/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/admin/instance/v1/spanner_instance_admin.proto

package com.google.spanner.admin.instance.v1;

/**
 *
 *
 * <pre>
 * An isolated set of Cloud Spanner resources on which databases can be hosted.
 * </pre>
 *
 * Protobuf type {@code google.spanner.admin.instance.v1.Instance}
 */
public final class Instance extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.admin.instance.v1.Instance)
    InstanceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Instance.newBuilder() to construct.
  private Instance(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Instance() {
    name_ = "";
    config_ = "";
    displayName_ = "";
    state_ = 0;
    endpointUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Instance();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
        .internal_static_google_spanner_admin_instance_v1_Instance_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 7:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
        .internal_static_google_spanner_admin_instance_v1_Instance_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.admin.instance.v1.Instance.class,
            com.google.spanner.admin.instance.v1.Instance.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Indicates the current state of the instance.
   * </pre>
   *
   * Protobuf enum {@code google.spanner.admin.instance.v1.Instance.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The instance is still being created. Resources may not be
     * available yet, and operations such as database creation may not
     * work.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    CREATING(1),
    /**
     *
     *
     * <pre>
     * The instance is fully created and ready to do work such as
     * creating databases.
     * </pre>
     *
     * <code>READY = 2;</code>
     */
    READY(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The instance is still being created. Resources may not be
     * available yet, and operations such as database creation may not
     * work.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    public static final int CREATING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The instance is fully created and ready to do work such as
     * creating databases.
     * </pre>
     *
     * <code>READY = 2;</code>
     */
    public static final int READY_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return CREATING;
        case 2:
          return READY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.spanner.admin.instance.v1.Instance.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.spanner.admin.instance.v1.Instance.State)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. A unique identifier for the instance, which cannot be changed
   * after the instance is created. Values are of the form
   * `projects/&lt;project&gt;/instances/[a-z][-a-z0-9]*[a-z0-9]`. The final
   * segment of the name must be between 2 and 64 characters in length.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. A unique identifier for the instance, which cannot be changed
   * after the instance is created. Values are of the form
   * `projects/&lt;project&gt;/instances/[a-z][-a-z0-9]*[a-z0-9]`. The final
   * segment of the name must be between 2 and 64 characters in length.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONFIG_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object config_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the instance's configuration. Values are of the form
   * `projects/&lt;project&gt;/instanceConfigs/&lt;configuration&gt;`. See
   * also [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig] and
   * [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs].
   * </pre>
   *
   * <code>
   * string config = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The config.
   */
  @java.lang.Override
  public java.lang.String getConfig() {
    java.lang.Object ref = config_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      config_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the instance's configuration. Values are of the form
   * `projects/&lt;project&gt;/instanceConfigs/&lt;configuration&gt;`. See
   * also [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig] and
   * [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs].
   * </pre>
   *
   * <code>
   * string config = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for config.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getConfigBytes() {
    java.lang.Object ref = config_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      config_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The descriptive name for this instance as it appears in UIs.
   * Must be unique per project and between 4 and 30 characters in length.
   * </pre>
   *
   * <code>string display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The descriptive name for this instance as it appears in UIs.
   * Must be unique per project and between 4 and 30 characters in length.
   * </pre>
   *
   * <code>string display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NODE_COUNT_FIELD_NUMBER = 5;
  private int nodeCount_ = 0;
  /**
   *
   *
   * <pre>
   * The number of nodes allocated to this instance. At most one of either
   * node_count or processing_units should be present in the message.
   *
   * Users can set the node_count field to specify the target number of nodes
   * allocated to the instance.
   *
   * This may be zero in API responses for instances that are not yet in state
   * `READY`.
   *
   * See [the
   * documentation](https://cloud.google.com/spanner/docs/compute-capacity)
   * for more information about nodes and processing units.
   * </pre>
   *
   * <code>int32 node_count = 5;</code>
   *
   * @return The nodeCount.
   */
  @java.lang.Override
  public int getNodeCount() {
    return nodeCount_;
  }

  public static final int PROCESSING_UNITS_FIELD_NUMBER = 9;
  private int processingUnits_ = 0;
  /**
   *
   *
   * <pre>
   * The number of processing units allocated to this instance. At most one of
   * processing_units or node_count should be present in the message.
   *
   * Users can set the processing_units field to specify the target number of
   * processing units allocated to the instance.
   *
   * This may be zero in API responses for instances that are not yet in state
   * `READY`.
   *
   * See [the
   * documentation](https://cloud.google.com/spanner/docs/compute-capacity)
   * for more information about nodes and processing units.
   * </pre>
   *
   * <code>int32 processing_units = 9;</code>
   *
   * @return The processingUnits.
   */
  @java.lang.Override
  public int getProcessingUnits() {
    return processingUnits_;
  }

  public static final int AUTOSCALING_CONFIG_FIELD_NUMBER = 17;
  private com.google.spanner.admin.instance.v1.AutoscalingConfig autoscalingConfig_;
  /**
   *
   *
   * <pre>
   * Optional. The autoscaling configuration. Autoscaling is enabled if this
   * field is set. When autoscaling is enabled, node_count and processing_units
   * are treated as OUTPUT_ONLY fields and reflect the current compute capacity
   * allocated to the instance.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.instance.v1.AutoscalingConfig autoscaling_config = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the autoscalingConfig field is set.
   */
  @java.lang.Override
  public boolean hasAutoscalingConfig() {
    return autoscalingConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The autoscaling configuration. Autoscaling is enabled if this
   * field is set. When autoscaling is enabled, node_count and processing_units
   * are treated as OUTPUT_ONLY fields and reflect the current compute capacity
   * allocated to the instance.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.instance.v1.AutoscalingConfig autoscaling_config = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The autoscalingConfig.
   */
  @java.lang.Override
  public com.google.spanner.admin.instance.v1.AutoscalingConfig getAutoscalingConfig() {
    return autoscalingConfig_ == null
        ? com.google.spanner.admin.instance.v1.AutoscalingConfig.getDefaultInstance()
        : autoscalingConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The autoscaling configuration. Autoscaling is enabled if this
   * field is set. When autoscaling is enabled, node_count and processing_units
   * are treated as OUTPUT_ONLY fields and reflect the current compute capacity
   * allocated to the instance.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.instance.v1.AutoscalingConfig autoscaling_config = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.admin.instance.v1.AutoscalingConfigOrBuilder
      getAutoscalingConfigOrBuilder() {
    return autoscalingConfig_ == null
        ? com.google.spanner.admin.instance.v1.AutoscalingConfig.getDefaultInstance()
        : autoscalingConfig_;
  }

  public static final int STATE_FIELD_NUMBER = 6;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The current instance state. For
   * [CreateInstance][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstance],
   * the state must be either omitted or set to `CREATING`. For
   * [UpdateInstance][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstance],
   * the state must be either omitted or set to `READY`.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.instance.v1.Instance.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current instance state. For
   * [CreateInstance][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstance],
   * the state must be either omitted or set to `CREATING`. For
   * [UpdateInstance][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstance],
   * the state must be either omitted or set to `READY`.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.instance.v1.Instance.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.spanner.admin.instance.v1.Instance.State getState() {
    com.google.spanner.admin.instance.v1.Instance.State result =
        com.google.spanner.admin.instance.v1.Instance.State.forNumber(state_);
    return result == null
        ? com.google.spanner.admin.instance.v1.Instance.State.UNRECOGNIZED
        : result;
  }

  public static final int LABELS_FIELD_NUMBER = 7;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
                .internal_static_google_spanner_admin_instance_v1_Instance_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Cloud Labels are a flexible and lightweight mechanism for organizing cloud
   * resources into groups that reflect a customer's organizational needs and
   * deployment strategies. Cloud Labels can be used to filter collections of
   * resources. They can be used to control how resource metrics are aggregated.
   * And they can be used as arguments to policy management rules (e.g. route,
   * firewall, load balancing, etc.).
   *
   *  * Label keys must be between 1 and 63 characters long and must conform to
   *    the following regular expression: `[a-z][a-z0-9_-]{0,62}`.
   *  * Label values must be between 0 and 63 characters long and must conform
   *    to the regular expression `[a-z0-9_-]{0,63}`.
   *  * No more than 64 labels can be associated with a given resource.
   *
   * See https://goo.gl/xmQnxf for more information on and examples of labels.
   *
   * If you plan to use labels in your own code, please note that additional
   * characters may be allowed in the future. And so you are advised to use an
   * internal label representation, such as JSON, which doesn't rely upon
   * specific characters being disallowed.  For example, representing labels
   * as the string:  name + "_" + value  would prove problematic if we were to
   * allow "_" in a future release.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Cloud Labels are a flexible and lightweight mechanism for organizing cloud
   * resources into groups that reflect a customer's organizational needs and
   * deployment strategies. Cloud Labels can be used to filter collections of
   * resources. They can be used to control how resource metrics are aggregated.
   * And they can be used as arguments to policy management rules (e.g. route,
   * firewall, load balancing, etc.).
   *
   *  * Label keys must be between 1 and 63 characters long and must conform to
   *    the following regular expression: `[a-z][a-z0-9_-]{0,62}`.
   *  * Label values must be between 0 and 63 characters long and must conform
   *    to the regular expression `[a-z0-9_-]{0,63}`.
   *  * No more than 64 labels can be associated with a given resource.
   *
   * See https://goo.gl/xmQnxf for more information on and examples of labels.
   *
   * If you plan to use labels in your own code, please note that additional
   * characters may be allowed in the future. And so you are advised to use an
   * internal label representation, such as JSON, which doesn't rely upon
   * specific characters being disallowed.  For example, representing labels
   * as the string:  name + "_" + value  would prove problematic if we were to
   * allow "_" in a future release.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Cloud Labels are a flexible and lightweight mechanism for organizing cloud
   * resources into groups that reflect a customer's organizational needs and
   * deployment strategies. Cloud Labels can be used to filter collections of
   * resources. They can be used to control how resource metrics are aggregated.
   * And they can be used as arguments to policy management rules (e.g. route,
   * firewall, load balancing, etc.).
   *
   *  * Label keys must be between 1 and 63 characters long and must conform to
   *    the following regular expression: `[a-z][a-z0-9_-]{0,62}`.
   *  * Label values must be between 0 and 63 characters long and must conform
   *    to the regular expression `[a-z0-9_-]{0,63}`.
   *  * No more than 64 labels can be associated with a given resource.
   *
   * See https://goo.gl/xmQnxf for more information on and examples of labels.
   *
   * If you plan to use labels in your own code, please note that additional
   * characters may be allowed in the future. And so you are advised to use an
   * internal label representation, such as JSON, which doesn't rely upon
   * specific characters being disallowed.  For example, representing labels
   * as the string:  name + "_" + value  would prove problematic if we were to
   * allow "_" in a future release.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Cloud Labels are a flexible and lightweight mechanism for organizing cloud
   * resources into groups that reflect a customer's organizational needs and
   * deployment strategies. Cloud Labels can be used to filter collections of
   * resources. They can be used to control how resource metrics are aggregated.
   * And they can be used as arguments to policy management rules (e.g. route,
   * firewall, load balancing, etc.).
   *
   *  * Label keys must be between 1 and 63 characters long and must conform to
   *    the following regular expression: `[a-z][a-z0-9_-]{0,62}`.
   *  * Label values must be between 0 and 63 characters long and must conform
   *    to the regular expression `[a-z0-9_-]{0,63}`.
   *  * No more than 64 labels can be associated with a given resource.
   *
   * See https://goo.gl/xmQnxf for more information on and examples of labels.
   *
   * If you plan to use labels in your own code, please note that additional
   * characters may be allowed in the future. And so you are advised to use an
   * internal label representation, such as JSON, which doesn't rely upon
   * specific characters being disallowed.  For example, representing labels
   * as the string:  name + "_" + value  would prove problematic if we were to
   * allow "_" in a future release.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ENDPOINT_URIS_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList endpointUris_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Deprecated. This field is not populated.
   * </pre>
   *
   * <code>repeated string endpoint_uris = 8;</code>
   *
   * @return A list containing the endpointUris.
   */
  public com.google.protobuf.ProtocolStringList getEndpointUrisList() {
    return endpointUris_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated. This field is not populated.
   * </pre>
   *
   * <code>repeated string endpoint_uris = 8;</code>
   *
   * @return The count of endpointUris.
   */
  public int getEndpointUrisCount() {
    return endpointUris_.size();
  }
  /**
   *
   *
   * <pre>
   * Deprecated. This field is not populated.
   * </pre>
   *
   * <code>repeated string endpoint_uris = 8;</code>
   *
   * @param index The index of the element to return.
   * @return The endpointUris at the given index.
   */
  public java.lang.String getEndpointUris(int index) {
    return endpointUris_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Deprecated. This field is not populated.
   * </pre>
   *
   * <code>repeated string endpoint_uris = 8;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the endpointUris at the given index.
   */
  public com.google.protobuf.ByteString getEndpointUrisBytes(int index) {
    return endpointUris_.getByteString(index);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 11;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time at which the instance was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the instance was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the instance was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 12;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time at which the instance was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the instance was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the instance was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(config_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, config_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, displayName_);
    }
    if (nodeCount_ != 0) {
      output.writeInt32(5, nodeCount_);
    }
    if (state_
        != com.google.spanner.admin.instance.v1.Instance.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(6, state_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 7);
    for (int i = 0; i < endpointUris_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, endpointUris_.getRaw(i));
    }
    if (processingUnits_ != 0) {
      output.writeInt32(9, processingUnits_);
    }
    if (createTime_ != null) {
      output.writeMessage(11, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(12, getUpdateTime());
    }
    if (autoscalingConfig_ != null) {
      output.writeMessage(17, getAutoscalingConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(config_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, config_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, displayName_);
    }
    if (nodeCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, nodeCount_);
    }
    if (state_
        != com.google.spanner.admin.instance.v1.Instance.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, state_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, labels__);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < endpointUris_.size(); i++) {
        dataSize += computeStringSizeNoTag(endpointUris_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getEndpointUrisList().size();
    }
    if (processingUnits_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(9, processingUnits_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getUpdateTime());
    }
    if (autoscalingConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, getAutoscalingConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.admin.instance.v1.Instance)) {
      return super.equals(obj);
    }
    com.google.spanner.admin.instance.v1.Instance other =
        (com.google.spanner.admin.instance.v1.Instance) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getConfig().equals(other.getConfig())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (getNodeCount() != other.getNodeCount()) return false;
    if (getProcessingUnits() != other.getProcessingUnits()) return false;
    if (hasAutoscalingConfig() != other.hasAutoscalingConfig()) return false;
    if (hasAutoscalingConfig()) {
      if (!getAutoscalingConfig().equals(other.getAutoscalingConfig())) return false;
    }
    if (state_ != other.state_) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getEndpointUrisList().equals(other.getEndpointUrisList())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + CONFIG_FIELD_NUMBER;
    hash = (53 * hash) + getConfig().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + NODE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getNodeCount();
    hash = (37 * hash) + PROCESSING_UNITS_FIELD_NUMBER;
    hash = (53 * hash) + getProcessingUnits();
    if (hasAutoscalingConfig()) {
      hash = (37 * hash) + AUTOSCALING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getAutoscalingConfig().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (getEndpointUrisCount() > 0) {
      hash = (37 * hash) + ENDPOINT_URIS_FIELD_NUMBER;
      hash = (53 * hash) + getEndpointUrisList().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.admin.instance.v1.Instance parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.instance.v1.Instance parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.Instance parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.instance.v1.Instance parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.Instance parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.instance.v1.Instance parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.Instance parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.instance.v1.Instance parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.Instance parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.instance.v1.Instance parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.Instance parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.instance.v1.Instance parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.admin.instance.v1.Instance prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An isolated set of Cloud Spanner resources on which databases can be hosted.
   * </pre>
   *
   * Protobuf type {@code google.spanner.admin.instance.v1.Instance}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.admin.instance.v1.Instance)
      com.google.spanner.admin.instance.v1.InstanceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
          .internal_static_google_spanner_admin_instance_v1_Instance_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 7:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 7:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
          .internal_static_google_spanner_admin_instance_v1_Instance_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.admin.instance.v1.Instance.class,
              com.google.spanner.admin.instance.v1.Instance.Builder.class);
    }

    // Construct using com.google.spanner.admin.instance.v1.Instance.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      config_ = "";
      displayName_ = "";
      nodeCount_ = 0;
      processingUnits_ = 0;
      autoscalingConfig_ = null;
      if (autoscalingConfigBuilder_ != null) {
        autoscalingConfigBuilder_.dispose();
        autoscalingConfigBuilder_ = null;
      }
      state_ = 0;
      internalGetMutableLabels().clear();
      endpointUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
          .internal_static_google_spanner_admin_instance_v1_Instance_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.admin.instance.v1.Instance getDefaultInstanceForType() {
      return com.google.spanner.admin.instance.v1.Instance.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.admin.instance.v1.Instance build() {
      com.google.spanner.admin.instance.v1.Instance result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.admin.instance.v1.Instance buildPartial() {
      com.google.spanner.admin.instance.v1.Instance result =
          new com.google.spanner.admin.instance.v1.Instance(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.admin.instance.v1.Instance result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.config_ = config_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.nodeCount_ = nodeCount_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.processingUnits_ = processingUnits_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.autoscalingConfig_ =
            autoscalingConfigBuilder_ == null
                ? autoscalingConfig_
                : autoscalingConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        endpointUris_.makeImmutable();
        result.endpointUris_ = endpointUris_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.admin.instance.v1.Instance) {
        return mergeFrom((com.google.spanner.admin.instance.v1.Instance) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.admin.instance.v1.Instance other) {
      if (other == com.google.spanner.admin.instance.v1.Instance.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getConfig().isEmpty()) {
        config_ = other.config_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.getNodeCount() != 0) {
        setNodeCount(other.getNodeCount());
      }
      if (other.getProcessingUnits() != 0) {
        setProcessingUnits(other.getProcessingUnits());
      }
      if (other.hasAutoscalingConfig()) {
        mergeAutoscalingConfig(other.getAutoscalingConfig());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000080;
      if (!other.endpointUris_.isEmpty()) {
        if (endpointUris_.isEmpty()) {
          endpointUris_ = other.endpointUris_;
          bitField0_ |= 0x00000100;
        } else {
          ensureEndpointUrisIsMutable();
          endpointUris_.addAll(other.endpointUris_);
        }
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                config_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 40:
              {
                nodeCount_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 40
            case 48:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 48
            case 58:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 66:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureEndpointUrisIsMutable();
                endpointUris_.add(s);
                break;
              } // case 66
            case 72:
              {
                processingUnits_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 72
            case 90:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 98
            case 138:
              {
                input.readMessage(
                    getAutoscalingConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 138
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. A unique identifier for the instance, which cannot be changed
     * after the instance is created. Values are of the form
     * `projects/&lt;project&gt;/instances/[a-z][-a-z0-9]*[a-z0-9]`. The final
     * segment of the name must be between 2 and 64 characters in length.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A unique identifier for the instance, which cannot be changed
     * after the instance is created. Values are of the form
     * `projects/&lt;project&gt;/instances/[a-z][-a-z0-9]*[a-z0-9]`. The final
     * segment of the name must be between 2 and 64 characters in length.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A unique identifier for the instance, which cannot be changed
     * after the instance is created. Values are of the form
     * `projects/&lt;project&gt;/instances/[a-z][-a-z0-9]*[a-z0-9]`. The final
     * segment of the name must be between 2 and 64 characters in length.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A unique identifier for the instance, which cannot be changed
     * after the instance is created. Values are of the form
     * `projects/&lt;project&gt;/instances/[a-z][-a-z0-9]*[a-z0-9]`. The final
     * segment of the name must be between 2 and 64 characters in length.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A unique identifier for the instance, which cannot be changed
     * after the instance is created. Values are of the form
     * `projects/&lt;project&gt;/instances/[a-z][-a-z0-9]*[a-z0-9]`. The final
     * segment of the name must be between 2 and 64 characters in length.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object config_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the instance's configuration. Values are of the form
     * `projects/&lt;project&gt;/instanceConfigs/&lt;configuration&gt;`. See
     * also [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig] and
     * [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs].
     * </pre>
     *
     * <code>
     * string config = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The config.
     */
    public java.lang.String getConfig() {
      java.lang.Object ref = config_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        config_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the instance's configuration. Values are of the form
     * `projects/&lt;project&gt;/instanceConfigs/&lt;configuration&gt;`. See
     * also [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig] and
     * [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs].
     * </pre>
     *
     * <code>
     * string config = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for config.
     */
    public com.google.protobuf.ByteString getConfigBytes() {
      java.lang.Object ref = config_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        config_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the instance's configuration. Values are of the form
     * `projects/&lt;project&gt;/instanceConfigs/&lt;configuration&gt;`. See
     * also [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig] and
     * [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs].
     * </pre>
     *
     * <code>
     * string config = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The config to set.
     * @return This builder for chaining.
     */
    public Builder setConfig(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      config_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the instance's configuration. Values are of the form
     * `projects/&lt;project&gt;/instanceConfigs/&lt;configuration&gt;`. See
     * also [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig] and
     * [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs].
     * </pre>
     *
     * <code>
     * string config = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConfig() {
      config_ = getDefaultInstance().getConfig();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the instance's configuration. Values are of the form
     * `projects/&lt;project&gt;/instanceConfigs/&lt;configuration&gt;`. See
     * also [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig] and
     * [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs].
     * </pre>
     *
     * <code>
     * string config = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for config to set.
     * @return This builder for chaining.
     */
    public Builder setConfigBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      config_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The descriptive name for this instance as it appears in UIs.
     * Must be unique per project and between 4 and 30 characters in length.
     * </pre>
     *
     * <code>string display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The descriptive name for this instance as it appears in UIs.
     * Must be unique per project and between 4 and 30 characters in length.
     * </pre>
     *
     * <code>string display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The descriptive name for this instance as it appears in UIs.
     * Must be unique per project and between 4 and 30 characters in length.
     * </pre>
     *
     * <code>string display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The descriptive name for this instance as it appears in UIs.
     * Must be unique per project and between 4 and 30 characters in length.
     * </pre>
     *
     * <code>string display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The descriptive name for this instance as it appears in UIs.
     * Must be unique per project and between 4 and 30 characters in length.
     * </pre>
     *
     * <code>string display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int nodeCount_;
    /**
     *
     *
     * <pre>
     * The number of nodes allocated to this instance. At most one of either
     * node_count or processing_units should be present in the message.
     *
     * Users can set the node_count field to specify the target number of nodes
     * allocated to the instance.
     *
     * This may be zero in API responses for instances that are not yet in state
     * `READY`.
     *
     * See [the
     * documentation](https://cloud.google.com/spanner/docs/compute-capacity)
     * for more information about nodes and processing units.
     * </pre>
     *
     * <code>int32 node_count = 5;</code>
     *
     * @return The nodeCount.
     */
    @java.lang.Override
    public int getNodeCount() {
      return nodeCount_;
    }
    /**
     *
     *
     * <pre>
     * The number of nodes allocated to this instance. At most one of either
     * node_count or processing_units should be present in the message.
     *
     * Users can set the node_count field to specify the target number of nodes
     * allocated to the instance.
     *
     * This may be zero in API responses for instances that are not yet in state
     * `READY`.
     *
     * See [the
     * documentation](https://cloud.google.com/spanner/docs/compute-capacity)
     * for more information about nodes and processing units.
     * </pre>
     *
     * <code>int32 node_count = 5;</code>
     *
     * @param value The nodeCount to set.
     * @return This builder for chaining.
     */
    public Builder setNodeCount(int value) {

      nodeCount_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of nodes allocated to this instance. At most one of either
     * node_count or processing_units should be present in the message.
     *
     * Users can set the node_count field to specify the target number of nodes
     * allocated to the instance.
     *
     * This may be zero in API responses for instances that are not yet in state
     * `READY`.
     *
     * See [the
     * documentation](https://cloud.google.com/spanner/docs/compute-capacity)
     * for more information about nodes and processing units.
     * </pre>
     *
     * <code>int32 node_count = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNodeCount() {
      bitField0_ = (bitField0_ & ~0x00000008);
      nodeCount_ = 0;
      onChanged();
      return this;
    }

    private int processingUnits_;
    /**
     *
     *
     * <pre>
     * The number of processing units allocated to this instance. At most one of
     * processing_units or node_count should be present in the message.
     *
     * Users can set the processing_units field to specify the target number of
     * processing units allocated to the instance.
     *
     * This may be zero in API responses for instances that are not yet in state
     * `READY`.
     *
     * See [the
     * documentation](https://cloud.google.com/spanner/docs/compute-capacity)
     * for more information about nodes and processing units.
     * </pre>
     *
     * <code>int32 processing_units = 9;</code>
     *
     * @return The processingUnits.
     */
    @java.lang.Override
    public int getProcessingUnits() {
      return processingUnits_;
    }
    /**
     *
     *
     * <pre>
     * The number of processing units allocated to this instance. At most one of
     * processing_units or node_count should be present in the message.
     *
     * Users can set the processing_units field to specify the target number of
     * processing units allocated to the instance.
     *
     * This may be zero in API responses for instances that are not yet in state
     * `READY`.
     *
     * See [the
     * documentation](https://cloud.google.com/spanner/docs/compute-capacity)
     * for more information about nodes and processing units.
     * </pre>
     *
     * <code>int32 processing_units = 9;</code>
     *
     * @param value The processingUnits to set.
     * @return This builder for chaining.
     */
    public Builder setProcessingUnits(int value) {

      processingUnits_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of processing units allocated to this instance. At most one of
     * processing_units or node_count should be present in the message.
     *
     * Users can set the processing_units field to specify the target number of
     * processing units allocated to the instance.
     *
     * This may be zero in API responses for instances that are not yet in state
     * `READY`.
     *
     * See [the
     * documentation](https://cloud.google.com/spanner/docs/compute-capacity)
     * for more information about nodes and processing units.
     * </pre>
     *
     * <code>int32 processing_units = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProcessingUnits() {
      bitField0_ = (bitField0_ & ~0x00000010);
      processingUnits_ = 0;
      onChanged();
      return this;
    }

    private com.google.spanner.admin.instance.v1.AutoscalingConfig autoscalingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.instance.v1.AutoscalingConfig,
            com.google.spanner.admin.instance.v1.AutoscalingConfig.Builder,
            com.google.spanner.admin.instance.v1.AutoscalingConfigOrBuilder>
        autoscalingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The autoscaling configuration. Autoscaling is enabled if this
     * field is set. When autoscaling is enabled, node_count and processing_units
     * are treated as OUTPUT_ONLY fields and reflect the current compute capacity
     * allocated to the instance.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.AutoscalingConfig autoscaling_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the autoscalingConfig field is set.
     */
    public boolean hasAutoscalingConfig() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The autoscaling configuration. Autoscaling is enabled if this
     * field is set. When autoscaling is enabled, node_count and processing_units
     * are treated as OUTPUT_ONLY fields and reflect the current compute capacity
     * allocated to the instance.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.AutoscalingConfig autoscaling_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The autoscalingConfig.
     */
    public com.google.spanner.admin.instance.v1.AutoscalingConfig getAutoscalingConfig() {
      if (autoscalingConfigBuilder_ == null) {
        return autoscalingConfig_ == null
            ? com.google.spanner.admin.instance.v1.AutoscalingConfig.getDefaultInstance()
            : autoscalingConfig_;
      } else {
        return autoscalingConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The autoscaling configuration. Autoscaling is enabled if this
     * field is set. When autoscaling is enabled, node_count and processing_units
     * are treated as OUTPUT_ONLY fields and reflect the current compute capacity
     * allocated to the instance.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.AutoscalingConfig autoscaling_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAutoscalingConfig(
        com.google.spanner.admin.instance.v1.AutoscalingConfig value) {
      if (autoscalingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        autoscalingConfig_ = value;
      } else {
        autoscalingConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The autoscaling configuration. Autoscaling is enabled if this
     * field is set. When autoscaling is enabled, node_count and processing_units
     * are treated as OUTPUT_ONLY fields and reflect the current compute capacity
     * allocated to the instance.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.AutoscalingConfig autoscaling_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAutoscalingConfig(
        com.google.spanner.admin.instance.v1.AutoscalingConfig.Builder builderForValue) {
      if (autoscalingConfigBuilder_ == null) {
        autoscalingConfig_ = builderForValue.build();
      } else {
        autoscalingConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The autoscaling configuration. Autoscaling is enabled if this
     * field is set. When autoscaling is enabled, node_count and processing_units
     * are treated as OUTPUT_ONLY fields and reflect the current compute capacity
     * allocated to the instance.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.AutoscalingConfig autoscaling_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAutoscalingConfig(
        com.google.spanner.admin.instance.v1.AutoscalingConfig value) {
      if (autoscalingConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && autoscalingConfig_ != null
            && autoscalingConfig_
                != com.google.spanner.admin.instance.v1.AutoscalingConfig.getDefaultInstance()) {
          getAutoscalingConfigBuilder().mergeFrom(value);
        } else {
          autoscalingConfig_ = value;
        }
      } else {
        autoscalingConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The autoscaling configuration. Autoscaling is enabled if this
     * field is set. When autoscaling is enabled, node_count and processing_units
     * are treated as OUTPUT_ONLY fields and reflect the current compute capacity
     * allocated to the instance.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.AutoscalingConfig autoscaling_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAutoscalingConfig() {
      bitField0_ = (bitField0_ & ~0x00000020);
      autoscalingConfig_ = null;
      if (autoscalingConfigBuilder_ != null) {
        autoscalingConfigBuilder_.dispose();
        autoscalingConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The autoscaling configuration. Autoscaling is enabled if this
     * field is set. When autoscaling is enabled, node_count and processing_units
     * are treated as OUTPUT_ONLY fields and reflect the current compute capacity
     * allocated to the instance.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.AutoscalingConfig autoscaling_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.spanner.admin.instance.v1.AutoscalingConfig.Builder
        getAutoscalingConfigBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getAutoscalingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The autoscaling configuration. Autoscaling is enabled if this
     * field is set. When autoscaling is enabled, node_count and processing_units
     * are treated as OUTPUT_ONLY fields and reflect the current compute capacity
     * allocated to the instance.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.AutoscalingConfig autoscaling_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.spanner.admin.instance.v1.AutoscalingConfigOrBuilder
        getAutoscalingConfigOrBuilder() {
      if (autoscalingConfigBuilder_ != null) {
        return autoscalingConfigBuilder_.getMessageOrBuilder();
      } else {
        return autoscalingConfig_ == null
            ? com.google.spanner.admin.instance.v1.AutoscalingConfig.getDefaultInstance()
            : autoscalingConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The autoscaling configuration. Autoscaling is enabled if this
     * field is set. When autoscaling is enabled, node_count and processing_units
     * are treated as OUTPUT_ONLY fields and reflect the current compute capacity
     * allocated to the instance.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.AutoscalingConfig autoscaling_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.instance.v1.AutoscalingConfig,
            com.google.spanner.admin.instance.v1.AutoscalingConfig.Builder,
            com.google.spanner.admin.instance.v1.AutoscalingConfigOrBuilder>
        getAutoscalingConfigFieldBuilder() {
      if (autoscalingConfigBuilder_ == null) {
        autoscalingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.admin.instance.v1.AutoscalingConfig,
                com.google.spanner.admin.instance.v1.AutoscalingConfig.Builder,
                com.google.spanner.admin.instance.v1.AutoscalingConfigOrBuilder>(
                getAutoscalingConfig(), getParentForChildren(), isClean());
        autoscalingConfig_ = null;
      }
      return autoscalingConfigBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current instance state. For
     * [CreateInstance][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstance],
     * the state must be either omitted or set to `CREATING`. For
     * [UpdateInstance][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstance],
     * the state must be either omitted or set to `READY`.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.Instance.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current instance state. For
     * [CreateInstance][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstance],
     * the state must be either omitted or set to `CREATING`. For
     * [UpdateInstance][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstance],
     * the state must be either omitted or set to `READY`.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.Instance.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current instance state. For
     * [CreateInstance][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstance],
     * the state must be either omitted or set to `CREATING`. For
     * [UpdateInstance][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstance],
     * the state must be either omitted or set to `READY`.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.Instance.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.spanner.admin.instance.v1.Instance.State getState() {
      com.google.spanner.admin.instance.v1.Instance.State result =
          com.google.spanner.admin.instance.v1.Instance.State.forNumber(state_);
      return result == null
          ? com.google.spanner.admin.instance.v1.Instance.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current instance state. For
     * [CreateInstance][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstance],
     * the state must be either omitted or set to `CREATING`. For
     * [UpdateInstance][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstance],
     * the state must be either omitted or set to `READY`.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.Instance.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.spanner.admin.instance.v1.Instance.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current instance state. For
     * [CreateInstance][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstance],
     * the state must be either omitted or set to `CREATING`. For
     * [UpdateInstance][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstance],
     * the state must be either omitted or set to `READY`.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.Instance.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000040);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Cloud Labels are a flexible and lightweight mechanism for organizing cloud
     * resources into groups that reflect a customer's organizational needs and
     * deployment strategies. Cloud Labels can be used to filter collections of
     * resources. They can be used to control how resource metrics are aggregated.
     * And they can be used as arguments to policy management rules (e.g. route,
     * firewall, load balancing, etc.).
     *
     *  * Label keys must be between 1 and 63 characters long and must conform to
     *    the following regular expression: `[a-z][a-z0-9_-]{0,62}`.
     *  * Label values must be between 0 and 63 characters long and must conform
     *    to the regular expression `[a-z0-9_-]{0,63}`.
     *  * No more than 64 labels can be associated with a given resource.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     *
     * If you plan to use labels in your own code, please note that additional
     * characters may be allowed in the future. And so you are advised to use an
     * internal label representation, such as JSON, which doesn't rely upon
     * specific characters being disallowed.  For example, representing labels
     * as the string:  name + "_" + value  would prove problematic if we were to
     * allow "_" in a future release.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Cloud Labels are a flexible and lightweight mechanism for organizing cloud
     * resources into groups that reflect a customer's organizational needs and
     * deployment strategies. Cloud Labels can be used to filter collections of
     * resources. They can be used to control how resource metrics are aggregated.
     * And they can be used as arguments to policy management rules (e.g. route,
     * firewall, load balancing, etc.).
     *
     *  * Label keys must be between 1 and 63 characters long and must conform to
     *    the following regular expression: `[a-z][a-z0-9_-]{0,62}`.
     *  * Label values must be between 0 and 63 characters long and must conform
     *    to the regular expression `[a-z0-9_-]{0,63}`.
     *  * No more than 64 labels can be associated with a given resource.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     *
     * If you plan to use labels in your own code, please note that additional
     * characters may be allowed in the future. And so you are advised to use an
     * internal label representation, such as JSON, which doesn't rely upon
     * specific characters being disallowed.  For example, representing labels
     * as the string:  name + "_" + value  would prove problematic if we were to
     * allow "_" in a future release.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Cloud Labels are a flexible and lightweight mechanism for organizing cloud
     * resources into groups that reflect a customer's organizational needs and
     * deployment strategies. Cloud Labels can be used to filter collections of
     * resources. They can be used to control how resource metrics are aggregated.
     * And they can be used as arguments to policy management rules (e.g. route,
     * firewall, load balancing, etc.).
     *
     *  * Label keys must be between 1 and 63 characters long and must conform to
     *    the following regular expression: `[a-z][a-z0-9_-]{0,62}`.
     *  * Label values must be between 0 and 63 characters long and must conform
     *    to the regular expression `[a-z0-9_-]{0,63}`.
     *  * No more than 64 labels can be associated with a given resource.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     *
     * If you plan to use labels in your own code, please note that additional
     * characters may be allowed in the future. And so you are advised to use an
     * internal label representation, such as JSON, which doesn't rely upon
     * specific characters being disallowed.  For example, representing labels
     * as the string:  name + "_" + value  would prove problematic if we were to
     * allow "_" in a future release.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Cloud Labels are a flexible and lightweight mechanism for organizing cloud
     * resources into groups that reflect a customer's organizational needs and
     * deployment strategies. Cloud Labels can be used to filter collections of
     * resources. They can be used to control how resource metrics are aggregated.
     * And they can be used as arguments to policy management rules (e.g. route,
     * firewall, load balancing, etc.).
     *
     *  * Label keys must be between 1 and 63 characters long and must conform to
     *    the following regular expression: `[a-z][a-z0-9_-]{0,62}`.
     *  * Label values must be between 0 and 63 characters long and must conform
     *    to the regular expression `[a-z0-9_-]{0,63}`.
     *  * No more than 64 labels can be associated with a given resource.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     *
     * If you plan to use labels in your own code, please note that additional
     * characters may be allowed in the future. And so you are advised to use an
     * internal label representation, such as JSON, which doesn't rely upon
     * specific characters being disallowed.  For example, representing labels
     * as the string:  name + "_" + value  would prove problematic if we were to
     * allow "_" in a future release.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000080);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Labels are a flexible and lightweight mechanism for organizing cloud
     * resources into groups that reflect a customer's organizational needs and
     * deployment strategies. Cloud Labels can be used to filter collections of
     * resources. They can be used to control how resource metrics are aggregated.
     * And they can be used as arguments to policy management rules (e.g. route,
     * firewall, load balancing, etc.).
     *
     *  * Label keys must be between 1 and 63 characters long and must conform to
     *    the following regular expression: `[a-z][a-z0-9_-]{0,62}`.
     *  * Label values must be between 0 and 63 characters long and must conform
     *    to the regular expression `[a-z0-9_-]{0,63}`.
     *  * No more than 64 labels can be associated with a given resource.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     *
     * If you plan to use labels in your own code, please note that additional
     * characters may be allowed in the future. And so you are advised to use an
     * internal label representation, such as JSON, which doesn't rely upon
     * specific characters being disallowed.  For example, representing labels
     * as the string:  name + "_" + value  would prove problematic if we were to
     * allow "_" in a future release.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000080;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Cloud Labels are a flexible and lightweight mechanism for organizing cloud
     * resources into groups that reflect a customer's organizational needs and
     * deployment strategies. Cloud Labels can be used to filter collections of
     * resources. They can be used to control how resource metrics are aggregated.
     * And they can be used as arguments to policy management rules (e.g. route,
     * firewall, load balancing, etc.).
     *
     *  * Label keys must be between 1 and 63 characters long and must conform to
     *    the following regular expression: `[a-z][a-z0-9_-]{0,62}`.
     *  * Label values must be between 0 and 63 characters long and must conform
     *    to the regular expression `[a-z0-9_-]{0,63}`.
     *  * No more than 64 labels can be associated with a given resource.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     *
     * If you plan to use labels in your own code, please note that additional
     * characters may be allowed in the future. And so you are advised to use an
     * internal label representation, such as JSON, which doesn't rely upon
     * specific characters being disallowed.  For example, representing labels
     * as the string:  name + "_" + value  would prove problematic if we were to
     * allow "_" in a future release.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000080;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Labels are a flexible and lightweight mechanism for organizing cloud
     * resources into groups that reflect a customer's organizational needs and
     * deployment strategies. Cloud Labels can be used to filter collections of
     * resources. They can be used to control how resource metrics are aggregated.
     * And they can be used as arguments to policy management rules (e.g. route,
     * firewall, load balancing, etc.).
     *
     *  * Label keys must be between 1 and 63 characters long and must conform to
     *    the following regular expression: `[a-z][a-z0-9_-]{0,62}`.
     *  * Label values must be between 0 and 63 characters long and must conform
     *    to the regular expression `[a-z0-9_-]{0,63}`.
     *  * No more than 64 labels can be associated with a given resource.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     *
     * If you plan to use labels in your own code, please note that additional
     * characters may be allowed in the future. And so you are advised to use an
     * internal label representation, such as JSON, which doesn't rely upon
     * specific characters being disallowed.  For example, representing labels
     * as the string:  name + "_" + value  would prove problematic if we were to
     * allow "_" in a future release.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000080;
      return this;
    }

    private com.google.protobuf.LazyStringArrayList endpointUris_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureEndpointUrisIsMutable() {
      if (!endpointUris_.isModifiable()) {
        endpointUris_ = new com.google.protobuf.LazyStringArrayList(endpointUris_);
      }
      bitField0_ |= 0x00000100;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field is not populated.
     * </pre>
     *
     * <code>repeated string endpoint_uris = 8;</code>
     *
     * @return A list containing the endpointUris.
     */
    public com.google.protobuf.ProtocolStringList getEndpointUrisList() {
      endpointUris_.makeImmutable();
      return endpointUris_;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field is not populated.
     * </pre>
     *
     * <code>repeated string endpoint_uris = 8;</code>
     *
     * @return The count of endpointUris.
     */
    public int getEndpointUrisCount() {
      return endpointUris_.size();
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field is not populated.
     * </pre>
     *
     * <code>repeated string endpoint_uris = 8;</code>
     *
     * @param index The index of the element to return.
     * @return The endpointUris at the given index.
     */
    public java.lang.String getEndpointUris(int index) {
      return endpointUris_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field is not populated.
     * </pre>
     *
     * <code>repeated string endpoint_uris = 8;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the endpointUris at the given index.
     */
    public com.google.protobuf.ByteString getEndpointUrisBytes(int index) {
      return endpointUris_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field is not populated.
     * </pre>
     *
     * <code>repeated string endpoint_uris = 8;</code>
     *
     * @param index The index to set the value at.
     * @param value The endpointUris to set.
     * @return This builder for chaining.
     */
    public Builder setEndpointUris(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEndpointUrisIsMutable();
      endpointUris_.set(index, value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field is not populated.
     * </pre>
     *
     * <code>repeated string endpoint_uris = 8;</code>
     *
     * @param value The endpointUris to add.
     * @return This builder for chaining.
     */
    public Builder addEndpointUris(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEndpointUrisIsMutable();
      endpointUris_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field is not populated.
     * </pre>
     *
     * <code>repeated string endpoint_uris = 8;</code>
     *
     * @param values The endpointUris to add.
     * @return This builder for chaining.
     */
    public Builder addAllEndpointUris(java.lang.Iterable<java.lang.String> values) {
      ensureEndpointUrisIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, endpointUris_);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field is not populated.
     * </pre>
     *
     * <code>repeated string endpoint_uris = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEndpointUris() {
      endpointUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000100);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field is not populated.
     * </pre>
     *
     * <code>repeated string endpoint_uris = 8;</code>
     *
     * @param value The bytes of the endpointUris to add.
     * @return This builder for chaining.
     */
    public Builder addEndpointUrisBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureEndpointUrisIsMutable();
      endpointUris_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000200);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000400);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.admin.instance.v1.Instance)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.admin.instance.v1.Instance)
  private static final com.google.spanner.admin.instance.v1.Instance DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.admin.instance.v1.Instance();
  }

  public static com.google.spanner.admin.instance.v1.Instance getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Instance> PARSER =
      new com.google.protobuf.AbstractParser<Instance>() {
        @java.lang.Override
        public Instance parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Instance> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Instance> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.admin.instance.v1.Instance getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
