/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/admin/instance/v1/spanner_instance_admin.proto

// Protobuf Java Version: 3.25.2
package com.google.spanner.admin.instance.v1;

/**
 *
 *
 * <pre>
 * The request for
 * [ListInstancePartitionOperations][google.spanner.admin.instance.v1.InstanceAdmin.ListInstancePartitionOperations].
 * </pre>
 *
 * Protobuf type {@code google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest}
 */
public final class ListInstancePartitionOperationsRequest
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest)
    ListInstancePartitionOperationsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListInstancePartitionOperationsRequest.newBuilder() to construct.
  private ListInstancePartitionOperationsRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListInstancePartitionOperationsRequest() {
    parent_ = "";
    filter_ = "";
    pageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListInstancePartitionOperationsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
        .internal_static_google_spanner_admin_instance_v1_ListInstancePartitionOperationsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
        .internal_static_google_spanner_admin_instance_v1_ListInstancePartitionOperationsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest.class,
            com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest.Builder
                .class);
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The parent instance of the instance partition operations.
   * Values are of the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The parent instance of the instance partition operations.
   * Values are of the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FILTER_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filter_ = "";
  /**
   *
   *
   * <pre>
   * Optional. An expression that filters the list of returned operations.
   *
   * A filter expression consists of a field name, a
   * comparison operator, and a value for filtering.
   * The value must be a string, a number, or a boolean. The comparison operator
   * must be one of: `&lt;`, `&gt;`, `&lt;=`, `&gt;=`, `!=`, `=`, or `:`.
   * Colon `:` is the contains operator. Filter rules are not case sensitive.
   *
   * The following fields in the [Operation][google.longrunning.Operation]
   * are eligible for filtering:
   *
   *   * `name` - The name of the long-running operation
   *   * `done` - False if the operation is in progress, else true.
   *   * `metadata.&#64;type` - the type of metadata. For example, the type string
   *      for
   *      [CreateInstancePartitionMetadata][google.spanner.admin.instance.v1.CreateInstancePartitionMetadata]
   *      is
   *      `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstancePartitionMetadata`.
   *   * `metadata.&lt;field_name&gt;` - any field in metadata.value.
   *      `metadata.&#64;type` must be specified first, if filtering on metadata
   *      fields.
   *   * `error` - Error associated with the long-running operation.
   *   * `response.&#64;type` - the type of response.
   *   * `response.&lt;field_name&gt;` - any field in response.value.
   *
   * You can combine multiple expressions by enclosing each expression in
   * parentheses. By default, expressions are combined with AND logic. However,
   * you can specify AND, OR, and NOT logic explicitly.
   *
   * Here are a few examples:
   *
   *   * `done:true` - The operation is complete.
   *   * `(metadata.&#64;type=` &#92;
   *     `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstancePartitionMetadata)
   *     AND` &#92;
   *     `(metadata.instance_partition.name:custom-instance-partition) AND` &#92;
   *     `(metadata.start_time &lt; &#92;"2021-03-28T14:50:00Z&#92;") AND` &#92;
   *     `(error:*)` - Return operations where:
   *     * The operation's metadata type is
   *     [CreateInstancePartitionMetadata][google.spanner.admin.instance.v1.CreateInstancePartitionMetadata].
   *     * The instance partition name contains "custom-instance-partition".
   *     * The operation started before 2021-03-28T14:50:00Z.
   *     * The operation resulted in an error.
   * </pre>
   *
   * <code>string filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. An expression that filters the list of returned operations.
   *
   * A filter expression consists of a field name, a
   * comparison operator, and a value for filtering.
   * The value must be a string, a number, or a boolean. The comparison operator
   * must be one of: `&lt;`, `&gt;`, `&lt;=`, `&gt;=`, `!=`, `=`, or `:`.
   * Colon `:` is the contains operator. Filter rules are not case sensitive.
   *
   * The following fields in the [Operation][google.longrunning.Operation]
   * are eligible for filtering:
   *
   *   * `name` - The name of the long-running operation
   *   * `done` - False if the operation is in progress, else true.
   *   * `metadata.&#64;type` - the type of metadata. For example, the type string
   *      for
   *      [CreateInstancePartitionMetadata][google.spanner.admin.instance.v1.CreateInstancePartitionMetadata]
   *      is
   *      `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstancePartitionMetadata`.
   *   * `metadata.&lt;field_name&gt;` - any field in metadata.value.
   *      `metadata.&#64;type` must be specified first, if filtering on metadata
   *      fields.
   *   * `error` - Error associated with the long-running operation.
   *   * `response.&#64;type` - the type of response.
   *   * `response.&lt;field_name&gt;` - any field in response.value.
   *
   * You can combine multiple expressions by enclosing each expression in
   * parentheses. By default, expressions are combined with AND logic. However,
   * you can specify AND, OR, and NOT logic explicitly.
   *
   * Here are a few examples:
   *
   *   * `done:true` - The operation is complete.
   *   * `(metadata.&#64;type=` &#92;
   *     `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstancePartitionMetadata)
   *     AND` &#92;
   *     `(metadata.instance_partition.name:custom-instance-partition) AND` &#92;
   *     `(metadata.start_time &lt; &#92;"2021-03-28T14:50:00Z&#92;") AND` &#92;
   *     `(error:*)` - Return operations where:
   *     * The operation's metadata type is
   *     [CreateInstancePartitionMetadata][google.spanner.admin.instance.v1.CreateInstancePartitionMetadata].
   *     * The instance partition name contains "custom-instance-partition".
   *     * The operation started before 2021-03-28T14:50:00Z.
   *     * The operation resulted in an error.
   * </pre>
   *
   * <code>string filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 3;
  private int pageSize_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Number of operations to be returned in the response. If 0 or
   * less, defaults to the server's maximum allowed page size.
   * </pre>
   *
   * <code>int32 page_size = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pageSize.
   */
  @java.lang.Override
  public int getPageSize() {
    return pageSize_;
  }

  public static final int PAGE_TOKEN_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pageToken_ = "";
  /**
   *
   *
   * <pre>
   * Optional. If non-empty, `page_token` should contain a
   * [next_page_token][google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse.next_page_token]
   * from a previous
   * [ListInstancePartitionOperationsResponse][google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse]
   * to the same `parent` and with the same `filter`.
   * </pre>
   *
   * <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pageToken.
   */
  @java.lang.Override
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. If non-empty, `page_token` should contain a
   * [next_page_token][google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse.next_page_token]
   * from a previous
   * [ListInstancePartitionOperationsResponse][google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse]
   * to the same `parent` and with the same `filter`.
   * </pre>
   *
   * <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for pageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSTANCE_PARTITION_DEADLINE_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp instancePartitionDeadline_;
  /**
   *
   *
   * <pre>
   * Optional. Deadline used while retrieving metadata for instance partition
   * operations. Instance partitions whose operation metadata cannot be
   * retrieved within this deadline will be added to
   * [unreachable][ListInstancePartitionOperationsResponse.unreachable] in
   * [ListInstancePartitionOperationsResponse][google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse].
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp instance_partition_deadline = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the instancePartitionDeadline field is set.
   */
  @java.lang.Override
  public boolean hasInstancePartitionDeadline() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Deadline used while retrieving metadata for instance partition
   * operations. Instance partitions whose operation metadata cannot be
   * retrieved within this deadline will be added to
   * [unreachable][ListInstancePartitionOperationsResponse.unreachable] in
   * [ListInstancePartitionOperationsResponse][google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse].
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp instance_partition_deadline = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The instancePartitionDeadline.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getInstancePartitionDeadline() {
    return instancePartitionDeadline_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : instancePartitionDeadline_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Deadline used while retrieving metadata for instance partition
   * operations. Instance partitions whose operation metadata cannot be
   * retrieved within this deadline will be added to
   * [unreachable][ListInstancePartitionOperationsResponse.unreachable] in
   * [ListInstancePartitionOperationsResponse][google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse].
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp instance_partition_deadline = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getInstancePartitionDeadlineOrBuilder() {
    return instancePartitionDeadline_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : instancePartitionDeadline_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, filter_);
    }
    if (pageSize_ != 0) {
      output.writeInt32(3, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, pageToken_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getInstancePartitionDeadline());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, filter_);
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, pageToken_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, getInstancePartitionDeadline());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest)) {
      return super.equals(obj);
    }
    com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest other =
        (com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getFilter().equals(other.getFilter())) return false;
    if (getPageSize() != other.getPageSize()) return false;
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (hasInstancePartitionDeadline() != other.hasInstancePartitionDeadline()) return false;
    if (hasInstancePartitionDeadline()) {
      if (!getInstancePartitionDeadline().equals(other.getInstancePartitionDeadline()))
        return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    if (hasInstancePartitionDeadline()) {
      hash = (37 * hash) + INSTANCE_PARTITION_DEADLINE_FIELD_NUMBER;
      hash = (53 * hash) + getInstancePartitionDeadline().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request for
   * [ListInstancePartitionOperations][google.spanner.admin.instance.v1.InstanceAdmin.ListInstancePartitionOperations].
   * </pre>
   *
   * Protobuf type {@code google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest)
      com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
          .internal_static_google_spanner_admin_instance_v1_ListInstancePartitionOperationsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
          .internal_static_google_spanner_admin_instance_v1_ListInstancePartitionOperationsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest.class,
              com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest.Builder
                  .class);
    }

    // Construct using
    // com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getInstancePartitionDeadlineFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      filter_ = "";
      pageSize_ = 0;
      pageToken_ = "";
      instancePartitionDeadline_ = null;
      if (instancePartitionDeadlineBuilder_ != null) {
        instancePartitionDeadlineBuilder_.dispose();
        instancePartitionDeadlineBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
          .internal_static_google_spanner_admin_instance_v1_ListInstancePartitionOperationsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest
        getDefaultInstanceForType() {
      return com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest build() {
      com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest
        buildPartial() {
      com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest result =
          new com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.filter_ = filter_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.pageSize_ = pageSize_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.pageToken_ = pageToken_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.instancePartitionDeadline_ =
            instancePartitionDeadlineBuilder_ == null
                ? instancePartitionDeadline_
                : instancePartitionDeadlineBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest) {
        return mergeFrom(
            (com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest other) {
      if (other
          == com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest
              .getDefaultInstance()) return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasInstancePartitionDeadline()) {
        mergeInstancePartitionDeadline(other.getInstancePartitionDeadline());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                filter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                pageSize_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                pageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getInstancePartitionDeadlineFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The parent instance of the instance partition operations.
     * Values are of the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent instance of the instance partition operations.
     * Values are of the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent instance of the instance partition operations.
     * Values are of the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent instance of the instance partition operations.
     * Values are of the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent instance of the instance partition operations.
     * Values are of the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * Optional. An expression that filters the list of returned operations.
     *
     * A filter expression consists of a field name, a
     * comparison operator, and a value for filtering.
     * The value must be a string, a number, or a boolean. The comparison operator
     * must be one of: `&lt;`, `&gt;`, `&lt;=`, `&gt;=`, `!=`, `=`, or `:`.
     * Colon `:` is the contains operator. Filter rules are not case sensitive.
     *
     * The following fields in the [Operation][google.longrunning.Operation]
     * are eligible for filtering:
     *
     *   * `name` - The name of the long-running operation
     *   * `done` - False if the operation is in progress, else true.
     *   * `metadata.&#64;type` - the type of metadata. For example, the type string
     *      for
     *      [CreateInstancePartitionMetadata][google.spanner.admin.instance.v1.CreateInstancePartitionMetadata]
     *      is
     *      `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstancePartitionMetadata`.
     *   * `metadata.&lt;field_name&gt;` - any field in metadata.value.
     *      `metadata.&#64;type` must be specified first, if filtering on metadata
     *      fields.
     *   * `error` - Error associated with the long-running operation.
     *   * `response.&#64;type` - the type of response.
     *   * `response.&lt;field_name&gt;` - any field in response.value.
     *
     * You can combine multiple expressions by enclosing each expression in
     * parentheses. By default, expressions are combined with AND logic. However,
     * you can specify AND, OR, and NOT logic explicitly.
     *
     * Here are a few examples:
     *
     *   * `done:true` - The operation is complete.
     *   * `(metadata.&#64;type=` &#92;
     *     `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstancePartitionMetadata)
     *     AND` &#92;
     *     `(metadata.instance_partition.name:custom-instance-partition) AND` &#92;
     *     `(metadata.start_time &lt; &#92;"2021-03-28T14:50:00Z&#92;") AND` &#92;
     *     `(error:*)` - Return operations where:
     *     * The operation's metadata type is
     *     [CreateInstancePartitionMetadata][google.spanner.admin.instance.v1.CreateInstancePartitionMetadata].
     *     * The instance partition name contains "custom-instance-partition".
     *     * The operation started before 2021-03-28T14:50:00Z.
     *     * The operation resulted in an error.
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The filter.
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An expression that filters the list of returned operations.
     *
     * A filter expression consists of a field name, a
     * comparison operator, and a value for filtering.
     * The value must be a string, a number, or a boolean. The comparison operator
     * must be one of: `&lt;`, `&gt;`, `&lt;=`, `&gt;=`, `!=`, `=`, or `:`.
     * Colon `:` is the contains operator. Filter rules are not case sensitive.
     *
     * The following fields in the [Operation][google.longrunning.Operation]
     * are eligible for filtering:
     *
     *   * `name` - The name of the long-running operation
     *   * `done` - False if the operation is in progress, else true.
     *   * `metadata.&#64;type` - the type of metadata. For example, the type string
     *      for
     *      [CreateInstancePartitionMetadata][google.spanner.admin.instance.v1.CreateInstancePartitionMetadata]
     *      is
     *      `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstancePartitionMetadata`.
     *   * `metadata.&lt;field_name&gt;` - any field in metadata.value.
     *      `metadata.&#64;type` must be specified first, if filtering on metadata
     *      fields.
     *   * `error` - Error associated with the long-running operation.
     *   * `response.&#64;type` - the type of response.
     *   * `response.&lt;field_name&gt;` - any field in response.value.
     *
     * You can combine multiple expressions by enclosing each expression in
     * parentheses. By default, expressions are combined with AND logic. However,
     * you can specify AND, OR, and NOT logic explicitly.
     *
     * Here are a few examples:
     *
     *   * `done:true` - The operation is complete.
     *   * `(metadata.&#64;type=` &#92;
     *     `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstancePartitionMetadata)
     *     AND` &#92;
     *     `(metadata.instance_partition.name:custom-instance-partition) AND` &#92;
     *     `(metadata.start_time &lt; &#92;"2021-03-28T14:50:00Z&#92;") AND` &#92;
     *     `(error:*)` - Return operations where:
     *     * The operation's metadata type is
     *     [CreateInstancePartitionMetadata][google.spanner.admin.instance.v1.CreateInstancePartitionMetadata].
     *     * The instance partition name contains "custom-instance-partition".
     *     * The operation started before 2021-03-28T14:50:00Z.
     *     * The operation resulted in an error.
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for filter.
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An expression that filters the list of returned operations.
     *
     * A filter expression consists of a field name, a
     * comparison operator, and a value for filtering.
     * The value must be a string, a number, or a boolean. The comparison operator
     * must be one of: `&lt;`, `&gt;`, `&lt;=`, `&gt;=`, `!=`, `=`, or `:`.
     * Colon `:` is the contains operator. Filter rules are not case sensitive.
     *
     * The following fields in the [Operation][google.longrunning.Operation]
     * are eligible for filtering:
     *
     *   * `name` - The name of the long-running operation
     *   * `done` - False if the operation is in progress, else true.
     *   * `metadata.&#64;type` - the type of metadata. For example, the type string
     *      for
     *      [CreateInstancePartitionMetadata][google.spanner.admin.instance.v1.CreateInstancePartitionMetadata]
     *      is
     *      `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstancePartitionMetadata`.
     *   * `metadata.&lt;field_name&gt;` - any field in metadata.value.
     *      `metadata.&#64;type` must be specified first, if filtering on metadata
     *      fields.
     *   * `error` - Error associated with the long-running operation.
     *   * `response.&#64;type` - the type of response.
     *   * `response.&lt;field_name&gt;` - any field in response.value.
     *
     * You can combine multiple expressions by enclosing each expression in
     * parentheses. By default, expressions are combined with AND logic. However,
     * you can specify AND, OR, and NOT logic explicitly.
     *
     * Here are a few examples:
     *
     *   * `done:true` - The operation is complete.
     *   * `(metadata.&#64;type=` &#92;
     *     `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstancePartitionMetadata)
     *     AND` &#92;
     *     `(metadata.instance_partition.name:custom-instance-partition) AND` &#92;
     *     `(metadata.start_time &lt; &#92;"2021-03-28T14:50:00Z&#92;") AND` &#92;
     *     `(error:*)` - Return operations where:
     *     * The operation's metadata type is
     *     [CreateInstancePartitionMetadata][google.spanner.admin.instance.v1.CreateInstancePartitionMetadata].
     *     * The instance partition name contains "custom-instance-partition".
     *     * The operation started before 2021-03-28T14:50:00Z.
     *     * The operation resulted in an error.
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filter_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An expression that filters the list of returned operations.
     *
     * A filter expression consists of a field name, a
     * comparison operator, and a value for filtering.
     * The value must be a string, a number, or a boolean. The comparison operator
     * must be one of: `&lt;`, `&gt;`, `&lt;=`, `&gt;=`, `!=`, `=`, or `:`.
     * Colon `:` is the contains operator. Filter rules are not case sensitive.
     *
     * The following fields in the [Operation][google.longrunning.Operation]
     * are eligible for filtering:
     *
     *   * `name` - The name of the long-running operation
     *   * `done` - False if the operation is in progress, else true.
     *   * `metadata.&#64;type` - the type of metadata. For example, the type string
     *      for
     *      [CreateInstancePartitionMetadata][google.spanner.admin.instance.v1.CreateInstancePartitionMetadata]
     *      is
     *      `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstancePartitionMetadata`.
     *   * `metadata.&lt;field_name&gt;` - any field in metadata.value.
     *      `metadata.&#64;type` must be specified first, if filtering on metadata
     *      fields.
     *   * `error` - Error associated with the long-running operation.
     *   * `response.&#64;type` - the type of response.
     *   * `response.&lt;field_name&gt;` - any field in response.value.
     *
     * You can combine multiple expressions by enclosing each expression in
     * parentheses. By default, expressions are combined with AND logic. However,
     * you can specify AND, OR, and NOT logic explicitly.
     *
     * Here are a few examples:
     *
     *   * `done:true` - The operation is complete.
     *   * `(metadata.&#64;type=` &#92;
     *     `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstancePartitionMetadata)
     *     AND` &#92;
     *     `(metadata.instance_partition.name:custom-instance-partition) AND` &#92;
     *     `(metadata.start_time &lt; &#92;"2021-03-28T14:50:00Z&#92;") AND` &#92;
     *     `(error:*)` - Return operations where:
     *     * The operation's metadata type is
     *     [CreateInstancePartitionMetadata][google.spanner.admin.instance.v1.CreateInstancePartitionMetadata].
     *     * The instance partition name contains "custom-instance-partition".
     *     * The operation started before 2021-03-28T14:50:00Z.
     *     * The operation resulted in an error.
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {
      filter_ = getDefaultInstance().getFilter();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An expression that filters the list of returned operations.
     *
     * A filter expression consists of a field name, a
     * comparison operator, and a value for filtering.
     * The value must be a string, a number, or a boolean. The comparison operator
     * must be one of: `&lt;`, `&gt;`, `&lt;=`, `&gt;=`, `!=`, `=`, or `:`.
     * Colon `:` is the contains operator. Filter rules are not case sensitive.
     *
     * The following fields in the [Operation][google.longrunning.Operation]
     * are eligible for filtering:
     *
     *   * `name` - The name of the long-running operation
     *   * `done` - False if the operation is in progress, else true.
     *   * `metadata.&#64;type` - the type of metadata. For example, the type string
     *      for
     *      [CreateInstancePartitionMetadata][google.spanner.admin.instance.v1.CreateInstancePartitionMetadata]
     *      is
     *      `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstancePartitionMetadata`.
     *   * `metadata.&lt;field_name&gt;` - any field in metadata.value.
     *      `metadata.&#64;type` must be specified first, if filtering on metadata
     *      fields.
     *   * `error` - Error associated with the long-running operation.
     *   * `response.&#64;type` - the type of response.
     *   * `response.&lt;field_name&gt;` - any field in response.value.
     *
     * You can combine multiple expressions by enclosing each expression in
     * parentheses. By default, expressions are combined with AND logic. However,
     * you can specify AND, OR, and NOT logic explicitly.
     *
     * Here are a few examples:
     *
     *   * `done:true` - The operation is complete.
     *   * `(metadata.&#64;type=` &#92;
     *     `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstancePartitionMetadata)
     *     AND` &#92;
     *     `(metadata.instance_partition.name:custom-instance-partition) AND` &#92;
     *     `(metadata.start_time &lt; &#92;"2021-03-28T14:50:00Z&#92;") AND` &#92;
     *     `(error:*)` - Return operations where:
     *     * The operation's metadata type is
     *     [CreateInstancePartitionMetadata][google.spanner.admin.instance.v1.CreateInstancePartitionMetadata].
     *     * The instance partition name contains "custom-instance-partition".
     *     * The operation started before 2021-03-28T14:50:00Z.
     *     * The operation resulted in an error.
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filter_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int pageSize_;
    /**
     *
     *
     * <pre>
     * Optional. Number of operations to be returned in the response. If 0 or
     * less, defaults to the server's maximum allowed page size.
     * </pre>
     *
     * <code>int32 page_size = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Number of operations to be returned in the response. If 0 or
     * less, defaults to the server's maximum allowed page size.
     * </pre>
     *
     * <code>int32 page_size = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The pageSize to set.
     * @return This builder for chaining.
     */
    public Builder setPageSize(int value) {

      pageSize_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Number of operations to be returned in the response. If 0 or
     * less, defaults to the server's maximum allowed page size.
     * </pre>
     *
     * <code>int32 page_size = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageSize() {
      bitField0_ = (bitField0_ & ~0x00000004);
      pageSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object pageToken_ = "";
    /**
     *
     *
     * <pre>
     * Optional. If non-empty, `page_token` should contain a
     * [next_page_token][google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse.next_page_token]
     * from a previous
     * [ListInstancePartitionOperationsResponse][google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse]
     * to the same `parent` and with the same `filter`.
     * </pre>
     *
     * <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pageToken.
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. If non-empty, `page_token` should contain a
     * [next_page_token][google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse.next_page_token]
     * from a previous
     * [ListInstancePartitionOperationsResponse][google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse]
     * to the same `parent` and with the same `filter`.
     * </pre>
     *
     * <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for pageToken.
     */
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. If non-empty, `page_token` should contain a
     * [next_page_token][google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse.next_page_token]
     * from a previous
     * [ListInstancePartitionOperationsResponse][google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse]
     * to the same `parent` and with the same `filter`.
     * </pre>
     *
     * <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pageToken_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If non-empty, `page_token` should contain a
     * [next_page_token][google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse.next_page_token]
     * from a previous
     * [ListInstancePartitionOperationsResponse][google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse]
     * to the same `parent` and with the same `filter`.
     * </pre>
     *
     * <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageToken() {
      pageToken_ = getDefaultInstance().getPageToken();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If non-empty, `page_token` should contain a
     * [next_page_token][google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse.next_page_token]
     * from a previous
     * [ListInstancePartitionOperationsResponse][google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse]
     * to the same `parent` and with the same `filter`.
     * </pre>
     *
     * <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pageToken_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp instancePartitionDeadline_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        instancePartitionDeadlineBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Deadline used while retrieving metadata for instance partition
     * operations. Instance partitions whose operation metadata cannot be
     * retrieved within this deadline will be added to
     * [unreachable][ListInstancePartitionOperationsResponse.unreachable] in
     * [ListInstancePartitionOperationsResponse][google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp instance_partition_deadline = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the instancePartitionDeadline field is set.
     */
    public boolean hasInstancePartitionDeadline() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Deadline used while retrieving metadata for instance partition
     * operations. Instance partitions whose operation metadata cannot be
     * retrieved within this deadline will be added to
     * [unreachable][ListInstancePartitionOperationsResponse.unreachable] in
     * [ListInstancePartitionOperationsResponse][google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp instance_partition_deadline = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The instancePartitionDeadline.
     */
    public com.google.protobuf.Timestamp getInstancePartitionDeadline() {
      if (instancePartitionDeadlineBuilder_ == null) {
        return instancePartitionDeadline_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : instancePartitionDeadline_;
      } else {
        return instancePartitionDeadlineBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Deadline used while retrieving metadata for instance partition
     * operations. Instance partitions whose operation metadata cannot be
     * retrieved within this deadline will be added to
     * [unreachable][ListInstancePartitionOperationsResponse.unreachable] in
     * [ListInstancePartitionOperationsResponse][google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp instance_partition_deadline = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setInstancePartitionDeadline(com.google.protobuf.Timestamp value) {
      if (instancePartitionDeadlineBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        instancePartitionDeadline_ = value;
      } else {
        instancePartitionDeadlineBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Deadline used while retrieving metadata for instance partition
     * operations. Instance partitions whose operation metadata cannot be
     * retrieved within this deadline will be added to
     * [unreachable][ListInstancePartitionOperationsResponse.unreachable] in
     * [ListInstancePartitionOperationsResponse][google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp instance_partition_deadline = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setInstancePartitionDeadline(
        com.google.protobuf.Timestamp.Builder builderForValue) {
      if (instancePartitionDeadlineBuilder_ == null) {
        instancePartitionDeadline_ = builderForValue.build();
      } else {
        instancePartitionDeadlineBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Deadline used while retrieving metadata for instance partition
     * operations. Instance partitions whose operation metadata cannot be
     * retrieved within this deadline will be added to
     * [unreachable][ListInstancePartitionOperationsResponse.unreachable] in
     * [ListInstancePartitionOperationsResponse][google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp instance_partition_deadline = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeInstancePartitionDeadline(com.google.protobuf.Timestamp value) {
      if (instancePartitionDeadlineBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && instancePartitionDeadline_ != null
            && instancePartitionDeadline_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getInstancePartitionDeadlineBuilder().mergeFrom(value);
        } else {
          instancePartitionDeadline_ = value;
        }
      } else {
        instancePartitionDeadlineBuilder_.mergeFrom(value);
      }
      if (instancePartitionDeadline_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Deadline used while retrieving metadata for instance partition
     * operations. Instance partitions whose operation metadata cannot be
     * retrieved within this deadline will be added to
     * [unreachable][ListInstancePartitionOperationsResponse.unreachable] in
     * [ListInstancePartitionOperationsResponse][google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp instance_partition_deadline = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearInstancePartitionDeadline() {
      bitField0_ = (bitField0_ & ~0x00000010);
      instancePartitionDeadline_ = null;
      if (instancePartitionDeadlineBuilder_ != null) {
        instancePartitionDeadlineBuilder_.dispose();
        instancePartitionDeadlineBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Deadline used while retrieving metadata for instance partition
     * operations. Instance partitions whose operation metadata cannot be
     * retrieved within this deadline will be added to
     * [unreachable][ListInstancePartitionOperationsResponse.unreachable] in
     * [ListInstancePartitionOperationsResponse][google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp instance_partition_deadline = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getInstancePartitionDeadlineBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getInstancePartitionDeadlineFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Deadline used while retrieving metadata for instance partition
     * operations. Instance partitions whose operation metadata cannot be
     * retrieved within this deadline will be added to
     * [unreachable][ListInstancePartitionOperationsResponse.unreachable] in
     * [ListInstancePartitionOperationsResponse][google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp instance_partition_deadline = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getInstancePartitionDeadlineOrBuilder() {
      if (instancePartitionDeadlineBuilder_ != null) {
        return instancePartitionDeadlineBuilder_.getMessageOrBuilder();
      } else {
        return instancePartitionDeadline_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : instancePartitionDeadline_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Deadline used while retrieving metadata for instance partition
     * operations. Instance partitions whose operation metadata cannot be
     * retrieved within this deadline will be added to
     * [unreachable][ListInstancePartitionOperationsResponse.unreachable] in
     * [ListInstancePartitionOperationsResponse][google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp instance_partition_deadline = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getInstancePartitionDeadlineFieldBuilder() {
      if (instancePartitionDeadlineBuilder_ == null) {
        instancePartitionDeadlineBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getInstancePartitionDeadline(), getParentForChildren(), isClean());
        instancePartitionDeadline_ = null;
      }
      return instancePartitionDeadlineBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest)
  private static final com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest();
  }

  public static com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListInstancePartitionOperationsRequest> PARSER =
      new com.google.protobuf.AbstractParser<ListInstancePartitionOperationsRequest>() {
        @java.lang.Override
        public ListInstancePartitionOperationsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListInstancePartitionOperationsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListInstancePartitionOperationsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
