/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/admin/instance/v1/spanner_instance_admin.proto

// Protobuf Java Version: 3.25.3
package com.google.spanner.admin.instance.v1;

public interface InstancePartitionOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.spanner.admin.instance.v1.InstancePartition)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. A unique identifier for the instance partition. Values are of the
   * form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/instancePartitions/[a-z][-a-z0-9]*[a-z0-9]`.
   * The final segment of the name must be between 2 and 64 characters in
   * length. An instance partition's name cannot be changed after the instance
   * partition is created.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Required. A unique identifier for the instance partition. Values are of the
   * form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/instancePartitions/[a-z][-a-z0-9]*[a-z0-9]`.
   * The final segment of the name must be between 2 and 64 characters in
   * length. An instance partition's name cannot be changed after the instance
   * partition is created.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Required. The name of the instance partition's configuration. Values are of
   * the form `projects/&lt;project&gt;/instanceConfigs/&lt;configuration&gt;`. See also
   * [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig] and
   * [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs].
   * </pre>
   *
   * <code>
   * string config = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The config.
   */
  java.lang.String getConfig();
  /**
   *
   *
   * <pre>
   * Required. The name of the instance partition's configuration. Values are of
   * the form `projects/&lt;project&gt;/instanceConfigs/&lt;configuration&gt;`. See also
   * [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig] and
   * [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs].
   * </pre>
   *
   * <code>
   * string config = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for config.
   */
  com.google.protobuf.ByteString getConfigBytes();

  /**
   *
   *
   * <pre>
   * Required. The descriptive name for this instance partition as it appears in
   * UIs. Must be unique per project and between 4 and 30 characters in length.
   * </pre>
   *
   * <code>string display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  java.lang.String getDisplayName();
  /**
   *
   *
   * <pre>
   * Required. The descriptive name for this instance partition as it appears in
   * UIs. Must be unique per project and between 4 and 30 characters in length.
   * </pre>
   *
   * <code>string display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  com.google.protobuf.ByteString getDisplayNameBytes();

  /**
   *
   *
   * <pre>
   * The number of nodes allocated to this instance partition.
   *
   * Users can set the node_count field to specify the target number of nodes
   * allocated to the instance partition.
   *
   * This may be zero in API responses for instance partitions that are not
   * yet in state `READY`.
   * </pre>
   *
   * <code>int32 node_count = 5;</code>
   *
   * @return Whether the nodeCount field is set.
   */
  boolean hasNodeCount();
  /**
   *
   *
   * <pre>
   * The number of nodes allocated to this instance partition.
   *
   * Users can set the node_count field to specify the target number of nodes
   * allocated to the instance partition.
   *
   * This may be zero in API responses for instance partitions that are not
   * yet in state `READY`.
   * </pre>
   *
   * <code>int32 node_count = 5;</code>
   *
   * @return The nodeCount.
   */
  int getNodeCount();

  /**
   *
   *
   * <pre>
   * The number of processing units allocated to this instance partition.
   *
   * Users can set the processing_units field to specify the target number of
   * processing units allocated to the instance partition.
   *
   * This may be zero in API responses for instance partitions that are not
   * yet in state `READY`.
   * </pre>
   *
   * <code>int32 processing_units = 6;</code>
   *
   * @return Whether the processingUnits field is set.
   */
  boolean hasProcessingUnits();
  /**
   *
   *
   * <pre>
   * The number of processing units allocated to this instance partition.
   *
   * Users can set the processing_units field to specify the target number of
   * processing units allocated to the instance partition.
   *
   * This may be zero in API responses for instance partitions that are not
   * yet in state `READY`.
   * </pre>
   *
   * <code>int32 processing_units = 6;</code>
   *
   * @return The processingUnits.
   */
  int getProcessingUnits();

  /**
   *
   *
   * <pre>
   * Output only. The current instance partition state.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.instance.v1.InstancePartition.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  int getStateValue();
  /**
   *
   *
   * <pre>
   * Output only. The current instance partition state.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.instance.v1.InstancePartition.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  com.google.spanner.admin.instance.v1.InstancePartition.State getState();

  /**
   *
   *
   * <pre>
   * Output only. The time at which the instance partition was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. The time at which the instance partition was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. The time at which the instance partition was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The time at which the instance partition was most recently
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  boolean hasUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. The time at which the instance partition was most recently
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  com.google.protobuf.Timestamp getUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. The time at which the instance partition was most recently
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The names of the databases that reference this
   * instance partition. Referencing databases should share the parent instance.
   * The existence of any referencing database prevents the instance partition
   * from being deleted.
   * </pre>
   *
   * <code>repeated string referencing_databases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the referencingDatabases.
   */
  java.util.List<java.lang.String> getReferencingDatabasesList();
  /**
   *
   *
   * <pre>
   * Output only. The names of the databases that reference this
   * instance partition. Referencing databases should share the parent instance.
   * The existence of any referencing database prevents the instance partition
   * from being deleted.
   * </pre>
   *
   * <code>repeated string referencing_databases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of referencingDatabases.
   */
  int getReferencingDatabasesCount();
  /**
   *
   *
   * <pre>
   * Output only. The names of the databases that reference this
   * instance partition. Referencing databases should share the parent instance.
   * The existence of any referencing database prevents the instance partition
   * from being deleted.
   * </pre>
   *
   * <code>repeated string referencing_databases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The referencingDatabases at the given index.
   */
  java.lang.String getReferencingDatabases(int index);
  /**
   *
   *
   * <pre>
   * Output only. The names of the databases that reference this
   * instance partition. Referencing databases should share the parent instance.
   * The existence of any referencing database prevents the instance partition
   * from being deleted.
   * </pre>
   *
   * <code>repeated string referencing_databases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the referencingDatabases at the given index.
   */
  com.google.protobuf.ByteString getReferencingDatabasesBytes(int index);

  /**
   *
   *
   * <pre>
   * Output only. The names of the backups that reference this instance
   * partition. Referencing backups should share the parent instance. The
   * existence of any referencing backup prevents the instance partition from
   * being deleted.
   * </pre>
   *
   * <code>repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the referencingBackups.
   */
  java.util.List<java.lang.String> getReferencingBackupsList();
  /**
   *
   *
   * <pre>
   * Output only. The names of the backups that reference this instance
   * partition. Referencing backups should share the parent instance. The
   * existence of any referencing backup prevents the instance partition from
   * being deleted.
   * </pre>
   *
   * <code>repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of referencingBackups.
   */
  int getReferencingBackupsCount();
  /**
   *
   *
   * <pre>
   * Output only. The names of the backups that reference this instance
   * partition. Referencing backups should share the parent instance. The
   * existence of any referencing backup prevents the instance partition from
   * being deleted.
   * </pre>
   *
   * <code>repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The referencingBackups at the given index.
   */
  java.lang.String getReferencingBackups(int index);
  /**
   *
   *
   * <pre>
   * Output only. The names of the backups that reference this instance
   * partition. Referencing backups should share the parent instance. The
   * existence of any referencing backup prevents the instance partition from
   * being deleted.
   * </pre>
   *
   * <code>repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the referencingBackups at the given index.
   */
  com.google.protobuf.ByteString getReferencingBackupsBytes(int index);

  /**
   *
   *
   * <pre>
   * Used for optimistic concurrency control as a way
   * to help prevent simultaneous updates of a instance partition from
   * overwriting each other. It is strongly suggested that systems make use of
   * the etag in the read-modify-write cycle to perform instance partition
   * updates in order to avoid race conditions: An etag is returned in the
   * response which contains instance partitions, and systems are expected to
   * put that etag in the request to update instance partitions to ensure that
   * their change will be applied to the same version of the instance partition.
   * If no etag is provided in the call to update instance partition, then the
   * existing instance partition is overwritten blindly.
   * </pre>
   *
   * <code>string etag = 12;</code>
   *
   * @return The etag.
   */
  java.lang.String getEtag();
  /**
   *
   *
   * <pre>
   * Used for optimistic concurrency control as a way
   * to help prevent simultaneous updates of a instance partition from
   * overwriting each other. It is strongly suggested that systems make use of
   * the etag in the read-modify-write cycle to perform instance partition
   * updates in order to avoid race conditions: An etag is returned in the
   * response which contains instance partitions, and systems are expected to
   * put that etag in the request to update instance partitions to ensure that
   * their change will be applied to the same version of the instance partition.
   * If no etag is provided in the call to update instance partition, then the
   * existing instance partition is overwritten blindly.
   * </pre>
   *
   * <code>string etag = 12;</code>
   *
   * @return The bytes for etag.
   */
  com.google.protobuf.ByteString getEtagBytes();

  com.google.spanner.admin.instance.v1.InstancePartition.ComputeCapacityCase
      getComputeCapacityCase();
}
