/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/admin/instance/v1/spanner_instance_admin.proto

// Protobuf Java Version: 3.25.3
package com.google.spanner.admin.instance.v1;

public interface ListInstancesRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.spanner.admin.instance.v1.ListInstancesRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The name of the project for which a list of instances is
   * requested. Values are of the form `projects/&lt;project&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  java.lang.String getParent();
  /**
   *
   *
   * <pre>
   * Required. The name of the project for which a list of instances is
   * requested. Values are of the form `projects/&lt;project&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  com.google.protobuf.ByteString getParentBytes();

  /**
   *
   *
   * <pre>
   * Number of instances to be returned in the response. If 0 or less, defaults
   * to the server's maximum allowed page size.
   * </pre>
   *
   * <code>int32 page_size = 2;</code>
   *
   * @return The pageSize.
   */
  int getPageSize();

  /**
   *
   *
   * <pre>
   * If non-empty, `page_token` should contain a
   * [next_page_token][google.spanner.admin.instance.v1.ListInstancesResponse.next_page_token]
   * from a previous
   * [ListInstancesResponse][google.spanner.admin.instance.v1.ListInstancesResponse].
   * </pre>
   *
   * <code>string page_token = 3;</code>
   *
   * @return The pageToken.
   */
  java.lang.String getPageToken();
  /**
   *
   *
   * <pre>
   * If non-empty, `page_token` should contain a
   * [next_page_token][google.spanner.admin.instance.v1.ListInstancesResponse.next_page_token]
   * from a previous
   * [ListInstancesResponse][google.spanner.admin.instance.v1.ListInstancesResponse].
   * </pre>
   *
   * <code>string page_token = 3;</code>
   *
   * @return The bytes for pageToken.
   */
  com.google.protobuf.ByteString getPageTokenBytes();

  /**
   *
   *
   * <pre>
   * An expression for filtering the results of the request. Filter rules are
   * case insensitive. The fields eligible for filtering are:
   *
   *   * `name`
   *   * `display_name`
   *   * `labels.key` where key is the name of a label
   *
   * Some examples of using filters are:
   *
   *   * `name:*` --&gt; The instance has a name.
   *   * `name:Howl` --&gt; The instance's name contains the string "howl".
   *   * `name:HOWL` --&gt; Equivalent to above.
   *   * `NAME:howl` --&gt; Equivalent to above.
   *   * `labels.env:*` --&gt; The instance has the label "env".
   *   * `labels.env:dev` --&gt; The instance has the label "env" and the value of
   *                        the label contains the string "dev".
   *   * `name:howl labels.env:dev` --&gt; The instance's name contains "howl" and
   *                                  it has the label "env" with its value
   *                                  containing "dev".
   * </pre>
   *
   * <code>string filter = 4;</code>
   *
   * @return The filter.
   */
  java.lang.String getFilter();
  /**
   *
   *
   * <pre>
   * An expression for filtering the results of the request. Filter rules are
   * case insensitive. The fields eligible for filtering are:
   *
   *   * `name`
   *   * `display_name`
   *   * `labels.key` where key is the name of a label
   *
   * Some examples of using filters are:
   *
   *   * `name:*` --&gt; The instance has a name.
   *   * `name:Howl` --&gt; The instance's name contains the string "howl".
   *   * `name:HOWL` --&gt; Equivalent to above.
   *   * `NAME:howl` --&gt; Equivalent to above.
   *   * `labels.env:*` --&gt; The instance has the label "env".
   *   * `labels.env:dev` --&gt; The instance has the label "env" and the value of
   *                        the label contains the string "dev".
   *   * `name:howl labels.env:dev` --&gt; The instance's name contains "howl" and
   *                                  it has the label "env" with its value
   *                                  containing "dev".
   * </pre>
   *
   * <code>string filter = 4;</code>
   *
   * @return The bytes for filter.
   */
  com.google.protobuf.ByteString getFilterBytes();

  /**
   *
   *
   * <pre>
   * Deadline used while retrieving metadata for instances.
   * Instances whose metadata cannot be retrieved within this deadline will be
   * added to
   * [unreachable][google.spanner.admin.instance.v1.ListInstancesResponse.unreachable]
   * in
   * [ListInstancesResponse][google.spanner.admin.instance.v1.ListInstancesResponse].
   * </pre>
   *
   * <code>.google.protobuf.Timestamp instance_deadline = 5;</code>
   *
   * @return Whether the instanceDeadline field is set.
   */
  boolean hasInstanceDeadline();
  /**
   *
   *
   * <pre>
   * Deadline used while retrieving metadata for instances.
   * Instances whose metadata cannot be retrieved within this deadline will be
   * added to
   * [unreachable][google.spanner.admin.instance.v1.ListInstancesResponse.unreachable]
   * in
   * [ListInstancesResponse][google.spanner.admin.instance.v1.ListInstancesResponse].
   * </pre>
   *
   * <code>.google.protobuf.Timestamp instance_deadline = 5;</code>
   *
   * @return The instanceDeadline.
   */
  com.google.protobuf.Timestamp getInstanceDeadline();
  /**
   *
   *
   * <pre>
   * Deadline used while retrieving metadata for instances.
   * Instances whose metadata cannot be retrieved within this deadline will be
   * added to
   * [unreachable][google.spanner.admin.instance.v1.ListInstancesResponse.unreachable]
   * in
   * [ListInstancesResponse][google.spanner.admin.instance.v1.ListInstancesResponse].
   * </pre>
   *
   * <code>.google.protobuf.Timestamp instance_deadline = 5;</code>
   */
  com.google.protobuf.TimestampOrBuilder getInstanceDeadlineOrBuilder();
}
