/*
 * Decompiled with CFR 0.152.
 */
package com.google.spanner.admin.instance.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InstancePartitionName
implements ResourceName {
    private static final PathTemplate PROJECT_INSTANCE_INSTANCE_PARTITION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/instances/{instance}/instancePartitions/{instance_partition}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String instance;
    private final String instancePartition;

    @Deprecated
    protected InstancePartitionName() {
        this.project = null;
        this.instance = null;
        this.instancePartition = null;
    }

    private InstancePartitionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
        this.instancePartition = (String)Preconditions.checkNotNull((Object)builder.getInstancePartition());
    }

    public String getProject() {
        return this.project;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getInstancePartition() {
        return this.instancePartition;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static InstancePartitionName of(String project, String instance, String instancePartition) {
        return InstancePartitionName.newBuilder().setProject(project).setInstance(instance).setInstancePartition(instancePartition).build();
    }

    public static String format(String project, String instance, String instancePartition) {
        return InstancePartitionName.newBuilder().setProject(project).setInstance(instance).setInstancePartition(instancePartition).build().toString();
    }

    public static InstancePartitionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_INSTANCE_INSTANCE_PARTITION.validatedMatch(formattedString, "InstancePartitionName.parse: formattedString not in valid format");
        return InstancePartitionName.of((String)matchMap.get("project"), (String)matchMap.get("instance"), (String)matchMap.get("instance_partition"));
    }

    public static List<InstancePartitionName> parseList(List<String> formattedStrings) {
        ArrayList<InstancePartitionName> list = new ArrayList<InstancePartitionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(InstancePartitionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<InstancePartitionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (InstancePartitionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_INSTANCE_INSTANCE_PARTITION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            InstancePartitionName instancePartitionName = this;
            synchronized (instancePartitionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.instance != null) {
                        fieldMapBuilder.put((Object)"instance", (Object)this.instance);
                    }
                    if (this.instancePartition != null) {
                        fieldMapBuilder.put((Object)"instance_partition", (Object)this.instancePartition);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_INSTANCE_INSTANCE_PARTITION.instantiate(new String[]{"project", this.project, "instance", this.instance, "instance_partition", this.instancePartition});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            InstancePartitionName that = (InstancePartitionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.instance, that.instance) && Objects.equals(this.instancePartition, that.instancePartition);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.instance);
        h *= 1000003;
        return h ^= Objects.hashCode(this.instancePartition);
    }

    public static class Builder {
        private String project;
        private String instance;
        private String instancePartition;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getInstance() {
            return this.instance;
        }

        public String getInstancePartition() {
            return this.instancePartition;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder setInstancePartition(String instancePartition) {
            this.instancePartition = instancePartition;
            return this;
        }

        private Builder(InstancePartitionName instancePartitionName) {
            this.project = instancePartitionName.project;
            this.instance = instancePartitionName.instance;
            this.instancePartition = instancePartitionName.instancePartition;
        }

        public InstancePartitionName build() {
            return new InstancePartitionName(this);
        }
    }
}

