/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/executor/v1/cloud_executor.proto

// Protobuf Java Version: 3.25.3
package com.google.spanner.executor.v1;

/**
 *
 *
 * <pre>
 * AdminAction defines all the cloud spanner admin actions, including
 * instance/database admin ops, backup ops and operation actions.
 * </pre>
 *
 * Protobuf type {@code google.spanner.executor.v1.AdminAction}
 */
public final class AdminAction extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.executor.v1.AdminAction)
    AdminActionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AdminAction.newBuilder() to construct.
  private AdminAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AdminAction() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AdminAction();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_AdminAction_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_AdminAction_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.executor.v1.AdminAction.class,
            com.google.spanner.executor.v1.AdminAction.Builder.class);
  }

  private int actionCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object action_;

  public enum ActionCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CREATE_USER_INSTANCE_CONFIG(1),
    UPDATE_USER_INSTANCE_CONFIG(2),
    DELETE_USER_INSTANCE_CONFIG(3),
    GET_CLOUD_INSTANCE_CONFIG(4),
    LIST_INSTANCE_CONFIGS(5),
    CREATE_CLOUD_INSTANCE(6),
    UPDATE_CLOUD_INSTANCE(7),
    DELETE_CLOUD_INSTANCE(8),
    LIST_CLOUD_INSTANCES(9),
    GET_CLOUD_INSTANCE(10),
    CREATE_CLOUD_DATABASE(11),
    UPDATE_CLOUD_DATABASE_DDL(12),
    UPDATE_CLOUD_DATABASE(27),
    DROP_CLOUD_DATABASE(13),
    LIST_CLOUD_DATABASES(14),
    LIST_CLOUD_DATABASE_OPERATIONS(15),
    RESTORE_CLOUD_DATABASE(16),
    GET_CLOUD_DATABASE(17),
    CREATE_CLOUD_BACKUP(18),
    COPY_CLOUD_BACKUP(19),
    GET_CLOUD_BACKUP(20),
    UPDATE_CLOUD_BACKUP(21),
    DELETE_CLOUD_BACKUP(22),
    LIST_CLOUD_BACKUPS(23),
    LIST_CLOUD_BACKUP_OPERATIONS(24),
    GET_OPERATION(25),
    CANCEL_OPERATION(26),
    CHANGE_QUORUM_CLOUD_DATABASE(28),
    ACTION_NOT_SET(0);
    private final int value;

    private ActionCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ActionCase valueOf(int value) {
      return forNumber(value);
    }

    public static ActionCase forNumber(int value) {
      switch (value) {
        case 1:
          return CREATE_USER_INSTANCE_CONFIG;
        case 2:
          return UPDATE_USER_INSTANCE_CONFIG;
        case 3:
          return DELETE_USER_INSTANCE_CONFIG;
        case 4:
          return GET_CLOUD_INSTANCE_CONFIG;
        case 5:
          return LIST_INSTANCE_CONFIGS;
        case 6:
          return CREATE_CLOUD_INSTANCE;
        case 7:
          return UPDATE_CLOUD_INSTANCE;
        case 8:
          return DELETE_CLOUD_INSTANCE;
        case 9:
          return LIST_CLOUD_INSTANCES;
        case 10:
          return GET_CLOUD_INSTANCE;
        case 11:
          return CREATE_CLOUD_DATABASE;
        case 12:
          return UPDATE_CLOUD_DATABASE_DDL;
        case 27:
          return UPDATE_CLOUD_DATABASE;
        case 13:
          return DROP_CLOUD_DATABASE;
        case 14:
          return LIST_CLOUD_DATABASES;
        case 15:
          return LIST_CLOUD_DATABASE_OPERATIONS;
        case 16:
          return RESTORE_CLOUD_DATABASE;
        case 17:
          return GET_CLOUD_DATABASE;
        case 18:
          return CREATE_CLOUD_BACKUP;
        case 19:
          return COPY_CLOUD_BACKUP;
        case 20:
          return GET_CLOUD_BACKUP;
        case 21:
          return UPDATE_CLOUD_BACKUP;
        case 22:
          return DELETE_CLOUD_BACKUP;
        case 23:
          return LIST_CLOUD_BACKUPS;
        case 24:
          return LIST_CLOUD_BACKUP_OPERATIONS;
        case 25:
          return GET_OPERATION;
        case 26:
          return CANCEL_OPERATION;
        case 28:
          return CHANGE_QUORUM_CLOUD_DATABASE;
        case 0:
          return ACTION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ActionCase getActionCase() {
    return ActionCase.forNumber(actionCase_);
  }

  public static final int CREATE_USER_INSTANCE_CONFIG_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Action that creates a user instance config.
   * </pre>
   *
   * <code>
   * .google.spanner.executor.v1.CreateUserInstanceConfigAction create_user_instance_config = 1;
   * </code>
   *
   * @return Whether the createUserInstanceConfig field is set.
   */
  @java.lang.Override
  public boolean hasCreateUserInstanceConfig() {
    return actionCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Action that creates a user instance config.
   * </pre>
   *
   * <code>
   * .google.spanner.executor.v1.CreateUserInstanceConfigAction create_user_instance_config = 1;
   * </code>
   *
   * @return The createUserInstanceConfig.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.CreateUserInstanceConfigAction
      getCreateUserInstanceConfig() {
    if (actionCase_ == 1) {
      return (com.google.spanner.executor.v1.CreateUserInstanceConfigAction) action_;
    }
    return com.google.spanner.executor.v1.CreateUserInstanceConfigAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action that creates a user instance config.
   * </pre>
   *
   * <code>
   * .google.spanner.executor.v1.CreateUserInstanceConfigAction create_user_instance_config = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.CreateUserInstanceConfigActionOrBuilder
      getCreateUserInstanceConfigOrBuilder() {
    if (actionCase_ == 1) {
      return (com.google.spanner.executor.v1.CreateUserInstanceConfigAction) action_;
    }
    return com.google.spanner.executor.v1.CreateUserInstanceConfigAction.getDefaultInstance();
  }

  public static final int UPDATE_USER_INSTANCE_CONFIG_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Action that updates a user instance config.
   * </pre>
   *
   * <code>
   * .google.spanner.executor.v1.UpdateUserInstanceConfigAction update_user_instance_config = 2;
   * </code>
   *
   * @return Whether the updateUserInstanceConfig field is set.
   */
  @java.lang.Override
  public boolean hasUpdateUserInstanceConfig() {
    return actionCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Action that updates a user instance config.
   * </pre>
   *
   * <code>
   * .google.spanner.executor.v1.UpdateUserInstanceConfigAction update_user_instance_config = 2;
   * </code>
   *
   * @return The updateUserInstanceConfig.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.UpdateUserInstanceConfigAction
      getUpdateUserInstanceConfig() {
    if (actionCase_ == 2) {
      return (com.google.spanner.executor.v1.UpdateUserInstanceConfigAction) action_;
    }
    return com.google.spanner.executor.v1.UpdateUserInstanceConfigAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action that updates a user instance config.
   * </pre>
   *
   * <code>
   * .google.spanner.executor.v1.UpdateUserInstanceConfigAction update_user_instance_config = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.UpdateUserInstanceConfigActionOrBuilder
      getUpdateUserInstanceConfigOrBuilder() {
    if (actionCase_ == 2) {
      return (com.google.spanner.executor.v1.UpdateUserInstanceConfigAction) action_;
    }
    return com.google.spanner.executor.v1.UpdateUserInstanceConfigAction.getDefaultInstance();
  }

  public static final int DELETE_USER_INSTANCE_CONFIG_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Action that deletes a user instance config.
   * </pre>
   *
   * <code>
   * .google.spanner.executor.v1.DeleteUserInstanceConfigAction delete_user_instance_config = 3;
   * </code>
   *
   * @return Whether the deleteUserInstanceConfig field is set.
   */
  @java.lang.Override
  public boolean hasDeleteUserInstanceConfig() {
    return actionCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Action that deletes a user instance config.
   * </pre>
   *
   * <code>
   * .google.spanner.executor.v1.DeleteUserInstanceConfigAction delete_user_instance_config = 3;
   * </code>
   *
   * @return The deleteUserInstanceConfig.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.DeleteUserInstanceConfigAction
      getDeleteUserInstanceConfig() {
    if (actionCase_ == 3) {
      return (com.google.spanner.executor.v1.DeleteUserInstanceConfigAction) action_;
    }
    return com.google.spanner.executor.v1.DeleteUserInstanceConfigAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action that deletes a user instance config.
   * </pre>
   *
   * <code>
   * .google.spanner.executor.v1.DeleteUserInstanceConfigAction delete_user_instance_config = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.DeleteUserInstanceConfigActionOrBuilder
      getDeleteUserInstanceConfigOrBuilder() {
    if (actionCase_ == 3) {
      return (com.google.spanner.executor.v1.DeleteUserInstanceConfigAction) action_;
    }
    return com.google.spanner.executor.v1.DeleteUserInstanceConfigAction.getDefaultInstance();
  }

  public static final int GET_CLOUD_INSTANCE_CONFIG_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Action that gets a user instance config.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.GetCloudInstanceConfigAction get_cloud_instance_config = 4;
   * </code>
   *
   * @return Whether the getCloudInstanceConfig field is set.
   */
  @java.lang.Override
  public boolean hasGetCloudInstanceConfig() {
    return actionCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Action that gets a user instance config.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.GetCloudInstanceConfigAction get_cloud_instance_config = 4;
   * </code>
   *
   * @return The getCloudInstanceConfig.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.GetCloudInstanceConfigAction getGetCloudInstanceConfig() {
    if (actionCase_ == 4) {
      return (com.google.spanner.executor.v1.GetCloudInstanceConfigAction) action_;
    }
    return com.google.spanner.executor.v1.GetCloudInstanceConfigAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action that gets a user instance config.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.GetCloudInstanceConfigAction get_cloud_instance_config = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.GetCloudInstanceConfigActionOrBuilder
      getGetCloudInstanceConfigOrBuilder() {
    if (actionCase_ == 4) {
      return (com.google.spanner.executor.v1.GetCloudInstanceConfigAction) action_;
    }
    return com.google.spanner.executor.v1.GetCloudInstanceConfigAction.getDefaultInstance();
  }

  public static final int LIST_INSTANCE_CONFIGS_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Action that lists user instance configs.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ListCloudInstanceConfigsAction list_instance_configs = 5;
   * </code>
   *
   * @return Whether the listInstanceConfigs field is set.
   */
  @java.lang.Override
  public boolean hasListInstanceConfigs() {
    return actionCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Action that lists user instance configs.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ListCloudInstanceConfigsAction list_instance_configs = 5;
   * </code>
   *
   * @return The listInstanceConfigs.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ListCloudInstanceConfigsAction getListInstanceConfigs() {
    if (actionCase_ == 5) {
      return (com.google.spanner.executor.v1.ListCloudInstanceConfigsAction) action_;
    }
    return com.google.spanner.executor.v1.ListCloudInstanceConfigsAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action that lists user instance configs.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ListCloudInstanceConfigsAction list_instance_configs = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ListCloudInstanceConfigsActionOrBuilder
      getListInstanceConfigsOrBuilder() {
    if (actionCase_ == 5) {
      return (com.google.spanner.executor.v1.ListCloudInstanceConfigsAction) action_;
    }
    return com.google.spanner.executor.v1.ListCloudInstanceConfigsAction.getDefaultInstance();
  }

  public static final int CREATE_CLOUD_INSTANCE_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Action that creates a Cloud Spanner instance.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.CreateCloudInstanceAction create_cloud_instance = 6;</code>
   *
   * @return Whether the createCloudInstance field is set.
   */
  @java.lang.Override
  public boolean hasCreateCloudInstance() {
    return actionCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Action that creates a Cloud Spanner instance.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.CreateCloudInstanceAction create_cloud_instance = 6;</code>
   *
   * @return The createCloudInstance.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.CreateCloudInstanceAction getCreateCloudInstance() {
    if (actionCase_ == 6) {
      return (com.google.spanner.executor.v1.CreateCloudInstanceAction) action_;
    }
    return com.google.spanner.executor.v1.CreateCloudInstanceAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action that creates a Cloud Spanner instance.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.CreateCloudInstanceAction create_cloud_instance = 6;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.CreateCloudInstanceActionOrBuilder
      getCreateCloudInstanceOrBuilder() {
    if (actionCase_ == 6) {
      return (com.google.spanner.executor.v1.CreateCloudInstanceAction) action_;
    }
    return com.google.spanner.executor.v1.CreateCloudInstanceAction.getDefaultInstance();
  }

  public static final int UPDATE_CLOUD_INSTANCE_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Action that updates a Cloud Spanner instance.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.UpdateCloudInstanceAction update_cloud_instance = 7;</code>
   *
   * @return Whether the updateCloudInstance field is set.
   */
  @java.lang.Override
  public boolean hasUpdateCloudInstance() {
    return actionCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Action that updates a Cloud Spanner instance.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.UpdateCloudInstanceAction update_cloud_instance = 7;</code>
   *
   * @return The updateCloudInstance.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.UpdateCloudInstanceAction getUpdateCloudInstance() {
    if (actionCase_ == 7) {
      return (com.google.spanner.executor.v1.UpdateCloudInstanceAction) action_;
    }
    return com.google.spanner.executor.v1.UpdateCloudInstanceAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action that updates a Cloud Spanner instance.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.UpdateCloudInstanceAction update_cloud_instance = 7;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.UpdateCloudInstanceActionOrBuilder
      getUpdateCloudInstanceOrBuilder() {
    if (actionCase_ == 7) {
      return (com.google.spanner.executor.v1.UpdateCloudInstanceAction) action_;
    }
    return com.google.spanner.executor.v1.UpdateCloudInstanceAction.getDefaultInstance();
  }

  public static final int DELETE_CLOUD_INSTANCE_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Action that deletes a Cloud Spanner instance.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.DeleteCloudInstanceAction delete_cloud_instance = 8;</code>
   *
   * @return Whether the deleteCloudInstance field is set.
   */
  @java.lang.Override
  public boolean hasDeleteCloudInstance() {
    return actionCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * Action that deletes a Cloud Spanner instance.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.DeleteCloudInstanceAction delete_cloud_instance = 8;</code>
   *
   * @return The deleteCloudInstance.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.DeleteCloudInstanceAction getDeleteCloudInstance() {
    if (actionCase_ == 8) {
      return (com.google.spanner.executor.v1.DeleteCloudInstanceAction) action_;
    }
    return com.google.spanner.executor.v1.DeleteCloudInstanceAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action that deletes a Cloud Spanner instance.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.DeleteCloudInstanceAction delete_cloud_instance = 8;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.DeleteCloudInstanceActionOrBuilder
      getDeleteCloudInstanceOrBuilder() {
    if (actionCase_ == 8) {
      return (com.google.spanner.executor.v1.DeleteCloudInstanceAction) action_;
    }
    return com.google.spanner.executor.v1.DeleteCloudInstanceAction.getDefaultInstance();
  }

  public static final int LIST_CLOUD_INSTANCES_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Action that lists Cloud Spanner instances.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ListCloudInstancesAction list_cloud_instances = 9;</code>
   *
   * @return Whether the listCloudInstances field is set.
   */
  @java.lang.Override
  public boolean hasListCloudInstances() {
    return actionCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Action that lists Cloud Spanner instances.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ListCloudInstancesAction list_cloud_instances = 9;</code>
   *
   * @return The listCloudInstances.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ListCloudInstancesAction getListCloudInstances() {
    if (actionCase_ == 9) {
      return (com.google.spanner.executor.v1.ListCloudInstancesAction) action_;
    }
    return com.google.spanner.executor.v1.ListCloudInstancesAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action that lists Cloud Spanner instances.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ListCloudInstancesAction list_cloud_instances = 9;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ListCloudInstancesActionOrBuilder
      getListCloudInstancesOrBuilder() {
    if (actionCase_ == 9) {
      return (com.google.spanner.executor.v1.ListCloudInstancesAction) action_;
    }
    return com.google.spanner.executor.v1.ListCloudInstancesAction.getDefaultInstance();
  }

  public static final int GET_CLOUD_INSTANCE_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * Action that retrieves a Cloud Spanner instance.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.GetCloudInstanceAction get_cloud_instance = 10;</code>
   *
   * @return Whether the getCloudInstance field is set.
   */
  @java.lang.Override
  public boolean hasGetCloudInstance() {
    return actionCase_ == 10;
  }
  /**
   *
   *
   * <pre>
   * Action that retrieves a Cloud Spanner instance.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.GetCloudInstanceAction get_cloud_instance = 10;</code>
   *
   * @return The getCloudInstance.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.GetCloudInstanceAction getGetCloudInstance() {
    if (actionCase_ == 10) {
      return (com.google.spanner.executor.v1.GetCloudInstanceAction) action_;
    }
    return com.google.spanner.executor.v1.GetCloudInstanceAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action that retrieves a Cloud Spanner instance.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.GetCloudInstanceAction get_cloud_instance = 10;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.GetCloudInstanceActionOrBuilder
      getGetCloudInstanceOrBuilder() {
    if (actionCase_ == 10) {
      return (com.google.spanner.executor.v1.GetCloudInstanceAction) action_;
    }
    return com.google.spanner.executor.v1.GetCloudInstanceAction.getDefaultInstance();
  }

  public static final int CREATE_CLOUD_DATABASE_FIELD_NUMBER = 11;
  /**
   *
   *
   * <pre>
   * Action that creates a Cloud Spanner database.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.CreateCloudDatabaseAction create_cloud_database = 11;</code>
   *
   * @return Whether the createCloudDatabase field is set.
   */
  @java.lang.Override
  public boolean hasCreateCloudDatabase() {
    return actionCase_ == 11;
  }
  /**
   *
   *
   * <pre>
   * Action that creates a Cloud Spanner database.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.CreateCloudDatabaseAction create_cloud_database = 11;</code>
   *
   * @return The createCloudDatabase.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.CreateCloudDatabaseAction getCreateCloudDatabase() {
    if (actionCase_ == 11) {
      return (com.google.spanner.executor.v1.CreateCloudDatabaseAction) action_;
    }
    return com.google.spanner.executor.v1.CreateCloudDatabaseAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action that creates a Cloud Spanner database.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.CreateCloudDatabaseAction create_cloud_database = 11;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.CreateCloudDatabaseActionOrBuilder
      getCreateCloudDatabaseOrBuilder() {
    if (actionCase_ == 11) {
      return (com.google.spanner.executor.v1.CreateCloudDatabaseAction) action_;
    }
    return com.google.spanner.executor.v1.CreateCloudDatabaseAction.getDefaultInstance();
  }

  public static final int UPDATE_CLOUD_DATABASE_DDL_FIELD_NUMBER = 12;
  /**
   *
   *
   * <pre>
   * Action that updates the schema of a Cloud Spanner database.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction update_cloud_database_ddl = 12;
   * </code>
   *
   * @return Whether the updateCloudDatabaseDdl field is set.
   */
  @java.lang.Override
  public boolean hasUpdateCloudDatabaseDdl() {
    return actionCase_ == 12;
  }
  /**
   *
   *
   * <pre>
   * Action that updates the schema of a Cloud Spanner database.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction update_cloud_database_ddl = 12;
   * </code>
   *
   * @return The updateCloudDatabaseDdl.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction getUpdateCloudDatabaseDdl() {
    if (actionCase_ == 12) {
      return (com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction) action_;
    }
    return com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action that updates the schema of a Cloud Spanner database.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction update_cloud_database_ddl = 12;
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.UpdateCloudDatabaseDdlActionOrBuilder
      getUpdateCloudDatabaseDdlOrBuilder() {
    if (actionCase_ == 12) {
      return (com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction) action_;
    }
    return com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction.getDefaultInstance();
  }

  public static final int UPDATE_CLOUD_DATABASE_FIELD_NUMBER = 27;
  /**
   *
   *
   * <pre>
   * Action that updates the schema of a Cloud Spanner database.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.UpdateCloudDatabaseAction update_cloud_database = 27;</code>
   *
   * @return Whether the updateCloudDatabase field is set.
   */
  @java.lang.Override
  public boolean hasUpdateCloudDatabase() {
    return actionCase_ == 27;
  }
  /**
   *
   *
   * <pre>
   * Action that updates the schema of a Cloud Spanner database.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.UpdateCloudDatabaseAction update_cloud_database = 27;</code>
   *
   * @return The updateCloudDatabase.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.UpdateCloudDatabaseAction getUpdateCloudDatabase() {
    if (actionCase_ == 27) {
      return (com.google.spanner.executor.v1.UpdateCloudDatabaseAction) action_;
    }
    return com.google.spanner.executor.v1.UpdateCloudDatabaseAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action that updates the schema of a Cloud Spanner database.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.UpdateCloudDatabaseAction update_cloud_database = 27;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.UpdateCloudDatabaseActionOrBuilder
      getUpdateCloudDatabaseOrBuilder() {
    if (actionCase_ == 27) {
      return (com.google.spanner.executor.v1.UpdateCloudDatabaseAction) action_;
    }
    return com.google.spanner.executor.v1.UpdateCloudDatabaseAction.getDefaultInstance();
  }

  public static final int DROP_CLOUD_DATABASE_FIELD_NUMBER = 13;
  /**
   *
   *
   * <pre>
   * Action that drops a Cloud Spanner database.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.DropCloudDatabaseAction drop_cloud_database = 13;</code>
   *
   * @return Whether the dropCloudDatabase field is set.
   */
  @java.lang.Override
  public boolean hasDropCloudDatabase() {
    return actionCase_ == 13;
  }
  /**
   *
   *
   * <pre>
   * Action that drops a Cloud Spanner database.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.DropCloudDatabaseAction drop_cloud_database = 13;</code>
   *
   * @return The dropCloudDatabase.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.DropCloudDatabaseAction getDropCloudDatabase() {
    if (actionCase_ == 13) {
      return (com.google.spanner.executor.v1.DropCloudDatabaseAction) action_;
    }
    return com.google.spanner.executor.v1.DropCloudDatabaseAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action that drops a Cloud Spanner database.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.DropCloudDatabaseAction drop_cloud_database = 13;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.DropCloudDatabaseActionOrBuilder
      getDropCloudDatabaseOrBuilder() {
    if (actionCase_ == 13) {
      return (com.google.spanner.executor.v1.DropCloudDatabaseAction) action_;
    }
    return com.google.spanner.executor.v1.DropCloudDatabaseAction.getDefaultInstance();
  }

  public static final int LIST_CLOUD_DATABASES_FIELD_NUMBER = 14;
  /**
   *
   *
   * <pre>
   * Action that lists Cloud Spanner databases.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ListCloudDatabasesAction list_cloud_databases = 14;</code>
   *
   * @return Whether the listCloudDatabases field is set.
   */
  @java.lang.Override
  public boolean hasListCloudDatabases() {
    return actionCase_ == 14;
  }
  /**
   *
   *
   * <pre>
   * Action that lists Cloud Spanner databases.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ListCloudDatabasesAction list_cloud_databases = 14;</code>
   *
   * @return The listCloudDatabases.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ListCloudDatabasesAction getListCloudDatabases() {
    if (actionCase_ == 14) {
      return (com.google.spanner.executor.v1.ListCloudDatabasesAction) action_;
    }
    return com.google.spanner.executor.v1.ListCloudDatabasesAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action that lists Cloud Spanner databases.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ListCloudDatabasesAction list_cloud_databases = 14;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ListCloudDatabasesActionOrBuilder
      getListCloudDatabasesOrBuilder() {
    if (actionCase_ == 14) {
      return (com.google.spanner.executor.v1.ListCloudDatabasesAction) action_;
    }
    return com.google.spanner.executor.v1.ListCloudDatabasesAction.getDefaultInstance();
  }

  public static final int LIST_CLOUD_DATABASE_OPERATIONS_FIELD_NUMBER = 15;
  /**
   *
   *
   * <pre>
   * Action that lists Cloud Spanner database operations.
   * </pre>
   *
   * <code>
   * .google.spanner.executor.v1.ListCloudDatabaseOperationsAction list_cloud_database_operations = 15;
   * </code>
   *
   * @return Whether the listCloudDatabaseOperations field is set.
   */
  @java.lang.Override
  public boolean hasListCloudDatabaseOperations() {
    return actionCase_ == 15;
  }
  /**
   *
   *
   * <pre>
   * Action that lists Cloud Spanner database operations.
   * </pre>
   *
   * <code>
   * .google.spanner.executor.v1.ListCloudDatabaseOperationsAction list_cloud_database_operations = 15;
   * </code>
   *
   * @return The listCloudDatabaseOperations.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ListCloudDatabaseOperationsAction
      getListCloudDatabaseOperations() {
    if (actionCase_ == 15) {
      return (com.google.spanner.executor.v1.ListCloudDatabaseOperationsAction) action_;
    }
    return com.google.spanner.executor.v1.ListCloudDatabaseOperationsAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action that lists Cloud Spanner database operations.
   * </pre>
   *
   * <code>
   * .google.spanner.executor.v1.ListCloudDatabaseOperationsAction list_cloud_database_operations = 15;
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ListCloudDatabaseOperationsActionOrBuilder
      getListCloudDatabaseOperationsOrBuilder() {
    if (actionCase_ == 15) {
      return (com.google.spanner.executor.v1.ListCloudDatabaseOperationsAction) action_;
    }
    return com.google.spanner.executor.v1.ListCloudDatabaseOperationsAction.getDefaultInstance();
  }

  public static final int RESTORE_CLOUD_DATABASE_FIELD_NUMBER = 16;
  /**
   *
   *
   * <pre>
   * Action that restores a Cloud Spanner database from a backup.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.RestoreCloudDatabaseAction restore_cloud_database = 16;
   * </code>
   *
   * @return Whether the restoreCloudDatabase field is set.
   */
  @java.lang.Override
  public boolean hasRestoreCloudDatabase() {
    return actionCase_ == 16;
  }
  /**
   *
   *
   * <pre>
   * Action that restores a Cloud Spanner database from a backup.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.RestoreCloudDatabaseAction restore_cloud_database = 16;
   * </code>
   *
   * @return The restoreCloudDatabase.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.RestoreCloudDatabaseAction getRestoreCloudDatabase() {
    if (actionCase_ == 16) {
      return (com.google.spanner.executor.v1.RestoreCloudDatabaseAction) action_;
    }
    return com.google.spanner.executor.v1.RestoreCloudDatabaseAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action that restores a Cloud Spanner database from a backup.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.RestoreCloudDatabaseAction restore_cloud_database = 16;
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.RestoreCloudDatabaseActionOrBuilder
      getRestoreCloudDatabaseOrBuilder() {
    if (actionCase_ == 16) {
      return (com.google.spanner.executor.v1.RestoreCloudDatabaseAction) action_;
    }
    return com.google.spanner.executor.v1.RestoreCloudDatabaseAction.getDefaultInstance();
  }

  public static final int GET_CLOUD_DATABASE_FIELD_NUMBER = 17;
  /**
   *
   *
   * <pre>
   * Action that gets a Cloud Spanner database.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.GetCloudDatabaseAction get_cloud_database = 17;</code>
   *
   * @return Whether the getCloudDatabase field is set.
   */
  @java.lang.Override
  public boolean hasGetCloudDatabase() {
    return actionCase_ == 17;
  }
  /**
   *
   *
   * <pre>
   * Action that gets a Cloud Spanner database.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.GetCloudDatabaseAction get_cloud_database = 17;</code>
   *
   * @return The getCloudDatabase.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.GetCloudDatabaseAction getGetCloudDatabase() {
    if (actionCase_ == 17) {
      return (com.google.spanner.executor.v1.GetCloudDatabaseAction) action_;
    }
    return com.google.spanner.executor.v1.GetCloudDatabaseAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action that gets a Cloud Spanner database.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.GetCloudDatabaseAction get_cloud_database = 17;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.GetCloudDatabaseActionOrBuilder
      getGetCloudDatabaseOrBuilder() {
    if (actionCase_ == 17) {
      return (com.google.spanner.executor.v1.GetCloudDatabaseAction) action_;
    }
    return com.google.spanner.executor.v1.GetCloudDatabaseAction.getDefaultInstance();
  }

  public static final int CREATE_CLOUD_BACKUP_FIELD_NUMBER = 18;
  /**
   *
   *
   * <pre>
   * Action that creates a Cloud Spanner database backup.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.CreateCloudBackupAction create_cloud_backup = 18;</code>
   *
   * @return Whether the createCloudBackup field is set.
   */
  @java.lang.Override
  public boolean hasCreateCloudBackup() {
    return actionCase_ == 18;
  }
  /**
   *
   *
   * <pre>
   * Action that creates a Cloud Spanner database backup.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.CreateCloudBackupAction create_cloud_backup = 18;</code>
   *
   * @return The createCloudBackup.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.CreateCloudBackupAction getCreateCloudBackup() {
    if (actionCase_ == 18) {
      return (com.google.spanner.executor.v1.CreateCloudBackupAction) action_;
    }
    return com.google.spanner.executor.v1.CreateCloudBackupAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action that creates a Cloud Spanner database backup.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.CreateCloudBackupAction create_cloud_backup = 18;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.CreateCloudBackupActionOrBuilder
      getCreateCloudBackupOrBuilder() {
    if (actionCase_ == 18) {
      return (com.google.spanner.executor.v1.CreateCloudBackupAction) action_;
    }
    return com.google.spanner.executor.v1.CreateCloudBackupAction.getDefaultInstance();
  }

  public static final int COPY_CLOUD_BACKUP_FIELD_NUMBER = 19;
  /**
   *
   *
   * <pre>
   * Action that copies a Cloud Spanner database backup.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.CopyCloudBackupAction copy_cloud_backup = 19;</code>
   *
   * @return Whether the copyCloudBackup field is set.
   */
  @java.lang.Override
  public boolean hasCopyCloudBackup() {
    return actionCase_ == 19;
  }
  /**
   *
   *
   * <pre>
   * Action that copies a Cloud Spanner database backup.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.CopyCloudBackupAction copy_cloud_backup = 19;</code>
   *
   * @return The copyCloudBackup.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.CopyCloudBackupAction getCopyCloudBackup() {
    if (actionCase_ == 19) {
      return (com.google.spanner.executor.v1.CopyCloudBackupAction) action_;
    }
    return com.google.spanner.executor.v1.CopyCloudBackupAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action that copies a Cloud Spanner database backup.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.CopyCloudBackupAction copy_cloud_backup = 19;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.CopyCloudBackupActionOrBuilder
      getCopyCloudBackupOrBuilder() {
    if (actionCase_ == 19) {
      return (com.google.spanner.executor.v1.CopyCloudBackupAction) action_;
    }
    return com.google.spanner.executor.v1.CopyCloudBackupAction.getDefaultInstance();
  }

  public static final int GET_CLOUD_BACKUP_FIELD_NUMBER = 20;
  /**
   *
   *
   * <pre>
   * Action that gets a Cloud Spanner database backup.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.GetCloudBackupAction get_cloud_backup = 20;</code>
   *
   * @return Whether the getCloudBackup field is set.
   */
  @java.lang.Override
  public boolean hasGetCloudBackup() {
    return actionCase_ == 20;
  }
  /**
   *
   *
   * <pre>
   * Action that gets a Cloud Spanner database backup.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.GetCloudBackupAction get_cloud_backup = 20;</code>
   *
   * @return The getCloudBackup.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.GetCloudBackupAction getGetCloudBackup() {
    if (actionCase_ == 20) {
      return (com.google.spanner.executor.v1.GetCloudBackupAction) action_;
    }
    return com.google.spanner.executor.v1.GetCloudBackupAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action that gets a Cloud Spanner database backup.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.GetCloudBackupAction get_cloud_backup = 20;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.GetCloudBackupActionOrBuilder getGetCloudBackupOrBuilder() {
    if (actionCase_ == 20) {
      return (com.google.spanner.executor.v1.GetCloudBackupAction) action_;
    }
    return com.google.spanner.executor.v1.GetCloudBackupAction.getDefaultInstance();
  }

  public static final int UPDATE_CLOUD_BACKUP_FIELD_NUMBER = 21;
  /**
   *
   *
   * <pre>
   * Action that updates a Cloud Spanner database backup.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.UpdateCloudBackupAction update_cloud_backup = 21;</code>
   *
   * @return Whether the updateCloudBackup field is set.
   */
  @java.lang.Override
  public boolean hasUpdateCloudBackup() {
    return actionCase_ == 21;
  }
  /**
   *
   *
   * <pre>
   * Action that updates a Cloud Spanner database backup.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.UpdateCloudBackupAction update_cloud_backup = 21;</code>
   *
   * @return The updateCloudBackup.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.UpdateCloudBackupAction getUpdateCloudBackup() {
    if (actionCase_ == 21) {
      return (com.google.spanner.executor.v1.UpdateCloudBackupAction) action_;
    }
    return com.google.spanner.executor.v1.UpdateCloudBackupAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action that updates a Cloud Spanner database backup.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.UpdateCloudBackupAction update_cloud_backup = 21;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.UpdateCloudBackupActionOrBuilder
      getUpdateCloudBackupOrBuilder() {
    if (actionCase_ == 21) {
      return (com.google.spanner.executor.v1.UpdateCloudBackupAction) action_;
    }
    return com.google.spanner.executor.v1.UpdateCloudBackupAction.getDefaultInstance();
  }

  public static final int DELETE_CLOUD_BACKUP_FIELD_NUMBER = 22;
  /**
   *
   *
   * <pre>
   * Action that deletes a Cloud Spanner database backup.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.DeleteCloudBackupAction delete_cloud_backup = 22;</code>
   *
   * @return Whether the deleteCloudBackup field is set.
   */
  @java.lang.Override
  public boolean hasDeleteCloudBackup() {
    return actionCase_ == 22;
  }
  /**
   *
   *
   * <pre>
   * Action that deletes a Cloud Spanner database backup.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.DeleteCloudBackupAction delete_cloud_backup = 22;</code>
   *
   * @return The deleteCloudBackup.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.DeleteCloudBackupAction getDeleteCloudBackup() {
    if (actionCase_ == 22) {
      return (com.google.spanner.executor.v1.DeleteCloudBackupAction) action_;
    }
    return com.google.spanner.executor.v1.DeleteCloudBackupAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action that deletes a Cloud Spanner database backup.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.DeleteCloudBackupAction delete_cloud_backup = 22;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.DeleteCloudBackupActionOrBuilder
      getDeleteCloudBackupOrBuilder() {
    if (actionCase_ == 22) {
      return (com.google.spanner.executor.v1.DeleteCloudBackupAction) action_;
    }
    return com.google.spanner.executor.v1.DeleteCloudBackupAction.getDefaultInstance();
  }

  public static final int LIST_CLOUD_BACKUPS_FIELD_NUMBER = 23;
  /**
   *
   *
   * <pre>
   * Action that lists Cloud Spanner database backups.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ListCloudBackupsAction list_cloud_backups = 23;</code>
   *
   * @return Whether the listCloudBackups field is set.
   */
  @java.lang.Override
  public boolean hasListCloudBackups() {
    return actionCase_ == 23;
  }
  /**
   *
   *
   * <pre>
   * Action that lists Cloud Spanner database backups.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ListCloudBackupsAction list_cloud_backups = 23;</code>
   *
   * @return The listCloudBackups.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ListCloudBackupsAction getListCloudBackups() {
    if (actionCase_ == 23) {
      return (com.google.spanner.executor.v1.ListCloudBackupsAction) action_;
    }
    return com.google.spanner.executor.v1.ListCloudBackupsAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action that lists Cloud Spanner database backups.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ListCloudBackupsAction list_cloud_backups = 23;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ListCloudBackupsActionOrBuilder
      getListCloudBackupsOrBuilder() {
    if (actionCase_ == 23) {
      return (com.google.spanner.executor.v1.ListCloudBackupsAction) action_;
    }
    return com.google.spanner.executor.v1.ListCloudBackupsAction.getDefaultInstance();
  }

  public static final int LIST_CLOUD_BACKUP_OPERATIONS_FIELD_NUMBER = 24;
  /**
   *
   *
   * <pre>
   * Action that lists Cloud Spanner database backup operations.
   * </pre>
   *
   * <code>
   * .google.spanner.executor.v1.ListCloudBackupOperationsAction list_cloud_backup_operations = 24;
   * </code>
   *
   * @return Whether the listCloudBackupOperations field is set.
   */
  @java.lang.Override
  public boolean hasListCloudBackupOperations() {
    return actionCase_ == 24;
  }
  /**
   *
   *
   * <pre>
   * Action that lists Cloud Spanner database backup operations.
   * </pre>
   *
   * <code>
   * .google.spanner.executor.v1.ListCloudBackupOperationsAction list_cloud_backup_operations = 24;
   * </code>
   *
   * @return The listCloudBackupOperations.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ListCloudBackupOperationsAction
      getListCloudBackupOperations() {
    if (actionCase_ == 24) {
      return (com.google.spanner.executor.v1.ListCloudBackupOperationsAction) action_;
    }
    return com.google.spanner.executor.v1.ListCloudBackupOperationsAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action that lists Cloud Spanner database backup operations.
   * </pre>
   *
   * <code>
   * .google.spanner.executor.v1.ListCloudBackupOperationsAction list_cloud_backup_operations = 24;
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ListCloudBackupOperationsActionOrBuilder
      getListCloudBackupOperationsOrBuilder() {
    if (actionCase_ == 24) {
      return (com.google.spanner.executor.v1.ListCloudBackupOperationsAction) action_;
    }
    return com.google.spanner.executor.v1.ListCloudBackupOperationsAction.getDefaultInstance();
  }

  public static final int GET_OPERATION_FIELD_NUMBER = 25;
  /**
   *
   *
   * <pre>
   * Action that gets an operation.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.GetOperationAction get_operation = 25;</code>
   *
   * @return Whether the getOperation field is set.
   */
  @java.lang.Override
  public boolean hasGetOperation() {
    return actionCase_ == 25;
  }
  /**
   *
   *
   * <pre>
   * Action that gets an operation.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.GetOperationAction get_operation = 25;</code>
   *
   * @return The getOperation.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.GetOperationAction getGetOperation() {
    if (actionCase_ == 25) {
      return (com.google.spanner.executor.v1.GetOperationAction) action_;
    }
    return com.google.spanner.executor.v1.GetOperationAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action that gets an operation.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.GetOperationAction get_operation = 25;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.GetOperationActionOrBuilder getGetOperationOrBuilder() {
    if (actionCase_ == 25) {
      return (com.google.spanner.executor.v1.GetOperationAction) action_;
    }
    return com.google.spanner.executor.v1.GetOperationAction.getDefaultInstance();
  }

  public static final int CANCEL_OPERATION_FIELD_NUMBER = 26;
  /**
   *
   *
   * <pre>
   * Action that cancels an operation.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.CancelOperationAction cancel_operation = 26;</code>
   *
   * @return Whether the cancelOperation field is set.
   */
  @java.lang.Override
  public boolean hasCancelOperation() {
    return actionCase_ == 26;
  }
  /**
   *
   *
   * <pre>
   * Action that cancels an operation.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.CancelOperationAction cancel_operation = 26;</code>
   *
   * @return The cancelOperation.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.CancelOperationAction getCancelOperation() {
    if (actionCase_ == 26) {
      return (com.google.spanner.executor.v1.CancelOperationAction) action_;
    }
    return com.google.spanner.executor.v1.CancelOperationAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action that cancels an operation.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.CancelOperationAction cancel_operation = 26;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.CancelOperationActionOrBuilder
      getCancelOperationOrBuilder() {
    if (actionCase_ == 26) {
      return (com.google.spanner.executor.v1.CancelOperationAction) action_;
    }
    return com.google.spanner.executor.v1.CancelOperationAction.getDefaultInstance();
  }

  public static final int CHANGE_QUORUM_CLOUD_DATABASE_FIELD_NUMBER = 28;
  /**
   *
   *
   * <pre>
   * Action that changes quorum of a Cloud Spanner database.
   * </pre>
   *
   * <code>
   * .google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction change_quorum_cloud_database = 28;
   * </code>
   *
   * @return Whether the changeQuorumCloudDatabase field is set.
   */
  @java.lang.Override
  public boolean hasChangeQuorumCloudDatabase() {
    return actionCase_ == 28;
  }
  /**
   *
   *
   * <pre>
   * Action that changes quorum of a Cloud Spanner database.
   * </pre>
   *
   * <code>
   * .google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction change_quorum_cloud_database = 28;
   * </code>
   *
   * @return The changeQuorumCloudDatabase.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction
      getChangeQuorumCloudDatabase() {
    if (actionCase_ == 28) {
      return (com.google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction) action_;
    }
    return com.google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action that changes quorum of a Cloud Spanner database.
   * </pre>
   *
   * <code>
   * .google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction change_quorum_cloud_database = 28;
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ChangeQuorumCloudDatabaseActionOrBuilder
      getChangeQuorumCloudDatabaseOrBuilder() {
    if (actionCase_ == 28) {
      return (com.google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction) action_;
    }
    return com.google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (actionCase_ == 1) {
      output.writeMessage(
          1, (com.google.spanner.executor.v1.CreateUserInstanceConfigAction) action_);
    }
    if (actionCase_ == 2) {
      output.writeMessage(
          2, (com.google.spanner.executor.v1.UpdateUserInstanceConfigAction) action_);
    }
    if (actionCase_ == 3) {
      output.writeMessage(
          3, (com.google.spanner.executor.v1.DeleteUserInstanceConfigAction) action_);
    }
    if (actionCase_ == 4) {
      output.writeMessage(4, (com.google.spanner.executor.v1.GetCloudInstanceConfigAction) action_);
    }
    if (actionCase_ == 5) {
      output.writeMessage(
          5, (com.google.spanner.executor.v1.ListCloudInstanceConfigsAction) action_);
    }
    if (actionCase_ == 6) {
      output.writeMessage(6, (com.google.spanner.executor.v1.CreateCloudInstanceAction) action_);
    }
    if (actionCase_ == 7) {
      output.writeMessage(7, (com.google.spanner.executor.v1.UpdateCloudInstanceAction) action_);
    }
    if (actionCase_ == 8) {
      output.writeMessage(8, (com.google.spanner.executor.v1.DeleteCloudInstanceAction) action_);
    }
    if (actionCase_ == 9) {
      output.writeMessage(9, (com.google.spanner.executor.v1.ListCloudInstancesAction) action_);
    }
    if (actionCase_ == 10) {
      output.writeMessage(10, (com.google.spanner.executor.v1.GetCloudInstanceAction) action_);
    }
    if (actionCase_ == 11) {
      output.writeMessage(11, (com.google.spanner.executor.v1.CreateCloudDatabaseAction) action_);
    }
    if (actionCase_ == 12) {
      output.writeMessage(
          12, (com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction) action_);
    }
    if (actionCase_ == 13) {
      output.writeMessage(13, (com.google.spanner.executor.v1.DropCloudDatabaseAction) action_);
    }
    if (actionCase_ == 14) {
      output.writeMessage(14, (com.google.spanner.executor.v1.ListCloudDatabasesAction) action_);
    }
    if (actionCase_ == 15) {
      output.writeMessage(
          15, (com.google.spanner.executor.v1.ListCloudDatabaseOperationsAction) action_);
    }
    if (actionCase_ == 16) {
      output.writeMessage(16, (com.google.spanner.executor.v1.RestoreCloudDatabaseAction) action_);
    }
    if (actionCase_ == 17) {
      output.writeMessage(17, (com.google.spanner.executor.v1.GetCloudDatabaseAction) action_);
    }
    if (actionCase_ == 18) {
      output.writeMessage(18, (com.google.spanner.executor.v1.CreateCloudBackupAction) action_);
    }
    if (actionCase_ == 19) {
      output.writeMessage(19, (com.google.spanner.executor.v1.CopyCloudBackupAction) action_);
    }
    if (actionCase_ == 20) {
      output.writeMessage(20, (com.google.spanner.executor.v1.GetCloudBackupAction) action_);
    }
    if (actionCase_ == 21) {
      output.writeMessage(21, (com.google.spanner.executor.v1.UpdateCloudBackupAction) action_);
    }
    if (actionCase_ == 22) {
      output.writeMessage(22, (com.google.spanner.executor.v1.DeleteCloudBackupAction) action_);
    }
    if (actionCase_ == 23) {
      output.writeMessage(23, (com.google.spanner.executor.v1.ListCloudBackupsAction) action_);
    }
    if (actionCase_ == 24) {
      output.writeMessage(
          24, (com.google.spanner.executor.v1.ListCloudBackupOperationsAction) action_);
    }
    if (actionCase_ == 25) {
      output.writeMessage(25, (com.google.spanner.executor.v1.GetOperationAction) action_);
    }
    if (actionCase_ == 26) {
      output.writeMessage(26, (com.google.spanner.executor.v1.CancelOperationAction) action_);
    }
    if (actionCase_ == 27) {
      output.writeMessage(27, (com.google.spanner.executor.v1.UpdateCloudDatabaseAction) action_);
    }
    if (actionCase_ == 28) {
      output.writeMessage(
          28, (com.google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction) action_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (actionCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.spanner.executor.v1.CreateUserInstanceConfigAction) action_);
    }
    if (actionCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.spanner.executor.v1.UpdateUserInstanceConfigAction) action_);
    }
    if (actionCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.spanner.executor.v1.DeleteUserInstanceConfigAction) action_);
    }
    if (actionCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.spanner.executor.v1.GetCloudInstanceConfigAction) action_);
    }
    if (actionCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.spanner.executor.v1.ListCloudInstanceConfigsAction) action_);
    }
    if (actionCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.spanner.executor.v1.CreateCloudInstanceAction) action_);
    }
    if (actionCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.spanner.executor.v1.UpdateCloudInstanceAction) action_);
    }
    if (actionCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.spanner.executor.v1.DeleteCloudInstanceAction) action_);
    }
    if (actionCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, (com.google.spanner.executor.v1.ListCloudInstancesAction) action_);
    }
    if (actionCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, (com.google.spanner.executor.v1.GetCloudInstanceAction) action_);
    }
    if (actionCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, (com.google.spanner.executor.v1.CreateCloudDatabaseAction) action_);
    }
    if (actionCase_ == 12) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12, (com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction) action_);
    }
    if (actionCase_ == 13) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13, (com.google.spanner.executor.v1.DropCloudDatabaseAction) action_);
    }
    if (actionCase_ == 14) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              14, (com.google.spanner.executor.v1.ListCloudDatabasesAction) action_);
    }
    if (actionCase_ == 15) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              15, (com.google.spanner.executor.v1.ListCloudDatabaseOperationsAction) action_);
    }
    if (actionCase_ == 16) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              16, (com.google.spanner.executor.v1.RestoreCloudDatabaseAction) action_);
    }
    if (actionCase_ == 17) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              17, (com.google.spanner.executor.v1.GetCloudDatabaseAction) action_);
    }
    if (actionCase_ == 18) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              18, (com.google.spanner.executor.v1.CreateCloudBackupAction) action_);
    }
    if (actionCase_ == 19) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              19, (com.google.spanner.executor.v1.CopyCloudBackupAction) action_);
    }
    if (actionCase_ == 20) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              20, (com.google.spanner.executor.v1.GetCloudBackupAction) action_);
    }
    if (actionCase_ == 21) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              21, (com.google.spanner.executor.v1.UpdateCloudBackupAction) action_);
    }
    if (actionCase_ == 22) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              22, (com.google.spanner.executor.v1.DeleteCloudBackupAction) action_);
    }
    if (actionCase_ == 23) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              23, (com.google.spanner.executor.v1.ListCloudBackupsAction) action_);
    }
    if (actionCase_ == 24) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              24, (com.google.spanner.executor.v1.ListCloudBackupOperationsAction) action_);
    }
    if (actionCase_ == 25) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              25, (com.google.spanner.executor.v1.GetOperationAction) action_);
    }
    if (actionCase_ == 26) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              26, (com.google.spanner.executor.v1.CancelOperationAction) action_);
    }
    if (actionCase_ == 27) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              27, (com.google.spanner.executor.v1.UpdateCloudDatabaseAction) action_);
    }
    if (actionCase_ == 28) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              28, (com.google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction) action_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.executor.v1.AdminAction)) {
      return super.equals(obj);
    }
    com.google.spanner.executor.v1.AdminAction other =
        (com.google.spanner.executor.v1.AdminAction) obj;

    if (!getActionCase().equals(other.getActionCase())) return false;
    switch (actionCase_) {
      case 1:
        if (!getCreateUserInstanceConfig().equals(other.getCreateUserInstanceConfig()))
          return false;
        break;
      case 2:
        if (!getUpdateUserInstanceConfig().equals(other.getUpdateUserInstanceConfig()))
          return false;
        break;
      case 3:
        if (!getDeleteUserInstanceConfig().equals(other.getDeleteUserInstanceConfig()))
          return false;
        break;
      case 4:
        if (!getGetCloudInstanceConfig().equals(other.getGetCloudInstanceConfig())) return false;
        break;
      case 5:
        if (!getListInstanceConfigs().equals(other.getListInstanceConfigs())) return false;
        break;
      case 6:
        if (!getCreateCloudInstance().equals(other.getCreateCloudInstance())) return false;
        break;
      case 7:
        if (!getUpdateCloudInstance().equals(other.getUpdateCloudInstance())) return false;
        break;
      case 8:
        if (!getDeleteCloudInstance().equals(other.getDeleteCloudInstance())) return false;
        break;
      case 9:
        if (!getListCloudInstances().equals(other.getListCloudInstances())) return false;
        break;
      case 10:
        if (!getGetCloudInstance().equals(other.getGetCloudInstance())) return false;
        break;
      case 11:
        if (!getCreateCloudDatabase().equals(other.getCreateCloudDatabase())) return false;
        break;
      case 12:
        if (!getUpdateCloudDatabaseDdl().equals(other.getUpdateCloudDatabaseDdl())) return false;
        break;
      case 27:
        if (!getUpdateCloudDatabase().equals(other.getUpdateCloudDatabase())) return false;
        break;
      case 13:
        if (!getDropCloudDatabase().equals(other.getDropCloudDatabase())) return false;
        break;
      case 14:
        if (!getListCloudDatabases().equals(other.getListCloudDatabases())) return false;
        break;
      case 15:
        if (!getListCloudDatabaseOperations().equals(other.getListCloudDatabaseOperations()))
          return false;
        break;
      case 16:
        if (!getRestoreCloudDatabase().equals(other.getRestoreCloudDatabase())) return false;
        break;
      case 17:
        if (!getGetCloudDatabase().equals(other.getGetCloudDatabase())) return false;
        break;
      case 18:
        if (!getCreateCloudBackup().equals(other.getCreateCloudBackup())) return false;
        break;
      case 19:
        if (!getCopyCloudBackup().equals(other.getCopyCloudBackup())) return false;
        break;
      case 20:
        if (!getGetCloudBackup().equals(other.getGetCloudBackup())) return false;
        break;
      case 21:
        if (!getUpdateCloudBackup().equals(other.getUpdateCloudBackup())) return false;
        break;
      case 22:
        if (!getDeleteCloudBackup().equals(other.getDeleteCloudBackup())) return false;
        break;
      case 23:
        if (!getListCloudBackups().equals(other.getListCloudBackups())) return false;
        break;
      case 24:
        if (!getListCloudBackupOperations().equals(other.getListCloudBackupOperations()))
          return false;
        break;
      case 25:
        if (!getGetOperation().equals(other.getGetOperation())) return false;
        break;
      case 26:
        if (!getCancelOperation().equals(other.getCancelOperation())) return false;
        break;
      case 28:
        if (!getChangeQuorumCloudDatabase().equals(other.getChangeQuorumCloudDatabase()))
          return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (actionCase_) {
      case 1:
        hash = (37 * hash) + CREATE_USER_INSTANCE_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getCreateUserInstanceConfig().hashCode();
        break;
      case 2:
        hash = (37 * hash) + UPDATE_USER_INSTANCE_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getUpdateUserInstanceConfig().hashCode();
        break;
      case 3:
        hash = (37 * hash) + DELETE_USER_INSTANCE_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getDeleteUserInstanceConfig().hashCode();
        break;
      case 4:
        hash = (37 * hash) + GET_CLOUD_INSTANCE_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getGetCloudInstanceConfig().hashCode();
        break;
      case 5:
        hash = (37 * hash) + LIST_INSTANCE_CONFIGS_FIELD_NUMBER;
        hash = (53 * hash) + getListInstanceConfigs().hashCode();
        break;
      case 6:
        hash = (37 * hash) + CREATE_CLOUD_INSTANCE_FIELD_NUMBER;
        hash = (53 * hash) + getCreateCloudInstance().hashCode();
        break;
      case 7:
        hash = (37 * hash) + UPDATE_CLOUD_INSTANCE_FIELD_NUMBER;
        hash = (53 * hash) + getUpdateCloudInstance().hashCode();
        break;
      case 8:
        hash = (37 * hash) + DELETE_CLOUD_INSTANCE_FIELD_NUMBER;
        hash = (53 * hash) + getDeleteCloudInstance().hashCode();
        break;
      case 9:
        hash = (37 * hash) + LIST_CLOUD_INSTANCES_FIELD_NUMBER;
        hash = (53 * hash) + getListCloudInstances().hashCode();
        break;
      case 10:
        hash = (37 * hash) + GET_CLOUD_INSTANCE_FIELD_NUMBER;
        hash = (53 * hash) + getGetCloudInstance().hashCode();
        break;
      case 11:
        hash = (37 * hash) + CREATE_CLOUD_DATABASE_FIELD_NUMBER;
        hash = (53 * hash) + getCreateCloudDatabase().hashCode();
        break;
      case 12:
        hash = (37 * hash) + UPDATE_CLOUD_DATABASE_DDL_FIELD_NUMBER;
        hash = (53 * hash) + getUpdateCloudDatabaseDdl().hashCode();
        break;
      case 27:
        hash = (37 * hash) + UPDATE_CLOUD_DATABASE_FIELD_NUMBER;
        hash = (53 * hash) + getUpdateCloudDatabase().hashCode();
        break;
      case 13:
        hash = (37 * hash) + DROP_CLOUD_DATABASE_FIELD_NUMBER;
        hash = (53 * hash) + getDropCloudDatabase().hashCode();
        break;
      case 14:
        hash = (37 * hash) + LIST_CLOUD_DATABASES_FIELD_NUMBER;
        hash = (53 * hash) + getListCloudDatabases().hashCode();
        break;
      case 15:
        hash = (37 * hash) + LIST_CLOUD_DATABASE_OPERATIONS_FIELD_NUMBER;
        hash = (53 * hash) + getListCloudDatabaseOperations().hashCode();
        break;
      case 16:
        hash = (37 * hash) + RESTORE_CLOUD_DATABASE_FIELD_NUMBER;
        hash = (53 * hash) + getRestoreCloudDatabase().hashCode();
        break;
      case 17:
        hash = (37 * hash) + GET_CLOUD_DATABASE_FIELD_NUMBER;
        hash = (53 * hash) + getGetCloudDatabase().hashCode();
        break;
      case 18:
        hash = (37 * hash) + CREATE_CLOUD_BACKUP_FIELD_NUMBER;
        hash = (53 * hash) + getCreateCloudBackup().hashCode();
        break;
      case 19:
        hash = (37 * hash) + COPY_CLOUD_BACKUP_FIELD_NUMBER;
        hash = (53 * hash) + getCopyCloudBackup().hashCode();
        break;
      case 20:
        hash = (37 * hash) + GET_CLOUD_BACKUP_FIELD_NUMBER;
        hash = (53 * hash) + getGetCloudBackup().hashCode();
        break;
      case 21:
        hash = (37 * hash) + UPDATE_CLOUD_BACKUP_FIELD_NUMBER;
        hash = (53 * hash) + getUpdateCloudBackup().hashCode();
        break;
      case 22:
        hash = (37 * hash) + DELETE_CLOUD_BACKUP_FIELD_NUMBER;
        hash = (53 * hash) + getDeleteCloudBackup().hashCode();
        break;
      case 23:
        hash = (37 * hash) + LIST_CLOUD_BACKUPS_FIELD_NUMBER;
        hash = (53 * hash) + getListCloudBackups().hashCode();
        break;
      case 24:
        hash = (37 * hash) + LIST_CLOUD_BACKUP_OPERATIONS_FIELD_NUMBER;
        hash = (53 * hash) + getListCloudBackupOperations().hashCode();
        break;
      case 25:
        hash = (37 * hash) + GET_OPERATION_FIELD_NUMBER;
        hash = (53 * hash) + getGetOperation().hashCode();
        break;
      case 26:
        hash = (37 * hash) + CANCEL_OPERATION_FIELD_NUMBER;
        hash = (53 * hash) + getCancelOperation().hashCode();
        break;
      case 28:
        hash = (37 * hash) + CHANGE_QUORUM_CLOUD_DATABASE_FIELD_NUMBER;
        hash = (53 * hash) + getChangeQuorumCloudDatabase().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.executor.v1.AdminAction parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.AdminAction parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.AdminAction parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.AdminAction parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.AdminAction parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.AdminAction parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.AdminAction parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.AdminAction parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.AdminAction parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.AdminAction parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.AdminAction parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.AdminAction parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.executor.v1.AdminAction prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * AdminAction defines all the cloud spanner admin actions, including
   * instance/database admin ops, backup ops and operation actions.
   * </pre>
   *
   * Protobuf type {@code google.spanner.executor.v1.AdminAction}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.executor.v1.AdminAction)
      com.google.spanner.executor.v1.AdminActionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_AdminAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_AdminAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.executor.v1.AdminAction.class,
              com.google.spanner.executor.v1.AdminAction.Builder.class);
    }

    // Construct using com.google.spanner.executor.v1.AdminAction.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (createUserInstanceConfigBuilder_ != null) {
        createUserInstanceConfigBuilder_.clear();
      }
      if (updateUserInstanceConfigBuilder_ != null) {
        updateUserInstanceConfigBuilder_.clear();
      }
      if (deleteUserInstanceConfigBuilder_ != null) {
        deleteUserInstanceConfigBuilder_.clear();
      }
      if (getCloudInstanceConfigBuilder_ != null) {
        getCloudInstanceConfigBuilder_.clear();
      }
      if (listInstanceConfigsBuilder_ != null) {
        listInstanceConfigsBuilder_.clear();
      }
      if (createCloudInstanceBuilder_ != null) {
        createCloudInstanceBuilder_.clear();
      }
      if (updateCloudInstanceBuilder_ != null) {
        updateCloudInstanceBuilder_.clear();
      }
      if (deleteCloudInstanceBuilder_ != null) {
        deleteCloudInstanceBuilder_.clear();
      }
      if (listCloudInstancesBuilder_ != null) {
        listCloudInstancesBuilder_.clear();
      }
      if (getCloudInstanceBuilder_ != null) {
        getCloudInstanceBuilder_.clear();
      }
      if (createCloudDatabaseBuilder_ != null) {
        createCloudDatabaseBuilder_.clear();
      }
      if (updateCloudDatabaseDdlBuilder_ != null) {
        updateCloudDatabaseDdlBuilder_.clear();
      }
      if (updateCloudDatabaseBuilder_ != null) {
        updateCloudDatabaseBuilder_.clear();
      }
      if (dropCloudDatabaseBuilder_ != null) {
        dropCloudDatabaseBuilder_.clear();
      }
      if (listCloudDatabasesBuilder_ != null) {
        listCloudDatabasesBuilder_.clear();
      }
      if (listCloudDatabaseOperationsBuilder_ != null) {
        listCloudDatabaseOperationsBuilder_.clear();
      }
      if (restoreCloudDatabaseBuilder_ != null) {
        restoreCloudDatabaseBuilder_.clear();
      }
      if (getCloudDatabaseBuilder_ != null) {
        getCloudDatabaseBuilder_.clear();
      }
      if (createCloudBackupBuilder_ != null) {
        createCloudBackupBuilder_.clear();
      }
      if (copyCloudBackupBuilder_ != null) {
        copyCloudBackupBuilder_.clear();
      }
      if (getCloudBackupBuilder_ != null) {
        getCloudBackupBuilder_.clear();
      }
      if (updateCloudBackupBuilder_ != null) {
        updateCloudBackupBuilder_.clear();
      }
      if (deleteCloudBackupBuilder_ != null) {
        deleteCloudBackupBuilder_.clear();
      }
      if (listCloudBackupsBuilder_ != null) {
        listCloudBackupsBuilder_.clear();
      }
      if (listCloudBackupOperationsBuilder_ != null) {
        listCloudBackupOperationsBuilder_.clear();
      }
      if (getOperationBuilder_ != null) {
        getOperationBuilder_.clear();
      }
      if (cancelOperationBuilder_ != null) {
        cancelOperationBuilder_.clear();
      }
      if (changeQuorumCloudDatabaseBuilder_ != null) {
        changeQuorumCloudDatabaseBuilder_.clear();
      }
      actionCase_ = 0;
      action_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_AdminAction_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.AdminAction getDefaultInstanceForType() {
      return com.google.spanner.executor.v1.AdminAction.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.AdminAction build() {
      com.google.spanner.executor.v1.AdminAction result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.AdminAction buildPartial() {
      com.google.spanner.executor.v1.AdminAction result =
          new com.google.spanner.executor.v1.AdminAction(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.executor.v1.AdminAction result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.spanner.executor.v1.AdminAction result) {
      result.actionCase_ = actionCase_;
      result.action_ = this.action_;
      if (actionCase_ == 1 && createUserInstanceConfigBuilder_ != null) {
        result.action_ = createUserInstanceConfigBuilder_.build();
      }
      if (actionCase_ == 2 && updateUserInstanceConfigBuilder_ != null) {
        result.action_ = updateUserInstanceConfigBuilder_.build();
      }
      if (actionCase_ == 3 && deleteUserInstanceConfigBuilder_ != null) {
        result.action_ = deleteUserInstanceConfigBuilder_.build();
      }
      if (actionCase_ == 4 && getCloudInstanceConfigBuilder_ != null) {
        result.action_ = getCloudInstanceConfigBuilder_.build();
      }
      if (actionCase_ == 5 && listInstanceConfigsBuilder_ != null) {
        result.action_ = listInstanceConfigsBuilder_.build();
      }
      if (actionCase_ == 6 && createCloudInstanceBuilder_ != null) {
        result.action_ = createCloudInstanceBuilder_.build();
      }
      if (actionCase_ == 7 && updateCloudInstanceBuilder_ != null) {
        result.action_ = updateCloudInstanceBuilder_.build();
      }
      if (actionCase_ == 8 && deleteCloudInstanceBuilder_ != null) {
        result.action_ = deleteCloudInstanceBuilder_.build();
      }
      if (actionCase_ == 9 && listCloudInstancesBuilder_ != null) {
        result.action_ = listCloudInstancesBuilder_.build();
      }
      if (actionCase_ == 10 && getCloudInstanceBuilder_ != null) {
        result.action_ = getCloudInstanceBuilder_.build();
      }
      if (actionCase_ == 11 && createCloudDatabaseBuilder_ != null) {
        result.action_ = createCloudDatabaseBuilder_.build();
      }
      if (actionCase_ == 12 && updateCloudDatabaseDdlBuilder_ != null) {
        result.action_ = updateCloudDatabaseDdlBuilder_.build();
      }
      if (actionCase_ == 27 && updateCloudDatabaseBuilder_ != null) {
        result.action_ = updateCloudDatabaseBuilder_.build();
      }
      if (actionCase_ == 13 && dropCloudDatabaseBuilder_ != null) {
        result.action_ = dropCloudDatabaseBuilder_.build();
      }
      if (actionCase_ == 14 && listCloudDatabasesBuilder_ != null) {
        result.action_ = listCloudDatabasesBuilder_.build();
      }
      if (actionCase_ == 15 && listCloudDatabaseOperationsBuilder_ != null) {
        result.action_ = listCloudDatabaseOperationsBuilder_.build();
      }
      if (actionCase_ == 16 && restoreCloudDatabaseBuilder_ != null) {
        result.action_ = restoreCloudDatabaseBuilder_.build();
      }
      if (actionCase_ == 17 && getCloudDatabaseBuilder_ != null) {
        result.action_ = getCloudDatabaseBuilder_.build();
      }
      if (actionCase_ == 18 && createCloudBackupBuilder_ != null) {
        result.action_ = createCloudBackupBuilder_.build();
      }
      if (actionCase_ == 19 && copyCloudBackupBuilder_ != null) {
        result.action_ = copyCloudBackupBuilder_.build();
      }
      if (actionCase_ == 20 && getCloudBackupBuilder_ != null) {
        result.action_ = getCloudBackupBuilder_.build();
      }
      if (actionCase_ == 21 && updateCloudBackupBuilder_ != null) {
        result.action_ = updateCloudBackupBuilder_.build();
      }
      if (actionCase_ == 22 && deleteCloudBackupBuilder_ != null) {
        result.action_ = deleteCloudBackupBuilder_.build();
      }
      if (actionCase_ == 23 && listCloudBackupsBuilder_ != null) {
        result.action_ = listCloudBackupsBuilder_.build();
      }
      if (actionCase_ == 24 && listCloudBackupOperationsBuilder_ != null) {
        result.action_ = listCloudBackupOperationsBuilder_.build();
      }
      if (actionCase_ == 25 && getOperationBuilder_ != null) {
        result.action_ = getOperationBuilder_.build();
      }
      if (actionCase_ == 26 && cancelOperationBuilder_ != null) {
        result.action_ = cancelOperationBuilder_.build();
      }
      if (actionCase_ == 28 && changeQuorumCloudDatabaseBuilder_ != null) {
        result.action_ = changeQuorumCloudDatabaseBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.executor.v1.AdminAction) {
        return mergeFrom((com.google.spanner.executor.v1.AdminAction) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.executor.v1.AdminAction other) {
      if (other == com.google.spanner.executor.v1.AdminAction.getDefaultInstance()) return this;
      switch (other.getActionCase()) {
        case CREATE_USER_INSTANCE_CONFIG:
          {
            mergeCreateUserInstanceConfig(other.getCreateUserInstanceConfig());
            break;
          }
        case UPDATE_USER_INSTANCE_CONFIG:
          {
            mergeUpdateUserInstanceConfig(other.getUpdateUserInstanceConfig());
            break;
          }
        case DELETE_USER_INSTANCE_CONFIG:
          {
            mergeDeleteUserInstanceConfig(other.getDeleteUserInstanceConfig());
            break;
          }
        case GET_CLOUD_INSTANCE_CONFIG:
          {
            mergeGetCloudInstanceConfig(other.getGetCloudInstanceConfig());
            break;
          }
        case LIST_INSTANCE_CONFIGS:
          {
            mergeListInstanceConfigs(other.getListInstanceConfigs());
            break;
          }
        case CREATE_CLOUD_INSTANCE:
          {
            mergeCreateCloudInstance(other.getCreateCloudInstance());
            break;
          }
        case UPDATE_CLOUD_INSTANCE:
          {
            mergeUpdateCloudInstance(other.getUpdateCloudInstance());
            break;
          }
        case DELETE_CLOUD_INSTANCE:
          {
            mergeDeleteCloudInstance(other.getDeleteCloudInstance());
            break;
          }
        case LIST_CLOUD_INSTANCES:
          {
            mergeListCloudInstances(other.getListCloudInstances());
            break;
          }
        case GET_CLOUD_INSTANCE:
          {
            mergeGetCloudInstance(other.getGetCloudInstance());
            break;
          }
        case CREATE_CLOUD_DATABASE:
          {
            mergeCreateCloudDatabase(other.getCreateCloudDatabase());
            break;
          }
        case UPDATE_CLOUD_DATABASE_DDL:
          {
            mergeUpdateCloudDatabaseDdl(other.getUpdateCloudDatabaseDdl());
            break;
          }
        case UPDATE_CLOUD_DATABASE:
          {
            mergeUpdateCloudDatabase(other.getUpdateCloudDatabase());
            break;
          }
        case DROP_CLOUD_DATABASE:
          {
            mergeDropCloudDatabase(other.getDropCloudDatabase());
            break;
          }
        case LIST_CLOUD_DATABASES:
          {
            mergeListCloudDatabases(other.getListCloudDatabases());
            break;
          }
        case LIST_CLOUD_DATABASE_OPERATIONS:
          {
            mergeListCloudDatabaseOperations(other.getListCloudDatabaseOperations());
            break;
          }
        case RESTORE_CLOUD_DATABASE:
          {
            mergeRestoreCloudDatabase(other.getRestoreCloudDatabase());
            break;
          }
        case GET_CLOUD_DATABASE:
          {
            mergeGetCloudDatabase(other.getGetCloudDatabase());
            break;
          }
        case CREATE_CLOUD_BACKUP:
          {
            mergeCreateCloudBackup(other.getCreateCloudBackup());
            break;
          }
        case COPY_CLOUD_BACKUP:
          {
            mergeCopyCloudBackup(other.getCopyCloudBackup());
            break;
          }
        case GET_CLOUD_BACKUP:
          {
            mergeGetCloudBackup(other.getGetCloudBackup());
            break;
          }
        case UPDATE_CLOUD_BACKUP:
          {
            mergeUpdateCloudBackup(other.getUpdateCloudBackup());
            break;
          }
        case DELETE_CLOUD_BACKUP:
          {
            mergeDeleteCloudBackup(other.getDeleteCloudBackup());
            break;
          }
        case LIST_CLOUD_BACKUPS:
          {
            mergeListCloudBackups(other.getListCloudBackups());
            break;
          }
        case LIST_CLOUD_BACKUP_OPERATIONS:
          {
            mergeListCloudBackupOperations(other.getListCloudBackupOperations());
            break;
          }
        case GET_OPERATION:
          {
            mergeGetOperation(other.getGetOperation());
            break;
          }
        case CANCEL_OPERATION:
          {
            mergeCancelOperation(other.getCancelOperation());
            break;
          }
        case CHANGE_QUORUM_CLOUD_DATABASE:
          {
            mergeChangeQuorumCloudDatabase(other.getChangeQuorumCloudDatabase());
            break;
          }
        case ACTION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getCreateUserInstanceConfigFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getUpdateUserInstanceConfigFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getDeleteUserInstanceConfigFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getGetCloudInstanceConfigFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getListInstanceConfigsFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getCreateCloudInstanceFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getUpdateCloudInstanceFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getDeleteCloudInstanceFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 8;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(
                    getListCloudInstancesFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 9;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(
                    getGetCloudInstanceFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 10;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(
                    getCreateCloudDatabaseFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 11;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(
                    getUpdateCloudDatabaseDdlFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 12;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(
                    getDropCloudDatabaseFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 13;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(
                    getListCloudDatabasesFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 14;
                break;
              } // case 114
            case 122:
              {
                input.readMessage(
                    getListCloudDatabaseOperationsFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 15;
                break;
              } // case 122
            case 130:
              {
                input.readMessage(
                    getRestoreCloudDatabaseFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 16;
                break;
              } // case 130
            case 138:
              {
                input.readMessage(
                    getGetCloudDatabaseFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 17;
                break;
              } // case 138
            case 146:
              {
                input.readMessage(
                    getCreateCloudBackupFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 18;
                break;
              } // case 146
            case 154:
              {
                input.readMessage(getCopyCloudBackupFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 19;
                break;
              } // case 154
            case 162:
              {
                input.readMessage(getGetCloudBackupFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 20;
                break;
              } // case 162
            case 170:
              {
                input.readMessage(
                    getUpdateCloudBackupFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 21;
                break;
              } // case 170
            case 178:
              {
                input.readMessage(
                    getDeleteCloudBackupFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 22;
                break;
              } // case 178
            case 186:
              {
                input.readMessage(
                    getListCloudBackupsFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 23;
                break;
              } // case 186
            case 194:
              {
                input.readMessage(
                    getListCloudBackupOperationsFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 24;
                break;
              } // case 194
            case 202:
              {
                input.readMessage(getGetOperationFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 25;
                break;
              } // case 202
            case 210:
              {
                input.readMessage(getCancelOperationFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 26;
                break;
              } // case 210
            case 218:
              {
                input.readMessage(
                    getUpdateCloudDatabaseFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 27;
                break;
              } // case 218
            case 226:
              {
                input.readMessage(
                    getChangeQuorumCloudDatabaseFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 28;
                break;
              } // case 226
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int actionCase_ = 0;
    private java.lang.Object action_;

    public ActionCase getActionCase() {
      return ActionCase.forNumber(actionCase_);
    }

    public Builder clearAction() {
      actionCase_ = 0;
      action_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.CreateUserInstanceConfigAction,
            com.google.spanner.executor.v1.CreateUserInstanceConfigAction.Builder,
            com.google.spanner.executor.v1.CreateUserInstanceConfigActionOrBuilder>
        createUserInstanceConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Action that creates a user instance config.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.CreateUserInstanceConfigAction create_user_instance_config = 1;
     * </code>
     *
     * @return Whether the createUserInstanceConfig field is set.
     */
    @java.lang.Override
    public boolean hasCreateUserInstanceConfig() {
      return actionCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Action that creates a user instance config.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.CreateUserInstanceConfigAction create_user_instance_config = 1;
     * </code>
     *
     * @return The createUserInstanceConfig.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.CreateUserInstanceConfigAction
        getCreateUserInstanceConfig() {
      if (createUserInstanceConfigBuilder_ == null) {
        if (actionCase_ == 1) {
          return (com.google.spanner.executor.v1.CreateUserInstanceConfigAction) action_;
        }
        return com.google.spanner.executor.v1.CreateUserInstanceConfigAction.getDefaultInstance();
      } else {
        if (actionCase_ == 1) {
          return createUserInstanceConfigBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.CreateUserInstanceConfigAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that creates a user instance config.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.CreateUserInstanceConfigAction create_user_instance_config = 1;
     * </code>
     */
    public Builder setCreateUserInstanceConfig(
        com.google.spanner.executor.v1.CreateUserInstanceConfigAction value) {
      if (createUserInstanceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        createUserInstanceConfigBuilder_.setMessage(value);
      }
      actionCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that creates a user instance config.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.CreateUserInstanceConfigAction create_user_instance_config = 1;
     * </code>
     */
    public Builder setCreateUserInstanceConfig(
        com.google.spanner.executor.v1.CreateUserInstanceConfigAction.Builder builderForValue) {
      if (createUserInstanceConfigBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        createUserInstanceConfigBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that creates a user instance config.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.CreateUserInstanceConfigAction create_user_instance_config = 1;
     * </code>
     */
    public Builder mergeCreateUserInstanceConfig(
        com.google.spanner.executor.v1.CreateUserInstanceConfigAction value) {
      if (createUserInstanceConfigBuilder_ == null) {
        if (actionCase_ == 1
            && action_
                != com.google.spanner.executor.v1.CreateUserInstanceConfigAction
                    .getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.CreateUserInstanceConfigAction.newBuilder(
                      (com.google.spanner.executor.v1.CreateUserInstanceConfigAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 1) {
          createUserInstanceConfigBuilder_.mergeFrom(value);
        } else {
          createUserInstanceConfigBuilder_.setMessage(value);
        }
      }
      actionCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that creates a user instance config.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.CreateUserInstanceConfigAction create_user_instance_config = 1;
     * </code>
     */
    public Builder clearCreateUserInstanceConfig() {
      if (createUserInstanceConfigBuilder_ == null) {
        if (actionCase_ == 1) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 1) {
          actionCase_ = 0;
          action_ = null;
        }
        createUserInstanceConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that creates a user instance config.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.CreateUserInstanceConfigAction create_user_instance_config = 1;
     * </code>
     */
    public com.google.spanner.executor.v1.CreateUserInstanceConfigAction.Builder
        getCreateUserInstanceConfigBuilder() {
      return getCreateUserInstanceConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action that creates a user instance config.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.CreateUserInstanceConfigAction create_user_instance_config = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.CreateUserInstanceConfigActionOrBuilder
        getCreateUserInstanceConfigOrBuilder() {
      if ((actionCase_ == 1) && (createUserInstanceConfigBuilder_ != null)) {
        return createUserInstanceConfigBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 1) {
          return (com.google.spanner.executor.v1.CreateUserInstanceConfigAction) action_;
        }
        return com.google.spanner.executor.v1.CreateUserInstanceConfigAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that creates a user instance config.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.CreateUserInstanceConfigAction create_user_instance_config = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.CreateUserInstanceConfigAction,
            com.google.spanner.executor.v1.CreateUserInstanceConfigAction.Builder,
            com.google.spanner.executor.v1.CreateUserInstanceConfigActionOrBuilder>
        getCreateUserInstanceConfigFieldBuilder() {
      if (createUserInstanceConfigBuilder_ == null) {
        if (!(actionCase_ == 1)) {
          action_ =
              com.google.spanner.executor.v1.CreateUserInstanceConfigAction.getDefaultInstance();
        }
        createUserInstanceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.CreateUserInstanceConfigAction,
                com.google.spanner.executor.v1.CreateUserInstanceConfigAction.Builder,
                com.google.spanner.executor.v1.CreateUserInstanceConfigActionOrBuilder>(
                (com.google.spanner.executor.v1.CreateUserInstanceConfigAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 1;
      onChanged();
      return createUserInstanceConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.UpdateUserInstanceConfigAction,
            com.google.spanner.executor.v1.UpdateUserInstanceConfigAction.Builder,
            com.google.spanner.executor.v1.UpdateUserInstanceConfigActionOrBuilder>
        updateUserInstanceConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Action that updates a user instance config.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.UpdateUserInstanceConfigAction update_user_instance_config = 2;
     * </code>
     *
     * @return Whether the updateUserInstanceConfig field is set.
     */
    @java.lang.Override
    public boolean hasUpdateUserInstanceConfig() {
      return actionCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Action that updates a user instance config.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.UpdateUserInstanceConfigAction update_user_instance_config = 2;
     * </code>
     *
     * @return The updateUserInstanceConfig.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.UpdateUserInstanceConfigAction
        getUpdateUserInstanceConfig() {
      if (updateUserInstanceConfigBuilder_ == null) {
        if (actionCase_ == 2) {
          return (com.google.spanner.executor.v1.UpdateUserInstanceConfigAction) action_;
        }
        return com.google.spanner.executor.v1.UpdateUserInstanceConfigAction.getDefaultInstance();
      } else {
        if (actionCase_ == 2) {
          return updateUserInstanceConfigBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.UpdateUserInstanceConfigAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that updates a user instance config.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.UpdateUserInstanceConfigAction update_user_instance_config = 2;
     * </code>
     */
    public Builder setUpdateUserInstanceConfig(
        com.google.spanner.executor.v1.UpdateUserInstanceConfigAction value) {
      if (updateUserInstanceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        updateUserInstanceConfigBuilder_.setMessage(value);
      }
      actionCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that updates a user instance config.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.UpdateUserInstanceConfigAction update_user_instance_config = 2;
     * </code>
     */
    public Builder setUpdateUserInstanceConfig(
        com.google.spanner.executor.v1.UpdateUserInstanceConfigAction.Builder builderForValue) {
      if (updateUserInstanceConfigBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        updateUserInstanceConfigBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that updates a user instance config.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.UpdateUserInstanceConfigAction update_user_instance_config = 2;
     * </code>
     */
    public Builder mergeUpdateUserInstanceConfig(
        com.google.spanner.executor.v1.UpdateUserInstanceConfigAction value) {
      if (updateUserInstanceConfigBuilder_ == null) {
        if (actionCase_ == 2
            && action_
                != com.google.spanner.executor.v1.UpdateUserInstanceConfigAction
                    .getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.UpdateUserInstanceConfigAction.newBuilder(
                      (com.google.spanner.executor.v1.UpdateUserInstanceConfigAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 2) {
          updateUserInstanceConfigBuilder_.mergeFrom(value);
        } else {
          updateUserInstanceConfigBuilder_.setMessage(value);
        }
      }
      actionCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that updates a user instance config.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.UpdateUserInstanceConfigAction update_user_instance_config = 2;
     * </code>
     */
    public Builder clearUpdateUserInstanceConfig() {
      if (updateUserInstanceConfigBuilder_ == null) {
        if (actionCase_ == 2) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 2) {
          actionCase_ = 0;
          action_ = null;
        }
        updateUserInstanceConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that updates a user instance config.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.UpdateUserInstanceConfigAction update_user_instance_config = 2;
     * </code>
     */
    public com.google.spanner.executor.v1.UpdateUserInstanceConfigAction.Builder
        getUpdateUserInstanceConfigBuilder() {
      return getUpdateUserInstanceConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action that updates a user instance config.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.UpdateUserInstanceConfigAction update_user_instance_config = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.UpdateUserInstanceConfigActionOrBuilder
        getUpdateUserInstanceConfigOrBuilder() {
      if ((actionCase_ == 2) && (updateUserInstanceConfigBuilder_ != null)) {
        return updateUserInstanceConfigBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 2) {
          return (com.google.spanner.executor.v1.UpdateUserInstanceConfigAction) action_;
        }
        return com.google.spanner.executor.v1.UpdateUserInstanceConfigAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that updates a user instance config.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.UpdateUserInstanceConfigAction update_user_instance_config = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.UpdateUserInstanceConfigAction,
            com.google.spanner.executor.v1.UpdateUserInstanceConfigAction.Builder,
            com.google.spanner.executor.v1.UpdateUserInstanceConfigActionOrBuilder>
        getUpdateUserInstanceConfigFieldBuilder() {
      if (updateUserInstanceConfigBuilder_ == null) {
        if (!(actionCase_ == 2)) {
          action_ =
              com.google.spanner.executor.v1.UpdateUserInstanceConfigAction.getDefaultInstance();
        }
        updateUserInstanceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.UpdateUserInstanceConfigAction,
                com.google.spanner.executor.v1.UpdateUserInstanceConfigAction.Builder,
                com.google.spanner.executor.v1.UpdateUserInstanceConfigActionOrBuilder>(
                (com.google.spanner.executor.v1.UpdateUserInstanceConfigAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 2;
      onChanged();
      return updateUserInstanceConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.DeleteUserInstanceConfigAction,
            com.google.spanner.executor.v1.DeleteUserInstanceConfigAction.Builder,
            com.google.spanner.executor.v1.DeleteUserInstanceConfigActionOrBuilder>
        deleteUserInstanceConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Action that deletes a user instance config.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.DeleteUserInstanceConfigAction delete_user_instance_config = 3;
     * </code>
     *
     * @return Whether the deleteUserInstanceConfig field is set.
     */
    @java.lang.Override
    public boolean hasDeleteUserInstanceConfig() {
      return actionCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Action that deletes a user instance config.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.DeleteUserInstanceConfigAction delete_user_instance_config = 3;
     * </code>
     *
     * @return The deleteUserInstanceConfig.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.DeleteUserInstanceConfigAction
        getDeleteUserInstanceConfig() {
      if (deleteUserInstanceConfigBuilder_ == null) {
        if (actionCase_ == 3) {
          return (com.google.spanner.executor.v1.DeleteUserInstanceConfigAction) action_;
        }
        return com.google.spanner.executor.v1.DeleteUserInstanceConfigAction.getDefaultInstance();
      } else {
        if (actionCase_ == 3) {
          return deleteUserInstanceConfigBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.DeleteUserInstanceConfigAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that deletes a user instance config.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.DeleteUserInstanceConfigAction delete_user_instance_config = 3;
     * </code>
     */
    public Builder setDeleteUserInstanceConfig(
        com.google.spanner.executor.v1.DeleteUserInstanceConfigAction value) {
      if (deleteUserInstanceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        deleteUserInstanceConfigBuilder_.setMessage(value);
      }
      actionCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that deletes a user instance config.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.DeleteUserInstanceConfigAction delete_user_instance_config = 3;
     * </code>
     */
    public Builder setDeleteUserInstanceConfig(
        com.google.spanner.executor.v1.DeleteUserInstanceConfigAction.Builder builderForValue) {
      if (deleteUserInstanceConfigBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        deleteUserInstanceConfigBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that deletes a user instance config.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.DeleteUserInstanceConfigAction delete_user_instance_config = 3;
     * </code>
     */
    public Builder mergeDeleteUserInstanceConfig(
        com.google.spanner.executor.v1.DeleteUserInstanceConfigAction value) {
      if (deleteUserInstanceConfigBuilder_ == null) {
        if (actionCase_ == 3
            && action_
                != com.google.spanner.executor.v1.DeleteUserInstanceConfigAction
                    .getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.DeleteUserInstanceConfigAction.newBuilder(
                      (com.google.spanner.executor.v1.DeleteUserInstanceConfigAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 3) {
          deleteUserInstanceConfigBuilder_.mergeFrom(value);
        } else {
          deleteUserInstanceConfigBuilder_.setMessage(value);
        }
      }
      actionCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that deletes a user instance config.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.DeleteUserInstanceConfigAction delete_user_instance_config = 3;
     * </code>
     */
    public Builder clearDeleteUserInstanceConfig() {
      if (deleteUserInstanceConfigBuilder_ == null) {
        if (actionCase_ == 3) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 3) {
          actionCase_ = 0;
          action_ = null;
        }
        deleteUserInstanceConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that deletes a user instance config.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.DeleteUserInstanceConfigAction delete_user_instance_config = 3;
     * </code>
     */
    public com.google.spanner.executor.v1.DeleteUserInstanceConfigAction.Builder
        getDeleteUserInstanceConfigBuilder() {
      return getDeleteUserInstanceConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action that deletes a user instance config.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.DeleteUserInstanceConfigAction delete_user_instance_config = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.DeleteUserInstanceConfigActionOrBuilder
        getDeleteUserInstanceConfigOrBuilder() {
      if ((actionCase_ == 3) && (deleteUserInstanceConfigBuilder_ != null)) {
        return deleteUserInstanceConfigBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 3) {
          return (com.google.spanner.executor.v1.DeleteUserInstanceConfigAction) action_;
        }
        return com.google.spanner.executor.v1.DeleteUserInstanceConfigAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that deletes a user instance config.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.DeleteUserInstanceConfigAction delete_user_instance_config = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.DeleteUserInstanceConfigAction,
            com.google.spanner.executor.v1.DeleteUserInstanceConfigAction.Builder,
            com.google.spanner.executor.v1.DeleteUserInstanceConfigActionOrBuilder>
        getDeleteUserInstanceConfigFieldBuilder() {
      if (deleteUserInstanceConfigBuilder_ == null) {
        if (!(actionCase_ == 3)) {
          action_ =
              com.google.spanner.executor.v1.DeleteUserInstanceConfigAction.getDefaultInstance();
        }
        deleteUserInstanceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.DeleteUserInstanceConfigAction,
                com.google.spanner.executor.v1.DeleteUserInstanceConfigAction.Builder,
                com.google.spanner.executor.v1.DeleteUserInstanceConfigActionOrBuilder>(
                (com.google.spanner.executor.v1.DeleteUserInstanceConfigAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 3;
      onChanged();
      return deleteUserInstanceConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.GetCloudInstanceConfigAction,
            com.google.spanner.executor.v1.GetCloudInstanceConfigAction.Builder,
            com.google.spanner.executor.v1.GetCloudInstanceConfigActionOrBuilder>
        getCloudInstanceConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Action that gets a user instance config.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudInstanceConfigAction get_cloud_instance_config = 4;
     * </code>
     *
     * @return Whether the getCloudInstanceConfig field is set.
     */
    @java.lang.Override
    public boolean hasGetCloudInstanceConfig() {
      return actionCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Action that gets a user instance config.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudInstanceConfigAction get_cloud_instance_config = 4;
     * </code>
     *
     * @return The getCloudInstanceConfig.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.GetCloudInstanceConfigAction getGetCloudInstanceConfig() {
      if (getCloudInstanceConfigBuilder_ == null) {
        if (actionCase_ == 4) {
          return (com.google.spanner.executor.v1.GetCloudInstanceConfigAction) action_;
        }
        return com.google.spanner.executor.v1.GetCloudInstanceConfigAction.getDefaultInstance();
      } else {
        if (actionCase_ == 4) {
          return getCloudInstanceConfigBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.GetCloudInstanceConfigAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that gets a user instance config.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudInstanceConfigAction get_cloud_instance_config = 4;
     * </code>
     */
    public Builder setGetCloudInstanceConfig(
        com.google.spanner.executor.v1.GetCloudInstanceConfigAction value) {
      if (getCloudInstanceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        getCloudInstanceConfigBuilder_.setMessage(value);
      }
      actionCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that gets a user instance config.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudInstanceConfigAction get_cloud_instance_config = 4;
     * </code>
     */
    public Builder setGetCloudInstanceConfig(
        com.google.spanner.executor.v1.GetCloudInstanceConfigAction.Builder builderForValue) {
      if (getCloudInstanceConfigBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        getCloudInstanceConfigBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that gets a user instance config.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudInstanceConfigAction get_cloud_instance_config = 4;
     * </code>
     */
    public Builder mergeGetCloudInstanceConfig(
        com.google.spanner.executor.v1.GetCloudInstanceConfigAction value) {
      if (getCloudInstanceConfigBuilder_ == null) {
        if (actionCase_ == 4
            && action_
                != com.google.spanner.executor.v1.GetCloudInstanceConfigAction
                    .getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.GetCloudInstanceConfigAction.newBuilder(
                      (com.google.spanner.executor.v1.GetCloudInstanceConfigAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 4) {
          getCloudInstanceConfigBuilder_.mergeFrom(value);
        } else {
          getCloudInstanceConfigBuilder_.setMessage(value);
        }
      }
      actionCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that gets a user instance config.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudInstanceConfigAction get_cloud_instance_config = 4;
     * </code>
     */
    public Builder clearGetCloudInstanceConfig() {
      if (getCloudInstanceConfigBuilder_ == null) {
        if (actionCase_ == 4) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 4) {
          actionCase_ = 0;
          action_ = null;
        }
        getCloudInstanceConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that gets a user instance config.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudInstanceConfigAction get_cloud_instance_config = 4;
     * </code>
     */
    public com.google.spanner.executor.v1.GetCloudInstanceConfigAction.Builder
        getGetCloudInstanceConfigBuilder() {
      return getGetCloudInstanceConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action that gets a user instance config.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudInstanceConfigAction get_cloud_instance_config = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.GetCloudInstanceConfigActionOrBuilder
        getGetCloudInstanceConfigOrBuilder() {
      if ((actionCase_ == 4) && (getCloudInstanceConfigBuilder_ != null)) {
        return getCloudInstanceConfigBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 4) {
          return (com.google.spanner.executor.v1.GetCloudInstanceConfigAction) action_;
        }
        return com.google.spanner.executor.v1.GetCloudInstanceConfigAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that gets a user instance config.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudInstanceConfigAction get_cloud_instance_config = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.GetCloudInstanceConfigAction,
            com.google.spanner.executor.v1.GetCloudInstanceConfigAction.Builder,
            com.google.spanner.executor.v1.GetCloudInstanceConfigActionOrBuilder>
        getGetCloudInstanceConfigFieldBuilder() {
      if (getCloudInstanceConfigBuilder_ == null) {
        if (!(actionCase_ == 4)) {
          action_ =
              com.google.spanner.executor.v1.GetCloudInstanceConfigAction.getDefaultInstance();
        }
        getCloudInstanceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.GetCloudInstanceConfigAction,
                com.google.spanner.executor.v1.GetCloudInstanceConfigAction.Builder,
                com.google.spanner.executor.v1.GetCloudInstanceConfigActionOrBuilder>(
                (com.google.spanner.executor.v1.GetCloudInstanceConfigAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 4;
      onChanged();
      return getCloudInstanceConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ListCloudInstanceConfigsAction,
            com.google.spanner.executor.v1.ListCloudInstanceConfigsAction.Builder,
            com.google.spanner.executor.v1.ListCloudInstanceConfigsActionOrBuilder>
        listInstanceConfigsBuilder_;
    /**
     *
     *
     * <pre>
     * Action that lists user instance configs.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudInstanceConfigsAction list_instance_configs = 5;
     * </code>
     *
     * @return Whether the listInstanceConfigs field is set.
     */
    @java.lang.Override
    public boolean hasListInstanceConfigs() {
      return actionCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Action that lists user instance configs.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudInstanceConfigsAction list_instance_configs = 5;
     * </code>
     *
     * @return The listInstanceConfigs.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.ListCloudInstanceConfigsAction getListInstanceConfigs() {
      if (listInstanceConfigsBuilder_ == null) {
        if (actionCase_ == 5) {
          return (com.google.spanner.executor.v1.ListCloudInstanceConfigsAction) action_;
        }
        return com.google.spanner.executor.v1.ListCloudInstanceConfigsAction.getDefaultInstance();
      } else {
        if (actionCase_ == 5) {
          return listInstanceConfigsBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.ListCloudInstanceConfigsAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that lists user instance configs.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudInstanceConfigsAction list_instance_configs = 5;
     * </code>
     */
    public Builder setListInstanceConfigs(
        com.google.spanner.executor.v1.ListCloudInstanceConfigsAction value) {
      if (listInstanceConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        listInstanceConfigsBuilder_.setMessage(value);
      }
      actionCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that lists user instance configs.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudInstanceConfigsAction list_instance_configs = 5;
     * </code>
     */
    public Builder setListInstanceConfigs(
        com.google.spanner.executor.v1.ListCloudInstanceConfigsAction.Builder builderForValue) {
      if (listInstanceConfigsBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        listInstanceConfigsBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that lists user instance configs.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudInstanceConfigsAction list_instance_configs = 5;
     * </code>
     */
    public Builder mergeListInstanceConfigs(
        com.google.spanner.executor.v1.ListCloudInstanceConfigsAction value) {
      if (listInstanceConfigsBuilder_ == null) {
        if (actionCase_ == 5
            && action_
                != com.google.spanner.executor.v1.ListCloudInstanceConfigsAction
                    .getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.ListCloudInstanceConfigsAction.newBuilder(
                      (com.google.spanner.executor.v1.ListCloudInstanceConfigsAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 5) {
          listInstanceConfigsBuilder_.mergeFrom(value);
        } else {
          listInstanceConfigsBuilder_.setMessage(value);
        }
      }
      actionCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that lists user instance configs.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudInstanceConfigsAction list_instance_configs = 5;
     * </code>
     */
    public Builder clearListInstanceConfigs() {
      if (listInstanceConfigsBuilder_ == null) {
        if (actionCase_ == 5) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 5) {
          actionCase_ = 0;
          action_ = null;
        }
        listInstanceConfigsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that lists user instance configs.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudInstanceConfigsAction list_instance_configs = 5;
     * </code>
     */
    public com.google.spanner.executor.v1.ListCloudInstanceConfigsAction.Builder
        getListInstanceConfigsBuilder() {
      return getListInstanceConfigsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action that lists user instance configs.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudInstanceConfigsAction list_instance_configs = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.ListCloudInstanceConfigsActionOrBuilder
        getListInstanceConfigsOrBuilder() {
      if ((actionCase_ == 5) && (listInstanceConfigsBuilder_ != null)) {
        return listInstanceConfigsBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 5) {
          return (com.google.spanner.executor.v1.ListCloudInstanceConfigsAction) action_;
        }
        return com.google.spanner.executor.v1.ListCloudInstanceConfigsAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that lists user instance configs.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudInstanceConfigsAction list_instance_configs = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ListCloudInstanceConfigsAction,
            com.google.spanner.executor.v1.ListCloudInstanceConfigsAction.Builder,
            com.google.spanner.executor.v1.ListCloudInstanceConfigsActionOrBuilder>
        getListInstanceConfigsFieldBuilder() {
      if (listInstanceConfigsBuilder_ == null) {
        if (!(actionCase_ == 5)) {
          action_ =
              com.google.spanner.executor.v1.ListCloudInstanceConfigsAction.getDefaultInstance();
        }
        listInstanceConfigsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.ListCloudInstanceConfigsAction,
                com.google.spanner.executor.v1.ListCloudInstanceConfigsAction.Builder,
                com.google.spanner.executor.v1.ListCloudInstanceConfigsActionOrBuilder>(
                (com.google.spanner.executor.v1.ListCloudInstanceConfigsAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 5;
      onChanged();
      return listInstanceConfigsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.CreateCloudInstanceAction,
            com.google.spanner.executor.v1.CreateCloudInstanceAction.Builder,
            com.google.spanner.executor.v1.CreateCloudInstanceActionOrBuilder>
        createCloudInstanceBuilder_;
    /**
     *
     *
     * <pre>
     * Action that creates a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CreateCloudInstanceAction create_cloud_instance = 6;</code>
     *
     * @return Whether the createCloudInstance field is set.
     */
    @java.lang.Override
    public boolean hasCreateCloudInstance() {
      return actionCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Action that creates a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CreateCloudInstanceAction create_cloud_instance = 6;</code>
     *
     * @return The createCloudInstance.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.CreateCloudInstanceAction getCreateCloudInstance() {
      if (createCloudInstanceBuilder_ == null) {
        if (actionCase_ == 6) {
          return (com.google.spanner.executor.v1.CreateCloudInstanceAction) action_;
        }
        return com.google.spanner.executor.v1.CreateCloudInstanceAction.getDefaultInstance();
      } else {
        if (actionCase_ == 6) {
          return createCloudInstanceBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.CreateCloudInstanceAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that creates a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CreateCloudInstanceAction create_cloud_instance = 6;</code>
     */
    public Builder setCreateCloudInstance(
        com.google.spanner.executor.v1.CreateCloudInstanceAction value) {
      if (createCloudInstanceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        createCloudInstanceBuilder_.setMessage(value);
      }
      actionCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that creates a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CreateCloudInstanceAction create_cloud_instance = 6;</code>
     */
    public Builder setCreateCloudInstance(
        com.google.spanner.executor.v1.CreateCloudInstanceAction.Builder builderForValue) {
      if (createCloudInstanceBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        createCloudInstanceBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that creates a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CreateCloudInstanceAction create_cloud_instance = 6;</code>
     */
    public Builder mergeCreateCloudInstance(
        com.google.spanner.executor.v1.CreateCloudInstanceAction value) {
      if (createCloudInstanceBuilder_ == null) {
        if (actionCase_ == 6
            && action_
                != com.google.spanner.executor.v1.CreateCloudInstanceAction.getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.CreateCloudInstanceAction.newBuilder(
                      (com.google.spanner.executor.v1.CreateCloudInstanceAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 6) {
          createCloudInstanceBuilder_.mergeFrom(value);
        } else {
          createCloudInstanceBuilder_.setMessage(value);
        }
      }
      actionCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that creates a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CreateCloudInstanceAction create_cloud_instance = 6;</code>
     */
    public Builder clearCreateCloudInstance() {
      if (createCloudInstanceBuilder_ == null) {
        if (actionCase_ == 6) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 6) {
          actionCase_ = 0;
          action_ = null;
        }
        createCloudInstanceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that creates a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CreateCloudInstanceAction create_cloud_instance = 6;</code>
     */
    public com.google.spanner.executor.v1.CreateCloudInstanceAction.Builder
        getCreateCloudInstanceBuilder() {
      return getCreateCloudInstanceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action that creates a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CreateCloudInstanceAction create_cloud_instance = 6;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.CreateCloudInstanceActionOrBuilder
        getCreateCloudInstanceOrBuilder() {
      if ((actionCase_ == 6) && (createCloudInstanceBuilder_ != null)) {
        return createCloudInstanceBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 6) {
          return (com.google.spanner.executor.v1.CreateCloudInstanceAction) action_;
        }
        return com.google.spanner.executor.v1.CreateCloudInstanceAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that creates a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CreateCloudInstanceAction create_cloud_instance = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.CreateCloudInstanceAction,
            com.google.spanner.executor.v1.CreateCloudInstanceAction.Builder,
            com.google.spanner.executor.v1.CreateCloudInstanceActionOrBuilder>
        getCreateCloudInstanceFieldBuilder() {
      if (createCloudInstanceBuilder_ == null) {
        if (!(actionCase_ == 6)) {
          action_ = com.google.spanner.executor.v1.CreateCloudInstanceAction.getDefaultInstance();
        }
        createCloudInstanceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.CreateCloudInstanceAction,
                com.google.spanner.executor.v1.CreateCloudInstanceAction.Builder,
                com.google.spanner.executor.v1.CreateCloudInstanceActionOrBuilder>(
                (com.google.spanner.executor.v1.CreateCloudInstanceAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 6;
      onChanged();
      return createCloudInstanceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.UpdateCloudInstanceAction,
            com.google.spanner.executor.v1.UpdateCloudInstanceAction.Builder,
            com.google.spanner.executor.v1.UpdateCloudInstanceActionOrBuilder>
        updateCloudInstanceBuilder_;
    /**
     *
     *
     * <pre>
     * Action that updates a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.UpdateCloudInstanceAction update_cloud_instance = 7;</code>
     *
     * @return Whether the updateCloudInstance field is set.
     */
    @java.lang.Override
    public boolean hasUpdateCloudInstance() {
      return actionCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Action that updates a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.UpdateCloudInstanceAction update_cloud_instance = 7;</code>
     *
     * @return The updateCloudInstance.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.UpdateCloudInstanceAction getUpdateCloudInstance() {
      if (updateCloudInstanceBuilder_ == null) {
        if (actionCase_ == 7) {
          return (com.google.spanner.executor.v1.UpdateCloudInstanceAction) action_;
        }
        return com.google.spanner.executor.v1.UpdateCloudInstanceAction.getDefaultInstance();
      } else {
        if (actionCase_ == 7) {
          return updateCloudInstanceBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.UpdateCloudInstanceAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that updates a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.UpdateCloudInstanceAction update_cloud_instance = 7;</code>
     */
    public Builder setUpdateCloudInstance(
        com.google.spanner.executor.v1.UpdateCloudInstanceAction value) {
      if (updateCloudInstanceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        updateCloudInstanceBuilder_.setMessage(value);
      }
      actionCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that updates a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.UpdateCloudInstanceAction update_cloud_instance = 7;</code>
     */
    public Builder setUpdateCloudInstance(
        com.google.spanner.executor.v1.UpdateCloudInstanceAction.Builder builderForValue) {
      if (updateCloudInstanceBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        updateCloudInstanceBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that updates a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.UpdateCloudInstanceAction update_cloud_instance = 7;</code>
     */
    public Builder mergeUpdateCloudInstance(
        com.google.spanner.executor.v1.UpdateCloudInstanceAction value) {
      if (updateCloudInstanceBuilder_ == null) {
        if (actionCase_ == 7
            && action_
                != com.google.spanner.executor.v1.UpdateCloudInstanceAction.getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.UpdateCloudInstanceAction.newBuilder(
                      (com.google.spanner.executor.v1.UpdateCloudInstanceAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 7) {
          updateCloudInstanceBuilder_.mergeFrom(value);
        } else {
          updateCloudInstanceBuilder_.setMessage(value);
        }
      }
      actionCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that updates a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.UpdateCloudInstanceAction update_cloud_instance = 7;</code>
     */
    public Builder clearUpdateCloudInstance() {
      if (updateCloudInstanceBuilder_ == null) {
        if (actionCase_ == 7) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 7) {
          actionCase_ = 0;
          action_ = null;
        }
        updateCloudInstanceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that updates a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.UpdateCloudInstanceAction update_cloud_instance = 7;</code>
     */
    public com.google.spanner.executor.v1.UpdateCloudInstanceAction.Builder
        getUpdateCloudInstanceBuilder() {
      return getUpdateCloudInstanceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action that updates a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.UpdateCloudInstanceAction update_cloud_instance = 7;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.UpdateCloudInstanceActionOrBuilder
        getUpdateCloudInstanceOrBuilder() {
      if ((actionCase_ == 7) && (updateCloudInstanceBuilder_ != null)) {
        return updateCloudInstanceBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 7) {
          return (com.google.spanner.executor.v1.UpdateCloudInstanceAction) action_;
        }
        return com.google.spanner.executor.v1.UpdateCloudInstanceAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that updates a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.UpdateCloudInstanceAction update_cloud_instance = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.UpdateCloudInstanceAction,
            com.google.spanner.executor.v1.UpdateCloudInstanceAction.Builder,
            com.google.spanner.executor.v1.UpdateCloudInstanceActionOrBuilder>
        getUpdateCloudInstanceFieldBuilder() {
      if (updateCloudInstanceBuilder_ == null) {
        if (!(actionCase_ == 7)) {
          action_ = com.google.spanner.executor.v1.UpdateCloudInstanceAction.getDefaultInstance();
        }
        updateCloudInstanceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.UpdateCloudInstanceAction,
                com.google.spanner.executor.v1.UpdateCloudInstanceAction.Builder,
                com.google.spanner.executor.v1.UpdateCloudInstanceActionOrBuilder>(
                (com.google.spanner.executor.v1.UpdateCloudInstanceAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 7;
      onChanged();
      return updateCloudInstanceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.DeleteCloudInstanceAction,
            com.google.spanner.executor.v1.DeleteCloudInstanceAction.Builder,
            com.google.spanner.executor.v1.DeleteCloudInstanceActionOrBuilder>
        deleteCloudInstanceBuilder_;
    /**
     *
     *
     * <pre>
     * Action that deletes a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DeleteCloudInstanceAction delete_cloud_instance = 8;</code>
     *
     * @return Whether the deleteCloudInstance field is set.
     */
    @java.lang.Override
    public boolean hasDeleteCloudInstance() {
      return actionCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Action that deletes a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DeleteCloudInstanceAction delete_cloud_instance = 8;</code>
     *
     * @return The deleteCloudInstance.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.DeleteCloudInstanceAction getDeleteCloudInstance() {
      if (deleteCloudInstanceBuilder_ == null) {
        if (actionCase_ == 8) {
          return (com.google.spanner.executor.v1.DeleteCloudInstanceAction) action_;
        }
        return com.google.spanner.executor.v1.DeleteCloudInstanceAction.getDefaultInstance();
      } else {
        if (actionCase_ == 8) {
          return deleteCloudInstanceBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.DeleteCloudInstanceAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that deletes a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DeleteCloudInstanceAction delete_cloud_instance = 8;</code>
     */
    public Builder setDeleteCloudInstance(
        com.google.spanner.executor.v1.DeleteCloudInstanceAction value) {
      if (deleteCloudInstanceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        deleteCloudInstanceBuilder_.setMessage(value);
      }
      actionCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that deletes a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DeleteCloudInstanceAction delete_cloud_instance = 8;</code>
     */
    public Builder setDeleteCloudInstance(
        com.google.spanner.executor.v1.DeleteCloudInstanceAction.Builder builderForValue) {
      if (deleteCloudInstanceBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        deleteCloudInstanceBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that deletes a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DeleteCloudInstanceAction delete_cloud_instance = 8;</code>
     */
    public Builder mergeDeleteCloudInstance(
        com.google.spanner.executor.v1.DeleteCloudInstanceAction value) {
      if (deleteCloudInstanceBuilder_ == null) {
        if (actionCase_ == 8
            && action_
                != com.google.spanner.executor.v1.DeleteCloudInstanceAction.getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.DeleteCloudInstanceAction.newBuilder(
                      (com.google.spanner.executor.v1.DeleteCloudInstanceAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 8) {
          deleteCloudInstanceBuilder_.mergeFrom(value);
        } else {
          deleteCloudInstanceBuilder_.setMessage(value);
        }
      }
      actionCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that deletes a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DeleteCloudInstanceAction delete_cloud_instance = 8;</code>
     */
    public Builder clearDeleteCloudInstance() {
      if (deleteCloudInstanceBuilder_ == null) {
        if (actionCase_ == 8) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 8) {
          actionCase_ = 0;
          action_ = null;
        }
        deleteCloudInstanceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that deletes a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DeleteCloudInstanceAction delete_cloud_instance = 8;</code>
     */
    public com.google.spanner.executor.v1.DeleteCloudInstanceAction.Builder
        getDeleteCloudInstanceBuilder() {
      return getDeleteCloudInstanceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action that deletes a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DeleteCloudInstanceAction delete_cloud_instance = 8;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.DeleteCloudInstanceActionOrBuilder
        getDeleteCloudInstanceOrBuilder() {
      if ((actionCase_ == 8) && (deleteCloudInstanceBuilder_ != null)) {
        return deleteCloudInstanceBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 8) {
          return (com.google.spanner.executor.v1.DeleteCloudInstanceAction) action_;
        }
        return com.google.spanner.executor.v1.DeleteCloudInstanceAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that deletes a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DeleteCloudInstanceAction delete_cloud_instance = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.DeleteCloudInstanceAction,
            com.google.spanner.executor.v1.DeleteCloudInstanceAction.Builder,
            com.google.spanner.executor.v1.DeleteCloudInstanceActionOrBuilder>
        getDeleteCloudInstanceFieldBuilder() {
      if (deleteCloudInstanceBuilder_ == null) {
        if (!(actionCase_ == 8)) {
          action_ = com.google.spanner.executor.v1.DeleteCloudInstanceAction.getDefaultInstance();
        }
        deleteCloudInstanceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.DeleteCloudInstanceAction,
                com.google.spanner.executor.v1.DeleteCloudInstanceAction.Builder,
                com.google.spanner.executor.v1.DeleteCloudInstanceActionOrBuilder>(
                (com.google.spanner.executor.v1.DeleteCloudInstanceAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 8;
      onChanged();
      return deleteCloudInstanceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ListCloudInstancesAction,
            com.google.spanner.executor.v1.ListCloudInstancesAction.Builder,
            com.google.spanner.executor.v1.ListCloudInstancesActionOrBuilder>
        listCloudInstancesBuilder_;
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner instances.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudInstancesAction list_cloud_instances = 9;</code>
     *
     * @return Whether the listCloudInstances field is set.
     */
    @java.lang.Override
    public boolean hasListCloudInstances() {
      return actionCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner instances.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudInstancesAction list_cloud_instances = 9;</code>
     *
     * @return The listCloudInstances.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.ListCloudInstancesAction getListCloudInstances() {
      if (listCloudInstancesBuilder_ == null) {
        if (actionCase_ == 9) {
          return (com.google.spanner.executor.v1.ListCloudInstancesAction) action_;
        }
        return com.google.spanner.executor.v1.ListCloudInstancesAction.getDefaultInstance();
      } else {
        if (actionCase_ == 9) {
          return listCloudInstancesBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.ListCloudInstancesAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner instances.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudInstancesAction list_cloud_instances = 9;</code>
     */
    public Builder setListCloudInstances(
        com.google.spanner.executor.v1.ListCloudInstancesAction value) {
      if (listCloudInstancesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        listCloudInstancesBuilder_.setMessage(value);
      }
      actionCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner instances.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudInstancesAction list_cloud_instances = 9;</code>
     */
    public Builder setListCloudInstances(
        com.google.spanner.executor.v1.ListCloudInstancesAction.Builder builderForValue) {
      if (listCloudInstancesBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        listCloudInstancesBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner instances.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudInstancesAction list_cloud_instances = 9;</code>
     */
    public Builder mergeListCloudInstances(
        com.google.spanner.executor.v1.ListCloudInstancesAction value) {
      if (listCloudInstancesBuilder_ == null) {
        if (actionCase_ == 9
            && action_
                != com.google.spanner.executor.v1.ListCloudInstancesAction.getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.ListCloudInstancesAction.newBuilder(
                      (com.google.spanner.executor.v1.ListCloudInstancesAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 9) {
          listCloudInstancesBuilder_.mergeFrom(value);
        } else {
          listCloudInstancesBuilder_.setMessage(value);
        }
      }
      actionCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner instances.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudInstancesAction list_cloud_instances = 9;</code>
     */
    public Builder clearListCloudInstances() {
      if (listCloudInstancesBuilder_ == null) {
        if (actionCase_ == 9) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 9) {
          actionCase_ = 0;
          action_ = null;
        }
        listCloudInstancesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner instances.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudInstancesAction list_cloud_instances = 9;</code>
     */
    public com.google.spanner.executor.v1.ListCloudInstancesAction.Builder
        getListCloudInstancesBuilder() {
      return getListCloudInstancesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner instances.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudInstancesAction list_cloud_instances = 9;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.ListCloudInstancesActionOrBuilder
        getListCloudInstancesOrBuilder() {
      if ((actionCase_ == 9) && (listCloudInstancesBuilder_ != null)) {
        return listCloudInstancesBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 9) {
          return (com.google.spanner.executor.v1.ListCloudInstancesAction) action_;
        }
        return com.google.spanner.executor.v1.ListCloudInstancesAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner instances.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudInstancesAction list_cloud_instances = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ListCloudInstancesAction,
            com.google.spanner.executor.v1.ListCloudInstancesAction.Builder,
            com.google.spanner.executor.v1.ListCloudInstancesActionOrBuilder>
        getListCloudInstancesFieldBuilder() {
      if (listCloudInstancesBuilder_ == null) {
        if (!(actionCase_ == 9)) {
          action_ = com.google.spanner.executor.v1.ListCloudInstancesAction.getDefaultInstance();
        }
        listCloudInstancesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.ListCloudInstancesAction,
                com.google.spanner.executor.v1.ListCloudInstancesAction.Builder,
                com.google.spanner.executor.v1.ListCloudInstancesActionOrBuilder>(
                (com.google.spanner.executor.v1.ListCloudInstancesAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 9;
      onChanged();
      return listCloudInstancesBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.GetCloudInstanceAction,
            com.google.spanner.executor.v1.GetCloudInstanceAction.Builder,
            com.google.spanner.executor.v1.GetCloudInstanceActionOrBuilder>
        getCloudInstanceBuilder_;
    /**
     *
     *
     * <pre>
     * Action that retrieves a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudInstanceAction get_cloud_instance = 10;</code>
     *
     * @return Whether the getCloudInstance field is set.
     */
    @java.lang.Override
    public boolean hasGetCloudInstance() {
      return actionCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * Action that retrieves a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudInstanceAction get_cloud_instance = 10;</code>
     *
     * @return The getCloudInstance.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.GetCloudInstanceAction getGetCloudInstance() {
      if (getCloudInstanceBuilder_ == null) {
        if (actionCase_ == 10) {
          return (com.google.spanner.executor.v1.GetCloudInstanceAction) action_;
        }
        return com.google.spanner.executor.v1.GetCloudInstanceAction.getDefaultInstance();
      } else {
        if (actionCase_ == 10) {
          return getCloudInstanceBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.GetCloudInstanceAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that retrieves a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudInstanceAction get_cloud_instance = 10;</code>
     */
    public Builder setGetCloudInstance(
        com.google.spanner.executor.v1.GetCloudInstanceAction value) {
      if (getCloudInstanceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        getCloudInstanceBuilder_.setMessage(value);
      }
      actionCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that retrieves a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudInstanceAction get_cloud_instance = 10;</code>
     */
    public Builder setGetCloudInstance(
        com.google.spanner.executor.v1.GetCloudInstanceAction.Builder builderForValue) {
      if (getCloudInstanceBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        getCloudInstanceBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that retrieves a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudInstanceAction get_cloud_instance = 10;</code>
     */
    public Builder mergeGetCloudInstance(
        com.google.spanner.executor.v1.GetCloudInstanceAction value) {
      if (getCloudInstanceBuilder_ == null) {
        if (actionCase_ == 10
            && action_
                != com.google.spanner.executor.v1.GetCloudInstanceAction.getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.GetCloudInstanceAction.newBuilder(
                      (com.google.spanner.executor.v1.GetCloudInstanceAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 10) {
          getCloudInstanceBuilder_.mergeFrom(value);
        } else {
          getCloudInstanceBuilder_.setMessage(value);
        }
      }
      actionCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that retrieves a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudInstanceAction get_cloud_instance = 10;</code>
     */
    public Builder clearGetCloudInstance() {
      if (getCloudInstanceBuilder_ == null) {
        if (actionCase_ == 10) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 10) {
          actionCase_ = 0;
          action_ = null;
        }
        getCloudInstanceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that retrieves a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudInstanceAction get_cloud_instance = 10;</code>
     */
    public com.google.spanner.executor.v1.GetCloudInstanceAction.Builder
        getGetCloudInstanceBuilder() {
      return getGetCloudInstanceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action that retrieves a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudInstanceAction get_cloud_instance = 10;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.GetCloudInstanceActionOrBuilder
        getGetCloudInstanceOrBuilder() {
      if ((actionCase_ == 10) && (getCloudInstanceBuilder_ != null)) {
        return getCloudInstanceBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 10) {
          return (com.google.spanner.executor.v1.GetCloudInstanceAction) action_;
        }
        return com.google.spanner.executor.v1.GetCloudInstanceAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that retrieves a Cloud Spanner instance.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudInstanceAction get_cloud_instance = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.GetCloudInstanceAction,
            com.google.spanner.executor.v1.GetCloudInstanceAction.Builder,
            com.google.spanner.executor.v1.GetCloudInstanceActionOrBuilder>
        getGetCloudInstanceFieldBuilder() {
      if (getCloudInstanceBuilder_ == null) {
        if (!(actionCase_ == 10)) {
          action_ = com.google.spanner.executor.v1.GetCloudInstanceAction.getDefaultInstance();
        }
        getCloudInstanceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.GetCloudInstanceAction,
                com.google.spanner.executor.v1.GetCloudInstanceAction.Builder,
                com.google.spanner.executor.v1.GetCloudInstanceActionOrBuilder>(
                (com.google.spanner.executor.v1.GetCloudInstanceAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 10;
      onChanged();
      return getCloudInstanceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.CreateCloudDatabaseAction,
            com.google.spanner.executor.v1.CreateCloudDatabaseAction.Builder,
            com.google.spanner.executor.v1.CreateCloudDatabaseActionOrBuilder>
        createCloudDatabaseBuilder_;
    /**
     *
     *
     * <pre>
     * Action that creates a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CreateCloudDatabaseAction create_cloud_database = 11;
     * </code>
     *
     * @return Whether the createCloudDatabase field is set.
     */
    @java.lang.Override
    public boolean hasCreateCloudDatabase() {
      return actionCase_ == 11;
    }
    /**
     *
     *
     * <pre>
     * Action that creates a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CreateCloudDatabaseAction create_cloud_database = 11;
     * </code>
     *
     * @return The createCloudDatabase.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.CreateCloudDatabaseAction getCreateCloudDatabase() {
      if (createCloudDatabaseBuilder_ == null) {
        if (actionCase_ == 11) {
          return (com.google.spanner.executor.v1.CreateCloudDatabaseAction) action_;
        }
        return com.google.spanner.executor.v1.CreateCloudDatabaseAction.getDefaultInstance();
      } else {
        if (actionCase_ == 11) {
          return createCloudDatabaseBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.CreateCloudDatabaseAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that creates a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CreateCloudDatabaseAction create_cloud_database = 11;
     * </code>
     */
    public Builder setCreateCloudDatabase(
        com.google.spanner.executor.v1.CreateCloudDatabaseAction value) {
      if (createCloudDatabaseBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        createCloudDatabaseBuilder_.setMessage(value);
      }
      actionCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that creates a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CreateCloudDatabaseAction create_cloud_database = 11;
     * </code>
     */
    public Builder setCreateCloudDatabase(
        com.google.spanner.executor.v1.CreateCloudDatabaseAction.Builder builderForValue) {
      if (createCloudDatabaseBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        createCloudDatabaseBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that creates a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CreateCloudDatabaseAction create_cloud_database = 11;
     * </code>
     */
    public Builder mergeCreateCloudDatabase(
        com.google.spanner.executor.v1.CreateCloudDatabaseAction value) {
      if (createCloudDatabaseBuilder_ == null) {
        if (actionCase_ == 11
            && action_
                != com.google.spanner.executor.v1.CreateCloudDatabaseAction.getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.CreateCloudDatabaseAction.newBuilder(
                      (com.google.spanner.executor.v1.CreateCloudDatabaseAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 11) {
          createCloudDatabaseBuilder_.mergeFrom(value);
        } else {
          createCloudDatabaseBuilder_.setMessage(value);
        }
      }
      actionCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that creates a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CreateCloudDatabaseAction create_cloud_database = 11;
     * </code>
     */
    public Builder clearCreateCloudDatabase() {
      if (createCloudDatabaseBuilder_ == null) {
        if (actionCase_ == 11) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 11) {
          actionCase_ = 0;
          action_ = null;
        }
        createCloudDatabaseBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that creates a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CreateCloudDatabaseAction create_cloud_database = 11;
     * </code>
     */
    public com.google.spanner.executor.v1.CreateCloudDatabaseAction.Builder
        getCreateCloudDatabaseBuilder() {
      return getCreateCloudDatabaseFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action that creates a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CreateCloudDatabaseAction create_cloud_database = 11;
     * </code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.CreateCloudDatabaseActionOrBuilder
        getCreateCloudDatabaseOrBuilder() {
      if ((actionCase_ == 11) && (createCloudDatabaseBuilder_ != null)) {
        return createCloudDatabaseBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 11) {
          return (com.google.spanner.executor.v1.CreateCloudDatabaseAction) action_;
        }
        return com.google.spanner.executor.v1.CreateCloudDatabaseAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that creates a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CreateCloudDatabaseAction create_cloud_database = 11;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.CreateCloudDatabaseAction,
            com.google.spanner.executor.v1.CreateCloudDatabaseAction.Builder,
            com.google.spanner.executor.v1.CreateCloudDatabaseActionOrBuilder>
        getCreateCloudDatabaseFieldBuilder() {
      if (createCloudDatabaseBuilder_ == null) {
        if (!(actionCase_ == 11)) {
          action_ = com.google.spanner.executor.v1.CreateCloudDatabaseAction.getDefaultInstance();
        }
        createCloudDatabaseBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.CreateCloudDatabaseAction,
                com.google.spanner.executor.v1.CreateCloudDatabaseAction.Builder,
                com.google.spanner.executor.v1.CreateCloudDatabaseActionOrBuilder>(
                (com.google.spanner.executor.v1.CreateCloudDatabaseAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 11;
      onChanged();
      return createCloudDatabaseBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction,
            com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction.Builder,
            com.google.spanner.executor.v1.UpdateCloudDatabaseDdlActionOrBuilder>
        updateCloudDatabaseDdlBuilder_;
    /**
     *
     *
     * <pre>
     * Action that updates the schema of a Cloud Spanner database.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.UpdateCloudDatabaseDdlAction update_cloud_database_ddl = 12;
     * </code>
     *
     * @return Whether the updateCloudDatabaseDdl field is set.
     */
    @java.lang.Override
    public boolean hasUpdateCloudDatabaseDdl() {
      return actionCase_ == 12;
    }
    /**
     *
     *
     * <pre>
     * Action that updates the schema of a Cloud Spanner database.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.UpdateCloudDatabaseDdlAction update_cloud_database_ddl = 12;
     * </code>
     *
     * @return The updateCloudDatabaseDdl.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction getUpdateCloudDatabaseDdl() {
      if (updateCloudDatabaseDdlBuilder_ == null) {
        if (actionCase_ == 12) {
          return (com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction) action_;
        }
        return com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction.getDefaultInstance();
      } else {
        if (actionCase_ == 12) {
          return updateCloudDatabaseDdlBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that updates the schema of a Cloud Spanner database.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.UpdateCloudDatabaseDdlAction update_cloud_database_ddl = 12;
     * </code>
     */
    public Builder setUpdateCloudDatabaseDdl(
        com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction value) {
      if (updateCloudDatabaseDdlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        updateCloudDatabaseDdlBuilder_.setMessage(value);
      }
      actionCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that updates the schema of a Cloud Spanner database.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.UpdateCloudDatabaseDdlAction update_cloud_database_ddl = 12;
     * </code>
     */
    public Builder setUpdateCloudDatabaseDdl(
        com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction.Builder builderForValue) {
      if (updateCloudDatabaseDdlBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        updateCloudDatabaseDdlBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that updates the schema of a Cloud Spanner database.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.UpdateCloudDatabaseDdlAction update_cloud_database_ddl = 12;
     * </code>
     */
    public Builder mergeUpdateCloudDatabaseDdl(
        com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction value) {
      if (updateCloudDatabaseDdlBuilder_ == null) {
        if (actionCase_ == 12
            && action_
                != com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction
                    .getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction.newBuilder(
                      (com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 12) {
          updateCloudDatabaseDdlBuilder_.mergeFrom(value);
        } else {
          updateCloudDatabaseDdlBuilder_.setMessage(value);
        }
      }
      actionCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that updates the schema of a Cloud Spanner database.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.UpdateCloudDatabaseDdlAction update_cloud_database_ddl = 12;
     * </code>
     */
    public Builder clearUpdateCloudDatabaseDdl() {
      if (updateCloudDatabaseDdlBuilder_ == null) {
        if (actionCase_ == 12) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 12) {
          actionCase_ = 0;
          action_ = null;
        }
        updateCloudDatabaseDdlBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that updates the schema of a Cloud Spanner database.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.UpdateCloudDatabaseDdlAction update_cloud_database_ddl = 12;
     * </code>
     */
    public com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction.Builder
        getUpdateCloudDatabaseDdlBuilder() {
      return getUpdateCloudDatabaseDdlFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action that updates the schema of a Cloud Spanner database.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.UpdateCloudDatabaseDdlAction update_cloud_database_ddl = 12;
     * </code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.UpdateCloudDatabaseDdlActionOrBuilder
        getUpdateCloudDatabaseDdlOrBuilder() {
      if ((actionCase_ == 12) && (updateCloudDatabaseDdlBuilder_ != null)) {
        return updateCloudDatabaseDdlBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 12) {
          return (com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction) action_;
        }
        return com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that updates the schema of a Cloud Spanner database.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.UpdateCloudDatabaseDdlAction update_cloud_database_ddl = 12;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction,
            com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction.Builder,
            com.google.spanner.executor.v1.UpdateCloudDatabaseDdlActionOrBuilder>
        getUpdateCloudDatabaseDdlFieldBuilder() {
      if (updateCloudDatabaseDdlBuilder_ == null) {
        if (!(actionCase_ == 12)) {
          action_ =
              com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction.getDefaultInstance();
        }
        updateCloudDatabaseDdlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction,
                com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction.Builder,
                com.google.spanner.executor.v1.UpdateCloudDatabaseDdlActionOrBuilder>(
                (com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 12;
      onChanged();
      return updateCloudDatabaseDdlBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.UpdateCloudDatabaseAction,
            com.google.spanner.executor.v1.UpdateCloudDatabaseAction.Builder,
            com.google.spanner.executor.v1.UpdateCloudDatabaseActionOrBuilder>
        updateCloudDatabaseBuilder_;
    /**
     *
     *
     * <pre>
     * Action that updates the schema of a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.UpdateCloudDatabaseAction update_cloud_database = 27;
     * </code>
     *
     * @return Whether the updateCloudDatabase field is set.
     */
    @java.lang.Override
    public boolean hasUpdateCloudDatabase() {
      return actionCase_ == 27;
    }
    /**
     *
     *
     * <pre>
     * Action that updates the schema of a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.UpdateCloudDatabaseAction update_cloud_database = 27;
     * </code>
     *
     * @return The updateCloudDatabase.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.UpdateCloudDatabaseAction getUpdateCloudDatabase() {
      if (updateCloudDatabaseBuilder_ == null) {
        if (actionCase_ == 27) {
          return (com.google.spanner.executor.v1.UpdateCloudDatabaseAction) action_;
        }
        return com.google.spanner.executor.v1.UpdateCloudDatabaseAction.getDefaultInstance();
      } else {
        if (actionCase_ == 27) {
          return updateCloudDatabaseBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.UpdateCloudDatabaseAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that updates the schema of a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.UpdateCloudDatabaseAction update_cloud_database = 27;
     * </code>
     */
    public Builder setUpdateCloudDatabase(
        com.google.spanner.executor.v1.UpdateCloudDatabaseAction value) {
      if (updateCloudDatabaseBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        updateCloudDatabaseBuilder_.setMessage(value);
      }
      actionCase_ = 27;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that updates the schema of a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.UpdateCloudDatabaseAction update_cloud_database = 27;
     * </code>
     */
    public Builder setUpdateCloudDatabase(
        com.google.spanner.executor.v1.UpdateCloudDatabaseAction.Builder builderForValue) {
      if (updateCloudDatabaseBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        updateCloudDatabaseBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 27;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that updates the schema of a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.UpdateCloudDatabaseAction update_cloud_database = 27;
     * </code>
     */
    public Builder mergeUpdateCloudDatabase(
        com.google.spanner.executor.v1.UpdateCloudDatabaseAction value) {
      if (updateCloudDatabaseBuilder_ == null) {
        if (actionCase_ == 27
            && action_
                != com.google.spanner.executor.v1.UpdateCloudDatabaseAction.getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.UpdateCloudDatabaseAction.newBuilder(
                      (com.google.spanner.executor.v1.UpdateCloudDatabaseAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 27) {
          updateCloudDatabaseBuilder_.mergeFrom(value);
        } else {
          updateCloudDatabaseBuilder_.setMessage(value);
        }
      }
      actionCase_ = 27;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that updates the schema of a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.UpdateCloudDatabaseAction update_cloud_database = 27;
     * </code>
     */
    public Builder clearUpdateCloudDatabase() {
      if (updateCloudDatabaseBuilder_ == null) {
        if (actionCase_ == 27) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 27) {
          actionCase_ = 0;
          action_ = null;
        }
        updateCloudDatabaseBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that updates the schema of a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.UpdateCloudDatabaseAction update_cloud_database = 27;
     * </code>
     */
    public com.google.spanner.executor.v1.UpdateCloudDatabaseAction.Builder
        getUpdateCloudDatabaseBuilder() {
      return getUpdateCloudDatabaseFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action that updates the schema of a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.UpdateCloudDatabaseAction update_cloud_database = 27;
     * </code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.UpdateCloudDatabaseActionOrBuilder
        getUpdateCloudDatabaseOrBuilder() {
      if ((actionCase_ == 27) && (updateCloudDatabaseBuilder_ != null)) {
        return updateCloudDatabaseBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 27) {
          return (com.google.spanner.executor.v1.UpdateCloudDatabaseAction) action_;
        }
        return com.google.spanner.executor.v1.UpdateCloudDatabaseAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that updates the schema of a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.UpdateCloudDatabaseAction update_cloud_database = 27;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.UpdateCloudDatabaseAction,
            com.google.spanner.executor.v1.UpdateCloudDatabaseAction.Builder,
            com.google.spanner.executor.v1.UpdateCloudDatabaseActionOrBuilder>
        getUpdateCloudDatabaseFieldBuilder() {
      if (updateCloudDatabaseBuilder_ == null) {
        if (!(actionCase_ == 27)) {
          action_ = com.google.spanner.executor.v1.UpdateCloudDatabaseAction.getDefaultInstance();
        }
        updateCloudDatabaseBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.UpdateCloudDatabaseAction,
                com.google.spanner.executor.v1.UpdateCloudDatabaseAction.Builder,
                com.google.spanner.executor.v1.UpdateCloudDatabaseActionOrBuilder>(
                (com.google.spanner.executor.v1.UpdateCloudDatabaseAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 27;
      onChanged();
      return updateCloudDatabaseBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.DropCloudDatabaseAction,
            com.google.spanner.executor.v1.DropCloudDatabaseAction.Builder,
            com.google.spanner.executor.v1.DropCloudDatabaseActionOrBuilder>
        dropCloudDatabaseBuilder_;
    /**
     *
     *
     * <pre>
     * Action that drops a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DropCloudDatabaseAction drop_cloud_database = 13;</code>
     *
     * @return Whether the dropCloudDatabase field is set.
     */
    @java.lang.Override
    public boolean hasDropCloudDatabase() {
      return actionCase_ == 13;
    }
    /**
     *
     *
     * <pre>
     * Action that drops a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DropCloudDatabaseAction drop_cloud_database = 13;</code>
     *
     * @return The dropCloudDatabase.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.DropCloudDatabaseAction getDropCloudDatabase() {
      if (dropCloudDatabaseBuilder_ == null) {
        if (actionCase_ == 13) {
          return (com.google.spanner.executor.v1.DropCloudDatabaseAction) action_;
        }
        return com.google.spanner.executor.v1.DropCloudDatabaseAction.getDefaultInstance();
      } else {
        if (actionCase_ == 13) {
          return dropCloudDatabaseBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.DropCloudDatabaseAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that drops a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DropCloudDatabaseAction drop_cloud_database = 13;</code>
     */
    public Builder setDropCloudDatabase(
        com.google.spanner.executor.v1.DropCloudDatabaseAction value) {
      if (dropCloudDatabaseBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        dropCloudDatabaseBuilder_.setMessage(value);
      }
      actionCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that drops a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DropCloudDatabaseAction drop_cloud_database = 13;</code>
     */
    public Builder setDropCloudDatabase(
        com.google.spanner.executor.v1.DropCloudDatabaseAction.Builder builderForValue) {
      if (dropCloudDatabaseBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        dropCloudDatabaseBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that drops a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DropCloudDatabaseAction drop_cloud_database = 13;</code>
     */
    public Builder mergeDropCloudDatabase(
        com.google.spanner.executor.v1.DropCloudDatabaseAction value) {
      if (dropCloudDatabaseBuilder_ == null) {
        if (actionCase_ == 13
            && action_
                != com.google.spanner.executor.v1.DropCloudDatabaseAction.getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.DropCloudDatabaseAction.newBuilder(
                      (com.google.spanner.executor.v1.DropCloudDatabaseAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 13) {
          dropCloudDatabaseBuilder_.mergeFrom(value);
        } else {
          dropCloudDatabaseBuilder_.setMessage(value);
        }
      }
      actionCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that drops a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DropCloudDatabaseAction drop_cloud_database = 13;</code>
     */
    public Builder clearDropCloudDatabase() {
      if (dropCloudDatabaseBuilder_ == null) {
        if (actionCase_ == 13) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 13) {
          actionCase_ = 0;
          action_ = null;
        }
        dropCloudDatabaseBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that drops a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DropCloudDatabaseAction drop_cloud_database = 13;</code>
     */
    public com.google.spanner.executor.v1.DropCloudDatabaseAction.Builder
        getDropCloudDatabaseBuilder() {
      return getDropCloudDatabaseFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action that drops a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DropCloudDatabaseAction drop_cloud_database = 13;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.DropCloudDatabaseActionOrBuilder
        getDropCloudDatabaseOrBuilder() {
      if ((actionCase_ == 13) && (dropCloudDatabaseBuilder_ != null)) {
        return dropCloudDatabaseBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 13) {
          return (com.google.spanner.executor.v1.DropCloudDatabaseAction) action_;
        }
        return com.google.spanner.executor.v1.DropCloudDatabaseAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that drops a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DropCloudDatabaseAction drop_cloud_database = 13;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.DropCloudDatabaseAction,
            com.google.spanner.executor.v1.DropCloudDatabaseAction.Builder,
            com.google.spanner.executor.v1.DropCloudDatabaseActionOrBuilder>
        getDropCloudDatabaseFieldBuilder() {
      if (dropCloudDatabaseBuilder_ == null) {
        if (!(actionCase_ == 13)) {
          action_ = com.google.spanner.executor.v1.DropCloudDatabaseAction.getDefaultInstance();
        }
        dropCloudDatabaseBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.DropCloudDatabaseAction,
                com.google.spanner.executor.v1.DropCloudDatabaseAction.Builder,
                com.google.spanner.executor.v1.DropCloudDatabaseActionOrBuilder>(
                (com.google.spanner.executor.v1.DropCloudDatabaseAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 13;
      onChanged();
      return dropCloudDatabaseBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ListCloudDatabasesAction,
            com.google.spanner.executor.v1.ListCloudDatabasesAction.Builder,
            com.google.spanner.executor.v1.ListCloudDatabasesActionOrBuilder>
        listCloudDatabasesBuilder_;
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner databases.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudDatabasesAction list_cloud_databases = 14;</code>
     *
     * @return Whether the listCloudDatabases field is set.
     */
    @java.lang.Override
    public boolean hasListCloudDatabases() {
      return actionCase_ == 14;
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner databases.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudDatabasesAction list_cloud_databases = 14;</code>
     *
     * @return The listCloudDatabases.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.ListCloudDatabasesAction getListCloudDatabases() {
      if (listCloudDatabasesBuilder_ == null) {
        if (actionCase_ == 14) {
          return (com.google.spanner.executor.v1.ListCloudDatabasesAction) action_;
        }
        return com.google.spanner.executor.v1.ListCloudDatabasesAction.getDefaultInstance();
      } else {
        if (actionCase_ == 14) {
          return listCloudDatabasesBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.ListCloudDatabasesAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner databases.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudDatabasesAction list_cloud_databases = 14;</code>
     */
    public Builder setListCloudDatabases(
        com.google.spanner.executor.v1.ListCloudDatabasesAction value) {
      if (listCloudDatabasesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        listCloudDatabasesBuilder_.setMessage(value);
      }
      actionCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner databases.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudDatabasesAction list_cloud_databases = 14;</code>
     */
    public Builder setListCloudDatabases(
        com.google.spanner.executor.v1.ListCloudDatabasesAction.Builder builderForValue) {
      if (listCloudDatabasesBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        listCloudDatabasesBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner databases.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudDatabasesAction list_cloud_databases = 14;</code>
     */
    public Builder mergeListCloudDatabases(
        com.google.spanner.executor.v1.ListCloudDatabasesAction value) {
      if (listCloudDatabasesBuilder_ == null) {
        if (actionCase_ == 14
            && action_
                != com.google.spanner.executor.v1.ListCloudDatabasesAction.getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.ListCloudDatabasesAction.newBuilder(
                      (com.google.spanner.executor.v1.ListCloudDatabasesAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 14) {
          listCloudDatabasesBuilder_.mergeFrom(value);
        } else {
          listCloudDatabasesBuilder_.setMessage(value);
        }
      }
      actionCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner databases.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudDatabasesAction list_cloud_databases = 14;</code>
     */
    public Builder clearListCloudDatabases() {
      if (listCloudDatabasesBuilder_ == null) {
        if (actionCase_ == 14) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 14) {
          actionCase_ = 0;
          action_ = null;
        }
        listCloudDatabasesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner databases.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudDatabasesAction list_cloud_databases = 14;</code>
     */
    public com.google.spanner.executor.v1.ListCloudDatabasesAction.Builder
        getListCloudDatabasesBuilder() {
      return getListCloudDatabasesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner databases.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudDatabasesAction list_cloud_databases = 14;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.ListCloudDatabasesActionOrBuilder
        getListCloudDatabasesOrBuilder() {
      if ((actionCase_ == 14) && (listCloudDatabasesBuilder_ != null)) {
        return listCloudDatabasesBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 14) {
          return (com.google.spanner.executor.v1.ListCloudDatabasesAction) action_;
        }
        return com.google.spanner.executor.v1.ListCloudDatabasesAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner databases.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudDatabasesAction list_cloud_databases = 14;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ListCloudDatabasesAction,
            com.google.spanner.executor.v1.ListCloudDatabasesAction.Builder,
            com.google.spanner.executor.v1.ListCloudDatabasesActionOrBuilder>
        getListCloudDatabasesFieldBuilder() {
      if (listCloudDatabasesBuilder_ == null) {
        if (!(actionCase_ == 14)) {
          action_ = com.google.spanner.executor.v1.ListCloudDatabasesAction.getDefaultInstance();
        }
        listCloudDatabasesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.ListCloudDatabasesAction,
                com.google.spanner.executor.v1.ListCloudDatabasesAction.Builder,
                com.google.spanner.executor.v1.ListCloudDatabasesActionOrBuilder>(
                (com.google.spanner.executor.v1.ListCloudDatabasesAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 14;
      onChanged();
      return listCloudDatabasesBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ListCloudDatabaseOperationsAction,
            com.google.spanner.executor.v1.ListCloudDatabaseOperationsAction.Builder,
            com.google.spanner.executor.v1.ListCloudDatabaseOperationsActionOrBuilder>
        listCloudDatabaseOperationsBuilder_;
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner database operations.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.ListCloudDatabaseOperationsAction list_cloud_database_operations = 15;
     * </code>
     *
     * @return Whether the listCloudDatabaseOperations field is set.
     */
    @java.lang.Override
    public boolean hasListCloudDatabaseOperations() {
      return actionCase_ == 15;
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner database operations.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.ListCloudDatabaseOperationsAction list_cloud_database_operations = 15;
     * </code>
     *
     * @return The listCloudDatabaseOperations.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.ListCloudDatabaseOperationsAction
        getListCloudDatabaseOperations() {
      if (listCloudDatabaseOperationsBuilder_ == null) {
        if (actionCase_ == 15) {
          return (com.google.spanner.executor.v1.ListCloudDatabaseOperationsAction) action_;
        }
        return com.google.spanner.executor.v1.ListCloudDatabaseOperationsAction
            .getDefaultInstance();
      } else {
        if (actionCase_ == 15) {
          return listCloudDatabaseOperationsBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.ListCloudDatabaseOperationsAction
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner database operations.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.ListCloudDatabaseOperationsAction list_cloud_database_operations = 15;
     * </code>
     */
    public Builder setListCloudDatabaseOperations(
        com.google.spanner.executor.v1.ListCloudDatabaseOperationsAction value) {
      if (listCloudDatabaseOperationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        listCloudDatabaseOperationsBuilder_.setMessage(value);
      }
      actionCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner database operations.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.ListCloudDatabaseOperationsAction list_cloud_database_operations = 15;
     * </code>
     */
    public Builder setListCloudDatabaseOperations(
        com.google.spanner.executor.v1.ListCloudDatabaseOperationsAction.Builder builderForValue) {
      if (listCloudDatabaseOperationsBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        listCloudDatabaseOperationsBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner database operations.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.ListCloudDatabaseOperationsAction list_cloud_database_operations = 15;
     * </code>
     */
    public Builder mergeListCloudDatabaseOperations(
        com.google.spanner.executor.v1.ListCloudDatabaseOperationsAction value) {
      if (listCloudDatabaseOperationsBuilder_ == null) {
        if (actionCase_ == 15
            && action_
                != com.google.spanner.executor.v1.ListCloudDatabaseOperationsAction
                    .getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.ListCloudDatabaseOperationsAction.newBuilder(
                      (com.google.spanner.executor.v1.ListCloudDatabaseOperationsAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 15) {
          listCloudDatabaseOperationsBuilder_.mergeFrom(value);
        } else {
          listCloudDatabaseOperationsBuilder_.setMessage(value);
        }
      }
      actionCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner database operations.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.ListCloudDatabaseOperationsAction list_cloud_database_operations = 15;
     * </code>
     */
    public Builder clearListCloudDatabaseOperations() {
      if (listCloudDatabaseOperationsBuilder_ == null) {
        if (actionCase_ == 15) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 15) {
          actionCase_ = 0;
          action_ = null;
        }
        listCloudDatabaseOperationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner database operations.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.ListCloudDatabaseOperationsAction list_cloud_database_operations = 15;
     * </code>
     */
    public com.google.spanner.executor.v1.ListCloudDatabaseOperationsAction.Builder
        getListCloudDatabaseOperationsBuilder() {
      return getListCloudDatabaseOperationsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner database operations.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.ListCloudDatabaseOperationsAction list_cloud_database_operations = 15;
     * </code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.ListCloudDatabaseOperationsActionOrBuilder
        getListCloudDatabaseOperationsOrBuilder() {
      if ((actionCase_ == 15) && (listCloudDatabaseOperationsBuilder_ != null)) {
        return listCloudDatabaseOperationsBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 15) {
          return (com.google.spanner.executor.v1.ListCloudDatabaseOperationsAction) action_;
        }
        return com.google.spanner.executor.v1.ListCloudDatabaseOperationsAction
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner database operations.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.ListCloudDatabaseOperationsAction list_cloud_database_operations = 15;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ListCloudDatabaseOperationsAction,
            com.google.spanner.executor.v1.ListCloudDatabaseOperationsAction.Builder,
            com.google.spanner.executor.v1.ListCloudDatabaseOperationsActionOrBuilder>
        getListCloudDatabaseOperationsFieldBuilder() {
      if (listCloudDatabaseOperationsBuilder_ == null) {
        if (!(actionCase_ == 15)) {
          action_ =
              com.google.spanner.executor.v1.ListCloudDatabaseOperationsAction.getDefaultInstance();
        }
        listCloudDatabaseOperationsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.ListCloudDatabaseOperationsAction,
                com.google.spanner.executor.v1.ListCloudDatabaseOperationsAction.Builder,
                com.google.spanner.executor.v1.ListCloudDatabaseOperationsActionOrBuilder>(
                (com.google.spanner.executor.v1.ListCloudDatabaseOperationsAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 15;
      onChanged();
      return listCloudDatabaseOperationsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.RestoreCloudDatabaseAction,
            com.google.spanner.executor.v1.RestoreCloudDatabaseAction.Builder,
            com.google.spanner.executor.v1.RestoreCloudDatabaseActionOrBuilder>
        restoreCloudDatabaseBuilder_;
    /**
     *
     *
     * <pre>
     * Action that restores a Cloud Spanner database from a backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.RestoreCloudDatabaseAction restore_cloud_database = 16;
     * </code>
     *
     * @return Whether the restoreCloudDatabase field is set.
     */
    @java.lang.Override
    public boolean hasRestoreCloudDatabase() {
      return actionCase_ == 16;
    }
    /**
     *
     *
     * <pre>
     * Action that restores a Cloud Spanner database from a backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.RestoreCloudDatabaseAction restore_cloud_database = 16;
     * </code>
     *
     * @return The restoreCloudDatabase.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.RestoreCloudDatabaseAction getRestoreCloudDatabase() {
      if (restoreCloudDatabaseBuilder_ == null) {
        if (actionCase_ == 16) {
          return (com.google.spanner.executor.v1.RestoreCloudDatabaseAction) action_;
        }
        return com.google.spanner.executor.v1.RestoreCloudDatabaseAction.getDefaultInstance();
      } else {
        if (actionCase_ == 16) {
          return restoreCloudDatabaseBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.RestoreCloudDatabaseAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that restores a Cloud Spanner database from a backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.RestoreCloudDatabaseAction restore_cloud_database = 16;
     * </code>
     */
    public Builder setRestoreCloudDatabase(
        com.google.spanner.executor.v1.RestoreCloudDatabaseAction value) {
      if (restoreCloudDatabaseBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        restoreCloudDatabaseBuilder_.setMessage(value);
      }
      actionCase_ = 16;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that restores a Cloud Spanner database from a backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.RestoreCloudDatabaseAction restore_cloud_database = 16;
     * </code>
     */
    public Builder setRestoreCloudDatabase(
        com.google.spanner.executor.v1.RestoreCloudDatabaseAction.Builder builderForValue) {
      if (restoreCloudDatabaseBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        restoreCloudDatabaseBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 16;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that restores a Cloud Spanner database from a backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.RestoreCloudDatabaseAction restore_cloud_database = 16;
     * </code>
     */
    public Builder mergeRestoreCloudDatabase(
        com.google.spanner.executor.v1.RestoreCloudDatabaseAction value) {
      if (restoreCloudDatabaseBuilder_ == null) {
        if (actionCase_ == 16
            && action_
                != com.google.spanner.executor.v1.RestoreCloudDatabaseAction.getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.RestoreCloudDatabaseAction.newBuilder(
                      (com.google.spanner.executor.v1.RestoreCloudDatabaseAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 16) {
          restoreCloudDatabaseBuilder_.mergeFrom(value);
        } else {
          restoreCloudDatabaseBuilder_.setMessage(value);
        }
      }
      actionCase_ = 16;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that restores a Cloud Spanner database from a backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.RestoreCloudDatabaseAction restore_cloud_database = 16;
     * </code>
     */
    public Builder clearRestoreCloudDatabase() {
      if (restoreCloudDatabaseBuilder_ == null) {
        if (actionCase_ == 16) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 16) {
          actionCase_ = 0;
          action_ = null;
        }
        restoreCloudDatabaseBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that restores a Cloud Spanner database from a backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.RestoreCloudDatabaseAction restore_cloud_database = 16;
     * </code>
     */
    public com.google.spanner.executor.v1.RestoreCloudDatabaseAction.Builder
        getRestoreCloudDatabaseBuilder() {
      return getRestoreCloudDatabaseFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action that restores a Cloud Spanner database from a backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.RestoreCloudDatabaseAction restore_cloud_database = 16;
     * </code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.RestoreCloudDatabaseActionOrBuilder
        getRestoreCloudDatabaseOrBuilder() {
      if ((actionCase_ == 16) && (restoreCloudDatabaseBuilder_ != null)) {
        return restoreCloudDatabaseBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 16) {
          return (com.google.spanner.executor.v1.RestoreCloudDatabaseAction) action_;
        }
        return com.google.spanner.executor.v1.RestoreCloudDatabaseAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that restores a Cloud Spanner database from a backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.RestoreCloudDatabaseAction restore_cloud_database = 16;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.RestoreCloudDatabaseAction,
            com.google.spanner.executor.v1.RestoreCloudDatabaseAction.Builder,
            com.google.spanner.executor.v1.RestoreCloudDatabaseActionOrBuilder>
        getRestoreCloudDatabaseFieldBuilder() {
      if (restoreCloudDatabaseBuilder_ == null) {
        if (!(actionCase_ == 16)) {
          action_ = com.google.spanner.executor.v1.RestoreCloudDatabaseAction.getDefaultInstance();
        }
        restoreCloudDatabaseBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.RestoreCloudDatabaseAction,
                com.google.spanner.executor.v1.RestoreCloudDatabaseAction.Builder,
                com.google.spanner.executor.v1.RestoreCloudDatabaseActionOrBuilder>(
                (com.google.spanner.executor.v1.RestoreCloudDatabaseAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 16;
      onChanged();
      return restoreCloudDatabaseBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.GetCloudDatabaseAction,
            com.google.spanner.executor.v1.GetCloudDatabaseAction.Builder,
            com.google.spanner.executor.v1.GetCloudDatabaseActionOrBuilder>
        getCloudDatabaseBuilder_;
    /**
     *
     *
     * <pre>
     * Action that gets a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudDatabaseAction get_cloud_database = 17;</code>
     *
     * @return Whether the getCloudDatabase field is set.
     */
    @java.lang.Override
    public boolean hasGetCloudDatabase() {
      return actionCase_ == 17;
    }
    /**
     *
     *
     * <pre>
     * Action that gets a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudDatabaseAction get_cloud_database = 17;</code>
     *
     * @return The getCloudDatabase.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.GetCloudDatabaseAction getGetCloudDatabase() {
      if (getCloudDatabaseBuilder_ == null) {
        if (actionCase_ == 17) {
          return (com.google.spanner.executor.v1.GetCloudDatabaseAction) action_;
        }
        return com.google.spanner.executor.v1.GetCloudDatabaseAction.getDefaultInstance();
      } else {
        if (actionCase_ == 17) {
          return getCloudDatabaseBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.GetCloudDatabaseAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that gets a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudDatabaseAction get_cloud_database = 17;</code>
     */
    public Builder setGetCloudDatabase(
        com.google.spanner.executor.v1.GetCloudDatabaseAction value) {
      if (getCloudDatabaseBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        getCloudDatabaseBuilder_.setMessage(value);
      }
      actionCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that gets a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudDatabaseAction get_cloud_database = 17;</code>
     */
    public Builder setGetCloudDatabase(
        com.google.spanner.executor.v1.GetCloudDatabaseAction.Builder builderForValue) {
      if (getCloudDatabaseBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        getCloudDatabaseBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that gets a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudDatabaseAction get_cloud_database = 17;</code>
     */
    public Builder mergeGetCloudDatabase(
        com.google.spanner.executor.v1.GetCloudDatabaseAction value) {
      if (getCloudDatabaseBuilder_ == null) {
        if (actionCase_ == 17
            && action_
                != com.google.spanner.executor.v1.GetCloudDatabaseAction.getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.GetCloudDatabaseAction.newBuilder(
                      (com.google.spanner.executor.v1.GetCloudDatabaseAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 17) {
          getCloudDatabaseBuilder_.mergeFrom(value);
        } else {
          getCloudDatabaseBuilder_.setMessage(value);
        }
      }
      actionCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that gets a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudDatabaseAction get_cloud_database = 17;</code>
     */
    public Builder clearGetCloudDatabase() {
      if (getCloudDatabaseBuilder_ == null) {
        if (actionCase_ == 17) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 17) {
          actionCase_ = 0;
          action_ = null;
        }
        getCloudDatabaseBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that gets a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudDatabaseAction get_cloud_database = 17;</code>
     */
    public com.google.spanner.executor.v1.GetCloudDatabaseAction.Builder
        getGetCloudDatabaseBuilder() {
      return getGetCloudDatabaseFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action that gets a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudDatabaseAction get_cloud_database = 17;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.GetCloudDatabaseActionOrBuilder
        getGetCloudDatabaseOrBuilder() {
      if ((actionCase_ == 17) && (getCloudDatabaseBuilder_ != null)) {
        return getCloudDatabaseBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 17) {
          return (com.google.spanner.executor.v1.GetCloudDatabaseAction) action_;
        }
        return com.google.spanner.executor.v1.GetCloudDatabaseAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that gets a Cloud Spanner database.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudDatabaseAction get_cloud_database = 17;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.GetCloudDatabaseAction,
            com.google.spanner.executor.v1.GetCloudDatabaseAction.Builder,
            com.google.spanner.executor.v1.GetCloudDatabaseActionOrBuilder>
        getGetCloudDatabaseFieldBuilder() {
      if (getCloudDatabaseBuilder_ == null) {
        if (!(actionCase_ == 17)) {
          action_ = com.google.spanner.executor.v1.GetCloudDatabaseAction.getDefaultInstance();
        }
        getCloudDatabaseBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.GetCloudDatabaseAction,
                com.google.spanner.executor.v1.GetCloudDatabaseAction.Builder,
                com.google.spanner.executor.v1.GetCloudDatabaseActionOrBuilder>(
                (com.google.spanner.executor.v1.GetCloudDatabaseAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 17;
      onChanged();
      return getCloudDatabaseBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.CreateCloudBackupAction,
            com.google.spanner.executor.v1.CreateCloudBackupAction.Builder,
            com.google.spanner.executor.v1.CreateCloudBackupActionOrBuilder>
        createCloudBackupBuilder_;
    /**
     *
     *
     * <pre>
     * Action that creates a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CreateCloudBackupAction create_cloud_backup = 18;</code>
     *
     * @return Whether the createCloudBackup field is set.
     */
    @java.lang.Override
    public boolean hasCreateCloudBackup() {
      return actionCase_ == 18;
    }
    /**
     *
     *
     * <pre>
     * Action that creates a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CreateCloudBackupAction create_cloud_backup = 18;</code>
     *
     * @return The createCloudBackup.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.CreateCloudBackupAction getCreateCloudBackup() {
      if (createCloudBackupBuilder_ == null) {
        if (actionCase_ == 18) {
          return (com.google.spanner.executor.v1.CreateCloudBackupAction) action_;
        }
        return com.google.spanner.executor.v1.CreateCloudBackupAction.getDefaultInstance();
      } else {
        if (actionCase_ == 18) {
          return createCloudBackupBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.CreateCloudBackupAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that creates a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CreateCloudBackupAction create_cloud_backup = 18;</code>
     */
    public Builder setCreateCloudBackup(
        com.google.spanner.executor.v1.CreateCloudBackupAction value) {
      if (createCloudBackupBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        createCloudBackupBuilder_.setMessage(value);
      }
      actionCase_ = 18;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that creates a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CreateCloudBackupAction create_cloud_backup = 18;</code>
     */
    public Builder setCreateCloudBackup(
        com.google.spanner.executor.v1.CreateCloudBackupAction.Builder builderForValue) {
      if (createCloudBackupBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        createCloudBackupBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 18;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that creates a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CreateCloudBackupAction create_cloud_backup = 18;</code>
     */
    public Builder mergeCreateCloudBackup(
        com.google.spanner.executor.v1.CreateCloudBackupAction value) {
      if (createCloudBackupBuilder_ == null) {
        if (actionCase_ == 18
            && action_
                != com.google.spanner.executor.v1.CreateCloudBackupAction.getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.CreateCloudBackupAction.newBuilder(
                      (com.google.spanner.executor.v1.CreateCloudBackupAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 18) {
          createCloudBackupBuilder_.mergeFrom(value);
        } else {
          createCloudBackupBuilder_.setMessage(value);
        }
      }
      actionCase_ = 18;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that creates a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CreateCloudBackupAction create_cloud_backup = 18;</code>
     */
    public Builder clearCreateCloudBackup() {
      if (createCloudBackupBuilder_ == null) {
        if (actionCase_ == 18) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 18) {
          actionCase_ = 0;
          action_ = null;
        }
        createCloudBackupBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that creates a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CreateCloudBackupAction create_cloud_backup = 18;</code>
     */
    public com.google.spanner.executor.v1.CreateCloudBackupAction.Builder
        getCreateCloudBackupBuilder() {
      return getCreateCloudBackupFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action that creates a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CreateCloudBackupAction create_cloud_backup = 18;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.CreateCloudBackupActionOrBuilder
        getCreateCloudBackupOrBuilder() {
      if ((actionCase_ == 18) && (createCloudBackupBuilder_ != null)) {
        return createCloudBackupBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 18) {
          return (com.google.spanner.executor.v1.CreateCloudBackupAction) action_;
        }
        return com.google.spanner.executor.v1.CreateCloudBackupAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that creates a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CreateCloudBackupAction create_cloud_backup = 18;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.CreateCloudBackupAction,
            com.google.spanner.executor.v1.CreateCloudBackupAction.Builder,
            com.google.spanner.executor.v1.CreateCloudBackupActionOrBuilder>
        getCreateCloudBackupFieldBuilder() {
      if (createCloudBackupBuilder_ == null) {
        if (!(actionCase_ == 18)) {
          action_ = com.google.spanner.executor.v1.CreateCloudBackupAction.getDefaultInstance();
        }
        createCloudBackupBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.CreateCloudBackupAction,
                com.google.spanner.executor.v1.CreateCloudBackupAction.Builder,
                com.google.spanner.executor.v1.CreateCloudBackupActionOrBuilder>(
                (com.google.spanner.executor.v1.CreateCloudBackupAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 18;
      onChanged();
      return createCloudBackupBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.CopyCloudBackupAction,
            com.google.spanner.executor.v1.CopyCloudBackupAction.Builder,
            com.google.spanner.executor.v1.CopyCloudBackupActionOrBuilder>
        copyCloudBackupBuilder_;
    /**
     *
     *
     * <pre>
     * Action that copies a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CopyCloudBackupAction copy_cloud_backup = 19;</code>
     *
     * @return Whether the copyCloudBackup field is set.
     */
    @java.lang.Override
    public boolean hasCopyCloudBackup() {
      return actionCase_ == 19;
    }
    /**
     *
     *
     * <pre>
     * Action that copies a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CopyCloudBackupAction copy_cloud_backup = 19;</code>
     *
     * @return The copyCloudBackup.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.CopyCloudBackupAction getCopyCloudBackup() {
      if (copyCloudBackupBuilder_ == null) {
        if (actionCase_ == 19) {
          return (com.google.spanner.executor.v1.CopyCloudBackupAction) action_;
        }
        return com.google.spanner.executor.v1.CopyCloudBackupAction.getDefaultInstance();
      } else {
        if (actionCase_ == 19) {
          return copyCloudBackupBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.CopyCloudBackupAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that copies a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CopyCloudBackupAction copy_cloud_backup = 19;</code>
     */
    public Builder setCopyCloudBackup(com.google.spanner.executor.v1.CopyCloudBackupAction value) {
      if (copyCloudBackupBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        copyCloudBackupBuilder_.setMessage(value);
      }
      actionCase_ = 19;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that copies a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CopyCloudBackupAction copy_cloud_backup = 19;</code>
     */
    public Builder setCopyCloudBackup(
        com.google.spanner.executor.v1.CopyCloudBackupAction.Builder builderForValue) {
      if (copyCloudBackupBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        copyCloudBackupBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 19;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that copies a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CopyCloudBackupAction copy_cloud_backup = 19;</code>
     */
    public Builder mergeCopyCloudBackup(
        com.google.spanner.executor.v1.CopyCloudBackupAction value) {
      if (copyCloudBackupBuilder_ == null) {
        if (actionCase_ == 19
            && action_
                != com.google.spanner.executor.v1.CopyCloudBackupAction.getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.CopyCloudBackupAction.newBuilder(
                      (com.google.spanner.executor.v1.CopyCloudBackupAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 19) {
          copyCloudBackupBuilder_.mergeFrom(value);
        } else {
          copyCloudBackupBuilder_.setMessage(value);
        }
      }
      actionCase_ = 19;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that copies a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CopyCloudBackupAction copy_cloud_backup = 19;</code>
     */
    public Builder clearCopyCloudBackup() {
      if (copyCloudBackupBuilder_ == null) {
        if (actionCase_ == 19) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 19) {
          actionCase_ = 0;
          action_ = null;
        }
        copyCloudBackupBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that copies a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CopyCloudBackupAction copy_cloud_backup = 19;</code>
     */
    public com.google.spanner.executor.v1.CopyCloudBackupAction.Builder
        getCopyCloudBackupBuilder() {
      return getCopyCloudBackupFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action that copies a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CopyCloudBackupAction copy_cloud_backup = 19;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.CopyCloudBackupActionOrBuilder
        getCopyCloudBackupOrBuilder() {
      if ((actionCase_ == 19) && (copyCloudBackupBuilder_ != null)) {
        return copyCloudBackupBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 19) {
          return (com.google.spanner.executor.v1.CopyCloudBackupAction) action_;
        }
        return com.google.spanner.executor.v1.CopyCloudBackupAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that copies a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CopyCloudBackupAction copy_cloud_backup = 19;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.CopyCloudBackupAction,
            com.google.spanner.executor.v1.CopyCloudBackupAction.Builder,
            com.google.spanner.executor.v1.CopyCloudBackupActionOrBuilder>
        getCopyCloudBackupFieldBuilder() {
      if (copyCloudBackupBuilder_ == null) {
        if (!(actionCase_ == 19)) {
          action_ = com.google.spanner.executor.v1.CopyCloudBackupAction.getDefaultInstance();
        }
        copyCloudBackupBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.CopyCloudBackupAction,
                com.google.spanner.executor.v1.CopyCloudBackupAction.Builder,
                com.google.spanner.executor.v1.CopyCloudBackupActionOrBuilder>(
                (com.google.spanner.executor.v1.CopyCloudBackupAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 19;
      onChanged();
      return copyCloudBackupBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.GetCloudBackupAction,
            com.google.spanner.executor.v1.GetCloudBackupAction.Builder,
            com.google.spanner.executor.v1.GetCloudBackupActionOrBuilder>
        getCloudBackupBuilder_;
    /**
     *
     *
     * <pre>
     * Action that gets a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudBackupAction get_cloud_backup = 20;</code>
     *
     * @return Whether the getCloudBackup field is set.
     */
    @java.lang.Override
    public boolean hasGetCloudBackup() {
      return actionCase_ == 20;
    }
    /**
     *
     *
     * <pre>
     * Action that gets a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudBackupAction get_cloud_backup = 20;</code>
     *
     * @return The getCloudBackup.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.GetCloudBackupAction getGetCloudBackup() {
      if (getCloudBackupBuilder_ == null) {
        if (actionCase_ == 20) {
          return (com.google.spanner.executor.v1.GetCloudBackupAction) action_;
        }
        return com.google.spanner.executor.v1.GetCloudBackupAction.getDefaultInstance();
      } else {
        if (actionCase_ == 20) {
          return getCloudBackupBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.GetCloudBackupAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that gets a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudBackupAction get_cloud_backup = 20;</code>
     */
    public Builder setGetCloudBackup(com.google.spanner.executor.v1.GetCloudBackupAction value) {
      if (getCloudBackupBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        getCloudBackupBuilder_.setMessage(value);
      }
      actionCase_ = 20;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that gets a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudBackupAction get_cloud_backup = 20;</code>
     */
    public Builder setGetCloudBackup(
        com.google.spanner.executor.v1.GetCloudBackupAction.Builder builderForValue) {
      if (getCloudBackupBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        getCloudBackupBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 20;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that gets a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudBackupAction get_cloud_backup = 20;</code>
     */
    public Builder mergeGetCloudBackup(com.google.spanner.executor.v1.GetCloudBackupAction value) {
      if (getCloudBackupBuilder_ == null) {
        if (actionCase_ == 20
            && action_
                != com.google.spanner.executor.v1.GetCloudBackupAction.getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.GetCloudBackupAction.newBuilder(
                      (com.google.spanner.executor.v1.GetCloudBackupAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 20) {
          getCloudBackupBuilder_.mergeFrom(value);
        } else {
          getCloudBackupBuilder_.setMessage(value);
        }
      }
      actionCase_ = 20;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that gets a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudBackupAction get_cloud_backup = 20;</code>
     */
    public Builder clearGetCloudBackup() {
      if (getCloudBackupBuilder_ == null) {
        if (actionCase_ == 20) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 20) {
          actionCase_ = 0;
          action_ = null;
        }
        getCloudBackupBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that gets a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudBackupAction get_cloud_backup = 20;</code>
     */
    public com.google.spanner.executor.v1.GetCloudBackupAction.Builder getGetCloudBackupBuilder() {
      return getGetCloudBackupFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action that gets a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudBackupAction get_cloud_backup = 20;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.GetCloudBackupActionOrBuilder
        getGetCloudBackupOrBuilder() {
      if ((actionCase_ == 20) && (getCloudBackupBuilder_ != null)) {
        return getCloudBackupBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 20) {
          return (com.google.spanner.executor.v1.GetCloudBackupAction) action_;
        }
        return com.google.spanner.executor.v1.GetCloudBackupAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that gets a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetCloudBackupAction get_cloud_backup = 20;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.GetCloudBackupAction,
            com.google.spanner.executor.v1.GetCloudBackupAction.Builder,
            com.google.spanner.executor.v1.GetCloudBackupActionOrBuilder>
        getGetCloudBackupFieldBuilder() {
      if (getCloudBackupBuilder_ == null) {
        if (!(actionCase_ == 20)) {
          action_ = com.google.spanner.executor.v1.GetCloudBackupAction.getDefaultInstance();
        }
        getCloudBackupBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.GetCloudBackupAction,
                com.google.spanner.executor.v1.GetCloudBackupAction.Builder,
                com.google.spanner.executor.v1.GetCloudBackupActionOrBuilder>(
                (com.google.spanner.executor.v1.GetCloudBackupAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 20;
      onChanged();
      return getCloudBackupBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.UpdateCloudBackupAction,
            com.google.spanner.executor.v1.UpdateCloudBackupAction.Builder,
            com.google.spanner.executor.v1.UpdateCloudBackupActionOrBuilder>
        updateCloudBackupBuilder_;
    /**
     *
     *
     * <pre>
     * Action that updates a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.UpdateCloudBackupAction update_cloud_backup = 21;</code>
     *
     * @return Whether the updateCloudBackup field is set.
     */
    @java.lang.Override
    public boolean hasUpdateCloudBackup() {
      return actionCase_ == 21;
    }
    /**
     *
     *
     * <pre>
     * Action that updates a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.UpdateCloudBackupAction update_cloud_backup = 21;</code>
     *
     * @return The updateCloudBackup.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.UpdateCloudBackupAction getUpdateCloudBackup() {
      if (updateCloudBackupBuilder_ == null) {
        if (actionCase_ == 21) {
          return (com.google.spanner.executor.v1.UpdateCloudBackupAction) action_;
        }
        return com.google.spanner.executor.v1.UpdateCloudBackupAction.getDefaultInstance();
      } else {
        if (actionCase_ == 21) {
          return updateCloudBackupBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.UpdateCloudBackupAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that updates a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.UpdateCloudBackupAction update_cloud_backup = 21;</code>
     */
    public Builder setUpdateCloudBackup(
        com.google.spanner.executor.v1.UpdateCloudBackupAction value) {
      if (updateCloudBackupBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        updateCloudBackupBuilder_.setMessage(value);
      }
      actionCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that updates a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.UpdateCloudBackupAction update_cloud_backup = 21;</code>
     */
    public Builder setUpdateCloudBackup(
        com.google.spanner.executor.v1.UpdateCloudBackupAction.Builder builderForValue) {
      if (updateCloudBackupBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        updateCloudBackupBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that updates a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.UpdateCloudBackupAction update_cloud_backup = 21;</code>
     */
    public Builder mergeUpdateCloudBackup(
        com.google.spanner.executor.v1.UpdateCloudBackupAction value) {
      if (updateCloudBackupBuilder_ == null) {
        if (actionCase_ == 21
            && action_
                != com.google.spanner.executor.v1.UpdateCloudBackupAction.getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.UpdateCloudBackupAction.newBuilder(
                      (com.google.spanner.executor.v1.UpdateCloudBackupAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 21) {
          updateCloudBackupBuilder_.mergeFrom(value);
        } else {
          updateCloudBackupBuilder_.setMessage(value);
        }
      }
      actionCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that updates a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.UpdateCloudBackupAction update_cloud_backup = 21;</code>
     */
    public Builder clearUpdateCloudBackup() {
      if (updateCloudBackupBuilder_ == null) {
        if (actionCase_ == 21) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 21) {
          actionCase_ = 0;
          action_ = null;
        }
        updateCloudBackupBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that updates a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.UpdateCloudBackupAction update_cloud_backup = 21;</code>
     */
    public com.google.spanner.executor.v1.UpdateCloudBackupAction.Builder
        getUpdateCloudBackupBuilder() {
      return getUpdateCloudBackupFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action that updates a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.UpdateCloudBackupAction update_cloud_backup = 21;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.UpdateCloudBackupActionOrBuilder
        getUpdateCloudBackupOrBuilder() {
      if ((actionCase_ == 21) && (updateCloudBackupBuilder_ != null)) {
        return updateCloudBackupBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 21) {
          return (com.google.spanner.executor.v1.UpdateCloudBackupAction) action_;
        }
        return com.google.spanner.executor.v1.UpdateCloudBackupAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that updates a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.UpdateCloudBackupAction update_cloud_backup = 21;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.UpdateCloudBackupAction,
            com.google.spanner.executor.v1.UpdateCloudBackupAction.Builder,
            com.google.spanner.executor.v1.UpdateCloudBackupActionOrBuilder>
        getUpdateCloudBackupFieldBuilder() {
      if (updateCloudBackupBuilder_ == null) {
        if (!(actionCase_ == 21)) {
          action_ = com.google.spanner.executor.v1.UpdateCloudBackupAction.getDefaultInstance();
        }
        updateCloudBackupBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.UpdateCloudBackupAction,
                com.google.spanner.executor.v1.UpdateCloudBackupAction.Builder,
                com.google.spanner.executor.v1.UpdateCloudBackupActionOrBuilder>(
                (com.google.spanner.executor.v1.UpdateCloudBackupAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 21;
      onChanged();
      return updateCloudBackupBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.DeleteCloudBackupAction,
            com.google.spanner.executor.v1.DeleteCloudBackupAction.Builder,
            com.google.spanner.executor.v1.DeleteCloudBackupActionOrBuilder>
        deleteCloudBackupBuilder_;
    /**
     *
     *
     * <pre>
     * Action that deletes a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DeleteCloudBackupAction delete_cloud_backup = 22;</code>
     *
     * @return Whether the deleteCloudBackup field is set.
     */
    @java.lang.Override
    public boolean hasDeleteCloudBackup() {
      return actionCase_ == 22;
    }
    /**
     *
     *
     * <pre>
     * Action that deletes a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DeleteCloudBackupAction delete_cloud_backup = 22;</code>
     *
     * @return The deleteCloudBackup.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.DeleteCloudBackupAction getDeleteCloudBackup() {
      if (deleteCloudBackupBuilder_ == null) {
        if (actionCase_ == 22) {
          return (com.google.spanner.executor.v1.DeleteCloudBackupAction) action_;
        }
        return com.google.spanner.executor.v1.DeleteCloudBackupAction.getDefaultInstance();
      } else {
        if (actionCase_ == 22) {
          return deleteCloudBackupBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.DeleteCloudBackupAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that deletes a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DeleteCloudBackupAction delete_cloud_backup = 22;</code>
     */
    public Builder setDeleteCloudBackup(
        com.google.spanner.executor.v1.DeleteCloudBackupAction value) {
      if (deleteCloudBackupBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        deleteCloudBackupBuilder_.setMessage(value);
      }
      actionCase_ = 22;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that deletes a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DeleteCloudBackupAction delete_cloud_backup = 22;</code>
     */
    public Builder setDeleteCloudBackup(
        com.google.spanner.executor.v1.DeleteCloudBackupAction.Builder builderForValue) {
      if (deleteCloudBackupBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        deleteCloudBackupBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 22;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that deletes a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DeleteCloudBackupAction delete_cloud_backup = 22;</code>
     */
    public Builder mergeDeleteCloudBackup(
        com.google.spanner.executor.v1.DeleteCloudBackupAction value) {
      if (deleteCloudBackupBuilder_ == null) {
        if (actionCase_ == 22
            && action_
                != com.google.spanner.executor.v1.DeleteCloudBackupAction.getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.DeleteCloudBackupAction.newBuilder(
                      (com.google.spanner.executor.v1.DeleteCloudBackupAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 22) {
          deleteCloudBackupBuilder_.mergeFrom(value);
        } else {
          deleteCloudBackupBuilder_.setMessage(value);
        }
      }
      actionCase_ = 22;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that deletes a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DeleteCloudBackupAction delete_cloud_backup = 22;</code>
     */
    public Builder clearDeleteCloudBackup() {
      if (deleteCloudBackupBuilder_ == null) {
        if (actionCase_ == 22) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 22) {
          actionCase_ = 0;
          action_ = null;
        }
        deleteCloudBackupBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that deletes a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DeleteCloudBackupAction delete_cloud_backup = 22;</code>
     */
    public com.google.spanner.executor.v1.DeleteCloudBackupAction.Builder
        getDeleteCloudBackupBuilder() {
      return getDeleteCloudBackupFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action that deletes a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DeleteCloudBackupAction delete_cloud_backup = 22;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.DeleteCloudBackupActionOrBuilder
        getDeleteCloudBackupOrBuilder() {
      if ((actionCase_ == 22) && (deleteCloudBackupBuilder_ != null)) {
        return deleteCloudBackupBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 22) {
          return (com.google.spanner.executor.v1.DeleteCloudBackupAction) action_;
        }
        return com.google.spanner.executor.v1.DeleteCloudBackupAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that deletes a Cloud Spanner database backup.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DeleteCloudBackupAction delete_cloud_backup = 22;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.DeleteCloudBackupAction,
            com.google.spanner.executor.v1.DeleteCloudBackupAction.Builder,
            com.google.spanner.executor.v1.DeleteCloudBackupActionOrBuilder>
        getDeleteCloudBackupFieldBuilder() {
      if (deleteCloudBackupBuilder_ == null) {
        if (!(actionCase_ == 22)) {
          action_ = com.google.spanner.executor.v1.DeleteCloudBackupAction.getDefaultInstance();
        }
        deleteCloudBackupBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.DeleteCloudBackupAction,
                com.google.spanner.executor.v1.DeleteCloudBackupAction.Builder,
                com.google.spanner.executor.v1.DeleteCloudBackupActionOrBuilder>(
                (com.google.spanner.executor.v1.DeleteCloudBackupAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 22;
      onChanged();
      return deleteCloudBackupBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ListCloudBackupsAction,
            com.google.spanner.executor.v1.ListCloudBackupsAction.Builder,
            com.google.spanner.executor.v1.ListCloudBackupsActionOrBuilder>
        listCloudBackupsBuilder_;
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner database backups.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudBackupsAction list_cloud_backups = 23;</code>
     *
     * @return Whether the listCloudBackups field is set.
     */
    @java.lang.Override
    public boolean hasListCloudBackups() {
      return actionCase_ == 23;
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner database backups.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudBackupsAction list_cloud_backups = 23;</code>
     *
     * @return The listCloudBackups.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.ListCloudBackupsAction getListCloudBackups() {
      if (listCloudBackupsBuilder_ == null) {
        if (actionCase_ == 23) {
          return (com.google.spanner.executor.v1.ListCloudBackupsAction) action_;
        }
        return com.google.spanner.executor.v1.ListCloudBackupsAction.getDefaultInstance();
      } else {
        if (actionCase_ == 23) {
          return listCloudBackupsBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.ListCloudBackupsAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner database backups.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudBackupsAction list_cloud_backups = 23;</code>
     */
    public Builder setListCloudBackups(
        com.google.spanner.executor.v1.ListCloudBackupsAction value) {
      if (listCloudBackupsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        listCloudBackupsBuilder_.setMessage(value);
      }
      actionCase_ = 23;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner database backups.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudBackupsAction list_cloud_backups = 23;</code>
     */
    public Builder setListCloudBackups(
        com.google.spanner.executor.v1.ListCloudBackupsAction.Builder builderForValue) {
      if (listCloudBackupsBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        listCloudBackupsBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 23;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner database backups.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudBackupsAction list_cloud_backups = 23;</code>
     */
    public Builder mergeListCloudBackups(
        com.google.spanner.executor.v1.ListCloudBackupsAction value) {
      if (listCloudBackupsBuilder_ == null) {
        if (actionCase_ == 23
            && action_
                != com.google.spanner.executor.v1.ListCloudBackupsAction.getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.ListCloudBackupsAction.newBuilder(
                      (com.google.spanner.executor.v1.ListCloudBackupsAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 23) {
          listCloudBackupsBuilder_.mergeFrom(value);
        } else {
          listCloudBackupsBuilder_.setMessage(value);
        }
      }
      actionCase_ = 23;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner database backups.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudBackupsAction list_cloud_backups = 23;</code>
     */
    public Builder clearListCloudBackups() {
      if (listCloudBackupsBuilder_ == null) {
        if (actionCase_ == 23) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 23) {
          actionCase_ = 0;
          action_ = null;
        }
        listCloudBackupsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner database backups.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudBackupsAction list_cloud_backups = 23;</code>
     */
    public com.google.spanner.executor.v1.ListCloudBackupsAction.Builder
        getListCloudBackupsBuilder() {
      return getListCloudBackupsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner database backups.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudBackupsAction list_cloud_backups = 23;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.ListCloudBackupsActionOrBuilder
        getListCloudBackupsOrBuilder() {
      if ((actionCase_ == 23) && (listCloudBackupsBuilder_ != null)) {
        return listCloudBackupsBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 23) {
          return (com.google.spanner.executor.v1.ListCloudBackupsAction) action_;
        }
        return com.google.spanner.executor.v1.ListCloudBackupsAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner database backups.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ListCloudBackupsAction list_cloud_backups = 23;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ListCloudBackupsAction,
            com.google.spanner.executor.v1.ListCloudBackupsAction.Builder,
            com.google.spanner.executor.v1.ListCloudBackupsActionOrBuilder>
        getListCloudBackupsFieldBuilder() {
      if (listCloudBackupsBuilder_ == null) {
        if (!(actionCase_ == 23)) {
          action_ = com.google.spanner.executor.v1.ListCloudBackupsAction.getDefaultInstance();
        }
        listCloudBackupsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.ListCloudBackupsAction,
                com.google.spanner.executor.v1.ListCloudBackupsAction.Builder,
                com.google.spanner.executor.v1.ListCloudBackupsActionOrBuilder>(
                (com.google.spanner.executor.v1.ListCloudBackupsAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 23;
      onChanged();
      return listCloudBackupsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ListCloudBackupOperationsAction,
            com.google.spanner.executor.v1.ListCloudBackupOperationsAction.Builder,
            com.google.spanner.executor.v1.ListCloudBackupOperationsActionOrBuilder>
        listCloudBackupOperationsBuilder_;
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner database backup operations.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.ListCloudBackupOperationsAction list_cloud_backup_operations = 24;
     * </code>
     *
     * @return Whether the listCloudBackupOperations field is set.
     */
    @java.lang.Override
    public boolean hasListCloudBackupOperations() {
      return actionCase_ == 24;
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner database backup operations.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.ListCloudBackupOperationsAction list_cloud_backup_operations = 24;
     * </code>
     *
     * @return The listCloudBackupOperations.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.ListCloudBackupOperationsAction
        getListCloudBackupOperations() {
      if (listCloudBackupOperationsBuilder_ == null) {
        if (actionCase_ == 24) {
          return (com.google.spanner.executor.v1.ListCloudBackupOperationsAction) action_;
        }
        return com.google.spanner.executor.v1.ListCloudBackupOperationsAction.getDefaultInstance();
      } else {
        if (actionCase_ == 24) {
          return listCloudBackupOperationsBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.ListCloudBackupOperationsAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner database backup operations.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.ListCloudBackupOperationsAction list_cloud_backup_operations = 24;
     * </code>
     */
    public Builder setListCloudBackupOperations(
        com.google.spanner.executor.v1.ListCloudBackupOperationsAction value) {
      if (listCloudBackupOperationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        listCloudBackupOperationsBuilder_.setMessage(value);
      }
      actionCase_ = 24;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner database backup operations.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.ListCloudBackupOperationsAction list_cloud_backup_operations = 24;
     * </code>
     */
    public Builder setListCloudBackupOperations(
        com.google.spanner.executor.v1.ListCloudBackupOperationsAction.Builder builderForValue) {
      if (listCloudBackupOperationsBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        listCloudBackupOperationsBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 24;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner database backup operations.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.ListCloudBackupOperationsAction list_cloud_backup_operations = 24;
     * </code>
     */
    public Builder mergeListCloudBackupOperations(
        com.google.spanner.executor.v1.ListCloudBackupOperationsAction value) {
      if (listCloudBackupOperationsBuilder_ == null) {
        if (actionCase_ == 24
            && action_
                != com.google.spanner.executor.v1.ListCloudBackupOperationsAction
                    .getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.ListCloudBackupOperationsAction.newBuilder(
                      (com.google.spanner.executor.v1.ListCloudBackupOperationsAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 24) {
          listCloudBackupOperationsBuilder_.mergeFrom(value);
        } else {
          listCloudBackupOperationsBuilder_.setMessage(value);
        }
      }
      actionCase_ = 24;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner database backup operations.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.ListCloudBackupOperationsAction list_cloud_backup_operations = 24;
     * </code>
     */
    public Builder clearListCloudBackupOperations() {
      if (listCloudBackupOperationsBuilder_ == null) {
        if (actionCase_ == 24) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 24) {
          actionCase_ = 0;
          action_ = null;
        }
        listCloudBackupOperationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner database backup operations.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.ListCloudBackupOperationsAction list_cloud_backup_operations = 24;
     * </code>
     */
    public com.google.spanner.executor.v1.ListCloudBackupOperationsAction.Builder
        getListCloudBackupOperationsBuilder() {
      return getListCloudBackupOperationsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner database backup operations.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.ListCloudBackupOperationsAction list_cloud_backup_operations = 24;
     * </code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.ListCloudBackupOperationsActionOrBuilder
        getListCloudBackupOperationsOrBuilder() {
      if ((actionCase_ == 24) && (listCloudBackupOperationsBuilder_ != null)) {
        return listCloudBackupOperationsBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 24) {
          return (com.google.spanner.executor.v1.ListCloudBackupOperationsAction) action_;
        }
        return com.google.spanner.executor.v1.ListCloudBackupOperationsAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that lists Cloud Spanner database backup operations.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.ListCloudBackupOperationsAction list_cloud_backup_operations = 24;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ListCloudBackupOperationsAction,
            com.google.spanner.executor.v1.ListCloudBackupOperationsAction.Builder,
            com.google.spanner.executor.v1.ListCloudBackupOperationsActionOrBuilder>
        getListCloudBackupOperationsFieldBuilder() {
      if (listCloudBackupOperationsBuilder_ == null) {
        if (!(actionCase_ == 24)) {
          action_ =
              com.google.spanner.executor.v1.ListCloudBackupOperationsAction.getDefaultInstance();
        }
        listCloudBackupOperationsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.ListCloudBackupOperationsAction,
                com.google.spanner.executor.v1.ListCloudBackupOperationsAction.Builder,
                com.google.spanner.executor.v1.ListCloudBackupOperationsActionOrBuilder>(
                (com.google.spanner.executor.v1.ListCloudBackupOperationsAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 24;
      onChanged();
      return listCloudBackupOperationsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.GetOperationAction,
            com.google.spanner.executor.v1.GetOperationAction.Builder,
            com.google.spanner.executor.v1.GetOperationActionOrBuilder>
        getOperationBuilder_;
    /**
     *
     *
     * <pre>
     * Action that gets an operation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetOperationAction get_operation = 25;</code>
     *
     * @return Whether the getOperation field is set.
     */
    @java.lang.Override
    public boolean hasGetOperation() {
      return actionCase_ == 25;
    }
    /**
     *
     *
     * <pre>
     * Action that gets an operation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetOperationAction get_operation = 25;</code>
     *
     * @return The getOperation.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.GetOperationAction getGetOperation() {
      if (getOperationBuilder_ == null) {
        if (actionCase_ == 25) {
          return (com.google.spanner.executor.v1.GetOperationAction) action_;
        }
        return com.google.spanner.executor.v1.GetOperationAction.getDefaultInstance();
      } else {
        if (actionCase_ == 25) {
          return getOperationBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.GetOperationAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that gets an operation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetOperationAction get_operation = 25;</code>
     */
    public Builder setGetOperation(com.google.spanner.executor.v1.GetOperationAction value) {
      if (getOperationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        getOperationBuilder_.setMessage(value);
      }
      actionCase_ = 25;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that gets an operation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetOperationAction get_operation = 25;</code>
     */
    public Builder setGetOperation(
        com.google.spanner.executor.v1.GetOperationAction.Builder builderForValue) {
      if (getOperationBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        getOperationBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 25;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that gets an operation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetOperationAction get_operation = 25;</code>
     */
    public Builder mergeGetOperation(com.google.spanner.executor.v1.GetOperationAction value) {
      if (getOperationBuilder_ == null) {
        if (actionCase_ == 25
            && action_ != com.google.spanner.executor.v1.GetOperationAction.getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.GetOperationAction.newBuilder(
                      (com.google.spanner.executor.v1.GetOperationAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 25) {
          getOperationBuilder_.mergeFrom(value);
        } else {
          getOperationBuilder_.setMessage(value);
        }
      }
      actionCase_ = 25;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that gets an operation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetOperationAction get_operation = 25;</code>
     */
    public Builder clearGetOperation() {
      if (getOperationBuilder_ == null) {
        if (actionCase_ == 25) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 25) {
          actionCase_ = 0;
          action_ = null;
        }
        getOperationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that gets an operation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetOperationAction get_operation = 25;</code>
     */
    public com.google.spanner.executor.v1.GetOperationAction.Builder getGetOperationBuilder() {
      return getGetOperationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action that gets an operation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetOperationAction get_operation = 25;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.GetOperationActionOrBuilder getGetOperationOrBuilder() {
      if ((actionCase_ == 25) && (getOperationBuilder_ != null)) {
        return getOperationBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 25) {
          return (com.google.spanner.executor.v1.GetOperationAction) action_;
        }
        return com.google.spanner.executor.v1.GetOperationAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that gets an operation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.GetOperationAction get_operation = 25;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.GetOperationAction,
            com.google.spanner.executor.v1.GetOperationAction.Builder,
            com.google.spanner.executor.v1.GetOperationActionOrBuilder>
        getGetOperationFieldBuilder() {
      if (getOperationBuilder_ == null) {
        if (!(actionCase_ == 25)) {
          action_ = com.google.spanner.executor.v1.GetOperationAction.getDefaultInstance();
        }
        getOperationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.GetOperationAction,
                com.google.spanner.executor.v1.GetOperationAction.Builder,
                com.google.spanner.executor.v1.GetOperationActionOrBuilder>(
                (com.google.spanner.executor.v1.GetOperationAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 25;
      onChanged();
      return getOperationBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.CancelOperationAction,
            com.google.spanner.executor.v1.CancelOperationAction.Builder,
            com.google.spanner.executor.v1.CancelOperationActionOrBuilder>
        cancelOperationBuilder_;
    /**
     *
     *
     * <pre>
     * Action that cancels an operation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CancelOperationAction cancel_operation = 26;</code>
     *
     * @return Whether the cancelOperation field is set.
     */
    @java.lang.Override
    public boolean hasCancelOperation() {
      return actionCase_ == 26;
    }
    /**
     *
     *
     * <pre>
     * Action that cancels an operation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CancelOperationAction cancel_operation = 26;</code>
     *
     * @return The cancelOperation.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.CancelOperationAction getCancelOperation() {
      if (cancelOperationBuilder_ == null) {
        if (actionCase_ == 26) {
          return (com.google.spanner.executor.v1.CancelOperationAction) action_;
        }
        return com.google.spanner.executor.v1.CancelOperationAction.getDefaultInstance();
      } else {
        if (actionCase_ == 26) {
          return cancelOperationBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.CancelOperationAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that cancels an operation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CancelOperationAction cancel_operation = 26;</code>
     */
    public Builder setCancelOperation(com.google.spanner.executor.v1.CancelOperationAction value) {
      if (cancelOperationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        cancelOperationBuilder_.setMessage(value);
      }
      actionCase_ = 26;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that cancels an operation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CancelOperationAction cancel_operation = 26;</code>
     */
    public Builder setCancelOperation(
        com.google.spanner.executor.v1.CancelOperationAction.Builder builderForValue) {
      if (cancelOperationBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        cancelOperationBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 26;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that cancels an operation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CancelOperationAction cancel_operation = 26;</code>
     */
    public Builder mergeCancelOperation(
        com.google.spanner.executor.v1.CancelOperationAction value) {
      if (cancelOperationBuilder_ == null) {
        if (actionCase_ == 26
            && action_
                != com.google.spanner.executor.v1.CancelOperationAction.getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.CancelOperationAction.newBuilder(
                      (com.google.spanner.executor.v1.CancelOperationAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 26) {
          cancelOperationBuilder_.mergeFrom(value);
        } else {
          cancelOperationBuilder_.setMessage(value);
        }
      }
      actionCase_ = 26;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that cancels an operation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CancelOperationAction cancel_operation = 26;</code>
     */
    public Builder clearCancelOperation() {
      if (cancelOperationBuilder_ == null) {
        if (actionCase_ == 26) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 26) {
          actionCase_ = 0;
          action_ = null;
        }
        cancelOperationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that cancels an operation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CancelOperationAction cancel_operation = 26;</code>
     */
    public com.google.spanner.executor.v1.CancelOperationAction.Builder
        getCancelOperationBuilder() {
      return getCancelOperationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action that cancels an operation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CancelOperationAction cancel_operation = 26;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.CancelOperationActionOrBuilder
        getCancelOperationOrBuilder() {
      if ((actionCase_ == 26) && (cancelOperationBuilder_ != null)) {
        return cancelOperationBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 26) {
          return (com.google.spanner.executor.v1.CancelOperationAction) action_;
        }
        return com.google.spanner.executor.v1.CancelOperationAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that cancels an operation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CancelOperationAction cancel_operation = 26;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.CancelOperationAction,
            com.google.spanner.executor.v1.CancelOperationAction.Builder,
            com.google.spanner.executor.v1.CancelOperationActionOrBuilder>
        getCancelOperationFieldBuilder() {
      if (cancelOperationBuilder_ == null) {
        if (!(actionCase_ == 26)) {
          action_ = com.google.spanner.executor.v1.CancelOperationAction.getDefaultInstance();
        }
        cancelOperationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.CancelOperationAction,
                com.google.spanner.executor.v1.CancelOperationAction.Builder,
                com.google.spanner.executor.v1.CancelOperationActionOrBuilder>(
                (com.google.spanner.executor.v1.CancelOperationAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 26;
      onChanged();
      return cancelOperationBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction,
            com.google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction.Builder,
            com.google.spanner.executor.v1.ChangeQuorumCloudDatabaseActionOrBuilder>
        changeQuorumCloudDatabaseBuilder_;
    /**
     *
     *
     * <pre>
     * Action that changes quorum of a Cloud Spanner database.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction change_quorum_cloud_database = 28;
     * </code>
     *
     * @return Whether the changeQuorumCloudDatabase field is set.
     */
    @java.lang.Override
    public boolean hasChangeQuorumCloudDatabase() {
      return actionCase_ == 28;
    }
    /**
     *
     *
     * <pre>
     * Action that changes quorum of a Cloud Spanner database.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction change_quorum_cloud_database = 28;
     * </code>
     *
     * @return The changeQuorumCloudDatabase.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction
        getChangeQuorumCloudDatabase() {
      if (changeQuorumCloudDatabaseBuilder_ == null) {
        if (actionCase_ == 28) {
          return (com.google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction) action_;
        }
        return com.google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction.getDefaultInstance();
      } else {
        if (actionCase_ == 28) {
          return changeQuorumCloudDatabaseBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that changes quorum of a Cloud Spanner database.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction change_quorum_cloud_database = 28;
     * </code>
     */
    public Builder setChangeQuorumCloudDatabase(
        com.google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction value) {
      if (changeQuorumCloudDatabaseBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        changeQuorumCloudDatabaseBuilder_.setMessage(value);
      }
      actionCase_ = 28;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that changes quorum of a Cloud Spanner database.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction change_quorum_cloud_database = 28;
     * </code>
     */
    public Builder setChangeQuorumCloudDatabase(
        com.google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction.Builder builderForValue) {
      if (changeQuorumCloudDatabaseBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        changeQuorumCloudDatabaseBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 28;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that changes quorum of a Cloud Spanner database.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction change_quorum_cloud_database = 28;
     * </code>
     */
    public Builder mergeChangeQuorumCloudDatabase(
        com.google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction value) {
      if (changeQuorumCloudDatabaseBuilder_ == null) {
        if (actionCase_ == 28
            && action_
                != com.google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction
                    .getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction.newBuilder(
                      (com.google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 28) {
          changeQuorumCloudDatabaseBuilder_.mergeFrom(value);
        } else {
          changeQuorumCloudDatabaseBuilder_.setMessage(value);
        }
      }
      actionCase_ = 28;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that changes quorum of a Cloud Spanner database.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction change_quorum_cloud_database = 28;
     * </code>
     */
    public Builder clearChangeQuorumCloudDatabase() {
      if (changeQuorumCloudDatabaseBuilder_ == null) {
        if (actionCase_ == 28) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 28) {
          actionCase_ = 0;
          action_ = null;
        }
        changeQuorumCloudDatabaseBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that changes quorum of a Cloud Spanner database.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction change_quorum_cloud_database = 28;
     * </code>
     */
    public com.google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction.Builder
        getChangeQuorumCloudDatabaseBuilder() {
      return getChangeQuorumCloudDatabaseFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action that changes quorum of a Cloud Spanner database.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction change_quorum_cloud_database = 28;
     * </code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.ChangeQuorumCloudDatabaseActionOrBuilder
        getChangeQuorumCloudDatabaseOrBuilder() {
      if ((actionCase_ == 28) && (changeQuorumCloudDatabaseBuilder_ != null)) {
        return changeQuorumCloudDatabaseBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 28) {
          return (com.google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction) action_;
        }
        return com.google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that changes quorum of a Cloud Spanner database.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction change_quorum_cloud_database = 28;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction,
            com.google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction.Builder,
            com.google.spanner.executor.v1.ChangeQuorumCloudDatabaseActionOrBuilder>
        getChangeQuorumCloudDatabaseFieldBuilder() {
      if (changeQuorumCloudDatabaseBuilder_ == null) {
        if (!(actionCase_ == 28)) {
          action_ =
              com.google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction.getDefaultInstance();
        }
        changeQuorumCloudDatabaseBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction,
                com.google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction.Builder,
                com.google.spanner.executor.v1.ChangeQuorumCloudDatabaseActionOrBuilder>(
                (com.google.spanner.executor.v1.ChangeQuorumCloudDatabaseAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 28;
      onChanged();
      return changeQuorumCloudDatabaseBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.executor.v1.AdminAction)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.executor.v1.AdminAction)
  private static final com.google.spanner.executor.v1.AdminAction DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.executor.v1.AdminAction();
  }

  public static com.google.spanner.executor.v1.AdminAction getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AdminAction> PARSER =
      new com.google.protobuf.AbstractParser<AdminAction>() {
        @java.lang.Override
        public AdminAction parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AdminAction> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AdminAction> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.executor.v1.AdminAction getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
