/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/executor/v1/cloud_executor.proto

// Protobuf Java Version: 3.25.3
package com.google.spanner.executor.v1;

/**
 *
 *
 * <pre>
 * Raw ChangeStream records.
 * Encodes one of: DataChangeRecord, HeartbeatRecord, ChildPartitionsRecord
 * returned from the ChangeStream API.
 * </pre>
 *
 * Protobuf type {@code google.spanner.executor.v1.ChangeStreamRecord}
 */
public final class ChangeStreamRecord extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.executor.v1.ChangeStreamRecord)
    ChangeStreamRecordOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ChangeStreamRecord.newBuilder() to construct.
  private ChangeStreamRecord(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ChangeStreamRecord() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ChangeStreamRecord();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_ChangeStreamRecord_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_ChangeStreamRecord_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.executor.v1.ChangeStreamRecord.class,
            com.google.spanner.executor.v1.ChangeStreamRecord.Builder.class);
  }

  private int recordCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object record_;

  public enum RecordCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DATA_CHANGE(1),
    CHILD_PARTITION(2),
    HEARTBEAT(3),
    RECORD_NOT_SET(0);
    private final int value;

    private RecordCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RecordCase valueOf(int value) {
      return forNumber(value);
    }

    public static RecordCase forNumber(int value) {
      switch (value) {
        case 1:
          return DATA_CHANGE;
        case 2:
          return CHILD_PARTITION;
        case 3:
          return HEARTBEAT;
        case 0:
          return RECORD_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public RecordCase getRecordCase() {
    return RecordCase.forNumber(recordCase_);
  }

  public static final int DATA_CHANGE_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Data change record.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.DataChangeRecord data_change = 1;</code>
   *
   * @return Whether the dataChange field is set.
   */
  @java.lang.Override
  public boolean hasDataChange() {
    return recordCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Data change record.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.DataChangeRecord data_change = 1;</code>
   *
   * @return The dataChange.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.DataChangeRecord getDataChange() {
    if (recordCase_ == 1) {
      return (com.google.spanner.executor.v1.DataChangeRecord) record_;
    }
    return com.google.spanner.executor.v1.DataChangeRecord.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Data change record.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.DataChangeRecord data_change = 1;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.DataChangeRecordOrBuilder getDataChangeOrBuilder() {
    if (recordCase_ == 1) {
      return (com.google.spanner.executor.v1.DataChangeRecord) record_;
    }
    return com.google.spanner.executor.v1.DataChangeRecord.getDefaultInstance();
  }

  public static final int CHILD_PARTITION_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Child partitions record.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ChildPartitionsRecord child_partition = 2;</code>
   *
   * @return Whether the childPartition field is set.
   */
  @java.lang.Override
  public boolean hasChildPartition() {
    return recordCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Child partitions record.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ChildPartitionsRecord child_partition = 2;</code>
   *
   * @return The childPartition.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ChildPartitionsRecord getChildPartition() {
    if (recordCase_ == 2) {
      return (com.google.spanner.executor.v1.ChildPartitionsRecord) record_;
    }
    return com.google.spanner.executor.v1.ChildPartitionsRecord.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Child partitions record.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ChildPartitionsRecord child_partition = 2;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ChildPartitionsRecordOrBuilder
      getChildPartitionOrBuilder() {
    if (recordCase_ == 2) {
      return (com.google.spanner.executor.v1.ChildPartitionsRecord) record_;
    }
    return com.google.spanner.executor.v1.ChildPartitionsRecord.getDefaultInstance();
  }

  public static final int HEARTBEAT_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Heartbeat record.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.HeartbeatRecord heartbeat = 3;</code>
   *
   * @return Whether the heartbeat field is set.
   */
  @java.lang.Override
  public boolean hasHeartbeat() {
    return recordCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Heartbeat record.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.HeartbeatRecord heartbeat = 3;</code>
   *
   * @return The heartbeat.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.HeartbeatRecord getHeartbeat() {
    if (recordCase_ == 3) {
      return (com.google.spanner.executor.v1.HeartbeatRecord) record_;
    }
    return com.google.spanner.executor.v1.HeartbeatRecord.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Heartbeat record.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.HeartbeatRecord heartbeat = 3;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.HeartbeatRecordOrBuilder getHeartbeatOrBuilder() {
    if (recordCase_ == 3) {
      return (com.google.spanner.executor.v1.HeartbeatRecord) record_;
    }
    return com.google.spanner.executor.v1.HeartbeatRecord.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (recordCase_ == 1) {
      output.writeMessage(1, (com.google.spanner.executor.v1.DataChangeRecord) record_);
    }
    if (recordCase_ == 2) {
      output.writeMessage(2, (com.google.spanner.executor.v1.ChildPartitionsRecord) record_);
    }
    if (recordCase_ == 3) {
      output.writeMessage(3, (com.google.spanner.executor.v1.HeartbeatRecord) record_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (recordCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.spanner.executor.v1.DataChangeRecord) record_);
    }
    if (recordCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.spanner.executor.v1.ChildPartitionsRecord) record_);
    }
    if (recordCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.spanner.executor.v1.HeartbeatRecord) record_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.executor.v1.ChangeStreamRecord)) {
      return super.equals(obj);
    }
    com.google.spanner.executor.v1.ChangeStreamRecord other =
        (com.google.spanner.executor.v1.ChangeStreamRecord) obj;

    if (!getRecordCase().equals(other.getRecordCase())) return false;
    switch (recordCase_) {
      case 1:
        if (!getDataChange().equals(other.getDataChange())) return false;
        break;
      case 2:
        if (!getChildPartition().equals(other.getChildPartition())) return false;
        break;
      case 3:
        if (!getHeartbeat().equals(other.getHeartbeat())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (recordCase_) {
      case 1:
        hash = (37 * hash) + DATA_CHANGE_FIELD_NUMBER;
        hash = (53 * hash) + getDataChange().hashCode();
        break;
      case 2:
        hash = (37 * hash) + CHILD_PARTITION_FIELD_NUMBER;
        hash = (53 * hash) + getChildPartition().hashCode();
        break;
      case 3:
        hash = (37 * hash) + HEARTBEAT_FIELD_NUMBER;
        hash = (53 * hash) + getHeartbeat().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.executor.v1.ChangeStreamRecord parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.ChangeStreamRecord parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.ChangeStreamRecord parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.ChangeStreamRecord parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.ChangeStreamRecord parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.ChangeStreamRecord parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.ChangeStreamRecord parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.ChangeStreamRecord parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.ChangeStreamRecord parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.ChangeStreamRecord parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.ChangeStreamRecord parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.ChangeStreamRecord parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.executor.v1.ChangeStreamRecord prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Raw ChangeStream records.
   * Encodes one of: DataChangeRecord, HeartbeatRecord, ChildPartitionsRecord
   * returned from the ChangeStream API.
   * </pre>
   *
   * Protobuf type {@code google.spanner.executor.v1.ChangeStreamRecord}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.executor.v1.ChangeStreamRecord)
      com.google.spanner.executor.v1.ChangeStreamRecordOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_ChangeStreamRecord_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_ChangeStreamRecord_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.executor.v1.ChangeStreamRecord.class,
              com.google.spanner.executor.v1.ChangeStreamRecord.Builder.class);
    }

    // Construct using com.google.spanner.executor.v1.ChangeStreamRecord.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (dataChangeBuilder_ != null) {
        dataChangeBuilder_.clear();
      }
      if (childPartitionBuilder_ != null) {
        childPartitionBuilder_.clear();
      }
      if (heartbeatBuilder_ != null) {
        heartbeatBuilder_.clear();
      }
      recordCase_ = 0;
      record_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_ChangeStreamRecord_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.ChangeStreamRecord getDefaultInstanceForType() {
      return com.google.spanner.executor.v1.ChangeStreamRecord.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.ChangeStreamRecord build() {
      com.google.spanner.executor.v1.ChangeStreamRecord result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.ChangeStreamRecord buildPartial() {
      com.google.spanner.executor.v1.ChangeStreamRecord result =
          new com.google.spanner.executor.v1.ChangeStreamRecord(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.executor.v1.ChangeStreamRecord result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.spanner.executor.v1.ChangeStreamRecord result) {
      result.recordCase_ = recordCase_;
      result.record_ = this.record_;
      if (recordCase_ == 1 && dataChangeBuilder_ != null) {
        result.record_ = dataChangeBuilder_.build();
      }
      if (recordCase_ == 2 && childPartitionBuilder_ != null) {
        result.record_ = childPartitionBuilder_.build();
      }
      if (recordCase_ == 3 && heartbeatBuilder_ != null) {
        result.record_ = heartbeatBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.executor.v1.ChangeStreamRecord) {
        return mergeFrom((com.google.spanner.executor.v1.ChangeStreamRecord) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.executor.v1.ChangeStreamRecord other) {
      if (other == com.google.spanner.executor.v1.ChangeStreamRecord.getDefaultInstance())
        return this;
      switch (other.getRecordCase()) {
        case DATA_CHANGE:
          {
            mergeDataChange(other.getDataChange());
            break;
          }
        case CHILD_PARTITION:
          {
            mergeChildPartition(other.getChildPartition());
            break;
          }
        case HEARTBEAT:
          {
            mergeHeartbeat(other.getHeartbeat());
            break;
          }
        case RECORD_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getDataChangeFieldBuilder().getBuilder(), extensionRegistry);
                recordCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getChildPartitionFieldBuilder().getBuilder(), extensionRegistry);
                recordCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getHeartbeatFieldBuilder().getBuilder(), extensionRegistry);
                recordCase_ = 3;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int recordCase_ = 0;
    private java.lang.Object record_;

    public RecordCase getRecordCase() {
      return RecordCase.forNumber(recordCase_);
    }

    public Builder clearRecord() {
      recordCase_ = 0;
      record_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.DataChangeRecord,
            com.google.spanner.executor.v1.DataChangeRecord.Builder,
            com.google.spanner.executor.v1.DataChangeRecordOrBuilder>
        dataChangeBuilder_;
    /**
     *
     *
     * <pre>
     * Data change record.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DataChangeRecord data_change = 1;</code>
     *
     * @return Whether the dataChange field is set.
     */
    @java.lang.Override
    public boolean hasDataChange() {
      return recordCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Data change record.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DataChangeRecord data_change = 1;</code>
     *
     * @return The dataChange.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.DataChangeRecord getDataChange() {
      if (dataChangeBuilder_ == null) {
        if (recordCase_ == 1) {
          return (com.google.spanner.executor.v1.DataChangeRecord) record_;
        }
        return com.google.spanner.executor.v1.DataChangeRecord.getDefaultInstance();
      } else {
        if (recordCase_ == 1) {
          return dataChangeBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.DataChangeRecord.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Data change record.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DataChangeRecord data_change = 1;</code>
     */
    public Builder setDataChange(com.google.spanner.executor.v1.DataChangeRecord value) {
      if (dataChangeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        record_ = value;
        onChanged();
      } else {
        dataChangeBuilder_.setMessage(value);
      }
      recordCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data change record.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DataChangeRecord data_change = 1;</code>
     */
    public Builder setDataChange(
        com.google.spanner.executor.v1.DataChangeRecord.Builder builderForValue) {
      if (dataChangeBuilder_ == null) {
        record_ = builderForValue.build();
        onChanged();
      } else {
        dataChangeBuilder_.setMessage(builderForValue.build());
      }
      recordCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data change record.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DataChangeRecord data_change = 1;</code>
     */
    public Builder mergeDataChange(com.google.spanner.executor.v1.DataChangeRecord value) {
      if (dataChangeBuilder_ == null) {
        if (recordCase_ == 1
            && record_ != com.google.spanner.executor.v1.DataChangeRecord.getDefaultInstance()) {
          record_ =
              com.google.spanner.executor.v1.DataChangeRecord.newBuilder(
                      (com.google.spanner.executor.v1.DataChangeRecord) record_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          record_ = value;
        }
        onChanged();
      } else {
        if (recordCase_ == 1) {
          dataChangeBuilder_.mergeFrom(value);
        } else {
          dataChangeBuilder_.setMessage(value);
        }
      }
      recordCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data change record.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DataChangeRecord data_change = 1;</code>
     */
    public Builder clearDataChange() {
      if (dataChangeBuilder_ == null) {
        if (recordCase_ == 1) {
          recordCase_ = 0;
          record_ = null;
          onChanged();
        }
      } else {
        if (recordCase_ == 1) {
          recordCase_ = 0;
          record_ = null;
        }
        dataChangeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data change record.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DataChangeRecord data_change = 1;</code>
     */
    public com.google.spanner.executor.v1.DataChangeRecord.Builder getDataChangeBuilder() {
      return getDataChangeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Data change record.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DataChangeRecord data_change = 1;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.DataChangeRecordOrBuilder getDataChangeOrBuilder() {
      if ((recordCase_ == 1) && (dataChangeBuilder_ != null)) {
        return dataChangeBuilder_.getMessageOrBuilder();
      } else {
        if (recordCase_ == 1) {
          return (com.google.spanner.executor.v1.DataChangeRecord) record_;
        }
        return com.google.spanner.executor.v1.DataChangeRecord.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Data change record.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DataChangeRecord data_change = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.DataChangeRecord,
            com.google.spanner.executor.v1.DataChangeRecord.Builder,
            com.google.spanner.executor.v1.DataChangeRecordOrBuilder>
        getDataChangeFieldBuilder() {
      if (dataChangeBuilder_ == null) {
        if (!(recordCase_ == 1)) {
          record_ = com.google.spanner.executor.v1.DataChangeRecord.getDefaultInstance();
        }
        dataChangeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.DataChangeRecord,
                com.google.spanner.executor.v1.DataChangeRecord.Builder,
                com.google.spanner.executor.v1.DataChangeRecordOrBuilder>(
                (com.google.spanner.executor.v1.DataChangeRecord) record_,
                getParentForChildren(),
                isClean());
        record_ = null;
      }
      recordCase_ = 1;
      onChanged();
      return dataChangeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ChildPartitionsRecord,
            com.google.spanner.executor.v1.ChildPartitionsRecord.Builder,
            com.google.spanner.executor.v1.ChildPartitionsRecordOrBuilder>
        childPartitionBuilder_;
    /**
     *
     *
     * <pre>
     * Child partitions record.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ChildPartitionsRecord child_partition = 2;</code>
     *
     * @return Whether the childPartition field is set.
     */
    @java.lang.Override
    public boolean hasChildPartition() {
      return recordCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Child partitions record.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ChildPartitionsRecord child_partition = 2;</code>
     *
     * @return The childPartition.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.ChildPartitionsRecord getChildPartition() {
      if (childPartitionBuilder_ == null) {
        if (recordCase_ == 2) {
          return (com.google.spanner.executor.v1.ChildPartitionsRecord) record_;
        }
        return com.google.spanner.executor.v1.ChildPartitionsRecord.getDefaultInstance();
      } else {
        if (recordCase_ == 2) {
          return childPartitionBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.ChildPartitionsRecord.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Child partitions record.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ChildPartitionsRecord child_partition = 2;</code>
     */
    public Builder setChildPartition(com.google.spanner.executor.v1.ChildPartitionsRecord value) {
      if (childPartitionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        record_ = value;
        onChanged();
      } else {
        childPartitionBuilder_.setMessage(value);
      }
      recordCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Child partitions record.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ChildPartitionsRecord child_partition = 2;</code>
     */
    public Builder setChildPartition(
        com.google.spanner.executor.v1.ChildPartitionsRecord.Builder builderForValue) {
      if (childPartitionBuilder_ == null) {
        record_ = builderForValue.build();
        onChanged();
      } else {
        childPartitionBuilder_.setMessage(builderForValue.build());
      }
      recordCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Child partitions record.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ChildPartitionsRecord child_partition = 2;</code>
     */
    public Builder mergeChildPartition(com.google.spanner.executor.v1.ChildPartitionsRecord value) {
      if (childPartitionBuilder_ == null) {
        if (recordCase_ == 2
            && record_
                != com.google.spanner.executor.v1.ChildPartitionsRecord.getDefaultInstance()) {
          record_ =
              com.google.spanner.executor.v1.ChildPartitionsRecord.newBuilder(
                      (com.google.spanner.executor.v1.ChildPartitionsRecord) record_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          record_ = value;
        }
        onChanged();
      } else {
        if (recordCase_ == 2) {
          childPartitionBuilder_.mergeFrom(value);
        } else {
          childPartitionBuilder_.setMessage(value);
        }
      }
      recordCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Child partitions record.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ChildPartitionsRecord child_partition = 2;</code>
     */
    public Builder clearChildPartition() {
      if (childPartitionBuilder_ == null) {
        if (recordCase_ == 2) {
          recordCase_ = 0;
          record_ = null;
          onChanged();
        }
      } else {
        if (recordCase_ == 2) {
          recordCase_ = 0;
          record_ = null;
        }
        childPartitionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Child partitions record.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ChildPartitionsRecord child_partition = 2;</code>
     */
    public com.google.spanner.executor.v1.ChildPartitionsRecord.Builder getChildPartitionBuilder() {
      return getChildPartitionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Child partitions record.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ChildPartitionsRecord child_partition = 2;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.ChildPartitionsRecordOrBuilder
        getChildPartitionOrBuilder() {
      if ((recordCase_ == 2) && (childPartitionBuilder_ != null)) {
        return childPartitionBuilder_.getMessageOrBuilder();
      } else {
        if (recordCase_ == 2) {
          return (com.google.spanner.executor.v1.ChildPartitionsRecord) record_;
        }
        return com.google.spanner.executor.v1.ChildPartitionsRecord.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Child partitions record.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ChildPartitionsRecord child_partition = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ChildPartitionsRecord,
            com.google.spanner.executor.v1.ChildPartitionsRecord.Builder,
            com.google.spanner.executor.v1.ChildPartitionsRecordOrBuilder>
        getChildPartitionFieldBuilder() {
      if (childPartitionBuilder_ == null) {
        if (!(recordCase_ == 2)) {
          record_ = com.google.spanner.executor.v1.ChildPartitionsRecord.getDefaultInstance();
        }
        childPartitionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.ChildPartitionsRecord,
                com.google.spanner.executor.v1.ChildPartitionsRecord.Builder,
                com.google.spanner.executor.v1.ChildPartitionsRecordOrBuilder>(
                (com.google.spanner.executor.v1.ChildPartitionsRecord) record_,
                getParentForChildren(),
                isClean());
        record_ = null;
      }
      recordCase_ = 2;
      onChanged();
      return childPartitionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.HeartbeatRecord,
            com.google.spanner.executor.v1.HeartbeatRecord.Builder,
            com.google.spanner.executor.v1.HeartbeatRecordOrBuilder>
        heartbeatBuilder_;
    /**
     *
     *
     * <pre>
     * Heartbeat record.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.HeartbeatRecord heartbeat = 3;</code>
     *
     * @return Whether the heartbeat field is set.
     */
    @java.lang.Override
    public boolean hasHeartbeat() {
      return recordCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Heartbeat record.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.HeartbeatRecord heartbeat = 3;</code>
     *
     * @return The heartbeat.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.HeartbeatRecord getHeartbeat() {
      if (heartbeatBuilder_ == null) {
        if (recordCase_ == 3) {
          return (com.google.spanner.executor.v1.HeartbeatRecord) record_;
        }
        return com.google.spanner.executor.v1.HeartbeatRecord.getDefaultInstance();
      } else {
        if (recordCase_ == 3) {
          return heartbeatBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.HeartbeatRecord.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Heartbeat record.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.HeartbeatRecord heartbeat = 3;</code>
     */
    public Builder setHeartbeat(com.google.spanner.executor.v1.HeartbeatRecord value) {
      if (heartbeatBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        record_ = value;
        onChanged();
      } else {
        heartbeatBuilder_.setMessage(value);
      }
      recordCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Heartbeat record.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.HeartbeatRecord heartbeat = 3;</code>
     */
    public Builder setHeartbeat(
        com.google.spanner.executor.v1.HeartbeatRecord.Builder builderForValue) {
      if (heartbeatBuilder_ == null) {
        record_ = builderForValue.build();
        onChanged();
      } else {
        heartbeatBuilder_.setMessage(builderForValue.build());
      }
      recordCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Heartbeat record.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.HeartbeatRecord heartbeat = 3;</code>
     */
    public Builder mergeHeartbeat(com.google.spanner.executor.v1.HeartbeatRecord value) {
      if (heartbeatBuilder_ == null) {
        if (recordCase_ == 3
            && record_ != com.google.spanner.executor.v1.HeartbeatRecord.getDefaultInstance()) {
          record_ =
              com.google.spanner.executor.v1.HeartbeatRecord.newBuilder(
                      (com.google.spanner.executor.v1.HeartbeatRecord) record_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          record_ = value;
        }
        onChanged();
      } else {
        if (recordCase_ == 3) {
          heartbeatBuilder_.mergeFrom(value);
        } else {
          heartbeatBuilder_.setMessage(value);
        }
      }
      recordCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Heartbeat record.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.HeartbeatRecord heartbeat = 3;</code>
     */
    public Builder clearHeartbeat() {
      if (heartbeatBuilder_ == null) {
        if (recordCase_ == 3) {
          recordCase_ = 0;
          record_ = null;
          onChanged();
        }
      } else {
        if (recordCase_ == 3) {
          recordCase_ = 0;
          record_ = null;
        }
        heartbeatBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Heartbeat record.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.HeartbeatRecord heartbeat = 3;</code>
     */
    public com.google.spanner.executor.v1.HeartbeatRecord.Builder getHeartbeatBuilder() {
      return getHeartbeatFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Heartbeat record.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.HeartbeatRecord heartbeat = 3;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.HeartbeatRecordOrBuilder getHeartbeatOrBuilder() {
      if ((recordCase_ == 3) && (heartbeatBuilder_ != null)) {
        return heartbeatBuilder_.getMessageOrBuilder();
      } else {
        if (recordCase_ == 3) {
          return (com.google.spanner.executor.v1.HeartbeatRecord) record_;
        }
        return com.google.spanner.executor.v1.HeartbeatRecord.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Heartbeat record.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.HeartbeatRecord heartbeat = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.HeartbeatRecord,
            com.google.spanner.executor.v1.HeartbeatRecord.Builder,
            com.google.spanner.executor.v1.HeartbeatRecordOrBuilder>
        getHeartbeatFieldBuilder() {
      if (heartbeatBuilder_ == null) {
        if (!(recordCase_ == 3)) {
          record_ = com.google.spanner.executor.v1.HeartbeatRecord.getDefaultInstance();
        }
        heartbeatBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.HeartbeatRecord,
                com.google.spanner.executor.v1.HeartbeatRecord.Builder,
                com.google.spanner.executor.v1.HeartbeatRecordOrBuilder>(
                (com.google.spanner.executor.v1.HeartbeatRecord) record_,
                getParentForChildren(),
                isClean());
        record_ = null;
      }
      recordCase_ = 3;
      onChanged();
      return heartbeatBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.executor.v1.ChangeStreamRecord)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.executor.v1.ChangeStreamRecord)
  private static final com.google.spanner.executor.v1.ChangeStreamRecord DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.executor.v1.ChangeStreamRecord();
  }

  public static com.google.spanner.executor.v1.ChangeStreamRecord getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ChangeStreamRecord> PARSER =
      new com.google.protobuf.AbstractParser<ChangeStreamRecord>() {
        @java.lang.Override
        public ChangeStreamRecord parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ChangeStreamRecord> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ChangeStreamRecord> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.executor.v1.ChangeStreamRecord getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
