/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/executor/v1/cloud_executor.proto

// Protobuf Java Version: 3.25.3
package com.google.spanner.executor.v1;

/**
 *
 *
 * <pre>
 * ChangeStream child partition record.
 * </pre>
 *
 * Protobuf type {@code google.spanner.executor.v1.ChildPartitionsRecord}
 */
public final class ChildPartitionsRecord extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.executor.v1.ChildPartitionsRecord)
    ChildPartitionsRecordOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ChildPartitionsRecord.newBuilder() to construct.
  private ChildPartitionsRecord(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ChildPartitionsRecord() {
    recordSequence_ = "";
    childPartitions_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ChildPartitionsRecord();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_ChildPartitionsRecord_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_ChildPartitionsRecord_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.executor.v1.ChildPartitionsRecord.class,
            com.google.spanner.executor.v1.ChildPartitionsRecord.Builder.class);
  }

  public interface ChildPartitionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Partition token string used to identify the child partition in queries.
     * </pre>
     *
     * <code>string token = 1;</code>
     *
     * @return The token.
     */
    java.lang.String getToken();
    /**
     *
     *
     * <pre>
     * Partition token string used to identify the child partition in queries.
     * </pre>
     *
     * <code>string token = 1;</code>
     *
     * @return The bytes for token.
     */
    com.google.protobuf.ByteString getTokenBytes();

    /**
     *
     *
     * <pre>
     * Parent partition tokens of this child partition.
     * </pre>
     *
     * <code>repeated string parent_partition_tokens = 2;</code>
     *
     * @return A list containing the parentPartitionTokens.
     */
    java.util.List<java.lang.String> getParentPartitionTokensList();
    /**
     *
     *
     * <pre>
     * Parent partition tokens of this child partition.
     * </pre>
     *
     * <code>repeated string parent_partition_tokens = 2;</code>
     *
     * @return The count of parentPartitionTokens.
     */
    int getParentPartitionTokensCount();
    /**
     *
     *
     * <pre>
     * Parent partition tokens of this child partition.
     * </pre>
     *
     * <code>repeated string parent_partition_tokens = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The parentPartitionTokens at the given index.
     */
    java.lang.String getParentPartitionTokens(int index);
    /**
     *
     *
     * <pre>
     * Parent partition tokens of this child partition.
     * </pre>
     *
     * <code>repeated string parent_partition_tokens = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the parentPartitionTokens at the given index.
     */
    com.google.protobuf.ByteString getParentPartitionTokensBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * A single child partition.
   * </pre>
   *
   * Protobuf type {@code google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition}
   */
  public static final class ChildPartition extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition)
      ChildPartitionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ChildPartition.newBuilder() to construct.
    private ChildPartition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ChildPartition() {
      token_ = "";
      parentPartitionTokens_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ChildPartition();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_ChildPartitionsRecord_ChildPartition_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_ChildPartitionsRecord_ChildPartition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition.class,
              com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition.Builder.class);
    }

    public static final int TOKEN_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object token_ = "";
    /**
     *
     *
     * <pre>
     * Partition token string used to identify the child partition in queries.
     * </pre>
     *
     * <code>string token = 1;</code>
     *
     * @return The token.
     */
    @java.lang.Override
    public java.lang.String getToken() {
      java.lang.Object ref = token_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        token_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Partition token string used to identify the child partition in queries.
     * </pre>
     *
     * <code>string token = 1;</code>
     *
     * @return The bytes for token.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTokenBytes() {
      java.lang.Object ref = token_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        token_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PARENT_PARTITION_TOKENS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList parentPartitionTokens_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Parent partition tokens of this child partition.
     * </pre>
     *
     * <code>repeated string parent_partition_tokens = 2;</code>
     *
     * @return A list containing the parentPartitionTokens.
     */
    public com.google.protobuf.ProtocolStringList getParentPartitionTokensList() {
      return parentPartitionTokens_;
    }
    /**
     *
     *
     * <pre>
     * Parent partition tokens of this child partition.
     * </pre>
     *
     * <code>repeated string parent_partition_tokens = 2;</code>
     *
     * @return The count of parentPartitionTokens.
     */
    public int getParentPartitionTokensCount() {
      return parentPartitionTokens_.size();
    }
    /**
     *
     *
     * <pre>
     * Parent partition tokens of this child partition.
     * </pre>
     *
     * <code>repeated string parent_partition_tokens = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The parentPartitionTokens at the given index.
     */
    public java.lang.String getParentPartitionTokens(int index) {
      return parentPartitionTokens_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Parent partition tokens of this child partition.
     * </pre>
     *
     * <code>repeated string parent_partition_tokens = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the parentPartitionTokens at the given index.
     */
    public com.google.protobuf.ByteString getParentPartitionTokensBytes(int index) {
      return parentPartitionTokens_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(token_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, token_);
      }
      for (int i = 0; i < parentPartitionTokens_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(
            output, 2, parentPartitionTokens_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(token_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, token_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < parentPartitionTokens_.size(); i++) {
          dataSize += computeStringSizeNoTag(parentPartitionTokens_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getParentPartitionTokensList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition)) {
        return super.equals(obj);
      }
      com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition other =
          (com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition) obj;

      if (!getToken().equals(other.getToken())) return false;
      if (!getParentPartitionTokensList().equals(other.getParentPartitionTokensList()))
        return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TOKEN_FIELD_NUMBER;
      hash = (53 * hash) + getToken().hashCode();
      if (getParentPartitionTokensCount() > 0) {
        hash = (37 * hash) + PARENT_PARTITION_TOKENS_FIELD_NUMBER;
        hash = (53 * hash) + getParentPartitionTokensList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A single child partition.
     * </pre>
     *
     * Protobuf type {@code google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition)
        com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartitionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.spanner.executor.v1.CloudExecutorProto
            .internal_static_google_spanner_executor_v1_ChildPartitionsRecord_ChildPartition_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.spanner.executor.v1.CloudExecutorProto
            .internal_static_google_spanner_executor_v1_ChildPartitionsRecord_ChildPartition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition.class,
                com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition.Builder.class);
      }

      // Construct using
      // com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        token_ = "";
        parentPartitionTokens_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.spanner.executor.v1.CloudExecutorProto
            .internal_static_google_spanner_executor_v1_ChildPartitionsRecord_ChildPartition_descriptor;
      }

      @java.lang.Override
      public com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition
          getDefaultInstanceForType() {
        return com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition build() {
        com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition buildPartial() {
        com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition result =
            new com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.token_ = token_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          parentPartitionTokens_.makeImmutable();
          result.parentPartitionTokens_ = parentPartitionTokens_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition) {
          return mergeFrom(
              (com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition other) {
        if (other
            == com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition
                .getDefaultInstance()) return this;
        if (!other.getToken().isEmpty()) {
          token_ = other.token_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.parentPartitionTokens_.isEmpty()) {
          if (parentPartitionTokens_.isEmpty()) {
            parentPartitionTokens_ = other.parentPartitionTokens_;
            bitField0_ |= 0x00000002;
          } else {
            ensureParentPartitionTokensIsMutable();
            parentPartitionTokens_.addAll(other.parentPartitionTokens_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  token_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureParentPartitionTokensIsMutable();
                  parentPartitionTokens_.add(s);
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object token_ = "";
      /**
       *
       *
       * <pre>
       * Partition token string used to identify the child partition in queries.
       * </pre>
       *
       * <code>string token = 1;</code>
       *
       * @return The token.
       */
      public java.lang.String getToken() {
        java.lang.Object ref = token_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          token_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Partition token string used to identify the child partition in queries.
       * </pre>
       *
       * <code>string token = 1;</code>
       *
       * @return The bytes for token.
       */
      public com.google.protobuf.ByteString getTokenBytes() {
        java.lang.Object ref = token_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          token_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Partition token string used to identify the child partition in queries.
       * </pre>
       *
       * <code>string token = 1;</code>
       *
       * @param value The token to set.
       * @return This builder for chaining.
       */
      public Builder setToken(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        token_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Partition token string used to identify the child partition in queries.
       * </pre>
       *
       * <code>string token = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearToken() {
        token_ = getDefaultInstance().getToken();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Partition token string used to identify the child partition in queries.
       * </pre>
       *
       * <code>string token = 1;</code>
       *
       * @param value The bytes for token to set.
       * @return This builder for chaining.
       */
      public Builder setTokenBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        token_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList parentPartitionTokens_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureParentPartitionTokensIsMutable() {
        if (!parentPartitionTokens_.isModifiable()) {
          parentPartitionTokens_ =
              new com.google.protobuf.LazyStringArrayList(parentPartitionTokens_);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       *
       *
       * <pre>
       * Parent partition tokens of this child partition.
       * </pre>
       *
       * <code>repeated string parent_partition_tokens = 2;</code>
       *
       * @return A list containing the parentPartitionTokens.
       */
      public com.google.protobuf.ProtocolStringList getParentPartitionTokensList() {
        parentPartitionTokens_.makeImmutable();
        return parentPartitionTokens_;
      }
      /**
       *
       *
       * <pre>
       * Parent partition tokens of this child partition.
       * </pre>
       *
       * <code>repeated string parent_partition_tokens = 2;</code>
       *
       * @return The count of parentPartitionTokens.
       */
      public int getParentPartitionTokensCount() {
        return parentPartitionTokens_.size();
      }
      /**
       *
       *
       * <pre>
       * Parent partition tokens of this child partition.
       * </pre>
       *
       * <code>repeated string parent_partition_tokens = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The parentPartitionTokens at the given index.
       */
      public java.lang.String getParentPartitionTokens(int index) {
        return parentPartitionTokens_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Parent partition tokens of this child partition.
       * </pre>
       *
       * <code>repeated string parent_partition_tokens = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the parentPartitionTokens at the given index.
       */
      public com.google.protobuf.ByteString getParentPartitionTokensBytes(int index) {
        return parentPartitionTokens_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Parent partition tokens of this child partition.
       * </pre>
       *
       * <code>repeated string parent_partition_tokens = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The parentPartitionTokens to set.
       * @return This builder for chaining.
       */
      public Builder setParentPartitionTokens(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParentPartitionTokensIsMutable();
        parentPartitionTokens_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Parent partition tokens of this child partition.
       * </pre>
       *
       * <code>repeated string parent_partition_tokens = 2;</code>
       *
       * @param value The parentPartitionTokens to add.
       * @return This builder for chaining.
       */
      public Builder addParentPartitionTokens(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParentPartitionTokensIsMutable();
        parentPartitionTokens_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Parent partition tokens of this child partition.
       * </pre>
       *
       * <code>repeated string parent_partition_tokens = 2;</code>
       *
       * @param values The parentPartitionTokens to add.
       * @return This builder for chaining.
       */
      public Builder addAllParentPartitionTokens(java.lang.Iterable<java.lang.String> values) {
        ensureParentPartitionTokensIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, parentPartitionTokens_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Parent partition tokens of this child partition.
       * </pre>
       *
       * <code>repeated string parent_partition_tokens = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearParentPartitionTokens() {
        parentPartitionTokens_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Parent partition tokens of this child partition.
       * </pre>
       *
       * <code>repeated string parent_partition_tokens = 2;</code>
       *
       * @param value The bytes of the parentPartitionTokens to add.
       * @return This builder for chaining.
       */
      public Builder addParentPartitionTokensBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureParentPartitionTokensIsMutable();
        parentPartitionTokens_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition)
    }

    // @@protoc_insertion_point(class_scope:google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition)
    private static final com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition();
    }

    public static com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ChildPartition> PARSER =
        new com.google.protobuf.AbstractParser<ChildPartition>() {
          @java.lang.Override
          public ChildPartition parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ChildPartition> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ChildPartition> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int START_TIME_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * Data change records returned from child partitions in this child partitions
   * record will have a commit timestamp greater than or equal to start_time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 1;</code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Data change records returned from child partitions in this child partitions
   * record will have a commit timestamp greater than or equal to start_time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 1;</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * Data change records returned from child partitions in this child partitions
   * record will have a commit timestamp greater than or equal to start_time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int RECORD_SEQUENCE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object recordSequence_ = "";
  /**
   *
   *
   * <pre>
   * A monotonically increasing sequence number that can be used to define the
   * ordering of the child partitions record when there are multiple child
   * partitions records returned with the same start_time in a particular
   * partition.
   * </pre>
   *
   * <code>string record_sequence = 2;</code>
   *
   * @return The recordSequence.
   */
  @java.lang.Override
  public java.lang.String getRecordSequence() {
    java.lang.Object ref = recordSequence_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      recordSequence_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A monotonically increasing sequence number that can be used to define the
   * ordering of the child partitions record when there are multiple child
   * partitions records returned with the same start_time in a particular
   * partition.
   * </pre>
   *
   * <code>string record_sequence = 2;</code>
   *
   * @return The bytes for recordSequence.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRecordSequenceBytes() {
    java.lang.Object ref = recordSequence_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      recordSequence_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CHILD_PARTITIONS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition>
      childPartitions_;
  /**
   *
   *
   * <pre>
   * A set of child partitions and their associated information.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition child_partitions = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition>
      getChildPartitionsList() {
    return childPartitions_;
  }
  /**
   *
   *
   * <pre>
   * A set of child partitions and their associated information.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition child_partitions = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartitionOrBuilder>
      getChildPartitionsOrBuilderList() {
    return childPartitions_;
  }
  /**
   *
   *
   * <pre>
   * A set of child partitions and their associated information.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition child_partitions = 3;
   * </code>
   */
  @java.lang.Override
  public int getChildPartitionsCount() {
    return childPartitions_.size();
  }
  /**
   *
   *
   * <pre>
   * A set of child partitions and their associated information.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition child_partitions = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition getChildPartitions(
      int index) {
    return childPartitions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A set of child partitions and their associated information.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition child_partitions = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartitionOrBuilder
      getChildPartitionsOrBuilder(int index) {
    return childPartitions_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getStartTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(recordSequence_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, recordSequence_);
    }
    for (int i = 0; i < childPartitions_.size(); i++) {
      output.writeMessage(3, childPartitions_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getStartTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(recordSequence_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, recordSequence_);
    }
    for (int i = 0; i < childPartitions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, childPartitions_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.executor.v1.ChildPartitionsRecord)) {
      return super.equals(obj);
    }
    com.google.spanner.executor.v1.ChildPartitionsRecord other =
        (com.google.spanner.executor.v1.ChildPartitionsRecord) obj;

    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (!getRecordSequence().equals(other.getRecordSequence())) return false;
    if (!getChildPartitionsList().equals(other.getChildPartitionsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    hash = (37 * hash) + RECORD_SEQUENCE_FIELD_NUMBER;
    hash = (53 * hash) + getRecordSequence().hashCode();
    if (getChildPartitionsCount() > 0) {
      hash = (37 * hash) + CHILD_PARTITIONS_FIELD_NUMBER;
      hash = (53 * hash) + getChildPartitionsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.executor.v1.ChildPartitionsRecord parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.ChildPartitionsRecord parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.ChildPartitionsRecord parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.ChildPartitionsRecord parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.ChildPartitionsRecord parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.ChildPartitionsRecord parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.ChildPartitionsRecord parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.ChildPartitionsRecord parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.ChildPartitionsRecord parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.ChildPartitionsRecord parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.ChildPartitionsRecord parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.ChildPartitionsRecord parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.executor.v1.ChildPartitionsRecord prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * ChangeStream child partition record.
   * </pre>
   *
   * Protobuf type {@code google.spanner.executor.v1.ChildPartitionsRecord}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.executor.v1.ChildPartitionsRecord)
      com.google.spanner.executor.v1.ChildPartitionsRecordOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_ChildPartitionsRecord_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_ChildPartitionsRecord_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.executor.v1.ChildPartitionsRecord.class,
              com.google.spanner.executor.v1.ChildPartitionsRecord.Builder.class);
    }

    // Construct using com.google.spanner.executor.v1.ChildPartitionsRecord.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getStartTimeFieldBuilder();
        getChildPartitionsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      recordSequence_ = "";
      if (childPartitionsBuilder_ == null) {
        childPartitions_ = java.util.Collections.emptyList();
      } else {
        childPartitions_ = null;
        childPartitionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_ChildPartitionsRecord_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.ChildPartitionsRecord getDefaultInstanceForType() {
      return com.google.spanner.executor.v1.ChildPartitionsRecord.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.ChildPartitionsRecord build() {
      com.google.spanner.executor.v1.ChildPartitionsRecord result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.ChildPartitionsRecord buildPartial() {
      com.google.spanner.executor.v1.ChildPartitionsRecord result =
          new com.google.spanner.executor.v1.ChildPartitionsRecord(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.spanner.executor.v1.ChildPartitionsRecord result) {
      if (childPartitionsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          childPartitions_ = java.util.Collections.unmodifiableList(childPartitions_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.childPartitions_ = childPartitions_;
      } else {
        result.childPartitions_ = childPartitionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.spanner.executor.v1.ChildPartitionsRecord result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.recordSequence_ = recordSequence_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.executor.v1.ChildPartitionsRecord) {
        return mergeFrom((com.google.spanner.executor.v1.ChildPartitionsRecord) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.executor.v1.ChildPartitionsRecord other) {
      if (other == com.google.spanner.executor.v1.ChildPartitionsRecord.getDefaultInstance())
        return this;
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (!other.getRecordSequence().isEmpty()) {
        recordSequence_ = other.recordSequence_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (childPartitionsBuilder_ == null) {
        if (!other.childPartitions_.isEmpty()) {
          if (childPartitions_.isEmpty()) {
            childPartitions_ = other.childPartitions_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureChildPartitionsIsMutable();
            childPartitions_.addAll(other.childPartitions_);
          }
          onChanged();
        }
      } else {
        if (!other.childPartitions_.isEmpty()) {
          if (childPartitionsBuilder_.isEmpty()) {
            childPartitionsBuilder_.dispose();
            childPartitionsBuilder_ = null;
            childPartitions_ = other.childPartitions_;
            bitField0_ = (bitField0_ & ~0x00000004);
            childPartitionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getChildPartitionsFieldBuilder()
                    : null;
          } else {
            childPartitionsBuilder_.addAllMessages(other.childPartitions_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                recordSequence_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition m =
                    input.readMessage(
                        com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition
                            .parser(),
                        extensionRegistry);
                if (childPartitionsBuilder_ == null) {
                  ensureChildPartitionsIsMutable();
                  childPartitions_.add(m);
                } else {
                  childPartitionsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Data change records returned from child partitions in this child partitions
     * record will have a commit timestamp greater than or equal to start_time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Data change records returned from child partitions in this child partitions
     * record will have a commit timestamp greater than or equal to start_time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Data change records returned from child partitions in this child partitions
     * record will have a commit timestamp greater than or equal to start_time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data change records returned from child partitions in this child partitions
     * record will have a commit timestamp greater than or equal to start_time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data change records returned from child partitions in this child partitions
     * record will have a commit timestamp greater than or equal to start_time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      if (startTime_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data change records returned from child partitions in this child partitions
     * record will have a commit timestamp greater than or equal to start_time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000001);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data change records returned from child partitions in this child partitions
     * record will have a commit timestamp greater than or equal to start_time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Data change records returned from child partitions in this child partitions
     * record will have a commit timestamp greater than or equal to start_time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Data change records returned from child partitions in this child partitions
     * record will have a commit timestamp greater than or equal to start_time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private java.lang.Object recordSequence_ = "";
    /**
     *
     *
     * <pre>
     * A monotonically increasing sequence number that can be used to define the
     * ordering of the child partitions record when there are multiple child
     * partitions records returned with the same start_time in a particular
     * partition.
     * </pre>
     *
     * <code>string record_sequence = 2;</code>
     *
     * @return The recordSequence.
     */
    public java.lang.String getRecordSequence() {
      java.lang.Object ref = recordSequence_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        recordSequence_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A monotonically increasing sequence number that can be used to define the
     * ordering of the child partitions record when there are multiple child
     * partitions records returned with the same start_time in a particular
     * partition.
     * </pre>
     *
     * <code>string record_sequence = 2;</code>
     *
     * @return The bytes for recordSequence.
     */
    public com.google.protobuf.ByteString getRecordSequenceBytes() {
      java.lang.Object ref = recordSequence_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        recordSequence_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A monotonically increasing sequence number that can be used to define the
     * ordering of the child partitions record when there are multiple child
     * partitions records returned with the same start_time in a particular
     * partition.
     * </pre>
     *
     * <code>string record_sequence = 2;</code>
     *
     * @param value The recordSequence to set.
     * @return This builder for chaining.
     */
    public Builder setRecordSequence(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      recordSequence_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A monotonically increasing sequence number that can be used to define the
     * ordering of the child partitions record when there are multiple child
     * partitions records returned with the same start_time in a particular
     * partition.
     * </pre>
     *
     * <code>string record_sequence = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRecordSequence() {
      recordSequence_ = getDefaultInstance().getRecordSequence();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A monotonically increasing sequence number that can be used to define the
     * ordering of the child partitions record when there are multiple child
     * partitions records returned with the same start_time in a particular
     * partition.
     * </pre>
     *
     * <code>string record_sequence = 2;</code>
     *
     * @param value The bytes for recordSequence to set.
     * @return This builder for chaining.
     */
    public Builder setRecordSequenceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      recordSequence_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition>
        childPartitions_ = java.util.Collections.emptyList();

    private void ensureChildPartitionsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        childPartitions_ =
            new java.util.ArrayList<
                com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition>(
                childPartitions_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition,
            com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition.Builder,
            com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartitionOrBuilder>
        childPartitionsBuilder_;

    /**
     *
     *
     * <pre>
     * A set of child partitions and their associated information.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition child_partitions = 3;
     * </code>
     */
    public java.util.List<com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition>
        getChildPartitionsList() {
      if (childPartitionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(childPartitions_);
      } else {
        return childPartitionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A set of child partitions and their associated information.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition child_partitions = 3;
     * </code>
     */
    public int getChildPartitionsCount() {
      if (childPartitionsBuilder_ == null) {
        return childPartitions_.size();
      } else {
        return childPartitionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A set of child partitions and their associated information.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition child_partitions = 3;
     * </code>
     */
    public com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition getChildPartitions(
        int index) {
      if (childPartitionsBuilder_ == null) {
        return childPartitions_.get(index);
      } else {
        return childPartitionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A set of child partitions and their associated information.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition child_partitions = 3;
     * </code>
     */
    public Builder setChildPartitions(
        int index, com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition value) {
      if (childPartitionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureChildPartitionsIsMutable();
        childPartitions_.set(index, value);
        onChanged();
      } else {
        childPartitionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of child partitions and their associated information.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition child_partitions = 3;
     * </code>
     */
    public Builder setChildPartitions(
        int index,
        com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition.Builder
            builderForValue) {
      if (childPartitionsBuilder_ == null) {
        ensureChildPartitionsIsMutable();
        childPartitions_.set(index, builderForValue.build());
        onChanged();
      } else {
        childPartitionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of child partitions and their associated information.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition child_partitions = 3;
     * </code>
     */
    public Builder addChildPartitions(
        com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition value) {
      if (childPartitionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureChildPartitionsIsMutable();
        childPartitions_.add(value);
        onChanged();
      } else {
        childPartitionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of child partitions and their associated information.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition child_partitions = 3;
     * </code>
     */
    public Builder addChildPartitions(
        int index, com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition value) {
      if (childPartitionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureChildPartitionsIsMutable();
        childPartitions_.add(index, value);
        onChanged();
      } else {
        childPartitionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of child partitions and their associated information.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition child_partitions = 3;
     * </code>
     */
    public Builder addChildPartitions(
        com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition.Builder
            builderForValue) {
      if (childPartitionsBuilder_ == null) {
        ensureChildPartitionsIsMutable();
        childPartitions_.add(builderForValue.build());
        onChanged();
      } else {
        childPartitionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of child partitions and their associated information.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition child_partitions = 3;
     * </code>
     */
    public Builder addChildPartitions(
        int index,
        com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition.Builder
            builderForValue) {
      if (childPartitionsBuilder_ == null) {
        ensureChildPartitionsIsMutable();
        childPartitions_.add(index, builderForValue.build());
        onChanged();
      } else {
        childPartitionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of child partitions and their associated information.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition child_partitions = 3;
     * </code>
     */
    public Builder addAllChildPartitions(
        java.lang.Iterable<
                ? extends com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition>
            values) {
      if (childPartitionsBuilder_ == null) {
        ensureChildPartitionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, childPartitions_);
        onChanged();
      } else {
        childPartitionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of child partitions and their associated information.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition child_partitions = 3;
     * </code>
     */
    public Builder clearChildPartitions() {
      if (childPartitionsBuilder_ == null) {
        childPartitions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        childPartitionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of child partitions and their associated information.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition child_partitions = 3;
     * </code>
     */
    public Builder removeChildPartitions(int index) {
      if (childPartitionsBuilder_ == null) {
        ensureChildPartitionsIsMutable();
        childPartitions_.remove(index);
        onChanged();
      } else {
        childPartitionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of child partitions and their associated information.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition child_partitions = 3;
     * </code>
     */
    public com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition.Builder
        getChildPartitionsBuilder(int index) {
      return getChildPartitionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A set of child partitions and their associated information.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition child_partitions = 3;
     * </code>
     */
    public com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartitionOrBuilder
        getChildPartitionsOrBuilder(int index) {
      if (childPartitionsBuilder_ == null) {
        return childPartitions_.get(index);
      } else {
        return childPartitionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A set of child partitions and their associated information.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition child_partitions = 3;
     * </code>
     */
    public java.util.List<
            ? extends com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartitionOrBuilder>
        getChildPartitionsOrBuilderList() {
      if (childPartitionsBuilder_ != null) {
        return childPartitionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(childPartitions_);
      }
    }
    /**
     *
     *
     * <pre>
     * A set of child partitions and their associated information.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition child_partitions = 3;
     * </code>
     */
    public com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition.Builder
        addChildPartitionsBuilder() {
      return getChildPartitionsFieldBuilder()
          .addBuilder(
              com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A set of child partitions and their associated information.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition child_partitions = 3;
     * </code>
     */
    public com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition.Builder
        addChildPartitionsBuilder(int index) {
      return getChildPartitionsFieldBuilder()
          .addBuilder(
              index,
              com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A set of child partitions and their associated information.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition child_partitions = 3;
     * </code>
     */
    public java.util.List<
            com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition.Builder>
        getChildPartitionsBuilderList() {
      return getChildPartitionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition,
            com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition.Builder,
            com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartitionOrBuilder>
        getChildPartitionsFieldBuilder() {
      if (childPartitionsBuilder_ == null) {
        childPartitionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition,
                com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition.Builder,
                com.google.spanner.executor.v1.ChildPartitionsRecord.ChildPartitionOrBuilder>(
                childPartitions_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        childPartitions_ = null;
      }
      return childPartitionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.executor.v1.ChildPartitionsRecord)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.executor.v1.ChildPartitionsRecord)
  private static final com.google.spanner.executor.v1.ChildPartitionsRecord DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.executor.v1.ChildPartitionsRecord();
  }

  public static com.google.spanner.executor.v1.ChildPartitionsRecord getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ChildPartitionsRecord> PARSER =
      new com.google.protobuf.AbstractParser<ChildPartitionsRecord>() {
        @java.lang.Override
        public ChildPartitionsRecord parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ChildPartitionsRecord> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ChildPartitionsRecord> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.executor.v1.ChildPartitionsRecord getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
