/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/executor/v1/cloud_executor.proto

// Protobuf Java Version: 3.25.3
package com.google.spanner.executor.v1;

/**
 *
 *
 * <pre>
 * CloudBackupResponse contains results returned by cloud backup related
 * actions.
 * </pre>
 *
 * Protobuf type {@code google.spanner.executor.v1.CloudBackupResponse}
 */
public final class CloudBackupResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.executor.v1.CloudBackupResponse)
    CloudBackupResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CloudBackupResponse.newBuilder() to construct.
  private CloudBackupResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CloudBackupResponse() {
    listedBackups_ = java.util.Collections.emptyList();
    listedBackupOperations_ = java.util.Collections.emptyList();
    nextPageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CloudBackupResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_CloudBackupResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_CloudBackupResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.executor.v1.CloudBackupResponse.class,
            com.google.spanner.executor.v1.CloudBackupResponse.Builder.class);
  }

  private int bitField0_;
  public static final int LISTED_BACKUPS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.spanner.admin.database.v1.Backup> listedBackups_;
  /**
   *
   *
   * <pre>
   * List of backups returned by ListCloudBackupsAction.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.database.v1.Backup listed_backups = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.spanner.admin.database.v1.Backup> getListedBackupsList() {
    return listedBackups_;
  }
  /**
   *
   *
   * <pre>
   * List of backups returned by ListCloudBackupsAction.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.database.v1.Backup listed_backups = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.spanner.admin.database.v1.BackupOrBuilder>
      getListedBackupsOrBuilderList() {
    return listedBackups_;
  }
  /**
   *
   *
   * <pre>
   * List of backups returned by ListCloudBackupsAction.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.database.v1.Backup listed_backups = 1;</code>
   */
  @java.lang.Override
  public int getListedBackupsCount() {
    return listedBackups_.size();
  }
  /**
   *
   *
   * <pre>
   * List of backups returned by ListCloudBackupsAction.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.database.v1.Backup listed_backups = 1;</code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.Backup getListedBackups(int index) {
    return listedBackups_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of backups returned by ListCloudBackupsAction.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.database.v1.Backup listed_backups = 1;</code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.BackupOrBuilder getListedBackupsOrBuilder(int index) {
    return listedBackups_.get(index);
  }

  public static final int LISTED_BACKUP_OPERATIONS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.longrunning.Operation> listedBackupOperations_;
  /**
   *
   *
   * <pre>
   * List of operations returned by ListCloudBackupOperationsAction.
   * </pre>
   *
   * <code>repeated .google.longrunning.Operation listed_backup_operations = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.longrunning.Operation> getListedBackupOperationsList() {
    return listedBackupOperations_;
  }
  /**
   *
   *
   * <pre>
   * List of operations returned by ListCloudBackupOperationsAction.
   * </pre>
   *
   * <code>repeated .google.longrunning.Operation listed_backup_operations = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.longrunning.OperationOrBuilder>
      getListedBackupOperationsOrBuilderList() {
    return listedBackupOperations_;
  }
  /**
   *
   *
   * <pre>
   * List of operations returned by ListCloudBackupOperationsAction.
   * </pre>
   *
   * <code>repeated .google.longrunning.Operation listed_backup_operations = 2;</code>
   */
  @java.lang.Override
  public int getListedBackupOperationsCount() {
    return listedBackupOperations_.size();
  }
  /**
   *
   *
   * <pre>
   * List of operations returned by ListCloudBackupOperationsAction.
   * </pre>
   *
   * <code>repeated .google.longrunning.Operation listed_backup_operations = 2;</code>
   */
  @java.lang.Override
  public com.google.longrunning.Operation getListedBackupOperations(int index) {
    return listedBackupOperations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of operations returned by ListCloudBackupOperationsAction.
   * </pre>
   *
   * <code>repeated .google.longrunning.Operation listed_backup_operations = 2;</code>
   */
  @java.lang.Override
  public com.google.longrunning.OperationOrBuilder getListedBackupOperationsOrBuilder(int index) {
    return listedBackupOperations_.get(index);
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nextPageToken_ = "";
  /**
   *
   *
   * <pre>
   * "next_page_token" can be sent in a subsequent list action
   * to fetch more of the matching data.
   * </pre>
   *
   * <code>string next_page_token = 3;</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * "next_page_token" can be sent in a subsequent list action
   * to fetch more of the matching data.
   * </pre>
   *
   * <code>string next_page_token = 3;</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BACKUP_FIELD_NUMBER = 4;
  private com.google.spanner.admin.database.v1.Backup backup_;
  /**
   *
   *
   * <pre>
   * Backup returned by GetCloudBackupAction/UpdateCloudBackupAction.
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.Backup backup = 4;</code>
   *
   * @return Whether the backup field is set.
   */
  @java.lang.Override
  public boolean hasBackup() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Backup returned by GetCloudBackupAction/UpdateCloudBackupAction.
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.Backup backup = 4;</code>
   *
   * @return The backup.
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.Backup getBackup() {
    return backup_ == null
        ? com.google.spanner.admin.database.v1.Backup.getDefaultInstance()
        : backup_;
  }
  /**
   *
   *
   * <pre>
   * Backup returned by GetCloudBackupAction/UpdateCloudBackupAction.
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.Backup backup = 4;</code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.BackupOrBuilder getBackupOrBuilder() {
    return backup_ == null
        ? com.google.spanner.admin.database.v1.Backup.getDefaultInstance()
        : backup_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < listedBackups_.size(); i++) {
      output.writeMessage(1, listedBackups_.get(i));
    }
    for (int i = 0; i < listedBackupOperations_.size(); i++) {
      output.writeMessage(2, listedBackupOperations_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, nextPageToken_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getBackup());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < listedBackups_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, listedBackups_.get(i));
    }
    for (int i = 0; i < listedBackupOperations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, listedBackupOperations_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, nextPageToken_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getBackup());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.executor.v1.CloudBackupResponse)) {
      return super.equals(obj);
    }
    com.google.spanner.executor.v1.CloudBackupResponse other =
        (com.google.spanner.executor.v1.CloudBackupResponse) obj;

    if (!getListedBackupsList().equals(other.getListedBackupsList())) return false;
    if (!getListedBackupOperationsList().equals(other.getListedBackupOperationsList()))
      return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (hasBackup() != other.hasBackup()) return false;
    if (hasBackup()) {
      if (!getBackup().equals(other.getBackup())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getListedBackupsCount() > 0) {
      hash = (37 * hash) + LISTED_BACKUPS_FIELD_NUMBER;
      hash = (53 * hash) + getListedBackupsList().hashCode();
    }
    if (getListedBackupOperationsCount() > 0) {
      hash = (37 * hash) + LISTED_BACKUP_OPERATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getListedBackupOperationsList().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    if (hasBackup()) {
      hash = (37 * hash) + BACKUP_FIELD_NUMBER;
      hash = (53 * hash) + getBackup().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.executor.v1.CloudBackupResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.CloudBackupResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.CloudBackupResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.CloudBackupResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.CloudBackupResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.CloudBackupResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.CloudBackupResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.CloudBackupResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.CloudBackupResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.CloudBackupResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.CloudBackupResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.CloudBackupResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.executor.v1.CloudBackupResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * CloudBackupResponse contains results returned by cloud backup related
   * actions.
   * </pre>
   *
   * Protobuf type {@code google.spanner.executor.v1.CloudBackupResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.executor.v1.CloudBackupResponse)
      com.google.spanner.executor.v1.CloudBackupResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_CloudBackupResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_CloudBackupResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.executor.v1.CloudBackupResponse.class,
              com.google.spanner.executor.v1.CloudBackupResponse.Builder.class);
    }

    // Construct using com.google.spanner.executor.v1.CloudBackupResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getListedBackupsFieldBuilder();
        getListedBackupOperationsFieldBuilder();
        getBackupFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (listedBackupsBuilder_ == null) {
        listedBackups_ = java.util.Collections.emptyList();
      } else {
        listedBackups_ = null;
        listedBackupsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (listedBackupOperationsBuilder_ == null) {
        listedBackupOperations_ = java.util.Collections.emptyList();
      } else {
        listedBackupOperations_ = null;
        listedBackupOperationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      nextPageToken_ = "";
      backup_ = null;
      if (backupBuilder_ != null) {
        backupBuilder_.dispose();
        backupBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_CloudBackupResponse_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.CloudBackupResponse getDefaultInstanceForType() {
      return com.google.spanner.executor.v1.CloudBackupResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.CloudBackupResponse build() {
      com.google.spanner.executor.v1.CloudBackupResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.CloudBackupResponse buildPartial() {
      com.google.spanner.executor.v1.CloudBackupResponse result =
          new com.google.spanner.executor.v1.CloudBackupResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.spanner.executor.v1.CloudBackupResponse result) {
      if (listedBackupsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          listedBackups_ = java.util.Collections.unmodifiableList(listedBackups_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.listedBackups_ = listedBackups_;
      } else {
        result.listedBackups_ = listedBackupsBuilder_.build();
      }
      if (listedBackupOperationsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          listedBackupOperations_ = java.util.Collections.unmodifiableList(listedBackupOperations_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.listedBackupOperations_ = listedBackupOperations_;
      } else {
        result.listedBackupOperations_ = listedBackupOperationsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.spanner.executor.v1.CloudBackupResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.nextPageToken_ = nextPageToken_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.backup_ = backupBuilder_ == null ? backup_ : backupBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.executor.v1.CloudBackupResponse) {
        return mergeFrom((com.google.spanner.executor.v1.CloudBackupResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.executor.v1.CloudBackupResponse other) {
      if (other == com.google.spanner.executor.v1.CloudBackupResponse.getDefaultInstance())
        return this;
      if (listedBackupsBuilder_ == null) {
        if (!other.listedBackups_.isEmpty()) {
          if (listedBackups_.isEmpty()) {
            listedBackups_ = other.listedBackups_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureListedBackupsIsMutable();
            listedBackups_.addAll(other.listedBackups_);
          }
          onChanged();
        }
      } else {
        if (!other.listedBackups_.isEmpty()) {
          if (listedBackupsBuilder_.isEmpty()) {
            listedBackupsBuilder_.dispose();
            listedBackupsBuilder_ = null;
            listedBackups_ = other.listedBackups_;
            bitField0_ = (bitField0_ & ~0x00000001);
            listedBackupsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getListedBackupsFieldBuilder()
                    : null;
          } else {
            listedBackupsBuilder_.addAllMessages(other.listedBackups_);
          }
        }
      }
      if (listedBackupOperationsBuilder_ == null) {
        if (!other.listedBackupOperations_.isEmpty()) {
          if (listedBackupOperations_.isEmpty()) {
            listedBackupOperations_ = other.listedBackupOperations_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureListedBackupOperationsIsMutable();
            listedBackupOperations_.addAll(other.listedBackupOperations_);
          }
          onChanged();
        }
      } else {
        if (!other.listedBackupOperations_.isEmpty()) {
          if (listedBackupOperationsBuilder_.isEmpty()) {
            listedBackupOperationsBuilder_.dispose();
            listedBackupOperationsBuilder_ = null;
            listedBackupOperations_ = other.listedBackupOperations_;
            bitField0_ = (bitField0_ & ~0x00000002);
            listedBackupOperationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getListedBackupOperationsFieldBuilder()
                    : null;
          } else {
            listedBackupOperationsBuilder_.addAllMessages(other.listedBackupOperations_);
          }
        }
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasBackup()) {
        mergeBackup(other.getBackup());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.spanner.admin.database.v1.Backup m =
                    input.readMessage(
                        com.google.spanner.admin.database.v1.Backup.parser(), extensionRegistry);
                if (listedBackupsBuilder_ == null) {
                  ensureListedBackupsIsMutable();
                  listedBackups_.add(m);
                } else {
                  listedBackupsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                com.google.longrunning.Operation m =
                    input.readMessage(com.google.longrunning.Operation.parser(), extensionRegistry);
                if (listedBackupOperationsBuilder_ == null) {
                  ensureListedBackupOperationsIsMutable();
                  listedBackupOperations_.add(m);
                } else {
                  listedBackupOperationsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                nextPageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getBackupFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.spanner.admin.database.v1.Backup> listedBackups_ =
        java.util.Collections.emptyList();

    private void ensureListedBackupsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        listedBackups_ =
            new java.util.ArrayList<com.google.spanner.admin.database.v1.Backup>(listedBackups_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.admin.database.v1.Backup,
            com.google.spanner.admin.database.v1.Backup.Builder,
            com.google.spanner.admin.database.v1.BackupOrBuilder>
        listedBackupsBuilder_;

    /**
     *
     *
     * <pre>
     * List of backups returned by ListCloudBackupsAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Backup listed_backups = 1;</code>
     */
    public java.util.List<com.google.spanner.admin.database.v1.Backup> getListedBackupsList() {
      if (listedBackupsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(listedBackups_);
      } else {
        return listedBackupsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of backups returned by ListCloudBackupsAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Backup listed_backups = 1;</code>
     */
    public int getListedBackupsCount() {
      if (listedBackupsBuilder_ == null) {
        return listedBackups_.size();
      } else {
        return listedBackupsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of backups returned by ListCloudBackupsAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Backup listed_backups = 1;</code>
     */
    public com.google.spanner.admin.database.v1.Backup getListedBackups(int index) {
      if (listedBackupsBuilder_ == null) {
        return listedBackups_.get(index);
      } else {
        return listedBackupsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of backups returned by ListCloudBackupsAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Backup listed_backups = 1;</code>
     */
    public Builder setListedBackups(int index, com.google.spanner.admin.database.v1.Backup value) {
      if (listedBackupsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureListedBackupsIsMutable();
        listedBackups_.set(index, value);
        onChanged();
      } else {
        listedBackupsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of backups returned by ListCloudBackupsAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Backup listed_backups = 1;</code>
     */
    public Builder setListedBackups(
        int index, com.google.spanner.admin.database.v1.Backup.Builder builderForValue) {
      if (listedBackupsBuilder_ == null) {
        ensureListedBackupsIsMutable();
        listedBackups_.set(index, builderForValue.build());
        onChanged();
      } else {
        listedBackupsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of backups returned by ListCloudBackupsAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Backup listed_backups = 1;</code>
     */
    public Builder addListedBackups(com.google.spanner.admin.database.v1.Backup value) {
      if (listedBackupsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureListedBackupsIsMutable();
        listedBackups_.add(value);
        onChanged();
      } else {
        listedBackupsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of backups returned by ListCloudBackupsAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Backup listed_backups = 1;</code>
     */
    public Builder addListedBackups(int index, com.google.spanner.admin.database.v1.Backup value) {
      if (listedBackupsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureListedBackupsIsMutable();
        listedBackups_.add(index, value);
        onChanged();
      } else {
        listedBackupsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of backups returned by ListCloudBackupsAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Backup listed_backups = 1;</code>
     */
    public Builder addListedBackups(
        com.google.spanner.admin.database.v1.Backup.Builder builderForValue) {
      if (listedBackupsBuilder_ == null) {
        ensureListedBackupsIsMutable();
        listedBackups_.add(builderForValue.build());
        onChanged();
      } else {
        listedBackupsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of backups returned by ListCloudBackupsAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Backup listed_backups = 1;</code>
     */
    public Builder addListedBackups(
        int index, com.google.spanner.admin.database.v1.Backup.Builder builderForValue) {
      if (listedBackupsBuilder_ == null) {
        ensureListedBackupsIsMutable();
        listedBackups_.add(index, builderForValue.build());
        onChanged();
      } else {
        listedBackupsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of backups returned by ListCloudBackupsAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Backup listed_backups = 1;</code>
     */
    public Builder addAllListedBackups(
        java.lang.Iterable<? extends com.google.spanner.admin.database.v1.Backup> values) {
      if (listedBackupsBuilder_ == null) {
        ensureListedBackupsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, listedBackups_);
        onChanged();
      } else {
        listedBackupsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of backups returned by ListCloudBackupsAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Backup listed_backups = 1;</code>
     */
    public Builder clearListedBackups() {
      if (listedBackupsBuilder_ == null) {
        listedBackups_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        listedBackupsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of backups returned by ListCloudBackupsAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Backup listed_backups = 1;</code>
     */
    public Builder removeListedBackups(int index) {
      if (listedBackupsBuilder_ == null) {
        ensureListedBackupsIsMutable();
        listedBackups_.remove(index);
        onChanged();
      } else {
        listedBackupsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of backups returned by ListCloudBackupsAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Backup listed_backups = 1;</code>
     */
    public com.google.spanner.admin.database.v1.Backup.Builder getListedBackupsBuilder(int index) {
      return getListedBackupsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of backups returned by ListCloudBackupsAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Backup listed_backups = 1;</code>
     */
    public com.google.spanner.admin.database.v1.BackupOrBuilder getListedBackupsOrBuilder(
        int index) {
      if (listedBackupsBuilder_ == null) {
        return listedBackups_.get(index);
      } else {
        return listedBackupsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of backups returned by ListCloudBackupsAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Backup listed_backups = 1;</code>
     */
    public java.util.List<? extends com.google.spanner.admin.database.v1.BackupOrBuilder>
        getListedBackupsOrBuilderList() {
      if (listedBackupsBuilder_ != null) {
        return listedBackupsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(listedBackups_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of backups returned by ListCloudBackupsAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Backup listed_backups = 1;</code>
     */
    public com.google.spanner.admin.database.v1.Backup.Builder addListedBackupsBuilder() {
      return getListedBackupsFieldBuilder()
          .addBuilder(com.google.spanner.admin.database.v1.Backup.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of backups returned by ListCloudBackupsAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Backup listed_backups = 1;</code>
     */
    public com.google.spanner.admin.database.v1.Backup.Builder addListedBackupsBuilder(int index) {
      return getListedBackupsFieldBuilder()
          .addBuilder(index, com.google.spanner.admin.database.v1.Backup.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of backups returned by ListCloudBackupsAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Backup listed_backups = 1;</code>
     */
    public java.util.List<com.google.spanner.admin.database.v1.Backup.Builder>
        getListedBackupsBuilderList() {
      return getListedBackupsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.admin.database.v1.Backup,
            com.google.spanner.admin.database.v1.Backup.Builder,
            com.google.spanner.admin.database.v1.BackupOrBuilder>
        getListedBackupsFieldBuilder() {
      if (listedBackupsBuilder_ == null) {
        listedBackupsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.spanner.admin.database.v1.Backup,
                com.google.spanner.admin.database.v1.Backup.Builder,
                com.google.spanner.admin.database.v1.BackupOrBuilder>(
                listedBackups_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        listedBackups_ = null;
      }
      return listedBackupsBuilder_;
    }

    private java.util.List<com.google.longrunning.Operation> listedBackupOperations_ =
        java.util.Collections.emptyList();

    private void ensureListedBackupOperationsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        listedBackupOperations_ =
            new java.util.ArrayList<com.google.longrunning.Operation>(listedBackupOperations_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.longrunning.Operation,
            com.google.longrunning.Operation.Builder,
            com.google.longrunning.OperationOrBuilder>
        listedBackupOperationsBuilder_;

    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudBackupOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_backup_operations = 2;</code>
     */
    public java.util.List<com.google.longrunning.Operation> getListedBackupOperationsList() {
      if (listedBackupOperationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(listedBackupOperations_);
      } else {
        return listedBackupOperationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudBackupOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_backup_operations = 2;</code>
     */
    public int getListedBackupOperationsCount() {
      if (listedBackupOperationsBuilder_ == null) {
        return listedBackupOperations_.size();
      } else {
        return listedBackupOperationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudBackupOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_backup_operations = 2;</code>
     */
    public com.google.longrunning.Operation getListedBackupOperations(int index) {
      if (listedBackupOperationsBuilder_ == null) {
        return listedBackupOperations_.get(index);
      } else {
        return listedBackupOperationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudBackupOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_backup_operations = 2;</code>
     */
    public Builder setListedBackupOperations(int index, com.google.longrunning.Operation value) {
      if (listedBackupOperationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureListedBackupOperationsIsMutable();
        listedBackupOperations_.set(index, value);
        onChanged();
      } else {
        listedBackupOperationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudBackupOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_backup_operations = 2;</code>
     */
    public Builder setListedBackupOperations(
        int index, com.google.longrunning.Operation.Builder builderForValue) {
      if (listedBackupOperationsBuilder_ == null) {
        ensureListedBackupOperationsIsMutable();
        listedBackupOperations_.set(index, builderForValue.build());
        onChanged();
      } else {
        listedBackupOperationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudBackupOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_backup_operations = 2;</code>
     */
    public Builder addListedBackupOperations(com.google.longrunning.Operation value) {
      if (listedBackupOperationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureListedBackupOperationsIsMutable();
        listedBackupOperations_.add(value);
        onChanged();
      } else {
        listedBackupOperationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudBackupOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_backup_operations = 2;</code>
     */
    public Builder addListedBackupOperations(int index, com.google.longrunning.Operation value) {
      if (listedBackupOperationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureListedBackupOperationsIsMutable();
        listedBackupOperations_.add(index, value);
        onChanged();
      } else {
        listedBackupOperationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudBackupOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_backup_operations = 2;</code>
     */
    public Builder addListedBackupOperations(
        com.google.longrunning.Operation.Builder builderForValue) {
      if (listedBackupOperationsBuilder_ == null) {
        ensureListedBackupOperationsIsMutable();
        listedBackupOperations_.add(builderForValue.build());
        onChanged();
      } else {
        listedBackupOperationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudBackupOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_backup_operations = 2;</code>
     */
    public Builder addListedBackupOperations(
        int index, com.google.longrunning.Operation.Builder builderForValue) {
      if (listedBackupOperationsBuilder_ == null) {
        ensureListedBackupOperationsIsMutable();
        listedBackupOperations_.add(index, builderForValue.build());
        onChanged();
      } else {
        listedBackupOperationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudBackupOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_backup_operations = 2;</code>
     */
    public Builder addAllListedBackupOperations(
        java.lang.Iterable<? extends com.google.longrunning.Operation> values) {
      if (listedBackupOperationsBuilder_ == null) {
        ensureListedBackupOperationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, listedBackupOperations_);
        onChanged();
      } else {
        listedBackupOperationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudBackupOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_backup_operations = 2;</code>
     */
    public Builder clearListedBackupOperations() {
      if (listedBackupOperationsBuilder_ == null) {
        listedBackupOperations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        listedBackupOperationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudBackupOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_backup_operations = 2;</code>
     */
    public Builder removeListedBackupOperations(int index) {
      if (listedBackupOperationsBuilder_ == null) {
        ensureListedBackupOperationsIsMutable();
        listedBackupOperations_.remove(index);
        onChanged();
      } else {
        listedBackupOperationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudBackupOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_backup_operations = 2;</code>
     */
    public com.google.longrunning.Operation.Builder getListedBackupOperationsBuilder(int index) {
      return getListedBackupOperationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudBackupOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_backup_operations = 2;</code>
     */
    public com.google.longrunning.OperationOrBuilder getListedBackupOperationsOrBuilder(int index) {
      if (listedBackupOperationsBuilder_ == null) {
        return listedBackupOperations_.get(index);
      } else {
        return listedBackupOperationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudBackupOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_backup_operations = 2;</code>
     */
    public java.util.List<? extends com.google.longrunning.OperationOrBuilder>
        getListedBackupOperationsOrBuilderList() {
      if (listedBackupOperationsBuilder_ != null) {
        return listedBackupOperationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(listedBackupOperations_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudBackupOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_backup_operations = 2;</code>
     */
    public com.google.longrunning.Operation.Builder addListedBackupOperationsBuilder() {
      return getListedBackupOperationsFieldBuilder()
          .addBuilder(com.google.longrunning.Operation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudBackupOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_backup_operations = 2;</code>
     */
    public com.google.longrunning.Operation.Builder addListedBackupOperationsBuilder(int index) {
      return getListedBackupOperationsFieldBuilder()
          .addBuilder(index, com.google.longrunning.Operation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudBackupOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_backup_operations = 2;</code>
     */
    public java.util.List<com.google.longrunning.Operation.Builder>
        getListedBackupOperationsBuilderList() {
      return getListedBackupOperationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.longrunning.Operation,
            com.google.longrunning.Operation.Builder,
            com.google.longrunning.OperationOrBuilder>
        getListedBackupOperationsFieldBuilder() {
      if (listedBackupOperationsBuilder_ == null) {
        listedBackupOperationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.longrunning.Operation,
                com.google.longrunning.Operation.Builder,
                com.google.longrunning.OperationOrBuilder>(
                listedBackupOperations_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        listedBackupOperations_ = null;
      }
      return listedBackupOperationsBuilder_;
    }

    private java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * "next_page_token" can be sent in a subsequent list action
     * to fetch more of the matching data.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * "next_page_token" can be sent in a subsequent list action
     * to fetch more of the matching data.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * "next_page_token" can be sent in a subsequent list action
     * to fetch more of the matching data.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextPageToken_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * "next_page_token" can be sent in a subsequent list action
     * to fetch more of the matching data.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {
      nextPageToken_ = getDefaultInstance().getNextPageToken();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * "next_page_token" can be sent in a subsequent list action
     * to fetch more of the matching data.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextPageToken_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.spanner.admin.database.v1.Backup backup_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.Backup,
            com.google.spanner.admin.database.v1.Backup.Builder,
            com.google.spanner.admin.database.v1.BackupOrBuilder>
        backupBuilder_;
    /**
     *
     *
     * <pre>
     * Backup returned by GetCloudBackupAction/UpdateCloudBackupAction.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.Backup backup = 4;</code>
     *
     * @return Whether the backup field is set.
     */
    public boolean hasBackup() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Backup returned by GetCloudBackupAction/UpdateCloudBackupAction.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.Backup backup = 4;</code>
     *
     * @return The backup.
     */
    public com.google.spanner.admin.database.v1.Backup getBackup() {
      if (backupBuilder_ == null) {
        return backup_ == null
            ? com.google.spanner.admin.database.v1.Backup.getDefaultInstance()
            : backup_;
      } else {
        return backupBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Backup returned by GetCloudBackupAction/UpdateCloudBackupAction.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.Backup backup = 4;</code>
     */
    public Builder setBackup(com.google.spanner.admin.database.v1.Backup value) {
      if (backupBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        backup_ = value;
      } else {
        backupBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Backup returned by GetCloudBackupAction/UpdateCloudBackupAction.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.Backup backup = 4;</code>
     */
    public Builder setBackup(com.google.spanner.admin.database.v1.Backup.Builder builderForValue) {
      if (backupBuilder_ == null) {
        backup_ = builderForValue.build();
      } else {
        backupBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Backup returned by GetCloudBackupAction/UpdateCloudBackupAction.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.Backup backup = 4;</code>
     */
    public Builder mergeBackup(com.google.spanner.admin.database.v1.Backup value) {
      if (backupBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && backup_ != null
            && backup_ != com.google.spanner.admin.database.v1.Backup.getDefaultInstance()) {
          getBackupBuilder().mergeFrom(value);
        } else {
          backup_ = value;
        }
      } else {
        backupBuilder_.mergeFrom(value);
      }
      if (backup_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Backup returned by GetCloudBackupAction/UpdateCloudBackupAction.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.Backup backup = 4;</code>
     */
    public Builder clearBackup() {
      bitField0_ = (bitField0_ & ~0x00000008);
      backup_ = null;
      if (backupBuilder_ != null) {
        backupBuilder_.dispose();
        backupBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Backup returned by GetCloudBackupAction/UpdateCloudBackupAction.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.Backup backup = 4;</code>
     */
    public com.google.spanner.admin.database.v1.Backup.Builder getBackupBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getBackupFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Backup returned by GetCloudBackupAction/UpdateCloudBackupAction.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.Backup backup = 4;</code>
     */
    public com.google.spanner.admin.database.v1.BackupOrBuilder getBackupOrBuilder() {
      if (backupBuilder_ != null) {
        return backupBuilder_.getMessageOrBuilder();
      } else {
        return backup_ == null
            ? com.google.spanner.admin.database.v1.Backup.getDefaultInstance()
            : backup_;
      }
    }
    /**
     *
     *
     * <pre>
     * Backup returned by GetCloudBackupAction/UpdateCloudBackupAction.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.Backup backup = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.Backup,
            com.google.spanner.admin.database.v1.Backup.Builder,
            com.google.spanner.admin.database.v1.BackupOrBuilder>
        getBackupFieldBuilder() {
      if (backupBuilder_ == null) {
        backupBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.admin.database.v1.Backup,
                com.google.spanner.admin.database.v1.Backup.Builder,
                com.google.spanner.admin.database.v1.BackupOrBuilder>(
                getBackup(), getParentForChildren(), isClean());
        backup_ = null;
      }
      return backupBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.executor.v1.CloudBackupResponse)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.executor.v1.CloudBackupResponse)
  private static final com.google.spanner.executor.v1.CloudBackupResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.executor.v1.CloudBackupResponse();
  }

  public static com.google.spanner.executor.v1.CloudBackupResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CloudBackupResponse> PARSER =
      new com.google.protobuf.AbstractParser<CloudBackupResponse>() {
        @java.lang.Override
        public CloudBackupResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CloudBackupResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CloudBackupResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.executor.v1.CloudBackupResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
