/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/executor/v1/cloud_executor.proto

// Protobuf Java Version: 3.25.3
package com.google.spanner.executor.v1;

/**
 *
 *
 * <pre>
 * CloudInstanceResponse contains results returned by cloud instance related
 * actions.
 * </pre>
 *
 * Protobuf type {@code google.spanner.executor.v1.CloudInstanceResponse}
 */
public final class CloudInstanceResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.executor.v1.CloudInstanceResponse)
    CloudInstanceResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CloudInstanceResponse.newBuilder() to construct.
  private CloudInstanceResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CloudInstanceResponse() {
    listedInstances_ = java.util.Collections.emptyList();
    nextPageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CloudInstanceResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_CloudInstanceResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_CloudInstanceResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.executor.v1.CloudInstanceResponse.class,
            com.google.spanner.executor.v1.CloudInstanceResponse.Builder.class);
  }

  private int bitField0_;
  public static final int LISTED_INSTANCES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.spanner.admin.instance.v1.Instance> listedInstances_;
  /**
   *
   *
   * <pre>
   * List of instances returned by ListCloudInstancesAction.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.instance.v1.Instance listed_instances = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.spanner.admin.instance.v1.Instance> getListedInstancesList() {
    return listedInstances_;
  }
  /**
   *
   *
   * <pre>
   * List of instances returned by ListCloudInstancesAction.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.instance.v1.Instance listed_instances = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.spanner.admin.instance.v1.InstanceOrBuilder>
      getListedInstancesOrBuilderList() {
    return listedInstances_;
  }
  /**
   *
   *
   * <pre>
   * List of instances returned by ListCloudInstancesAction.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.instance.v1.Instance listed_instances = 1;</code>
   */
  @java.lang.Override
  public int getListedInstancesCount() {
    return listedInstances_.size();
  }
  /**
   *
   *
   * <pre>
   * List of instances returned by ListCloudInstancesAction.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.instance.v1.Instance listed_instances = 1;</code>
   */
  @java.lang.Override
  public com.google.spanner.admin.instance.v1.Instance getListedInstances(int index) {
    return listedInstances_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of instances returned by ListCloudInstancesAction.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.instance.v1.Instance listed_instances = 1;</code>
   */
  @java.lang.Override
  public com.google.spanner.admin.instance.v1.InstanceOrBuilder getListedInstancesOrBuilder(
      int index) {
    return listedInstances_.get(index);
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nextPageToken_ = "";
  /**
   *
   *
   * <pre>
   * "next_page_token" can be sent in a subsequent list action
   * to fetch more of the matching data.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * "next_page_token" can be sent in a subsequent list action
   * to fetch more of the matching data.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSTANCE_FIELD_NUMBER = 3;
  private com.google.spanner.admin.instance.v1.Instance instance_;
  /**
   *
   *
   * <pre>
   * Instance returned by GetCloudInstanceAction
   * </pre>
   *
   * <code>.google.spanner.admin.instance.v1.Instance instance = 3;</code>
   *
   * @return Whether the instance field is set.
   */
  @java.lang.Override
  public boolean hasInstance() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Instance returned by GetCloudInstanceAction
   * </pre>
   *
   * <code>.google.spanner.admin.instance.v1.Instance instance = 3;</code>
   *
   * @return The instance.
   */
  @java.lang.Override
  public com.google.spanner.admin.instance.v1.Instance getInstance() {
    return instance_ == null
        ? com.google.spanner.admin.instance.v1.Instance.getDefaultInstance()
        : instance_;
  }
  /**
   *
   *
   * <pre>
   * Instance returned by GetCloudInstanceAction
   * </pre>
   *
   * <code>.google.spanner.admin.instance.v1.Instance instance = 3;</code>
   */
  @java.lang.Override
  public com.google.spanner.admin.instance.v1.InstanceOrBuilder getInstanceOrBuilder() {
    return instance_ == null
        ? com.google.spanner.admin.instance.v1.Instance.getDefaultInstance()
        : instance_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < listedInstances_.size(); i++) {
      output.writeMessage(1, listedInstances_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, nextPageToken_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getInstance());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < listedInstances_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, listedInstances_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, nextPageToken_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getInstance());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.executor.v1.CloudInstanceResponse)) {
      return super.equals(obj);
    }
    com.google.spanner.executor.v1.CloudInstanceResponse other =
        (com.google.spanner.executor.v1.CloudInstanceResponse) obj;

    if (!getListedInstancesList().equals(other.getListedInstancesList())) return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (hasInstance() != other.hasInstance()) return false;
    if (hasInstance()) {
      if (!getInstance().equals(other.getInstance())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getListedInstancesCount() > 0) {
      hash = (37 * hash) + LISTED_INSTANCES_FIELD_NUMBER;
      hash = (53 * hash) + getListedInstancesList().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    if (hasInstance()) {
      hash = (37 * hash) + INSTANCE_FIELD_NUMBER;
      hash = (53 * hash) + getInstance().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.executor.v1.CloudInstanceResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.CloudInstanceResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.CloudInstanceResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.CloudInstanceResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.CloudInstanceResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.CloudInstanceResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.CloudInstanceResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.CloudInstanceResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.CloudInstanceResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.CloudInstanceResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.CloudInstanceResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.CloudInstanceResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.executor.v1.CloudInstanceResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * CloudInstanceResponse contains results returned by cloud instance related
   * actions.
   * </pre>
   *
   * Protobuf type {@code google.spanner.executor.v1.CloudInstanceResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.executor.v1.CloudInstanceResponse)
      com.google.spanner.executor.v1.CloudInstanceResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_CloudInstanceResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_CloudInstanceResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.executor.v1.CloudInstanceResponse.class,
              com.google.spanner.executor.v1.CloudInstanceResponse.Builder.class);
    }

    // Construct using com.google.spanner.executor.v1.CloudInstanceResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getListedInstancesFieldBuilder();
        getInstanceFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (listedInstancesBuilder_ == null) {
        listedInstances_ = java.util.Collections.emptyList();
      } else {
        listedInstances_ = null;
        listedInstancesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      nextPageToken_ = "";
      instance_ = null;
      if (instanceBuilder_ != null) {
        instanceBuilder_.dispose();
        instanceBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_CloudInstanceResponse_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.CloudInstanceResponse getDefaultInstanceForType() {
      return com.google.spanner.executor.v1.CloudInstanceResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.CloudInstanceResponse build() {
      com.google.spanner.executor.v1.CloudInstanceResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.CloudInstanceResponse buildPartial() {
      com.google.spanner.executor.v1.CloudInstanceResponse result =
          new com.google.spanner.executor.v1.CloudInstanceResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.spanner.executor.v1.CloudInstanceResponse result) {
      if (listedInstancesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          listedInstances_ = java.util.Collections.unmodifiableList(listedInstances_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.listedInstances_ = listedInstances_;
      } else {
        result.listedInstances_ = listedInstancesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.spanner.executor.v1.CloudInstanceResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.nextPageToken_ = nextPageToken_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.instance_ = instanceBuilder_ == null ? instance_ : instanceBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.executor.v1.CloudInstanceResponse) {
        return mergeFrom((com.google.spanner.executor.v1.CloudInstanceResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.executor.v1.CloudInstanceResponse other) {
      if (other == com.google.spanner.executor.v1.CloudInstanceResponse.getDefaultInstance())
        return this;
      if (listedInstancesBuilder_ == null) {
        if (!other.listedInstances_.isEmpty()) {
          if (listedInstances_.isEmpty()) {
            listedInstances_ = other.listedInstances_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureListedInstancesIsMutable();
            listedInstances_.addAll(other.listedInstances_);
          }
          onChanged();
        }
      } else {
        if (!other.listedInstances_.isEmpty()) {
          if (listedInstancesBuilder_.isEmpty()) {
            listedInstancesBuilder_.dispose();
            listedInstancesBuilder_ = null;
            listedInstances_ = other.listedInstances_;
            bitField0_ = (bitField0_ & ~0x00000001);
            listedInstancesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getListedInstancesFieldBuilder()
                    : null;
          } else {
            listedInstancesBuilder_.addAllMessages(other.listedInstances_);
          }
        }
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasInstance()) {
        mergeInstance(other.getInstance());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.spanner.admin.instance.v1.Instance m =
                    input.readMessage(
                        com.google.spanner.admin.instance.v1.Instance.parser(), extensionRegistry);
                if (listedInstancesBuilder_ == null) {
                  ensureListedInstancesIsMutable();
                  listedInstances_.add(m);
                } else {
                  listedInstancesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                nextPageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getInstanceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.spanner.admin.instance.v1.Instance> listedInstances_ =
        java.util.Collections.emptyList();

    private void ensureListedInstancesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        listedInstances_ =
            new java.util.ArrayList<com.google.spanner.admin.instance.v1.Instance>(
                listedInstances_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.admin.instance.v1.Instance,
            com.google.spanner.admin.instance.v1.Instance.Builder,
            com.google.spanner.admin.instance.v1.InstanceOrBuilder>
        listedInstancesBuilder_;

    /**
     *
     *
     * <pre>
     * List of instances returned by ListCloudInstancesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.Instance listed_instances = 1;</code>
     */
    public java.util.List<com.google.spanner.admin.instance.v1.Instance> getListedInstancesList() {
      if (listedInstancesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(listedInstances_);
      } else {
        return listedInstancesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of instances returned by ListCloudInstancesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.Instance listed_instances = 1;</code>
     */
    public int getListedInstancesCount() {
      if (listedInstancesBuilder_ == null) {
        return listedInstances_.size();
      } else {
        return listedInstancesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of instances returned by ListCloudInstancesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.Instance listed_instances = 1;</code>
     */
    public com.google.spanner.admin.instance.v1.Instance getListedInstances(int index) {
      if (listedInstancesBuilder_ == null) {
        return listedInstances_.get(index);
      } else {
        return listedInstancesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of instances returned by ListCloudInstancesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.Instance listed_instances = 1;</code>
     */
    public Builder setListedInstances(
        int index, com.google.spanner.admin.instance.v1.Instance value) {
      if (listedInstancesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureListedInstancesIsMutable();
        listedInstances_.set(index, value);
        onChanged();
      } else {
        listedInstancesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of instances returned by ListCloudInstancesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.Instance listed_instances = 1;</code>
     */
    public Builder setListedInstances(
        int index, com.google.spanner.admin.instance.v1.Instance.Builder builderForValue) {
      if (listedInstancesBuilder_ == null) {
        ensureListedInstancesIsMutable();
        listedInstances_.set(index, builderForValue.build());
        onChanged();
      } else {
        listedInstancesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of instances returned by ListCloudInstancesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.Instance listed_instances = 1;</code>
     */
    public Builder addListedInstances(com.google.spanner.admin.instance.v1.Instance value) {
      if (listedInstancesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureListedInstancesIsMutable();
        listedInstances_.add(value);
        onChanged();
      } else {
        listedInstancesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of instances returned by ListCloudInstancesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.Instance listed_instances = 1;</code>
     */
    public Builder addListedInstances(
        int index, com.google.spanner.admin.instance.v1.Instance value) {
      if (listedInstancesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureListedInstancesIsMutable();
        listedInstances_.add(index, value);
        onChanged();
      } else {
        listedInstancesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of instances returned by ListCloudInstancesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.Instance listed_instances = 1;</code>
     */
    public Builder addListedInstances(
        com.google.spanner.admin.instance.v1.Instance.Builder builderForValue) {
      if (listedInstancesBuilder_ == null) {
        ensureListedInstancesIsMutable();
        listedInstances_.add(builderForValue.build());
        onChanged();
      } else {
        listedInstancesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of instances returned by ListCloudInstancesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.Instance listed_instances = 1;</code>
     */
    public Builder addListedInstances(
        int index, com.google.spanner.admin.instance.v1.Instance.Builder builderForValue) {
      if (listedInstancesBuilder_ == null) {
        ensureListedInstancesIsMutable();
        listedInstances_.add(index, builderForValue.build());
        onChanged();
      } else {
        listedInstancesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of instances returned by ListCloudInstancesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.Instance listed_instances = 1;</code>
     */
    public Builder addAllListedInstances(
        java.lang.Iterable<? extends com.google.spanner.admin.instance.v1.Instance> values) {
      if (listedInstancesBuilder_ == null) {
        ensureListedInstancesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, listedInstances_);
        onChanged();
      } else {
        listedInstancesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of instances returned by ListCloudInstancesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.Instance listed_instances = 1;</code>
     */
    public Builder clearListedInstances() {
      if (listedInstancesBuilder_ == null) {
        listedInstances_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        listedInstancesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of instances returned by ListCloudInstancesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.Instance listed_instances = 1;</code>
     */
    public Builder removeListedInstances(int index) {
      if (listedInstancesBuilder_ == null) {
        ensureListedInstancesIsMutable();
        listedInstances_.remove(index);
        onChanged();
      } else {
        listedInstancesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of instances returned by ListCloudInstancesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.Instance listed_instances = 1;</code>
     */
    public com.google.spanner.admin.instance.v1.Instance.Builder getListedInstancesBuilder(
        int index) {
      return getListedInstancesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of instances returned by ListCloudInstancesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.Instance listed_instances = 1;</code>
     */
    public com.google.spanner.admin.instance.v1.InstanceOrBuilder getListedInstancesOrBuilder(
        int index) {
      if (listedInstancesBuilder_ == null) {
        return listedInstances_.get(index);
      } else {
        return listedInstancesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of instances returned by ListCloudInstancesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.Instance listed_instances = 1;</code>
     */
    public java.util.List<? extends com.google.spanner.admin.instance.v1.InstanceOrBuilder>
        getListedInstancesOrBuilderList() {
      if (listedInstancesBuilder_ != null) {
        return listedInstancesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(listedInstances_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of instances returned by ListCloudInstancesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.Instance listed_instances = 1;</code>
     */
    public com.google.spanner.admin.instance.v1.Instance.Builder addListedInstancesBuilder() {
      return getListedInstancesFieldBuilder()
          .addBuilder(com.google.spanner.admin.instance.v1.Instance.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of instances returned by ListCloudInstancesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.Instance listed_instances = 1;</code>
     */
    public com.google.spanner.admin.instance.v1.Instance.Builder addListedInstancesBuilder(
        int index) {
      return getListedInstancesFieldBuilder()
          .addBuilder(index, com.google.spanner.admin.instance.v1.Instance.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of instances returned by ListCloudInstancesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.Instance listed_instances = 1;</code>
     */
    public java.util.List<com.google.spanner.admin.instance.v1.Instance.Builder>
        getListedInstancesBuilderList() {
      return getListedInstancesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.admin.instance.v1.Instance,
            com.google.spanner.admin.instance.v1.Instance.Builder,
            com.google.spanner.admin.instance.v1.InstanceOrBuilder>
        getListedInstancesFieldBuilder() {
      if (listedInstancesBuilder_ == null) {
        listedInstancesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.spanner.admin.instance.v1.Instance,
                com.google.spanner.admin.instance.v1.Instance.Builder,
                com.google.spanner.admin.instance.v1.InstanceOrBuilder>(
                listedInstances_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        listedInstances_ = null;
      }
      return listedInstancesBuilder_;
    }

    private java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * "next_page_token" can be sent in a subsequent list action
     * to fetch more of the matching data.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * "next_page_token" can be sent in a subsequent list action
     * to fetch more of the matching data.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * "next_page_token" can be sent in a subsequent list action
     * to fetch more of the matching data.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextPageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * "next_page_token" can be sent in a subsequent list action
     * to fetch more of the matching data.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {
      nextPageToken_ = getDefaultInstance().getNextPageToken();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * "next_page_token" can be sent in a subsequent list action
     * to fetch more of the matching data.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextPageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.spanner.admin.instance.v1.Instance instance_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.instance.v1.Instance,
            com.google.spanner.admin.instance.v1.Instance.Builder,
            com.google.spanner.admin.instance.v1.InstanceOrBuilder>
        instanceBuilder_;
    /**
     *
     *
     * <pre>
     * Instance returned by GetCloudInstanceAction
     * </pre>
     *
     * <code>.google.spanner.admin.instance.v1.Instance instance = 3;</code>
     *
     * @return Whether the instance field is set.
     */
    public boolean hasInstance() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Instance returned by GetCloudInstanceAction
     * </pre>
     *
     * <code>.google.spanner.admin.instance.v1.Instance instance = 3;</code>
     *
     * @return The instance.
     */
    public com.google.spanner.admin.instance.v1.Instance getInstance() {
      if (instanceBuilder_ == null) {
        return instance_ == null
            ? com.google.spanner.admin.instance.v1.Instance.getDefaultInstance()
            : instance_;
      } else {
        return instanceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Instance returned by GetCloudInstanceAction
     * </pre>
     *
     * <code>.google.spanner.admin.instance.v1.Instance instance = 3;</code>
     */
    public Builder setInstance(com.google.spanner.admin.instance.v1.Instance value) {
      if (instanceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        instance_ = value;
      } else {
        instanceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instance returned by GetCloudInstanceAction
     * </pre>
     *
     * <code>.google.spanner.admin.instance.v1.Instance instance = 3;</code>
     */
    public Builder setInstance(
        com.google.spanner.admin.instance.v1.Instance.Builder builderForValue) {
      if (instanceBuilder_ == null) {
        instance_ = builderForValue.build();
      } else {
        instanceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instance returned by GetCloudInstanceAction
     * </pre>
     *
     * <code>.google.spanner.admin.instance.v1.Instance instance = 3;</code>
     */
    public Builder mergeInstance(com.google.spanner.admin.instance.v1.Instance value) {
      if (instanceBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && instance_ != null
            && instance_ != com.google.spanner.admin.instance.v1.Instance.getDefaultInstance()) {
          getInstanceBuilder().mergeFrom(value);
        } else {
          instance_ = value;
        }
      } else {
        instanceBuilder_.mergeFrom(value);
      }
      if (instance_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instance returned by GetCloudInstanceAction
     * </pre>
     *
     * <code>.google.spanner.admin.instance.v1.Instance instance = 3;</code>
     */
    public Builder clearInstance() {
      bitField0_ = (bitField0_ & ~0x00000004);
      instance_ = null;
      if (instanceBuilder_ != null) {
        instanceBuilder_.dispose();
        instanceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instance returned by GetCloudInstanceAction
     * </pre>
     *
     * <code>.google.spanner.admin.instance.v1.Instance instance = 3;</code>
     */
    public com.google.spanner.admin.instance.v1.Instance.Builder getInstanceBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getInstanceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Instance returned by GetCloudInstanceAction
     * </pre>
     *
     * <code>.google.spanner.admin.instance.v1.Instance instance = 3;</code>
     */
    public com.google.spanner.admin.instance.v1.InstanceOrBuilder getInstanceOrBuilder() {
      if (instanceBuilder_ != null) {
        return instanceBuilder_.getMessageOrBuilder();
      } else {
        return instance_ == null
            ? com.google.spanner.admin.instance.v1.Instance.getDefaultInstance()
            : instance_;
      }
    }
    /**
     *
     *
     * <pre>
     * Instance returned by GetCloudInstanceAction
     * </pre>
     *
     * <code>.google.spanner.admin.instance.v1.Instance instance = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.instance.v1.Instance,
            com.google.spanner.admin.instance.v1.Instance.Builder,
            com.google.spanner.admin.instance.v1.InstanceOrBuilder>
        getInstanceFieldBuilder() {
      if (instanceBuilder_ == null) {
        instanceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.admin.instance.v1.Instance,
                com.google.spanner.admin.instance.v1.Instance.Builder,
                com.google.spanner.admin.instance.v1.InstanceOrBuilder>(
                getInstance(), getParentForChildren(), isClean());
        instance_ = null;
      }
      return instanceBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.executor.v1.CloudInstanceResponse)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.executor.v1.CloudInstanceResponse)
  private static final com.google.spanner.executor.v1.CloudInstanceResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.executor.v1.CloudInstanceResponse();
  }

  public static com.google.spanner.executor.v1.CloudInstanceResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CloudInstanceResponse> PARSER =
      new com.google.protobuf.AbstractParser<CloudInstanceResponse>() {
        @java.lang.Override
        public CloudInstanceResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CloudInstanceResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CloudInstanceResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.executor.v1.CloudInstanceResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
