/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/executor/v1/cloud_executor.proto

// Protobuf Java Version: 3.25.3
package com.google.spanner.executor.v1;

/**
 *
 *
 * <pre>
 * Concurrency for read-only transactions.
 * </pre>
 *
 * Protobuf type {@code google.spanner.executor.v1.Concurrency}
 */
public final class Concurrency extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.executor.v1.Concurrency)
    ConcurrencyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Concurrency.newBuilder() to construct.
  private Concurrency(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Concurrency() {
    snapshotEpochRootTable_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Concurrency();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_Concurrency_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_Concurrency_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.executor.v1.Concurrency.class,
            com.google.spanner.executor.v1.Concurrency.Builder.class);
  }

  private int concurrencyModeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object concurrencyMode_;

  public enum ConcurrencyModeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    STALENESS_SECONDS(1),
    MIN_READ_TIMESTAMP_MICROS(2),
    MAX_STALENESS_SECONDS(3),
    EXACT_TIMESTAMP_MICROS(4),
    STRONG(5),
    BATCH(6),
    CONCURRENCYMODE_NOT_SET(0);
    private final int value;

    private ConcurrencyModeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConcurrencyModeCase valueOf(int value) {
      return forNumber(value);
    }

    public static ConcurrencyModeCase forNumber(int value) {
      switch (value) {
        case 1:
          return STALENESS_SECONDS;
        case 2:
          return MIN_READ_TIMESTAMP_MICROS;
        case 3:
          return MAX_STALENESS_SECONDS;
        case 4:
          return EXACT_TIMESTAMP_MICROS;
        case 5:
          return STRONG;
        case 6:
          return BATCH;
        case 0:
          return CONCURRENCYMODE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ConcurrencyModeCase getConcurrencyModeCase() {
    return ConcurrencyModeCase.forNumber(concurrencyModeCase_);
  }

  public static final int STALENESS_SECONDS_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Indicates a read at a consistent timestamp that is specified relative to
   * now. That is, if the caller has specified an exact staleness of s
   * seconds, we will read at now - s.
   * </pre>
   *
   * <code>double staleness_seconds = 1;</code>
   *
   * @return Whether the stalenessSeconds field is set.
   */
  @java.lang.Override
  public boolean hasStalenessSeconds() {
    return concurrencyModeCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Indicates a read at a consistent timestamp that is specified relative to
   * now. That is, if the caller has specified an exact staleness of s
   * seconds, we will read at now - s.
   * </pre>
   *
   * <code>double staleness_seconds = 1;</code>
   *
   * @return The stalenessSeconds.
   */
  @java.lang.Override
  public double getStalenessSeconds() {
    if (concurrencyModeCase_ == 1) {
      return (java.lang.Double) concurrencyMode_;
    }
    return 0D;
  }

  public static final int MIN_READ_TIMESTAMP_MICROS_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Indicates a boundedly stale read that reads at a timestamp &gt;= T.
   * </pre>
   *
   * <code>int64 min_read_timestamp_micros = 2;</code>
   *
   * @return Whether the minReadTimestampMicros field is set.
   */
  @java.lang.Override
  public boolean hasMinReadTimestampMicros() {
    return concurrencyModeCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Indicates a boundedly stale read that reads at a timestamp &gt;= T.
   * </pre>
   *
   * <code>int64 min_read_timestamp_micros = 2;</code>
   *
   * @return The minReadTimestampMicros.
   */
  @java.lang.Override
  public long getMinReadTimestampMicros() {
    if (concurrencyModeCase_ == 2) {
      return (java.lang.Long) concurrencyMode_;
    }
    return 0L;
  }

  public static final int MAX_STALENESS_SECONDS_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Indicates a boundedly stale read that is at most N seconds stale.
   * </pre>
   *
   * <code>double max_staleness_seconds = 3;</code>
   *
   * @return Whether the maxStalenessSeconds field is set.
   */
  @java.lang.Override
  public boolean hasMaxStalenessSeconds() {
    return concurrencyModeCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Indicates a boundedly stale read that is at most N seconds stale.
   * </pre>
   *
   * <code>double max_staleness_seconds = 3;</code>
   *
   * @return The maxStalenessSeconds.
   */
  @java.lang.Override
  public double getMaxStalenessSeconds() {
    if (concurrencyModeCase_ == 3) {
      return (java.lang.Double) concurrencyMode_;
    }
    return 0D;
  }

  public static final int EXACT_TIMESTAMP_MICROS_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Indicates a read at a consistent timestamp.
   * </pre>
   *
   * <code>int64 exact_timestamp_micros = 4;</code>
   *
   * @return Whether the exactTimestampMicros field is set.
   */
  @java.lang.Override
  public boolean hasExactTimestampMicros() {
    return concurrencyModeCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Indicates a read at a consistent timestamp.
   * </pre>
   *
   * <code>int64 exact_timestamp_micros = 4;</code>
   *
   * @return The exactTimestampMicros.
   */
  @java.lang.Override
  public long getExactTimestampMicros() {
    if (concurrencyModeCase_ == 4) {
      return (java.lang.Long) concurrencyMode_;
    }
    return 0L;
  }

  public static final int STRONG_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Indicates a strong read, must only be set to true, or unset.
   * </pre>
   *
   * <code>bool strong = 5;</code>
   *
   * @return Whether the strong field is set.
   */
  @java.lang.Override
  public boolean hasStrong() {
    return concurrencyModeCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Indicates a strong read, must only be set to true, or unset.
   * </pre>
   *
   * <code>bool strong = 5;</code>
   *
   * @return The strong.
   */
  @java.lang.Override
  public boolean getStrong() {
    if (concurrencyModeCase_ == 5) {
      return (java.lang.Boolean) concurrencyMode_;
    }
    return false;
  }

  public static final int BATCH_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Indicates a batch read, must only be set to true, or unset.
   * </pre>
   *
   * <code>bool batch = 6;</code>
   *
   * @return Whether the batch field is set.
   */
  @java.lang.Override
  public boolean hasBatch() {
    return concurrencyModeCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Indicates a batch read, must only be set to true, or unset.
   * </pre>
   *
   * <code>bool batch = 6;</code>
   *
   * @return The batch.
   */
  @java.lang.Override
  public boolean getBatch() {
    if (concurrencyModeCase_ == 6) {
      return (java.lang.Boolean) concurrencyMode_;
    }
    return false;
  }

  public static final int SNAPSHOT_EPOCH_READ_FIELD_NUMBER = 7;
  private boolean snapshotEpochRead_ = false;
  /**
   *
   *
   * <pre>
   * True if exact_timestamp_micros is set, and the chosen timestamp is that of
   * a snapshot epoch.
   * </pre>
   *
   * <code>bool snapshot_epoch_read = 7;</code>
   *
   * @return The snapshotEpochRead.
   */
  @java.lang.Override
  public boolean getSnapshotEpochRead() {
    return snapshotEpochRead_;
  }

  public static final int SNAPSHOT_EPOCH_ROOT_TABLE_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object snapshotEpochRootTable_ = "";
  /**
   *
   *
   * <pre>
   * If set, this is a snapshot epoch read constrained to read only the
   * specified log scope root table, and its children. Will not be set for full
   * database epochs.
   * </pre>
   *
   * <code>string snapshot_epoch_root_table = 8;</code>
   *
   * @return The snapshotEpochRootTable.
   */
  @java.lang.Override
  public java.lang.String getSnapshotEpochRootTable() {
    java.lang.Object ref = snapshotEpochRootTable_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      snapshotEpochRootTable_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If set, this is a snapshot epoch read constrained to read only the
   * specified log scope root table, and its children. Will not be set for full
   * database epochs.
   * </pre>
   *
   * <code>string snapshot_epoch_root_table = 8;</code>
   *
   * @return The bytes for snapshotEpochRootTable.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSnapshotEpochRootTableBytes() {
    java.lang.Object ref = snapshotEpochRootTable_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      snapshotEpochRootTable_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BATCH_READ_TIMESTAMP_MICROS_FIELD_NUMBER = 9;
  private long batchReadTimestampMicros_ = 0L;
  /**
   *
   *
   * <pre>
   * Set only when batch is true.
   * </pre>
   *
   * <code>int64 batch_read_timestamp_micros = 9;</code>
   *
   * @return The batchReadTimestampMicros.
   */
  @java.lang.Override
  public long getBatchReadTimestampMicros() {
    return batchReadTimestampMicros_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (concurrencyModeCase_ == 1) {
      output.writeDouble(1, (double) ((java.lang.Double) concurrencyMode_));
    }
    if (concurrencyModeCase_ == 2) {
      output.writeInt64(2, (long) ((java.lang.Long) concurrencyMode_));
    }
    if (concurrencyModeCase_ == 3) {
      output.writeDouble(3, (double) ((java.lang.Double) concurrencyMode_));
    }
    if (concurrencyModeCase_ == 4) {
      output.writeInt64(4, (long) ((java.lang.Long) concurrencyMode_));
    }
    if (concurrencyModeCase_ == 5) {
      output.writeBool(5, (boolean) ((java.lang.Boolean) concurrencyMode_));
    }
    if (concurrencyModeCase_ == 6) {
      output.writeBool(6, (boolean) ((java.lang.Boolean) concurrencyMode_));
    }
    if (snapshotEpochRead_ != false) {
      output.writeBool(7, snapshotEpochRead_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(snapshotEpochRootTable_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, snapshotEpochRootTable_);
    }
    if (batchReadTimestampMicros_ != 0L) {
      output.writeInt64(9, batchReadTimestampMicros_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (concurrencyModeCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeDoubleSize(
              1, (double) ((java.lang.Double) concurrencyMode_));
    }
    if (concurrencyModeCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(
              2, (long) ((java.lang.Long) concurrencyMode_));
    }
    if (concurrencyModeCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeDoubleSize(
              3, (double) ((java.lang.Double) concurrencyMode_));
    }
    if (concurrencyModeCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(
              4, (long) ((java.lang.Long) concurrencyMode_));
    }
    if (concurrencyModeCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              5, (boolean) ((java.lang.Boolean) concurrencyMode_));
    }
    if (concurrencyModeCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              6, (boolean) ((java.lang.Boolean) concurrencyMode_));
    }
    if (snapshotEpochRead_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, snapshotEpochRead_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(snapshotEpochRootTable_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, snapshotEpochRootTable_);
    }
    if (batchReadTimestampMicros_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(9, batchReadTimestampMicros_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.executor.v1.Concurrency)) {
      return super.equals(obj);
    }
    com.google.spanner.executor.v1.Concurrency other =
        (com.google.spanner.executor.v1.Concurrency) obj;

    if (getSnapshotEpochRead() != other.getSnapshotEpochRead()) return false;
    if (!getSnapshotEpochRootTable().equals(other.getSnapshotEpochRootTable())) return false;
    if (getBatchReadTimestampMicros() != other.getBatchReadTimestampMicros()) return false;
    if (!getConcurrencyModeCase().equals(other.getConcurrencyModeCase())) return false;
    switch (concurrencyModeCase_) {
      case 1:
        if (java.lang.Double.doubleToLongBits(getStalenessSeconds())
            != java.lang.Double.doubleToLongBits(other.getStalenessSeconds())) return false;
        break;
      case 2:
        if (getMinReadTimestampMicros() != other.getMinReadTimestampMicros()) return false;
        break;
      case 3:
        if (java.lang.Double.doubleToLongBits(getMaxStalenessSeconds())
            != java.lang.Double.doubleToLongBits(other.getMaxStalenessSeconds())) return false;
        break;
      case 4:
        if (getExactTimestampMicros() != other.getExactTimestampMicros()) return false;
        break;
      case 5:
        if (getStrong() != other.getStrong()) return false;
        break;
      case 6:
        if (getBatch() != other.getBatch()) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SNAPSHOT_EPOCH_READ_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSnapshotEpochRead());
    hash = (37 * hash) + SNAPSHOT_EPOCH_ROOT_TABLE_FIELD_NUMBER;
    hash = (53 * hash) + getSnapshotEpochRootTable().hashCode();
    hash = (37 * hash) + BATCH_READ_TIMESTAMP_MICROS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getBatchReadTimestampMicros());
    switch (concurrencyModeCase_) {
      case 1:
        hash = (37 * hash) + STALENESS_SECONDS_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getStalenessSeconds()));
        break;
      case 2:
        hash = (37 * hash) + MIN_READ_TIMESTAMP_MICROS_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMinReadTimestampMicros());
        break;
      case 3:
        hash = (37 * hash) + MAX_STALENESS_SECONDS_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getMaxStalenessSeconds()));
        break;
      case 4:
        hash = (37 * hash) + EXACT_TIMESTAMP_MICROS_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getExactTimestampMicros());
        break;
      case 5:
        hash = (37 * hash) + STRONG_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getStrong());
        break;
      case 6:
        hash = (37 * hash) + BATCH_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getBatch());
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.executor.v1.Concurrency parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.Concurrency parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.Concurrency parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.Concurrency parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.Concurrency parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.Concurrency parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.Concurrency parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.Concurrency parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.Concurrency parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.Concurrency parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.Concurrency parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.Concurrency parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.executor.v1.Concurrency prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Concurrency for read-only transactions.
   * </pre>
   *
   * Protobuf type {@code google.spanner.executor.v1.Concurrency}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.executor.v1.Concurrency)
      com.google.spanner.executor.v1.ConcurrencyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_Concurrency_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_Concurrency_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.executor.v1.Concurrency.class,
              com.google.spanner.executor.v1.Concurrency.Builder.class);
    }

    // Construct using com.google.spanner.executor.v1.Concurrency.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      snapshotEpochRead_ = false;
      snapshotEpochRootTable_ = "";
      batchReadTimestampMicros_ = 0L;
      concurrencyModeCase_ = 0;
      concurrencyMode_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_Concurrency_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.Concurrency getDefaultInstanceForType() {
      return com.google.spanner.executor.v1.Concurrency.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.Concurrency build() {
      com.google.spanner.executor.v1.Concurrency result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.Concurrency buildPartial() {
      com.google.spanner.executor.v1.Concurrency result =
          new com.google.spanner.executor.v1.Concurrency(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.executor.v1.Concurrency result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.snapshotEpochRead_ = snapshotEpochRead_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.snapshotEpochRootTable_ = snapshotEpochRootTable_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.batchReadTimestampMicros_ = batchReadTimestampMicros_;
      }
    }

    private void buildPartialOneofs(com.google.spanner.executor.v1.Concurrency result) {
      result.concurrencyModeCase_ = concurrencyModeCase_;
      result.concurrencyMode_ = this.concurrencyMode_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.executor.v1.Concurrency) {
        return mergeFrom((com.google.spanner.executor.v1.Concurrency) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.executor.v1.Concurrency other) {
      if (other == com.google.spanner.executor.v1.Concurrency.getDefaultInstance()) return this;
      if (other.getSnapshotEpochRead() != false) {
        setSnapshotEpochRead(other.getSnapshotEpochRead());
      }
      if (!other.getSnapshotEpochRootTable().isEmpty()) {
        snapshotEpochRootTable_ = other.snapshotEpochRootTable_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.getBatchReadTimestampMicros() != 0L) {
        setBatchReadTimestampMicros(other.getBatchReadTimestampMicros());
      }
      switch (other.getConcurrencyModeCase()) {
        case STALENESS_SECONDS:
          {
            setStalenessSeconds(other.getStalenessSeconds());
            break;
          }
        case MIN_READ_TIMESTAMP_MICROS:
          {
            setMinReadTimestampMicros(other.getMinReadTimestampMicros());
            break;
          }
        case MAX_STALENESS_SECONDS:
          {
            setMaxStalenessSeconds(other.getMaxStalenessSeconds());
            break;
          }
        case EXACT_TIMESTAMP_MICROS:
          {
            setExactTimestampMicros(other.getExactTimestampMicros());
            break;
          }
        case STRONG:
          {
            setStrong(other.getStrong());
            break;
          }
        case BATCH:
          {
            setBatch(other.getBatch());
            break;
          }
        case CONCURRENCYMODE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 9:
              {
                concurrencyMode_ = input.readDouble();
                concurrencyModeCase_ = 1;
                break;
              } // case 9
            case 16:
              {
                concurrencyMode_ = input.readInt64();
                concurrencyModeCase_ = 2;
                break;
              } // case 16
            case 25:
              {
                concurrencyMode_ = input.readDouble();
                concurrencyModeCase_ = 3;
                break;
              } // case 25
            case 32:
              {
                concurrencyMode_ = input.readInt64();
                concurrencyModeCase_ = 4;
                break;
              } // case 32
            case 40:
              {
                concurrencyMode_ = input.readBool();
                concurrencyModeCase_ = 5;
                break;
              } // case 40
            case 48:
              {
                concurrencyMode_ = input.readBool();
                concurrencyModeCase_ = 6;
                break;
              } // case 48
            case 56:
              {
                snapshotEpochRead_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 66:
              {
                snapshotEpochRootTable_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 72:
              {
                batchReadTimestampMicros_ = input.readInt64();
                bitField0_ |= 0x00000100;
                break;
              } // case 72
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int concurrencyModeCase_ = 0;
    private java.lang.Object concurrencyMode_;

    public ConcurrencyModeCase getConcurrencyModeCase() {
      return ConcurrencyModeCase.forNumber(concurrencyModeCase_);
    }

    public Builder clearConcurrencyMode() {
      concurrencyModeCase_ = 0;
      concurrencyMode_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * Indicates a read at a consistent timestamp that is specified relative to
     * now. That is, if the caller has specified an exact staleness of s
     * seconds, we will read at now - s.
     * </pre>
     *
     * <code>double staleness_seconds = 1;</code>
     *
     * @return Whether the stalenessSeconds field is set.
     */
    public boolean hasStalenessSeconds() {
      return concurrencyModeCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Indicates a read at a consistent timestamp that is specified relative to
     * now. That is, if the caller has specified an exact staleness of s
     * seconds, we will read at now - s.
     * </pre>
     *
     * <code>double staleness_seconds = 1;</code>
     *
     * @return The stalenessSeconds.
     */
    public double getStalenessSeconds() {
      if (concurrencyModeCase_ == 1) {
        return (java.lang.Double) concurrencyMode_;
      }
      return 0D;
    }
    /**
     *
     *
     * <pre>
     * Indicates a read at a consistent timestamp that is specified relative to
     * now. That is, if the caller has specified an exact staleness of s
     * seconds, we will read at now - s.
     * </pre>
     *
     * <code>double staleness_seconds = 1;</code>
     *
     * @param value The stalenessSeconds to set.
     * @return This builder for chaining.
     */
    public Builder setStalenessSeconds(double value) {

      concurrencyModeCase_ = 1;
      concurrencyMode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates a read at a consistent timestamp that is specified relative to
     * now. That is, if the caller has specified an exact staleness of s
     * seconds, we will read at now - s.
     * </pre>
     *
     * <code>double staleness_seconds = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStalenessSeconds() {
      if (concurrencyModeCase_ == 1) {
        concurrencyModeCase_ = 0;
        concurrencyMode_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Indicates a boundedly stale read that reads at a timestamp &gt;= T.
     * </pre>
     *
     * <code>int64 min_read_timestamp_micros = 2;</code>
     *
     * @return Whether the minReadTimestampMicros field is set.
     */
    public boolean hasMinReadTimestampMicros() {
      return concurrencyModeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Indicates a boundedly stale read that reads at a timestamp &gt;= T.
     * </pre>
     *
     * <code>int64 min_read_timestamp_micros = 2;</code>
     *
     * @return The minReadTimestampMicros.
     */
    public long getMinReadTimestampMicros() {
      if (concurrencyModeCase_ == 2) {
        return (java.lang.Long) concurrencyMode_;
      }
      return 0L;
    }
    /**
     *
     *
     * <pre>
     * Indicates a boundedly stale read that reads at a timestamp &gt;= T.
     * </pre>
     *
     * <code>int64 min_read_timestamp_micros = 2;</code>
     *
     * @param value The minReadTimestampMicros to set.
     * @return This builder for chaining.
     */
    public Builder setMinReadTimestampMicros(long value) {

      concurrencyModeCase_ = 2;
      concurrencyMode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates a boundedly stale read that reads at a timestamp &gt;= T.
     * </pre>
     *
     * <code>int64 min_read_timestamp_micros = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinReadTimestampMicros() {
      if (concurrencyModeCase_ == 2) {
        concurrencyModeCase_ = 0;
        concurrencyMode_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Indicates a boundedly stale read that is at most N seconds stale.
     * </pre>
     *
     * <code>double max_staleness_seconds = 3;</code>
     *
     * @return Whether the maxStalenessSeconds field is set.
     */
    public boolean hasMaxStalenessSeconds() {
      return concurrencyModeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Indicates a boundedly stale read that is at most N seconds stale.
     * </pre>
     *
     * <code>double max_staleness_seconds = 3;</code>
     *
     * @return The maxStalenessSeconds.
     */
    public double getMaxStalenessSeconds() {
      if (concurrencyModeCase_ == 3) {
        return (java.lang.Double) concurrencyMode_;
      }
      return 0D;
    }
    /**
     *
     *
     * <pre>
     * Indicates a boundedly stale read that is at most N seconds stale.
     * </pre>
     *
     * <code>double max_staleness_seconds = 3;</code>
     *
     * @param value The maxStalenessSeconds to set.
     * @return This builder for chaining.
     */
    public Builder setMaxStalenessSeconds(double value) {

      concurrencyModeCase_ = 3;
      concurrencyMode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates a boundedly stale read that is at most N seconds stale.
     * </pre>
     *
     * <code>double max_staleness_seconds = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxStalenessSeconds() {
      if (concurrencyModeCase_ == 3) {
        concurrencyModeCase_ = 0;
        concurrencyMode_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Indicates a read at a consistent timestamp.
     * </pre>
     *
     * <code>int64 exact_timestamp_micros = 4;</code>
     *
     * @return Whether the exactTimestampMicros field is set.
     */
    public boolean hasExactTimestampMicros() {
      return concurrencyModeCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Indicates a read at a consistent timestamp.
     * </pre>
     *
     * <code>int64 exact_timestamp_micros = 4;</code>
     *
     * @return The exactTimestampMicros.
     */
    public long getExactTimestampMicros() {
      if (concurrencyModeCase_ == 4) {
        return (java.lang.Long) concurrencyMode_;
      }
      return 0L;
    }
    /**
     *
     *
     * <pre>
     * Indicates a read at a consistent timestamp.
     * </pre>
     *
     * <code>int64 exact_timestamp_micros = 4;</code>
     *
     * @param value The exactTimestampMicros to set.
     * @return This builder for chaining.
     */
    public Builder setExactTimestampMicros(long value) {

      concurrencyModeCase_ = 4;
      concurrencyMode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates a read at a consistent timestamp.
     * </pre>
     *
     * <code>int64 exact_timestamp_micros = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExactTimestampMicros() {
      if (concurrencyModeCase_ == 4) {
        concurrencyModeCase_ = 0;
        concurrencyMode_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Indicates a strong read, must only be set to true, or unset.
     * </pre>
     *
     * <code>bool strong = 5;</code>
     *
     * @return Whether the strong field is set.
     */
    public boolean hasStrong() {
      return concurrencyModeCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Indicates a strong read, must only be set to true, or unset.
     * </pre>
     *
     * <code>bool strong = 5;</code>
     *
     * @return The strong.
     */
    public boolean getStrong() {
      if (concurrencyModeCase_ == 5) {
        return (java.lang.Boolean) concurrencyMode_;
      }
      return false;
    }
    /**
     *
     *
     * <pre>
     * Indicates a strong read, must only be set to true, or unset.
     * </pre>
     *
     * <code>bool strong = 5;</code>
     *
     * @param value The strong to set.
     * @return This builder for chaining.
     */
    public Builder setStrong(boolean value) {

      concurrencyModeCase_ = 5;
      concurrencyMode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates a strong read, must only be set to true, or unset.
     * </pre>
     *
     * <code>bool strong = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStrong() {
      if (concurrencyModeCase_ == 5) {
        concurrencyModeCase_ = 0;
        concurrencyMode_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Indicates a batch read, must only be set to true, or unset.
     * </pre>
     *
     * <code>bool batch = 6;</code>
     *
     * @return Whether the batch field is set.
     */
    public boolean hasBatch() {
      return concurrencyModeCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Indicates a batch read, must only be set to true, or unset.
     * </pre>
     *
     * <code>bool batch = 6;</code>
     *
     * @return The batch.
     */
    public boolean getBatch() {
      if (concurrencyModeCase_ == 6) {
        return (java.lang.Boolean) concurrencyMode_;
      }
      return false;
    }
    /**
     *
     *
     * <pre>
     * Indicates a batch read, must only be set to true, or unset.
     * </pre>
     *
     * <code>bool batch = 6;</code>
     *
     * @param value The batch to set.
     * @return This builder for chaining.
     */
    public Builder setBatch(boolean value) {

      concurrencyModeCase_ = 6;
      concurrencyMode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates a batch read, must only be set to true, or unset.
     * </pre>
     *
     * <code>bool batch = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBatch() {
      if (concurrencyModeCase_ == 6) {
        concurrencyModeCase_ = 0;
        concurrencyMode_ = null;
        onChanged();
      }
      return this;
    }

    private boolean snapshotEpochRead_;
    /**
     *
     *
     * <pre>
     * True if exact_timestamp_micros is set, and the chosen timestamp is that of
     * a snapshot epoch.
     * </pre>
     *
     * <code>bool snapshot_epoch_read = 7;</code>
     *
     * @return The snapshotEpochRead.
     */
    @java.lang.Override
    public boolean getSnapshotEpochRead() {
      return snapshotEpochRead_;
    }
    /**
     *
     *
     * <pre>
     * True if exact_timestamp_micros is set, and the chosen timestamp is that of
     * a snapshot epoch.
     * </pre>
     *
     * <code>bool snapshot_epoch_read = 7;</code>
     *
     * @param value The snapshotEpochRead to set.
     * @return This builder for chaining.
     */
    public Builder setSnapshotEpochRead(boolean value) {

      snapshotEpochRead_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * True if exact_timestamp_micros is set, and the chosen timestamp is that of
     * a snapshot epoch.
     * </pre>
     *
     * <code>bool snapshot_epoch_read = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSnapshotEpochRead() {
      bitField0_ = (bitField0_ & ~0x00000040);
      snapshotEpochRead_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object snapshotEpochRootTable_ = "";
    /**
     *
     *
     * <pre>
     * If set, this is a snapshot epoch read constrained to read only the
     * specified log scope root table, and its children. Will not be set for full
     * database epochs.
     * </pre>
     *
     * <code>string snapshot_epoch_root_table = 8;</code>
     *
     * @return The snapshotEpochRootTable.
     */
    public java.lang.String getSnapshotEpochRootTable() {
      java.lang.Object ref = snapshotEpochRootTable_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        snapshotEpochRootTable_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If set, this is a snapshot epoch read constrained to read only the
     * specified log scope root table, and its children. Will not be set for full
     * database epochs.
     * </pre>
     *
     * <code>string snapshot_epoch_root_table = 8;</code>
     *
     * @return The bytes for snapshotEpochRootTable.
     */
    public com.google.protobuf.ByteString getSnapshotEpochRootTableBytes() {
      java.lang.Object ref = snapshotEpochRootTable_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        snapshotEpochRootTable_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If set, this is a snapshot epoch read constrained to read only the
     * specified log scope root table, and its children. Will not be set for full
     * database epochs.
     * </pre>
     *
     * <code>string snapshot_epoch_root_table = 8;</code>
     *
     * @param value The snapshotEpochRootTable to set.
     * @return This builder for chaining.
     */
    public Builder setSnapshotEpochRootTable(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      snapshotEpochRootTable_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, this is a snapshot epoch read constrained to read only the
     * specified log scope root table, and its children. Will not be set for full
     * database epochs.
     * </pre>
     *
     * <code>string snapshot_epoch_root_table = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSnapshotEpochRootTable() {
      snapshotEpochRootTable_ = getDefaultInstance().getSnapshotEpochRootTable();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, this is a snapshot epoch read constrained to read only the
     * specified log scope root table, and its children. Will not be set for full
     * database epochs.
     * </pre>
     *
     * <code>string snapshot_epoch_root_table = 8;</code>
     *
     * @param value The bytes for snapshotEpochRootTable to set.
     * @return This builder for chaining.
     */
    public Builder setSnapshotEpochRootTableBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      snapshotEpochRootTable_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private long batchReadTimestampMicros_;
    /**
     *
     *
     * <pre>
     * Set only when batch is true.
     * </pre>
     *
     * <code>int64 batch_read_timestamp_micros = 9;</code>
     *
     * @return The batchReadTimestampMicros.
     */
    @java.lang.Override
    public long getBatchReadTimestampMicros() {
      return batchReadTimestampMicros_;
    }
    /**
     *
     *
     * <pre>
     * Set only when batch is true.
     * </pre>
     *
     * <code>int64 batch_read_timestamp_micros = 9;</code>
     *
     * @param value The batchReadTimestampMicros to set.
     * @return This builder for chaining.
     */
    public Builder setBatchReadTimestampMicros(long value) {

      batchReadTimestampMicros_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set only when batch is true.
     * </pre>
     *
     * <code>int64 batch_read_timestamp_micros = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBatchReadTimestampMicros() {
      bitField0_ = (bitField0_ & ~0x00000100);
      batchReadTimestampMicros_ = 0L;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.executor.v1.Concurrency)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.executor.v1.Concurrency)
  private static final com.google.spanner.executor.v1.Concurrency DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.executor.v1.Concurrency();
  }

  public static com.google.spanner.executor.v1.Concurrency getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Concurrency> PARSER =
      new com.google.protobuf.AbstractParser<Concurrency>() {
        @java.lang.Override
        public Concurrency parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Concurrency> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Concurrency> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.executor.v1.Concurrency getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
