/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/executor/v1/cloud_executor.proto

// Protobuf Java Version: 3.25.3
package com.google.spanner.executor.v1;

/**
 *
 *
 * <pre>
 * Action that creates a user instance config.
 * </pre>
 *
 * Protobuf type {@code google.spanner.executor.v1.CreateUserInstanceConfigAction}
 */
public final class CreateUserInstanceConfigAction extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.executor.v1.CreateUserInstanceConfigAction)
    CreateUserInstanceConfigActionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CreateUserInstanceConfigAction.newBuilder() to construct.
  private CreateUserInstanceConfigAction(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CreateUserInstanceConfigAction() {
    userConfigId_ = "";
    projectId_ = "";
    baseConfigId_ = "";
    replicas_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CreateUserInstanceConfigAction();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_CreateUserInstanceConfigAction_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_CreateUserInstanceConfigAction_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.executor.v1.CreateUserInstanceConfigAction.class,
            com.google.spanner.executor.v1.CreateUserInstanceConfigAction.Builder.class);
  }

  public static final int USER_CONFIG_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object userConfigId_ = "";
  /**
   *
   *
   * <pre>
   * User instance config ID (not path), e.g. "custom-config".
   * </pre>
   *
   * <code>string user_config_id = 1;</code>
   *
   * @return The userConfigId.
   */
  @java.lang.Override
  public java.lang.String getUserConfigId() {
    java.lang.Object ref = userConfigId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      userConfigId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * User instance config ID (not path), e.g. "custom-config".
   * </pre>
   *
   * <code>string user_config_id = 1;</code>
   *
   * @return The bytes for userConfigId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUserConfigIdBytes() {
    java.lang.Object ref = userConfigId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      userConfigId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROJECT_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object projectId_ = "";
  /**
   *
   *
   * <pre>
   * Cloud project ID, e.g. "spanner-cloud-systest".
   * </pre>
   *
   * <code>string project_id = 2;</code>
   *
   * @return The projectId.
   */
  @java.lang.Override
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Cloud project ID, e.g. "spanner-cloud-systest".
   * </pre>
   *
   * <code>string project_id = 2;</code>
   *
   * @return The bytes for projectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BASE_CONFIG_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object baseConfigId_ = "";
  /**
   *
   *
   * <pre>
   * Base config ID, e.g. "test-config".
   * </pre>
   *
   * <code>string base_config_id = 3;</code>
   *
   * @return The baseConfigId.
   */
  @java.lang.Override
  public java.lang.String getBaseConfigId() {
    java.lang.Object ref = baseConfigId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      baseConfigId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Base config ID, e.g. "test-config".
   * </pre>
   *
   * <code>string base_config_id = 3;</code>
   *
   * @return The bytes for baseConfigId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBaseConfigIdBytes() {
    java.lang.Object ref = baseConfigId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      baseConfigId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REPLICAS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.spanner.admin.instance.v1.ReplicaInfo> replicas_;
  /**
   *
   *
   * <pre>
   * Replicas that should be included in the user config.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.spanner.admin.instance.v1.ReplicaInfo> getReplicasList() {
    return replicas_;
  }
  /**
   *
   *
   * <pre>
   * Replicas that should be included in the user config.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.spanner.admin.instance.v1.ReplicaInfoOrBuilder>
      getReplicasOrBuilderList() {
    return replicas_;
  }
  /**
   *
   *
   * <pre>
   * Replicas that should be included in the user config.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 4;</code>
   */
  @java.lang.Override
  public int getReplicasCount() {
    return replicas_.size();
  }
  /**
   *
   *
   * <pre>
   * Replicas that should be included in the user config.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 4;</code>
   */
  @java.lang.Override
  public com.google.spanner.admin.instance.v1.ReplicaInfo getReplicas(int index) {
    return replicas_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Replicas that should be included in the user config.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 4;</code>
   */
  @java.lang.Override
  public com.google.spanner.admin.instance.v1.ReplicaInfoOrBuilder getReplicasOrBuilder(int index) {
    return replicas_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userConfigId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, userConfigId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(baseConfigId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, baseConfigId_);
    }
    for (int i = 0; i < replicas_.size(); i++) {
      output.writeMessage(4, replicas_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userConfigId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, userConfigId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(baseConfigId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, baseConfigId_);
    }
    for (int i = 0; i < replicas_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, replicas_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.executor.v1.CreateUserInstanceConfigAction)) {
      return super.equals(obj);
    }
    com.google.spanner.executor.v1.CreateUserInstanceConfigAction other =
        (com.google.spanner.executor.v1.CreateUserInstanceConfigAction) obj;

    if (!getUserConfigId().equals(other.getUserConfigId())) return false;
    if (!getProjectId().equals(other.getProjectId())) return false;
    if (!getBaseConfigId().equals(other.getBaseConfigId())) return false;
    if (!getReplicasList().equals(other.getReplicasList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + USER_CONFIG_ID_FIELD_NUMBER;
    hash = (53 * hash) + getUserConfigId().hashCode();
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    hash = (37 * hash) + BASE_CONFIG_ID_FIELD_NUMBER;
    hash = (53 * hash) + getBaseConfigId().hashCode();
    if (getReplicasCount() > 0) {
      hash = (37 * hash) + REPLICAS_FIELD_NUMBER;
      hash = (53 * hash) + getReplicasList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.executor.v1.CreateUserInstanceConfigAction parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.CreateUserInstanceConfigAction parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.CreateUserInstanceConfigAction parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.CreateUserInstanceConfigAction parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.CreateUserInstanceConfigAction parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.CreateUserInstanceConfigAction parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.CreateUserInstanceConfigAction parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.CreateUserInstanceConfigAction parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.CreateUserInstanceConfigAction parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.CreateUserInstanceConfigAction parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.CreateUserInstanceConfigAction parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.CreateUserInstanceConfigAction parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.spanner.executor.v1.CreateUserInstanceConfigAction prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Action that creates a user instance config.
   * </pre>
   *
   * Protobuf type {@code google.spanner.executor.v1.CreateUserInstanceConfigAction}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.executor.v1.CreateUserInstanceConfigAction)
      com.google.spanner.executor.v1.CreateUserInstanceConfigActionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_CreateUserInstanceConfigAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_CreateUserInstanceConfigAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.executor.v1.CreateUserInstanceConfigAction.class,
              com.google.spanner.executor.v1.CreateUserInstanceConfigAction.Builder.class);
    }

    // Construct using com.google.spanner.executor.v1.CreateUserInstanceConfigAction.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      userConfigId_ = "";
      projectId_ = "";
      baseConfigId_ = "";
      if (replicasBuilder_ == null) {
        replicas_ = java.util.Collections.emptyList();
      } else {
        replicas_ = null;
        replicasBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_CreateUserInstanceConfigAction_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.CreateUserInstanceConfigAction
        getDefaultInstanceForType() {
      return com.google.spanner.executor.v1.CreateUserInstanceConfigAction.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.CreateUserInstanceConfigAction build() {
      com.google.spanner.executor.v1.CreateUserInstanceConfigAction result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.CreateUserInstanceConfigAction buildPartial() {
      com.google.spanner.executor.v1.CreateUserInstanceConfigAction result =
          new com.google.spanner.executor.v1.CreateUserInstanceConfigAction(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.spanner.executor.v1.CreateUserInstanceConfigAction result) {
      if (replicasBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          replicas_ = java.util.Collections.unmodifiableList(replicas_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.replicas_ = replicas_;
      } else {
        result.replicas_ = replicasBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.spanner.executor.v1.CreateUserInstanceConfigAction result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.userConfigId_ = userConfigId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.projectId_ = projectId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.baseConfigId_ = baseConfigId_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.executor.v1.CreateUserInstanceConfigAction) {
        return mergeFrom((com.google.spanner.executor.v1.CreateUserInstanceConfigAction) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.executor.v1.CreateUserInstanceConfigAction other) {
      if (other
          == com.google.spanner.executor.v1.CreateUserInstanceConfigAction.getDefaultInstance())
        return this;
      if (!other.getUserConfigId().isEmpty()) {
        userConfigId_ = other.userConfigId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getBaseConfigId().isEmpty()) {
        baseConfigId_ = other.baseConfigId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (replicasBuilder_ == null) {
        if (!other.replicas_.isEmpty()) {
          if (replicas_.isEmpty()) {
            replicas_ = other.replicas_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureReplicasIsMutable();
            replicas_.addAll(other.replicas_);
          }
          onChanged();
        }
      } else {
        if (!other.replicas_.isEmpty()) {
          if (replicasBuilder_.isEmpty()) {
            replicasBuilder_.dispose();
            replicasBuilder_ = null;
            replicas_ = other.replicas_;
            bitField0_ = (bitField0_ & ~0x00000008);
            replicasBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getReplicasFieldBuilder()
                    : null;
          } else {
            replicasBuilder_.addAllMessages(other.replicas_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                userConfigId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                projectId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                baseConfigId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.spanner.admin.instance.v1.ReplicaInfo m =
                    input.readMessage(
                        com.google.spanner.admin.instance.v1.ReplicaInfo.parser(),
                        extensionRegistry);
                if (replicasBuilder_ == null) {
                  ensureReplicasIsMutable();
                  replicas_.add(m);
                } else {
                  replicasBuilder_.addMessage(m);
                }
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object userConfigId_ = "";
    /**
     *
     *
     * <pre>
     * User instance config ID (not path), e.g. "custom-config".
     * </pre>
     *
     * <code>string user_config_id = 1;</code>
     *
     * @return The userConfigId.
     */
    public java.lang.String getUserConfigId() {
      java.lang.Object ref = userConfigId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        userConfigId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User instance config ID (not path), e.g. "custom-config".
     * </pre>
     *
     * <code>string user_config_id = 1;</code>
     *
     * @return The bytes for userConfigId.
     */
    public com.google.protobuf.ByteString getUserConfigIdBytes() {
      java.lang.Object ref = userConfigId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        userConfigId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User instance config ID (not path), e.g. "custom-config".
     * </pre>
     *
     * <code>string user_config_id = 1;</code>
     *
     * @param value The userConfigId to set.
     * @return This builder for chaining.
     */
    public Builder setUserConfigId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      userConfigId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User instance config ID (not path), e.g. "custom-config".
     * </pre>
     *
     * <code>string user_config_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUserConfigId() {
      userConfigId_ = getDefaultInstance().getUserConfigId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User instance config ID (not path), e.g. "custom-config".
     * </pre>
     *
     * <code>string user_config_id = 1;</code>
     *
     * @param value The bytes for userConfigId to set.
     * @return This builder for chaining.
     */
    public Builder setUserConfigIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      userConfigId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * Cloud project ID, e.g. "spanner-cloud-systest".
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @return The projectId.
     */
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud project ID, e.g. "spanner-cloud-systest".
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @return The bytes for projectId.
     */
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud project ID, e.g. "spanner-cloud-systest".
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      projectId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud project ID, e.g. "spanner-cloud-systest".
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectId() {
      projectId_ = getDefaultInstance().getProjectId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud project ID, e.g. "spanner-cloud-systest".
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      projectId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object baseConfigId_ = "";
    /**
     *
     *
     * <pre>
     * Base config ID, e.g. "test-config".
     * </pre>
     *
     * <code>string base_config_id = 3;</code>
     *
     * @return The baseConfigId.
     */
    public java.lang.String getBaseConfigId() {
      java.lang.Object ref = baseConfigId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        baseConfigId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Base config ID, e.g. "test-config".
     * </pre>
     *
     * <code>string base_config_id = 3;</code>
     *
     * @return The bytes for baseConfigId.
     */
    public com.google.protobuf.ByteString getBaseConfigIdBytes() {
      java.lang.Object ref = baseConfigId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        baseConfigId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Base config ID, e.g. "test-config".
     * </pre>
     *
     * <code>string base_config_id = 3;</code>
     *
     * @param value The baseConfigId to set.
     * @return This builder for chaining.
     */
    public Builder setBaseConfigId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      baseConfigId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Base config ID, e.g. "test-config".
     * </pre>
     *
     * <code>string base_config_id = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBaseConfigId() {
      baseConfigId_ = getDefaultInstance().getBaseConfigId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Base config ID, e.g. "test-config".
     * </pre>
     *
     * <code>string base_config_id = 3;</code>
     *
     * @param value The bytes for baseConfigId to set.
     * @return This builder for chaining.
     */
    public Builder setBaseConfigIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      baseConfigId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.util.List<com.google.spanner.admin.instance.v1.ReplicaInfo> replicas_ =
        java.util.Collections.emptyList();

    private void ensureReplicasIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        replicas_ =
            new java.util.ArrayList<com.google.spanner.admin.instance.v1.ReplicaInfo>(replicas_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.admin.instance.v1.ReplicaInfo,
            com.google.spanner.admin.instance.v1.ReplicaInfo.Builder,
            com.google.spanner.admin.instance.v1.ReplicaInfoOrBuilder>
        replicasBuilder_;

    /**
     *
     *
     * <pre>
     * Replicas that should be included in the user config.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 4;</code>
     */
    public java.util.List<com.google.spanner.admin.instance.v1.ReplicaInfo> getReplicasList() {
      if (replicasBuilder_ == null) {
        return java.util.Collections.unmodifiableList(replicas_);
      } else {
        return replicasBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Replicas that should be included in the user config.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 4;</code>
     */
    public int getReplicasCount() {
      if (replicasBuilder_ == null) {
        return replicas_.size();
      } else {
        return replicasBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Replicas that should be included in the user config.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 4;</code>
     */
    public com.google.spanner.admin.instance.v1.ReplicaInfo getReplicas(int index) {
      if (replicasBuilder_ == null) {
        return replicas_.get(index);
      } else {
        return replicasBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Replicas that should be included in the user config.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 4;</code>
     */
    public Builder setReplicas(int index, com.google.spanner.admin.instance.v1.ReplicaInfo value) {
      if (replicasBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReplicasIsMutable();
        replicas_.set(index, value);
        onChanged();
      } else {
        replicasBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Replicas that should be included in the user config.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 4;</code>
     */
    public Builder setReplicas(
        int index, com.google.spanner.admin.instance.v1.ReplicaInfo.Builder builderForValue) {
      if (replicasBuilder_ == null) {
        ensureReplicasIsMutable();
        replicas_.set(index, builderForValue.build());
        onChanged();
      } else {
        replicasBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Replicas that should be included in the user config.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 4;</code>
     */
    public Builder addReplicas(com.google.spanner.admin.instance.v1.ReplicaInfo value) {
      if (replicasBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReplicasIsMutable();
        replicas_.add(value);
        onChanged();
      } else {
        replicasBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Replicas that should be included in the user config.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 4;</code>
     */
    public Builder addReplicas(int index, com.google.spanner.admin.instance.v1.ReplicaInfo value) {
      if (replicasBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReplicasIsMutable();
        replicas_.add(index, value);
        onChanged();
      } else {
        replicasBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Replicas that should be included in the user config.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 4;</code>
     */
    public Builder addReplicas(
        com.google.spanner.admin.instance.v1.ReplicaInfo.Builder builderForValue) {
      if (replicasBuilder_ == null) {
        ensureReplicasIsMutable();
        replicas_.add(builderForValue.build());
        onChanged();
      } else {
        replicasBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Replicas that should be included in the user config.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 4;</code>
     */
    public Builder addReplicas(
        int index, com.google.spanner.admin.instance.v1.ReplicaInfo.Builder builderForValue) {
      if (replicasBuilder_ == null) {
        ensureReplicasIsMutable();
        replicas_.add(index, builderForValue.build());
        onChanged();
      } else {
        replicasBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Replicas that should be included in the user config.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 4;</code>
     */
    public Builder addAllReplicas(
        java.lang.Iterable<? extends com.google.spanner.admin.instance.v1.ReplicaInfo> values) {
      if (replicasBuilder_ == null) {
        ensureReplicasIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, replicas_);
        onChanged();
      } else {
        replicasBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Replicas that should be included in the user config.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 4;</code>
     */
    public Builder clearReplicas() {
      if (replicasBuilder_ == null) {
        replicas_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        replicasBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Replicas that should be included in the user config.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 4;</code>
     */
    public Builder removeReplicas(int index) {
      if (replicasBuilder_ == null) {
        ensureReplicasIsMutable();
        replicas_.remove(index);
        onChanged();
      } else {
        replicasBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Replicas that should be included in the user config.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 4;</code>
     */
    public com.google.spanner.admin.instance.v1.ReplicaInfo.Builder getReplicasBuilder(int index) {
      return getReplicasFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Replicas that should be included in the user config.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 4;</code>
     */
    public com.google.spanner.admin.instance.v1.ReplicaInfoOrBuilder getReplicasOrBuilder(
        int index) {
      if (replicasBuilder_ == null) {
        return replicas_.get(index);
      } else {
        return replicasBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Replicas that should be included in the user config.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 4;</code>
     */
    public java.util.List<? extends com.google.spanner.admin.instance.v1.ReplicaInfoOrBuilder>
        getReplicasOrBuilderList() {
      if (replicasBuilder_ != null) {
        return replicasBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(replicas_);
      }
    }
    /**
     *
     *
     * <pre>
     * Replicas that should be included in the user config.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 4;</code>
     */
    public com.google.spanner.admin.instance.v1.ReplicaInfo.Builder addReplicasBuilder() {
      return getReplicasFieldBuilder()
          .addBuilder(com.google.spanner.admin.instance.v1.ReplicaInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Replicas that should be included in the user config.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 4;</code>
     */
    public com.google.spanner.admin.instance.v1.ReplicaInfo.Builder addReplicasBuilder(int index) {
      return getReplicasFieldBuilder()
          .addBuilder(index, com.google.spanner.admin.instance.v1.ReplicaInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Replicas that should be included in the user config.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 4;</code>
     */
    public java.util.List<com.google.spanner.admin.instance.v1.ReplicaInfo.Builder>
        getReplicasBuilderList() {
      return getReplicasFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.admin.instance.v1.ReplicaInfo,
            com.google.spanner.admin.instance.v1.ReplicaInfo.Builder,
            com.google.spanner.admin.instance.v1.ReplicaInfoOrBuilder>
        getReplicasFieldBuilder() {
      if (replicasBuilder_ == null) {
        replicasBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.spanner.admin.instance.v1.ReplicaInfo,
                com.google.spanner.admin.instance.v1.ReplicaInfo.Builder,
                com.google.spanner.admin.instance.v1.ReplicaInfoOrBuilder>(
                replicas_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        replicas_ = null;
      }
      return replicasBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.executor.v1.CreateUserInstanceConfigAction)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.executor.v1.CreateUserInstanceConfigAction)
  private static final com.google.spanner.executor.v1.CreateUserInstanceConfigAction
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.executor.v1.CreateUserInstanceConfigAction();
  }

  public static com.google.spanner.executor.v1.CreateUserInstanceConfigAction getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CreateUserInstanceConfigAction> PARSER =
      new com.google.protobuf.AbstractParser<CreateUserInstanceConfigAction>() {
        @java.lang.Override
        public CreateUserInstanceConfigAction parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CreateUserInstanceConfigAction> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CreateUserInstanceConfigAction> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.executor.v1.CreateUserInstanceConfigAction getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
