/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/executor/v1/cloud_executor.proto

// Protobuf Java Version: 3.25.3
package com.google.spanner.executor.v1;

/**
 *
 *
 * <pre>
 * Generate database partitions for the given read. Successful outcomes will
 * contain database partitions in the db_partition field.
 * </pre>
 *
 * Protobuf type {@code google.spanner.executor.v1.GenerateDbPartitionsForReadAction}
 */
public final class GenerateDbPartitionsForReadAction extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.executor.v1.GenerateDbPartitionsForReadAction)
    GenerateDbPartitionsForReadActionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GenerateDbPartitionsForReadAction.newBuilder() to construct.
  private GenerateDbPartitionsForReadAction(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GenerateDbPartitionsForReadAction() {
    table_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GenerateDbPartitionsForReadAction();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_GenerateDbPartitionsForReadAction_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_GenerateDbPartitionsForReadAction_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction.class,
            com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction.Builder.class);
  }

  private int bitField0_;
  public static final int READ_FIELD_NUMBER = 1;
  private com.google.spanner.executor.v1.ReadAction read_;
  /**
   *
   *
   * <pre>
   * Read to generate partitions for.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ReadAction read = 1;</code>
   *
   * @return Whether the read field is set.
   */
  @java.lang.Override
  public boolean hasRead() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Read to generate partitions for.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ReadAction read = 1;</code>
   *
   * @return The read.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ReadAction getRead() {
    return read_ == null ? com.google.spanner.executor.v1.ReadAction.getDefaultInstance() : read_;
  }
  /**
   *
   *
   * <pre>
   * Read to generate partitions for.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ReadAction read = 1;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ReadActionOrBuilder getReadOrBuilder() {
    return read_ == null ? com.google.spanner.executor.v1.ReadAction.getDefaultInstance() : read_;
  }

  public static final int TABLE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.spanner.executor.v1.TableMetadata> table_;
  /**
   *
   *
   * <pre>
   * Metadata related to the tables involved in the read.
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.spanner.executor.v1.TableMetadata> getTableList() {
    return table_;
  }
  /**
   *
   *
   * <pre>
   * Metadata related to the tables involved in the read.
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.spanner.executor.v1.TableMetadataOrBuilder>
      getTableOrBuilderList() {
    return table_;
  }
  /**
   *
   *
   * <pre>
   * Metadata related to the tables involved in the read.
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
   */
  @java.lang.Override
  public int getTableCount() {
    return table_.size();
  }
  /**
   *
   *
   * <pre>
   * Metadata related to the tables involved in the read.
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.TableMetadata getTable(int index) {
    return table_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Metadata related to the tables involved in the read.
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.TableMetadataOrBuilder getTableOrBuilder(int index) {
    return table_.get(index);
  }

  public static final int DESIRED_BYTES_PER_PARTITION_FIELD_NUMBER = 3;
  private long desiredBytesPerPartition_ = 0L;
  /**
   *
   *
   * <pre>
   * Desired size of data in each partition. Spanner doesn't guarantee to
   * respect this value.
   * </pre>
   *
   * <code>optional int64 desired_bytes_per_partition = 3;</code>
   *
   * @return Whether the desiredBytesPerPartition field is set.
   */
  @java.lang.Override
  public boolean hasDesiredBytesPerPartition() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Desired size of data in each partition. Spanner doesn't guarantee to
   * respect this value.
   * </pre>
   *
   * <code>optional int64 desired_bytes_per_partition = 3;</code>
   *
   * @return The desiredBytesPerPartition.
   */
  @java.lang.Override
  public long getDesiredBytesPerPartition() {
    return desiredBytesPerPartition_;
  }

  public static final int MAX_PARTITION_COUNT_FIELD_NUMBER = 4;
  private long maxPartitionCount_ = 0L;
  /**
   *
   *
   * <pre>
   * If set, the desired max number of partitions. Spanner doesn't guarantee to
   * respect this value.
   * </pre>
   *
   * <code>optional int64 max_partition_count = 4;</code>
   *
   * @return Whether the maxPartitionCount field is set.
   */
  @java.lang.Override
  public boolean hasMaxPartitionCount() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * If set, the desired max number of partitions. Spanner doesn't guarantee to
   * respect this value.
   * </pre>
   *
   * <code>optional int64 max_partition_count = 4;</code>
   *
   * @return The maxPartitionCount.
   */
  @java.lang.Override
  public long getMaxPartitionCount() {
    return maxPartitionCount_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getRead());
    }
    for (int i = 0; i < table_.size(); i++) {
      output.writeMessage(2, table_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeInt64(3, desiredBytesPerPartition_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeInt64(4, maxPartitionCount_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getRead());
    }
    for (int i = 0; i < table_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, table_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, desiredBytesPerPartition_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, maxPartitionCount_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction)) {
      return super.equals(obj);
    }
    com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction other =
        (com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction) obj;

    if (hasRead() != other.hasRead()) return false;
    if (hasRead()) {
      if (!getRead().equals(other.getRead())) return false;
    }
    if (!getTableList().equals(other.getTableList())) return false;
    if (hasDesiredBytesPerPartition() != other.hasDesiredBytesPerPartition()) return false;
    if (hasDesiredBytesPerPartition()) {
      if (getDesiredBytesPerPartition() != other.getDesiredBytesPerPartition()) return false;
    }
    if (hasMaxPartitionCount() != other.hasMaxPartitionCount()) return false;
    if (hasMaxPartitionCount()) {
      if (getMaxPartitionCount() != other.getMaxPartitionCount()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasRead()) {
      hash = (37 * hash) + READ_FIELD_NUMBER;
      hash = (53 * hash) + getRead().hashCode();
    }
    if (getTableCount() > 0) {
      hash = (37 * hash) + TABLE_FIELD_NUMBER;
      hash = (53 * hash) + getTableList().hashCode();
    }
    if (hasDesiredBytesPerPartition()) {
      hash = (37 * hash) + DESIRED_BYTES_PER_PARTITION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getDesiredBytesPerPartition());
    }
    if (hasMaxPartitionCount()) {
      hash = (37 * hash) + MAX_PARTITION_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMaxPartitionCount());
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Generate database partitions for the given read. Successful outcomes will
   * contain database partitions in the db_partition field.
   * </pre>
   *
   * Protobuf type {@code google.spanner.executor.v1.GenerateDbPartitionsForReadAction}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.executor.v1.GenerateDbPartitionsForReadAction)
      com.google.spanner.executor.v1.GenerateDbPartitionsForReadActionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_GenerateDbPartitionsForReadAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_GenerateDbPartitionsForReadAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction.class,
              com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction.Builder.class);
    }

    // Construct using com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getReadFieldBuilder();
        getTableFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      read_ = null;
      if (readBuilder_ != null) {
        readBuilder_.dispose();
        readBuilder_ = null;
      }
      if (tableBuilder_ == null) {
        table_ = java.util.Collections.emptyList();
      } else {
        table_ = null;
        tableBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      desiredBytesPerPartition_ = 0L;
      maxPartitionCount_ = 0L;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_GenerateDbPartitionsForReadAction_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction
        getDefaultInstanceForType() {
      return com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction build() {
      com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction buildPartial() {
      com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction result =
          new com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction result) {
      if (tableBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          table_ = java.util.Collections.unmodifiableList(table_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.table_ = table_;
      } else {
        result.table_ = tableBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.read_ = readBuilder_ == null ? read_ : readBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.desiredBytesPerPartition_ = desiredBytesPerPartition_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.maxPartitionCount_ = maxPartitionCount_;
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction) {
        return mergeFrom((com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction other) {
      if (other
          == com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction.getDefaultInstance())
        return this;
      if (other.hasRead()) {
        mergeRead(other.getRead());
      }
      if (tableBuilder_ == null) {
        if (!other.table_.isEmpty()) {
          if (table_.isEmpty()) {
            table_ = other.table_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureTableIsMutable();
            table_.addAll(other.table_);
          }
          onChanged();
        }
      } else {
        if (!other.table_.isEmpty()) {
          if (tableBuilder_.isEmpty()) {
            tableBuilder_.dispose();
            tableBuilder_ = null;
            table_ = other.table_;
            bitField0_ = (bitField0_ & ~0x00000002);
            tableBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTableFieldBuilder()
                    : null;
          } else {
            tableBuilder_.addAllMessages(other.table_);
          }
        }
      }
      if (other.hasDesiredBytesPerPartition()) {
        setDesiredBytesPerPartition(other.getDesiredBytesPerPartition());
      }
      if (other.hasMaxPartitionCount()) {
        setMaxPartitionCount(other.getMaxPartitionCount());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getReadFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.spanner.executor.v1.TableMetadata m =
                    input.readMessage(
                        com.google.spanner.executor.v1.TableMetadata.parser(), extensionRegistry);
                if (tableBuilder_ == null) {
                  ensureTableIsMutable();
                  table_.add(m);
                } else {
                  tableBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 24:
              {
                desiredBytesPerPartition_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                maxPartitionCount_ = input.readInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.spanner.executor.v1.ReadAction read_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ReadAction,
            com.google.spanner.executor.v1.ReadAction.Builder,
            com.google.spanner.executor.v1.ReadActionOrBuilder>
        readBuilder_;
    /**
     *
     *
     * <pre>
     * Read to generate partitions for.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ReadAction read = 1;</code>
     *
     * @return Whether the read field is set.
     */
    public boolean hasRead() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Read to generate partitions for.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ReadAction read = 1;</code>
     *
     * @return The read.
     */
    public com.google.spanner.executor.v1.ReadAction getRead() {
      if (readBuilder_ == null) {
        return read_ == null
            ? com.google.spanner.executor.v1.ReadAction.getDefaultInstance()
            : read_;
      } else {
        return readBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Read to generate partitions for.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ReadAction read = 1;</code>
     */
    public Builder setRead(com.google.spanner.executor.v1.ReadAction value) {
      if (readBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        read_ = value;
      } else {
        readBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Read to generate partitions for.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ReadAction read = 1;</code>
     */
    public Builder setRead(com.google.spanner.executor.v1.ReadAction.Builder builderForValue) {
      if (readBuilder_ == null) {
        read_ = builderForValue.build();
      } else {
        readBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Read to generate partitions for.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ReadAction read = 1;</code>
     */
    public Builder mergeRead(com.google.spanner.executor.v1.ReadAction value) {
      if (readBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && read_ != null
            && read_ != com.google.spanner.executor.v1.ReadAction.getDefaultInstance()) {
          getReadBuilder().mergeFrom(value);
        } else {
          read_ = value;
        }
      } else {
        readBuilder_.mergeFrom(value);
      }
      if (read_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Read to generate partitions for.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ReadAction read = 1;</code>
     */
    public Builder clearRead() {
      bitField0_ = (bitField0_ & ~0x00000001);
      read_ = null;
      if (readBuilder_ != null) {
        readBuilder_.dispose();
        readBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Read to generate partitions for.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ReadAction read = 1;</code>
     */
    public com.google.spanner.executor.v1.ReadAction.Builder getReadBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getReadFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Read to generate partitions for.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ReadAction read = 1;</code>
     */
    public com.google.spanner.executor.v1.ReadActionOrBuilder getReadOrBuilder() {
      if (readBuilder_ != null) {
        return readBuilder_.getMessageOrBuilder();
      } else {
        return read_ == null
            ? com.google.spanner.executor.v1.ReadAction.getDefaultInstance()
            : read_;
      }
    }
    /**
     *
     *
     * <pre>
     * Read to generate partitions for.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ReadAction read = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ReadAction,
            com.google.spanner.executor.v1.ReadAction.Builder,
            com.google.spanner.executor.v1.ReadActionOrBuilder>
        getReadFieldBuilder() {
      if (readBuilder_ == null) {
        readBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.ReadAction,
                com.google.spanner.executor.v1.ReadAction.Builder,
                com.google.spanner.executor.v1.ReadActionOrBuilder>(
                getRead(), getParentForChildren(), isClean());
        read_ = null;
      }
      return readBuilder_;
    }

    private java.util.List<com.google.spanner.executor.v1.TableMetadata> table_ =
        java.util.Collections.emptyList();

    private void ensureTableIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        table_ = new java.util.ArrayList<com.google.spanner.executor.v1.TableMetadata>(table_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.executor.v1.TableMetadata,
            com.google.spanner.executor.v1.TableMetadata.Builder,
            com.google.spanner.executor.v1.TableMetadataOrBuilder>
        tableBuilder_;

    /**
     *
     *
     * <pre>
     * Metadata related to the tables involved in the read.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public java.util.List<com.google.spanner.executor.v1.TableMetadata> getTableList() {
      if (tableBuilder_ == null) {
        return java.util.Collections.unmodifiableList(table_);
      } else {
        return tableBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata related to the tables involved in the read.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public int getTableCount() {
      if (tableBuilder_ == null) {
        return table_.size();
      } else {
        return tableBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata related to the tables involved in the read.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public com.google.spanner.executor.v1.TableMetadata getTable(int index) {
      if (tableBuilder_ == null) {
        return table_.get(index);
      } else {
        return tableBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata related to the tables involved in the read.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public Builder setTable(int index, com.google.spanner.executor.v1.TableMetadata value) {
      if (tableBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTableIsMutable();
        table_.set(index, value);
        onChanged();
      } else {
        tableBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata related to the tables involved in the read.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public Builder setTable(
        int index, com.google.spanner.executor.v1.TableMetadata.Builder builderForValue) {
      if (tableBuilder_ == null) {
        ensureTableIsMutable();
        table_.set(index, builderForValue.build());
        onChanged();
      } else {
        tableBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata related to the tables involved in the read.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public Builder addTable(com.google.spanner.executor.v1.TableMetadata value) {
      if (tableBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTableIsMutable();
        table_.add(value);
        onChanged();
      } else {
        tableBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata related to the tables involved in the read.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public Builder addTable(int index, com.google.spanner.executor.v1.TableMetadata value) {
      if (tableBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTableIsMutable();
        table_.add(index, value);
        onChanged();
      } else {
        tableBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata related to the tables involved in the read.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public Builder addTable(com.google.spanner.executor.v1.TableMetadata.Builder builderForValue) {
      if (tableBuilder_ == null) {
        ensureTableIsMutable();
        table_.add(builderForValue.build());
        onChanged();
      } else {
        tableBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata related to the tables involved in the read.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public Builder addTable(
        int index, com.google.spanner.executor.v1.TableMetadata.Builder builderForValue) {
      if (tableBuilder_ == null) {
        ensureTableIsMutable();
        table_.add(index, builderForValue.build());
        onChanged();
      } else {
        tableBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata related to the tables involved in the read.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public Builder addAllTable(
        java.lang.Iterable<? extends com.google.spanner.executor.v1.TableMetadata> values) {
      if (tableBuilder_ == null) {
        ensureTableIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, table_);
        onChanged();
      } else {
        tableBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata related to the tables involved in the read.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public Builder clearTable() {
      if (tableBuilder_ == null) {
        table_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        tableBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata related to the tables involved in the read.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public Builder removeTable(int index) {
      if (tableBuilder_ == null) {
        ensureTableIsMutable();
        table_.remove(index);
        onChanged();
      } else {
        tableBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata related to the tables involved in the read.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public com.google.spanner.executor.v1.TableMetadata.Builder getTableBuilder(int index) {
      return getTableFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Metadata related to the tables involved in the read.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public com.google.spanner.executor.v1.TableMetadataOrBuilder getTableOrBuilder(int index) {
      if (tableBuilder_ == null) {
        return table_.get(index);
      } else {
        return tableBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata related to the tables involved in the read.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public java.util.List<? extends com.google.spanner.executor.v1.TableMetadataOrBuilder>
        getTableOrBuilderList() {
      if (tableBuilder_ != null) {
        return tableBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(table_);
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata related to the tables involved in the read.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public com.google.spanner.executor.v1.TableMetadata.Builder addTableBuilder() {
      return getTableFieldBuilder()
          .addBuilder(com.google.spanner.executor.v1.TableMetadata.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Metadata related to the tables involved in the read.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public com.google.spanner.executor.v1.TableMetadata.Builder addTableBuilder(int index) {
      return getTableFieldBuilder()
          .addBuilder(index, com.google.spanner.executor.v1.TableMetadata.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Metadata related to the tables involved in the read.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public java.util.List<com.google.spanner.executor.v1.TableMetadata.Builder>
        getTableBuilderList() {
      return getTableFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.executor.v1.TableMetadata,
            com.google.spanner.executor.v1.TableMetadata.Builder,
            com.google.spanner.executor.v1.TableMetadataOrBuilder>
        getTableFieldBuilder() {
      if (tableBuilder_ == null) {
        tableBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.spanner.executor.v1.TableMetadata,
                com.google.spanner.executor.v1.TableMetadata.Builder,
                com.google.spanner.executor.v1.TableMetadataOrBuilder>(
                table_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        table_ = null;
      }
      return tableBuilder_;
    }

    private long desiredBytesPerPartition_;
    /**
     *
     *
     * <pre>
     * Desired size of data in each partition. Spanner doesn't guarantee to
     * respect this value.
     * </pre>
     *
     * <code>optional int64 desired_bytes_per_partition = 3;</code>
     *
     * @return Whether the desiredBytesPerPartition field is set.
     */
    @java.lang.Override
    public boolean hasDesiredBytesPerPartition() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Desired size of data in each partition. Spanner doesn't guarantee to
     * respect this value.
     * </pre>
     *
     * <code>optional int64 desired_bytes_per_partition = 3;</code>
     *
     * @return The desiredBytesPerPartition.
     */
    @java.lang.Override
    public long getDesiredBytesPerPartition() {
      return desiredBytesPerPartition_;
    }
    /**
     *
     *
     * <pre>
     * Desired size of data in each partition. Spanner doesn't guarantee to
     * respect this value.
     * </pre>
     *
     * <code>optional int64 desired_bytes_per_partition = 3;</code>
     *
     * @param value The desiredBytesPerPartition to set.
     * @return This builder for chaining.
     */
    public Builder setDesiredBytesPerPartition(long value) {

      desiredBytesPerPartition_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Desired size of data in each partition. Spanner doesn't guarantee to
     * respect this value.
     * </pre>
     *
     * <code>optional int64 desired_bytes_per_partition = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDesiredBytesPerPartition() {
      bitField0_ = (bitField0_ & ~0x00000004);
      desiredBytesPerPartition_ = 0L;
      onChanged();
      return this;
    }

    private long maxPartitionCount_;
    /**
     *
     *
     * <pre>
     * If set, the desired max number of partitions. Spanner doesn't guarantee to
     * respect this value.
     * </pre>
     *
     * <code>optional int64 max_partition_count = 4;</code>
     *
     * @return Whether the maxPartitionCount field is set.
     */
    @java.lang.Override
    public boolean hasMaxPartitionCount() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * If set, the desired max number of partitions. Spanner doesn't guarantee to
     * respect this value.
     * </pre>
     *
     * <code>optional int64 max_partition_count = 4;</code>
     *
     * @return The maxPartitionCount.
     */
    @java.lang.Override
    public long getMaxPartitionCount() {
      return maxPartitionCount_;
    }
    /**
     *
     *
     * <pre>
     * If set, the desired max number of partitions. Spanner doesn't guarantee to
     * respect this value.
     * </pre>
     *
     * <code>optional int64 max_partition_count = 4;</code>
     *
     * @param value The maxPartitionCount to set.
     * @return This builder for chaining.
     */
    public Builder setMaxPartitionCount(long value) {

      maxPartitionCount_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, the desired max number of partitions. Spanner doesn't guarantee to
     * respect this value.
     * </pre>
     *
     * <code>optional int64 max_partition_count = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxPartitionCount() {
      bitField0_ = (bitField0_ & ~0x00000008);
      maxPartitionCount_ = 0L;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.executor.v1.GenerateDbPartitionsForReadAction)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.executor.v1.GenerateDbPartitionsForReadAction)
  private static final com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction();
  }

  public static com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GenerateDbPartitionsForReadAction> PARSER =
      new com.google.protobuf.AbstractParser<GenerateDbPartitionsForReadAction>() {
        @java.lang.Override
        public GenerateDbPartitionsForReadAction parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GenerateDbPartitionsForReadAction> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GenerateDbPartitionsForReadAction> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
