/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/executor/v1/cloud_executor.proto

// Protobuf Java Version: 3.25.3
package com.google.spanner.executor.v1;

/**
 *
 *
 * <pre>
 * KeySet defines a collection of Spanner keys and/or key ranges. All
 * the keys are expected to be in the same table. The keys need not be
 * sorted in any particular way.
 * </pre>
 *
 * Protobuf type {@code google.spanner.executor.v1.KeySet}
 */
public final class KeySet extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.executor.v1.KeySet)
    KeySetOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use KeySet.newBuilder() to construct.
  private KeySet(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private KeySet() {
    point_ = java.util.Collections.emptyList();
    range_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new KeySet();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_KeySet_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_KeySet_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.executor.v1.KeySet.class,
            com.google.spanner.executor.v1.KeySet.Builder.class);
  }

  public static final int POINT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.spanner.executor.v1.ValueList> point_;
  /**
   *
   *
   * <pre>
   * A list of specific keys. Entries in "keys" should have exactly as
   * many elements as there are columns in the primary or index key
   * with which this "KeySet" is used.
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.ValueList point = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.spanner.executor.v1.ValueList> getPointList() {
    return point_;
  }
  /**
   *
   *
   * <pre>
   * A list of specific keys. Entries in "keys" should have exactly as
   * many elements as there are columns in the primary or index key
   * with which this "KeySet" is used.
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.ValueList point = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.spanner.executor.v1.ValueListOrBuilder>
      getPointOrBuilderList() {
    return point_;
  }
  /**
   *
   *
   * <pre>
   * A list of specific keys. Entries in "keys" should have exactly as
   * many elements as there are columns in the primary or index key
   * with which this "KeySet" is used.
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.ValueList point = 1;</code>
   */
  @java.lang.Override
  public int getPointCount() {
    return point_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of specific keys. Entries in "keys" should have exactly as
   * many elements as there are columns in the primary or index key
   * with which this "KeySet" is used.
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.ValueList point = 1;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ValueList getPoint(int index) {
    return point_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of specific keys. Entries in "keys" should have exactly as
   * many elements as there are columns in the primary or index key
   * with which this "KeySet" is used.
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.ValueList point = 1;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ValueListOrBuilder getPointOrBuilder(int index) {
    return point_.get(index);
  }

  public static final int RANGE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.spanner.executor.v1.KeyRange> range_;
  /**
   *
   *
   * <pre>
   * A list of key ranges.
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.KeyRange range = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.spanner.executor.v1.KeyRange> getRangeList() {
    return range_;
  }
  /**
   *
   *
   * <pre>
   * A list of key ranges.
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.KeyRange range = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.spanner.executor.v1.KeyRangeOrBuilder>
      getRangeOrBuilderList() {
    return range_;
  }
  /**
   *
   *
   * <pre>
   * A list of key ranges.
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.KeyRange range = 2;</code>
   */
  @java.lang.Override
  public int getRangeCount() {
    return range_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of key ranges.
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.KeyRange range = 2;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.KeyRange getRange(int index) {
    return range_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of key ranges.
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.KeyRange range = 2;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.KeyRangeOrBuilder getRangeOrBuilder(int index) {
    return range_.get(index);
  }

  public static final int ALL_FIELD_NUMBER = 3;
  private boolean all_ = false;
  /**
   *
   *
   * <pre>
   * For convenience "all" can be set to "true" to indicate that this
   * "KeySet" matches all keys in the table or index. Note that any keys
   * specified in "keys" or "ranges" are only yielded once.
   * </pre>
   *
   * <code>bool all = 3;</code>
   *
   * @return The all.
   */
  @java.lang.Override
  public boolean getAll() {
    return all_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < point_.size(); i++) {
      output.writeMessage(1, point_.get(i));
    }
    for (int i = 0; i < range_.size(); i++) {
      output.writeMessage(2, range_.get(i));
    }
    if (all_ != false) {
      output.writeBool(3, all_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < point_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, point_.get(i));
    }
    for (int i = 0; i < range_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, range_.get(i));
    }
    if (all_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, all_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.executor.v1.KeySet)) {
      return super.equals(obj);
    }
    com.google.spanner.executor.v1.KeySet other = (com.google.spanner.executor.v1.KeySet) obj;

    if (!getPointList().equals(other.getPointList())) return false;
    if (!getRangeList().equals(other.getRangeList())) return false;
    if (getAll() != other.getAll()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getPointCount() > 0) {
      hash = (37 * hash) + POINT_FIELD_NUMBER;
      hash = (53 * hash) + getPointList().hashCode();
    }
    if (getRangeCount() > 0) {
      hash = (37 * hash) + RANGE_FIELD_NUMBER;
      hash = (53 * hash) + getRangeList().hashCode();
    }
    hash = (37 * hash) + ALL_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAll());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.executor.v1.KeySet parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.KeySet parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.KeySet parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.KeySet parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.KeySet parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.KeySet parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.KeySet parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.KeySet parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.KeySet parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.KeySet parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.KeySet parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.KeySet parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.executor.v1.KeySet prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * KeySet defines a collection of Spanner keys and/or key ranges. All
   * the keys are expected to be in the same table. The keys need not be
   * sorted in any particular way.
   * </pre>
   *
   * Protobuf type {@code google.spanner.executor.v1.KeySet}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.executor.v1.KeySet)
      com.google.spanner.executor.v1.KeySetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_KeySet_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_KeySet_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.executor.v1.KeySet.class,
              com.google.spanner.executor.v1.KeySet.Builder.class);
    }

    // Construct using com.google.spanner.executor.v1.KeySet.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (pointBuilder_ == null) {
        point_ = java.util.Collections.emptyList();
      } else {
        point_ = null;
        pointBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (rangeBuilder_ == null) {
        range_ = java.util.Collections.emptyList();
      } else {
        range_ = null;
        rangeBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      all_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_KeySet_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.KeySet getDefaultInstanceForType() {
      return com.google.spanner.executor.v1.KeySet.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.KeySet build() {
      com.google.spanner.executor.v1.KeySet result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.KeySet buildPartial() {
      com.google.spanner.executor.v1.KeySet result =
          new com.google.spanner.executor.v1.KeySet(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.spanner.executor.v1.KeySet result) {
      if (pointBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          point_ = java.util.Collections.unmodifiableList(point_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.point_ = point_;
      } else {
        result.point_ = pointBuilder_.build();
      }
      if (rangeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          range_ = java.util.Collections.unmodifiableList(range_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.range_ = range_;
      } else {
        result.range_ = rangeBuilder_.build();
      }
    }

    private void buildPartial0(com.google.spanner.executor.v1.KeySet result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.all_ = all_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.executor.v1.KeySet) {
        return mergeFrom((com.google.spanner.executor.v1.KeySet) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.executor.v1.KeySet other) {
      if (other == com.google.spanner.executor.v1.KeySet.getDefaultInstance()) return this;
      if (pointBuilder_ == null) {
        if (!other.point_.isEmpty()) {
          if (point_.isEmpty()) {
            point_ = other.point_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensurePointIsMutable();
            point_.addAll(other.point_);
          }
          onChanged();
        }
      } else {
        if (!other.point_.isEmpty()) {
          if (pointBuilder_.isEmpty()) {
            pointBuilder_.dispose();
            pointBuilder_ = null;
            point_ = other.point_;
            bitField0_ = (bitField0_ & ~0x00000001);
            pointBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPointFieldBuilder()
                    : null;
          } else {
            pointBuilder_.addAllMessages(other.point_);
          }
        }
      }
      if (rangeBuilder_ == null) {
        if (!other.range_.isEmpty()) {
          if (range_.isEmpty()) {
            range_ = other.range_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureRangeIsMutable();
            range_.addAll(other.range_);
          }
          onChanged();
        }
      } else {
        if (!other.range_.isEmpty()) {
          if (rangeBuilder_.isEmpty()) {
            rangeBuilder_.dispose();
            rangeBuilder_ = null;
            range_ = other.range_;
            bitField0_ = (bitField0_ & ~0x00000002);
            rangeBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRangeFieldBuilder()
                    : null;
          } else {
            rangeBuilder_.addAllMessages(other.range_);
          }
        }
      }
      if (other.getAll() != false) {
        setAll(other.getAll());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.spanner.executor.v1.ValueList m =
                    input.readMessage(
                        com.google.spanner.executor.v1.ValueList.parser(), extensionRegistry);
                if (pointBuilder_ == null) {
                  ensurePointIsMutable();
                  point_.add(m);
                } else {
                  pointBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                com.google.spanner.executor.v1.KeyRange m =
                    input.readMessage(
                        com.google.spanner.executor.v1.KeyRange.parser(), extensionRegistry);
                if (rangeBuilder_ == null) {
                  ensureRangeIsMutable();
                  range_.add(m);
                } else {
                  rangeBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 24:
              {
                all_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.spanner.executor.v1.ValueList> point_ =
        java.util.Collections.emptyList();

    private void ensurePointIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        point_ = new java.util.ArrayList<com.google.spanner.executor.v1.ValueList>(point_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.executor.v1.ValueList,
            com.google.spanner.executor.v1.ValueList.Builder,
            com.google.spanner.executor.v1.ValueListOrBuilder>
        pointBuilder_;

    /**
     *
     *
     * <pre>
     * A list of specific keys. Entries in "keys" should have exactly as
     * many elements as there are columns in the primary or index key
     * with which this "KeySet" is used.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList point = 1;</code>
     */
    public java.util.List<com.google.spanner.executor.v1.ValueList> getPointList() {
      if (pointBuilder_ == null) {
        return java.util.Collections.unmodifiableList(point_);
      } else {
        return pointBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of specific keys. Entries in "keys" should have exactly as
     * many elements as there are columns in the primary or index key
     * with which this "KeySet" is used.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList point = 1;</code>
     */
    public int getPointCount() {
      if (pointBuilder_ == null) {
        return point_.size();
      } else {
        return pointBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of specific keys. Entries in "keys" should have exactly as
     * many elements as there are columns in the primary or index key
     * with which this "KeySet" is used.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList point = 1;</code>
     */
    public com.google.spanner.executor.v1.ValueList getPoint(int index) {
      if (pointBuilder_ == null) {
        return point_.get(index);
      } else {
        return pointBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of specific keys. Entries in "keys" should have exactly as
     * many elements as there are columns in the primary or index key
     * with which this "KeySet" is used.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList point = 1;</code>
     */
    public Builder setPoint(int index, com.google.spanner.executor.v1.ValueList value) {
      if (pointBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePointIsMutable();
        point_.set(index, value);
        onChanged();
      } else {
        pointBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of specific keys. Entries in "keys" should have exactly as
     * many elements as there are columns in the primary or index key
     * with which this "KeySet" is used.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList point = 1;</code>
     */
    public Builder setPoint(
        int index, com.google.spanner.executor.v1.ValueList.Builder builderForValue) {
      if (pointBuilder_ == null) {
        ensurePointIsMutable();
        point_.set(index, builderForValue.build());
        onChanged();
      } else {
        pointBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of specific keys. Entries in "keys" should have exactly as
     * many elements as there are columns in the primary or index key
     * with which this "KeySet" is used.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList point = 1;</code>
     */
    public Builder addPoint(com.google.spanner.executor.v1.ValueList value) {
      if (pointBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePointIsMutable();
        point_.add(value);
        onChanged();
      } else {
        pointBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of specific keys. Entries in "keys" should have exactly as
     * many elements as there are columns in the primary or index key
     * with which this "KeySet" is used.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList point = 1;</code>
     */
    public Builder addPoint(int index, com.google.spanner.executor.v1.ValueList value) {
      if (pointBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePointIsMutable();
        point_.add(index, value);
        onChanged();
      } else {
        pointBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of specific keys. Entries in "keys" should have exactly as
     * many elements as there are columns in the primary or index key
     * with which this "KeySet" is used.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList point = 1;</code>
     */
    public Builder addPoint(com.google.spanner.executor.v1.ValueList.Builder builderForValue) {
      if (pointBuilder_ == null) {
        ensurePointIsMutable();
        point_.add(builderForValue.build());
        onChanged();
      } else {
        pointBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of specific keys. Entries in "keys" should have exactly as
     * many elements as there are columns in the primary or index key
     * with which this "KeySet" is used.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList point = 1;</code>
     */
    public Builder addPoint(
        int index, com.google.spanner.executor.v1.ValueList.Builder builderForValue) {
      if (pointBuilder_ == null) {
        ensurePointIsMutable();
        point_.add(index, builderForValue.build());
        onChanged();
      } else {
        pointBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of specific keys. Entries in "keys" should have exactly as
     * many elements as there are columns in the primary or index key
     * with which this "KeySet" is used.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList point = 1;</code>
     */
    public Builder addAllPoint(
        java.lang.Iterable<? extends com.google.spanner.executor.v1.ValueList> values) {
      if (pointBuilder_ == null) {
        ensurePointIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, point_);
        onChanged();
      } else {
        pointBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of specific keys. Entries in "keys" should have exactly as
     * many elements as there are columns in the primary or index key
     * with which this "KeySet" is used.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList point = 1;</code>
     */
    public Builder clearPoint() {
      if (pointBuilder_ == null) {
        point_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        pointBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of specific keys. Entries in "keys" should have exactly as
     * many elements as there are columns in the primary or index key
     * with which this "KeySet" is used.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList point = 1;</code>
     */
    public Builder removePoint(int index) {
      if (pointBuilder_ == null) {
        ensurePointIsMutable();
        point_.remove(index);
        onChanged();
      } else {
        pointBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of specific keys. Entries in "keys" should have exactly as
     * many elements as there are columns in the primary or index key
     * with which this "KeySet" is used.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList point = 1;</code>
     */
    public com.google.spanner.executor.v1.ValueList.Builder getPointBuilder(int index) {
      return getPointFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of specific keys. Entries in "keys" should have exactly as
     * many elements as there are columns in the primary or index key
     * with which this "KeySet" is used.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList point = 1;</code>
     */
    public com.google.spanner.executor.v1.ValueListOrBuilder getPointOrBuilder(int index) {
      if (pointBuilder_ == null) {
        return point_.get(index);
      } else {
        return pointBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of specific keys. Entries in "keys" should have exactly as
     * many elements as there are columns in the primary or index key
     * with which this "KeySet" is used.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList point = 1;</code>
     */
    public java.util.List<? extends com.google.spanner.executor.v1.ValueListOrBuilder>
        getPointOrBuilderList() {
      if (pointBuilder_ != null) {
        return pointBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(point_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of specific keys. Entries in "keys" should have exactly as
     * many elements as there are columns in the primary or index key
     * with which this "KeySet" is used.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList point = 1;</code>
     */
    public com.google.spanner.executor.v1.ValueList.Builder addPointBuilder() {
      return getPointFieldBuilder()
          .addBuilder(com.google.spanner.executor.v1.ValueList.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of specific keys. Entries in "keys" should have exactly as
     * many elements as there are columns in the primary or index key
     * with which this "KeySet" is used.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList point = 1;</code>
     */
    public com.google.spanner.executor.v1.ValueList.Builder addPointBuilder(int index) {
      return getPointFieldBuilder()
          .addBuilder(index, com.google.spanner.executor.v1.ValueList.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of specific keys. Entries in "keys" should have exactly as
     * many elements as there are columns in the primary or index key
     * with which this "KeySet" is used.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ValueList point = 1;</code>
     */
    public java.util.List<com.google.spanner.executor.v1.ValueList.Builder> getPointBuilderList() {
      return getPointFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.executor.v1.ValueList,
            com.google.spanner.executor.v1.ValueList.Builder,
            com.google.spanner.executor.v1.ValueListOrBuilder>
        getPointFieldBuilder() {
      if (pointBuilder_ == null) {
        pointBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.spanner.executor.v1.ValueList,
                com.google.spanner.executor.v1.ValueList.Builder,
                com.google.spanner.executor.v1.ValueListOrBuilder>(
                point_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        point_ = null;
      }
      return pointBuilder_;
    }

    private java.util.List<com.google.spanner.executor.v1.KeyRange> range_ =
        java.util.Collections.emptyList();

    private void ensureRangeIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        range_ = new java.util.ArrayList<com.google.spanner.executor.v1.KeyRange>(range_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.executor.v1.KeyRange,
            com.google.spanner.executor.v1.KeyRange.Builder,
            com.google.spanner.executor.v1.KeyRangeOrBuilder>
        rangeBuilder_;

    /**
     *
     *
     * <pre>
     * A list of key ranges.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.KeyRange range = 2;</code>
     */
    public java.util.List<com.google.spanner.executor.v1.KeyRange> getRangeList() {
      if (rangeBuilder_ == null) {
        return java.util.Collections.unmodifiableList(range_);
      } else {
        return rangeBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of key ranges.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.KeyRange range = 2;</code>
     */
    public int getRangeCount() {
      if (rangeBuilder_ == null) {
        return range_.size();
      } else {
        return rangeBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of key ranges.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.KeyRange range = 2;</code>
     */
    public com.google.spanner.executor.v1.KeyRange getRange(int index) {
      if (rangeBuilder_ == null) {
        return range_.get(index);
      } else {
        return rangeBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of key ranges.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.KeyRange range = 2;</code>
     */
    public Builder setRange(int index, com.google.spanner.executor.v1.KeyRange value) {
      if (rangeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRangeIsMutable();
        range_.set(index, value);
        onChanged();
      } else {
        rangeBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of key ranges.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.KeyRange range = 2;</code>
     */
    public Builder setRange(
        int index, com.google.spanner.executor.v1.KeyRange.Builder builderForValue) {
      if (rangeBuilder_ == null) {
        ensureRangeIsMutable();
        range_.set(index, builderForValue.build());
        onChanged();
      } else {
        rangeBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of key ranges.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.KeyRange range = 2;</code>
     */
    public Builder addRange(com.google.spanner.executor.v1.KeyRange value) {
      if (rangeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRangeIsMutable();
        range_.add(value);
        onChanged();
      } else {
        rangeBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of key ranges.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.KeyRange range = 2;</code>
     */
    public Builder addRange(int index, com.google.spanner.executor.v1.KeyRange value) {
      if (rangeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRangeIsMutable();
        range_.add(index, value);
        onChanged();
      } else {
        rangeBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of key ranges.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.KeyRange range = 2;</code>
     */
    public Builder addRange(com.google.spanner.executor.v1.KeyRange.Builder builderForValue) {
      if (rangeBuilder_ == null) {
        ensureRangeIsMutable();
        range_.add(builderForValue.build());
        onChanged();
      } else {
        rangeBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of key ranges.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.KeyRange range = 2;</code>
     */
    public Builder addRange(
        int index, com.google.spanner.executor.v1.KeyRange.Builder builderForValue) {
      if (rangeBuilder_ == null) {
        ensureRangeIsMutable();
        range_.add(index, builderForValue.build());
        onChanged();
      } else {
        rangeBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of key ranges.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.KeyRange range = 2;</code>
     */
    public Builder addAllRange(
        java.lang.Iterable<? extends com.google.spanner.executor.v1.KeyRange> values) {
      if (rangeBuilder_ == null) {
        ensureRangeIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, range_);
        onChanged();
      } else {
        rangeBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of key ranges.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.KeyRange range = 2;</code>
     */
    public Builder clearRange() {
      if (rangeBuilder_ == null) {
        range_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        rangeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of key ranges.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.KeyRange range = 2;</code>
     */
    public Builder removeRange(int index) {
      if (rangeBuilder_ == null) {
        ensureRangeIsMutable();
        range_.remove(index);
        onChanged();
      } else {
        rangeBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of key ranges.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.KeyRange range = 2;</code>
     */
    public com.google.spanner.executor.v1.KeyRange.Builder getRangeBuilder(int index) {
      return getRangeFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of key ranges.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.KeyRange range = 2;</code>
     */
    public com.google.spanner.executor.v1.KeyRangeOrBuilder getRangeOrBuilder(int index) {
      if (rangeBuilder_ == null) {
        return range_.get(index);
      } else {
        return rangeBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of key ranges.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.KeyRange range = 2;</code>
     */
    public java.util.List<? extends com.google.spanner.executor.v1.KeyRangeOrBuilder>
        getRangeOrBuilderList() {
      if (rangeBuilder_ != null) {
        return rangeBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(range_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of key ranges.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.KeyRange range = 2;</code>
     */
    public com.google.spanner.executor.v1.KeyRange.Builder addRangeBuilder() {
      return getRangeFieldBuilder()
          .addBuilder(com.google.spanner.executor.v1.KeyRange.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of key ranges.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.KeyRange range = 2;</code>
     */
    public com.google.spanner.executor.v1.KeyRange.Builder addRangeBuilder(int index) {
      return getRangeFieldBuilder()
          .addBuilder(index, com.google.spanner.executor.v1.KeyRange.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of key ranges.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.KeyRange range = 2;</code>
     */
    public java.util.List<com.google.spanner.executor.v1.KeyRange.Builder> getRangeBuilderList() {
      return getRangeFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.executor.v1.KeyRange,
            com.google.spanner.executor.v1.KeyRange.Builder,
            com.google.spanner.executor.v1.KeyRangeOrBuilder>
        getRangeFieldBuilder() {
      if (rangeBuilder_ == null) {
        rangeBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.spanner.executor.v1.KeyRange,
                com.google.spanner.executor.v1.KeyRange.Builder,
                com.google.spanner.executor.v1.KeyRangeOrBuilder>(
                range_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        range_ = null;
      }
      return rangeBuilder_;
    }

    private boolean all_;
    /**
     *
     *
     * <pre>
     * For convenience "all" can be set to "true" to indicate that this
     * "KeySet" matches all keys in the table or index. Note that any keys
     * specified in "keys" or "ranges" are only yielded once.
     * </pre>
     *
     * <code>bool all = 3;</code>
     *
     * @return The all.
     */
    @java.lang.Override
    public boolean getAll() {
      return all_;
    }
    /**
     *
     *
     * <pre>
     * For convenience "all" can be set to "true" to indicate that this
     * "KeySet" matches all keys in the table or index. Note that any keys
     * specified in "keys" or "ranges" are only yielded once.
     * </pre>
     *
     * <code>bool all = 3;</code>
     *
     * @param value The all to set.
     * @return This builder for chaining.
     */
    public Builder setAll(boolean value) {

      all_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For convenience "all" can be set to "true" to indicate that this
     * "KeySet" matches all keys in the table or index. Note that any keys
     * specified in "keys" or "ranges" are only yielded once.
     * </pre>
     *
     * <code>bool all = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAll() {
      bitField0_ = (bitField0_ & ~0x00000004);
      all_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.executor.v1.KeySet)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.executor.v1.KeySet)
  private static final com.google.spanner.executor.v1.KeySet DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.executor.v1.KeySet();
  }

  public static com.google.spanner.executor.v1.KeySet getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<KeySet> PARSER =
      new com.google.protobuf.AbstractParser<KeySet>() {
        @java.lang.Override
        public KeySet parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<KeySet> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<KeySet> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.executor.v1.KeySet getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
