/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/executor/v1/cloud_executor.proto

// Protobuf Java Version: 3.25.3
package com.google.spanner.executor.v1;

/**
 *
 *
 * <pre>
 * Starts a batch read-only transaction in executor. Successful outcomes of this
 * action will contain batch_txn_id--the identificator that can be used to start
 * the same transaction in other Executors to parallelize partition processing.
 *
 * Example of a batch read flow:
 * 1. Start batch transaction with a timestamp (StartBatchTransactionAction)
 * 2. Generate database partitions for a read or query
 * (GenerateDbPartitionsForReadAction/GenerateDbPartitionsForQueryAction)
 * 3. Call ExecutePartitionAction for some or all partitions, process rows
 * 4. Clean up the transaction (CloseBatchTransactionAction).
 *
 * More sophisticated example, with parallel processing:
 * 1. Start batch transaction with a timestamp (StartBatchTransactionAction),
 * note the returned BatchTransactionId
 * 2. Generate database partitions for a read or query
 * (GenerateDbPartitionsForReadAction/GenerateDbPartitionsForQueryAction)
 * 3. Distribute the partitions over a pool of workers, along with the
 * transaction ID.
 *
 * In each worker:
 * 4-1. StartBatchTransactionAction with the given transaction ID
 * 4-2. ExecutePartitionAction for each partition it got, process read results
 * 4-3. Close (not cleanup) the transaction (CloseBatchTransactionAction).
 *
 * When all workers are done:
 * 5. Cleanup the transaction (CloseBatchTransactionAction). This can be done
 * either by the last worker to finish the job, or by the main Executor that
 * initialized this transaction in the first place. It is also possible to clean
 * it up with a brand new Executor -- just execute StartBatchTransactionAction
 * with the ID, then clean it up right away.
 *
 * Cleaning up is optional, but recommended.
 * </pre>
 *
 * Protobuf type {@code google.spanner.executor.v1.StartBatchTransactionAction}
 */
public final class StartBatchTransactionAction extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.executor.v1.StartBatchTransactionAction)
    StartBatchTransactionActionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StartBatchTransactionAction.newBuilder() to construct.
  private StartBatchTransactionAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StartBatchTransactionAction() {
    cloudDatabaseRole_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StartBatchTransactionAction();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_StartBatchTransactionAction_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_StartBatchTransactionAction_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.executor.v1.StartBatchTransactionAction.class,
            com.google.spanner.executor.v1.StartBatchTransactionAction.Builder.class);
  }

  private int paramCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object param_;

  public enum ParamCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BATCH_TXN_TIME(1),
    TID(2),
    PARAM_NOT_SET(0);
    private final int value;

    private ParamCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ParamCase valueOf(int value) {
      return forNumber(value);
    }

    public static ParamCase forNumber(int value) {
      switch (value) {
        case 1:
          return BATCH_TXN_TIME;
        case 2:
          return TID;
        case 0:
          return PARAM_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ParamCase getParamCase() {
    return ParamCase.forNumber(paramCase_);
  }

  public static final int BATCH_TXN_TIME_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * The exact timestamp to start the batch transaction.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp batch_txn_time = 1;</code>
   *
   * @return Whether the batchTxnTime field is set.
   */
  @java.lang.Override
  public boolean hasBatchTxnTime() {
    return paramCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * The exact timestamp to start the batch transaction.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp batch_txn_time = 1;</code>
   *
   * @return The batchTxnTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getBatchTxnTime() {
    if (paramCase_ == 1) {
      return (com.google.protobuf.Timestamp) param_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The exact timestamp to start the batch transaction.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp batch_txn_time = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getBatchTxnTimeOrBuilder() {
    if (paramCase_ == 1) {
      return (com.google.protobuf.Timestamp) param_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }

  public static final int TID_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * ID of a batch read-only transaction. It can be used to start the same
   * batch transaction on multiple executors and parallelize partition
   * processing.
   * </pre>
   *
   * <code>bytes tid = 2;</code>
   *
   * @return Whether the tid field is set.
   */
  @java.lang.Override
  public boolean hasTid() {
    return paramCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * ID of a batch read-only transaction. It can be used to start the same
   * batch transaction on multiple executors and parallelize partition
   * processing.
   * </pre>
   *
   * <code>bytes tid = 2;</code>
   *
   * @return The tid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTid() {
    if (paramCase_ == 2) {
      return (com.google.protobuf.ByteString) param_;
    }
    return com.google.protobuf.ByteString.EMPTY;
  }

  public static final int CLOUD_DATABASE_ROLE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cloudDatabaseRole_ = "";
  /**
   *
   *
   * <pre>
   * Database role to assume while performing this action. Setting the
   * database_role will enforce additional role-based access checks on this
   * action.
   * </pre>
   *
   * <code>string cloud_database_role = 3;</code>
   *
   * @return The cloudDatabaseRole.
   */
  @java.lang.Override
  public java.lang.String getCloudDatabaseRole() {
    java.lang.Object ref = cloudDatabaseRole_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cloudDatabaseRole_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Database role to assume while performing this action. Setting the
   * database_role will enforce additional role-based access checks on this
   * action.
   * </pre>
   *
   * <code>string cloud_database_role = 3;</code>
   *
   * @return The bytes for cloudDatabaseRole.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCloudDatabaseRoleBytes() {
    java.lang.Object ref = cloudDatabaseRole_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cloudDatabaseRole_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (paramCase_ == 1) {
      output.writeMessage(1, (com.google.protobuf.Timestamp) param_);
    }
    if (paramCase_ == 2) {
      output.writeBytes(2, (com.google.protobuf.ByteString) param_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cloudDatabaseRole_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, cloudDatabaseRole_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (paramCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.protobuf.Timestamp) param_);
    }
    if (paramCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBytesSize(
              2, (com.google.protobuf.ByteString) param_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cloudDatabaseRole_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, cloudDatabaseRole_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.executor.v1.StartBatchTransactionAction)) {
      return super.equals(obj);
    }
    com.google.spanner.executor.v1.StartBatchTransactionAction other =
        (com.google.spanner.executor.v1.StartBatchTransactionAction) obj;

    if (!getCloudDatabaseRole().equals(other.getCloudDatabaseRole())) return false;
    if (!getParamCase().equals(other.getParamCase())) return false;
    switch (paramCase_) {
      case 1:
        if (!getBatchTxnTime().equals(other.getBatchTxnTime())) return false;
        break;
      case 2:
        if (!getTid().equals(other.getTid())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CLOUD_DATABASE_ROLE_FIELD_NUMBER;
    hash = (53 * hash) + getCloudDatabaseRole().hashCode();
    switch (paramCase_) {
      case 1:
        hash = (37 * hash) + BATCH_TXN_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getBatchTxnTime().hashCode();
        break;
      case 2:
        hash = (37 * hash) + TID_FIELD_NUMBER;
        hash = (53 * hash) + getTid().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.executor.v1.StartBatchTransactionAction parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.StartBatchTransactionAction parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.StartBatchTransactionAction parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.StartBatchTransactionAction parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.StartBatchTransactionAction parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.StartBatchTransactionAction parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.StartBatchTransactionAction parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.StartBatchTransactionAction parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.StartBatchTransactionAction parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.StartBatchTransactionAction parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.StartBatchTransactionAction parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.StartBatchTransactionAction parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.spanner.executor.v1.StartBatchTransactionAction prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Starts a batch read-only transaction in executor. Successful outcomes of this
   * action will contain batch_txn_id--the identificator that can be used to start
   * the same transaction in other Executors to parallelize partition processing.
   *
   * Example of a batch read flow:
   * 1. Start batch transaction with a timestamp (StartBatchTransactionAction)
   * 2. Generate database partitions for a read or query
   * (GenerateDbPartitionsForReadAction/GenerateDbPartitionsForQueryAction)
   * 3. Call ExecutePartitionAction for some or all partitions, process rows
   * 4. Clean up the transaction (CloseBatchTransactionAction).
   *
   * More sophisticated example, with parallel processing:
   * 1. Start batch transaction with a timestamp (StartBatchTransactionAction),
   * note the returned BatchTransactionId
   * 2. Generate database partitions for a read or query
   * (GenerateDbPartitionsForReadAction/GenerateDbPartitionsForQueryAction)
   * 3. Distribute the partitions over a pool of workers, along with the
   * transaction ID.
   *
   * In each worker:
   * 4-1. StartBatchTransactionAction with the given transaction ID
   * 4-2. ExecutePartitionAction for each partition it got, process read results
   * 4-3. Close (not cleanup) the transaction (CloseBatchTransactionAction).
   *
   * When all workers are done:
   * 5. Cleanup the transaction (CloseBatchTransactionAction). This can be done
   * either by the last worker to finish the job, or by the main Executor that
   * initialized this transaction in the first place. It is also possible to clean
   * it up with a brand new Executor -- just execute StartBatchTransactionAction
   * with the ID, then clean it up right away.
   *
   * Cleaning up is optional, but recommended.
   * </pre>
   *
   * Protobuf type {@code google.spanner.executor.v1.StartBatchTransactionAction}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.executor.v1.StartBatchTransactionAction)
      com.google.spanner.executor.v1.StartBatchTransactionActionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_StartBatchTransactionAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_StartBatchTransactionAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.executor.v1.StartBatchTransactionAction.class,
              com.google.spanner.executor.v1.StartBatchTransactionAction.Builder.class);
    }

    // Construct using com.google.spanner.executor.v1.StartBatchTransactionAction.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (batchTxnTimeBuilder_ != null) {
        batchTxnTimeBuilder_.clear();
      }
      cloudDatabaseRole_ = "";
      paramCase_ = 0;
      param_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_StartBatchTransactionAction_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.StartBatchTransactionAction getDefaultInstanceForType() {
      return com.google.spanner.executor.v1.StartBatchTransactionAction.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.StartBatchTransactionAction build() {
      com.google.spanner.executor.v1.StartBatchTransactionAction result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.StartBatchTransactionAction buildPartial() {
      com.google.spanner.executor.v1.StartBatchTransactionAction result =
          new com.google.spanner.executor.v1.StartBatchTransactionAction(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.executor.v1.StartBatchTransactionAction result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.cloudDatabaseRole_ = cloudDatabaseRole_;
      }
    }

    private void buildPartialOneofs(
        com.google.spanner.executor.v1.StartBatchTransactionAction result) {
      result.paramCase_ = paramCase_;
      result.param_ = this.param_;
      if (paramCase_ == 1 && batchTxnTimeBuilder_ != null) {
        result.param_ = batchTxnTimeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.executor.v1.StartBatchTransactionAction) {
        return mergeFrom((com.google.spanner.executor.v1.StartBatchTransactionAction) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.executor.v1.StartBatchTransactionAction other) {
      if (other == com.google.spanner.executor.v1.StartBatchTransactionAction.getDefaultInstance())
        return this;
      if (!other.getCloudDatabaseRole().isEmpty()) {
        cloudDatabaseRole_ = other.cloudDatabaseRole_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      switch (other.getParamCase()) {
        case BATCH_TXN_TIME:
          {
            mergeBatchTxnTime(other.getBatchTxnTime());
            break;
          }
        case TID:
          {
            setTid(other.getTid());
            break;
          }
        case PARAM_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getBatchTxnTimeFieldBuilder().getBuilder(), extensionRegistry);
                paramCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                param_ = input.readBytes();
                paramCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                cloudDatabaseRole_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int paramCase_ = 0;
    private java.lang.Object param_;

    public ParamCase getParamCase() {
      return ParamCase.forNumber(paramCase_);
    }

    public Builder clearParam() {
      paramCase_ = 0;
      param_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        batchTxnTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The exact timestamp to start the batch transaction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp batch_txn_time = 1;</code>
     *
     * @return Whether the batchTxnTime field is set.
     */
    @java.lang.Override
    public boolean hasBatchTxnTime() {
      return paramCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * The exact timestamp to start the batch transaction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp batch_txn_time = 1;</code>
     *
     * @return The batchTxnTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getBatchTxnTime() {
      if (batchTxnTimeBuilder_ == null) {
        if (paramCase_ == 1) {
          return (com.google.protobuf.Timestamp) param_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      } else {
        if (paramCase_ == 1) {
          return batchTxnTimeBuilder_.getMessage();
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The exact timestamp to start the batch transaction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp batch_txn_time = 1;</code>
     */
    public Builder setBatchTxnTime(com.google.protobuf.Timestamp value) {
      if (batchTxnTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        param_ = value;
        onChanged();
      } else {
        batchTxnTimeBuilder_.setMessage(value);
      }
      paramCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The exact timestamp to start the batch transaction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp batch_txn_time = 1;</code>
     */
    public Builder setBatchTxnTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (batchTxnTimeBuilder_ == null) {
        param_ = builderForValue.build();
        onChanged();
      } else {
        batchTxnTimeBuilder_.setMessage(builderForValue.build());
      }
      paramCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The exact timestamp to start the batch transaction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp batch_txn_time = 1;</code>
     */
    public Builder mergeBatchTxnTime(com.google.protobuf.Timestamp value) {
      if (batchTxnTimeBuilder_ == null) {
        if (paramCase_ == 1 && param_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          param_ =
              com.google.protobuf.Timestamp.newBuilder((com.google.protobuf.Timestamp) param_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          param_ = value;
        }
        onChanged();
      } else {
        if (paramCase_ == 1) {
          batchTxnTimeBuilder_.mergeFrom(value);
        } else {
          batchTxnTimeBuilder_.setMessage(value);
        }
      }
      paramCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The exact timestamp to start the batch transaction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp batch_txn_time = 1;</code>
     */
    public Builder clearBatchTxnTime() {
      if (batchTxnTimeBuilder_ == null) {
        if (paramCase_ == 1) {
          paramCase_ = 0;
          param_ = null;
          onChanged();
        }
      } else {
        if (paramCase_ == 1) {
          paramCase_ = 0;
          param_ = null;
        }
        batchTxnTimeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The exact timestamp to start the batch transaction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp batch_txn_time = 1;</code>
     */
    public com.google.protobuf.Timestamp.Builder getBatchTxnTimeBuilder() {
      return getBatchTxnTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The exact timestamp to start the batch transaction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp batch_txn_time = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getBatchTxnTimeOrBuilder() {
      if ((paramCase_ == 1) && (batchTxnTimeBuilder_ != null)) {
        return batchTxnTimeBuilder_.getMessageOrBuilder();
      } else {
        if (paramCase_ == 1) {
          return (com.google.protobuf.Timestamp) param_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The exact timestamp to start the batch transaction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp batch_txn_time = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getBatchTxnTimeFieldBuilder() {
      if (batchTxnTimeBuilder_ == null) {
        if (!(paramCase_ == 1)) {
          param_ = com.google.protobuf.Timestamp.getDefaultInstance();
        }
        batchTxnTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                (com.google.protobuf.Timestamp) param_, getParentForChildren(), isClean());
        param_ = null;
      }
      paramCase_ = 1;
      onChanged();
      return batchTxnTimeBuilder_;
    }

    /**
     *
     *
     * <pre>
     * ID of a batch read-only transaction. It can be used to start the same
     * batch transaction on multiple executors and parallelize partition
     * processing.
     * </pre>
     *
     * <code>bytes tid = 2;</code>
     *
     * @return Whether the tid field is set.
     */
    public boolean hasTid() {
      return paramCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * ID of a batch read-only transaction. It can be used to start the same
     * batch transaction on multiple executors and parallelize partition
     * processing.
     * </pre>
     *
     * <code>bytes tid = 2;</code>
     *
     * @return The tid.
     */
    public com.google.protobuf.ByteString getTid() {
      if (paramCase_ == 2) {
        return (com.google.protobuf.ByteString) param_;
      }
      return com.google.protobuf.ByteString.EMPTY;
    }
    /**
     *
     *
     * <pre>
     * ID of a batch read-only transaction. It can be used to start the same
     * batch transaction on multiple executors and parallelize partition
     * processing.
     * </pre>
     *
     * <code>bytes tid = 2;</code>
     *
     * @param value The tid to set.
     * @return This builder for chaining.
     */
    public Builder setTid(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      paramCase_ = 2;
      param_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ID of a batch read-only transaction. It can be used to start the same
     * batch transaction on multiple executors and parallelize partition
     * processing.
     * </pre>
     *
     * <code>bytes tid = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTid() {
      if (paramCase_ == 2) {
        paramCase_ = 0;
        param_ = null;
        onChanged();
      }
      return this;
    }

    private java.lang.Object cloudDatabaseRole_ = "";
    /**
     *
     *
     * <pre>
     * Database role to assume while performing this action. Setting the
     * database_role will enforce additional role-based access checks on this
     * action.
     * </pre>
     *
     * <code>string cloud_database_role = 3;</code>
     *
     * @return The cloudDatabaseRole.
     */
    public java.lang.String getCloudDatabaseRole() {
      java.lang.Object ref = cloudDatabaseRole_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cloudDatabaseRole_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Database role to assume while performing this action. Setting the
     * database_role will enforce additional role-based access checks on this
     * action.
     * </pre>
     *
     * <code>string cloud_database_role = 3;</code>
     *
     * @return The bytes for cloudDatabaseRole.
     */
    public com.google.protobuf.ByteString getCloudDatabaseRoleBytes() {
      java.lang.Object ref = cloudDatabaseRole_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cloudDatabaseRole_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Database role to assume while performing this action. Setting the
     * database_role will enforce additional role-based access checks on this
     * action.
     * </pre>
     *
     * <code>string cloud_database_role = 3;</code>
     *
     * @param value The cloudDatabaseRole to set.
     * @return This builder for chaining.
     */
    public Builder setCloudDatabaseRole(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cloudDatabaseRole_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Database role to assume while performing this action. Setting the
     * database_role will enforce additional role-based access checks on this
     * action.
     * </pre>
     *
     * <code>string cloud_database_role = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCloudDatabaseRole() {
      cloudDatabaseRole_ = getDefaultInstance().getCloudDatabaseRole();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Database role to assume while performing this action. Setting the
     * database_role will enforce additional role-based access checks on this
     * action.
     * </pre>
     *
     * <code>string cloud_database_role = 3;</code>
     *
     * @param value The bytes for cloudDatabaseRole to set.
     * @return This builder for chaining.
     */
    public Builder setCloudDatabaseRoleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cloudDatabaseRole_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.executor.v1.StartBatchTransactionAction)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.executor.v1.StartBatchTransactionAction)
  private static final com.google.spanner.executor.v1.StartBatchTransactionAction DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.executor.v1.StartBatchTransactionAction();
  }

  public static com.google.spanner.executor.v1.StartBatchTransactionAction getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StartBatchTransactionAction> PARSER =
      new com.google.protobuf.AbstractParser<StartBatchTransactionAction>() {
        @java.lang.Override
        public StartBatchTransactionAction parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StartBatchTransactionAction> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StartBatchTransactionAction> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.executor.v1.StartBatchTransactionAction getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
