/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/executor/v1/cloud_executor.proto

// Protobuf Java Version: 3.25.3
package com.google.spanner.executor.v1;

/**
 *
 *
 * <pre>
 * Value represents a single value that can be read or written to/from
 * Spanner.
 * </pre>
 *
 * Protobuf type {@code google.spanner.executor.v1.Value}
 */
public final class Value extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.executor.v1.Value)
    ValueOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Value.newBuilder() to construct.
  private Value(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Value() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Value();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_Value_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_Value_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.executor.v1.Value.class,
            com.google.spanner.executor.v1.Value.Builder.class);
  }

  private int bitField0_;
  private int valueTypeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object valueType_;

  public enum ValueTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    IS_NULL(1),
    INT_VALUE(2),
    BOOL_VALUE(3),
    DOUBLE_VALUE(4),
    BYTES_VALUE(5),
    STRING_VALUE(6),
    STRUCT_VALUE(7),
    TIMESTAMP_VALUE(8),
    DATE_DAYS_VALUE(9),
    IS_COMMIT_TIMESTAMP(10),
    ARRAY_VALUE(11),
    VALUETYPE_NOT_SET(0);
    private final int value;

    private ValueTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ValueTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static ValueTypeCase forNumber(int value) {
      switch (value) {
        case 1:
          return IS_NULL;
        case 2:
          return INT_VALUE;
        case 3:
          return BOOL_VALUE;
        case 4:
          return DOUBLE_VALUE;
        case 5:
          return BYTES_VALUE;
        case 6:
          return STRING_VALUE;
        case 7:
          return STRUCT_VALUE;
        case 8:
          return TIMESTAMP_VALUE;
        case 9:
          return DATE_DAYS_VALUE;
        case 10:
          return IS_COMMIT_TIMESTAMP;
        case 11:
          return ARRAY_VALUE;
        case 0:
          return VALUETYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ValueTypeCase getValueTypeCase() {
    return ValueTypeCase.forNumber(valueTypeCase_);
  }

  public static final int IS_NULL_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * If is_null is set, then this value is null.
   * </pre>
   *
   * <code>bool is_null = 1;</code>
   *
   * @return Whether the isNull field is set.
   */
  @java.lang.Override
  public boolean hasIsNull() {
    return valueTypeCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * If is_null is set, then this value is null.
   * </pre>
   *
   * <code>bool is_null = 1;</code>
   *
   * @return The isNull.
   */
  @java.lang.Override
  public boolean getIsNull() {
    if (valueTypeCase_ == 1) {
      return (java.lang.Boolean) valueType_;
    }
    return false;
  }

  public static final int INT_VALUE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Int type value. It's used for all integer number types, like int32 and
   * int64.
   * </pre>
   *
   * <code>int64 int_value = 2;</code>
   *
   * @return Whether the intValue field is set.
   */
  @java.lang.Override
  public boolean hasIntValue() {
    return valueTypeCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Int type value. It's used for all integer number types, like int32 and
   * int64.
   * </pre>
   *
   * <code>int64 int_value = 2;</code>
   *
   * @return The intValue.
   */
  @java.lang.Override
  public long getIntValue() {
    if (valueTypeCase_ == 2) {
      return (java.lang.Long) valueType_;
    }
    return 0L;
  }

  public static final int BOOL_VALUE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Bool type value.
   * </pre>
   *
   * <code>bool bool_value = 3;</code>
   *
   * @return Whether the boolValue field is set.
   */
  @java.lang.Override
  public boolean hasBoolValue() {
    return valueTypeCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Bool type value.
   * </pre>
   *
   * <code>bool bool_value = 3;</code>
   *
   * @return The boolValue.
   */
  @java.lang.Override
  public boolean getBoolValue() {
    if (valueTypeCase_ == 3) {
      return (java.lang.Boolean) valueType_;
    }
    return false;
  }

  public static final int DOUBLE_VALUE_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Double type value. It's used for all float point types, like float and
   * double.
   * </pre>
   *
   * <code>double double_value = 4;</code>
   *
   * @return Whether the doubleValue field is set.
   */
  @java.lang.Override
  public boolean hasDoubleValue() {
    return valueTypeCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Double type value. It's used for all float point types, like float and
   * double.
   * </pre>
   *
   * <code>double double_value = 4;</code>
   *
   * @return The doubleValue.
   */
  @java.lang.Override
  public double getDoubleValue() {
    if (valueTypeCase_ == 4) {
      return (java.lang.Double) valueType_;
    }
    return 0D;
  }

  public static final int BYTES_VALUE_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Bytes type value, stored in CORD. It's also used for PROTO type value.
   * </pre>
   *
   * <code>bytes bytes_value = 5;</code>
   *
   * @return Whether the bytesValue field is set.
   */
  @java.lang.Override
  public boolean hasBytesValue() {
    return valueTypeCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Bytes type value, stored in CORD. It's also used for PROTO type value.
   * </pre>
   *
   * <code>bytes bytes_value = 5;</code>
   *
   * @return The bytesValue.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBytesValue() {
    if (valueTypeCase_ == 5) {
      return (com.google.protobuf.ByteString) valueType_;
    }
    return com.google.protobuf.ByteString.EMPTY;
  }

  public static final int STRING_VALUE_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * String type value, stored in CORD.
   * </pre>
   *
   * <code>string string_value = 6;</code>
   *
   * @return Whether the stringValue field is set.
   */
  public boolean hasStringValue() {
    return valueTypeCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * String type value, stored in CORD.
   * </pre>
   *
   * <code>string string_value = 6;</code>
   *
   * @return The stringValue.
   */
  public java.lang.String getStringValue() {
    java.lang.Object ref = "";
    if (valueTypeCase_ == 6) {
      ref = valueType_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (valueTypeCase_ == 6) {
        valueType_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * String type value, stored in CORD.
   * </pre>
   *
   * <code>string string_value = 6;</code>
   *
   * @return The bytes for stringValue.
   */
  public com.google.protobuf.ByteString getStringValueBytes() {
    java.lang.Object ref = "";
    if (valueTypeCase_ == 6) {
      ref = valueType_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (valueTypeCase_ == 6) {
        valueType_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STRUCT_VALUE_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Struct type value. It contains a ValueList representing the values in
   * this struct.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ValueList struct_value = 7;</code>
   *
   * @return Whether the structValue field is set.
   */
  @java.lang.Override
  public boolean hasStructValue() {
    return valueTypeCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Struct type value. It contains a ValueList representing the values in
   * this struct.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ValueList struct_value = 7;</code>
   *
   * @return The structValue.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ValueList getStructValue() {
    if (valueTypeCase_ == 7) {
      return (com.google.spanner.executor.v1.ValueList) valueType_;
    }
    return com.google.spanner.executor.v1.ValueList.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Struct type value. It contains a ValueList representing the values in
   * this struct.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ValueList struct_value = 7;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ValueListOrBuilder getStructValueOrBuilder() {
    if (valueTypeCase_ == 7) {
      return (com.google.spanner.executor.v1.ValueList) valueType_;
    }
    return com.google.spanner.executor.v1.ValueList.getDefaultInstance();
  }

  public static final int TIMESTAMP_VALUE_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Timestamp type value.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp timestamp_value = 8;</code>
   *
   * @return Whether the timestampValue field is set.
   */
  @java.lang.Override
  public boolean hasTimestampValue() {
    return valueTypeCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * Timestamp type value.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp timestamp_value = 8;</code>
   *
   * @return The timestampValue.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getTimestampValue() {
    if (valueTypeCase_ == 8) {
      return (com.google.protobuf.Timestamp) valueType_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Timestamp type value.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp timestamp_value = 8;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getTimestampValueOrBuilder() {
    if (valueTypeCase_ == 8) {
      return (com.google.protobuf.Timestamp) valueType_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }

  public static final int DATE_DAYS_VALUE_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Date type value. Date is specified as a number of days since Unix epoch.
   * </pre>
   *
   * <code>int32 date_days_value = 9;</code>
   *
   * @return Whether the dateDaysValue field is set.
   */
  @java.lang.Override
  public boolean hasDateDaysValue() {
    return valueTypeCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Date type value. Date is specified as a number of days since Unix epoch.
   * </pre>
   *
   * <code>int32 date_days_value = 9;</code>
   *
   * @return The dateDaysValue.
   */
  @java.lang.Override
  public int getDateDaysValue() {
    if (valueTypeCase_ == 9) {
      return (java.lang.Integer) valueType_;
    }
    return 0;
  }

  public static final int IS_COMMIT_TIMESTAMP_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * If set, holds the sentinel value for the transaction CommitTimestamp.
   * </pre>
   *
   * <code>bool is_commit_timestamp = 10;</code>
   *
   * @return Whether the isCommitTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasIsCommitTimestamp() {
    return valueTypeCase_ == 10;
  }
  /**
   *
   *
   * <pre>
   * If set, holds the sentinel value for the transaction CommitTimestamp.
   * </pre>
   *
   * <code>bool is_commit_timestamp = 10;</code>
   *
   * @return The isCommitTimestamp.
   */
  @java.lang.Override
  public boolean getIsCommitTimestamp() {
    if (valueTypeCase_ == 10) {
      return (java.lang.Boolean) valueType_;
    }
    return false;
  }

  public static final int ARRAY_VALUE_FIELD_NUMBER = 11;
  /**
   *
   *
   * <pre>
   * Array type value. The underlying Valuelist should have values that have
   * the same type.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ValueList array_value = 11;</code>
   *
   * @return Whether the arrayValue field is set.
   */
  @java.lang.Override
  public boolean hasArrayValue() {
    return valueTypeCase_ == 11;
  }
  /**
   *
   *
   * <pre>
   * Array type value. The underlying Valuelist should have values that have
   * the same type.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ValueList array_value = 11;</code>
   *
   * @return The arrayValue.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ValueList getArrayValue() {
    if (valueTypeCase_ == 11) {
      return (com.google.spanner.executor.v1.ValueList) valueType_;
    }
    return com.google.spanner.executor.v1.ValueList.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Array type value. The underlying Valuelist should have values that have
   * the same type.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ValueList array_value = 11;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ValueListOrBuilder getArrayValueOrBuilder() {
    if (valueTypeCase_ == 11) {
      return (com.google.spanner.executor.v1.ValueList) valueType_;
    }
    return com.google.spanner.executor.v1.ValueList.getDefaultInstance();
  }

  public static final int ARRAY_TYPE_FIELD_NUMBER = 12;
  private com.google.spanner.v1.Type arrayType_;
  /**
   *
   *
   * <pre>
   * Type of array element. Only set if value is an array.
   * </pre>
   *
   * <code>optional .google.spanner.v1.Type array_type = 12;</code>
   *
   * @return Whether the arrayType field is set.
   */
  @java.lang.Override
  public boolean hasArrayType() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Type of array element. Only set if value is an array.
   * </pre>
   *
   * <code>optional .google.spanner.v1.Type array_type = 12;</code>
   *
   * @return The arrayType.
   */
  @java.lang.Override
  public com.google.spanner.v1.Type getArrayType() {
    return arrayType_ == null ? com.google.spanner.v1.Type.getDefaultInstance() : arrayType_;
  }
  /**
   *
   *
   * <pre>
   * Type of array element. Only set if value is an array.
   * </pre>
   *
   * <code>optional .google.spanner.v1.Type array_type = 12;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.TypeOrBuilder getArrayTypeOrBuilder() {
    return arrayType_ == null ? com.google.spanner.v1.Type.getDefaultInstance() : arrayType_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (valueTypeCase_ == 1) {
      output.writeBool(1, (boolean) ((java.lang.Boolean) valueType_));
    }
    if (valueTypeCase_ == 2) {
      output.writeInt64(2, (long) ((java.lang.Long) valueType_));
    }
    if (valueTypeCase_ == 3) {
      output.writeBool(3, (boolean) ((java.lang.Boolean) valueType_));
    }
    if (valueTypeCase_ == 4) {
      output.writeDouble(4, (double) ((java.lang.Double) valueType_));
    }
    if (valueTypeCase_ == 5) {
      output.writeBytes(5, (com.google.protobuf.ByteString) valueType_);
    }
    if (valueTypeCase_ == 6) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, valueType_);
    }
    if (valueTypeCase_ == 7) {
      output.writeMessage(7, (com.google.spanner.executor.v1.ValueList) valueType_);
    }
    if (valueTypeCase_ == 8) {
      output.writeMessage(8, (com.google.protobuf.Timestamp) valueType_);
    }
    if (valueTypeCase_ == 9) {
      output.writeInt32(9, (int) ((java.lang.Integer) valueType_));
    }
    if (valueTypeCase_ == 10) {
      output.writeBool(10, (boolean) ((java.lang.Boolean) valueType_));
    }
    if (valueTypeCase_ == 11) {
      output.writeMessage(11, (com.google.spanner.executor.v1.ValueList) valueType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(12, getArrayType());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (valueTypeCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              1, (boolean) ((java.lang.Boolean) valueType_));
    }
    if (valueTypeCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(
              2, (long) ((java.lang.Long) valueType_));
    }
    if (valueTypeCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              3, (boolean) ((java.lang.Boolean) valueType_));
    }
    if (valueTypeCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeDoubleSize(
              4, (double) ((java.lang.Double) valueType_));
    }
    if (valueTypeCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBytesSize(
              5, (com.google.protobuf.ByteString) valueType_);
    }
    if (valueTypeCase_ == 6) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, valueType_);
    }
    if (valueTypeCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.spanner.executor.v1.ValueList) valueType_);
    }
    if (valueTypeCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.protobuf.Timestamp) valueType_);
    }
    if (valueTypeCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              9, (int) ((java.lang.Integer) valueType_));
    }
    if (valueTypeCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              10, (boolean) ((java.lang.Boolean) valueType_));
    }
    if (valueTypeCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, (com.google.spanner.executor.v1.ValueList) valueType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getArrayType());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.executor.v1.Value)) {
      return super.equals(obj);
    }
    com.google.spanner.executor.v1.Value other = (com.google.spanner.executor.v1.Value) obj;

    if (hasArrayType() != other.hasArrayType()) return false;
    if (hasArrayType()) {
      if (!getArrayType().equals(other.getArrayType())) return false;
    }
    if (!getValueTypeCase().equals(other.getValueTypeCase())) return false;
    switch (valueTypeCase_) {
      case 1:
        if (getIsNull() != other.getIsNull()) return false;
        break;
      case 2:
        if (getIntValue() != other.getIntValue()) return false;
        break;
      case 3:
        if (getBoolValue() != other.getBoolValue()) return false;
        break;
      case 4:
        if (java.lang.Double.doubleToLongBits(getDoubleValue())
            != java.lang.Double.doubleToLongBits(other.getDoubleValue())) return false;
        break;
      case 5:
        if (!getBytesValue().equals(other.getBytesValue())) return false;
        break;
      case 6:
        if (!getStringValue().equals(other.getStringValue())) return false;
        break;
      case 7:
        if (!getStructValue().equals(other.getStructValue())) return false;
        break;
      case 8:
        if (!getTimestampValue().equals(other.getTimestampValue())) return false;
        break;
      case 9:
        if (getDateDaysValue() != other.getDateDaysValue()) return false;
        break;
      case 10:
        if (getIsCommitTimestamp() != other.getIsCommitTimestamp()) return false;
        break;
      case 11:
        if (!getArrayValue().equals(other.getArrayValue())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasArrayType()) {
      hash = (37 * hash) + ARRAY_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getArrayType().hashCode();
    }
    switch (valueTypeCase_) {
      case 1:
        hash = (37 * hash) + IS_NULL_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsNull());
        break;
      case 2:
        hash = (37 * hash) + INT_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIntValue());
        break;
      case 3:
        hash = (37 * hash) + BOOL_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getBoolValue());
        break;
      case 4:
        hash = (37 * hash) + DOUBLE_VALUE_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getDoubleValue()));
        break;
      case 5:
        hash = (37 * hash) + BYTES_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getBytesValue().hashCode();
        break;
      case 6:
        hash = (37 * hash) + STRING_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getStringValue().hashCode();
        break;
      case 7:
        hash = (37 * hash) + STRUCT_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getStructValue().hashCode();
        break;
      case 8:
        hash = (37 * hash) + TIMESTAMP_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getTimestampValue().hashCode();
        break;
      case 9:
        hash = (37 * hash) + DATE_DAYS_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getDateDaysValue();
        break;
      case 10:
        hash = (37 * hash) + IS_COMMIT_TIMESTAMP_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsCommitTimestamp());
        break;
      case 11:
        hash = (37 * hash) + ARRAY_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getArrayValue().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.executor.v1.Value parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.Value parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.Value parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.Value parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.Value parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.Value parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.Value parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.Value parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.Value parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.Value parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.Value parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.Value parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.executor.v1.Value prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Value represents a single value that can be read or written to/from
   * Spanner.
   * </pre>
   *
   * Protobuf type {@code google.spanner.executor.v1.Value}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.executor.v1.Value)
      com.google.spanner.executor.v1.ValueOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_Value_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_Value_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.executor.v1.Value.class,
              com.google.spanner.executor.v1.Value.Builder.class);
    }

    // Construct using com.google.spanner.executor.v1.Value.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getArrayTypeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (structValueBuilder_ != null) {
        structValueBuilder_.clear();
      }
      if (timestampValueBuilder_ != null) {
        timestampValueBuilder_.clear();
      }
      if (arrayValueBuilder_ != null) {
        arrayValueBuilder_.clear();
      }
      arrayType_ = null;
      if (arrayTypeBuilder_ != null) {
        arrayTypeBuilder_.dispose();
        arrayTypeBuilder_ = null;
      }
      valueTypeCase_ = 0;
      valueType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_Value_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.Value getDefaultInstanceForType() {
      return com.google.spanner.executor.v1.Value.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.Value build() {
      com.google.spanner.executor.v1.Value result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.Value buildPartial() {
      com.google.spanner.executor.v1.Value result = new com.google.spanner.executor.v1.Value(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.executor.v1.Value result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.arrayType_ = arrayTypeBuilder_ == null ? arrayType_ : arrayTypeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.spanner.executor.v1.Value result) {
      result.valueTypeCase_ = valueTypeCase_;
      result.valueType_ = this.valueType_;
      if (valueTypeCase_ == 7 && structValueBuilder_ != null) {
        result.valueType_ = structValueBuilder_.build();
      }
      if (valueTypeCase_ == 8 && timestampValueBuilder_ != null) {
        result.valueType_ = timestampValueBuilder_.build();
      }
      if (valueTypeCase_ == 11 && arrayValueBuilder_ != null) {
        result.valueType_ = arrayValueBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.executor.v1.Value) {
        return mergeFrom((com.google.spanner.executor.v1.Value) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.executor.v1.Value other) {
      if (other == com.google.spanner.executor.v1.Value.getDefaultInstance()) return this;
      if (other.hasArrayType()) {
        mergeArrayType(other.getArrayType());
      }
      switch (other.getValueTypeCase()) {
        case IS_NULL:
          {
            setIsNull(other.getIsNull());
            break;
          }
        case INT_VALUE:
          {
            setIntValue(other.getIntValue());
            break;
          }
        case BOOL_VALUE:
          {
            setBoolValue(other.getBoolValue());
            break;
          }
        case DOUBLE_VALUE:
          {
            setDoubleValue(other.getDoubleValue());
            break;
          }
        case BYTES_VALUE:
          {
            setBytesValue(other.getBytesValue());
            break;
          }
        case STRING_VALUE:
          {
            valueTypeCase_ = 6;
            valueType_ = other.valueType_;
            onChanged();
            break;
          }
        case STRUCT_VALUE:
          {
            mergeStructValue(other.getStructValue());
            break;
          }
        case TIMESTAMP_VALUE:
          {
            mergeTimestampValue(other.getTimestampValue());
            break;
          }
        case DATE_DAYS_VALUE:
          {
            setDateDaysValue(other.getDateDaysValue());
            break;
          }
        case IS_COMMIT_TIMESTAMP:
          {
            setIsCommitTimestamp(other.getIsCommitTimestamp());
            break;
          }
        case ARRAY_VALUE:
          {
            mergeArrayValue(other.getArrayValue());
            break;
          }
        case VALUETYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                valueType_ = input.readBool();
                valueTypeCase_ = 1;
                break;
              } // case 8
            case 16:
              {
                valueType_ = input.readInt64();
                valueTypeCase_ = 2;
                break;
              } // case 16
            case 24:
              {
                valueType_ = input.readBool();
                valueTypeCase_ = 3;
                break;
              } // case 24
            case 33:
              {
                valueType_ = input.readDouble();
                valueTypeCase_ = 4;
                break;
              } // case 33
            case 42:
              {
                valueType_ = input.readBytes();
                valueTypeCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                valueTypeCase_ = 6;
                valueType_ = s;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getStructValueFieldBuilder().getBuilder(), extensionRegistry);
                valueTypeCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getTimestampValueFieldBuilder().getBuilder(), extensionRegistry);
                valueTypeCase_ = 8;
                break;
              } // case 66
            case 72:
              {
                valueType_ = input.readInt32();
                valueTypeCase_ = 9;
                break;
              } // case 72
            case 80:
              {
                valueType_ = input.readBool();
                valueTypeCase_ = 10;
                break;
              } // case 80
            case 90:
              {
                input.readMessage(getArrayValueFieldBuilder().getBuilder(), extensionRegistry);
                valueTypeCase_ = 11;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getArrayTypeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 98
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int valueTypeCase_ = 0;
    private java.lang.Object valueType_;

    public ValueTypeCase getValueTypeCase() {
      return ValueTypeCase.forNumber(valueTypeCase_);
    }

    public Builder clearValueType() {
      valueTypeCase_ = 0;
      valueType_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * If is_null is set, then this value is null.
     * </pre>
     *
     * <code>bool is_null = 1;</code>
     *
     * @return Whether the isNull field is set.
     */
    public boolean hasIsNull() {
      return valueTypeCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * If is_null is set, then this value is null.
     * </pre>
     *
     * <code>bool is_null = 1;</code>
     *
     * @return The isNull.
     */
    public boolean getIsNull() {
      if (valueTypeCase_ == 1) {
        return (java.lang.Boolean) valueType_;
      }
      return false;
    }
    /**
     *
     *
     * <pre>
     * If is_null is set, then this value is null.
     * </pre>
     *
     * <code>bool is_null = 1;</code>
     *
     * @param value The isNull to set.
     * @return This builder for chaining.
     */
    public Builder setIsNull(boolean value) {

      valueTypeCase_ = 1;
      valueType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If is_null is set, then this value is null.
     * </pre>
     *
     * <code>bool is_null = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIsNull() {
      if (valueTypeCase_ == 1) {
        valueTypeCase_ = 0;
        valueType_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Int type value. It's used for all integer number types, like int32 and
     * int64.
     * </pre>
     *
     * <code>int64 int_value = 2;</code>
     *
     * @return Whether the intValue field is set.
     */
    public boolean hasIntValue() {
      return valueTypeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Int type value. It's used for all integer number types, like int32 and
     * int64.
     * </pre>
     *
     * <code>int64 int_value = 2;</code>
     *
     * @return The intValue.
     */
    public long getIntValue() {
      if (valueTypeCase_ == 2) {
        return (java.lang.Long) valueType_;
      }
      return 0L;
    }
    /**
     *
     *
     * <pre>
     * Int type value. It's used for all integer number types, like int32 and
     * int64.
     * </pre>
     *
     * <code>int64 int_value = 2;</code>
     *
     * @param value The intValue to set.
     * @return This builder for chaining.
     */
    public Builder setIntValue(long value) {

      valueTypeCase_ = 2;
      valueType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Int type value. It's used for all integer number types, like int32 and
     * int64.
     * </pre>
     *
     * <code>int64 int_value = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIntValue() {
      if (valueTypeCase_ == 2) {
        valueTypeCase_ = 0;
        valueType_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Bool type value.
     * </pre>
     *
     * <code>bool bool_value = 3;</code>
     *
     * @return Whether the boolValue field is set.
     */
    public boolean hasBoolValue() {
      return valueTypeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Bool type value.
     * </pre>
     *
     * <code>bool bool_value = 3;</code>
     *
     * @return The boolValue.
     */
    public boolean getBoolValue() {
      if (valueTypeCase_ == 3) {
        return (java.lang.Boolean) valueType_;
      }
      return false;
    }
    /**
     *
     *
     * <pre>
     * Bool type value.
     * </pre>
     *
     * <code>bool bool_value = 3;</code>
     *
     * @param value The boolValue to set.
     * @return This builder for chaining.
     */
    public Builder setBoolValue(boolean value) {

      valueTypeCase_ = 3;
      valueType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Bool type value.
     * </pre>
     *
     * <code>bool bool_value = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBoolValue() {
      if (valueTypeCase_ == 3) {
        valueTypeCase_ = 0;
        valueType_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Double type value. It's used for all float point types, like float and
     * double.
     * </pre>
     *
     * <code>double double_value = 4;</code>
     *
     * @return Whether the doubleValue field is set.
     */
    public boolean hasDoubleValue() {
      return valueTypeCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Double type value. It's used for all float point types, like float and
     * double.
     * </pre>
     *
     * <code>double double_value = 4;</code>
     *
     * @return The doubleValue.
     */
    public double getDoubleValue() {
      if (valueTypeCase_ == 4) {
        return (java.lang.Double) valueType_;
      }
      return 0D;
    }
    /**
     *
     *
     * <pre>
     * Double type value. It's used for all float point types, like float and
     * double.
     * </pre>
     *
     * <code>double double_value = 4;</code>
     *
     * @param value The doubleValue to set.
     * @return This builder for chaining.
     */
    public Builder setDoubleValue(double value) {

      valueTypeCase_ = 4;
      valueType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Double type value. It's used for all float point types, like float and
     * double.
     * </pre>
     *
     * <code>double double_value = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDoubleValue() {
      if (valueTypeCase_ == 4) {
        valueTypeCase_ = 0;
        valueType_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Bytes type value, stored in CORD. It's also used for PROTO type value.
     * </pre>
     *
     * <code>bytes bytes_value = 5;</code>
     *
     * @return Whether the bytesValue field is set.
     */
    public boolean hasBytesValue() {
      return valueTypeCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Bytes type value, stored in CORD. It's also used for PROTO type value.
     * </pre>
     *
     * <code>bytes bytes_value = 5;</code>
     *
     * @return The bytesValue.
     */
    public com.google.protobuf.ByteString getBytesValue() {
      if (valueTypeCase_ == 5) {
        return (com.google.protobuf.ByteString) valueType_;
      }
      return com.google.protobuf.ByteString.EMPTY;
    }
    /**
     *
     *
     * <pre>
     * Bytes type value, stored in CORD. It's also used for PROTO type value.
     * </pre>
     *
     * <code>bytes bytes_value = 5;</code>
     *
     * @param value The bytesValue to set.
     * @return This builder for chaining.
     */
    public Builder setBytesValue(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      valueTypeCase_ = 5;
      valueType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Bytes type value, stored in CORD. It's also used for PROTO type value.
     * </pre>
     *
     * <code>bytes bytes_value = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBytesValue() {
      if (valueTypeCase_ == 5) {
        valueTypeCase_ = 0;
        valueType_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * String type value, stored in CORD.
     * </pre>
     *
     * <code>string string_value = 6;</code>
     *
     * @return Whether the stringValue field is set.
     */
    @java.lang.Override
    public boolean hasStringValue() {
      return valueTypeCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * String type value, stored in CORD.
     * </pre>
     *
     * <code>string string_value = 6;</code>
     *
     * @return The stringValue.
     */
    @java.lang.Override
    public java.lang.String getStringValue() {
      java.lang.Object ref = "";
      if (valueTypeCase_ == 6) {
        ref = valueType_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (valueTypeCase_ == 6) {
          valueType_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * String type value, stored in CORD.
     * </pre>
     *
     * <code>string string_value = 6;</code>
     *
     * @return The bytes for stringValue.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getStringValueBytes() {
      java.lang.Object ref = "";
      if (valueTypeCase_ == 6) {
        ref = valueType_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (valueTypeCase_ == 6) {
          valueType_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * String type value, stored in CORD.
     * </pre>
     *
     * <code>string string_value = 6;</code>
     *
     * @param value The stringValue to set.
     * @return This builder for chaining.
     */
    public Builder setStringValue(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      valueTypeCase_ = 6;
      valueType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * String type value, stored in CORD.
     * </pre>
     *
     * <code>string string_value = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStringValue() {
      if (valueTypeCase_ == 6) {
        valueTypeCase_ = 0;
        valueType_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * String type value, stored in CORD.
     * </pre>
     *
     * <code>string string_value = 6;</code>
     *
     * @param value The bytes for stringValue to set.
     * @return This builder for chaining.
     */
    public Builder setStringValueBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      valueTypeCase_ = 6;
      valueType_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ValueList,
            com.google.spanner.executor.v1.ValueList.Builder,
            com.google.spanner.executor.v1.ValueListOrBuilder>
        structValueBuilder_;
    /**
     *
     *
     * <pre>
     * Struct type value. It contains a ValueList representing the values in
     * this struct.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList struct_value = 7;</code>
     *
     * @return Whether the structValue field is set.
     */
    @java.lang.Override
    public boolean hasStructValue() {
      return valueTypeCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Struct type value. It contains a ValueList representing the values in
     * this struct.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList struct_value = 7;</code>
     *
     * @return The structValue.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.ValueList getStructValue() {
      if (structValueBuilder_ == null) {
        if (valueTypeCase_ == 7) {
          return (com.google.spanner.executor.v1.ValueList) valueType_;
        }
        return com.google.spanner.executor.v1.ValueList.getDefaultInstance();
      } else {
        if (valueTypeCase_ == 7) {
          return structValueBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.ValueList.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Struct type value. It contains a ValueList representing the values in
     * this struct.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList struct_value = 7;</code>
     */
    public Builder setStructValue(com.google.spanner.executor.v1.ValueList value) {
      if (structValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        valueType_ = value;
        onChanged();
      } else {
        structValueBuilder_.setMessage(value);
      }
      valueTypeCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Struct type value. It contains a ValueList representing the values in
     * this struct.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList struct_value = 7;</code>
     */
    public Builder setStructValue(
        com.google.spanner.executor.v1.ValueList.Builder builderForValue) {
      if (structValueBuilder_ == null) {
        valueType_ = builderForValue.build();
        onChanged();
      } else {
        structValueBuilder_.setMessage(builderForValue.build());
      }
      valueTypeCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Struct type value. It contains a ValueList representing the values in
     * this struct.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList struct_value = 7;</code>
     */
    public Builder mergeStructValue(com.google.spanner.executor.v1.ValueList value) {
      if (structValueBuilder_ == null) {
        if (valueTypeCase_ == 7
            && valueType_ != com.google.spanner.executor.v1.ValueList.getDefaultInstance()) {
          valueType_ =
              com.google.spanner.executor.v1.ValueList.newBuilder(
                      (com.google.spanner.executor.v1.ValueList) valueType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          valueType_ = value;
        }
        onChanged();
      } else {
        if (valueTypeCase_ == 7) {
          structValueBuilder_.mergeFrom(value);
        } else {
          structValueBuilder_.setMessage(value);
        }
      }
      valueTypeCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Struct type value. It contains a ValueList representing the values in
     * this struct.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList struct_value = 7;</code>
     */
    public Builder clearStructValue() {
      if (structValueBuilder_ == null) {
        if (valueTypeCase_ == 7) {
          valueTypeCase_ = 0;
          valueType_ = null;
          onChanged();
        }
      } else {
        if (valueTypeCase_ == 7) {
          valueTypeCase_ = 0;
          valueType_ = null;
        }
        structValueBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Struct type value. It contains a ValueList representing the values in
     * this struct.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList struct_value = 7;</code>
     */
    public com.google.spanner.executor.v1.ValueList.Builder getStructValueBuilder() {
      return getStructValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Struct type value. It contains a ValueList representing the values in
     * this struct.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList struct_value = 7;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.ValueListOrBuilder getStructValueOrBuilder() {
      if ((valueTypeCase_ == 7) && (structValueBuilder_ != null)) {
        return structValueBuilder_.getMessageOrBuilder();
      } else {
        if (valueTypeCase_ == 7) {
          return (com.google.spanner.executor.v1.ValueList) valueType_;
        }
        return com.google.spanner.executor.v1.ValueList.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Struct type value. It contains a ValueList representing the values in
     * this struct.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList struct_value = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ValueList,
            com.google.spanner.executor.v1.ValueList.Builder,
            com.google.spanner.executor.v1.ValueListOrBuilder>
        getStructValueFieldBuilder() {
      if (structValueBuilder_ == null) {
        if (!(valueTypeCase_ == 7)) {
          valueType_ = com.google.spanner.executor.v1.ValueList.getDefaultInstance();
        }
        structValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.ValueList,
                com.google.spanner.executor.v1.ValueList.Builder,
                com.google.spanner.executor.v1.ValueListOrBuilder>(
                (com.google.spanner.executor.v1.ValueList) valueType_,
                getParentForChildren(),
                isClean());
        valueType_ = null;
      }
      valueTypeCase_ = 7;
      onChanged();
      return structValueBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        timestampValueBuilder_;
    /**
     *
     *
     * <pre>
     * Timestamp type value.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 8;</code>
     *
     * @return Whether the timestampValue field is set.
     */
    @java.lang.Override
    public boolean hasTimestampValue() {
      return valueTypeCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Timestamp type value.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 8;</code>
     *
     * @return The timestampValue.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getTimestampValue() {
      if (timestampValueBuilder_ == null) {
        if (valueTypeCase_ == 8) {
          return (com.google.protobuf.Timestamp) valueType_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      } else {
        if (valueTypeCase_ == 8) {
          return timestampValueBuilder_.getMessage();
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Timestamp type value.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 8;</code>
     */
    public Builder setTimestampValue(com.google.protobuf.Timestamp value) {
      if (timestampValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        valueType_ = value;
        onChanged();
      } else {
        timestampValueBuilder_.setMessage(value);
      }
      valueTypeCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp type value.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 8;</code>
     */
    public Builder setTimestampValue(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (timestampValueBuilder_ == null) {
        valueType_ = builderForValue.build();
        onChanged();
      } else {
        timestampValueBuilder_.setMessage(builderForValue.build());
      }
      valueTypeCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp type value.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 8;</code>
     */
    public Builder mergeTimestampValue(com.google.protobuf.Timestamp value) {
      if (timestampValueBuilder_ == null) {
        if (valueTypeCase_ == 8
            && valueType_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          valueType_ =
              com.google.protobuf.Timestamp.newBuilder((com.google.protobuf.Timestamp) valueType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          valueType_ = value;
        }
        onChanged();
      } else {
        if (valueTypeCase_ == 8) {
          timestampValueBuilder_.mergeFrom(value);
        } else {
          timestampValueBuilder_.setMessage(value);
        }
      }
      valueTypeCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp type value.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 8;</code>
     */
    public Builder clearTimestampValue() {
      if (timestampValueBuilder_ == null) {
        if (valueTypeCase_ == 8) {
          valueTypeCase_ = 0;
          valueType_ = null;
          onChanged();
        }
      } else {
        if (valueTypeCase_ == 8) {
          valueTypeCase_ = 0;
          valueType_ = null;
        }
        timestampValueBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp type value.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 8;</code>
     */
    public com.google.protobuf.Timestamp.Builder getTimestampValueBuilder() {
      return getTimestampValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Timestamp type value.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 8;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getTimestampValueOrBuilder() {
      if ((valueTypeCase_ == 8) && (timestampValueBuilder_ != null)) {
        return timestampValueBuilder_.getMessageOrBuilder();
      } else {
        if (valueTypeCase_ == 8) {
          return (com.google.protobuf.Timestamp) valueType_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Timestamp type value.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getTimestampValueFieldBuilder() {
      if (timestampValueBuilder_ == null) {
        if (!(valueTypeCase_ == 8)) {
          valueType_ = com.google.protobuf.Timestamp.getDefaultInstance();
        }
        timestampValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                (com.google.protobuf.Timestamp) valueType_, getParentForChildren(), isClean());
        valueType_ = null;
      }
      valueTypeCase_ = 8;
      onChanged();
      return timestampValueBuilder_;
    }

    /**
     *
     *
     * <pre>
     * Date type value. Date is specified as a number of days since Unix epoch.
     * </pre>
     *
     * <code>int32 date_days_value = 9;</code>
     *
     * @return Whether the dateDaysValue field is set.
     */
    public boolean hasDateDaysValue() {
      return valueTypeCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Date type value. Date is specified as a number of days since Unix epoch.
     * </pre>
     *
     * <code>int32 date_days_value = 9;</code>
     *
     * @return The dateDaysValue.
     */
    public int getDateDaysValue() {
      if (valueTypeCase_ == 9) {
        return (java.lang.Integer) valueType_;
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * Date type value. Date is specified as a number of days since Unix epoch.
     * </pre>
     *
     * <code>int32 date_days_value = 9;</code>
     *
     * @param value The dateDaysValue to set.
     * @return This builder for chaining.
     */
    public Builder setDateDaysValue(int value) {

      valueTypeCase_ = 9;
      valueType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Date type value. Date is specified as a number of days since Unix epoch.
     * </pre>
     *
     * <code>int32 date_days_value = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDateDaysValue() {
      if (valueTypeCase_ == 9) {
        valueTypeCase_ = 0;
        valueType_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If set, holds the sentinel value for the transaction CommitTimestamp.
     * </pre>
     *
     * <code>bool is_commit_timestamp = 10;</code>
     *
     * @return Whether the isCommitTimestamp field is set.
     */
    public boolean hasIsCommitTimestamp() {
      return valueTypeCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * If set, holds the sentinel value for the transaction CommitTimestamp.
     * </pre>
     *
     * <code>bool is_commit_timestamp = 10;</code>
     *
     * @return The isCommitTimestamp.
     */
    public boolean getIsCommitTimestamp() {
      if (valueTypeCase_ == 10) {
        return (java.lang.Boolean) valueType_;
      }
      return false;
    }
    /**
     *
     *
     * <pre>
     * If set, holds the sentinel value for the transaction CommitTimestamp.
     * </pre>
     *
     * <code>bool is_commit_timestamp = 10;</code>
     *
     * @param value The isCommitTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setIsCommitTimestamp(boolean value) {

      valueTypeCase_ = 10;
      valueType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, holds the sentinel value for the transaction CommitTimestamp.
     * </pre>
     *
     * <code>bool is_commit_timestamp = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIsCommitTimestamp() {
      if (valueTypeCase_ == 10) {
        valueTypeCase_ = 0;
        valueType_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ValueList,
            com.google.spanner.executor.v1.ValueList.Builder,
            com.google.spanner.executor.v1.ValueListOrBuilder>
        arrayValueBuilder_;
    /**
     *
     *
     * <pre>
     * Array type value. The underlying Valuelist should have values that have
     * the same type.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList array_value = 11;</code>
     *
     * @return Whether the arrayValue field is set.
     */
    @java.lang.Override
    public boolean hasArrayValue() {
      return valueTypeCase_ == 11;
    }
    /**
     *
     *
     * <pre>
     * Array type value. The underlying Valuelist should have values that have
     * the same type.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList array_value = 11;</code>
     *
     * @return The arrayValue.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.ValueList getArrayValue() {
      if (arrayValueBuilder_ == null) {
        if (valueTypeCase_ == 11) {
          return (com.google.spanner.executor.v1.ValueList) valueType_;
        }
        return com.google.spanner.executor.v1.ValueList.getDefaultInstance();
      } else {
        if (valueTypeCase_ == 11) {
          return arrayValueBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.ValueList.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Array type value. The underlying Valuelist should have values that have
     * the same type.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList array_value = 11;</code>
     */
    public Builder setArrayValue(com.google.spanner.executor.v1.ValueList value) {
      if (arrayValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        valueType_ = value;
        onChanged();
      } else {
        arrayValueBuilder_.setMessage(value);
      }
      valueTypeCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Array type value. The underlying Valuelist should have values that have
     * the same type.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList array_value = 11;</code>
     */
    public Builder setArrayValue(com.google.spanner.executor.v1.ValueList.Builder builderForValue) {
      if (arrayValueBuilder_ == null) {
        valueType_ = builderForValue.build();
        onChanged();
      } else {
        arrayValueBuilder_.setMessage(builderForValue.build());
      }
      valueTypeCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Array type value. The underlying Valuelist should have values that have
     * the same type.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList array_value = 11;</code>
     */
    public Builder mergeArrayValue(com.google.spanner.executor.v1.ValueList value) {
      if (arrayValueBuilder_ == null) {
        if (valueTypeCase_ == 11
            && valueType_ != com.google.spanner.executor.v1.ValueList.getDefaultInstance()) {
          valueType_ =
              com.google.spanner.executor.v1.ValueList.newBuilder(
                      (com.google.spanner.executor.v1.ValueList) valueType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          valueType_ = value;
        }
        onChanged();
      } else {
        if (valueTypeCase_ == 11) {
          arrayValueBuilder_.mergeFrom(value);
        } else {
          arrayValueBuilder_.setMessage(value);
        }
      }
      valueTypeCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Array type value. The underlying Valuelist should have values that have
     * the same type.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList array_value = 11;</code>
     */
    public Builder clearArrayValue() {
      if (arrayValueBuilder_ == null) {
        if (valueTypeCase_ == 11) {
          valueTypeCase_ = 0;
          valueType_ = null;
          onChanged();
        }
      } else {
        if (valueTypeCase_ == 11) {
          valueTypeCase_ = 0;
          valueType_ = null;
        }
        arrayValueBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Array type value. The underlying Valuelist should have values that have
     * the same type.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList array_value = 11;</code>
     */
    public com.google.spanner.executor.v1.ValueList.Builder getArrayValueBuilder() {
      return getArrayValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Array type value. The underlying Valuelist should have values that have
     * the same type.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList array_value = 11;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.ValueListOrBuilder getArrayValueOrBuilder() {
      if ((valueTypeCase_ == 11) && (arrayValueBuilder_ != null)) {
        return arrayValueBuilder_.getMessageOrBuilder();
      } else {
        if (valueTypeCase_ == 11) {
          return (com.google.spanner.executor.v1.ValueList) valueType_;
        }
        return com.google.spanner.executor.v1.ValueList.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Array type value. The underlying Valuelist should have values that have
     * the same type.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList array_value = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ValueList,
            com.google.spanner.executor.v1.ValueList.Builder,
            com.google.spanner.executor.v1.ValueListOrBuilder>
        getArrayValueFieldBuilder() {
      if (arrayValueBuilder_ == null) {
        if (!(valueTypeCase_ == 11)) {
          valueType_ = com.google.spanner.executor.v1.ValueList.getDefaultInstance();
        }
        arrayValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.ValueList,
                com.google.spanner.executor.v1.ValueList.Builder,
                com.google.spanner.executor.v1.ValueListOrBuilder>(
                (com.google.spanner.executor.v1.ValueList) valueType_,
                getParentForChildren(),
                isClean());
        valueType_ = null;
      }
      valueTypeCase_ = 11;
      onChanged();
      return arrayValueBuilder_;
    }

    private com.google.spanner.v1.Type arrayType_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.Type,
            com.google.spanner.v1.Type.Builder,
            com.google.spanner.v1.TypeOrBuilder>
        arrayTypeBuilder_;
    /**
     *
     *
     * <pre>
     * Type of array element. Only set if value is an array.
     * </pre>
     *
     * <code>optional .google.spanner.v1.Type array_type = 12;</code>
     *
     * @return Whether the arrayType field is set.
     */
    public boolean hasArrayType() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Type of array element. Only set if value is an array.
     * </pre>
     *
     * <code>optional .google.spanner.v1.Type array_type = 12;</code>
     *
     * @return The arrayType.
     */
    public com.google.spanner.v1.Type getArrayType() {
      if (arrayTypeBuilder_ == null) {
        return arrayType_ == null ? com.google.spanner.v1.Type.getDefaultInstance() : arrayType_;
      } else {
        return arrayTypeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Type of array element. Only set if value is an array.
     * </pre>
     *
     * <code>optional .google.spanner.v1.Type array_type = 12;</code>
     */
    public Builder setArrayType(com.google.spanner.v1.Type value) {
      if (arrayTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        arrayType_ = value;
      } else {
        arrayTypeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of array element. Only set if value is an array.
     * </pre>
     *
     * <code>optional .google.spanner.v1.Type array_type = 12;</code>
     */
    public Builder setArrayType(com.google.spanner.v1.Type.Builder builderForValue) {
      if (arrayTypeBuilder_ == null) {
        arrayType_ = builderForValue.build();
      } else {
        arrayTypeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of array element. Only set if value is an array.
     * </pre>
     *
     * <code>optional .google.spanner.v1.Type array_type = 12;</code>
     */
    public Builder mergeArrayType(com.google.spanner.v1.Type value) {
      if (arrayTypeBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && arrayType_ != null
            && arrayType_ != com.google.spanner.v1.Type.getDefaultInstance()) {
          getArrayTypeBuilder().mergeFrom(value);
        } else {
          arrayType_ = value;
        }
      } else {
        arrayTypeBuilder_.mergeFrom(value);
      }
      if (arrayType_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of array element. Only set if value is an array.
     * </pre>
     *
     * <code>optional .google.spanner.v1.Type array_type = 12;</code>
     */
    public Builder clearArrayType() {
      bitField0_ = (bitField0_ & ~0x00000800);
      arrayType_ = null;
      if (arrayTypeBuilder_ != null) {
        arrayTypeBuilder_.dispose();
        arrayTypeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of array element. Only set if value is an array.
     * </pre>
     *
     * <code>optional .google.spanner.v1.Type array_type = 12;</code>
     */
    public com.google.spanner.v1.Type.Builder getArrayTypeBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getArrayTypeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Type of array element. Only set if value is an array.
     * </pre>
     *
     * <code>optional .google.spanner.v1.Type array_type = 12;</code>
     */
    public com.google.spanner.v1.TypeOrBuilder getArrayTypeOrBuilder() {
      if (arrayTypeBuilder_ != null) {
        return arrayTypeBuilder_.getMessageOrBuilder();
      } else {
        return arrayType_ == null ? com.google.spanner.v1.Type.getDefaultInstance() : arrayType_;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of array element. Only set if value is an array.
     * </pre>
     *
     * <code>optional .google.spanner.v1.Type array_type = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.Type,
            com.google.spanner.v1.Type.Builder,
            com.google.spanner.v1.TypeOrBuilder>
        getArrayTypeFieldBuilder() {
      if (arrayTypeBuilder_ == null) {
        arrayTypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.Type,
                com.google.spanner.v1.Type.Builder,
                com.google.spanner.v1.TypeOrBuilder>(
                getArrayType(), getParentForChildren(), isClean());
        arrayType_ = null;
      }
      return arrayTypeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.executor.v1.Value)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.executor.v1.Value)
  private static final com.google.spanner.executor.v1.Value DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.executor.v1.Value();
  }

  public static com.google.spanner.executor.v1.Value getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Value> PARSER =
      new com.google.protobuf.AbstractParser<Value>() {
        @java.lang.Override
        public Value parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Value> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Value> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.executor.v1.Value getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
