/*
 * Decompiled with CFR 0.152.
 */
package com.google.spanner.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.spanner.v1.SessionNameType;
import java.util.Map;

public class SessionName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/instances/{instance}/databases/{database}/sessions/{session}");
    private final String project;
    private final String instance;
    private final String database;
    private final String session;

    public String getProject() {
        return this.project;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getSession() {
        return this.session;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private SessionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
        this.database = (String)Preconditions.checkNotNull((Object)builder.getDatabase());
        this.session = (String)Preconditions.checkNotNull((Object)builder.getSession());
    }

    public static SessionName of(String project, String instance, String database, String session) {
        return SessionName.newBuilder().setProject(project).setInstance(instance).setDatabase(database).setSession(session).build();
    }

    @Deprecated
    public static SessionName create(String project, String instance, String database, String session) {
        return SessionName.of(project, instance, database, session);
    }

    public static SessionName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "SessionName.parse: formattedString not in valid format");
        return SessionName.of((String)matchMap.get("project"), (String)matchMap.get("instance"), (String)matchMap.get("database"), (String)matchMap.get("session"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return SessionNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "instance", this.instance, "database", this.database, "session", this.session});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SessionName) {
            SessionName that = (SessionName)o;
            return this.project.equals(that.project) && this.instance.equals(that.instance) && this.database.equals(that.database) && this.session.equals(that.session);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.instance.hashCode();
        h *= 1000003;
        h ^= this.database.hashCode();
        h *= 1000003;
        return h ^= this.session.hashCode();
    }

    public static class Builder {
        private String project;
        private String instance;
        private String database;
        private String session;

        public String getProject() {
            return this.project;
        }

        public String getInstance() {
            return this.instance;
        }

        public String getDatabase() {
            return this.database;
        }

        public String getSession() {
            return this.session;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder setSession(String session) {
            this.session = session;
            return this;
        }

        private Builder() {
        }

        private Builder(SessionName sessionName) {
            this.project = sessionName.project;
            this.instance = sessionName.instance;
            this.database = sessionName.database;
            this.session = sessionName.session;
        }

        public SessionName build() {
            return new SessionName(this);
        }
    }
}

