/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/v1/spanner.proto

package com.google.spanner.v1;

/**
 *
 *
 * <pre>
 * The response for [ExecuteBatchDml][google.spanner.v1.Spanner.ExecuteBatchDml]. Contains a list
 * of [ResultSet][google.spanner.v1.ResultSet] messages, one for each DML statement that has successfully
 * executed, in the same order as the statements in the request. If a statement
 * fails, the status in the response body identifies the cause of the failure.
 * To check for DML statements that failed, use the following approach:
 * 1. Check the status in the response message. The [google.rpc.Code][google.rpc.Code] enum
 *    value `OK` indicates that all statements were executed successfully.
 * 2. If the status was not `OK`, check the number of result sets in the
 *    response. If the response contains `N` [ResultSet][google.spanner.v1.ResultSet] messages, then
 *    statement `N+1` in the request failed.
 * Example 1:
 * * Request: 5 DML statements, all executed successfully.
 * * Response: 5 [ResultSet][google.spanner.v1.ResultSet] messages, with the status `OK`.
 * Example 2:
 * * Request: 5 DML statements. The third statement has a syntax error.
 * * Response: 2 [ResultSet][google.spanner.v1.ResultSet] messages, and a syntax error (`INVALID_ARGUMENT`)
 *   status. The number of [ResultSet][google.spanner.v1.ResultSet] messages indicates that the third
 *   statement failed, and the fourth and fifth statements were not executed.
 * </pre>
 *
 * Protobuf type {@code google.spanner.v1.ExecuteBatchDmlResponse}
 */
public final class ExecuteBatchDmlResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.v1.ExecuteBatchDmlResponse)
    ExecuteBatchDmlResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExecuteBatchDmlResponse.newBuilder() to construct.
  private ExecuteBatchDmlResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExecuteBatchDmlResponse() {
    resultSets_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExecuteBatchDmlResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ExecuteBatchDmlResponse(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                resultSets_ = new java.util.ArrayList<com.google.spanner.v1.ResultSet>();
                mutable_bitField0_ |= 0x00000001;
              }
              resultSets_.add(
                  input.readMessage(com.google.spanner.v1.ResultSet.parser(), extensionRegistry));
              break;
            }
          case 18:
            {
              com.google.rpc.Status.Builder subBuilder = null;
              if (status_ != null) {
                subBuilder = status_.toBuilder();
              }
              status_ = input.readMessage(com.google.rpc.Status.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(status_);
                status_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        resultSets_ = java.util.Collections.unmodifiableList(resultSets_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.v1.SpannerProto
        .internal_static_google_spanner_v1_ExecuteBatchDmlResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.v1.SpannerProto
        .internal_static_google_spanner_v1_ExecuteBatchDmlResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.v1.ExecuteBatchDmlResponse.class,
            com.google.spanner.v1.ExecuteBatchDmlResponse.Builder.class);
  }

  public static final int RESULT_SETS_FIELD_NUMBER = 1;
  private java.util.List<com.google.spanner.v1.ResultSet> resultSets_;
  /**
   *
   *
   * <pre>
   * One [ResultSet][google.spanner.v1.ResultSet] for each statement in the request that ran successfully,
   * in the same order as the statements in the request. Each [ResultSet][google.spanner.v1.ResultSet] does
   * not contain any rows. The [ResultSetStats][google.spanner.v1.ResultSetStats] in each [ResultSet][google.spanner.v1.ResultSet] contain
   * the number of rows modified by the statement.
   * Only the first [ResultSet][google.spanner.v1.ResultSet] in the response contains valid
   * [ResultSetMetadata][google.spanner.v1.ResultSetMetadata].
   * </pre>
   *
   * <code>repeated .google.spanner.v1.ResultSet result_sets = 1;</code>
   */
  public java.util.List<com.google.spanner.v1.ResultSet> getResultSetsList() {
    return resultSets_;
  }
  /**
   *
   *
   * <pre>
   * One [ResultSet][google.spanner.v1.ResultSet] for each statement in the request that ran successfully,
   * in the same order as the statements in the request. Each [ResultSet][google.spanner.v1.ResultSet] does
   * not contain any rows. The [ResultSetStats][google.spanner.v1.ResultSetStats] in each [ResultSet][google.spanner.v1.ResultSet] contain
   * the number of rows modified by the statement.
   * Only the first [ResultSet][google.spanner.v1.ResultSet] in the response contains valid
   * [ResultSetMetadata][google.spanner.v1.ResultSetMetadata].
   * </pre>
   *
   * <code>repeated .google.spanner.v1.ResultSet result_sets = 1;</code>
   */
  public java.util.List<? extends com.google.spanner.v1.ResultSetOrBuilder>
      getResultSetsOrBuilderList() {
    return resultSets_;
  }
  /**
   *
   *
   * <pre>
   * One [ResultSet][google.spanner.v1.ResultSet] for each statement in the request that ran successfully,
   * in the same order as the statements in the request. Each [ResultSet][google.spanner.v1.ResultSet] does
   * not contain any rows. The [ResultSetStats][google.spanner.v1.ResultSetStats] in each [ResultSet][google.spanner.v1.ResultSet] contain
   * the number of rows modified by the statement.
   * Only the first [ResultSet][google.spanner.v1.ResultSet] in the response contains valid
   * [ResultSetMetadata][google.spanner.v1.ResultSetMetadata].
   * </pre>
   *
   * <code>repeated .google.spanner.v1.ResultSet result_sets = 1;</code>
   */
  public int getResultSetsCount() {
    return resultSets_.size();
  }
  /**
   *
   *
   * <pre>
   * One [ResultSet][google.spanner.v1.ResultSet] for each statement in the request that ran successfully,
   * in the same order as the statements in the request. Each [ResultSet][google.spanner.v1.ResultSet] does
   * not contain any rows. The [ResultSetStats][google.spanner.v1.ResultSetStats] in each [ResultSet][google.spanner.v1.ResultSet] contain
   * the number of rows modified by the statement.
   * Only the first [ResultSet][google.spanner.v1.ResultSet] in the response contains valid
   * [ResultSetMetadata][google.spanner.v1.ResultSetMetadata].
   * </pre>
   *
   * <code>repeated .google.spanner.v1.ResultSet result_sets = 1;</code>
   */
  public com.google.spanner.v1.ResultSet getResultSets(int index) {
    return resultSets_.get(index);
  }
  /**
   *
   *
   * <pre>
   * One [ResultSet][google.spanner.v1.ResultSet] for each statement in the request that ran successfully,
   * in the same order as the statements in the request. Each [ResultSet][google.spanner.v1.ResultSet] does
   * not contain any rows. The [ResultSetStats][google.spanner.v1.ResultSetStats] in each [ResultSet][google.spanner.v1.ResultSet] contain
   * the number of rows modified by the statement.
   * Only the first [ResultSet][google.spanner.v1.ResultSet] in the response contains valid
   * [ResultSetMetadata][google.spanner.v1.ResultSetMetadata].
   * </pre>
   *
   * <code>repeated .google.spanner.v1.ResultSet result_sets = 1;</code>
   */
  public com.google.spanner.v1.ResultSetOrBuilder getResultSetsOrBuilder(int index) {
    return resultSets_.get(index);
  }

  public static final int STATUS_FIELD_NUMBER = 2;
  private com.google.rpc.Status status_;
  /**
   *
   *
   * <pre>
   * If all DML statements are executed successfully, the status is `OK`.
   * Otherwise, the error status of the first failed statement.
   * </pre>
   *
   * <code>.google.rpc.Status status = 2;</code>
   *
   * @return Whether the status field is set.
   */
  public boolean hasStatus() {
    return status_ != null;
  }
  /**
   *
   *
   * <pre>
   * If all DML statements are executed successfully, the status is `OK`.
   * Otherwise, the error status of the first failed statement.
   * </pre>
   *
   * <code>.google.rpc.Status status = 2;</code>
   *
   * @return The status.
   */
  public com.google.rpc.Status getStatus() {
    return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
  }
  /**
   *
   *
   * <pre>
   * If all DML statements are executed successfully, the status is `OK`.
   * Otherwise, the error status of the first failed statement.
   * </pre>
   *
   * <code>.google.rpc.Status status = 2;</code>
   */
  public com.google.rpc.StatusOrBuilder getStatusOrBuilder() {
    return getStatus();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < resultSets_.size(); i++) {
      output.writeMessage(1, resultSets_.get(i));
    }
    if (status_ != null) {
      output.writeMessage(2, getStatus());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < resultSets_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, resultSets_.get(i));
    }
    if (status_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getStatus());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.v1.ExecuteBatchDmlResponse)) {
      return super.equals(obj);
    }
    com.google.spanner.v1.ExecuteBatchDmlResponse other =
        (com.google.spanner.v1.ExecuteBatchDmlResponse) obj;

    if (!getResultSetsList().equals(other.getResultSetsList())) return false;
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getResultSetsCount() > 0) {
      hash = (37 * hash) + RESULT_SETS_FIELD_NUMBER;
      hash = (53 * hash) + getResultSetsList().hashCode();
    }
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.v1.ExecuteBatchDmlResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.ExecuteBatchDmlResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.ExecuteBatchDmlResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.ExecuteBatchDmlResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.ExecuteBatchDmlResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.ExecuteBatchDmlResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.ExecuteBatchDmlResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.ExecuteBatchDmlResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.ExecuteBatchDmlResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.ExecuteBatchDmlResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.ExecuteBatchDmlResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.ExecuteBatchDmlResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.v1.ExecuteBatchDmlResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The response for [ExecuteBatchDml][google.spanner.v1.Spanner.ExecuteBatchDml]. Contains a list
   * of [ResultSet][google.spanner.v1.ResultSet] messages, one for each DML statement that has successfully
   * executed, in the same order as the statements in the request. If a statement
   * fails, the status in the response body identifies the cause of the failure.
   * To check for DML statements that failed, use the following approach:
   * 1. Check the status in the response message. The [google.rpc.Code][google.rpc.Code] enum
   *    value `OK` indicates that all statements were executed successfully.
   * 2. If the status was not `OK`, check the number of result sets in the
   *    response. If the response contains `N` [ResultSet][google.spanner.v1.ResultSet] messages, then
   *    statement `N+1` in the request failed.
   * Example 1:
   * * Request: 5 DML statements, all executed successfully.
   * * Response: 5 [ResultSet][google.spanner.v1.ResultSet] messages, with the status `OK`.
   * Example 2:
   * * Request: 5 DML statements. The third statement has a syntax error.
   * * Response: 2 [ResultSet][google.spanner.v1.ResultSet] messages, and a syntax error (`INVALID_ARGUMENT`)
   *   status. The number of [ResultSet][google.spanner.v1.ResultSet] messages indicates that the third
   *   statement failed, and the fourth and fifth statements were not executed.
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.ExecuteBatchDmlResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.v1.ExecuteBatchDmlResponse)
      com.google.spanner.v1.ExecuteBatchDmlResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_ExecuteBatchDmlResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_ExecuteBatchDmlResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.ExecuteBatchDmlResponse.class,
              com.google.spanner.v1.ExecuteBatchDmlResponse.Builder.class);
    }

    // Construct using com.google.spanner.v1.ExecuteBatchDmlResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getResultSetsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (resultSetsBuilder_ == null) {
        resultSets_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        resultSetsBuilder_.clear();
      }
      if (statusBuilder_ == null) {
        status_ = null;
      } else {
        status_ = null;
        statusBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_ExecuteBatchDmlResponse_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.v1.ExecuteBatchDmlResponse getDefaultInstanceForType() {
      return com.google.spanner.v1.ExecuteBatchDmlResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.v1.ExecuteBatchDmlResponse build() {
      com.google.spanner.v1.ExecuteBatchDmlResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.v1.ExecuteBatchDmlResponse buildPartial() {
      com.google.spanner.v1.ExecuteBatchDmlResponse result =
          new com.google.spanner.v1.ExecuteBatchDmlResponse(this);
      int from_bitField0_ = bitField0_;
      if (resultSetsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          resultSets_ = java.util.Collections.unmodifiableList(resultSets_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.resultSets_ = resultSets_;
      } else {
        result.resultSets_ = resultSetsBuilder_.build();
      }
      if (statusBuilder_ == null) {
        result.status_ = status_;
      } else {
        result.status_ = statusBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.v1.ExecuteBatchDmlResponse) {
        return mergeFrom((com.google.spanner.v1.ExecuteBatchDmlResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.v1.ExecuteBatchDmlResponse other) {
      if (other == com.google.spanner.v1.ExecuteBatchDmlResponse.getDefaultInstance()) return this;
      if (resultSetsBuilder_ == null) {
        if (!other.resultSets_.isEmpty()) {
          if (resultSets_.isEmpty()) {
            resultSets_ = other.resultSets_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureResultSetsIsMutable();
            resultSets_.addAll(other.resultSets_);
          }
          onChanged();
        }
      } else {
        if (!other.resultSets_.isEmpty()) {
          if (resultSetsBuilder_.isEmpty()) {
            resultSetsBuilder_.dispose();
            resultSetsBuilder_ = null;
            resultSets_ = other.resultSets_;
            bitField0_ = (bitField0_ & ~0x00000001);
            resultSetsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getResultSetsFieldBuilder()
                    : null;
          } else {
            resultSetsBuilder_.addAllMessages(other.resultSets_);
          }
        }
      }
      if (other.hasStatus()) {
        mergeStatus(other.getStatus());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.spanner.v1.ExecuteBatchDmlResponse parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.spanner.v1.ExecuteBatchDmlResponse) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.spanner.v1.ResultSet> resultSets_ =
        java.util.Collections.emptyList();

    private void ensureResultSetsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        resultSets_ = new java.util.ArrayList<com.google.spanner.v1.ResultSet>(resultSets_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.v1.ResultSet,
            com.google.spanner.v1.ResultSet.Builder,
            com.google.spanner.v1.ResultSetOrBuilder>
        resultSetsBuilder_;

    /**
     *
     *
     * <pre>
     * One [ResultSet][google.spanner.v1.ResultSet] for each statement in the request that ran successfully,
     * in the same order as the statements in the request. Each [ResultSet][google.spanner.v1.ResultSet] does
     * not contain any rows. The [ResultSetStats][google.spanner.v1.ResultSetStats] in each [ResultSet][google.spanner.v1.ResultSet] contain
     * the number of rows modified by the statement.
     * Only the first [ResultSet][google.spanner.v1.ResultSet] in the response contains valid
     * [ResultSetMetadata][google.spanner.v1.ResultSetMetadata].
     * </pre>
     *
     * <code>repeated .google.spanner.v1.ResultSet result_sets = 1;</code>
     */
    public java.util.List<com.google.spanner.v1.ResultSet> getResultSetsList() {
      if (resultSetsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(resultSets_);
      } else {
        return resultSetsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * One [ResultSet][google.spanner.v1.ResultSet] for each statement in the request that ran successfully,
     * in the same order as the statements in the request. Each [ResultSet][google.spanner.v1.ResultSet] does
     * not contain any rows. The [ResultSetStats][google.spanner.v1.ResultSetStats] in each [ResultSet][google.spanner.v1.ResultSet] contain
     * the number of rows modified by the statement.
     * Only the first [ResultSet][google.spanner.v1.ResultSet] in the response contains valid
     * [ResultSetMetadata][google.spanner.v1.ResultSetMetadata].
     * </pre>
     *
     * <code>repeated .google.spanner.v1.ResultSet result_sets = 1;</code>
     */
    public int getResultSetsCount() {
      if (resultSetsBuilder_ == null) {
        return resultSets_.size();
      } else {
        return resultSetsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * One [ResultSet][google.spanner.v1.ResultSet] for each statement in the request that ran successfully,
     * in the same order as the statements in the request. Each [ResultSet][google.spanner.v1.ResultSet] does
     * not contain any rows. The [ResultSetStats][google.spanner.v1.ResultSetStats] in each [ResultSet][google.spanner.v1.ResultSet] contain
     * the number of rows modified by the statement.
     * Only the first [ResultSet][google.spanner.v1.ResultSet] in the response contains valid
     * [ResultSetMetadata][google.spanner.v1.ResultSetMetadata].
     * </pre>
     *
     * <code>repeated .google.spanner.v1.ResultSet result_sets = 1;</code>
     */
    public com.google.spanner.v1.ResultSet getResultSets(int index) {
      if (resultSetsBuilder_ == null) {
        return resultSets_.get(index);
      } else {
        return resultSetsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * One [ResultSet][google.spanner.v1.ResultSet] for each statement in the request that ran successfully,
     * in the same order as the statements in the request. Each [ResultSet][google.spanner.v1.ResultSet] does
     * not contain any rows. The [ResultSetStats][google.spanner.v1.ResultSetStats] in each [ResultSet][google.spanner.v1.ResultSet] contain
     * the number of rows modified by the statement.
     * Only the first [ResultSet][google.spanner.v1.ResultSet] in the response contains valid
     * [ResultSetMetadata][google.spanner.v1.ResultSetMetadata].
     * </pre>
     *
     * <code>repeated .google.spanner.v1.ResultSet result_sets = 1;</code>
     */
    public Builder setResultSets(int index, com.google.spanner.v1.ResultSet value) {
      if (resultSetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultSetsIsMutable();
        resultSets_.set(index, value);
        onChanged();
      } else {
        resultSetsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * One [ResultSet][google.spanner.v1.ResultSet] for each statement in the request that ran successfully,
     * in the same order as the statements in the request. Each [ResultSet][google.spanner.v1.ResultSet] does
     * not contain any rows. The [ResultSetStats][google.spanner.v1.ResultSetStats] in each [ResultSet][google.spanner.v1.ResultSet] contain
     * the number of rows modified by the statement.
     * Only the first [ResultSet][google.spanner.v1.ResultSet] in the response contains valid
     * [ResultSetMetadata][google.spanner.v1.ResultSetMetadata].
     * </pre>
     *
     * <code>repeated .google.spanner.v1.ResultSet result_sets = 1;</code>
     */
    public Builder setResultSets(
        int index, com.google.spanner.v1.ResultSet.Builder builderForValue) {
      if (resultSetsBuilder_ == null) {
        ensureResultSetsIsMutable();
        resultSets_.set(index, builderForValue.build());
        onChanged();
      } else {
        resultSetsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * One [ResultSet][google.spanner.v1.ResultSet] for each statement in the request that ran successfully,
     * in the same order as the statements in the request. Each [ResultSet][google.spanner.v1.ResultSet] does
     * not contain any rows. The [ResultSetStats][google.spanner.v1.ResultSetStats] in each [ResultSet][google.spanner.v1.ResultSet] contain
     * the number of rows modified by the statement.
     * Only the first [ResultSet][google.spanner.v1.ResultSet] in the response contains valid
     * [ResultSetMetadata][google.spanner.v1.ResultSetMetadata].
     * </pre>
     *
     * <code>repeated .google.spanner.v1.ResultSet result_sets = 1;</code>
     */
    public Builder addResultSets(com.google.spanner.v1.ResultSet value) {
      if (resultSetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultSetsIsMutable();
        resultSets_.add(value);
        onChanged();
      } else {
        resultSetsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * One [ResultSet][google.spanner.v1.ResultSet] for each statement in the request that ran successfully,
     * in the same order as the statements in the request. Each [ResultSet][google.spanner.v1.ResultSet] does
     * not contain any rows. The [ResultSetStats][google.spanner.v1.ResultSetStats] in each [ResultSet][google.spanner.v1.ResultSet] contain
     * the number of rows modified by the statement.
     * Only the first [ResultSet][google.spanner.v1.ResultSet] in the response contains valid
     * [ResultSetMetadata][google.spanner.v1.ResultSetMetadata].
     * </pre>
     *
     * <code>repeated .google.spanner.v1.ResultSet result_sets = 1;</code>
     */
    public Builder addResultSets(int index, com.google.spanner.v1.ResultSet value) {
      if (resultSetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultSetsIsMutable();
        resultSets_.add(index, value);
        onChanged();
      } else {
        resultSetsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * One [ResultSet][google.spanner.v1.ResultSet] for each statement in the request that ran successfully,
     * in the same order as the statements in the request. Each [ResultSet][google.spanner.v1.ResultSet] does
     * not contain any rows. The [ResultSetStats][google.spanner.v1.ResultSetStats] in each [ResultSet][google.spanner.v1.ResultSet] contain
     * the number of rows modified by the statement.
     * Only the first [ResultSet][google.spanner.v1.ResultSet] in the response contains valid
     * [ResultSetMetadata][google.spanner.v1.ResultSetMetadata].
     * </pre>
     *
     * <code>repeated .google.spanner.v1.ResultSet result_sets = 1;</code>
     */
    public Builder addResultSets(com.google.spanner.v1.ResultSet.Builder builderForValue) {
      if (resultSetsBuilder_ == null) {
        ensureResultSetsIsMutable();
        resultSets_.add(builderForValue.build());
        onChanged();
      } else {
        resultSetsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * One [ResultSet][google.spanner.v1.ResultSet] for each statement in the request that ran successfully,
     * in the same order as the statements in the request. Each [ResultSet][google.spanner.v1.ResultSet] does
     * not contain any rows. The [ResultSetStats][google.spanner.v1.ResultSetStats] in each [ResultSet][google.spanner.v1.ResultSet] contain
     * the number of rows modified by the statement.
     * Only the first [ResultSet][google.spanner.v1.ResultSet] in the response contains valid
     * [ResultSetMetadata][google.spanner.v1.ResultSetMetadata].
     * </pre>
     *
     * <code>repeated .google.spanner.v1.ResultSet result_sets = 1;</code>
     */
    public Builder addResultSets(
        int index, com.google.spanner.v1.ResultSet.Builder builderForValue) {
      if (resultSetsBuilder_ == null) {
        ensureResultSetsIsMutable();
        resultSets_.add(index, builderForValue.build());
        onChanged();
      } else {
        resultSetsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * One [ResultSet][google.spanner.v1.ResultSet] for each statement in the request that ran successfully,
     * in the same order as the statements in the request. Each [ResultSet][google.spanner.v1.ResultSet] does
     * not contain any rows. The [ResultSetStats][google.spanner.v1.ResultSetStats] in each [ResultSet][google.spanner.v1.ResultSet] contain
     * the number of rows modified by the statement.
     * Only the first [ResultSet][google.spanner.v1.ResultSet] in the response contains valid
     * [ResultSetMetadata][google.spanner.v1.ResultSetMetadata].
     * </pre>
     *
     * <code>repeated .google.spanner.v1.ResultSet result_sets = 1;</code>
     */
    public Builder addAllResultSets(
        java.lang.Iterable<? extends com.google.spanner.v1.ResultSet> values) {
      if (resultSetsBuilder_ == null) {
        ensureResultSetsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, resultSets_);
        onChanged();
      } else {
        resultSetsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * One [ResultSet][google.spanner.v1.ResultSet] for each statement in the request that ran successfully,
     * in the same order as the statements in the request. Each [ResultSet][google.spanner.v1.ResultSet] does
     * not contain any rows. The [ResultSetStats][google.spanner.v1.ResultSetStats] in each [ResultSet][google.spanner.v1.ResultSet] contain
     * the number of rows modified by the statement.
     * Only the first [ResultSet][google.spanner.v1.ResultSet] in the response contains valid
     * [ResultSetMetadata][google.spanner.v1.ResultSetMetadata].
     * </pre>
     *
     * <code>repeated .google.spanner.v1.ResultSet result_sets = 1;</code>
     */
    public Builder clearResultSets() {
      if (resultSetsBuilder_ == null) {
        resultSets_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        resultSetsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * One [ResultSet][google.spanner.v1.ResultSet] for each statement in the request that ran successfully,
     * in the same order as the statements in the request. Each [ResultSet][google.spanner.v1.ResultSet] does
     * not contain any rows. The [ResultSetStats][google.spanner.v1.ResultSetStats] in each [ResultSet][google.spanner.v1.ResultSet] contain
     * the number of rows modified by the statement.
     * Only the first [ResultSet][google.spanner.v1.ResultSet] in the response contains valid
     * [ResultSetMetadata][google.spanner.v1.ResultSetMetadata].
     * </pre>
     *
     * <code>repeated .google.spanner.v1.ResultSet result_sets = 1;</code>
     */
    public Builder removeResultSets(int index) {
      if (resultSetsBuilder_ == null) {
        ensureResultSetsIsMutable();
        resultSets_.remove(index);
        onChanged();
      } else {
        resultSetsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * One [ResultSet][google.spanner.v1.ResultSet] for each statement in the request that ran successfully,
     * in the same order as the statements in the request. Each [ResultSet][google.spanner.v1.ResultSet] does
     * not contain any rows. The [ResultSetStats][google.spanner.v1.ResultSetStats] in each [ResultSet][google.spanner.v1.ResultSet] contain
     * the number of rows modified by the statement.
     * Only the first [ResultSet][google.spanner.v1.ResultSet] in the response contains valid
     * [ResultSetMetadata][google.spanner.v1.ResultSetMetadata].
     * </pre>
     *
     * <code>repeated .google.spanner.v1.ResultSet result_sets = 1;</code>
     */
    public com.google.spanner.v1.ResultSet.Builder getResultSetsBuilder(int index) {
      return getResultSetsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * One [ResultSet][google.spanner.v1.ResultSet] for each statement in the request that ran successfully,
     * in the same order as the statements in the request. Each [ResultSet][google.spanner.v1.ResultSet] does
     * not contain any rows. The [ResultSetStats][google.spanner.v1.ResultSetStats] in each [ResultSet][google.spanner.v1.ResultSet] contain
     * the number of rows modified by the statement.
     * Only the first [ResultSet][google.spanner.v1.ResultSet] in the response contains valid
     * [ResultSetMetadata][google.spanner.v1.ResultSetMetadata].
     * </pre>
     *
     * <code>repeated .google.spanner.v1.ResultSet result_sets = 1;</code>
     */
    public com.google.spanner.v1.ResultSetOrBuilder getResultSetsOrBuilder(int index) {
      if (resultSetsBuilder_ == null) {
        return resultSets_.get(index);
      } else {
        return resultSetsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * One [ResultSet][google.spanner.v1.ResultSet] for each statement in the request that ran successfully,
     * in the same order as the statements in the request. Each [ResultSet][google.spanner.v1.ResultSet] does
     * not contain any rows. The [ResultSetStats][google.spanner.v1.ResultSetStats] in each [ResultSet][google.spanner.v1.ResultSet] contain
     * the number of rows modified by the statement.
     * Only the first [ResultSet][google.spanner.v1.ResultSet] in the response contains valid
     * [ResultSetMetadata][google.spanner.v1.ResultSetMetadata].
     * </pre>
     *
     * <code>repeated .google.spanner.v1.ResultSet result_sets = 1;</code>
     */
    public java.util.List<? extends com.google.spanner.v1.ResultSetOrBuilder>
        getResultSetsOrBuilderList() {
      if (resultSetsBuilder_ != null) {
        return resultSetsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(resultSets_);
      }
    }
    /**
     *
     *
     * <pre>
     * One [ResultSet][google.spanner.v1.ResultSet] for each statement in the request that ran successfully,
     * in the same order as the statements in the request. Each [ResultSet][google.spanner.v1.ResultSet] does
     * not contain any rows. The [ResultSetStats][google.spanner.v1.ResultSetStats] in each [ResultSet][google.spanner.v1.ResultSet] contain
     * the number of rows modified by the statement.
     * Only the first [ResultSet][google.spanner.v1.ResultSet] in the response contains valid
     * [ResultSetMetadata][google.spanner.v1.ResultSetMetadata].
     * </pre>
     *
     * <code>repeated .google.spanner.v1.ResultSet result_sets = 1;</code>
     */
    public com.google.spanner.v1.ResultSet.Builder addResultSetsBuilder() {
      return getResultSetsFieldBuilder()
          .addBuilder(com.google.spanner.v1.ResultSet.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * One [ResultSet][google.spanner.v1.ResultSet] for each statement in the request that ran successfully,
     * in the same order as the statements in the request. Each [ResultSet][google.spanner.v1.ResultSet] does
     * not contain any rows. The [ResultSetStats][google.spanner.v1.ResultSetStats] in each [ResultSet][google.spanner.v1.ResultSet] contain
     * the number of rows modified by the statement.
     * Only the first [ResultSet][google.spanner.v1.ResultSet] in the response contains valid
     * [ResultSetMetadata][google.spanner.v1.ResultSetMetadata].
     * </pre>
     *
     * <code>repeated .google.spanner.v1.ResultSet result_sets = 1;</code>
     */
    public com.google.spanner.v1.ResultSet.Builder addResultSetsBuilder(int index) {
      return getResultSetsFieldBuilder()
          .addBuilder(index, com.google.spanner.v1.ResultSet.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * One [ResultSet][google.spanner.v1.ResultSet] for each statement in the request that ran successfully,
     * in the same order as the statements in the request. Each [ResultSet][google.spanner.v1.ResultSet] does
     * not contain any rows. The [ResultSetStats][google.spanner.v1.ResultSetStats] in each [ResultSet][google.spanner.v1.ResultSet] contain
     * the number of rows modified by the statement.
     * Only the first [ResultSet][google.spanner.v1.ResultSet] in the response contains valid
     * [ResultSetMetadata][google.spanner.v1.ResultSetMetadata].
     * </pre>
     *
     * <code>repeated .google.spanner.v1.ResultSet result_sets = 1;</code>
     */
    public java.util.List<com.google.spanner.v1.ResultSet.Builder> getResultSetsBuilderList() {
      return getResultSetsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.v1.ResultSet,
            com.google.spanner.v1.ResultSet.Builder,
            com.google.spanner.v1.ResultSetOrBuilder>
        getResultSetsFieldBuilder() {
      if (resultSetsBuilder_ == null) {
        resultSetsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.spanner.v1.ResultSet,
                com.google.spanner.v1.ResultSet.Builder,
                com.google.spanner.v1.ResultSetOrBuilder>(
                resultSets_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        resultSets_ = null;
      }
      return resultSetsBuilder_;
    }

    private com.google.rpc.Status status_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        statusBuilder_;
    /**
     *
     *
     * <pre>
     * If all DML statements are executed successfully, the status is `OK`.
     * Otherwise, the error status of the first failed statement.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return statusBuilder_ != null || status_ != null;
    }
    /**
     *
     *
     * <pre>
     * If all DML statements are executed successfully, the status is `OK`.
     * Otherwise, the error status of the first failed statement.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     *
     * @return The status.
     */
    public com.google.rpc.Status getStatus() {
      if (statusBuilder_ == null) {
        return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
      } else {
        return statusBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If all DML statements are executed successfully, the status is `OK`.
     * Otherwise, the error status of the first failed statement.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     */
    public Builder setStatus(com.google.rpc.Status value) {
      if (statusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        status_ = value;
        onChanged();
      } else {
        statusBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If all DML statements are executed successfully, the status is `OK`.
     * Otherwise, the error status of the first failed statement.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     */
    public Builder setStatus(com.google.rpc.Status.Builder builderForValue) {
      if (statusBuilder_ == null) {
        status_ = builderForValue.build();
        onChanged();
      } else {
        statusBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If all DML statements are executed successfully, the status is `OK`.
     * Otherwise, the error status of the first failed statement.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     */
    public Builder mergeStatus(com.google.rpc.Status value) {
      if (statusBuilder_ == null) {
        if (status_ != null) {
          status_ = com.google.rpc.Status.newBuilder(status_).mergeFrom(value).buildPartial();
        } else {
          status_ = value;
        }
        onChanged();
      } else {
        statusBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If all DML statements are executed successfully, the status is `OK`.
     * Otherwise, the error status of the first failed statement.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     */
    public Builder clearStatus() {
      if (statusBuilder_ == null) {
        status_ = null;
        onChanged();
      } else {
        status_ = null;
        statusBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If all DML statements are executed successfully, the status is `OK`.
     * Otherwise, the error status of the first failed statement.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     */
    public com.google.rpc.Status.Builder getStatusBuilder() {

      onChanged();
      return getStatusFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If all DML statements are executed successfully, the status is `OK`.
     * Otherwise, the error status of the first failed statement.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     */
    public com.google.rpc.StatusOrBuilder getStatusOrBuilder() {
      if (statusBuilder_ != null) {
        return statusBuilder_.getMessageOrBuilder();
      } else {
        return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
      }
    }
    /**
     *
     *
     * <pre>
     * If all DML statements are executed successfully, the status is `OK`.
     * Otherwise, the error status of the first failed statement.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getStatusFieldBuilder() {
      if (statusBuilder_ == null) {
        statusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getStatus(), getParentForChildren(), isClean());
        status_ = null;
      }
      return statusBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.v1.ExecuteBatchDmlResponse)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.v1.ExecuteBatchDmlResponse)
  private static final com.google.spanner.v1.ExecuteBatchDmlResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.v1.ExecuteBatchDmlResponse();
  }

  public static com.google.spanner.v1.ExecuteBatchDmlResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExecuteBatchDmlResponse> PARSER =
      new com.google.protobuf.AbstractParser<ExecuteBatchDmlResponse>() {
        @java.lang.Override
        public ExecuteBatchDmlResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ExecuteBatchDmlResponse(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ExecuteBatchDmlResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExecuteBatchDmlResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.v1.ExecuteBatchDmlResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
