/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/v1/spanner.proto

package com.google.spanner.v1;

/**
 *
 *
 * <pre>
 * The request for [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] and
 * [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql].
 * </pre>
 *
 * Protobuf type {@code google.spanner.v1.ExecuteSqlRequest}
 */
public final class ExecuteSqlRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.v1.ExecuteSqlRequest)
    ExecuteSqlRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExecuteSqlRequest.newBuilder() to construct.
  private ExecuteSqlRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExecuteSqlRequest() {
    session_ = "";
    sql_ = "";
    resumeToken_ = com.google.protobuf.ByteString.EMPTY;
    queryMode_ = 0;
    partitionToken_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExecuteSqlRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ExecuteSqlRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              session_ = s;
              break;
            }
          case 18:
            {
              com.google.spanner.v1.TransactionSelector.Builder subBuilder = null;
              if (transaction_ != null) {
                subBuilder = transaction_.toBuilder();
              }
              transaction_ =
                  input.readMessage(
                      com.google.spanner.v1.TransactionSelector.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(transaction_);
                transaction_ = subBuilder.buildPartial();
              }

              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              sql_ = s;
              break;
            }
          case 34:
            {
              com.google.protobuf.Struct.Builder subBuilder = null;
              if (params_ != null) {
                subBuilder = params_.toBuilder();
              }
              params_ = input.readMessage(com.google.protobuf.Struct.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(params_);
                params_ = subBuilder.buildPartial();
              }

              break;
            }
          case 42:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                paramTypes_ =
                    com.google.protobuf.MapField.newMapField(
                        ParamTypesDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000001;
              }
              com.google.protobuf.MapEntry<java.lang.String, com.google.spanner.v1.Type>
                  paramTypes__ =
                      input.readMessage(
                          ParamTypesDefaultEntryHolder.defaultEntry.getParserForType(),
                          extensionRegistry);
              paramTypes_.getMutableMap().put(paramTypes__.getKey(), paramTypes__.getValue());
              break;
            }
          case 50:
            {
              resumeToken_ = input.readBytes();
              break;
            }
          case 56:
            {
              int rawValue = input.readEnum();

              queryMode_ = rawValue;
              break;
            }
          case 66:
            {
              partitionToken_ = input.readBytes();
              break;
            }
          case 72:
            {
              seqno_ = input.readInt64();
              break;
            }
          case 82:
            {
              com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.Builder subBuilder = null;
              if (queryOptions_ != null) {
                subBuilder = queryOptions_.toBuilder();
              }
              queryOptions_ =
                  input.readMessage(
                      com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(queryOptions_);
                queryOptions_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.v1.SpannerProto
        .internal_static_google_spanner_v1_ExecuteSqlRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 5:
        return internalGetParamTypes();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.v1.SpannerProto
        .internal_static_google_spanner_v1_ExecuteSqlRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.v1.ExecuteSqlRequest.class,
            com.google.spanner.v1.ExecuteSqlRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Mode in which the statement must be processed.
   * </pre>
   *
   * Protobuf enum {@code google.spanner.v1.ExecuteSqlRequest.QueryMode}
   */
  public enum QueryMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The default mode. Only the statement results are returned.
     * </pre>
     *
     * <code>NORMAL = 0;</code>
     */
    NORMAL(0),
    /**
     *
     *
     * <pre>
     * This mode returns only the query plan, without any results or
     * execution statistics information.
     * </pre>
     *
     * <code>PLAN = 1;</code>
     */
    PLAN(1),
    /**
     *
     *
     * <pre>
     * This mode returns both the query plan and the execution statistics along
     * with the results.
     * </pre>
     *
     * <code>PROFILE = 2;</code>
     */
    PROFILE(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The default mode. Only the statement results are returned.
     * </pre>
     *
     * <code>NORMAL = 0;</code>
     */
    public static final int NORMAL_VALUE = 0;
    /**
     *
     *
     * <pre>
     * This mode returns only the query plan, without any results or
     * execution statistics information.
     * </pre>
     *
     * <code>PLAN = 1;</code>
     */
    public static final int PLAN_VALUE = 1;
    /**
     *
     *
     * <pre>
     * This mode returns both the query plan and the execution statistics along
     * with the results.
     * </pre>
     *
     * <code>PROFILE = 2;</code>
     */
    public static final int PROFILE_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static QueryMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static QueryMode forNumber(int value) {
      switch (value) {
        case 0:
          return NORMAL;
        case 1:
          return PLAN;
        case 2:
          return PROFILE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<QueryMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<QueryMode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<QueryMode>() {
          public QueryMode findValueByNumber(int number) {
            return QueryMode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.spanner.v1.ExecuteSqlRequest.getDescriptor().getEnumTypes().get(0);
    }

    private static final QueryMode[] VALUES = values();

    public static QueryMode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private QueryMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.spanner.v1.ExecuteSqlRequest.QueryMode)
  }

  public interface QueryOptionsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.spanner.v1.ExecuteSqlRequest.QueryOptions)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * An option to control the selection of optimizer version.
     * This parameter allows individual queries to pick different query
     * optimizer versions.
     * Specifying "latest" as a value instructs Cloud Spanner to use the
     * latest supported query optimizer version. If not specified, Cloud Spanner
     * uses optimizer version set at the database level options. Any other
     * positive integer (from the list of supported optimizer versions)
     * overrides the default optimizer version for query execution.
     * The list of supported optimizer versions can be queried from
     * SPANNER_SYS.SUPPORTED_OPTIMIZER_VERSIONS. Executing a SQL statement
     * with an invalid optimizer version will fail with a syntax error
     * (`INVALID_ARGUMENT`) status.
     * The `optimizer_version` statement hint has precedence over this setting.
     * </pre>
     *
     * <code>string optimizer_version = 1;</code>
     *
     * @return The optimizerVersion.
     */
    java.lang.String getOptimizerVersion();
    /**
     *
     *
     * <pre>
     * An option to control the selection of optimizer version.
     * This parameter allows individual queries to pick different query
     * optimizer versions.
     * Specifying "latest" as a value instructs Cloud Spanner to use the
     * latest supported query optimizer version. If not specified, Cloud Spanner
     * uses optimizer version set at the database level options. Any other
     * positive integer (from the list of supported optimizer versions)
     * overrides the default optimizer version for query execution.
     * The list of supported optimizer versions can be queried from
     * SPANNER_SYS.SUPPORTED_OPTIMIZER_VERSIONS. Executing a SQL statement
     * with an invalid optimizer version will fail with a syntax error
     * (`INVALID_ARGUMENT`) status.
     * The `optimizer_version` statement hint has precedence over this setting.
     * </pre>
     *
     * <code>string optimizer_version = 1;</code>
     *
     * @return The bytes for optimizerVersion.
     */
    com.google.protobuf.ByteString getOptimizerVersionBytes();
  }
  /**
   *
   *
   * <pre>
   * Query optimizer configuration.
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.ExecuteSqlRequest.QueryOptions}
   */
  public static final class QueryOptions extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.spanner.v1.ExecuteSqlRequest.QueryOptions)
      QueryOptionsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use QueryOptions.newBuilder() to construct.
    private QueryOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private QueryOptions() {
      optimizerVersion_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new QueryOptions();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private QueryOptions(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                optimizerVersion_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_ExecuteSqlRequest_QueryOptions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_ExecuteSqlRequest_QueryOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.class,
              com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.Builder.class);
    }

    public static final int OPTIMIZER_VERSION_FIELD_NUMBER = 1;
    private volatile java.lang.Object optimizerVersion_;
    /**
     *
     *
     * <pre>
     * An option to control the selection of optimizer version.
     * This parameter allows individual queries to pick different query
     * optimizer versions.
     * Specifying "latest" as a value instructs Cloud Spanner to use the
     * latest supported query optimizer version. If not specified, Cloud Spanner
     * uses optimizer version set at the database level options. Any other
     * positive integer (from the list of supported optimizer versions)
     * overrides the default optimizer version for query execution.
     * The list of supported optimizer versions can be queried from
     * SPANNER_SYS.SUPPORTED_OPTIMIZER_VERSIONS. Executing a SQL statement
     * with an invalid optimizer version will fail with a syntax error
     * (`INVALID_ARGUMENT`) status.
     * The `optimizer_version` statement hint has precedence over this setting.
     * </pre>
     *
     * <code>string optimizer_version = 1;</code>
     *
     * @return The optimizerVersion.
     */
    @java.lang.Override
    public java.lang.String getOptimizerVersion() {
      java.lang.Object ref = optimizerVersion_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        optimizerVersion_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * An option to control the selection of optimizer version.
     * This parameter allows individual queries to pick different query
     * optimizer versions.
     * Specifying "latest" as a value instructs Cloud Spanner to use the
     * latest supported query optimizer version. If not specified, Cloud Spanner
     * uses optimizer version set at the database level options. Any other
     * positive integer (from the list of supported optimizer versions)
     * overrides the default optimizer version for query execution.
     * The list of supported optimizer versions can be queried from
     * SPANNER_SYS.SUPPORTED_OPTIMIZER_VERSIONS. Executing a SQL statement
     * with an invalid optimizer version will fail with a syntax error
     * (`INVALID_ARGUMENT`) status.
     * The `optimizer_version` statement hint has precedence over this setting.
     * </pre>
     *
     * <code>string optimizer_version = 1;</code>
     *
     * @return The bytes for optimizerVersion.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getOptimizerVersionBytes() {
      java.lang.Object ref = optimizerVersion_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        optimizerVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getOptimizerVersionBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, optimizerVersion_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getOptimizerVersionBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, optimizerVersion_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.spanner.v1.ExecuteSqlRequest.QueryOptions)) {
        return super.equals(obj);
      }
      com.google.spanner.v1.ExecuteSqlRequest.QueryOptions other =
          (com.google.spanner.v1.ExecuteSqlRequest.QueryOptions) obj;

      if (!getOptimizerVersion().equals(other.getOptimizerVersion())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + OPTIMIZER_VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getOptimizerVersion().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.spanner.v1.ExecuteSqlRequest.QueryOptions parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.ExecuteSqlRequest.QueryOptions parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.ExecuteSqlRequest.QueryOptions parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.ExecuteSqlRequest.QueryOptions parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.ExecuteSqlRequest.QueryOptions parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.ExecuteSqlRequest.QueryOptions parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.ExecuteSqlRequest.QueryOptions parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.ExecuteSqlRequest.QueryOptions parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.ExecuteSqlRequest.QueryOptions parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.ExecuteSqlRequest.QueryOptions parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.ExecuteSqlRequest.QueryOptions parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.ExecuteSqlRequest.QueryOptions parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.spanner.v1.ExecuteSqlRequest.QueryOptions prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Query optimizer configuration.
     * </pre>
     *
     * Protobuf type {@code google.spanner.v1.ExecuteSqlRequest.QueryOptions}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.spanner.v1.ExecuteSqlRequest.QueryOptions)
        com.google.spanner.v1.ExecuteSqlRequest.QueryOptionsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.spanner.v1.SpannerProto
            .internal_static_google_spanner_v1_ExecuteSqlRequest_QueryOptions_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.spanner.v1.SpannerProto
            .internal_static_google_spanner_v1_ExecuteSqlRequest_QueryOptions_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.class,
                com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.Builder.class);
      }

      // Construct using com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        optimizerVersion_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.spanner.v1.SpannerProto
            .internal_static_google_spanner_v1_ExecuteSqlRequest_QueryOptions_descriptor;
      }

      @java.lang.Override
      public com.google.spanner.v1.ExecuteSqlRequest.QueryOptions getDefaultInstanceForType() {
        return com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.spanner.v1.ExecuteSqlRequest.QueryOptions build() {
        com.google.spanner.v1.ExecuteSqlRequest.QueryOptions result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.spanner.v1.ExecuteSqlRequest.QueryOptions buildPartial() {
        com.google.spanner.v1.ExecuteSqlRequest.QueryOptions result =
            new com.google.spanner.v1.ExecuteSqlRequest.QueryOptions(this);
        result.optimizerVersion_ = optimizerVersion_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.spanner.v1.ExecuteSqlRequest.QueryOptions) {
          return mergeFrom((com.google.spanner.v1.ExecuteSqlRequest.QueryOptions) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.spanner.v1.ExecuteSqlRequest.QueryOptions other) {
        if (other == com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.getDefaultInstance())
          return this;
        if (!other.getOptimizerVersion().isEmpty()) {
          optimizerVersion_ = other.optimizerVersion_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.spanner.v1.ExecuteSqlRequest.QueryOptions parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.spanner.v1.ExecuteSqlRequest.QueryOptions) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object optimizerVersion_ = "";
      /**
       *
       *
       * <pre>
       * An option to control the selection of optimizer version.
       * This parameter allows individual queries to pick different query
       * optimizer versions.
       * Specifying "latest" as a value instructs Cloud Spanner to use the
       * latest supported query optimizer version. If not specified, Cloud Spanner
       * uses optimizer version set at the database level options. Any other
       * positive integer (from the list of supported optimizer versions)
       * overrides the default optimizer version for query execution.
       * The list of supported optimizer versions can be queried from
       * SPANNER_SYS.SUPPORTED_OPTIMIZER_VERSIONS. Executing a SQL statement
       * with an invalid optimizer version will fail with a syntax error
       * (`INVALID_ARGUMENT`) status.
       * The `optimizer_version` statement hint has precedence over this setting.
       * </pre>
       *
       * <code>string optimizer_version = 1;</code>
       *
       * @return The optimizerVersion.
       */
      public java.lang.String getOptimizerVersion() {
        java.lang.Object ref = optimizerVersion_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          optimizerVersion_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * An option to control the selection of optimizer version.
       * This parameter allows individual queries to pick different query
       * optimizer versions.
       * Specifying "latest" as a value instructs Cloud Spanner to use the
       * latest supported query optimizer version. If not specified, Cloud Spanner
       * uses optimizer version set at the database level options. Any other
       * positive integer (from the list of supported optimizer versions)
       * overrides the default optimizer version for query execution.
       * The list of supported optimizer versions can be queried from
       * SPANNER_SYS.SUPPORTED_OPTIMIZER_VERSIONS. Executing a SQL statement
       * with an invalid optimizer version will fail with a syntax error
       * (`INVALID_ARGUMENT`) status.
       * The `optimizer_version` statement hint has precedence over this setting.
       * </pre>
       *
       * <code>string optimizer_version = 1;</code>
       *
       * @return The bytes for optimizerVersion.
       */
      public com.google.protobuf.ByteString getOptimizerVersionBytes() {
        java.lang.Object ref = optimizerVersion_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          optimizerVersion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * An option to control the selection of optimizer version.
       * This parameter allows individual queries to pick different query
       * optimizer versions.
       * Specifying "latest" as a value instructs Cloud Spanner to use the
       * latest supported query optimizer version. If not specified, Cloud Spanner
       * uses optimizer version set at the database level options. Any other
       * positive integer (from the list of supported optimizer versions)
       * overrides the default optimizer version for query execution.
       * The list of supported optimizer versions can be queried from
       * SPANNER_SYS.SUPPORTED_OPTIMIZER_VERSIONS. Executing a SQL statement
       * with an invalid optimizer version will fail with a syntax error
       * (`INVALID_ARGUMENT`) status.
       * The `optimizer_version` statement hint has precedence over this setting.
       * </pre>
       *
       * <code>string optimizer_version = 1;</code>
       *
       * @param value The optimizerVersion to set.
       * @return This builder for chaining.
       */
      public Builder setOptimizerVersion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        optimizerVersion_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An option to control the selection of optimizer version.
       * This parameter allows individual queries to pick different query
       * optimizer versions.
       * Specifying "latest" as a value instructs Cloud Spanner to use the
       * latest supported query optimizer version. If not specified, Cloud Spanner
       * uses optimizer version set at the database level options. Any other
       * positive integer (from the list of supported optimizer versions)
       * overrides the default optimizer version for query execution.
       * The list of supported optimizer versions can be queried from
       * SPANNER_SYS.SUPPORTED_OPTIMIZER_VERSIONS. Executing a SQL statement
       * with an invalid optimizer version will fail with a syntax error
       * (`INVALID_ARGUMENT`) status.
       * The `optimizer_version` statement hint has precedence over this setting.
       * </pre>
       *
       * <code>string optimizer_version = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOptimizerVersion() {

        optimizerVersion_ = getDefaultInstance().getOptimizerVersion();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An option to control the selection of optimizer version.
       * This parameter allows individual queries to pick different query
       * optimizer versions.
       * Specifying "latest" as a value instructs Cloud Spanner to use the
       * latest supported query optimizer version. If not specified, Cloud Spanner
       * uses optimizer version set at the database level options. Any other
       * positive integer (from the list of supported optimizer versions)
       * overrides the default optimizer version for query execution.
       * The list of supported optimizer versions can be queried from
       * SPANNER_SYS.SUPPORTED_OPTIMIZER_VERSIONS. Executing a SQL statement
       * with an invalid optimizer version will fail with a syntax error
       * (`INVALID_ARGUMENT`) status.
       * The `optimizer_version` statement hint has precedence over this setting.
       * </pre>
       *
       * <code>string optimizer_version = 1;</code>
       *
       * @param value The bytes for optimizerVersion to set.
       * @return This builder for chaining.
       */
      public Builder setOptimizerVersionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        optimizerVersion_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.spanner.v1.ExecuteSqlRequest.QueryOptions)
    }

    // @@protoc_insertion_point(class_scope:google.spanner.v1.ExecuteSqlRequest.QueryOptions)
    private static final com.google.spanner.v1.ExecuteSqlRequest.QueryOptions DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.spanner.v1.ExecuteSqlRequest.QueryOptions();
    }

    public static com.google.spanner.v1.ExecuteSqlRequest.QueryOptions getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<QueryOptions> PARSER =
        new com.google.protobuf.AbstractParser<QueryOptions>() {
          @java.lang.Override
          public QueryOptions parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new QueryOptions(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<QueryOptions> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<QueryOptions> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.spanner.v1.ExecuteSqlRequest.QueryOptions getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int SESSION_FIELD_NUMBER = 1;
  private volatile java.lang.Object session_;
  /**
   *
   *
   * <pre>
   * Required. The session in which the SQL query should be performed.
   * </pre>
   *
   * <code>
   * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The session.
   */
  @java.lang.Override
  public java.lang.String getSession() {
    java.lang.Object ref = session_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      session_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The session in which the SQL query should be performed.
   * </pre>
   *
   * <code>
   * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for session.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSessionBytes() {
    java.lang.Object ref = session_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      session_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRANSACTION_FIELD_NUMBER = 2;
  private com.google.spanner.v1.TransactionSelector transaction_;
  /**
   *
   *
   * <pre>
   * The transaction to use.
   * For queries, if none is provided, the default is a temporary read-only
   * transaction with strong concurrency.
   * Standard DML statements require a read-write transaction. To protect
   * against replays, single-use transactions are not supported.  The caller
   * must either supply an existing transaction ID or begin a new transaction.
   * Partitioned DML requires an existing Partitioned DML transaction ID.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
   *
   * @return Whether the transaction field is set.
   */
  @java.lang.Override
  public boolean hasTransaction() {
    return transaction_ != null;
  }
  /**
   *
   *
   * <pre>
   * The transaction to use.
   * For queries, if none is provided, the default is a temporary read-only
   * transaction with strong concurrency.
   * Standard DML statements require a read-write transaction. To protect
   * against replays, single-use transactions are not supported.  The caller
   * must either supply an existing transaction ID or begin a new transaction.
   * Partitioned DML requires an existing Partitioned DML transaction ID.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
   *
   * @return The transaction.
   */
  @java.lang.Override
  public com.google.spanner.v1.TransactionSelector getTransaction() {
    return transaction_ == null
        ? com.google.spanner.v1.TransactionSelector.getDefaultInstance()
        : transaction_;
  }
  /**
   *
   *
   * <pre>
   * The transaction to use.
   * For queries, if none is provided, the default is a temporary read-only
   * transaction with strong concurrency.
   * Standard DML statements require a read-write transaction. To protect
   * against replays, single-use transactions are not supported.  The caller
   * must either supply an existing transaction ID or begin a new transaction.
   * Partitioned DML requires an existing Partitioned DML transaction ID.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.TransactionSelectorOrBuilder getTransactionOrBuilder() {
    return getTransaction();
  }

  public static final int SQL_FIELD_NUMBER = 3;
  private volatile java.lang.Object sql_;
  /**
   *
   *
   * <pre>
   * Required. The SQL string.
   * </pre>
   *
   * <code>string sql = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The sql.
   */
  @java.lang.Override
  public java.lang.String getSql() {
    java.lang.Object ref = sql_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sql_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The SQL string.
   * </pre>
   *
   * <code>string sql = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for sql.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSqlBytes() {
    java.lang.Object ref = sql_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sql_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARAMS_FIELD_NUMBER = 4;
  private com.google.protobuf.Struct params_;
  /**
   *
   *
   * <pre>
   * Parameter names and values that bind to placeholders in the SQL string.
   * A parameter placeholder consists of the `&#64;` character followed by the
   * parameter name (for example, `&#64;firstName`). Parameter names can contain
   * letters, numbers, and underscores.
   * Parameters can appear anywhere that a literal value is expected.  The same
   * parameter name can be used more than once, for example:
   * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
   * It is an error to execute a SQL statement with unbound parameters.
   * </pre>
   *
   * <code>.google.protobuf.Struct params = 4;</code>
   *
   * @return Whether the params field is set.
   */
  @java.lang.Override
  public boolean hasParams() {
    return params_ != null;
  }
  /**
   *
   *
   * <pre>
   * Parameter names and values that bind to placeholders in the SQL string.
   * A parameter placeholder consists of the `&#64;` character followed by the
   * parameter name (for example, `&#64;firstName`). Parameter names can contain
   * letters, numbers, and underscores.
   * Parameters can appear anywhere that a literal value is expected.  The same
   * parameter name can be used more than once, for example:
   * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
   * It is an error to execute a SQL statement with unbound parameters.
   * </pre>
   *
   * <code>.google.protobuf.Struct params = 4;</code>
   *
   * @return The params.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getParams() {
    return params_ == null ? com.google.protobuf.Struct.getDefaultInstance() : params_;
  }
  /**
   *
   *
   * <pre>
   * Parameter names and values that bind to placeholders in the SQL string.
   * A parameter placeholder consists of the `&#64;` character followed by the
   * parameter name (for example, `&#64;firstName`). Parameter names can contain
   * letters, numbers, and underscores.
   * Parameters can appear anywhere that a literal value is expected.  The same
   * parameter name can be used more than once, for example:
   * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
   * It is an error to execute a SQL statement with unbound parameters.
   * </pre>
   *
   * <code>.google.protobuf.Struct params = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getParamsOrBuilder() {
    return getParams();
  }

  public static final int PARAM_TYPES_FIELD_NUMBER = 5;

  private static final class ParamTypesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, com.google.spanner.v1.Type>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.spanner.v1.Type>newDefaultInstance(
                    com.google.spanner.v1.SpannerProto
                        .internal_static_google_spanner_v1_ExecuteSqlRequest_ParamTypesEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.spanner.v1.Type.getDefaultInstance());
  }

  private com.google.protobuf.MapField<java.lang.String, com.google.spanner.v1.Type> paramTypes_;

  private com.google.protobuf.MapField<java.lang.String, com.google.spanner.v1.Type>
      internalGetParamTypes() {
    if (paramTypes_ == null) {
      return com.google.protobuf.MapField.emptyMapField(ParamTypesDefaultEntryHolder.defaultEntry);
    }
    return paramTypes_;
  }

  public int getParamTypesCount() {
    return internalGetParamTypes().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * It is not always possible for Cloud Spanner to infer the right SQL type
   * from a JSON value.  For example, values of type `BYTES` and values
   * of type `STRING` both appear in [params][google.spanner.v1.ExecuteSqlRequest.params] as JSON strings.
   * In these cases, `param_types` can be used to specify the exact
   * SQL type for some or all of the SQL statement parameters. See the
   * definition of [Type][google.spanner.v1.Type] for more information
   * about SQL types.
   * </pre>
   *
   * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
   */
  @java.lang.Override
  public boolean containsParamTypes(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    return internalGetParamTypes().getMap().containsKey(key);
  }
  /** Use {@link #getParamTypesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.spanner.v1.Type> getParamTypes() {
    return getParamTypesMap();
  }
  /**
   *
   *
   * <pre>
   * It is not always possible for Cloud Spanner to infer the right SQL type
   * from a JSON value.  For example, values of type `BYTES` and values
   * of type `STRING` both appear in [params][google.spanner.v1.ExecuteSqlRequest.params] as JSON strings.
   * In these cases, `param_types` can be used to specify the exact
   * SQL type for some or all of the SQL statement parameters. See the
   * definition of [Type][google.spanner.v1.Type] for more information
   * about SQL types.
   * </pre>
   *
   * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.spanner.v1.Type> getParamTypesMap() {
    return internalGetParamTypes().getMap();
  }
  /**
   *
   *
   * <pre>
   * It is not always possible for Cloud Spanner to infer the right SQL type
   * from a JSON value.  For example, values of type `BYTES` and values
   * of type `STRING` both appear in [params][google.spanner.v1.ExecuteSqlRequest.params] as JSON strings.
   * In these cases, `param_types` can be used to specify the exact
   * SQL type for some or all of the SQL statement parameters. See the
   * definition of [Type][google.spanner.v1.Type] for more information
   * about SQL types.
   * </pre>
   *
   * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.Type getParamTypesOrDefault(
      java.lang.String key, com.google.spanner.v1.Type defaultValue) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, com.google.spanner.v1.Type> map =
        internalGetParamTypes().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * It is not always possible for Cloud Spanner to infer the right SQL type
   * from a JSON value.  For example, values of type `BYTES` and values
   * of type `STRING` both appear in [params][google.spanner.v1.ExecuteSqlRequest.params] as JSON strings.
   * In these cases, `param_types` can be used to specify the exact
   * SQL type for some or all of the SQL statement parameters. See the
   * definition of [Type][google.spanner.v1.Type] for more information
   * about SQL types.
   * </pre>
   *
   * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.Type getParamTypesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, com.google.spanner.v1.Type> map =
        internalGetParamTypes().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int RESUME_TOKEN_FIELD_NUMBER = 6;
  private com.google.protobuf.ByteString resumeToken_;
  /**
   *
   *
   * <pre>
   * If this request is resuming a previously interrupted SQL statement
   * execution, `resume_token` should be copied from the last
   * [PartialResultSet][google.spanner.v1.PartialResultSet] yielded before the interruption. Doing this
   * enables the new SQL statement execution to resume where the last one left
   * off. The rest of the request parameters must exactly match the
   * request that yielded this token.
   * </pre>
   *
   * <code>bytes resume_token = 6;</code>
   *
   * @return The resumeToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResumeToken() {
    return resumeToken_;
  }

  public static final int QUERY_MODE_FIELD_NUMBER = 7;
  private int queryMode_;
  /**
   *
   *
   * <pre>
   * Used to control the amount of debugging information returned in
   * [ResultSetStats][google.spanner.v1.ResultSetStats]. If [partition_token][google.spanner.v1.ExecuteSqlRequest.partition_token] is set, [query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode] can only
   * be set to [QueryMode.NORMAL][google.spanner.v1.ExecuteSqlRequest.QueryMode.NORMAL].
   * </pre>
   *
   * <code>.google.spanner.v1.ExecuteSqlRequest.QueryMode query_mode = 7;</code>
   *
   * @return The enum numeric value on the wire for queryMode.
   */
  @java.lang.Override
  public int getQueryModeValue() {
    return queryMode_;
  }
  /**
   *
   *
   * <pre>
   * Used to control the amount of debugging information returned in
   * [ResultSetStats][google.spanner.v1.ResultSetStats]. If [partition_token][google.spanner.v1.ExecuteSqlRequest.partition_token] is set, [query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode] can only
   * be set to [QueryMode.NORMAL][google.spanner.v1.ExecuteSqlRequest.QueryMode.NORMAL].
   * </pre>
   *
   * <code>.google.spanner.v1.ExecuteSqlRequest.QueryMode query_mode = 7;</code>
   *
   * @return The queryMode.
   */
  @java.lang.Override
  public com.google.spanner.v1.ExecuteSqlRequest.QueryMode getQueryMode() {
    @SuppressWarnings("deprecation")
    com.google.spanner.v1.ExecuteSqlRequest.QueryMode result =
        com.google.spanner.v1.ExecuteSqlRequest.QueryMode.valueOf(queryMode_);
    return result == null ? com.google.spanner.v1.ExecuteSqlRequest.QueryMode.UNRECOGNIZED : result;
  }

  public static final int PARTITION_TOKEN_FIELD_NUMBER = 8;
  private com.google.protobuf.ByteString partitionToken_;
  /**
   *
   *
   * <pre>
   * If present, results will be restricted to the specified partition
   * previously created using PartitionQuery().  There must be an exact
   * match for the values of fields common to this message and the
   * PartitionQueryRequest message used to create this partition_token.
   * </pre>
   *
   * <code>bytes partition_token = 8;</code>
   *
   * @return The partitionToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPartitionToken() {
    return partitionToken_;
  }

  public static final int SEQNO_FIELD_NUMBER = 9;
  private long seqno_;
  /**
   *
   *
   * <pre>
   * A per-transaction sequence number used to identify this request. This field
   * makes each request idempotent such that if the request is received multiple
   * times, at most one will succeed.
   * The sequence number must be monotonically increasing within the
   * transaction. If a request arrives for the first time with an out-of-order
   * sequence number, the transaction may be aborted. Replays of previously
   * handled requests will yield the same response as the first execution.
   * Required for DML statements. Ignored for queries.
   * </pre>
   *
   * <code>int64 seqno = 9;</code>
   *
   * @return The seqno.
   */
  @java.lang.Override
  public long getSeqno() {
    return seqno_;
  }

  public static final int QUERY_OPTIONS_FIELD_NUMBER = 10;
  private com.google.spanner.v1.ExecuteSqlRequest.QueryOptions queryOptions_;
  /**
   *
   *
   * <pre>
   * Query optimizer configuration to use for the given query.
   * </pre>
   *
   * <code>.google.spanner.v1.ExecuteSqlRequest.QueryOptions query_options = 10;</code>
   *
   * @return Whether the queryOptions field is set.
   */
  @java.lang.Override
  public boolean hasQueryOptions() {
    return queryOptions_ != null;
  }
  /**
   *
   *
   * <pre>
   * Query optimizer configuration to use for the given query.
   * </pre>
   *
   * <code>.google.spanner.v1.ExecuteSqlRequest.QueryOptions query_options = 10;</code>
   *
   * @return The queryOptions.
   */
  @java.lang.Override
  public com.google.spanner.v1.ExecuteSqlRequest.QueryOptions getQueryOptions() {
    return queryOptions_ == null
        ? com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.getDefaultInstance()
        : queryOptions_;
  }
  /**
   *
   *
   * <pre>
   * Query optimizer configuration to use for the given query.
   * </pre>
   *
   * <code>.google.spanner.v1.ExecuteSqlRequest.QueryOptions query_options = 10;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.ExecuteSqlRequest.QueryOptionsOrBuilder getQueryOptionsOrBuilder() {
    return getQueryOptions();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getSessionBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, session_);
    }
    if (transaction_ != null) {
      output.writeMessage(2, getTransaction());
    }
    if (!getSqlBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, sql_);
    }
    if (params_ != null) {
      output.writeMessage(4, getParams());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetParamTypes(), ParamTypesDefaultEntryHolder.defaultEntry, 5);
    if (!resumeToken_.isEmpty()) {
      output.writeBytes(6, resumeToken_);
    }
    if (queryMode_ != com.google.spanner.v1.ExecuteSqlRequest.QueryMode.NORMAL.getNumber()) {
      output.writeEnum(7, queryMode_);
    }
    if (!partitionToken_.isEmpty()) {
      output.writeBytes(8, partitionToken_);
    }
    if (seqno_ != 0L) {
      output.writeInt64(9, seqno_);
    }
    if (queryOptions_ != null) {
      output.writeMessage(10, getQueryOptions());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getSessionBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, session_);
    }
    if (transaction_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getTransaction());
    }
    if (!getSqlBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, sql_);
    }
    if (params_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getParams());
    }
    for (java.util.Map.Entry<java.lang.String, com.google.spanner.v1.Type> entry :
        internalGetParamTypes().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.spanner.v1.Type> paramTypes__ =
          ParamTypesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, paramTypes__);
    }
    if (!resumeToken_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(6, resumeToken_);
    }
    if (queryMode_ != com.google.spanner.v1.ExecuteSqlRequest.QueryMode.NORMAL.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, queryMode_);
    }
    if (!partitionToken_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(8, partitionToken_);
    }
    if (seqno_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(9, seqno_);
    }
    if (queryOptions_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getQueryOptions());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.v1.ExecuteSqlRequest)) {
      return super.equals(obj);
    }
    com.google.spanner.v1.ExecuteSqlRequest other = (com.google.spanner.v1.ExecuteSqlRequest) obj;

    if (!getSession().equals(other.getSession())) return false;
    if (hasTransaction() != other.hasTransaction()) return false;
    if (hasTransaction()) {
      if (!getTransaction().equals(other.getTransaction())) return false;
    }
    if (!getSql().equals(other.getSql())) return false;
    if (hasParams() != other.hasParams()) return false;
    if (hasParams()) {
      if (!getParams().equals(other.getParams())) return false;
    }
    if (!internalGetParamTypes().equals(other.internalGetParamTypes())) return false;
    if (!getResumeToken().equals(other.getResumeToken())) return false;
    if (queryMode_ != other.queryMode_) return false;
    if (!getPartitionToken().equals(other.getPartitionToken())) return false;
    if (getSeqno() != other.getSeqno()) return false;
    if (hasQueryOptions() != other.hasQueryOptions()) return false;
    if (hasQueryOptions()) {
      if (!getQueryOptions().equals(other.getQueryOptions())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SESSION_FIELD_NUMBER;
    hash = (53 * hash) + getSession().hashCode();
    if (hasTransaction()) {
      hash = (37 * hash) + TRANSACTION_FIELD_NUMBER;
      hash = (53 * hash) + getTransaction().hashCode();
    }
    hash = (37 * hash) + SQL_FIELD_NUMBER;
    hash = (53 * hash) + getSql().hashCode();
    if (hasParams()) {
      hash = (37 * hash) + PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getParams().hashCode();
    }
    if (!internalGetParamTypes().getMap().isEmpty()) {
      hash = (37 * hash) + PARAM_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetParamTypes().hashCode();
    }
    hash = (37 * hash) + RESUME_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getResumeToken().hashCode();
    hash = (37 * hash) + QUERY_MODE_FIELD_NUMBER;
    hash = (53 * hash) + queryMode_;
    hash = (37 * hash) + PARTITION_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPartitionToken().hashCode();
    hash = (37 * hash) + SEQNO_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getSeqno());
    if (hasQueryOptions()) {
      hash = (37 * hash) + QUERY_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getQueryOptions().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.v1.ExecuteSqlRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.ExecuteSqlRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.ExecuteSqlRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.ExecuteSqlRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.ExecuteSqlRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.ExecuteSqlRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.ExecuteSqlRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.ExecuteSqlRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.ExecuteSqlRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.ExecuteSqlRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.ExecuteSqlRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.ExecuteSqlRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.v1.ExecuteSqlRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request for [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] and
   * [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql].
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.ExecuteSqlRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.v1.ExecuteSqlRequest)
      com.google.spanner.v1.ExecuteSqlRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_ExecuteSqlRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 5:
          return internalGetParamTypes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 5:
          return internalGetMutableParamTypes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_ExecuteSqlRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.ExecuteSqlRequest.class,
              com.google.spanner.v1.ExecuteSqlRequest.Builder.class);
    }

    // Construct using com.google.spanner.v1.ExecuteSqlRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      session_ = "";

      if (transactionBuilder_ == null) {
        transaction_ = null;
      } else {
        transaction_ = null;
        transactionBuilder_ = null;
      }
      sql_ = "";

      if (paramsBuilder_ == null) {
        params_ = null;
      } else {
        params_ = null;
        paramsBuilder_ = null;
      }
      internalGetMutableParamTypes().clear();
      resumeToken_ = com.google.protobuf.ByteString.EMPTY;

      queryMode_ = 0;

      partitionToken_ = com.google.protobuf.ByteString.EMPTY;

      seqno_ = 0L;

      if (queryOptionsBuilder_ == null) {
        queryOptions_ = null;
      } else {
        queryOptions_ = null;
        queryOptionsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_ExecuteSqlRequest_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.v1.ExecuteSqlRequest getDefaultInstanceForType() {
      return com.google.spanner.v1.ExecuteSqlRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.v1.ExecuteSqlRequest build() {
      com.google.spanner.v1.ExecuteSqlRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.v1.ExecuteSqlRequest buildPartial() {
      com.google.spanner.v1.ExecuteSqlRequest result =
          new com.google.spanner.v1.ExecuteSqlRequest(this);
      int from_bitField0_ = bitField0_;
      result.session_ = session_;
      if (transactionBuilder_ == null) {
        result.transaction_ = transaction_;
      } else {
        result.transaction_ = transactionBuilder_.build();
      }
      result.sql_ = sql_;
      if (paramsBuilder_ == null) {
        result.params_ = params_;
      } else {
        result.params_ = paramsBuilder_.build();
      }
      result.paramTypes_ = internalGetParamTypes();
      result.paramTypes_.makeImmutable();
      result.resumeToken_ = resumeToken_;
      result.queryMode_ = queryMode_;
      result.partitionToken_ = partitionToken_;
      result.seqno_ = seqno_;
      if (queryOptionsBuilder_ == null) {
        result.queryOptions_ = queryOptions_;
      } else {
        result.queryOptions_ = queryOptionsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.v1.ExecuteSqlRequest) {
        return mergeFrom((com.google.spanner.v1.ExecuteSqlRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.v1.ExecuteSqlRequest other) {
      if (other == com.google.spanner.v1.ExecuteSqlRequest.getDefaultInstance()) return this;
      if (!other.getSession().isEmpty()) {
        session_ = other.session_;
        onChanged();
      }
      if (other.hasTransaction()) {
        mergeTransaction(other.getTransaction());
      }
      if (!other.getSql().isEmpty()) {
        sql_ = other.sql_;
        onChanged();
      }
      if (other.hasParams()) {
        mergeParams(other.getParams());
      }
      internalGetMutableParamTypes().mergeFrom(other.internalGetParamTypes());
      if (other.getResumeToken() != com.google.protobuf.ByteString.EMPTY) {
        setResumeToken(other.getResumeToken());
      }
      if (other.queryMode_ != 0) {
        setQueryModeValue(other.getQueryModeValue());
      }
      if (other.getPartitionToken() != com.google.protobuf.ByteString.EMPTY) {
        setPartitionToken(other.getPartitionToken());
      }
      if (other.getSeqno() != 0L) {
        setSeqno(other.getSeqno());
      }
      if (other.hasQueryOptions()) {
        mergeQueryOptions(other.getQueryOptions());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.spanner.v1.ExecuteSqlRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.spanner.v1.ExecuteSqlRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object session_ = "";
    /**
     *
     *
     * <pre>
     * Required. The session in which the SQL query should be performed.
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The session.
     */
    public java.lang.String getSession() {
      java.lang.Object ref = session_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        session_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The session in which the SQL query should be performed.
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for session.
     */
    public com.google.protobuf.ByteString getSessionBytes() {
      java.lang.Object ref = session_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        session_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The session in which the SQL query should be performed.
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The session to set.
     * @return This builder for chaining.
     */
    public Builder setSession(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      session_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The session in which the SQL query should be performed.
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSession() {

      session_ = getDefaultInstance().getSession();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The session in which the SQL query should be performed.
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for session to set.
     * @return This builder for chaining.
     */
    public Builder setSessionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      session_ = value;
      onChanged();
      return this;
    }

    private com.google.spanner.v1.TransactionSelector transaction_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.TransactionSelector,
            com.google.spanner.v1.TransactionSelector.Builder,
            com.google.spanner.v1.TransactionSelectorOrBuilder>
        transactionBuilder_;
    /**
     *
     *
     * <pre>
     * The transaction to use.
     * For queries, if none is provided, the default is a temporary read-only
     * transaction with strong concurrency.
     * Standard DML statements require a read-write transaction. To protect
     * against replays, single-use transactions are not supported.  The caller
     * must either supply an existing transaction ID or begin a new transaction.
     * Partitioned DML requires an existing Partitioned DML transaction ID.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     *
     * @return Whether the transaction field is set.
     */
    public boolean hasTransaction() {
      return transactionBuilder_ != null || transaction_ != null;
    }
    /**
     *
     *
     * <pre>
     * The transaction to use.
     * For queries, if none is provided, the default is a temporary read-only
     * transaction with strong concurrency.
     * Standard DML statements require a read-write transaction. To protect
     * against replays, single-use transactions are not supported.  The caller
     * must either supply an existing transaction ID or begin a new transaction.
     * Partitioned DML requires an existing Partitioned DML transaction ID.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     *
     * @return The transaction.
     */
    public com.google.spanner.v1.TransactionSelector getTransaction() {
      if (transactionBuilder_ == null) {
        return transaction_ == null
            ? com.google.spanner.v1.TransactionSelector.getDefaultInstance()
            : transaction_;
      } else {
        return transactionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The transaction to use.
     * For queries, if none is provided, the default is a temporary read-only
     * transaction with strong concurrency.
     * Standard DML statements require a read-write transaction. To protect
     * against replays, single-use transactions are not supported.  The caller
     * must either supply an existing transaction ID or begin a new transaction.
     * Partitioned DML requires an existing Partitioned DML transaction ID.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     */
    public Builder setTransaction(com.google.spanner.v1.TransactionSelector value) {
      if (transactionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transaction_ = value;
        onChanged();
      } else {
        transactionBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The transaction to use.
     * For queries, if none is provided, the default is a temporary read-only
     * transaction with strong concurrency.
     * Standard DML statements require a read-write transaction. To protect
     * against replays, single-use transactions are not supported.  The caller
     * must either supply an existing transaction ID or begin a new transaction.
     * Partitioned DML requires an existing Partitioned DML transaction ID.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     */
    public Builder setTransaction(
        com.google.spanner.v1.TransactionSelector.Builder builderForValue) {
      if (transactionBuilder_ == null) {
        transaction_ = builderForValue.build();
        onChanged();
      } else {
        transactionBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The transaction to use.
     * For queries, if none is provided, the default is a temporary read-only
     * transaction with strong concurrency.
     * Standard DML statements require a read-write transaction. To protect
     * against replays, single-use transactions are not supported.  The caller
     * must either supply an existing transaction ID or begin a new transaction.
     * Partitioned DML requires an existing Partitioned DML transaction ID.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     */
    public Builder mergeTransaction(com.google.spanner.v1.TransactionSelector value) {
      if (transactionBuilder_ == null) {
        if (transaction_ != null) {
          transaction_ =
              com.google.spanner.v1.TransactionSelector.newBuilder(transaction_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          transaction_ = value;
        }
        onChanged();
      } else {
        transactionBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The transaction to use.
     * For queries, if none is provided, the default is a temporary read-only
     * transaction with strong concurrency.
     * Standard DML statements require a read-write transaction. To protect
     * against replays, single-use transactions are not supported.  The caller
     * must either supply an existing transaction ID or begin a new transaction.
     * Partitioned DML requires an existing Partitioned DML transaction ID.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     */
    public Builder clearTransaction() {
      if (transactionBuilder_ == null) {
        transaction_ = null;
        onChanged();
      } else {
        transaction_ = null;
        transactionBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The transaction to use.
     * For queries, if none is provided, the default is a temporary read-only
     * transaction with strong concurrency.
     * Standard DML statements require a read-write transaction. To protect
     * against replays, single-use transactions are not supported.  The caller
     * must either supply an existing transaction ID or begin a new transaction.
     * Partitioned DML requires an existing Partitioned DML transaction ID.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     */
    public com.google.spanner.v1.TransactionSelector.Builder getTransactionBuilder() {

      onChanged();
      return getTransactionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The transaction to use.
     * For queries, if none is provided, the default is a temporary read-only
     * transaction with strong concurrency.
     * Standard DML statements require a read-write transaction. To protect
     * against replays, single-use transactions are not supported.  The caller
     * must either supply an existing transaction ID or begin a new transaction.
     * Partitioned DML requires an existing Partitioned DML transaction ID.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     */
    public com.google.spanner.v1.TransactionSelectorOrBuilder getTransactionOrBuilder() {
      if (transactionBuilder_ != null) {
        return transactionBuilder_.getMessageOrBuilder();
      } else {
        return transaction_ == null
            ? com.google.spanner.v1.TransactionSelector.getDefaultInstance()
            : transaction_;
      }
    }
    /**
     *
     *
     * <pre>
     * The transaction to use.
     * For queries, if none is provided, the default is a temporary read-only
     * transaction with strong concurrency.
     * Standard DML statements require a read-write transaction. To protect
     * against replays, single-use transactions are not supported.  The caller
     * must either supply an existing transaction ID or begin a new transaction.
     * Partitioned DML requires an existing Partitioned DML transaction ID.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.TransactionSelector,
            com.google.spanner.v1.TransactionSelector.Builder,
            com.google.spanner.v1.TransactionSelectorOrBuilder>
        getTransactionFieldBuilder() {
      if (transactionBuilder_ == null) {
        transactionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.TransactionSelector,
                com.google.spanner.v1.TransactionSelector.Builder,
                com.google.spanner.v1.TransactionSelectorOrBuilder>(
                getTransaction(), getParentForChildren(), isClean());
        transaction_ = null;
      }
      return transactionBuilder_;
    }

    private java.lang.Object sql_ = "";
    /**
     *
     *
     * <pre>
     * Required. The SQL string.
     * </pre>
     *
     * <code>string sql = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The sql.
     */
    public java.lang.String getSql() {
      java.lang.Object ref = sql_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sql_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The SQL string.
     * </pre>
     *
     * <code>string sql = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for sql.
     */
    public com.google.protobuf.ByteString getSqlBytes() {
      java.lang.Object ref = sql_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sql_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The SQL string.
     * </pre>
     *
     * <code>string sql = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The sql to set.
     * @return This builder for chaining.
     */
    public Builder setSql(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      sql_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The SQL string.
     * </pre>
     *
     * <code>string sql = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSql() {

      sql_ = getDefaultInstance().getSql();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The SQL string.
     * </pre>
     *
     * <code>string sql = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for sql to set.
     * @return This builder for chaining.
     */
    public Builder setSqlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      sql_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Struct params_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        paramsBuilder_;
    /**
     *
     *
     * <pre>
     * Parameter names and values that bind to placeholders in the SQL string.
     * A parameter placeholder consists of the `&#64;` character followed by the
     * parameter name (for example, `&#64;firstName`). Parameter names can contain
     * letters, numbers, and underscores.
     * Parameters can appear anywhere that a literal value is expected.  The same
     * parameter name can be used more than once, for example:
     * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
     * It is an error to execute a SQL statement with unbound parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 4;</code>
     *
     * @return Whether the params field is set.
     */
    public boolean hasParams() {
      return paramsBuilder_ != null || params_ != null;
    }
    /**
     *
     *
     * <pre>
     * Parameter names and values that bind to placeholders in the SQL string.
     * A parameter placeholder consists of the `&#64;` character followed by the
     * parameter name (for example, `&#64;firstName`). Parameter names can contain
     * letters, numbers, and underscores.
     * Parameters can appear anywhere that a literal value is expected.  The same
     * parameter name can be used more than once, for example:
     * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
     * It is an error to execute a SQL statement with unbound parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 4;</code>
     *
     * @return The params.
     */
    public com.google.protobuf.Struct getParams() {
      if (paramsBuilder_ == null) {
        return params_ == null ? com.google.protobuf.Struct.getDefaultInstance() : params_;
      } else {
        return paramsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Parameter names and values that bind to placeholders in the SQL string.
     * A parameter placeholder consists of the `&#64;` character followed by the
     * parameter name (for example, `&#64;firstName`). Parameter names can contain
     * letters, numbers, and underscores.
     * Parameters can appear anywhere that a literal value is expected.  The same
     * parameter name can be used more than once, for example:
     * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
     * It is an error to execute a SQL statement with unbound parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 4;</code>
     */
    public Builder setParams(com.google.protobuf.Struct value) {
      if (paramsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        params_ = value;
        onChanged();
      } else {
        paramsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameter names and values that bind to placeholders in the SQL string.
     * A parameter placeholder consists of the `&#64;` character followed by the
     * parameter name (for example, `&#64;firstName`). Parameter names can contain
     * letters, numbers, and underscores.
     * Parameters can appear anywhere that a literal value is expected.  The same
     * parameter name can be used more than once, for example:
     * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
     * It is an error to execute a SQL statement with unbound parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 4;</code>
     */
    public Builder setParams(com.google.protobuf.Struct.Builder builderForValue) {
      if (paramsBuilder_ == null) {
        params_ = builderForValue.build();
        onChanged();
      } else {
        paramsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameter names and values that bind to placeholders in the SQL string.
     * A parameter placeholder consists of the `&#64;` character followed by the
     * parameter name (for example, `&#64;firstName`). Parameter names can contain
     * letters, numbers, and underscores.
     * Parameters can appear anywhere that a literal value is expected.  The same
     * parameter name can be used more than once, for example:
     * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
     * It is an error to execute a SQL statement with unbound parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 4;</code>
     */
    public Builder mergeParams(com.google.protobuf.Struct value) {
      if (paramsBuilder_ == null) {
        if (params_ != null) {
          params_ = com.google.protobuf.Struct.newBuilder(params_).mergeFrom(value).buildPartial();
        } else {
          params_ = value;
        }
        onChanged();
      } else {
        paramsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameter names and values that bind to placeholders in the SQL string.
     * A parameter placeholder consists of the `&#64;` character followed by the
     * parameter name (for example, `&#64;firstName`). Parameter names can contain
     * letters, numbers, and underscores.
     * Parameters can appear anywhere that a literal value is expected.  The same
     * parameter name can be used more than once, for example:
     * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
     * It is an error to execute a SQL statement with unbound parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 4;</code>
     */
    public Builder clearParams() {
      if (paramsBuilder_ == null) {
        params_ = null;
        onChanged();
      } else {
        params_ = null;
        paramsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameter names and values that bind to placeholders in the SQL string.
     * A parameter placeholder consists of the `&#64;` character followed by the
     * parameter name (for example, `&#64;firstName`). Parameter names can contain
     * letters, numbers, and underscores.
     * Parameters can appear anywhere that a literal value is expected.  The same
     * parameter name can be used more than once, for example:
     * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
     * It is an error to execute a SQL statement with unbound parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 4;</code>
     */
    public com.google.protobuf.Struct.Builder getParamsBuilder() {

      onChanged();
      return getParamsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Parameter names and values that bind to placeholders in the SQL string.
     * A parameter placeholder consists of the `&#64;` character followed by the
     * parameter name (for example, `&#64;firstName`). Parameter names can contain
     * letters, numbers, and underscores.
     * Parameters can appear anywhere that a literal value is expected.  The same
     * parameter name can be used more than once, for example:
     * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
     * It is an error to execute a SQL statement with unbound parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 4;</code>
     */
    public com.google.protobuf.StructOrBuilder getParamsOrBuilder() {
      if (paramsBuilder_ != null) {
        return paramsBuilder_.getMessageOrBuilder();
      } else {
        return params_ == null ? com.google.protobuf.Struct.getDefaultInstance() : params_;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameter names and values that bind to placeholders in the SQL string.
     * A parameter placeholder consists of the `&#64;` character followed by the
     * parameter name (for example, `&#64;firstName`). Parameter names can contain
     * letters, numbers, and underscores.
     * Parameters can appear anywhere that a literal value is expected.  The same
     * parameter name can be used more than once, for example:
     * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
     * It is an error to execute a SQL statement with unbound parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getParamsFieldBuilder() {
      if (paramsBuilder_ == null) {
        paramsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getParams(), getParentForChildren(), isClean());
        params_ = null;
      }
      return paramsBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, com.google.spanner.v1.Type> paramTypes_;

    private com.google.protobuf.MapField<java.lang.String, com.google.spanner.v1.Type>
        internalGetParamTypes() {
      if (paramTypes_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ParamTypesDefaultEntryHolder.defaultEntry);
      }
      return paramTypes_;
    }

    private com.google.protobuf.MapField<java.lang.String, com.google.spanner.v1.Type>
        internalGetMutableParamTypes() {
      onChanged();
      ;
      if (paramTypes_ == null) {
        paramTypes_ =
            com.google.protobuf.MapField.newMapField(ParamTypesDefaultEntryHolder.defaultEntry);
      }
      if (!paramTypes_.isMutable()) {
        paramTypes_ = paramTypes_.copy();
      }
      return paramTypes_;
    }

    public int getParamTypesCount() {
      return internalGetParamTypes().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * It is not always possible for Cloud Spanner to infer the right SQL type
     * from a JSON value.  For example, values of type `BYTES` and values
     * of type `STRING` both appear in [params][google.spanner.v1.ExecuteSqlRequest.params] as JSON strings.
     * In these cases, `param_types` can be used to specify the exact
     * SQL type for some or all of the SQL statement parameters. See the
     * definition of [Type][google.spanner.v1.Type] for more information
     * about SQL types.
     * </pre>
     *
     * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
     */
    @java.lang.Override
    public boolean containsParamTypes(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetParamTypes().getMap().containsKey(key);
    }
    /** Use {@link #getParamTypesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.spanner.v1.Type> getParamTypes() {
      return getParamTypesMap();
    }
    /**
     *
     *
     * <pre>
     * It is not always possible for Cloud Spanner to infer the right SQL type
     * from a JSON value.  For example, values of type `BYTES` and values
     * of type `STRING` both appear in [params][google.spanner.v1.ExecuteSqlRequest.params] as JSON strings.
     * In these cases, `param_types` can be used to specify the exact
     * SQL type for some or all of the SQL statement parameters. See the
     * definition of [Type][google.spanner.v1.Type] for more information
     * about SQL types.
     * </pre>
     *
     * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.spanner.v1.Type> getParamTypesMap() {
      return internalGetParamTypes().getMap();
    }
    /**
     *
     *
     * <pre>
     * It is not always possible for Cloud Spanner to infer the right SQL type
     * from a JSON value.  For example, values of type `BYTES` and values
     * of type `STRING` both appear in [params][google.spanner.v1.ExecuteSqlRequest.params] as JSON strings.
     * In these cases, `param_types` can be used to specify the exact
     * SQL type for some or all of the SQL statement parameters. See the
     * definition of [Type][google.spanner.v1.Type] for more information
     * about SQL types.
     * </pre>
     *
     * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
     */
    @java.lang.Override
    public com.google.spanner.v1.Type getParamTypesOrDefault(
        java.lang.String key, com.google.spanner.v1.Type defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, com.google.spanner.v1.Type> map =
          internalGetParamTypes().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * It is not always possible for Cloud Spanner to infer the right SQL type
     * from a JSON value.  For example, values of type `BYTES` and values
     * of type `STRING` both appear in [params][google.spanner.v1.ExecuteSqlRequest.params] as JSON strings.
     * In these cases, `param_types` can be used to specify the exact
     * SQL type for some or all of the SQL statement parameters. See the
     * definition of [Type][google.spanner.v1.Type] for more information
     * about SQL types.
     * </pre>
     *
     * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
     */
    @java.lang.Override
    public com.google.spanner.v1.Type getParamTypesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, com.google.spanner.v1.Type> map =
          internalGetParamTypes().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearParamTypes() {
      internalGetMutableParamTypes().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * It is not always possible for Cloud Spanner to infer the right SQL type
     * from a JSON value.  For example, values of type `BYTES` and values
     * of type `STRING` both appear in [params][google.spanner.v1.ExecuteSqlRequest.params] as JSON strings.
     * In these cases, `param_types` can be used to specify the exact
     * SQL type for some or all of the SQL statement parameters. See the
     * definition of [Type][google.spanner.v1.Type] for more information
     * about SQL types.
     * </pre>
     *
     * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
     */
    public Builder removeParamTypes(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableParamTypes().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.spanner.v1.Type> getMutableParamTypes() {
      return internalGetMutableParamTypes().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * It is not always possible for Cloud Spanner to infer the right SQL type
     * from a JSON value.  For example, values of type `BYTES` and values
     * of type `STRING` both appear in [params][google.spanner.v1.ExecuteSqlRequest.params] as JSON strings.
     * In these cases, `param_types` can be used to specify the exact
     * SQL type for some or all of the SQL statement parameters. See the
     * definition of [Type][google.spanner.v1.Type] for more information
     * about SQL types.
     * </pre>
     *
     * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
     */
    public Builder putParamTypes(java.lang.String key, com.google.spanner.v1.Type value) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      if (value == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableParamTypes().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * It is not always possible for Cloud Spanner to infer the right SQL type
     * from a JSON value.  For example, values of type `BYTES` and values
     * of type `STRING` both appear in [params][google.spanner.v1.ExecuteSqlRequest.params] as JSON strings.
     * In these cases, `param_types` can be used to specify the exact
     * SQL type for some or all of the SQL statement parameters. See the
     * definition of [Type][google.spanner.v1.Type] for more information
     * about SQL types.
     * </pre>
     *
     * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
     */
    public Builder putAllParamTypes(
        java.util.Map<java.lang.String, com.google.spanner.v1.Type> values) {
      internalGetMutableParamTypes().getMutableMap().putAll(values);
      return this;
    }

    private com.google.protobuf.ByteString resumeToken_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * If this request is resuming a previously interrupted SQL statement
     * execution, `resume_token` should be copied from the last
     * [PartialResultSet][google.spanner.v1.PartialResultSet] yielded before the interruption. Doing this
     * enables the new SQL statement execution to resume where the last one left
     * off. The rest of the request parameters must exactly match the
     * request that yielded this token.
     * </pre>
     *
     * <code>bytes resume_token = 6;</code>
     *
     * @return The resumeToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getResumeToken() {
      return resumeToken_;
    }
    /**
     *
     *
     * <pre>
     * If this request is resuming a previously interrupted SQL statement
     * execution, `resume_token` should be copied from the last
     * [PartialResultSet][google.spanner.v1.PartialResultSet] yielded before the interruption. Doing this
     * enables the new SQL statement execution to resume where the last one left
     * off. The rest of the request parameters must exactly match the
     * request that yielded this token.
     * </pre>
     *
     * <code>bytes resume_token = 6;</code>
     *
     * @param value The resumeToken to set.
     * @return This builder for chaining.
     */
    public Builder setResumeToken(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }

      resumeToken_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If this request is resuming a previously interrupted SQL statement
     * execution, `resume_token` should be copied from the last
     * [PartialResultSet][google.spanner.v1.PartialResultSet] yielded before the interruption. Doing this
     * enables the new SQL statement execution to resume where the last one left
     * off. The rest of the request parameters must exactly match the
     * request that yielded this token.
     * </pre>
     *
     * <code>bytes resume_token = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResumeToken() {

      resumeToken_ = getDefaultInstance().getResumeToken();
      onChanged();
      return this;
    }

    private int queryMode_ = 0;
    /**
     *
     *
     * <pre>
     * Used to control the amount of debugging information returned in
     * [ResultSetStats][google.spanner.v1.ResultSetStats]. If [partition_token][google.spanner.v1.ExecuteSqlRequest.partition_token] is set, [query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode] can only
     * be set to [QueryMode.NORMAL][google.spanner.v1.ExecuteSqlRequest.QueryMode.NORMAL].
     * </pre>
     *
     * <code>.google.spanner.v1.ExecuteSqlRequest.QueryMode query_mode = 7;</code>
     *
     * @return The enum numeric value on the wire for queryMode.
     */
    @java.lang.Override
    public int getQueryModeValue() {
      return queryMode_;
    }
    /**
     *
     *
     * <pre>
     * Used to control the amount of debugging information returned in
     * [ResultSetStats][google.spanner.v1.ResultSetStats]. If [partition_token][google.spanner.v1.ExecuteSqlRequest.partition_token] is set, [query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode] can only
     * be set to [QueryMode.NORMAL][google.spanner.v1.ExecuteSqlRequest.QueryMode.NORMAL].
     * </pre>
     *
     * <code>.google.spanner.v1.ExecuteSqlRequest.QueryMode query_mode = 7;</code>
     *
     * @param value The enum numeric value on the wire for queryMode to set.
     * @return This builder for chaining.
     */
    public Builder setQueryModeValue(int value) {

      queryMode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Used to control the amount of debugging information returned in
     * [ResultSetStats][google.spanner.v1.ResultSetStats]. If [partition_token][google.spanner.v1.ExecuteSqlRequest.partition_token] is set, [query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode] can only
     * be set to [QueryMode.NORMAL][google.spanner.v1.ExecuteSqlRequest.QueryMode.NORMAL].
     * </pre>
     *
     * <code>.google.spanner.v1.ExecuteSqlRequest.QueryMode query_mode = 7;</code>
     *
     * @return The queryMode.
     */
    @java.lang.Override
    public com.google.spanner.v1.ExecuteSqlRequest.QueryMode getQueryMode() {
      @SuppressWarnings("deprecation")
      com.google.spanner.v1.ExecuteSqlRequest.QueryMode result =
          com.google.spanner.v1.ExecuteSqlRequest.QueryMode.valueOf(queryMode_);
      return result == null
          ? com.google.spanner.v1.ExecuteSqlRequest.QueryMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Used to control the amount of debugging information returned in
     * [ResultSetStats][google.spanner.v1.ResultSetStats]. If [partition_token][google.spanner.v1.ExecuteSqlRequest.partition_token] is set, [query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode] can only
     * be set to [QueryMode.NORMAL][google.spanner.v1.ExecuteSqlRequest.QueryMode.NORMAL].
     * </pre>
     *
     * <code>.google.spanner.v1.ExecuteSqlRequest.QueryMode query_mode = 7;</code>
     *
     * @param value The queryMode to set.
     * @return This builder for chaining.
     */
    public Builder setQueryMode(com.google.spanner.v1.ExecuteSqlRequest.QueryMode value) {
      if (value == null) {
        throw new NullPointerException();
      }

      queryMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Used to control the amount of debugging information returned in
     * [ResultSetStats][google.spanner.v1.ResultSetStats]. If [partition_token][google.spanner.v1.ExecuteSqlRequest.partition_token] is set, [query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode] can only
     * be set to [QueryMode.NORMAL][google.spanner.v1.ExecuteSqlRequest.QueryMode.NORMAL].
     * </pre>
     *
     * <code>.google.spanner.v1.ExecuteSqlRequest.QueryMode query_mode = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQueryMode() {

      queryMode_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString partitionToken_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * If present, results will be restricted to the specified partition
     * previously created using PartitionQuery().  There must be an exact
     * match for the values of fields common to this message and the
     * PartitionQueryRequest message used to create this partition_token.
     * </pre>
     *
     * <code>bytes partition_token = 8;</code>
     *
     * @return The partitionToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPartitionToken() {
      return partitionToken_;
    }
    /**
     *
     *
     * <pre>
     * If present, results will be restricted to the specified partition
     * previously created using PartitionQuery().  There must be an exact
     * match for the values of fields common to this message and the
     * PartitionQueryRequest message used to create this partition_token.
     * </pre>
     *
     * <code>bytes partition_token = 8;</code>
     *
     * @param value The partitionToken to set.
     * @return This builder for chaining.
     */
    public Builder setPartitionToken(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }

      partitionToken_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, results will be restricted to the specified partition
     * previously created using PartitionQuery().  There must be an exact
     * match for the values of fields common to this message and the
     * PartitionQueryRequest message used to create this partition_token.
     * </pre>
     *
     * <code>bytes partition_token = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPartitionToken() {

      partitionToken_ = getDefaultInstance().getPartitionToken();
      onChanged();
      return this;
    }

    private long seqno_;
    /**
     *
     *
     * <pre>
     * A per-transaction sequence number used to identify this request. This field
     * makes each request idempotent such that if the request is received multiple
     * times, at most one will succeed.
     * The sequence number must be monotonically increasing within the
     * transaction. If a request arrives for the first time with an out-of-order
     * sequence number, the transaction may be aborted. Replays of previously
     * handled requests will yield the same response as the first execution.
     * Required for DML statements. Ignored for queries.
     * </pre>
     *
     * <code>int64 seqno = 9;</code>
     *
     * @return The seqno.
     */
    @java.lang.Override
    public long getSeqno() {
      return seqno_;
    }
    /**
     *
     *
     * <pre>
     * A per-transaction sequence number used to identify this request. This field
     * makes each request idempotent such that if the request is received multiple
     * times, at most one will succeed.
     * The sequence number must be monotonically increasing within the
     * transaction. If a request arrives for the first time with an out-of-order
     * sequence number, the transaction may be aborted. Replays of previously
     * handled requests will yield the same response as the first execution.
     * Required for DML statements. Ignored for queries.
     * </pre>
     *
     * <code>int64 seqno = 9;</code>
     *
     * @param value The seqno to set.
     * @return This builder for chaining.
     */
    public Builder setSeqno(long value) {

      seqno_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A per-transaction sequence number used to identify this request. This field
     * makes each request idempotent such that if the request is received multiple
     * times, at most one will succeed.
     * The sequence number must be monotonically increasing within the
     * transaction. If a request arrives for the first time with an out-of-order
     * sequence number, the transaction may be aborted. Replays of previously
     * handled requests will yield the same response as the first execution.
     * Required for DML statements. Ignored for queries.
     * </pre>
     *
     * <code>int64 seqno = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSeqno() {

      seqno_ = 0L;
      onChanged();
      return this;
    }

    private com.google.spanner.v1.ExecuteSqlRequest.QueryOptions queryOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.ExecuteSqlRequest.QueryOptions,
            com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.Builder,
            com.google.spanner.v1.ExecuteSqlRequest.QueryOptionsOrBuilder>
        queryOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * Query optimizer configuration to use for the given query.
     * </pre>
     *
     * <code>.google.spanner.v1.ExecuteSqlRequest.QueryOptions query_options = 10;</code>
     *
     * @return Whether the queryOptions field is set.
     */
    public boolean hasQueryOptions() {
      return queryOptionsBuilder_ != null || queryOptions_ != null;
    }
    /**
     *
     *
     * <pre>
     * Query optimizer configuration to use for the given query.
     * </pre>
     *
     * <code>.google.spanner.v1.ExecuteSqlRequest.QueryOptions query_options = 10;</code>
     *
     * @return The queryOptions.
     */
    public com.google.spanner.v1.ExecuteSqlRequest.QueryOptions getQueryOptions() {
      if (queryOptionsBuilder_ == null) {
        return queryOptions_ == null
            ? com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.getDefaultInstance()
            : queryOptions_;
      } else {
        return queryOptionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Query optimizer configuration to use for the given query.
     * </pre>
     *
     * <code>.google.spanner.v1.ExecuteSqlRequest.QueryOptions query_options = 10;</code>
     */
    public Builder setQueryOptions(com.google.spanner.v1.ExecuteSqlRequest.QueryOptions value) {
      if (queryOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queryOptions_ = value;
        onChanged();
      } else {
        queryOptionsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Query optimizer configuration to use for the given query.
     * </pre>
     *
     * <code>.google.spanner.v1.ExecuteSqlRequest.QueryOptions query_options = 10;</code>
     */
    public Builder setQueryOptions(
        com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.Builder builderForValue) {
      if (queryOptionsBuilder_ == null) {
        queryOptions_ = builderForValue.build();
        onChanged();
      } else {
        queryOptionsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Query optimizer configuration to use for the given query.
     * </pre>
     *
     * <code>.google.spanner.v1.ExecuteSqlRequest.QueryOptions query_options = 10;</code>
     */
    public Builder mergeQueryOptions(com.google.spanner.v1.ExecuteSqlRequest.QueryOptions value) {
      if (queryOptionsBuilder_ == null) {
        if (queryOptions_ != null) {
          queryOptions_ =
              com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.newBuilder(queryOptions_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          queryOptions_ = value;
        }
        onChanged();
      } else {
        queryOptionsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Query optimizer configuration to use for the given query.
     * </pre>
     *
     * <code>.google.spanner.v1.ExecuteSqlRequest.QueryOptions query_options = 10;</code>
     */
    public Builder clearQueryOptions() {
      if (queryOptionsBuilder_ == null) {
        queryOptions_ = null;
        onChanged();
      } else {
        queryOptions_ = null;
        queryOptionsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Query optimizer configuration to use for the given query.
     * </pre>
     *
     * <code>.google.spanner.v1.ExecuteSqlRequest.QueryOptions query_options = 10;</code>
     */
    public com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.Builder getQueryOptionsBuilder() {

      onChanged();
      return getQueryOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Query optimizer configuration to use for the given query.
     * </pre>
     *
     * <code>.google.spanner.v1.ExecuteSqlRequest.QueryOptions query_options = 10;</code>
     */
    public com.google.spanner.v1.ExecuteSqlRequest.QueryOptionsOrBuilder
        getQueryOptionsOrBuilder() {
      if (queryOptionsBuilder_ != null) {
        return queryOptionsBuilder_.getMessageOrBuilder();
      } else {
        return queryOptions_ == null
            ? com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.getDefaultInstance()
            : queryOptions_;
      }
    }
    /**
     *
     *
     * <pre>
     * Query optimizer configuration to use for the given query.
     * </pre>
     *
     * <code>.google.spanner.v1.ExecuteSqlRequest.QueryOptions query_options = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.ExecuteSqlRequest.QueryOptions,
            com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.Builder,
            com.google.spanner.v1.ExecuteSqlRequest.QueryOptionsOrBuilder>
        getQueryOptionsFieldBuilder() {
      if (queryOptionsBuilder_ == null) {
        queryOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.ExecuteSqlRequest.QueryOptions,
                com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.Builder,
                com.google.spanner.v1.ExecuteSqlRequest.QueryOptionsOrBuilder>(
                getQueryOptions(), getParentForChildren(), isClean());
        queryOptions_ = null;
      }
      return queryOptionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.v1.ExecuteSqlRequest)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.v1.ExecuteSqlRequest)
  private static final com.google.spanner.v1.ExecuteSqlRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.v1.ExecuteSqlRequest();
  }

  public static com.google.spanner.v1.ExecuteSqlRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExecuteSqlRequest> PARSER =
      new com.google.protobuf.AbstractParser<ExecuteSqlRequest>() {
        @java.lang.Override
        public ExecuteSqlRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ExecuteSqlRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ExecuteSqlRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExecuteSqlRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.v1.ExecuteSqlRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
