/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/v1/transaction.proto

package com.google.spanner.v1;

/**
 *
 *
 * <pre>
 * Transactions:
 * Each session can have at most one active transaction at a time (note that
 * standalone reads and queries use a transaction internally and do count
 * towards the one transaction limit). After the active transaction is
 * completed, the session can immediately be re-used for the next transaction.
 * It is not necessary to create a new session for each transaction.
 * Transaction modes:
 * Cloud Spanner supports three transaction modes:
 *   1. Locking read-write. This type of transaction is the only way
 *      to write data into Cloud Spanner. These transactions rely on
 *      pessimistic locking and, if necessary, two-phase commit.
 *      Locking read-write transactions may abort, requiring the
 *      application to retry.
 *   2. Snapshot read-only. Snapshot read-only transactions provide guaranteed
 *      consistency across several reads, but do not allow
 *      writes. Snapshot read-only transactions can be configured to read at
 *      timestamps in the past, or configured to perform a strong read
 *      (where Spanner will select a timestamp such that the read is
 *      guaranteed to see the effects of all transactions that have committed
 *      before the start of the read). Snapshot read-only transactions do not
 *      need to be committed.
 *      Queries on change streams must be performed with the snapshot read-only
 *      transaction mode, specifying a strong read. Please see
 *      [TransactionOptions.ReadOnly.strong][google.spanner.v1.TransactionOptions.ReadOnly.strong] for more details.
 *   3. Partitioned DML. This type of transaction is used to execute
 *      a single Partitioned DML statement. Partitioned DML partitions
 *      the key space and runs the DML statement over each partition
 *      in parallel using separate, internal transactions that commit
 *      independently. Partitioned DML transactions do not need to be
 *      committed.
 * For transactions that only read, snapshot read-only transactions
 * provide simpler semantics and are almost always faster. In
 * particular, read-only transactions do not take locks, so they do
 * not conflict with read-write transactions. As a consequence of not
 * taking locks, they also do not abort, so retry loops are not needed.
 * Transactions may only read-write data in a single database. They
 * may, however, read-write data in different tables within that
 * database.
 * Locking read-write transactions:
 * Locking transactions may be used to atomically read-modify-write
 * data anywhere in a database. This type of transaction is externally
 * consistent.
 * Clients should attempt to minimize the amount of time a transaction
 * is active. Faster transactions commit with higher probability
 * and cause less contention. Cloud Spanner attempts to keep read locks
 * active as long as the transaction continues to do reads, and the
 * transaction has not been terminated by
 * [Commit][google.spanner.v1.Spanner.Commit] or
 * [Rollback][google.spanner.v1.Spanner.Rollback]. Long periods of
 * inactivity at the client may cause Cloud Spanner to release a
 * transaction's locks and abort it.
 * Conceptually, a read-write transaction consists of zero or more
 * reads or SQL statements followed by
 * [Commit][google.spanner.v1.Spanner.Commit]. At any time before
 * [Commit][google.spanner.v1.Spanner.Commit], the client can send a
 * [Rollback][google.spanner.v1.Spanner.Rollback] request to abort the
 * transaction.
 * Semantics:
 * Cloud Spanner can commit the transaction if all read locks it acquired
 * are still valid at commit time, and it is able to acquire write
 * locks for all writes. Cloud Spanner can abort the transaction for any
 * reason. If a commit attempt returns `ABORTED`, Cloud Spanner guarantees
 * that the transaction has not modified any user data in Cloud Spanner.
 * Unless the transaction commits, Cloud Spanner makes no guarantees about
 * how long the transaction's locks were held for. It is an error to
 * use Cloud Spanner locks for any sort of mutual exclusion other than
 * between Cloud Spanner transactions themselves.
 * Retrying aborted transactions:
 * When a transaction aborts, the application can choose to retry the
 * whole transaction again. To maximize the chances of successfully
 * committing the retry, the client should execute the retry in the
 * same session as the original attempt. The original session's lock
 * priority increases with each consecutive abort, meaning that each
 * attempt has a slightly better chance of success than the previous.
 * Under some circumstances (for example, many transactions attempting to
 * modify the same row(s)), a transaction can abort many times in a
 * short period before successfully committing. Thus, it is not a good
 * idea to cap the number of retries a transaction can attempt;
 * instead, it is better to limit the total amount of time spent
 * retrying.
 * Idle transactions:
 * A transaction is considered idle if it has no outstanding reads or
 * SQL queries and has not started a read or SQL query within the last 10
 * seconds. Idle transactions can be aborted by Cloud Spanner so that they
 * don't hold on to locks indefinitely. If an idle transaction is aborted, the
 * commit will fail with error `ABORTED`.
 * If this behavior is undesirable, periodically executing a simple
 * SQL query in the transaction (for example, `SELECT 1`) prevents the
 * transaction from becoming idle.
 * Snapshot read-only transactions:
 * Snapshot read-only transactions provides a simpler method than
 * locking read-write transactions for doing several consistent
 * reads. However, this type of transaction does not support writes.
 * Snapshot transactions do not take locks. Instead, they work by
 * choosing a Cloud Spanner timestamp, then executing all reads at that
 * timestamp. Since they do not acquire locks, they do not block
 * concurrent read-write transactions.
 * Unlike locking read-write transactions, snapshot read-only
 * transactions never abort. They can fail if the chosen read
 * timestamp is garbage collected; however, the default garbage
 * collection policy is generous enough that most applications do not
 * need to worry about this in practice.
 * Snapshot read-only transactions do not need to call
 * [Commit][google.spanner.v1.Spanner.Commit] or
 * [Rollback][google.spanner.v1.Spanner.Rollback] (and in fact are not
 * permitted to do so).
 * To execute a snapshot transaction, the client specifies a timestamp
 * bound, which tells Cloud Spanner how to choose a read timestamp.
 * The types of timestamp bound are:
 *   - Strong (the default).
 *   - Bounded staleness.
 *   - Exact staleness.
 * If the Cloud Spanner database to be read is geographically distributed,
 * stale read-only transactions can execute more quickly than strong
 * or read-write transactions, because they are able to execute far
 * from the leader replica.
 * Each type of timestamp bound is discussed in detail below.
 * Strong: Strong reads are guaranteed to see the effects of all transactions
 * that have committed before the start of the read. Furthermore, all
 * rows yielded by a single read are consistent with each other -- if
 * any part of the read observes a transaction, all parts of the read
 * see the transaction.
 * Strong reads are not repeatable: two consecutive strong read-only
 * transactions might return inconsistent results if there are
 * concurrent writes. If consistency across reads is required, the
 * reads should be executed within a transaction or at an exact read
 * timestamp.
 * Queries on change streams (see below for more details) must also specify
 * the strong read timestamp bound.
 * See [TransactionOptions.ReadOnly.strong][google.spanner.v1.TransactionOptions.ReadOnly.strong].
 * Exact staleness:
 * These timestamp bounds execute reads at a user-specified
 * timestamp. Reads at a timestamp are guaranteed to see a consistent
 * prefix of the global transaction history: they observe
 * modifications done by all transactions with a commit timestamp less than or
 * equal to the read timestamp, and observe none of the modifications done by
 * transactions with a larger commit timestamp. They will block until
 * all conflicting transactions that may be assigned commit timestamps
 * &lt;= the read timestamp have finished.
 * The timestamp can either be expressed as an absolute Cloud Spanner commit
 * timestamp or a staleness relative to the current time.
 * These modes do not require a "negotiation phase" to pick a
 * timestamp. As a result, they execute slightly faster than the
 * equivalent boundedly stale concurrency modes. On the other hand,
 * boundedly stale reads usually return fresher results.
 * See [TransactionOptions.ReadOnly.read_timestamp][google.spanner.v1.TransactionOptions.ReadOnly.read_timestamp] and
 * [TransactionOptions.ReadOnly.exact_staleness][google.spanner.v1.TransactionOptions.ReadOnly.exact_staleness].
 * Bounded staleness:
 * Bounded staleness modes allow Cloud Spanner to pick the read timestamp,
 * subject to a user-provided staleness bound. Cloud Spanner chooses the
 * newest timestamp within the staleness bound that allows execution
 * of the reads at the closest available replica without blocking.
 * All rows yielded are consistent with each other -- if any part of
 * the read observes a transaction, all parts of the read see the
 * transaction. Boundedly stale reads are not repeatable: two stale
 * reads, even if they use the same staleness bound, can execute at
 * different timestamps and thus return inconsistent results.
 * Boundedly stale reads execute in two phases: the first phase
 * negotiates a timestamp among all replicas needed to serve the
 * read. In the second phase, reads are executed at the negotiated
 * timestamp.
 * As a result of the two phase execution, bounded staleness reads are
 * usually a little slower than comparable exact staleness
 * reads. However, they are typically able to return fresher
 * results, and are more likely to execute at the closest replica.
 * Because the timestamp negotiation requires up-front knowledge of
 * which rows will be read, it can only be used with single-use
 * read-only transactions.
 * See [TransactionOptions.ReadOnly.max_staleness][google.spanner.v1.TransactionOptions.ReadOnly.max_staleness] and
 * [TransactionOptions.ReadOnly.min_read_timestamp][google.spanner.v1.TransactionOptions.ReadOnly.min_read_timestamp].
 * Old read timestamps and garbage collection:
 * Cloud Spanner continuously garbage collects deleted and overwritten data
 * in the background to reclaim storage space. This process is known
 * as "version GC". By default, version GC reclaims versions after they
 * are one hour old. Because of this, Cloud Spanner cannot perform reads
 * at read timestamps more than one hour in the past. This
 * restriction also applies to in-progress reads and/or SQL queries whose
 * timestamp become too old while executing. Reads and SQL queries with
 * too-old read timestamps fail with the error `FAILED_PRECONDITION`.
 * You can configure and extend the `VERSION_RETENTION_PERIOD` of a
 * database up to a period as long as one week, which allows Cloud Spanner
 * to perform reads up to one week in the past.
 * Querying change Streams:
 * A Change Stream is a schema object that can be configured to watch data
 * changes on the entire database, a set of tables, or a set of columns
 * in a database.
 * When a change stream is created, Spanner automatically defines a
 * corresponding SQL Table-Valued Function (TVF) that can be used to query
 * the change records in the associated change stream using the
 * ExecuteStreamingSql API. The name of the TVF for a change stream is
 * generated from the name of the change stream: READ_&lt;change_stream_name&gt;.
 * All queries on change stream TVFs must be executed using the
 * ExecuteStreamingSql API with a single-use read-only transaction with a
 * strong read-only timestamp_bound. The change stream TVF allows users to
 * specify the start_timestamp and end_timestamp for the time range of
 * interest. All change records within the retention period is accessible
 * using the strong read-only timestamp_bound. All other TransactionOptions
 * are invalid for change stream queries.
 * In addition, if TransactionOptions.read_only.return_read_timestamp is set
 * to true, a special value of 2^63 - 2 will be returned in the
 * [Transaction][google.spanner.v1.Transaction] message that describes the
 * transaction, instead of a valid read timestamp. This special value should be
 * discarded and not used for any subsequent queries.
 * Please see https://cloud.google.com/spanner/docs/change-streams
 * for more details on how to query the change stream TVFs.
 * Partitioned DML transactions:
 * Partitioned DML transactions are used to execute DML statements with a
 * different execution strategy that provides different, and often better,
 * scalability properties for large, table-wide operations than DML in a
 * ReadWrite transaction. Smaller scoped statements, such as an OLTP workload,
 * should prefer using ReadWrite transactions.
 * Partitioned DML partitions the keyspace and runs the DML statement on each
 * partition in separate, internal transactions. These transactions commit
 * automatically when complete, and run independently from one another.
 * To reduce lock contention, this execution strategy only acquires read locks
 * on rows that match the WHERE clause of the statement. Additionally, the
 * smaller per-partition transactions hold locks for less time.
 * That said, Partitioned DML is not a drop-in replacement for standard DML used
 * in ReadWrite transactions.
 *  - The DML statement must be fully-partitionable. Specifically, the statement
 *    must be expressible as the union of many statements which each access only
 *    a single row of the table.
 *  - The statement is not applied atomically to all rows of the table. Rather,
 *    the statement is applied atomically to partitions of the table, in
 *    independent transactions. Secondary index rows are updated atomically
 *    with the base table rows.
 *  - Partitioned DML does not guarantee exactly-once execution semantics
 *    against a partition. The statement will be applied at least once to each
 *    partition. It is strongly recommended that the DML statement should be
 *    idempotent to avoid unexpected results. For instance, it is potentially
 *    dangerous to run a statement such as
 *    `UPDATE table SET column = column + 1` as it could be run multiple times
 *    against some rows.
 *  - The partitions are committed automatically - there is no support for
 *    Commit or Rollback. If the call returns an error, or if the client issuing
 *    the ExecuteSql call dies, it is possible that some rows had the statement
 *    executed on them successfully. It is also possible that statement was
 *    never executed against other rows.
 *  - Partitioned DML transactions may only contain the execution of a single
 *    DML statement via ExecuteSql or ExecuteStreamingSql.
 *  - If any error is encountered during the execution of the partitioned DML
 *    operation (for instance, a UNIQUE INDEX violation, division by zero, or a
 *    value that cannot be stored due to schema constraints), then the
 *    operation is stopped at that point and an error is returned. It is
 *    possible that at this point, some partitions have been committed (or even
 *    committed multiple times), and other partitions have not been run at all.
 * Given the above, Partitioned DML is good fit for large, database-wide,
 * operations that are idempotent, such as deleting old rows from a very large
 * table.
 * </pre>
 *
 * Protobuf type {@code google.spanner.v1.TransactionOptions}
 */
public final class TransactionOptions extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.v1.TransactionOptions)
    TransactionOptionsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TransactionOptions.newBuilder() to construct.
  private TransactionOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TransactionOptions() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TransactionOptions();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private TransactionOptions(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.spanner.v1.TransactionOptions.ReadWrite.Builder subBuilder = null;
              if (modeCase_ == 1) {
                subBuilder =
                    ((com.google.spanner.v1.TransactionOptions.ReadWrite) mode_).toBuilder();
              }
              mode_ =
                  input.readMessage(
                      com.google.spanner.v1.TransactionOptions.ReadWrite.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.spanner.v1.TransactionOptions.ReadWrite) mode_);
                mode_ = subBuilder.buildPartial();
              }
              modeCase_ = 1;
              break;
            }
          case 18:
            {
              com.google.spanner.v1.TransactionOptions.ReadOnly.Builder subBuilder = null;
              if (modeCase_ == 2) {
                subBuilder =
                    ((com.google.spanner.v1.TransactionOptions.ReadOnly) mode_).toBuilder();
              }
              mode_ =
                  input.readMessage(
                      com.google.spanner.v1.TransactionOptions.ReadOnly.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.spanner.v1.TransactionOptions.ReadOnly) mode_);
                mode_ = subBuilder.buildPartial();
              }
              modeCase_ = 2;
              break;
            }
          case 26:
            {
              com.google.spanner.v1.TransactionOptions.PartitionedDml.Builder subBuilder = null;
              if (modeCase_ == 3) {
                subBuilder =
                    ((com.google.spanner.v1.TransactionOptions.PartitionedDml) mode_).toBuilder();
              }
              mode_ =
                  input.readMessage(
                      com.google.spanner.v1.TransactionOptions.PartitionedDml.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.spanner.v1.TransactionOptions.PartitionedDml) mode_);
                mode_ = subBuilder.buildPartial();
              }
              modeCase_ = 3;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.v1.TransactionProto
        .internal_static_google_spanner_v1_TransactionOptions_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.v1.TransactionProto
        .internal_static_google_spanner_v1_TransactionOptions_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.v1.TransactionOptions.class,
            com.google.spanner.v1.TransactionOptions.Builder.class);
  }

  public interface ReadWriteOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.spanner.v1.TransactionOptions.ReadWrite)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * Message type to initiate a read-write transaction. Currently this
   * transaction type has no options.
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.TransactionOptions.ReadWrite}
   */
  public static final class ReadWrite extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.spanner.v1.TransactionOptions.ReadWrite)
      ReadWriteOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ReadWrite.newBuilder() to construct.
    private ReadWrite(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ReadWrite() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ReadWrite();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private ReadWrite(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.TransactionProto
          .internal_static_google_spanner_v1_TransactionOptions_ReadWrite_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.TransactionProto
          .internal_static_google_spanner_v1_TransactionOptions_ReadWrite_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.TransactionOptions.ReadWrite.class,
              com.google.spanner.v1.TransactionOptions.ReadWrite.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.spanner.v1.TransactionOptions.ReadWrite)) {
        return super.equals(obj);
      }
      com.google.spanner.v1.TransactionOptions.ReadWrite other =
          (com.google.spanner.v1.TransactionOptions.ReadWrite) obj;

      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.spanner.v1.TransactionOptions.ReadWrite parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadWrite parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadWrite parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadWrite parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadWrite parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadWrite parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadWrite parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadWrite parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadWrite parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadWrite parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadWrite parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadWrite parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.spanner.v1.TransactionOptions.ReadWrite prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Message type to initiate a read-write transaction. Currently this
     * transaction type has no options.
     * </pre>
     *
     * Protobuf type {@code google.spanner.v1.TransactionOptions.ReadWrite}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.spanner.v1.TransactionOptions.ReadWrite)
        com.google.spanner.v1.TransactionOptions.ReadWriteOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.spanner.v1.TransactionProto
            .internal_static_google_spanner_v1_TransactionOptions_ReadWrite_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.spanner.v1.TransactionProto
            .internal_static_google_spanner_v1_TransactionOptions_ReadWrite_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.spanner.v1.TransactionOptions.ReadWrite.class,
                com.google.spanner.v1.TransactionOptions.ReadWrite.Builder.class);
      }

      // Construct using com.google.spanner.v1.TransactionOptions.ReadWrite.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.spanner.v1.TransactionProto
            .internal_static_google_spanner_v1_TransactionOptions_ReadWrite_descriptor;
      }

      @java.lang.Override
      public com.google.spanner.v1.TransactionOptions.ReadWrite getDefaultInstanceForType() {
        return com.google.spanner.v1.TransactionOptions.ReadWrite.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.spanner.v1.TransactionOptions.ReadWrite build() {
        com.google.spanner.v1.TransactionOptions.ReadWrite result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.spanner.v1.TransactionOptions.ReadWrite buildPartial() {
        com.google.spanner.v1.TransactionOptions.ReadWrite result =
            new com.google.spanner.v1.TransactionOptions.ReadWrite(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.spanner.v1.TransactionOptions.ReadWrite) {
          return mergeFrom((com.google.spanner.v1.TransactionOptions.ReadWrite) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.spanner.v1.TransactionOptions.ReadWrite other) {
        if (other == com.google.spanner.v1.TransactionOptions.ReadWrite.getDefaultInstance())
          return this;
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.spanner.v1.TransactionOptions.ReadWrite parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.spanner.v1.TransactionOptions.ReadWrite) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.spanner.v1.TransactionOptions.ReadWrite)
    }

    // @@protoc_insertion_point(class_scope:google.spanner.v1.TransactionOptions.ReadWrite)
    private static final com.google.spanner.v1.TransactionOptions.ReadWrite DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.spanner.v1.TransactionOptions.ReadWrite();
    }

    public static com.google.spanner.v1.TransactionOptions.ReadWrite getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ReadWrite> PARSER =
        new com.google.protobuf.AbstractParser<ReadWrite>() {
          @java.lang.Override
          public ReadWrite parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new ReadWrite(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<ReadWrite> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ReadWrite> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.spanner.v1.TransactionOptions.ReadWrite getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PartitionedDmlOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.spanner.v1.TransactionOptions.PartitionedDml)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * Message type to initiate a Partitioned DML transaction.
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.TransactionOptions.PartitionedDml}
   */
  public static final class PartitionedDml extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.spanner.v1.TransactionOptions.PartitionedDml)
      PartitionedDmlOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PartitionedDml.newBuilder() to construct.
    private PartitionedDml(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PartitionedDml() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PartitionedDml();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private PartitionedDml(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.TransactionProto
          .internal_static_google_spanner_v1_TransactionOptions_PartitionedDml_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.TransactionProto
          .internal_static_google_spanner_v1_TransactionOptions_PartitionedDml_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.TransactionOptions.PartitionedDml.class,
              com.google.spanner.v1.TransactionOptions.PartitionedDml.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.spanner.v1.TransactionOptions.PartitionedDml)) {
        return super.equals(obj);
      }
      com.google.spanner.v1.TransactionOptions.PartitionedDml other =
          (com.google.spanner.v1.TransactionOptions.PartitionedDml) obj;

      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.spanner.v1.TransactionOptions.PartitionedDml parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.TransactionOptions.PartitionedDml parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.TransactionOptions.PartitionedDml parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.TransactionOptions.PartitionedDml parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.TransactionOptions.PartitionedDml parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.TransactionOptions.PartitionedDml parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.TransactionOptions.PartitionedDml parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.TransactionOptions.PartitionedDml parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.TransactionOptions.PartitionedDml parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.TransactionOptions.PartitionedDml parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.TransactionOptions.PartitionedDml parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.TransactionOptions.PartitionedDml parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.spanner.v1.TransactionOptions.PartitionedDml prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Message type to initiate a Partitioned DML transaction.
     * </pre>
     *
     * Protobuf type {@code google.spanner.v1.TransactionOptions.PartitionedDml}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.spanner.v1.TransactionOptions.PartitionedDml)
        com.google.spanner.v1.TransactionOptions.PartitionedDmlOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.spanner.v1.TransactionProto
            .internal_static_google_spanner_v1_TransactionOptions_PartitionedDml_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.spanner.v1.TransactionProto
            .internal_static_google_spanner_v1_TransactionOptions_PartitionedDml_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.spanner.v1.TransactionOptions.PartitionedDml.class,
                com.google.spanner.v1.TransactionOptions.PartitionedDml.Builder.class);
      }

      // Construct using com.google.spanner.v1.TransactionOptions.PartitionedDml.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.spanner.v1.TransactionProto
            .internal_static_google_spanner_v1_TransactionOptions_PartitionedDml_descriptor;
      }

      @java.lang.Override
      public com.google.spanner.v1.TransactionOptions.PartitionedDml getDefaultInstanceForType() {
        return com.google.spanner.v1.TransactionOptions.PartitionedDml.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.spanner.v1.TransactionOptions.PartitionedDml build() {
        com.google.spanner.v1.TransactionOptions.PartitionedDml result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.spanner.v1.TransactionOptions.PartitionedDml buildPartial() {
        com.google.spanner.v1.TransactionOptions.PartitionedDml result =
            new com.google.spanner.v1.TransactionOptions.PartitionedDml(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.spanner.v1.TransactionOptions.PartitionedDml) {
          return mergeFrom((com.google.spanner.v1.TransactionOptions.PartitionedDml) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.spanner.v1.TransactionOptions.PartitionedDml other) {
        if (other == com.google.spanner.v1.TransactionOptions.PartitionedDml.getDefaultInstance())
          return this;
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.spanner.v1.TransactionOptions.PartitionedDml parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.spanner.v1.TransactionOptions.PartitionedDml) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.spanner.v1.TransactionOptions.PartitionedDml)
    }

    // @@protoc_insertion_point(class_scope:google.spanner.v1.TransactionOptions.PartitionedDml)
    private static final com.google.spanner.v1.TransactionOptions.PartitionedDml DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.spanner.v1.TransactionOptions.PartitionedDml();
    }

    public static com.google.spanner.v1.TransactionOptions.PartitionedDml getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PartitionedDml> PARSER =
        new com.google.protobuf.AbstractParser<PartitionedDml>() {
          @java.lang.Override
          public PartitionedDml parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new PartitionedDml(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<PartitionedDml> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PartitionedDml> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.spanner.v1.TransactionOptions.PartitionedDml getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ReadOnlyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.spanner.v1.TransactionOptions.ReadOnly)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Read at a timestamp where all previously committed transactions
     * are visible.
     * </pre>
     *
     * <code>bool strong = 1;</code>
     *
     * @return Whether the strong field is set.
     */
    boolean hasStrong();
    /**
     *
     *
     * <pre>
     * Read at a timestamp where all previously committed transactions
     * are visible.
     * </pre>
     *
     * <code>bool strong = 1;</code>
     *
     * @return The strong.
     */
    boolean getStrong();

    /**
     *
     *
     * <pre>
     * Executes all reads at a timestamp &gt;= `min_read_timestamp`.
     * This is useful for requesting fresher data than some previous
     * read, or data that is fresh enough to observe the effects of some
     * previously committed transaction whose timestamp is known.
     * Note that this option can only be used in single-use transactions.
     * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
     * Example: `"2014-10-02T15:01:23.045123456Z"`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp min_read_timestamp = 2;</code>
     *
     * @return Whether the minReadTimestamp field is set.
     */
    boolean hasMinReadTimestamp();
    /**
     *
     *
     * <pre>
     * Executes all reads at a timestamp &gt;= `min_read_timestamp`.
     * This is useful for requesting fresher data than some previous
     * read, or data that is fresh enough to observe the effects of some
     * previously committed transaction whose timestamp is known.
     * Note that this option can only be used in single-use transactions.
     * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
     * Example: `"2014-10-02T15:01:23.045123456Z"`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp min_read_timestamp = 2;</code>
     *
     * @return The minReadTimestamp.
     */
    com.google.protobuf.Timestamp getMinReadTimestamp();
    /**
     *
     *
     * <pre>
     * Executes all reads at a timestamp &gt;= `min_read_timestamp`.
     * This is useful for requesting fresher data than some previous
     * read, or data that is fresh enough to observe the effects of some
     * previously committed transaction whose timestamp is known.
     * Note that this option can only be used in single-use transactions.
     * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
     * Example: `"2014-10-02T15:01:23.045123456Z"`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp min_read_timestamp = 2;</code>
     */
    com.google.protobuf.TimestampOrBuilder getMinReadTimestampOrBuilder();

    /**
     *
     *
     * <pre>
     * Read data at a timestamp &gt;= `NOW - max_staleness`
     * seconds. Guarantees that all writes that have committed more
     * than the specified number of seconds ago are visible. Because
     * Cloud Spanner chooses the exact timestamp, this mode works even if
     * the client's local clock is substantially skewed from Cloud Spanner
     * commit timestamps.
     * Useful for reading the freshest data available at a nearby
     * replica, while bounding the possible staleness if the local
     * replica has fallen behind.
     * Note that this option can only be used in single-use
     * transactions.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_staleness = 3;</code>
     *
     * @return Whether the maxStaleness field is set.
     */
    boolean hasMaxStaleness();
    /**
     *
     *
     * <pre>
     * Read data at a timestamp &gt;= `NOW - max_staleness`
     * seconds. Guarantees that all writes that have committed more
     * than the specified number of seconds ago are visible. Because
     * Cloud Spanner chooses the exact timestamp, this mode works even if
     * the client's local clock is substantially skewed from Cloud Spanner
     * commit timestamps.
     * Useful for reading the freshest data available at a nearby
     * replica, while bounding the possible staleness if the local
     * replica has fallen behind.
     * Note that this option can only be used in single-use
     * transactions.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_staleness = 3;</code>
     *
     * @return The maxStaleness.
     */
    com.google.protobuf.Duration getMaxStaleness();
    /**
     *
     *
     * <pre>
     * Read data at a timestamp &gt;= `NOW - max_staleness`
     * seconds. Guarantees that all writes that have committed more
     * than the specified number of seconds ago are visible. Because
     * Cloud Spanner chooses the exact timestamp, this mode works even if
     * the client's local clock is substantially skewed from Cloud Spanner
     * commit timestamps.
     * Useful for reading the freshest data available at a nearby
     * replica, while bounding the possible staleness if the local
     * replica has fallen behind.
     * Note that this option can only be used in single-use
     * transactions.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_staleness = 3;</code>
     */
    com.google.protobuf.DurationOrBuilder getMaxStalenessOrBuilder();

    /**
     *
     *
     * <pre>
     * Executes all reads at the given timestamp. Unlike other modes,
     * reads at a specific timestamp are repeatable; the same read at
     * the same timestamp always returns the same data. If the
     * timestamp is in the future, the read will block until the
     * specified timestamp, modulo the read's deadline.
     * Useful for large scale consistent reads such as mapreduces, or
     * for coordinating many reads against a consistent snapshot of the
     * data.
     * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
     * Example: `"2014-10-02T15:01:23.045123456Z"`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_timestamp = 4;</code>
     *
     * @return Whether the readTimestamp field is set.
     */
    boolean hasReadTimestamp();
    /**
     *
     *
     * <pre>
     * Executes all reads at the given timestamp. Unlike other modes,
     * reads at a specific timestamp are repeatable; the same read at
     * the same timestamp always returns the same data. If the
     * timestamp is in the future, the read will block until the
     * specified timestamp, modulo the read's deadline.
     * Useful for large scale consistent reads such as mapreduces, or
     * for coordinating many reads against a consistent snapshot of the
     * data.
     * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
     * Example: `"2014-10-02T15:01:23.045123456Z"`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_timestamp = 4;</code>
     *
     * @return The readTimestamp.
     */
    com.google.protobuf.Timestamp getReadTimestamp();
    /**
     *
     *
     * <pre>
     * Executes all reads at the given timestamp. Unlike other modes,
     * reads at a specific timestamp are repeatable; the same read at
     * the same timestamp always returns the same data. If the
     * timestamp is in the future, the read will block until the
     * specified timestamp, modulo the read's deadline.
     * Useful for large scale consistent reads such as mapreduces, or
     * for coordinating many reads against a consistent snapshot of the
     * data.
     * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
     * Example: `"2014-10-02T15:01:23.045123456Z"`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_timestamp = 4;</code>
     */
    com.google.protobuf.TimestampOrBuilder getReadTimestampOrBuilder();

    /**
     *
     *
     * <pre>
     * Executes all reads at a timestamp that is `exact_staleness`
     * old. The timestamp is chosen soon after the read is started.
     * Guarantees that all writes that have committed more than the
     * specified number of seconds ago are visible. Because Cloud Spanner
     * chooses the exact timestamp, this mode works even if the client's
     * local clock is substantially skewed from Cloud Spanner commit
     * timestamps.
     * Useful for reading at nearby replicas without the distributed
     * timestamp negotiation overhead of `max_staleness`.
     * </pre>
     *
     * <code>.google.protobuf.Duration exact_staleness = 5;</code>
     *
     * @return Whether the exactStaleness field is set.
     */
    boolean hasExactStaleness();
    /**
     *
     *
     * <pre>
     * Executes all reads at a timestamp that is `exact_staleness`
     * old. The timestamp is chosen soon after the read is started.
     * Guarantees that all writes that have committed more than the
     * specified number of seconds ago are visible. Because Cloud Spanner
     * chooses the exact timestamp, this mode works even if the client's
     * local clock is substantially skewed from Cloud Spanner commit
     * timestamps.
     * Useful for reading at nearby replicas without the distributed
     * timestamp negotiation overhead of `max_staleness`.
     * </pre>
     *
     * <code>.google.protobuf.Duration exact_staleness = 5;</code>
     *
     * @return The exactStaleness.
     */
    com.google.protobuf.Duration getExactStaleness();
    /**
     *
     *
     * <pre>
     * Executes all reads at a timestamp that is `exact_staleness`
     * old. The timestamp is chosen soon after the read is started.
     * Guarantees that all writes that have committed more than the
     * specified number of seconds ago are visible. Because Cloud Spanner
     * chooses the exact timestamp, this mode works even if the client's
     * local clock is substantially skewed from Cloud Spanner commit
     * timestamps.
     * Useful for reading at nearby replicas without the distributed
     * timestamp negotiation overhead of `max_staleness`.
     * </pre>
     *
     * <code>.google.protobuf.Duration exact_staleness = 5;</code>
     */
    com.google.protobuf.DurationOrBuilder getExactStalenessOrBuilder();

    /**
     *
     *
     * <pre>
     * If true, the Cloud Spanner-selected read timestamp is included in
     * the [Transaction][google.spanner.v1.Transaction] message that describes the transaction.
     * </pre>
     *
     * <code>bool return_read_timestamp = 6;</code>
     *
     * @return The returnReadTimestamp.
     */
    boolean getReturnReadTimestamp();

    public com.google.spanner.v1.TransactionOptions.ReadOnly.TimestampBoundCase
        getTimestampBoundCase();
  }
  /**
   *
   *
   * <pre>
   * Message type to initiate a read-only transaction.
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.TransactionOptions.ReadOnly}
   */
  public static final class ReadOnly extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.spanner.v1.TransactionOptions.ReadOnly)
      ReadOnlyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ReadOnly.newBuilder() to construct.
    private ReadOnly(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ReadOnly() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ReadOnly();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private ReadOnly(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                timestampBound_ = input.readBool();
                timestampBoundCase_ = 1;
                break;
              }
            case 18:
              {
                com.google.protobuf.Timestamp.Builder subBuilder = null;
                if (timestampBoundCase_ == 2) {
                  subBuilder = ((com.google.protobuf.Timestamp) timestampBound_).toBuilder();
                }
                timestampBound_ =
                    input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom((com.google.protobuf.Timestamp) timestampBound_);
                  timestampBound_ = subBuilder.buildPartial();
                }
                timestampBoundCase_ = 2;
                break;
              }
            case 26:
              {
                com.google.protobuf.Duration.Builder subBuilder = null;
                if (timestampBoundCase_ == 3) {
                  subBuilder = ((com.google.protobuf.Duration) timestampBound_).toBuilder();
                }
                timestampBound_ =
                    input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom((com.google.protobuf.Duration) timestampBound_);
                  timestampBound_ = subBuilder.buildPartial();
                }
                timestampBoundCase_ = 3;
                break;
              }
            case 34:
              {
                com.google.protobuf.Timestamp.Builder subBuilder = null;
                if (timestampBoundCase_ == 4) {
                  subBuilder = ((com.google.protobuf.Timestamp) timestampBound_).toBuilder();
                }
                timestampBound_ =
                    input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom((com.google.protobuf.Timestamp) timestampBound_);
                  timestampBound_ = subBuilder.buildPartial();
                }
                timestampBoundCase_ = 4;
                break;
              }
            case 42:
              {
                com.google.protobuf.Duration.Builder subBuilder = null;
                if (timestampBoundCase_ == 5) {
                  subBuilder = ((com.google.protobuf.Duration) timestampBound_).toBuilder();
                }
                timestampBound_ =
                    input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom((com.google.protobuf.Duration) timestampBound_);
                  timestampBound_ = subBuilder.buildPartial();
                }
                timestampBoundCase_ = 5;
                break;
              }
            case 48:
              {
                returnReadTimestamp_ = input.readBool();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.TransactionProto
          .internal_static_google_spanner_v1_TransactionOptions_ReadOnly_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.TransactionProto
          .internal_static_google_spanner_v1_TransactionOptions_ReadOnly_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.TransactionOptions.ReadOnly.class,
              com.google.spanner.v1.TransactionOptions.ReadOnly.Builder.class);
    }

    private int timestampBoundCase_ = 0;
    private java.lang.Object timestampBound_;

    public enum TimestampBoundCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      STRONG(1),
      MIN_READ_TIMESTAMP(2),
      MAX_STALENESS(3),
      READ_TIMESTAMP(4),
      EXACT_STALENESS(5),
      TIMESTAMPBOUND_NOT_SET(0);
      private final int value;

      private TimestampBoundCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static TimestampBoundCase valueOf(int value) {
        return forNumber(value);
      }

      public static TimestampBoundCase forNumber(int value) {
        switch (value) {
          case 1:
            return STRONG;
          case 2:
            return MIN_READ_TIMESTAMP;
          case 3:
            return MAX_STALENESS;
          case 4:
            return READ_TIMESTAMP;
          case 5:
            return EXACT_STALENESS;
          case 0:
            return TIMESTAMPBOUND_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public TimestampBoundCase getTimestampBoundCase() {
      return TimestampBoundCase.forNumber(timestampBoundCase_);
    }

    public static final int STRONG_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Read at a timestamp where all previously committed transactions
     * are visible.
     * </pre>
     *
     * <code>bool strong = 1;</code>
     *
     * @return Whether the strong field is set.
     */
    @java.lang.Override
    public boolean hasStrong() {
      return timestampBoundCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Read at a timestamp where all previously committed transactions
     * are visible.
     * </pre>
     *
     * <code>bool strong = 1;</code>
     *
     * @return The strong.
     */
    @java.lang.Override
    public boolean getStrong() {
      if (timestampBoundCase_ == 1) {
        return (java.lang.Boolean) timestampBound_;
      }
      return false;
    }

    public static final int MIN_READ_TIMESTAMP_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * Executes all reads at a timestamp &gt;= `min_read_timestamp`.
     * This is useful for requesting fresher data than some previous
     * read, or data that is fresh enough to observe the effects of some
     * previously committed transaction whose timestamp is known.
     * Note that this option can only be used in single-use transactions.
     * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
     * Example: `"2014-10-02T15:01:23.045123456Z"`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp min_read_timestamp = 2;</code>
     *
     * @return Whether the minReadTimestamp field is set.
     */
    @java.lang.Override
    public boolean hasMinReadTimestamp() {
      return timestampBoundCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Executes all reads at a timestamp &gt;= `min_read_timestamp`.
     * This is useful for requesting fresher data than some previous
     * read, or data that is fresh enough to observe the effects of some
     * previously committed transaction whose timestamp is known.
     * Note that this option can only be used in single-use transactions.
     * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
     * Example: `"2014-10-02T15:01:23.045123456Z"`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp min_read_timestamp = 2;</code>
     *
     * @return The minReadTimestamp.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getMinReadTimestamp() {
      if (timestampBoundCase_ == 2) {
        return (com.google.protobuf.Timestamp) timestampBound_;
      }
      return com.google.protobuf.Timestamp.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Executes all reads at a timestamp &gt;= `min_read_timestamp`.
     * This is useful for requesting fresher data than some previous
     * read, or data that is fresh enough to observe the effects of some
     * previously committed transaction whose timestamp is known.
     * Note that this option can only be used in single-use transactions.
     * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
     * Example: `"2014-10-02T15:01:23.045123456Z"`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp min_read_timestamp = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getMinReadTimestampOrBuilder() {
      if (timestampBoundCase_ == 2) {
        return (com.google.protobuf.Timestamp) timestampBound_;
      }
      return com.google.protobuf.Timestamp.getDefaultInstance();
    }

    public static final int MAX_STALENESS_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * Read data at a timestamp &gt;= `NOW - max_staleness`
     * seconds. Guarantees that all writes that have committed more
     * than the specified number of seconds ago are visible. Because
     * Cloud Spanner chooses the exact timestamp, this mode works even if
     * the client's local clock is substantially skewed from Cloud Spanner
     * commit timestamps.
     * Useful for reading the freshest data available at a nearby
     * replica, while bounding the possible staleness if the local
     * replica has fallen behind.
     * Note that this option can only be used in single-use
     * transactions.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_staleness = 3;</code>
     *
     * @return Whether the maxStaleness field is set.
     */
    @java.lang.Override
    public boolean hasMaxStaleness() {
      return timestampBoundCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Read data at a timestamp &gt;= `NOW - max_staleness`
     * seconds. Guarantees that all writes that have committed more
     * than the specified number of seconds ago are visible. Because
     * Cloud Spanner chooses the exact timestamp, this mode works even if
     * the client's local clock is substantially skewed from Cloud Spanner
     * commit timestamps.
     * Useful for reading the freshest data available at a nearby
     * replica, while bounding the possible staleness if the local
     * replica has fallen behind.
     * Note that this option can only be used in single-use
     * transactions.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_staleness = 3;</code>
     *
     * @return The maxStaleness.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getMaxStaleness() {
      if (timestampBoundCase_ == 3) {
        return (com.google.protobuf.Duration) timestampBound_;
      }
      return com.google.protobuf.Duration.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Read data at a timestamp &gt;= `NOW - max_staleness`
     * seconds. Guarantees that all writes that have committed more
     * than the specified number of seconds ago are visible. Because
     * Cloud Spanner chooses the exact timestamp, this mode works even if
     * the client's local clock is substantially skewed from Cloud Spanner
     * commit timestamps.
     * Useful for reading the freshest data available at a nearby
     * replica, while bounding the possible staleness if the local
     * replica has fallen behind.
     * Note that this option can only be used in single-use
     * transactions.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_staleness = 3;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getMaxStalenessOrBuilder() {
      if (timestampBoundCase_ == 3) {
        return (com.google.protobuf.Duration) timestampBound_;
      }
      return com.google.protobuf.Duration.getDefaultInstance();
    }

    public static final int READ_TIMESTAMP_FIELD_NUMBER = 4;
    /**
     *
     *
     * <pre>
     * Executes all reads at the given timestamp. Unlike other modes,
     * reads at a specific timestamp are repeatable; the same read at
     * the same timestamp always returns the same data. If the
     * timestamp is in the future, the read will block until the
     * specified timestamp, modulo the read's deadline.
     * Useful for large scale consistent reads such as mapreduces, or
     * for coordinating many reads against a consistent snapshot of the
     * data.
     * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
     * Example: `"2014-10-02T15:01:23.045123456Z"`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_timestamp = 4;</code>
     *
     * @return Whether the readTimestamp field is set.
     */
    @java.lang.Override
    public boolean hasReadTimestamp() {
      return timestampBoundCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Executes all reads at the given timestamp. Unlike other modes,
     * reads at a specific timestamp are repeatable; the same read at
     * the same timestamp always returns the same data. If the
     * timestamp is in the future, the read will block until the
     * specified timestamp, modulo the read's deadline.
     * Useful for large scale consistent reads such as mapreduces, or
     * for coordinating many reads against a consistent snapshot of the
     * data.
     * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
     * Example: `"2014-10-02T15:01:23.045123456Z"`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_timestamp = 4;</code>
     *
     * @return The readTimestamp.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getReadTimestamp() {
      if (timestampBoundCase_ == 4) {
        return (com.google.protobuf.Timestamp) timestampBound_;
      }
      return com.google.protobuf.Timestamp.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Executes all reads at the given timestamp. Unlike other modes,
     * reads at a specific timestamp are repeatable; the same read at
     * the same timestamp always returns the same data. If the
     * timestamp is in the future, the read will block until the
     * specified timestamp, modulo the read's deadline.
     * Useful for large scale consistent reads such as mapreduces, or
     * for coordinating many reads against a consistent snapshot of the
     * data.
     * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
     * Example: `"2014-10-02T15:01:23.045123456Z"`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_timestamp = 4;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getReadTimestampOrBuilder() {
      if (timestampBoundCase_ == 4) {
        return (com.google.protobuf.Timestamp) timestampBound_;
      }
      return com.google.protobuf.Timestamp.getDefaultInstance();
    }

    public static final int EXACT_STALENESS_FIELD_NUMBER = 5;
    /**
     *
     *
     * <pre>
     * Executes all reads at a timestamp that is `exact_staleness`
     * old. The timestamp is chosen soon after the read is started.
     * Guarantees that all writes that have committed more than the
     * specified number of seconds ago are visible. Because Cloud Spanner
     * chooses the exact timestamp, this mode works even if the client's
     * local clock is substantially skewed from Cloud Spanner commit
     * timestamps.
     * Useful for reading at nearby replicas without the distributed
     * timestamp negotiation overhead of `max_staleness`.
     * </pre>
     *
     * <code>.google.protobuf.Duration exact_staleness = 5;</code>
     *
     * @return Whether the exactStaleness field is set.
     */
    @java.lang.Override
    public boolean hasExactStaleness() {
      return timestampBoundCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Executes all reads at a timestamp that is `exact_staleness`
     * old. The timestamp is chosen soon after the read is started.
     * Guarantees that all writes that have committed more than the
     * specified number of seconds ago are visible. Because Cloud Spanner
     * chooses the exact timestamp, this mode works even if the client's
     * local clock is substantially skewed from Cloud Spanner commit
     * timestamps.
     * Useful for reading at nearby replicas without the distributed
     * timestamp negotiation overhead of `max_staleness`.
     * </pre>
     *
     * <code>.google.protobuf.Duration exact_staleness = 5;</code>
     *
     * @return The exactStaleness.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getExactStaleness() {
      if (timestampBoundCase_ == 5) {
        return (com.google.protobuf.Duration) timestampBound_;
      }
      return com.google.protobuf.Duration.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Executes all reads at a timestamp that is `exact_staleness`
     * old. The timestamp is chosen soon after the read is started.
     * Guarantees that all writes that have committed more than the
     * specified number of seconds ago are visible. Because Cloud Spanner
     * chooses the exact timestamp, this mode works even if the client's
     * local clock is substantially skewed from Cloud Spanner commit
     * timestamps.
     * Useful for reading at nearby replicas without the distributed
     * timestamp negotiation overhead of `max_staleness`.
     * </pre>
     *
     * <code>.google.protobuf.Duration exact_staleness = 5;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getExactStalenessOrBuilder() {
      if (timestampBoundCase_ == 5) {
        return (com.google.protobuf.Duration) timestampBound_;
      }
      return com.google.protobuf.Duration.getDefaultInstance();
    }

    public static final int RETURN_READ_TIMESTAMP_FIELD_NUMBER = 6;
    private boolean returnReadTimestamp_;
    /**
     *
     *
     * <pre>
     * If true, the Cloud Spanner-selected read timestamp is included in
     * the [Transaction][google.spanner.v1.Transaction] message that describes the transaction.
     * </pre>
     *
     * <code>bool return_read_timestamp = 6;</code>
     *
     * @return The returnReadTimestamp.
     */
    @java.lang.Override
    public boolean getReturnReadTimestamp() {
      return returnReadTimestamp_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (timestampBoundCase_ == 1) {
        output.writeBool(1, (boolean) ((java.lang.Boolean) timestampBound_));
      }
      if (timestampBoundCase_ == 2) {
        output.writeMessage(2, (com.google.protobuf.Timestamp) timestampBound_);
      }
      if (timestampBoundCase_ == 3) {
        output.writeMessage(3, (com.google.protobuf.Duration) timestampBound_);
      }
      if (timestampBoundCase_ == 4) {
        output.writeMessage(4, (com.google.protobuf.Timestamp) timestampBound_);
      }
      if (timestampBoundCase_ == 5) {
        output.writeMessage(5, (com.google.protobuf.Duration) timestampBound_);
      }
      if (returnReadTimestamp_ != false) {
        output.writeBool(6, returnReadTimestamp_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (timestampBoundCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(
                1, (boolean) ((java.lang.Boolean) timestampBound_));
      }
      if (timestampBoundCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.protobuf.Timestamp) timestampBound_);
      }
      if (timestampBoundCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3, (com.google.protobuf.Duration) timestampBound_);
      }
      if (timestampBoundCase_ == 4) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4, (com.google.protobuf.Timestamp) timestampBound_);
      }
      if (timestampBoundCase_ == 5) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                5, (com.google.protobuf.Duration) timestampBound_);
      }
      if (returnReadTimestamp_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, returnReadTimestamp_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.spanner.v1.TransactionOptions.ReadOnly)) {
        return super.equals(obj);
      }
      com.google.spanner.v1.TransactionOptions.ReadOnly other =
          (com.google.spanner.v1.TransactionOptions.ReadOnly) obj;

      if (getReturnReadTimestamp() != other.getReturnReadTimestamp()) return false;
      if (!getTimestampBoundCase().equals(other.getTimestampBoundCase())) return false;
      switch (timestampBoundCase_) {
        case 1:
          if (getStrong() != other.getStrong()) return false;
          break;
        case 2:
          if (!getMinReadTimestamp().equals(other.getMinReadTimestamp())) return false;
          break;
        case 3:
          if (!getMaxStaleness().equals(other.getMaxStaleness())) return false;
          break;
        case 4:
          if (!getReadTimestamp().equals(other.getReadTimestamp())) return false;
          break;
        case 5:
          if (!getExactStaleness().equals(other.getExactStaleness())) return false;
          break;
        case 0:
        default:
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + RETURN_READ_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getReturnReadTimestamp());
      switch (timestampBoundCase_) {
        case 1:
          hash = (37 * hash) + STRONG_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getStrong());
          break;
        case 2:
          hash = (37 * hash) + MIN_READ_TIMESTAMP_FIELD_NUMBER;
          hash = (53 * hash) + getMinReadTimestamp().hashCode();
          break;
        case 3:
          hash = (37 * hash) + MAX_STALENESS_FIELD_NUMBER;
          hash = (53 * hash) + getMaxStaleness().hashCode();
          break;
        case 4:
          hash = (37 * hash) + READ_TIMESTAMP_FIELD_NUMBER;
          hash = (53 * hash) + getReadTimestamp().hashCode();
          break;
        case 5:
          hash = (37 * hash) + EXACT_STALENESS_FIELD_NUMBER;
          hash = (53 * hash) + getExactStaleness().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.spanner.v1.TransactionOptions.ReadOnly parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadOnly parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadOnly parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadOnly parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadOnly parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadOnly parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadOnly parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadOnly parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadOnly parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadOnly parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadOnly parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.TransactionOptions.ReadOnly parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.spanner.v1.TransactionOptions.ReadOnly prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Message type to initiate a read-only transaction.
     * </pre>
     *
     * Protobuf type {@code google.spanner.v1.TransactionOptions.ReadOnly}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.spanner.v1.TransactionOptions.ReadOnly)
        com.google.spanner.v1.TransactionOptions.ReadOnlyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.spanner.v1.TransactionProto
            .internal_static_google_spanner_v1_TransactionOptions_ReadOnly_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.spanner.v1.TransactionProto
            .internal_static_google_spanner_v1_TransactionOptions_ReadOnly_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.spanner.v1.TransactionOptions.ReadOnly.class,
                com.google.spanner.v1.TransactionOptions.ReadOnly.Builder.class);
      }

      // Construct using com.google.spanner.v1.TransactionOptions.ReadOnly.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        returnReadTimestamp_ = false;

        timestampBoundCase_ = 0;
        timestampBound_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.spanner.v1.TransactionProto
            .internal_static_google_spanner_v1_TransactionOptions_ReadOnly_descriptor;
      }

      @java.lang.Override
      public com.google.spanner.v1.TransactionOptions.ReadOnly getDefaultInstanceForType() {
        return com.google.spanner.v1.TransactionOptions.ReadOnly.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.spanner.v1.TransactionOptions.ReadOnly build() {
        com.google.spanner.v1.TransactionOptions.ReadOnly result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.spanner.v1.TransactionOptions.ReadOnly buildPartial() {
        com.google.spanner.v1.TransactionOptions.ReadOnly result =
            new com.google.spanner.v1.TransactionOptions.ReadOnly(this);
        if (timestampBoundCase_ == 1) {
          result.timestampBound_ = timestampBound_;
        }
        if (timestampBoundCase_ == 2) {
          if (minReadTimestampBuilder_ == null) {
            result.timestampBound_ = timestampBound_;
          } else {
            result.timestampBound_ = minReadTimestampBuilder_.build();
          }
        }
        if (timestampBoundCase_ == 3) {
          if (maxStalenessBuilder_ == null) {
            result.timestampBound_ = timestampBound_;
          } else {
            result.timestampBound_ = maxStalenessBuilder_.build();
          }
        }
        if (timestampBoundCase_ == 4) {
          if (readTimestampBuilder_ == null) {
            result.timestampBound_ = timestampBound_;
          } else {
            result.timestampBound_ = readTimestampBuilder_.build();
          }
        }
        if (timestampBoundCase_ == 5) {
          if (exactStalenessBuilder_ == null) {
            result.timestampBound_ = timestampBound_;
          } else {
            result.timestampBound_ = exactStalenessBuilder_.build();
          }
        }
        result.returnReadTimestamp_ = returnReadTimestamp_;
        result.timestampBoundCase_ = timestampBoundCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.spanner.v1.TransactionOptions.ReadOnly) {
          return mergeFrom((com.google.spanner.v1.TransactionOptions.ReadOnly) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.spanner.v1.TransactionOptions.ReadOnly other) {
        if (other == com.google.spanner.v1.TransactionOptions.ReadOnly.getDefaultInstance())
          return this;
        if (other.getReturnReadTimestamp() != false) {
          setReturnReadTimestamp(other.getReturnReadTimestamp());
        }
        switch (other.getTimestampBoundCase()) {
          case STRONG:
            {
              setStrong(other.getStrong());
              break;
            }
          case MIN_READ_TIMESTAMP:
            {
              mergeMinReadTimestamp(other.getMinReadTimestamp());
              break;
            }
          case MAX_STALENESS:
            {
              mergeMaxStaleness(other.getMaxStaleness());
              break;
            }
          case READ_TIMESTAMP:
            {
              mergeReadTimestamp(other.getReadTimestamp());
              break;
            }
          case EXACT_STALENESS:
            {
              mergeExactStaleness(other.getExactStaleness());
              break;
            }
          case TIMESTAMPBOUND_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.spanner.v1.TransactionOptions.ReadOnly parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.spanner.v1.TransactionOptions.ReadOnly) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int timestampBoundCase_ = 0;
      private java.lang.Object timestampBound_;

      public TimestampBoundCase getTimestampBoundCase() {
        return TimestampBoundCase.forNumber(timestampBoundCase_);
      }

      public Builder clearTimestampBound() {
        timestampBoundCase_ = 0;
        timestampBound_ = null;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Read at a timestamp where all previously committed transactions
       * are visible.
       * </pre>
       *
       * <code>bool strong = 1;</code>
       *
       * @return Whether the strong field is set.
       */
      public boolean hasStrong() {
        return timestampBoundCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Read at a timestamp where all previously committed transactions
       * are visible.
       * </pre>
       *
       * <code>bool strong = 1;</code>
       *
       * @return The strong.
       */
      public boolean getStrong() {
        if (timestampBoundCase_ == 1) {
          return (java.lang.Boolean) timestampBound_;
        }
        return false;
      }
      /**
       *
       *
       * <pre>
       * Read at a timestamp where all previously committed transactions
       * are visible.
       * </pre>
       *
       * <code>bool strong = 1;</code>
       *
       * @param value The strong to set.
       * @return This builder for chaining.
       */
      public Builder setStrong(boolean value) {
        timestampBoundCase_ = 1;
        timestampBound_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Read at a timestamp where all previously committed transactions
       * are visible.
       * </pre>
       *
       * <code>bool strong = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStrong() {
        if (timestampBoundCase_ == 1) {
          timestampBoundCase_ = 0;
          timestampBound_ = null;
          onChanged();
        }
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          minReadTimestampBuilder_;
      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp &gt;= `min_read_timestamp`.
       * This is useful for requesting fresher data than some previous
       * read, or data that is fresh enough to observe the effects of some
       * previously committed transaction whose timestamp is known.
       * Note that this option can only be used in single-use transactions.
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp min_read_timestamp = 2;</code>
       *
       * @return Whether the minReadTimestamp field is set.
       */
      @java.lang.Override
      public boolean hasMinReadTimestamp() {
        return timestampBoundCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp &gt;= `min_read_timestamp`.
       * This is useful for requesting fresher data than some previous
       * read, or data that is fresh enough to observe the effects of some
       * previously committed transaction whose timestamp is known.
       * Note that this option can only be used in single-use transactions.
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp min_read_timestamp = 2;</code>
       *
       * @return The minReadTimestamp.
       */
      @java.lang.Override
      public com.google.protobuf.Timestamp getMinReadTimestamp() {
        if (minReadTimestampBuilder_ == null) {
          if (timestampBoundCase_ == 2) {
            return (com.google.protobuf.Timestamp) timestampBound_;
          }
          return com.google.protobuf.Timestamp.getDefaultInstance();
        } else {
          if (timestampBoundCase_ == 2) {
            return minReadTimestampBuilder_.getMessage();
          }
          return com.google.protobuf.Timestamp.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp &gt;= `min_read_timestamp`.
       * This is useful for requesting fresher data than some previous
       * read, or data that is fresh enough to observe the effects of some
       * previously committed transaction whose timestamp is known.
       * Note that this option can only be used in single-use transactions.
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp min_read_timestamp = 2;</code>
       */
      public Builder setMinReadTimestamp(com.google.protobuf.Timestamp value) {
        if (minReadTimestampBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          timestampBound_ = value;
          onChanged();
        } else {
          minReadTimestampBuilder_.setMessage(value);
        }
        timestampBoundCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp &gt;= `min_read_timestamp`.
       * This is useful for requesting fresher data than some previous
       * read, or data that is fresh enough to observe the effects of some
       * previously committed transaction whose timestamp is known.
       * Note that this option can only be used in single-use transactions.
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp min_read_timestamp = 2;</code>
       */
      public Builder setMinReadTimestamp(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (minReadTimestampBuilder_ == null) {
          timestampBound_ = builderForValue.build();
          onChanged();
        } else {
          minReadTimestampBuilder_.setMessage(builderForValue.build());
        }
        timestampBoundCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp &gt;= `min_read_timestamp`.
       * This is useful for requesting fresher data than some previous
       * read, or data that is fresh enough to observe the effects of some
       * previously committed transaction whose timestamp is known.
       * Note that this option can only be used in single-use transactions.
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp min_read_timestamp = 2;</code>
       */
      public Builder mergeMinReadTimestamp(com.google.protobuf.Timestamp value) {
        if (minReadTimestampBuilder_ == null) {
          if (timestampBoundCase_ == 2
              && timestampBound_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            timestampBound_ =
                com.google.protobuf.Timestamp.newBuilder(
                        (com.google.protobuf.Timestamp) timestampBound_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            timestampBound_ = value;
          }
          onChanged();
        } else {
          if (timestampBoundCase_ == 2) {
            minReadTimestampBuilder_.mergeFrom(value);
          } else {
            minReadTimestampBuilder_.setMessage(value);
          }
        }
        timestampBoundCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp &gt;= `min_read_timestamp`.
       * This is useful for requesting fresher data than some previous
       * read, or data that is fresh enough to observe the effects of some
       * previously committed transaction whose timestamp is known.
       * Note that this option can only be used in single-use transactions.
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp min_read_timestamp = 2;</code>
       */
      public Builder clearMinReadTimestamp() {
        if (minReadTimestampBuilder_ == null) {
          if (timestampBoundCase_ == 2) {
            timestampBoundCase_ = 0;
            timestampBound_ = null;
            onChanged();
          }
        } else {
          if (timestampBoundCase_ == 2) {
            timestampBoundCase_ = 0;
            timestampBound_ = null;
          }
          minReadTimestampBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp &gt;= `min_read_timestamp`.
       * This is useful for requesting fresher data than some previous
       * read, or data that is fresh enough to observe the effects of some
       * previously committed transaction whose timestamp is known.
       * Note that this option can only be used in single-use transactions.
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp min_read_timestamp = 2;</code>
       */
      public com.google.protobuf.Timestamp.Builder getMinReadTimestampBuilder() {
        return getMinReadTimestampFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp &gt;= `min_read_timestamp`.
       * This is useful for requesting fresher data than some previous
       * read, or data that is fresh enough to observe the effects of some
       * previously committed transaction whose timestamp is known.
       * Note that this option can only be used in single-use transactions.
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp min_read_timestamp = 2;</code>
       */
      @java.lang.Override
      public com.google.protobuf.TimestampOrBuilder getMinReadTimestampOrBuilder() {
        if ((timestampBoundCase_ == 2) && (minReadTimestampBuilder_ != null)) {
          return minReadTimestampBuilder_.getMessageOrBuilder();
        } else {
          if (timestampBoundCase_ == 2) {
            return (com.google.protobuf.Timestamp) timestampBound_;
          }
          return com.google.protobuf.Timestamp.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp &gt;= `min_read_timestamp`.
       * This is useful for requesting fresher data than some previous
       * read, or data that is fresh enough to observe the effects of some
       * previously committed transaction whose timestamp is known.
       * Note that this option can only be used in single-use transactions.
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp min_read_timestamp = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getMinReadTimestampFieldBuilder() {
        if (minReadTimestampBuilder_ == null) {
          if (!(timestampBoundCase_ == 2)) {
            timestampBound_ = com.google.protobuf.Timestamp.getDefaultInstance();
          }
          minReadTimestampBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  (com.google.protobuf.Timestamp) timestampBound_,
                  getParentForChildren(),
                  isClean());
          timestampBound_ = null;
        }
        timestampBoundCase_ = 2;
        onChanged();
        ;
        return minReadTimestampBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          maxStalenessBuilder_;
      /**
       *
       *
       * <pre>
       * Read data at a timestamp &gt;= `NOW - max_staleness`
       * seconds. Guarantees that all writes that have committed more
       * than the specified number of seconds ago are visible. Because
       * Cloud Spanner chooses the exact timestamp, this mode works even if
       * the client's local clock is substantially skewed from Cloud Spanner
       * commit timestamps.
       * Useful for reading the freshest data available at a nearby
       * replica, while bounding the possible staleness if the local
       * replica has fallen behind.
       * Note that this option can only be used in single-use
       * transactions.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_staleness = 3;</code>
       *
       * @return Whether the maxStaleness field is set.
       */
      @java.lang.Override
      public boolean hasMaxStaleness() {
        return timestampBoundCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * Read data at a timestamp &gt;= `NOW - max_staleness`
       * seconds. Guarantees that all writes that have committed more
       * than the specified number of seconds ago are visible. Because
       * Cloud Spanner chooses the exact timestamp, this mode works even if
       * the client's local clock is substantially skewed from Cloud Spanner
       * commit timestamps.
       * Useful for reading the freshest data available at a nearby
       * replica, while bounding the possible staleness if the local
       * replica has fallen behind.
       * Note that this option can only be used in single-use
       * transactions.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_staleness = 3;</code>
       *
       * @return The maxStaleness.
       */
      @java.lang.Override
      public com.google.protobuf.Duration getMaxStaleness() {
        if (maxStalenessBuilder_ == null) {
          if (timestampBoundCase_ == 3) {
            return (com.google.protobuf.Duration) timestampBound_;
          }
          return com.google.protobuf.Duration.getDefaultInstance();
        } else {
          if (timestampBoundCase_ == 3) {
            return maxStalenessBuilder_.getMessage();
          }
          return com.google.protobuf.Duration.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Read data at a timestamp &gt;= `NOW - max_staleness`
       * seconds. Guarantees that all writes that have committed more
       * than the specified number of seconds ago are visible. Because
       * Cloud Spanner chooses the exact timestamp, this mode works even if
       * the client's local clock is substantially skewed from Cloud Spanner
       * commit timestamps.
       * Useful for reading the freshest data available at a nearby
       * replica, while bounding the possible staleness if the local
       * replica has fallen behind.
       * Note that this option can only be used in single-use
       * transactions.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_staleness = 3;</code>
       */
      public Builder setMaxStaleness(com.google.protobuf.Duration value) {
        if (maxStalenessBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          timestampBound_ = value;
          onChanged();
        } else {
          maxStalenessBuilder_.setMessage(value);
        }
        timestampBoundCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Read data at a timestamp &gt;= `NOW - max_staleness`
       * seconds. Guarantees that all writes that have committed more
       * than the specified number of seconds ago are visible. Because
       * Cloud Spanner chooses the exact timestamp, this mode works even if
       * the client's local clock is substantially skewed from Cloud Spanner
       * commit timestamps.
       * Useful for reading the freshest data available at a nearby
       * replica, while bounding the possible staleness if the local
       * replica has fallen behind.
       * Note that this option can only be used in single-use
       * transactions.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_staleness = 3;</code>
       */
      public Builder setMaxStaleness(com.google.protobuf.Duration.Builder builderForValue) {
        if (maxStalenessBuilder_ == null) {
          timestampBound_ = builderForValue.build();
          onChanged();
        } else {
          maxStalenessBuilder_.setMessage(builderForValue.build());
        }
        timestampBoundCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Read data at a timestamp &gt;= `NOW - max_staleness`
       * seconds. Guarantees that all writes that have committed more
       * than the specified number of seconds ago are visible. Because
       * Cloud Spanner chooses the exact timestamp, this mode works even if
       * the client's local clock is substantially skewed from Cloud Spanner
       * commit timestamps.
       * Useful for reading the freshest data available at a nearby
       * replica, while bounding the possible staleness if the local
       * replica has fallen behind.
       * Note that this option can only be used in single-use
       * transactions.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_staleness = 3;</code>
       */
      public Builder mergeMaxStaleness(com.google.protobuf.Duration value) {
        if (maxStalenessBuilder_ == null) {
          if (timestampBoundCase_ == 3
              && timestampBound_ != com.google.protobuf.Duration.getDefaultInstance()) {
            timestampBound_ =
                com.google.protobuf.Duration.newBuilder(
                        (com.google.protobuf.Duration) timestampBound_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            timestampBound_ = value;
          }
          onChanged();
        } else {
          if (timestampBoundCase_ == 3) {
            maxStalenessBuilder_.mergeFrom(value);
          } else {
            maxStalenessBuilder_.setMessage(value);
          }
        }
        timestampBoundCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Read data at a timestamp &gt;= `NOW - max_staleness`
       * seconds. Guarantees that all writes that have committed more
       * than the specified number of seconds ago are visible. Because
       * Cloud Spanner chooses the exact timestamp, this mode works even if
       * the client's local clock is substantially skewed from Cloud Spanner
       * commit timestamps.
       * Useful for reading the freshest data available at a nearby
       * replica, while bounding the possible staleness if the local
       * replica has fallen behind.
       * Note that this option can only be used in single-use
       * transactions.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_staleness = 3;</code>
       */
      public Builder clearMaxStaleness() {
        if (maxStalenessBuilder_ == null) {
          if (timestampBoundCase_ == 3) {
            timestampBoundCase_ = 0;
            timestampBound_ = null;
            onChanged();
          }
        } else {
          if (timestampBoundCase_ == 3) {
            timestampBoundCase_ = 0;
            timestampBound_ = null;
          }
          maxStalenessBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Read data at a timestamp &gt;= `NOW - max_staleness`
       * seconds. Guarantees that all writes that have committed more
       * than the specified number of seconds ago are visible. Because
       * Cloud Spanner chooses the exact timestamp, this mode works even if
       * the client's local clock is substantially skewed from Cloud Spanner
       * commit timestamps.
       * Useful for reading the freshest data available at a nearby
       * replica, while bounding the possible staleness if the local
       * replica has fallen behind.
       * Note that this option can only be used in single-use
       * transactions.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_staleness = 3;</code>
       */
      public com.google.protobuf.Duration.Builder getMaxStalenessBuilder() {
        return getMaxStalenessFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Read data at a timestamp &gt;= `NOW - max_staleness`
       * seconds. Guarantees that all writes that have committed more
       * than the specified number of seconds ago are visible. Because
       * Cloud Spanner chooses the exact timestamp, this mode works even if
       * the client's local clock is substantially skewed from Cloud Spanner
       * commit timestamps.
       * Useful for reading the freshest data available at a nearby
       * replica, while bounding the possible staleness if the local
       * replica has fallen behind.
       * Note that this option can only be used in single-use
       * transactions.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_staleness = 3;</code>
       */
      @java.lang.Override
      public com.google.protobuf.DurationOrBuilder getMaxStalenessOrBuilder() {
        if ((timestampBoundCase_ == 3) && (maxStalenessBuilder_ != null)) {
          return maxStalenessBuilder_.getMessageOrBuilder();
        } else {
          if (timestampBoundCase_ == 3) {
            return (com.google.protobuf.Duration) timestampBound_;
          }
          return com.google.protobuf.Duration.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Read data at a timestamp &gt;= `NOW - max_staleness`
       * seconds. Guarantees that all writes that have committed more
       * than the specified number of seconds ago are visible. Because
       * Cloud Spanner chooses the exact timestamp, this mode works even if
       * the client's local clock is substantially skewed from Cloud Spanner
       * commit timestamps.
       * Useful for reading the freshest data available at a nearby
       * replica, while bounding the possible staleness if the local
       * replica has fallen behind.
       * Note that this option can only be used in single-use
       * transactions.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_staleness = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getMaxStalenessFieldBuilder() {
        if (maxStalenessBuilder_ == null) {
          if (!(timestampBoundCase_ == 3)) {
            timestampBound_ = com.google.protobuf.Duration.getDefaultInstance();
          }
          maxStalenessBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  (com.google.protobuf.Duration) timestampBound_,
                  getParentForChildren(),
                  isClean());
          timestampBound_ = null;
        }
        timestampBoundCase_ = 3;
        onChanged();
        ;
        return maxStalenessBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          readTimestampBuilder_;
      /**
       *
       *
       * <pre>
       * Executes all reads at the given timestamp. Unlike other modes,
       * reads at a specific timestamp are repeatable; the same read at
       * the same timestamp always returns the same data. If the
       * timestamp is in the future, the read will block until the
       * specified timestamp, modulo the read's deadline.
       * Useful for large scale consistent reads such as mapreduces, or
       * for coordinating many reads against a consistent snapshot of the
       * data.
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_timestamp = 4;</code>
       *
       * @return Whether the readTimestamp field is set.
       */
      @java.lang.Override
      public boolean hasReadTimestamp() {
        return timestampBoundCase_ == 4;
      }
      /**
       *
       *
       * <pre>
       * Executes all reads at the given timestamp. Unlike other modes,
       * reads at a specific timestamp are repeatable; the same read at
       * the same timestamp always returns the same data. If the
       * timestamp is in the future, the read will block until the
       * specified timestamp, modulo the read's deadline.
       * Useful for large scale consistent reads such as mapreduces, or
       * for coordinating many reads against a consistent snapshot of the
       * data.
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_timestamp = 4;</code>
       *
       * @return The readTimestamp.
       */
      @java.lang.Override
      public com.google.protobuf.Timestamp getReadTimestamp() {
        if (readTimestampBuilder_ == null) {
          if (timestampBoundCase_ == 4) {
            return (com.google.protobuf.Timestamp) timestampBound_;
          }
          return com.google.protobuf.Timestamp.getDefaultInstance();
        } else {
          if (timestampBoundCase_ == 4) {
            return readTimestampBuilder_.getMessage();
          }
          return com.google.protobuf.Timestamp.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Executes all reads at the given timestamp. Unlike other modes,
       * reads at a specific timestamp are repeatable; the same read at
       * the same timestamp always returns the same data. If the
       * timestamp is in the future, the read will block until the
       * specified timestamp, modulo the read's deadline.
       * Useful for large scale consistent reads such as mapreduces, or
       * for coordinating many reads against a consistent snapshot of the
       * data.
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_timestamp = 4;</code>
       */
      public Builder setReadTimestamp(com.google.protobuf.Timestamp value) {
        if (readTimestampBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          timestampBound_ = value;
          onChanged();
        } else {
          readTimestampBuilder_.setMessage(value);
        }
        timestampBoundCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Executes all reads at the given timestamp. Unlike other modes,
       * reads at a specific timestamp are repeatable; the same read at
       * the same timestamp always returns the same data. If the
       * timestamp is in the future, the read will block until the
       * specified timestamp, modulo the read's deadline.
       * Useful for large scale consistent reads such as mapreduces, or
       * for coordinating many reads against a consistent snapshot of the
       * data.
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_timestamp = 4;</code>
       */
      public Builder setReadTimestamp(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (readTimestampBuilder_ == null) {
          timestampBound_ = builderForValue.build();
          onChanged();
        } else {
          readTimestampBuilder_.setMessage(builderForValue.build());
        }
        timestampBoundCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Executes all reads at the given timestamp. Unlike other modes,
       * reads at a specific timestamp are repeatable; the same read at
       * the same timestamp always returns the same data. If the
       * timestamp is in the future, the read will block until the
       * specified timestamp, modulo the read's deadline.
       * Useful for large scale consistent reads such as mapreduces, or
       * for coordinating many reads against a consistent snapshot of the
       * data.
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_timestamp = 4;</code>
       */
      public Builder mergeReadTimestamp(com.google.protobuf.Timestamp value) {
        if (readTimestampBuilder_ == null) {
          if (timestampBoundCase_ == 4
              && timestampBound_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            timestampBound_ =
                com.google.protobuf.Timestamp.newBuilder(
                        (com.google.protobuf.Timestamp) timestampBound_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            timestampBound_ = value;
          }
          onChanged();
        } else {
          if (timestampBoundCase_ == 4) {
            readTimestampBuilder_.mergeFrom(value);
          } else {
            readTimestampBuilder_.setMessage(value);
          }
        }
        timestampBoundCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Executes all reads at the given timestamp. Unlike other modes,
       * reads at a specific timestamp are repeatable; the same read at
       * the same timestamp always returns the same data. If the
       * timestamp is in the future, the read will block until the
       * specified timestamp, modulo the read's deadline.
       * Useful for large scale consistent reads such as mapreduces, or
       * for coordinating many reads against a consistent snapshot of the
       * data.
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_timestamp = 4;</code>
       */
      public Builder clearReadTimestamp() {
        if (readTimestampBuilder_ == null) {
          if (timestampBoundCase_ == 4) {
            timestampBoundCase_ = 0;
            timestampBound_ = null;
            onChanged();
          }
        } else {
          if (timestampBoundCase_ == 4) {
            timestampBoundCase_ = 0;
            timestampBound_ = null;
          }
          readTimestampBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Executes all reads at the given timestamp. Unlike other modes,
       * reads at a specific timestamp are repeatable; the same read at
       * the same timestamp always returns the same data. If the
       * timestamp is in the future, the read will block until the
       * specified timestamp, modulo the read's deadline.
       * Useful for large scale consistent reads such as mapreduces, or
       * for coordinating many reads against a consistent snapshot of the
       * data.
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_timestamp = 4;</code>
       */
      public com.google.protobuf.Timestamp.Builder getReadTimestampBuilder() {
        return getReadTimestampFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Executes all reads at the given timestamp. Unlike other modes,
       * reads at a specific timestamp are repeatable; the same read at
       * the same timestamp always returns the same data. If the
       * timestamp is in the future, the read will block until the
       * specified timestamp, modulo the read's deadline.
       * Useful for large scale consistent reads such as mapreduces, or
       * for coordinating many reads against a consistent snapshot of the
       * data.
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_timestamp = 4;</code>
       */
      @java.lang.Override
      public com.google.protobuf.TimestampOrBuilder getReadTimestampOrBuilder() {
        if ((timestampBoundCase_ == 4) && (readTimestampBuilder_ != null)) {
          return readTimestampBuilder_.getMessageOrBuilder();
        } else {
          if (timestampBoundCase_ == 4) {
            return (com.google.protobuf.Timestamp) timestampBound_;
          }
          return com.google.protobuf.Timestamp.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Executes all reads at the given timestamp. Unlike other modes,
       * reads at a specific timestamp are repeatable; the same read at
       * the same timestamp always returns the same data. If the
       * timestamp is in the future, the read will block until the
       * specified timestamp, modulo the read's deadline.
       * Useful for large scale consistent reads such as mapreduces, or
       * for coordinating many reads against a consistent snapshot of the
       * data.
       * A timestamp in RFC3339 UTC &#92;"Zulu&#92;" format, accurate to nanoseconds.
       * Example: `"2014-10-02T15:01:23.045123456Z"`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_timestamp = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getReadTimestampFieldBuilder() {
        if (readTimestampBuilder_ == null) {
          if (!(timestampBoundCase_ == 4)) {
            timestampBound_ = com.google.protobuf.Timestamp.getDefaultInstance();
          }
          readTimestampBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  (com.google.protobuf.Timestamp) timestampBound_,
                  getParentForChildren(),
                  isClean());
          timestampBound_ = null;
        }
        timestampBoundCase_ = 4;
        onChanged();
        ;
        return readTimestampBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          exactStalenessBuilder_;
      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp that is `exact_staleness`
       * old. The timestamp is chosen soon after the read is started.
       * Guarantees that all writes that have committed more than the
       * specified number of seconds ago are visible. Because Cloud Spanner
       * chooses the exact timestamp, this mode works even if the client's
       * local clock is substantially skewed from Cloud Spanner commit
       * timestamps.
       * Useful for reading at nearby replicas without the distributed
       * timestamp negotiation overhead of `max_staleness`.
       * </pre>
       *
       * <code>.google.protobuf.Duration exact_staleness = 5;</code>
       *
       * @return Whether the exactStaleness field is set.
       */
      @java.lang.Override
      public boolean hasExactStaleness() {
        return timestampBoundCase_ == 5;
      }
      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp that is `exact_staleness`
       * old. The timestamp is chosen soon after the read is started.
       * Guarantees that all writes that have committed more than the
       * specified number of seconds ago are visible. Because Cloud Spanner
       * chooses the exact timestamp, this mode works even if the client's
       * local clock is substantially skewed from Cloud Spanner commit
       * timestamps.
       * Useful for reading at nearby replicas without the distributed
       * timestamp negotiation overhead of `max_staleness`.
       * </pre>
       *
       * <code>.google.protobuf.Duration exact_staleness = 5;</code>
       *
       * @return The exactStaleness.
       */
      @java.lang.Override
      public com.google.protobuf.Duration getExactStaleness() {
        if (exactStalenessBuilder_ == null) {
          if (timestampBoundCase_ == 5) {
            return (com.google.protobuf.Duration) timestampBound_;
          }
          return com.google.protobuf.Duration.getDefaultInstance();
        } else {
          if (timestampBoundCase_ == 5) {
            return exactStalenessBuilder_.getMessage();
          }
          return com.google.protobuf.Duration.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp that is `exact_staleness`
       * old. The timestamp is chosen soon after the read is started.
       * Guarantees that all writes that have committed more than the
       * specified number of seconds ago are visible. Because Cloud Spanner
       * chooses the exact timestamp, this mode works even if the client's
       * local clock is substantially skewed from Cloud Spanner commit
       * timestamps.
       * Useful for reading at nearby replicas without the distributed
       * timestamp negotiation overhead of `max_staleness`.
       * </pre>
       *
       * <code>.google.protobuf.Duration exact_staleness = 5;</code>
       */
      public Builder setExactStaleness(com.google.protobuf.Duration value) {
        if (exactStalenessBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          timestampBound_ = value;
          onChanged();
        } else {
          exactStalenessBuilder_.setMessage(value);
        }
        timestampBoundCase_ = 5;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp that is `exact_staleness`
       * old. The timestamp is chosen soon after the read is started.
       * Guarantees that all writes that have committed more than the
       * specified number of seconds ago are visible. Because Cloud Spanner
       * chooses the exact timestamp, this mode works even if the client's
       * local clock is substantially skewed from Cloud Spanner commit
       * timestamps.
       * Useful for reading at nearby replicas without the distributed
       * timestamp negotiation overhead of `max_staleness`.
       * </pre>
       *
       * <code>.google.protobuf.Duration exact_staleness = 5;</code>
       */
      public Builder setExactStaleness(com.google.protobuf.Duration.Builder builderForValue) {
        if (exactStalenessBuilder_ == null) {
          timestampBound_ = builderForValue.build();
          onChanged();
        } else {
          exactStalenessBuilder_.setMessage(builderForValue.build());
        }
        timestampBoundCase_ = 5;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp that is `exact_staleness`
       * old. The timestamp is chosen soon after the read is started.
       * Guarantees that all writes that have committed more than the
       * specified number of seconds ago are visible. Because Cloud Spanner
       * chooses the exact timestamp, this mode works even if the client's
       * local clock is substantially skewed from Cloud Spanner commit
       * timestamps.
       * Useful for reading at nearby replicas without the distributed
       * timestamp negotiation overhead of `max_staleness`.
       * </pre>
       *
       * <code>.google.protobuf.Duration exact_staleness = 5;</code>
       */
      public Builder mergeExactStaleness(com.google.protobuf.Duration value) {
        if (exactStalenessBuilder_ == null) {
          if (timestampBoundCase_ == 5
              && timestampBound_ != com.google.protobuf.Duration.getDefaultInstance()) {
            timestampBound_ =
                com.google.protobuf.Duration.newBuilder(
                        (com.google.protobuf.Duration) timestampBound_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            timestampBound_ = value;
          }
          onChanged();
        } else {
          if (timestampBoundCase_ == 5) {
            exactStalenessBuilder_.mergeFrom(value);
          } else {
            exactStalenessBuilder_.setMessage(value);
          }
        }
        timestampBoundCase_ = 5;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp that is `exact_staleness`
       * old. The timestamp is chosen soon after the read is started.
       * Guarantees that all writes that have committed more than the
       * specified number of seconds ago are visible. Because Cloud Spanner
       * chooses the exact timestamp, this mode works even if the client's
       * local clock is substantially skewed from Cloud Spanner commit
       * timestamps.
       * Useful for reading at nearby replicas without the distributed
       * timestamp negotiation overhead of `max_staleness`.
       * </pre>
       *
       * <code>.google.protobuf.Duration exact_staleness = 5;</code>
       */
      public Builder clearExactStaleness() {
        if (exactStalenessBuilder_ == null) {
          if (timestampBoundCase_ == 5) {
            timestampBoundCase_ = 0;
            timestampBound_ = null;
            onChanged();
          }
        } else {
          if (timestampBoundCase_ == 5) {
            timestampBoundCase_ = 0;
            timestampBound_ = null;
          }
          exactStalenessBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp that is `exact_staleness`
       * old. The timestamp is chosen soon after the read is started.
       * Guarantees that all writes that have committed more than the
       * specified number of seconds ago are visible. Because Cloud Spanner
       * chooses the exact timestamp, this mode works even if the client's
       * local clock is substantially skewed from Cloud Spanner commit
       * timestamps.
       * Useful for reading at nearby replicas without the distributed
       * timestamp negotiation overhead of `max_staleness`.
       * </pre>
       *
       * <code>.google.protobuf.Duration exact_staleness = 5;</code>
       */
      public com.google.protobuf.Duration.Builder getExactStalenessBuilder() {
        return getExactStalenessFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp that is `exact_staleness`
       * old. The timestamp is chosen soon after the read is started.
       * Guarantees that all writes that have committed more than the
       * specified number of seconds ago are visible. Because Cloud Spanner
       * chooses the exact timestamp, this mode works even if the client's
       * local clock is substantially skewed from Cloud Spanner commit
       * timestamps.
       * Useful for reading at nearby replicas without the distributed
       * timestamp negotiation overhead of `max_staleness`.
       * </pre>
       *
       * <code>.google.protobuf.Duration exact_staleness = 5;</code>
       */
      @java.lang.Override
      public com.google.protobuf.DurationOrBuilder getExactStalenessOrBuilder() {
        if ((timestampBoundCase_ == 5) && (exactStalenessBuilder_ != null)) {
          return exactStalenessBuilder_.getMessageOrBuilder();
        } else {
          if (timestampBoundCase_ == 5) {
            return (com.google.protobuf.Duration) timestampBound_;
          }
          return com.google.protobuf.Duration.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Executes all reads at a timestamp that is `exact_staleness`
       * old. The timestamp is chosen soon after the read is started.
       * Guarantees that all writes that have committed more than the
       * specified number of seconds ago are visible. Because Cloud Spanner
       * chooses the exact timestamp, this mode works even if the client's
       * local clock is substantially skewed from Cloud Spanner commit
       * timestamps.
       * Useful for reading at nearby replicas without the distributed
       * timestamp negotiation overhead of `max_staleness`.
       * </pre>
       *
       * <code>.google.protobuf.Duration exact_staleness = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getExactStalenessFieldBuilder() {
        if (exactStalenessBuilder_ == null) {
          if (!(timestampBoundCase_ == 5)) {
            timestampBound_ = com.google.protobuf.Duration.getDefaultInstance();
          }
          exactStalenessBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  (com.google.protobuf.Duration) timestampBound_,
                  getParentForChildren(),
                  isClean());
          timestampBound_ = null;
        }
        timestampBoundCase_ = 5;
        onChanged();
        ;
        return exactStalenessBuilder_;
      }

      private boolean returnReadTimestamp_;
      /**
       *
       *
       * <pre>
       * If true, the Cloud Spanner-selected read timestamp is included in
       * the [Transaction][google.spanner.v1.Transaction] message that describes the transaction.
       * </pre>
       *
       * <code>bool return_read_timestamp = 6;</code>
       *
       * @return The returnReadTimestamp.
       */
      @java.lang.Override
      public boolean getReturnReadTimestamp() {
        return returnReadTimestamp_;
      }
      /**
       *
       *
       * <pre>
       * If true, the Cloud Spanner-selected read timestamp is included in
       * the [Transaction][google.spanner.v1.Transaction] message that describes the transaction.
       * </pre>
       *
       * <code>bool return_read_timestamp = 6;</code>
       *
       * @param value The returnReadTimestamp to set.
       * @return This builder for chaining.
       */
      public Builder setReturnReadTimestamp(boolean value) {

        returnReadTimestamp_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If true, the Cloud Spanner-selected read timestamp is included in
       * the [Transaction][google.spanner.v1.Transaction] message that describes the transaction.
       * </pre>
       *
       * <code>bool return_read_timestamp = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearReturnReadTimestamp() {

        returnReadTimestamp_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.spanner.v1.TransactionOptions.ReadOnly)
    }

    // @@protoc_insertion_point(class_scope:google.spanner.v1.TransactionOptions.ReadOnly)
    private static final com.google.spanner.v1.TransactionOptions.ReadOnly DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.spanner.v1.TransactionOptions.ReadOnly();
    }

    public static com.google.spanner.v1.TransactionOptions.ReadOnly getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ReadOnly> PARSER =
        new com.google.protobuf.AbstractParser<ReadOnly>() {
          @java.lang.Override
          public ReadOnly parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new ReadOnly(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<ReadOnly> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ReadOnly> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.spanner.v1.TransactionOptions.ReadOnly getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int modeCase_ = 0;
  private java.lang.Object mode_;

  public enum ModeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    READ_WRITE(1),
    PARTITIONED_DML(3),
    READ_ONLY(2),
    MODE_NOT_SET(0);
    private final int value;

    private ModeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ModeCase valueOf(int value) {
      return forNumber(value);
    }

    public static ModeCase forNumber(int value) {
      switch (value) {
        case 1:
          return READ_WRITE;
        case 3:
          return PARTITIONED_DML;
        case 2:
          return READ_ONLY;
        case 0:
          return MODE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ModeCase getModeCase() {
    return ModeCase.forNumber(modeCase_);
  }

  public static final int READ_WRITE_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Transaction may write.
   * Authorization to begin a read-write transaction requires
   * `spanner.databases.beginOrRollbackReadWriteTransaction` permission
   * on the `session` resource.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionOptions.ReadWrite read_write = 1;</code>
   *
   * @return Whether the readWrite field is set.
   */
  @java.lang.Override
  public boolean hasReadWrite() {
    return modeCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Transaction may write.
   * Authorization to begin a read-write transaction requires
   * `spanner.databases.beginOrRollbackReadWriteTransaction` permission
   * on the `session` resource.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionOptions.ReadWrite read_write = 1;</code>
   *
   * @return The readWrite.
   */
  @java.lang.Override
  public com.google.spanner.v1.TransactionOptions.ReadWrite getReadWrite() {
    if (modeCase_ == 1) {
      return (com.google.spanner.v1.TransactionOptions.ReadWrite) mode_;
    }
    return com.google.spanner.v1.TransactionOptions.ReadWrite.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Transaction may write.
   * Authorization to begin a read-write transaction requires
   * `spanner.databases.beginOrRollbackReadWriteTransaction` permission
   * on the `session` resource.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionOptions.ReadWrite read_write = 1;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.TransactionOptions.ReadWriteOrBuilder getReadWriteOrBuilder() {
    if (modeCase_ == 1) {
      return (com.google.spanner.v1.TransactionOptions.ReadWrite) mode_;
    }
    return com.google.spanner.v1.TransactionOptions.ReadWrite.getDefaultInstance();
  }

  public static final int PARTITIONED_DML_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Partitioned DML transaction.
   * Authorization to begin a Partitioned DML transaction requires
   * `spanner.databases.beginPartitionedDmlTransaction` permission
   * on the `session` resource.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionOptions.PartitionedDml partitioned_dml = 3;</code>
   *
   * @return Whether the partitionedDml field is set.
   */
  @java.lang.Override
  public boolean hasPartitionedDml() {
    return modeCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Partitioned DML transaction.
   * Authorization to begin a Partitioned DML transaction requires
   * `spanner.databases.beginPartitionedDmlTransaction` permission
   * on the `session` resource.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionOptions.PartitionedDml partitioned_dml = 3;</code>
   *
   * @return The partitionedDml.
   */
  @java.lang.Override
  public com.google.spanner.v1.TransactionOptions.PartitionedDml getPartitionedDml() {
    if (modeCase_ == 3) {
      return (com.google.spanner.v1.TransactionOptions.PartitionedDml) mode_;
    }
    return com.google.spanner.v1.TransactionOptions.PartitionedDml.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Partitioned DML transaction.
   * Authorization to begin a Partitioned DML transaction requires
   * `spanner.databases.beginPartitionedDmlTransaction` permission
   * on the `session` resource.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionOptions.PartitionedDml partitioned_dml = 3;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.TransactionOptions.PartitionedDmlOrBuilder
      getPartitionedDmlOrBuilder() {
    if (modeCase_ == 3) {
      return (com.google.spanner.v1.TransactionOptions.PartitionedDml) mode_;
    }
    return com.google.spanner.v1.TransactionOptions.PartitionedDml.getDefaultInstance();
  }

  public static final int READ_ONLY_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Transaction will not write.
   * Authorization to begin a read-only transaction requires
   * `spanner.databases.beginReadOnlyTransaction` permission
   * on the `session` resource.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionOptions.ReadOnly read_only = 2;</code>
   *
   * @return Whether the readOnly field is set.
   */
  @java.lang.Override
  public boolean hasReadOnly() {
    return modeCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Transaction will not write.
   * Authorization to begin a read-only transaction requires
   * `spanner.databases.beginReadOnlyTransaction` permission
   * on the `session` resource.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionOptions.ReadOnly read_only = 2;</code>
   *
   * @return The readOnly.
   */
  @java.lang.Override
  public com.google.spanner.v1.TransactionOptions.ReadOnly getReadOnly() {
    if (modeCase_ == 2) {
      return (com.google.spanner.v1.TransactionOptions.ReadOnly) mode_;
    }
    return com.google.spanner.v1.TransactionOptions.ReadOnly.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Transaction will not write.
   * Authorization to begin a read-only transaction requires
   * `spanner.databases.beginReadOnlyTransaction` permission
   * on the `session` resource.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionOptions.ReadOnly read_only = 2;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.TransactionOptions.ReadOnlyOrBuilder getReadOnlyOrBuilder() {
    if (modeCase_ == 2) {
      return (com.google.spanner.v1.TransactionOptions.ReadOnly) mode_;
    }
    return com.google.spanner.v1.TransactionOptions.ReadOnly.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (modeCase_ == 1) {
      output.writeMessage(1, (com.google.spanner.v1.TransactionOptions.ReadWrite) mode_);
    }
    if (modeCase_ == 2) {
      output.writeMessage(2, (com.google.spanner.v1.TransactionOptions.ReadOnly) mode_);
    }
    if (modeCase_ == 3) {
      output.writeMessage(3, (com.google.spanner.v1.TransactionOptions.PartitionedDml) mode_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (modeCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.spanner.v1.TransactionOptions.ReadWrite) mode_);
    }
    if (modeCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.spanner.v1.TransactionOptions.ReadOnly) mode_);
    }
    if (modeCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.spanner.v1.TransactionOptions.PartitionedDml) mode_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.v1.TransactionOptions)) {
      return super.equals(obj);
    }
    com.google.spanner.v1.TransactionOptions other = (com.google.spanner.v1.TransactionOptions) obj;

    if (!getModeCase().equals(other.getModeCase())) return false;
    switch (modeCase_) {
      case 1:
        if (!getReadWrite().equals(other.getReadWrite())) return false;
        break;
      case 3:
        if (!getPartitionedDml().equals(other.getPartitionedDml())) return false;
        break;
      case 2:
        if (!getReadOnly().equals(other.getReadOnly())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (modeCase_) {
      case 1:
        hash = (37 * hash) + READ_WRITE_FIELD_NUMBER;
        hash = (53 * hash) + getReadWrite().hashCode();
        break;
      case 3:
        hash = (37 * hash) + PARTITIONED_DML_FIELD_NUMBER;
        hash = (53 * hash) + getPartitionedDml().hashCode();
        break;
      case 2:
        hash = (37 * hash) + READ_ONLY_FIELD_NUMBER;
        hash = (53 * hash) + getReadOnly().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.v1.TransactionOptions parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.TransactionOptions parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.TransactionOptions parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.TransactionOptions parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.TransactionOptions parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.TransactionOptions parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.TransactionOptions parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.TransactionOptions parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.TransactionOptions parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.TransactionOptions parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.TransactionOptions parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.TransactionOptions parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.v1.TransactionOptions prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Transactions:
   * Each session can have at most one active transaction at a time (note that
   * standalone reads and queries use a transaction internally and do count
   * towards the one transaction limit). After the active transaction is
   * completed, the session can immediately be re-used for the next transaction.
   * It is not necessary to create a new session for each transaction.
   * Transaction modes:
   * Cloud Spanner supports three transaction modes:
   *   1. Locking read-write. This type of transaction is the only way
   *      to write data into Cloud Spanner. These transactions rely on
   *      pessimistic locking and, if necessary, two-phase commit.
   *      Locking read-write transactions may abort, requiring the
   *      application to retry.
   *   2. Snapshot read-only. Snapshot read-only transactions provide guaranteed
   *      consistency across several reads, but do not allow
   *      writes. Snapshot read-only transactions can be configured to read at
   *      timestamps in the past, or configured to perform a strong read
   *      (where Spanner will select a timestamp such that the read is
   *      guaranteed to see the effects of all transactions that have committed
   *      before the start of the read). Snapshot read-only transactions do not
   *      need to be committed.
   *      Queries on change streams must be performed with the snapshot read-only
   *      transaction mode, specifying a strong read. Please see
   *      [TransactionOptions.ReadOnly.strong][google.spanner.v1.TransactionOptions.ReadOnly.strong] for more details.
   *   3. Partitioned DML. This type of transaction is used to execute
   *      a single Partitioned DML statement. Partitioned DML partitions
   *      the key space and runs the DML statement over each partition
   *      in parallel using separate, internal transactions that commit
   *      independently. Partitioned DML transactions do not need to be
   *      committed.
   * For transactions that only read, snapshot read-only transactions
   * provide simpler semantics and are almost always faster. In
   * particular, read-only transactions do not take locks, so they do
   * not conflict with read-write transactions. As a consequence of not
   * taking locks, they also do not abort, so retry loops are not needed.
   * Transactions may only read-write data in a single database. They
   * may, however, read-write data in different tables within that
   * database.
   * Locking read-write transactions:
   * Locking transactions may be used to atomically read-modify-write
   * data anywhere in a database. This type of transaction is externally
   * consistent.
   * Clients should attempt to minimize the amount of time a transaction
   * is active. Faster transactions commit with higher probability
   * and cause less contention. Cloud Spanner attempts to keep read locks
   * active as long as the transaction continues to do reads, and the
   * transaction has not been terminated by
   * [Commit][google.spanner.v1.Spanner.Commit] or
   * [Rollback][google.spanner.v1.Spanner.Rollback]. Long periods of
   * inactivity at the client may cause Cloud Spanner to release a
   * transaction's locks and abort it.
   * Conceptually, a read-write transaction consists of zero or more
   * reads or SQL statements followed by
   * [Commit][google.spanner.v1.Spanner.Commit]. At any time before
   * [Commit][google.spanner.v1.Spanner.Commit], the client can send a
   * [Rollback][google.spanner.v1.Spanner.Rollback] request to abort the
   * transaction.
   * Semantics:
   * Cloud Spanner can commit the transaction if all read locks it acquired
   * are still valid at commit time, and it is able to acquire write
   * locks for all writes. Cloud Spanner can abort the transaction for any
   * reason. If a commit attempt returns `ABORTED`, Cloud Spanner guarantees
   * that the transaction has not modified any user data in Cloud Spanner.
   * Unless the transaction commits, Cloud Spanner makes no guarantees about
   * how long the transaction's locks were held for. It is an error to
   * use Cloud Spanner locks for any sort of mutual exclusion other than
   * between Cloud Spanner transactions themselves.
   * Retrying aborted transactions:
   * When a transaction aborts, the application can choose to retry the
   * whole transaction again. To maximize the chances of successfully
   * committing the retry, the client should execute the retry in the
   * same session as the original attempt. The original session's lock
   * priority increases with each consecutive abort, meaning that each
   * attempt has a slightly better chance of success than the previous.
   * Under some circumstances (for example, many transactions attempting to
   * modify the same row(s)), a transaction can abort many times in a
   * short period before successfully committing. Thus, it is not a good
   * idea to cap the number of retries a transaction can attempt;
   * instead, it is better to limit the total amount of time spent
   * retrying.
   * Idle transactions:
   * A transaction is considered idle if it has no outstanding reads or
   * SQL queries and has not started a read or SQL query within the last 10
   * seconds. Idle transactions can be aborted by Cloud Spanner so that they
   * don't hold on to locks indefinitely. If an idle transaction is aborted, the
   * commit will fail with error `ABORTED`.
   * If this behavior is undesirable, periodically executing a simple
   * SQL query in the transaction (for example, `SELECT 1`) prevents the
   * transaction from becoming idle.
   * Snapshot read-only transactions:
   * Snapshot read-only transactions provides a simpler method than
   * locking read-write transactions for doing several consistent
   * reads. However, this type of transaction does not support writes.
   * Snapshot transactions do not take locks. Instead, they work by
   * choosing a Cloud Spanner timestamp, then executing all reads at that
   * timestamp. Since they do not acquire locks, they do not block
   * concurrent read-write transactions.
   * Unlike locking read-write transactions, snapshot read-only
   * transactions never abort. They can fail if the chosen read
   * timestamp is garbage collected; however, the default garbage
   * collection policy is generous enough that most applications do not
   * need to worry about this in practice.
   * Snapshot read-only transactions do not need to call
   * [Commit][google.spanner.v1.Spanner.Commit] or
   * [Rollback][google.spanner.v1.Spanner.Rollback] (and in fact are not
   * permitted to do so).
   * To execute a snapshot transaction, the client specifies a timestamp
   * bound, which tells Cloud Spanner how to choose a read timestamp.
   * The types of timestamp bound are:
   *   - Strong (the default).
   *   - Bounded staleness.
   *   - Exact staleness.
   * If the Cloud Spanner database to be read is geographically distributed,
   * stale read-only transactions can execute more quickly than strong
   * or read-write transactions, because they are able to execute far
   * from the leader replica.
   * Each type of timestamp bound is discussed in detail below.
   * Strong: Strong reads are guaranteed to see the effects of all transactions
   * that have committed before the start of the read. Furthermore, all
   * rows yielded by a single read are consistent with each other -- if
   * any part of the read observes a transaction, all parts of the read
   * see the transaction.
   * Strong reads are not repeatable: two consecutive strong read-only
   * transactions might return inconsistent results if there are
   * concurrent writes. If consistency across reads is required, the
   * reads should be executed within a transaction or at an exact read
   * timestamp.
   * Queries on change streams (see below for more details) must also specify
   * the strong read timestamp bound.
   * See [TransactionOptions.ReadOnly.strong][google.spanner.v1.TransactionOptions.ReadOnly.strong].
   * Exact staleness:
   * These timestamp bounds execute reads at a user-specified
   * timestamp. Reads at a timestamp are guaranteed to see a consistent
   * prefix of the global transaction history: they observe
   * modifications done by all transactions with a commit timestamp less than or
   * equal to the read timestamp, and observe none of the modifications done by
   * transactions with a larger commit timestamp. They will block until
   * all conflicting transactions that may be assigned commit timestamps
   * &lt;= the read timestamp have finished.
   * The timestamp can either be expressed as an absolute Cloud Spanner commit
   * timestamp or a staleness relative to the current time.
   * These modes do not require a "negotiation phase" to pick a
   * timestamp. As a result, they execute slightly faster than the
   * equivalent boundedly stale concurrency modes. On the other hand,
   * boundedly stale reads usually return fresher results.
   * See [TransactionOptions.ReadOnly.read_timestamp][google.spanner.v1.TransactionOptions.ReadOnly.read_timestamp] and
   * [TransactionOptions.ReadOnly.exact_staleness][google.spanner.v1.TransactionOptions.ReadOnly.exact_staleness].
   * Bounded staleness:
   * Bounded staleness modes allow Cloud Spanner to pick the read timestamp,
   * subject to a user-provided staleness bound. Cloud Spanner chooses the
   * newest timestamp within the staleness bound that allows execution
   * of the reads at the closest available replica without blocking.
   * All rows yielded are consistent with each other -- if any part of
   * the read observes a transaction, all parts of the read see the
   * transaction. Boundedly stale reads are not repeatable: two stale
   * reads, even if they use the same staleness bound, can execute at
   * different timestamps and thus return inconsistent results.
   * Boundedly stale reads execute in two phases: the first phase
   * negotiates a timestamp among all replicas needed to serve the
   * read. In the second phase, reads are executed at the negotiated
   * timestamp.
   * As a result of the two phase execution, bounded staleness reads are
   * usually a little slower than comparable exact staleness
   * reads. However, they are typically able to return fresher
   * results, and are more likely to execute at the closest replica.
   * Because the timestamp negotiation requires up-front knowledge of
   * which rows will be read, it can only be used with single-use
   * read-only transactions.
   * See [TransactionOptions.ReadOnly.max_staleness][google.spanner.v1.TransactionOptions.ReadOnly.max_staleness] and
   * [TransactionOptions.ReadOnly.min_read_timestamp][google.spanner.v1.TransactionOptions.ReadOnly.min_read_timestamp].
   * Old read timestamps and garbage collection:
   * Cloud Spanner continuously garbage collects deleted and overwritten data
   * in the background to reclaim storage space. This process is known
   * as "version GC". By default, version GC reclaims versions after they
   * are one hour old. Because of this, Cloud Spanner cannot perform reads
   * at read timestamps more than one hour in the past. This
   * restriction also applies to in-progress reads and/or SQL queries whose
   * timestamp become too old while executing. Reads and SQL queries with
   * too-old read timestamps fail with the error `FAILED_PRECONDITION`.
   * You can configure and extend the `VERSION_RETENTION_PERIOD` of a
   * database up to a period as long as one week, which allows Cloud Spanner
   * to perform reads up to one week in the past.
   * Querying change Streams:
   * A Change Stream is a schema object that can be configured to watch data
   * changes on the entire database, a set of tables, or a set of columns
   * in a database.
   * When a change stream is created, Spanner automatically defines a
   * corresponding SQL Table-Valued Function (TVF) that can be used to query
   * the change records in the associated change stream using the
   * ExecuteStreamingSql API. The name of the TVF for a change stream is
   * generated from the name of the change stream: READ_&lt;change_stream_name&gt;.
   * All queries on change stream TVFs must be executed using the
   * ExecuteStreamingSql API with a single-use read-only transaction with a
   * strong read-only timestamp_bound. The change stream TVF allows users to
   * specify the start_timestamp and end_timestamp for the time range of
   * interest. All change records within the retention period is accessible
   * using the strong read-only timestamp_bound. All other TransactionOptions
   * are invalid for change stream queries.
   * In addition, if TransactionOptions.read_only.return_read_timestamp is set
   * to true, a special value of 2^63 - 2 will be returned in the
   * [Transaction][google.spanner.v1.Transaction] message that describes the
   * transaction, instead of a valid read timestamp. This special value should be
   * discarded and not used for any subsequent queries.
   * Please see https://cloud.google.com/spanner/docs/change-streams
   * for more details on how to query the change stream TVFs.
   * Partitioned DML transactions:
   * Partitioned DML transactions are used to execute DML statements with a
   * different execution strategy that provides different, and often better,
   * scalability properties for large, table-wide operations than DML in a
   * ReadWrite transaction. Smaller scoped statements, such as an OLTP workload,
   * should prefer using ReadWrite transactions.
   * Partitioned DML partitions the keyspace and runs the DML statement on each
   * partition in separate, internal transactions. These transactions commit
   * automatically when complete, and run independently from one another.
   * To reduce lock contention, this execution strategy only acquires read locks
   * on rows that match the WHERE clause of the statement. Additionally, the
   * smaller per-partition transactions hold locks for less time.
   * That said, Partitioned DML is not a drop-in replacement for standard DML used
   * in ReadWrite transactions.
   *  - The DML statement must be fully-partitionable. Specifically, the statement
   *    must be expressible as the union of many statements which each access only
   *    a single row of the table.
   *  - The statement is not applied atomically to all rows of the table. Rather,
   *    the statement is applied atomically to partitions of the table, in
   *    independent transactions. Secondary index rows are updated atomically
   *    with the base table rows.
   *  - Partitioned DML does not guarantee exactly-once execution semantics
   *    against a partition. The statement will be applied at least once to each
   *    partition. It is strongly recommended that the DML statement should be
   *    idempotent to avoid unexpected results. For instance, it is potentially
   *    dangerous to run a statement such as
   *    `UPDATE table SET column = column + 1` as it could be run multiple times
   *    against some rows.
   *  - The partitions are committed automatically - there is no support for
   *    Commit or Rollback. If the call returns an error, or if the client issuing
   *    the ExecuteSql call dies, it is possible that some rows had the statement
   *    executed on them successfully. It is also possible that statement was
   *    never executed against other rows.
   *  - Partitioned DML transactions may only contain the execution of a single
   *    DML statement via ExecuteSql or ExecuteStreamingSql.
   *  - If any error is encountered during the execution of the partitioned DML
   *    operation (for instance, a UNIQUE INDEX violation, division by zero, or a
   *    value that cannot be stored due to schema constraints), then the
   *    operation is stopped at that point and an error is returned. It is
   *    possible that at this point, some partitions have been committed (or even
   *    committed multiple times), and other partitions have not been run at all.
   * Given the above, Partitioned DML is good fit for large, database-wide,
   * operations that are idempotent, such as deleting old rows from a very large
   * table.
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.TransactionOptions}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.v1.TransactionOptions)
      com.google.spanner.v1.TransactionOptionsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.TransactionProto
          .internal_static_google_spanner_v1_TransactionOptions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.TransactionProto
          .internal_static_google_spanner_v1_TransactionOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.TransactionOptions.class,
              com.google.spanner.v1.TransactionOptions.Builder.class);
    }

    // Construct using com.google.spanner.v1.TransactionOptions.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      modeCase_ = 0;
      mode_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.v1.TransactionProto
          .internal_static_google_spanner_v1_TransactionOptions_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.v1.TransactionOptions getDefaultInstanceForType() {
      return com.google.spanner.v1.TransactionOptions.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.v1.TransactionOptions build() {
      com.google.spanner.v1.TransactionOptions result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.v1.TransactionOptions buildPartial() {
      com.google.spanner.v1.TransactionOptions result =
          new com.google.spanner.v1.TransactionOptions(this);
      if (modeCase_ == 1) {
        if (readWriteBuilder_ == null) {
          result.mode_ = mode_;
        } else {
          result.mode_ = readWriteBuilder_.build();
        }
      }
      if (modeCase_ == 3) {
        if (partitionedDmlBuilder_ == null) {
          result.mode_ = mode_;
        } else {
          result.mode_ = partitionedDmlBuilder_.build();
        }
      }
      if (modeCase_ == 2) {
        if (readOnlyBuilder_ == null) {
          result.mode_ = mode_;
        } else {
          result.mode_ = readOnlyBuilder_.build();
        }
      }
      result.modeCase_ = modeCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.v1.TransactionOptions) {
        return mergeFrom((com.google.spanner.v1.TransactionOptions) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.v1.TransactionOptions other) {
      if (other == com.google.spanner.v1.TransactionOptions.getDefaultInstance()) return this;
      switch (other.getModeCase()) {
        case READ_WRITE:
          {
            mergeReadWrite(other.getReadWrite());
            break;
          }
        case PARTITIONED_DML:
          {
            mergePartitionedDml(other.getPartitionedDml());
            break;
          }
        case READ_ONLY:
          {
            mergeReadOnly(other.getReadOnly());
            break;
          }
        case MODE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.spanner.v1.TransactionOptions parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.spanner.v1.TransactionOptions) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int modeCase_ = 0;
    private java.lang.Object mode_;

    public ModeCase getModeCase() {
      return ModeCase.forNumber(modeCase_);
    }

    public Builder clearMode() {
      modeCase_ = 0;
      mode_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.TransactionOptions.ReadWrite,
            com.google.spanner.v1.TransactionOptions.ReadWrite.Builder,
            com.google.spanner.v1.TransactionOptions.ReadWriteOrBuilder>
        readWriteBuilder_;
    /**
     *
     *
     * <pre>
     * Transaction may write.
     * Authorization to begin a read-write transaction requires
     * `spanner.databases.beginOrRollbackReadWriteTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadWrite read_write = 1;</code>
     *
     * @return Whether the readWrite field is set.
     */
    @java.lang.Override
    public boolean hasReadWrite() {
      return modeCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Transaction may write.
     * Authorization to begin a read-write transaction requires
     * `spanner.databases.beginOrRollbackReadWriteTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadWrite read_write = 1;</code>
     *
     * @return The readWrite.
     */
    @java.lang.Override
    public com.google.spanner.v1.TransactionOptions.ReadWrite getReadWrite() {
      if (readWriteBuilder_ == null) {
        if (modeCase_ == 1) {
          return (com.google.spanner.v1.TransactionOptions.ReadWrite) mode_;
        }
        return com.google.spanner.v1.TransactionOptions.ReadWrite.getDefaultInstance();
      } else {
        if (modeCase_ == 1) {
          return readWriteBuilder_.getMessage();
        }
        return com.google.spanner.v1.TransactionOptions.ReadWrite.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Transaction may write.
     * Authorization to begin a read-write transaction requires
     * `spanner.databases.beginOrRollbackReadWriteTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadWrite read_write = 1;</code>
     */
    public Builder setReadWrite(com.google.spanner.v1.TransactionOptions.ReadWrite value) {
      if (readWriteBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        mode_ = value;
        onChanged();
      } else {
        readWriteBuilder_.setMessage(value);
      }
      modeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transaction may write.
     * Authorization to begin a read-write transaction requires
     * `spanner.databases.beginOrRollbackReadWriteTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadWrite read_write = 1;</code>
     */
    public Builder setReadWrite(
        com.google.spanner.v1.TransactionOptions.ReadWrite.Builder builderForValue) {
      if (readWriteBuilder_ == null) {
        mode_ = builderForValue.build();
        onChanged();
      } else {
        readWriteBuilder_.setMessage(builderForValue.build());
      }
      modeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transaction may write.
     * Authorization to begin a read-write transaction requires
     * `spanner.databases.beginOrRollbackReadWriteTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadWrite read_write = 1;</code>
     */
    public Builder mergeReadWrite(com.google.spanner.v1.TransactionOptions.ReadWrite value) {
      if (readWriteBuilder_ == null) {
        if (modeCase_ == 1
            && mode_ != com.google.spanner.v1.TransactionOptions.ReadWrite.getDefaultInstance()) {
          mode_ =
              com.google.spanner.v1.TransactionOptions.ReadWrite.newBuilder(
                      (com.google.spanner.v1.TransactionOptions.ReadWrite) mode_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          mode_ = value;
        }
        onChanged();
      } else {
        if (modeCase_ == 1) {
          readWriteBuilder_.mergeFrom(value);
        } else {
          readWriteBuilder_.setMessage(value);
        }
      }
      modeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transaction may write.
     * Authorization to begin a read-write transaction requires
     * `spanner.databases.beginOrRollbackReadWriteTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadWrite read_write = 1;</code>
     */
    public Builder clearReadWrite() {
      if (readWriteBuilder_ == null) {
        if (modeCase_ == 1) {
          modeCase_ = 0;
          mode_ = null;
          onChanged();
        }
      } else {
        if (modeCase_ == 1) {
          modeCase_ = 0;
          mode_ = null;
        }
        readWriteBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transaction may write.
     * Authorization to begin a read-write transaction requires
     * `spanner.databases.beginOrRollbackReadWriteTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadWrite read_write = 1;</code>
     */
    public com.google.spanner.v1.TransactionOptions.ReadWrite.Builder getReadWriteBuilder() {
      return getReadWriteFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Transaction may write.
     * Authorization to begin a read-write transaction requires
     * `spanner.databases.beginOrRollbackReadWriteTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadWrite read_write = 1;</code>
     */
    @java.lang.Override
    public com.google.spanner.v1.TransactionOptions.ReadWriteOrBuilder getReadWriteOrBuilder() {
      if ((modeCase_ == 1) && (readWriteBuilder_ != null)) {
        return readWriteBuilder_.getMessageOrBuilder();
      } else {
        if (modeCase_ == 1) {
          return (com.google.spanner.v1.TransactionOptions.ReadWrite) mode_;
        }
        return com.google.spanner.v1.TransactionOptions.ReadWrite.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Transaction may write.
     * Authorization to begin a read-write transaction requires
     * `spanner.databases.beginOrRollbackReadWriteTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadWrite read_write = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.TransactionOptions.ReadWrite,
            com.google.spanner.v1.TransactionOptions.ReadWrite.Builder,
            com.google.spanner.v1.TransactionOptions.ReadWriteOrBuilder>
        getReadWriteFieldBuilder() {
      if (readWriteBuilder_ == null) {
        if (!(modeCase_ == 1)) {
          mode_ = com.google.spanner.v1.TransactionOptions.ReadWrite.getDefaultInstance();
        }
        readWriteBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.TransactionOptions.ReadWrite,
                com.google.spanner.v1.TransactionOptions.ReadWrite.Builder,
                com.google.spanner.v1.TransactionOptions.ReadWriteOrBuilder>(
                (com.google.spanner.v1.TransactionOptions.ReadWrite) mode_,
                getParentForChildren(),
                isClean());
        mode_ = null;
      }
      modeCase_ = 1;
      onChanged();
      ;
      return readWriteBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.TransactionOptions.PartitionedDml,
            com.google.spanner.v1.TransactionOptions.PartitionedDml.Builder,
            com.google.spanner.v1.TransactionOptions.PartitionedDmlOrBuilder>
        partitionedDmlBuilder_;
    /**
     *
     *
     * <pre>
     * Partitioned DML transaction.
     * Authorization to begin a Partitioned DML transaction requires
     * `spanner.databases.beginPartitionedDmlTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.PartitionedDml partitioned_dml = 3;</code>
     *
     * @return Whether the partitionedDml field is set.
     */
    @java.lang.Override
    public boolean hasPartitionedDml() {
      return modeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Partitioned DML transaction.
     * Authorization to begin a Partitioned DML transaction requires
     * `spanner.databases.beginPartitionedDmlTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.PartitionedDml partitioned_dml = 3;</code>
     *
     * @return The partitionedDml.
     */
    @java.lang.Override
    public com.google.spanner.v1.TransactionOptions.PartitionedDml getPartitionedDml() {
      if (partitionedDmlBuilder_ == null) {
        if (modeCase_ == 3) {
          return (com.google.spanner.v1.TransactionOptions.PartitionedDml) mode_;
        }
        return com.google.spanner.v1.TransactionOptions.PartitionedDml.getDefaultInstance();
      } else {
        if (modeCase_ == 3) {
          return partitionedDmlBuilder_.getMessage();
        }
        return com.google.spanner.v1.TransactionOptions.PartitionedDml.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Partitioned DML transaction.
     * Authorization to begin a Partitioned DML transaction requires
     * `spanner.databases.beginPartitionedDmlTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.PartitionedDml partitioned_dml = 3;</code>
     */
    public Builder setPartitionedDml(
        com.google.spanner.v1.TransactionOptions.PartitionedDml value) {
      if (partitionedDmlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        mode_ = value;
        onChanged();
      } else {
        partitionedDmlBuilder_.setMessage(value);
      }
      modeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partitioned DML transaction.
     * Authorization to begin a Partitioned DML transaction requires
     * `spanner.databases.beginPartitionedDmlTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.PartitionedDml partitioned_dml = 3;</code>
     */
    public Builder setPartitionedDml(
        com.google.spanner.v1.TransactionOptions.PartitionedDml.Builder builderForValue) {
      if (partitionedDmlBuilder_ == null) {
        mode_ = builderForValue.build();
        onChanged();
      } else {
        partitionedDmlBuilder_.setMessage(builderForValue.build());
      }
      modeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partitioned DML transaction.
     * Authorization to begin a Partitioned DML transaction requires
     * `spanner.databases.beginPartitionedDmlTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.PartitionedDml partitioned_dml = 3;</code>
     */
    public Builder mergePartitionedDml(
        com.google.spanner.v1.TransactionOptions.PartitionedDml value) {
      if (partitionedDmlBuilder_ == null) {
        if (modeCase_ == 3
            && mode_
                != com.google.spanner.v1.TransactionOptions.PartitionedDml.getDefaultInstance()) {
          mode_ =
              com.google.spanner.v1.TransactionOptions.PartitionedDml.newBuilder(
                      (com.google.spanner.v1.TransactionOptions.PartitionedDml) mode_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          mode_ = value;
        }
        onChanged();
      } else {
        if (modeCase_ == 3) {
          partitionedDmlBuilder_.mergeFrom(value);
        } else {
          partitionedDmlBuilder_.setMessage(value);
        }
      }
      modeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partitioned DML transaction.
     * Authorization to begin a Partitioned DML transaction requires
     * `spanner.databases.beginPartitionedDmlTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.PartitionedDml partitioned_dml = 3;</code>
     */
    public Builder clearPartitionedDml() {
      if (partitionedDmlBuilder_ == null) {
        if (modeCase_ == 3) {
          modeCase_ = 0;
          mode_ = null;
          onChanged();
        }
      } else {
        if (modeCase_ == 3) {
          modeCase_ = 0;
          mode_ = null;
        }
        partitionedDmlBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partitioned DML transaction.
     * Authorization to begin a Partitioned DML transaction requires
     * `spanner.databases.beginPartitionedDmlTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.PartitionedDml partitioned_dml = 3;</code>
     */
    public com.google.spanner.v1.TransactionOptions.PartitionedDml.Builder
        getPartitionedDmlBuilder() {
      return getPartitionedDmlFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Partitioned DML transaction.
     * Authorization to begin a Partitioned DML transaction requires
     * `spanner.databases.beginPartitionedDmlTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.PartitionedDml partitioned_dml = 3;</code>
     */
    @java.lang.Override
    public com.google.spanner.v1.TransactionOptions.PartitionedDmlOrBuilder
        getPartitionedDmlOrBuilder() {
      if ((modeCase_ == 3) && (partitionedDmlBuilder_ != null)) {
        return partitionedDmlBuilder_.getMessageOrBuilder();
      } else {
        if (modeCase_ == 3) {
          return (com.google.spanner.v1.TransactionOptions.PartitionedDml) mode_;
        }
        return com.google.spanner.v1.TransactionOptions.PartitionedDml.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Partitioned DML transaction.
     * Authorization to begin a Partitioned DML transaction requires
     * `spanner.databases.beginPartitionedDmlTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.PartitionedDml partitioned_dml = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.TransactionOptions.PartitionedDml,
            com.google.spanner.v1.TransactionOptions.PartitionedDml.Builder,
            com.google.spanner.v1.TransactionOptions.PartitionedDmlOrBuilder>
        getPartitionedDmlFieldBuilder() {
      if (partitionedDmlBuilder_ == null) {
        if (!(modeCase_ == 3)) {
          mode_ = com.google.spanner.v1.TransactionOptions.PartitionedDml.getDefaultInstance();
        }
        partitionedDmlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.TransactionOptions.PartitionedDml,
                com.google.spanner.v1.TransactionOptions.PartitionedDml.Builder,
                com.google.spanner.v1.TransactionOptions.PartitionedDmlOrBuilder>(
                (com.google.spanner.v1.TransactionOptions.PartitionedDml) mode_,
                getParentForChildren(),
                isClean());
        mode_ = null;
      }
      modeCase_ = 3;
      onChanged();
      ;
      return partitionedDmlBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.TransactionOptions.ReadOnly,
            com.google.spanner.v1.TransactionOptions.ReadOnly.Builder,
            com.google.spanner.v1.TransactionOptions.ReadOnlyOrBuilder>
        readOnlyBuilder_;
    /**
     *
     *
     * <pre>
     * Transaction will not write.
     * Authorization to begin a read-only transaction requires
     * `spanner.databases.beginReadOnlyTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     *
     * @return Whether the readOnly field is set.
     */
    @java.lang.Override
    public boolean hasReadOnly() {
      return modeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Transaction will not write.
     * Authorization to begin a read-only transaction requires
     * `spanner.databases.beginReadOnlyTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     *
     * @return The readOnly.
     */
    @java.lang.Override
    public com.google.spanner.v1.TransactionOptions.ReadOnly getReadOnly() {
      if (readOnlyBuilder_ == null) {
        if (modeCase_ == 2) {
          return (com.google.spanner.v1.TransactionOptions.ReadOnly) mode_;
        }
        return com.google.spanner.v1.TransactionOptions.ReadOnly.getDefaultInstance();
      } else {
        if (modeCase_ == 2) {
          return readOnlyBuilder_.getMessage();
        }
        return com.google.spanner.v1.TransactionOptions.ReadOnly.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Transaction will not write.
     * Authorization to begin a read-only transaction requires
     * `spanner.databases.beginReadOnlyTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     */
    public Builder setReadOnly(com.google.spanner.v1.TransactionOptions.ReadOnly value) {
      if (readOnlyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        mode_ = value;
        onChanged();
      } else {
        readOnlyBuilder_.setMessage(value);
      }
      modeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transaction will not write.
     * Authorization to begin a read-only transaction requires
     * `spanner.databases.beginReadOnlyTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     */
    public Builder setReadOnly(
        com.google.spanner.v1.TransactionOptions.ReadOnly.Builder builderForValue) {
      if (readOnlyBuilder_ == null) {
        mode_ = builderForValue.build();
        onChanged();
      } else {
        readOnlyBuilder_.setMessage(builderForValue.build());
      }
      modeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transaction will not write.
     * Authorization to begin a read-only transaction requires
     * `spanner.databases.beginReadOnlyTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     */
    public Builder mergeReadOnly(com.google.spanner.v1.TransactionOptions.ReadOnly value) {
      if (readOnlyBuilder_ == null) {
        if (modeCase_ == 2
            && mode_ != com.google.spanner.v1.TransactionOptions.ReadOnly.getDefaultInstance()) {
          mode_ =
              com.google.spanner.v1.TransactionOptions.ReadOnly.newBuilder(
                      (com.google.spanner.v1.TransactionOptions.ReadOnly) mode_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          mode_ = value;
        }
        onChanged();
      } else {
        if (modeCase_ == 2) {
          readOnlyBuilder_.mergeFrom(value);
        } else {
          readOnlyBuilder_.setMessage(value);
        }
      }
      modeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transaction will not write.
     * Authorization to begin a read-only transaction requires
     * `spanner.databases.beginReadOnlyTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     */
    public Builder clearReadOnly() {
      if (readOnlyBuilder_ == null) {
        if (modeCase_ == 2) {
          modeCase_ = 0;
          mode_ = null;
          onChanged();
        }
      } else {
        if (modeCase_ == 2) {
          modeCase_ = 0;
          mode_ = null;
        }
        readOnlyBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transaction will not write.
     * Authorization to begin a read-only transaction requires
     * `spanner.databases.beginReadOnlyTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     */
    public com.google.spanner.v1.TransactionOptions.ReadOnly.Builder getReadOnlyBuilder() {
      return getReadOnlyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Transaction will not write.
     * Authorization to begin a read-only transaction requires
     * `spanner.databases.beginReadOnlyTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     */
    @java.lang.Override
    public com.google.spanner.v1.TransactionOptions.ReadOnlyOrBuilder getReadOnlyOrBuilder() {
      if ((modeCase_ == 2) && (readOnlyBuilder_ != null)) {
        return readOnlyBuilder_.getMessageOrBuilder();
      } else {
        if (modeCase_ == 2) {
          return (com.google.spanner.v1.TransactionOptions.ReadOnly) mode_;
        }
        return com.google.spanner.v1.TransactionOptions.ReadOnly.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Transaction will not write.
     * Authorization to begin a read-only transaction requires
     * `spanner.databases.beginReadOnlyTransaction` permission
     * on the `session` resource.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.TransactionOptions.ReadOnly,
            com.google.spanner.v1.TransactionOptions.ReadOnly.Builder,
            com.google.spanner.v1.TransactionOptions.ReadOnlyOrBuilder>
        getReadOnlyFieldBuilder() {
      if (readOnlyBuilder_ == null) {
        if (!(modeCase_ == 2)) {
          mode_ = com.google.spanner.v1.TransactionOptions.ReadOnly.getDefaultInstance();
        }
        readOnlyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.TransactionOptions.ReadOnly,
                com.google.spanner.v1.TransactionOptions.ReadOnly.Builder,
                com.google.spanner.v1.TransactionOptions.ReadOnlyOrBuilder>(
                (com.google.spanner.v1.TransactionOptions.ReadOnly) mode_,
                getParentForChildren(),
                isClean());
        mode_ = null;
      }
      modeCase_ = 2;
      onChanged();
      ;
      return readOnlyBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.v1.TransactionOptions)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.v1.TransactionOptions)
  private static final com.google.spanner.v1.TransactionOptions DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.v1.TransactionOptions();
  }

  public static com.google.spanner.v1.TransactionOptions getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TransactionOptions> PARSER =
      new com.google.protobuf.AbstractParser<TransactionOptions>() {
        @java.lang.Override
        public TransactionOptions parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new TransactionOptions(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<TransactionOptions> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TransactionOptions> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.v1.TransactionOptions getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
