/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/v1/spanner.proto

package com.google.spanner.v1;

/**
 *
 *
 * <pre>
 * Common request options for various APIs.
 * </pre>
 *
 * Protobuf type {@code google.spanner.v1.RequestOptions}
 */
public final class RequestOptions extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.v1.RequestOptions)
    RequestOptionsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RequestOptions.newBuilder() to construct.
  private RequestOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RequestOptions() {
    priority_ = 0;
    requestTag_ = "";
    transactionTag_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RequestOptions();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.v1.SpannerProto
        .internal_static_google_spanner_v1_RequestOptions_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.v1.SpannerProto
        .internal_static_google_spanner_v1_RequestOptions_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.v1.RequestOptions.class,
            com.google.spanner.v1.RequestOptions.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The relative priority for requests. Note that priority is not applicable
   * for [BeginTransaction][google.spanner.v1.Spanner.BeginTransaction].
   * The priority acts as a hint to the Cloud Spanner scheduler and does not
   * guarantee priority or order of execution. For example:
   * * Some parts of a write operation always execute at `PRIORITY_HIGH`,
   *   regardless of the specified priority. This may cause you to see an
   *   increase in high priority workload even when executing a low priority
   *   request. This can also potentially cause a priority inversion where a
   *   lower priority request will be fulfilled ahead of a higher priority
   *   request.
   * * If a transaction contains multiple operations with different priorities,
   *   Cloud Spanner does not guarantee to process the higher priority
   *   operations first. There may be other constraints to satisfy, such as
   *   order of operations.
   * </pre>
   *
   * Protobuf enum {@code google.spanner.v1.RequestOptions.Priority}
   */
  public enum Priority implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * `PRIORITY_UNSPECIFIED` is equivalent to `PRIORITY_HIGH`.
     * </pre>
     *
     * <code>PRIORITY_UNSPECIFIED = 0;</code>
     */
    PRIORITY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * This specifies that the request is low priority.
     * </pre>
     *
     * <code>PRIORITY_LOW = 1;</code>
     */
    PRIORITY_LOW(1),
    /**
     *
     *
     * <pre>
     * This specifies that the request is medium priority.
     * </pre>
     *
     * <code>PRIORITY_MEDIUM = 2;</code>
     */
    PRIORITY_MEDIUM(2),
    /**
     *
     *
     * <pre>
     * This specifies that the request is high priority.
     * </pre>
     *
     * <code>PRIORITY_HIGH = 3;</code>
     */
    PRIORITY_HIGH(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * `PRIORITY_UNSPECIFIED` is equivalent to `PRIORITY_HIGH`.
     * </pre>
     *
     * <code>PRIORITY_UNSPECIFIED = 0;</code>
     */
    public static final int PRIORITY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * This specifies that the request is low priority.
     * </pre>
     *
     * <code>PRIORITY_LOW = 1;</code>
     */
    public static final int PRIORITY_LOW_VALUE = 1;
    /**
     *
     *
     * <pre>
     * This specifies that the request is medium priority.
     * </pre>
     *
     * <code>PRIORITY_MEDIUM = 2;</code>
     */
    public static final int PRIORITY_MEDIUM_VALUE = 2;
    /**
     *
     *
     * <pre>
     * This specifies that the request is high priority.
     * </pre>
     *
     * <code>PRIORITY_HIGH = 3;</code>
     */
    public static final int PRIORITY_HIGH_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Priority valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Priority forNumber(int value) {
      switch (value) {
        case 0:
          return PRIORITY_UNSPECIFIED;
        case 1:
          return PRIORITY_LOW;
        case 2:
          return PRIORITY_MEDIUM;
        case 3:
          return PRIORITY_HIGH;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Priority> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Priority> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Priority>() {
          public Priority findValueByNumber(int number) {
            return Priority.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.spanner.v1.RequestOptions.getDescriptor().getEnumTypes().get(0);
    }

    private static final Priority[] VALUES = values();

    public static Priority valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Priority(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.spanner.v1.RequestOptions.Priority)
  }

  public static final int PRIORITY_FIELD_NUMBER = 1;
  private int priority_;
  /**
   *
   *
   * <pre>
   * Priority for the request.
   * </pre>
   *
   * <code>.google.spanner.v1.RequestOptions.Priority priority = 1;</code>
   *
   * @return The enum numeric value on the wire for priority.
   */
  @java.lang.Override
  public int getPriorityValue() {
    return priority_;
  }
  /**
   *
   *
   * <pre>
   * Priority for the request.
   * </pre>
   *
   * <code>.google.spanner.v1.RequestOptions.Priority priority = 1;</code>
   *
   * @return The priority.
   */
  @java.lang.Override
  public com.google.spanner.v1.RequestOptions.Priority getPriority() {
    @SuppressWarnings("deprecation")
    com.google.spanner.v1.RequestOptions.Priority result =
        com.google.spanner.v1.RequestOptions.Priority.valueOf(priority_);
    return result == null ? com.google.spanner.v1.RequestOptions.Priority.UNRECOGNIZED : result;
  }

  public static final int REQUEST_TAG_FIELD_NUMBER = 2;
  private volatile java.lang.Object requestTag_;
  /**
   *
   *
   * <pre>
   * A per-request tag which can be applied to queries or reads, used for
   * statistics collection.
   * Both request_tag and transaction_tag can be specified for a read or query
   * that belongs to a transaction.
   * This field is ignored for requests where it's not applicable (e.g.
   * CommitRequest).
   * Legal characters for `request_tag` values are all printable characters
   * (ASCII 32 - 126) and the length of a request_tag is limited to 50
   * characters. Values that exceed this limit are truncated.
   * Any leading underscore (_) characters will be removed from the string.
   * </pre>
   *
   * <code>string request_tag = 2;</code>
   *
   * @return The requestTag.
   */
  @java.lang.Override
  public java.lang.String getRequestTag() {
    java.lang.Object ref = requestTag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestTag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A per-request tag which can be applied to queries or reads, used for
   * statistics collection.
   * Both request_tag and transaction_tag can be specified for a read or query
   * that belongs to a transaction.
   * This field is ignored for requests where it's not applicable (e.g.
   * CommitRequest).
   * Legal characters for `request_tag` values are all printable characters
   * (ASCII 32 - 126) and the length of a request_tag is limited to 50
   * characters. Values that exceed this limit are truncated.
   * Any leading underscore (_) characters will be removed from the string.
   * </pre>
   *
   * <code>string request_tag = 2;</code>
   *
   * @return The bytes for requestTag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestTagBytes() {
    java.lang.Object ref = requestTag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestTag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRANSACTION_TAG_FIELD_NUMBER = 3;
  private volatile java.lang.Object transactionTag_;
  /**
   *
   *
   * <pre>
   * A tag used for statistics collection about this transaction.
   * Both request_tag and transaction_tag can be specified for a read or query
   * that belongs to a transaction.
   * The value of transaction_tag should be the same for all requests belonging
   * to the same transaction.
   * If this request doesn't belong to any transaction, transaction_tag will be
   * ignored.
   * Legal characters for `transaction_tag` values are all printable characters
   * (ASCII 32 - 126) and the length of a transaction_tag is limited to 50
   * characters. Values that exceed this limit are truncated.
   * Any leading underscore (_) characters will be removed from the string.
   * </pre>
   *
   * <code>string transaction_tag = 3;</code>
   *
   * @return The transactionTag.
   */
  @java.lang.Override
  public java.lang.String getTransactionTag() {
    java.lang.Object ref = transactionTag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      transactionTag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A tag used for statistics collection about this transaction.
   * Both request_tag and transaction_tag can be specified for a read or query
   * that belongs to a transaction.
   * The value of transaction_tag should be the same for all requests belonging
   * to the same transaction.
   * If this request doesn't belong to any transaction, transaction_tag will be
   * ignored.
   * Legal characters for `transaction_tag` values are all printable characters
   * (ASCII 32 - 126) and the length of a transaction_tag is limited to 50
   * characters. Values that exceed this limit are truncated.
   * Any leading underscore (_) characters will be removed from the string.
   * </pre>
   *
   * <code>string transaction_tag = 3;</code>
   *
   * @return The bytes for transactionTag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTransactionTagBytes() {
    java.lang.Object ref = transactionTag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      transactionTag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (priority_
        != com.google.spanner.v1.RequestOptions.Priority.PRIORITY_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, priority_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestTag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, requestTag_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(transactionTag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, transactionTag_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (priority_
        != com.google.spanner.v1.RequestOptions.Priority.PRIORITY_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, priority_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestTag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, requestTag_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(transactionTag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, transactionTag_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.v1.RequestOptions)) {
      return super.equals(obj);
    }
    com.google.spanner.v1.RequestOptions other = (com.google.spanner.v1.RequestOptions) obj;

    if (priority_ != other.priority_) return false;
    if (!getRequestTag().equals(other.getRequestTag())) return false;
    if (!getTransactionTag().equals(other.getTransactionTag())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PRIORITY_FIELD_NUMBER;
    hash = (53 * hash) + priority_;
    hash = (37 * hash) + REQUEST_TAG_FIELD_NUMBER;
    hash = (53 * hash) + getRequestTag().hashCode();
    hash = (37 * hash) + TRANSACTION_TAG_FIELD_NUMBER;
    hash = (53 * hash) + getTransactionTag().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.v1.RequestOptions parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.RequestOptions parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.RequestOptions parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.RequestOptions parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.RequestOptions parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.RequestOptions parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.RequestOptions parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.RequestOptions parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.RequestOptions parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.RequestOptions parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.RequestOptions parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.RequestOptions parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.v1.RequestOptions prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Common request options for various APIs.
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.RequestOptions}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.v1.RequestOptions)
      com.google.spanner.v1.RequestOptionsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_RequestOptions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_RequestOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.RequestOptions.class,
              com.google.spanner.v1.RequestOptions.Builder.class);
    }

    // Construct using com.google.spanner.v1.RequestOptions.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      priority_ = 0;

      requestTag_ = "";

      transactionTag_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_RequestOptions_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.v1.RequestOptions getDefaultInstanceForType() {
      return com.google.spanner.v1.RequestOptions.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.v1.RequestOptions build() {
      com.google.spanner.v1.RequestOptions result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.v1.RequestOptions buildPartial() {
      com.google.spanner.v1.RequestOptions result = new com.google.spanner.v1.RequestOptions(this);
      result.priority_ = priority_;
      result.requestTag_ = requestTag_;
      result.transactionTag_ = transactionTag_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.v1.RequestOptions) {
        return mergeFrom((com.google.spanner.v1.RequestOptions) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.v1.RequestOptions other) {
      if (other == com.google.spanner.v1.RequestOptions.getDefaultInstance()) return this;
      if (other.priority_ != 0) {
        setPriorityValue(other.getPriorityValue());
      }
      if (!other.getRequestTag().isEmpty()) {
        requestTag_ = other.requestTag_;
        onChanged();
      }
      if (!other.getTransactionTag().isEmpty()) {
        transactionTag_ = other.transactionTag_;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                priority_ = input.readEnum();

                break;
              } // case 8
            case 18:
              {
                requestTag_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                transactionTag_ = input.readStringRequireUtf8();

                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int priority_ = 0;
    /**
     *
     *
     * <pre>
     * Priority for the request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions.Priority priority = 1;</code>
     *
     * @return The enum numeric value on the wire for priority.
     */
    @java.lang.Override
    public int getPriorityValue() {
      return priority_;
    }
    /**
     *
     *
     * <pre>
     * Priority for the request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions.Priority priority = 1;</code>
     *
     * @param value The enum numeric value on the wire for priority to set.
     * @return This builder for chaining.
     */
    public Builder setPriorityValue(int value) {

      priority_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Priority for the request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions.Priority priority = 1;</code>
     *
     * @return The priority.
     */
    @java.lang.Override
    public com.google.spanner.v1.RequestOptions.Priority getPriority() {
      @SuppressWarnings("deprecation")
      com.google.spanner.v1.RequestOptions.Priority result =
          com.google.spanner.v1.RequestOptions.Priority.valueOf(priority_);
      return result == null ? com.google.spanner.v1.RequestOptions.Priority.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Priority for the request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions.Priority priority = 1;</code>
     *
     * @param value The priority to set.
     * @return This builder for chaining.
     */
    public Builder setPriority(com.google.spanner.v1.RequestOptions.Priority value) {
      if (value == null) {
        throw new NullPointerException();
      }

      priority_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Priority for the request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions.Priority priority = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPriority() {

      priority_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object requestTag_ = "";
    /**
     *
     *
     * <pre>
     * A per-request tag which can be applied to queries or reads, used for
     * statistics collection.
     * Both request_tag and transaction_tag can be specified for a read or query
     * that belongs to a transaction.
     * This field is ignored for requests where it's not applicable (e.g.
     * CommitRequest).
     * Legal characters for `request_tag` values are all printable characters
     * (ASCII 32 - 126) and the length of a request_tag is limited to 50
     * characters. Values that exceed this limit are truncated.
     * Any leading underscore (_) characters will be removed from the string.
     * </pre>
     *
     * <code>string request_tag = 2;</code>
     *
     * @return The requestTag.
     */
    public java.lang.String getRequestTag() {
      java.lang.Object ref = requestTag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestTag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A per-request tag which can be applied to queries or reads, used for
     * statistics collection.
     * Both request_tag and transaction_tag can be specified for a read or query
     * that belongs to a transaction.
     * This field is ignored for requests where it's not applicable (e.g.
     * CommitRequest).
     * Legal characters for `request_tag` values are all printable characters
     * (ASCII 32 - 126) and the length of a request_tag is limited to 50
     * characters. Values that exceed this limit are truncated.
     * Any leading underscore (_) characters will be removed from the string.
     * </pre>
     *
     * <code>string request_tag = 2;</code>
     *
     * @return The bytes for requestTag.
     */
    public com.google.protobuf.ByteString getRequestTagBytes() {
      java.lang.Object ref = requestTag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestTag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A per-request tag which can be applied to queries or reads, used for
     * statistics collection.
     * Both request_tag and transaction_tag can be specified for a read or query
     * that belongs to a transaction.
     * This field is ignored for requests where it's not applicable (e.g.
     * CommitRequest).
     * Legal characters for `request_tag` values are all printable characters
     * (ASCII 32 - 126) and the length of a request_tag is limited to 50
     * characters. Values that exceed this limit are truncated.
     * Any leading underscore (_) characters will be removed from the string.
     * </pre>
     *
     * <code>string request_tag = 2;</code>
     *
     * @param value The requestTag to set.
     * @return This builder for chaining.
     */
    public Builder setRequestTag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      requestTag_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A per-request tag which can be applied to queries or reads, used for
     * statistics collection.
     * Both request_tag and transaction_tag can be specified for a read or query
     * that belongs to a transaction.
     * This field is ignored for requests where it's not applicable (e.g.
     * CommitRequest).
     * Legal characters for `request_tag` values are all printable characters
     * (ASCII 32 - 126) and the length of a request_tag is limited to 50
     * characters. Values that exceed this limit are truncated.
     * Any leading underscore (_) characters will be removed from the string.
     * </pre>
     *
     * <code>string request_tag = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestTag() {

      requestTag_ = getDefaultInstance().getRequestTag();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A per-request tag which can be applied to queries or reads, used for
     * statistics collection.
     * Both request_tag and transaction_tag can be specified for a read or query
     * that belongs to a transaction.
     * This field is ignored for requests where it's not applicable (e.g.
     * CommitRequest).
     * Legal characters for `request_tag` values are all printable characters
     * (ASCII 32 - 126) and the length of a request_tag is limited to 50
     * characters. Values that exceed this limit are truncated.
     * Any leading underscore (_) characters will be removed from the string.
     * </pre>
     *
     * <code>string request_tag = 2;</code>
     *
     * @param value The bytes for requestTag to set.
     * @return This builder for chaining.
     */
    public Builder setRequestTagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      requestTag_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object transactionTag_ = "";
    /**
     *
     *
     * <pre>
     * A tag used for statistics collection about this transaction.
     * Both request_tag and transaction_tag can be specified for a read or query
     * that belongs to a transaction.
     * The value of transaction_tag should be the same for all requests belonging
     * to the same transaction.
     * If this request doesn't belong to any transaction, transaction_tag will be
     * ignored.
     * Legal characters for `transaction_tag` values are all printable characters
     * (ASCII 32 - 126) and the length of a transaction_tag is limited to 50
     * characters. Values that exceed this limit are truncated.
     * Any leading underscore (_) characters will be removed from the string.
     * </pre>
     *
     * <code>string transaction_tag = 3;</code>
     *
     * @return The transactionTag.
     */
    public java.lang.String getTransactionTag() {
      java.lang.Object ref = transactionTag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        transactionTag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A tag used for statistics collection about this transaction.
     * Both request_tag and transaction_tag can be specified for a read or query
     * that belongs to a transaction.
     * The value of transaction_tag should be the same for all requests belonging
     * to the same transaction.
     * If this request doesn't belong to any transaction, transaction_tag will be
     * ignored.
     * Legal characters for `transaction_tag` values are all printable characters
     * (ASCII 32 - 126) and the length of a transaction_tag is limited to 50
     * characters. Values that exceed this limit are truncated.
     * Any leading underscore (_) characters will be removed from the string.
     * </pre>
     *
     * <code>string transaction_tag = 3;</code>
     *
     * @return The bytes for transactionTag.
     */
    public com.google.protobuf.ByteString getTransactionTagBytes() {
      java.lang.Object ref = transactionTag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        transactionTag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A tag used for statistics collection about this transaction.
     * Both request_tag and transaction_tag can be specified for a read or query
     * that belongs to a transaction.
     * The value of transaction_tag should be the same for all requests belonging
     * to the same transaction.
     * If this request doesn't belong to any transaction, transaction_tag will be
     * ignored.
     * Legal characters for `transaction_tag` values are all printable characters
     * (ASCII 32 - 126) and the length of a transaction_tag is limited to 50
     * characters. Values that exceed this limit are truncated.
     * Any leading underscore (_) characters will be removed from the string.
     * </pre>
     *
     * <code>string transaction_tag = 3;</code>
     *
     * @param value The transactionTag to set.
     * @return This builder for chaining.
     */
    public Builder setTransactionTag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      transactionTag_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A tag used for statistics collection about this transaction.
     * Both request_tag and transaction_tag can be specified for a read or query
     * that belongs to a transaction.
     * The value of transaction_tag should be the same for all requests belonging
     * to the same transaction.
     * If this request doesn't belong to any transaction, transaction_tag will be
     * ignored.
     * Legal characters for `transaction_tag` values are all printable characters
     * (ASCII 32 - 126) and the length of a transaction_tag is limited to 50
     * characters. Values that exceed this limit are truncated.
     * Any leading underscore (_) characters will be removed from the string.
     * </pre>
     *
     * <code>string transaction_tag = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTransactionTag() {

      transactionTag_ = getDefaultInstance().getTransactionTag();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A tag used for statistics collection about this transaction.
     * Both request_tag and transaction_tag can be specified for a read or query
     * that belongs to a transaction.
     * The value of transaction_tag should be the same for all requests belonging
     * to the same transaction.
     * If this request doesn't belong to any transaction, transaction_tag will be
     * ignored.
     * Legal characters for `transaction_tag` values are all printable characters
     * (ASCII 32 - 126) and the length of a transaction_tag is limited to 50
     * characters. Values that exceed this limit are truncated.
     * Any leading underscore (_) characters will be removed from the string.
     * </pre>
     *
     * <code>string transaction_tag = 3;</code>
     *
     * @param value The bytes for transactionTag to set.
     * @return This builder for chaining.
     */
    public Builder setTransactionTagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      transactionTag_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.v1.RequestOptions)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.v1.RequestOptions)
  private static final com.google.spanner.v1.RequestOptions DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.v1.RequestOptions();
  }

  public static com.google.spanner.v1.RequestOptions getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RequestOptions> PARSER =
      new com.google.protobuf.AbstractParser<RequestOptions>() {
        @java.lang.Override
        public RequestOptions parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RequestOptions> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RequestOptions> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.v1.RequestOptions getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
