/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/v1/spanner.proto

package com.google.spanner.v1;

/**
 *
 *
 * <pre>
 * The request for [Read][google.spanner.v1.Spanner.Read] and
 * [StreamingRead][google.spanner.v1.Spanner.StreamingRead].
 * </pre>
 *
 * Protobuf type {@code google.spanner.v1.ReadRequest}
 */
public final class ReadRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.v1.ReadRequest)
    ReadRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ReadRequest.newBuilder() to construct.
  private ReadRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReadRequest() {
    session_ = "";
    table_ = "";
    index_ = "";
    columns_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    resumeToken_ = com.google.protobuf.ByteString.EMPTY;
    partitionToken_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReadRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.v1.SpannerProto
        .internal_static_google_spanner_v1_ReadRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.v1.SpannerProto
        .internal_static_google_spanner_v1_ReadRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.v1.ReadRequest.class,
            com.google.spanner.v1.ReadRequest.Builder.class);
  }

  public static final int SESSION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object session_ = "";
  /**
   *
   *
   * <pre>
   * Required. The session in which the read should be performed.
   * </pre>
   *
   * <code>
   * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The session.
   */
  @java.lang.Override
  public java.lang.String getSession() {
    java.lang.Object ref = session_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      session_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The session in which the read should be performed.
   * </pre>
   *
   * <code>
   * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for session.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSessionBytes() {
    java.lang.Object ref = session_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      session_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRANSACTION_FIELD_NUMBER = 2;
  private com.google.spanner.v1.TransactionSelector transaction_;
  /**
   *
   *
   * <pre>
   * The transaction to use. If none is provided, the default is a
   * temporary read-only transaction with strong concurrency.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
   *
   * @return Whether the transaction field is set.
   */
  @java.lang.Override
  public boolean hasTransaction() {
    return transaction_ != null;
  }
  /**
   *
   *
   * <pre>
   * The transaction to use. If none is provided, the default is a
   * temporary read-only transaction with strong concurrency.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
   *
   * @return The transaction.
   */
  @java.lang.Override
  public com.google.spanner.v1.TransactionSelector getTransaction() {
    return transaction_ == null
        ? com.google.spanner.v1.TransactionSelector.getDefaultInstance()
        : transaction_;
  }
  /**
   *
   *
   * <pre>
   * The transaction to use. If none is provided, the default is a
   * temporary read-only transaction with strong concurrency.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.TransactionSelectorOrBuilder getTransactionOrBuilder() {
    return transaction_ == null
        ? com.google.spanner.v1.TransactionSelector.getDefaultInstance()
        : transaction_;
  }

  public static final int TABLE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object table_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the table in the database to be read.
   * </pre>
   *
   * <code>string table = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The table.
   */
  @java.lang.Override
  public java.lang.String getTable() {
    java.lang.Object ref = table_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      table_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the table in the database to be read.
   * </pre>
   *
   * <code>string table = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for table.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTableBytes() {
    java.lang.Object ref = table_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      table_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INDEX_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object index_ = "";
  /**
   *
   *
   * <pre>
   * If non-empty, the name of an index on [table][google.spanner.v1.ReadRequest.table]. This index is
   * used instead of the table primary key when interpreting [key_set][google.spanner.v1.ReadRequest.key_set]
   * and sorting result rows. See [key_set][google.spanner.v1.ReadRequest.key_set] for further information.
   * </pre>
   *
   * <code>string index = 4;</code>
   *
   * @return The index.
   */
  @java.lang.Override
  public java.lang.String getIndex() {
    java.lang.Object ref = index_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      index_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If non-empty, the name of an index on [table][google.spanner.v1.ReadRequest.table]. This index is
   * used instead of the table primary key when interpreting [key_set][google.spanner.v1.ReadRequest.key_set]
   * and sorting result rows. See [key_set][google.spanner.v1.ReadRequest.key_set] for further information.
   * </pre>
   *
   * <code>string index = 4;</code>
   *
   * @return The bytes for index.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIndexBytes() {
    java.lang.Object ref = index_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      index_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COLUMNS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringList columns_;
  /**
   *
   *
   * <pre>
   * Required. The columns of [table][google.spanner.v1.ReadRequest.table] to be returned for each row matching
   * this request.
   * </pre>
   *
   * <code>repeated string columns = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return A list containing the columns.
   */
  public com.google.protobuf.ProtocolStringList getColumnsList() {
    return columns_;
  }
  /**
   *
   *
   * <pre>
   * Required. The columns of [table][google.spanner.v1.ReadRequest.table] to be returned for each row matching
   * this request.
   * </pre>
   *
   * <code>repeated string columns = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The count of columns.
   */
  public int getColumnsCount() {
    return columns_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The columns of [table][google.spanner.v1.ReadRequest.table] to be returned for each row matching
   * this request.
   * </pre>
   *
   * <code>repeated string columns = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the element to return.
   * @return The columns at the given index.
   */
  public java.lang.String getColumns(int index) {
    return columns_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. The columns of [table][google.spanner.v1.ReadRequest.table] to be returned for each row matching
   * this request.
   * </pre>
   *
   * <code>repeated string columns = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the columns at the given index.
   */
  public com.google.protobuf.ByteString getColumnsBytes(int index) {
    return columns_.getByteString(index);
  }

  public static final int KEY_SET_FIELD_NUMBER = 6;
  private com.google.spanner.v1.KeySet keySet_;
  /**
   *
   *
   * <pre>
   * Required. `key_set` identifies the rows to be yielded. `key_set` names the
   * primary keys of the rows in [table][google.spanner.v1.ReadRequest.table] to be yielded, unless [index][google.spanner.v1.ReadRequest.index]
   * is present. If [index][google.spanner.v1.ReadRequest.index] is present, then [key_set][google.spanner.v1.ReadRequest.key_set] instead names
   * index keys in [index][google.spanner.v1.ReadRequest.index].
   * If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is empty, rows are yielded
   * in table primary key order (if [index][google.spanner.v1.ReadRequest.index] is empty) or index key order
   * (if [index][google.spanner.v1.ReadRequest.index] is non-empty).  If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is not
   * empty, rows will be yielded in an unspecified order.
   * It is not an error for the `key_set` to name rows that do not
   * exist in the database. Read yields nothing for nonexistent rows.
   * </pre>
   *
   * <code>.google.spanner.v1.KeySet key_set = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return Whether the keySet field is set.
   */
  @java.lang.Override
  public boolean hasKeySet() {
    return keySet_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. `key_set` identifies the rows to be yielded. `key_set` names the
   * primary keys of the rows in [table][google.spanner.v1.ReadRequest.table] to be yielded, unless [index][google.spanner.v1.ReadRequest.index]
   * is present. If [index][google.spanner.v1.ReadRequest.index] is present, then [key_set][google.spanner.v1.ReadRequest.key_set] instead names
   * index keys in [index][google.spanner.v1.ReadRequest.index].
   * If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is empty, rows are yielded
   * in table primary key order (if [index][google.spanner.v1.ReadRequest.index] is empty) or index key order
   * (if [index][google.spanner.v1.ReadRequest.index] is non-empty).  If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is not
   * empty, rows will be yielded in an unspecified order.
   * It is not an error for the `key_set` to name rows that do not
   * exist in the database. Read yields nothing for nonexistent rows.
   * </pre>
   *
   * <code>.google.spanner.v1.KeySet key_set = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The keySet.
   */
  @java.lang.Override
  public com.google.spanner.v1.KeySet getKeySet() {
    return keySet_ == null ? com.google.spanner.v1.KeySet.getDefaultInstance() : keySet_;
  }
  /**
   *
   *
   * <pre>
   * Required. `key_set` identifies the rows to be yielded. `key_set` names the
   * primary keys of the rows in [table][google.spanner.v1.ReadRequest.table] to be yielded, unless [index][google.spanner.v1.ReadRequest.index]
   * is present. If [index][google.spanner.v1.ReadRequest.index] is present, then [key_set][google.spanner.v1.ReadRequest.key_set] instead names
   * index keys in [index][google.spanner.v1.ReadRequest.index].
   * If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is empty, rows are yielded
   * in table primary key order (if [index][google.spanner.v1.ReadRequest.index] is empty) or index key order
   * (if [index][google.spanner.v1.ReadRequest.index] is non-empty).  If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is not
   * empty, rows will be yielded in an unspecified order.
   * It is not an error for the `key_set` to name rows that do not
   * exist in the database. Read yields nothing for nonexistent rows.
   * </pre>
   *
   * <code>.google.spanner.v1.KeySet key_set = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.KeySetOrBuilder getKeySetOrBuilder() {
    return keySet_ == null ? com.google.spanner.v1.KeySet.getDefaultInstance() : keySet_;
  }

  public static final int LIMIT_FIELD_NUMBER = 8;
  private long limit_ = 0L;
  /**
   *
   *
   * <pre>
   * If greater than zero, only the first `limit` rows are yielded. If `limit`
   * is zero, the default is no limit. A limit cannot be specified if
   * `partition_token` is set.
   * </pre>
   *
   * <code>int64 limit = 8;</code>
   *
   * @return The limit.
   */
  @java.lang.Override
  public long getLimit() {
    return limit_;
  }

  public static final int RESUME_TOKEN_FIELD_NUMBER = 9;
  private com.google.protobuf.ByteString resumeToken_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * If this request is resuming a previously interrupted read,
   * `resume_token` should be copied from the last
   * [PartialResultSet][google.spanner.v1.PartialResultSet] yielded before the interruption. Doing this
   * enables the new read to resume where the last read left off. The
   * rest of the request parameters must exactly match the request
   * that yielded this token.
   * </pre>
   *
   * <code>bytes resume_token = 9;</code>
   *
   * @return The resumeToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResumeToken() {
    return resumeToken_;
  }

  public static final int PARTITION_TOKEN_FIELD_NUMBER = 10;
  private com.google.protobuf.ByteString partitionToken_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * If present, results will be restricted to the specified partition
   * previously created using PartitionRead().    There must be an exact
   * match for the values of fields common to this message and the
   * PartitionReadRequest message used to create this partition_token.
   * </pre>
   *
   * <code>bytes partition_token = 10;</code>
   *
   * @return The partitionToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPartitionToken() {
    return partitionToken_;
  }

  public static final int REQUEST_OPTIONS_FIELD_NUMBER = 11;
  private com.google.spanner.v1.RequestOptions requestOptions_;
  /**
   *
   *
   * <pre>
   * Common options for this request.
   * </pre>
   *
   * <code>.google.spanner.v1.RequestOptions request_options = 11;</code>
   *
   * @return Whether the requestOptions field is set.
   */
  @java.lang.Override
  public boolean hasRequestOptions() {
    return requestOptions_ != null;
  }
  /**
   *
   *
   * <pre>
   * Common options for this request.
   * </pre>
   *
   * <code>.google.spanner.v1.RequestOptions request_options = 11;</code>
   *
   * @return The requestOptions.
   */
  @java.lang.Override
  public com.google.spanner.v1.RequestOptions getRequestOptions() {
    return requestOptions_ == null
        ? com.google.spanner.v1.RequestOptions.getDefaultInstance()
        : requestOptions_;
  }
  /**
   *
   *
   * <pre>
   * Common options for this request.
   * </pre>
   *
   * <code>.google.spanner.v1.RequestOptions request_options = 11;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.RequestOptionsOrBuilder getRequestOptionsOrBuilder() {
    return requestOptions_ == null
        ? com.google.spanner.v1.RequestOptions.getDefaultInstance()
        : requestOptions_;
  }

  public static final int DATA_BOOST_ENABLED_FIELD_NUMBER = 16;
  private boolean dataBoostEnabled_ = false;
  /**
   *
   *
   * <pre>
   * If this is for a partitioned query and this field is set to `true`, the
   * request will be executed via Spanner independent compute resources.
   * If the field is set to `true` but the request does not set
   * `partition_token`, the API will return an `INVALID_ARGUMENT` error.
   * </pre>
   *
   * <code>bool data_boost_enabled = 16;</code>
   *
   * @return The dataBoostEnabled.
   */
  @java.lang.Override
  public boolean getDataBoostEnabled() {
    return dataBoostEnabled_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(session_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, session_);
    }
    if (transaction_ != null) {
      output.writeMessage(2, getTransaction());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(table_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, table_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(index_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, index_);
    }
    for (int i = 0; i < columns_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, columns_.getRaw(i));
    }
    if (keySet_ != null) {
      output.writeMessage(6, getKeySet());
    }
    if (limit_ != 0L) {
      output.writeInt64(8, limit_);
    }
    if (!resumeToken_.isEmpty()) {
      output.writeBytes(9, resumeToken_);
    }
    if (!partitionToken_.isEmpty()) {
      output.writeBytes(10, partitionToken_);
    }
    if (requestOptions_ != null) {
      output.writeMessage(11, getRequestOptions());
    }
    if (dataBoostEnabled_ != false) {
      output.writeBool(16, dataBoostEnabled_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(session_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, session_);
    }
    if (transaction_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getTransaction());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(table_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, table_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(index_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, index_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < columns_.size(); i++) {
        dataSize += computeStringSizeNoTag(columns_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getColumnsList().size();
    }
    if (keySet_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getKeySet());
    }
    if (limit_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(8, limit_);
    }
    if (!resumeToken_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(9, resumeToken_);
    }
    if (!partitionToken_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(10, partitionToken_);
    }
    if (requestOptions_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getRequestOptions());
    }
    if (dataBoostEnabled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(16, dataBoostEnabled_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.v1.ReadRequest)) {
      return super.equals(obj);
    }
    com.google.spanner.v1.ReadRequest other = (com.google.spanner.v1.ReadRequest) obj;

    if (!getSession().equals(other.getSession())) return false;
    if (hasTransaction() != other.hasTransaction()) return false;
    if (hasTransaction()) {
      if (!getTransaction().equals(other.getTransaction())) return false;
    }
    if (!getTable().equals(other.getTable())) return false;
    if (!getIndex().equals(other.getIndex())) return false;
    if (!getColumnsList().equals(other.getColumnsList())) return false;
    if (hasKeySet() != other.hasKeySet()) return false;
    if (hasKeySet()) {
      if (!getKeySet().equals(other.getKeySet())) return false;
    }
    if (getLimit() != other.getLimit()) return false;
    if (!getResumeToken().equals(other.getResumeToken())) return false;
    if (!getPartitionToken().equals(other.getPartitionToken())) return false;
    if (hasRequestOptions() != other.hasRequestOptions()) return false;
    if (hasRequestOptions()) {
      if (!getRequestOptions().equals(other.getRequestOptions())) return false;
    }
    if (getDataBoostEnabled() != other.getDataBoostEnabled()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SESSION_FIELD_NUMBER;
    hash = (53 * hash) + getSession().hashCode();
    if (hasTransaction()) {
      hash = (37 * hash) + TRANSACTION_FIELD_NUMBER;
      hash = (53 * hash) + getTransaction().hashCode();
    }
    hash = (37 * hash) + TABLE_FIELD_NUMBER;
    hash = (53 * hash) + getTable().hashCode();
    hash = (37 * hash) + INDEX_FIELD_NUMBER;
    hash = (53 * hash) + getIndex().hashCode();
    if (getColumnsCount() > 0) {
      hash = (37 * hash) + COLUMNS_FIELD_NUMBER;
      hash = (53 * hash) + getColumnsList().hashCode();
    }
    if (hasKeySet()) {
      hash = (37 * hash) + KEY_SET_FIELD_NUMBER;
      hash = (53 * hash) + getKeySet().hashCode();
    }
    hash = (37 * hash) + LIMIT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getLimit());
    hash = (37 * hash) + RESUME_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getResumeToken().hashCode();
    hash = (37 * hash) + PARTITION_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPartitionToken().hashCode();
    if (hasRequestOptions()) {
      hash = (37 * hash) + REQUEST_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getRequestOptions().hashCode();
    }
    hash = (37 * hash) + DATA_BOOST_ENABLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDataBoostEnabled());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.v1.ReadRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.ReadRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.ReadRequest parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.ReadRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.ReadRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.ReadRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.ReadRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.ReadRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.ReadRequest parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.ReadRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.ReadRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.ReadRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.v1.ReadRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request for [Read][google.spanner.v1.Spanner.Read] and
   * [StreamingRead][google.spanner.v1.Spanner.StreamingRead].
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.ReadRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.v1.ReadRequest)
      com.google.spanner.v1.ReadRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_ReadRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_ReadRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.ReadRequest.class,
              com.google.spanner.v1.ReadRequest.Builder.class);
    }

    // Construct using com.google.spanner.v1.ReadRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      session_ = "";
      transaction_ = null;
      if (transactionBuilder_ != null) {
        transactionBuilder_.dispose();
        transactionBuilder_ = null;
      }
      table_ = "";
      index_ = "";
      columns_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000010);
      keySet_ = null;
      if (keySetBuilder_ != null) {
        keySetBuilder_.dispose();
        keySetBuilder_ = null;
      }
      limit_ = 0L;
      resumeToken_ = com.google.protobuf.ByteString.EMPTY;
      partitionToken_ = com.google.protobuf.ByteString.EMPTY;
      requestOptions_ = null;
      if (requestOptionsBuilder_ != null) {
        requestOptionsBuilder_.dispose();
        requestOptionsBuilder_ = null;
      }
      dataBoostEnabled_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_ReadRequest_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.v1.ReadRequest getDefaultInstanceForType() {
      return com.google.spanner.v1.ReadRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.v1.ReadRequest build() {
      com.google.spanner.v1.ReadRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.v1.ReadRequest buildPartial() {
      com.google.spanner.v1.ReadRequest result = new com.google.spanner.v1.ReadRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.spanner.v1.ReadRequest result) {
      if (((bitField0_ & 0x00000010) != 0)) {
        columns_ = columns_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000010);
      }
      result.columns_ = columns_;
    }

    private void buildPartial0(com.google.spanner.v1.ReadRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.session_ = session_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.transaction_ =
            transactionBuilder_ == null ? transaction_ : transactionBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.table_ = table_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.index_ = index_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.keySet_ = keySetBuilder_ == null ? keySet_ : keySetBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.limit_ = limit_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.resumeToken_ = resumeToken_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.partitionToken_ = partitionToken_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.requestOptions_ =
            requestOptionsBuilder_ == null ? requestOptions_ : requestOptionsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.dataBoostEnabled_ = dataBoostEnabled_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.v1.ReadRequest) {
        return mergeFrom((com.google.spanner.v1.ReadRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.v1.ReadRequest other) {
      if (other == com.google.spanner.v1.ReadRequest.getDefaultInstance()) return this;
      if (!other.getSession().isEmpty()) {
        session_ = other.session_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasTransaction()) {
        mergeTransaction(other.getTransaction());
      }
      if (!other.getTable().isEmpty()) {
        table_ = other.table_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getIndex().isEmpty()) {
        index_ = other.index_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.columns_.isEmpty()) {
        if (columns_.isEmpty()) {
          columns_ = other.columns_;
          bitField0_ = (bitField0_ & ~0x00000010);
        } else {
          ensureColumnsIsMutable();
          columns_.addAll(other.columns_);
        }
        onChanged();
      }
      if (other.hasKeySet()) {
        mergeKeySet(other.getKeySet());
      }
      if (other.getLimit() != 0L) {
        setLimit(other.getLimit());
      }
      if (other.getResumeToken() != com.google.protobuf.ByteString.EMPTY) {
        setResumeToken(other.getResumeToken());
      }
      if (other.getPartitionToken() != com.google.protobuf.ByteString.EMPTY) {
        setPartitionToken(other.getPartitionToken());
      }
      if (other.hasRequestOptions()) {
        mergeRequestOptions(other.getRequestOptions());
      }
      if (other.getDataBoostEnabled() != false) {
        setDataBoostEnabled(other.getDataBoostEnabled());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                session_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getTransactionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                table_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                index_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureColumnsIsMutable();
                columns_.add(s);
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getKeySetFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 64:
              {
                limit_ = input.readInt64();
                bitField0_ |= 0x00000040;
                break;
              } // case 64
            case 74:
              {
                resumeToken_ = input.readBytes();
                bitField0_ |= 0x00000080;
                break;
              } // case 74
            case 82:
              {
                partitionToken_ = input.readBytes();
                bitField0_ |= 0x00000100;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getRequestOptionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 90
            case 128:
              {
                dataBoostEnabled_ = input.readBool();
                bitField0_ |= 0x00000400;
                break;
              } // case 128
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object session_ = "";
    /**
     *
     *
     * <pre>
     * Required. The session in which the read should be performed.
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The session.
     */
    public java.lang.String getSession() {
      java.lang.Object ref = session_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        session_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The session in which the read should be performed.
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for session.
     */
    public com.google.protobuf.ByteString getSessionBytes() {
      java.lang.Object ref = session_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        session_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The session in which the read should be performed.
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The session to set.
     * @return This builder for chaining.
     */
    public Builder setSession(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      session_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The session in which the read should be performed.
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSession() {
      session_ = getDefaultInstance().getSession();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The session in which the read should be performed.
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for session to set.
     * @return This builder for chaining.
     */
    public Builder setSessionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      session_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.spanner.v1.TransactionSelector transaction_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.TransactionSelector,
            com.google.spanner.v1.TransactionSelector.Builder,
            com.google.spanner.v1.TransactionSelectorOrBuilder>
        transactionBuilder_;
    /**
     *
     *
     * <pre>
     * The transaction to use. If none is provided, the default is a
     * temporary read-only transaction with strong concurrency.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     *
     * @return Whether the transaction field is set.
     */
    public boolean hasTransaction() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The transaction to use. If none is provided, the default is a
     * temporary read-only transaction with strong concurrency.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     *
     * @return The transaction.
     */
    public com.google.spanner.v1.TransactionSelector getTransaction() {
      if (transactionBuilder_ == null) {
        return transaction_ == null
            ? com.google.spanner.v1.TransactionSelector.getDefaultInstance()
            : transaction_;
      } else {
        return transactionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The transaction to use. If none is provided, the default is a
     * temporary read-only transaction with strong concurrency.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     */
    public Builder setTransaction(com.google.spanner.v1.TransactionSelector value) {
      if (transactionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transaction_ = value;
      } else {
        transactionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The transaction to use. If none is provided, the default is a
     * temporary read-only transaction with strong concurrency.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     */
    public Builder setTransaction(
        com.google.spanner.v1.TransactionSelector.Builder builderForValue) {
      if (transactionBuilder_ == null) {
        transaction_ = builderForValue.build();
      } else {
        transactionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The transaction to use. If none is provided, the default is a
     * temporary read-only transaction with strong concurrency.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     */
    public Builder mergeTransaction(com.google.spanner.v1.TransactionSelector value) {
      if (transactionBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && transaction_ != null
            && transaction_ != com.google.spanner.v1.TransactionSelector.getDefaultInstance()) {
          getTransactionBuilder().mergeFrom(value);
        } else {
          transaction_ = value;
        }
      } else {
        transactionBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The transaction to use. If none is provided, the default is a
     * temporary read-only transaction with strong concurrency.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     */
    public Builder clearTransaction() {
      bitField0_ = (bitField0_ & ~0x00000002);
      transaction_ = null;
      if (transactionBuilder_ != null) {
        transactionBuilder_.dispose();
        transactionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The transaction to use. If none is provided, the default is a
     * temporary read-only transaction with strong concurrency.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     */
    public com.google.spanner.v1.TransactionSelector.Builder getTransactionBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getTransactionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The transaction to use. If none is provided, the default is a
     * temporary read-only transaction with strong concurrency.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     */
    public com.google.spanner.v1.TransactionSelectorOrBuilder getTransactionOrBuilder() {
      if (transactionBuilder_ != null) {
        return transactionBuilder_.getMessageOrBuilder();
      } else {
        return transaction_ == null
            ? com.google.spanner.v1.TransactionSelector.getDefaultInstance()
            : transaction_;
      }
    }
    /**
     *
     *
     * <pre>
     * The transaction to use. If none is provided, the default is a
     * temporary read-only transaction with strong concurrency.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.TransactionSelector,
            com.google.spanner.v1.TransactionSelector.Builder,
            com.google.spanner.v1.TransactionSelectorOrBuilder>
        getTransactionFieldBuilder() {
      if (transactionBuilder_ == null) {
        transactionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.TransactionSelector,
                com.google.spanner.v1.TransactionSelector.Builder,
                com.google.spanner.v1.TransactionSelectorOrBuilder>(
                getTransaction(), getParentForChildren(), isClean());
        transaction_ = null;
      }
      return transactionBuilder_;
    }

    private java.lang.Object table_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the table in the database to be read.
     * </pre>
     *
     * <code>string table = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The table.
     */
    public java.lang.String getTable() {
      java.lang.Object ref = table_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        table_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the table in the database to be read.
     * </pre>
     *
     * <code>string table = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for table.
     */
    public com.google.protobuf.ByteString getTableBytes() {
      java.lang.Object ref = table_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        table_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the table in the database to be read.
     * </pre>
     *
     * <code>string table = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The table to set.
     * @return This builder for chaining.
     */
    public Builder setTable(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      table_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the table in the database to be read.
     * </pre>
     *
     * <code>string table = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTable() {
      table_ = getDefaultInstance().getTable();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the table in the database to be read.
     * </pre>
     *
     * <code>string table = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for table to set.
     * @return This builder for chaining.
     */
    public Builder setTableBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      table_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object index_ = "";
    /**
     *
     *
     * <pre>
     * If non-empty, the name of an index on [table][google.spanner.v1.ReadRequest.table]. This index is
     * used instead of the table primary key when interpreting [key_set][google.spanner.v1.ReadRequest.key_set]
     * and sorting result rows. See [key_set][google.spanner.v1.ReadRequest.key_set] for further information.
     * </pre>
     *
     * <code>string index = 4;</code>
     *
     * @return The index.
     */
    public java.lang.String getIndex() {
      java.lang.Object ref = index_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        index_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If non-empty, the name of an index on [table][google.spanner.v1.ReadRequest.table]. This index is
     * used instead of the table primary key when interpreting [key_set][google.spanner.v1.ReadRequest.key_set]
     * and sorting result rows. See [key_set][google.spanner.v1.ReadRequest.key_set] for further information.
     * </pre>
     *
     * <code>string index = 4;</code>
     *
     * @return The bytes for index.
     */
    public com.google.protobuf.ByteString getIndexBytes() {
      java.lang.Object ref = index_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        index_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If non-empty, the name of an index on [table][google.spanner.v1.ReadRequest.table]. This index is
     * used instead of the table primary key when interpreting [key_set][google.spanner.v1.ReadRequest.key_set]
     * and sorting result rows. See [key_set][google.spanner.v1.ReadRequest.key_set] for further information.
     * </pre>
     *
     * <code>string index = 4;</code>
     *
     * @param value The index to set.
     * @return This builder for chaining.
     */
    public Builder setIndex(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      index_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If non-empty, the name of an index on [table][google.spanner.v1.ReadRequest.table]. This index is
     * used instead of the table primary key when interpreting [key_set][google.spanner.v1.ReadRequest.key_set]
     * and sorting result rows. See [key_set][google.spanner.v1.ReadRequest.key_set] for further information.
     * </pre>
     *
     * <code>string index = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIndex() {
      index_ = getDefaultInstance().getIndex();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If non-empty, the name of an index on [table][google.spanner.v1.ReadRequest.table]. This index is
     * used instead of the table primary key when interpreting [key_set][google.spanner.v1.ReadRequest.key_set]
     * and sorting result rows. See [key_set][google.spanner.v1.ReadRequest.key_set] for further information.
     * </pre>
     *
     * <code>string index = 4;</code>
     *
     * @param value The bytes for index to set.
     * @return This builder for chaining.
     */
    public Builder setIndexBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      index_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList columns_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureColumnsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        columns_ = new com.google.protobuf.LazyStringArrayList(columns_);
        bitField0_ |= 0x00000010;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The columns of [table][google.spanner.v1.ReadRequest.table] to be returned for each row matching
     * this request.
     * </pre>
     *
     * <code>repeated string columns = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return A list containing the columns.
     */
    public com.google.protobuf.ProtocolStringList getColumnsList() {
      return columns_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Required. The columns of [table][google.spanner.v1.ReadRequest.table] to be returned for each row matching
     * this request.
     * </pre>
     *
     * <code>repeated string columns = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count of columns.
     */
    public int getColumnsCount() {
      return columns_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. The columns of [table][google.spanner.v1.ReadRequest.table] to be returned for each row matching
     * this request.
     * </pre>
     *
     * <code>repeated string columns = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the element to return.
     * @return The columns at the given index.
     */
    public java.lang.String getColumns(int index) {
      return columns_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The columns of [table][google.spanner.v1.ReadRequest.table] to be returned for each row matching
     * this request.
     * </pre>
     *
     * <code>repeated string columns = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the columns at the given index.
     */
    public com.google.protobuf.ByteString getColumnsBytes(int index) {
      return columns_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The columns of [table][google.spanner.v1.ReadRequest.table] to be returned for each row matching
     * this request.
     * </pre>
     *
     * <code>repeated string columns = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index to set the value at.
     * @param value The columns to set.
     * @return This builder for chaining.
     */
    public Builder setColumns(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureColumnsIsMutable();
      columns_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The columns of [table][google.spanner.v1.ReadRequest.table] to be returned for each row matching
     * this request.
     * </pre>
     *
     * <code>repeated string columns = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The columns to add.
     * @return This builder for chaining.
     */
    public Builder addColumns(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureColumnsIsMutable();
      columns_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The columns of [table][google.spanner.v1.ReadRequest.table] to be returned for each row matching
     * this request.
     * </pre>
     *
     * <code>repeated string columns = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param values The columns to add.
     * @return This builder for chaining.
     */
    public Builder addAllColumns(java.lang.Iterable<java.lang.String> values) {
      ensureColumnsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, columns_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The columns of [table][google.spanner.v1.ReadRequest.table] to be returned for each row matching
     * this request.
     * </pre>
     *
     * <code>repeated string columns = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearColumns() {
      columns_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The columns of [table][google.spanner.v1.ReadRequest.table] to be returned for each row matching
     * this request.
     * </pre>
     *
     * <code>repeated string columns = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes of the columns to add.
     * @return This builder for chaining.
     */
    public Builder addColumnsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureColumnsIsMutable();
      columns_.add(value);
      onChanged();
      return this;
    }

    private com.google.spanner.v1.KeySet keySet_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.KeySet,
            com.google.spanner.v1.KeySet.Builder,
            com.google.spanner.v1.KeySetOrBuilder>
        keySetBuilder_;
    /**
     *
     *
     * <pre>
     * Required. `key_set` identifies the rows to be yielded. `key_set` names the
     * primary keys of the rows in [table][google.spanner.v1.ReadRequest.table] to be yielded, unless [index][google.spanner.v1.ReadRequest.index]
     * is present. If [index][google.spanner.v1.ReadRequest.index] is present, then [key_set][google.spanner.v1.ReadRequest.key_set] instead names
     * index keys in [index][google.spanner.v1.ReadRequest.index].
     * If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is empty, rows are yielded
     * in table primary key order (if [index][google.spanner.v1.ReadRequest.index] is empty) or index key order
     * (if [index][google.spanner.v1.ReadRequest.index] is non-empty).  If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is not
     * empty, rows will be yielded in an unspecified order.
     * It is not an error for the `key_set` to name rows that do not
     * exist in the database. Read yields nothing for nonexistent rows.
     * </pre>
     *
     * <code>.google.spanner.v1.KeySet key_set = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return Whether the keySet field is set.
     */
    public boolean hasKeySet() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. `key_set` identifies the rows to be yielded. `key_set` names the
     * primary keys of the rows in [table][google.spanner.v1.ReadRequest.table] to be yielded, unless [index][google.spanner.v1.ReadRequest.index]
     * is present. If [index][google.spanner.v1.ReadRequest.index] is present, then [key_set][google.spanner.v1.ReadRequest.key_set] instead names
     * index keys in [index][google.spanner.v1.ReadRequest.index].
     * If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is empty, rows are yielded
     * in table primary key order (if [index][google.spanner.v1.ReadRequest.index] is empty) or index key order
     * (if [index][google.spanner.v1.ReadRequest.index] is non-empty).  If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is not
     * empty, rows will be yielded in an unspecified order.
     * It is not an error for the `key_set` to name rows that do not
     * exist in the database. Read yields nothing for nonexistent rows.
     * </pre>
     *
     * <code>.google.spanner.v1.KeySet key_set = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The keySet.
     */
    public com.google.spanner.v1.KeySet getKeySet() {
      if (keySetBuilder_ == null) {
        return keySet_ == null ? com.google.spanner.v1.KeySet.getDefaultInstance() : keySet_;
      } else {
        return keySetBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. `key_set` identifies the rows to be yielded. `key_set` names the
     * primary keys of the rows in [table][google.spanner.v1.ReadRequest.table] to be yielded, unless [index][google.spanner.v1.ReadRequest.index]
     * is present. If [index][google.spanner.v1.ReadRequest.index] is present, then [key_set][google.spanner.v1.ReadRequest.key_set] instead names
     * index keys in [index][google.spanner.v1.ReadRequest.index].
     * If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is empty, rows are yielded
     * in table primary key order (if [index][google.spanner.v1.ReadRequest.index] is empty) or index key order
     * (if [index][google.spanner.v1.ReadRequest.index] is non-empty).  If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is not
     * empty, rows will be yielded in an unspecified order.
     * It is not an error for the `key_set` to name rows that do not
     * exist in the database. Read yields nothing for nonexistent rows.
     * </pre>
     *
     * <code>.google.spanner.v1.KeySet key_set = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setKeySet(com.google.spanner.v1.KeySet value) {
      if (keySetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        keySet_ = value;
      } else {
        keySetBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. `key_set` identifies the rows to be yielded. `key_set` names the
     * primary keys of the rows in [table][google.spanner.v1.ReadRequest.table] to be yielded, unless [index][google.spanner.v1.ReadRequest.index]
     * is present. If [index][google.spanner.v1.ReadRequest.index] is present, then [key_set][google.spanner.v1.ReadRequest.key_set] instead names
     * index keys in [index][google.spanner.v1.ReadRequest.index].
     * If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is empty, rows are yielded
     * in table primary key order (if [index][google.spanner.v1.ReadRequest.index] is empty) or index key order
     * (if [index][google.spanner.v1.ReadRequest.index] is non-empty).  If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is not
     * empty, rows will be yielded in an unspecified order.
     * It is not an error for the `key_set` to name rows that do not
     * exist in the database. Read yields nothing for nonexistent rows.
     * </pre>
     *
     * <code>.google.spanner.v1.KeySet key_set = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setKeySet(com.google.spanner.v1.KeySet.Builder builderForValue) {
      if (keySetBuilder_ == null) {
        keySet_ = builderForValue.build();
      } else {
        keySetBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. `key_set` identifies the rows to be yielded. `key_set` names the
     * primary keys of the rows in [table][google.spanner.v1.ReadRequest.table] to be yielded, unless [index][google.spanner.v1.ReadRequest.index]
     * is present. If [index][google.spanner.v1.ReadRequest.index] is present, then [key_set][google.spanner.v1.ReadRequest.key_set] instead names
     * index keys in [index][google.spanner.v1.ReadRequest.index].
     * If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is empty, rows are yielded
     * in table primary key order (if [index][google.spanner.v1.ReadRequest.index] is empty) or index key order
     * (if [index][google.spanner.v1.ReadRequest.index] is non-empty).  If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is not
     * empty, rows will be yielded in an unspecified order.
     * It is not an error for the `key_set` to name rows that do not
     * exist in the database. Read yields nothing for nonexistent rows.
     * </pre>
     *
     * <code>.google.spanner.v1.KeySet key_set = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder mergeKeySet(com.google.spanner.v1.KeySet value) {
      if (keySetBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && keySet_ != null
            && keySet_ != com.google.spanner.v1.KeySet.getDefaultInstance()) {
          getKeySetBuilder().mergeFrom(value);
        } else {
          keySet_ = value;
        }
      } else {
        keySetBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. `key_set` identifies the rows to be yielded. `key_set` names the
     * primary keys of the rows in [table][google.spanner.v1.ReadRequest.table] to be yielded, unless [index][google.spanner.v1.ReadRequest.index]
     * is present. If [index][google.spanner.v1.ReadRequest.index] is present, then [key_set][google.spanner.v1.ReadRequest.key_set] instead names
     * index keys in [index][google.spanner.v1.ReadRequest.index].
     * If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is empty, rows are yielded
     * in table primary key order (if [index][google.spanner.v1.ReadRequest.index] is empty) or index key order
     * (if [index][google.spanner.v1.ReadRequest.index] is non-empty).  If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is not
     * empty, rows will be yielded in an unspecified order.
     * It is not an error for the `key_set` to name rows that do not
     * exist in the database. Read yields nothing for nonexistent rows.
     * </pre>
     *
     * <code>.google.spanner.v1.KeySet key_set = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder clearKeySet() {
      bitField0_ = (bitField0_ & ~0x00000020);
      keySet_ = null;
      if (keySetBuilder_ != null) {
        keySetBuilder_.dispose();
        keySetBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. `key_set` identifies the rows to be yielded. `key_set` names the
     * primary keys of the rows in [table][google.spanner.v1.ReadRequest.table] to be yielded, unless [index][google.spanner.v1.ReadRequest.index]
     * is present. If [index][google.spanner.v1.ReadRequest.index] is present, then [key_set][google.spanner.v1.ReadRequest.key_set] instead names
     * index keys in [index][google.spanner.v1.ReadRequest.index].
     * If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is empty, rows are yielded
     * in table primary key order (if [index][google.spanner.v1.ReadRequest.index] is empty) or index key order
     * (if [index][google.spanner.v1.ReadRequest.index] is non-empty).  If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is not
     * empty, rows will be yielded in an unspecified order.
     * It is not an error for the `key_set` to name rows that do not
     * exist in the database. Read yields nothing for nonexistent rows.
     * </pre>
     *
     * <code>.google.spanner.v1.KeySet key_set = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public com.google.spanner.v1.KeySet.Builder getKeySetBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getKeySetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. `key_set` identifies the rows to be yielded. `key_set` names the
     * primary keys of the rows in [table][google.spanner.v1.ReadRequest.table] to be yielded, unless [index][google.spanner.v1.ReadRequest.index]
     * is present. If [index][google.spanner.v1.ReadRequest.index] is present, then [key_set][google.spanner.v1.ReadRequest.key_set] instead names
     * index keys in [index][google.spanner.v1.ReadRequest.index].
     * If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is empty, rows are yielded
     * in table primary key order (if [index][google.spanner.v1.ReadRequest.index] is empty) or index key order
     * (if [index][google.spanner.v1.ReadRequest.index] is non-empty).  If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is not
     * empty, rows will be yielded in an unspecified order.
     * It is not an error for the `key_set` to name rows that do not
     * exist in the database. Read yields nothing for nonexistent rows.
     * </pre>
     *
     * <code>.google.spanner.v1.KeySet key_set = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public com.google.spanner.v1.KeySetOrBuilder getKeySetOrBuilder() {
      if (keySetBuilder_ != null) {
        return keySetBuilder_.getMessageOrBuilder();
      } else {
        return keySet_ == null ? com.google.spanner.v1.KeySet.getDefaultInstance() : keySet_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. `key_set` identifies the rows to be yielded. `key_set` names the
     * primary keys of the rows in [table][google.spanner.v1.ReadRequest.table] to be yielded, unless [index][google.spanner.v1.ReadRequest.index]
     * is present. If [index][google.spanner.v1.ReadRequest.index] is present, then [key_set][google.spanner.v1.ReadRequest.key_set] instead names
     * index keys in [index][google.spanner.v1.ReadRequest.index].
     * If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is empty, rows are yielded
     * in table primary key order (if [index][google.spanner.v1.ReadRequest.index] is empty) or index key order
     * (if [index][google.spanner.v1.ReadRequest.index] is non-empty).  If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is not
     * empty, rows will be yielded in an unspecified order.
     * It is not an error for the `key_set` to name rows that do not
     * exist in the database. Read yields nothing for nonexistent rows.
     * </pre>
     *
     * <code>.google.spanner.v1.KeySet key_set = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.KeySet,
            com.google.spanner.v1.KeySet.Builder,
            com.google.spanner.v1.KeySetOrBuilder>
        getKeySetFieldBuilder() {
      if (keySetBuilder_ == null) {
        keySetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.KeySet,
                com.google.spanner.v1.KeySet.Builder,
                com.google.spanner.v1.KeySetOrBuilder>(
                getKeySet(), getParentForChildren(), isClean());
        keySet_ = null;
      }
      return keySetBuilder_;
    }

    private long limit_;
    /**
     *
     *
     * <pre>
     * If greater than zero, only the first `limit` rows are yielded. If `limit`
     * is zero, the default is no limit. A limit cannot be specified if
     * `partition_token` is set.
     * </pre>
     *
     * <code>int64 limit = 8;</code>
     *
     * @return The limit.
     */
    @java.lang.Override
    public long getLimit() {
      return limit_;
    }
    /**
     *
     *
     * <pre>
     * If greater than zero, only the first `limit` rows are yielded. If `limit`
     * is zero, the default is no limit. A limit cannot be specified if
     * `partition_token` is set.
     * </pre>
     *
     * <code>int64 limit = 8;</code>
     *
     * @param value The limit to set.
     * @return This builder for chaining.
     */
    public Builder setLimit(long value) {

      limit_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If greater than zero, only the first `limit` rows are yielded. If `limit`
     * is zero, the default is no limit. A limit cannot be specified if
     * `partition_token` is set.
     * </pre>
     *
     * <code>int64 limit = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLimit() {
      bitField0_ = (bitField0_ & ~0x00000040);
      limit_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString resumeToken_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * If this request is resuming a previously interrupted read,
     * `resume_token` should be copied from the last
     * [PartialResultSet][google.spanner.v1.PartialResultSet] yielded before the interruption. Doing this
     * enables the new read to resume where the last read left off. The
     * rest of the request parameters must exactly match the request
     * that yielded this token.
     * </pre>
     *
     * <code>bytes resume_token = 9;</code>
     *
     * @return The resumeToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getResumeToken() {
      return resumeToken_;
    }
    /**
     *
     *
     * <pre>
     * If this request is resuming a previously interrupted read,
     * `resume_token` should be copied from the last
     * [PartialResultSet][google.spanner.v1.PartialResultSet] yielded before the interruption. Doing this
     * enables the new read to resume where the last read left off. The
     * rest of the request parameters must exactly match the request
     * that yielded this token.
     * </pre>
     *
     * <code>bytes resume_token = 9;</code>
     *
     * @param value The resumeToken to set.
     * @return This builder for chaining.
     */
    public Builder setResumeToken(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      resumeToken_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If this request is resuming a previously interrupted read,
     * `resume_token` should be copied from the last
     * [PartialResultSet][google.spanner.v1.PartialResultSet] yielded before the interruption. Doing this
     * enables the new read to resume where the last read left off. The
     * rest of the request parameters must exactly match the request
     * that yielded this token.
     * </pre>
     *
     * <code>bytes resume_token = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResumeToken() {
      bitField0_ = (bitField0_ & ~0x00000080);
      resumeToken_ = getDefaultInstance().getResumeToken();
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString partitionToken_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * If present, results will be restricted to the specified partition
     * previously created using PartitionRead().    There must be an exact
     * match for the values of fields common to this message and the
     * PartitionReadRequest message used to create this partition_token.
     * </pre>
     *
     * <code>bytes partition_token = 10;</code>
     *
     * @return The partitionToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPartitionToken() {
      return partitionToken_;
    }
    /**
     *
     *
     * <pre>
     * If present, results will be restricted to the specified partition
     * previously created using PartitionRead().    There must be an exact
     * match for the values of fields common to this message and the
     * PartitionReadRequest message used to create this partition_token.
     * </pre>
     *
     * <code>bytes partition_token = 10;</code>
     *
     * @param value The partitionToken to set.
     * @return This builder for chaining.
     */
    public Builder setPartitionToken(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      partitionToken_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, results will be restricted to the specified partition
     * previously created using PartitionRead().    There must be an exact
     * match for the values of fields common to this message and the
     * PartitionReadRequest message used to create this partition_token.
     * </pre>
     *
     * <code>bytes partition_token = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPartitionToken() {
      bitField0_ = (bitField0_ & ~0x00000100);
      partitionToken_ = getDefaultInstance().getPartitionToken();
      onChanged();
      return this;
    }

    private com.google.spanner.v1.RequestOptions requestOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.RequestOptions,
            com.google.spanner.v1.RequestOptions.Builder,
            com.google.spanner.v1.RequestOptionsOrBuilder>
        requestOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 11;</code>
     *
     * @return Whether the requestOptions field is set.
     */
    public boolean hasRequestOptions() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 11;</code>
     *
     * @return The requestOptions.
     */
    public com.google.spanner.v1.RequestOptions getRequestOptions() {
      if (requestOptionsBuilder_ == null) {
        return requestOptions_ == null
            ? com.google.spanner.v1.RequestOptions.getDefaultInstance()
            : requestOptions_;
      } else {
        return requestOptionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 11;</code>
     */
    public Builder setRequestOptions(com.google.spanner.v1.RequestOptions value) {
      if (requestOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        requestOptions_ = value;
      } else {
        requestOptionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 11;</code>
     */
    public Builder setRequestOptions(com.google.spanner.v1.RequestOptions.Builder builderForValue) {
      if (requestOptionsBuilder_ == null) {
        requestOptions_ = builderForValue.build();
      } else {
        requestOptionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 11;</code>
     */
    public Builder mergeRequestOptions(com.google.spanner.v1.RequestOptions value) {
      if (requestOptionsBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && requestOptions_ != null
            && requestOptions_ != com.google.spanner.v1.RequestOptions.getDefaultInstance()) {
          getRequestOptionsBuilder().mergeFrom(value);
        } else {
          requestOptions_ = value;
        }
      } else {
        requestOptionsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 11;</code>
     */
    public Builder clearRequestOptions() {
      bitField0_ = (bitField0_ & ~0x00000200);
      requestOptions_ = null;
      if (requestOptionsBuilder_ != null) {
        requestOptionsBuilder_.dispose();
        requestOptionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 11;</code>
     */
    public com.google.spanner.v1.RequestOptions.Builder getRequestOptionsBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getRequestOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 11;</code>
     */
    public com.google.spanner.v1.RequestOptionsOrBuilder getRequestOptionsOrBuilder() {
      if (requestOptionsBuilder_ != null) {
        return requestOptionsBuilder_.getMessageOrBuilder();
      } else {
        return requestOptions_ == null
            ? com.google.spanner.v1.RequestOptions.getDefaultInstance()
            : requestOptions_;
      }
    }
    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.RequestOptions,
            com.google.spanner.v1.RequestOptions.Builder,
            com.google.spanner.v1.RequestOptionsOrBuilder>
        getRequestOptionsFieldBuilder() {
      if (requestOptionsBuilder_ == null) {
        requestOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.RequestOptions,
                com.google.spanner.v1.RequestOptions.Builder,
                com.google.spanner.v1.RequestOptionsOrBuilder>(
                getRequestOptions(), getParentForChildren(), isClean());
        requestOptions_ = null;
      }
      return requestOptionsBuilder_;
    }

    private boolean dataBoostEnabled_;
    /**
     *
     *
     * <pre>
     * If this is for a partitioned query and this field is set to `true`, the
     * request will be executed via Spanner independent compute resources.
     * If the field is set to `true` but the request does not set
     * `partition_token`, the API will return an `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>bool data_boost_enabled = 16;</code>
     *
     * @return The dataBoostEnabled.
     */
    @java.lang.Override
    public boolean getDataBoostEnabled() {
      return dataBoostEnabled_;
    }
    /**
     *
     *
     * <pre>
     * If this is for a partitioned query and this field is set to `true`, the
     * request will be executed via Spanner independent compute resources.
     * If the field is set to `true` but the request does not set
     * `partition_token`, the API will return an `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>bool data_boost_enabled = 16;</code>
     *
     * @param value The dataBoostEnabled to set.
     * @return This builder for chaining.
     */
    public Builder setDataBoostEnabled(boolean value) {

      dataBoostEnabled_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If this is for a partitioned query and this field is set to `true`, the
     * request will be executed via Spanner independent compute resources.
     * If the field is set to `true` but the request does not set
     * `partition_token`, the API will return an `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>bool data_boost_enabled = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataBoostEnabled() {
      bitField0_ = (bitField0_ & ~0x00000400);
      dataBoostEnabled_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.v1.ReadRequest)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.v1.ReadRequest)
  private static final com.google.spanner.v1.ReadRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.v1.ReadRequest();
  }

  public static com.google.spanner.v1.ReadRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReadRequest> PARSER =
      new com.google.protobuf.AbstractParser<ReadRequest>() {
        @java.lang.Override
        public ReadRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ReadRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReadRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.v1.ReadRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
