/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/v1/spanner.proto

package com.google.spanner.v1;

/**
 *
 *
 * <pre>
 * The request for [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] and
 * [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql].
 * </pre>
 *
 * Protobuf type {@code google.spanner.v1.ExecuteSqlRequest}
 */
public final class ExecuteSqlRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.v1.ExecuteSqlRequest)
    ExecuteSqlRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExecuteSqlRequest.newBuilder() to construct.
  private ExecuteSqlRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExecuteSqlRequest() {
    session_ = "";
    sql_ = "";
    resumeToken_ = com.google.protobuf.ByteString.EMPTY;
    queryMode_ = 0;
    partitionToken_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExecuteSqlRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.v1.SpannerProto
        .internal_static_google_spanner_v1_ExecuteSqlRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 5:
        return internalGetParamTypes();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.v1.SpannerProto
        .internal_static_google_spanner_v1_ExecuteSqlRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.v1.ExecuteSqlRequest.class,
            com.google.spanner.v1.ExecuteSqlRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Mode in which the statement must be processed.
   * </pre>
   *
   * Protobuf enum {@code google.spanner.v1.ExecuteSqlRequest.QueryMode}
   */
  public enum QueryMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The default mode. Only the statement results are returned.
     * </pre>
     *
     * <code>NORMAL = 0;</code>
     */
    NORMAL(0),
    /**
     *
     *
     * <pre>
     * This mode returns only the query plan, without any results or
     * execution statistics information.
     * </pre>
     *
     * <code>PLAN = 1;</code>
     */
    PLAN(1),
    /**
     *
     *
     * <pre>
     * This mode returns both the query plan and the execution statistics along
     * with the results.
     * </pre>
     *
     * <code>PROFILE = 2;</code>
     */
    PROFILE(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The default mode. Only the statement results are returned.
     * </pre>
     *
     * <code>NORMAL = 0;</code>
     */
    public static final int NORMAL_VALUE = 0;
    /**
     *
     *
     * <pre>
     * This mode returns only the query plan, without any results or
     * execution statistics information.
     * </pre>
     *
     * <code>PLAN = 1;</code>
     */
    public static final int PLAN_VALUE = 1;
    /**
     *
     *
     * <pre>
     * This mode returns both the query plan and the execution statistics along
     * with the results.
     * </pre>
     *
     * <code>PROFILE = 2;</code>
     */
    public static final int PROFILE_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static QueryMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static QueryMode forNumber(int value) {
      switch (value) {
        case 0:
          return NORMAL;
        case 1:
          return PLAN;
        case 2:
          return PROFILE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<QueryMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<QueryMode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<QueryMode>() {
          public QueryMode findValueByNumber(int number) {
            return QueryMode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.spanner.v1.ExecuteSqlRequest.getDescriptor().getEnumTypes().get(0);
    }

    private static final QueryMode[] VALUES = values();

    public static QueryMode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private QueryMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.spanner.v1.ExecuteSqlRequest.QueryMode)
  }

  public interface QueryOptionsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.spanner.v1.ExecuteSqlRequest.QueryOptions)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * An option to control the selection of optimizer version.
     *
     * This parameter allows individual queries to pick different query
     * optimizer versions.
     *
     * Specifying `latest` as a value instructs Cloud Spanner to use the
     * latest supported query optimizer version. If not specified, Cloud Spanner
     * uses the optimizer version set at the database level options. Any other
     * positive integer (from the list of supported optimizer versions)
     * overrides the default optimizer version for query execution.
     *
     * The list of supported optimizer versions can be queried from
     * SPANNER_SYS.SUPPORTED_OPTIMIZER_VERSIONS.
     *
     * Executing a SQL statement with an invalid optimizer version fails with
     * an `INVALID_ARGUMENT` error.
     *
     * See
     * https://cloud.google.com/spanner/docs/query-optimizer/manage-query-optimizer
     * for more information on managing the query optimizer.
     *
     * The `optimizer_version` statement hint has precedence over this setting.
     * </pre>
     *
     * <code>string optimizer_version = 1;</code>
     *
     * @return The optimizerVersion.
     */
    java.lang.String getOptimizerVersion();
    /**
     *
     *
     * <pre>
     * An option to control the selection of optimizer version.
     *
     * This parameter allows individual queries to pick different query
     * optimizer versions.
     *
     * Specifying `latest` as a value instructs Cloud Spanner to use the
     * latest supported query optimizer version. If not specified, Cloud Spanner
     * uses the optimizer version set at the database level options. Any other
     * positive integer (from the list of supported optimizer versions)
     * overrides the default optimizer version for query execution.
     *
     * The list of supported optimizer versions can be queried from
     * SPANNER_SYS.SUPPORTED_OPTIMIZER_VERSIONS.
     *
     * Executing a SQL statement with an invalid optimizer version fails with
     * an `INVALID_ARGUMENT` error.
     *
     * See
     * https://cloud.google.com/spanner/docs/query-optimizer/manage-query-optimizer
     * for more information on managing the query optimizer.
     *
     * The `optimizer_version` statement hint has precedence over this setting.
     * </pre>
     *
     * <code>string optimizer_version = 1;</code>
     *
     * @return The bytes for optimizerVersion.
     */
    com.google.protobuf.ByteString getOptimizerVersionBytes();

    /**
     *
     *
     * <pre>
     * An option to control the selection of optimizer statistics package.
     *
     * This parameter allows individual queries to use a different query
     * optimizer statistics package.
     *
     * Specifying `latest` as a value instructs Cloud Spanner to use the latest
     * generated statistics package. If not specified, Cloud Spanner uses
     * the statistics package set at the database level options, or the latest
     * package if the database option is not set.
     *
     * The statistics package requested by the query has to be exempt from
     * garbage collection. This can be achieved with the following DDL
     * statement:
     *
     * ```
     * ALTER STATISTICS &lt;package_name&gt; SET OPTIONS (allow_gc=false)
     * ```
     *
     * The list of available statistics packages can be queried from
     * `INFORMATION_SCHEMA.SPANNER_STATISTICS`.
     *
     * Executing a SQL statement with an invalid optimizer statistics package
     * or with a statistics package that allows garbage collection fails with
     * an `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>string optimizer_statistics_package = 2;</code>
     *
     * @return The optimizerStatisticsPackage.
     */
    java.lang.String getOptimizerStatisticsPackage();
    /**
     *
     *
     * <pre>
     * An option to control the selection of optimizer statistics package.
     *
     * This parameter allows individual queries to use a different query
     * optimizer statistics package.
     *
     * Specifying `latest` as a value instructs Cloud Spanner to use the latest
     * generated statistics package. If not specified, Cloud Spanner uses
     * the statistics package set at the database level options, or the latest
     * package if the database option is not set.
     *
     * The statistics package requested by the query has to be exempt from
     * garbage collection. This can be achieved with the following DDL
     * statement:
     *
     * ```
     * ALTER STATISTICS &lt;package_name&gt; SET OPTIONS (allow_gc=false)
     * ```
     *
     * The list of available statistics packages can be queried from
     * `INFORMATION_SCHEMA.SPANNER_STATISTICS`.
     *
     * Executing a SQL statement with an invalid optimizer statistics package
     * or with a statistics package that allows garbage collection fails with
     * an `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>string optimizer_statistics_package = 2;</code>
     *
     * @return The bytes for optimizerStatisticsPackage.
     */
    com.google.protobuf.ByteString getOptimizerStatisticsPackageBytes();
  }
  /**
   *
   *
   * <pre>
   * Query optimizer configuration.
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.ExecuteSqlRequest.QueryOptions}
   */
  public static final class QueryOptions extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.spanner.v1.ExecuteSqlRequest.QueryOptions)
      QueryOptionsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use QueryOptions.newBuilder() to construct.
    private QueryOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private QueryOptions() {
      optimizerVersion_ = "";
      optimizerStatisticsPackage_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new QueryOptions();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_ExecuteSqlRequest_QueryOptions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_ExecuteSqlRequest_QueryOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.class,
              com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.Builder.class);
    }

    public static final int OPTIMIZER_VERSION_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object optimizerVersion_ = "";
    /**
     *
     *
     * <pre>
     * An option to control the selection of optimizer version.
     *
     * This parameter allows individual queries to pick different query
     * optimizer versions.
     *
     * Specifying `latest` as a value instructs Cloud Spanner to use the
     * latest supported query optimizer version. If not specified, Cloud Spanner
     * uses the optimizer version set at the database level options. Any other
     * positive integer (from the list of supported optimizer versions)
     * overrides the default optimizer version for query execution.
     *
     * The list of supported optimizer versions can be queried from
     * SPANNER_SYS.SUPPORTED_OPTIMIZER_VERSIONS.
     *
     * Executing a SQL statement with an invalid optimizer version fails with
     * an `INVALID_ARGUMENT` error.
     *
     * See
     * https://cloud.google.com/spanner/docs/query-optimizer/manage-query-optimizer
     * for more information on managing the query optimizer.
     *
     * The `optimizer_version` statement hint has precedence over this setting.
     * </pre>
     *
     * <code>string optimizer_version = 1;</code>
     *
     * @return The optimizerVersion.
     */
    @java.lang.Override
    public java.lang.String getOptimizerVersion() {
      java.lang.Object ref = optimizerVersion_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        optimizerVersion_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * An option to control the selection of optimizer version.
     *
     * This parameter allows individual queries to pick different query
     * optimizer versions.
     *
     * Specifying `latest` as a value instructs Cloud Spanner to use the
     * latest supported query optimizer version. If not specified, Cloud Spanner
     * uses the optimizer version set at the database level options. Any other
     * positive integer (from the list of supported optimizer versions)
     * overrides the default optimizer version for query execution.
     *
     * The list of supported optimizer versions can be queried from
     * SPANNER_SYS.SUPPORTED_OPTIMIZER_VERSIONS.
     *
     * Executing a SQL statement with an invalid optimizer version fails with
     * an `INVALID_ARGUMENT` error.
     *
     * See
     * https://cloud.google.com/spanner/docs/query-optimizer/manage-query-optimizer
     * for more information on managing the query optimizer.
     *
     * The `optimizer_version` statement hint has precedence over this setting.
     * </pre>
     *
     * <code>string optimizer_version = 1;</code>
     *
     * @return The bytes for optimizerVersion.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getOptimizerVersionBytes() {
      java.lang.Object ref = optimizerVersion_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        optimizerVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int OPTIMIZER_STATISTICS_PACKAGE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object optimizerStatisticsPackage_ = "";
    /**
     *
     *
     * <pre>
     * An option to control the selection of optimizer statistics package.
     *
     * This parameter allows individual queries to use a different query
     * optimizer statistics package.
     *
     * Specifying `latest` as a value instructs Cloud Spanner to use the latest
     * generated statistics package. If not specified, Cloud Spanner uses
     * the statistics package set at the database level options, or the latest
     * package if the database option is not set.
     *
     * The statistics package requested by the query has to be exempt from
     * garbage collection. This can be achieved with the following DDL
     * statement:
     *
     * ```
     * ALTER STATISTICS &lt;package_name&gt; SET OPTIONS (allow_gc=false)
     * ```
     *
     * The list of available statistics packages can be queried from
     * `INFORMATION_SCHEMA.SPANNER_STATISTICS`.
     *
     * Executing a SQL statement with an invalid optimizer statistics package
     * or with a statistics package that allows garbage collection fails with
     * an `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>string optimizer_statistics_package = 2;</code>
     *
     * @return The optimizerStatisticsPackage.
     */
    @java.lang.Override
    public java.lang.String getOptimizerStatisticsPackage() {
      java.lang.Object ref = optimizerStatisticsPackage_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        optimizerStatisticsPackage_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * An option to control the selection of optimizer statistics package.
     *
     * This parameter allows individual queries to use a different query
     * optimizer statistics package.
     *
     * Specifying `latest` as a value instructs Cloud Spanner to use the latest
     * generated statistics package. If not specified, Cloud Spanner uses
     * the statistics package set at the database level options, or the latest
     * package if the database option is not set.
     *
     * The statistics package requested by the query has to be exempt from
     * garbage collection. This can be achieved with the following DDL
     * statement:
     *
     * ```
     * ALTER STATISTICS &lt;package_name&gt; SET OPTIONS (allow_gc=false)
     * ```
     *
     * The list of available statistics packages can be queried from
     * `INFORMATION_SCHEMA.SPANNER_STATISTICS`.
     *
     * Executing a SQL statement with an invalid optimizer statistics package
     * or with a statistics package that allows garbage collection fails with
     * an `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>string optimizer_statistics_package = 2;</code>
     *
     * @return The bytes for optimizerStatisticsPackage.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getOptimizerStatisticsPackageBytes() {
      java.lang.Object ref = optimizerStatisticsPackage_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        optimizerStatisticsPackage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(optimizerVersion_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, optimizerVersion_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(optimizerStatisticsPackage_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, optimizerStatisticsPackage_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(optimizerVersion_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, optimizerVersion_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(optimizerStatisticsPackage_)) {
        size +=
            com.google.protobuf.GeneratedMessageV3.computeStringSize(
                2, optimizerStatisticsPackage_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.spanner.v1.ExecuteSqlRequest.QueryOptions)) {
        return super.equals(obj);
      }
      com.google.spanner.v1.ExecuteSqlRequest.QueryOptions other =
          (com.google.spanner.v1.ExecuteSqlRequest.QueryOptions) obj;

      if (!getOptimizerVersion().equals(other.getOptimizerVersion())) return false;
      if (!getOptimizerStatisticsPackage().equals(other.getOptimizerStatisticsPackage()))
        return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + OPTIMIZER_VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getOptimizerVersion().hashCode();
      hash = (37 * hash) + OPTIMIZER_STATISTICS_PACKAGE_FIELD_NUMBER;
      hash = (53 * hash) + getOptimizerStatisticsPackage().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.spanner.v1.ExecuteSqlRequest.QueryOptions parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.ExecuteSqlRequest.QueryOptions parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.ExecuteSqlRequest.QueryOptions parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.ExecuteSqlRequest.QueryOptions parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.ExecuteSqlRequest.QueryOptions parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.ExecuteSqlRequest.QueryOptions parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.ExecuteSqlRequest.QueryOptions parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.ExecuteSqlRequest.QueryOptions parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.ExecuteSqlRequest.QueryOptions parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.ExecuteSqlRequest.QueryOptions parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.ExecuteSqlRequest.QueryOptions parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.ExecuteSqlRequest.QueryOptions parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.spanner.v1.ExecuteSqlRequest.QueryOptions prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Query optimizer configuration.
     * </pre>
     *
     * Protobuf type {@code google.spanner.v1.ExecuteSqlRequest.QueryOptions}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.spanner.v1.ExecuteSqlRequest.QueryOptions)
        com.google.spanner.v1.ExecuteSqlRequest.QueryOptionsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.spanner.v1.SpannerProto
            .internal_static_google_spanner_v1_ExecuteSqlRequest_QueryOptions_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.spanner.v1.SpannerProto
            .internal_static_google_spanner_v1_ExecuteSqlRequest_QueryOptions_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.class,
                com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.Builder.class);
      }

      // Construct using com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        optimizerVersion_ = "";
        optimizerStatisticsPackage_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.spanner.v1.SpannerProto
            .internal_static_google_spanner_v1_ExecuteSqlRequest_QueryOptions_descriptor;
      }

      @java.lang.Override
      public com.google.spanner.v1.ExecuteSqlRequest.QueryOptions getDefaultInstanceForType() {
        return com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.spanner.v1.ExecuteSqlRequest.QueryOptions build() {
        com.google.spanner.v1.ExecuteSqlRequest.QueryOptions result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.spanner.v1.ExecuteSqlRequest.QueryOptions buildPartial() {
        com.google.spanner.v1.ExecuteSqlRequest.QueryOptions result =
            new com.google.spanner.v1.ExecuteSqlRequest.QueryOptions(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.spanner.v1.ExecuteSqlRequest.QueryOptions result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.optimizerVersion_ = optimizerVersion_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.optimizerStatisticsPackage_ = optimizerStatisticsPackage_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.spanner.v1.ExecuteSqlRequest.QueryOptions) {
          return mergeFrom((com.google.spanner.v1.ExecuteSqlRequest.QueryOptions) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.spanner.v1.ExecuteSqlRequest.QueryOptions other) {
        if (other == com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.getDefaultInstance())
          return this;
        if (!other.getOptimizerVersion().isEmpty()) {
          optimizerVersion_ = other.optimizerVersion_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getOptimizerStatisticsPackage().isEmpty()) {
          optimizerStatisticsPackage_ = other.optimizerStatisticsPackage_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  optimizerVersion_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  optimizerStatisticsPackage_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object optimizerVersion_ = "";
      /**
       *
       *
       * <pre>
       * An option to control the selection of optimizer version.
       *
       * This parameter allows individual queries to pick different query
       * optimizer versions.
       *
       * Specifying `latest` as a value instructs Cloud Spanner to use the
       * latest supported query optimizer version. If not specified, Cloud Spanner
       * uses the optimizer version set at the database level options. Any other
       * positive integer (from the list of supported optimizer versions)
       * overrides the default optimizer version for query execution.
       *
       * The list of supported optimizer versions can be queried from
       * SPANNER_SYS.SUPPORTED_OPTIMIZER_VERSIONS.
       *
       * Executing a SQL statement with an invalid optimizer version fails with
       * an `INVALID_ARGUMENT` error.
       *
       * See
       * https://cloud.google.com/spanner/docs/query-optimizer/manage-query-optimizer
       * for more information on managing the query optimizer.
       *
       * The `optimizer_version` statement hint has precedence over this setting.
       * </pre>
       *
       * <code>string optimizer_version = 1;</code>
       *
       * @return The optimizerVersion.
       */
      public java.lang.String getOptimizerVersion() {
        java.lang.Object ref = optimizerVersion_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          optimizerVersion_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * An option to control the selection of optimizer version.
       *
       * This parameter allows individual queries to pick different query
       * optimizer versions.
       *
       * Specifying `latest` as a value instructs Cloud Spanner to use the
       * latest supported query optimizer version. If not specified, Cloud Spanner
       * uses the optimizer version set at the database level options. Any other
       * positive integer (from the list of supported optimizer versions)
       * overrides the default optimizer version for query execution.
       *
       * The list of supported optimizer versions can be queried from
       * SPANNER_SYS.SUPPORTED_OPTIMIZER_VERSIONS.
       *
       * Executing a SQL statement with an invalid optimizer version fails with
       * an `INVALID_ARGUMENT` error.
       *
       * See
       * https://cloud.google.com/spanner/docs/query-optimizer/manage-query-optimizer
       * for more information on managing the query optimizer.
       *
       * The `optimizer_version` statement hint has precedence over this setting.
       * </pre>
       *
       * <code>string optimizer_version = 1;</code>
       *
       * @return The bytes for optimizerVersion.
       */
      public com.google.protobuf.ByteString getOptimizerVersionBytes() {
        java.lang.Object ref = optimizerVersion_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          optimizerVersion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * An option to control the selection of optimizer version.
       *
       * This parameter allows individual queries to pick different query
       * optimizer versions.
       *
       * Specifying `latest` as a value instructs Cloud Spanner to use the
       * latest supported query optimizer version. If not specified, Cloud Spanner
       * uses the optimizer version set at the database level options. Any other
       * positive integer (from the list of supported optimizer versions)
       * overrides the default optimizer version for query execution.
       *
       * The list of supported optimizer versions can be queried from
       * SPANNER_SYS.SUPPORTED_OPTIMIZER_VERSIONS.
       *
       * Executing a SQL statement with an invalid optimizer version fails with
       * an `INVALID_ARGUMENT` error.
       *
       * See
       * https://cloud.google.com/spanner/docs/query-optimizer/manage-query-optimizer
       * for more information on managing the query optimizer.
       *
       * The `optimizer_version` statement hint has precedence over this setting.
       * </pre>
       *
       * <code>string optimizer_version = 1;</code>
       *
       * @param value The optimizerVersion to set.
       * @return This builder for chaining.
       */
      public Builder setOptimizerVersion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        optimizerVersion_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An option to control the selection of optimizer version.
       *
       * This parameter allows individual queries to pick different query
       * optimizer versions.
       *
       * Specifying `latest` as a value instructs Cloud Spanner to use the
       * latest supported query optimizer version. If not specified, Cloud Spanner
       * uses the optimizer version set at the database level options. Any other
       * positive integer (from the list of supported optimizer versions)
       * overrides the default optimizer version for query execution.
       *
       * The list of supported optimizer versions can be queried from
       * SPANNER_SYS.SUPPORTED_OPTIMIZER_VERSIONS.
       *
       * Executing a SQL statement with an invalid optimizer version fails with
       * an `INVALID_ARGUMENT` error.
       *
       * See
       * https://cloud.google.com/spanner/docs/query-optimizer/manage-query-optimizer
       * for more information on managing the query optimizer.
       *
       * The `optimizer_version` statement hint has precedence over this setting.
       * </pre>
       *
       * <code>string optimizer_version = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOptimizerVersion() {
        optimizerVersion_ = getDefaultInstance().getOptimizerVersion();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An option to control the selection of optimizer version.
       *
       * This parameter allows individual queries to pick different query
       * optimizer versions.
       *
       * Specifying `latest` as a value instructs Cloud Spanner to use the
       * latest supported query optimizer version. If not specified, Cloud Spanner
       * uses the optimizer version set at the database level options. Any other
       * positive integer (from the list of supported optimizer versions)
       * overrides the default optimizer version for query execution.
       *
       * The list of supported optimizer versions can be queried from
       * SPANNER_SYS.SUPPORTED_OPTIMIZER_VERSIONS.
       *
       * Executing a SQL statement with an invalid optimizer version fails with
       * an `INVALID_ARGUMENT` error.
       *
       * See
       * https://cloud.google.com/spanner/docs/query-optimizer/manage-query-optimizer
       * for more information on managing the query optimizer.
       *
       * The `optimizer_version` statement hint has precedence over this setting.
       * </pre>
       *
       * <code>string optimizer_version = 1;</code>
       *
       * @param value The bytes for optimizerVersion to set.
       * @return This builder for chaining.
       */
      public Builder setOptimizerVersionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        optimizerVersion_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object optimizerStatisticsPackage_ = "";
      /**
       *
       *
       * <pre>
       * An option to control the selection of optimizer statistics package.
       *
       * This parameter allows individual queries to use a different query
       * optimizer statistics package.
       *
       * Specifying `latest` as a value instructs Cloud Spanner to use the latest
       * generated statistics package. If not specified, Cloud Spanner uses
       * the statistics package set at the database level options, or the latest
       * package if the database option is not set.
       *
       * The statistics package requested by the query has to be exempt from
       * garbage collection. This can be achieved with the following DDL
       * statement:
       *
       * ```
       * ALTER STATISTICS &lt;package_name&gt; SET OPTIONS (allow_gc=false)
       * ```
       *
       * The list of available statistics packages can be queried from
       * `INFORMATION_SCHEMA.SPANNER_STATISTICS`.
       *
       * Executing a SQL statement with an invalid optimizer statistics package
       * or with a statistics package that allows garbage collection fails with
       * an `INVALID_ARGUMENT` error.
       * </pre>
       *
       * <code>string optimizer_statistics_package = 2;</code>
       *
       * @return The optimizerStatisticsPackage.
       */
      public java.lang.String getOptimizerStatisticsPackage() {
        java.lang.Object ref = optimizerStatisticsPackage_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          optimizerStatisticsPackage_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * An option to control the selection of optimizer statistics package.
       *
       * This parameter allows individual queries to use a different query
       * optimizer statistics package.
       *
       * Specifying `latest` as a value instructs Cloud Spanner to use the latest
       * generated statistics package. If not specified, Cloud Spanner uses
       * the statistics package set at the database level options, or the latest
       * package if the database option is not set.
       *
       * The statistics package requested by the query has to be exempt from
       * garbage collection. This can be achieved with the following DDL
       * statement:
       *
       * ```
       * ALTER STATISTICS &lt;package_name&gt; SET OPTIONS (allow_gc=false)
       * ```
       *
       * The list of available statistics packages can be queried from
       * `INFORMATION_SCHEMA.SPANNER_STATISTICS`.
       *
       * Executing a SQL statement with an invalid optimizer statistics package
       * or with a statistics package that allows garbage collection fails with
       * an `INVALID_ARGUMENT` error.
       * </pre>
       *
       * <code>string optimizer_statistics_package = 2;</code>
       *
       * @return The bytes for optimizerStatisticsPackage.
       */
      public com.google.protobuf.ByteString getOptimizerStatisticsPackageBytes() {
        java.lang.Object ref = optimizerStatisticsPackage_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          optimizerStatisticsPackage_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * An option to control the selection of optimizer statistics package.
       *
       * This parameter allows individual queries to use a different query
       * optimizer statistics package.
       *
       * Specifying `latest` as a value instructs Cloud Spanner to use the latest
       * generated statistics package. If not specified, Cloud Spanner uses
       * the statistics package set at the database level options, or the latest
       * package if the database option is not set.
       *
       * The statistics package requested by the query has to be exempt from
       * garbage collection. This can be achieved with the following DDL
       * statement:
       *
       * ```
       * ALTER STATISTICS &lt;package_name&gt; SET OPTIONS (allow_gc=false)
       * ```
       *
       * The list of available statistics packages can be queried from
       * `INFORMATION_SCHEMA.SPANNER_STATISTICS`.
       *
       * Executing a SQL statement with an invalid optimizer statistics package
       * or with a statistics package that allows garbage collection fails with
       * an `INVALID_ARGUMENT` error.
       * </pre>
       *
       * <code>string optimizer_statistics_package = 2;</code>
       *
       * @param value The optimizerStatisticsPackage to set.
       * @return This builder for chaining.
       */
      public Builder setOptimizerStatisticsPackage(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        optimizerStatisticsPackage_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An option to control the selection of optimizer statistics package.
       *
       * This parameter allows individual queries to use a different query
       * optimizer statistics package.
       *
       * Specifying `latest` as a value instructs Cloud Spanner to use the latest
       * generated statistics package. If not specified, Cloud Spanner uses
       * the statistics package set at the database level options, or the latest
       * package if the database option is not set.
       *
       * The statistics package requested by the query has to be exempt from
       * garbage collection. This can be achieved with the following DDL
       * statement:
       *
       * ```
       * ALTER STATISTICS &lt;package_name&gt; SET OPTIONS (allow_gc=false)
       * ```
       *
       * The list of available statistics packages can be queried from
       * `INFORMATION_SCHEMA.SPANNER_STATISTICS`.
       *
       * Executing a SQL statement with an invalid optimizer statistics package
       * or with a statistics package that allows garbage collection fails with
       * an `INVALID_ARGUMENT` error.
       * </pre>
       *
       * <code>string optimizer_statistics_package = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOptimizerStatisticsPackage() {
        optimizerStatisticsPackage_ = getDefaultInstance().getOptimizerStatisticsPackage();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An option to control the selection of optimizer statistics package.
       *
       * This parameter allows individual queries to use a different query
       * optimizer statistics package.
       *
       * Specifying `latest` as a value instructs Cloud Spanner to use the latest
       * generated statistics package. If not specified, Cloud Spanner uses
       * the statistics package set at the database level options, or the latest
       * package if the database option is not set.
       *
       * The statistics package requested by the query has to be exempt from
       * garbage collection. This can be achieved with the following DDL
       * statement:
       *
       * ```
       * ALTER STATISTICS &lt;package_name&gt; SET OPTIONS (allow_gc=false)
       * ```
       *
       * The list of available statistics packages can be queried from
       * `INFORMATION_SCHEMA.SPANNER_STATISTICS`.
       *
       * Executing a SQL statement with an invalid optimizer statistics package
       * or with a statistics package that allows garbage collection fails with
       * an `INVALID_ARGUMENT` error.
       * </pre>
       *
       * <code>string optimizer_statistics_package = 2;</code>
       *
       * @param value The bytes for optimizerStatisticsPackage to set.
       * @return This builder for chaining.
       */
      public Builder setOptimizerStatisticsPackageBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        optimizerStatisticsPackage_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.spanner.v1.ExecuteSqlRequest.QueryOptions)
    }

    // @@protoc_insertion_point(class_scope:google.spanner.v1.ExecuteSqlRequest.QueryOptions)
    private static final com.google.spanner.v1.ExecuteSqlRequest.QueryOptions DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.spanner.v1.ExecuteSqlRequest.QueryOptions();
    }

    public static com.google.spanner.v1.ExecuteSqlRequest.QueryOptions getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<QueryOptions> PARSER =
        new com.google.protobuf.AbstractParser<QueryOptions>() {
          @java.lang.Override
          public QueryOptions parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<QueryOptions> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<QueryOptions> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.spanner.v1.ExecuteSqlRequest.QueryOptions getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int SESSION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object session_ = "";
  /**
   *
   *
   * <pre>
   * Required. The session in which the SQL query should be performed.
   * </pre>
   *
   * <code>
   * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The session.
   */
  @java.lang.Override
  public java.lang.String getSession() {
    java.lang.Object ref = session_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      session_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The session in which the SQL query should be performed.
   * </pre>
   *
   * <code>
   * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for session.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSessionBytes() {
    java.lang.Object ref = session_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      session_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRANSACTION_FIELD_NUMBER = 2;
  private com.google.spanner.v1.TransactionSelector transaction_;
  /**
   *
   *
   * <pre>
   * The transaction to use.
   *
   * For queries, if none is provided, the default is a temporary read-only
   * transaction with strong concurrency.
   *
   * Standard DML statements require a read-write transaction. To protect
   * against replays, single-use transactions are not supported.  The caller
   * must either supply an existing transaction ID or begin a new transaction.
   *
   * Partitioned DML requires an existing Partitioned DML transaction ID.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
   *
   * @return Whether the transaction field is set.
   */
  @java.lang.Override
  public boolean hasTransaction() {
    return transaction_ != null;
  }
  /**
   *
   *
   * <pre>
   * The transaction to use.
   *
   * For queries, if none is provided, the default is a temporary read-only
   * transaction with strong concurrency.
   *
   * Standard DML statements require a read-write transaction. To protect
   * against replays, single-use transactions are not supported.  The caller
   * must either supply an existing transaction ID or begin a new transaction.
   *
   * Partitioned DML requires an existing Partitioned DML transaction ID.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
   *
   * @return The transaction.
   */
  @java.lang.Override
  public com.google.spanner.v1.TransactionSelector getTransaction() {
    return transaction_ == null
        ? com.google.spanner.v1.TransactionSelector.getDefaultInstance()
        : transaction_;
  }
  /**
   *
   *
   * <pre>
   * The transaction to use.
   *
   * For queries, if none is provided, the default is a temporary read-only
   * transaction with strong concurrency.
   *
   * Standard DML statements require a read-write transaction. To protect
   * against replays, single-use transactions are not supported.  The caller
   * must either supply an existing transaction ID or begin a new transaction.
   *
   * Partitioned DML requires an existing Partitioned DML transaction ID.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.TransactionSelectorOrBuilder getTransactionOrBuilder() {
    return transaction_ == null
        ? com.google.spanner.v1.TransactionSelector.getDefaultInstance()
        : transaction_;
  }

  public static final int SQL_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sql_ = "";
  /**
   *
   *
   * <pre>
   * Required. The SQL string.
   * </pre>
   *
   * <code>string sql = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The sql.
   */
  @java.lang.Override
  public java.lang.String getSql() {
    java.lang.Object ref = sql_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sql_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The SQL string.
   * </pre>
   *
   * <code>string sql = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for sql.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSqlBytes() {
    java.lang.Object ref = sql_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sql_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARAMS_FIELD_NUMBER = 4;
  private com.google.protobuf.Struct params_;
  /**
   *
   *
   * <pre>
   * Parameter names and values that bind to placeholders in the SQL string.
   *
   * A parameter placeholder consists of the `&#64;` character followed by the
   * parameter name (for example, `&#64;firstName`). Parameter names must conform
   * to the naming requirements of identifiers as specified at
   * https://cloud.google.com/spanner/docs/lexical#identifiers.
   *
   * Parameters can appear anywhere that a literal value is expected.  The same
   * parameter name can be used more than once, for example:
   *
   * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
   *
   * It is an error to execute a SQL statement with unbound parameters.
   * </pre>
   *
   * <code>.google.protobuf.Struct params = 4;</code>
   *
   * @return Whether the params field is set.
   */
  @java.lang.Override
  public boolean hasParams() {
    return params_ != null;
  }
  /**
   *
   *
   * <pre>
   * Parameter names and values that bind to placeholders in the SQL string.
   *
   * A parameter placeholder consists of the `&#64;` character followed by the
   * parameter name (for example, `&#64;firstName`). Parameter names must conform
   * to the naming requirements of identifiers as specified at
   * https://cloud.google.com/spanner/docs/lexical#identifiers.
   *
   * Parameters can appear anywhere that a literal value is expected.  The same
   * parameter name can be used more than once, for example:
   *
   * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
   *
   * It is an error to execute a SQL statement with unbound parameters.
   * </pre>
   *
   * <code>.google.protobuf.Struct params = 4;</code>
   *
   * @return The params.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getParams() {
    return params_ == null ? com.google.protobuf.Struct.getDefaultInstance() : params_;
  }
  /**
   *
   *
   * <pre>
   * Parameter names and values that bind to placeholders in the SQL string.
   *
   * A parameter placeholder consists of the `&#64;` character followed by the
   * parameter name (for example, `&#64;firstName`). Parameter names must conform
   * to the naming requirements of identifiers as specified at
   * https://cloud.google.com/spanner/docs/lexical#identifiers.
   *
   * Parameters can appear anywhere that a literal value is expected.  The same
   * parameter name can be used more than once, for example:
   *
   * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
   *
   * It is an error to execute a SQL statement with unbound parameters.
   * </pre>
   *
   * <code>.google.protobuf.Struct params = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getParamsOrBuilder() {
    return params_ == null ? com.google.protobuf.Struct.getDefaultInstance() : params_;
  }

  public static final int PARAM_TYPES_FIELD_NUMBER = 5;

  private static final class ParamTypesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, com.google.spanner.v1.Type>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.spanner.v1.Type>newDefaultInstance(
                    com.google.spanner.v1.SpannerProto
                        .internal_static_google_spanner_v1_ExecuteSqlRequest_ParamTypesEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.spanner.v1.Type.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, com.google.spanner.v1.Type> paramTypes_;

  private com.google.protobuf.MapField<java.lang.String, com.google.spanner.v1.Type>
      internalGetParamTypes() {
    if (paramTypes_ == null) {
      return com.google.protobuf.MapField.emptyMapField(ParamTypesDefaultEntryHolder.defaultEntry);
    }
    return paramTypes_;
  }

  public int getParamTypesCount() {
    return internalGetParamTypes().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * It is not always possible for Cloud Spanner to infer the right SQL type
   * from a JSON value.  For example, values of type `BYTES` and values
   * of type `STRING` both appear in [params][google.spanner.v1.ExecuteSqlRequest.params] as JSON strings.
   *
   * In these cases, `param_types` can be used to specify the exact
   * SQL type for some or all of the SQL statement parameters. See the
   * definition of [Type][google.spanner.v1.Type] for more information
   * about SQL types.
   * </pre>
   *
   * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
   */
  @java.lang.Override
  public boolean containsParamTypes(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetParamTypes().getMap().containsKey(key);
  }
  /** Use {@link #getParamTypesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.spanner.v1.Type> getParamTypes() {
    return getParamTypesMap();
  }
  /**
   *
   *
   * <pre>
   * It is not always possible for Cloud Spanner to infer the right SQL type
   * from a JSON value.  For example, values of type `BYTES` and values
   * of type `STRING` both appear in [params][google.spanner.v1.ExecuteSqlRequest.params] as JSON strings.
   *
   * In these cases, `param_types` can be used to specify the exact
   * SQL type for some or all of the SQL statement parameters. See the
   * definition of [Type][google.spanner.v1.Type] for more information
   * about SQL types.
   * </pre>
   *
   * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.spanner.v1.Type> getParamTypesMap() {
    return internalGetParamTypes().getMap();
  }
  /**
   *
   *
   * <pre>
   * It is not always possible for Cloud Spanner to infer the right SQL type
   * from a JSON value.  For example, values of type `BYTES` and values
   * of type `STRING` both appear in [params][google.spanner.v1.ExecuteSqlRequest.params] as JSON strings.
   *
   * In these cases, `param_types` can be used to specify the exact
   * SQL type for some or all of the SQL statement parameters. See the
   * definition of [Type][google.spanner.v1.Type] for more information
   * about SQL types.
   * </pre>
   *
   * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
   */
  @java.lang.Override
  public /* nullable */ com.google.spanner.v1.Type getParamTypesOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.spanner.v1.Type defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.spanner.v1.Type> map =
        internalGetParamTypes().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * It is not always possible for Cloud Spanner to infer the right SQL type
   * from a JSON value.  For example, values of type `BYTES` and values
   * of type `STRING` both appear in [params][google.spanner.v1.ExecuteSqlRequest.params] as JSON strings.
   *
   * In these cases, `param_types` can be used to specify the exact
   * SQL type for some or all of the SQL statement parameters. See the
   * definition of [Type][google.spanner.v1.Type] for more information
   * about SQL types.
   * </pre>
   *
   * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.Type getParamTypesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.spanner.v1.Type> map =
        internalGetParamTypes().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int RESUME_TOKEN_FIELD_NUMBER = 6;
  private com.google.protobuf.ByteString resumeToken_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * If this request is resuming a previously interrupted SQL statement
   * execution, `resume_token` should be copied from the last
   * [PartialResultSet][google.spanner.v1.PartialResultSet] yielded before the interruption. Doing this
   * enables the new SQL statement execution to resume where the last one left
   * off. The rest of the request parameters must exactly match the
   * request that yielded this token.
   * </pre>
   *
   * <code>bytes resume_token = 6;</code>
   *
   * @return The resumeToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResumeToken() {
    return resumeToken_;
  }

  public static final int QUERY_MODE_FIELD_NUMBER = 7;
  private int queryMode_ = 0;
  /**
   *
   *
   * <pre>
   * Used to control the amount of debugging information returned in
   * [ResultSetStats][google.spanner.v1.ResultSetStats]. If [partition_token][google.spanner.v1.ExecuteSqlRequest.partition_token] is set, [query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode] can only
   * be set to [QueryMode.NORMAL][google.spanner.v1.ExecuteSqlRequest.QueryMode.NORMAL].
   * </pre>
   *
   * <code>.google.spanner.v1.ExecuteSqlRequest.QueryMode query_mode = 7;</code>
   *
   * @return The enum numeric value on the wire for queryMode.
   */
  @java.lang.Override
  public int getQueryModeValue() {
    return queryMode_;
  }
  /**
   *
   *
   * <pre>
   * Used to control the amount of debugging information returned in
   * [ResultSetStats][google.spanner.v1.ResultSetStats]. If [partition_token][google.spanner.v1.ExecuteSqlRequest.partition_token] is set, [query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode] can only
   * be set to [QueryMode.NORMAL][google.spanner.v1.ExecuteSqlRequest.QueryMode.NORMAL].
   * </pre>
   *
   * <code>.google.spanner.v1.ExecuteSqlRequest.QueryMode query_mode = 7;</code>
   *
   * @return The queryMode.
   */
  @java.lang.Override
  public com.google.spanner.v1.ExecuteSqlRequest.QueryMode getQueryMode() {
    com.google.spanner.v1.ExecuteSqlRequest.QueryMode result =
        com.google.spanner.v1.ExecuteSqlRequest.QueryMode.forNumber(queryMode_);
    return result == null ? com.google.spanner.v1.ExecuteSqlRequest.QueryMode.UNRECOGNIZED : result;
  }

  public static final int PARTITION_TOKEN_FIELD_NUMBER = 8;
  private com.google.protobuf.ByteString partitionToken_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * If present, results will be restricted to the specified partition
   * previously created using PartitionQuery().  There must be an exact
   * match for the values of fields common to this message and the
   * PartitionQueryRequest message used to create this partition_token.
   * </pre>
   *
   * <code>bytes partition_token = 8;</code>
   *
   * @return The partitionToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPartitionToken() {
    return partitionToken_;
  }

  public static final int SEQNO_FIELD_NUMBER = 9;
  private long seqno_ = 0L;
  /**
   *
   *
   * <pre>
   * A per-transaction sequence number used to identify this request. This field
   * makes each request idempotent such that if the request is received multiple
   * times, at most one will succeed.
   *
   * The sequence number must be monotonically increasing within the
   * transaction. If a request arrives for the first time with an out-of-order
   * sequence number, the transaction may be aborted. Replays of previously
   * handled requests will yield the same response as the first execution.
   *
   * Required for DML statements. Ignored for queries.
   * </pre>
   *
   * <code>int64 seqno = 9;</code>
   *
   * @return The seqno.
   */
  @java.lang.Override
  public long getSeqno() {
    return seqno_;
  }

  public static final int QUERY_OPTIONS_FIELD_NUMBER = 10;
  private com.google.spanner.v1.ExecuteSqlRequest.QueryOptions queryOptions_;
  /**
   *
   *
   * <pre>
   * Query optimizer configuration to use for the given query.
   * </pre>
   *
   * <code>.google.spanner.v1.ExecuteSqlRequest.QueryOptions query_options = 10;</code>
   *
   * @return Whether the queryOptions field is set.
   */
  @java.lang.Override
  public boolean hasQueryOptions() {
    return queryOptions_ != null;
  }
  /**
   *
   *
   * <pre>
   * Query optimizer configuration to use for the given query.
   * </pre>
   *
   * <code>.google.spanner.v1.ExecuteSqlRequest.QueryOptions query_options = 10;</code>
   *
   * @return The queryOptions.
   */
  @java.lang.Override
  public com.google.spanner.v1.ExecuteSqlRequest.QueryOptions getQueryOptions() {
    return queryOptions_ == null
        ? com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.getDefaultInstance()
        : queryOptions_;
  }
  /**
   *
   *
   * <pre>
   * Query optimizer configuration to use for the given query.
   * </pre>
   *
   * <code>.google.spanner.v1.ExecuteSqlRequest.QueryOptions query_options = 10;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.ExecuteSqlRequest.QueryOptionsOrBuilder getQueryOptionsOrBuilder() {
    return queryOptions_ == null
        ? com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.getDefaultInstance()
        : queryOptions_;
  }

  public static final int REQUEST_OPTIONS_FIELD_NUMBER = 11;
  private com.google.spanner.v1.RequestOptions requestOptions_;
  /**
   *
   *
   * <pre>
   * Common options for this request.
   * </pre>
   *
   * <code>.google.spanner.v1.RequestOptions request_options = 11;</code>
   *
   * @return Whether the requestOptions field is set.
   */
  @java.lang.Override
  public boolean hasRequestOptions() {
    return requestOptions_ != null;
  }
  /**
   *
   *
   * <pre>
   * Common options for this request.
   * </pre>
   *
   * <code>.google.spanner.v1.RequestOptions request_options = 11;</code>
   *
   * @return The requestOptions.
   */
  @java.lang.Override
  public com.google.spanner.v1.RequestOptions getRequestOptions() {
    return requestOptions_ == null
        ? com.google.spanner.v1.RequestOptions.getDefaultInstance()
        : requestOptions_;
  }
  /**
   *
   *
   * <pre>
   * Common options for this request.
   * </pre>
   *
   * <code>.google.spanner.v1.RequestOptions request_options = 11;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.RequestOptionsOrBuilder getRequestOptionsOrBuilder() {
    return requestOptions_ == null
        ? com.google.spanner.v1.RequestOptions.getDefaultInstance()
        : requestOptions_;
  }

  public static final int DATA_BOOST_ENABLED_FIELD_NUMBER = 16;
  private boolean dataBoostEnabled_ = false;
  /**
   *
   *
   * <pre>
   * If this is for a partitioned query and this field is set to `true`, the
   * request will be executed via Spanner independent compute resources.
   *
   * If the field is set to `true` but the request does not set
   * `partition_token`, the API will return an `INVALID_ARGUMENT` error.
   * </pre>
   *
   * <code>bool data_boost_enabled = 16;</code>
   *
   * @return The dataBoostEnabled.
   */
  @java.lang.Override
  public boolean getDataBoostEnabled() {
    return dataBoostEnabled_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(session_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, session_);
    }
    if (transaction_ != null) {
      output.writeMessage(2, getTransaction());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sql_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, sql_);
    }
    if (params_ != null) {
      output.writeMessage(4, getParams());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetParamTypes(), ParamTypesDefaultEntryHolder.defaultEntry, 5);
    if (!resumeToken_.isEmpty()) {
      output.writeBytes(6, resumeToken_);
    }
    if (queryMode_ != com.google.spanner.v1.ExecuteSqlRequest.QueryMode.NORMAL.getNumber()) {
      output.writeEnum(7, queryMode_);
    }
    if (!partitionToken_.isEmpty()) {
      output.writeBytes(8, partitionToken_);
    }
    if (seqno_ != 0L) {
      output.writeInt64(9, seqno_);
    }
    if (queryOptions_ != null) {
      output.writeMessage(10, getQueryOptions());
    }
    if (requestOptions_ != null) {
      output.writeMessage(11, getRequestOptions());
    }
    if (dataBoostEnabled_ != false) {
      output.writeBool(16, dataBoostEnabled_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(session_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, session_);
    }
    if (transaction_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getTransaction());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sql_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, sql_);
    }
    if (params_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getParams());
    }
    for (java.util.Map.Entry<java.lang.String, com.google.spanner.v1.Type> entry :
        internalGetParamTypes().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.spanner.v1.Type> paramTypes__ =
          ParamTypesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, paramTypes__);
    }
    if (!resumeToken_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(6, resumeToken_);
    }
    if (queryMode_ != com.google.spanner.v1.ExecuteSqlRequest.QueryMode.NORMAL.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, queryMode_);
    }
    if (!partitionToken_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(8, partitionToken_);
    }
    if (seqno_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(9, seqno_);
    }
    if (queryOptions_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getQueryOptions());
    }
    if (requestOptions_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getRequestOptions());
    }
    if (dataBoostEnabled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(16, dataBoostEnabled_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.v1.ExecuteSqlRequest)) {
      return super.equals(obj);
    }
    com.google.spanner.v1.ExecuteSqlRequest other = (com.google.spanner.v1.ExecuteSqlRequest) obj;

    if (!getSession().equals(other.getSession())) return false;
    if (hasTransaction() != other.hasTransaction()) return false;
    if (hasTransaction()) {
      if (!getTransaction().equals(other.getTransaction())) return false;
    }
    if (!getSql().equals(other.getSql())) return false;
    if (hasParams() != other.hasParams()) return false;
    if (hasParams()) {
      if (!getParams().equals(other.getParams())) return false;
    }
    if (!internalGetParamTypes().equals(other.internalGetParamTypes())) return false;
    if (!getResumeToken().equals(other.getResumeToken())) return false;
    if (queryMode_ != other.queryMode_) return false;
    if (!getPartitionToken().equals(other.getPartitionToken())) return false;
    if (getSeqno() != other.getSeqno()) return false;
    if (hasQueryOptions() != other.hasQueryOptions()) return false;
    if (hasQueryOptions()) {
      if (!getQueryOptions().equals(other.getQueryOptions())) return false;
    }
    if (hasRequestOptions() != other.hasRequestOptions()) return false;
    if (hasRequestOptions()) {
      if (!getRequestOptions().equals(other.getRequestOptions())) return false;
    }
    if (getDataBoostEnabled() != other.getDataBoostEnabled()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SESSION_FIELD_NUMBER;
    hash = (53 * hash) + getSession().hashCode();
    if (hasTransaction()) {
      hash = (37 * hash) + TRANSACTION_FIELD_NUMBER;
      hash = (53 * hash) + getTransaction().hashCode();
    }
    hash = (37 * hash) + SQL_FIELD_NUMBER;
    hash = (53 * hash) + getSql().hashCode();
    if (hasParams()) {
      hash = (37 * hash) + PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getParams().hashCode();
    }
    if (!internalGetParamTypes().getMap().isEmpty()) {
      hash = (37 * hash) + PARAM_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetParamTypes().hashCode();
    }
    hash = (37 * hash) + RESUME_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getResumeToken().hashCode();
    hash = (37 * hash) + QUERY_MODE_FIELD_NUMBER;
    hash = (53 * hash) + queryMode_;
    hash = (37 * hash) + PARTITION_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPartitionToken().hashCode();
    hash = (37 * hash) + SEQNO_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getSeqno());
    if (hasQueryOptions()) {
      hash = (37 * hash) + QUERY_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getQueryOptions().hashCode();
    }
    if (hasRequestOptions()) {
      hash = (37 * hash) + REQUEST_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getRequestOptions().hashCode();
    }
    hash = (37 * hash) + DATA_BOOST_ENABLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDataBoostEnabled());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.v1.ExecuteSqlRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.ExecuteSqlRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.ExecuteSqlRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.ExecuteSqlRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.ExecuteSqlRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.ExecuteSqlRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.ExecuteSqlRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.ExecuteSqlRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.ExecuteSqlRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.ExecuteSqlRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.ExecuteSqlRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.ExecuteSqlRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.v1.ExecuteSqlRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request for [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] and
   * [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql].
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.ExecuteSqlRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.v1.ExecuteSqlRequest)
      com.google.spanner.v1.ExecuteSqlRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_ExecuteSqlRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 5:
          return internalGetParamTypes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 5:
          return internalGetMutableParamTypes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_ExecuteSqlRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.ExecuteSqlRequest.class,
              com.google.spanner.v1.ExecuteSqlRequest.Builder.class);
    }

    // Construct using com.google.spanner.v1.ExecuteSqlRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      session_ = "";
      transaction_ = null;
      if (transactionBuilder_ != null) {
        transactionBuilder_.dispose();
        transactionBuilder_ = null;
      }
      sql_ = "";
      params_ = null;
      if (paramsBuilder_ != null) {
        paramsBuilder_.dispose();
        paramsBuilder_ = null;
      }
      internalGetMutableParamTypes().clear();
      resumeToken_ = com.google.protobuf.ByteString.EMPTY;
      queryMode_ = 0;
      partitionToken_ = com.google.protobuf.ByteString.EMPTY;
      seqno_ = 0L;
      queryOptions_ = null;
      if (queryOptionsBuilder_ != null) {
        queryOptionsBuilder_.dispose();
        queryOptionsBuilder_ = null;
      }
      requestOptions_ = null;
      if (requestOptionsBuilder_ != null) {
        requestOptionsBuilder_.dispose();
        requestOptionsBuilder_ = null;
      }
      dataBoostEnabled_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_ExecuteSqlRequest_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.v1.ExecuteSqlRequest getDefaultInstanceForType() {
      return com.google.spanner.v1.ExecuteSqlRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.v1.ExecuteSqlRequest build() {
      com.google.spanner.v1.ExecuteSqlRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.v1.ExecuteSqlRequest buildPartial() {
      com.google.spanner.v1.ExecuteSqlRequest result =
          new com.google.spanner.v1.ExecuteSqlRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.v1.ExecuteSqlRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.session_ = session_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.transaction_ =
            transactionBuilder_ == null ? transaction_ : transactionBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.sql_ = sql_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.params_ = paramsBuilder_ == null ? params_ : paramsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.paramTypes_ = internalGetParamTypes();
        result.paramTypes_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.resumeToken_ = resumeToken_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.queryMode_ = queryMode_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.partitionToken_ = partitionToken_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.seqno_ = seqno_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.queryOptions_ =
            queryOptionsBuilder_ == null ? queryOptions_ : queryOptionsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.requestOptions_ =
            requestOptionsBuilder_ == null ? requestOptions_ : requestOptionsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.dataBoostEnabled_ = dataBoostEnabled_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.v1.ExecuteSqlRequest) {
        return mergeFrom((com.google.spanner.v1.ExecuteSqlRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.v1.ExecuteSqlRequest other) {
      if (other == com.google.spanner.v1.ExecuteSqlRequest.getDefaultInstance()) return this;
      if (!other.getSession().isEmpty()) {
        session_ = other.session_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasTransaction()) {
        mergeTransaction(other.getTransaction());
      }
      if (!other.getSql().isEmpty()) {
        sql_ = other.sql_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasParams()) {
        mergeParams(other.getParams());
      }
      internalGetMutableParamTypes().mergeFrom(other.internalGetParamTypes());
      bitField0_ |= 0x00000010;
      if (other.getResumeToken() != com.google.protobuf.ByteString.EMPTY) {
        setResumeToken(other.getResumeToken());
      }
      if (other.queryMode_ != 0) {
        setQueryModeValue(other.getQueryModeValue());
      }
      if (other.getPartitionToken() != com.google.protobuf.ByteString.EMPTY) {
        setPartitionToken(other.getPartitionToken());
      }
      if (other.getSeqno() != 0L) {
        setSeqno(other.getSeqno());
      }
      if (other.hasQueryOptions()) {
        mergeQueryOptions(other.getQueryOptions());
      }
      if (other.hasRequestOptions()) {
        mergeRequestOptions(other.getRequestOptions());
      }
      if (other.getDataBoostEnabled() != false) {
        setDataBoostEnabled(other.getDataBoostEnabled());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                session_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getTransactionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                sql_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getParamsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, com.google.spanner.v1.Type>
                    paramTypes__ =
                        input.readMessage(
                            ParamTypesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableParamTypes()
                    .getMutableMap()
                    .put(paramTypes__.getKey(), paramTypes__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                resumeToken_ = input.readBytes();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 56:
              {
                queryMode_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 66:
              {
                partitionToken_ = input.readBytes();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 72:
              {
                seqno_ = input.readInt64();
                bitField0_ |= 0x00000100;
                break;
              } // case 72
            case 82:
              {
                input.readMessage(getQueryOptionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getRequestOptionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 128:
              {
                dataBoostEnabled_ = input.readBool();
                bitField0_ |= 0x00000800;
                break;
              } // case 128
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object session_ = "";
    /**
     *
     *
     * <pre>
     * Required. The session in which the SQL query should be performed.
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The session.
     */
    public java.lang.String getSession() {
      java.lang.Object ref = session_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        session_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The session in which the SQL query should be performed.
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for session.
     */
    public com.google.protobuf.ByteString getSessionBytes() {
      java.lang.Object ref = session_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        session_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The session in which the SQL query should be performed.
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The session to set.
     * @return This builder for chaining.
     */
    public Builder setSession(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      session_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The session in which the SQL query should be performed.
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSession() {
      session_ = getDefaultInstance().getSession();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The session in which the SQL query should be performed.
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for session to set.
     * @return This builder for chaining.
     */
    public Builder setSessionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      session_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.spanner.v1.TransactionSelector transaction_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.TransactionSelector,
            com.google.spanner.v1.TransactionSelector.Builder,
            com.google.spanner.v1.TransactionSelectorOrBuilder>
        transactionBuilder_;
    /**
     *
     *
     * <pre>
     * The transaction to use.
     *
     * For queries, if none is provided, the default is a temporary read-only
     * transaction with strong concurrency.
     *
     * Standard DML statements require a read-write transaction. To protect
     * against replays, single-use transactions are not supported.  The caller
     * must either supply an existing transaction ID or begin a new transaction.
     *
     * Partitioned DML requires an existing Partitioned DML transaction ID.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     *
     * @return Whether the transaction field is set.
     */
    public boolean hasTransaction() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The transaction to use.
     *
     * For queries, if none is provided, the default is a temporary read-only
     * transaction with strong concurrency.
     *
     * Standard DML statements require a read-write transaction. To protect
     * against replays, single-use transactions are not supported.  The caller
     * must either supply an existing transaction ID or begin a new transaction.
     *
     * Partitioned DML requires an existing Partitioned DML transaction ID.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     *
     * @return The transaction.
     */
    public com.google.spanner.v1.TransactionSelector getTransaction() {
      if (transactionBuilder_ == null) {
        return transaction_ == null
            ? com.google.spanner.v1.TransactionSelector.getDefaultInstance()
            : transaction_;
      } else {
        return transactionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The transaction to use.
     *
     * For queries, if none is provided, the default is a temporary read-only
     * transaction with strong concurrency.
     *
     * Standard DML statements require a read-write transaction. To protect
     * against replays, single-use transactions are not supported.  The caller
     * must either supply an existing transaction ID or begin a new transaction.
     *
     * Partitioned DML requires an existing Partitioned DML transaction ID.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     */
    public Builder setTransaction(com.google.spanner.v1.TransactionSelector value) {
      if (transactionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transaction_ = value;
      } else {
        transactionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The transaction to use.
     *
     * For queries, if none is provided, the default is a temporary read-only
     * transaction with strong concurrency.
     *
     * Standard DML statements require a read-write transaction. To protect
     * against replays, single-use transactions are not supported.  The caller
     * must either supply an existing transaction ID or begin a new transaction.
     *
     * Partitioned DML requires an existing Partitioned DML transaction ID.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     */
    public Builder setTransaction(
        com.google.spanner.v1.TransactionSelector.Builder builderForValue) {
      if (transactionBuilder_ == null) {
        transaction_ = builderForValue.build();
      } else {
        transactionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The transaction to use.
     *
     * For queries, if none is provided, the default is a temporary read-only
     * transaction with strong concurrency.
     *
     * Standard DML statements require a read-write transaction. To protect
     * against replays, single-use transactions are not supported.  The caller
     * must either supply an existing transaction ID or begin a new transaction.
     *
     * Partitioned DML requires an existing Partitioned DML transaction ID.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     */
    public Builder mergeTransaction(com.google.spanner.v1.TransactionSelector value) {
      if (transactionBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && transaction_ != null
            && transaction_ != com.google.spanner.v1.TransactionSelector.getDefaultInstance()) {
          getTransactionBuilder().mergeFrom(value);
        } else {
          transaction_ = value;
        }
      } else {
        transactionBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The transaction to use.
     *
     * For queries, if none is provided, the default is a temporary read-only
     * transaction with strong concurrency.
     *
     * Standard DML statements require a read-write transaction. To protect
     * against replays, single-use transactions are not supported.  The caller
     * must either supply an existing transaction ID or begin a new transaction.
     *
     * Partitioned DML requires an existing Partitioned DML transaction ID.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     */
    public Builder clearTransaction() {
      bitField0_ = (bitField0_ & ~0x00000002);
      transaction_ = null;
      if (transactionBuilder_ != null) {
        transactionBuilder_.dispose();
        transactionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The transaction to use.
     *
     * For queries, if none is provided, the default is a temporary read-only
     * transaction with strong concurrency.
     *
     * Standard DML statements require a read-write transaction. To protect
     * against replays, single-use transactions are not supported.  The caller
     * must either supply an existing transaction ID or begin a new transaction.
     *
     * Partitioned DML requires an existing Partitioned DML transaction ID.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     */
    public com.google.spanner.v1.TransactionSelector.Builder getTransactionBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getTransactionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The transaction to use.
     *
     * For queries, if none is provided, the default is a temporary read-only
     * transaction with strong concurrency.
     *
     * Standard DML statements require a read-write transaction. To protect
     * against replays, single-use transactions are not supported.  The caller
     * must either supply an existing transaction ID or begin a new transaction.
     *
     * Partitioned DML requires an existing Partitioned DML transaction ID.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     */
    public com.google.spanner.v1.TransactionSelectorOrBuilder getTransactionOrBuilder() {
      if (transactionBuilder_ != null) {
        return transactionBuilder_.getMessageOrBuilder();
      } else {
        return transaction_ == null
            ? com.google.spanner.v1.TransactionSelector.getDefaultInstance()
            : transaction_;
      }
    }
    /**
     *
     *
     * <pre>
     * The transaction to use.
     *
     * For queries, if none is provided, the default is a temporary read-only
     * transaction with strong concurrency.
     *
     * Standard DML statements require a read-write transaction. To protect
     * against replays, single-use transactions are not supported.  The caller
     * must either supply an existing transaction ID or begin a new transaction.
     *
     * Partitioned DML requires an existing Partitioned DML transaction ID.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.TransactionSelector,
            com.google.spanner.v1.TransactionSelector.Builder,
            com.google.spanner.v1.TransactionSelectorOrBuilder>
        getTransactionFieldBuilder() {
      if (transactionBuilder_ == null) {
        transactionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.TransactionSelector,
                com.google.spanner.v1.TransactionSelector.Builder,
                com.google.spanner.v1.TransactionSelectorOrBuilder>(
                getTransaction(), getParentForChildren(), isClean());
        transaction_ = null;
      }
      return transactionBuilder_;
    }

    private java.lang.Object sql_ = "";
    /**
     *
     *
     * <pre>
     * Required. The SQL string.
     * </pre>
     *
     * <code>string sql = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The sql.
     */
    public java.lang.String getSql() {
      java.lang.Object ref = sql_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sql_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The SQL string.
     * </pre>
     *
     * <code>string sql = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for sql.
     */
    public com.google.protobuf.ByteString getSqlBytes() {
      java.lang.Object ref = sql_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sql_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The SQL string.
     * </pre>
     *
     * <code>string sql = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The sql to set.
     * @return This builder for chaining.
     */
    public Builder setSql(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sql_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The SQL string.
     * </pre>
     *
     * <code>string sql = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSql() {
      sql_ = getDefaultInstance().getSql();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The SQL string.
     * </pre>
     *
     * <code>string sql = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for sql to set.
     * @return This builder for chaining.
     */
    public Builder setSqlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sql_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Struct params_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        paramsBuilder_;
    /**
     *
     *
     * <pre>
     * Parameter names and values that bind to placeholders in the SQL string.
     *
     * A parameter placeholder consists of the `&#64;` character followed by the
     * parameter name (for example, `&#64;firstName`). Parameter names must conform
     * to the naming requirements of identifiers as specified at
     * https://cloud.google.com/spanner/docs/lexical#identifiers.
     *
     * Parameters can appear anywhere that a literal value is expected.  The same
     * parameter name can be used more than once, for example:
     *
     * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
     *
     * It is an error to execute a SQL statement with unbound parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 4;</code>
     *
     * @return Whether the params field is set.
     */
    public boolean hasParams() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Parameter names and values that bind to placeholders in the SQL string.
     *
     * A parameter placeholder consists of the `&#64;` character followed by the
     * parameter name (for example, `&#64;firstName`). Parameter names must conform
     * to the naming requirements of identifiers as specified at
     * https://cloud.google.com/spanner/docs/lexical#identifiers.
     *
     * Parameters can appear anywhere that a literal value is expected.  The same
     * parameter name can be used more than once, for example:
     *
     * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
     *
     * It is an error to execute a SQL statement with unbound parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 4;</code>
     *
     * @return The params.
     */
    public com.google.protobuf.Struct getParams() {
      if (paramsBuilder_ == null) {
        return params_ == null ? com.google.protobuf.Struct.getDefaultInstance() : params_;
      } else {
        return paramsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Parameter names and values that bind to placeholders in the SQL string.
     *
     * A parameter placeholder consists of the `&#64;` character followed by the
     * parameter name (for example, `&#64;firstName`). Parameter names must conform
     * to the naming requirements of identifiers as specified at
     * https://cloud.google.com/spanner/docs/lexical#identifiers.
     *
     * Parameters can appear anywhere that a literal value is expected.  The same
     * parameter name can be used more than once, for example:
     *
     * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
     *
     * It is an error to execute a SQL statement with unbound parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 4;</code>
     */
    public Builder setParams(com.google.protobuf.Struct value) {
      if (paramsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        params_ = value;
      } else {
        paramsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameter names and values that bind to placeholders in the SQL string.
     *
     * A parameter placeholder consists of the `&#64;` character followed by the
     * parameter name (for example, `&#64;firstName`). Parameter names must conform
     * to the naming requirements of identifiers as specified at
     * https://cloud.google.com/spanner/docs/lexical#identifiers.
     *
     * Parameters can appear anywhere that a literal value is expected.  The same
     * parameter name can be used more than once, for example:
     *
     * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
     *
     * It is an error to execute a SQL statement with unbound parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 4;</code>
     */
    public Builder setParams(com.google.protobuf.Struct.Builder builderForValue) {
      if (paramsBuilder_ == null) {
        params_ = builderForValue.build();
      } else {
        paramsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameter names and values that bind to placeholders in the SQL string.
     *
     * A parameter placeholder consists of the `&#64;` character followed by the
     * parameter name (for example, `&#64;firstName`). Parameter names must conform
     * to the naming requirements of identifiers as specified at
     * https://cloud.google.com/spanner/docs/lexical#identifiers.
     *
     * Parameters can appear anywhere that a literal value is expected.  The same
     * parameter name can be used more than once, for example:
     *
     * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
     *
     * It is an error to execute a SQL statement with unbound parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 4;</code>
     */
    public Builder mergeParams(com.google.protobuf.Struct value) {
      if (paramsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && params_ != null
            && params_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getParamsBuilder().mergeFrom(value);
        } else {
          params_ = value;
        }
      } else {
        paramsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameter names and values that bind to placeholders in the SQL string.
     *
     * A parameter placeholder consists of the `&#64;` character followed by the
     * parameter name (for example, `&#64;firstName`). Parameter names must conform
     * to the naming requirements of identifiers as specified at
     * https://cloud.google.com/spanner/docs/lexical#identifiers.
     *
     * Parameters can appear anywhere that a literal value is expected.  The same
     * parameter name can be used more than once, for example:
     *
     * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
     *
     * It is an error to execute a SQL statement with unbound parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 4;</code>
     */
    public Builder clearParams() {
      bitField0_ = (bitField0_ & ~0x00000008);
      params_ = null;
      if (paramsBuilder_ != null) {
        paramsBuilder_.dispose();
        paramsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameter names and values that bind to placeholders in the SQL string.
     *
     * A parameter placeholder consists of the `&#64;` character followed by the
     * parameter name (for example, `&#64;firstName`). Parameter names must conform
     * to the naming requirements of identifiers as specified at
     * https://cloud.google.com/spanner/docs/lexical#identifiers.
     *
     * Parameters can appear anywhere that a literal value is expected.  The same
     * parameter name can be used more than once, for example:
     *
     * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
     *
     * It is an error to execute a SQL statement with unbound parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 4;</code>
     */
    public com.google.protobuf.Struct.Builder getParamsBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getParamsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Parameter names and values that bind to placeholders in the SQL string.
     *
     * A parameter placeholder consists of the `&#64;` character followed by the
     * parameter name (for example, `&#64;firstName`). Parameter names must conform
     * to the naming requirements of identifiers as specified at
     * https://cloud.google.com/spanner/docs/lexical#identifiers.
     *
     * Parameters can appear anywhere that a literal value is expected.  The same
     * parameter name can be used more than once, for example:
     *
     * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
     *
     * It is an error to execute a SQL statement with unbound parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 4;</code>
     */
    public com.google.protobuf.StructOrBuilder getParamsOrBuilder() {
      if (paramsBuilder_ != null) {
        return paramsBuilder_.getMessageOrBuilder();
      } else {
        return params_ == null ? com.google.protobuf.Struct.getDefaultInstance() : params_;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameter names and values that bind to placeholders in the SQL string.
     *
     * A parameter placeholder consists of the `&#64;` character followed by the
     * parameter name (for example, `&#64;firstName`). Parameter names must conform
     * to the naming requirements of identifiers as specified at
     * https://cloud.google.com/spanner/docs/lexical#identifiers.
     *
     * Parameters can appear anywhere that a literal value is expected.  The same
     * parameter name can be used more than once, for example:
     *
     * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
     *
     * It is an error to execute a SQL statement with unbound parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getParamsFieldBuilder() {
      if (paramsBuilder_ == null) {
        paramsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getParams(), getParentForChildren(), isClean());
        params_ = null;
      }
      return paramsBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, com.google.spanner.v1.Type> paramTypes_;

    private com.google.protobuf.MapField<java.lang.String, com.google.spanner.v1.Type>
        internalGetParamTypes() {
      if (paramTypes_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ParamTypesDefaultEntryHolder.defaultEntry);
      }
      return paramTypes_;
    }

    private com.google.protobuf.MapField<java.lang.String, com.google.spanner.v1.Type>
        internalGetMutableParamTypes() {
      if (paramTypes_ == null) {
        paramTypes_ =
            com.google.protobuf.MapField.newMapField(ParamTypesDefaultEntryHolder.defaultEntry);
      }
      if (!paramTypes_.isMutable()) {
        paramTypes_ = paramTypes_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return paramTypes_;
    }

    public int getParamTypesCount() {
      return internalGetParamTypes().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * It is not always possible for Cloud Spanner to infer the right SQL type
     * from a JSON value.  For example, values of type `BYTES` and values
     * of type `STRING` both appear in [params][google.spanner.v1.ExecuteSqlRequest.params] as JSON strings.
     *
     * In these cases, `param_types` can be used to specify the exact
     * SQL type for some or all of the SQL statement parameters. See the
     * definition of [Type][google.spanner.v1.Type] for more information
     * about SQL types.
     * </pre>
     *
     * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
     */
    @java.lang.Override
    public boolean containsParamTypes(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetParamTypes().getMap().containsKey(key);
    }
    /** Use {@link #getParamTypesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.spanner.v1.Type> getParamTypes() {
      return getParamTypesMap();
    }
    /**
     *
     *
     * <pre>
     * It is not always possible for Cloud Spanner to infer the right SQL type
     * from a JSON value.  For example, values of type `BYTES` and values
     * of type `STRING` both appear in [params][google.spanner.v1.ExecuteSqlRequest.params] as JSON strings.
     *
     * In these cases, `param_types` can be used to specify the exact
     * SQL type for some or all of the SQL statement parameters. See the
     * definition of [Type][google.spanner.v1.Type] for more information
     * about SQL types.
     * </pre>
     *
     * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.spanner.v1.Type> getParamTypesMap() {
      return internalGetParamTypes().getMap();
    }
    /**
     *
     *
     * <pre>
     * It is not always possible for Cloud Spanner to infer the right SQL type
     * from a JSON value.  For example, values of type `BYTES` and values
     * of type `STRING` both appear in [params][google.spanner.v1.ExecuteSqlRequest.params] as JSON strings.
     *
     * In these cases, `param_types` can be used to specify the exact
     * SQL type for some or all of the SQL statement parameters. See the
     * definition of [Type][google.spanner.v1.Type] for more information
     * about SQL types.
     * </pre>
     *
     * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
     */
    @java.lang.Override
    public /* nullable */ com.google.spanner.v1.Type getParamTypesOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.spanner.v1.Type defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.spanner.v1.Type> map =
          internalGetParamTypes().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * It is not always possible for Cloud Spanner to infer the right SQL type
     * from a JSON value.  For example, values of type `BYTES` and values
     * of type `STRING` both appear in [params][google.spanner.v1.ExecuteSqlRequest.params] as JSON strings.
     *
     * In these cases, `param_types` can be used to specify the exact
     * SQL type for some or all of the SQL statement parameters. See the
     * definition of [Type][google.spanner.v1.Type] for more information
     * about SQL types.
     * </pre>
     *
     * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
     */
    @java.lang.Override
    public com.google.spanner.v1.Type getParamTypesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.spanner.v1.Type> map =
          internalGetParamTypes().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearParamTypes() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableParamTypes().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * It is not always possible for Cloud Spanner to infer the right SQL type
     * from a JSON value.  For example, values of type `BYTES` and values
     * of type `STRING` both appear in [params][google.spanner.v1.ExecuteSqlRequest.params] as JSON strings.
     *
     * In these cases, `param_types` can be used to specify the exact
     * SQL type for some or all of the SQL statement parameters. See the
     * definition of [Type][google.spanner.v1.Type] for more information
     * about SQL types.
     * </pre>
     *
     * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
     */
    public Builder removeParamTypes(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableParamTypes().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.spanner.v1.Type> getMutableParamTypes() {
      bitField0_ |= 0x00000010;
      return internalGetMutableParamTypes().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * It is not always possible for Cloud Spanner to infer the right SQL type
     * from a JSON value.  For example, values of type `BYTES` and values
     * of type `STRING` both appear in [params][google.spanner.v1.ExecuteSqlRequest.params] as JSON strings.
     *
     * In these cases, `param_types` can be used to specify the exact
     * SQL type for some or all of the SQL statement parameters. See the
     * definition of [Type][google.spanner.v1.Type] for more information
     * about SQL types.
     * </pre>
     *
     * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
     */
    public Builder putParamTypes(java.lang.String key, com.google.spanner.v1.Type value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableParamTypes().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * It is not always possible for Cloud Spanner to infer the right SQL type
     * from a JSON value.  For example, values of type `BYTES` and values
     * of type `STRING` both appear in [params][google.spanner.v1.ExecuteSqlRequest.params] as JSON strings.
     *
     * In these cases, `param_types` can be used to specify the exact
     * SQL type for some or all of the SQL statement parameters. See the
     * definition of [Type][google.spanner.v1.Type] for more information
     * about SQL types.
     * </pre>
     *
     * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
     */
    public Builder putAllParamTypes(
        java.util.Map<java.lang.String, com.google.spanner.v1.Type> values) {
      internalGetMutableParamTypes().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private com.google.protobuf.ByteString resumeToken_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * If this request is resuming a previously interrupted SQL statement
     * execution, `resume_token` should be copied from the last
     * [PartialResultSet][google.spanner.v1.PartialResultSet] yielded before the interruption. Doing this
     * enables the new SQL statement execution to resume where the last one left
     * off. The rest of the request parameters must exactly match the
     * request that yielded this token.
     * </pre>
     *
     * <code>bytes resume_token = 6;</code>
     *
     * @return The resumeToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getResumeToken() {
      return resumeToken_;
    }
    /**
     *
     *
     * <pre>
     * If this request is resuming a previously interrupted SQL statement
     * execution, `resume_token` should be copied from the last
     * [PartialResultSet][google.spanner.v1.PartialResultSet] yielded before the interruption. Doing this
     * enables the new SQL statement execution to resume where the last one left
     * off. The rest of the request parameters must exactly match the
     * request that yielded this token.
     * </pre>
     *
     * <code>bytes resume_token = 6;</code>
     *
     * @param value The resumeToken to set.
     * @return This builder for chaining.
     */
    public Builder setResumeToken(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      resumeToken_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If this request is resuming a previously interrupted SQL statement
     * execution, `resume_token` should be copied from the last
     * [PartialResultSet][google.spanner.v1.PartialResultSet] yielded before the interruption. Doing this
     * enables the new SQL statement execution to resume where the last one left
     * off. The rest of the request parameters must exactly match the
     * request that yielded this token.
     * </pre>
     *
     * <code>bytes resume_token = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResumeToken() {
      bitField0_ = (bitField0_ & ~0x00000020);
      resumeToken_ = getDefaultInstance().getResumeToken();
      onChanged();
      return this;
    }

    private int queryMode_ = 0;
    /**
     *
     *
     * <pre>
     * Used to control the amount of debugging information returned in
     * [ResultSetStats][google.spanner.v1.ResultSetStats]. If [partition_token][google.spanner.v1.ExecuteSqlRequest.partition_token] is set, [query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode] can only
     * be set to [QueryMode.NORMAL][google.spanner.v1.ExecuteSqlRequest.QueryMode.NORMAL].
     * </pre>
     *
     * <code>.google.spanner.v1.ExecuteSqlRequest.QueryMode query_mode = 7;</code>
     *
     * @return The enum numeric value on the wire for queryMode.
     */
    @java.lang.Override
    public int getQueryModeValue() {
      return queryMode_;
    }
    /**
     *
     *
     * <pre>
     * Used to control the amount of debugging information returned in
     * [ResultSetStats][google.spanner.v1.ResultSetStats]. If [partition_token][google.spanner.v1.ExecuteSqlRequest.partition_token] is set, [query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode] can only
     * be set to [QueryMode.NORMAL][google.spanner.v1.ExecuteSqlRequest.QueryMode.NORMAL].
     * </pre>
     *
     * <code>.google.spanner.v1.ExecuteSqlRequest.QueryMode query_mode = 7;</code>
     *
     * @param value The enum numeric value on the wire for queryMode to set.
     * @return This builder for chaining.
     */
    public Builder setQueryModeValue(int value) {
      queryMode_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Used to control the amount of debugging information returned in
     * [ResultSetStats][google.spanner.v1.ResultSetStats]. If [partition_token][google.spanner.v1.ExecuteSqlRequest.partition_token] is set, [query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode] can only
     * be set to [QueryMode.NORMAL][google.spanner.v1.ExecuteSqlRequest.QueryMode.NORMAL].
     * </pre>
     *
     * <code>.google.spanner.v1.ExecuteSqlRequest.QueryMode query_mode = 7;</code>
     *
     * @return The queryMode.
     */
    @java.lang.Override
    public com.google.spanner.v1.ExecuteSqlRequest.QueryMode getQueryMode() {
      com.google.spanner.v1.ExecuteSqlRequest.QueryMode result =
          com.google.spanner.v1.ExecuteSqlRequest.QueryMode.forNumber(queryMode_);
      return result == null
          ? com.google.spanner.v1.ExecuteSqlRequest.QueryMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Used to control the amount of debugging information returned in
     * [ResultSetStats][google.spanner.v1.ResultSetStats]. If [partition_token][google.spanner.v1.ExecuteSqlRequest.partition_token] is set, [query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode] can only
     * be set to [QueryMode.NORMAL][google.spanner.v1.ExecuteSqlRequest.QueryMode.NORMAL].
     * </pre>
     *
     * <code>.google.spanner.v1.ExecuteSqlRequest.QueryMode query_mode = 7;</code>
     *
     * @param value The queryMode to set.
     * @return This builder for chaining.
     */
    public Builder setQueryMode(com.google.spanner.v1.ExecuteSqlRequest.QueryMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      queryMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Used to control the amount of debugging information returned in
     * [ResultSetStats][google.spanner.v1.ResultSetStats]. If [partition_token][google.spanner.v1.ExecuteSqlRequest.partition_token] is set, [query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode] can only
     * be set to [QueryMode.NORMAL][google.spanner.v1.ExecuteSqlRequest.QueryMode.NORMAL].
     * </pre>
     *
     * <code>.google.spanner.v1.ExecuteSqlRequest.QueryMode query_mode = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQueryMode() {
      bitField0_ = (bitField0_ & ~0x00000040);
      queryMode_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString partitionToken_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * If present, results will be restricted to the specified partition
     * previously created using PartitionQuery().  There must be an exact
     * match for the values of fields common to this message and the
     * PartitionQueryRequest message used to create this partition_token.
     * </pre>
     *
     * <code>bytes partition_token = 8;</code>
     *
     * @return The partitionToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPartitionToken() {
      return partitionToken_;
    }
    /**
     *
     *
     * <pre>
     * If present, results will be restricted to the specified partition
     * previously created using PartitionQuery().  There must be an exact
     * match for the values of fields common to this message and the
     * PartitionQueryRequest message used to create this partition_token.
     * </pre>
     *
     * <code>bytes partition_token = 8;</code>
     *
     * @param value The partitionToken to set.
     * @return This builder for chaining.
     */
    public Builder setPartitionToken(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      partitionToken_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, results will be restricted to the specified partition
     * previously created using PartitionQuery().  There must be an exact
     * match for the values of fields common to this message and the
     * PartitionQueryRequest message used to create this partition_token.
     * </pre>
     *
     * <code>bytes partition_token = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPartitionToken() {
      bitField0_ = (bitField0_ & ~0x00000080);
      partitionToken_ = getDefaultInstance().getPartitionToken();
      onChanged();
      return this;
    }

    private long seqno_;
    /**
     *
     *
     * <pre>
     * A per-transaction sequence number used to identify this request. This field
     * makes each request idempotent such that if the request is received multiple
     * times, at most one will succeed.
     *
     * The sequence number must be monotonically increasing within the
     * transaction. If a request arrives for the first time with an out-of-order
     * sequence number, the transaction may be aborted. Replays of previously
     * handled requests will yield the same response as the first execution.
     *
     * Required for DML statements. Ignored for queries.
     * </pre>
     *
     * <code>int64 seqno = 9;</code>
     *
     * @return The seqno.
     */
    @java.lang.Override
    public long getSeqno() {
      return seqno_;
    }
    /**
     *
     *
     * <pre>
     * A per-transaction sequence number used to identify this request. This field
     * makes each request idempotent such that if the request is received multiple
     * times, at most one will succeed.
     *
     * The sequence number must be monotonically increasing within the
     * transaction. If a request arrives for the first time with an out-of-order
     * sequence number, the transaction may be aborted. Replays of previously
     * handled requests will yield the same response as the first execution.
     *
     * Required for DML statements. Ignored for queries.
     * </pre>
     *
     * <code>int64 seqno = 9;</code>
     *
     * @param value The seqno to set.
     * @return This builder for chaining.
     */
    public Builder setSeqno(long value) {

      seqno_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A per-transaction sequence number used to identify this request. This field
     * makes each request idempotent such that if the request is received multiple
     * times, at most one will succeed.
     *
     * The sequence number must be monotonically increasing within the
     * transaction. If a request arrives for the first time with an out-of-order
     * sequence number, the transaction may be aborted. Replays of previously
     * handled requests will yield the same response as the first execution.
     *
     * Required for DML statements. Ignored for queries.
     * </pre>
     *
     * <code>int64 seqno = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSeqno() {
      bitField0_ = (bitField0_ & ~0x00000100);
      seqno_ = 0L;
      onChanged();
      return this;
    }

    private com.google.spanner.v1.ExecuteSqlRequest.QueryOptions queryOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.ExecuteSqlRequest.QueryOptions,
            com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.Builder,
            com.google.spanner.v1.ExecuteSqlRequest.QueryOptionsOrBuilder>
        queryOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * Query optimizer configuration to use for the given query.
     * </pre>
     *
     * <code>.google.spanner.v1.ExecuteSqlRequest.QueryOptions query_options = 10;</code>
     *
     * @return Whether the queryOptions field is set.
     */
    public boolean hasQueryOptions() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Query optimizer configuration to use for the given query.
     * </pre>
     *
     * <code>.google.spanner.v1.ExecuteSqlRequest.QueryOptions query_options = 10;</code>
     *
     * @return The queryOptions.
     */
    public com.google.spanner.v1.ExecuteSqlRequest.QueryOptions getQueryOptions() {
      if (queryOptionsBuilder_ == null) {
        return queryOptions_ == null
            ? com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.getDefaultInstance()
            : queryOptions_;
      } else {
        return queryOptionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Query optimizer configuration to use for the given query.
     * </pre>
     *
     * <code>.google.spanner.v1.ExecuteSqlRequest.QueryOptions query_options = 10;</code>
     */
    public Builder setQueryOptions(com.google.spanner.v1.ExecuteSqlRequest.QueryOptions value) {
      if (queryOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queryOptions_ = value;
      } else {
        queryOptionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query optimizer configuration to use for the given query.
     * </pre>
     *
     * <code>.google.spanner.v1.ExecuteSqlRequest.QueryOptions query_options = 10;</code>
     */
    public Builder setQueryOptions(
        com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.Builder builderForValue) {
      if (queryOptionsBuilder_ == null) {
        queryOptions_ = builderForValue.build();
      } else {
        queryOptionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query optimizer configuration to use for the given query.
     * </pre>
     *
     * <code>.google.spanner.v1.ExecuteSqlRequest.QueryOptions query_options = 10;</code>
     */
    public Builder mergeQueryOptions(com.google.spanner.v1.ExecuteSqlRequest.QueryOptions value) {
      if (queryOptionsBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && queryOptions_ != null
            && queryOptions_
                != com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.getDefaultInstance()) {
          getQueryOptionsBuilder().mergeFrom(value);
        } else {
          queryOptions_ = value;
        }
      } else {
        queryOptionsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query optimizer configuration to use for the given query.
     * </pre>
     *
     * <code>.google.spanner.v1.ExecuteSqlRequest.QueryOptions query_options = 10;</code>
     */
    public Builder clearQueryOptions() {
      bitField0_ = (bitField0_ & ~0x00000200);
      queryOptions_ = null;
      if (queryOptionsBuilder_ != null) {
        queryOptionsBuilder_.dispose();
        queryOptionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query optimizer configuration to use for the given query.
     * </pre>
     *
     * <code>.google.spanner.v1.ExecuteSqlRequest.QueryOptions query_options = 10;</code>
     */
    public com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.Builder getQueryOptionsBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getQueryOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Query optimizer configuration to use for the given query.
     * </pre>
     *
     * <code>.google.spanner.v1.ExecuteSqlRequest.QueryOptions query_options = 10;</code>
     */
    public com.google.spanner.v1.ExecuteSqlRequest.QueryOptionsOrBuilder
        getQueryOptionsOrBuilder() {
      if (queryOptionsBuilder_ != null) {
        return queryOptionsBuilder_.getMessageOrBuilder();
      } else {
        return queryOptions_ == null
            ? com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.getDefaultInstance()
            : queryOptions_;
      }
    }
    /**
     *
     *
     * <pre>
     * Query optimizer configuration to use for the given query.
     * </pre>
     *
     * <code>.google.spanner.v1.ExecuteSqlRequest.QueryOptions query_options = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.ExecuteSqlRequest.QueryOptions,
            com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.Builder,
            com.google.spanner.v1.ExecuteSqlRequest.QueryOptionsOrBuilder>
        getQueryOptionsFieldBuilder() {
      if (queryOptionsBuilder_ == null) {
        queryOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.ExecuteSqlRequest.QueryOptions,
                com.google.spanner.v1.ExecuteSqlRequest.QueryOptions.Builder,
                com.google.spanner.v1.ExecuteSqlRequest.QueryOptionsOrBuilder>(
                getQueryOptions(), getParentForChildren(), isClean());
        queryOptions_ = null;
      }
      return queryOptionsBuilder_;
    }

    private com.google.spanner.v1.RequestOptions requestOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.RequestOptions,
            com.google.spanner.v1.RequestOptions.Builder,
            com.google.spanner.v1.RequestOptionsOrBuilder>
        requestOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 11;</code>
     *
     * @return Whether the requestOptions field is set.
     */
    public boolean hasRequestOptions() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 11;</code>
     *
     * @return The requestOptions.
     */
    public com.google.spanner.v1.RequestOptions getRequestOptions() {
      if (requestOptionsBuilder_ == null) {
        return requestOptions_ == null
            ? com.google.spanner.v1.RequestOptions.getDefaultInstance()
            : requestOptions_;
      } else {
        return requestOptionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 11;</code>
     */
    public Builder setRequestOptions(com.google.spanner.v1.RequestOptions value) {
      if (requestOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        requestOptions_ = value;
      } else {
        requestOptionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 11;</code>
     */
    public Builder setRequestOptions(com.google.spanner.v1.RequestOptions.Builder builderForValue) {
      if (requestOptionsBuilder_ == null) {
        requestOptions_ = builderForValue.build();
      } else {
        requestOptionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 11;</code>
     */
    public Builder mergeRequestOptions(com.google.spanner.v1.RequestOptions value) {
      if (requestOptionsBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && requestOptions_ != null
            && requestOptions_ != com.google.spanner.v1.RequestOptions.getDefaultInstance()) {
          getRequestOptionsBuilder().mergeFrom(value);
        } else {
          requestOptions_ = value;
        }
      } else {
        requestOptionsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 11;</code>
     */
    public Builder clearRequestOptions() {
      bitField0_ = (bitField0_ & ~0x00000400);
      requestOptions_ = null;
      if (requestOptionsBuilder_ != null) {
        requestOptionsBuilder_.dispose();
        requestOptionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 11;</code>
     */
    public com.google.spanner.v1.RequestOptions.Builder getRequestOptionsBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getRequestOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 11;</code>
     */
    public com.google.spanner.v1.RequestOptionsOrBuilder getRequestOptionsOrBuilder() {
      if (requestOptionsBuilder_ != null) {
        return requestOptionsBuilder_.getMessageOrBuilder();
      } else {
        return requestOptions_ == null
            ? com.google.spanner.v1.RequestOptions.getDefaultInstance()
            : requestOptions_;
      }
    }
    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.RequestOptions,
            com.google.spanner.v1.RequestOptions.Builder,
            com.google.spanner.v1.RequestOptionsOrBuilder>
        getRequestOptionsFieldBuilder() {
      if (requestOptionsBuilder_ == null) {
        requestOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.RequestOptions,
                com.google.spanner.v1.RequestOptions.Builder,
                com.google.spanner.v1.RequestOptionsOrBuilder>(
                getRequestOptions(), getParentForChildren(), isClean());
        requestOptions_ = null;
      }
      return requestOptionsBuilder_;
    }

    private boolean dataBoostEnabled_;
    /**
     *
     *
     * <pre>
     * If this is for a partitioned query and this field is set to `true`, the
     * request will be executed via Spanner independent compute resources.
     *
     * If the field is set to `true` but the request does not set
     * `partition_token`, the API will return an `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>bool data_boost_enabled = 16;</code>
     *
     * @return The dataBoostEnabled.
     */
    @java.lang.Override
    public boolean getDataBoostEnabled() {
      return dataBoostEnabled_;
    }
    /**
     *
     *
     * <pre>
     * If this is for a partitioned query and this field is set to `true`, the
     * request will be executed via Spanner independent compute resources.
     *
     * If the field is set to `true` but the request does not set
     * `partition_token`, the API will return an `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>bool data_boost_enabled = 16;</code>
     *
     * @param value The dataBoostEnabled to set.
     * @return This builder for chaining.
     */
    public Builder setDataBoostEnabled(boolean value) {

      dataBoostEnabled_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If this is for a partitioned query and this field is set to `true`, the
     * request will be executed via Spanner independent compute resources.
     *
     * If the field is set to `true` but the request does not set
     * `partition_token`, the API will return an `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>bool data_boost_enabled = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataBoostEnabled() {
      bitField0_ = (bitField0_ & ~0x00000800);
      dataBoostEnabled_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.v1.ExecuteSqlRequest)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.v1.ExecuteSqlRequest)
  private static final com.google.spanner.v1.ExecuteSqlRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.v1.ExecuteSqlRequest();
  }

  public static com.google.spanner.v1.ExecuteSqlRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExecuteSqlRequest> PARSER =
      new com.google.protobuf.AbstractParser<ExecuteSqlRequest>() {
        @java.lang.Override
        public ExecuteSqlRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExecuteSqlRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExecuteSqlRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.v1.ExecuteSqlRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
