/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/v1/spanner.proto

package com.google.spanner.v1;

/**
 *
 *
 * <pre>
 * The request for [Commit][google.spanner.v1.Spanner.Commit].
 * </pre>
 *
 * Protobuf type {@code google.spanner.v1.CommitRequest}
 */
public final class CommitRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.v1.CommitRequest)
    CommitRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CommitRequest.newBuilder() to construct.
  private CommitRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CommitRequest() {
    session_ = "";
    mutations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CommitRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.v1.SpannerProto
        .internal_static_google_spanner_v1_CommitRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.v1.SpannerProto
        .internal_static_google_spanner_v1_CommitRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.v1.CommitRequest.class,
            com.google.spanner.v1.CommitRequest.Builder.class);
  }

  private int transactionCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object transaction_;

  public enum TransactionCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TRANSACTION_ID(2),
    SINGLE_USE_TRANSACTION(3),
    TRANSACTION_NOT_SET(0);
    private final int value;

    private TransactionCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TransactionCase valueOf(int value) {
      return forNumber(value);
    }

    public static TransactionCase forNumber(int value) {
      switch (value) {
        case 2:
          return TRANSACTION_ID;
        case 3:
          return SINGLE_USE_TRANSACTION;
        case 0:
          return TRANSACTION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TransactionCase getTransactionCase() {
    return TransactionCase.forNumber(transactionCase_);
  }

  public static final int SESSION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object session_ = "";
  /**
   *
   *
   * <pre>
   * Required. The session in which the transaction to be committed is running.
   * </pre>
   *
   * <code>
   * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The session.
   */
  @java.lang.Override
  public java.lang.String getSession() {
    java.lang.Object ref = session_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      session_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The session in which the transaction to be committed is running.
   * </pre>
   *
   * <code>
   * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for session.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSessionBytes() {
    java.lang.Object ref = session_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      session_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRANSACTION_ID_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Commit a previously-started transaction.
   * </pre>
   *
   * <code>bytes transaction_id = 2;</code>
   *
   * @return Whether the transactionId field is set.
   */
  @java.lang.Override
  public boolean hasTransactionId() {
    return transactionCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Commit a previously-started transaction.
   * </pre>
   *
   * <code>bytes transaction_id = 2;</code>
   *
   * @return The transactionId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTransactionId() {
    if (transactionCase_ == 2) {
      return (com.google.protobuf.ByteString) transaction_;
    }
    return com.google.protobuf.ByteString.EMPTY;
  }

  public static final int SINGLE_USE_TRANSACTION_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Execute mutations in a temporary transaction. Note that unlike
   * commit of a previously-started transaction, commit with a
   * temporary transaction is non-idempotent. That is, if the
   * `CommitRequest` is sent to Cloud Spanner more than once (for
   * instance, due to retries in the application, or in the
   * transport library), it is possible that the mutations are
   * executed more than once. If this is undesirable, use
   * [BeginTransaction][google.spanner.v1.Spanner.BeginTransaction] and
   * [Commit][google.spanner.v1.Spanner.Commit] instead.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionOptions single_use_transaction = 3;</code>
   *
   * @return Whether the singleUseTransaction field is set.
   */
  @java.lang.Override
  public boolean hasSingleUseTransaction() {
    return transactionCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Execute mutations in a temporary transaction. Note that unlike
   * commit of a previously-started transaction, commit with a
   * temporary transaction is non-idempotent. That is, if the
   * `CommitRequest` is sent to Cloud Spanner more than once (for
   * instance, due to retries in the application, or in the
   * transport library), it is possible that the mutations are
   * executed more than once. If this is undesirable, use
   * [BeginTransaction][google.spanner.v1.Spanner.BeginTransaction] and
   * [Commit][google.spanner.v1.Spanner.Commit] instead.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionOptions single_use_transaction = 3;</code>
   *
   * @return The singleUseTransaction.
   */
  @java.lang.Override
  public com.google.spanner.v1.TransactionOptions getSingleUseTransaction() {
    if (transactionCase_ == 3) {
      return (com.google.spanner.v1.TransactionOptions) transaction_;
    }
    return com.google.spanner.v1.TransactionOptions.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Execute mutations in a temporary transaction. Note that unlike
   * commit of a previously-started transaction, commit with a
   * temporary transaction is non-idempotent. That is, if the
   * `CommitRequest` is sent to Cloud Spanner more than once (for
   * instance, due to retries in the application, or in the
   * transport library), it is possible that the mutations are
   * executed more than once. If this is undesirable, use
   * [BeginTransaction][google.spanner.v1.Spanner.BeginTransaction] and
   * [Commit][google.spanner.v1.Spanner.Commit] instead.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionOptions single_use_transaction = 3;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.TransactionOptionsOrBuilder getSingleUseTransactionOrBuilder() {
    if (transactionCase_ == 3) {
      return (com.google.spanner.v1.TransactionOptions) transaction_;
    }
    return com.google.spanner.v1.TransactionOptions.getDefaultInstance();
  }

  public static final int MUTATIONS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.spanner.v1.Mutation> mutations_;
  /**
   *
   *
   * <pre>
   * The mutations to be executed when this transaction commits. All
   * mutations are applied atomically, in the order they appear in
   * this list.
   * </pre>
   *
   * <code>repeated .google.spanner.v1.Mutation mutations = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.spanner.v1.Mutation> getMutationsList() {
    return mutations_;
  }
  /**
   *
   *
   * <pre>
   * The mutations to be executed when this transaction commits. All
   * mutations are applied atomically, in the order they appear in
   * this list.
   * </pre>
   *
   * <code>repeated .google.spanner.v1.Mutation mutations = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.spanner.v1.MutationOrBuilder>
      getMutationsOrBuilderList() {
    return mutations_;
  }
  /**
   *
   *
   * <pre>
   * The mutations to be executed when this transaction commits. All
   * mutations are applied atomically, in the order they appear in
   * this list.
   * </pre>
   *
   * <code>repeated .google.spanner.v1.Mutation mutations = 4;</code>
   */
  @java.lang.Override
  public int getMutationsCount() {
    return mutations_.size();
  }
  /**
   *
   *
   * <pre>
   * The mutations to be executed when this transaction commits. All
   * mutations are applied atomically, in the order they appear in
   * this list.
   * </pre>
   *
   * <code>repeated .google.spanner.v1.Mutation mutations = 4;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.Mutation getMutations(int index) {
    return mutations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The mutations to be executed when this transaction commits. All
   * mutations are applied atomically, in the order they appear in
   * this list.
   * </pre>
   *
   * <code>repeated .google.spanner.v1.Mutation mutations = 4;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.MutationOrBuilder getMutationsOrBuilder(int index) {
    return mutations_.get(index);
  }

  public static final int RETURN_COMMIT_STATS_FIELD_NUMBER = 5;
  private boolean returnCommitStats_ = false;
  /**
   *
   *
   * <pre>
   * If `true`, then statistics related to the transaction will be included in
   * the [CommitResponse][google.spanner.v1.CommitResponse.commit_stats].
   * Default value is `false`.
   * </pre>
   *
   * <code>bool return_commit_stats = 5;</code>
   *
   * @return The returnCommitStats.
   */
  @java.lang.Override
  public boolean getReturnCommitStats() {
    return returnCommitStats_;
  }

  public static final int REQUEST_OPTIONS_FIELD_NUMBER = 6;
  private com.google.spanner.v1.RequestOptions requestOptions_;
  /**
   *
   *
   * <pre>
   * Common options for this request.
   * </pre>
   *
   * <code>.google.spanner.v1.RequestOptions request_options = 6;</code>
   *
   * @return Whether the requestOptions field is set.
   */
  @java.lang.Override
  public boolean hasRequestOptions() {
    return requestOptions_ != null;
  }
  /**
   *
   *
   * <pre>
   * Common options for this request.
   * </pre>
   *
   * <code>.google.spanner.v1.RequestOptions request_options = 6;</code>
   *
   * @return The requestOptions.
   */
  @java.lang.Override
  public com.google.spanner.v1.RequestOptions getRequestOptions() {
    return requestOptions_ == null
        ? com.google.spanner.v1.RequestOptions.getDefaultInstance()
        : requestOptions_;
  }
  /**
   *
   *
   * <pre>
   * Common options for this request.
   * </pre>
   *
   * <code>.google.spanner.v1.RequestOptions request_options = 6;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.RequestOptionsOrBuilder getRequestOptionsOrBuilder() {
    return requestOptions_ == null
        ? com.google.spanner.v1.RequestOptions.getDefaultInstance()
        : requestOptions_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(session_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, session_);
    }
    if (transactionCase_ == 2) {
      output.writeBytes(2, (com.google.protobuf.ByteString) transaction_);
    }
    if (transactionCase_ == 3) {
      output.writeMessage(3, (com.google.spanner.v1.TransactionOptions) transaction_);
    }
    for (int i = 0; i < mutations_.size(); i++) {
      output.writeMessage(4, mutations_.get(i));
    }
    if (returnCommitStats_ != false) {
      output.writeBool(5, returnCommitStats_);
    }
    if (requestOptions_ != null) {
      output.writeMessage(6, getRequestOptions());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(session_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, session_);
    }
    if (transactionCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBytesSize(
              2, (com.google.protobuf.ByteString) transaction_);
    }
    if (transactionCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.spanner.v1.TransactionOptions) transaction_);
    }
    for (int i = 0; i < mutations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, mutations_.get(i));
    }
    if (returnCommitStats_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, returnCommitStats_);
    }
    if (requestOptions_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getRequestOptions());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.v1.CommitRequest)) {
      return super.equals(obj);
    }
    com.google.spanner.v1.CommitRequest other = (com.google.spanner.v1.CommitRequest) obj;

    if (!getSession().equals(other.getSession())) return false;
    if (!getMutationsList().equals(other.getMutationsList())) return false;
    if (getReturnCommitStats() != other.getReturnCommitStats()) return false;
    if (hasRequestOptions() != other.hasRequestOptions()) return false;
    if (hasRequestOptions()) {
      if (!getRequestOptions().equals(other.getRequestOptions())) return false;
    }
    if (!getTransactionCase().equals(other.getTransactionCase())) return false;
    switch (transactionCase_) {
      case 2:
        if (!getTransactionId().equals(other.getTransactionId())) return false;
        break;
      case 3:
        if (!getSingleUseTransaction().equals(other.getSingleUseTransaction())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SESSION_FIELD_NUMBER;
    hash = (53 * hash) + getSession().hashCode();
    if (getMutationsCount() > 0) {
      hash = (37 * hash) + MUTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getMutationsList().hashCode();
    }
    hash = (37 * hash) + RETURN_COMMIT_STATS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getReturnCommitStats());
    if (hasRequestOptions()) {
      hash = (37 * hash) + REQUEST_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getRequestOptions().hashCode();
    }
    switch (transactionCase_) {
      case 2:
        hash = (37 * hash) + TRANSACTION_ID_FIELD_NUMBER;
        hash = (53 * hash) + getTransactionId().hashCode();
        break;
      case 3:
        hash = (37 * hash) + SINGLE_USE_TRANSACTION_FIELD_NUMBER;
        hash = (53 * hash) + getSingleUseTransaction().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.v1.CommitRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.CommitRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.CommitRequest parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.CommitRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.CommitRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.CommitRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.CommitRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.CommitRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.CommitRequest parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.CommitRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.CommitRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.CommitRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.v1.CommitRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request for [Commit][google.spanner.v1.Spanner.Commit].
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.CommitRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.v1.CommitRequest)
      com.google.spanner.v1.CommitRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_CommitRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_CommitRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.CommitRequest.class,
              com.google.spanner.v1.CommitRequest.Builder.class);
    }

    // Construct using com.google.spanner.v1.CommitRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      session_ = "";
      if (singleUseTransactionBuilder_ != null) {
        singleUseTransactionBuilder_.clear();
      }
      if (mutationsBuilder_ == null) {
        mutations_ = java.util.Collections.emptyList();
      } else {
        mutations_ = null;
        mutationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      returnCommitStats_ = false;
      requestOptions_ = null;
      if (requestOptionsBuilder_ != null) {
        requestOptionsBuilder_.dispose();
        requestOptionsBuilder_ = null;
      }
      transactionCase_ = 0;
      transaction_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_CommitRequest_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.v1.CommitRequest getDefaultInstanceForType() {
      return com.google.spanner.v1.CommitRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.v1.CommitRequest build() {
      com.google.spanner.v1.CommitRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.v1.CommitRequest buildPartial() {
      com.google.spanner.v1.CommitRequest result = new com.google.spanner.v1.CommitRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.spanner.v1.CommitRequest result) {
      if (mutationsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          mutations_ = java.util.Collections.unmodifiableList(mutations_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.mutations_ = mutations_;
      } else {
        result.mutations_ = mutationsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.spanner.v1.CommitRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.session_ = session_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.returnCommitStats_ = returnCommitStats_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.requestOptions_ =
            requestOptionsBuilder_ == null ? requestOptions_ : requestOptionsBuilder_.build();
      }
    }

    private void buildPartialOneofs(com.google.spanner.v1.CommitRequest result) {
      result.transactionCase_ = transactionCase_;
      result.transaction_ = this.transaction_;
      if (transactionCase_ == 3 && singleUseTransactionBuilder_ != null) {
        result.transaction_ = singleUseTransactionBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.v1.CommitRequest) {
        return mergeFrom((com.google.spanner.v1.CommitRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.v1.CommitRequest other) {
      if (other == com.google.spanner.v1.CommitRequest.getDefaultInstance()) return this;
      if (!other.getSession().isEmpty()) {
        session_ = other.session_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (mutationsBuilder_ == null) {
        if (!other.mutations_.isEmpty()) {
          if (mutations_.isEmpty()) {
            mutations_ = other.mutations_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureMutationsIsMutable();
            mutations_.addAll(other.mutations_);
          }
          onChanged();
        }
      } else {
        if (!other.mutations_.isEmpty()) {
          if (mutationsBuilder_.isEmpty()) {
            mutationsBuilder_.dispose();
            mutationsBuilder_ = null;
            mutations_ = other.mutations_;
            bitField0_ = (bitField0_ & ~0x00000008);
            mutationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMutationsFieldBuilder()
                    : null;
          } else {
            mutationsBuilder_.addAllMessages(other.mutations_);
          }
        }
      }
      if (other.getReturnCommitStats() != false) {
        setReturnCommitStats(other.getReturnCommitStats());
      }
      if (other.hasRequestOptions()) {
        mergeRequestOptions(other.getRequestOptions());
      }
      switch (other.getTransactionCase()) {
        case TRANSACTION_ID:
          {
            setTransactionId(other.getTransactionId());
            break;
          }
        case SINGLE_USE_TRANSACTION:
          {
            mergeSingleUseTransaction(other.getSingleUseTransaction());
            break;
          }
        case TRANSACTION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                session_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                transaction_ = input.readBytes();
                transactionCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getSingleUseTransactionFieldBuilder().getBuilder(), extensionRegistry);
                transactionCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                com.google.spanner.v1.Mutation m =
                    input.readMessage(com.google.spanner.v1.Mutation.parser(), extensionRegistry);
                if (mutationsBuilder_ == null) {
                  ensureMutationsIsMutable();
                  mutations_.add(m);
                } else {
                  mutationsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 40:
              {
                returnCommitStats_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                input.readMessage(getRequestOptionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int transactionCase_ = 0;
    private java.lang.Object transaction_;

    public TransactionCase getTransactionCase() {
      return TransactionCase.forNumber(transactionCase_);
    }

    public Builder clearTransaction() {
      transactionCase_ = 0;
      transaction_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object session_ = "";
    /**
     *
     *
     * <pre>
     * Required. The session in which the transaction to be committed is running.
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The session.
     */
    public java.lang.String getSession() {
      java.lang.Object ref = session_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        session_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The session in which the transaction to be committed is running.
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for session.
     */
    public com.google.protobuf.ByteString getSessionBytes() {
      java.lang.Object ref = session_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        session_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The session in which the transaction to be committed is running.
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The session to set.
     * @return This builder for chaining.
     */
    public Builder setSession(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      session_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The session in which the transaction to be committed is running.
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSession() {
      session_ = getDefaultInstance().getSession();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The session in which the transaction to be committed is running.
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for session to set.
     * @return This builder for chaining.
     */
    public Builder setSessionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      session_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Commit a previously-started transaction.
     * </pre>
     *
     * <code>bytes transaction_id = 2;</code>
     *
     * @return Whether the transactionId field is set.
     */
    public boolean hasTransactionId() {
      return transactionCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Commit a previously-started transaction.
     * </pre>
     *
     * <code>bytes transaction_id = 2;</code>
     *
     * @return The transactionId.
     */
    public com.google.protobuf.ByteString getTransactionId() {
      if (transactionCase_ == 2) {
        return (com.google.protobuf.ByteString) transaction_;
      }
      return com.google.protobuf.ByteString.EMPTY;
    }
    /**
     *
     *
     * <pre>
     * Commit a previously-started transaction.
     * </pre>
     *
     * <code>bytes transaction_id = 2;</code>
     *
     * @param value The transactionId to set.
     * @return This builder for chaining.
     */
    public Builder setTransactionId(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      transactionCase_ = 2;
      transaction_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Commit a previously-started transaction.
     * </pre>
     *
     * <code>bytes transaction_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTransactionId() {
      if (transactionCase_ == 2) {
        transactionCase_ = 0;
        transaction_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.TransactionOptions,
            com.google.spanner.v1.TransactionOptions.Builder,
            com.google.spanner.v1.TransactionOptionsOrBuilder>
        singleUseTransactionBuilder_;
    /**
     *
     *
     * <pre>
     * Execute mutations in a temporary transaction. Note that unlike
     * commit of a previously-started transaction, commit with a
     * temporary transaction is non-idempotent. That is, if the
     * `CommitRequest` is sent to Cloud Spanner more than once (for
     * instance, due to retries in the application, or in the
     * transport library), it is possible that the mutations are
     * executed more than once. If this is undesirable, use
     * [BeginTransaction][google.spanner.v1.Spanner.BeginTransaction] and
     * [Commit][google.spanner.v1.Spanner.Commit] instead.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions single_use_transaction = 3;</code>
     *
     * @return Whether the singleUseTransaction field is set.
     */
    @java.lang.Override
    public boolean hasSingleUseTransaction() {
      return transactionCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Execute mutations in a temporary transaction. Note that unlike
     * commit of a previously-started transaction, commit with a
     * temporary transaction is non-idempotent. That is, if the
     * `CommitRequest` is sent to Cloud Spanner more than once (for
     * instance, due to retries in the application, or in the
     * transport library), it is possible that the mutations are
     * executed more than once. If this is undesirable, use
     * [BeginTransaction][google.spanner.v1.Spanner.BeginTransaction] and
     * [Commit][google.spanner.v1.Spanner.Commit] instead.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions single_use_transaction = 3;</code>
     *
     * @return The singleUseTransaction.
     */
    @java.lang.Override
    public com.google.spanner.v1.TransactionOptions getSingleUseTransaction() {
      if (singleUseTransactionBuilder_ == null) {
        if (transactionCase_ == 3) {
          return (com.google.spanner.v1.TransactionOptions) transaction_;
        }
        return com.google.spanner.v1.TransactionOptions.getDefaultInstance();
      } else {
        if (transactionCase_ == 3) {
          return singleUseTransactionBuilder_.getMessage();
        }
        return com.google.spanner.v1.TransactionOptions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Execute mutations in a temporary transaction. Note that unlike
     * commit of a previously-started transaction, commit with a
     * temporary transaction is non-idempotent. That is, if the
     * `CommitRequest` is sent to Cloud Spanner more than once (for
     * instance, due to retries in the application, or in the
     * transport library), it is possible that the mutations are
     * executed more than once. If this is undesirable, use
     * [BeginTransaction][google.spanner.v1.Spanner.BeginTransaction] and
     * [Commit][google.spanner.v1.Spanner.Commit] instead.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions single_use_transaction = 3;</code>
     */
    public Builder setSingleUseTransaction(com.google.spanner.v1.TransactionOptions value) {
      if (singleUseTransactionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transaction_ = value;
        onChanged();
      } else {
        singleUseTransactionBuilder_.setMessage(value);
      }
      transactionCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Execute mutations in a temporary transaction. Note that unlike
     * commit of a previously-started transaction, commit with a
     * temporary transaction is non-idempotent. That is, if the
     * `CommitRequest` is sent to Cloud Spanner more than once (for
     * instance, due to retries in the application, or in the
     * transport library), it is possible that the mutations are
     * executed more than once. If this is undesirable, use
     * [BeginTransaction][google.spanner.v1.Spanner.BeginTransaction] and
     * [Commit][google.spanner.v1.Spanner.Commit] instead.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions single_use_transaction = 3;</code>
     */
    public Builder setSingleUseTransaction(
        com.google.spanner.v1.TransactionOptions.Builder builderForValue) {
      if (singleUseTransactionBuilder_ == null) {
        transaction_ = builderForValue.build();
        onChanged();
      } else {
        singleUseTransactionBuilder_.setMessage(builderForValue.build());
      }
      transactionCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Execute mutations in a temporary transaction. Note that unlike
     * commit of a previously-started transaction, commit with a
     * temporary transaction is non-idempotent. That is, if the
     * `CommitRequest` is sent to Cloud Spanner more than once (for
     * instance, due to retries in the application, or in the
     * transport library), it is possible that the mutations are
     * executed more than once. If this is undesirable, use
     * [BeginTransaction][google.spanner.v1.Spanner.BeginTransaction] and
     * [Commit][google.spanner.v1.Spanner.Commit] instead.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions single_use_transaction = 3;</code>
     */
    public Builder mergeSingleUseTransaction(com.google.spanner.v1.TransactionOptions value) {
      if (singleUseTransactionBuilder_ == null) {
        if (transactionCase_ == 3
            && transaction_ != com.google.spanner.v1.TransactionOptions.getDefaultInstance()) {
          transaction_ =
              com.google.spanner.v1.TransactionOptions.newBuilder(
                      (com.google.spanner.v1.TransactionOptions) transaction_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          transaction_ = value;
        }
        onChanged();
      } else {
        if (transactionCase_ == 3) {
          singleUseTransactionBuilder_.mergeFrom(value);
        } else {
          singleUseTransactionBuilder_.setMessage(value);
        }
      }
      transactionCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Execute mutations in a temporary transaction. Note that unlike
     * commit of a previously-started transaction, commit with a
     * temporary transaction is non-idempotent. That is, if the
     * `CommitRequest` is sent to Cloud Spanner more than once (for
     * instance, due to retries in the application, or in the
     * transport library), it is possible that the mutations are
     * executed more than once. If this is undesirable, use
     * [BeginTransaction][google.spanner.v1.Spanner.BeginTransaction] and
     * [Commit][google.spanner.v1.Spanner.Commit] instead.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions single_use_transaction = 3;</code>
     */
    public Builder clearSingleUseTransaction() {
      if (singleUseTransactionBuilder_ == null) {
        if (transactionCase_ == 3) {
          transactionCase_ = 0;
          transaction_ = null;
          onChanged();
        }
      } else {
        if (transactionCase_ == 3) {
          transactionCase_ = 0;
          transaction_ = null;
        }
        singleUseTransactionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Execute mutations in a temporary transaction. Note that unlike
     * commit of a previously-started transaction, commit with a
     * temporary transaction is non-idempotent. That is, if the
     * `CommitRequest` is sent to Cloud Spanner more than once (for
     * instance, due to retries in the application, or in the
     * transport library), it is possible that the mutations are
     * executed more than once. If this is undesirable, use
     * [BeginTransaction][google.spanner.v1.Spanner.BeginTransaction] and
     * [Commit][google.spanner.v1.Spanner.Commit] instead.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions single_use_transaction = 3;</code>
     */
    public com.google.spanner.v1.TransactionOptions.Builder getSingleUseTransactionBuilder() {
      return getSingleUseTransactionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Execute mutations in a temporary transaction. Note that unlike
     * commit of a previously-started transaction, commit with a
     * temporary transaction is non-idempotent. That is, if the
     * `CommitRequest` is sent to Cloud Spanner more than once (for
     * instance, due to retries in the application, or in the
     * transport library), it is possible that the mutations are
     * executed more than once. If this is undesirable, use
     * [BeginTransaction][google.spanner.v1.Spanner.BeginTransaction] and
     * [Commit][google.spanner.v1.Spanner.Commit] instead.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions single_use_transaction = 3;</code>
     */
    @java.lang.Override
    public com.google.spanner.v1.TransactionOptionsOrBuilder getSingleUseTransactionOrBuilder() {
      if ((transactionCase_ == 3) && (singleUseTransactionBuilder_ != null)) {
        return singleUseTransactionBuilder_.getMessageOrBuilder();
      } else {
        if (transactionCase_ == 3) {
          return (com.google.spanner.v1.TransactionOptions) transaction_;
        }
        return com.google.spanner.v1.TransactionOptions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Execute mutations in a temporary transaction. Note that unlike
     * commit of a previously-started transaction, commit with a
     * temporary transaction is non-idempotent. That is, if the
     * `CommitRequest` is sent to Cloud Spanner more than once (for
     * instance, due to retries in the application, or in the
     * transport library), it is possible that the mutations are
     * executed more than once. If this is undesirable, use
     * [BeginTransaction][google.spanner.v1.Spanner.BeginTransaction] and
     * [Commit][google.spanner.v1.Spanner.Commit] instead.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionOptions single_use_transaction = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.TransactionOptions,
            com.google.spanner.v1.TransactionOptions.Builder,
            com.google.spanner.v1.TransactionOptionsOrBuilder>
        getSingleUseTransactionFieldBuilder() {
      if (singleUseTransactionBuilder_ == null) {
        if (!(transactionCase_ == 3)) {
          transaction_ = com.google.spanner.v1.TransactionOptions.getDefaultInstance();
        }
        singleUseTransactionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.TransactionOptions,
                com.google.spanner.v1.TransactionOptions.Builder,
                com.google.spanner.v1.TransactionOptionsOrBuilder>(
                (com.google.spanner.v1.TransactionOptions) transaction_,
                getParentForChildren(),
                isClean());
        transaction_ = null;
      }
      transactionCase_ = 3;
      onChanged();
      return singleUseTransactionBuilder_;
    }

    private java.util.List<com.google.spanner.v1.Mutation> mutations_ =
        java.util.Collections.emptyList();

    private void ensureMutationsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        mutations_ = new java.util.ArrayList<com.google.spanner.v1.Mutation>(mutations_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.v1.Mutation,
            com.google.spanner.v1.Mutation.Builder,
            com.google.spanner.v1.MutationOrBuilder>
        mutationsBuilder_;

    /**
     *
     *
     * <pre>
     * The mutations to be executed when this transaction commits. All
     * mutations are applied atomically, in the order they appear in
     * this list.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.Mutation mutations = 4;</code>
     */
    public java.util.List<com.google.spanner.v1.Mutation> getMutationsList() {
      if (mutationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(mutations_);
      } else {
        return mutationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The mutations to be executed when this transaction commits. All
     * mutations are applied atomically, in the order they appear in
     * this list.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.Mutation mutations = 4;</code>
     */
    public int getMutationsCount() {
      if (mutationsBuilder_ == null) {
        return mutations_.size();
      } else {
        return mutationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The mutations to be executed when this transaction commits. All
     * mutations are applied atomically, in the order they appear in
     * this list.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.Mutation mutations = 4;</code>
     */
    public com.google.spanner.v1.Mutation getMutations(int index) {
      if (mutationsBuilder_ == null) {
        return mutations_.get(index);
      } else {
        return mutationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The mutations to be executed when this transaction commits. All
     * mutations are applied atomically, in the order they appear in
     * this list.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.Mutation mutations = 4;</code>
     */
    public Builder setMutations(int index, com.google.spanner.v1.Mutation value) {
      if (mutationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMutationsIsMutable();
        mutations_.set(index, value);
        onChanged();
      } else {
        mutationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mutations to be executed when this transaction commits. All
     * mutations are applied atomically, in the order they appear in
     * this list.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.Mutation mutations = 4;</code>
     */
    public Builder setMutations(int index, com.google.spanner.v1.Mutation.Builder builderForValue) {
      if (mutationsBuilder_ == null) {
        ensureMutationsIsMutable();
        mutations_.set(index, builderForValue.build());
        onChanged();
      } else {
        mutationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mutations to be executed when this transaction commits. All
     * mutations are applied atomically, in the order they appear in
     * this list.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.Mutation mutations = 4;</code>
     */
    public Builder addMutations(com.google.spanner.v1.Mutation value) {
      if (mutationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMutationsIsMutable();
        mutations_.add(value);
        onChanged();
      } else {
        mutationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mutations to be executed when this transaction commits. All
     * mutations are applied atomically, in the order they appear in
     * this list.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.Mutation mutations = 4;</code>
     */
    public Builder addMutations(int index, com.google.spanner.v1.Mutation value) {
      if (mutationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMutationsIsMutable();
        mutations_.add(index, value);
        onChanged();
      } else {
        mutationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mutations to be executed when this transaction commits. All
     * mutations are applied atomically, in the order they appear in
     * this list.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.Mutation mutations = 4;</code>
     */
    public Builder addMutations(com.google.spanner.v1.Mutation.Builder builderForValue) {
      if (mutationsBuilder_ == null) {
        ensureMutationsIsMutable();
        mutations_.add(builderForValue.build());
        onChanged();
      } else {
        mutationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mutations to be executed when this transaction commits. All
     * mutations are applied atomically, in the order they appear in
     * this list.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.Mutation mutations = 4;</code>
     */
    public Builder addMutations(int index, com.google.spanner.v1.Mutation.Builder builderForValue) {
      if (mutationsBuilder_ == null) {
        ensureMutationsIsMutable();
        mutations_.add(index, builderForValue.build());
        onChanged();
      } else {
        mutationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mutations to be executed when this transaction commits. All
     * mutations are applied atomically, in the order they appear in
     * this list.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.Mutation mutations = 4;</code>
     */
    public Builder addAllMutations(
        java.lang.Iterable<? extends com.google.spanner.v1.Mutation> values) {
      if (mutationsBuilder_ == null) {
        ensureMutationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, mutations_);
        onChanged();
      } else {
        mutationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mutations to be executed when this transaction commits. All
     * mutations are applied atomically, in the order they appear in
     * this list.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.Mutation mutations = 4;</code>
     */
    public Builder clearMutations() {
      if (mutationsBuilder_ == null) {
        mutations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        mutationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mutations to be executed when this transaction commits. All
     * mutations are applied atomically, in the order they appear in
     * this list.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.Mutation mutations = 4;</code>
     */
    public Builder removeMutations(int index) {
      if (mutationsBuilder_ == null) {
        ensureMutationsIsMutable();
        mutations_.remove(index);
        onChanged();
      } else {
        mutationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mutations to be executed when this transaction commits. All
     * mutations are applied atomically, in the order they appear in
     * this list.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.Mutation mutations = 4;</code>
     */
    public com.google.spanner.v1.Mutation.Builder getMutationsBuilder(int index) {
      return getMutationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The mutations to be executed when this transaction commits. All
     * mutations are applied atomically, in the order they appear in
     * this list.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.Mutation mutations = 4;</code>
     */
    public com.google.spanner.v1.MutationOrBuilder getMutationsOrBuilder(int index) {
      if (mutationsBuilder_ == null) {
        return mutations_.get(index);
      } else {
        return mutationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The mutations to be executed when this transaction commits. All
     * mutations are applied atomically, in the order they appear in
     * this list.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.Mutation mutations = 4;</code>
     */
    public java.util.List<? extends com.google.spanner.v1.MutationOrBuilder>
        getMutationsOrBuilderList() {
      if (mutationsBuilder_ != null) {
        return mutationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(mutations_);
      }
    }
    /**
     *
     *
     * <pre>
     * The mutations to be executed when this transaction commits. All
     * mutations are applied atomically, in the order they appear in
     * this list.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.Mutation mutations = 4;</code>
     */
    public com.google.spanner.v1.Mutation.Builder addMutationsBuilder() {
      return getMutationsFieldBuilder()
          .addBuilder(com.google.spanner.v1.Mutation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The mutations to be executed when this transaction commits. All
     * mutations are applied atomically, in the order they appear in
     * this list.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.Mutation mutations = 4;</code>
     */
    public com.google.spanner.v1.Mutation.Builder addMutationsBuilder(int index) {
      return getMutationsFieldBuilder()
          .addBuilder(index, com.google.spanner.v1.Mutation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The mutations to be executed when this transaction commits. All
     * mutations are applied atomically, in the order they appear in
     * this list.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.Mutation mutations = 4;</code>
     */
    public java.util.List<com.google.spanner.v1.Mutation.Builder> getMutationsBuilderList() {
      return getMutationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.v1.Mutation,
            com.google.spanner.v1.Mutation.Builder,
            com.google.spanner.v1.MutationOrBuilder>
        getMutationsFieldBuilder() {
      if (mutationsBuilder_ == null) {
        mutationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.spanner.v1.Mutation,
                com.google.spanner.v1.Mutation.Builder,
                com.google.spanner.v1.MutationOrBuilder>(
                mutations_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        mutations_ = null;
      }
      return mutationsBuilder_;
    }

    private boolean returnCommitStats_;
    /**
     *
     *
     * <pre>
     * If `true`, then statistics related to the transaction will be included in
     * the [CommitResponse][google.spanner.v1.CommitResponse.commit_stats].
     * Default value is `false`.
     * </pre>
     *
     * <code>bool return_commit_stats = 5;</code>
     *
     * @return The returnCommitStats.
     */
    @java.lang.Override
    public boolean getReturnCommitStats() {
      return returnCommitStats_;
    }
    /**
     *
     *
     * <pre>
     * If `true`, then statistics related to the transaction will be included in
     * the [CommitResponse][google.spanner.v1.CommitResponse.commit_stats].
     * Default value is `false`.
     * </pre>
     *
     * <code>bool return_commit_stats = 5;</code>
     *
     * @param value The returnCommitStats to set.
     * @return This builder for chaining.
     */
    public Builder setReturnCommitStats(boolean value) {

      returnCommitStats_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If `true`, then statistics related to the transaction will be included in
     * the [CommitResponse][google.spanner.v1.CommitResponse.commit_stats].
     * Default value is `false`.
     * </pre>
     *
     * <code>bool return_commit_stats = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReturnCommitStats() {
      bitField0_ = (bitField0_ & ~0x00000010);
      returnCommitStats_ = false;
      onChanged();
      return this;
    }

    private com.google.spanner.v1.RequestOptions requestOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.RequestOptions,
            com.google.spanner.v1.RequestOptions.Builder,
            com.google.spanner.v1.RequestOptionsOrBuilder>
        requestOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 6;</code>
     *
     * @return Whether the requestOptions field is set.
     */
    public boolean hasRequestOptions() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 6;</code>
     *
     * @return The requestOptions.
     */
    public com.google.spanner.v1.RequestOptions getRequestOptions() {
      if (requestOptionsBuilder_ == null) {
        return requestOptions_ == null
            ? com.google.spanner.v1.RequestOptions.getDefaultInstance()
            : requestOptions_;
      } else {
        return requestOptionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 6;</code>
     */
    public Builder setRequestOptions(com.google.spanner.v1.RequestOptions value) {
      if (requestOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        requestOptions_ = value;
      } else {
        requestOptionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 6;</code>
     */
    public Builder setRequestOptions(com.google.spanner.v1.RequestOptions.Builder builderForValue) {
      if (requestOptionsBuilder_ == null) {
        requestOptions_ = builderForValue.build();
      } else {
        requestOptionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 6;</code>
     */
    public Builder mergeRequestOptions(com.google.spanner.v1.RequestOptions value) {
      if (requestOptionsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && requestOptions_ != null
            && requestOptions_ != com.google.spanner.v1.RequestOptions.getDefaultInstance()) {
          getRequestOptionsBuilder().mergeFrom(value);
        } else {
          requestOptions_ = value;
        }
      } else {
        requestOptionsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 6;</code>
     */
    public Builder clearRequestOptions() {
      bitField0_ = (bitField0_ & ~0x00000020);
      requestOptions_ = null;
      if (requestOptionsBuilder_ != null) {
        requestOptionsBuilder_.dispose();
        requestOptionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 6;</code>
     */
    public com.google.spanner.v1.RequestOptions.Builder getRequestOptionsBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getRequestOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 6;</code>
     */
    public com.google.spanner.v1.RequestOptionsOrBuilder getRequestOptionsOrBuilder() {
      if (requestOptionsBuilder_ != null) {
        return requestOptionsBuilder_.getMessageOrBuilder();
      } else {
        return requestOptions_ == null
            ? com.google.spanner.v1.RequestOptions.getDefaultInstance()
            : requestOptions_;
      }
    }
    /**
     *
     *
     * <pre>
     * Common options for this request.
     * </pre>
     *
     * <code>.google.spanner.v1.RequestOptions request_options = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.RequestOptions,
            com.google.spanner.v1.RequestOptions.Builder,
            com.google.spanner.v1.RequestOptionsOrBuilder>
        getRequestOptionsFieldBuilder() {
      if (requestOptionsBuilder_ == null) {
        requestOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.RequestOptions,
                com.google.spanner.v1.RequestOptions.Builder,
                com.google.spanner.v1.RequestOptionsOrBuilder>(
                getRequestOptions(), getParentForChildren(), isClean());
        requestOptions_ = null;
      }
      return requestOptionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.v1.CommitRequest)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.v1.CommitRequest)
  private static final com.google.spanner.v1.CommitRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.v1.CommitRequest();
  }

  public static com.google.spanner.v1.CommitRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CommitRequest> PARSER =
      new com.google.protobuf.AbstractParser<CommitRequest>() {
        @java.lang.Override
        public CommitRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CommitRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CommitRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.v1.CommitRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
