/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/v1/spanner.proto

// Protobuf Java Version: 3.25.3
package com.google.spanner.v1;

/**
 *
 *
 * <pre>
 * The DirectedReadOptions can be used to indicate which replicas or regions
 * should be used for non-transactional reads or queries.
 *
 * DirectedReadOptions may only be specified for a read-only transaction,
 * otherwise the API will return an `INVALID_ARGUMENT` error.
 * </pre>
 *
 * Protobuf type {@code google.spanner.v1.DirectedReadOptions}
 */
public final class DirectedReadOptions extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.v1.DirectedReadOptions)
    DirectedReadOptionsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DirectedReadOptions.newBuilder() to construct.
  private DirectedReadOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DirectedReadOptions() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DirectedReadOptions();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.v1.SpannerProto
        .internal_static_google_spanner_v1_DirectedReadOptions_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.v1.SpannerProto
        .internal_static_google_spanner_v1_DirectedReadOptions_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.v1.DirectedReadOptions.class,
            com.google.spanner.v1.DirectedReadOptions.Builder.class);
  }

  public interface ReplicaSelectionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.spanner.v1.DirectedReadOptions.ReplicaSelection)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The location or region of the serving requests, e.g. "us-east1".
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The location.
     */
    java.lang.String getLocation();
    /**
     *
     *
     * <pre>
     * The location or region of the serving requests, e.g. "us-east1".
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The bytes for location.
     */
    com.google.protobuf.ByteString getLocationBytes();

    /**
     *
     *
     * <pre>
     * The type of replica.
     * </pre>
     *
     * <code>.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Type type = 2;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    int getTypeValue();
    /**
     *
     *
     * <pre>
     * The type of replica.
     * </pre>
     *
     * <code>.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Type type = 2;</code>
     *
     * @return The type.
     */
    com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Type getType();
  }
  /**
   *
   *
   * <pre>
   * The directed read replica selector.
   * Callers must provide one or more of the following fields for replica
   * selection:
   *
   *   * `location` - The location must be one of the regions within the
   *      multi-region configuration of your database.
   *   * `type` - The type of the replica.
   *
   * Some examples of using replica_selectors are:
   *
   *   * `location:us-east1` --&gt; The "us-east1" replica(s) of any available type
   *                             will be used to process the request.
   *   * `type:READ_ONLY`    --&gt; The "READ_ONLY" type replica(s) in nearest
   *                             available location will be used to process the
   *                             request.
   *   * `location:us-east1 type:READ_ONLY` --&gt; The "READ_ONLY" type replica(s)
   *                          in location "us-east1" will be used to process
   *                          the request.
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.DirectedReadOptions.ReplicaSelection}
   */
  public static final class ReplicaSelection extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.spanner.v1.DirectedReadOptions.ReplicaSelection)
      ReplicaSelectionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ReplicaSelection.newBuilder() to construct.
    private ReplicaSelection(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ReplicaSelection() {
      location_ = "";
      type_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ReplicaSelection();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_DirectedReadOptions_ReplicaSelection_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_DirectedReadOptions_ReplicaSelection_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.class,
              com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Indicates the type of replica.
     * </pre>
     *
     * Protobuf enum {@code google.spanner.v1.DirectedReadOptions.ReplicaSelection.Type}
     */
    public enum Type implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Not specified.
       * </pre>
       *
       * <code>TYPE_UNSPECIFIED = 0;</code>
       */
      TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Read-write replicas support both reads and writes.
       * </pre>
       *
       * <code>READ_WRITE = 1;</code>
       */
      READ_WRITE(1),
      /**
       *
       *
       * <pre>
       * Read-only replicas only support reads (not writes).
       * </pre>
       *
       * <code>READ_ONLY = 2;</code>
       */
      READ_ONLY(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Not specified.
       * </pre>
       *
       * <code>TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int TYPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Read-write replicas support both reads and writes.
       * </pre>
       *
       * <code>READ_WRITE = 1;</code>
       */
      public static final int READ_WRITE_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Read-only replicas only support reads (not writes).
       * </pre>
       *
       * <code>READ_ONLY = 2;</code>
       */
      public static final int READ_ONLY_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Type valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Type forNumber(int value) {
        switch (value) {
          case 0:
            return TYPE_UNSPECIFIED;
          case 1:
            return READ_WRITE;
          case 2:
            return READ_ONLY;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Type>() {
            public Type findValueByNumber(int number) {
              return Type.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Type[] VALUES = values();

      public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Type(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.spanner.v1.DirectedReadOptions.ReplicaSelection.Type)
    }

    public static final int LOCATION_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object location_ = "";
    /**
     *
     *
     * <pre>
     * The location or region of the serving requests, e.g. "us-east1".
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The location.
     */
    @java.lang.Override
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The location or region of the serving requests, e.g. "us-east1".
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The bytes for location.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TYPE_FIELD_NUMBER = 2;
    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * The type of replica.
     * </pre>
     *
     * <code>.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Type type = 2;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * The type of replica.
     * </pre>
     *
     * <code>.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Type type = 2;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Type getType() {
      com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Type result =
          com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Type.forNumber(type_);
      return result == null
          ? com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Type.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, location_);
      }
      if (type_
          != com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Type.TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, type_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, location_);
      }
      if (type_
          != com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Type.TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, type_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.spanner.v1.DirectedReadOptions.ReplicaSelection)) {
        return super.equals(obj);
      }
      com.google.spanner.v1.DirectedReadOptions.ReplicaSelection other =
          (com.google.spanner.v1.DirectedReadOptions.ReplicaSelection) obj;

      if (!getLocation().equals(other.getLocation())) return false;
      if (type_ != other.type_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getLocation().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.spanner.v1.DirectedReadOptions.ReplicaSelection parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.DirectedReadOptions.ReplicaSelection parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.DirectedReadOptions.ReplicaSelection parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.DirectedReadOptions.ReplicaSelection parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.DirectedReadOptions.ReplicaSelection parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.DirectedReadOptions.ReplicaSelection parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.DirectedReadOptions.ReplicaSelection parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.DirectedReadOptions.ReplicaSelection parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.DirectedReadOptions.ReplicaSelection parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.DirectedReadOptions.ReplicaSelection parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.DirectedReadOptions.ReplicaSelection parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.DirectedReadOptions.ReplicaSelection parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.spanner.v1.DirectedReadOptions.ReplicaSelection prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The directed read replica selector.
     * Callers must provide one or more of the following fields for replica
     * selection:
     *
     *   * `location` - The location must be one of the regions within the
     *      multi-region configuration of your database.
     *   * `type` - The type of the replica.
     *
     * Some examples of using replica_selectors are:
     *
     *   * `location:us-east1` --&gt; The "us-east1" replica(s) of any available type
     *                             will be used to process the request.
     *   * `type:READ_ONLY`    --&gt; The "READ_ONLY" type replica(s) in nearest
     *                             available location will be used to process the
     *                             request.
     *   * `location:us-east1 type:READ_ONLY` --&gt; The "READ_ONLY" type replica(s)
     *                          in location "us-east1" will be used to process
     *                          the request.
     * </pre>
     *
     * Protobuf type {@code google.spanner.v1.DirectedReadOptions.ReplicaSelection}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.spanner.v1.DirectedReadOptions.ReplicaSelection)
        com.google.spanner.v1.DirectedReadOptions.ReplicaSelectionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.spanner.v1.SpannerProto
            .internal_static_google_spanner_v1_DirectedReadOptions_ReplicaSelection_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.spanner.v1.SpannerProto
            .internal_static_google_spanner_v1_DirectedReadOptions_ReplicaSelection_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.class,
                com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Builder.class);
      }

      // Construct using com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        location_ = "";
        type_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.spanner.v1.SpannerProto
            .internal_static_google_spanner_v1_DirectedReadOptions_ReplicaSelection_descriptor;
      }

      @java.lang.Override
      public com.google.spanner.v1.DirectedReadOptions.ReplicaSelection
          getDefaultInstanceForType() {
        return com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.spanner.v1.DirectedReadOptions.ReplicaSelection build() {
        com.google.spanner.v1.DirectedReadOptions.ReplicaSelection result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.spanner.v1.DirectedReadOptions.ReplicaSelection buildPartial() {
        com.google.spanner.v1.DirectedReadOptions.ReplicaSelection result =
            new com.google.spanner.v1.DirectedReadOptions.ReplicaSelection(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.spanner.v1.DirectedReadOptions.ReplicaSelection result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.location_ = location_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.type_ = type_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.spanner.v1.DirectedReadOptions.ReplicaSelection) {
          return mergeFrom((com.google.spanner.v1.DirectedReadOptions.ReplicaSelection) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.spanner.v1.DirectedReadOptions.ReplicaSelection other) {
        if (other
            == com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.getDefaultInstance())
          return this;
        if (!other.getLocation().isEmpty()) {
          location_ = other.location_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  location_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  type_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object location_ = "";
      /**
       *
       *
       * <pre>
       * The location or region of the serving requests, e.g. "us-east1".
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @return The location.
       */
      public java.lang.String getLocation() {
        java.lang.Object ref = location_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          location_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The location or region of the serving requests, e.g. "us-east1".
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @return The bytes for location.
       */
      public com.google.protobuf.ByteString getLocationBytes() {
        java.lang.Object ref = location_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          location_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The location or region of the serving requests, e.g. "us-east1".
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @param value The location to set.
       * @return This builder for chaining.
       */
      public Builder setLocation(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        location_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The location or region of the serving requests, e.g. "us-east1".
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLocation() {
        location_ = getDefaultInstance().getLocation();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The location or region of the serving requests, e.g. "us-east1".
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @param value The bytes for location to set.
       * @return This builder for chaining.
       */
      public Builder setLocationBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        location_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int type_ = 0;
      /**
       *
       *
       * <pre>
       * The type of replica.
       * </pre>
       *
       * <code>.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Type type = 2;</code>
       *
       * @return The enum numeric value on the wire for type.
       */
      @java.lang.Override
      public int getTypeValue() {
        return type_;
      }
      /**
       *
       *
       * <pre>
       * The type of replica.
       * </pre>
       *
       * <code>.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Type type = 2;</code>
       *
       * @param value The enum numeric value on the wire for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeValue(int value) {
        type_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The type of replica.
       * </pre>
       *
       * <code>.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Type type = 2;</code>
       *
       * @return The type.
       */
      @java.lang.Override
      public com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Type getType() {
        com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Type result =
            com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Type.forNumber(type_);
        return result == null
            ? com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Type.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The type of replica.
       * </pre>
       *
       * <code>.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Type type = 2;</code>
       *
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(
          com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Type value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The type of replica.
       * </pre>
       *
       * <code>.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Type type = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000002);
        type_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.spanner.v1.DirectedReadOptions.ReplicaSelection)
    }

    // @@protoc_insertion_point(class_scope:google.spanner.v1.DirectedReadOptions.ReplicaSelection)
    private static final com.google.spanner.v1.DirectedReadOptions.ReplicaSelection
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.spanner.v1.DirectedReadOptions.ReplicaSelection();
    }

    public static com.google.spanner.v1.DirectedReadOptions.ReplicaSelection getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ReplicaSelection> PARSER =
        new com.google.protobuf.AbstractParser<ReplicaSelection>() {
          @java.lang.Override
          public ReplicaSelection parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ReplicaSelection> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ReplicaSelection> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.spanner.v1.DirectedReadOptions.ReplicaSelection getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface IncludeReplicasOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.spanner.v1.DirectedReadOptions.IncludeReplicas)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The directed read replica selector.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
     * </code>
     */
    java.util.List<com.google.spanner.v1.DirectedReadOptions.ReplicaSelection>
        getReplicaSelectionsList();
    /**
     *
     *
     * <pre>
     * The directed read replica selector.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
     * </code>
     */
    com.google.spanner.v1.DirectedReadOptions.ReplicaSelection getReplicaSelections(int index);
    /**
     *
     *
     * <pre>
     * The directed read replica selector.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
     * </code>
     */
    int getReplicaSelectionsCount();
    /**
     *
     *
     * <pre>
     * The directed read replica selector.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
     * </code>
     */
    java.util.List<? extends com.google.spanner.v1.DirectedReadOptions.ReplicaSelectionOrBuilder>
        getReplicaSelectionsOrBuilderList();
    /**
     *
     *
     * <pre>
     * The directed read replica selector.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
     * </code>
     */
    com.google.spanner.v1.DirectedReadOptions.ReplicaSelectionOrBuilder
        getReplicaSelectionsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * If true, Spanner will not route requests to a replica outside the
     * include_replicas list when all of the specified replicas are unavailable
     * or unhealthy. Default value is `false`.
     * </pre>
     *
     * <code>bool auto_failover_disabled = 2;</code>
     *
     * @return The autoFailoverDisabled.
     */
    boolean getAutoFailoverDisabled();
  }
  /**
   *
   *
   * <pre>
   * An IncludeReplicas contains a repeated set of ReplicaSelection which
   * indicates the order in which replicas should be considered.
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.DirectedReadOptions.IncludeReplicas}
   */
  public static final class IncludeReplicas extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.spanner.v1.DirectedReadOptions.IncludeReplicas)
      IncludeReplicasOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use IncludeReplicas.newBuilder() to construct.
    private IncludeReplicas(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private IncludeReplicas() {
      replicaSelections_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new IncludeReplicas();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_DirectedReadOptions_IncludeReplicas_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_DirectedReadOptions_IncludeReplicas_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.DirectedReadOptions.IncludeReplicas.class,
              com.google.spanner.v1.DirectedReadOptions.IncludeReplicas.Builder.class);
    }

    public static final int REPLICA_SELECTIONS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.spanner.v1.DirectedReadOptions.ReplicaSelection>
        replicaSelections_;
    /**
     *
     *
     * <pre>
     * The directed read replica selector.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.spanner.v1.DirectedReadOptions.ReplicaSelection>
        getReplicaSelectionsList() {
      return replicaSelections_;
    }
    /**
     *
     *
     * <pre>
     * The directed read replica selector.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.spanner.v1.DirectedReadOptions.ReplicaSelectionOrBuilder>
        getReplicaSelectionsOrBuilderList() {
      return replicaSelections_;
    }
    /**
     *
     *
     * <pre>
     * The directed read replica selector.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
     * </code>
     */
    @java.lang.Override
    public int getReplicaSelectionsCount() {
      return replicaSelections_.size();
    }
    /**
     *
     *
     * <pre>
     * The directed read replica selector.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.spanner.v1.DirectedReadOptions.ReplicaSelection getReplicaSelections(
        int index) {
      return replicaSelections_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The directed read replica selector.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.spanner.v1.DirectedReadOptions.ReplicaSelectionOrBuilder
        getReplicaSelectionsOrBuilder(int index) {
      return replicaSelections_.get(index);
    }

    public static final int AUTO_FAILOVER_DISABLED_FIELD_NUMBER = 2;
    private boolean autoFailoverDisabled_ = false;
    /**
     *
     *
     * <pre>
     * If true, Spanner will not route requests to a replica outside the
     * include_replicas list when all of the specified replicas are unavailable
     * or unhealthy. Default value is `false`.
     * </pre>
     *
     * <code>bool auto_failover_disabled = 2;</code>
     *
     * @return The autoFailoverDisabled.
     */
    @java.lang.Override
    public boolean getAutoFailoverDisabled() {
      return autoFailoverDisabled_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < replicaSelections_.size(); i++) {
        output.writeMessage(1, replicaSelections_.get(i));
      }
      if (autoFailoverDisabled_ != false) {
        output.writeBool(2, autoFailoverDisabled_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < replicaSelections_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(1, replicaSelections_.get(i));
      }
      if (autoFailoverDisabled_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, autoFailoverDisabled_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.spanner.v1.DirectedReadOptions.IncludeReplicas)) {
        return super.equals(obj);
      }
      com.google.spanner.v1.DirectedReadOptions.IncludeReplicas other =
          (com.google.spanner.v1.DirectedReadOptions.IncludeReplicas) obj;

      if (!getReplicaSelectionsList().equals(other.getReplicaSelectionsList())) return false;
      if (getAutoFailoverDisabled() != other.getAutoFailoverDisabled()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getReplicaSelectionsCount() > 0) {
        hash = (37 * hash) + REPLICA_SELECTIONS_FIELD_NUMBER;
        hash = (53 * hash) + getReplicaSelectionsList().hashCode();
      }
      hash = (37 * hash) + AUTO_FAILOVER_DISABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAutoFailoverDisabled());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.spanner.v1.DirectedReadOptions.IncludeReplicas parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.DirectedReadOptions.IncludeReplicas parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.DirectedReadOptions.IncludeReplicas parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.DirectedReadOptions.IncludeReplicas parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.DirectedReadOptions.IncludeReplicas parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.DirectedReadOptions.IncludeReplicas parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.DirectedReadOptions.IncludeReplicas parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.DirectedReadOptions.IncludeReplicas parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.DirectedReadOptions.IncludeReplicas parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.DirectedReadOptions.IncludeReplicas parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.DirectedReadOptions.IncludeReplicas parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.DirectedReadOptions.IncludeReplicas parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.spanner.v1.DirectedReadOptions.IncludeReplicas prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * An IncludeReplicas contains a repeated set of ReplicaSelection which
     * indicates the order in which replicas should be considered.
     * </pre>
     *
     * Protobuf type {@code google.spanner.v1.DirectedReadOptions.IncludeReplicas}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.spanner.v1.DirectedReadOptions.IncludeReplicas)
        com.google.spanner.v1.DirectedReadOptions.IncludeReplicasOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.spanner.v1.SpannerProto
            .internal_static_google_spanner_v1_DirectedReadOptions_IncludeReplicas_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.spanner.v1.SpannerProto
            .internal_static_google_spanner_v1_DirectedReadOptions_IncludeReplicas_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.spanner.v1.DirectedReadOptions.IncludeReplicas.class,
                com.google.spanner.v1.DirectedReadOptions.IncludeReplicas.Builder.class);
      }

      // Construct using com.google.spanner.v1.DirectedReadOptions.IncludeReplicas.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (replicaSelectionsBuilder_ == null) {
          replicaSelections_ = java.util.Collections.emptyList();
        } else {
          replicaSelections_ = null;
          replicaSelectionsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        autoFailoverDisabled_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.spanner.v1.SpannerProto
            .internal_static_google_spanner_v1_DirectedReadOptions_IncludeReplicas_descriptor;
      }

      @java.lang.Override
      public com.google.spanner.v1.DirectedReadOptions.IncludeReplicas getDefaultInstanceForType() {
        return com.google.spanner.v1.DirectedReadOptions.IncludeReplicas.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.spanner.v1.DirectedReadOptions.IncludeReplicas build() {
        com.google.spanner.v1.DirectedReadOptions.IncludeReplicas result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.spanner.v1.DirectedReadOptions.IncludeReplicas buildPartial() {
        com.google.spanner.v1.DirectedReadOptions.IncludeReplicas result =
            new com.google.spanner.v1.DirectedReadOptions.IncludeReplicas(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.spanner.v1.DirectedReadOptions.IncludeReplicas result) {
        if (replicaSelectionsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            replicaSelections_ = java.util.Collections.unmodifiableList(replicaSelections_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.replicaSelections_ = replicaSelections_;
        } else {
          result.replicaSelections_ = replicaSelectionsBuilder_.build();
        }
      }

      private void buildPartial0(com.google.spanner.v1.DirectedReadOptions.IncludeReplicas result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.autoFailoverDisabled_ = autoFailoverDisabled_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.spanner.v1.DirectedReadOptions.IncludeReplicas) {
          return mergeFrom((com.google.spanner.v1.DirectedReadOptions.IncludeReplicas) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.spanner.v1.DirectedReadOptions.IncludeReplicas other) {
        if (other == com.google.spanner.v1.DirectedReadOptions.IncludeReplicas.getDefaultInstance())
          return this;
        if (replicaSelectionsBuilder_ == null) {
          if (!other.replicaSelections_.isEmpty()) {
            if (replicaSelections_.isEmpty()) {
              replicaSelections_ = other.replicaSelections_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureReplicaSelectionsIsMutable();
              replicaSelections_.addAll(other.replicaSelections_);
            }
            onChanged();
          }
        } else {
          if (!other.replicaSelections_.isEmpty()) {
            if (replicaSelectionsBuilder_.isEmpty()) {
              replicaSelectionsBuilder_.dispose();
              replicaSelectionsBuilder_ = null;
              replicaSelections_ = other.replicaSelections_;
              bitField0_ = (bitField0_ & ~0x00000001);
              replicaSelectionsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getReplicaSelectionsFieldBuilder()
                      : null;
            } else {
              replicaSelectionsBuilder_.addAllMessages(other.replicaSelections_);
            }
          }
        }
        if (other.getAutoFailoverDisabled() != false) {
          setAutoFailoverDisabled(other.getAutoFailoverDisabled());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.spanner.v1.DirectedReadOptions.ReplicaSelection m =
                      input.readMessage(
                          com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.parser(),
                          extensionRegistry);
                  if (replicaSelectionsBuilder_ == null) {
                    ensureReplicaSelectionsIsMutable();
                    replicaSelections_.add(m);
                  } else {
                    replicaSelectionsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 16:
                {
                  autoFailoverDisabled_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.spanner.v1.DirectedReadOptions.ReplicaSelection>
          replicaSelections_ = java.util.Collections.emptyList();

      private void ensureReplicaSelectionsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          replicaSelections_ =
              new java.util.ArrayList<com.google.spanner.v1.DirectedReadOptions.ReplicaSelection>(
                  replicaSelections_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.spanner.v1.DirectedReadOptions.ReplicaSelection,
              com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Builder,
              com.google.spanner.v1.DirectedReadOptions.ReplicaSelectionOrBuilder>
          replicaSelectionsBuilder_;

      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public java.util.List<com.google.spanner.v1.DirectedReadOptions.ReplicaSelection>
          getReplicaSelectionsList() {
        if (replicaSelectionsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(replicaSelections_);
        } else {
          return replicaSelectionsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public int getReplicaSelectionsCount() {
        if (replicaSelectionsBuilder_ == null) {
          return replicaSelections_.size();
        } else {
          return replicaSelectionsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public com.google.spanner.v1.DirectedReadOptions.ReplicaSelection getReplicaSelections(
          int index) {
        if (replicaSelectionsBuilder_ == null) {
          return replicaSelections_.get(index);
        } else {
          return replicaSelectionsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public Builder setReplicaSelections(
          int index, com.google.spanner.v1.DirectedReadOptions.ReplicaSelection value) {
        if (replicaSelectionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureReplicaSelectionsIsMutable();
          replicaSelections_.set(index, value);
          onChanged();
        } else {
          replicaSelectionsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public Builder setReplicaSelections(
          int index,
          com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Builder builderForValue) {
        if (replicaSelectionsBuilder_ == null) {
          ensureReplicaSelectionsIsMutable();
          replicaSelections_.set(index, builderForValue.build());
          onChanged();
        } else {
          replicaSelectionsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public Builder addReplicaSelections(
          com.google.spanner.v1.DirectedReadOptions.ReplicaSelection value) {
        if (replicaSelectionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureReplicaSelectionsIsMutable();
          replicaSelections_.add(value);
          onChanged();
        } else {
          replicaSelectionsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public Builder addReplicaSelections(
          int index, com.google.spanner.v1.DirectedReadOptions.ReplicaSelection value) {
        if (replicaSelectionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureReplicaSelectionsIsMutable();
          replicaSelections_.add(index, value);
          onChanged();
        } else {
          replicaSelectionsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public Builder addReplicaSelections(
          com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Builder builderForValue) {
        if (replicaSelectionsBuilder_ == null) {
          ensureReplicaSelectionsIsMutable();
          replicaSelections_.add(builderForValue.build());
          onChanged();
        } else {
          replicaSelectionsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public Builder addReplicaSelections(
          int index,
          com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Builder builderForValue) {
        if (replicaSelectionsBuilder_ == null) {
          ensureReplicaSelectionsIsMutable();
          replicaSelections_.add(index, builderForValue.build());
          onChanged();
        } else {
          replicaSelectionsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public Builder addAllReplicaSelections(
          java.lang.Iterable<? extends com.google.spanner.v1.DirectedReadOptions.ReplicaSelection>
              values) {
        if (replicaSelectionsBuilder_ == null) {
          ensureReplicaSelectionsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, replicaSelections_);
          onChanged();
        } else {
          replicaSelectionsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public Builder clearReplicaSelections() {
        if (replicaSelectionsBuilder_ == null) {
          replicaSelections_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          replicaSelectionsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public Builder removeReplicaSelections(int index) {
        if (replicaSelectionsBuilder_ == null) {
          ensureReplicaSelectionsIsMutable();
          replicaSelections_.remove(index);
          onChanged();
        } else {
          replicaSelectionsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Builder
          getReplicaSelectionsBuilder(int index) {
        return getReplicaSelectionsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public com.google.spanner.v1.DirectedReadOptions.ReplicaSelectionOrBuilder
          getReplicaSelectionsOrBuilder(int index) {
        if (replicaSelectionsBuilder_ == null) {
          return replicaSelections_.get(index);
        } else {
          return replicaSelectionsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public java.util.List<
              ? extends com.google.spanner.v1.DirectedReadOptions.ReplicaSelectionOrBuilder>
          getReplicaSelectionsOrBuilderList() {
        if (replicaSelectionsBuilder_ != null) {
          return replicaSelectionsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(replicaSelections_);
        }
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Builder
          addReplicaSelectionsBuilder() {
        return getReplicaSelectionsFieldBuilder()
            .addBuilder(
                com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Builder
          addReplicaSelectionsBuilder(int index) {
        return getReplicaSelectionsFieldBuilder()
            .addBuilder(
                index,
                com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public java.util.List<com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Builder>
          getReplicaSelectionsBuilderList() {
        return getReplicaSelectionsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.spanner.v1.DirectedReadOptions.ReplicaSelection,
              com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Builder,
              com.google.spanner.v1.DirectedReadOptions.ReplicaSelectionOrBuilder>
          getReplicaSelectionsFieldBuilder() {
        if (replicaSelectionsBuilder_ == null) {
          replicaSelectionsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.spanner.v1.DirectedReadOptions.ReplicaSelection,
                  com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Builder,
                  com.google.spanner.v1.DirectedReadOptions.ReplicaSelectionOrBuilder>(
                  replicaSelections_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          replicaSelections_ = null;
        }
        return replicaSelectionsBuilder_;
      }

      private boolean autoFailoverDisabled_;
      /**
       *
       *
       * <pre>
       * If true, Spanner will not route requests to a replica outside the
       * include_replicas list when all of the specified replicas are unavailable
       * or unhealthy. Default value is `false`.
       * </pre>
       *
       * <code>bool auto_failover_disabled = 2;</code>
       *
       * @return The autoFailoverDisabled.
       */
      @java.lang.Override
      public boolean getAutoFailoverDisabled() {
        return autoFailoverDisabled_;
      }
      /**
       *
       *
       * <pre>
       * If true, Spanner will not route requests to a replica outside the
       * include_replicas list when all of the specified replicas are unavailable
       * or unhealthy. Default value is `false`.
       * </pre>
       *
       * <code>bool auto_failover_disabled = 2;</code>
       *
       * @param value The autoFailoverDisabled to set.
       * @return This builder for chaining.
       */
      public Builder setAutoFailoverDisabled(boolean value) {

        autoFailoverDisabled_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If true, Spanner will not route requests to a replica outside the
       * include_replicas list when all of the specified replicas are unavailable
       * or unhealthy. Default value is `false`.
       * </pre>
       *
       * <code>bool auto_failover_disabled = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAutoFailoverDisabled() {
        bitField0_ = (bitField0_ & ~0x00000002);
        autoFailoverDisabled_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.spanner.v1.DirectedReadOptions.IncludeReplicas)
    }

    // @@protoc_insertion_point(class_scope:google.spanner.v1.DirectedReadOptions.IncludeReplicas)
    private static final com.google.spanner.v1.DirectedReadOptions.IncludeReplicas DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.spanner.v1.DirectedReadOptions.IncludeReplicas();
    }

    public static com.google.spanner.v1.DirectedReadOptions.IncludeReplicas getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<IncludeReplicas> PARSER =
        new com.google.protobuf.AbstractParser<IncludeReplicas>() {
          @java.lang.Override
          public IncludeReplicas parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<IncludeReplicas> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IncludeReplicas> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.spanner.v1.DirectedReadOptions.IncludeReplicas getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ExcludeReplicasOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.spanner.v1.DirectedReadOptions.ExcludeReplicas)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The directed read replica selector.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
     * </code>
     */
    java.util.List<com.google.spanner.v1.DirectedReadOptions.ReplicaSelection>
        getReplicaSelectionsList();
    /**
     *
     *
     * <pre>
     * The directed read replica selector.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
     * </code>
     */
    com.google.spanner.v1.DirectedReadOptions.ReplicaSelection getReplicaSelections(int index);
    /**
     *
     *
     * <pre>
     * The directed read replica selector.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
     * </code>
     */
    int getReplicaSelectionsCount();
    /**
     *
     *
     * <pre>
     * The directed read replica selector.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
     * </code>
     */
    java.util.List<? extends com.google.spanner.v1.DirectedReadOptions.ReplicaSelectionOrBuilder>
        getReplicaSelectionsOrBuilderList();
    /**
     *
     *
     * <pre>
     * The directed read replica selector.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
     * </code>
     */
    com.google.spanner.v1.DirectedReadOptions.ReplicaSelectionOrBuilder
        getReplicaSelectionsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * An ExcludeReplicas contains a repeated set of ReplicaSelection that should
   * be excluded from serving requests.
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.DirectedReadOptions.ExcludeReplicas}
   */
  public static final class ExcludeReplicas extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.spanner.v1.DirectedReadOptions.ExcludeReplicas)
      ExcludeReplicasOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ExcludeReplicas.newBuilder() to construct.
    private ExcludeReplicas(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ExcludeReplicas() {
      replicaSelections_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ExcludeReplicas();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_DirectedReadOptions_ExcludeReplicas_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_DirectedReadOptions_ExcludeReplicas_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas.class,
              com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas.Builder.class);
    }

    public static final int REPLICA_SELECTIONS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.spanner.v1.DirectedReadOptions.ReplicaSelection>
        replicaSelections_;
    /**
     *
     *
     * <pre>
     * The directed read replica selector.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.spanner.v1.DirectedReadOptions.ReplicaSelection>
        getReplicaSelectionsList() {
      return replicaSelections_;
    }
    /**
     *
     *
     * <pre>
     * The directed read replica selector.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.spanner.v1.DirectedReadOptions.ReplicaSelectionOrBuilder>
        getReplicaSelectionsOrBuilderList() {
      return replicaSelections_;
    }
    /**
     *
     *
     * <pre>
     * The directed read replica selector.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
     * </code>
     */
    @java.lang.Override
    public int getReplicaSelectionsCount() {
      return replicaSelections_.size();
    }
    /**
     *
     *
     * <pre>
     * The directed read replica selector.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.spanner.v1.DirectedReadOptions.ReplicaSelection getReplicaSelections(
        int index) {
      return replicaSelections_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The directed read replica selector.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.spanner.v1.DirectedReadOptions.ReplicaSelectionOrBuilder
        getReplicaSelectionsOrBuilder(int index) {
      return replicaSelections_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < replicaSelections_.size(); i++) {
        output.writeMessage(1, replicaSelections_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < replicaSelections_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(1, replicaSelections_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas)) {
        return super.equals(obj);
      }
      com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas other =
          (com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas) obj;

      if (!getReplicaSelectionsList().equals(other.getReplicaSelectionsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getReplicaSelectionsCount() > 0) {
        hash = (37 * hash) + REPLICA_SELECTIONS_FIELD_NUMBER;
        hash = (53 * hash) + getReplicaSelectionsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * An ExcludeReplicas contains a repeated set of ReplicaSelection that should
     * be excluded from serving requests.
     * </pre>
     *
     * Protobuf type {@code google.spanner.v1.DirectedReadOptions.ExcludeReplicas}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.spanner.v1.DirectedReadOptions.ExcludeReplicas)
        com.google.spanner.v1.DirectedReadOptions.ExcludeReplicasOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.spanner.v1.SpannerProto
            .internal_static_google_spanner_v1_DirectedReadOptions_ExcludeReplicas_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.spanner.v1.SpannerProto
            .internal_static_google_spanner_v1_DirectedReadOptions_ExcludeReplicas_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas.class,
                com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas.Builder.class);
      }

      // Construct using com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (replicaSelectionsBuilder_ == null) {
          replicaSelections_ = java.util.Collections.emptyList();
        } else {
          replicaSelections_ = null;
          replicaSelectionsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.spanner.v1.SpannerProto
            .internal_static_google_spanner_v1_DirectedReadOptions_ExcludeReplicas_descriptor;
      }

      @java.lang.Override
      public com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas getDefaultInstanceForType() {
        return com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas build() {
        com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas buildPartial() {
        com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas result =
            new com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas result) {
        if (replicaSelectionsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            replicaSelections_ = java.util.Collections.unmodifiableList(replicaSelections_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.replicaSelections_ = replicaSelections_;
        } else {
          result.replicaSelections_ = replicaSelectionsBuilder_.build();
        }
      }

      private void buildPartial0(com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas) {
          return mergeFrom((com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas other) {
        if (other == com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas.getDefaultInstance())
          return this;
        if (replicaSelectionsBuilder_ == null) {
          if (!other.replicaSelections_.isEmpty()) {
            if (replicaSelections_.isEmpty()) {
              replicaSelections_ = other.replicaSelections_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureReplicaSelectionsIsMutable();
              replicaSelections_.addAll(other.replicaSelections_);
            }
            onChanged();
          }
        } else {
          if (!other.replicaSelections_.isEmpty()) {
            if (replicaSelectionsBuilder_.isEmpty()) {
              replicaSelectionsBuilder_.dispose();
              replicaSelectionsBuilder_ = null;
              replicaSelections_ = other.replicaSelections_;
              bitField0_ = (bitField0_ & ~0x00000001);
              replicaSelectionsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getReplicaSelectionsFieldBuilder()
                      : null;
            } else {
              replicaSelectionsBuilder_.addAllMessages(other.replicaSelections_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.spanner.v1.DirectedReadOptions.ReplicaSelection m =
                      input.readMessage(
                          com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.parser(),
                          extensionRegistry);
                  if (replicaSelectionsBuilder_ == null) {
                    ensureReplicaSelectionsIsMutable();
                    replicaSelections_.add(m);
                  } else {
                    replicaSelectionsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.spanner.v1.DirectedReadOptions.ReplicaSelection>
          replicaSelections_ = java.util.Collections.emptyList();

      private void ensureReplicaSelectionsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          replicaSelections_ =
              new java.util.ArrayList<com.google.spanner.v1.DirectedReadOptions.ReplicaSelection>(
                  replicaSelections_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.spanner.v1.DirectedReadOptions.ReplicaSelection,
              com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Builder,
              com.google.spanner.v1.DirectedReadOptions.ReplicaSelectionOrBuilder>
          replicaSelectionsBuilder_;

      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public java.util.List<com.google.spanner.v1.DirectedReadOptions.ReplicaSelection>
          getReplicaSelectionsList() {
        if (replicaSelectionsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(replicaSelections_);
        } else {
          return replicaSelectionsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public int getReplicaSelectionsCount() {
        if (replicaSelectionsBuilder_ == null) {
          return replicaSelections_.size();
        } else {
          return replicaSelectionsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public com.google.spanner.v1.DirectedReadOptions.ReplicaSelection getReplicaSelections(
          int index) {
        if (replicaSelectionsBuilder_ == null) {
          return replicaSelections_.get(index);
        } else {
          return replicaSelectionsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public Builder setReplicaSelections(
          int index, com.google.spanner.v1.DirectedReadOptions.ReplicaSelection value) {
        if (replicaSelectionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureReplicaSelectionsIsMutable();
          replicaSelections_.set(index, value);
          onChanged();
        } else {
          replicaSelectionsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public Builder setReplicaSelections(
          int index,
          com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Builder builderForValue) {
        if (replicaSelectionsBuilder_ == null) {
          ensureReplicaSelectionsIsMutable();
          replicaSelections_.set(index, builderForValue.build());
          onChanged();
        } else {
          replicaSelectionsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public Builder addReplicaSelections(
          com.google.spanner.v1.DirectedReadOptions.ReplicaSelection value) {
        if (replicaSelectionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureReplicaSelectionsIsMutable();
          replicaSelections_.add(value);
          onChanged();
        } else {
          replicaSelectionsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public Builder addReplicaSelections(
          int index, com.google.spanner.v1.DirectedReadOptions.ReplicaSelection value) {
        if (replicaSelectionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureReplicaSelectionsIsMutable();
          replicaSelections_.add(index, value);
          onChanged();
        } else {
          replicaSelectionsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public Builder addReplicaSelections(
          com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Builder builderForValue) {
        if (replicaSelectionsBuilder_ == null) {
          ensureReplicaSelectionsIsMutable();
          replicaSelections_.add(builderForValue.build());
          onChanged();
        } else {
          replicaSelectionsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public Builder addReplicaSelections(
          int index,
          com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Builder builderForValue) {
        if (replicaSelectionsBuilder_ == null) {
          ensureReplicaSelectionsIsMutable();
          replicaSelections_.add(index, builderForValue.build());
          onChanged();
        } else {
          replicaSelectionsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public Builder addAllReplicaSelections(
          java.lang.Iterable<? extends com.google.spanner.v1.DirectedReadOptions.ReplicaSelection>
              values) {
        if (replicaSelectionsBuilder_ == null) {
          ensureReplicaSelectionsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, replicaSelections_);
          onChanged();
        } else {
          replicaSelectionsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public Builder clearReplicaSelections() {
        if (replicaSelectionsBuilder_ == null) {
          replicaSelections_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          replicaSelectionsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public Builder removeReplicaSelections(int index) {
        if (replicaSelectionsBuilder_ == null) {
          ensureReplicaSelectionsIsMutable();
          replicaSelections_.remove(index);
          onChanged();
        } else {
          replicaSelectionsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Builder
          getReplicaSelectionsBuilder(int index) {
        return getReplicaSelectionsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public com.google.spanner.v1.DirectedReadOptions.ReplicaSelectionOrBuilder
          getReplicaSelectionsOrBuilder(int index) {
        if (replicaSelectionsBuilder_ == null) {
          return replicaSelections_.get(index);
        } else {
          return replicaSelectionsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public java.util.List<
              ? extends com.google.spanner.v1.DirectedReadOptions.ReplicaSelectionOrBuilder>
          getReplicaSelectionsOrBuilderList() {
        if (replicaSelectionsBuilder_ != null) {
          return replicaSelectionsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(replicaSelections_);
        }
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Builder
          addReplicaSelectionsBuilder() {
        return getReplicaSelectionsFieldBuilder()
            .addBuilder(
                com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Builder
          addReplicaSelectionsBuilder(int index) {
        return getReplicaSelectionsFieldBuilder()
            .addBuilder(
                index,
                com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The directed read replica selector.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.DirectedReadOptions.ReplicaSelection replica_selections = 1;
       * </code>
       */
      public java.util.List<com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Builder>
          getReplicaSelectionsBuilderList() {
        return getReplicaSelectionsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.spanner.v1.DirectedReadOptions.ReplicaSelection,
              com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Builder,
              com.google.spanner.v1.DirectedReadOptions.ReplicaSelectionOrBuilder>
          getReplicaSelectionsFieldBuilder() {
        if (replicaSelectionsBuilder_ == null) {
          replicaSelectionsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.spanner.v1.DirectedReadOptions.ReplicaSelection,
                  com.google.spanner.v1.DirectedReadOptions.ReplicaSelection.Builder,
                  com.google.spanner.v1.DirectedReadOptions.ReplicaSelectionOrBuilder>(
                  replicaSelections_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          replicaSelections_ = null;
        }
        return replicaSelectionsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.spanner.v1.DirectedReadOptions.ExcludeReplicas)
    }

    // @@protoc_insertion_point(class_scope:google.spanner.v1.DirectedReadOptions.ExcludeReplicas)
    private static final com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas();
    }

    public static com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ExcludeReplicas> PARSER =
        new com.google.protobuf.AbstractParser<ExcludeReplicas>() {
          @java.lang.Override
          public ExcludeReplicas parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ExcludeReplicas> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ExcludeReplicas> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int replicasCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object replicas_;

  public enum ReplicasCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    INCLUDE_REPLICAS(1),
    EXCLUDE_REPLICAS(2),
    REPLICAS_NOT_SET(0);
    private final int value;

    private ReplicasCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ReplicasCase valueOf(int value) {
      return forNumber(value);
    }

    public static ReplicasCase forNumber(int value) {
      switch (value) {
        case 1:
          return INCLUDE_REPLICAS;
        case 2:
          return EXCLUDE_REPLICAS;
        case 0:
          return REPLICAS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ReplicasCase getReplicasCase() {
    return ReplicasCase.forNumber(replicasCase_);
  }

  public static final int INCLUDE_REPLICAS_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Include_replicas indicates the order of replicas (as they appear in
   * this list) to process the request. If auto_failover_disabled is set to
   * true and all replicas are exhausted without finding a healthy replica,
   * Spanner will wait for a replica in the list to become available, requests
   * may fail due to `DEADLINE_EXCEEDED` errors.
   * </pre>
   *
   * <code>.google.spanner.v1.DirectedReadOptions.IncludeReplicas include_replicas = 1;</code>
   *
   * @return Whether the includeReplicas field is set.
   */
  @java.lang.Override
  public boolean hasIncludeReplicas() {
    return replicasCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Include_replicas indicates the order of replicas (as they appear in
   * this list) to process the request. If auto_failover_disabled is set to
   * true and all replicas are exhausted without finding a healthy replica,
   * Spanner will wait for a replica in the list to become available, requests
   * may fail due to `DEADLINE_EXCEEDED` errors.
   * </pre>
   *
   * <code>.google.spanner.v1.DirectedReadOptions.IncludeReplicas include_replicas = 1;</code>
   *
   * @return The includeReplicas.
   */
  @java.lang.Override
  public com.google.spanner.v1.DirectedReadOptions.IncludeReplicas getIncludeReplicas() {
    if (replicasCase_ == 1) {
      return (com.google.spanner.v1.DirectedReadOptions.IncludeReplicas) replicas_;
    }
    return com.google.spanner.v1.DirectedReadOptions.IncludeReplicas.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Include_replicas indicates the order of replicas (as they appear in
   * this list) to process the request. If auto_failover_disabled is set to
   * true and all replicas are exhausted without finding a healthy replica,
   * Spanner will wait for a replica in the list to become available, requests
   * may fail due to `DEADLINE_EXCEEDED` errors.
   * </pre>
   *
   * <code>.google.spanner.v1.DirectedReadOptions.IncludeReplicas include_replicas = 1;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.DirectedReadOptions.IncludeReplicasOrBuilder
      getIncludeReplicasOrBuilder() {
    if (replicasCase_ == 1) {
      return (com.google.spanner.v1.DirectedReadOptions.IncludeReplicas) replicas_;
    }
    return com.google.spanner.v1.DirectedReadOptions.IncludeReplicas.getDefaultInstance();
  }

  public static final int EXCLUDE_REPLICAS_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Exclude_replicas indicates that specified replicas should be excluded
   * from serving requests. Spanner will not route requests to the replicas
   * in this list.
   * </pre>
   *
   * <code>.google.spanner.v1.DirectedReadOptions.ExcludeReplicas exclude_replicas = 2;</code>
   *
   * @return Whether the excludeReplicas field is set.
   */
  @java.lang.Override
  public boolean hasExcludeReplicas() {
    return replicasCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Exclude_replicas indicates that specified replicas should be excluded
   * from serving requests. Spanner will not route requests to the replicas
   * in this list.
   * </pre>
   *
   * <code>.google.spanner.v1.DirectedReadOptions.ExcludeReplicas exclude_replicas = 2;</code>
   *
   * @return The excludeReplicas.
   */
  @java.lang.Override
  public com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas getExcludeReplicas() {
    if (replicasCase_ == 2) {
      return (com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas) replicas_;
    }
    return com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Exclude_replicas indicates that specified replicas should be excluded
   * from serving requests. Spanner will not route requests to the replicas
   * in this list.
   * </pre>
   *
   * <code>.google.spanner.v1.DirectedReadOptions.ExcludeReplicas exclude_replicas = 2;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.DirectedReadOptions.ExcludeReplicasOrBuilder
      getExcludeReplicasOrBuilder() {
    if (replicasCase_ == 2) {
      return (com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas) replicas_;
    }
    return com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (replicasCase_ == 1) {
      output.writeMessage(1, (com.google.spanner.v1.DirectedReadOptions.IncludeReplicas) replicas_);
    }
    if (replicasCase_ == 2) {
      output.writeMessage(2, (com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas) replicas_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (replicasCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.spanner.v1.DirectedReadOptions.IncludeReplicas) replicas_);
    }
    if (replicasCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas) replicas_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.v1.DirectedReadOptions)) {
      return super.equals(obj);
    }
    com.google.spanner.v1.DirectedReadOptions other =
        (com.google.spanner.v1.DirectedReadOptions) obj;

    if (!getReplicasCase().equals(other.getReplicasCase())) return false;
    switch (replicasCase_) {
      case 1:
        if (!getIncludeReplicas().equals(other.getIncludeReplicas())) return false;
        break;
      case 2:
        if (!getExcludeReplicas().equals(other.getExcludeReplicas())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (replicasCase_) {
      case 1:
        hash = (37 * hash) + INCLUDE_REPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + getIncludeReplicas().hashCode();
        break;
      case 2:
        hash = (37 * hash) + EXCLUDE_REPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + getExcludeReplicas().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.v1.DirectedReadOptions parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.DirectedReadOptions parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.DirectedReadOptions parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.DirectedReadOptions parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.DirectedReadOptions parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.DirectedReadOptions parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.DirectedReadOptions parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.DirectedReadOptions parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.DirectedReadOptions parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.DirectedReadOptions parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.DirectedReadOptions parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.DirectedReadOptions parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.v1.DirectedReadOptions prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The DirectedReadOptions can be used to indicate which replicas or regions
   * should be used for non-transactional reads or queries.
   *
   * DirectedReadOptions may only be specified for a read-only transaction,
   * otherwise the API will return an `INVALID_ARGUMENT` error.
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.DirectedReadOptions}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.v1.DirectedReadOptions)
      com.google.spanner.v1.DirectedReadOptionsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_DirectedReadOptions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_DirectedReadOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.DirectedReadOptions.class,
              com.google.spanner.v1.DirectedReadOptions.Builder.class);
    }

    // Construct using com.google.spanner.v1.DirectedReadOptions.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (includeReplicasBuilder_ != null) {
        includeReplicasBuilder_.clear();
      }
      if (excludeReplicasBuilder_ != null) {
        excludeReplicasBuilder_.clear();
      }
      replicasCase_ = 0;
      replicas_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_DirectedReadOptions_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.v1.DirectedReadOptions getDefaultInstanceForType() {
      return com.google.spanner.v1.DirectedReadOptions.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.v1.DirectedReadOptions build() {
      com.google.spanner.v1.DirectedReadOptions result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.v1.DirectedReadOptions buildPartial() {
      com.google.spanner.v1.DirectedReadOptions result =
          new com.google.spanner.v1.DirectedReadOptions(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.v1.DirectedReadOptions result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.spanner.v1.DirectedReadOptions result) {
      result.replicasCase_ = replicasCase_;
      result.replicas_ = this.replicas_;
      if (replicasCase_ == 1 && includeReplicasBuilder_ != null) {
        result.replicas_ = includeReplicasBuilder_.build();
      }
      if (replicasCase_ == 2 && excludeReplicasBuilder_ != null) {
        result.replicas_ = excludeReplicasBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.v1.DirectedReadOptions) {
        return mergeFrom((com.google.spanner.v1.DirectedReadOptions) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.v1.DirectedReadOptions other) {
      if (other == com.google.spanner.v1.DirectedReadOptions.getDefaultInstance()) return this;
      switch (other.getReplicasCase()) {
        case INCLUDE_REPLICAS:
          {
            mergeIncludeReplicas(other.getIncludeReplicas());
            break;
          }
        case EXCLUDE_REPLICAS:
          {
            mergeExcludeReplicas(other.getExcludeReplicas());
            break;
          }
        case REPLICAS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getIncludeReplicasFieldBuilder().getBuilder(), extensionRegistry);
                replicasCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getExcludeReplicasFieldBuilder().getBuilder(), extensionRegistry);
                replicasCase_ = 2;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int replicasCase_ = 0;
    private java.lang.Object replicas_;

    public ReplicasCase getReplicasCase() {
      return ReplicasCase.forNumber(replicasCase_);
    }

    public Builder clearReplicas() {
      replicasCase_ = 0;
      replicas_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.DirectedReadOptions.IncludeReplicas,
            com.google.spanner.v1.DirectedReadOptions.IncludeReplicas.Builder,
            com.google.spanner.v1.DirectedReadOptions.IncludeReplicasOrBuilder>
        includeReplicasBuilder_;
    /**
     *
     *
     * <pre>
     * Include_replicas indicates the order of replicas (as they appear in
     * this list) to process the request. If auto_failover_disabled is set to
     * true and all replicas are exhausted without finding a healthy replica,
     * Spanner will wait for a replica in the list to become available, requests
     * may fail due to `DEADLINE_EXCEEDED` errors.
     * </pre>
     *
     * <code>.google.spanner.v1.DirectedReadOptions.IncludeReplicas include_replicas = 1;</code>
     *
     * @return Whether the includeReplicas field is set.
     */
    @java.lang.Override
    public boolean hasIncludeReplicas() {
      return replicasCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Include_replicas indicates the order of replicas (as they appear in
     * this list) to process the request. If auto_failover_disabled is set to
     * true and all replicas are exhausted without finding a healthy replica,
     * Spanner will wait for a replica in the list to become available, requests
     * may fail due to `DEADLINE_EXCEEDED` errors.
     * </pre>
     *
     * <code>.google.spanner.v1.DirectedReadOptions.IncludeReplicas include_replicas = 1;</code>
     *
     * @return The includeReplicas.
     */
    @java.lang.Override
    public com.google.spanner.v1.DirectedReadOptions.IncludeReplicas getIncludeReplicas() {
      if (includeReplicasBuilder_ == null) {
        if (replicasCase_ == 1) {
          return (com.google.spanner.v1.DirectedReadOptions.IncludeReplicas) replicas_;
        }
        return com.google.spanner.v1.DirectedReadOptions.IncludeReplicas.getDefaultInstance();
      } else {
        if (replicasCase_ == 1) {
          return includeReplicasBuilder_.getMessage();
        }
        return com.google.spanner.v1.DirectedReadOptions.IncludeReplicas.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Include_replicas indicates the order of replicas (as they appear in
     * this list) to process the request. If auto_failover_disabled is set to
     * true and all replicas are exhausted without finding a healthy replica,
     * Spanner will wait for a replica in the list to become available, requests
     * may fail due to `DEADLINE_EXCEEDED` errors.
     * </pre>
     *
     * <code>.google.spanner.v1.DirectedReadOptions.IncludeReplicas include_replicas = 1;</code>
     */
    public Builder setIncludeReplicas(
        com.google.spanner.v1.DirectedReadOptions.IncludeReplicas value) {
      if (includeReplicasBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        replicas_ = value;
        onChanged();
      } else {
        includeReplicasBuilder_.setMessage(value);
      }
      replicasCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Include_replicas indicates the order of replicas (as they appear in
     * this list) to process the request. If auto_failover_disabled is set to
     * true and all replicas are exhausted without finding a healthy replica,
     * Spanner will wait for a replica in the list to become available, requests
     * may fail due to `DEADLINE_EXCEEDED` errors.
     * </pre>
     *
     * <code>.google.spanner.v1.DirectedReadOptions.IncludeReplicas include_replicas = 1;</code>
     */
    public Builder setIncludeReplicas(
        com.google.spanner.v1.DirectedReadOptions.IncludeReplicas.Builder builderForValue) {
      if (includeReplicasBuilder_ == null) {
        replicas_ = builderForValue.build();
        onChanged();
      } else {
        includeReplicasBuilder_.setMessage(builderForValue.build());
      }
      replicasCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Include_replicas indicates the order of replicas (as they appear in
     * this list) to process the request. If auto_failover_disabled is set to
     * true and all replicas are exhausted without finding a healthy replica,
     * Spanner will wait for a replica in the list to become available, requests
     * may fail due to `DEADLINE_EXCEEDED` errors.
     * </pre>
     *
     * <code>.google.spanner.v1.DirectedReadOptions.IncludeReplicas include_replicas = 1;</code>
     */
    public Builder mergeIncludeReplicas(
        com.google.spanner.v1.DirectedReadOptions.IncludeReplicas value) {
      if (includeReplicasBuilder_ == null) {
        if (replicasCase_ == 1
            && replicas_
                != com.google.spanner.v1.DirectedReadOptions.IncludeReplicas.getDefaultInstance()) {
          replicas_ =
              com.google.spanner.v1.DirectedReadOptions.IncludeReplicas.newBuilder(
                      (com.google.spanner.v1.DirectedReadOptions.IncludeReplicas) replicas_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          replicas_ = value;
        }
        onChanged();
      } else {
        if (replicasCase_ == 1) {
          includeReplicasBuilder_.mergeFrom(value);
        } else {
          includeReplicasBuilder_.setMessage(value);
        }
      }
      replicasCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Include_replicas indicates the order of replicas (as they appear in
     * this list) to process the request. If auto_failover_disabled is set to
     * true and all replicas are exhausted without finding a healthy replica,
     * Spanner will wait for a replica in the list to become available, requests
     * may fail due to `DEADLINE_EXCEEDED` errors.
     * </pre>
     *
     * <code>.google.spanner.v1.DirectedReadOptions.IncludeReplicas include_replicas = 1;</code>
     */
    public Builder clearIncludeReplicas() {
      if (includeReplicasBuilder_ == null) {
        if (replicasCase_ == 1) {
          replicasCase_ = 0;
          replicas_ = null;
          onChanged();
        }
      } else {
        if (replicasCase_ == 1) {
          replicasCase_ = 0;
          replicas_ = null;
        }
        includeReplicasBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Include_replicas indicates the order of replicas (as they appear in
     * this list) to process the request. If auto_failover_disabled is set to
     * true and all replicas are exhausted without finding a healthy replica,
     * Spanner will wait for a replica in the list to become available, requests
     * may fail due to `DEADLINE_EXCEEDED` errors.
     * </pre>
     *
     * <code>.google.spanner.v1.DirectedReadOptions.IncludeReplicas include_replicas = 1;</code>
     */
    public com.google.spanner.v1.DirectedReadOptions.IncludeReplicas.Builder
        getIncludeReplicasBuilder() {
      return getIncludeReplicasFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Include_replicas indicates the order of replicas (as they appear in
     * this list) to process the request. If auto_failover_disabled is set to
     * true and all replicas are exhausted without finding a healthy replica,
     * Spanner will wait for a replica in the list to become available, requests
     * may fail due to `DEADLINE_EXCEEDED` errors.
     * </pre>
     *
     * <code>.google.spanner.v1.DirectedReadOptions.IncludeReplicas include_replicas = 1;</code>
     */
    @java.lang.Override
    public com.google.spanner.v1.DirectedReadOptions.IncludeReplicasOrBuilder
        getIncludeReplicasOrBuilder() {
      if ((replicasCase_ == 1) && (includeReplicasBuilder_ != null)) {
        return includeReplicasBuilder_.getMessageOrBuilder();
      } else {
        if (replicasCase_ == 1) {
          return (com.google.spanner.v1.DirectedReadOptions.IncludeReplicas) replicas_;
        }
        return com.google.spanner.v1.DirectedReadOptions.IncludeReplicas.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Include_replicas indicates the order of replicas (as they appear in
     * this list) to process the request. If auto_failover_disabled is set to
     * true and all replicas are exhausted without finding a healthy replica,
     * Spanner will wait for a replica in the list to become available, requests
     * may fail due to `DEADLINE_EXCEEDED` errors.
     * </pre>
     *
     * <code>.google.spanner.v1.DirectedReadOptions.IncludeReplicas include_replicas = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.DirectedReadOptions.IncludeReplicas,
            com.google.spanner.v1.DirectedReadOptions.IncludeReplicas.Builder,
            com.google.spanner.v1.DirectedReadOptions.IncludeReplicasOrBuilder>
        getIncludeReplicasFieldBuilder() {
      if (includeReplicasBuilder_ == null) {
        if (!(replicasCase_ == 1)) {
          replicas_ =
              com.google.spanner.v1.DirectedReadOptions.IncludeReplicas.getDefaultInstance();
        }
        includeReplicasBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.DirectedReadOptions.IncludeReplicas,
                com.google.spanner.v1.DirectedReadOptions.IncludeReplicas.Builder,
                com.google.spanner.v1.DirectedReadOptions.IncludeReplicasOrBuilder>(
                (com.google.spanner.v1.DirectedReadOptions.IncludeReplicas) replicas_,
                getParentForChildren(),
                isClean());
        replicas_ = null;
      }
      replicasCase_ = 1;
      onChanged();
      return includeReplicasBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas,
            com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas.Builder,
            com.google.spanner.v1.DirectedReadOptions.ExcludeReplicasOrBuilder>
        excludeReplicasBuilder_;
    /**
     *
     *
     * <pre>
     * Exclude_replicas indicates that specified replicas should be excluded
     * from serving requests. Spanner will not route requests to the replicas
     * in this list.
     * </pre>
     *
     * <code>.google.spanner.v1.DirectedReadOptions.ExcludeReplicas exclude_replicas = 2;</code>
     *
     * @return Whether the excludeReplicas field is set.
     */
    @java.lang.Override
    public boolean hasExcludeReplicas() {
      return replicasCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Exclude_replicas indicates that specified replicas should be excluded
     * from serving requests. Spanner will not route requests to the replicas
     * in this list.
     * </pre>
     *
     * <code>.google.spanner.v1.DirectedReadOptions.ExcludeReplicas exclude_replicas = 2;</code>
     *
     * @return The excludeReplicas.
     */
    @java.lang.Override
    public com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas getExcludeReplicas() {
      if (excludeReplicasBuilder_ == null) {
        if (replicasCase_ == 2) {
          return (com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas) replicas_;
        }
        return com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas.getDefaultInstance();
      } else {
        if (replicasCase_ == 2) {
          return excludeReplicasBuilder_.getMessage();
        }
        return com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Exclude_replicas indicates that specified replicas should be excluded
     * from serving requests. Spanner will not route requests to the replicas
     * in this list.
     * </pre>
     *
     * <code>.google.spanner.v1.DirectedReadOptions.ExcludeReplicas exclude_replicas = 2;</code>
     */
    public Builder setExcludeReplicas(
        com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas value) {
      if (excludeReplicasBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        replicas_ = value;
        onChanged();
      } else {
        excludeReplicasBuilder_.setMessage(value);
      }
      replicasCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Exclude_replicas indicates that specified replicas should be excluded
     * from serving requests. Spanner will not route requests to the replicas
     * in this list.
     * </pre>
     *
     * <code>.google.spanner.v1.DirectedReadOptions.ExcludeReplicas exclude_replicas = 2;</code>
     */
    public Builder setExcludeReplicas(
        com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas.Builder builderForValue) {
      if (excludeReplicasBuilder_ == null) {
        replicas_ = builderForValue.build();
        onChanged();
      } else {
        excludeReplicasBuilder_.setMessage(builderForValue.build());
      }
      replicasCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Exclude_replicas indicates that specified replicas should be excluded
     * from serving requests. Spanner will not route requests to the replicas
     * in this list.
     * </pre>
     *
     * <code>.google.spanner.v1.DirectedReadOptions.ExcludeReplicas exclude_replicas = 2;</code>
     */
    public Builder mergeExcludeReplicas(
        com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas value) {
      if (excludeReplicasBuilder_ == null) {
        if (replicasCase_ == 2
            && replicas_
                != com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas.getDefaultInstance()) {
          replicas_ =
              com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas.newBuilder(
                      (com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas) replicas_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          replicas_ = value;
        }
        onChanged();
      } else {
        if (replicasCase_ == 2) {
          excludeReplicasBuilder_.mergeFrom(value);
        } else {
          excludeReplicasBuilder_.setMessage(value);
        }
      }
      replicasCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Exclude_replicas indicates that specified replicas should be excluded
     * from serving requests. Spanner will not route requests to the replicas
     * in this list.
     * </pre>
     *
     * <code>.google.spanner.v1.DirectedReadOptions.ExcludeReplicas exclude_replicas = 2;</code>
     */
    public Builder clearExcludeReplicas() {
      if (excludeReplicasBuilder_ == null) {
        if (replicasCase_ == 2) {
          replicasCase_ = 0;
          replicas_ = null;
          onChanged();
        }
      } else {
        if (replicasCase_ == 2) {
          replicasCase_ = 0;
          replicas_ = null;
        }
        excludeReplicasBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Exclude_replicas indicates that specified replicas should be excluded
     * from serving requests. Spanner will not route requests to the replicas
     * in this list.
     * </pre>
     *
     * <code>.google.spanner.v1.DirectedReadOptions.ExcludeReplicas exclude_replicas = 2;</code>
     */
    public com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas.Builder
        getExcludeReplicasBuilder() {
      return getExcludeReplicasFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Exclude_replicas indicates that specified replicas should be excluded
     * from serving requests. Spanner will not route requests to the replicas
     * in this list.
     * </pre>
     *
     * <code>.google.spanner.v1.DirectedReadOptions.ExcludeReplicas exclude_replicas = 2;</code>
     */
    @java.lang.Override
    public com.google.spanner.v1.DirectedReadOptions.ExcludeReplicasOrBuilder
        getExcludeReplicasOrBuilder() {
      if ((replicasCase_ == 2) && (excludeReplicasBuilder_ != null)) {
        return excludeReplicasBuilder_.getMessageOrBuilder();
      } else {
        if (replicasCase_ == 2) {
          return (com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas) replicas_;
        }
        return com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Exclude_replicas indicates that specified replicas should be excluded
     * from serving requests. Spanner will not route requests to the replicas
     * in this list.
     * </pre>
     *
     * <code>.google.spanner.v1.DirectedReadOptions.ExcludeReplicas exclude_replicas = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas,
            com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas.Builder,
            com.google.spanner.v1.DirectedReadOptions.ExcludeReplicasOrBuilder>
        getExcludeReplicasFieldBuilder() {
      if (excludeReplicasBuilder_ == null) {
        if (!(replicasCase_ == 2)) {
          replicas_ =
              com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas.getDefaultInstance();
        }
        excludeReplicasBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas,
                com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas.Builder,
                com.google.spanner.v1.DirectedReadOptions.ExcludeReplicasOrBuilder>(
                (com.google.spanner.v1.DirectedReadOptions.ExcludeReplicas) replicas_,
                getParentForChildren(),
                isClean());
        replicas_ = null;
      }
      replicasCase_ = 2;
      onChanged();
      return excludeReplicasBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.v1.DirectedReadOptions)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.v1.DirectedReadOptions)
  private static final com.google.spanner.v1.DirectedReadOptions DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.v1.DirectedReadOptions();
  }

  public static com.google.spanner.v1.DirectedReadOptions getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DirectedReadOptions> PARSER =
      new com.google.protobuf.AbstractParser<DirectedReadOptions>() {
        @java.lang.Override
        public DirectedReadOptions parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DirectedReadOptions> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DirectedReadOptions> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.v1.DirectedReadOptions getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
