/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/v1/spanner.proto

// Protobuf Java Version: 3.25.3
package com.google.spanner.v1;

/**
 *
 *
 * <pre>
 * The request for [PartitionQuery][google.spanner.v1.Spanner.PartitionQuery]
 * </pre>
 *
 * Protobuf type {@code google.spanner.v1.PartitionQueryRequest}
 */
public final class PartitionQueryRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.v1.PartitionQueryRequest)
    PartitionQueryRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PartitionQueryRequest.newBuilder() to construct.
  private PartitionQueryRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PartitionQueryRequest() {
    session_ = "";
    sql_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PartitionQueryRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.v1.SpannerProto
        .internal_static_google_spanner_v1_PartitionQueryRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 5:
        return internalGetParamTypes();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.v1.SpannerProto
        .internal_static_google_spanner_v1_PartitionQueryRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.v1.PartitionQueryRequest.class,
            com.google.spanner.v1.PartitionQueryRequest.Builder.class);
  }

  private int bitField0_;
  public static final int SESSION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object session_ = "";
  /**
   *
   *
   * <pre>
   * Required. The session used to create the partitions.
   * </pre>
   *
   * <code>
   * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The session.
   */
  @java.lang.Override
  public java.lang.String getSession() {
    java.lang.Object ref = session_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      session_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The session used to create the partitions.
   * </pre>
   *
   * <code>
   * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for session.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSessionBytes() {
    java.lang.Object ref = session_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      session_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRANSACTION_FIELD_NUMBER = 2;
  private com.google.spanner.v1.TransactionSelector transaction_;
  /**
   *
   *
   * <pre>
   * Read only snapshot transactions are supported, read/write and single use
   * transactions are not.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
   *
   * @return Whether the transaction field is set.
   */
  @java.lang.Override
  public boolean hasTransaction() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Read only snapshot transactions are supported, read/write and single use
   * transactions are not.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
   *
   * @return The transaction.
   */
  @java.lang.Override
  public com.google.spanner.v1.TransactionSelector getTransaction() {
    return transaction_ == null
        ? com.google.spanner.v1.TransactionSelector.getDefaultInstance()
        : transaction_;
  }
  /**
   *
   *
   * <pre>
   * Read only snapshot transactions are supported, read/write and single use
   * transactions are not.
   * </pre>
   *
   * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.TransactionSelectorOrBuilder getTransactionOrBuilder() {
    return transaction_ == null
        ? com.google.spanner.v1.TransactionSelector.getDefaultInstance()
        : transaction_;
  }

  public static final int SQL_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sql_ = "";
  /**
   *
   *
   * <pre>
   * Required. The query request to generate partitions for. The request will
   * fail if the query is not root partitionable. For a query to be root
   * partitionable, it needs to satisfy a few conditions. For example, if the
   * query execution plan contains a distributed union operator, then it must be
   * the first operator in the plan. For more information about other
   * conditions, see [Read data in
   * parallel](https://cloud.google.com/spanner/docs/reads#read_data_in_parallel).
   *
   * The query request must not contain DML commands, such as INSERT, UPDATE, or
   * DELETE. Use
   * [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql] with a
   * PartitionedDml transaction for large, partition-friendly DML operations.
   * </pre>
   *
   * <code>string sql = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The sql.
   */
  @java.lang.Override
  public java.lang.String getSql() {
    java.lang.Object ref = sql_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sql_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The query request to generate partitions for. The request will
   * fail if the query is not root partitionable. For a query to be root
   * partitionable, it needs to satisfy a few conditions. For example, if the
   * query execution plan contains a distributed union operator, then it must be
   * the first operator in the plan. For more information about other
   * conditions, see [Read data in
   * parallel](https://cloud.google.com/spanner/docs/reads#read_data_in_parallel).
   *
   * The query request must not contain DML commands, such as INSERT, UPDATE, or
   * DELETE. Use
   * [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql] with a
   * PartitionedDml transaction for large, partition-friendly DML operations.
   * </pre>
   *
   * <code>string sql = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for sql.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSqlBytes() {
    java.lang.Object ref = sql_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sql_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARAMS_FIELD_NUMBER = 4;
  private com.google.protobuf.Struct params_;
  /**
   *
   *
   * <pre>
   * Parameter names and values that bind to placeholders in the SQL string.
   *
   * A parameter placeholder consists of the `&#64;` character followed by the
   * parameter name (for example, `&#64;firstName`). Parameter names can contain
   * letters, numbers, and underscores.
   *
   * Parameters can appear anywhere that a literal value is expected.  The same
   * parameter name can be used more than once, for example:
   *
   * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
   *
   * It is an error to execute a SQL statement with unbound parameters.
   * </pre>
   *
   * <code>.google.protobuf.Struct params = 4;</code>
   *
   * @return Whether the params field is set.
   */
  @java.lang.Override
  public boolean hasParams() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Parameter names and values that bind to placeholders in the SQL string.
   *
   * A parameter placeholder consists of the `&#64;` character followed by the
   * parameter name (for example, `&#64;firstName`). Parameter names can contain
   * letters, numbers, and underscores.
   *
   * Parameters can appear anywhere that a literal value is expected.  The same
   * parameter name can be used more than once, for example:
   *
   * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
   *
   * It is an error to execute a SQL statement with unbound parameters.
   * </pre>
   *
   * <code>.google.protobuf.Struct params = 4;</code>
   *
   * @return The params.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getParams() {
    return params_ == null ? com.google.protobuf.Struct.getDefaultInstance() : params_;
  }
  /**
   *
   *
   * <pre>
   * Parameter names and values that bind to placeholders in the SQL string.
   *
   * A parameter placeholder consists of the `&#64;` character followed by the
   * parameter name (for example, `&#64;firstName`). Parameter names can contain
   * letters, numbers, and underscores.
   *
   * Parameters can appear anywhere that a literal value is expected.  The same
   * parameter name can be used more than once, for example:
   *
   * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
   *
   * It is an error to execute a SQL statement with unbound parameters.
   * </pre>
   *
   * <code>.google.protobuf.Struct params = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getParamsOrBuilder() {
    return params_ == null ? com.google.protobuf.Struct.getDefaultInstance() : params_;
  }

  public static final int PARAM_TYPES_FIELD_NUMBER = 5;

  private static final class ParamTypesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, com.google.spanner.v1.Type>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.spanner.v1.Type>newDefaultInstance(
                    com.google.spanner.v1.SpannerProto
                        .internal_static_google_spanner_v1_PartitionQueryRequest_ParamTypesEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.spanner.v1.Type.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, com.google.spanner.v1.Type> paramTypes_;

  private com.google.protobuf.MapField<java.lang.String, com.google.spanner.v1.Type>
      internalGetParamTypes() {
    if (paramTypes_ == null) {
      return com.google.protobuf.MapField.emptyMapField(ParamTypesDefaultEntryHolder.defaultEntry);
    }
    return paramTypes_;
  }

  public int getParamTypesCount() {
    return internalGetParamTypes().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * It is not always possible for Cloud Spanner to infer the right SQL type
   * from a JSON value.  For example, values of type `BYTES` and values
   * of type `STRING` both appear in
   * [params][google.spanner.v1.PartitionQueryRequest.params] as JSON strings.
   *
   * In these cases, `param_types` can be used to specify the exact
   * SQL type for some or all of the SQL query parameters. See the
   * definition of [Type][google.spanner.v1.Type] for more information
   * about SQL types.
   * </pre>
   *
   * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
   */
  @java.lang.Override
  public boolean containsParamTypes(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetParamTypes().getMap().containsKey(key);
  }
  /** Use {@link #getParamTypesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.spanner.v1.Type> getParamTypes() {
    return getParamTypesMap();
  }
  /**
   *
   *
   * <pre>
   * It is not always possible for Cloud Spanner to infer the right SQL type
   * from a JSON value.  For example, values of type `BYTES` and values
   * of type `STRING` both appear in
   * [params][google.spanner.v1.PartitionQueryRequest.params] as JSON strings.
   *
   * In these cases, `param_types` can be used to specify the exact
   * SQL type for some or all of the SQL query parameters. See the
   * definition of [Type][google.spanner.v1.Type] for more information
   * about SQL types.
   * </pre>
   *
   * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.spanner.v1.Type> getParamTypesMap() {
    return internalGetParamTypes().getMap();
  }
  /**
   *
   *
   * <pre>
   * It is not always possible for Cloud Spanner to infer the right SQL type
   * from a JSON value.  For example, values of type `BYTES` and values
   * of type `STRING` both appear in
   * [params][google.spanner.v1.PartitionQueryRequest.params] as JSON strings.
   *
   * In these cases, `param_types` can be used to specify the exact
   * SQL type for some or all of the SQL query parameters. See the
   * definition of [Type][google.spanner.v1.Type] for more information
   * about SQL types.
   * </pre>
   *
   * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
   */
  @java.lang.Override
  public /* nullable */ com.google.spanner.v1.Type getParamTypesOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.spanner.v1.Type defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.spanner.v1.Type> map =
        internalGetParamTypes().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * It is not always possible for Cloud Spanner to infer the right SQL type
   * from a JSON value.  For example, values of type `BYTES` and values
   * of type `STRING` both appear in
   * [params][google.spanner.v1.PartitionQueryRequest.params] as JSON strings.
   *
   * In these cases, `param_types` can be used to specify the exact
   * SQL type for some or all of the SQL query parameters. See the
   * definition of [Type][google.spanner.v1.Type] for more information
   * about SQL types.
   * </pre>
   *
   * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.Type getParamTypesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.spanner.v1.Type> map =
        internalGetParamTypes().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int PARTITION_OPTIONS_FIELD_NUMBER = 6;
  private com.google.spanner.v1.PartitionOptions partitionOptions_;
  /**
   *
   *
   * <pre>
   * Additional options that affect how many partitions are created.
   * </pre>
   *
   * <code>.google.spanner.v1.PartitionOptions partition_options = 6;</code>
   *
   * @return Whether the partitionOptions field is set.
   */
  @java.lang.Override
  public boolean hasPartitionOptions() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Additional options that affect how many partitions are created.
   * </pre>
   *
   * <code>.google.spanner.v1.PartitionOptions partition_options = 6;</code>
   *
   * @return The partitionOptions.
   */
  @java.lang.Override
  public com.google.spanner.v1.PartitionOptions getPartitionOptions() {
    return partitionOptions_ == null
        ? com.google.spanner.v1.PartitionOptions.getDefaultInstance()
        : partitionOptions_;
  }
  /**
   *
   *
   * <pre>
   * Additional options that affect how many partitions are created.
   * </pre>
   *
   * <code>.google.spanner.v1.PartitionOptions partition_options = 6;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.PartitionOptionsOrBuilder getPartitionOptionsOrBuilder() {
    return partitionOptions_ == null
        ? com.google.spanner.v1.PartitionOptions.getDefaultInstance()
        : partitionOptions_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(session_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, session_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getTransaction());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sql_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, sql_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getParams());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetParamTypes(), ParamTypesDefaultEntryHolder.defaultEntry, 5);
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(6, getPartitionOptions());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(session_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, session_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getTransaction());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sql_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, sql_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getParams());
    }
    for (java.util.Map.Entry<java.lang.String, com.google.spanner.v1.Type> entry :
        internalGetParamTypes().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.spanner.v1.Type> paramTypes__ =
          ParamTypesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, paramTypes__);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getPartitionOptions());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.v1.PartitionQueryRequest)) {
      return super.equals(obj);
    }
    com.google.spanner.v1.PartitionQueryRequest other =
        (com.google.spanner.v1.PartitionQueryRequest) obj;

    if (!getSession().equals(other.getSession())) return false;
    if (hasTransaction() != other.hasTransaction()) return false;
    if (hasTransaction()) {
      if (!getTransaction().equals(other.getTransaction())) return false;
    }
    if (!getSql().equals(other.getSql())) return false;
    if (hasParams() != other.hasParams()) return false;
    if (hasParams()) {
      if (!getParams().equals(other.getParams())) return false;
    }
    if (!internalGetParamTypes().equals(other.internalGetParamTypes())) return false;
    if (hasPartitionOptions() != other.hasPartitionOptions()) return false;
    if (hasPartitionOptions()) {
      if (!getPartitionOptions().equals(other.getPartitionOptions())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SESSION_FIELD_NUMBER;
    hash = (53 * hash) + getSession().hashCode();
    if (hasTransaction()) {
      hash = (37 * hash) + TRANSACTION_FIELD_NUMBER;
      hash = (53 * hash) + getTransaction().hashCode();
    }
    hash = (37 * hash) + SQL_FIELD_NUMBER;
    hash = (53 * hash) + getSql().hashCode();
    if (hasParams()) {
      hash = (37 * hash) + PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getParams().hashCode();
    }
    if (!internalGetParamTypes().getMap().isEmpty()) {
      hash = (37 * hash) + PARAM_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetParamTypes().hashCode();
    }
    if (hasPartitionOptions()) {
      hash = (37 * hash) + PARTITION_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getPartitionOptions().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.v1.PartitionQueryRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.PartitionQueryRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.PartitionQueryRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.PartitionQueryRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.PartitionQueryRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.PartitionQueryRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.PartitionQueryRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.PartitionQueryRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.PartitionQueryRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.PartitionQueryRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.PartitionQueryRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.PartitionQueryRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.v1.PartitionQueryRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request for [PartitionQuery][google.spanner.v1.Spanner.PartitionQuery]
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.PartitionQueryRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.v1.PartitionQueryRequest)
      com.google.spanner.v1.PartitionQueryRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_PartitionQueryRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetParamTypes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetMutableParamTypes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_PartitionQueryRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.PartitionQueryRequest.class,
              com.google.spanner.v1.PartitionQueryRequest.Builder.class);
    }

    // Construct using com.google.spanner.v1.PartitionQueryRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTransactionFieldBuilder();
        getParamsFieldBuilder();
        getPartitionOptionsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      session_ = "";
      transaction_ = null;
      if (transactionBuilder_ != null) {
        transactionBuilder_.dispose();
        transactionBuilder_ = null;
      }
      sql_ = "";
      params_ = null;
      if (paramsBuilder_ != null) {
        paramsBuilder_.dispose();
        paramsBuilder_ = null;
      }
      internalGetMutableParamTypes().clear();
      partitionOptions_ = null;
      if (partitionOptionsBuilder_ != null) {
        partitionOptionsBuilder_.dispose();
        partitionOptionsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.v1.SpannerProto
          .internal_static_google_spanner_v1_PartitionQueryRequest_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.v1.PartitionQueryRequest getDefaultInstanceForType() {
      return com.google.spanner.v1.PartitionQueryRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.v1.PartitionQueryRequest build() {
      com.google.spanner.v1.PartitionQueryRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.v1.PartitionQueryRequest buildPartial() {
      com.google.spanner.v1.PartitionQueryRequest result =
          new com.google.spanner.v1.PartitionQueryRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.v1.PartitionQueryRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.session_ = session_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.transaction_ =
            transactionBuilder_ == null ? transaction_ : transactionBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.sql_ = sql_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.params_ = paramsBuilder_ == null ? params_ : paramsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.paramTypes_ =
            internalGetParamTypes().build(ParamTypesDefaultEntryHolder.defaultEntry);
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.partitionOptions_ =
            partitionOptionsBuilder_ == null ? partitionOptions_ : partitionOptionsBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.v1.PartitionQueryRequest) {
        return mergeFrom((com.google.spanner.v1.PartitionQueryRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.v1.PartitionQueryRequest other) {
      if (other == com.google.spanner.v1.PartitionQueryRequest.getDefaultInstance()) return this;
      if (!other.getSession().isEmpty()) {
        session_ = other.session_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasTransaction()) {
        mergeTransaction(other.getTransaction());
      }
      if (!other.getSql().isEmpty()) {
        sql_ = other.sql_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasParams()) {
        mergeParams(other.getParams());
      }
      internalGetMutableParamTypes().mergeFrom(other.internalGetParamTypes());
      bitField0_ |= 0x00000010;
      if (other.hasPartitionOptions()) {
        mergePartitionOptions(other.getPartitionOptions());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                session_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getTransactionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                sql_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getParamsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, com.google.spanner.v1.Type>
                    paramTypes__ =
                        input.readMessage(
                            ParamTypesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableParamTypes()
                    .ensureBuilderMap()
                    .put(paramTypes__.getKey(), paramTypes__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getPartitionOptionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object session_ = "";
    /**
     *
     *
     * <pre>
     * Required. The session used to create the partitions.
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The session.
     */
    public java.lang.String getSession() {
      java.lang.Object ref = session_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        session_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The session used to create the partitions.
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for session.
     */
    public com.google.protobuf.ByteString getSessionBytes() {
      java.lang.Object ref = session_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        session_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The session used to create the partitions.
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The session to set.
     * @return This builder for chaining.
     */
    public Builder setSession(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      session_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The session used to create the partitions.
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSession() {
      session_ = getDefaultInstance().getSession();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The session used to create the partitions.
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for session to set.
     * @return This builder for chaining.
     */
    public Builder setSessionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      session_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.spanner.v1.TransactionSelector transaction_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.TransactionSelector,
            com.google.spanner.v1.TransactionSelector.Builder,
            com.google.spanner.v1.TransactionSelectorOrBuilder>
        transactionBuilder_;
    /**
     *
     *
     * <pre>
     * Read only snapshot transactions are supported, read/write and single use
     * transactions are not.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     *
     * @return Whether the transaction field is set.
     */
    public boolean hasTransaction() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Read only snapshot transactions are supported, read/write and single use
     * transactions are not.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     *
     * @return The transaction.
     */
    public com.google.spanner.v1.TransactionSelector getTransaction() {
      if (transactionBuilder_ == null) {
        return transaction_ == null
            ? com.google.spanner.v1.TransactionSelector.getDefaultInstance()
            : transaction_;
      } else {
        return transactionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Read only snapshot transactions are supported, read/write and single use
     * transactions are not.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     */
    public Builder setTransaction(com.google.spanner.v1.TransactionSelector value) {
      if (transactionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transaction_ = value;
      } else {
        transactionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Read only snapshot transactions are supported, read/write and single use
     * transactions are not.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     */
    public Builder setTransaction(
        com.google.spanner.v1.TransactionSelector.Builder builderForValue) {
      if (transactionBuilder_ == null) {
        transaction_ = builderForValue.build();
      } else {
        transactionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Read only snapshot transactions are supported, read/write and single use
     * transactions are not.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     */
    public Builder mergeTransaction(com.google.spanner.v1.TransactionSelector value) {
      if (transactionBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && transaction_ != null
            && transaction_ != com.google.spanner.v1.TransactionSelector.getDefaultInstance()) {
          getTransactionBuilder().mergeFrom(value);
        } else {
          transaction_ = value;
        }
      } else {
        transactionBuilder_.mergeFrom(value);
      }
      if (transaction_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Read only snapshot transactions are supported, read/write and single use
     * transactions are not.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     */
    public Builder clearTransaction() {
      bitField0_ = (bitField0_ & ~0x00000002);
      transaction_ = null;
      if (transactionBuilder_ != null) {
        transactionBuilder_.dispose();
        transactionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Read only snapshot transactions are supported, read/write and single use
     * transactions are not.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     */
    public com.google.spanner.v1.TransactionSelector.Builder getTransactionBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getTransactionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Read only snapshot transactions are supported, read/write and single use
     * transactions are not.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     */
    public com.google.spanner.v1.TransactionSelectorOrBuilder getTransactionOrBuilder() {
      if (transactionBuilder_ != null) {
        return transactionBuilder_.getMessageOrBuilder();
      } else {
        return transaction_ == null
            ? com.google.spanner.v1.TransactionSelector.getDefaultInstance()
            : transaction_;
      }
    }
    /**
     *
     *
     * <pre>
     * Read only snapshot transactions are supported, read/write and single use
     * transactions are not.
     * </pre>
     *
     * <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.TransactionSelector,
            com.google.spanner.v1.TransactionSelector.Builder,
            com.google.spanner.v1.TransactionSelectorOrBuilder>
        getTransactionFieldBuilder() {
      if (transactionBuilder_ == null) {
        transactionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.TransactionSelector,
                com.google.spanner.v1.TransactionSelector.Builder,
                com.google.spanner.v1.TransactionSelectorOrBuilder>(
                getTransaction(), getParentForChildren(), isClean());
        transaction_ = null;
      }
      return transactionBuilder_;
    }

    private java.lang.Object sql_ = "";
    /**
     *
     *
     * <pre>
     * Required. The query request to generate partitions for. The request will
     * fail if the query is not root partitionable. For a query to be root
     * partitionable, it needs to satisfy a few conditions. For example, if the
     * query execution plan contains a distributed union operator, then it must be
     * the first operator in the plan. For more information about other
     * conditions, see [Read data in
     * parallel](https://cloud.google.com/spanner/docs/reads#read_data_in_parallel).
     *
     * The query request must not contain DML commands, such as INSERT, UPDATE, or
     * DELETE. Use
     * [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql] with a
     * PartitionedDml transaction for large, partition-friendly DML operations.
     * </pre>
     *
     * <code>string sql = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The sql.
     */
    public java.lang.String getSql() {
      java.lang.Object ref = sql_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sql_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The query request to generate partitions for. The request will
     * fail if the query is not root partitionable. For a query to be root
     * partitionable, it needs to satisfy a few conditions. For example, if the
     * query execution plan contains a distributed union operator, then it must be
     * the first operator in the plan. For more information about other
     * conditions, see [Read data in
     * parallel](https://cloud.google.com/spanner/docs/reads#read_data_in_parallel).
     *
     * The query request must not contain DML commands, such as INSERT, UPDATE, or
     * DELETE. Use
     * [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql] with a
     * PartitionedDml transaction for large, partition-friendly DML operations.
     * </pre>
     *
     * <code>string sql = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for sql.
     */
    public com.google.protobuf.ByteString getSqlBytes() {
      java.lang.Object ref = sql_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sql_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The query request to generate partitions for. The request will
     * fail if the query is not root partitionable. For a query to be root
     * partitionable, it needs to satisfy a few conditions. For example, if the
     * query execution plan contains a distributed union operator, then it must be
     * the first operator in the plan. For more information about other
     * conditions, see [Read data in
     * parallel](https://cloud.google.com/spanner/docs/reads#read_data_in_parallel).
     *
     * The query request must not contain DML commands, such as INSERT, UPDATE, or
     * DELETE. Use
     * [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql] with a
     * PartitionedDml transaction for large, partition-friendly DML operations.
     * </pre>
     *
     * <code>string sql = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The sql to set.
     * @return This builder for chaining.
     */
    public Builder setSql(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sql_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The query request to generate partitions for. The request will
     * fail if the query is not root partitionable. For a query to be root
     * partitionable, it needs to satisfy a few conditions. For example, if the
     * query execution plan contains a distributed union operator, then it must be
     * the first operator in the plan. For more information about other
     * conditions, see [Read data in
     * parallel](https://cloud.google.com/spanner/docs/reads#read_data_in_parallel).
     *
     * The query request must not contain DML commands, such as INSERT, UPDATE, or
     * DELETE. Use
     * [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql] with a
     * PartitionedDml transaction for large, partition-friendly DML operations.
     * </pre>
     *
     * <code>string sql = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSql() {
      sql_ = getDefaultInstance().getSql();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The query request to generate partitions for. The request will
     * fail if the query is not root partitionable. For a query to be root
     * partitionable, it needs to satisfy a few conditions. For example, if the
     * query execution plan contains a distributed union operator, then it must be
     * the first operator in the plan. For more information about other
     * conditions, see [Read data in
     * parallel](https://cloud.google.com/spanner/docs/reads#read_data_in_parallel).
     *
     * The query request must not contain DML commands, such as INSERT, UPDATE, or
     * DELETE. Use
     * [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql] with a
     * PartitionedDml transaction for large, partition-friendly DML operations.
     * </pre>
     *
     * <code>string sql = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for sql to set.
     * @return This builder for chaining.
     */
    public Builder setSqlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sql_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Struct params_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        paramsBuilder_;
    /**
     *
     *
     * <pre>
     * Parameter names and values that bind to placeholders in the SQL string.
     *
     * A parameter placeholder consists of the `&#64;` character followed by the
     * parameter name (for example, `&#64;firstName`). Parameter names can contain
     * letters, numbers, and underscores.
     *
     * Parameters can appear anywhere that a literal value is expected.  The same
     * parameter name can be used more than once, for example:
     *
     * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
     *
     * It is an error to execute a SQL statement with unbound parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 4;</code>
     *
     * @return Whether the params field is set.
     */
    public boolean hasParams() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Parameter names and values that bind to placeholders in the SQL string.
     *
     * A parameter placeholder consists of the `&#64;` character followed by the
     * parameter name (for example, `&#64;firstName`). Parameter names can contain
     * letters, numbers, and underscores.
     *
     * Parameters can appear anywhere that a literal value is expected.  The same
     * parameter name can be used more than once, for example:
     *
     * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
     *
     * It is an error to execute a SQL statement with unbound parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 4;</code>
     *
     * @return The params.
     */
    public com.google.protobuf.Struct getParams() {
      if (paramsBuilder_ == null) {
        return params_ == null ? com.google.protobuf.Struct.getDefaultInstance() : params_;
      } else {
        return paramsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Parameter names and values that bind to placeholders in the SQL string.
     *
     * A parameter placeholder consists of the `&#64;` character followed by the
     * parameter name (for example, `&#64;firstName`). Parameter names can contain
     * letters, numbers, and underscores.
     *
     * Parameters can appear anywhere that a literal value is expected.  The same
     * parameter name can be used more than once, for example:
     *
     * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
     *
     * It is an error to execute a SQL statement with unbound parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 4;</code>
     */
    public Builder setParams(com.google.protobuf.Struct value) {
      if (paramsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        params_ = value;
      } else {
        paramsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameter names and values that bind to placeholders in the SQL string.
     *
     * A parameter placeholder consists of the `&#64;` character followed by the
     * parameter name (for example, `&#64;firstName`). Parameter names can contain
     * letters, numbers, and underscores.
     *
     * Parameters can appear anywhere that a literal value is expected.  The same
     * parameter name can be used more than once, for example:
     *
     * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
     *
     * It is an error to execute a SQL statement with unbound parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 4;</code>
     */
    public Builder setParams(com.google.protobuf.Struct.Builder builderForValue) {
      if (paramsBuilder_ == null) {
        params_ = builderForValue.build();
      } else {
        paramsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameter names and values that bind to placeholders in the SQL string.
     *
     * A parameter placeholder consists of the `&#64;` character followed by the
     * parameter name (for example, `&#64;firstName`). Parameter names can contain
     * letters, numbers, and underscores.
     *
     * Parameters can appear anywhere that a literal value is expected.  The same
     * parameter name can be used more than once, for example:
     *
     * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
     *
     * It is an error to execute a SQL statement with unbound parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 4;</code>
     */
    public Builder mergeParams(com.google.protobuf.Struct value) {
      if (paramsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && params_ != null
            && params_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getParamsBuilder().mergeFrom(value);
        } else {
          params_ = value;
        }
      } else {
        paramsBuilder_.mergeFrom(value);
      }
      if (params_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameter names and values that bind to placeholders in the SQL string.
     *
     * A parameter placeholder consists of the `&#64;` character followed by the
     * parameter name (for example, `&#64;firstName`). Parameter names can contain
     * letters, numbers, and underscores.
     *
     * Parameters can appear anywhere that a literal value is expected.  The same
     * parameter name can be used more than once, for example:
     *
     * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
     *
     * It is an error to execute a SQL statement with unbound parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 4;</code>
     */
    public Builder clearParams() {
      bitField0_ = (bitField0_ & ~0x00000008);
      params_ = null;
      if (paramsBuilder_ != null) {
        paramsBuilder_.dispose();
        paramsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameter names and values that bind to placeholders in the SQL string.
     *
     * A parameter placeholder consists of the `&#64;` character followed by the
     * parameter name (for example, `&#64;firstName`). Parameter names can contain
     * letters, numbers, and underscores.
     *
     * Parameters can appear anywhere that a literal value is expected.  The same
     * parameter name can be used more than once, for example:
     *
     * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
     *
     * It is an error to execute a SQL statement with unbound parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 4;</code>
     */
    public com.google.protobuf.Struct.Builder getParamsBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getParamsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Parameter names and values that bind to placeholders in the SQL string.
     *
     * A parameter placeholder consists of the `&#64;` character followed by the
     * parameter name (for example, `&#64;firstName`). Parameter names can contain
     * letters, numbers, and underscores.
     *
     * Parameters can appear anywhere that a literal value is expected.  The same
     * parameter name can be used more than once, for example:
     *
     * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
     *
     * It is an error to execute a SQL statement with unbound parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 4;</code>
     */
    public com.google.protobuf.StructOrBuilder getParamsOrBuilder() {
      if (paramsBuilder_ != null) {
        return paramsBuilder_.getMessageOrBuilder();
      } else {
        return params_ == null ? com.google.protobuf.Struct.getDefaultInstance() : params_;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameter names and values that bind to placeholders in the SQL string.
     *
     * A parameter placeholder consists of the `&#64;` character followed by the
     * parameter name (for example, `&#64;firstName`). Parameter names can contain
     * letters, numbers, and underscores.
     *
     * Parameters can appear anywhere that a literal value is expected.  The same
     * parameter name can be used more than once, for example:
     *
     * `"WHERE id &gt; &#64;msg_id AND id &lt; &#64;msg_id + 100"`
     *
     * It is an error to execute a SQL statement with unbound parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct params = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getParamsFieldBuilder() {
      if (paramsBuilder_ == null) {
        paramsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getParams(), getParentForChildren(), isClean());
        params_ = null;
      }
      return paramsBuilder_;
    }

    private static final class ParamTypesConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String, com.google.spanner.v1.TypeOrBuilder, com.google.spanner.v1.Type> {
      @java.lang.Override
      public com.google.spanner.v1.Type build(com.google.spanner.v1.TypeOrBuilder val) {
        if (val instanceof com.google.spanner.v1.Type) {
          return (com.google.spanner.v1.Type) val;
        }
        return ((com.google.spanner.v1.Type.Builder) val).build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<java.lang.String, com.google.spanner.v1.Type>
          defaultEntry() {
        return ParamTypesDefaultEntryHolder.defaultEntry;
      }
    };

    private static final ParamTypesConverter paramTypesConverter = new ParamTypesConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.spanner.v1.TypeOrBuilder,
            com.google.spanner.v1.Type,
            com.google.spanner.v1.Type.Builder>
        paramTypes_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.spanner.v1.TypeOrBuilder,
            com.google.spanner.v1.Type,
            com.google.spanner.v1.Type.Builder>
        internalGetParamTypes() {
      if (paramTypes_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(paramTypesConverter);
      }
      return paramTypes_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.spanner.v1.TypeOrBuilder,
            com.google.spanner.v1.Type,
            com.google.spanner.v1.Type.Builder>
        internalGetMutableParamTypes() {
      if (paramTypes_ == null) {
        paramTypes_ = new com.google.protobuf.MapFieldBuilder<>(paramTypesConverter);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return paramTypes_;
    }

    public int getParamTypesCount() {
      return internalGetParamTypes().ensureBuilderMap().size();
    }
    /**
     *
     *
     * <pre>
     * It is not always possible for Cloud Spanner to infer the right SQL type
     * from a JSON value.  For example, values of type `BYTES` and values
     * of type `STRING` both appear in
     * [params][google.spanner.v1.PartitionQueryRequest.params] as JSON strings.
     *
     * In these cases, `param_types` can be used to specify the exact
     * SQL type for some or all of the SQL query parameters. See the
     * definition of [Type][google.spanner.v1.Type] for more information
     * about SQL types.
     * </pre>
     *
     * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
     */
    @java.lang.Override
    public boolean containsParamTypes(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetParamTypes().ensureBuilderMap().containsKey(key);
    }
    /** Use {@link #getParamTypesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.spanner.v1.Type> getParamTypes() {
      return getParamTypesMap();
    }
    /**
     *
     *
     * <pre>
     * It is not always possible for Cloud Spanner to infer the right SQL type
     * from a JSON value.  For example, values of type `BYTES` and values
     * of type `STRING` both appear in
     * [params][google.spanner.v1.PartitionQueryRequest.params] as JSON strings.
     *
     * In these cases, `param_types` can be used to specify the exact
     * SQL type for some or all of the SQL query parameters. See the
     * definition of [Type][google.spanner.v1.Type] for more information
     * about SQL types.
     * </pre>
     *
     * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.spanner.v1.Type> getParamTypesMap() {
      return internalGetParamTypes().getImmutableMap();
    }
    /**
     *
     *
     * <pre>
     * It is not always possible for Cloud Spanner to infer the right SQL type
     * from a JSON value.  For example, values of type `BYTES` and values
     * of type `STRING` both appear in
     * [params][google.spanner.v1.PartitionQueryRequest.params] as JSON strings.
     *
     * In these cases, `param_types` can be used to specify the exact
     * SQL type for some or all of the SQL query parameters. See the
     * definition of [Type][google.spanner.v1.Type] for more information
     * about SQL types.
     * </pre>
     *
     * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
     */
    @java.lang.Override
    public /* nullable */ com.google.spanner.v1.Type getParamTypesOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.spanner.v1.Type defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.spanner.v1.TypeOrBuilder> map =
          internalGetMutableParamTypes().ensureBuilderMap();
      return map.containsKey(key) ? paramTypesConverter.build(map.get(key)) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * It is not always possible for Cloud Spanner to infer the right SQL type
     * from a JSON value.  For example, values of type `BYTES` and values
     * of type `STRING` both appear in
     * [params][google.spanner.v1.PartitionQueryRequest.params] as JSON strings.
     *
     * In these cases, `param_types` can be used to specify the exact
     * SQL type for some or all of the SQL query parameters. See the
     * definition of [Type][google.spanner.v1.Type] for more information
     * about SQL types.
     * </pre>
     *
     * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
     */
    @java.lang.Override
    public com.google.spanner.v1.Type getParamTypesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.spanner.v1.TypeOrBuilder> map =
          internalGetMutableParamTypes().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return paramTypesConverter.build(map.get(key));
    }

    public Builder clearParamTypes() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableParamTypes().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * It is not always possible for Cloud Spanner to infer the right SQL type
     * from a JSON value.  For example, values of type `BYTES` and values
     * of type `STRING` both appear in
     * [params][google.spanner.v1.PartitionQueryRequest.params] as JSON strings.
     *
     * In these cases, `param_types` can be used to specify the exact
     * SQL type for some or all of the SQL query parameters. See the
     * definition of [Type][google.spanner.v1.Type] for more information
     * about SQL types.
     * </pre>
     *
     * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
     */
    public Builder removeParamTypes(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableParamTypes().ensureBuilderMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.spanner.v1.Type> getMutableParamTypes() {
      bitField0_ |= 0x00000010;
      return internalGetMutableParamTypes().ensureMessageMap();
    }
    /**
     *
     *
     * <pre>
     * It is not always possible for Cloud Spanner to infer the right SQL type
     * from a JSON value.  For example, values of type `BYTES` and values
     * of type `STRING` both appear in
     * [params][google.spanner.v1.PartitionQueryRequest.params] as JSON strings.
     *
     * In these cases, `param_types` can be used to specify the exact
     * SQL type for some or all of the SQL query parameters. See the
     * definition of [Type][google.spanner.v1.Type] for more information
     * about SQL types.
     * </pre>
     *
     * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
     */
    public Builder putParamTypes(java.lang.String key, com.google.spanner.v1.Type value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableParamTypes().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * It is not always possible for Cloud Spanner to infer the right SQL type
     * from a JSON value.  For example, values of type `BYTES` and values
     * of type `STRING` both appear in
     * [params][google.spanner.v1.PartitionQueryRequest.params] as JSON strings.
     *
     * In these cases, `param_types` can be used to specify the exact
     * SQL type for some or all of the SQL query parameters. See the
     * definition of [Type][google.spanner.v1.Type] for more information
     * about SQL types.
     * </pre>
     *
     * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
     */
    public Builder putAllParamTypes(
        java.util.Map<java.lang.String, com.google.spanner.v1.Type> values) {
      for (java.util.Map.Entry<java.lang.String, com.google.spanner.v1.Type> e :
          values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableParamTypes().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * It is not always possible for Cloud Spanner to infer the right SQL type
     * from a JSON value.  For example, values of type `BYTES` and values
     * of type `STRING` both appear in
     * [params][google.spanner.v1.PartitionQueryRequest.params] as JSON strings.
     *
     * In these cases, `param_types` can be used to specify the exact
     * SQL type for some or all of the SQL query parameters. See the
     * definition of [Type][google.spanner.v1.Type] for more information
     * about SQL types.
     * </pre>
     *
     * <code>map&lt;string, .google.spanner.v1.Type&gt; param_types = 5;</code>
     */
    public com.google.spanner.v1.Type.Builder putParamTypesBuilderIfAbsent(java.lang.String key) {
      java.util.Map<java.lang.String, com.google.spanner.v1.TypeOrBuilder> builderMap =
          internalGetMutableParamTypes().ensureBuilderMap();
      com.google.spanner.v1.TypeOrBuilder entry = builderMap.get(key);
      if (entry == null) {
        entry = com.google.spanner.v1.Type.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.spanner.v1.Type) {
        entry = ((com.google.spanner.v1.Type) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.spanner.v1.Type.Builder) entry;
    }

    private com.google.spanner.v1.PartitionOptions partitionOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.PartitionOptions,
            com.google.spanner.v1.PartitionOptions.Builder,
            com.google.spanner.v1.PartitionOptionsOrBuilder>
        partitionOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * Additional options that affect how many partitions are created.
     * </pre>
     *
     * <code>.google.spanner.v1.PartitionOptions partition_options = 6;</code>
     *
     * @return Whether the partitionOptions field is set.
     */
    public boolean hasPartitionOptions() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Additional options that affect how many partitions are created.
     * </pre>
     *
     * <code>.google.spanner.v1.PartitionOptions partition_options = 6;</code>
     *
     * @return The partitionOptions.
     */
    public com.google.spanner.v1.PartitionOptions getPartitionOptions() {
      if (partitionOptionsBuilder_ == null) {
        return partitionOptions_ == null
            ? com.google.spanner.v1.PartitionOptions.getDefaultInstance()
            : partitionOptions_;
      } else {
        return partitionOptionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Additional options that affect how many partitions are created.
     * </pre>
     *
     * <code>.google.spanner.v1.PartitionOptions partition_options = 6;</code>
     */
    public Builder setPartitionOptions(com.google.spanner.v1.PartitionOptions value) {
      if (partitionOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        partitionOptions_ = value;
      } else {
        partitionOptionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional options that affect how many partitions are created.
     * </pre>
     *
     * <code>.google.spanner.v1.PartitionOptions partition_options = 6;</code>
     */
    public Builder setPartitionOptions(
        com.google.spanner.v1.PartitionOptions.Builder builderForValue) {
      if (partitionOptionsBuilder_ == null) {
        partitionOptions_ = builderForValue.build();
      } else {
        partitionOptionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional options that affect how many partitions are created.
     * </pre>
     *
     * <code>.google.spanner.v1.PartitionOptions partition_options = 6;</code>
     */
    public Builder mergePartitionOptions(com.google.spanner.v1.PartitionOptions value) {
      if (partitionOptionsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && partitionOptions_ != null
            && partitionOptions_ != com.google.spanner.v1.PartitionOptions.getDefaultInstance()) {
          getPartitionOptionsBuilder().mergeFrom(value);
        } else {
          partitionOptions_ = value;
        }
      } else {
        partitionOptionsBuilder_.mergeFrom(value);
      }
      if (partitionOptions_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional options that affect how many partitions are created.
     * </pre>
     *
     * <code>.google.spanner.v1.PartitionOptions partition_options = 6;</code>
     */
    public Builder clearPartitionOptions() {
      bitField0_ = (bitField0_ & ~0x00000020);
      partitionOptions_ = null;
      if (partitionOptionsBuilder_ != null) {
        partitionOptionsBuilder_.dispose();
        partitionOptionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional options that affect how many partitions are created.
     * </pre>
     *
     * <code>.google.spanner.v1.PartitionOptions partition_options = 6;</code>
     */
    public com.google.spanner.v1.PartitionOptions.Builder getPartitionOptionsBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getPartitionOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Additional options that affect how many partitions are created.
     * </pre>
     *
     * <code>.google.spanner.v1.PartitionOptions partition_options = 6;</code>
     */
    public com.google.spanner.v1.PartitionOptionsOrBuilder getPartitionOptionsOrBuilder() {
      if (partitionOptionsBuilder_ != null) {
        return partitionOptionsBuilder_.getMessageOrBuilder();
      } else {
        return partitionOptions_ == null
            ? com.google.spanner.v1.PartitionOptions.getDefaultInstance()
            : partitionOptions_;
      }
    }
    /**
     *
     *
     * <pre>
     * Additional options that affect how many partitions are created.
     * </pre>
     *
     * <code>.google.spanner.v1.PartitionOptions partition_options = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.PartitionOptions,
            com.google.spanner.v1.PartitionOptions.Builder,
            com.google.spanner.v1.PartitionOptionsOrBuilder>
        getPartitionOptionsFieldBuilder() {
      if (partitionOptionsBuilder_ == null) {
        partitionOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.PartitionOptions,
                com.google.spanner.v1.PartitionOptions.Builder,
                com.google.spanner.v1.PartitionOptionsOrBuilder>(
                getPartitionOptions(), getParentForChildren(), isClean());
        partitionOptions_ = null;
      }
      return partitionOptionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.v1.PartitionQueryRequest)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.v1.PartitionQueryRequest)
  private static final com.google.spanner.v1.PartitionQueryRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.v1.PartitionQueryRequest();
  }

  public static com.google.spanner.v1.PartitionQueryRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PartitionQueryRequest> PARSER =
      new com.google.protobuf.AbstractParser<PartitionQueryRequest>() {
        @java.lang.Override
        public PartitionQueryRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PartitionQueryRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PartitionQueryRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.v1.PartitionQueryRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
