/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/speech/v1/resource.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.speech.v1;

/**
 *
 *
 * <pre>
 * A set of words or phrases that represents a common concept likely to appear
 * in your audio, for example a list of passenger ship names. CustomClass items
 * can be substituted into placeholders that you set in PhraseSet phrases.
 * </pre>
 *
 * Protobuf type {@code google.cloud.speech.v1.CustomClass}
 */
public final class CustomClass extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.speech.v1.CustomClass)
    CustomClassOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use CustomClass.newBuilder() to construct.
  private CustomClass(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CustomClass() {
    name_ = "";
    customClassId_ = "";
    items_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CustomClass();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.speech.v1.SpeechResourceProto
        .internal_static_google_cloud_speech_v1_CustomClass_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.speech.v1.SpeechResourceProto
        .internal_static_google_cloud_speech_v1_CustomClass_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.speech.v1.CustomClass.class,
            com.google.cloud.speech.v1.CustomClass.Builder.class);
  }

  public interface ClassItemOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.speech.v1.CustomClass.ClassItem)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The class item's value.
     * </pre>
     *
     * <code>string value = 1;</code>
     *
     * @return The value.
     */
    java.lang.String getValue();

    /**
     *
     *
     * <pre>
     * The class item's value.
     * </pre>
     *
     * <code>string value = 1;</code>
     *
     * @return The bytes for value.
     */
    com.google.protobuf.ByteString getValueBytes();
  }

  /**
   *
   *
   * <pre>
   * An item of the class.
   * </pre>
   *
   * Protobuf type {@code google.cloud.speech.v1.CustomClass.ClassItem}
   */
  public static final class ClassItem extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.speech.v1.CustomClass.ClassItem)
      ClassItemOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ClassItem.newBuilder() to construct.
    private ClassItem(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ClassItem() {
      value_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ClassItem();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.speech.v1.SpeechResourceProto
          .internal_static_google_cloud_speech_v1_CustomClass_ClassItem_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.speech.v1.SpeechResourceProto
          .internal_static_google_cloud_speech_v1_CustomClass_ClassItem_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.speech.v1.CustomClass.ClassItem.class,
              com.google.cloud.speech.v1.CustomClass.ClassItem.Builder.class);
    }

    public static final int VALUE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object value_ = "";

    /**
     *
     *
     * <pre>
     * The class item's value.
     * </pre>
     *
     * <code>string value = 1;</code>
     *
     * @return The value.
     */
    @java.lang.Override
    public java.lang.String getValue() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        value_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The class item's value.
     * </pre>
     *
     * <code>string value = 1;</code>
     *
     * @return The bytes for value.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getValueBytes() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        value_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, value_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, value_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.speech.v1.CustomClass.ClassItem)) {
        return super.equals(obj);
      }
      com.google.cloud.speech.v1.CustomClass.ClassItem other =
          (com.google.cloud.speech.v1.CustomClass.ClassItem) obj;

      if (!getValue().equals(other.getValue())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getValue().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.speech.v1.CustomClass.ClassItem parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.speech.v1.CustomClass.ClassItem parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.speech.v1.CustomClass.ClassItem parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.speech.v1.CustomClass.ClassItem parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.speech.v1.CustomClass.ClassItem parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.speech.v1.CustomClass.ClassItem parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.speech.v1.CustomClass.ClassItem parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.speech.v1.CustomClass.ClassItem parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.speech.v1.CustomClass.ClassItem parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.speech.v1.CustomClass.ClassItem parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.speech.v1.CustomClass.ClassItem parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.speech.v1.CustomClass.ClassItem parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.speech.v1.CustomClass.ClassItem prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * An item of the class.
     * </pre>
     *
     * Protobuf type {@code google.cloud.speech.v1.CustomClass.ClassItem}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.speech.v1.CustomClass.ClassItem)
        com.google.cloud.speech.v1.CustomClass.ClassItemOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.speech.v1.SpeechResourceProto
            .internal_static_google_cloud_speech_v1_CustomClass_ClassItem_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.speech.v1.SpeechResourceProto
            .internal_static_google_cloud_speech_v1_CustomClass_ClassItem_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.speech.v1.CustomClass.ClassItem.class,
                com.google.cloud.speech.v1.CustomClass.ClassItem.Builder.class);
      }

      // Construct using com.google.cloud.speech.v1.CustomClass.ClassItem.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        value_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.speech.v1.SpeechResourceProto
            .internal_static_google_cloud_speech_v1_CustomClass_ClassItem_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.speech.v1.CustomClass.ClassItem getDefaultInstanceForType() {
        return com.google.cloud.speech.v1.CustomClass.ClassItem.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.speech.v1.CustomClass.ClassItem build() {
        com.google.cloud.speech.v1.CustomClass.ClassItem result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.speech.v1.CustomClass.ClassItem buildPartial() {
        com.google.cloud.speech.v1.CustomClass.ClassItem result =
            new com.google.cloud.speech.v1.CustomClass.ClassItem(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.speech.v1.CustomClass.ClassItem result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.value_ = value_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.speech.v1.CustomClass.ClassItem) {
          return mergeFrom((com.google.cloud.speech.v1.CustomClass.ClassItem) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.speech.v1.CustomClass.ClassItem other) {
        if (other == com.google.cloud.speech.v1.CustomClass.ClassItem.getDefaultInstance())
          return this;
        if (!other.getValue().isEmpty()) {
          value_ = other.value_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  value_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object value_ = "";

      /**
       *
       *
       * <pre>
       * The class item's value.
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @return The value.
       */
      public java.lang.String getValue() {
        java.lang.Object ref = value_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          value_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The class item's value.
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @return The bytes for value.
       */
      public com.google.protobuf.ByteString getValueBytes() {
        java.lang.Object ref = value_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          value_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The class item's value.
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @param value The value to set.
       * @return This builder for chaining.
       */
      public Builder setValue(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        value_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The class item's value.
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValue() {
        value_ = getDefaultInstance().getValue();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The class item's value.
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @param value The bytes for value to set.
       * @return This builder for chaining.
       */
      public Builder setValueBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        value_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.speech.v1.CustomClass.ClassItem)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.speech.v1.CustomClass.ClassItem)
    private static final com.google.cloud.speech.v1.CustomClass.ClassItem DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.speech.v1.CustomClass.ClassItem();
    }

    public static com.google.cloud.speech.v1.CustomClass.ClassItem getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ClassItem> PARSER =
        new com.google.protobuf.AbstractParser<ClassItem>() {
          @java.lang.Override
          public ClassItem parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ClassItem> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ClassItem> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.speech.v1.CustomClass.ClassItem getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * The resource name of the custom class.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The resource name of the custom class.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CUSTOM_CLASS_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object customClassId_ = "";

  /**
   *
   *
   * <pre>
   * If this custom class is a resource, the custom_class_id is the resource id
   * of the CustomClass. Case sensitive.
   * </pre>
   *
   * <code>string custom_class_id = 2;</code>
   *
   * @return The customClassId.
   */
  @java.lang.Override
  public java.lang.String getCustomClassId() {
    java.lang.Object ref = customClassId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      customClassId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * If this custom class is a resource, the custom_class_id is the resource id
   * of the CustomClass. Case sensitive.
   * </pre>
   *
   * <code>string custom_class_id = 2;</code>
   *
   * @return The bytes for customClassId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCustomClassIdBytes() {
    java.lang.Object ref = customClassId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      customClassId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ITEMS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.speech.v1.CustomClass.ClassItem> items_;

  /**
   *
   *
   * <pre>
   * A collection of class items.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1.CustomClass.ClassItem items = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.speech.v1.CustomClass.ClassItem> getItemsList() {
    return items_;
  }

  /**
   *
   *
   * <pre>
   * A collection of class items.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1.CustomClass.ClassItem items = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.speech.v1.CustomClass.ClassItemOrBuilder>
      getItemsOrBuilderList() {
    return items_;
  }

  /**
   *
   *
   * <pre>
   * A collection of class items.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1.CustomClass.ClassItem items = 3;</code>
   */
  @java.lang.Override
  public int getItemsCount() {
    return items_.size();
  }

  /**
   *
   *
   * <pre>
   * A collection of class items.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1.CustomClass.ClassItem items = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v1.CustomClass.ClassItem getItems(int index) {
    return items_.get(index);
  }

  /**
   *
   *
   * <pre>
   * A collection of class items.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1.CustomClass.ClassItem items = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v1.CustomClass.ClassItemOrBuilder getItemsOrBuilder(int index) {
    return items_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(customClassId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, customClassId_);
    }
    for (int i = 0; i < items_.size(); i++) {
      output.writeMessage(3, items_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(customClassId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, customClassId_);
    }
    for (int i = 0; i < items_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, items_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.speech.v1.CustomClass)) {
      return super.equals(obj);
    }
    com.google.cloud.speech.v1.CustomClass other = (com.google.cloud.speech.v1.CustomClass) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getCustomClassId().equals(other.getCustomClassId())) return false;
    if (!getItemsList().equals(other.getItemsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + CUSTOM_CLASS_ID_FIELD_NUMBER;
    hash = (53 * hash) + getCustomClassId().hashCode();
    if (getItemsCount() > 0) {
      hash = (37 * hash) + ITEMS_FIELD_NUMBER;
      hash = (53 * hash) + getItemsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.speech.v1.CustomClass parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v1.CustomClass parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v1.CustomClass parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v1.CustomClass parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v1.CustomClass parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v1.CustomClass parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v1.CustomClass parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v1.CustomClass parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v1.CustomClass parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v1.CustomClass parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v1.CustomClass parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v1.CustomClass parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.speech.v1.CustomClass prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A set of words or phrases that represents a common concept likely to appear
   * in your audio, for example a list of passenger ship names. CustomClass items
   * can be substituted into placeholders that you set in PhraseSet phrases.
   * </pre>
   *
   * Protobuf type {@code google.cloud.speech.v1.CustomClass}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.speech.v1.CustomClass)
      com.google.cloud.speech.v1.CustomClassOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.speech.v1.SpeechResourceProto
          .internal_static_google_cloud_speech_v1_CustomClass_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.speech.v1.SpeechResourceProto
          .internal_static_google_cloud_speech_v1_CustomClass_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.speech.v1.CustomClass.class,
              com.google.cloud.speech.v1.CustomClass.Builder.class);
    }

    // Construct using com.google.cloud.speech.v1.CustomClass.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      customClassId_ = "";
      if (itemsBuilder_ == null) {
        items_ = java.util.Collections.emptyList();
      } else {
        items_ = null;
        itemsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.speech.v1.SpeechResourceProto
          .internal_static_google_cloud_speech_v1_CustomClass_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.speech.v1.CustomClass getDefaultInstanceForType() {
      return com.google.cloud.speech.v1.CustomClass.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.speech.v1.CustomClass build() {
      com.google.cloud.speech.v1.CustomClass result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.speech.v1.CustomClass buildPartial() {
      com.google.cloud.speech.v1.CustomClass result =
          new com.google.cloud.speech.v1.CustomClass(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.speech.v1.CustomClass result) {
      if (itemsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          items_ = java.util.Collections.unmodifiableList(items_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.items_ = items_;
      } else {
        result.items_ = itemsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.speech.v1.CustomClass result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.customClassId_ = customClassId_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.speech.v1.CustomClass) {
        return mergeFrom((com.google.cloud.speech.v1.CustomClass) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.speech.v1.CustomClass other) {
      if (other == com.google.cloud.speech.v1.CustomClass.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getCustomClassId().isEmpty()) {
        customClassId_ = other.customClassId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (itemsBuilder_ == null) {
        if (!other.items_.isEmpty()) {
          if (items_.isEmpty()) {
            items_ = other.items_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureItemsIsMutable();
            items_.addAll(other.items_);
          }
          onChanged();
        }
      } else {
        if (!other.items_.isEmpty()) {
          if (itemsBuilder_.isEmpty()) {
            itemsBuilder_.dispose();
            itemsBuilder_ = null;
            items_ = other.items_;
            bitField0_ = (bitField0_ & ~0x00000004);
            itemsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getItemsFieldBuilder()
                    : null;
          } else {
            itemsBuilder_.addAllMessages(other.items_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                customClassId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.speech.v1.CustomClass.ClassItem m =
                    input.readMessage(
                        com.google.cloud.speech.v1.CustomClass.ClassItem.parser(),
                        extensionRegistry);
                if (itemsBuilder_ == null) {
                  ensureItemsIsMutable();
                  items_.add(m);
                } else {
                  itemsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * The resource name of the custom class.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The resource name of the custom class.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The resource name of the custom class.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The resource name of the custom class.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The resource name of the custom class.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object customClassId_ = "";

    /**
     *
     *
     * <pre>
     * If this custom class is a resource, the custom_class_id is the resource id
     * of the CustomClass. Case sensitive.
     * </pre>
     *
     * <code>string custom_class_id = 2;</code>
     *
     * @return The customClassId.
     */
    public java.lang.String getCustomClassId() {
      java.lang.Object ref = customClassId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        customClassId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * If this custom class is a resource, the custom_class_id is the resource id
     * of the CustomClass. Case sensitive.
     * </pre>
     *
     * <code>string custom_class_id = 2;</code>
     *
     * @return The bytes for customClassId.
     */
    public com.google.protobuf.ByteString getCustomClassIdBytes() {
      java.lang.Object ref = customClassId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        customClassId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * If this custom class is a resource, the custom_class_id is the resource id
     * of the CustomClass. Case sensitive.
     * </pre>
     *
     * <code>string custom_class_id = 2;</code>
     *
     * @param value The customClassId to set.
     * @return This builder for chaining.
     */
    public Builder setCustomClassId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      customClassId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If this custom class is a resource, the custom_class_id is the resource id
     * of the CustomClass. Case sensitive.
     * </pre>
     *
     * <code>string custom_class_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCustomClassId() {
      customClassId_ = getDefaultInstance().getCustomClassId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If this custom class is a resource, the custom_class_id is the resource id
     * of the CustomClass. Case sensitive.
     * </pre>
     *
     * <code>string custom_class_id = 2;</code>
     *
     * @param value The bytes for customClassId to set.
     * @return This builder for chaining.
     */
    public Builder setCustomClassIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      customClassId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.speech.v1.CustomClass.ClassItem> items_ =
        java.util.Collections.emptyList();

    private void ensureItemsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        items_ = new java.util.ArrayList<com.google.cloud.speech.v1.CustomClass.ClassItem>(items_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.speech.v1.CustomClass.ClassItem,
            com.google.cloud.speech.v1.CustomClass.ClassItem.Builder,
            com.google.cloud.speech.v1.CustomClass.ClassItemOrBuilder>
        itemsBuilder_;

    /**
     *
     *
     * <pre>
     * A collection of class items.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.CustomClass.ClassItem items = 3;</code>
     */
    public java.util.List<com.google.cloud.speech.v1.CustomClass.ClassItem> getItemsList() {
      if (itemsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(items_);
      } else {
        return itemsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * A collection of class items.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.CustomClass.ClassItem items = 3;</code>
     */
    public int getItemsCount() {
      if (itemsBuilder_ == null) {
        return items_.size();
      } else {
        return itemsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * A collection of class items.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.CustomClass.ClassItem items = 3;</code>
     */
    public com.google.cloud.speech.v1.CustomClass.ClassItem getItems(int index) {
      if (itemsBuilder_ == null) {
        return items_.get(index);
      } else {
        return itemsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A collection of class items.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.CustomClass.ClassItem items = 3;</code>
     */
    public Builder setItems(int index, com.google.cloud.speech.v1.CustomClass.ClassItem value) {
      if (itemsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureItemsIsMutable();
        items_.set(index, value);
        onChanged();
      } else {
        itemsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A collection of class items.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.CustomClass.ClassItem items = 3;</code>
     */
    public Builder setItems(
        int index, com.google.cloud.speech.v1.CustomClass.ClassItem.Builder builderForValue) {
      if (itemsBuilder_ == null) {
        ensureItemsIsMutable();
        items_.set(index, builderForValue.build());
        onChanged();
      } else {
        itemsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A collection of class items.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.CustomClass.ClassItem items = 3;</code>
     */
    public Builder addItems(com.google.cloud.speech.v1.CustomClass.ClassItem value) {
      if (itemsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureItemsIsMutable();
        items_.add(value);
        onChanged();
      } else {
        itemsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A collection of class items.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.CustomClass.ClassItem items = 3;</code>
     */
    public Builder addItems(int index, com.google.cloud.speech.v1.CustomClass.ClassItem value) {
      if (itemsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureItemsIsMutable();
        items_.add(index, value);
        onChanged();
      } else {
        itemsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A collection of class items.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.CustomClass.ClassItem items = 3;</code>
     */
    public Builder addItems(
        com.google.cloud.speech.v1.CustomClass.ClassItem.Builder builderForValue) {
      if (itemsBuilder_ == null) {
        ensureItemsIsMutable();
        items_.add(builderForValue.build());
        onChanged();
      } else {
        itemsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A collection of class items.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.CustomClass.ClassItem items = 3;</code>
     */
    public Builder addItems(
        int index, com.google.cloud.speech.v1.CustomClass.ClassItem.Builder builderForValue) {
      if (itemsBuilder_ == null) {
        ensureItemsIsMutable();
        items_.add(index, builderForValue.build());
        onChanged();
      } else {
        itemsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A collection of class items.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.CustomClass.ClassItem items = 3;</code>
     */
    public Builder addAllItems(
        java.lang.Iterable<? extends com.google.cloud.speech.v1.CustomClass.ClassItem> values) {
      if (itemsBuilder_ == null) {
        ensureItemsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, items_);
        onChanged();
      } else {
        itemsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A collection of class items.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.CustomClass.ClassItem items = 3;</code>
     */
    public Builder clearItems() {
      if (itemsBuilder_ == null) {
        items_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        itemsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A collection of class items.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.CustomClass.ClassItem items = 3;</code>
     */
    public Builder removeItems(int index) {
      if (itemsBuilder_ == null) {
        ensureItemsIsMutable();
        items_.remove(index);
        onChanged();
      } else {
        itemsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A collection of class items.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.CustomClass.ClassItem items = 3;</code>
     */
    public com.google.cloud.speech.v1.CustomClass.ClassItem.Builder getItemsBuilder(int index) {
      return getItemsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * A collection of class items.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.CustomClass.ClassItem items = 3;</code>
     */
    public com.google.cloud.speech.v1.CustomClass.ClassItemOrBuilder getItemsOrBuilder(int index) {
      if (itemsBuilder_ == null) {
        return items_.get(index);
      } else {
        return itemsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A collection of class items.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.CustomClass.ClassItem items = 3;</code>
     */
    public java.util.List<? extends com.google.cloud.speech.v1.CustomClass.ClassItemOrBuilder>
        getItemsOrBuilderList() {
      if (itemsBuilder_ != null) {
        return itemsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(items_);
      }
    }

    /**
     *
     *
     * <pre>
     * A collection of class items.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.CustomClass.ClassItem items = 3;</code>
     */
    public com.google.cloud.speech.v1.CustomClass.ClassItem.Builder addItemsBuilder() {
      return getItemsFieldBuilder()
          .addBuilder(com.google.cloud.speech.v1.CustomClass.ClassItem.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A collection of class items.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.CustomClass.ClassItem items = 3;</code>
     */
    public com.google.cloud.speech.v1.CustomClass.ClassItem.Builder addItemsBuilder(int index) {
      return getItemsFieldBuilder()
          .addBuilder(index, com.google.cloud.speech.v1.CustomClass.ClassItem.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A collection of class items.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.CustomClass.ClassItem items = 3;</code>
     */
    public java.util.List<com.google.cloud.speech.v1.CustomClass.ClassItem.Builder>
        getItemsBuilderList() {
      return getItemsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.speech.v1.CustomClass.ClassItem,
            com.google.cloud.speech.v1.CustomClass.ClassItem.Builder,
            com.google.cloud.speech.v1.CustomClass.ClassItemOrBuilder>
        getItemsFieldBuilder() {
      if (itemsBuilder_ == null) {
        itemsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.speech.v1.CustomClass.ClassItem,
                com.google.cloud.speech.v1.CustomClass.ClassItem.Builder,
                com.google.cloud.speech.v1.CustomClass.ClassItemOrBuilder>(
                items_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        items_ = null;
      }
      return itemsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.speech.v1.CustomClass)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.speech.v1.CustomClass)
  private static final com.google.cloud.speech.v1.CustomClass DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.speech.v1.CustomClass();
  }

  public static com.google.cloud.speech.v1.CustomClass getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CustomClass> PARSER =
      new com.google.protobuf.AbstractParser<CustomClass>() {
        @java.lang.Override
        public CustomClass parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CustomClass> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CustomClass> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.speech.v1.CustomClass getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
