/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/speech/v1/cloud_speech.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.speech.v1;

/**
 *
 *
 * <pre>
 * The only message returned to the client by the `LongRunningRecognize` method.
 * It contains the result as zero or more sequential `SpeechRecognitionResult`
 * messages. It is included in the `result.response` field of the `Operation`
 * returned by the `GetOperation` call of the `google::longrunning::Operations`
 * service.
 * </pre>
 *
 * Protobuf type {@code google.cloud.speech.v1.LongRunningRecognizeResponse}
 */
public final class LongRunningRecognizeResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.speech.v1.LongRunningRecognizeResponse)
    LongRunningRecognizeResponseOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use LongRunningRecognizeResponse.newBuilder() to construct.
  private LongRunningRecognizeResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LongRunningRecognizeResponse() {
    results_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LongRunningRecognizeResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.speech.v1.SpeechProto
        .internal_static_google_cloud_speech_v1_LongRunningRecognizeResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.speech.v1.SpeechProto
        .internal_static_google_cloud_speech_v1_LongRunningRecognizeResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.speech.v1.LongRunningRecognizeResponse.class,
            com.google.cloud.speech.v1.LongRunningRecognizeResponse.Builder.class);
  }

  private int bitField0_;
  public static final int RESULTS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.speech.v1.SpeechRecognitionResult> results_;

  /**
   *
   *
   * <pre>
   * Sequential list of transcription results corresponding to
   * sequential portions of audio.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1.SpeechRecognitionResult results = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.speech.v1.SpeechRecognitionResult> getResultsList() {
    return results_;
  }

  /**
   *
   *
   * <pre>
   * Sequential list of transcription results corresponding to
   * sequential portions of audio.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1.SpeechRecognitionResult results = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.speech.v1.SpeechRecognitionResultOrBuilder>
      getResultsOrBuilderList() {
    return results_;
  }

  /**
   *
   *
   * <pre>
   * Sequential list of transcription results corresponding to
   * sequential portions of audio.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1.SpeechRecognitionResult results = 2;</code>
   */
  @java.lang.Override
  public int getResultsCount() {
    return results_.size();
  }

  /**
   *
   *
   * <pre>
   * Sequential list of transcription results corresponding to
   * sequential portions of audio.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1.SpeechRecognitionResult results = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v1.SpeechRecognitionResult getResults(int index) {
    return results_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Sequential list of transcription results corresponding to
   * sequential portions of audio.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1.SpeechRecognitionResult results = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v1.SpeechRecognitionResultOrBuilder getResultsOrBuilder(
      int index) {
    return results_.get(index);
  }

  public static final int TOTAL_BILLED_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Duration totalBilledTime_;

  /**
   *
   *
   * <pre>
   * When available, billed audio seconds for the corresponding request.
   * </pre>
   *
   * <code>.google.protobuf.Duration total_billed_time = 3;</code>
   *
   * @return Whether the totalBilledTime field is set.
   */
  @java.lang.Override
  public boolean hasTotalBilledTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * When available, billed audio seconds for the corresponding request.
   * </pre>
   *
   * <code>.google.protobuf.Duration total_billed_time = 3;</code>
   *
   * @return The totalBilledTime.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTotalBilledTime() {
    return totalBilledTime_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : totalBilledTime_;
  }

  /**
   *
   *
   * <pre>
   * When available, billed audio seconds for the corresponding request.
   * </pre>
   *
   * <code>.google.protobuf.Duration total_billed_time = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTotalBilledTimeOrBuilder() {
    return totalBilledTime_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : totalBilledTime_;
  }

  public static final int OUTPUT_CONFIG_FIELD_NUMBER = 6;
  private com.google.cloud.speech.v1.TranscriptOutputConfig outputConfig_;

  /**
   *
   *
   * <pre>
   * Original output config if present in the request.
   * </pre>
   *
   * <code>.google.cloud.speech.v1.TranscriptOutputConfig output_config = 6;</code>
   *
   * @return Whether the outputConfig field is set.
   */
  @java.lang.Override
  public boolean hasOutputConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Original output config if present in the request.
   * </pre>
   *
   * <code>.google.cloud.speech.v1.TranscriptOutputConfig output_config = 6;</code>
   *
   * @return The outputConfig.
   */
  @java.lang.Override
  public com.google.cloud.speech.v1.TranscriptOutputConfig getOutputConfig() {
    return outputConfig_ == null
        ? com.google.cloud.speech.v1.TranscriptOutputConfig.getDefaultInstance()
        : outputConfig_;
  }

  /**
   *
   *
   * <pre>
   * Original output config if present in the request.
   * </pre>
   *
   * <code>.google.cloud.speech.v1.TranscriptOutputConfig output_config = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v1.TranscriptOutputConfigOrBuilder getOutputConfigOrBuilder() {
    return outputConfig_ == null
        ? com.google.cloud.speech.v1.TranscriptOutputConfig.getDefaultInstance()
        : outputConfig_;
  }

  public static final int OUTPUT_ERROR_FIELD_NUMBER = 7;
  private com.google.rpc.Status outputError_;

  /**
   *
   *
   * <pre>
   * If the transcript output fails this field contains the relevant error.
   * </pre>
   *
   * <code>.google.rpc.Status output_error = 7;</code>
   *
   * @return Whether the outputError field is set.
   */
  @java.lang.Override
  public boolean hasOutputError() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * If the transcript output fails this field contains the relevant error.
   * </pre>
   *
   * <code>.google.rpc.Status output_error = 7;</code>
   *
   * @return The outputError.
   */
  @java.lang.Override
  public com.google.rpc.Status getOutputError() {
    return outputError_ == null ? com.google.rpc.Status.getDefaultInstance() : outputError_;
  }

  /**
   *
   *
   * <pre>
   * If the transcript output fails this field contains the relevant error.
   * </pre>
   *
   * <code>.google.rpc.Status output_error = 7;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getOutputErrorOrBuilder() {
    return outputError_ == null ? com.google.rpc.Status.getDefaultInstance() : outputError_;
  }

  public static final int SPEECH_ADAPTATION_INFO_FIELD_NUMBER = 8;
  private com.google.cloud.speech.v1.SpeechAdaptationInfo speechAdaptationInfo_;

  /**
   *
   *
   * <pre>
   * Provides information on speech adaptation behavior in response
   * </pre>
   *
   * <code>.google.cloud.speech.v1.SpeechAdaptationInfo speech_adaptation_info = 8;</code>
   *
   * @return Whether the speechAdaptationInfo field is set.
   */
  @java.lang.Override
  public boolean hasSpeechAdaptationInfo() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Provides information on speech adaptation behavior in response
   * </pre>
   *
   * <code>.google.cloud.speech.v1.SpeechAdaptationInfo speech_adaptation_info = 8;</code>
   *
   * @return The speechAdaptationInfo.
   */
  @java.lang.Override
  public com.google.cloud.speech.v1.SpeechAdaptationInfo getSpeechAdaptationInfo() {
    return speechAdaptationInfo_ == null
        ? com.google.cloud.speech.v1.SpeechAdaptationInfo.getDefaultInstance()
        : speechAdaptationInfo_;
  }

  /**
   *
   *
   * <pre>
   * Provides information on speech adaptation behavior in response
   * </pre>
   *
   * <code>.google.cloud.speech.v1.SpeechAdaptationInfo speech_adaptation_info = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v1.SpeechAdaptationInfoOrBuilder
      getSpeechAdaptationInfoOrBuilder() {
    return speechAdaptationInfo_ == null
        ? com.google.cloud.speech.v1.SpeechAdaptationInfo.getDefaultInstance()
        : speechAdaptationInfo_;
  }

  public static final int REQUEST_ID_FIELD_NUMBER = 9;
  private long requestId_ = 0L;

  /**
   *
   *
   * <pre>
   * The ID associated with the request. This is a unique ID specific only to
   * the given request.
   * </pre>
   *
   * <code>int64 request_id = 9;</code>
   *
   * @return The requestId.
   */
  @java.lang.Override
  public long getRequestId() {
    return requestId_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < results_.size(); i++) {
      output.writeMessage(2, results_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getTotalBilledTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getOutputConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(7, getOutputError());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(8, getSpeechAdaptationInfo());
    }
    if (requestId_ != 0L) {
      output.writeInt64(9, requestId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < results_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, results_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getTotalBilledTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getOutputConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getOutputError());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(8, getSpeechAdaptationInfo());
    }
    if (requestId_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(9, requestId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.speech.v1.LongRunningRecognizeResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.speech.v1.LongRunningRecognizeResponse other =
        (com.google.cloud.speech.v1.LongRunningRecognizeResponse) obj;

    if (!getResultsList().equals(other.getResultsList())) return false;
    if (hasTotalBilledTime() != other.hasTotalBilledTime()) return false;
    if (hasTotalBilledTime()) {
      if (!getTotalBilledTime().equals(other.getTotalBilledTime())) return false;
    }
    if (hasOutputConfig() != other.hasOutputConfig()) return false;
    if (hasOutputConfig()) {
      if (!getOutputConfig().equals(other.getOutputConfig())) return false;
    }
    if (hasOutputError() != other.hasOutputError()) return false;
    if (hasOutputError()) {
      if (!getOutputError().equals(other.getOutputError())) return false;
    }
    if (hasSpeechAdaptationInfo() != other.hasSpeechAdaptationInfo()) return false;
    if (hasSpeechAdaptationInfo()) {
      if (!getSpeechAdaptationInfo().equals(other.getSpeechAdaptationInfo())) return false;
    }
    if (getRequestId() != other.getRequestId()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getResultsCount() > 0) {
      hash = (37 * hash) + RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getResultsList().hashCode();
    }
    if (hasTotalBilledTime()) {
      hash = (37 * hash) + TOTAL_BILLED_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getTotalBilledTime().hashCode();
    }
    if (hasOutputConfig()) {
      hash = (37 * hash) + OUTPUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getOutputConfig().hashCode();
    }
    if (hasOutputError()) {
      hash = (37 * hash) + OUTPUT_ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getOutputError().hashCode();
    }
    if (hasSpeechAdaptationInfo()) {
      hash = (37 * hash) + SPEECH_ADAPTATION_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getSpeechAdaptationInfo().hashCode();
    }
    hash = (37 * hash) + REQUEST_ID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getRequestId());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.speech.v1.LongRunningRecognizeResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v1.LongRunningRecognizeResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v1.LongRunningRecognizeResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v1.LongRunningRecognizeResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v1.LongRunningRecognizeResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v1.LongRunningRecognizeResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v1.LongRunningRecognizeResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v1.LongRunningRecognizeResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v1.LongRunningRecognizeResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v1.LongRunningRecognizeResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v1.LongRunningRecognizeResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v1.LongRunningRecognizeResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.speech.v1.LongRunningRecognizeResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The only message returned to the client by the `LongRunningRecognize` method.
   * It contains the result as zero or more sequential `SpeechRecognitionResult`
   * messages. It is included in the `result.response` field of the `Operation`
   * returned by the `GetOperation` call of the `google::longrunning::Operations`
   * service.
   * </pre>
   *
   * Protobuf type {@code google.cloud.speech.v1.LongRunningRecognizeResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.speech.v1.LongRunningRecognizeResponse)
      com.google.cloud.speech.v1.LongRunningRecognizeResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.speech.v1.SpeechProto
          .internal_static_google_cloud_speech_v1_LongRunningRecognizeResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.speech.v1.SpeechProto
          .internal_static_google_cloud_speech_v1_LongRunningRecognizeResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.speech.v1.LongRunningRecognizeResponse.class,
              com.google.cloud.speech.v1.LongRunningRecognizeResponse.Builder.class);
    }

    // Construct using com.google.cloud.speech.v1.LongRunningRecognizeResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getResultsFieldBuilder();
        getTotalBilledTimeFieldBuilder();
        getOutputConfigFieldBuilder();
        getOutputErrorFieldBuilder();
        getSpeechAdaptationInfoFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (resultsBuilder_ == null) {
        results_ = java.util.Collections.emptyList();
      } else {
        results_ = null;
        resultsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      totalBilledTime_ = null;
      if (totalBilledTimeBuilder_ != null) {
        totalBilledTimeBuilder_.dispose();
        totalBilledTimeBuilder_ = null;
      }
      outputConfig_ = null;
      if (outputConfigBuilder_ != null) {
        outputConfigBuilder_.dispose();
        outputConfigBuilder_ = null;
      }
      outputError_ = null;
      if (outputErrorBuilder_ != null) {
        outputErrorBuilder_.dispose();
        outputErrorBuilder_ = null;
      }
      speechAdaptationInfo_ = null;
      if (speechAdaptationInfoBuilder_ != null) {
        speechAdaptationInfoBuilder_.dispose();
        speechAdaptationInfoBuilder_ = null;
      }
      requestId_ = 0L;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.speech.v1.SpeechProto
          .internal_static_google_cloud_speech_v1_LongRunningRecognizeResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.speech.v1.LongRunningRecognizeResponse getDefaultInstanceForType() {
      return com.google.cloud.speech.v1.LongRunningRecognizeResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.speech.v1.LongRunningRecognizeResponse build() {
      com.google.cloud.speech.v1.LongRunningRecognizeResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.speech.v1.LongRunningRecognizeResponse buildPartial() {
      com.google.cloud.speech.v1.LongRunningRecognizeResponse result =
          new com.google.cloud.speech.v1.LongRunningRecognizeResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.speech.v1.LongRunningRecognizeResponse result) {
      if (resultsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          results_ = java.util.Collections.unmodifiableList(results_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.results_ = results_;
      } else {
        result.results_ = resultsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.speech.v1.LongRunningRecognizeResponse result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.totalBilledTime_ =
            totalBilledTimeBuilder_ == null ? totalBilledTime_ : totalBilledTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.outputConfig_ =
            outputConfigBuilder_ == null ? outputConfig_ : outputConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.outputError_ =
            outputErrorBuilder_ == null ? outputError_ : outputErrorBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.speechAdaptationInfo_ =
            speechAdaptationInfoBuilder_ == null
                ? speechAdaptationInfo_
                : speechAdaptationInfoBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.requestId_ = requestId_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.speech.v1.LongRunningRecognizeResponse) {
        return mergeFrom((com.google.cloud.speech.v1.LongRunningRecognizeResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.speech.v1.LongRunningRecognizeResponse other) {
      if (other == com.google.cloud.speech.v1.LongRunningRecognizeResponse.getDefaultInstance())
        return this;
      if (resultsBuilder_ == null) {
        if (!other.results_.isEmpty()) {
          if (results_.isEmpty()) {
            results_ = other.results_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureResultsIsMutable();
            results_.addAll(other.results_);
          }
          onChanged();
        }
      } else {
        if (!other.results_.isEmpty()) {
          if (resultsBuilder_.isEmpty()) {
            resultsBuilder_.dispose();
            resultsBuilder_ = null;
            results_ = other.results_;
            bitField0_ = (bitField0_ & ~0x00000001);
            resultsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getResultsFieldBuilder()
                    : null;
          } else {
            resultsBuilder_.addAllMessages(other.results_);
          }
        }
      }
      if (other.hasTotalBilledTime()) {
        mergeTotalBilledTime(other.getTotalBilledTime());
      }
      if (other.hasOutputConfig()) {
        mergeOutputConfig(other.getOutputConfig());
      }
      if (other.hasOutputError()) {
        mergeOutputError(other.getOutputError());
      }
      if (other.hasSpeechAdaptationInfo()) {
        mergeSpeechAdaptationInfo(other.getSpeechAdaptationInfo());
      }
      if (other.getRequestId() != 0L) {
        setRequestId(other.getRequestId());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                com.google.cloud.speech.v1.SpeechRecognitionResult m =
                    input.readMessage(
                        com.google.cloud.speech.v1.SpeechRecognitionResult.parser(),
                        extensionRegistry);
                if (resultsBuilder_ == null) {
                  ensureResultsIsMutable();
                  results_.add(m);
                } else {
                  resultsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getTotalBilledTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 50:
              {
                input.readMessage(getOutputConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getOutputErrorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getSpeechAdaptationInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 66
            case 72:
              {
                requestId_ = input.readInt64();
                bitField0_ |= 0x00000020;
                break;
              } // case 72
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.speech.v1.SpeechRecognitionResult> results_ =
        java.util.Collections.emptyList();

    private void ensureResultsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        results_ =
            new java.util.ArrayList<com.google.cloud.speech.v1.SpeechRecognitionResult>(results_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.speech.v1.SpeechRecognitionResult,
            com.google.cloud.speech.v1.SpeechRecognitionResult.Builder,
            com.google.cloud.speech.v1.SpeechRecognitionResultOrBuilder>
        resultsBuilder_;

    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechRecognitionResult results = 2;</code>
     */
    public java.util.List<com.google.cloud.speech.v1.SpeechRecognitionResult> getResultsList() {
      if (resultsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(results_);
      } else {
        return resultsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechRecognitionResult results = 2;</code>
     */
    public int getResultsCount() {
      if (resultsBuilder_ == null) {
        return results_.size();
      } else {
        return resultsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechRecognitionResult results = 2;</code>
     */
    public com.google.cloud.speech.v1.SpeechRecognitionResult getResults(int index) {
      if (resultsBuilder_ == null) {
        return results_.get(index);
      } else {
        return resultsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechRecognitionResult results = 2;</code>
     */
    public Builder setResults(int index, com.google.cloud.speech.v1.SpeechRecognitionResult value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultsIsMutable();
        results_.set(index, value);
        onChanged();
      } else {
        resultsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechRecognitionResult results = 2;</code>
     */
    public Builder setResults(
        int index, com.google.cloud.speech.v1.SpeechRecognitionResult.Builder builderForValue) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.set(index, builderForValue.build());
        onChanged();
      } else {
        resultsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechRecognitionResult results = 2;</code>
     */
    public Builder addResults(com.google.cloud.speech.v1.SpeechRecognitionResult value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultsIsMutable();
        results_.add(value);
        onChanged();
      } else {
        resultsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechRecognitionResult results = 2;</code>
     */
    public Builder addResults(int index, com.google.cloud.speech.v1.SpeechRecognitionResult value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultsIsMutable();
        results_.add(index, value);
        onChanged();
      } else {
        resultsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechRecognitionResult results = 2;</code>
     */
    public Builder addResults(
        com.google.cloud.speech.v1.SpeechRecognitionResult.Builder builderForValue) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.add(builderForValue.build());
        onChanged();
      } else {
        resultsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechRecognitionResult results = 2;</code>
     */
    public Builder addResults(
        int index, com.google.cloud.speech.v1.SpeechRecognitionResult.Builder builderForValue) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.add(index, builderForValue.build());
        onChanged();
      } else {
        resultsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechRecognitionResult results = 2;</code>
     */
    public Builder addAllResults(
        java.lang.Iterable<? extends com.google.cloud.speech.v1.SpeechRecognitionResult> values) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, results_);
        onChanged();
      } else {
        resultsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechRecognitionResult results = 2;</code>
     */
    public Builder clearResults() {
      if (resultsBuilder_ == null) {
        results_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        resultsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechRecognitionResult results = 2;</code>
     */
    public Builder removeResults(int index) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.remove(index);
        onChanged();
      } else {
        resultsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechRecognitionResult results = 2;</code>
     */
    public com.google.cloud.speech.v1.SpeechRecognitionResult.Builder getResultsBuilder(int index) {
      return getResultsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechRecognitionResult results = 2;</code>
     */
    public com.google.cloud.speech.v1.SpeechRecognitionResultOrBuilder getResultsOrBuilder(
        int index) {
      if (resultsBuilder_ == null) {
        return results_.get(index);
      } else {
        return resultsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechRecognitionResult results = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.speech.v1.SpeechRecognitionResultOrBuilder>
        getResultsOrBuilderList() {
      if (resultsBuilder_ != null) {
        return resultsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(results_);
      }
    }

    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechRecognitionResult results = 2;</code>
     */
    public com.google.cloud.speech.v1.SpeechRecognitionResult.Builder addResultsBuilder() {
      return getResultsFieldBuilder()
          .addBuilder(com.google.cloud.speech.v1.SpeechRecognitionResult.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechRecognitionResult results = 2;</code>
     */
    public com.google.cloud.speech.v1.SpeechRecognitionResult.Builder addResultsBuilder(int index) {
      return getResultsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.speech.v1.SpeechRecognitionResult.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.SpeechRecognitionResult results = 2;</code>
     */
    public java.util.List<com.google.cloud.speech.v1.SpeechRecognitionResult.Builder>
        getResultsBuilderList() {
      return getResultsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.speech.v1.SpeechRecognitionResult,
            com.google.cloud.speech.v1.SpeechRecognitionResult.Builder,
            com.google.cloud.speech.v1.SpeechRecognitionResultOrBuilder>
        getResultsFieldBuilder() {
      if (resultsBuilder_ == null) {
        resultsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.speech.v1.SpeechRecognitionResult,
                com.google.cloud.speech.v1.SpeechRecognitionResult.Builder,
                com.google.cloud.speech.v1.SpeechRecognitionResultOrBuilder>(
                results_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        results_ = null;
      }
      return resultsBuilder_;
    }

    private com.google.protobuf.Duration totalBilledTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        totalBilledTimeBuilder_;

    /**
     *
     *
     * <pre>
     * When available, billed audio seconds for the corresponding request.
     * </pre>
     *
     * <code>.google.protobuf.Duration total_billed_time = 3;</code>
     *
     * @return Whether the totalBilledTime field is set.
     */
    public boolean hasTotalBilledTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * When available, billed audio seconds for the corresponding request.
     * </pre>
     *
     * <code>.google.protobuf.Duration total_billed_time = 3;</code>
     *
     * @return The totalBilledTime.
     */
    public com.google.protobuf.Duration getTotalBilledTime() {
      if (totalBilledTimeBuilder_ == null) {
        return totalBilledTime_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : totalBilledTime_;
      } else {
        return totalBilledTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * When available, billed audio seconds for the corresponding request.
     * </pre>
     *
     * <code>.google.protobuf.Duration total_billed_time = 3;</code>
     */
    public Builder setTotalBilledTime(com.google.protobuf.Duration value) {
      if (totalBilledTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        totalBilledTime_ = value;
      } else {
        totalBilledTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * When available, billed audio seconds for the corresponding request.
     * </pre>
     *
     * <code>.google.protobuf.Duration total_billed_time = 3;</code>
     */
    public Builder setTotalBilledTime(com.google.protobuf.Duration.Builder builderForValue) {
      if (totalBilledTimeBuilder_ == null) {
        totalBilledTime_ = builderForValue.build();
      } else {
        totalBilledTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * When available, billed audio seconds for the corresponding request.
     * </pre>
     *
     * <code>.google.protobuf.Duration total_billed_time = 3;</code>
     */
    public Builder mergeTotalBilledTime(com.google.protobuf.Duration value) {
      if (totalBilledTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && totalBilledTime_ != null
            && totalBilledTime_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getTotalBilledTimeBuilder().mergeFrom(value);
        } else {
          totalBilledTime_ = value;
        }
      } else {
        totalBilledTimeBuilder_.mergeFrom(value);
      }
      if (totalBilledTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * When available, billed audio seconds for the corresponding request.
     * </pre>
     *
     * <code>.google.protobuf.Duration total_billed_time = 3;</code>
     */
    public Builder clearTotalBilledTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      totalBilledTime_ = null;
      if (totalBilledTimeBuilder_ != null) {
        totalBilledTimeBuilder_.dispose();
        totalBilledTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * When available, billed audio seconds for the corresponding request.
     * </pre>
     *
     * <code>.google.protobuf.Duration total_billed_time = 3;</code>
     */
    public com.google.protobuf.Duration.Builder getTotalBilledTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getTotalBilledTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * When available, billed audio seconds for the corresponding request.
     * </pre>
     *
     * <code>.google.protobuf.Duration total_billed_time = 3;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTotalBilledTimeOrBuilder() {
      if (totalBilledTimeBuilder_ != null) {
        return totalBilledTimeBuilder_.getMessageOrBuilder();
      } else {
        return totalBilledTime_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : totalBilledTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * When available, billed audio seconds for the corresponding request.
     * </pre>
     *
     * <code>.google.protobuf.Duration total_billed_time = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTotalBilledTimeFieldBuilder() {
      if (totalBilledTimeBuilder_ == null) {
        totalBilledTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTotalBilledTime(), getParentForChildren(), isClean());
        totalBilledTime_ = null;
      }
      return totalBilledTimeBuilder_;
    }

    private com.google.cloud.speech.v1.TranscriptOutputConfig outputConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v1.TranscriptOutputConfig,
            com.google.cloud.speech.v1.TranscriptOutputConfig.Builder,
            com.google.cloud.speech.v1.TranscriptOutputConfigOrBuilder>
        outputConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Original output config if present in the request.
     * </pre>
     *
     * <code>.google.cloud.speech.v1.TranscriptOutputConfig output_config = 6;</code>
     *
     * @return Whether the outputConfig field is set.
     */
    public boolean hasOutputConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Original output config if present in the request.
     * </pre>
     *
     * <code>.google.cloud.speech.v1.TranscriptOutputConfig output_config = 6;</code>
     *
     * @return The outputConfig.
     */
    public com.google.cloud.speech.v1.TranscriptOutputConfig getOutputConfig() {
      if (outputConfigBuilder_ == null) {
        return outputConfig_ == null
            ? com.google.cloud.speech.v1.TranscriptOutputConfig.getDefaultInstance()
            : outputConfig_;
      } else {
        return outputConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Original output config if present in the request.
     * </pre>
     *
     * <code>.google.cloud.speech.v1.TranscriptOutputConfig output_config = 6;</code>
     */
    public Builder setOutputConfig(com.google.cloud.speech.v1.TranscriptOutputConfig value) {
      if (outputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputConfig_ = value;
      } else {
        outputConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Original output config if present in the request.
     * </pre>
     *
     * <code>.google.cloud.speech.v1.TranscriptOutputConfig output_config = 6;</code>
     */
    public Builder setOutputConfig(
        com.google.cloud.speech.v1.TranscriptOutputConfig.Builder builderForValue) {
      if (outputConfigBuilder_ == null) {
        outputConfig_ = builderForValue.build();
      } else {
        outputConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Original output config if present in the request.
     * </pre>
     *
     * <code>.google.cloud.speech.v1.TranscriptOutputConfig output_config = 6;</code>
     */
    public Builder mergeOutputConfig(com.google.cloud.speech.v1.TranscriptOutputConfig value) {
      if (outputConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && outputConfig_ != null
            && outputConfig_
                != com.google.cloud.speech.v1.TranscriptOutputConfig.getDefaultInstance()) {
          getOutputConfigBuilder().mergeFrom(value);
        } else {
          outputConfig_ = value;
        }
      } else {
        outputConfigBuilder_.mergeFrom(value);
      }
      if (outputConfig_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Original output config if present in the request.
     * </pre>
     *
     * <code>.google.cloud.speech.v1.TranscriptOutputConfig output_config = 6;</code>
     */
    public Builder clearOutputConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      outputConfig_ = null;
      if (outputConfigBuilder_ != null) {
        outputConfigBuilder_.dispose();
        outputConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Original output config if present in the request.
     * </pre>
     *
     * <code>.google.cloud.speech.v1.TranscriptOutputConfig output_config = 6;</code>
     */
    public com.google.cloud.speech.v1.TranscriptOutputConfig.Builder getOutputConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getOutputConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Original output config if present in the request.
     * </pre>
     *
     * <code>.google.cloud.speech.v1.TranscriptOutputConfig output_config = 6;</code>
     */
    public com.google.cloud.speech.v1.TranscriptOutputConfigOrBuilder getOutputConfigOrBuilder() {
      if (outputConfigBuilder_ != null) {
        return outputConfigBuilder_.getMessageOrBuilder();
      } else {
        return outputConfig_ == null
            ? com.google.cloud.speech.v1.TranscriptOutputConfig.getDefaultInstance()
            : outputConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Original output config if present in the request.
     * </pre>
     *
     * <code>.google.cloud.speech.v1.TranscriptOutputConfig output_config = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v1.TranscriptOutputConfig,
            com.google.cloud.speech.v1.TranscriptOutputConfig.Builder,
            com.google.cloud.speech.v1.TranscriptOutputConfigOrBuilder>
        getOutputConfigFieldBuilder() {
      if (outputConfigBuilder_ == null) {
        outputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v1.TranscriptOutputConfig,
                com.google.cloud.speech.v1.TranscriptOutputConfig.Builder,
                com.google.cloud.speech.v1.TranscriptOutputConfigOrBuilder>(
                getOutputConfig(), getParentForChildren(), isClean());
        outputConfig_ = null;
      }
      return outputConfigBuilder_;
    }

    private com.google.rpc.Status outputError_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        outputErrorBuilder_;

    /**
     *
     *
     * <pre>
     * If the transcript output fails this field contains the relevant error.
     * </pre>
     *
     * <code>.google.rpc.Status output_error = 7;</code>
     *
     * @return Whether the outputError field is set.
     */
    public boolean hasOutputError() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * If the transcript output fails this field contains the relevant error.
     * </pre>
     *
     * <code>.google.rpc.Status output_error = 7;</code>
     *
     * @return The outputError.
     */
    public com.google.rpc.Status getOutputError() {
      if (outputErrorBuilder_ == null) {
        return outputError_ == null ? com.google.rpc.Status.getDefaultInstance() : outputError_;
      } else {
        return outputErrorBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * If the transcript output fails this field contains the relevant error.
     * </pre>
     *
     * <code>.google.rpc.Status output_error = 7;</code>
     */
    public Builder setOutputError(com.google.rpc.Status value) {
      if (outputErrorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputError_ = value;
      } else {
        outputErrorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If the transcript output fails this field contains the relevant error.
     * </pre>
     *
     * <code>.google.rpc.Status output_error = 7;</code>
     */
    public Builder setOutputError(com.google.rpc.Status.Builder builderForValue) {
      if (outputErrorBuilder_ == null) {
        outputError_ = builderForValue.build();
      } else {
        outputErrorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If the transcript output fails this field contains the relevant error.
     * </pre>
     *
     * <code>.google.rpc.Status output_error = 7;</code>
     */
    public Builder mergeOutputError(com.google.rpc.Status value) {
      if (outputErrorBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && outputError_ != null
            && outputError_ != com.google.rpc.Status.getDefaultInstance()) {
          getOutputErrorBuilder().mergeFrom(value);
        } else {
          outputError_ = value;
        }
      } else {
        outputErrorBuilder_.mergeFrom(value);
      }
      if (outputError_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If the transcript output fails this field contains the relevant error.
     * </pre>
     *
     * <code>.google.rpc.Status output_error = 7;</code>
     */
    public Builder clearOutputError() {
      bitField0_ = (bitField0_ & ~0x00000008);
      outputError_ = null;
      if (outputErrorBuilder_ != null) {
        outputErrorBuilder_.dispose();
        outputErrorBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If the transcript output fails this field contains the relevant error.
     * </pre>
     *
     * <code>.google.rpc.Status output_error = 7;</code>
     */
    public com.google.rpc.Status.Builder getOutputErrorBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getOutputErrorFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * If the transcript output fails this field contains the relevant error.
     * </pre>
     *
     * <code>.google.rpc.Status output_error = 7;</code>
     */
    public com.google.rpc.StatusOrBuilder getOutputErrorOrBuilder() {
      if (outputErrorBuilder_ != null) {
        return outputErrorBuilder_.getMessageOrBuilder();
      } else {
        return outputError_ == null ? com.google.rpc.Status.getDefaultInstance() : outputError_;
      }
    }

    /**
     *
     *
     * <pre>
     * If the transcript output fails this field contains the relevant error.
     * </pre>
     *
     * <code>.google.rpc.Status output_error = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getOutputErrorFieldBuilder() {
      if (outputErrorBuilder_ == null) {
        outputErrorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                getOutputError(), getParentForChildren(), isClean());
        outputError_ = null;
      }
      return outputErrorBuilder_;
    }

    private com.google.cloud.speech.v1.SpeechAdaptationInfo speechAdaptationInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v1.SpeechAdaptationInfo,
            com.google.cloud.speech.v1.SpeechAdaptationInfo.Builder,
            com.google.cloud.speech.v1.SpeechAdaptationInfoOrBuilder>
        speechAdaptationInfoBuilder_;

    /**
     *
     *
     * <pre>
     * Provides information on speech adaptation behavior in response
     * </pre>
     *
     * <code>.google.cloud.speech.v1.SpeechAdaptationInfo speech_adaptation_info = 8;</code>
     *
     * @return Whether the speechAdaptationInfo field is set.
     */
    public boolean hasSpeechAdaptationInfo() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Provides information on speech adaptation behavior in response
     * </pre>
     *
     * <code>.google.cloud.speech.v1.SpeechAdaptationInfo speech_adaptation_info = 8;</code>
     *
     * @return The speechAdaptationInfo.
     */
    public com.google.cloud.speech.v1.SpeechAdaptationInfo getSpeechAdaptationInfo() {
      if (speechAdaptationInfoBuilder_ == null) {
        return speechAdaptationInfo_ == null
            ? com.google.cloud.speech.v1.SpeechAdaptationInfo.getDefaultInstance()
            : speechAdaptationInfo_;
      } else {
        return speechAdaptationInfoBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Provides information on speech adaptation behavior in response
     * </pre>
     *
     * <code>.google.cloud.speech.v1.SpeechAdaptationInfo speech_adaptation_info = 8;</code>
     */
    public Builder setSpeechAdaptationInfo(com.google.cloud.speech.v1.SpeechAdaptationInfo value) {
      if (speechAdaptationInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        speechAdaptationInfo_ = value;
      } else {
        speechAdaptationInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Provides information on speech adaptation behavior in response
     * </pre>
     *
     * <code>.google.cloud.speech.v1.SpeechAdaptationInfo speech_adaptation_info = 8;</code>
     */
    public Builder setSpeechAdaptationInfo(
        com.google.cloud.speech.v1.SpeechAdaptationInfo.Builder builderForValue) {
      if (speechAdaptationInfoBuilder_ == null) {
        speechAdaptationInfo_ = builderForValue.build();
      } else {
        speechAdaptationInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Provides information on speech adaptation behavior in response
     * </pre>
     *
     * <code>.google.cloud.speech.v1.SpeechAdaptationInfo speech_adaptation_info = 8;</code>
     */
    public Builder mergeSpeechAdaptationInfo(
        com.google.cloud.speech.v1.SpeechAdaptationInfo value) {
      if (speechAdaptationInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && speechAdaptationInfo_ != null
            && speechAdaptationInfo_
                != com.google.cloud.speech.v1.SpeechAdaptationInfo.getDefaultInstance()) {
          getSpeechAdaptationInfoBuilder().mergeFrom(value);
        } else {
          speechAdaptationInfo_ = value;
        }
      } else {
        speechAdaptationInfoBuilder_.mergeFrom(value);
      }
      if (speechAdaptationInfo_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Provides information on speech adaptation behavior in response
     * </pre>
     *
     * <code>.google.cloud.speech.v1.SpeechAdaptationInfo speech_adaptation_info = 8;</code>
     */
    public Builder clearSpeechAdaptationInfo() {
      bitField0_ = (bitField0_ & ~0x00000010);
      speechAdaptationInfo_ = null;
      if (speechAdaptationInfoBuilder_ != null) {
        speechAdaptationInfoBuilder_.dispose();
        speechAdaptationInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Provides information on speech adaptation behavior in response
     * </pre>
     *
     * <code>.google.cloud.speech.v1.SpeechAdaptationInfo speech_adaptation_info = 8;</code>
     */
    public com.google.cloud.speech.v1.SpeechAdaptationInfo.Builder
        getSpeechAdaptationInfoBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getSpeechAdaptationInfoFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Provides information on speech adaptation behavior in response
     * </pre>
     *
     * <code>.google.cloud.speech.v1.SpeechAdaptationInfo speech_adaptation_info = 8;</code>
     */
    public com.google.cloud.speech.v1.SpeechAdaptationInfoOrBuilder
        getSpeechAdaptationInfoOrBuilder() {
      if (speechAdaptationInfoBuilder_ != null) {
        return speechAdaptationInfoBuilder_.getMessageOrBuilder();
      } else {
        return speechAdaptationInfo_ == null
            ? com.google.cloud.speech.v1.SpeechAdaptationInfo.getDefaultInstance()
            : speechAdaptationInfo_;
      }
    }

    /**
     *
     *
     * <pre>
     * Provides information on speech adaptation behavior in response
     * </pre>
     *
     * <code>.google.cloud.speech.v1.SpeechAdaptationInfo speech_adaptation_info = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v1.SpeechAdaptationInfo,
            com.google.cloud.speech.v1.SpeechAdaptationInfo.Builder,
            com.google.cloud.speech.v1.SpeechAdaptationInfoOrBuilder>
        getSpeechAdaptationInfoFieldBuilder() {
      if (speechAdaptationInfoBuilder_ == null) {
        speechAdaptationInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v1.SpeechAdaptationInfo,
                com.google.cloud.speech.v1.SpeechAdaptationInfo.Builder,
                com.google.cloud.speech.v1.SpeechAdaptationInfoOrBuilder>(
                getSpeechAdaptationInfo(), getParentForChildren(), isClean());
        speechAdaptationInfo_ = null;
      }
      return speechAdaptationInfoBuilder_;
    }

    private long requestId_;

    /**
     *
     *
     * <pre>
     * The ID associated with the request. This is a unique ID specific only to
     * the given request.
     * </pre>
     *
     * <code>int64 request_id = 9;</code>
     *
     * @return The requestId.
     */
    @java.lang.Override
    public long getRequestId() {
      return requestId_;
    }

    /**
     *
     *
     * <pre>
     * The ID associated with the request. This is a unique ID specific only to
     * the given request.
     * </pre>
     *
     * <code>int64 request_id = 9;</code>
     *
     * @param value The requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestId(long value) {

      requestId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The ID associated with the request. This is a unique ID specific only to
     * the given request.
     * </pre>
     *
     * <code>int64 request_id = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestId() {
      bitField0_ = (bitField0_ & ~0x00000020);
      requestId_ = 0L;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.speech.v1.LongRunningRecognizeResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.speech.v1.LongRunningRecognizeResponse)
  private static final com.google.cloud.speech.v1.LongRunningRecognizeResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.speech.v1.LongRunningRecognizeResponse();
  }

  public static com.google.cloud.speech.v1.LongRunningRecognizeResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LongRunningRecognizeResponse> PARSER =
      new com.google.protobuf.AbstractParser<LongRunningRecognizeResponse>() {
        @java.lang.Override
        public LongRunningRecognizeResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<LongRunningRecognizeResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LongRunningRecognizeResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.speech.v1.LongRunningRecognizeResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
