/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/speech/v1p1beta1/cloud_speech.proto

package com.google.cloud.speech.v1p1beta1;

/**
 *
 *
 * <pre>
 * The only message returned to the client by the `LongRunningRecognize` method.
 * It contains the result as zero or more sequential `SpeechRecognitionResult`
 * messages. It is included in the `result.response` field of the `Operation`
 * returned by the `GetOperation` call of the `google::longrunning::Operations`
 * service.
 * </pre>
 *
 * Protobuf type {@code google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse}
 */
public final class LongRunningRecognizeResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse)
    LongRunningRecognizeResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use LongRunningRecognizeResponse.newBuilder() to construct.
  private LongRunningRecognizeResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LongRunningRecognizeResponse() {
    results_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LongRunningRecognizeResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private LongRunningRecognizeResponse(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 18:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                results_ =
                    new java.util.ArrayList<
                        com.google.cloud.speech.v1p1beta1.SpeechRecognitionResult>();
                mutable_bitField0_ |= 0x00000001;
              }
              results_.add(
                  input.readMessage(
                      com.google.cloud.speech.v1p1beta1.SpeechRecognitionResult.parser(),
                      extensionRegistry));
              break;
            }
          case 50:
            {
              com.google.cloud.speech.v1p1beta1.TranscriptOutputConfig.Builder subBuilder = null;
              if (outputConfig_ != null) {
                subBuilder = outputConfig_.toBuilder();
              }
              outputConfig_ =
                  input.readMessage(
                      com.google.cloud.speech.v1p1beta1.TranscriptOutputConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(outputConfig_);
                outputConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 58:
            {
              com.google.rpc.Status.Builder subBuilder = null;
              if (outputError_ != null) {
                subBuilder = outputError_.toBuilder();
              }
              outputError_ = input.readMessage(com.google.rpc.Status.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(outputError_);
                outputError_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        results_ = java.util.Collections.unmodifiableList(results_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.speech.v1p1beta1.SpeechProto
        .internal_static_google_cloud_speech_v1p1beta1_LongRunningRecognizeResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.speech.v1p1beta1.SpeechProto
        .internal_static_google_cloud_speech_v1p1beta1_LongRunningRecognizeResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse.class,
            com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse.Builder.class);
  }

  public static final int RESULTS_FIELD_NUMBER = 2;
  private java.util.List<com.google.cloud.speech.v1p1beta1.SpeechRecognitionResult> results_;
  /**
   *
   *
   * <pre>
   * Sequential list of transcription results corresponding to
   * sequential portions of audio.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1p1beta1.SpeechRecognitionResult results = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.speech.v1p1beta1.SpeechRecognitionResult>
      getResultsList() {
    return results_;
  }
  /**
   *
   *
   * <pre>
   * Sequential list of transcription results corresponding to
   * sequential portions of audio.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1p1beta1.SpeechRecognitionResult results = 2;</code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.speech.v1p1beta1.SpeechRecognitionResultOrBuilder>
      getResultsOrBuilderList() {
    return results_;
  }
  /**
   *
   *
   * <pre>
   * Sequential list of transcription results corresponding to
   * sequential portions of audio.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1p1beta1.SpeechRecognitionResult results = 2;</code>
   */
  @java.lang.Override
  public int getResultsCount() {
    return results_.size();
  }
  /**
   *
   *
   * <pre>
   * Sequential list of transcription results corresponding to
   * sequential portions of audio.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1p1beta1.SpeechRecognitionResult results = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v1p1beta1.SpeechRecognitionResult getResults(int index) {
    return results_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Sequential list of transcription results corresponding to
   * sequential portions of audio.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1p1beta1.SpeechRecognitionResult results = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v1p1beta1.SpeechRecognitionResultOrBuilder getResultsOrBuilder(
      int index) {
    return results_.get(index);
  }

  public static final int OUTPUT_CONFIG_FIELD_NUMBER = 6;
  private com.google.cloud.speech.v1p1beta1.TranscriptOutputConfig outputConfig_;
  /**
   *
   *
   * <pre>
   * Original output config if present in the request.
   * </pre>
   *
   * <code>.google.cloud.speech.v1p1beta1.TranscriptOutputConfig output_config = 6;</code>
   *
   * @return Whether the outputConfig field is set.
   */
  @java.lang.Override
  public boolean hasOutputConfig() {
    return outputConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Original output config if present in the request.
   * </pre>
   *
   * <code>.google.cloud.speech.v1p1beta1.TranscriptOutputConfig output_config = 6;</code>
   *
   * @return The outputConfig.
   */
  @java.lang.Override
  public com.google.cloud.speech.v1p1beta1.TranscriptOutputConfig getOutputConfig() {
    return outputConfig_ == null
        ? com.google.cloud.speech.v1p1beta1.TranscriptOutputConfig.getDefaultInstance()
        : outputConfig_;
  }
  /**
   *
   *
   * <pre>
   * Original output config if present in the request.
   * </pre>
   *
   * <code>.google.cloud.speech.v1p1beta1.TranscriptOutputConfig output_config = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v1p1beta1.TranscriptOutputConfigOrBuilder
      getOutputConfigOrBuilder() {
    return getOutputConfig();
  }

  public static final int OUTPUT_ERROR_FIELD_NUMBER = 7;
  private com.google.rpc.Status outputError_;
  /**
   *
   *
   * <pre>
   * If the transcript output fails this field contains the relevant error.
   * </pre>
   *
   * <code>.google.rpc.Status output_error = 7;</code>
   *
   * @return Whether the outputError field is set.
   */
  @java.lang.Override
  public boolean hasOutputError() {
    return outputError_ != null;
  }
  /**
   *
   *
   * <pre>
   * If the transcript output fails this field contains the relevant error.
   * </pre>
   *
   * <code>.google.rpc.Status output_error = 7;</code>
   *
   * @return The outputError.
   */
  @java.lang.Override
  public com.google.rpc.Status getOutputError() {
    return outputError_ == null ? com.google.rpc.Status.getDefaultInstance() : outputError_;
  }
  /**
   *
   *
   * <pre>
   * If the transcript output fails this field contains the relevant error.
   * </pre>
   *
   * <code>.google.rpc.Status output_error = 7;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getOutputErrorOrBuilder() {
    return getOutputError();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < results_.size(); i++) {
      output.writeMessage(2, results_.get(i));
    }
    if (outputConfig_ != null) {
      output.writeMessage(6, getOutputConfig());
    }
    if (outputError_ != null) {
      output.writeMessage(7, getOutputError());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < results_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, results_.get(i));
    }
    if (outputConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getOutputConfig());
    }
    if (outputError_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getOutputError());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse other =
        (com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse) obj;

    if (!getResultsList().equals(other.getResultsList())) return false;
    if (hasOutputConfig() != other.hasOutputConfig()) return false;
    if (hasOutputConfig()) {
      if (!getOutputConfig().equals(other.getOutputConfig())) return false;
    }
    if (hasOutputError() != other.hasOutputError()) return false;
    if (hasOutputError()) {
      if (!getOutputError().equals(other.getOutputError())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getResultsCount() > 0) {
      hash = (37 * hash) + RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getResultsList().hashCode();
    }
    if (hasOutputConfig()) {
      hash = (37 * hash) + OUTPUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getOutputConfig().hashCode();
    }
    if (hasOutputError()) {
      hash = (37 * hash) + OUTPUT_ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getOutputError().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The only message returned to the client by the `LongRunningRecognize` method.
   * It contains the result as zero or more sequential `SpeechRecognitionResult`
   * messages. It is included in the `result.response` field of the `Operation`
   * returned by the `GetOperation` call of the `google::longrunning::Operations`
   * service.
   * </pre>
   *
   * Protobuf type {@code google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse)
      com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.speech.v1p1beta1.SpeechProto
          .internal_static_google_cloud_speech_v1p1beta1_LongRunningRecognizeResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.speech.v1p1beta1.SpeechProto
          .internal_static_google_cloud_speech_v1p1beta1_LongRunningRecognizeResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse.class,
              com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse.Builder.class);
    }

    // Construct using com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getResultsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (resultsBuilder_ == null) {
        results_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        resultsBuilder_.clear();
      }
      if (outputConfigBuilder_ == null) {
        outputConfig_ = null;
      } else {
        outputConfig_ = null;
        outputConfigBuilder_ = null;
      }
      if (outputErrorBuilder_ == null) {
        outputError_ = null;
      } else {
        outputError_ = null;
        outputErrorBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.speech.v1p1beta1.SpeechProto
          .internal_static_google_cloud_speech_v1p1beta1_LongRunningRecognizeResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse
        getDefaultInstanceForType() {
      return com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse build() {
      com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse buildPartial() {
      com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse result =
          new com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse(this);
      int from_bitField0_ = bitField0_;
      if (resultsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          results_ = java.util.Collections.unmodifiableList(results_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.results_ = results_;
      } else {
        result.results_ = resultsBuilder_.build();
      }
      if (outputConfigBuilder_ == null) {
        result.outputConfig_ = outputConfig_;
      } else {
        result.outputConfig_ = outputConfigBuilder_.build();
      }
      if (outputErrorBuilder_ == null) {
        result.outputError_ = outputError_;
      } else {
        result.outputError_ = outputErrorBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse) {
        return mergeFrom((com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse other) {
      if (other
          == com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse.getDefaultInstance())
        return this;
      if (resultsBuilder_ == null) {
        if (!other.results_.isEmpty()) {
          if (results_.isEmpty()) {
            results_ = other.results_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureResultsIsMutable();
            results_.addAll(other.results_);
          }
          onChanged();
        }
      } else {
        if (!other.results_.isEmpty()) {
          if (resultsBuilder_.isEmpty()) {
            resultsBuilder_.dispose();
            resultsBuilder_ = null;
            results_ = other.results_;
            bitField0_ = (bitField0_ & ~0x00000001);
            resultsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getResultsFieldBuilder()
                    : null;
          } else {
            resultsBuilder_.addAllMessages(other.results_);
          }
        }
      }
      if (other.hasOutputConfig()) {
        mergeOutputConfig(other.getOutputConfig());
      }
      if (other.hasOutputError()) {
        mergeOutputError(other.getOutputError());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse)
                e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.speech.v1p1beta1.SpeechRecognitionResult> results_ =
        java.util.Collections.emptyList();

    private void ensureResultsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        results_ =
            new java.util.ArrayList<com.google.cloud.speech.v1p1beta1.SpeechRecognitionResult>(
                results_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.speech.v1p1beta1.SpeechRecognitionResult,
            com.google.cloud.speech.v1p1beta1.SpeechRecognitionResult.Builder,
            com.google.cloud.speech.v1p1beta1.SpeechRecognitionResultOrBuilder>
        resultsBuilder_;

    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.SpeechRecognitionResult results = 2;</code>
     */
    public java.util.List<com.google.cloud.speech.v1p1beta1.SpeechRecognitionResult>
        getResultsList() {
      if (resultsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(results_);
      } else {
        return resultsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.SpeechRecognitionResult results = 2;</code>
     */
    public int getResultsCount() {
      if (resultsBuilder_ == null) {
        return results_.size();
      } else {
        return resultsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.SpeechRecognitionResult results = 2;</code>
     */
    public com.google.cloud.speech.v1p1beta1.SpeechRecognitionResult getResults(int index) {
      if (resultsBuilder_ == null) {
        return results_.get(index);
      } else {
        return resultsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.SpeechRecognitionResult results = 2;</code>
     */
    public Builder setResults(
        int index, com.google.cloud.speech.v1p1beta1.SpeechRecognitionResult value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultsIsMutable();
        results_.set(index, value);
        onChanged();
      } else {
        resultsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.SpeechRecognitionResult results = 2;</code>
     */
    public Builder setResults(
        int index,
        com.google.cloud.speech.v1p1beta1.SpeechRecognitionResult.Builder builderForValue) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.set(index, builderForValue.build());
        onChanged();
      } else {
        resultsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.SpeechRecognitionResult results = 2;</code>
     */
    public Builder addResults(com.google.cloud.speech.v1p1beta1.SpeechRecognitionResult value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultsIsMutable();
        results_.add(value);
        onChanged();
      } else {
        resultsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.SpeechRecognitionResult results = 2;</code>
     */
    public Builder addResults(
        int index, com.google.cloud.speech.v1p1beta1.SpeechRecognitionResult value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultsIsMutable();
        results_.add(index, value);
        onChanged();
      } else {
        resultsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.SpeechRecognitionResult results = 2;</code>
     */
    public Builder addResults(
        com.google.cloud.speech.v1p1beta1.SpeechRecognitionResult.Builder builderForValue) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.add(builderForValue.build());
        onChanged();
      } else {
        resultsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.SpeechRecognitionResult results = 2;</code>
     */
    public Builder addResults(
        int index,
        com.google.cloud.speech.v1p1beta1.SpeechRecognitionResult.Builder builderForValue) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.add(index, builderForValue.build());
        onChanged();
      } else {
        resultsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.SpeechRecognitionResult results = 2;</code>
     */
    public Builder addAllResults(
        java.lang.Iterable<? extends com.google.cloud.speech.v1p1beta1.SpeechRecognitionResult>
            values) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, results_);
        onChanged();
      } else {
        resultsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.SpeechRecognitionResult results = 2;</code>
     */
    public Builder clearResults() {
      if (resultsBuilder_ == null) {
        results_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        resultsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.SpeechRecognitionResult results = 2;</code>
     */
    public Builder removeResults(int index) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.remove(index);
        onChanged();
      } else {
        resultsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.SpeechRecognitionResult results = 2;</code>
     */
    public com.google.cloud.speech.v1p1beta1.SpeechRecognitionResult.Builder getResultsBuilder(
        int index) {
      return getResultsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.SpeechRecognitionResult results = 2;</code>
     */
    public com.google.cloud.speech.v1p1beta1.SpeechRecognitionResultOrBuilder getResultsOrBuilder(
        int index) {
      if (resultsBuilder_ == null) {
        return results_.get(index);
      } else {
        return resultsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.SpeechRecognitionResult results = 2;</code>
     */
    public java.util.List<
            ? extends com.google.cloud.speech.v1p1beta1.SpeechRecognitionResultOrBuilder>
        getResultsOrBuilderList() {
      if (resultsBuilder_ != null) {
        return resultsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(results_);
      }
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.SpeechRecognitionResult results = 2;</code>
     */
    public com.google.cloud.speech.v1p1beta1.SpeechRecognitionResult.Builder addResultsBuilder() {
      return getResultsFieldBuilder()
          .addBuilder(
              com.google.cloud.speech.v1p1beta1.SpeechRecognitionResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.SpeechRecognitionResult results = 2;</code>
     */
    public com.google.cloud.speech.v1p1beta1.SpeechRecognitionResult.Builder addResultsBuilder(
        int index) {
      return getResultsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.speech.v1p1beta1.SpeechRecognitionResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to
     * sequential portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.SpeechRecognitionResult results = 2;</code>
     */
    public java.util.List<com.google.cloud.speech.v1p1beta1.SpeechRecognitionResult.Builder>
        getResultsBuilderList() {
      return getResultsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.speech.v1p1beta1.SpeechRecognitionResult,
            com.google.cloud.speech.v1p1beta1.SpeechRecognitionResult.Builder,
            com.google.cloud.speech.v1p1beta1.SpeechRecognitionResultOrBuilder>
        getResultsFieldBuilder() {
      if (resultsBuilder_ == null) {
        resultsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.speech.v1p1beta1.SpeechRecognitionResult,
                com.google.cloud.speech.v1p1beta1.SpeechRecognitionResult.Builder,
                com.google.cloud.speech.v1p1beta1.SpeechRecognitionResultOrBuilder>(
                results_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        results_ = null;
      }
      return resultsBuilder_;
    }

    private com.google.cloud.speech.v1p1beta1.TranscriptOutputConfig outputConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v1p1beta1.TranscriptOutputConfig,
            com.google.cloud.speech.v1p1beta1.TranscriptOutputConfig.Builder,
            com.google.cloud.speech.v1p1beta1.TranscriptOutputConfigOrBuilder>
        outputConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Original output config if present in the request.
     * </pre>
     *
     * <code>.google.cloud.speech.v1p1beta1.TranscriptOutputConfig output_config = 6;</code>
     *
     * @return Whether the outputConfig field is set.
     */
    public boolean hasOutputConfig() {
      return outputConfigBuilder_ != null || outputConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Original output config if present in the request.
     * </pre>
     *
     * <code>.google.cloud.speech.v1p1beta1.TranscriptOutputConfig output_config = 6;</code>
     *
     * @return The outputConfig.
     */
    public com.google.cloud.speech.v1p1beta1.TranscriptOutputConfig getOutputConfig() {
      if (outputConfigBuilder_ == null) {
        return outputConfig_ == null
            ? com.google.cloud.speech.v1p1beta1.TranscriptOutputConfig.getDefaultInstance()
            : outputConfig_;
      } else {
        return outputConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Original output config if present in the request.
     * </pre>
     *
     * <code>.google.cloud.speech.v1p1beta1.TranscriptOutputConfig output_config = 6;</code>
     */
    public Builder setOutputConfig(com.google.cloud.speech.v1p1beta1.TranscriptOutputConfig value) {
      if (outputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputConfig_ = value;
        onChanged();
      } else {
        outputConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Original output config if present in the request.
     * </pre>
     *
     * <code>.google.cloud.speech.v1p1beta1.TranscriptOutputConfig output_config = 6;</code>
     */
    public Builder setOutputConfig(
        com.google.cloud.speech.v1p1beta1.TranscriptOutputConfig.Builder builderForValue) {
      if (outputConfigBuilder_ == null) {
        outputConfig_ = builderForValue.build();
        onChanged();
      } else {
        outputConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Original output config if present in the request.
     * </pre>
     *
     * <code>.google.cloud.speech.v1p1beta1.TranscriptOutputConfig output_config = 6;</code>
     */
    public Builder mergeOutputConfig(
        com.google.cloud.speech.v1p1beta1.TranscriptOutputConfig value) {
      if (outputConfigBuilder_ == null) {
        if (outputConfig_ != null) {
          outputConfig_ =
              com.google.cloud.speech.v1p1beta1.TranscriptOutputConfig.newBuilder(outputConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          outputConfig_ = value;
        }
        onChanged();
      } else {
        outputConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Original output config if present in the request.
     * </pre>
     *
     * <code>.google.cloud.speech.v1p1beta1.TranscriptOutputConfig output_config = 6;</code>
     */
    public Builder clearOutputConfig() {
      if (outputConfigBuilder_ == null) {
        outputConfig_ = null;
        onChanged();
      } else {
        outputConfig_ = null;
        outputConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Original output config if present in the request.
     * </pre>
     *
     * <code>.google.cloud.speech.v1p1beta1.TranscriptOutputConfig output_config = 6;</code>
     */
    public com.google.cloud.speech.v1p1beta1.TranscriptOutputConfig.Builder
        getOutputConfigBuilder() {

      onChanged();
      return getOutputConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Original output config if present in the request.
     * </pre>
     *
     * <code>.google.cloud.speech.v1p1beta1.TranscriptOutputConfig output_config = 6;</code>
     */
    public com.google.cloud.speech.v1p1beta1.TranscriptOutputConfigOrBuilder
        getOutputConfigOrBuilder() {
      if (outputConfigBuilder_ != null) {
        return outputConfigBuilder_.getMessageOrBuilder();
      } else {
        return outputConfig_ == null
            ? com.google.cloud.speech.v1p1beta1.TranscriptOutputConfig.getDefaultInstance()
            : outputConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Original output config if present in the request.
     * </pre>
     *
     * <code>.google.cloud.speech.v1p1beta1.TranscriptOutputConfig output_config = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v1p1beta1.TranscriptOutputConfig,
            com.google.cloud.speech.v1p1beta1.TranscriptOutputConfig.Builder,
            com.google.cloud.speech.v1p1beta1.TranscriptOutputConfigOrBuilder>
        getOutputConfigFieldBuilder() {
      if (outputConfigBuilder_ == null) {
        outputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v1p1beta1.TranscriptOutputConfig,
                com.google.cloud.speech.v1p1beta1.TranscriptOutputConfig.Builder,
                com.google.cloud.speech.v1p1beta1.TranscriptOutputConfigOrBuilder>(
                getOutputConfig(), getParentForChildren(), isClean());
        outputConfig_ = null;
      }
      return outputConfigBuilder_;
    }

    private com.google.rpc.Status outputError_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        outputErrorBuilder_;
    /**
     *
     *
     * <pre>
     * If the transcript output fails this field contains the relevant error.
     * </pre>
     *
     * <code>.google.rpc.Status output_error = 7;</code>
     *
     * @return Whether the outputError field is set.
     */
    public boolean hasOutputError() {
      return outputErrorBuilder_ != null || outputError_ != null;
    }
    /**
     *
     *
     * <pre>
     * If the transcript output fails this field contains the relevant error.
     * </pre>
     *
     * <code>.google.rpc.Status output_error = 7;</code>
     *
     * @return The outputError.
     */
    public com.google.rpc.Status getOutputError() {
      if (outputErrorBuilder_ == null) {
        return outputError_ == null ? com.google.rpc.Status.getDefaultInstance() : outputError_;
      } else {
        return outputErrorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If the transcript output fails this field contains the relevant error.
     * </pre>
     *
     * <code>.google.rpc.Status output_error = 7;</code>
     */
    public Builder setOutputError(com.google.rpc.Status value) {
      if (outputErrorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputError_ = value;
        onChanged();
      } else {
        outputErrorBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If the transcript output fails this field contains the relevant error.
     * </pre>
     *
     * <code>.google.rpc.Status output_error = 7;</code>
     */
    public Builder setOutputError(com.google.rpc.Status.Builder builderForValue) {
      if (outputErrorBuilder_ == null) {
        outputError_ = builderForValue.build();
        onChanged();
      } else {
        outputErrorBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If the transcript output fails this field contains the relevant error.
     * </pre>
     *
     * <code>.google.rpc.Status output_error = 7;</code>
     */
    public Builder mergeOutputError(com.google.rpc.Status value) {
      if (outputErrorBuilder_ == null) {
        if (outputError_ != null) {
          outputError_ =
              com.google.rpc.Status.newBuilder(outputError_).mergeFrom(value).buildPartial();
        } else {
          outputError_ = value;
        }
        onChanged();
      } else {
        outputErrorBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If the transcript output fails this field contains the relevant error.
     * </pre>
     *
     * <code>.google.rpc.Status output_error = 7;</code>
     */
    public Builder clearOutputError() {
      if (outputErrorBuilder_ == null) {
        outputError_ = null;
        onChanged();
      } else {
        outputError_ = null;
        outputErrorBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If the transcript output fails this field contains the relevant error.
     * </pre>
     *
     * <code>.google.rpc.Status output_error = 7;</code>
     */
    public com.google.rpc.Status.Builder getOutputErrorBuilder() {

      onChanged();
      return getOutputErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If the transcript output fails this field contains the relevant error.
     * </pre>
     *
     * <code>.google.rpc.Status output_error = 7;</code>
     */
    public com.google.rpc.StatusOrBuilder getOutputErrorOrBuilder() {
      if (outputErrorBuilder_ != null) {
        return outputErrorBuilder_.getMessageOrBuilder();
      } else {
        return outputError_ == null ? com.google.rpc.Status.getDefaultInstance() : outputError_;
      }
    }
    /**
     *
     *
     * <pre>
     * If the transcript output fails this field contains the relevant error.
     * </pre>
     *
     * <code>.google.rpc.Status output_error = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getOutputErrorFieldBuilder() {
      if (outputErrorBuilder_ == null) {
        outputErrorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                getOutputError(), getParentForChildren(), isClean());
        outputError_ = null;
      }
      return outputErrorBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse)
  private static final com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse();
  }

  public static com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LongRunningRecognizeResponse> PARSER =
      new com.google.protobuf.AbstractParser<LongRunningRecognizeResponse>() {
        @java.lang.Override
        public LongRunningRecognizeResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new LongRunningRecognizeResponse(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<LongRunningRecognizeResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LongRunningRecognizeResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
