/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/speech/v1p1beta1/resource.proto

package com.google.cloud.speech.v1p1beta1;

/**
 *
 *
 * <pre>
 * Provides "hints" to the speech recognizer to favor specific words and phrases
 * in the results.
 * </pre>
 *
 * Protobuf type {@code google.cloud.speech.v1p1beta1.PhraseSet}
 */
public final class PhraseSet extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.speech.v1p1beta1.PhraseSet)
    PhraseSetOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PhraseSet.newBuilder() to construct.
  private PhraseSet(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PhraseSet() {
    name_ = "";
    phrases_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PhraseSet();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private PhraseSet(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                phrases_ =
                    new java.util.ArrayList<com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase>();
                mutable_bitField0_ |= 0x00000001;
              }
              phrases_.add(
                  input.readMessage(
                      com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase.parser(),
                      extensionRegistry));
              break;
            }
          case 37:
            {
              boost_ = input.readFloat();
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        phrases_ = java.util.Collections.unmodifiableList(phrases_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.speech.v1p1beta1.SpeechResourceProto
        .internal_static_google_cloud_speech_v1p1beta1_PhraseSet_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.speech.v1p1beta1.SpeechResourceProto
        .internal_static_google_cloud_speech_v1p1beta1_PhraseSet_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.speech.v1p1beta1.PhraseSet.class,
            com.google.cloud.speech.v1p1beta1.PhraseSet.Builder.class);
  }

  public interface PhraseOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.speech.v1p1beta1.PhraseSet.Phrase)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The phrase itself.
     * </pre>
     *
     * <code>string value = 1;</code>
     *
     * @return The value.
     */
    java.lang.String getValue();
    /**
     *
     *
     * <pre>
     * The phrase itself.
     * </pre>
     *
     * <code>string value = 1;</code>
     *
     * @return The bytes for value.
     */
    com.google.protobuf.ByteString getValueBytes();

    /**
     *
     *
     * <pre>
     * Hint Boost. Overrides the boost set at the phrase set level.
     * Positive value will increase the probability that a specific phrase will
     * be recognized over other similar sounding phrases. The higher the boost,
     * the higher the chance of false positive recognition as well. Negative
     * boost values would correspond to anti-biasing. Anti-biasing is not
     * enabled, so negative boost will simply be ignored. Though `boost` can
     * accept a wide range of positive values, most use cases are best served
     * with values between 0 and 20. We recommend using a binary search approach
     * to finding the optimal value for your use case. Speech recognition
     * will skip PhraseSets with a boost value of 0.
     * </pre>
     *
     * <code>float boost = 2;</code>
     *
     * @return The boost.
     */
    float getBoost();
  }
  /**
   *
   *
   * <pre>
   * A phrases containing words and phrase "hints" so that
   * the speech recognition is more likely to recognize them. This can be used
   * to improve the accuracy for specific words and phrases, for example, if
   * specific commands are typically spoken by the user. This can also be used
   * to add additional words to the vocabulary of the recognizer. See
   * [usage limits](https://cloud.google.com/speech-to-text/quotas#content).
   * List items can also include pre-built or custom classes containing groups
   * of words that represent common concepts that occur in natural language. For
   * example, rather than providing a phrase hint for every month of the
   * year (e.g. "i was born in january", "i was born in febuary", ...), use the
   * pre-built `$MONTH` class improves the likelihood of correctly transcribing
   * audio that includes months (e.g. "i was born in $month").
   * To refer to pre-built classes, use the class' symbol prepended with `$`
   * e.g. `$MONTH`. To refer to custom classes that were defined inline in the
   * request, set the class's `custom_class_id` to a string unique to all class
   * resources and inline classes. Then use the class' id wrapped in $`{...}`
   * e.g. "${my-months}". To refer to custom classes resources, use the class'
   * id wrapped in `${}` (e.g. `${my-months}`).
   * </pre>
   *
   * Protobuf type {@code google.cloud.speech.v1p1beta1.PhraseSet.Phrase}
   */
  public static final class Phrase extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.speech.v1p1beta1.PhraseSet.Phrase)
      PhraseOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Phrase.newBuilder() to construct.
    private Phrase(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Phrase() {
      value_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Phrase();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Phrase(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                value_ = s;
                break;
              }
            case 21:
              {
                boost_ = input.readFloat();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.speech.v1p1beta1.SpeechResourceProto
          .internal_static_google_cloud_speech_v1p1beta1_PhraseSet_Phrase_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.speech.v1p1beta1.SpeechResourceProto
          .internal_static_google_cloud_speech_v1p1beta1_PhraseSet_Phrase_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase.class,
              com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase.Builder.class);
    }

    public static final int VALUE_FIELD_NUMBER = 1;
    private volatile java.lang.Object value_;
    /**
     *
     *
     * <pre>
     * The phrase itself.
     * </pre>
     *
     * <code>string value = 1;</code>
     *
     * @return The value.
     */
    @java.lang.Override
    public java.lang.String getValue() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        value_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The phrase itself.
     * </pre>
     *
     * <code>string value = 1;</code>
     *
     * @return The bytes for value.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getValueBytes() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        value_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int BOOST_FIELD_NUMBER = 2;
    private float boost_;
    /**
     *
     *
     * <pre>
     * Hint Boost. Overrides the boost set at the phrase set level.
     * Positive value will increase the probability that a specific phrase will
     * be recognized over other similar sounding phrases. The higher the boost,
     * the higher the chance of false positive recognition as well. Negative
     * boost values would correspond to anti-biasing. Anti-biasing is not
     * enabled, so negative boost will simply be ignored. Though `boost` can
     * accept a wide range of positive values, most use cases are best served
     * with values between 0 and 20. We recommend using a binary search approach
     * to finding the optimal value for your use case. Speech recognition
     * will skip PhraseSets with a boost value of 0.
     * </pre>
     *
     * <code>float boost = 2;</code>
     *
     * @return The boost.
     */
    @java.lang.Override
    public float getBoost() {
      return boost_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getValueBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, value_);
      }
      if (boost_ != 0F) {
        output.writeFloat(2, boost_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getValueBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, value_);
      }
      if (boost_ != 0F) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, boost_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase)) {
        return super.equals(obj);
      }
      com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase other =
          (com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase) obj;

      if (!getValue().equals(other.getValue())) return false;
      if (java.lang.Float.floatToIntBits(getBoost())
          != java.lang.Float.floatToIntBits(other.getBoost())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getValue().hashCode();
      hash = (37 * hash) + BOOST_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getBoost());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A phrases containing words and phrase "hints" so that
     * the speech recognition is more likely to recognize them. This can be used
     * to improve the accuracy for specific words and phrases, for example, if
     * specific commands are typically spoken by the user. This can also be used
     * to add additional words to the vocabulary of the recognizer. See
     * [usage limits](https://cloud.google.com/speech-to-text/quotas#content).
     * List items can also include pre-built or custom classes containing groups
     * of words that represent common concepts that occur in natural language. For
     * example, rather than providing a phrase hint for every month of the
     * year (e.g. "i was born in january", "i was born in febuary", ...), use the
     * pre-built `$MONTH` class improves the likelihood of correctly transcribing
     * audio that includes months (e.g. "i was born in $month").
     * To refer to pre-built classes, use the class' symbol prepended with `$`
     * e.g. `$MONTH`. To refer to custom classes that were defined inline in the
     * request, set the class's `custom_class_id` to a string unique to all class
     * resources and inline classes. Then use the class' id wrapped in $`{...}`
     * e.g. "${my-months}". To refer to custom classes resources, use the class'
     * id wrapped in `${}` (e.g. `${my-months}`).
     * </pre>
     *
     * Protobuf type {@code google.cloud.speech.v1p1beta1.PhraseSet.Phrase}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.speech.v1p1beta1.PhraseSet.Phrase)
        com.google.cloud.speech.v1p1beta1.PhraseSet.PhraseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.speech.v1p1beta1.SpeechResourceProto
            .internal_static_google_cloud_speech_v1p1beta1_PhraseSet_Phrase_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.speech.v1p1beta1.SpeechResourceProto
            .internal_static_google_cloud_speech_v1p1beta1_PhraseSet_Phrase_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase.class,
                com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase.Builder.class);
      }

      // Construct using com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        value_ = "";

        boost_ = 0F;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.speech.v1p1beta1.SpeechResourceProto
            .internal_static_google_cloud_speech_v1p1beta1_PhraseSet_Phrase_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase getDefaultInstanceForType() {
        return com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase build() {
        com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase buildPartial() {
        com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase result =
            new com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase(this);
        result.value_ = value_;
        result.boost_ = boost_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase) {
          return mergeFrom((com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase other) {
        if (other == com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase.getDefaultInstance())
          return this;
        if (!other.getValue().isEmpty()) {
          value_ = other.value_;
          onChanged();
        }
        if (other.getBoost() != 0F) {
          setBoost(other.getBoost());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object value_ = "";
      /**
       *
       *
       * <pre>
       * The phrase itself.
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @return The value.
       */
      public java.lang.String getValue() {
        java.lang.Object ref = value_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          value_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The phrase itself.
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @return The bytes for value.
       */
      public com.google.protobuf.ByteString getValueBytes() {
        java.lang.Object ref = value_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          value_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The phrase itself.
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @param value The value to set.
       * @return This builder for chaining.
       */
      public Builder setValue(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        value_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The phrase itself.
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValue() {

        value_ = getDefaultInstance().getValue();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The phrase itself.
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @param value The bytes for value to set.
       * @return This builder for chaining.
       */
      public Builder setValueBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        value_ = value;
        onChanged();
        return this;
      }

      private float boost_;
      /**
       *
       *
       * <pre>
       * Hint Boost. Overrides the boost set at the phrase set level.
       * Positive value will increase the probability that a specific phrase will
       * be recognized over other similar sounding phrases. The higher the boost,
       * the higher the chance of false positive recognition as well. Negative
       * boost values would correspond to anti-biasing. Anti-biasing is not
       * enabled, so negative boost will simply be ignored. Though `boost` can
       * accept a wide range of positive values, most use cases are best served
       * with values between 0 and 20. We recommend using a binary search approach
       * to finding the optimal value for your use case. Speech recognition
       * will skip PhraseSets with a boost value of 0.
       * </pre>
       *
       * <code>float boost = 2;</code>
       *
       * @return The boost.
       */
      @java.lang.Override
      public float getBoost() {
        return boost_;
      }
      /**
       *
       *
       * <pre>
       * Hint Boost. Overrides the boost set at the phrase set level.
       * Positive value will increase the probability that a specific phrase will
       * be recognized over other similar sounding phrases. The higher the boost,
       * the higher the chance of false positive recognition as well. Negative
       * boost values would correspond to anti-biasing. Anti-biasing is not
       * enabled, so negative boost will simply be ignored. Though `boost` can
       * accept a wide range of positive values, most use cases are best served
       * with values between 0 and 20. We recommend using a binary search approach
       * to finding the optimal value for your use case. Speech recognition
       * will skip PhraseSets with a boost value of 0.
       * </pre>
       *
       * <code>float boost = 2;</code>
       *
       * @param value The boost to set.
       * @return This builder for chaining.
       */
      public Builder setBoost(float value) {

        boost_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Hint Boost. Overrides the boost set at the phrase set level.
       * Positive value will increase the probability that a specific phrase will
       * be recognized over other similar sounding phrases. The higher the boost,
       * the higher the chance of false positive recognition as well. Negative
       * boost values would correspond to anti-biasing. Anti-biasing is not
       * enabled, so negative boost will simply be ignored. Though `boost` can
       * accept a wide range of positive values, most use cases are best served
       * with values between 0 and 20. We recommend using a binary search approach
       * to finding the optimal value for your use case. Speech recognition
       * will skip PhraseSets with a boost value of 0.
       * </pre>
       *
       * <code>float boost = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBoost() {

        boost_ = 0F;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.speech.v1p1beta1.PhraseSet.Phrase)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.speech.v1p1beta1.PhraseSet.Phrase)
    private static final com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase();
    }

    public static com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Phrase> PARSER =
        new com.google.protobuf.AbstractParser<Phrase>() {
          @java.lang.Override
          public Phrase parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Phrase(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Phrase> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Phrase> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The resource name of the phrase set.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the phrase set.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PHRASES_FIELD_NUMBER = 2;
  private java.util.List<com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase> phrases_;
  /**
   *
   *
   * <pre>
   * A list of word and phrases.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1p1beta1.PhraseSet.Phrase phrases = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase> getPhrasesList() {
    return phrases_;
  }
  /**
   *
   *
   * <pre>
   * A list of word and phrases.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1p1beta1.PhraseSet.Phrase phrases = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.speech.v1p1beta1.PhraseSet.PhraseOrBuilder>
      getPhrasesOrBuilderList() {
    return phrases_;
  }
  /**
   *
   *
   * <pre>
   * A list of word and phrases.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1p1beta1.PhraseSet.Phrase phrases = 2;</code>
   */
  @java.lang.Override
  public int getPhrasesCount() {
    return phrases_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of word and phrases.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1p1beta1.PhraseSet.Phrase phrases = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase getPhrases(int index) {
    return phrases_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of word and phrases.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1p1beta1.PhraseSet.Phrase phrases = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v1p1beta1.PhraseSet.PhraseOrBuilder getPhrasesOrBuilder(
      int index) {
    return phrases_.get(index);
  }

  public static final int BOOST_FIELD_NUMBER = 4;
  private float boost_;
  /**
   *
   *
   * <pre>
   * Hint Boost. Positive value will increase the probability that a specific
   * phrase will be recognized over other similar sounding phrases. The higher
   * the boost, the higher the chance of false positive recognition as well.
   * Negative boost values would correspond to anti-biasing. Anti-biasing is not
   * enabled, so negative boost will simply be ignored. Though `boost` can
   * accept a wide range of positive values, most use cases are best served with
   * values between 0 (exclusive) and 20. We recommend using a binary search
   * approach to finding the optimal value for your use case. Speech recognition
   * will skip PhraseSets with a boost value of 0.
   * </pre>
   *
   * <code>float boost = 4;</code>
   *
   * @return The boost.
   */
  @java.lang.Override
  public float getBoost() {
    return boost_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < phrases_.size(); i++) {
      output.writeMessage(2, phrases_.get(i));
    }
    if (boost_ != 0F) {
      output.writeFloat(4, boost_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    for (int i = 0; i < phrases_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, phrases_.get(i));
    }
    if (boost_ != 0F) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(4, boost_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.speech.v1p1beta1.PhraseSet)) {
      return super.equals(obj);
    }
    com.google.cloud.speech.v1p1beta1.PhraseSet other =
        (com.google.cloud.speech.v1p1beta1.PhraseSet) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getPhrasesList().equals(other.getPhrasesList())) return false;
    if (java.lang.Float.floatToIntBits(getBoost())
        != java.lang.Float.floatToIntBits(other.getBoost())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getPhrasesCount() > 0) {
      hash = (37 * hash) + PHRASES_FIELD_NUMBER;
      hash = (53 * hash) + getPhrasesList().hashCode();
    }
    hash = (37 * hash) + BOOST_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getBoost());
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.speech.v1p1beta1.PhraseSet parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v1p1beta1.PhraseSet parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v1p1beta1.PhraseSet parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v1p1beta1.PhraseSet parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v1p1beta1.PhraseSet parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v1p1beta1.PhraseSet parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v1p1beta1.PhraseSet parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v1p1beta1.PhraseSet parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v1p1beta1.PhraseSet parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v1p1beta1.PhraseSet parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v1p1beta1.PhraseSet parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v1p1beta1.PhraseSet parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.speech.v1p1beta1.PhraseSet prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Provides "hints" to the speech recognizer to favor specific words and phrases
   * in the results.
   * </pre>
   *
   * Protobuf type {@code google.cloud.speech.v1p1beta1.PhraseSet}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.speech.v1p1beta1.PhraseSet)
      com.google.cloud.speech.v1p1beta1.PhraseSetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.speech.v1p1beta1.SpeechResourceProto
          .internal_static_google_cloud_speech_v1p1beta1_PhraseSet_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.speech.v1p1beta1.SpeechResourceProto
          .internal_static_google_cloud_speech_v1p1beta1_PhraseSet_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.speech.v1p1beta1.PhraseSet.class,
              com.google.cloud.speech.v1p1beta1.PhraseSet.Builder.class);
    }

    // Construct using com.google.cloud.speech.v1p1beta1.PhraseSet.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPhrasesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      if (phrasesBuilder_ == null) {
        phrases_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        phrasesBuilder_.clear();
      }
      boost_ = 0F;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.speech.v1p1beta1.SpeechResourceProto
          .internal_static_google_cloud_speech_v1p1beta1_PhraseSet_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.speech.v1p1beta1.PhraseSet getDefaultInstanceForType() {
      return com.google.cloud.speech.v1p1beta1.PhraseSet.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.speech.v1p1beta1.PhraseSet build() {
      com.google.cloud.speech.v1p1beta1.PhraseSet result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.speech.v1p1beta1.PhraseSet buildPartial() {
      com.google.cloud.speech.v1p1beta1.PhraseSet result =
          new com.google.cloud.speech.v1p1beta1.PhraseSet(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      if (phrasesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          phrases_ = java.util.Collections.unmodifiableList(phrases_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.phrases_ = phrases_;
      } else {
        result.phrases_ = phrasesBuilder_.build();
      }
      result.boost_ = boost_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.speech.v1p1beta1.PhraseSet) {
        return mergeFrom((com.google.cloud.speech.v1p1beta1.PhraseSet) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.speech.v1p1beta1.PhraseSet other) {
      if (other == com.google.cloud.speech.v1p1beta1.PhraseSet.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (phrasesBuilder_ == null) {
        if (!other.phrases_.isEmpty()) {
          if (phrases_.isEmpty()) {
            phrases_ = other.phrases_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensurePhrasesIsMutable();
            phrases_.addAll(other.phrases_);
          }
          onChanged();
        }
      } else {
        if (!other.phrases_.isEmpty()) {
          if (phrasesBuilder_.isEmpty()) {
            phrasesBuilder_.dispose();
            phrasesBuilder_ = null;
            phrases_ = other.phrases_;
            bitField0_ = (bitField0_ & ~0x00000001);
            phrasesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPhrasesFieldBuilder()
                    : null;
          } else {
            phrasesBuilder_.addAllMessages(other.phrases_);
          }
        }
      }
      if (other.getBoost() != 0F) {
        setBoost(other.getBoost());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.speech.v1p1beta1.PhraseSet parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.speech.v1p1beta1.PhraseSet) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the phrase set.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the phrase set.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the phrase set.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the phrase set.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the phrase set.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase> phrases_ =
        java.util.Collections.emptyList();

    private void ensurePhrasesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        phrases_ =
            new java.util.ArrayList<com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase>(phrases_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase,
            com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase.Builder,
            com.google.cloud.speech.v1p1beta1.PhraseSet.PhraseOrBuilder>
        phrasesBuilder_;

    /**
     *
     *
     * <pre>
     * A list of word and phrases.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.PhraseSet.Phrase phrases = 2;</code>
     */
    public java.util.List<com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase> getPhrasesList() {
      if (phrasesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(phrases_);
      } else {
        return phrasesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of word and phrases.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.PhraseSet.Phrase phrases = 2;</code>
     */
    public int getPhrasesCount() {
      if (phrasesBuilder_ == null) {
        return phrases_.size();
      } else {
        return phrasesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of word and phrases.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.PhraseSet.Phrase phrases = 2;</code>
     */
    public com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase getPhrases(int index) {
      if (phrasesBuilder_ == null) {
        return phrases_.get(index);
      } else {
        return phrasesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of word and phrases.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.PhraseSet.Phrase phrases = 2;</code>
     */
    public Builder setPhrases(int index, com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase value) {
      if (phrasesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePhrasesIsMutable();
        phrases_.set(index, value);
        onChanged();
      } else {
        phrasesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of word and phrases.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.PhraseSet.Phrase phrases = 2;</code>
     */
    public Builder setPhrases(
        int index, com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase.Builder builderForValue) {
      if (phrasesBuilder_ == null) {
        ensurePhrasesIsMutable();
        phrases_.set(index, builderForValue.build());
        onChanged();
      } else {
        phrasesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of word and phrases.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.PhraseSet.Phrase phrases = 2;</code>
     */
    public Builder addPhrases(com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase value) {
      if (phrasesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePhrasesIsMutable();
        phrases_.add(value);
        onChanged();
      } else {
        phrasesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of word and phrases.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.PhraseSet.Phrase phrases = 2;</code>
     */
    public Builder addPhrases(int index, com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase value) {
      if (phrasesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePhrasesIsMutable();
        phrases_.add(index, value);
        onChanged();
      } else {
        phrasesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of word and phrases.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.PhraseSet.Phrase phrases = 2;</code>
     */
    public Builder addPhrases(
        com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase.Builder builderForValue) {
      if (phrasesBuilder_ == null) {
        ensurePhrasesIsMutable();
        phrases_.add(builderForValue.build());
        onChanged();
      } else {
        phrasesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of word and phrases.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.PhraseSet.Phrase phrases = 2;</code>
     */
    public Builder addPhrases(
        int index, com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase.Builder builderForValue) {
      if (phrasesBuilder_ == null) {
        ensurePhrasesIsMutable();
        phrases_.add(index, builderForValue.build());
        onChanged();
      } else {
        phrasesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of word and phrases.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.PhraseSet.Phrase phrases = 2;</code>
     */
    public Builder addAllPhrases(
        java.lang.Iterable<? extends com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase> values) {
      if (phrasesBuilder_ == null) {
        ensurePhrasesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, phrases_);
        onChanged();
      } else {
        phrasesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of word and phrases.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.PhraseSet.Phrase phrases = 2;</code>
     */
    public Builder clearPhrases() {
      if (phrasesBuilder_ == null) {
        phrases_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        phrasesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of word and phrases.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.PhraseSet.Phrase phrases = 2;</code>
     */
    public Builder removePhrases(int index) {
      if (phrasesBuilder_ == null) {
        ensurePhrasesIsMutable();
        phrases_.remove(index);
        onChanged();
      } else {
        phrasesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of word and phrases.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.PhraseSet.Phrase phrases = 2;</code>
     */
    public com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase.Builder getPhrasesBuilder(int index) {
      return getPhrasesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of word and phrases.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.PhraseSet.Phrase phrases = 2;</code>
     */
    public com.google.cloud.speech.v1p1beta1.PhraseSet.PhraseOrBuilder getPhrasesOrBuilder(
        int index) {
      if (phrasesBuilder_ == null) {
        return phrases_.get(index);
      } else {
        return phrasesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of word and phrases.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.PhraseSet.Phrase phrases = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.speech.v1p1beta1.PhraseSet.PhraseOrBuilder>
        getPhrasesOrBuilderList() {
      if (phrasesBuilder_ != null) {
        return phrasesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(phrases_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of word and phrases.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.PhraseSet.Phrase phrases = 2;</code>
     */
    public com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase.Builder addPhrasesBuilder() {
      return getPhrasesFieldBuilder()
          .addBuilder(com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of word and phrases.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.PhraseSet.Phrase phrases = 2;</code>
     */
    public com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase.Builder addPhrasesBuilder(int index) {
      return getPhrasesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of word and phrases.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1p1beta1.PhraseSet.Phrase phrases = 2;</code>
     */
    public java.util.List<com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase.Builder>
        getPhrasesBuilderList() {
      return getPhrasesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase,
            com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase.Builder,
            com.google.cloud.speech.v1p1beta1.PhraseSet.PhraseOrBuilder>
        getPhrasesFieldBuilder() {
      if (phrasesBuilder_ == null) {
        phrasesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase,
                com.google.cloud.speech.v1p1beta1.PhraseSet.Phrase.Builder,
                com.google.cloud.speech.v1p1beta1.PhraseSet.PhraseOrBuilder>(
                phrases_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        phrases_ = null;
      }
      return phrasesBuilder_;
    }

    private float boost_;
    /**
     *
     *
     * <pre>
     * Hint Boost. Positive value will increase the probability that a specific
     * phrase will be recognized over other similar sounding phrases. The higher
     * the boost, the higher the chance of false positive recognition as well.
     * Negative boost values would correspond to anti-biasing. Anti-biasing is not
     * enabled, so negative boost will simply be ignored. Though `boost` can
     * accept a wide range of positive values, most use cases are best served with
     * values between 0 (exclusive) and 20. We recommend using a binary search
     * approach to finding the optimal value for your use case. Speech recognition
     * will skip PhraseSets with a boost value of 0.
     * </pre>
     *
     * <code>float boost = 4;</code>
     *
     * @return The boost.
     */
    @java.lang.Override
    public float getBoost() {
      return boost_;
    }
    /**
     *
     *
     * <pre>
     * Hint Boost. Positive value will increase the probability that a specific
     * phrase will be recognized over other similar sounding phrases. The higher
     * the boost, the higher the chance of false positive recognition as well.
     * Negative boost values would correspond to anti-biasing. Anti-biasing is not
     * enabled, so negative boost will simply be ignored. Though `boost` can
     * accept a wide range of positive values, most use cases are best served with
     * values between 0 (exclusive) and 20. We recommend using a binary search
     * approach to finding the optimal value for your use case. Speech recognition
     * will skip PhraseSets with a boost value of 0.
     * </pre>
     *
     * <code>float boost = 4;</code>
     *
     * @param value The boost to set.
     * @return This builder for chaining.
     */
    public Builder setBoost(float value) {

      boost_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Hint Boost. Positive value will increase the probability that a specific
     * phrase will be recognized over other similar sounding phrases. The higher
     * the boost, the higher the chance of false positive recognition as well.
     * Negative boost values would correspond to anti-biasing. Anti-biasing is not
     * enabled, so negative boost will simply be ignored. Though `boost` can
     * accept a wide range of positive values, most use cases are best served with
     * values between 0 (exclusive) and 20. We recommend using a binary search
     * approach to finding the optimal value for your use case. Speech recognition
     * will skip PhraseSets with a boost value of 0.
     * </pre>
     *
     * <code>float boost = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBoost() {

      boost_ = 0F;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.speech.v1p1beta1.PhraseSet)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.speech.v1p1beta1.PhraseSet)
  private static final com.google.cloud.speech.v1p1beta1.PhraseSet DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.speech.v1p1beta1.PhraseSet();
  }

  public static com.google.cloud.speech.v1p1beta1.PhraseSet getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PhraseSet> PARSER =
      new com.google.protobuf.AbstractParser<PhraseSet>() {
        @java.lang.Override
        public PhraseSet parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new PhraseSet(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<PhraseSet> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PhraseSet> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.speech.v1p1beta1.PhraseSet getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
