/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/speech/v2/cloud_speech.proto

package com.google.cloud.speech.v2;

/**
 *
 *
 * <pre>
 * Provides information to the Recognizer that specifies how to process the
 * recognition request.
 * </pre>
 *
 * Protobuf type {@code google.cloud.speech.v2.RecognitionConfig}
 */
public final class RecognitionConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.speech.v2.RecognitionConfig)
    RecognitionConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RecognitionConfig.newBuilder() to construct.
  private RecognitionConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RecognitionConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RecognitionConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.speech.v2.CloudSpeechProto
        .internal_static_google_cloud_speech_v2_RecognitionConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.speech.v2.CloudSpeechProto
        .internal_static_google_cloud_speech_v2_RecognitionConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.speech.v2.RecognitionConfig.class,
            com.google.cloud.speech.v2.RecognitionConfig.Builder.class);
  }

  private int decodingConfigCase_ = 0;
  private java.lang.Object decodingConfig_;

  public enum DecodingConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    AUTO_DECODING_CONFIG(7),
    EXPLICIT_DECODING_CONFIG(8),
    DECODINGCONFIG_NOT_SET(0);
    private final int value;

    private DecodingConfigCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DecodingConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static DecodingConfigCase forNumber(int value) {
      switch (value) {
        case 7:
          return AUTO_DECODING_CONFIG;
        case 8:
          return EXPLICIT_DECODING_CONFIG;
        case 0:
          return DECODINGCONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DecodingConfigCase getDecodingConfigCase() {
    return DecodingConfigCase.forNumber(decodingConfigCase_);
  }

  public static final int AUTO_DECODING_CONFIG_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Automatically detect decoding parameters.
   * Preferred for supported formats.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.AutoDetectDecodingConfig auto_decoding_config = 7;</code>
   *
   * @return Whether the autoDecodingConfig field is set.
   */
  @java.lang.Override
  public boolean hasAutoDecodingConfig() {
    return decodingConfigCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Automatically detect decoding parameters.
   * Preferred for supported formats.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.AutoDetectDecodingConfig auto_decoding_config = 7;</code>
   *
   * @return The autoDecodingConfig.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.AutoDetectDecodingConfig getAutoDecodingConfig() {
    if (decodingConfigCase_ == 7) {
      return (com.google.cloud.speech.v2.AutoDetectDecodingConfig) decodingConfig_;
    }
    return com.google.cloud.speech.v2.AutoDetectDecodingConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Automatically detect decoding parameters.
   * Preferred for supported formats.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.AutoDetectDecodingConfig auto_decoding_config = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.AutoDetectDecodingConfigOrBuilder
      getAutoDecodingConfigOrBuilder() {
    if (decodingConfigCase_ == 7) {
      return (com.google.cloud.speech.v2.AutoDetectDecodingConfig) decodingConfig_;
    }
    return com.google.cloud.speech.v2.AutoDetectDecodingConfig.getDefaultInstance();
  }

  public static final int EXPLICIT_DECODING_CONFIG_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Explicitly specified decoding parameters.
   * Required if using headerless PCM audio (linear16, mulaw, alaw).
   * </pre>
   *
   * <code>.google.cloud.speech.v2.ExplicitDecodingConfig explicit_decoding_config = 8;</code>
   *
   * @return Whether the explicitDecodingConfig field is set.
   */
  @java.lang.Override
  public boolean hasExplicitDecodingConfig() {
    return decodingConfigCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * Explicitly specified decoding parameters.
   * Required if using headerless PCM audio (linear16, mulaw, alaw).
   * </pre>
   *
   * <code>.google.cloud.speech.v2.ExplicitDecodingConfig explicit_decoding_config = 8;</code>
   *
   * @return The explicitDecodingConfig.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.ExplicitDecodingConfig getExplicitDecodingConfig() {
    if (decodingConfigCase_ == 8) {
      return (com.google.cloud.speech.v2.ExplicitDecodingConfig) decodingConfig_;
    }
    return com.google.cloud.speech.v2.ExplicitDecodingConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Explicitly specified decoding parameters.
   * Required if using headerless PCM audio (linear16, mulaw, alaw).
   * </pre>
   *
   * <code>.google.cloud.speech.v2.ExplicitDecodingConfig explicit_decoding_config = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.ExplicitDecodingConfigOrBuilder
      getExplicitDecodingConfigOrBuilder() {
    if (decodingConfigCase_ == 8) {
      return (com.google.cloud.speech.v2.ExplicitDecodingConfig) decodingConfig_;
    }
    return com.google.cloud.speech.v2.ExplicitDecodingConfig.getDefaultInstance();
  }

  public static final int FEATURES_FIELD_NUMBER = 2;
  private com.google.cloud.speech.v2.RecognitionFeatures features_;
  /**
   *
   *
   * <pre>
   * Speech recognition features to enable.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.RecognitionFeatures features = 2;</code>
   *
   * @return Whether the features field is set.
   */
  @java.lang.Override
  public boolean hasFeatures() {
    return features_ != null;
  }
  /**
   *
   *
   * <pre>
   * Speech recognition features to enable.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.RecognitionFeatures features = 2;</code>
   *
   * @return The features.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.RecognitionFeatures getFeatures() {
    return features_ == null
        ? com.google.cloud.speech.v2.RecognitionFeatures.getDefaultInstance()
        : features_;
  }
  /**
   *
   *
   * <pre>
   * Speech recognition features to enable.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.RecognitionFeatures features = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.RecognitionFeaturesOrBuilder getFeaturesOrBuilder() {
    return features_ == null
        ? com.google.cloud.speech.v2.RecognitionFeatures.getDefaultInstance()
        : features_;
  }

  public static final int ADAPTATION_FIELD_NUMBER = 6;
  private com.google.cloud.speech.v2.SpeechAdaptation adaptation_;
  /**
   *
   *
   * <pre>
   * Speech adaptation context that weights recognizer predictions for specific
   * words and phrases.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.SpeechAdaptation adaptation = 6;</code>
   *
   * @return Whether the adaptation field is set.
   */
  @java.lang.Override
  public boolean hasAdaptation() {
    return adaptation_ != null;
  }
  /**
   *
   *
   * <pre>
   * Speech adaptation context that weights recognizer predictions for specific
   * words and phrases.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.SpeechAdaptation adaptation = 6;</code>
   *
   * @return The adaptation.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.SpeechAdaptation getAdaptation() {
    return adaptation_ == null
        ? com.google.cloud.speech.v2.SpeechAdaptation.getDefaultInstance()
        : adaptation_;
  }
  /**
   *
   *
   * <pre>
   * Speech adaptation context that weights recognizer predictions for specific
   * words and phrases.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.SpeechAdaptation adaptation = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.SpeechAdaptationOrBuilder getAdaptationOrBuilder() {
    return adaptation_ == null
        ? com.google.cloud.speech.v2.SpeechAdaptation.getDefaultInstance()
        : adaptation_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (features_ != null) {
      output.writeMessage(2, getFeatures());
    }
    if (adaptation_ != null) {
      output.writeMessage(6, getAdaptation());
    }
    if (decodingConfigCase_ == 7) {
      output.writeMessage(7, (com.google.cloud.speech.v2.AutoDetectDecodingConfig) decodingConfig_);
    }
    if (decodingConfigCase_ == 8) {
      output.writeMessage(8, (com.google.cloud.speech.v2.ExplicitDecodingConfig) decodingConfig_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (features_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getFeatures());
    }
    if (adaptation_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getAdaptation());
    }
    if (decodingConfigCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.speech.v2.AutoDetectDecodingConfig) decodingConfig_);
    }
    if (decodingConfigCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.cloud.speech.v2.ExplicitDecodingConfig) decodingConfig_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.speech.v2.RecognitionConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.speech.v2.RecognitionConfig other =
        (com.google.cloud.speech.v2.RecognitionConfig) obj;

    if (hasFeatures() != other.hasFeatures()) return false;
    if (hasFeatures()) {
      if (!getFeatures().equals(other.getFeatures())) return false;
    }
    if (hasAdaptation() != other.hasAdaptation()) return false;
    if (hasAdaptation()) {
      if (!getAdaptation().equals(other.getAdaptation())) return false;
    }
    if (!getDecodingConfigCase().equals(other.getDecodingConfigCase())) return false;
    switch (decodingConfigCase_) {
      case 7:
        if (!getAutoDecodingConfig().equals(other.getAutoDecodingConfig())) return false;
        break;
      case 8:
        if (!getExplicitDecodingConfig().equals(other.getExplicitDecodingConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasFeatures()) {
      hash = (37 * hash) + FEATURES_FIELD_NUMBER;
      hash = (53 * hash) + getFeatures().hashCode();
    }
    if (hasAdaptation()) {
      hash = (37 * hash) + ADAPTATION_FIELD_NUMBER;
      hash = (53 * hash) + getAdaptation().hashCode();
    }
    switch (decodingConfigCase_) {
      case 7:
        hash = (37 * hash) + AUTO_DECODING_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getAutoDecodingConfig().hashCode();
        break;
      case 8:
        hash = (37 * hash) + EXPLICIT_DECODING_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getExplicitDecodingConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.speech.v2.RecognitionConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.RecognitionConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.RecognitionConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.RecognitionConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.RecognitionConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.RecognitionConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.RecognitionConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.RecognitionConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.RecognitionConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.RecognitionConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.RecognitionConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.RecognitionConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.speech.v2.RecognitionConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Provides information to the Recognizer that specifies how to process the
   * recognition request.
   * </pre>
   *
   * Protobuf type {@code google.cloud.speech.v2.RecognitionConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.speech.v2.RecognitionConfig)
      com.google.cloud.speech.v2.RecognitionConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_RecognitionConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_RecognitionConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.speech.v2.RecognitionConfig.class,
              com.google.cloud.speech.v2.RecognitionConfig.Builder.class);
    }

    // Construct using com.google.cloud.speech.v2.RecognitionConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (autoDecodingConfigBuilder_ != null) {
        autoDecodingConfigBuilder_.clear();
      }
      if (explicitDecodingConfigBuilder_ != null) {
        explicitDecodingConfigBuilder_.clear();
      }
      features_ = null;
      if (featuresBuilder_ != null) {
        featuresBuilder_.dispose();
        featuresBuilder_ = null;
      }
      adaptation_ = null;
      if (adaptationBuilder_ != null) {
        adaptationBuilder_.dispose();
        adaptationBuilder_ = null;
      }
      decodingConfigCase_ = 0;
      decodingConfig_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_RecognitionConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.RecognitionConfig getDefaultInstanceForType() {
      return com.google.cloud.speech.v2.RecognitionConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.RecognitionConfig build() {
      com.google.cloud.speech.v2.RecognitionConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.RecognitionConfig buildPartial() {
      com.google.cloud.speech.v2.RecognitionConfig result =
          new com.google.cloud.speech.v2.RecognitionConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.speech.v2.RecognitionConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.features_ = featuresBuilder_ == null ? features_ : featuresBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.adaptation_ = adaptationBuilder_ == null ? adaptation_ : adaptationBuilder_.build();
      }
    }

    private void buildPartialOneofs(com.google.cloud.speech.v2.RecognitionConfig result) {
      result.decodingConfigCase_ = decodingConfigCase_;
      result.decodingConfig_ = this.decodingConfig_;
      if (decodingConfigCase_ == 7 && autoDecodingConfigBuilder_ != null) {
        result.decodingConfig_ = autoDecodingConfigBuilder_.build();
      }
      if (decodingConfigCase_ == 8 && explicitDecodingConfigBuilder_ != null) {
        result.decodingConfig_ = explicitDecodingConfigBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.speech.v2.RecognitionConfig) {
        return mergeFrom((com.google.cloud.speech.v2.RecognitionConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.speech.v2.RecognitionConfig other) {
      if (other == com.google.cloud.speech.v2.RecognitionConfig.getDefaultInstance()) return this;
      if (other.hasFeatures()) {
        mergeFeatures(other.getFeatures());
      }
      if (other.hasAdaptation()) {
        mergeAdaptation(other.getAdaptation());
      }
      switch (other.getDecodingConfigCase()) {
        case AUTO_DECODING_CONFIG:
          {
            mergeAutoDecodingConfig(other.getAutoDecodingConfig());
            break;
          }
        case EXPLICIT_DECODING_CONFIG:
          {
            mergeExplicitDecodingConfig(other.getExplicitDecodingConfig());
            break;
          }
        case DECODINGCONFIG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                input.readMessage(getFeaturesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 50:
              {
                input.readMessage(getAdaptationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getAutoDecodingConfigFieldBuilder().getBuilder(), extensionRegistry);
                decodingConfigCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getExplicitDecodingConfigFieldBuilder().getBuilder(), extensionRegistry);
                decodingConfigCase_ = 8;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int decodingConfigCase_ = 0;
    private java.lang.Object decodingConfig_;

    public DecodingConfigCase getDecodingConfigCase() {
      return DecodingConfigCase.forNumber(decodingConfigCase_);
    }

    public Builder clearDecodingConfig() {
      decodingConfigCase_ = 0;
      decodingConfig_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.AutoDetectDecodingConfig,
            com.google.cloud.speech.v2.AutoDetectDecodingConfig.Builder,
            com.google.cloud.speech.v2.AutoDetectDecodingConfigOrBuilder>
        autoDecodingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Automatically detect decoding parameters.
     * Preferred for supported formats.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.AutoDetectDecodingConfig auto_decoding_config = 7;</code>
     *
     * @return Whether the autoDecodingConfig field is set.
     */
    @java.lang.Override
    public boolean hasAutoDecodingConfig() {
      return decodingConfigCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Automatically detect decoding parameters.
     * Preferred for supported formats.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.AutoDetectDecodingConfig auto_decoding_config = 7;</code>
     *
     * @return The autoDecodingConfig.
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.AutoDetectDecodingConfig getAutoDecodingConfig() {
      if (autoDecodingConfigBuilder_ == null) {
        if (decodingConfigCase_ == 7) {
          return (com.google.cloud.speech.v2.AutoDetectDecodingConfig) decodingConfig_;
        }
        return com.google.cloud.speech.v2.AutoDetectDecodingConfig.getDefaultInstance();
      } else {
        if (decodingConfigCase_ == 7) {
          return autoDecodingConfigBuilder_.getMessage();
        }
        return com.google.cloud.speech.v2.AutoDetectDecodingConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Automatically detect decoding parameters.
     * Preferred for supported formats.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.AutoDetectDecodingConfig auto_decoding_config = 7;</code>
     */
    public Builder setAutoDecodingConfig(
        com.google.cloud.speech.v2.AutoDetectDecodingConfig value) {
      if (autoDecodingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        decodingConfig_ = value;
        onChanged();
      } else {
        autoDecodingConfigBuilder_.setMessage(value);
      }
      decodingConfigCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Automatically detect decoding parameters.
     * Preferred for supported formats.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.AutoDetectDecodingConfig auto_decoding_config = 7;</code>
     */
    public Builder setAutoDecodingConfig(
        com.google.cloud.speech.v2.AutoDetectDecodingConfig.Builder builderForValue) {
      if (autoDecodingConfigBuilder_ == null) {
        decodingConfig_ = builderForValue.build();
        onChanged();
      } else {
        autoDecodingConfigBuilder_.setMessage(builderForValue.build());
      }
      decodingConfigCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Automatically detect decoding parameters.
     * Preferred for supported formats.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.AutoDetectDecodingConfig auto_decoding_config = 7;</code>
     */
    public Builder mergeAutoDecodingConfig(
        com.google.cloud.speech.v2.AutoDetectDecodingConfig value) {
      if (autoDecodingConfigBuilder_ == null) {
        if (decodingConfigCase_ == 7
            && decodingConfig_
                != com.google.cloud.speech.v2.AutoDetectDecodingConfig.getDefaultInstance()) {
          decodingConfig_ =
              com.google.cloud.speech.v2.AutoDetectDecodingConfig.newBuilder(
                      (com.google.cloud.speech.v2.AutoDetectDecodingConfig) decodingConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          decodingConfig_ = value;
        }
        onChanged();
      } else {
        if (decodingConfigCase_ == 7) {
          autoDecodingConfigBuilder_.mergeFrom(value);
        } else {
          autoDecodingConfigBuilder_.setMessage(value);
        }
      }
      decodingConfigCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Automatically detect decoding parameters.
     * Preferred for supported formats.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.AutoDetectDecodingConfig auto_decoding_config = 7;</code>
     */
    public Builder clearAutoDecodingConfig() {
      if (autoDecodingConfigBuilder_ == null) {
        if (decodingConfigCase_ == 7) {
          decodingConfigCase_ = 0;
          decodingConfig_ = null;
          onChanged();
        }
      } else {
        if (decodingConfigCase_ == 7) {
          decodingConfigCase_ = 0;
          decodingConfig_ = null;
        }
        autoDecodingConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Automatically detect decoding parameters.
     * Preferred for supported formats.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.AutoDetectDecodingConfig auto_decoding_config = 7;</code>
     */
    public com.google.cloud.speech.v2.AutoDetectDecodingConfig.Builder
        getAutoDecodingConfigBuilder() {
      return getAutoDecodingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Automatically detect decoding parameters.
     * Preferred for supported formats.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.AutoDetectDecodingConfig auto_decoding_config = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.AutoDetectDecodingConfigOrBuilder
        getAutoDecodingConfigOrBuilder() {
      if ((decodingConfigCase_ == 7) && (autoDecodingConfigBuilder_ != null)) {
        return autoDecodingConfigBuilder_.getMessageOrBuilder();
      } else {
        if (decodingConfigCase_ == 7) {
          return (com.google.cloud.speech.v2.AutoDetectDecodingConfig) decodingConfig_;
        }
        return com.google.cloud.speech.v2.AutoDetectDecodingConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Automatically detect decoding parameters.
     * Preferred for supported formats.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.AutoDetectDecodingConfig auto_decoding_config = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.AutoDetectDecodingConfig,
            com.google.cloud.speech.v2.AutoDetectDecodingConfig.Builder,
            com.google.cloud.speech.v2.AutoDetectDecodingConfigOrBuilder>
        getAutoDecodingConfigFieldBuilder() {
      if (autoDecodingConfigBuilder_ == null) {
        if (!(decodingConfigCase_ == 7)) {
          decodingConfig_ =
              com.google.cloud.speech.v2.AutoDetectDecodingConfig.getDefaultInstance();
        }
        autoDecodingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v2.AutoDetectDecodingConfig,
                com.google.cloud.speech.v2.AutoDetectDecodingConfig.Builder,
                com.google.cloud.speech.v2.AutoDetectDecodingConfigOrBuilder>(
                (com.google.cloud.speech.v2.AutoDetectDecodingConfig) decodingConfig_,
                getParentForChildren(),
                isClean());
        decodingConfig_ = null;
      }
      decodingConfigCase_ = 7;
      onChanged();
      return autoDecodingConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.ExplicitDecodingConfig,
            com.google.cloud.speech.v2.ExplicitDecodingConfig.Builder,
            com.google.cloud.speech.v2.ExplicitDecodingConfigOrBuilder>
        explicitDecodingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Explicitly specified decoding parameters.
     * Required if using headerless PCM audio (linear16, mulaw, alaw).
     * </pre>
     *
     * <code>.google.cloud.speech.v2.ExplicitDecodingConfig explicit_decoding_config = 8;</code>
     *
     * @return Whether the explicitDecodingConfig field is set.
     */
    @java.lang.Override
    public boolean hasExplicitDecodingConfig() {
      return decodingConfigCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Explicitly specified decoding parameters.
     * Required if using headerless PCM audio (linear16, mulaw, alaw).
     * </pre>
     *
     * <code>.google.cloud.speech.v2.ExplicitDecodingConfig explicit_decoding_config = 8;</code>
     *
     * @return The explicitDecodingConfig.
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.ExplicitDecodingConfig getExplicitDecodingConfig() {
      if (explicitDecodingConfigBuilder_ == null) {
        if (decodingConfigCase_ == 8) {
          return (com.google.cloud.speech.v2.ExplicitDecodingConfig) decodingConfig_;
        }
        return com.google.cloud.speech.v2.ExplicitDecodingConfig.getDefaultInstance();
      } else {
        if (decodingConfigCase_ == 8) {
          return explicitDecodingConfigBuilder_.getMessage();
        }
        return com.google.cloud.speech.v2.ExplicitDecodingConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Explicitly specified decoding parameters.
     * Required if using headerless PCM audio (linear16, mulaw, alaw).
     * </pre>
     *
     * <code>.google.cloud.speech.v2.ExplicitDecodingConfig explicit_decoding_config = 8;</code>
     */
    public Builder setExplicitDecodingConfig(
        com.google.cloud.speech.v2.ExplicitDecodingConfig value) {
      if (explicitDecodingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        decodingConfig_ = value;
        onChanged();
      } else {
        explicitDecodingConfigBuilder_.setMessage(value);
      }
      decodingConfigCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explicitly specified decoding parameters.
     * Required if using headerless PCM audio (linear16, mulaw, alaw).
     * </pre>
     *
     * <code>.google.cloud.speech.v2.ExplicitDecodingConfig explicit_decoding_config = 8;</code>
     */
    public Builder setExplicitDecodingConfig(
        com.google.cloud.speech.v2.ExplicitDecodingConfig.Builder builderForValue) {
      if (explicitDecodingConfigBuilder_ == null) {
        decodingConfig_ = builderForValue.build();
        onChanged();
      } else {
        explicitDecodingConfigBuilder_.setMessage(builderForValue.build());
      }
      decodingConfigCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explicitly specified decoding parameters.
     * Required if using headerless PCM audio (linear16, mulaw, alaw).
     * </pre>
     *
     * <code>.google.cloud.speech.v2.ExplicitDecodingConfig explicit_decoding_config = 8;</code>
     */
    public Builder mergeExplicitDecodingConfig(
        com.google.cloud.speech.v2.ExplicitDecodingConfig value) {
      if (explicitDecodingConfigBuilder_ == null) {
        if (decodingConfigCase_ == 8
            && decodingConfig_
                != com.google.cloud.speech.v2.ExplicitDecodingConfig.getDefaultInstance()) {
          decodingConfig_ =
              com.google.cloud.speech.v2.ExplicitDecodingConfig.newBuilder(
                      (com.google.cloud.speech.v2.ExplicitDecodingConfig) decodingConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          decodingConfig_ = value;
        }
        onChanged();
      } else {
        if (decodingConfigCase_ == 8) {
          explicitDecodingConfigBuilder_.mergeFrom(value);
        } else {
          explicitDecodingConfigBuilder_.setMessage(value);
        }
      }
      decodingConfigCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explicitly specified decoding parameters.
     * Required if using headerless PCM audio (linear16, mulaw, alaw).
     * </pre>
     *
     * <code>.google.cloud.speech.v2.ExplicitDecodingConfig explicit_decoding_config = 8;</code>
     */
    public Builder clearExplicitDecodingConfig() {
      if (explicitDecodingConfigBuilder_ == null) {
        if (decodingConfigCase_ == 8) {
          decodingConfigCase_ = 0;
          decodingConfig_ = null;
          onChanged();
        }
      } else {
        if (decodingConfigCase_ == 8) {
          decodingConfigCase_ = 0;
          decodingConfig_ = null;
        }
        explicitDecodingConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explicitly specified decoding parameters.
     * Required if using headerless PCM audio (linear16, mulaw, alaw).
     * </pre>
     *
     * <code>.google.cloud.speech.v2.ExplicitDecodingConfig explicit_decoding_config = 8;</code>
     */
    public com.google.cloud.speech.v2.ExplicitDecodingConfig.Builder
        getExplicitDecodingConfigBuilder() {
      return getExplicitDecodingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Explicitly specified decoding parameters.
     * Required if using headerless PCM audio (linear16, mulaw, alaw).
     * </pre>
     *
     * <code>.google.cloud.speech.v2.ExplicitDecodingConfig explicit_decoding_config = 8;</code>
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.ExplicitDecodingConfigOrBuilder
        getExplicitDecodingConfigOrBuilder() {
      if ((decodingConfigCase_ == 8) && (explicitDecodingConfigBuilder_ != null)) {
        return explicitDecodingConfigBuilder_.getMessageOrBuilder();
      } else {
        if (decodingConfigCase_ == 8) {
          return (com.google.cloud.speech.v2.ExplicitDecodingConfig) decodingConfig_;
        }
        return com.google.cloud.speech.v2.ExplicitDecodingConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Explicitly specified decoding parameters.
     * Required if using headerless PCM audio (linear16, mulaw, alaw).
     * </pre>
     *
     * <code>.google.cloud.speech.v2.ExplicitDecodingConfig explicit_decoding_config = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.ExplicitDecodingConfig,
            com.google.cloud.speech.v2.ExplicitDecodingConfig.Builder,
            com.google.cloud.speech.v2.ExplicitDecodingConfigOrBuilder>
        getExplicitDecodingConfigFieldBuilder() {
      if (explicitDecodingConfigBuilder_ == null) {
        if (!(decodingConfigCase_ == 8)) {
          decodingConfig_ = com.google.cloud.speech.v2.ExplicitDecodingConfig.getDefaultInstance();
        }
        explicitDecodingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v2.ExplicitDecodingConfig,
                com.google.cloud.speech.v2.ExplicitDecodingConfig.Builder,
                com.google.cloud.speech.v2.ExplicitDecodingConfigOrBuilder>(
                (com.google.cloud.speech.v2.ExplicitDecodingConfig) decodingConfig_,
                getParentForChildren(),
                isClean());
        decodingConfig_ = null;
      }
      decodingConfigCase_ = 8;
      onChanged();
      return explicitDecodingConfigBuilder_;
    }

    private com.google.cloud.speech.v2.RecognitionFeatures features_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.RecognitionFeatures,
            com.google.cloud.speech.v2.RecognitionFeatures.Builder,
            com.google.cloud.speech.v2.RecognitionFeaturesOrBuilder>
        featuresBuilder_;
    /**
     *
     *
     * <pre>
     * Speech recognition features to enable.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionFeatures features = 2;</code>
     *
     * @return Whether the features field is set.
     */
    public boolean hasFeatures() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Speech recognition features to enable.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionFeatures features = 2;</code>
     *
     * @return The features.
     */
    public com.google.cloud.speech.v2.RecognitionFeatures getFeatures() {
      if (featuresBuilder_ == null) {
        return features_ == null
            ? com.google.cloud.speech.v2.RecognitionFeatures.getDefaultInstance()
            : features_;
      } else {
        return featuresBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Speech recognition features to enable.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionFeatures features = 2;</code>
     */
    public Builder setFeatures(com.google.cloud.speech.v2.RecognitionFeatures value) {
      if (featuresBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        features_ = value;
      } else {
        featuresBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech recognition features to enable.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionFeatures features = 2;</code>
     */
    public Builder setFeatures(
        com.google.cloud.speech.v2.RecognitionFeatures.Builder builderForValue) {
      if (featuresBuilder_ == null) {
        features_ = builderForValue.build();
      } else {
        featuresBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech recognition features to enable.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionFeatures features = 2;</code>
     */
    public Builder mergeFeatures(com.google.cloud.speech.v2.RecognitionFeatures value) {
      if (featuresBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && features_ != null
            && features_ != com.google.cloud.speech.v2.RecognitionFeatures.getDefaultInstance()) {
          getFeaturesBuilder().mergeFrom(value);
        } else {
          features_ = value;
        }
      } else {
        featuresBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech recognition features to enable.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionFeatures features = 2;</code>
     */
    public Builder clearFeatures() {
      bitField0_ = (bitField0_ & ~0x00000004);
      features_ = null;
      if (featuresBuilder_ != null) {
        featuresBuilder_.dispose();
        featuresBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech recognition features to enable.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionFeatures features = 2;</code>
     */
    public com.google.cloud.speech.v2.RecognitionFeatures.Builder getFeaturesBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getFeaturesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Speech recognition features to enable.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionFeatures features = 2;</code>
     */
    public com.google.cloud.speech.v2.RecognitionFeaturesOrBuilder getFeaturesOrBuilder() {
      if (featuresBuilder_ != null) {
        return featuresBuilder_.getMessageOrBuilder();
      } else {
        return features_ == null
            ? com.google.cloud.speech.v2.RecognitionFeatures.getDefaultInstance()
            : features_;
      }
    }
    /**
     *
     *
     * <pre>
     * Speech recognition features to enable.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionFeatures features = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.RecognitionFeatures,
            com.google.cloud.speech.v2.RecognitionFeatures.Builder,
            com.google.cloud.speech.v2.RecognitionFeaturesOrBuilder>
        getFeaturesFieldBuilder() {
      if (featuresBuilder_ == null) {
        featuresBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v2.RecognitionFeatures,
                com.google.cloud.speech.v2.RecognitionFeatures.Builder,
                com.google.cloud.speech.v2.RecognitionFeaturesOrBuilder>(
                getFeatures(), getParentForChildren(), isClean());
        features_ = null;
      }
      return featuresBuilder_;
    }

    private com.google.cloud.speech.v2.SpeechAdaptation adaptation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.SpeechAdaptation,
            com.google.cloud.speech.v2.SpeechAdaptation.Builder,
            com.google.cloud.speech.v2.SpeechAdaptationOrBuilder>
        adaptationBuilder_;
    /**
     *
     *
     * <pre>
     * Speech adaptation context that weights recognizer predictions for specific
     * words and phrases.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.SpeechAdaptation adaptation = 6;</code>
     *
     * @return Whether the adaptation field is set.
     */
    public boolean hasAdaptation() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Speech adaptation context that weights recognizer predictions for specific
     * words and phrases.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.SpeechAdaptation adaptation = 6;</code>
     *
     * @return The adaptation.
     */
    public com.google.cloud.speech.v2.SpeechAdaptation getAdaptation() {
      if (adaptationBuilder_ == null) {
        return adaptation_ == null
            ? com.google.cloud.speech.v2.SpeechAdaptation.getDefaultInstance()
            : adaptation_;
      } else {
        return adaptationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Speech adaptation context that weights recognizer predictions for specific
     * words and phrases.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.SpeechAdaptation adaptation = 6;</code>
     */
    public Builder setAdaptation(com.google.cloud.speech.v2.SpeechAdaptation value) {
      if (adaptationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        adaptation_ = value;
      } else {
        adaptationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech adaptation context that weights recognizer predictions for specific
     * words and phrases.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.SpeechAdaptation adaptation = 6;</code>
     */
    public Builder setAdaptation(
        com.google.cloud.speech.v2.SpeechAdaptation.Builder builderForValue) {
      if (adaptationBuilder_ == null) {
        adaptation_ = builderForValue.build();
      } else {
        adaptationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech adaptation context that weights recognizer predictions for specific
     * words and phrases.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.SpeechAdaptation adaptation = 6;</code>
     */
    public Builder mergeAdaptation(com.google.cloud.speech.v2.SpeechAdaptation value) {
      if (adaptationBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && adaptation_ != null
            && adaptation_ != com.google.cloud.speech.v2.SpeechAdaptation.getDefaultInstance()) {
          getAdaptationBuilder().mergeFrom(value);
        } else {
          adaptation_ = value;
        }
      } else {
        adaptationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech adaptation context that weights recognizer predictions for specific
     * words and phrases.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.SpeechAdaptation adaptation = 6;</code>
     */
    public Builder clearAdaptation() {
      bitField0_ = (bitField0_ & ~0x00000008);
      adaptation_ = null;
      if (adaptationBuilder_ != null) {
        adaptationBuilder_.dispose();
        adaptationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech adaptation context that weights recognizer predictions for specific
     * words and phrases.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.SpeechAdaptation adaptation = 6;</code>
     */
    public com.google.cloud.speech.v2.SpeechAdaptation.Builder getAdaptationBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getAdaptationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Speech adaptation context that weights recognizer predictions for specific
     * words and phrases.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.SpeechAdaptation adaptation = 6;</code>
     */
    public com.google.cloud.speech.v2.SpeechAdaptationOrBuilder getAdaptationOrBuilder() {
      if (adaptationBuilder_ != null) {
        return adaptationBuilder_.getMessageOrBuilder();
      } else {
        return adaptation_ == null
            ? com.google.cloud.speech.v2.SpeechAdaptation.getDefaultInstance()
            : adaptation_;
      }
    }
    /**
     *
     *
     * <pre>
     * Speech adaptation context that weights recognizer predictions for specific
     * words and phrases.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.SpeechAdaptation adaptation = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.SpeechAdaptation,
            com.google.cloud.speech.v2.SpeechAdaptation.Builder,
            com.google.cloud.speech.v2.SpeechAdaptationOrBuilder>
        getAdaptationFieldBuilder() {
      if (adaptationBuilder_ == null) {
        adaptationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v2.SpeechAdaptation,
                com.google.cloud.speech.v2.SpeechAdaptation.Builder,
                com.google.cloud.speech.v2.SpeechAdaptationOrBuilder>(
                getAdaptation(), getParentForChildren(), isClean());
        adaptation_ = null;
      }
      return adaptationBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.speech.v2.RecognitionConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.speech.v2.RecognitionConfig)
  private static final com.google.cloud.speech.v2.RecognitionConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.speech.v2.RecognitionConfig();
  }

  public static com.google.cloud.speech.v2.RecognitionConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RecognitionConfig> PARSER =
      new com.google.protobuf.AbstractParser<RecognitionConfig>() {
        @java.lang.Override
        public RecognitionConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RecognitionConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RecognitionConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.speech.v2.RecognitionConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
