/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/speech/v2/cloud_speech.proto

package com.google.cloud.speech.v2;

/**
 *
 *
 * <pre>
 * Final results for a single file.
 * </pre>
 *
 * Protobuf type {@code google.cloud.speech.v2.BatchRecognizeFileResult}
 */
public final class BatchRecognizeFileResult extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.speech.v2.BatchRecognizeFileResult)
    BatchRecognizeFileResultOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BatchRecognizeFileResult.newBuilder() to construct.
  private BatchRecognizeFileResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchRecognizeFileResult() {
    uri_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchRecognizeFileResult();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.speech.v2.CloudSpeechProto
        .internal_static_google_cloud_speech_v2_BatchRecognizeFileResult_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.speech.v2.CloudSpeechProto
        .internal_static_google_cloud_speech_v2_BatchRecognizeFileResult_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.speech.v2.BatchRecognizeFileResult.class,
            com.google.cloud.speech.v2.BatchRecognizeFileResult.Builder.class);
  }

  public static final int URI_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uri_ = "";
  /**
   *
   *
   * <pre>
   * The Cloud Storage URI to which recognition results were written.
   * </pre>
   *
   * <code>string uri = 1;</code>
   *
   * @return The uri.
   */
  @java.lang.Override
  public java.lang.String getUri() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Cloud Storage URI to which recognition results were written.
   * </pre>
   *
   * <code>string uri = 1;</code>
   *
   * @return The bytes for uri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUriBytes() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ERROR_FIELD_NUMBER = 2;
  private com.google.rpc.Status error_;
  /**
   *
   *
   * <pre>
   * Error if one was encountered.
   * </pre>
   *
   * <code>.google.rpc.Status error = 2;</code>
   *
   * @return Whether the error field is set.
   */
  @java.lang.Override
  public boolean hasError() {
    return error_ != null;
  }
  /**
   *
   *
   * <pre>
   * Error if one was encountered.
   * </pre>
   *
   * <code>.google.rpc.Status error = 2;</code>
   *
   * @return The error.
   */
  @java.lang.Override
  public com.google.rpc.Status getError() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }
  /**
   *
   *
   * <pre>
   * Error if one was encountered.
   * </pre>
   *
   * <code>.google.rpc.Status error = 2;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }

  public static final int METADATA_FIELD_NUMBER = 3;
  private com.google.cloud.speech.v2.RecognitionResponseMetadata metadata_;
  /**
   * <code>.google.cloud.speech.v2.RecognitionResponseMetadata metadata = 3;</code>
   *
   * @return Whether the metadata field is set.
   */
  @java.lang.Override
  public boolean hasMetadata() {
    return metadata_ != null;
  }
  /**
   * <code>.google.cloud.speech.v2.RecognitionResponseMetadata metadata = 3;</code>
   *
   * @return The metadata.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.RecognitionResponseMetadata getMetadata() {
    return metadata_ == null
        ? com.google.cloud.speech.v2.RecognitionResponseMetadata.getDefaultInstance()
        : metadata_;
  }
  /** <code>.google.cloud.speech.v2.RecognitionResponseMetadata metadata = 3;</code> */
  @java.lang.Override
  public com.google.cloud.speech.v2.RecognitionResponseMetadataOrBuilder getMetadataOrBuilder() {
    return metadata_ == null
        ? com.google.cloud.speech.v2.RecognitionResponseMetadata.getDefaultInstance()
        : metadata_;
  }

  public static final int TRANSCRIPT_FIELD_NUMBER = 4;
  private com.google.cloud.speech.v2.BatchRecognizeResults transcript_;
  /**
   *
   *
   * <pre>
   * The transcript for the audio file. This is populated only when
   * [InlineOutputConfig][google.cloud.speech.v2.InlineOutputConfig] is set in
   * the
   * [RecognitionOutputConfig][[google.cloud.speech.v2.RecognitionOutputConfig].
   * </pre>
   *
   * <code>.google.cloud.speech.v2.BatchRecognizeResults transcript = 4;</code>
   *
   * @return Whether the transcript field is set.
   */
  @java.lang.Override
  public boolean hasTranscript() {
    return transcript_ != null;
  }
  /**
   *
   *
   * <pre>
   * The transcript for the audio file. This is populated only when
   * [InlineOutputConfig][google.cloud.speech.v2.InlineOutputConfig] is set in
   * the
   * [RecognitionOutputConfig][[google.cloud.speech.v2.RecognitionOutputConfig].
   * </pre>
   *
   * <code>.google.cloud.speech.v2.BatchRecognizeResults transcript = 4;</code>
   *
   * @return The transcript.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.BatchRecognizeResults getTranscript() {
    return transcript_ == null
        ? com.google.cloud.speech.v2.BatchRecognizeResults.getDefaultInstance()
        : transcript_;
  }
  /**
   *
   *
   * <pre>
   * The transcript for the audio file. This is populated only when
   * [InlineOutputConfig][google.cloud.speech.v2.InlineOutputConfig] is set in
   * the
   * [RecognitionOutputConfig][[google.cloud.speech.v2.RecognitionOutputConfig].
   * </pre>
   *
   * <code>.google.cloud.speech.v2.BatchRecognizeResults transcript = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.BatchRecognizeResultsOrBuilder getTranscriptOrBuilder() {
    return transcript_ == null
        ? com.google.cloud.speech.v2.BatchRecognizeResults.getDefaultInstance()
        : transcript_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, uri_);
    }
    if (error_ != null) {
      output.writeMessage(2, getError());
    }
    if (metadata_ != null) {
      output.writeMessage(3, getMetadata());
    }
    if (transcript_ != null) {
      output.writeMessage(4, getTranscript());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, uri_);
    }
    if (error_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getError());
    }
    if (metadata_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getMetadata());
    }
    if (transcript_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getTranscript());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.speech.v2.BatchRecognizeFileResult)) {
      return super.equals(obj);
    }
    com.google.cloud.speech.v2.BatchRecognizeFileResult other =
        (com.google.cloud.speech.v2.BatchRecognizeFileResult) obj;

    if (!getUri().equals(other.getUri())) return false;
    if (hasError() != other.hasError()) return false;
    if (hasError()) {
      if (!getError().equals(other.getError())) return false;
    }
    if (hasMetadata() != other.hasMetadata()) return false;
    if (hasMetadata()) {
      if (!getMetadata().equals(other.getMetadata())) return false;
    }
    if (hasTranscript() != other.hasTranscript()) return false;
    if (hasTranscript()) {
      if (!getTranscript().equals(other.getTranscript())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + URI_FIELD_NUMBER;
    hash = (53 * hash) + getUri().hashCode();
    if (hasError()) {
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getError().hashCode();
    }
    if (hasMetadata()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadata().hashCode();
    }
    if (hasTranscript()) {
      hash = (37 * hash) + TRANSCRIPT_FIELD_NUMBER;
      hash = (53 * hash) + getTranscript().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.speech.v2.BatchRecognizeFileResult parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeFileResult parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeFileResult parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeFileResult parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeFileResult parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeFileResult parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeFileResult parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeFileResult parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeFileResult parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeFileResult parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeFileResult parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeFileResult parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.speech.v2.BatchRecognizeFileResult prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Final results for a single file.
   * </pre>
   *
   * Protobuf type {@code google.cloud.speech.v2.BatchRecognizeFileResult}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.speech.v2.BatchRecognizeFileResult)
      com.google.cloud.speech.v2.BatchRecognizeFileResultOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_BatchRecognizeFileResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_BatchRecognizeFileResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.speech.v2.BatchRecognizeFileResult.class,
              com.google.cloud.speech.v2.BatchRecognizeFileResult.Builder.class);
    }

    // Construct using com.google.cloud.speech.v2.BatchRecognizeFileResult.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      uri_ = "";
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      transcript_ = null;
      if (transcriptBuilder_ != null) {
        transcriptBuilder_.dispose();
        transcriptBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_BatchRecognizeFileResult_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.BatchRecognizeFileResult getDefaultInstanceForType() {
      return com.google.cloud.speech.v2.BatchRecognizeFileResult.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.BatchRecognizeFileResult build() {
      com.google.cloud.speech.v2.BatchRecognizeFileResult result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.BatchRecognizeFileResult buildPartial() {
      com.google.cloud.speech.v2.BatchRecognizeFileResult result =
          new com.google.cloud.speech.v2.BatchRecognizeFileResult(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.speech.v2.BatchRecognizeFileResult result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.uri_ = uri_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.error_ = errorBuilder_ == null ? error_ : errorBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.metadata_ = metadataBuilder_ == null ? metadata_ : metadataBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.transcript_ = transcriptBuilder_ == null ? transcript_ : transcriptBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.speech.v2.BatchRecognizeFileResult) {
        return mergeFrom((com.google.cloud.speech.v2.BatchRecognizeFileResult) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.speech.v2.BatchRecognizeFileResult other) {
      if (other == com.google.cloud.speech.v2.BatchRecognizeFileResult.getDefaultInstance())
        return this;
      if (!other.getUri().isEmpty()) {
        uri_ = other.uri_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasError()) {
        mergeError(other.getError());
      }
      if (other.hasMetadata()) {
        mergeMetadata(other.getMetadata());
      }
      if (other.hasTranscript()) {
        mergeTranscript(other.getTranscript());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                uri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getErrorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getTranscriptFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object uri_ = "";
    /**
     *
     *
     * <pre>
     * The Cloud Storage URI to which recognition results were written.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return The uri.
     */
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage URI to which recognition results were written.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return The bytes for uri.
     */
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage URI to which recognition results were written.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @param value The uri to set.
     * @return This builder for chaining.
     */
    public Builder setUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage URI to which recognition results were written.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUri() {
      uri_ = getDefaultInstance().getUri();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage URI to which recognition results were written.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @param value The bytes for uri to set.
     * @return This builder for chaining.
     */
    public Builder setUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.rpc.Status error_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorBuilder_;
    /**
     *
     *
     * <pre>
     * Error if one was encountered.
     * </pre>
     *
     * <code>.google.rpc.Status error = 2;</code>
     *
     * @return Whether the error field is set.
     */
    public boolean hasError() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Error if one was encountered.
     * </pre>
     *
     * <code>.google.rpc.Status error = 2;</code>
     *
     * @return The error.
     */
    public com.google.rpc.Status getError() {
      if (errorBuilder_ == null) {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      } else {
        return errorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Error if one was encountered.
     * </pre>
     *
     * <code>.google.rpc.Status error = 2;</code>
     */
    public Builder setError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        error_ = value;
      } else {
        errorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Error if one was encountered.
     * </pre>
     *
     * <code>.google.rpc.Status error = 2;</code>
     */
    public Builder setError(com.google.rpc.Status.Builder builderForValue) {
      if (errorBuilder_ == null) {
        error_ = builderForValue.build();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Error if one was encountered.
     * </pre>
     *
     * <code>.google.rpc.Status error = 2;</code>
     */
    public Builder mergeError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && error_ != null
            && error_ != com.google.rpc.Status.getDefaultInstance()) {
          getErrorBuilder().mergeFrom(value);
        } else {
          error_ = value;
        }
      } else {
        errorBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Error if one was encountered.
     * </pre>
     *
     * <code>.google.rpc.Status error = 2;</code>
     */
    public Builder clearError() {
      bitField0_ = (bitField0_ & ~0x00000002);
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Error if one was encountered.
     * </pre>
     *
     * <code>.google.rpc.Status error = 2;</code>
     */
    public com.google.rpc.Status.Builder getErrorBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Error if one was encountered.
     * </pre>
     *
     * <code>.google.rpc.Status error = 2;</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if (errorBuilder_ != null) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      }
    }
    /**
     *
     *
     * <pre>
     * Error if one was encountered.
     * </pre>
     *
     * <code>.google.rpc.Status error = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getError(), getParentForChildren(), isClean());
        error_ = null;
      }
      return errorBuilder_;
    }

    private com.google.cloud.speech.v2.RecognitionResponseMetadata metadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.RecognitionResponseMetadata,
            com.google.cloud.speech.v2.RecognitionResponseMetadata.Builder,
            com.google.cloud.speech.v2.RecognitionResponseMetadataOrBuilder>
        metadataBuilder_;
    /**
     * <code>.google.cloud.speech.v2.RecognitionResponseMetadata metadata = 3;</code>
     *
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <code>.google.cloud.speech.v2.RecognitionResponseMetadata metadata = 3;</code>
     *
     * @return The metadata.
     */
    public com.google.cloud.speech.v2.RecognitionResponseMetadata getMetadata() {
      if (metadataBuilder_ == null) {
        return metadata_ == null
            ? com.google.cloud.speech.v2.RecognitionResponseMetadata.getDefaultInstance()
            : metadata_;
      } else {
        return metadataBuilder_.getMessage();
      }
    }
    /** <code>.google.cloud.speech.v2.RecognitionResponseMetadata metadata = 3;</code> */
    public Builder setMetadata(com.google.cloud.speech.v2.RecognitionResponseMetadata value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
      } else {
        metadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /** <code>.google.cloud.speech.v2.RecognitionResponseMetadata metadata = 3;</code> */
    public Builder setMetadata(
        com.google.cloud.speech.v2.RecognitionResponseMetadata.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        metadata_ = builderForValue.build();
      } else {
        metadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /** <code>.google.cloud.speech.v2.RecognitionResponseMetadata metadata = 3;</code> */
    public Builder mergeMetadata(com.google.cloud.speech.v2.RecognitionResponseMetadata value) {
      if (metadataBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && metadata_ != null
            && metadata_
                != com.google.cloud.speech.v2.RecognitionResponseMetadata.getDefaultInstance()) {
          getMetadataBuilder().mergeFrom(value);
        } else {
          metadata_ = value;
        }
      } else {
        metadataBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /** <code>.google.cloud.speech.v2.RecognitionResponseMetadata metadata = 3;</code> */
    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x00000004);
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /** <code>.google.cloud.speech.v2.RecognitionResponseMetadata metadata = 3;</code> */
    public com.google.cloud.speech.v2.RecognitionResponseMetadata.Builder getMetadataBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getMetadataFieldBuilder().getBuilder();
    }
    /** <code>.google.cloud.speech.v2.RecognitionResponseMetadata metadata = 3;</code> */
    public com.google.cloud.speech.v2.RecognitionResponseMetadataOrBuilder getMetadataOrBuilder() {
      if (metadataBuilder_ != null) {
        return metadataBuilder_.getMessageOrBuilder();
      } else {
        return metadata_ == null
            ? com.google.cloud.speech.v2.RecognitionResponseMetadata.getDefaultInstance()
            : metadata_;
      }
    }
    /** <code>.google.cloud.speech.v2.RecognitionResponseMetadata metadata = 3;</code> */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.RecognitionResponseMetadata,
            com.google.cloud.speech.v2.RecognitionResponseMetadata.Builder,
            com.google.cloud.speech.v2.RecognitionResponseMetadataOrBuilder>
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        metadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v2.RecognitionResponseMetadata,
                com.google.cloud.speech.v2.RecognitionResponseMetadata.Builder,
                com.google.cloud.speech.v2.RecognitionResponseMetadataOrBuilder>(
                getMetadata(), getParentForChildren(), isClean());
        metadata_ = null;
      }
      return metadataBuilder_;
    }

    private com.google.cloud.speech.v2.BatchRecognizeResults transcript_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.BatchRecognizeResults,
            com.google.cloud.speech.v2.BatchRecognizeResults.Builder,
            com.google.cloud.speech.v2.BatchRecognizeResultsOrBuilder>
        transcriptBuilder_;
    /**
     *
     *
     * <pre>
     * The transcript for the audio file. This is populated only when
     * [InlineOutputConfig][google.cloud.speech.v2.InlineOutputConfig] is set in
     * the
     * [RecognitionOutputConfig][[google.cloud.speech.v2.RecognitionOutputConfig].
     * </pre>
     *
     * <code>.google.cloud.speech.v2.BatchRecognizeResults transcript = 4;</code>
     *
     * @return Whether the transcript field is set.
     */
    public boolean hasTranscript() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The transcript for the audio file. This is populated only when
     * [InlineOutputConfig][google.cloud.speech.v2.InlineOutputConfig] is set in
     * the
     * [RecognitionOutputConfig][[google.cloud.speech.v2.RecognitionOutputConfig].
     * </pre>
     *
     * <code>.google.cloud.speech.v2.BatchRecognizeResults transcript = 4;</code>
     *
     * @return The transcript.
     */
    public com.google.cloud.speech.v2.BatchRecognizeResults getTranscript() {
      if (transcriptBuilder_ == null) {
        return transcript_ == null
            ? com.google.cloud.speech.v2.BatchRecognizeResults.getDefaultInstance()
            : transcript_;
      } else {
        return transcriptBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The transcript for the audio file. This is populated only when
     * [InlineOutputConfig][google.cloud.speech.v2.InlineOutputConfig] is set in
     * the
     * [RecognitionOutputConfig][[google.cloud.speech.v2.RecognitionOutputConfig].
     * </pre>
     *
     * <code>.google.cloud.speech.v2.BatchRecognizeResults transcript = 4;</code>
     */
    public Builder setTranscript(com.google.cloud.speech.v2.BatchRecognizeResults value) {
      if (transcriptBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transcript_ = value;
      } else {
        transcriptBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The transcript for the audio file. This is populated only when
     * [InlineOutputConfig][google.cloud.speech.v2.InlineOutputConfig] is set in
     * the
     * [RecognitionOutputConfig][[google.cloud.speech.v2.RecognitionOutputConfig].
     * </pre>
     *
     * <code>.google.cloud.speech.v2.BatchRecognizeResults transcript = 4;</code>
     */
    public Builder setTranscript(
        com.google.cloud.speech.v2.BatchRecognizeResults.Builder builderForValue) {
      if (transcriptBuilder_ == null) {
        transcript_ = builderForValue.build();
      } else {
        transcriptBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The transcript for the audio file. This is populated only when
     * [InlineOutputConfig][google.cloud.speech.v2.InlineOutputConfig] is set in
     * the
     * [RecognitionOutputConfig][[google.cloud.speech.v2.RecognitionOutputConfig].
     * </pre>
     *
     * <code>.google.cloud.speech.v2.BatchRecognizeResults transcript = 4;</code>
     */
    public Builder mergeTranscript(com.google.cloud.speech.v2.BatchRecognizeResults value) {
      if (transcriptBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && transcript_ != null
            && transcript_
                != com.google.cloud.speech.v2.BatchRecognizeResults.getDefaultInstance()) {
          getTranscriptBuilder().mergeFrom(value);
        } else {
          transcript_ = value;
        }
      } else {
        transcriptBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The transcript for the audio file. This is populated only when
     * [InlineOutputConfig][google.cloud.speech.v2.InlineOutputConfig] is set in
     * the
     * [RecognitionOutputConfig][[google.cloud.speech.v2.RecognitionOutputConfig].
     * </pre>
     *
     * <code>.google.cloud.speech.v2.BatchRecognizeResults transcript = 4;</code>
     */
    public Builder clearTranscript() {
      bitField0_ = (bitField0_ & ~0x00000008);
      transcript_ = null;
      if (transcriptBuilder_ != null) {
        transcriptBuilder_.dispose();
        transcriptBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The transcript for the audio file. This is populated only when
     * [InlineOutputConfig][google.cloud.speech.v2.InlineOutputConfig] is set in
     * the
     * [RecognitionOutputConfig][[google.cloud.speech.v2.RecognitionOutputConfig].
     * </pre>
     *
     * <code>.google.cloud.speech.v2.BatchRecognizeResults transcript = 4;</code>
     */
    public com.google.cloud.speech.v2.BatchRecognizeResults.Builder getTranscriptBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getTranscriptFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The transcript for the audio file. This is populated only when
     * [InlineOutputConfig][google.cloud.speech.v2.InlineOutputConfig] is set in
     * the
     * [RecognitionOutputConfig][[google.cloud.speech.v2.RecognitionOutputConfig].
     * </pre>
     *
     * <code>.google.cloud.speech.v2.BatchRecognizeResults transcript = 4;</code>
     */
    public com.google.cloud.speech.v2.BatchRecognizeResultsOrBuilder getTranscriptOrBuilder() {
      if (transcriptBuilder_ != null) {
        return transcriptBuilder_.getMessageOrBuilder();
      } else {
        return transcript_ == null
            ? com.google.cloud.speech.v2.BatchRecognizeResults.getDefaultInstance()
            : transcript_;
      }
    }
    /**
     *
     *
     * <pre>
     * The transcript for the audio file. This is populated only when
     * [InlineOutputConfig][google.cloud.speech.v2.InlineOutputConfig] is set in
     * the
     * [RecognitionOutputConfig][[google.cloud.speech.v2.RecognitionOutputConfig].
     * </pre>
     *
     * <code>.google.cloud.speech.v2.BatchRecognizeResults transcript = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.BatchRecognizeResults,
            com.google.cloud.speech.v2.BatchRecognizeResults.Builder,
            com.google.cloud.speech.v2.BatchRecognizeResultsOrBuilder>
        getTranscriptFieldBuilder() {
      if (transcriptBuilder_ == null) {
        transcriptBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v2.BatchRecognizeResults,
                com.google.cloud.speech.v2.BatchRecognizeResults.Builder,
                com.google.cloud.speech.v2.BatchRecognizeResultsOrBuilder>(
                getTranscript(), getParentForChildren(), isClean());
        transcript_ = null;
      }
      return transcriptBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.speech.v2.BatchRecognizeFileResult)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.speech.v2.BatchRecognizeFileResult)
  private static final com.google.cloud.speech.v2.BatchRecognizeFileResult DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.speech.v2.BatchRecognizeFileResult();
  }

  public static com.google.cloud.speech.v2.BatchRecognizeFileResult getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchRecognizeFileResult> PARSER =
      new com.google.protobuf.AbstractParser<BatchRecognizeFileResult>() {
        @java.lang.Override
        public BatchRecognizeFileResult parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BatchRecognizeFileResult> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchRecognizeFileResult> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.speech.v2.BatchRecognizeFileResult getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
