/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/speech/v2/cloud_speech.proto

package com.google.cloud.speech.v2;

/**
 *
 *
 * <pre>
 * Request message for the
 * [Recognize][google.cloud.speech.v2.Speech.Recognize] method. Either
 * `content` or `uri` must be supplied. Supplying both or neither returns
 * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]. See [content
 * limits](https://cloud.google.com/speech-to-text/quotas#content).
 * </pre>
 *
 * Protobuf type {@code google.cloud.speech.v2.RecognizeRequest}
 */
public final class RecognizeRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.speech.v2.RecognizeRequest)
    RecognizeRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RecognizeRequest.newBuilder() to construct.
  private RecognizeRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RecognizeRequest() {
    recognizer_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RecognizeRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.speech.v2.CloudSpeechProto
        .internal_static_google_cloud_speech_v2_RecognizeRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.speech.v2.CloudSpeechProto
        .internal_static_google_cloud_speech_v2_RecognizeRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.speech.v2.RecognizeRequest.class,
            com.google.cloud.speech.v2.RecognizeRequest.Builder.class);
  }

  private int audioSourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object audioSource_;

  public enum AudioSourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CONTENT(5),
    URI(6),
    AUDIOSOURCE_NOT_SET(0);
    private final int value;

    private AudioSourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AudioSourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static AudioSourceCase forNumber(int value) {
      switch (value) {
        case 5:
          return CONTENT;
        case 6:
          return URI;
        case 0:
          return AUDIOSOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public AudioSourceCase getAudioSourceCase() {
    return AudioSourceCase.forNumber(audioSourceCase_);
  }

  public static final int RECOGNIZER_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object recognizer_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the Recognizer to use during recognition. The
   * expected format is
   * `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
   * {recognizer} segment may be set to `_` to use an empty implicit Recognizer.
   * </pre>
   *
   * <code>
   * string recognizer = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The recognizer.
   */
  @java.lang.Override
  public java.lang.String getRecognizer() {
    java.lang.Object ref = recognizer_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      recognizer_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the Recognizer to use during recognition. The
   * expected format is
   * `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
   * {recognizer} segment may be set to `_` to use an empty implicit Recognizer.
   * </pre>
   *
   * <code>
   * string recognizer = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for recognizer.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRecognizerBytes() {
    java.lang.Object ref = recognizer_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      recognizer_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONFIG_FIELD_NUMBER = 1;
  private com.google.cloud.speech.v2.RecognitionConfig config_;
  /**
   *
   *
   * <pre>
   * Features and audio metadata to use for the Automatic Speech Recognition.
   * This field in combination with the
   * [config_mask][google.cloud.speech.v2.RecognizeRequest.config_mask] field
   * can be used to override parts of the
   * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
   * of the Recognizer resource.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.RecognitionConfig config = 1;</code>
   *
   * @return Whether the config field is set.
   */
  @java.lang.Override
  public boolean hasConfig() {
    return config_ != null;
  }
  /**
   *
   *
   * <pre>
   * Features and audio metadata to use for the Automatic Speech Recognition.
   * This field in combination with the
   * [config_mask][google.cloud.speech.v2.RecognizeRequest.config_mask] field
   * can be used to override parts of the
   * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
   * of the Recognizer resource.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.RecognitionConfig config = 1;</code>
   *
   * @return The config.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.RecognitionConfig getConfig() {
    return config_ == null
        ? com.google.cloud.speech.v2.RecognitionConfig.getDefaultInstance()
        : config_;
  }
  /**
   *
   *
   * <pre>
   * Features and audio metadata to use for the Automatic Speech Recognition.
   * This field in combination with the
   * [config_mask][google.cloud.speech.v2.RecognizeRequest.config_mask] field
   * can be used to override parts of the
   * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
   * of the Recognizer resource.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.RecognitionConfig config = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.RecognitionConfigOrBuilder getConfigOrBuilder() {
    return config_ == null
        ? com.google.cloud.speech.v2.RecognitionConfig.getDefaultInstance()
        : config_;
  }

  public static final int CONFIG_MASK_FIELD_NUMBER = 8;
  private com.google.protobuf.FieldMask configMask_;
  /**
   *
   *
   * <pre>
   * The list of fields in
   * [config][google.cloud.speech.v2.RecognizeRequest.config] that override the
   * values in the
   * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
   * of the recognizer during this recognition request. If no mask is provided,
   * all non-default valued fields in
   * [config][google.cloud.speech.v2.RecognizeRequest.config] override the
   * values in the recognizer for this recognition request. If a mask is
   * provided, only the fields listed in the mask override the config in the
   * recognizer for this recognition request. If a wildcard (`*`) is provided,
   * [config][google.cloud.speech.v2.RecognizeRequest.config] completely
   * overrides and replaces the config in the recognizer for this recognition
   * request.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask config_mask = 8;</code>
   *
   * @return Whether the configMask field is set.
   */
  @java.lang.Override
  public boolean hasConfigMask() {
    return configMask_ != null;
  }
  /**
   *
   *
   * <pre>
   * The list of fields in
   * [config][google.cloud.speech.v2.RecognizeRequest.config] that override the
   * values in the
   * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
   * of the recognizer during this recognition request. If no mask is provided,
   * all non-default valued fields in
   * [config][google.cloud.speech.v2.RecognizeRequest.config] override the
   * values in the recognizer for this recognition request. If a mask is
   * provided, only the fields listed in the mask override the config in the
   * recognizer for this recognition request. If a wildcard (`*`) is provided,
   * [config][google.cloud.speech.v2.RecognizeRequest.config] completely
   * overrides and replaces the config in the recognizer for this recognition
   * request.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask config_mask = 8;</code>
   *
   * @return The configMask.
   */
  @java.lang.Override
  public com.google.protobuf.FieldMask getConfigMask() {
    return configMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : configMask_;
  }
  /**
   *
   *
   * <pre>
   * The list of fields in
   * [config][google.cloud.speech.v2.RecognizeRequest.config] that override the
   * values in the
   * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
   * of the recognizer during this recognition request. If no mask is provided,
   * all non-default valued fields in
   * [config][google.cloud.speech.v2.RecognizeRequest.config] override the
   * values in the recognizer for this recognition request. If a mask is
   * provided, only the fields listed in the mask override the config in the
   * recognizer for this recognition request. If a wildcard (`*`) is provided,
   * [config][google.cloud.speech.v2.RecognizeRequest.config] completely
   * overrides and replaces the config in the recognizer for this recognition
   * request.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask config_mask = 8;</code>
   */
  @java.lang.Override
  public com.google.protobuf.FieldMaskOrBuilder getConfigMaskOrBuilder() {
    return configMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : configMask_;
  }

  public static final int CONTENT_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * The audio data bytes encoded as specified in
   * [RecognitionConfig][google.cloud.speech.v2.RecognitionConfig]. As
   * with all bytes fields, proto buffers use a pure binary representation,
   * whereas JSON representations use base64.
   * </pre>
   *
   * <code>bytes content = 5;</code>
   *
   * @return Whether the content field is set.
   */
  @java.lang.Override
  public boolean hasContent() {
    return audioSourceCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * The audio data bytes encoded as specified in
   * [RecognitionConfig][google.cloud.speech.v2.RecognitionConfig]. As
   * with all bytes fields, proto buffers use a pure binary representation,
   * whereas JSON representations use base64.
   * </pre>
   *
   * <code>bytes content = 5;</code>
   *
   * @return The content.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getContent() {
    if (audioSourceCase_ == 5) {
      return (com.google.protobuf.ByteString) audioSource_;
    }
    return com.google.protobuf.ByteString.EMPTY;
  }

  public static final int URI_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * URI that points to a file that contains audio data bytes as specified in
   * [RecognitionConfig][google.cloud.speech.v2.RecognitionConfig]. The file
   * must not be compressed (for example, gzip). Currently, only Google Cloud
   * Storage URIs are supported, which must be specified in the following
   * format: `gs://bucket_name/object_name` (other URI formats return
   * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more
   * information, see [Request
   * URIs](https://cloud.google.com/storage/docs/reference-uris).
   * </pre>
   *
   * <code>string uri = 6;</code>
   *
   * @return Whether the uri field is set.
   */
  public boolean hasUri() {
    return audioSourceCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * URI that points to a file that contains audio data bytes as specified in
   * [RecognitionConfig][google.cloud.speech.v2.RecognitionConfig]. The file
   * must not be compressed (for example, gzip). Currently, only Google Cloud
   * Storage URIs are supported, which must be specified in the following
   * format: `gs://bucket_name/object_name` (other URI formats return
   * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more
   * information, see [Request
   * URIs](https://cloud.google.com/storage/docs/reference-uris).
   * </pre>
   *
   * <code>string uri = 6;</code>
   *
   * @return The uri.
   */
  public java.lang.String getUri() {
    java.lang.Object ref = "";
    if (audioSourceCase_ == 6) {
      ref = audioSource_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (audioSourceCase_ == 6) {
        audioSource_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URI that points to a file that contains audio data bytes as specified in
   * [RecognitionConfig][google.cloud.speech.v2.RecognitionConfig]. The file
   * must not be compressed (for example, gzip). Currently, only Google Cloud
   * Storage URIs are supported, which must be specified in the following
   * format: `gs://bucket_name/object_name` (other URI formats return
   * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more
   * information, see [Request
   * URIs](https://cloud.google.com/storage/docs/reference-uris).
   * </pre>
   *
   * <code>string uri = 6;</code>
   *
   * @return The bytes for uri.
   */
  public com.google.protobuf.ByteString getUriBytes() {
    java.lang.Object ref = "";
    if (audioSourceCase_ == 6) {
      ref = audioSource_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (audioSourceCase_ == 6) {
        audioSource_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (config_ != null) {
      output.writeMessage(1, getConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(recognizer_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, recognizer_);
    }
    if (audioSourceCase_ == 5) {
      output.writeBytes(5, (com.google.protobuf.ByteString) audioSource_);
    }
    if (audioSourceCase_ == 6) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, audioSource_);
    }
    if (configMask_ != null) {
      output.writeMessage(8, getConfigMask());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (config_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(recognizer_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, recognizer_);
    }
    if (audioSourceCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBytesSize(
              5, (com.google.protobuf.ByteString) audioSource_);
    }
    if (audioSourceCase_ == 6) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, audioSource_);
    }
    if (configMask_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getConfigMask());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.speech.v2.RecognizeRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.speech.v2.RecognizeRequest other =
        (com.google.cloud.speech.v2.RecognizeRequest) obj;

    if (!getRecognizer().equals(other.getRecognizer())) return false;
    if (hasConfig() != other.hasConfig()) return false;
    if (hasConfig()) {
      if (!getConfig().equals(other.getConfig())) return false;
    }
    if (hasConfigMask() != other.hasConfigMask()) return false;
    if (hasConfigMask()) {
      if (!getConfigMask().equals(other.getConfigMask())) return false;
    }
    if (!getAudioSourceCase().equals(other.getAudioSourceCase())) return false;
    switch (audioSourceCase_) {
      case 5:
        if (!getContent().equals(other.getContent())) return false;
        break;
      case 6:
        if (!getUri().equals(other.getUri())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RECOGNIZER_FIELD_NUMBER;
    hash = (53 * hash) + getRecognizer().hashCode();
    if (hasConfig()) {
      hash = (37 * hash) + CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getConfig().hashCode();
    }
    if (hasConfigMask()) {
      hash = (37 * hash) + CONFIG_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getConfigMask().hashCode();
    }
    switch (audioSourceCase_) {
      case 5:
        hash = (37 * hash) + CONTENT_FIELD_NUMBER;
        hash = (53 * hash) + getContent().hashCode();
        break;
      case 6:
        hash = (37 * hash) + URI_FIELD_NUMBER;
        hash = (53 * hash) + getUri().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.speech.v2.RecognizeRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.RecognizeRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.RecognizeRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.RecognizeRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.RecognizeRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.RecognizeRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.RecognizeRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.RecognizeRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.RecognizeRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.RecognizeRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.RecognizeRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.RecognizeRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.speech.v2.RecognizeRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for the
   * [Recognize][google.cloud.speech.v2.Speech.Recognize] method. Either
   * `content` or `uri` must be supplied. Supplying both or neither returns
   * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]. See [content
   * limits](https://cloud.google.com/speech-to-text/quotas#content).
   * </pre>
   *
   * Protobuf type {@code google.cloud.speech.v2.RecognizeRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.speech.v2.RecognizeRequest)
      com.google.cloud.speech.v2.RecognizeRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_RecognizeRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_RecognizeRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.speech.v2.RecognizeRequest.class,
              com.google.cloud.speech.v2.RecognizeRequest.Builder.class);
    }

    // Construct using com.google.cloud.speech.v2.RecognizeRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      recognizer_ = "";
      config_ = null;
      if (configBuilder_ != null) {
        configBuilder_.dispose();
        configBuilder_ = null;
      }
      configMask_ = null;
      if (configMaskBuilder_ != null) {
        configMaskBuilder_.dispose();
        configMaskBuilder_ = null;
      }
      audioSourceCase_ = 0;
      audioSource_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_RecognizeRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.RecognizeRequest getDefaultInstanceForType() {
      return com.google.cloud.speech.v2.RecognizeRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.RecognizeRequest build() {
      com.google.cloud.speech.v2.RecognizeRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.RecognizeRequest buildPartial() {
      com.google.cloud.speech.v2.RecognizeRequest result =
          new com.google.cloud.speech.v2.RecognizeRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.speech.v2.RecognizeRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.recognizer_ = recognizer_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.config_ = configBuilder_ == null ? config_ : configBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.configMask_ = configMaskBuilder_ == null ? configMask_ : configMaskBuilder_.build();
      }
    }

    private void buildPartialOneofs(com.google.cloud.speech.v2.RecognizeRequest result) {
      result.audioSourceCase_ = audioSourceCase_;
      result.audioSource_ = this.audioSource_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.speech.v2.RecognizeRequest) {
        return mergeFrom((com.google.cloud.speech.v2.RecognizeRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.speech.v2.RecognizeRequest other) {
      if (other == com.google.cloud.speech.v2.RecognizeRequest.getDefaultInstance()) return this;
      if (!other.getRecognizer().isEmpty()) {
        recognizer_ = other.recognizer_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasConfig()) {
        mergeConfig(other.getConfig());
      }
      if (other.hasConfigMask()) {
        mergeConfigMask(other.getConfigMask());
      }
      switch (other.getAudioSourceCase()) {
        case CONTENT:
          {
            setContent(other.getContent());
            break;
          }
        case URI:
          {
            audioSourceCase_ = 6;
            audioSource_ = other.audioSource_;
            onChanged();
            break;
          }
        case AUDIOSOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 26:
              {
                recognizer_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 26
            case 42:
              {
                audioSource_ = input.readBytes();
                audioSourceCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                audioSourceCase_ = 6;
                audioSource_ = s;
                break;
              } // case 50
            case 66:
              {
                input.readMessage(getConfigMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int audioSourceCase_ = 0;
    private java.lang.Object audioSource_;

    public AudioSourceCase getAudioSourceCase() {
      return AudioSourceCase.forNumber(audioSourceCase_);
    }

    public Builder clearAudioSource() {
      audioSourceCase_ = 0;
      audioSource_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object recognizer_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the Recognizer to use during recognition. The
     * expected format is
     * `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
     * {recognizer} segment may be set to `_` to use an empty implicit Recognizer.
     * </pre>
     *
     * <code>
     * string recognizer = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The recognizer.
     */
    public java.lang.String getRecognizer() {
      java.lang.Object ref = recognizer_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        recognizer_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Recognizer to use during recognition. The
     * expected format is
     * `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
     * {recognizer} segment may be set to `_` to use an empty implicit Recognizer.
     * </pre>
     *
     * <code>
     * string recognizer = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for recognizer.
     */
    public com.google.protobuf.ByteString getRecognizerBytes() {
      java.lang.Object ref = recognizer_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        recognizer_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Recognizer to use during recognition. The
     * expected format is
     * `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
     * {recognizer} segment may be set to `_` to use an empty implicit Recognizer.
     * </pre>
     *
     * <code>
     * string recognizer = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The recognizer to set.
     * @return This builder for chaining.
     */
    public Builder setRecognizer(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      recognizer_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Recognizer to use during recognition. The
     * expected format is
     * `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
     * {recognizer} segment may be set to `_` to use an empty implicit Recognizer.
     * </pre>
     *
     * <code>
     * string recognizer = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRecognizer() {
      recognizer_ = getDefaultInstance().getRecognizer();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Recognizer to use during recognition. The
     * expected format is
     * `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
     * {recognizer} segment may be set to `_` to use an empty implicit Recognizer.
     * </pre>
     *
     * <code>
     * string recognizer = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for recognizer to set.
     * @return This builder for chaining.
     */
    public Builder setRecognizerBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      recognizer_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.speech.v2.RecognitionConfig config_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.RecognitionConfig,
            com.google.cloud.speech.v2.RecognitionConfig.Builder,
            com.google.cloud.speech.v2.RecognitionConfigOrBuilder>
        configBuilder_;
    /**
     *
     *
     * <pre>
     * Features and audio metadata to use for the Automatic Speech Recognition.
     * This field in combination with the
     * [config_mask][google.cloud.speech.v2.RecognizeRequest.config_mask] field
     * can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig config = 1;</code>
     *
     * @return Whether the config field is set.
     */
    public boolean hasConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Features and audio metadata to use for the Automatic Speech Recognition.
     * This field in combination with the
     * [config_mask][google.cloud.speech.v2.RecognizeRequest.config_mask] field
     * can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig config = 1;</code>
     *
     * @return The config.
     */
    public com.google.cloud.speech.v2.RecognitionConfig getConfig() {
      if (configBuilder_ == null) {
        return config_ == null
            ? com.google.cloud.speech.v2.RecognitionConfig.getDefaultInstance()
            : config_;
      } else {
        return configBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Features and audio metadata to use for the Automatic Speech Recognition.
     * This field in combination with the
     * [config_mask][google.cloud.speech.v2.RecognizeRequest.config_mask] field
     * can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig config = 1;</code>
     */
    public Builder setConfig(com.google.cloud.speech.v2.RecognitionConfig value) {
      if (configBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        config_ = value;
      } else {
        configBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Features and audio metadata to use for the Automatic Speech Recognition.
     * This field in combination with the
     * [config_mask][google.cloud.speech.v2.RecognizeRequest.config_mask] field
     * can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig config = 1;</code>
     */
    public Builder setConfig(com.google.cloud.speech.v2.RecognitionConfig.Builder builderForValue) {
      if (configBuilder_ == null) {
        config_ = builderForValue.build();
      } else {
        configBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Features and audio metadata to use for the Automatic Speech Recognition.
     * This field in combination with the
     * [config_mask][google.cloud.speech.v2.RecognizeRequest.config_mask] field
     * can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig config = 1;</code>
     */
    public Builder mergeConfig(com.google.cloud.speech.v2.RecognitionConfig value) {
      if (configBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && config_ != null
            && config_ != com.google.cloud.speech.v2.RecognitionConfig.getDefaultInstance()) {
          getConfigBuilder().mergeFrom(value);
        } else {
          config_ = value;
        }
      } else {
        configBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Features and audio metadata to use for the Automatic Speech Recognition.
     * This field in combination with the
     * [config_mask][google.cloud.speech.v2.RecognizeRequest.config_mask] field
     * can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig config = 1;</code>
     */
    public Builder clearConfig() {
      bitField0_ = (bitField0_ & ~0x00000002);
      config_ = null;
      if (configBuilder_ != null) {
        configBuilder_.dispose();
        configBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Features and audio metadata to use for the Automatic Speech Recognition.
     * This field in combination with the
     * [config_mask][google.cloud.speech.v2.RecognizeRequest.config_mask] field
     * can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig config = 1;</code>
     */
    public com.google.cloud.speech.v2.RecognitionConfig.Builder getConfigBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Features and audio metadata to use for the Automatic Speech Recognition.
     * This field in combination with the
     * [config_mask][google.cloud.speech.v2.RecognizeRequest.config_mask] field
     * can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig config = 1;</code>
     */
    public com.google.cloud.speech.v2.RecognitionConfigOrBuilder getConfigOrBuilder() {
      if (configBuilder_ != null) {
        return configBuilder_.getMessageOrBuilder();
      } else {
        return config_ == null
            ? com.google.cloud.speech.v2.RecognitionConfig.getDefaultInstance()
            : config_;
      }
    }
    /**
     *
     *
     * <pre>
     * Features and audio metadata to use for the Automatic Speech Recognition.
     * This field in combination with the
     * [config_mask][google.cloud.speech.v2.RecognizeRequest.config_mask] field
     * can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig config = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.RecognitionConfig,
            com.google.cloud.speech.v2.RecognitionConfig.Builder,
            com.google.cloud.speech.v2.RecognitionConfigOrBuilder>
        getConfigFieldBuilder() {
      if (configBuilder_ == null) {
        configBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v2.RecognitionConfig,
                com.google.cloud.speech.v2.RecognitionConfig.Builder,
                com.google.cloud.speech.v2.RecognitionConfigOrBuilder>(
                getConfig(), getParentForChildren(), isClean());
        config_ = null;
      }
      return configBuilder_;
    }

    private com.google.protobuf.FieldMask configMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        configMaskBuilder_;
    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.RecognizeRequest.config] that override the
     * values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all non-default valued fields in
     * [config][google.cloud.speech.v2.RecognizeRequest.config] override the
     * values in the recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.RecognizeRequest.config] completely
     * overrides and replaces the config in the recognizer for this recognition
     * request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 8;</code>
     *
     * @return Whether the configMask field is set.
     */
    public boolean hasConfigMask() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.RecognizeRequest.config] that override the
     * values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all non-default valued fields in
     * [config][google.cloud.speech.v2.RecognizeRequest.config] override the
     * values in the recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.RecognizeRequest.config] completely
     * overrides and replaces the config in the recognizer for this recognition
     * request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 8;</code>
     *
     * @return The configMask.
     */
    public com.google.protobuf.FieldMask getConfigMask() {
      if (configMaskBuilder_ == null) {
        return configMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : configMask_;
      } else {
        return configMaskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.RecognizeRequest.config] that override the
     * values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all non-default valued fields in
     * [config][google.cloud.speech.v2.RecognizeRequest.config] override the
     * values in the recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.RecognizeRequest.config] completely
     * overrides and replaces the config in the recognizer for this recognition
     * request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 8;</code>
     */
    public Builder setConfigMask(com.google.protobuf.FieldMask value) {
      if (configMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        configMask_ = value;
      } else {
        configMaskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.RecognizeRequest.config] that override the
     * values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all non-default valued fields in
     * [config][google.cloud.speech.v2.RecognizeRequest.config] override the
     * values in the recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.RecognizeRequest.config] completely
     * overrides and replaces the config in the recognizer for this recognition
     * request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 8;</code>
     */
    public Builder setConfigMask(com.google.protobuf.FieldMask.Builder builderForValue) {
      if (configMaskBuilder_ == null) {
        configMask_ = builderForValue.build();
      } else {
        configMaskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.RecognizeRequest.config] that override the
     * values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all non-default valued fields in
     * [config][google.cloud.speech.v2.RecognizeRequest.config] override the
     * values in the recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.RecognizeRequest.config] completely
     * overrides and replaces the config in the recognizer for this recognition
     * request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 8;</code>
     */
    public Builder mergeConfigMask(com.google.protobuf.FieldMask value) {
      if (configMaskBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && configMask_ != null
            && configMask_ != com.google.protobuf.FieldMask.getDefaultInstance()) {
          getConfigMaskBuilder().mergeFrom(value);
        } else {
          configMask_ = value;
        }
      } else {
        configMaskBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.RecognizeRequest.config] that override the
     * values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all non-default valued fields in
     * [config][google.cloud.speech.v2.RecognizeRequest.config] override the
     * values in the recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.RecognizeRequest.config] completely
     * overrides and replaces the config in the recognizer for this recognition
     * request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 8;</code>
     */
    public Builder clearConfigMask() {
      bitField0_ = (bitField0_ & ~0x00000004);
      configMask_ = null;
      if (configMaskBuilder_ != null) {
        configMaskBuilder_.dispose();
        configMaskBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.RecognizeRequest.config] that override the
     * values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all non-default valued fields in
     * [config][google.cloud.speech.v2.RecognizeRequest.config] override the
     * values in the recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.RecognizeRequest.config] completely
     * overrides and replaces the config in the recognizer for this recognition
     * request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 8;</code>
     */
    public com.google.protobuf.FieldMask.Builder getConfigMaskBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getConfigMaskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.RecognizeRequest.config] that override the
     * values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all non-default valued fields in
     * [config][google.cloud.speech.v2.RecognizeRequest.config] override the
     * values in the recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.RecognizeRequest.config] completely
     * overrides and replaces the config in the recognizer for this recognition
     * request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 8;</code>
     */
    public com.google.protobuf.FieldMaskOrBuilder getConfigMaskOrBuilder() {
      if (configMaskBuilder_ != null) {
        return configMaskBuilder_.getMessageOrBuilder();
      } else {
        return configMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : configMask_;
      }
    }
    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.RecognizeRequest.config] that override the
     * values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all non-default valued fields in
     * [config][google.cloud.speech.v2.RecognizeRequest.config] override the
     * values in the recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.RecognizeRequest.config] completely
     * overrides and replaces the config in the recognizer for this recognition
     * request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        getConfigMaskFieldBuilder() {
      if (configMaskBuilder_ == null) {
        configMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FieldMask,
                com.google.protobuf.FieldMask.Builder,
                com.google.protobuf.FieldMaskOrBuilder>(
                getConfigMask(), getParentForChildren(), isClean());
        configMask_ = null;
      }
      return configMaskBuilder_;
    }

    /**
     *
     *
     * <pre>
     * The audio data bytes encoded as specified in
     * [RecognitionConfig][google.cloud.speech.v2.RecognitionConfig]. As
     * with all bytes fields, proto buffers use a pure binary representation,
     * whereas JSON representations use base64.
     * </pre>
     *
     * <code>bytes content = 5;</code>
     *
     * @return Whether the content field is set.
     */
    public boolean hasContent() {
      return audioSourceCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * The audio data bytes encoded as specified in
     * [RecognitionConfig][google.cloud.speech.v2.RecognitionConfig]. As
     * with all bytes fields, proto buffers use a pure binary representation,
     * whereas JSON representations use base64.
     * </pre>
     *
     * <code>bytes content = 5;</code>
     *
     * @return The content.
     */
    public com.google.protobuf.ByteString getContent() {
      if (audioSourceCase_ == 5) {
        return (com.google.protobuf.ByteString) audioSource_;
      }
      return com.google.protobuf.ByteString.EMPTY;
    }
    /**
     *
     *
     * <pre>
     * The audio data bytes encoded as specified in
     * [RecognitionConfig][google.cloud.speech.v2.RecognitionConfig]. As
     * with all bytes fields, proto buffers use a pure binary representation,
     * whereas JSON representations use base64.
     * </pre>
     *
     * <code>bytes content = 5;</code>
     *
     * @param value The content to set.
     * @return This builder for chaining.
     */
    public Builder setContent(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      audioSourceCase_ = 5;
      audioSource_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The audio data bytes encoded as specified in
     * [RecognitionConfig][google.cloud.speech.v2.RecognitionConfig]. As
     * with all bytes fields, proto buffers use a pure binary representation,
     * whereas JSON representations use base64.
     * </pre>
     *
     * <code>bytes content = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContent() {
      if (audioSourceCase_ == 5) {
        audioSourceCase_ = 0;
        audioSource_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * URI that points to a file that contains audio data bytes as specified in
     * [RecognitionConfig][google.cloud.speech.v2.RecognitionConfig]. The file
     * must not be compressed (for example, gzip). Currently, only Google Cloud
     * Storage URIs are supported, which must be specified in the following
     * format: `gs://bucket_name/object_name` (other URI formats return
     * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more
     * information, see [Request
     * URIs](https://cloud.google.com/storage/docs/reference-uris).
     * </pre>
     *
     * <code>string uri = 6;</code>
     *
     * @return Whether the uri field is set.
     */
    @java.lang.Override
    public boolean hasUri() {
      return audioSourceCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * URI that points to a file that contains audio data bytes as specified in
     * [RecognitionConfig][google.cloud.speech.v2.RecognitionConfig]. The file
     * must not be compressed (for example, gzip). Currently, only Google Cloud
     * Storage URIs are supported, which must be specified in the following
     * format: `gs://bucket_name/object_name` (other URI formats return
     * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more
     * information, see [Request
     * URIs](https://cloud.google.com/storage/docs/reference-uris).
     * </pre>
     *
     * <code>string uri = 6;</code>
     *
     * @return The uri.
     */
    @java.lang.Override
    public java.lang.String getUri() {
      java.lang.Object ref = "";
      if (audioSourceCase_ == 6) {
        ref = audioSource_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (audioSourceCase_ == 6) {
          audioSource_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI that points to a file that contains audio data bytes as specified in
     * [RecognitionConfig][google.cloud.speech.v2.RecognitionConfig]. The file
     * must not be compressed (for example, gzip). Currently, only Google Cloud
     * Storage URIs are supported, which must be specified in the following
     * format: `gs://bucket_name/object_name` (other URI formats return
     * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more
     * information, see [Request
     * URIs](https://cloud.google.com/storage/docs/reference-uris).
     * </pre>
     *
     * <code>string uri = 6;</code>
     *
     * @return The bytes for uri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = "";
      if (audioSourceCase_ == 6) {
        ref = audioSource_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (audioSourceCase_ == 6) {
          audioSource_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI that points to a file that contains audio data bytes as specified in
     * [RecognitionConfig][google.cloud.speech.v2.RecognitionConfig]. The file
     * must not be compressed (for example, gzip). Currently, only Google Cloud
     * Storage URIs are supported, which must be specified in the following
     * format: `gs://bucket_name/object_name` (other URI formats return
     * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more
     * information, see [Request
     * URIs](https://cloud.google.com/storage/docs/reference-uris).
     * </pre>
     *
     * <code>string uri = 6;</code>
     *
     * @param value The uri to set.
     * @return This builder for chaining.
     */
    public Builder setUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      audioSourceCase_ = 6;
      audioSource_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI that points to a file that contains audio data bytes as specified in
     * [RecognitionConfig][google.cloud.speech.v2.RecognitionConfig]. The file
     * must not be compressed (for example, gzip). Currently, only Google Cloud
     * Storage URIs are supported, which must be specified in the following
     * format: `gs://bucket_name/object_name` (other URI formats return
     * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more
     * information, see [Request
     * URIs](https://cloud.google.com/storage/docs/reference-uris).
     * </pre>
     *
     * <code>string uri = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUri() {
      if (audioSourceCase_ == 6) {
        audioSourceCase_ = 0;
        audioSource_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI that points to a file that contains audio data bytes as specified in
     * [RecognitionConfig][google.cloud.speech.v2.RecognitionConfig]. The file
     * must not be compressed (for example, gzip). Currently, only Google Cloud
     * Storage URIs are supported, which must be specified in the following
     * format: `gs://bucket_name/object_name` (other URI formats return
     * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more
     * information, see [Request
     * URIs](https://cloud.google.com/storage/docs/reference-uris).
     * </pre>
     *
     * <code>string uri = 6;</code>
     *
     * @param value The bytes for uri to set.
     * @return This builder for chaining.
     */
    public Builder setUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      audioSourceCase_ = 6;
      audioSource_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.speech.v2.RecognizeRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.speech.v2.RecognizeRequest)
  private static final com.google.cloud.speech.v2.RecognizeRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.speech.v2.RecognizeRequest();
  }

  public static com.google.cloud.speech.v2.RecognizeRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RecognizeRequest> PARSER =
      new com.google.protobuf.AbstractParser<RecognizeRequest>() {
        @java.lang.Override
        public RecognizeRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RecognizeRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RecognizeRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.speech.v2.RecognizeRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
