/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/speech/v2/cloud_speech.proto

package com.google.cloud.speech.v2;

/**
 *
 *
 * <pre>
 * A Recognizer message. Stores recognition configuration and metadata.
 * </pre>
 *
 * Protobuf type {@code google.cloud.speech.v2.Recognizer}
 */
public final class Recognizer extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.speech.v2.Recognizer)
    RecognizerOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Recognizer.newBuilder() to construct.
  private Recognizer(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Recognizer() {
    name_ = "";
    uid_ = "";
    displayName_ = "";
    model_ = "";
    languageCodes_ = com.google.protobuf.LazyStringArrayList.emptyList();
    state_ = 0;
    etag_ = "";
    kmsKeyName_ = "";
    kmsKeyVersionName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Recognizer();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.speech.v2.CloudSpeechProto
        .internal_static_google_cloud_speech_v2_Recognizer_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 7:
        return internalGetAnnotations();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.speech.v2.CloudSpeechProto
        .internal_static_google_cloud_speech_v2_Recognizer_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.speech.v2.Recognizer.class,
            com.google.cloud.speech.v2.Recognizer.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Set of states that define the lifecycle of a Recognizer.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.speech.v2.Recognizer.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The default value. This value is used if the state is omitted.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The Recognizer is active and ready for use.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    ACTIVE(2),
    /**
     *
     *
     * <pre>
     * This Recognizer has been deleted.
     * </pre>
     *
     * <code>DELETED = 4;</code>
     */
    DELETED(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The default value. This value is used if the state is omitted.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The Recognizer is active and ready for use.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    public static final int ACTIVE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * This Recognizer has been deleted.
     * </pre>
     *
     * <code>DELETED = 4;</code>
     */
    public static final int DELETED_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 2:
          return ACTIVE;
        case 4:
          return DELETED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.speech.v2.Recognizer.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.speech.v2.Recognizer.State)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the Recognizer.
   * Format: `projects/{project}/locations/{location}/recognizers/{recognizer}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the Recognizer.
   * Format: `projects/{project}/locations/{location}/recognizers/{recognizer}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uid_ = "";
  /**
   *
   *
   * <pre>
   * Output only. System-assigned unique identifier for the Recognizer.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  @java.lang.Override
  public java.lang.String getUid() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. System-assigned unique identifier for the Recognizer.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUidBytes() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * User-settable, human-readable name for the Recognizer. Must be 63
   * characters or less.
   * </pre>
   *
   * <code>string display_name = 3;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * User-settable, human-readable name for the Recognizer. Must be 63
   * characters or less.
   * </pre>
   *
   * <code>string display_name = 3;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODEL_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object model_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Which model to use for recognition requests. Select the model
   * best suited to your domain to get best results.
   *
   * Guidance for choosing which model to use can be found in the [Transcription
   * Models
   * Documentation](https://cloud.google.com/speech-to-text/v2/docs/transcription-model)
   * and the models supported in each region can be found in the [Table Of
   * Supported
   * Models](https://cloud.google.com/speech-to-text/v2/docs/speech-to-text-supported-languages).
   * </pre>
   *
   * <code>string model = 4 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @deprecated google.cloud.speech.v2.Recognizer.model is deprecated. See
   *     google/cloud/speech/v2/cloud_speech.proto;l=596
   * @return The model.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getModel() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      model_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Which model to use for recognition requests. Select the model
   * best suited to your domain to get best results.
   *
   * Guidance for choosing which model to use can be found in the [Transcription
   * Models
   * Documentation](https://cloud.google.com/speech-to-text/v2/docs/transcription-model)
   * and the models supported in each region can be found in the [Table Of
   * Supported
   * Models](https://cloud.google.com/speech-to-text/v2/docs/speech-to-text-supported-languages).
   * </pre>
   *
   * <code>string model = 4 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @deprecated google.cloud.speech.v2.Recognizer.model is deprecated. See
   *     google/cloud/speech/v2/cloud_speech.proto;l=596
   * @return The bytes for model.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getModelBytes() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      model_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LANGUAGE_CODES_FIELD_NUMBER = 17;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList languageCodes_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. The language of the supplied audio as a
   * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
   *
   * Supported languages for each model are listed in the [Table of Supported
   * Models](https://cloud.google.com/speech-to-text/v2/docs/speech-to-text-supported-languages).
   *
   * If additional languages are provided, recognition result will contain
   * recognition in the most likely language detected. The recognition result
   * will include the language tag of the language detected in the audio.
   * When you create or update a Recognizer, these values are
   * stored in normalized BCP-47 form. For example, "en-us" is stored as
   * "en-US".
   * </pre>
   *
   * <code>
   * repeated string language_codes = 17 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @deprecated google.cloud.speech.v2.Recognizer.language_codes is deprecated. See
   *     google/cloud/speech/v2/cloud_speech.proto;l=610
   * @return A list containing the languageCodes.
   */
  @java.lang.Deprecated
  public com.google.protobuf.ProtocolStringList getLanguageCodesList() {
    return languageCodes_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The language of the supplied audio as a
   * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
   *
   * Supported languages for each model are listed in the [Table of Supported
   * Models](https://cloud.google.com/speech-to-text/v2/docs/speech-to-text-supported-languages).
   *
   * If additional languages are provided, recognition result will contain
   * recognition in the most likely language detected. The recognition result
   * will include the language tag of the language detected in the audio.
   * When you create or update a Recognizer, these values are
   * stored in normalized BCP-47 form. For example, "en-us" is stored as
   * "en-US".
   * </pre>
   *
   * <code>
   * repeated string language_codes = 17 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @deprecated google.cloud.speech.v2.Recognizer.language_codes is deprecated. See
   *     google/cloud/speech/v2/cloud_speech.proto;l=610
   * @return The count of languageCodes.
   */
  @java.lang.Deprecated
  public int getLanguageCodesCount() {
    return languageCodes_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The language of the supplied audio as a
   * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
   *
   * Supported languages for each model are listed in the [Table of Supported
   * Models](https://cloud.google.com/speech-to-text/v2/docs/speech-to-text-supported-languages).
   *
   * If additional languages are provided, recognition result will contain
   * recognition in the most likely language detected. The recognition result
   * will include the language tag of the language detected in the audio.
   * When you create or update a Recognizer, these values are
   * stored in normalized BCP-47 form. For example, "en-us" is stored as
   * "en-US".
   * </pre>
   *
   * <code>
   * repeated string language_codes = 17 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @deprecated google.cloud.speech.v2.Recognizer.language_codes is deprecated. See
   *     google/cloud/speech/v2/cloud_speech.proto;l=610
   * @param index The index of the element to return.
   * @return The languageCodes at the given index.
   */
  @java.lang.Deprecated
  public java.lang.String getLanguageCodes(int index) {
    return languageCodes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The language of the supplied audio as a
   * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
   *
   * Supported languages for each model are listed in the [Table of Supported
   * Models](https://cloud.google.com/speech-to-text/v2/docs/speech-to-text-supported-languages).
   *
   * If additional languages are provided, recognition result will contain
   * recognition in the most likely language detected. The recognition result
   * will include the language tag of the language detected in the audio.
   * When you create or update a Recognizer, these values are
   * stored in normalized BCP-47 form. For example, "en-us" is stored as
   * "en-US".
   * </pre>
   *
   * <code>
   * repeated string language_codes = 17 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @deprecated google.cloud.speech.v2.Recognizer.language_codes is deprecated. See
   *     google/cloud/speech/v2/cloud_speech.proto;l=610
   * @param index The index of the value to return.
   * @return The bytes of the languageCodes at the given index.
   */
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getLanguageCodesBytes(int index) {
    return languageCodes_.getByteString(index);
  }

  public static final int DEFAULT_RECOGNITION_CONFIG_FIELD_NUMBER = 6;
  private com.google.cloud.speech.v2.RecognitionConfig defaultRecognitionConfig_;
  /**
   *
   *
   * <pre>
   * Default configuration to use for requests with this Recognizer.
   * This can be overwritten by inline configuration in the
   * [RecognizeRequest.config][google.cloud.speech.v2.RecognizeRequest.config]
   * field.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.RecognitionConfig default_recognition_config = 6;</code>
   *
   * @return Whether the defaultRecognitionConfig field is set.
   */
  @java.lang.Override
  public boolean hasDefaultRecognitionConfig() {
    return defaultRecognitionConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Default configuration to use for requests with this Recognizer.
   * This can be overwritten by inline configuration in the
   * [RecognizeRequest.config][google.cloud.speech.v2.RecognizeRequest.config]
   * field.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.RecognitionConfig default_recognition_config = 6;</code>
   *
   * @return The defaultRecognitionConfig.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.RecognitionConfig getDefaultRecognitionConfig() {
    return defaultRecognitionConfig_ == null
        ? com.google.cloud.speech.v2.RecognitionConfig.getDefaultInstance()
        : defaultRecognitionConfig_;
  }
  /**
   *
   *
   * <pre>
   * Default configuration to use for requests with this Recognizer.
   * This can be overwritten by inline configuration in the
   * [RecognizeRequest.config][google.cloud.speech.v2.RecognizeRequest.config]
   * field.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.RecognitionConfig default_recognition_config = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.RecognitionConfigOrBuilder
      getDefaultRecognitionConfigOrBuilder() {
    return defaultRecognitionConfig_ == null
        ? com.google.cloud.speech.v2.RecognitionConfig.getDefaultInstance()
        : defaultRecognitionConfig_;
  }

  public static final int ANNOTATIONS_FIELD_NUMBER = 7;

  private static final class AnnotationsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.speech.v2.CloudSpeechProto
                .internal_static_google_cloud_speech_v2_Recognizer_AnnotationsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetAnnotations() {
    if (annotations_ == null) {
      return com.google.protobuf.MapField.emptyMapField(AnnotationsDefaultEntryHolder.defaultEntry);
    }
    return annotations_;
  }

  public int getAnnotationsCount() {
    return internalGetAnnotations().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Allows users to store small amounts of arbitrary data.
   * Both the key and the value must be 63 characters or less each.
   * At most 100 annotations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 7;</code>
   */
  @java.lang.Override
  public boolean containsAnnotations(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAnnotations().getMap().containsKey(key);
  }
  /** Use {@link #getAnnotationsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
    return getAnnotationsMap();
  }
  /**
   *
   *
   * <pre>
   * Allows users to store small amounts of arbitrary data.
   * Both the key and the value must be 63 characters or less each.
   * At most 100 annotations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 7;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
    return internalGetAnnotations().getMap();
  }
  /**
   *
   *
   * <pre>
   * Allows users to store small amounts of arbitrary data.
   * Both the key and the value must be 63 characters or less each.
   * At most 100 annotations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 7;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getAnnotationsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Allows users to store small amounts of arbitrary data.
   * Both the key and the value must be 63 characters or less each.
   * At most 100 annotations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 7;</code>
   */
  @java.lang.Override
  public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int STATE_FIELD_NUMBER = 8;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The Recognizer lifecycle state.
   * </pre>
   *
   * <code>
   * .google.cloud.speech.v2.Recognizer.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The Recognizer lifecycle state.
   * </pre>
   *
   * <code>
   * .google.cloud.speech.v2.Recognizer.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.Recognizer.State getState() {
    com.google.cloud.speech.v2.Recognizer.State result =
        com.google.cloud.speech.v2.Recognizer.State.forNumber(state_);
    return result == null ? com.google.cloud.speech.v2.Recognizer.State.UNRECOGNIZED : result;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The most recent time this Recognizer was modified.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The most recent time this Recognizer was modified.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The most recent time this Recognizer was modified.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int DELETE_TIME_FIELD_NUMBER = 11;
  private com.google.protobuf.Timestamp deleteTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time at which this Recognizer was requested for deletion.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the deleteTime field is set.
   */
  @java.lang.Override
  public boolean hasDeleteTime() {
    return deleteTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which this Recognizer was requested for deletion.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The deleteTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getDeleteTime() {
    return deleteTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deleteTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which this Recognizer was requested for deletion.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
    return deleteTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deleteTime_;
  }

  public static final int EXPIRE_TIME_FIELD_NUMBER = 14;
  private com.google.protobuf.Timestamp expireTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time at which this Recognizer will be purged.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the expireTime field is set.
   */
  @java.lang.Override
  public boolean hasExpireTime() {
    return expireTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which this Recognizer will be purged.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The expireTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getExpireTime() {
    return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which this Recognizer will be purged.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
    return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
  }

  public static final int ETAG_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * Output only. This checksum is computed by the server based on the value of
   * other fields. This may be sent on update, undelete, and delete requests to
   * ensure the client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. This checksum is computed by the server based on the value of
   * other fields. This may be sent on update, undelete, and delete requests to
   * ensure the client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RECONCILING_FIELD_NUMBER = 13;
  private boolean reconciling_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Whether or not this Recognizer is in the process of being
   * updated.
   * </pre>
   *
   * <code>bool reconciling = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The reconciling.
   */
  @java.lang.Override
  public boolean getReconciling() {
    return reconciling_;
  }

  public static final int KMS_KEY_NAME_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kmsKeyName_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The [KMS key
   * name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) with which
   * the Recognizer is encrypted. The expected format is
   * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
   * </pre>
   *
   * <code>
   * string kms_key_name = 15 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The kmsKeyName.
   */
  @java.lang.Override
  public java.lang.String getKmsKeyName() {
    java.lang.Object ref = kmsKeyName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kmsKeyName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The [KMS key
   * name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) with which
   * the Recognizer is encrypted. The expected format is
   * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
   * </pre>
   *
   * <code>
   * string kms_key_name = 15 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for kmsKeyName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKmsKeyNameBytes() {
    java.lang.Object ref = kmsKeyName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kmsKeyName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KMS_KEY_VERSION_NAME_FIELD_NUMBER = 16;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kmsKeyVersionName_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The [KMS key version
   * name](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions)
   * with which the Recognizer is encrypted. The expected format is
   * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`.
   * </pre>
   *
   * <code>
   * string kms_key_version_name = 16 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The kmsKeyVersionName.
   */
  @java.lang.Override
  public java.lang.String getKmsKeyVersionName() {
    java.lang.Object ref = kmsKeyVersionName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kmsKeyVersionName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The [KMS key version
   * name](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions)
   * with which the Recognizer is encrypted. The expected format is
   * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`.
   * </pre>
   *
   * <code>
   * string kms_key_version_name = 16 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for kmsKeyVersionName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKmsKeyVersionNameBytes() {
    java.lang.Object ref = kmsKeyVersionName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kmsKeyVersionName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, model_);
    }
    if (defaultRecognitionConfig_ != null) {
      output.writeMessage(6, getDefaultRecognitionConfig());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetAnnotations(), AnnotationsDefaultEntryHolder.defaultEntry, 7);
    if (state_ != com.google.cloud.speech.v2.Recognizer.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(8, state_);
    }
    if (createTime_ != null) {
      output.writeMessage(9, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(10, getUpdateTime());
    }
    if (deleteTime_ != null) {
      output.writeMessage(11, getDeleteTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, etag_);
    }
    if (reconciling_ != false) {
      output.writeBool(13, reconciling_);
    }
    if (expireTime_ != null) {
      output.writeMessage(14, getExpireTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, kmsKeyName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyVersionName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, kmsKeyVersionName_);
    }
    for (int i = 0; i < languageCodes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 17, languageCodes_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, model_);
    }
    if (defaultRecognitionConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, getDefaultRecognitionConfig());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetAnnotations().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
          AnnotationsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, annotations__);
    }
    if (state_ != com.google.cloud.speech.v2.Recognizer.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, state_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getUpdateTime());
    }
    if (deleteTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getDeleteTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, etag_);
    }
    if (reconciling_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(13, reconciling_);
    }
    if (expireTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getExpireTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, kmsKeyName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyVersionName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, kmsKeyVersionName_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < languageCodes_.size(); i++) {
        dataSize += computeStringSizeNoTag(languageCodes_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getLanguageCodesList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.speech.v2.Recognizer)) {
      return super.equals(obj);
    }
    com.google.cloud.speech.v2.Recognizer other = (com.google.cloud.speech.v2.Recognizer) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getUid().equals(other.getUid())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getModel().equals(other.getModel())) return false;
    if (!getLanguageCodesList().equals(other.getLanguageCodesList())) return false;
    if (hasDefaultRecognitionConfig() != other.hasDefaultRecognitionConfig()) return false;
    if (hasDefaultRecognitionConfig()) {
      if (!getDefaultRecognitionConfig().equals(other.getDefaultRecognitionConfig())) return false;
    }
    if (!internalGetAnnotations().equals(other.internalGetAnnotations())) return false;
    if (state_ != other.state_) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasDeleteTime() != other.hasDeleteTime()) return false;
    if (hasDeleteTime()) {
      if (!getDeleteTime().equals(other.getDeleteTime())) return false;
    }
    if (hasExpireTime() != other.hasExpireTime()) return false;
    if (hasExpireTime()) {
      if (!getExpireTime().equals(other.getExpireTime())) return false;
    }
    if (!getEtag().equals(other.getEtag())) return false;
    if (getReconciling() != other.getReconciling()) return false;
    if (!getKmsKeyName().equals(other.getKmsKeyName())) return false;
    if (!getKmsKeyVersionName().equals(other.getKmsKeyVersionName())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + UID_FIELD_NUMBER;
    hash = (53 * hash) + getUid().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + MODEL_FIELD_NUMBER;
    hash = (53 * hash) + getModel().hashCode();
    if (getLanguageCodesCount() > 0) {
      hash = (37 * hash) + LANGUAGE_CODES_FIELD_NUMBER;
      hash = (53 * hash) + getLanguageCodesList().hashCode();
    }
    if (hasDefaultRecognitionConfig()) {
      hash = (37 * hash) + DEFAULT_RECOGNITION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDefaultRecognitionConfig().hashCode();
    }
    if (!internalGetAnnotations().getMap().isEmpty()) {
      hash = (37 * hash) + ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAnnotations().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasDeleteTime()) {
      hash = (37 * hash) + DELETE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDeleteTime().hashCode();
    }
    if (hasExpireTime()) {
      hash = (37 * hash) + EXPIRE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getExpireTime().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (37 * hash) + RECONCILING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getReconciling());
    hash = (37 * hash) + KMS_KEY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getKmsKeyName().hashCode();
    hash = (37 * hash) + KMS_KEY_VERSION_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getKmsKeyVersionName().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.speech.v2.Recognizer parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.Recognizer parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.Recognizer parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.Recognizer parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.Recognizer parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.Recognizer parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.Recognizer parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.Recognizer parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.Recognizer parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.Recognizer parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.Recognizer parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.Recognizer parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.speech.v2.Recognizer prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Recognizer message. Stores recognition configuration and metadata.
   * </pre>
   *
   * Protobuf type {@code google.cloud.speech.v2.Recognizer}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.speech.v2.Recognizer)
      com.google.cloud.speech.v2.RecognizerOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_Recognizer_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 7:
          return internalGetAnnotations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 7:
          return internalGetMutableAnnotations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_Recognizer_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.speech.v2.Recognizer.class,
              com.google.cloud.speech.v2.Recognizer.Builder.class);
    }

    // Construct using com.google.cloud.speech.v2.Recognizer.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      uid_ = "";
      displayName_ = "";
      model_ = "";
      languageCodes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      defaultRecognitionConfig_ = null;
      if (defaultRecognitionConfigBuilder_ != null) {
        defaultRecognitionConfigBuilder_.dispose();
        defaultRecognitionConfigBuilder_ = null;
      }
      internalGetMutableAnnotations().clear();
      state_ = 0;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      deleteTime_ = null;
      if (deleteTimeBuilder_ != null) {
        deleteTimeBuilder_.dispose();
        deleteTimeBuilder_ = null;
      }
      expireTime_ = null;
      if (expireTimeBuilder_ != null) {
        expireTimeBuilder_.dispose();
        expireTimeBuilder_ = null;
      }
      etag_ = "";
      reconciling_ = false;
      kmsKeyName_ = "";
      kmsKeyVersionName_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_Recognizer_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.Recognizer getDefaultInstanceForType() {
      return com.google.cloud.speech.v2.Recognizer.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.Recognizer build() {
      com.google.cloud.speech.v2.Recognizer result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.Recognizer buildPartial() {
      com.google.cloud.speech.v2.Recognizer result =
          new com.google.cloud.speech.v2.Recognizer(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.speech.v2.Recognizer result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.uid_ = uid_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.model_ = model_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        languageCodes_.makeImmutable();
        result.languageCodes_ = languageCodes_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.defaultRecognitionConfig_ =
            defaultRecognitionConfigBuilder_ == null
                ? defaultRecognitionConfig_
                : defaultRecognitionConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.annotations_ = internalGetAnnotations();
        result.annotations_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.deleteTime_ = deleteTimeBuilder_ == null ? deleteTime_ : deleteTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.expireTime_ = expireTimeBuilder_ == null ? expireTime_ : expireTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.reconciling_ = reconciling_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.kmsKeyName_ = kmsKeyName_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.kmsKeyVersionName_ = kmsKeyVersionName_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.speech.v2.Recognizer) {
        return mergeFrom((com.google.cloud.speech.v2.Recognizer) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.speech.v2.Recognizer other) {
      if (other == com.google.cloud.speech.v2.Recognizer.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getUid().isEmpty()) {
        uid_ = other.uid_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getModel().isEmpty()) {
        model_ = other.model_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.languageCodes_.isEmpty()) {
        if (languageCodes_.isEmpty()) {
          languageCodes_ = other.languageCodes_;
          bitField0_ |= 0x00000010;
        } else {
          ensureLanguageCodesIsMutable();
          languageCodes_.addAll(other.languageCodes_);
        }
        onChanged();
      }
      if (other.hasDefaultRecognitionConfig()) {
        mergeDefaultRecognitionConfig(other.getDefaultRecognitionConfig());
      }
      internalGetMutableAnnotations().mergeFrom(other.internalGetAnnotations());
      bitField0_ |= 0x00000040;
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasDeleteTime()) {
        mergeDeleteTime(other.getDeleteTime());
      }
      if (other.hasExpireTime()) {
        mergeExpireTime(other.getExpireTime());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (other.getReconciling() != false) {
        setReconciling(other.getReconciling());
      }
      if (!other.getKmsKeyName().isEmpty()) {
        kmsKeyName_ = other.kmsKeyName_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (!other.getKmsKeyVersionName().isEmpty()) {
        kmsKeyVersionName_ = other.kmsKeyVersionName_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                uid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                model_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 50:
              {
                input.readMessage(
                    getDefaultRecognitionConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
                    input.readMessage(
                        AnnotationsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableAnnotations()
                    .getMutableMap()
                    .put(annotations__.getKey(), annotations__.getValue());
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 64:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 74:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getDeleteTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 98:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 98
            case 104:
              {
                reconciling_ = input.readBool();
                bitField0_ |= 0x00002000;
                break;
              } // case 104
            case 114:
              {
                input.readMessage(getExpireTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 114
            case 122:
              {
                kmsKeyName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 122
            case 130:
              {
                kmsKeyVersionName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 130
            case 138:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureLanguageCodesIsMutable();
                languageCodes_.add(s);
                break;
              } // case 138
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Recognizer.
     * Format: `projects/{project}/locations/{location}/recognizers/{recognizer}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Recognizer.
     * Format: `projects/{project}/locations/{location}/recognizers/{recognizer}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Recognizer.
     * Format: `projects/{project}/locations/{location}/recognizers/{recognizer}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Recognizer.
     * Format: `projects/{project}/locations/{location}/recognizers/{recognizer}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Recognizer.
     * Format: `projects/{project}/locations/{location}/recognizers/{recognizer}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object uid_ = "";
    /**
     *
     *
     * <pre>
     * Output only. System-assigned unique identifier for the Recognizer.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uid.
     */
    public java.lang.String getUid() {
      java.lang.Object ref = uid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. System-assigned unique identifier for the Recognizer.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uid.
     */
    public com.google.protobuf.ByteString getUidBytes() {
      java.lang.Object ref = uid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. System-assigned unique identifier for the Recognizer.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uid to set.
     * @return This builder for chaining.
     */
    public Builder setUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. System-assigned unique identifier for the Recognizer.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUid() {
      uid_ = getDefaultInstance().getUid();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. System-assigned unique identifier for the Recognizer.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uid to set.
     * @return This builder for chaining.
     */
    public Builder setUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * User-settable, human-readable name for the Recognizer. Must be 63
     * characters or less.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-settable, human-readable name for the Recognizer. Must be 63
     * characters or less.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-settable, human-readable name for the Recognizer. Must be 63
     * characters or less.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-settable, human-readable name for the Recognizer. Must be 63
     * characters or less.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-settable, human-readable name for the Recognizer. Must be 63
     * characters or less.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object model_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Which model to use for recognition requests. Select the model
     * best suited to your domain to get best results.
     *
     * Guidance for choosing which model to use can be found in the [Transcription
     * Models
     * Documentation](https://cloud.google.com/speech-to-text/v2/docs/transcription-model)
     * and the models supported in each region can be found in the [Table Of
     * Supported
     * Models](https://cloud.google.com/speech-to-text/v2/docs/speech-to-text-supported-languages).
     * </pre>
     *
     * <code>string model = 4 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @deprecated google.cloud.speech.v2.Recognizer.model is deprecated. See
     *     google/cloud/speech/v2/cloud_speech.proto;l=596
     * @return The model.
     */
    @java.lang.Deprecated
    public java.lang.String getModel() {
      java.lang.Object ref = model_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        model_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Which model to use for recognition requests. Select the model
     * best suited to your domain to get best results.
     *
     * Guidance for choosing which model to use can be found in the [Transcription
     * Models
     * Documentation](https://cloud.google.com/speech-to-text/v2/docs/transcription-model)
     * and the models supported in each region can be found in the [Table Of
     * Supported
     * Models](https://cloud.google.com/speech-to-text/v2/docs/speech-to-text-supported-languages).
     * </pre>
     *
     * <code>string model = 4 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @deprecated google.cloud.speech.v2.Recognizer.model is deprecated. See
     *     google/cloud/speech/v2/cloud_speech.proto;l=596
     * @return The bytes for model.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getModelBytes() {
      java.lang.Object ref = model_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        model_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Which model to use for recognition requests. Select the model
     * best suited to your domain to get best results.
     *
     * Guidance for choosing which model to use can be found in the [Transcription
     * Models
     * Documentation](https://cloud.google.com/speech-to-text/v2/docs/transcription-model)
     * and the models supported in each region can be found in the [Table Of
     * Supported
     * Models](https://cloud.google.com/speech-to-text/v2/docs/speech-to-text-supported-languages).
     * </pre>
     *
     * <code>string model = 4 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @deprecated google.cloud.speech.v2.Recognizer.model is deprecated. See
     *     google/cloud/speech/v2/cloud_speech.proto;l=596
     * @param value The model to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setModel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      model_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Which model to use for recognition requests. Select the model
     * best suited to your domain to get best results.
     *
     * Guidance for choosing which model to use can be found in the [Transcription
     * Models
     * Documentation](https://cloud.google.com/speech-to-text/v2/docs/transcription-model)
     * and the models supported in each region can be found in the [Table Of
     * Supported
     * Models](https://cloud.google.com/speech-to-text/v2/docs/speech-to-text-supported-languages).
     * </pre>
     *
     * <code>string model = 4 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @deprecated google.cloud.speech.v2.Recognizer.model is deprecated. See
     *     google/cloud/speech/v2/cloud_speech.proto;l=596
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearModel() {
      model_ = getDefaultInstance().getModel();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Which model to use for recognition requests. Select the model
     * best suited to your domain to get best results.
     *
     * Guidance for choosing which model to use can be found in the [Transcription
     * Models
     * Documentation](https://cloud.google.com/speech-to-text/v2/docs/transcription-model)
     * and the models supported in each region can be found in the [Table Of
     * Supported
     * Models](https://cloud.google.com/speech-to-text/v2/docs/speech-to-text-supported-languages).
     * </pre>
     *
     * <code>string model = 4 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @deprecated google.cloud.speech.v2.Recognizer.model is deprecated. See
     *     google/cloud/speech/v2/cloud_speech.proto;l=596
     * @param value The bytes for model to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setModelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      model_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList languageCodes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureLanguageCodesIsMutable() {
      if (!languageCodes_.isModifiable()) {
        languageCodes_ = new com.google.protobuf.LazyStringArrayList(languageCodes_);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     *
     *
     * <pre>
     * Optional. The language of the supplied audio as a
     * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
     *
     * Supported languages for each model are listed in the [Table of Supported
     * Models](https://cloud.google.com/speech-to-text/v2/docs/speech-to-text-supported-languages).
     *
     * If additional languages are provided, recognition result will contain
     * recognition in the most likely language detected. The recognition result
     * will include the language tag of the language detected in the audio.
     * When you create or update a Recognizer, these values are
     * stored in normalized BCP-47 form. For example, "en-us" is stored as
     * "en-US".
     * </pre>
     *
     * <code>
     * repeated string language_codes = 17 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated google.cloud.speech.v2.Recognizer.language_codes is deprecated. See
     *     google/cloud/speech/v2/cloud_speech.proto;l=610
     * @return A list containing the languageCodes.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ProtocolStringList getLanguageCodesList() {
      languageCodes_.makeImmutable();
      return languageCodes_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The language of the supplied audio as a
     * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
     *
     * Supported languages for each model are listed in the [Table of Supported
     * Models](https://cloud.google.com/speech-to-text/v2/docs/speech-to-text-supported-languages).
     *
     * If additional languages are provided, recognition result will contain
     * recognition in the most likely language detected. The recognition result
     * will include the language tag of the language detected in the audio.
     * When you create or update a Recognizer, these values are
     * stored in normalized BCP-47 form. For example, "en-us" is stored as
     * "en-US".
     * </pre>
     *
     * <code>
     * repeated string language_codes = 17 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated google.cloud.speech.v2.Recognizer.language_codes is deprecated. See
     *     google/cloud/speech/v2/cloud_speech.proto;l=610
     * @return The count of languageCodes.
     */
    @java.lang.Deprecated
    public int getLanguageCodesCount() {
      return languageCodes_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The language of the supplied audio as a
     * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
     *
     * Supported languages for each model are listed in the [Table of Supported
     * Models](https://cloud.google.com/speech-to-text/v2/docs/speech-to-text-supported-languages).
     *
     * If additional languages are provided, recognition result will contain
     * recognition in the most likely language detected. The recognition result
     * will include the language tag of the language detected in the audio.
     * When you create or update a Recognizer, these values are
     * stored in normalized BCP-47 form. For example, "en-us" is stored as
     * "en-US".
     * </pre>
     *
     * <code>
     * repeated string language_codes = 17 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated google.cloud.speech.v2.Recognizer.language_codes is deprecated. See
     *     google/cloud/speech/v2/cloud_speech.proto;l=610
     * @param index The index of the element to return.
     * @return The languageCodes at the given index.
     */
    @java.lang.Deprecated
    public java.lang.String getLanguageCodes(int index) {
      return languageCodes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The language of the supplied audio as a
     * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
     *
     * Supported languages for each model are listed in the [Table of Supported
     * Models](https://cloud.google.com/speech-to-text/v2/docs/speech-to-text-supported-languages).
     *
     * If additional languages are provided, recognition result will contain
     * recognition in the most likely language detected. The recognition result
     * will include the language tag of the language detected in the audio.
     * When you create or update a Recognizer, these values are
     * stored in normalized BCP-47 form. For example, "en-us" is stored as
     * "en-US".
     * </pre>
     *
     * <code>
     * repeated string language_codes = 17 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated google.cloud.speech.v2.Recognizer.language_codes is deprecated. See
     *     google/cloud/speech/v2/cloud_speech.proto;l=610
     * @param index The index of the value to return.
     * @return The bytes of the languageCodes at the given index.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getLanguageCodesBytes(int index) {
      return languageCodes_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The language of the supplied audio as a
     * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
     *
     * Supported languages for each model are listed in the [Table of Supported
     * Models](https://cloud.google.com/speech-to-text/v2/docs/speech-to-text-supported-languages).
     *
     * If additional languages are provided, recognition result will contain
     * recognition in the most likely language detected. The recognition result
     * will include the language tag of the language detected in the audio.
     * When you create or update a Recognizer, these values are
     * stored in normalized BCP-47 form. For example, "en-us" is stored as
     * "en-US".
     * </pre>
     *
     * <code>
     * repeated string language_codes = 17 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated google.cloud.speech.v2.Recognizer.language_codes is deprecated. See
     *     google/cloud/speech/v2/cloud_speech.proto;l=610
     * @param index The index to set the value at.
     * @param value The languageCodes to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setLanguageCodes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLanguageCodesIsMutable();
      languageCodes_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The language of the supplied audio as a
     * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
     *
     * Supported languages for each model are listed in the [Table of Supported
     * Models](https://cloud.google.com/speech-to-text/v2/docs/speech-to-text-supported-languages).
     *
     * If additional languages are provided, recognition result will contain
     * recognition in the most likely language detected. The recognition result
     * will include the language tag of the language detected in the audio.
     * When you create or update a Recognizer, these values are
     * stored in normalized BCP-47 form. For example, "en-us" is stored as
     * "en-US".
     * </pre>
     *
     * <code>
     * repeated string language_codes = 17 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated google.cloud.speech.v2.Recognizer.language_codes is deprecated. See
     *     google/cloud/speech/v2/cloud_speech.proto;l=610
     * @param value The languageCodes to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addLanguageCodes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLanguageCodesIsMutable();
      languageCodes_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The language of the supplied audio as a
     * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
     *
     * Supported languages for each model are listed in the [Table of Supported
     * Models](https://cloud.google.com/speech-to-text/v2/docs/speech-to-text-supported-languages).
     *
     * If additional languages are provided, recognition result will contain
     * recognition in the most likely language detected. The recognition result
     * will include the language tag of the language detected in the audio.
     * When you create or update a Recognizer, these values are
     * stored in normalized BCP-47 form. For example, "en-us" is stored as
     * "en-US".
     * </pre>
     *
     * <code>
     * repeated string language_codes = 17 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated google.cloud.speech.v2.Recognizer.language_codes is deprecated. See
     *     google/cloud/speech/v2/cloud_speech.proto;l=610
     * @param values The languageCodes to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addAllLanguageCodes(java.lang.Iterable<java.lang.String> values) {
      ensureLanguageCodesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, languageCodes_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The language of the supplied audio as a
     * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
     *
     * Supported languages for each model are listed in the [Table of Supported
     * Models](https://cloud.google.com/speech-to-text/v2/docs/speech-to-text-supported-languages).
     *
     * If additional languages are provided, recognition result will contain
     * recognition in the most likely language detected. The recognition result
     * will include the language tag of the language detected in the audio.
     * When you create or update a Recognizer, these values are
     * stored in normalized BCP-47 form. For example, "en-us" is stored as
     * "en-US".
     * </pre>
     *
     * <code>
     * repeated string language_codes = 17 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated google.cloud.speech.v2.Recognizer.language_codes is deprecated. See
     *     google/cloud/speech/v2/cloud_speech.proto;l=610
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearLanguageCodes() {
      languageCodes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The language of the supplied audio as a
     * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
     *
     * Supported languages for each model are listed in the [Table of Supported
     * Models](https://cloud.google.com/speech-to-text/v2/docs/speech-to-text-supported-languages).
     *
     * If additional languages are provided, recognition result will contain
     * recognition in the most likely language detected. The recognition result
     * will include the language tag of the language detected in the audio.
     * When you create or update a Recognizer, these values are
     * stored in normalized BCP-47 form. For example, "en-us" is stored as
     * "en-US".
     * </pre>
     *
     * <code>
     * repeated string language_codes = 17 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated google.cloud.speech.v2.Recognizer.language_codes is deprecated. See
     *     google/cloud/speech/v2/cloud_speech.proto;l=610
     * @param value The bytes of the languageCodes to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addLanguageCodesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureLanguageCodesIsMutable();
      languageCodes_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.cloud.speech.v2.RecognitionConfig defaultRecognitionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.RecognitionConfig,
            com.google.cloud.speech.v2.RecognitionConfig.Builder,
            com.google.cloud.speech.v2.RecognitionConfigOrBuilder>
        defaultRecognitionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Default configuration to use for requests with this Recognizer.
     * This can be overwritten by inline configuration in the
     * [RecognizeRequest.config][google.cloud.speech.v2.RecognizeRequest.config]
     * field.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig default_recognition_config = 6;</code>
     *
     * @return Whether the defaultRecognitionConfig field is set.
     */
    public boolean hasDefaultRecognitionConfig() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Default configuration to use for requests with this Recognizer.
     * This can be overwritten by inline configuration in the
     * [RecognizeRequest.config][google.cloud.speech.v2.RecognizeRequest.config]
     * field.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig default_recognition_config = 6;</code>
     *
     * @return The defaultRecognitionConfig.
     */
    public com.google.cloud.speech.v2.RecognitionConfig getDefaultRecognitionConfig() {
      if (defaultRecognitionConfigBuilder_ == null) {
        return defaultRecognitionConfig_ == null
            ? com.google.cloud.speech.v2.RecognitionConfig.getDefaultInstance()
            : defaultRecognitionConfig_;
      } else {
        return defaultRecognitionConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Default configuration to use for requests with this Recognizer.
     * This can be overwritten by inline configuration in the
     * [RecognizeRequest.config][google.cloud.speech.v2.RecognizeRequest.config]
     * field.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig default_recognition_config = 6;</code>
     */
    public Builder setDefaultRecognitionConfig(com.google.cloud.speech.v2.RecognitionConfig value) {
      if (defaultRecognitionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        defaultRecognitionConfig_ = value;
      } else {
        defaultRecognitionConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default configuration to use for requests with this Recognizer.
     * This can be overwritten by inline configuration in the
     * [RecognizeRequest.config][google.cloud.speech.v2.RecognizeRequest.config]
     * field.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig default_recognition_config = 6;</code>
     */
    public Builder setDefaultRecognitionConfig(
        com.google.cloud.speech.v2.RecognitionConfig.Builder builderForValue) {
      if (defaultRecognitionConfigBuilder_ == null) {
        defaultRecognitionConfig_ = builderForValue.build();
      } else {
        defaultRecognitionConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default configuration to use for requests with this Recognizer.
     * This can be overwritten by inline configuration in the
     * [RecognizeRequest.config][google.cloud.speech.v2.RecognizeRequest.config]
     * field.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig default_recognition_config = 6;</code>
     */
    public Builder mergeDefaultRecognitionConfig(
        com.google.cloud.speech.v2.RecognitionConfig value) {
      if (defaultRecognitionConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && defaultRecognitionConfig_ != null
            && defaultRecognitionConfig_
                != com.google.cloud.speech.v2.RecognitionConfig.getDefaultInstance()) {
          getDefaultRecognitionConfigBuilder().mergeFrom(value);
        } else {
          defaultRecognitionConfig_ = value;
        }
      } else {
        defaultRecognitionConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default configuration to use for requests with this Recognizer.
     * This can be overwritten by inline configuration in the
     * [RecognizeRequest.config][google.cloud.speech.v2.RecognizeRequest.config]
     * field.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig default_recognition_config = 6;</code>
     */
    public Builder clearDefaultRecognitionConfig() {
      bitField0_ = (bitField0_ & ~0x00000020);
      defaultRecognitionConfig_ = null;
      if (defaultRecognitionConfigBuilder_ != null) {
        defaultRecognitionConfigBuilder_.dispose();
        defaultRecognitionConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default configuration to use for requests with this Recognizer.
     * This can be overwritten by inline configuration in the
     * [RecognizeRequest.config][google.cloud.speech.v2.RecognizeRequest.config]
     * field.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig default_recognition_config = 6;</code>
     */
    public com.google.cloud.speech.v2.RecognitionConfig.Builder
        getDefaultRecognitionConfigBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getDefaultRecognitionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Default configuration to use for requests with this Recognizer.
     * This can be overwritten by inline configuration in the
     * [RecognizeRequest.config][google.cloud.speech.v2.RecognizeRequest.config]
     * field.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig default_recognition_config = 6;</code>
     */
    public com.google.cloud.speech.v2.RecognitionConfigOrBuilder
        getDefaultRecognitionConfigOrBuilder() {
      if (defaultRecognitionConfigBuilder_ != null) {
        return defaultRecognitionConfigBuilder_.getMessageOrBuilder();
      } else {
        return defaultRecognitionConfig_ == null
            ? com.google.cloud.speech.v2.RecognitionConfig.getDefaultInstance()
            : defaultRecognitionConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Default configuration to use for requests with this Recognizer.
     * This can be overwritten by inline configuration in the
     * [RecognizeRequest.config][google.cloud.speech.v2.RecognizeRequest.config]
     * field.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig default_recognition_config = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.RecognitionConfig,
            com.google.cloud.speech.v2.RecognitionConfig.Builder,
            com.google.cloud.speech.v2.RecognitionConfigOrBuilder>
        getDefaultRecognitionConfigFieldBuilder() {
      if (defaultRecognitionConfigBuilder_ == null) {
        defaultRecognitionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v2.RecognitionConfig,
                com.google.cloud.speech.v2.RecognitionConfig.Builder,
                com.google.cloud.speech.v2.RecognitionConfigOrBuilder>(
                getDefaultRecognitionConfig(), getParentForChildren(), isClean());
        defaultRecognitionConfig_ = null;
      }
      return defaultRecognitionConfigBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetAnnotations() {
      if (annotations_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AnnotationsDefaultEntryHolder.defaultEntry);
      }
      return annotations_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableAnnotations() {
      if (annotations_ == null) {
        annotations_ =
            com.google.protobuf.MapField.newMapField(AnnotationsDefaultEntryHolder.defaultEntry);
      }
      if (!annotations_.isMutable()) {
        annotations_ = annotations_.copy();
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return annotations_;
    }

    public int getAnnotationsCount() {
      return internalGetAnnotations().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Allows users to store small amounts of arbitrary data.
     * Both the key and the value must be 63 characters or less each.
     * At most 100 annotations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 7;</code>
     */
    @java.lang.Override
    public boolean containsAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAnnotations().getMap().containsKey(key);
    }
    /** Use {@link #getAnnotationsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
      return getAnnotationsMap();
    }
    /**
     *
     *
     * <pre>
     * Allows users to store small amounts of arbitrary data.
     * Both the key and the value must be 63 characters or less each.
     * At most 100 annotations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 7;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
      return internalGetAnnotations().getMap();
    }
    /**
     *
     *
     * <pre>
     * Allows users to store small amounts of arbitrary data.
     * Both the key and the value must be 63 characters or less each.
     * At most 100 annotations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 7;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getAnnotationsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Allows users to store small amounts of arbitrary data.
     * Both the key and the value must be 63 characters or less each.
     * At most 100 annotations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 7;</code>
     */
    @java.lang.Override
    public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearAnnotations() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableAnnotations().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allows users to store small amounts of arbitrary data.
     * Both the key and the value must be 63 characters or less each.
     * At most 100 annotations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 7;</code>
     */
    public Builder removeAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAnnotations().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableAnnotations() {
      bitField0_ |= 0x00000040;
      return internalGetMutableAnnotations().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Allows users to store small amounts of arbitrary data.
     * Both the key and the value must be 63 characters or less each.
     * At most 100 annotations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 7;</code>
     */
    public Builder putAnnotations(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAnnotations().getMutableMap().put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allows users to store small amounts of arbitrary data.
     * Both the key and the value must be 63 characters or less each.
     * At most 100 annotations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 7;</code>
     */
    public Builder putAllAnnotations(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableAnnotations().getMutableMap().putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The Recognizer lifecycle state.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.Recognizer.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Recognizer lifecycle state.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.Recognizer.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Recognizer lifecycle state.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.Recognizer.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.Recognizer.State getState() {
      com.google.cloud.speech.v2.Recognizer.State result =
          com.google.cloud.speech.v2.Recognizer.State.forNumber(state_);
      return result == null ? com.google.cloud.speech.v2.Recognizer.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Recognizer lifecycle state.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.Recognizer.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.speech.v2.Recognizer.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Recognizer lifecycle state.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.Recognizer.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000080);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The most recent time this Recognizer was modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time this Recognizer was modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time this Recognizer was modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time this Recognizer was modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time this Recognizer was modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time this Recognizer was modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000200);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time this Recognizer was modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time this Recognizer was modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time this Recognizer was modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.Timestamp deleteTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        deleteTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which this Recognizer was requested for deletion.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the deleteTime field is set.
     */
    public boolean hasDeleteTime() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this Recognizer was requested for deletion.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The deleteTime.
     */
    public com.google.protobuf.Timestamp getDeleteTime() {
      if (deleteTimeBuilder_ == null) {
        return deleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deleteTime_;
      } else {
        return deleteTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this Recognizer was requested for deletion.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeleteTime(com.google.protobuf.Timestamp value) {
      if (deleteTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deleteTime_ = value;
      } else {
        deleteTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this Recognizer was requested for deletion.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeleteTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (deleteTimeBuilder_ == null) {
        deleteTime_ = builderForValue.build();
      } else {
        deleteTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this Recognizer was requested for deletion.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDeleteTime(com.google.protobuf.Timestamp value) {
      if (deleteTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && deleteTime_ != null
            && deleteTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getDeleteTimeBuilder().mergeFrom(value);
        } else {
          deleteTime_ = value;
        }
      } else {
        deleteTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this Recognizer was requested for deletion.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDeleteTime() {
      bitField0_ = (bitField0_ & ~0x00000400);
      deleteTime_ = null;
      if (deleteTimeBuilder_ != null) {
        deleteTimeBuilder_.dispose();
        deleteTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this Recognizer was requested for deletion.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getDeleteTimeBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getDeleteTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this Recognizer was requested for deletion.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
      if (deleteTimeBuilder_ != null) {
        return deleteTimeBuilder_.getMessageOrBuilder();
      } else {
        return deleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deleteTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this Recognizer was requested for deletion.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getDeleteTimeFieldBuilder() {
      if (deleteTimeBuilder_ == null) {
        deleteTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getDeleteTime(), getParentForChildren(), isClean());
        deleteTime_ = null;
      }
      return deleteTimeBuilder_;
    }

    private com.google.protobuf.Timestamp expireTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        expireTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which this Recognizer will be purged.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the expireTime field is set.
     */
    public boolean hasExpireTime() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this Recognizer will be purged.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The expireTime.
     */
    public com.google.protobuf.Timestamp getExpireTime() {
      if (expireTimeBuilder_ == null) {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      } else {
        return expireTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this Recognizer will be purged.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expireTime_ = value;
      } else {
        expireTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this Recognizer will be purged.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (expireTimeBuilder_ == null) {
        expireTime_ = builderForValue.build();
      } else {
        expireTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this Recognizer will be purged.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && expireTime_ != null
            && expireTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getExpireTimeBuilder().mergeFrom(value);
        } else {
          expireTime_ = value;
        }
      } else {
        expireTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this Recognizer will be purged.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearExpireTime() {
      bitField0_ = (bitField0_ & ~0x00000800);
      expireTime_ = null;
      if (expireTimeBuilder_ != null) {
        expireTimeBuilder_.dispose();
        expireTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this Recognizer will be purged.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getExpireTimeBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getExpireTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this Recognizer will be purged.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
      if (expireTimeBuilder_ != null) {
        return expireTimeBuilder_.getMessageOrBuilder();
      } else {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this Recognizer will be purged.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getExpireTimeFieldBuilder() {
      if (expireTimeBuilder_ == null) {
        expireTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getExpireTime(), getParentForChildren(), isClean());
        expireTime_ = null;
      }
      return expireTimeBuilder_;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Output only. This checksum is computed by the server based on the value of
     * other fields. This may be sent on update, undelete, and delete requests to
     * ensure the client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. This checksum is computed by the server based on the value of
     * other fields. This may be sent on update, undelete, and delete requests to
     * ensure the client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. This checksum is computed by the server based on the value of
     * other fields. This may be sent on update, undelete, and delete requests to
     * ensure the client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This checksum is computed by the server based on the value of
     * other fields. This may be sent on update, undelete, and delete requests to
     * ensure the client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This checksum is computed by the server based on the value of
     * other fields. This may be sent on update, undelete, and delete requests to
     * ensure the client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private boolean reconciling_;
    /**
     *
     *
     * <pre>
     * Output only. Whether or not this Recognizer is in the process of being
     * updated.
     * </pre>
     *
     * <code>bool reconciling = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The reconciling.
     */
    @java.lang.Override
    public boolean getReconciling() {
      return reconciling_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Whether or not this Recognizer is in the process of being
     * updated.
     * </pre>
     *
     * <code>bool reconciling = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The reconciling to set.
     * @return This builder for chaining.
     */
    public Builder setReconciling(boolean value) {

      reconciling_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Whether or not this Recognizer is in the process of being
     * updated.
     * </pre>
     *
     * <code>bool reconciling = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReconciling() {
      bitField0_ = (bitField0_ & ~0x00002000);
      reconciling_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object kmsKeyName_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The [KMS key
     * name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) with which
     * the Recognizer is encrypted. The expected format is
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     * </pre>
     *
     * <code>
     * string kms_key_name = 15 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The kmsKeyName.
     */
    public java.lang.String getKmsKeyName() {
      java.lang.Object ref = kmsKeyName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKeyName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The [KMS key
     * name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) with which
     * the Recognizer is encrypted. The expected format is
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     * </pre>
     *
     * <code>
     * string kms_key_name = 15 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for kmsKeyName.
     */
    public com.google.protobuf.ByteString getKmsKeyNameBytes() {
      java.lang.Object ref = kmsKeyName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKeyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The [KMS key
     * name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) with which
     * the Recognizer is encrypted. The expected format is
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     * </pre>
     *
     * <code>
     * string kms_key_name = 15 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The kmsKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kmsKeyName_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The [KMS key
     * name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) with which
     * the Recognizer is encrypted. The expected format is
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     * </pre>
     *
     * <code>
     * string kms_key_name = 15 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKmsKeyName() {
      kmsKeyName_ = getDefaultInstance().getKmsKeyName();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The [KMS key
     * name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) with which
     * the Recognizer is encrypted. The expected format is
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     * </pre>
     *
     * <code>
     * string kms_key_name = 15 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for kmsKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kmsKeyName_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private java.lang.Object kmsKeyVersionName_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The [KMS key version
     * name](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions)
     * with which the Recognizer is encrypted. The expected format is
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`.
     * </pre>
     *
     * <code>
     * string kms_key_version_name = 16 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The kmsKeyVersionName.
     */
    public java.lang.String getKmsKeyVersionName() {
      java.lang.Object ref = kmsKeyVersionName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKeyVersionName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The [KMS key version
     * name](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions)
     * with which the Recognizer is encrypted. The expected format is
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`.
     * </pre>
     *
     * <code>
     * string kms_key_version_name = 16 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for kmsKeyVersionName.
     */
    public com.google.protobuf.ByteString getKmsKeyVersionNameBytes() {
      java.lang.Object ref = kmsKeyVersionName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKeyVersionName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The [KMS key version
     * name](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions)
     * with which the Recognizer is encrypted. The expected format is
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`.
     * </pre>
     *
     * <code>
     * string kms_key_version_name = 16 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The kmsKeyVersionName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyVersionName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kmsKeyVersionName_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The [KMS key version
     * name](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions)
     * with which the Recognizer is encrypted. The expected format is
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`.
     * </pre>
     *
     * <code>
     * string kms_key_version_name = 16 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKmsKeyVersionName() {
      kmsKeyVersionName_ = getDefaultInstance().getKmsKeyVersionName();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The [KMS key version
     * name](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions)
     * with which the Recognizer is encrypted. The expected format is
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`.
     * </pre>
     *
     * <code>
     * string kms_key_version_name = 16 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for kmsKeyVersionName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyVersionNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kmsKeyVersionName_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.speech.v2.Recognizer)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.speech.v2.Recognizer)
  private static final com.google.cloud.speech.v2.Recognizer DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.speech.v2.Recognizer();
  }

  public static com.google.cloud.speech.v2.Recognizer getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Recognizer> PARSER =
      new com.google.protobuf.AbstractParser<Recognizer>() {
        @java.lang.Override
        public Recognizer parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Recognizer> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Recognizer> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.speech.v2.Recognizer getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
