/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/speech/v2/cloud_speech.proto

package com.google.cloud.speech.v2;

/**
 *
 *
 * <pre>
 * Request message for the
 * [StreamingRecognize][google.cloud.speech.v2.Speech.StreamingRecognize]
 * method. Multiple
 * [StreamingRecognizeRequest][google.cloud.speech.v2.StreamingRecognizeRequest]
 * messages are sent in one call.
 *
 * If the [Recognizer][google.cloud.speech.v2.Recognizer] referenced by
 * [recognizer][google.cloud.speech.v2.StreamingRecognizeRequest.recognizer]
 * contains a fully specified request configuration then the stream may only
 * contain messages with only
 * [audio][google.cloud.speech.v2.StreamingRecognizeRequest.audio] set.
 *
 * Otherwise the first message must contain a
 * [recognizer][google.cloud.speech.v2.StreamingRecognizeRequest.recognizer] and
 * a
 * [streaming_config][google.cloud.speech.v2.StreamingRecognizeRequest.streaming_config]
 * message that together fully specify the request configuration and must not
 * contain [audio][google.cloud.speech.v2.StreamingRecognizeRequest.audio]. All
 * subsequent messages must only have
 * [audio][google.cloud.speech.v2.StreamingRecognizeRequest.audio] set.
 * </pre>
 *
 * Protobuf type {@code google.cloud.speech.v2.StreamingRecognizeRequest}
 */
public final class StreamingRecognizeRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.speech.v2.StreamingRecognizeRequest)
    StreamingRecognizeRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StreamingRecognizeRequest.newBuilder() to construct.
  private StreamingRecognizeRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StreamingRecognizeRequest() {
    recognizer_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StreamingRecognizeRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.speech.v2.CloudSpeechProto
        .internal_static_google_cloud_speech_v2_StreamingRecognizeRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.speech.v2.CloudSpeechProto
        .internal_static_google_cloud_speech_v2_StreamingRecognizeRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.speech.v2.StreamingRecognizeRequest.class,
            com.google.cloud.speech.v2.StreamingRecognizeRequest.Builder.class);
  }

  private int streamingRequestCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object streamingRequest_;

  public enum StreamingRequestCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    STREAMING_CONFIG(6),
    AUDIO(5),
    STREAMINGREQUEST_NOT_SET(0);
    private final int value;

    private StreamingRequestCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static StreamingRequestCase valueOf(int value) {
      return forNumber(value);
    }

    public static StreamingRequestCase forNumber(int value) {
      switch (value) {
        case 6:
          return STREAMING_CONFIG;
        case 5:
          return AUDIO;
        case 0:
          return STREAMINGREQUEST_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public StreamingRequestCase getStreamingRequestCase() {
    return StreamingRequestCase.forNumber(streamingRequestCase_);
  }

  public static final int RECOGNIZER_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object recognizer_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the Recognizer to use during recognition. The
   * expected format is
   * `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
   * {recognizer} segment may be set to `_` to use an empty implicit Recognizer.
   * </pre>
   *
   * <code>
   * string recognizer = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The recognizer.
   */
  @java.lang.Override
  public java.lang.String getRecognizer() {
    java.lang.Object ref = recognizer_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      recognizer_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the Recognizer to use during recognition. The
   * expected format is
   * `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
   * {recognizer} segment may be set to `_` to use an empty implicit Recognizer.
   * </pre>
   *
   * <code>
   * string recognizer = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for recognizer.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRecognizerBytes() {
    java.lang.Object ref = recognizer_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      recognizer_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STREAMING_CONFIG_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * StreamingRecognitionConfig to be used in this recognition attempt.
   * If provided, it will override the default RecognitionConfig stored in the
   * Recognizer.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.StreamingRecognitionConfig streaming_config = 6;</code>
   *
   * @return Whether the streamingConfig field is set.
   */
  @java.lang.Override
  public boolean hasStreamingConfig() {
    return streamingRequestCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * StreamingRecognitionConfig to be used in this recognition attempt.
   * If provided, it will override the default RecognitionConfig stored in the
   * Recognizer.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.StreamingRecognitionConfig streaming_config = 6;</code>
   *
   * @return The streamingConfig.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.StreamingRecognitionConfig getStreamingConfig() {
    if (streamingRequestCase_ == 6) {
      return (com.google.cloud.speech.v2.StreamingRecognitionConfig) streamingRequest_;
    }
    return com.google.cloud.speech.v2.StreamingRecognitionConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * StreamingRecognitionConfig to be used in this recognition attempt.
   * If provided, it will override the default RecognitionConfig stored in the
   * Recognizer.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.StreamingRecognitionConfig streaming_config = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.StreamingRecognitionConfigOrBuilder
      getStreamingConfigOrBuilder() {
    if (streamingRequestCase_ == 6) {
      return (com.google.cloud.speech.v2.StreamingRecognitionConfig) streamingRequest_;
    }
    return com.google.cloud.speech.v2.StreamingRecognitionConfig.getDefaultInstance();
  }

  public static final int AUDIO_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Inline audio bytes to be Recognized.
   * Maximum size for this field is 15 KB per request.
   * </pre>
   *
   * <code>bytes audio = 5;</code>
   *
   * @return Whether the audio field is set.
   */
  @java.lang.Override
  public boolean hasAudio() {
    return streamingRequestCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Inline audio bytes to be Recognized.
   * Maximum size for this field is 15 KB per request.
   * </pre>
   *
   * <code>bytes audio = 5;</code>
   *
   * @return The audio.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAudio() {
    if (streamingRequestCase_ == 5) {
      return (com.google.protobuf.ByteString) streamingRequest_;
    }
    return com.google.protobuf.ByteString.EMPTY;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(recognizer_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, recognizer_);
    }
    if (streamingRequestCase_ == 5) {
      output.writeBytes(5, (com.google.protobuf.ByteString) streamingRequest_);
    }
    if (streamingRequestCase_ == 6) {
      output.writeMessage(
          6, (com.google.cloud.speech.v2.StreamingRecognitionConfig) streamingRequest_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(recognizer_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, recognizer_);
    }
    if (streamingRequestCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBytesSize(
              5, (com.google.protobuf.ByteString) streamingRequest_);
    }
    if (streamingRequestCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.speech.v2.StreamingRecognitionConfig) streamingRequest_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.speech.v2.StreamingRecognizeRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.speech.v2.StreamingRecognizeRequest other =
        (com.google.cloud.speech.v2.StreamingRecognizeRequest) obj;

    if (!getRecognizer().equals(other.getRecognizer())) return false;
    if (!getStreamingRequestCase().equals(other.getStreamingRequestCase())) return false;
    switch (streamingRequestCase_) {
      case 6:
        if (!getStreamingConfig().equals(other.getStreamingConfig())) return false;
        break;
      case 5:
        if (!getAudio().equals(other.getAudio())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RECOGNIZER_FIELD_NUMBER;
    hash = (53 * hash) + getRecognizer().hashCode();
    switch (streamingRequestCase_) {
      case 6:
        hash = (37 * hash) + STREAMING_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getStreamingConfig().hashCode();
        break;
      case 5:
        hash = (37 * hash) + AUDIO_FIELD_NUMBER;
        hash = (53 * hash) + getAudio().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.speech.v2.StreamingRecognizeRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.StreamingRecognizeRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.StreamingRecognizeRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.StreamingRecognizeRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.StreamingRecognizeRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.StreamingRecognizeRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.StreamingRecognizeRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.StreamingRecognizeRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.StreamingRecognizeRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.StreamingRecognizeRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.StreamingRecognizeRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.StreamingRecognizeRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.speech.v2.StreamingRecognizeRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for the
   * [StreamingRecognize][google.cloud.speech.v2.Speech.StreamingRecognize]
   * method. Multiple
   * [StreamingRecognizeRequest][google.cloud.speech.v2.StreamingRecognizeRequest]
   * messages are sent in one call.
   *
   * If the [Recognizer][google.cloud.speech.v2.Recognizer] referenced by
   * [recognizer][google.cloud.speech.v2.StreamingRecognizeRequest.recognizer]
   * contains a fully specified request configuration then the stream may only
   * contain messages with only
   * [audio][google.cloud.speech.v2.StreamingRecognizeRequest.audio] set.
   *
   * Otherwise the first message must contain a
   * [recognizer][google.cloud.speech.v2.StreamingRecognizeRequest.recognizer] and
   * a
   * [streaming_config][google.cloud.speech.v2.StreamingRecognizeRequest.streaming_config]
   * message that together fully specify the request configuration and must not
   * contain [audio][google.cloud.speech.v2.StreamingRecognizeRequest.audio]. All
   * subsequent messages must only have
   * [audio][google.cloud.speech.v2.StreamingRecognizeRequest.audio] set.
   * </pre>
   *
   * Protobuf type {@code google.cloud.speech.v2.StreamingRecognizeRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.speech.v2.StreamingRecognizeRequest)
      com.google.cloud.speech.v2.StreamingRecognizeRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_StreamingRecognizeRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_StreamingRecognizeRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.speech.v2.StreamingRecognizeRequest.class,
              com.google.cloud.speech.v2.StreamingRecognizeRequest.Builder.class);
    }

    // Construct using com.google.cloud.speech.v2.StreamingRecognizeRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      recognizer_ = "";
      if (streamingConfigBuilder_ != null) {
        streamingConfigBuilder_.clear();
      }
      streamingRequestCase_ = 0;
      streamingRequest_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_StreamingRecognizeRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.StreamingRecognizeRequest getDefaultInstanceForType() {
      return com.google.cloud.speech.v2.StreamingRecognizeRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.StreamingRecognizeRequest build() {
      com.google.cloud.speech.v2.StreamingRecognizeRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.StreamingRecognizeRequest buildPartial() {
      com.google.cloud.speech.v2.StreamingRecognizeRequest result =
          new com.google.cloud.speech.v2.StreamingRecognizeRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.speech.v2.StreamingRecognizeRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.recognizer_ = recognizer_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.speech.v2.StreamingRecognizeRequest result) {
      result.streamingRequestCase_ = streamingRequestCase_;
      result.streamingRequest_ = this.streamingRequest_;
      if (streamingRequestCase_ == 6 && streamingConfigBuilder_ != null) {
        result.streamingRequest_ = streamingConfigBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.speech.v2.StreamingRecognizeRequest) {
        return mergeFrom((com.google.cloud.speech.v2.StreamingRecognizeRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.speech.v2.StreamingRecognizeRequest other) {
      if (other == com.google.cloud.speech.v2.StreamingRecognizeRequest.getDefaultInstance())
        return this;
      if (!other.getRecognizer().isEmpty()) {
        recognizer_ = other.recognizer_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      switch (other.getStreamingRequestCase()) {
        case STREAMING_CONFIG:
          {
            mergeStreamingConfig(other.getStreamingConfig());
            break;
          }
        case AUDIO:
          {
            setAudio(other.getAudio());
            break;
          }
        case STREAMINGREQUEST_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26:
              {
                recognizer_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 26
            case 42:
              {
                streamingRequest_ = input.readBytes();
                streamingRequestCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getStreamingConfigFieldBuilder().getBuilder(), extensionRegistry);
                streamingRequestCase_ = 6;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int streamingRequestCase_ = 0;
    private java.lang.Object streamingRequest_;

    public StreamingRequestCase getStreamingRequestCase() {
      return StreamingRequestCase.forNumber(streamingRequestCase_);
    }

    public Builder clearStreamingRequest() {
      streamingRequestCase_ = 0;
      streamingRequest_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object recognizer_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the Recognizer to use during recognition. The
     * expected format is
     * `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
     * {recognizer} segment may be set to `_` to use an empty implicit Recognizer.
     * </pre>
     *
     * <code>
     * string recognizer = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The recognizer.
     */
    public java.lang.String getRecognizer() {
      java.lang.Object ref = recognizer_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        recognizer_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Recognizer to use during recognition. The
     * expected format is
     * `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
     * {recognizer} segment may be set to `_` to use an empty implicit Recognizer.
     * </pre>
     *
     * <code>
     * string recognizer = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for recognizer.
     */
    public com.google.protobuf.ByteString getRecognizerBytes() {
      java.lang.Object ref = recognizer_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        recognizer_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Recognizer to use during recognition. The
     * expected format is
     * `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
     * {recognizer} segment may be set to `_` to use an empty implicit Recognizer.
     * </pre>
     *
     * <code>
     * string recognizer = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The recognizer to set.
     * @return This builder for chaining.
     */
    public Builder setRecognizer(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      recognizer_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Recognizer to use during recognition. The
     * expected format is
     * `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
     * {recognizer} segment may be set to `_` to use an empty implicit Recognizer.
     * </pre>
     *
     * <code>
     * string recognizer = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRecognizer() {
      recognizer_ = getDefaultInstance().getRecognizer();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Recognizer to use during recognition. The
     * expected format is
     * `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
     * {recognizer} segment may be set to `_` to use an empty implicit Recognizer.
     * </pre>
     *
     * <code>
     * string recognizer = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for recognizer to set.
     * @return This builder for chaining.
     */
    public Builder setRecognizerBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      recognizer_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.StreamingRecognitionConfig,
            com.google.cloud.speech.v2.StreamingRecognitionConfig.Builder,
            com.google.cloud.speech.v2.StreamingRecognitionConfigOrBuilder>
        streamingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * StreamingRecognitionConfig to be used in this recognition attempt.
     * If provided, it will override the default RecognitionConfig stored in the
     * Recognizer.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.StreamingRecognitionConfig streaming_config = 6;</code>
     *
     * @return Whether the streamingConfig field is set.
     */
    @java.lang.Override
    public boolean hasStreamingConfig() {
      return streamingRequestCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * StreamingRecognitionConfig to be used in this recognition attempt.
     * If provided, it will override the default RecognitionConfig stored in the
     * Recognizer.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.StreamingRecognitionConfig streaming_config = 6;</code>
     *
     * @return The streamingConfig.
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.StreamingRecognitionConfig getStreamingConfig() {
      if (streamingConfigBuilder_ == null) {
        if (streamingRequestCase_ == 6) {
          return (com.google.cloud.speech.v2.StreamingRecognitionConfig) streamingRequest_;
        }
        return com.google.cloud.speech.v2.StreamingRecognitionConfig.getDefaultInstance();
      } else {
        if (streamingRequestCase_ == 6) {
          return streamingConfigBuilder_.getMessage();
        }
        return com.google.cloud.speech.v2.StreamingRecognitionConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * StreamingRecognitionConfig to be used in this recognition attempt.
     * If provided, it will override the default RecognitionConfig stored in the
     * Recognizer.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.StreamingRecognitionConfig streaming_config = 6;</code>
     */
    public Builder setStreamingConfig(com.google.cloud.speech.v2.StreamingRecognitionConfig value) {
      if (streamingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        streamingRequest_ = value;
        onChanged();
      } else {
        streamingConfigBuilder_.setMessage(value);
      }
      streamingRequestCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * StreamingRecognitionConfig to be used in this recognition attempt.
     * If provided, it will override the default RecognitionConfig stored in the
     * Recognizer.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.StreamingRecognitionConfig streaming_config = 6;</code>
     */
    public Builder setStreamingConfig(
        com.google.cloud.speech.v2.StreamingRecognitionConfig.Builder builderForValue) {
      if (streamingConfigBuilder_ == null) {
        streamingRequest_ = builderForValue.build();
        onChanged();
      } else {
        streamingConfigBuilder_.setMessage(builderForValue.build());
      }
      streamingRequestCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * StreamingRecognitionConfig to be used in this recognition attempt.
     * If provided, it will override the default RecognitionConfig stored in the
     * Recognizer.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.StreamingRecognitionConfig streaming_config = 6;</code>
     */
    public Builder mergeStreamingConfig(
        com.google.cloud.speech.v2.StreamingRecognitionConfig value) {
      if (streamingConfigBuilder_ == null) {
        if (streamingRequestCase_ == 6
            && streamingRequest_
                != com.google.cloud.speech.v2.StreamingRecognitionConfig.getDefaultInstance()) {
          streamingRequest_ =
              com.google.cloud.speech.v2.StreamingRecognitionConfig.newBuilder(
                      (com.google.cloud.speech.v2.StreamingRecognitionConfig) streamingRequest_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          streamingRequest_ = value;
        }
        onChanged();
      } else {
        if (streamingRequestCase_ == 6) {
          streamingConfigBuilder_.mergeFrom(value);
        } else {
          streamingConfigBuilder_.setMessage(value);
        }
      }
      streamingRequestCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * StreamingRecognitionConfig to be used in this recognition attempt.
     * If provided, it will override the default RecognitionConfig stored in the
     * Recognizer.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.StreamingRecognitionConfig streaming_config = 6;</code>
     */
    public Builder clearStreamingConfig() {
      if (streamingConfigBuilder_ == null) {
        if (streamingRequestCase_ == 6) {
          streamingRequestCase_ = 0;
          streamingRequest_ = null;
          onChanged();
        }
      } else {
        if (streamingRequestCase_ == 6) {
          streamingRequestCase_ = 0;
          streamingRequest_ = null;
        }
        streamingConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * StreamingRecognitionConfig to be used in this recognition attempt.
     * If provided, it will override the default RecognitionConfig stored in the
     * Recognizer.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.StreamingRecognitionConfig streaming_config = 6;</code>
     */
    public com.google.cloud.speech.v2.StreamingRecognitionConfig.Builder
        getStreamingConfigBuilder() {
      return getStreamingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * StreamingRecognitionConfig to be used in this recognition attempt.
     * If provided, it will override the default RecognitionConfig stored in the
     * Recognizer.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.StreamingRecognitionConfig streaming_config = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.StreamingRecognitionConfigOrBuilder
        getStreamingConfigOrBuilder() {
      if ((streamingRequestCase_ == 6) && (streamingConfigBuilder_ != null)) {
        return streamingConfigBuilder_.getMessageOrBuilder();
      } else {
        if (streamingRequestCase_ == 6) {
          return (com.google.cloud.speech.v2.StreamingRecognitionConfig) streamingRequest_;
        }
        return com.google.cloud.speech.v2.StreamingRecognitionConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * StreamingRecognitionConfig to be used in this recognition attempt.
     * If provided, it will override the default RecognitionConfig stored in the
     * Recognizer.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.StreamingRecognitionConfig streaming_config = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.StreamingRecognitionConfig,
            com.google.cloud.speech.v2.StreamingRecognitionConfig.Builder,
            com.google.cloud.speech.v2.StreamingRecognitionConfigOrBuilder>
        getStreamingConfigFieldBuilder() {
      if (streamingConfigBuilder_ == null) {
        if (!(streamingRequestCase_ == 6)) {
          streamingRequest_ =
              com.google.cloud.speech.v2.StreamingRecognitionConfig.getDefaultInstance();
        }
        streamingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v2.StreamingRecognitionConfig,
                com.google.cloud.speech.v2.StreamingRecognitionConfig.Builder,
                com.google.cloud.speech.v2.StreamingRecognitionConfigOrBuilder>(
                (com.google.cloud.speech.v2.StreamingRecognitionConfig) streamingRequest_,
                getParentForChildren(),
                isClean());
        streamingRequest_ = null;
      }
      streamingRequestCase_ = 6;
      onChanged();
      return streamingConfigBuilder_;
    }

    /**
     *
     *
     * <pre>
     * Inline audio bytes to be Recognized.
     * Maximum size for this field is 15 KB per request.
     * </pre>
     *
     * <code>bytes audio = 5;</code>
     *
     * @return Whether the audio field is set.
     */
    public boolean hasAudio() {
      return streamingRequestCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Inline audio bytes to be Recognized.
     * Maximum size for this field is 15 KB per request.
     * </pre>
     *
     * <code>bytes audio = 5;</code>
     *
     * @return The audio.
     */
    public com.google.protobuf.ByteString getAudio() {
      if (streamingRequestCase_ == 5) {
        return (com.google.protobuf.ByteString) streamingRequest_;
      }
      return com.google.protobuf.ByteString.EMPTY;
    }
    /**
     *
     *
     * <pre>
     * Inline audio bytes to be Recognized.
     * Maximum size for this field is 15 KB per request.
     * </pre>
     *
     * <code>bytes audio = 5;</code>
     *
     * @param value The audio to set.
     * @return This builder for chaining.
     */
    public Builder setAudio(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      streamingRequestCase_ = 5;
      streamingRequest_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Inline audio bytes to be Recognized.
     * Maximum size for this field is 15 KB per request.
     * </pre>
     *
     * <code>bytes audio = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAudio() {
      if (streamingRequestCase_ == 5) {
        streamingRequestCase_ = 0;
        streamingRequest_ = null;
        onChanged();
      }
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.speech.v2.StreamingRecognizeRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.speech.v2.StreamingRecognizeRequest)
  private static final com.google.cloud.speech.v2.StreamingRecognizeRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.speech.v2.StreamingRecognizeRequest();
  }

  public static com.google.cloud.speech.v2.StreamingRecognizeRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StreamingRecognizeRequest> PARSER =
      new com.google.protobuf.AbstractParser<StreamingRecognizeRequest>() {
        @java.lang.Override
        public StreamingRecognizeRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StreamingRecognizeRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StreamingRecognizeRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.speech.v2.StreamingRecognizeRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
