/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/speech/v2/cloud_speech.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.speech.v2;

/**
 *
 *
 * <pre>
 * Metadata about a single file in a batch for BatchRecognize.
 * </pre>
 *
 * Protobuf type {@code google.cloud.speech.v2.BatchRecognizeFileMetadata}
 */
public final class BatchRecognizeFileMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.speech.v2.BatchRecognizeFileMetadata)
    BatchRecognizeFileMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BatchRecognizeFileMetadata.newBuilder() to construct.
  private BatchRecognizeFileMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchRecognizeFileMetadata() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchRecognizeFileMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.speech.v2.CloudSpeechProto
        .internal_static_google_cloud_speech_v2_BatchRecognizeFileMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.speech.v2.CloudSpeechProto
        .internal_static_google_cloud_speech_v2_BatchRecognizeFileMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.speech.v2.BatchRecognizeFileMetadata.class,
            com.google.cloud.speech.v2.BatchRecognizeFileMetadata.Builder.class);
  }

  private int bitField0_;
  private int audioSourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object audioSource_;

  public enum AudioSourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    URI(1),
    AUDIOSOURCE_NOT_SET(0);
    private final int value;

    private AudioSourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AudioSourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static AudioSourceCase forNumber(int value) {
      switch (value) {
        case 1:
          return URI;
        case 0:
          return AUDIOSOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public AudioSourceCase getAudioSourceCase() {
    return AudioSourceCase.forNumber(audioSourceCase_);
  }

  public static final int URI_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Cloud Storage URI for the audio file.
   * </pre>
   *
   * <code>string uri = 1;</code>
   *
   * @return Whether the uri field is set.
   */
  public boolean hasUri() {
    return audioSourceCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Cloud Storage URI for the audio file.
   * </pre>
   *
   * <code>string uri = 1;</code>
   *
   * @return The uri.
   */
  public java.lang.String getUri() {
    java.lang.Object ref = "";
    if (audioSourceCase_ == 1) {
      ref = audioSource_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (audioSourceCase_ == 1) {
        audioSource_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Cloud Storage URI for the audio file.
   * </pre>
   *
   * <code>string uri = 1;</code>
   *
   * @return The bytes for uri.
   */
  public com.google.protobuf.ByteString getUriBytes() {
    java.lang.Object ref = "";
    if (audioSourceCase_ == 1) {
      ref = audioSource_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (audioSourceCase_ == 1) {
        audioSource_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.speech.v2.RecognitionConfig config_;
  /**
   *
   *
   * <pre>
   * Features and audio metadata to use for the Automatic Speech Recognition.
   * This field in combination with the
   * [config_mask][google.cloud.speech.v2.BatchRecognizeFileMetadata.config_mask]
   * field can be used to override parts of the
   * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
   * of the Recognizer resource as well as the
   * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] at the
   * request level.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.RecognitionConfig config = 4;</code>
   *
   * @return Whether the config field is set.
   */
  @java.lang.Override
  public boolean hasConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Features and audio metadata to use for the Automatic Speech Recognition.
   * This field in combination with the
   * [config_mask][google.cloud.speech.v2.BatchRecognizeFileMetadata.config_mask]
   * field can be used to override parts of the
   * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
   * of the Recognizer resource as well as the
   * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] at the
   * request level.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.RecognitionConfig config = 4;</code>
   *
   * @return The config.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.RecognitionConfig getConfig() {
    return config_ == null
        ? com.google.cloud.speech.v2.RecognitionConfig.getDefaultInstance()
        : config_;
  }
  /**
   *
   *
   * <pre>
   * Features and audio metadata to use for the Automatic Speech Recognition.
   * This field in combination with the
   * [config_mask][google.cloud.speech.v2.BatchRecognizeFileMetadata.config_mask]
   * field can be used to override parts of the
   * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
   * of the Recognizer resource as well as the
   * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] at the
   * request level.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.RecognitionConfig config = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.RecognitionConfigOrBuilder getConfigOrBuilder() {
    return config_ == null
        ? com.google.cloud.speech.v2.RecognitionConfig.getDefaultInstance()
        : config_;
  }

  public static final int CONFIG_MASK_FIELD_NUMBER = 5;
  private com.google.protobuf.FieldMask configMask_;
  /**
   *
   *
   * <pre>
   * The list of fields in
   * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config] that
   * override the values in the
   * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
   * of the recognizer during this recognition request. If no mask is provided,
   * all non-default valued fields in
   * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config] override
   * the values in the recognizer for this recognition request. If a mask is
   * provided, only the fields listed in the mask override the config in the
   * recognizer for this recognition request. If a wildcard (`*`) is provided,
   * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config]
   * completely overrides and replaces the config in the recognizer for this
   * recognition request.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask config_mask = 5;</code>
   *
   * @return Whether the configMask field is set.
   */
  @java.lang.Override
  public boolean hasConfigMask() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The list of fields in
   * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config] that
   * override the values in the
   * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
   * of the recognizer during this recognition request. If no mask is provided,
   * all non-default valued fields in
   * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config] override
   * the values in the recognizer for this recognition request. If a mask is
   * provided, only the fields listed in the mask override the config in the
   * recognizer for this recognition request. If a wildcard (`*`) is provided,
   * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config]
   * completely overrides and replaces the config in the recognizer for this
   * recognition request.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask config_mask = 5;</code>
   *
   * @return The configMask.
   */
  @java.lang.Override
  public com.google.protobuf.FieldMask getConfigMask() {
    return configMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : configMask_;
  }
  /**
   *
   *
   * <pre>
   * The list of fields in
   * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config] that
   * override the values in the
   * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
   * of the recognizer during this recognition request. If no mask is provided,
   * all non-default valued fields in
   * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config] override
   * the values in the recognizer for this recognition request. If a mask is
   * provided, only the fields listed in the mask override the config in the
   * recognizer for this recognition request. If a wildcard (`*`) is provided,
   * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config]
   * completely overrides and replaces the config in the recognizer for this
   * recognition request.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask config_mask = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.FieldMaskOrBuilder getConfigMaskOrBuilder() {
    return configMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : configMask_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (audioSourceCase_ == 1) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, audioSource_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getConfigMask());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (audioSourceCase_ == 1) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, audioSource_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getConfigMask());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.speech.v2.BatchRecognizeFileMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.speech.v2.BatchRecognizeFileMetadata other =
        (com.google.cloud.speech.v2.BatchRecognizeFileMetadata) obj;

    if (hasConfig() != other.hasConfig()) return false;
    if (hasConfig()) {
      if (!getConfig().equals(other.getConfig())) return false;
    }
    if (hasConfigMask() != other.hasConfigMask()) return false;
    if (hasConfigMask()) {
      if (!getConfigMask().equals(other.getConfigMask())) return false;
    }
    if (!getAudioSourceCase().equals(other.getAudioSourceCase())) return false;
    switch (audioSourceCase_) {
      case 1:
        if (!getUri().equals(other.getUri())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasConfig()) {
      hash = (37 * hash) + CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getConfig().hashCode();
    }
    if (hasConfigMask()) {
      hash = (37 * hash) + CONFIG_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getConfigMask().hashCode();
    }
    switch (audioSourceCase_) {
      case 1:
        hash = (37 * hash) + URI_FIELD_NUMBER;
        hash = (53 * hash) + getUri().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.speech.v2.BatchRecognizeFileMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeFileMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeFileMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeFileMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeFileMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeFileMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeFileMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeFileMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeFileMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeFileMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeFileMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeFileMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.speech.v2.BatchRecognizeFileMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata about a single file in a batch for BatchRecognize.
   * </pre>
   *
   * Protobuf type {@code google.cloud.speech.v2.BatchRecognizeFileMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.speech.v2.BatchRecognizeFileMetadata)
      com.google.cloud.speech.v2.BatchRecognizeFileMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_BatchRecognizeFileMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_BatchRecognizeFileMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.speech.v2.BatchRecognizeFileMetadata.class,
              com.google.cloud.speech.v2.BatchRecognizeFileMetadata.Builder.class);
    }

    // Construct using com.google.cloud.speech.v2.BatchRecognizeFileMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getConfigFieldBuilder();
        getConfigMaskFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      config_ = null;
      if (configBuilder_ != null) {
        configBuilder_.dispose();
        configBuilder_ = null;
      }
      configMask_ = null;
      if (configMaskBuilder_ != null) {
        configMaskBuilder_.dispose();
        configMaskBuilder_ = null;
      }
      audioSourceCase_ = 0;
      audioSource_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_BatchRecognizeFileMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.BatchRecognizeFileMetadata getDefaultInstanceForType() {
      return com.google.cloud.speech.v2.BatchRecognizeFileMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.BatchRecognizeFileMetadata build() {
      com.google.cloud.speech.v2.BatchRecognizeFileMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.BatchRecognizeFileMetadata buildPartial() {
      com.google.cloud.speech.v2.BatchRecognizeFileMetadata result =
          new com.google.cloud.speech.v2.BatchRecognizeFileMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.speech.v2.BatchRecognizeFileMetadata result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.config_ = configBuilder_ == null ? config_ : configBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.configMask_ = configMaskBuilder_ == null ? configMask_ : configMaskBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.speech.v2.BatchRecognizeFileMetadata result) {
      result.audioSourceCase_ = audioSourceCase_;
      result.audioSource_ = this.audioSource_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.speech.v2.BatchRecognizeFileMetadata) {
        return mergeFrom((com.google.cloud.speech.v2.BatchRecognizeFileMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.speech.v2.BatchRecognizeFileMetadata other) {
      if (other == com.google.cloud.speech.v2.BatchRecognizeFileMetadata.getDefaultInstance())
        return this;
      if (other.hasConfig()) {
        mergeConfig(other.getConfig());
      }
      if (other.hasConfigMask()) {
        mergeConfigMask(other.getConfigMask());
      }
      switch (other.getAudioSourceCase()) {
        case URI:
          {
            audioSourceCase_ = 1;
            audioSource_ = other.audioSource_;
            onChanged();
            break;
          }
        case AUDIOSOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                audioSourceCase_ = 1;
                audioSource_ = s;
                break;
              } // case 10
            case 34:
              {
                input.readMessage(getConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getConfigMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int audioSourceCase_ = 0;
    private java.lang.Object audioSource_;

    public AudioSourceCase getAudioSourceCase() {
      return AudioSourceCase.forNumber(audioSourceCase_);
    }

    public Builder clearAudioSource() {
      audioSourceCase_ = 0;
      audioSource_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * Cloud Storage URI for the audio file.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return Whether the uri field is set.
     */
    @java.lang.Override
    public boolean hasUri() {
      return audioSourceCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage URI for the audio file.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return The uri.
     */
    @java.lang.Override
    public java.lang.String getUri() {
      java.lang.Object ref = "";
      if (audioSourceCase_ == 1) {
        ref = audioSource_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (audioSourceCase_ == 1) {
          audioSource_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage URI for the audio file.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return The bytes for uri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = "";
      if (audioSourceCase_ == 1) {
        ref = audioSource_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (audioSourceCase_ == 1) {
          audioSource_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage URI for the audio file.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @param value The uri to set.
     * @return This builder for chaining.
     */
    public Builder setUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      audioSourceCase_ = 1;
      audioSource_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage URI for the audio file.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUri() {
      if (audioSourceCase_ == 1) {
        audioSourceCase_ = 0;
        audioSource_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage URI for the audio file.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @param value The bytes for uri to set.
     * @return This builder for chaining.
     */
    public Builder setUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      audioSourceCase_ = 1;
      audioSource_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.speech.v2.RecognitionConfig config_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.RecognitionConfig,
            com.google.cloud.speech.v2.RecognitionConfig.Builder,
            com.google.cloud.speech.v2.RecognitionConfigOrBuilder>
        configBuilder_;
    /**
     *
     *
     * <pre>
     * Features and audio metadata to use for the Automatic Speech Recognition.
     * This field in combination with the
     * [config_mask][google.cloud.speech.v2.BatchRecognizeFileMetadata.config_mask]
     * field can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource as well as the
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] at the
     * request level.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig config = 4;</code>
     *
     * @return Whether the config field is set.
     */
    public boolean hasConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Features and audio metadata to use for the Automatic Speech Recognition.
     * This field in combination with the
     * [config_mask][google.cloud.speech.v2.BatchRecognizeFileMetadata.config_mask]
     * field can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource as well as the
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] at the
     * request level.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig config = 4;</code>
     *
     * @return The config.
     */
    public com.google.cloud.speech.v2.RecognitionConfig getConfig() {
      if (configBuilder_ == null) {
        return config_ == null
            ? com.google.cloud.speech.v2.RecognitionConfig.getDefaultInstance()
            : config_;
      } else {
        return configBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Features and audio metadata to use for the Automatic Speech Recognition.
     * This field in combination with the
     * [config_mask][google.cloud.speech.v2.BatchRecognizeFileMetadata.config_mask]
     * field can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource as well as the
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] at the
     * request level.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig config = 4;</code>
     */
    public Builder setConfig(com.google.cloud.speech.v2.RecognitionConfig value) {
      if (configBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        config_ = value;
      } else {
        configBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Features and audio metadata to use for the Automatic Speech Recognition.
     * This field in combination with the
     * [config_mask][google.cloud.speech.v2.BatchRecognizeFileMetadata.config_mask]
     * field can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource as well as the
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] at the
     * request level.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig config = 4;</code>
     */
    public Builder setConfig(com.google.cloud.speech.v2.RecognitionConfig.Builder builderForValue) {
      if (configBuilder_ == null) {
        config_ = builderForValue.build();
      } else {
        configBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Features and audio metadata to use for the Automatic Speech Recognition.
     * This field in combination with the
     * [config_mask][google.cloud.speech.v2.BatchRecognizeFileMetadata.config_mask]
     * field can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource as well as the
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] at the
     * request level.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig config = 4;</code>
     */
    public Builder mergeConfig(com.google.cloud.speech.v2.RecognitionConfig value) {
      if (configBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && config_ != null
            && config_ != com.google.cloud.speech.v2.RecognitionConfig.getDefaultInstance()) {
          getConfigBuilder().mergeFrom(value);
        } else {
          config_ = value;
        }
      } else {
        configBuilder_.mergeFrom(value);
      }
      if (config_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Features and audio metadata to use for the Automatic Speech Recognition.
     * This field in combination with the
     * [config_mask][google.cloud.speech.v2.BatchRecognizeFileMetadata.config_mask]
     * field can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource as well as the
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] at the
     * request level.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig config = 4;</code>
     */
    public Builder clearConfig() {
      bitField0_ = (bitField0_ & ~0x00000002);
      config_ = null;
      if (configBuilder_ != null) {
        configBuilder_.dispose();
        configBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Features and audio metadata to use for the Automatic Speech Recognition.
     * This field in combination with the
     * [config_mask][google.cloud.speech.v2.BatchRecognizeFileMetadata.config_mask]
     * field can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource as well as the
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] at the
     * request level.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig config = 4;</code>
     */
    public com.google.cloud.speech.v2.RecognitionConfig.Builder getConfigBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Features and audio metadata to use for the Automatic Speech Recognition.
     * This field in combination with the
     * [config_mask][google.cloud.speech.v2.BatchRecognizeFileMetadata.config_mask]
     * field can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource as well as the
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] at the
     * request level.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig config = 4;</code>
     */
    public com.google.cloud.speech.v2.RecognitionConfigOrBuilder getConfigOrBuilder() {
      if (configBuilder_ != null) {
        return configBuilder_.getMessageOrBuilder();
      } else {
        return config_ == null
            ? com.google.cloud.speech.v2.RecognitionConfig.getDefaultInstance()
            : config_;
      }
    }
    /**
     *
     *
     * <pre>
     * Features and audio metadata to use for the Automatic Speech Recognition.
     * This field in combination with the
     * [config_mask][google.cloud.speech.v2.BatchRecognizeFileMetadata.config_mask]
     * field can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource as well as the
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] at the
     * request level.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig config = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.RecognitionConfig,
            com.google.cloud.speech.v2.RecognitionConfig.Builder,
            com.google.cloud.speech.v2.RecognitionConfigOrBuilder>
        getConfigFieldBuilder() {
      if (configBuilder_ == null) {
        configBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v2.RecognitionConfig,
                com.google.cloud.speech.v2.RecognitionConfig.Builder,
                com.google.cloud.speech.v2.RecognitionConfigOrBuilder>(
                getConfig(), getParentForChildren(), isClean());
        config_ = null;
      }
      return configBuilder_;
    }

    private com.google.protobuf.FieldMask configMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        configMaskBuilder_;
    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config] that
     * override the values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all non-default valued fields in
     * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config] override
     * the values in the recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config]
     * completely overrides and replaces the config in the recognizer for this
     * recognition request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 5;</code>
     *
     * @return Whether the configMask field is set.
     */
    public boolean hasConfigMask() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config] that
     * override the values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all non-default valued fields in
     * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config] override
     * the values in the recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config]
     * completely overrides and replaces the config in the recognizer for this
     * recognition request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 5;</code>
     *
     * @return The configMask.
     */
    public com.google.protobuf.FieldMask getConfigMask() {
      if (configMaskBuilder_ == null) {
        return configMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : configMask_;
      } else {
        return configMaskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config] that
     * override the values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all non-default valued fields in
     * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config] override
     * the values in the recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config]
     * completely overrides and replaces the config in the recognizer for this
     * recognition request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 5;</code>
     */
    public Builder setConfigMask(com.google.protobuf.FieldMask value) {
      if (configMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        configMask_ = value;
      } else {
        configMaskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config] that
     * override the values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all non-default valued fields in
     * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config] override
     * the values in the recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config]
     * completely overrides and replaces the config in the recognizer for this
     * recognition request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 5;</code>
     */
    public Builder setConfigMask(com.google.protobuf.FieldMask.Builder builderForValue) {
      if (configMaskBuilder_ == null) {
        configMask_ = builderForValue.build();
      } else {
        configMaskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config] that
     * override the values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all non-default valued fields in
     * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config] override
     * the values in the recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config]
     * completely overrides and replaces the config in the recognizer for this
     * recognition request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 5;</code>
     */
    public Builder mergeConfigMask(com.google.protobuf.FieldMask value) {
      if (configMaskBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && configMask_ != null
            && configMask_ != com.google.protobuf.FieldMask.getDefaultInstance()) {
          getConfigMaskBuilder().mergeFrom(value);
        } else {
          configMask_ = value;
        }
      } else {
        configMaskBuilder_.mergeFrom(value);
      }
      if (configMask_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config] that
     * override the values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all non-default valued fields in
     * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config] override
     * the values in the recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config]
     * completely overrides and replaces the config in the recognizer for this
     * recognition request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 5;</code>
     */
    public Builder clearConfigMask() {
      bitField0_ = (bitField0_ & ~0x00000004);
      configMask_ = null;
      if (configMaskBuilder_ != null) {
        configMaskBuilder_.dispose();
        configMaskBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config] that
     * override the values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all non-default valued fields in
     * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config] override
     * the values in the recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config]
     * completely overrides and replaces the config in the recognizer for this
     * recognition request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 5;</code>
     */
    public com.google.protobuf.FieldMask.Builder getConfigMaskBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getConfigMaskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config] that
     * override the values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all non-default valued fields in
     * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config] override
     * the values in the recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config]
     * completely overrides and replaces the config in the recognizer for this
     * recognition request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 5;</code>
     */
    public com.google.protobuf.FieldMaskOrBuilder getConfigMaskOrBuilder() {
      if (configMaskBuilder_ != null) {
        return configMaskBuilder_.getMessageOrBuilder();
      } else {
        return configMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : configMask_;
      }
    }
    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config] that
     * override the values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all non-default valued fields in
     * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config] override
     * the values in the recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config]
     * completely overrides and replaces the config in the recognizer for this
     * recognition request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        getConfigMaskFieldBuilder() {
      if (configMaskBuilder_ == null) {
        configMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FieldMask,
                com.google.protobuf.FieldMask.Builder,
                com.google.protobuf.FieldMaskOrBuilder>(
                getConfigMask(), getParentForChildren(), isClean());
        configMask_ = null;
      }
      return configMaskBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.speech.v2.BatchRecognizeFileMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.speech.v2.BatchRecognizeFileMetadata)
  private static final com.google.cloud.speech.v2.BatchRecognizeFileMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.speech.v2.BatchRecognizeFileMetadata();
  }

  public static com.google.cloud.speech.v2.BatchRecognizeFileMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchRecognizeFileMetadata> PARSER =
      new com.google.protobuf.AbstractParser<BatchRecognizeFileMetadata>() {
        @java.lang.Override
        public BatchRecognizeFileMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BatchRecognizeFileMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchRecognizeFileMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.speech.v2.BatchRecognizeFileMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
