/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/speech/v2/cloud_speech.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.speech.v2;

/**
 *
 *
 * <pre>
 * Configuration options for the output(s) of recognition.
 * </pre>
 *
 * Protobuf type {@code google.cloud.speech.v2.RecognitionOutputConfig}
 */
public final class RecognitionOutputConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.speech.v2.RecognitionOutputConfig)
    RecognitionOutputConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RecognitionOutputConfig.newBuilder() to construct.
  private RecognitionOutputConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RecognitionOutputConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RecognitionOutputConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.speech.v2.CloudSpeechProto
        .internal_static_google_cloud_speech_v2_RecognitionOutputConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.speech.v2.CloudSpeechProto
        .internal_static_google_cloud_speech_v2_RecognitionOutputConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.speech.v2.RecognitionOutputConfig.class,
            com.google.cloud.speech.v2.RecognitionOutputConfig.Builder.class);
  }

  private int bitField0_;
  private int outputCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object output_;

  public enum OutputCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GCS_OUTPUT_CONFIG(1),
    INLINE_RESPONSE_CONFIG(2),
    OUTPUT_NOT_SET(0);
    private final int value;

    private OutputCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static OutputCase valueOf(int value) {
      return forNumber(value);
    }

    public static OutputCase forNumber(int value) {
      switch (value) {
        case 1:
          return GCS_OUTPUT_CONFIG;
        case 2:
          return INLINE_RESPONSE_CONFIG;
        case 0:
          return OUTPUT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public OutputCase getOutputCase() {
    return OutputCase.forNumber(outputCase_);
  }

  public static final int GCS_OUTPUT_CONFIG_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * If this message is populated, recognition results are written to the
   * provided Google Cloud Storage URI.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.GcsOutputConfig gcs_output_config = 1;</code>
   *
   * @return Whether the gcsOutputConfig field is set.
   */
  @java.lang.Override
  public boolean hasGcsOutputConfig() {
    return outputCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * If this message is populated, recognition results are written to the
   * provided Google Cloud Storage URI.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.GcsOutputConfig gcs_output_config = 1;</code>
   *
   * @return The gcsOutputConfig.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.GcsOutputConfig getGcsOutputConfig() {
    if (outputCase_ == 1) {
      return (com.google.cloud.speech.v2.GcsOutputConfig) output_;
    }
    return com.google.cloud.speech.v2.GcsOutputConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * If this message is populated, recognition results are written to the
   * provided Google Cloud Storage URI.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.GcsOutputConfig gcs_output_config = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.GcsOutputConfigOrBuilder getGcsOutputConfigOrBuilder() {
    if (outputCase_ == 1) {
      return (com.google.cloud.speech.v2.GcsOutputConfig) output_;
    }
    return com.google.cloud.speech.v2.GcsOutputConfig.getDefaultInstance();
  }

  public static final int INLINE_RESPONSE_CONFIG_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * If this message is populated, recognition results are provided in the
   * [BatchRecognizeResponse][google.cloud.speech.v2.BatchRecognizeResponse]
   * message of the Operation when completed. This is only supported when
   * calling [BatchRecognize][google.cloud.speech.v2.Speech.BatchRecognize]
   * with just one audio file.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.InlineOutputConfig inline_response_config = 2;</code>
   *
   * @return Whether the inlineResponseConfig field is set.
   */
  @java.lang.Override
  public boolean hasInlineResponseConfig() {
    return outputCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * If this message is populated, recognition results are provided in the
   * [BatchRecognizeResponse][google.cloud.speech.v2.BatchRecognizeResponse]
   * message of the Operation when completed. This is only supported when
   * calling [BatchRecognize][google.cloud.speech.v2.Speech.BatchRecognize]
   * with just one audio file.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.InlineOutputConfig inline_response_config = 2;</code>
   *
   * @return The inlineResponseConfig.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.InlineOutputConfig getInlineResponseConfig() {
    if (outputCase_ == 2) {
      return (com.google.cloud.speech.v2.InlineOutputConfig) output_;
    }
    return com.google.cloud.speech.v2.InlineOutputConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * If this message is populated, recognition results are provided in the
   * [BatchRecognizeResponse][google.cloud.speech.v2.BatchRecognizeResponse]
   * message of the Operation when completed. This is only supported when
   * calling [BatchRecognize][google.cloud.speech.v2.Speech.BatchRecognize]
   * with just one audio file.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.InlineOutputConfig inline_response_config = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.InlineOutputConfigOrBuilder getInlineResponseConfigOrBuilder() {
    if (outputCase_ == 2) {
      return (com.google.cloud.speech.v2.InlineOutputConfig) output_;
    }
    return com.google.cloud.speech.v2.InlineOutputConfig.getDefaultInstance();
  }

  public static final int OUTPUT_FORMAT_CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.speech.v2.OutputFormatConfig outputFormatConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Configuration for the format of the results stored to `output`.
   * If unspecified transcripts will be written in the `NATIVE` format only.
   * </pre>
   *
   * <code>
   * .google.cloud.speech.v2.OutputFormatConfig output_format_config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the outputFormatConfig field is set.
   */
  @java.lang.Override
  public boolean hasOutputFormatConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Configuration for the format of the results stored to `output`.
   * If unspecified transcripts will be written in the `NATIVE` format only.
   * </pre>
   *
   * <code>
   * .google.cloud.speech.v2.OutputFormatConfig output_format_config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The outputFormatConfig.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.OutputFormatConfig getOutputFormatConfig() {
    return outputFormatConfig_ == null
        ? com.google.cloud.speech.v2.OutputFormatConfig.getDefaultInstance()
        : outputFormatConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Configuration for the format of the results stored to `output`.
   * If unspecified transcripts will be written in the `NATIVE` format only.
   * </pre>
   *
   * <code>
   * .google.cloud.speech.v2.OutputFormatConfig output_format_config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.OutputFormatConfigOrBuilder getOutputFormatConfigOrBuilder() {
    return outputFormatConfig_ == null
        ? com.google.cloud.speech.v2.OutputFormatConfig.getDefaultInstance()
        : outputFormatConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (outputCase_ == 1) {
      output.writeMessage(1, (com.google.cloud.speech.v2.GcsOutputConfig) output_);
    }
    if (outputCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.speech.v2.InlineOutputConfig) output_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getOutputFormatConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (outputCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.speech.v2.GcsOutputConfig) output_);
    }
    if (outputCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.speech.v2.InlineOutputConfig) output_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getOutputFormatConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.speech.v2.RecognitionOutputConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.speech.v2.RecognitionOutputConfig other =
        (com.google.cloud.speech.v2.RecognitionOutputConfig) obj;

    if (hasOutputFormatConfig() != other.hasOutputFormatConfig()) return false;
    if (hasOutputFormatConfig()) {
      if (!getOutputFormatConfig().equals(other.getOutputFormatConfig())) return false;
    }
    if (!getOutputCase().equals(other.getOutputCase())) return false;
    switch (outputCase_) {
      case 1:
        if (!getGcsOutputConfig().equals(other.getGcsOutputConfig())) return false;
        break;
      case 2:
        if (!getInlineResponseConfig().equals(other.getInlineResponseConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasOutputFormatConfig()) {
      hash = (37 * hash) + OUTPUT_FORMAT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getOutputFormatConfig().hashCode();
    }
    switch (outputCase_) {
      case 1:
        hash = (37 * hash) + GCS_OUTPUT_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getGcsOutputConfig().hashCode();
        break;
      case 2:
        hash = (37 * hash) + INLINE_RESPONSE_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getInlineResponseConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.speech.v2.RecognitionOutputConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.RecognitionOutputConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.RecognitionOutputConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.RecognitionOutputConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.RecognitionOutputConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.RecognitionOutputConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.RecognitionOutputConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.RecognitionOutputConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.RecognitionOutputConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.RecognitionOutputConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.RecognitionOutputConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.RecognitionOutputConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.speech.v2.RecognitionOutputConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration options for the output(s) of recognition.
   * </pre>
   *
   * Protobuf type {@code google.cloud.speech.v2.RecognitionOutputConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.speech.v2.RecognitionOutputConfig)
      com.google.cloud.speech.v2.RecognitionOutputConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_RecognitionOutputConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_RecognitionOutputConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.speech.v2.RecognitionOutputConfig.class,
              com.google.cloud.speech.v2.RecognitionOutputConfig.Builder.class);
    }

    // Construct using com.google.cloud.speech.v2.RecognitionOutputConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getOutputFormatConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (gcsOutputConfigBuilder_ != null) {
        gcsOutputConfigBuilder_.clear();
      }
      if (inlineResponseConfigBuilder_ != null) {
        inlineResponseConfigBuilder_.clear();
      }
      outputFormatConfig_ = null;
      if (outputFormatConfigBuilder_ != null) {
        outputFormatConfigBuilder_.dispose();
        outputFormatConfigBuilder_ = null;
      }
      outputCase_ = 0;
      output_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_RecognitionOutputConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.RecognitionOutputConfig getDefaultInstanceForType() {
      return com.google.cloud.speech.v2.RecognitionOutputConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.RecognitionOutputConfig build() {
      com.google.cloud.speech.v2.RecognitionOutputConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.RecognitionOutputConfig buildPartial() {
      com.google.cloud.speech.v2.RecognitionOutputConfig result =
          new com.google.cloud.speech.v2.RecognitionOutputConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.speech.v2.RecognitionOutputConfig result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.outputFormatConfig_ =
            outputFormatConfigBuilder_ == null
                ? outputFormatConfig_
                : outputFormatConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.speech.v2.RecognitionOutputConfig result) {
      result.outputCase_ = outputCase_;
      result.output_ = this.output_;
      if (outputCase_ == 1 && gcsOutputConfigBuilder_ != null) {
        result.output_ = gcsOutputConfigBuilder_.build();
      }
      if (outputCase_ == 2 && inlineResponseConfigBuilder_ != null) {
        result.output_ = inlineResponseConfigBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.speech.v2.RecognitionOutputConfig) {
        return mergeFrom((com.google.cloud.speech.v2.RecognitionOutputConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.speech.v2.RecognitionOutputConfig other) {
      if (other == com.google.cloud.speech.v2.RecognitionOutputConfig.getDefaultInstance())
        return this;
      if (other.hasOutputFormatConfig()) {
        mergeOutputFormatConfig(other.getOutputFormatConfig());
      }
      switch (other.getOutputCase()) {
        case GCS_OUTPUT_CONFIG:
          {
            mergeGcsOutputConfig(other.getGcsOutputConfig());
            break;
          }
        case INLINE_RESPONSE_CONFIG:
          {
            mergeInlineResponseConfig(other.getInlineResponseConfig());
            break;
          }
        case OUTPUT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getGcsOutputConfigFieldBuilder().getBuilder(), extensionRegistry);
                outputCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getInlineResponseConfigFieldBuilder().getBuilder(), extensionRegistry);
                outputCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getOutputFormatConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int outputCase_ = 0;
    private java.lang.Object output_;

    public OutputCase getOutputCase() {
      return OutputCase.forNumber(outputCase_);
    }

    public Builder clearOutput() {
      outputCase_ = 0;
      output_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.GcsOutputConfig,
            com.google.cloud.speech.v2.GcsOutputConfig.Builder,
            com.google.cloud.speech.v2.GcsOutputConfigOrBuilder>
        gcsOutputConfigBuilder_;
    /**
     *
     *
     * <pre>
     * If this message is populated, recognition results are written to the
     * provided Google Cloud Storage URI.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.GcsOutputConfig gcs_output_config = 1;</code>
     *
     * @return Whether the gcsOutputConfig field is set.
     */
    @java.lang.Override
    public boolean hasGcsOutputConfig() {
      return outputCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * If this message is populated, recognition results are written to the
     * provided Google Cloud Storage URI.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.GcsOutputConfig gcs_output_config = 1;</code>
     *
     * @return The gcsOutputConfig.
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.GcsOutputConfig getGcsOutputConfig() {
      if (gcsOutputConfigBuilder_ == null) {
        if (outputCase_ == 1) {
          return (com.google.cloud.speech.v2.GcsOutputConfig) output_;
        }
        return com.google.cloud.speech.v2.GcsOutputConfig.getDefaultInstance();
      } else {
        if (outputCase_ == 1) {
          return gcsOutputConfigBuilder_.getMessage();
        }
        return com.google.cloud.speech.v2.GcsOutputConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * If this message is populated, recognition results are written to the
     * provided Google Cloud Storage URI.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.GcsOutputConfig gcs_output_config = 1;</code>
     */
    public Builder setGcsOutputConfig(com.google.cloud.speech.v2.GcsOutputConfig value) {
      if (gcsOutputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        output_ = value;
        onChanged();
      } else {
        gcsOutputConfigBuilder_.setMessage(value);
      }
      outputCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If this message is populated, recognition results are written to the
     * provided Google Cloud Storage URI.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.GcsOutputConfig gcs_output_config = 1;</code>
     */
    public Builder setGcsOutputConfig(
        com.google.cloud.speech.v2.GcsOutputConfig.Builder builderForValue) {
      if (gcsOutputConfigBuilder_ == null) {
        output_ = builderForValue.build();
        onChanged();
      } else {
        gcsOutputConfigBuilder_.setMessage(builderForValue.build());
      }
      outputCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If this message is populated, recognition results are written to the
     * provided Google Cloud Storage URI.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.GcsOutputConfig gcs_output_config = 1;</code>
     */
    public Builder mergeGcsOutputConfig(com.google.cloud.speech.v2.GcsOutputConfig value) {
      if (gcsOutputConfigBuilder_ == null) {
        if (outputCase_ == 1
            && output_ != com.google.cloud.speech.v2.GcsOutputConfig.getDefaultInstance()) {
          output_ =
              com.google.cloud.speech.v2.GcsOutputConfig.newBuilder(
                      (com.google.cloud.speech.v2.GcsOutputConfig) output_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          output_ = value;
        }
        onChanged();
      } else {
        if (outputCase_ == 1) {
          gcsOutputConfigBuilder_.mergeFrom(value);
        } else {
          gcsOutputConfigBuilder_.setMessage(value);
        }
      }
      outputCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If this message is populated, recognition results are written to the
     * provided Google Cloud Storage URI.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.GcsOutputConfig gcs_output_config = 1;</code>
     */
    public Builder clearGcsOutputConfig() {
      if (gcsOutputConfigBuilder_ == null) {
        if (outputCase_ == 1) {
          outputCase_ = 0;
          output_ = null;
          onChanged();
        }
      } else {
        if (outputCase_ == 1) {
          outputCase_ = 0;
          output_ = null;
        }
        gcsOutputConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If this message is populated, recognition results are written to the
     * provided Google Cloud Storage URI.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.GcsOutputConfig gcs_output_config = 1;</code>
     */
    public com.google.cloud.speech.v2.GcsOutputConfig.Builder getGcsOutputConfigBuilder() {
      return getGcsOutputConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If this message is populated, recognition results are written to the
     * provided Google Cloud Storage URI.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.GcsOutputConfig gcs_output_config = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.GcsOutputConfigOrBuilder getGcsOutputConfigOrBuilder() {
      if ((outputCase_ == 1) && (gcsOutputConfigBuilder_ != null)) {
        return gcsOutputConfigBuilder_.getMessageOrBuilder();
      } else {
        if (outputCase_ == 1) {
          return (com.google.cloud.speech.v2.GcsOutputConfig) output_;
        }
        return com.google.cloud.speech.v2.GcsOutputConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * If this message is populated, recognition results are written to the
     * provided Google Cloud Storage URI.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.GcsOutputConfig gcs_output_config = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.GcsOutputConfig,
            com.google.cloud.speech.v2.GcsOutputConfig.Builder,
            com.google.cloud.speech.v2.GcsOutputConfigOrBuilder>
        getGcsOutputConfigFieldBuilder() {
      if (gcsOutputConfigBuilder_ == null) {
        if (!(outputCase_ == 1)) {
          output_ = com.google.cloud.speech.v2.GcsOutputConfig.getDefaultInstance();
        }
        gcsOutputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v2.GcsOutputConfig,
                com.google.cloud.speech.v2.GcsOutputConfig.Builder,
                com.google.cloud.speech.v2.GcsOutputConfigOrBuilder>(
                (com.google.cloud.speech.v2.GcsOutputConfig) output_,
                getParentForChildren(),
                isClean());
        output_ = null;
      }
      outputCase_ = 1;
      onChanged();
      return gcsOutputConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.InlineOutputConfig,
            com.google.cloud.speech.v2.InlineOutputConfig.Builder,
            com.google.cloud.speech.v2.InlineOutputConfigOrBuilder>
        inlineResponseConfigBuilder_;
    /**
     *
     *
     * <pre>
     * If this message is populated, recognition results are provided in the
     * [BatchRecognizeResponse][google.cloud.speech.v2.BatchRecognizeResponse]
     * message of the Operation when completed. This is only supported when
     * calling [BatchRecognize][google.cloud.speech.v2.Speech.BatchRecognize]
     * with just one audio file.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.InlineOutputConfig inline_response_config = 2;</code>
     *
     * @return Whether the inlineResponseConfig field is set.
     */
    @java.lang.Override
    public boolean hasInlineResponseConfig() {
      return outputCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * If this message is populated, recognition results are provided in the
     * [BatchRecognizeResponse][google.cloud.speech.v2.BatchRecognizeResponse]
     * message of the Operation when completed. This is only supported when
     * calling [BatchRecognize][google.cloud.speech.v2.Speech.BatchRecognize]
     * with just one audio file.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.InlineOutputConfig inline_response_config = 2;</code>
     *
     * @return The inlineResponseConfig.
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.InlineOutputConfig getInlineResponseConfig() {
      if (inlineResponseConfigBuilder_ == null) {
        if (outputCase_ == 2) {
          return (com.google.cloud.speech.v2.InlineOutputConfig) output_;
        }
        return com.google.cloud.speech.v2.InlineOutputConfig.getDefaultInstance();
      } else {
        if (outputCase_ == 2) {
          return inlineResponseConfigBuilder_.getMessage();
        }
        return com.google.cloud.speech.v2.InlineOutputConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * If this message is populated, recognition results are provided in the
     * [BatchRecognizeResponse][google.cloud.speech.v2.BatchRecognizeResponse]
     * message of the Operation when completed. This is only supported when
     * calling [BatchRecognize][google.cloud.speech.v2.Speech.BatchRecognize]
     * with just one audio file.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.InlineOutputConfig inline_response_config = 2;</code>
     */
    public Builder setInlineResponseConfig(com.google.cloud.speech.v2.InlineOutputConfig value) {
      if (inlineResponseConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        output_ = value;
        onChanged();
      } else {
        inlineResponseConfigBuilder_.setMessage(value);
      }
      outputCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If this message is populated, recognition results are provided in the
     * [BatchRecognizeResponse][google.cloud.speech.v2.BatchRecognizeResponse]
     * message of the Operation when completed. This is only supported when
     * calling [BatchRecognize][google.cloud.speech.v2.Speech.BatchRecognize]
     * with just one audio file.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.InlineOutputConfig inline_response_config = 2;</code>
     */
    public Builder setInlineResponseConfig(
        com.google.cloud.speech.v2.InlineOutputConfig.Builder builderForValue) {
      if (inlineResponseConfigBuilder_ == null) {
        output_ = builderForValue.build();
        onChanged();
      } else {
        inlineResponseConfigBuilder_.setMessage(builderForValue.build());
      }
      outputCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If this message is populated, recognition results are provided in the
     * [BatchRecognizeResponse][google.cloud.speech.v2.BatchRecognizeResponse]
     * message of the Operation when completed. This is only supported when
     * calling [BatchRecognize][google.cloud.speech.v2.Speech.BatchRecognize]
     * with just one audio file.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.InlineOutputConfig inline_response_config = 2;</code>
     */
    public Builder mergeInlineResponseConfig(com.google.cloud.speech.v2.InlineOutputConfig value) {
      if (inlineResponseConfigBuilder_ == null) {
        if (outputCase_ == 2
            && output_ != com.google.cloud.speech.v2.InlineOutputConfig.getDefaultInstance()) {
          output_ =
              com.google.cloud.speech.v2.InlineOutputConfig.newBuilder(
                      (com.google.cloud.speech.v2.InlineOutputConfig) output_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          output_ = value;
        }
        onChanged();
      } else {
        if (outputCase_ == 2) {
          inlineResponseConfigBuilder_.mergeFrom(value);
        } else {
          inlineResponseConfigBuilder_.setMessage(value);
        }
      }
      outputCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If this message is populated, recognition results are provided in the
     * [BatchRecognizeResponse][google.cloud.speech.v2.BatchRecognizeResponse]
     * message of the Operation when completed. This is only supported when
     * calling [BatchRecognize][google.cloud.speech.v2.Speech.BatchRecognize]
     * with just one audio file.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.InlineOutputConfig inline_response_config = 2;</code>
     */
    public Builder clearInlineResponseConfig() {
      if (inlineResponseConfigBuilder_ == null) {
        if (outputCase_ == 2) {
          outputCase_ = 0;
          output_ = null;
          onChanged();
        }
      } else {
        if (outputCase_ == 2) {
          outputCase_ = 0;
          output_ = null;
        }
        inlineResponseConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If this message is populated, recognition results are provided in the
     * [BatchRecognizeResponse][google.cloud.speech.v2.BatchRecognizeResponse]
     * message of the Operation when completed. This is only supported when
     * calling [BatchRecognize][google.cloud.speech.v2.Speech.BatchRecognize]
     * with just one audio file.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.InlineOutputConfig inline_response_config = 2;</code>
     */
    public com.google.cloud.speech.v2.InlineOutputConfig.Builder getInlineResponseConfigBuilder() {
      return getInlineResponseConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If this message is populated, recognition results are provided in the
     * [BatchRecognizeResponse][google.cloud.speech.v2.BatchRecognizeResponse]
     * message of the Operation when completed. This is only supported when
     * calling [BatchRecognize][google.cloud.speech.v2.Speech.BatchRecognize]
     * with just one audio file.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.InlineOutputConfig inline_response_config = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.InlineOutputConfigOrBuilder
        getInlineResponseConfigOrBuilder() {
      if ((outputCase_ == 2) && (inlineResponseConfigBuilder_ != null)) {
        return inlineResponseConfigBuilder_.getMessageOrBuilder();
      } else {
        if (outputCase_ == 2) {
          return (com.google.cloud.speech.v2.InlineOutputConfig) output_;
        }
        return com.google.cloud.speech.v2.InlineOutputConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * If this message is populated, recognition results are provided in the
     * [BatchRecognizeResponse][google.cloud.speech.v2.BatchRecognizeResponse]
     * message of the Operation when completed. This is only supported when
     * calling [BatchRecognize][google.cloud.speech.v2.Speech.BatchRecognize]
     * with just one audio file.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.InlineOutputConfig inline_response_config = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.InlineOutputConfig,
            com.google.cloud.speech.v2.InlineOutputConfig.Builder,
            com.google.cloud.speech.v2.InlineOutputConfigOrBuilder>
        getInlineResponseConfigFieldBuilder() {
      if (inlineResponseConfigBuilder_ == null) {
        if (!(outputCase_ == 2)) {
          output_ = com.google.cloud.speech.v2.InlineOutputConfig.getDefaultInstance();
        }
        inlineResponseConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v2.InlineOutputConfig,
                com.google.cloud.speech.v2.InlineOutputConfig.Builder,
                com.google.cloud.speech.v2.InlineOutputConfigOrBuilder>(
                (com.google.cloud.speech.v2.InlineOutputConfig) output_,
                getParentForChildren(),
                isClean());
        output_ = null;
      }
      outputCase_ = 2;
      onChanged();
      return inlineResponseConfigBuilder_;
    }

    private com.google.cloud.speech.v2.OutputFormatConfig outputFormatConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.OutputFormatConfig,
            com.google.cloud.speech.v2.OutputFormatConfig.Builder,
            com.google.cloud.speech.v2.OutputFormatConfigOrBuilder>
        outputFormatConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the format of the results stored to `output`.
     * If unspecified transcripts will be written in the `NATIVE` format only.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.OutputFormatConfig output_format_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the outputFormatConfig field is set.
     */
    public boolean hasOutputFormatConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the format of the results stored to `output`.
     * If unspecified transcripts will be written in the `NATIVE` format only.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.OutputFormatConfig output_format_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The outputFormatConfig.
     */
    public com.google.cloud.speech.v2.OutputFormatConfig getOutputFormatConfig() {
      if (outputFormatConfigBuilder_ == null) {
        return outputFormatConfig_ == null
            ? com.google.cloud.speech.v2.OutputFormatConfig.getDefaultInstance()
            : outputFormatConfig_;
      } else {
        return outputFormatConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the format of the results stored to `output`.
     * If unspecified transcripts will be written in the `NATIVE` format only.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.OutputFormatConfig output_format_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setOutputFormatConfig(com.google.cloud.speech.v2.OutputFormatConfig value) {
      if (outputFormatConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputFormatConfig_ = value;
      } else {
        outputFormatConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the format of the results stored to `output`.
     * If unspecified transcripts will be written in the `NATIVE` format only.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.OutputFormatConfig output_format_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setOutputFormatConfig(
        com.google.cloud.speech.v2.OutputFormatConfig.Builder builderForValue) {
      if (outputFormatConfigBuilder_ == null) {
        outputFormatConfig_ = builderForValue.build();
      } else {
        outputFormatConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the format of the results stored to `output`.
     * If unspecified transcripts will be written in the `NATIVE` format only.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.OutputFormatConfig output_format_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeOutputFormatConfig(com.google.cloud.speech.v2.OutputFormatConfig value) {
      if (outputFormatConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && outputFormatConfig_ != null
            && outputFormatConfig_
                != com.google.cloud.speech.v2.OutputFormatConfig.getDefaultInstance()) {
          getOutputFormatConfigBuilder().mergeFrom(value);
        } else {
          outputFormatConfig_ = value;
        }
      } else {
        outputFormatConfigBuilder_.mergeFrom(value);
      }
      if (outputFormatConfig_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the format of the results stored to `output`.
     * If unspecified transcripts will be written in the `NATIVE` format only.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.OutputFormatConfig output_format_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearOutputFormatConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      outputFormatConfig_ = null;
      if (outputFormatConfigBuilder_ != null) {
        outputFormatConfigBuilder_.dispose();
        outputFormatConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the format of the results stored to `output`.
     * If unspecified transcripts will be written in the `NATIVE` format only.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.OutputFormatConfig output_format_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.speech.v2.OutputFormatConfig.Builder getOutputFormatConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getOutputFormatConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the format of the results stored to `output`.
     * If unspecified transcripts will be written in the `NATIVE` format only.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.OutputFormatConfig output_format_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.speech.v2.OutputFormatConfigOrBuilder getOutputFormatConfigOrBuilder() {
      if (outputFormatConfigBuilder_ != null) {
        return outputFormatConfigBuilder_.getMessageOrBuilder();
      } else {
        return outputFormatConfig_ == null
            ? com.google.cloud.speech.v2.OutputFormatConfig.getDefaultInstance()
            : outputFormatConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the format of the results stored to `output`.
     * If unspecified transcripts will be written in the `NATIVE` format only.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.OutputFormatConfig output_format_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.OutputFormatConfig,
            com.google.cloud.speech.v2.OutputFormatConfig.Builder,
            com.google.cloud.speech.v2.OutputFormatConfigOrBuilder>
        getOutputFormatConfigFieldBuilder() {
      if (outputFormatConfigBuilder_ == null) {
        outputFormatConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v2.OutputFormatConfig,
                com.google.cloud.speech.v2.OutputFormatConfig.Builder,
                com.google.cloud.speech.v2.OutputFormatConfigOrBuilder>(
                getOutputFormatConfig(), getParentForChildren(), isClean());
        outputFormatConfig_ = null;
      }
      return outputFormatConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.speech.v2.RecognitionOutputConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.speech.v2.RecognitionOutputConfig)
  private static final com.google.cloud.speech.v2.RecognitionOutputConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.speech.v2.RecognitionOutputConfig();
  }

  public static com.google.cloud.speech.v2.RecognitionOutputConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RecognitionOutputConfig> PARSER =
      new com.google.protobuf.AbstractParser<RecognitionOutputConfig>() {
        @java.lang.Override
        public RecognitionOutputConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RecognitionOutputConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RecognitionOutputConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.speech.v2.RecognitionOutputConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
