/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/speech/v2/cloud_speech.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.speech.v2;

/**
 *
 *
 * <pre>
 * Request message for the
 * [BatchRecognize][google.cloud.speech.v2.Speech.BatchRecognize]
 * method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.speech.v2.BatchRecognizeRequest}
 */
public final class BatchRecognizeRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.speech.v2.BatchRecognizeRequest)
    BatchRecognizeRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use BatchRecognizeRequest.newBuilder() to construct.
  private BatchRecognizeRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchRecognizeRequest() {
    recognizer_ = "";
    files_ = java.util.Collections.emptyList();
    processingStrategy_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchRecognizeRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.speech.v2.CloudSpeechProto
        .internal_static_google_cloud_speech_v2_BatchRecognizeRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.speech.v2.CloudSpeechProto
        .internal_static_google_cloud_speech_v2_BatchRecognizeRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.speech.v2.BatchRecognizeRequest.class,
            com.google.cloud.speech.v2.BatchRecognizeRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible processing strategies for batch requests.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.speech.v2.BatchRecognizeRequest.ProcessingStrategy}
   */
  public enum ProcessingStrategy implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value for the processing strategy. The request is processed as
     * soon as its received.
     * </pre>
     *
     * <code>PROCESSING_STRATEGY_UNSPECIFIED = 0;</code>
     */
    PROCESSING_STRATEGY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * If selected, processes the request during lower utilization periods for a
     * price discount. The request is fulfilled within 24 hours.
     * </pre>
     *
     * <code>DYNAMIC_BATCHING = 1;</code>
     */
    DYNAMIC_BATCHING(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value for the processing strategy. The request is processed as
     * soon as its received.
     * </pre>
     *
     * <code>PROCESSING_STRATEGY_UNSPECIFIED = 0;</code>
     */
    public static final int PROCESSING_STRATEGY_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * If selected, processes the request during lower utilization periods for a
     * price discount. The request is fulfilled within 24 hours.
     * </pre>
     *
     * <code>DYNAMIC_BATCHING = 1;</code>
     */
    public static final int DYNAMIC_BATCHING_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ProcessingStrategy valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ProcessingStrategy forNumber(int value) {
      switch (value) {
        case 0:
          return PROCESSING_STRATEGY_UNSPECIFIED;
        case 1:
          return DYNAMIC_BATCHING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ProcessingStrategy>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ProcessingStrategy>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ProcessingStrategy>() {
              public ProcessingStrategy findValueByNumber(int number) {
                return ProcessingStrategy.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.speech.v2.BatchRecognizeRequest.getDescriptor().getEnumTypes().get(0);
    }

    private static final ProcessingStrategy[] VALUES = values();

    public static ProcessingStrategy valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ProcessingStrategy(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.speech.v2.BatchRecognizeRequest.ProcessingStrategy)
  }

  private int bitField0_;
  public static final int RECOGNIZER_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object recognizer_ = "";

  /**
   *
   *
   * <pre>
   * Required. The name of the Recognizer to use during recognition. The
   * expected format is
   * `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
   * {recognizer} segment may be set to `_` to use an empty implicit Recognizer.
   * </pre>
   *
   * <code>
   * string recognizer = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The recognizer.
   */
  @java.lang.Override
  public java.lang.String getRecognizer() {
    java.lang.Object ref = recognizer_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      recognizer_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The name of the Recognizer to use during recognition. The
   * expected format is
   * `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
   * {recognizer} segment may be set to `_` to use an empty implicit Recognizer.
   * </pre>
   *
   * <code>
   * string recognizer = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for recognizer.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRecognizerBytes() {
    java.lang.Object ref = recognizer_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      recognizer_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.speech.v2.RecognitionConfig config_;

  /**
   *
   *
   * <pre>
   * Features and audio metadata to use for the Automatic Speech Recognition.
   * This field in combination with the
   * [config_mask][google.cloud.speech.v2.BatchRecognizeRequest.config_mask]
   * field can be used to override parts of the
   * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
   * of the Recognizer resource.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.RecognitionConfig config = 4;</code>
   *
   * @return Whether the config field is set.
   */
  @java.lang.Override
  public boolean hasConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Features and audio metadata to use for the Automatic Speech Recognition.
   * This field in combination with the
   * [config_mask][google.cloud.speech.v2.BatchRecognizeRequest.config_mask]
   * field can be used to override parts of the
   * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
   * of the Recognizer resource.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.RecognitionConfig config = 4;</code>
   *
   * @return The config.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.RecognitionConfig getConfig() {
    return config_ == null
        ? com.google.cloud.speech.v2.RecognitionConfig.getDefaultInstance()
        : config_;
  }

  /**
   *
   *
   * <pre>
   * Features and audio metadata to use for the Automatic Speech Recognition.
   * This field in combination with the
   * [config_mask][google.cloud.speech.v2.BatchRecognizeRequest.config_mask]
   * field can be used to override parts of the
   * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
   * of the Recognizer resource.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.RecognitionConfig config = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.RecognitionConfigOrBuilder getConfigOrBuilder() {
    return config_ == null
        ? com.google.cloud.speech.v2.RecognitionConfig.getDefaultInstance()
        : config_;
  }

  public static final int CONFIG_MASK_FIELD_NUMBER = 5;
  private com.google.protobuf.FieldMask configMask_;

  /**
   *
   *
   * <pre>
   * The list of fields in
   * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] that override
   * the values in the
   * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
   * of the recognizer during this recognition request. If no mask is provided,
   * all given fields in
   * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] override the
   * values in the recognizer for this recognition request. If a mask is
   * provided, only the fields listed in the mask override the config in the
   * recognizer for this recognition request. If a wildcard (`*`) is provided,
   * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] completely
   * overrides and replaces the config in the recognizer for this recognition
   * request.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask config_mask = 5;</code>
   *
   * @return Whether the configMask field is set.
   */
  @java.lang.Override
  public boolean hasConfigMask() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The list of fields in
   * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] that override
   * the values in the
   * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
   * of the recognizer during this recognition request. If no mask is provided,
   * all given fields in
   * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] override the
   * values in the recognizer for this recognition request. If a mask is
   * provided, only the fields listed in the mask override the config in the
   * recognizer for this recognition request. If a wildcard (`*`) is provided,
   * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] completely
   * overrides and replaces the config in the recognizer for this recognition
   * request.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask config_mask = 5;</code>
   *
   * @return The configMask.
   */
  @java.lang.Override
  public com.google.protobuf.FieldMask getConfigMask() {
    return configMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : configMask_;
  }

  /**
   *
   *
   * <pre>
   * The list of fields in
   * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] that override
   * the values in the
   * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
   * of the recognizer during this recognition request. If no mask is provided,
   * all given fields in
   * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] override the
   * values in the recognizer for this recognition request. If a mask is
   * provided, only the fields listed in the mask override the config in the
   * recognizer for this recognition request. If a wildcard (`*`) is provided,
   * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] completely
   * overrides and replaces the config in the recognizer for this recognition
   * request.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask config_mask = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.FieldMaskOrBuilder getConfigMaskOrBuilder() {
    return configMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : configMask_;
  }

  public static final int FILES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.speech.v2.BatchRecognizeFileMetadata> files_;

  /**
   *
   *
   * <pre>
   * Audio files with file metadata for ASR.
   * The maximum number of files allowed to be specified is 15.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v2.BatchRecognizeFileMetadata files = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.speech.v2.BatchRecognizeFileMetadata> getFilesList() {
    return files_;
  }

  /**
   *
   *
   * <pre>
   * Audio files with file metadata for ASR.
   * The maximum number of files allowed to be specified is 15.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v2.BatchRecognizeFileMetadata files = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.speech.v2.BatchRecognizeFileMetadataOrBuilder>
      getFilesOrBuilderList() {
    return files_;
  }

  /**
   *
   *
   * <pre>
   * Audio files with file metadata for ASR.
   * The maximum number of files allowed to be specified is 15.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v2.BatchRecognizeFileMetadata files = 3;</code>
   */
  @java.lang.Override
  public int getFilesCount() {
    return files_.size();
  }

  /**
   *
   *
   * <pre>
   * Audio files with file metadata for ASR.
   * The maximum number of files allowed to be specified is 15.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v2.BatchRecognizeFileMetadata files = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.BatchRecognizeFileMetadata getFiles(int index) {
    return files_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Audio files with file metadata for ASR.
   * The maximum number of files allowed to be specified is 15.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v2.BatchRecognizeFileMetadata files = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.BatchRecognizeFileMetadataOrBuilder getFilesOrBuilder(
      int index) {
    return files_.get(index);
  }

  public static final int RECOGNITION_OUTPUT_CONFIG_FIELD_NUMBER = 6;
  private com.google.cloud.speech.v2.RecognitionOutputConfig recognitionOutputConfig_;

  /**
   *
   *
   * <pre>
   * Configuration options for where to output the transcripts of each file.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.RecognitionOutputConfig recognition_output_config = 6;</code>
   *
   * @return Whether the recognitionOutputConfig field is set.
   */
  @java.lang.Override
  public boolean hasRecognitionOutputConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Configuration options for where to output the transcripts of each file.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.RecognitionOutputConfig recognition_output_config = 6;</code>
   *
   * @return The recognitionOutputConfig.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.RecognitionOutputConfig getRecognitionOutputConfig() {
    return recognitionOutputConfig_ == null
        ? com.google.cloud.speech.v2.RecognitionOutputConfig.getDefaultInstance()
        : recognitionOutputConfig_;
  }

  /**
   *
   *
   * <pre>
   * Configuration options for where to output the transcripts of each file.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.RecognitionOutputConfig recognition_output_config = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.RecognitionOutputConfigOrBuilder
      getRecognitionOutputConfigOrBuilder() {
    return recognitionOutputConfig_ == null
        ? com.google.cloud.speech.v2.RecognitionOutputConfig.getDefaultInstance()
        : recognitionOutputConfig_;
  }

  public static final int PROCESSING_STRATEGY_FIELD_NUMBER = 7;
  private int processingStrategy_ = 0;

  /**
   *
   *
   * <pre>
   * Processing strategy to use for this request.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.BatchRecognizeRequest.ProcessingStrategy processing_strategy = 7;
   * </code>
   *
   * @return The enum numeric value on the wire for processingStrategy.
   */
  @java.lang.Override
  public int getProcessingStrategyValue() {
    return processingStrategy_;
  }

  /**
   *
   *
   * <pre>
   * Processing strategy to use for this request.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.BatchRecognizeRequest.ProcessingStrategy processing_strategy = 7;
   * </code>
   *
   * @return The processingStrategy.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.BatchRecognizeRequest.ProcessingStrategy
      getProcessingStrategy() {
    com.google.cloud.speech.v2.BatchRecognizeRequest.ProcessingStrategy result =
        com.google.cloud.speech.v2.BatchRecognizeRequest.ProcessingStrategy.forNumber(
            processingStrategy_);
    return result == null
        ? com.google.cloud.speech.v2.BatchRecognizeRequest.ProcessingStrategy.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(recognizer_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, recognizer_);
    }
    for (int i = 0; i < files_.size(); i++) {
      output.writeMessage(3, files_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getConfigMask());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(6, getRecognitionOutputConfig());
    }
    if (processingStrategy_
        != com.google.cloud.speech.v2.BatchRecognizeRequest.ProcessingStrategy
            .PROCESSING_STRATEGY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(7, processingStrategy_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(recognizer_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, recognizer_);
    }
    for (int i = 0; i < files_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, files_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getConfigMask());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(6, getRecognitionOutputConfig());
    }
    if (processingStrategy_
        != com.google.cloud.speech.v2.BatchRecognizeRequest.ProcessingStrategy
            .PROCESSING_STRATEGY_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, processingStrategy_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.speech.v2.BatchRecognizeRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.speech.v2.BatchRecognizeRequest other =
        (com.google.cloud.speech.v2.BatchRecognizeRequest) obj;

    if (!getRecognizer().equals(other.getRecognizer())) return false;
    if (hasConfig() != other.hasConfig()) return false;
    if (hasConfig()) {
      if (!getConfig().equals(other.getConfig())) return false;
    }
    if (hasConfigMask() != other.hasConfigMask()) return false;
    if (hasConfigMask()) {
      if (!getConfigMask().equals(other.getConfigMask())) return false;
    }
    if (!getFilesList().equals(other.getFilesList())) return false;
    if (hasRecognitionOutputConfig() != other.hasRecognitionOutputConfig()) return false;
    if (hasRecognitionOutputConfig()) {
      if (!getRecognitionOutputConfig().equals(other.getRecognitionOutputConfig())) return false;
    }
    if (processingStrategy_ != other.processingStrategy_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RECOGNIZER_FIELD_NUMBER;
    hash = (53 * hash) + getRecognizer().hashCode();
    if (hasConfig()) {
      hash = (37 * hash) + CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getConfig().hashCode();
    }
    if (hasConfigMask()) {
      hash = (37 * hash) + CONFIG_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getConfigMask().hashCode();
    }
    if (getFilesCount() > 0) {
      hash = (37 * hash) + FILES_FIELD_NUMBER;
      hash = (53 * hash) + getFilesList().hashCode();
    }
    if (hasRecognitionOutputConfig()) {
      hash = (37 * hash) + RECOGNITION_OUTPUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRecognitionOutputConfig().hashCode();
    }
    hash = (37 * hash) + PROCESSING_STRATEGY_FIELD_NUMBER;
    hash = (53 * hash) + processingStrategy_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.speech.v2.BatchRecognizeRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.speech.v2.BatchRecognizeRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for the
   * [BatchRecognize][google.cloud.speech.v2.Speech.BatchRecognize]
   * method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.speech.v2.BatchRecognizeRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.speech.v2.BatchRecognizeRequest)
      com.google.cloud.speech.v2.BatchRecognizeRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_BatchRecognizeRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_BatchRecognizeRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.speech.v2.BatchRecognizeRequest.class,
              com.google.cloud.speech.v2.BatchRecognizeRequest.Builder.class);
    }

    // Construct using com.google.cloud.speech.v2.BatchRecognizeRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getConfigFieldBuilder();
        getConfigMaskFieldBuilder();
        getFilesFieldBuilder();
        getRecognitionOutputConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      recognizer_ = "";
      config_ = null;
      if (configBuilder_ != null) {
        configBuilder_.dispose();
        configBuilder_ = null;
      }
      configMask_ = null;
      if (configMaskBuilder_ != null) {
        configMaskBuilder_.dispose();
        configMaskBuilder_ = null;
      }
      if (filesBuilder_ == null) {
        files_ = java.util.Collections.emptyList();
      } else {
        files_ = null;
        filesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      recognitionOutputConfig_ = null;
      if (recognitionOutputConfigBuilder_ != null) {
        recognitionOutputConfigBuilder_.dispose();
        recognitionOutputConfigBuilder_ = null;
      }
      processingStrategy_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_BatchRecognizeRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.BatchRecognizeRequest getDefaultInstanceForType() {
      return com.google.cloud.speech.v2.BatchRecognizeRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.BatchRecognizeRequest build() {
      com.google.cloud.speech.v2.BatchRecognizeRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.BatchRecognizeRequest buildPartial() {
      com.google.cloud.speech.v2.BatchRecognizeRequest result =
          new com.google.cloud.speech.v2.BatchRecognizeRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.speech.v2.BatchRecognizeRequest result) {
      if (filesBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          files_ = java.util.Collections.unmodifiableList(files_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.files_ = files_;
      } else {
        result.files_ = filesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.speech.v2.BatchRecognizeRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.recognizer_ = recognizer_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.config_ = configBuilder_ == null ? config_ : configBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.configMask_ = configMaskBuilder_ == null ? configMask_ : configMaskBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.recognitionOutputConfig_ =
            recognitionOutputConfigBuilder_ == null
                ? recognitionOutputConfig_
                : recognitionOutputConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.processingStrategy_ = processingStrategy_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.speech.v2.BatchRecognizeRequest) {
        return mergeFrom((com.google.cloud.speech.v2.BatchRecognizeRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.speech.v2.BatchRecognizeRequest other) {
      if (other == com.google.cloud.speech.v2.BatchRecognizeRequest.getDefaultInstance())
        return this;
      if (!other.getRecognizer().isEmpty()) {
        recognizer_ = other.recognizer_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasConfig()) {
        mergeConfig(other.getConfig());
      }
      if (other.hasConfigMask()) {
        mergeConfigMask(other.getConfigMask());
      }
      if (filesBuilder_ == null) {
        if (!other.files_.isEmpty()) {
          if (files_.isEmpty()) {
            files_ = other.files_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureFilesIsMutable();
            files_.addAll(other.files_);
          }
          onChanged();
        }
      } else {
        if (!other.files_.isEmpty()) {
          if (filesBuilder_.isEmpty()) {
            filesBuilder_.dispose();
            filesBuilder_ = null;
            files_ = other.files_;
            bitField0_ = (bitField0_ & ~0x00000008);
            filesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFilesFieldBuilder()
                    : null;
          } else {
            filesBuilder_.addAllMessages(other.files_);
          }
        }
      }
      if (other.hasRecognitionOutputConfig()) {
        mergeRecognitionOutputConfig(other.getRecognitionOutputConfig());
      }
      if (other.processingStrategy_ != 0) {
        setProcessingStrategyValue(other.getProcessingStrategyValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                recognizer_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                com.google.cloud.speech.v2.BatchRecognizeFileMetadata m =
                    input.readMessage(
                        com.google.cloud.speech.v2.BatchRecognizeFileMetadata.parser(),
                        extensionRegistry);
                if (filesBuilder_ == null) {
                  ensureFilesIsMutable();
                  files_.add(m);
                } else {
                  filesBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getConfigMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getRecognitionOutputConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            case 56:
              {
                processingStrategy_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 56
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object recognizer_ = "";

    /**
     *
     *
     * <pre>
     * Required. The name of the Recognizer to use during recognition. The
     * expected format is
     * `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
     * {recognizer} segment may be set to `_` to use an empty implicit Recognizer.
     * </pre>
     *
     * <code>
     * string recognizer = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The recognizer.
     */
    public java.lang.String getRecognizer() {
      java.lang.Object ref = recognizer_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        recognizer_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the Recognizer to use during recognition. The
     * expected format is
     * `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
     * {recognizer} segment may be set to `_` to use an empty implicit Recognizer.
     * </pre>
     *
     * <code>
     * string recognizer = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for recognizer.
     */
    public com.google.protobuf.ByteString getRecognizerBytes() {
      java.lang.Object ref = recognizer_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        recognizer_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the Recognizer to use during recognition. The
     * expected format is
     * `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
     * {recognizer} segment may be set to `_` to use an empty implicit Recognizer.
     * </pre>
     *
     * <code>
     * string recognizer = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The recognizer to set.
     * @return This builder for chaining.
     */
    public Builder setRecognizer(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      recognizer_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the Recognizer to use during recognition. The
     * expected format is
     * `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
     * {recognizer} segment may be set to `_` to use an empty implicit Recognizer.
     * </pre>
     *
     * <code>
     * string recognizer = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRecognizer() {
      recognizer_ = getDefaultInstance().getRecognizer();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the Recognizer to use during recognition. The
     * expected format is
     * `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
     * {recognizer} segment may be set to `_` to use an empty implicit Recognizer.
     * </pre>
     *
     * <code>
     * string recognizer = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for recognizer to set.
     * @return This builder for chaining.
     */
    public Builder setRecognizerBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      recognizer_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.speech.v2.RecognitionConfig config_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.RecognitionConfig,
            com.google.cloud.speech.v2.RecognitionConfig.Builder,
            com.google.cloud.speech.v2.RecognitionConfigOrBuilder>
        configBuilder_;

    /**
     *
     *
     * <pre>
     * Features and audio metadata to use for the Automatic Speech Recognition.
     * This field in combination with the
     * [config_mask][google.cloud.speech.v2.BatchRecognizeRequest.config_mask]
     * field can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig config = 4;</code>
     *
     * @return Whether the config field is set.
     */
    public boolean hasConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Features and audio metadata to use for the Automatic Speech Recognition.
     * This field in combination with the
     * [config_mask][google.cloud.speech.v2.BatchRecognizeRequest.config_mask]
     * field can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig config = 4;</code>
     *
     * @return The config.
     */
    public com.google.cloud.speech.v2.RecognitionConfig getConfig() {
      if (configBuilder_ == null) {
        return config_ == null
            ? com.google.cloud.speech.v2.RecognitionConfig.getDefaultInstance()
            : config_;
      } else {
        return configBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Features and audio metadata to use for the Automatic Speech Recognition.
     * This field in combination with the
     * [config_mask][google.cloud.speech.v2.BatchRecognizeRequest.config_mask]
     * field can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig config = 4;</code>
     */
    public Builder setConfig(com.google.cloud.speech.v2.RecognitionConfig value) {
      if (configBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        config_ = value;
      } else {
        configBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Features and audio metadata to use for the Automatic Speech Recognition.
     * This field in combination with the
     * [config_mask][google.cloud.speech.v2.BatchRecognizeRequest.config_mask]
     * field can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig config = 4;</code>
     */
    public Builder setConfig(com.google.cloud.speech.v2.RecognitionConfig.Builder builderForValue) {
      if (configBuilder_ == null) {
        config_ = builderForValue.build();
      } else {
        configBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Features and audio metadata to use for the Automatic Speech Recognition.
     * This field in combination with the
     * [config_mask][google.cloud.speech.v2.BatchRecognizeRequest.config_mask]
     * field can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig config = 4;</code>
     */
    public Builder mergeConfig(com.google.cloud.speech.v2.RecognitionConfig value) {
      if (configBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && config_ != null
            && config_ != com.google.cloud.speech.v2.RecognitionConfig.getDefaultInstance()) {
          getConfigBuilder().mergeFrom(value);
        } else {
          config_ = value;
        }
      } else {
        configBuilder_.mergeFrom(value);
      }
      if (config_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Features and audio metadata to use for the Automatic Speech Recognition.
     * This field in combination with the
     * [config_mask][google.cloud.speech.v2.BatchRecognizeRequest.config_mask]
     * field can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig config = 4;</code>
     */
    public Builder clearConfig() {
      bitField0_ = (bitField0_ & ~0x00000002);
      config_ = null;
      if (configBuilder_ != null) {
        configBuilder_.dispose();
        configBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Features and audio metadata to use for the Automatic Speech Recognition.
     * This field in combination with the
     * [config_mask][google.cloud.speech.v2.BatchRecognizeRequest.config_mask]
     * field can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig config = 4;</code>
     */
    public com.google.cloud.speech.v2.RecognitionConfig.Builder getConfigBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Features and audio metadata to use for the Automatic Speech Recognition.
     * This field in combination with the
     * [config_mask][google.cloud.speech.v2.BatchRecognizeRequest.config_mask]
     * field can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig config = 4;</code>
     */
    public com.google.cloud.speech.v2.RecognitionConfigOrBuilder getConfigOrBuilder() {
      if (configBuilder_ != null) {
        return configBuilder_.getMessageOrBuilder();
      } else {
        return config_ == null
            ? com.google.cloud.speech.v2.RecognitionConfig.getDefaultInstance()
            : config_;
      }
    }

    /**
     *
     *
     * <pre>
     * Features and audio metadata to use for the Automatic Speech Recognition.
     * This field in combination with the
     * [config_mask][google.cloud.speech.v2.BatchRecognizeRequest.config_mask]
     * field can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionConfig config = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.RecognitionConfig,
            com.google.cloud.speech.v2.RecognitionConfig.Builder,
            com.google.cloud.speech.v2.RecognitionConfigOrBuilder>
        getConfigFieldBuilder() {
      if (configBuilder_ == null) {
        configBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v2.RecognitionConfig,
                com.google.cloud.speech.v2.RecognitionConfig.Builder,
                com.google.cloud.speech.v2.RecognitionConfigOrBuilder>(
                getConfig(), getParentForChildren(), isClean());
        config_ = null;
      }
      return configBuilder_;
    }

    private com.google.protobuf.FieldMask configMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        configMaskBuilder_;

    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] that override
     * the values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all given fields in
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] override the
     * values in the recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] completely
     * overrides and replaces the config in the recognizer for this recognition
     * request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 5;</code>
     *
     * @return Whether the configMask field is set.
     */
    public boolean hasConfigMask() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] that override
     * the values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all given fields in
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] override the
     * values in the recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] completely
     * overrides and replaces the config in the recognizer for this recognition
     * request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 5;</code>
     *
     * @return The configMask.
     */
    public com.google.protobuf.FieldMask getConfigMask() {
      if (configMaskBuilder_ == null) {
        return configMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : configMask_;
      } else {
        return configMaskBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] that override
     * the values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all given fields in
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] override the
     * values in the recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] completely
     * overrides and replaces the config in the recognizer for this recognition
     * request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 5;</code>
     */
    public Builder setConfigMask(com.google.protobuf.FieldMask value) {
      if (configMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        configMask_ = value;
      } else {
        configMaskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] that override
     * the values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all given fields in
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] override the
     * values in the recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] completely
     * overrides and replaces the config in the recognizer for this recognition
     * request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 5;</code>
     */
    public Builder setConfigMask(com.google.protobuf.FieldMask.Builder builderForValue) {
      if (configMaskBuilder_ == null) {
        configMask_ = builderForValue.build();
      } else {
        configMaskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] that override
     * the values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all given fields in
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] override the
     * values in the recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] completely
     * overrides and replaces the config in the recognizer for this recognition
     * request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 5;</code>
     */
    public Builder mergeConfigMask(com.google.protobuf.FieldMask value) {
      if (configMaskBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && configMask_ != null
            && configMask_ != com.google.protobuf.FieldMask.getDefaultInstance()) {
          getConfigMaskBuilder().mergeFrom(value);
        } else {
          configMask_ = value;
        }
      } else {
        configMaskBuilder_.mergeFrom(value);
      }
      if (configMask_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] that override
     * the values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all given fields in
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] override the
     * values in the recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] completely
     * overrides and replaces the config in the recognizer for this recognition
     * request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 5;</code>
     */
    public Builder clearConfigMask() {
      bitField0_ = (bitField0_ & ~0x00000004);
      configMask_ = null;
      if (configMaskBuilder_ != null) {
        configMaskBuilder_.dispose();
        configMaskBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] that override
     * the values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all given fields in
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] override the
     * values in the recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] completely
     * overrides and replaces the config in the recognizer for this recognition
     * request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 5;</code>
     */
    public com.google.protobuf.FieldMask.Builder getConfigMaskBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getConfigMaskFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] that override
     * the values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all given fields in
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] override the
     * values in the recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] completely
     * overrides and replaces the config in the recognizer for this recognition
     * request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 5;</code>
     */
    public com.google.protobuf.FieldMaskOrBuilder getConfigMaskOrBuilder() {
      if (configMaskBuilder_ != null) {
        return configMaskBuilder_.getMessageOrBuilder();
      } else {
        return configMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : configMask_;
      }
    }

    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] that override
     * the values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all given fields in
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] override the
     * values in the recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.BatchRecognizeRequest.config] completely
     * overrides and replaces the config in the recognizer for this recognition
     * request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        getConfigMaskFieldBuilder() {
      if (configMaskBuilder_ == null) {
        configMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FieldMask,
                com.google.protobuf.FieldMask.Builder,
                com.google.protobuf.FieldMaskOrBuilder>(
                getConfigMask(), getParentForChildren(), isClean());
        configMask_ = null;
      }
      return configMaskBuilder_;
    }

    private java.util.List<com.google.cloud.speech.v2.BatchRecognizeFileMetadata> files_ =
        java.util.Collections.emptyList();

    private void ensureFilesIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        files_ =
            new java.util.ArrayList<com.google.cloud.speech.v2.BatchRecognizeFileMetadata>(files_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.speech.v2.BatchRecognizeFileMetadata,
            com.google.cloud.speech.v2.BatchRecognizeFileMetadata.Builder,
            com.google.cloud.speech.v2.BatchRecognizeFileMetadataOrBuilder>
        filesBuilder_;

    /**
     *
     *
     * <pre>
     * Audio files with file metadata for ASR.
     * The maximum number of files allowed to be specified is 15.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.BatchRecognizeFileMetadata files = 3;</code>
     */
    public java.util.List<com.google.cloud.speech.v2.BatchRecognizeFileMetadata> getFilesList() {
      if (filesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(files_);
      } else {
        return filesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Audio files with file metadata for ASR.
     * The maximum number of files allowed to be specified is 15.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.BatchRecognizeFileMetadata files = 3;</code>
     */
    public int getFilesCount() {
      if (filesBuilder_ == null) {
        return files_.size();
      } else {
        return filesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Audio files with file metadata for ASR.
     * The maximum number of files allowed to be specified is 15.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.BatchRecognizeFileMetadata files = 3;</code>
     */
    public com.google.cloud.speech.v2.BatchRecognizeFileMetadata getFiles(int index) {
      if (filesBuilder_ == null) {
        return files_.get(index);
      } else {
        return filesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Audio files with file metadata for ASR.
     * The maximum number of files allowed to be specified is 15.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.BatchRecognizeFileMetadata files = 3;</code>
     */
    public Builder setFiles(
        int index, com.google.cloud.speech.v2.BatchRecognizeFileMetadata value) {
      if (filesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFilesIsMutable();
        files_.set(index, value);
        onChanged();
      } else {
        filesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Audio files with file metadata for ASR.
     * The maximum number of files allowed to be specified is 15.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.BatchRecognizeFileMetadata files = 3;</code>
     */
    public Builder setFiles(
        int index, com.google.cloud.speech.v2.BatchRecognizeFileMetadata.Builder builderForValue) {
      if (filesBuilder_ == null) {
        ensureFilesIsMutable();
        files_.set(index, builderForValue.build());
        onChanged();
      } else {
        filesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Audio files with file metadata for ASR.
     * The maximum number of files allowed to be specified is 15.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.BatchRecognizeFileMetadata files = 3;</code>
     */
    public Builder addFiles(com.google.cloud.speech.v2.BatchRecognizeFileMetadata value) {
      if (filesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFilesIsMutable();
        files_.add(value);
        onChanged();
      } else {
        filesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Audio files with file metadata for ASR.
     * The maximum number of files allowed to be specified is 15.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.BatchRecognizeFileMetadata files = 3;</code>
     */
    public Builder addFiles(
        int index, com.google.cloud.speech.v2.BatchRecognizeFileMetadata value) {
      if (filesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFilesIsMutable();
        files_.add(index, value);
        onChanged();
      } else {
        filesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Audio files with file metadata for ASR.
     * The maximum number of files allowed to be specified is 15.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.BatchRecognizeFileMetadata files = 3;</code>
     */
    public Builder addFiles(
        com.google.cloud.speech.v2.BatchRecognizeFileMetadata.Builder builderForValue) {
      if (filesBuilder_ == null) {
        ensureFilesIsMutable();
        files_.add(builderForValue.build());
        onChanged();
      } else {
        filesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Audio files with file metadata for ASR.
     * The maximum number of files allowed to be specified is 15.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.BatchRecognizeFileMetadata files = 3;</code>
     */
    public Builder addFiles(
        int index, com.google.cloud.speech.v2.BatchRecognizeFileMetadata.Builder builderForValue) {
      if (filesBuilder_ == null) {
        ensureFilesIsMutable();
        files_.add(index, builderForValue.build());
        onChanged();
      } else {
        filesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Audio files with file metadata for ASR.
     * The maximum number of files allowed to be specified is 15.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.BatchRecognizeFileMetadata files = 3;</code>
     */
    public Builder addAllFiles(
        java.lang.Iterable<? extends com.google.cloud.speech.v2.BatchRecognizeFileMetadata>
            values) {
      if (filesBuilder_ == null) {
        ensureFilesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, files_);
        onChanged();
      } else {
        filesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Audio files with file metadata for ASR.
     * The maximum number of files allowed to be specified is 15.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.BatchRecognizeFileMetadata files = 3;</code>
     */
    public Builder clearFiles() {
      if (filesBuilder_ == null) {
        files_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        filesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Audio files with file metadata for ASR.
     * The maximum number of files allowed to be specified is 15.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.BatchRecognizeFileMetadata files = 3;</code>
     */
    public Builder removeFiles(int index) {
      if (filesBuilder_ == null) {
        ensureFilesIsMutable();
        files_.remove(index);
        onChanged();
      } else {
        filesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Audio files with file metadata for ASR.
     * The maximum number of files allowed to be specified is 15.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.BatchRecognizeFileMetadata files = 3;</code>
     */
    public com.google.cloud.speech.v2.BatchRecognizeFileMetadata.Builder getFilesBuilder(
        int index) {
      return getFilesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Audio files with file metadata for ASR.
     * The maximum number of files allowed to be specified is 15.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.BatchRecognizeFileMetadata files = 3;</code>
     */
    public com.google.cloud.speech.v2.BatchRecognizeFileMetadataOrBuilder getFilesOrBuilder(
        int index) {
      if (filesBuilder_ == null) {
        return files_.get(index);
      } else {
        return filesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Audio files with file metadata for ASR.
     * The maximum number of files allowed to be specified is 15.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.BatchRecognizeFileMetadata files = 3;</code>
     */
    public java.util.List<? extends com.google.cloud.speech.v2.BatchRecognizeFileMetadataOrBuilder>
        getFilesOrBuilderList() {
      if (filesBuilder_ != null) {
        return filesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(files_);
      }
    }

    /**
     *
     *
     * <pre>
     * Audio files with file metadata for ASR.
     * The maximum number of files allowed to be specified is 15.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.BatchRecognizeFileMetadata files = 3;</code>
     */
    public com.google.cloud.speech.v2.BatchRecognizeFileMetadata.Builder addFilesBuilder() {
      return getFilesFieldBuilder()
          .addBuilder(com.google.cloud.speech.v2.BatchRecognizeFileMetadata.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Audio files with file metadata for ASR.
     * The maximum number of files allowed to be specified is 15.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.BatchRecognizeFileMetadata files = 3;</code>
     */
    public com.google.cloud.speech.v2.BatchRecognizeFileMetadata.Builder addFilesBuilder(
        int index) {
      return getFilesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.speech.v2.BatchRecognizeFileMetadata.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Audio files with file metadata for ASR.
     * The maximum number of files allowed to be specified is 15.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.BatchRecognizeFileMetadata files = 3;</code>
     */
    public java.util.List<com.google.cloud.speech.v2.BatchRecognizeFileMetadata.Builder>
        getFilesBuilderList() {
      return getFilesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.speech.v2.BatchRecognizeFileMetadata,
            com.google.cloud.speech.v2.BatchRecognizeFileMetadata.Builder,
            com.google.cloud.speech.v2.BatchRecognizeFileMetadataOrBuilder>
        getFilesFieldBuilder() {
      if (filesBuilder_ == null) {
        filesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.speech.v2.BatchRecognizeFileMetadata,
                com.google.cloud.speech.v2.BatchRecognizeFileMetadata.Builder,
                com.google.cloud.speech.v2.BatchRecognizeFileMetadataOrBuilder>(
                files_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        files_ = null;
      }
      return filesBuilder_;
    }

    private com.google.cloud.speech.v2.RecognitionOutputConfig recognitionOutputConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.RecognitionOutputConfig,
            com.google.cloud.speech.v2.RecognitionOutputConfig.Builder,
            com.google.cloud.speech.v2.RecognitionOutputConfigOrBuilder>
        recognitionOutputConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Configuration options for where to output the transcripts of each file.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionOutputConfig recognition_output_config = 6;</code>
     *
     * @return Whether the recognitionOutputConfig field is set.
     */
    public boolean hasRecognitionOutputConfig() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Configuration options for where to output the transcripts of each file.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionOutputConfig recognition_output_config = 6;</code>
     *
     * @return The recognitionOutputConfig.
     */
    public com.google.cloud.speech.v2.RecognitionOutputConfig getRecognitionOutputConfig() {
      if (recognitionOutputConfigBuilder_ == null) {
        return recognitionOutputConfig_ == null
            ? com.google.cloud.speech.v2.RecognitionOutputConfig.getDefaultInstance()
            : recognitionOutputConfig_;
      } else {
        return recognitionOutputConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Configuration options for where to output the transcripts of each file.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionOutputConfig recognition_output_config = 6;</code>
     */
    public Builder setRecognitionOutputConfig(
        com.google.cloud.speech.v2.RecognitionOutputConfig value) {
      if (recognitionOutputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        recognitionOutputConfig_ = value;
      } else {
        recognitionOutputConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configuration options for where to output the transcripts of each file.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionOutputConfig recognition_output_config = 6;</code>
     */
    public Builder setRecognitionOutputConfig(
        com.google.cloud.speech.v2.RecognitionOutputConfig.Builder builderForValue) {
      if (recognitionOutputConfigBuilder_ == null) {
        recognitionOutputConfig_ = builderForValue.build();
      } else {
        recognitionOutputConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configuration options for where to output the transcripts of each file.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionOutputConfig recognition_output_config = 6;</code>
     */
    public Builder mergeRecognitionOutputConfig(
        com.google.cloud.speech.v2.RecognitionOutputConfig value) {
      if (recognitionOutputConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && recognitionOutputConfig_ != null
            && recognitionOutputConfig_
                != com.google.cloud.speech.v2.RecognitionOutputConfig.getDefaultInstance()) {
          getRecognitionOutputConfigBuilder().mergeFrom(value);
        } else {
          recognitionOutputConfig_ = value;
        }
      } else {
        recognitionOutputConfigBuilder_.mergeFrom(value);
      }
      if (recognitionOutputConfig_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configuration options for where to output the transcripts of each file.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionOutputConfig recognition_output_config = 6;</code>
     */
    public Builder clearRecognitionOutputConfig() {
      bitField0_ = (bitField0_ & ~0x00000010);
      recognitionOutputConfig_ = null;
      if (recognitionOutputConfigBuilder_ != null) {
        recognitionOutputConfigBuilder_.dispose();
        recognitionOutputConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configuration options for where to output the transcripts of each file.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionOutputConfig recognition_output_config = 6;</code>
     */
    public com.google.cloud.speech.v2.RecognitionOutputConfig.Builder
        getRecognitionOutputConfigBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getRecognitionOutputConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Configuration options for where to output the transcripts of each file.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionOutputConfig recognition_output_config = 6;</code>
     */
    public com.google.cloud.speech.v2.RecognitionOutputConfigOrBuilder
        getRecognitionOutputConfigOrBuilder() {
      if (recognitionOutputConfigBuilder_ != null) {
        return recognitionOutputConfigBuilder_.getMessageOrBuilder();
      } else {
        return recognitionOutputConfig_ == null
            ? com.google.cloud.speech.v2.RecognitionOutputConfig.getDefaultInstance()
            : recognitionOutputConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Configuration options for where to output the transcripts of each file.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionOutputConfig recognition_output_config = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.RecognitionOutputConfig,
            com.google.cloud.speech.v2.RecognitionOutputConfig.Builder,
            com.google.cloud.speech.v2.RecognitionOutputConfigOrBuilder>
        getRecognitionOutputConfigFieldBuilder() {
      if (recognitionOutputConfigBuilder_ == null) {
        recognitionOutputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v2.RecognitionOutputConfig,
                com.google.cloud.speech.v2.RecognitionOutputConfig.Builder,
                com.google.cloud.speech.v2.RecognitionOutputConfigOrBuilder>(
                getRecognitionOutputConfig(), getParentForChildren(), isClean());
        recognitionOutputConfig_ = null;
      }
      return recognitionOutputConfigBuilder_;
    }

    private int processingStrategy_ = 0;

    /**
     *
     *
     * <pre>
     * Processing strategy to use for this request.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.BatchRecognizeRequest.ProcessingStrategy processing_strategy = 7;
     * </code>
     *
     * @return The enum numeric value on the wire for processingStrategy.
     */
    @java.lang.Override
    public int getProcessingStrategyValue() {
      return processingStrategy_;
    }

    /**
     *
     *
     * <pre>
     * Processing strategy to use for this request.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.BatchRecognizeRequest.ProcessingStrategy processing_strategy = 7;
     * </code>
     *
     * @param value The enum numeric value on the wire for processingStrategy to set.
     * @return This builder for chaining.
     */
    public Builder setProcessingStrategyValue(int value) {
      processingStrategy_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Processing strategy to use for this request.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.BatchRecognizeRequest.ProcessingStrategy processing_strategy = 7;
     * </code>
     *
     * @return The processingStrategy.
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.BatchRecognizeRequest.ProcessingStrategy
        getProcessingStrategy() {
      com.google.cloud.speech.v2.BatchRecognizeRequest.ProcessingStrategy result =
          com.google.cloud.speech.v2.BatchRecognizeRequest.ProcessingStrategy.forNumber(
              processingStrategy_);
      return result == null
          ? com.google.cloud.speech.v2.BatchRecognizeRequest.ProcessingStrategy.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Processing strategy to use for this request.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.BatchRecognizeRequest.ProcessingStrategy processing_strategy = 7;
     * </code>
     *
     * @param value The processingStrategy to set.
     * @return This builder for chaining.
     */
    public Builder setProcessingStrategy(
        com.google.cloud.speech.v2.BatchRecognizeRequest.ProcessingStrategy value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      processingStrategy_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Processing strategy to use for this request.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.BatchRecognizeRequest.ProcessingStrategy processing_strategy = 7;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProcessingStrategy() {
      bitField0_ = (bitField0_ & ~0x00000020);
      processingStrategy_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.speech.v2.BatchRecognizeRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.speech.v2.BatchRecognizeRequest)
  private static final com.google.cloud.speech.v2.BatchRecognizeRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.speech.v2.BatchRecognizeRequest();
  }

  public static com.google.cloud.speech.v2.BatchRecognizeRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchRecognizeRequest> PARSER =
      new com.google.protobuf.AbstractParser<BatchRecognizeRequest>() {
        @java.lang.Override
        public BatchRecognizeRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BatchRecognizeRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchRecognizeRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.speech.v2.BatchRecognizeRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
