/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/speech/v2/cloud_speech.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.speech.v2;

/**
 *
 *
 * <pre>
 * Provides configuration information for the StreamingRecognize request.
 * </pre>
 *
 * Protobuf type {@code google.cloud.speech.v2.StreamingRecognitionConfig}
 */
public final class StreamingRecognitionConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.speech.v2.StreamingRecognitionConfig)
    StreamingRecognitionConfigOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use StreamingRecognitionConfig.newBuilder() to construct.
  private StreamingRecognitionConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StreamingRecognitionConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StreamingRecognitionConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.speech.v2.CloudSpeechProto
        .internal_static_google_cloud_speech_v2_StreamingRecognitionConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.speech.v2.CloudSpeechProto
        .internal_static_google_cloud_speech_v2_StreamingRecognitionConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.speech.v2.StreamingRecognitionConfig.class,
            com.google.cloud.speech.v2.StreamingRecognitionConfig.Builder.class);
  }

  private int bitField0_;
  public static final int CONFIG_FIELD_NUMBER = 1;
  private com.google.cloud.speech.v2.RecognitionConfig config_;

  /**
   *
   *
   * <pre>
   * Required. Features and audio metadata to use for the Automatic Speech
   * Recognition. This field in combination with the
   * [config_mask][google.cloud.speech.v2.StreamingRecognitionConfig.config_mask]
   * field can be used to override parts of the
   * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
   * of the Recognizer resource.
   * </pre>
   *
   * <code>
   * .google.cloud.speech.v2.RecognitionConfig config = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the config field is set.
   */
  @java.lang.Override
  public boolean hasConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. Features and audio metadata to use for the Automatic Speech
   * Recognition. This field in combination with the
   * [config_mask][google.cloud.speech.v2.StreamingRecognitionConfig.config_mask]
   * field can be used to override parts of the
   * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
   * of the Recognizer resource.
   * </pre>
   *
   * <code>
   * .google.cloud.speech.v2.RecognitionConfig config = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The config.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.RecognitionConfig getConfig() {
    return config_ == null
        ? com.google.cloud.speech.v2.RecognitionConfig.getDefaultInstance()
        : config_;
  }

  /**
   *
   *
   * <pre>
   * Required. Features and audio metadata to use for the Automatic Speech
   * Recognition. This field in combination with the
   * [config_mask][google.cloud.speech.v2.StreamingRecognitionConfig.config_mask]
   * field can be used to override parts of the
   * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
   * of the Recognizer resource.
   * </pre>
   *
   * <code>
   * .google.cloud.speech.v2.RecognitionConfig config = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.RecognitionConfigOrBuilder getConfigOrBuilder() {
    return config_ == null
        ? com.google.cloud.speech.v2.RecognitionConfig.getDefaultInstance()
        : config_;
  }

  public static final int CONFIG_MASK_FIELD_NUMBER = 3;
  private com.google.protobuf.FieldMask configMask_;

  /**
   *
   *
   * <pre>
   * The list of fields in
   * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config] that
   * override the values in the
   * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
   * of the recognizer during this recognition request. If no mask is provided,
   * all non-default valued fields in
   * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config] override
   * the values in the Recognizer for this recognition request. If a mask is
   * provided, only the fields listed in the mask override the config in the
   * Recognizer for this recognition request. If a wildcard (`*`) is provided,
   * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config]
   * completely overrides and replaces the config in the recognizer for this
   * recognition request.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask config_mask = 3;</code>
   *
   * @return Whether the configMask field is set.
   */
  @java.lang.Override
  public boolean hasConfigMask() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The list of fields in
   * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config] that
   * override the values in the
   * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
   * of the recognizer during this recognition request. If no mask is provided,
   * all non-default valued fields in
   * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config] override
   * the values in the Recognizer for this recognition request. If a mask is
   * provided, only the fields listed in the mask override the config in the
   * Recognizer for this recognition request. If a wildcard (`*`) is provided,
   * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config]
   * completely overrides and replaces the config in the recognizer for this
   * recognition request.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask config_mask = 3;</code>
   *
   * @return The configMask.
   */
  @java.lang.Override
  public com.google.protobuf.FieldMask getConfigMask() {
    return configMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : configMask_;
  }

  /**
   *
   *
   * <pre>
   * The list of fields in
   * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config] that
   * override the values in the
   * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
   * of the recognizer during this recognition request. If no mask is provided,
   * all non-default valued fields in
   * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config] override
   * the values in the Recognizer for this recognition request. If a mask is
   * provided, only the fields listed in the mask override the config in the
   * Recognizer for this recognition request. If a wildcard (`*`) is provided,
   * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config]
   * completely overrides and replaces the config in the recognizer for this
   * recognition request.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask config_mask = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.FieldMaskOrBuilder getConfigMaskOrBuilder() {
    return configMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : configMask_;
  }

  public static final int STREAMING_FEATURES_FIELD_NUMBER = 2;
  private com.google.cloud.speech.v2.StreamingRecognitionFeatures streamingFeatures_;

  /**
   *
   *
   * <pre>
   * Speech recognition features to enable specific to streaming audio
   * recognition requests.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.StreamingRecognitionFeatures streaming_features = 2;</code>
   *
   * @return Whether the streamingFeatures field is set.
   */
  @java.lang.Override
  public boolean hasStreamingFeatures() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Speech recognition features to enable specific to streaming audio
   * recognition requests.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.StreamingRecognitionFeatures streaming_features = 2;</code>
   *
   * @return The streamingFeatures.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.StreamingRecognitionFeatures getStreamingFeatures() {
    return streamingFeatures_ == null
        ? com.google.cloud.speech.v2.StreamingRecognitionFeatures.getDefaultInstance()
        : streamingFeatures_;
  }

  /**
   *
   *
   * <pre>
   * Speech recognition features to enable specific to streaming audio
   * recognition requests.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.StreamingRecognitionFeatures streaming_features = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.StreamingRecognitionFeaturesOrBuilder
      getStreamingFeaturesOrBuilder() {
    return streamingFeatures_ == null
        ? com.google.cloud.speech.v2.StreamingRecognitionFeatures.getDefaultInstance()
        : streamingFeatures_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(2, getStreamingFeatures());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getConfigMask());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getStreamingFeatures());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getConfigMask());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.speech.v2.StreamingRecognitionConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.speech.v2.StreamingRecognitionConfig other =
        (com.google.cloud.speech.v2.StreamingRecognitionConfig) obj;

    if (hasConfig() != other.hasConfig()) return false;
    if (hasConfig()) {
      if (!getConfig().equals(other.getConfig())) return false;
    }
    if (hasConfigMask() != other.hasConfigMask()) return false;
    if (hasConfigMask()) {
      if (!getConfigMask().equals(other.getConfigMask())) return false;
    }
    if (hasStreamingFeatures() != other.hasStreamingFeatures()) return false;
    if (hasStreamingFeatures()) {
      if (!getStreamingFeatures().equals(other.getStreamingFeatures())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasConfig()) {
      hash = (37 * hash) + CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getConfig().hashCode();
    }
    if (hasConfigMask()) {
      hash = (37 * hash) + CONFIG_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getConfigMask().hashCode();
    }
    if (hasStreamingFeatures()) {
      hash = (37 * hash) + STREAMING_FEATURES_FIELD_NUMBER;
      hash = (53 * hash) + getStreamingFeatures().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.speech.v2.StreamingRecognitionConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.StreamingRecognitionConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.StreamingRecognitionConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.StreamingRecognitionConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.StreamingRecognitionConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.StreamingRecognitionConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.StreamingRecognitionConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.StreamingRecognitionConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.StreamingRecognitionConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.StreamingRecognitionConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.StreamingRecognitionConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.StreamingRecognitionConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.speech.v2.StreamingRecognitionConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Provides configuration information for the StreamingRecognize request.
   * </pre>
   *
   * Protobuf type {@code google.cloud.speech.v2.StreamingRecognitionConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.speech.v2.StreamingRecognitionConfig)
      com.google.cloud.speech.v2.StreamingRecognitionConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_StreamingRecognitionConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_StreamingRecognitionConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.speech.v2.StreamingRecognitionConfig.class,
              com.google.cloud.speech.v2.StreamingRecognitionConfig.Builder.class);
    }

    // Construct using com.google.cloud.speech.v2.StreamingRecognitionConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getConfigFieldBuilder();
        getConfigMaskFieldBuilder();
        getStreamingFeaturesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      config_ = null;
      if (configBuilder_ != null) {
        configBuilder_.dispose();
        configBuilder_ = null;
      }
      configMask_ = null;
      if (configMaskBuilder_ != null) {
        configMaskBuilder_.dispose();
        configMaskBuilder_ = null;
      }
      streamingFeatures_ = null;
      if (streamingFeaturesBuilder_ != null) {
        streamingFeaturesBuilder_.dispose();
        streamingFeaturesBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_StreamingRecognitionConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.StreamingRecognitionConfig getDefaultInstanceForType() {
      return com.google.cloud.speech.v2.StreamingRecognitionConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.StreamingRecognitionConfig build() {
      com.google.cloud.speech.v2.StreamingRecognitionConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.StreamingRecognitionConfig buildPartial() {
      com.google.cloud.speech.v2.StreamingRecognitionConfig result =
          new com.google.cloud.speech.v2.StreamingRecognitionConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.speech.v2.StreamingRecognitionConfig result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.config_ = configBuilder_ == null ? config_ : configBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.configMask_ = configMaskBuilder_ == null ? configMask_ : configMaskBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.streamingFeatures_ =
            streamingFeaturesBuilder_ == null
                ? streamingFeatures_
                : streamingFeaturesBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.speech.v2.StreamingRecognitionConfig) {
        return mergeFrom((com.google.cloud.speech.v2.StreamingRecognitionConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.speech.v2.StreamingRecognitionConfig other) {
      if (other == com.google.cloud.speech.v2.StreamingRecognitionConfig.getDefaultInstance())
        return this;
      if (other.hasConfig()) {
        mergeConfig(other.getConfig());
      }
      if (other.hasConfigMask()) {
        mergeConfigMask(other.getConfigMask());
      }
      if (other.hasStreamingFeatures()) {
        mergeStreamingFeatures(other.getStreamingFeatures());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getStreamingFeaturesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getConfigMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.speech.v2.RecognitionConfig config_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.RecognitionConfig,
            com.google.cloud.speech.v2.RecognitionConfig.Builder,
            com.google.cloud.speech.v2.RecognitionConfigOrBuilder>
        configBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Features and audio metadata to use for the Automatic Speech
     * Recognition. This field in combination with the
     * [config_mask][google.cloud.speech.v2.StreamingRecognitionConfig.config_mask]
     * field can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.RecognitionConfig config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the config field is set.
     */
    public boolean hasConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. Features and audio metadata to use for the Automatic Speech
     * Recognition. This field in combination with the
     * [config_mask][google.cloud.speech.v2.StreamingRecognitionConfig.config_mask]
     * field can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.RecognitionConfig config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The config.
     */
    public com.google.cloud.speech.v2.RecognitionConfig getConfig() {
      if (configBuilder_ == null) {
        return config_ == null
            ? com.google.cloud.speech.v2.RecognitionConfig.getDefaultInstance()
            : config_;
      } else {
        return configBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Features and audio metadata to use for the Automatic Speech
     * Recognition. This field in combination with the
     * [config_mask][google.cloud.speech.v2.StreamingRecognitionConfig.config_mask]
     * field can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.RecognitionConfig config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setConfig(com.google.cloud.speech.v2.RecognitionConfig value) {
      if (configBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        config_ = value;
      } else {
        configBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Features and audio metadata to use for the Automatic Speech
     * Recognition. This field in combination with the
     * [config_mask][google.cloud.speech.v2.StreamingRecognitionConfig.config_mask]
     * field can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.RecognitionConfig config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setConfig(com.google.cloud.speech.v2.RecognitionConfig.Builder builderForValue) {
      if (configBuilder_ == null) {
        config_ = builderForValue.build();
      } else {
        configBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Features and audio metadata to use for the Automatic Speech
     * Recognition. This field in combination with the
     * [config_mask][google.cloud.speech.v2.StreamingRecognitionConfig.config_mask]
     * field can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.RecognitionConfig config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeConfig(com.google.cloud.speech.v2.RecognitionConfig value) {
      if (configBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && config_ != null
            && config_ != com.google.cloud.speech.v2.RecognitionConfig.getDefaultInstance()) {
          getConfigBuilder().mergeFrom(value);
        } else {
          config_ = value;
        }
      } else {
        configBuilder_.mergeFrom(value);
      }
      if (config_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Features and audio metadata to use for the Automatic Speech
     * Recognition. This field in combination with the
     * [config_mask][google.cloud.speech.v2.StreamingRecognitionConfig.config_mask]
     * field can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.RecognitionConfig config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearConfig() {
      bitField0_ = (bitField0_ & ~0x00000001);
      config_ = null;
      if (configBuilder_ != null) {
        configBuilder_.dispose();
        configBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Features and audio metadata to use for the Automatic Speech
     * Recognition. This field in combination with the
     * [config_mask][google.cloud.speech.v2.StreamingRecognitionConfig.config_mask]
     * field can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.RecognitionConfig config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.speech.v2.RecognitionConfig.Builder getConfigBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. Features and audio metadata to use for the Automatic Speech
     * Recognition. This field in combination with the
     * [config_mask][google.cloud.speech.v2.StreamingRecognitionConfig.config_mask]
     * field can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.RecognitionConfig config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.speech.v2.RecognitionConfigOrBuilder getConfigOrBuilder() {
      if (configBuilder_ != null) {
        return configBuilder_.getMessageOrBuilder();
      } else {
        return config_ == null
            ? com.google.cloud.speech.v2.RecognitionConfig.getDefaultInstance()
            : config_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Features and audio metadata to use for the Automatic Speech
     * Recognition. This field in combination with the
     * [config_mask][google.cloud.speech.v2.StreamingRecognitionConfig.config_mask]
     * field can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.RecognitionConfig config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.RecognitionConfig,
            com.google.cloud.speech.v2.RecognitionConfig.Builder,
            com.google.cloud.speech.v2.RecognitionConfigOrBuilder>
        getConfigFieldBuilder() {
      if (configBuilder_ == null) {
        configBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v2.RecognitionConfig,
                com.google.cloud.speech.v2.RecognitionConfig.Builder,
                com.google.cloud.speech.v2.RecognitionConfigOrBuilder>(
                getConfig(), getParentForChildren(), isClean());
        config_ = null;
      }
      return configBuilder_;
    }

    private com.google.protobuf.FieldMask configMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        configMaskBuilder_;

    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config] that
     * override the values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all non-default valued fields in
     * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config] override
     * the values in the Recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * Recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config]
     * completely overrides and replaces the config in the recognizer for this
     * recognition request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 3;</code>
     *
     * @return Whether the configMask field is set.
     */
    public boolean hasConfigMask() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config] that
     * override the values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all non-default valued fields in
     * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config] override
     * the values in the Recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * Recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config]
     * completely overrides and replaces the config in the recognizer for this
     * recognition request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 3;</code>
     *
     * @return The configMask.
     */
    public com.google.protobuf.FieldMask getConfigMask() {
      if (configMaskBuilder_ == null) {
        return configMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : configMask_;
      } else {
        return configMaskBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config] that
     * override the values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all non-default valued fields in
     * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config] override
     * the values in the Recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * Recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config]
     * completely overrides and replaces the config in the recognizer for this
     * recognition request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 3;</code>
     */
    public Builder setConfigMask(com.google.protobuf.FieldMask value) {
      if (configMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        configMask_ = value;
      } else {
        configMaskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config] that
     * override the values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all non-default valued fields in
     * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config] override
     * the values in the Recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * Recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config]
     * completely overrides and replaces the config in the recognizer for this
     * recognition request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 3;</code>
     */
    public Builder setConfigMask(com.google.protobuf.FieldMask.Builder builderForValue) {
      if (configMaskBuilder_ == null) {
        configMask_ = builderForValue.build();
      } else {
        configMaskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config] that
     * override the values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all non-default valued fields in
     * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config] override
     * the values in the Recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * Recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config]
     * completely overrides and replaces the config in the recognizer for this
     * recognition request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 3;</code>
     */
    public Builder mergeConfigMask(com.google.protobuf.FieldMask value) {
      if (configMaskBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && configMask_ != null
            && configMask_ != com.google.protobuf.FieldMask.getDefaultInstance()) {
          getConfigMaskBuilder().mergeFrom(value);
        } else {
          configMask_ = value;
        }
      } else {
        configMaskBuilder_.mergeFrom(value);
      }
      if (configMask_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config] that
     * override the values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all non-default valued fields in
     * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config] override
     * the values in the Recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * Recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config]
     * completely overrides and replaces the config in the recognizer for this
     * recognition request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 3;</code>
     */
    public Builder clearConfigMask() {
      bitField0_ = (bitField0_ & ~0x00000002);
      configMask_ = null;
      if (configMaskBuilder_ != null) {
        configMaskBuilder_.dispose();
        configMaskBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config] that
     * override the values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all non-default valued fields in
     * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config] override
     * the values in the Recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * Recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config]
     * completely overrides and replaces the config in the recognizer for this
     * recognition request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 3;</code>
     */
    public com.google.protobuf.FieldMask.Builder getConfigMaskBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getConfigMaskFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config] that
     * override the values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all non-default valued fields in
     * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config] override
     * the values in the Recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * Recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config]
     * completely overrides and replaces the config in the recognizer for this
     * recognition request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 3;</code>
     */
    public com.google.protobuf.FieldMaskOrBuilder getConfigMaskOrBuilder() {
      if (configMaskBuilder_ != null) {
        return configMaskBuilder_.getMessageOrBuilder();
      } else {
        return configMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : configMask_;
      }
    }

    /**
     *
     *
     * <pre>
     * The list of fields in
     * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config] that
     * override the values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all non-default valued fields in
     * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config] override
     * the values in the Recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * Recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.StreamingRecognitionConfig.config]
     * completely overrides and replaces the config in the recognizer for this
     * recognition request.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask config_mask = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        getConfigMaskFieldBuilder() {
      if (configMaskBuilder_ == null) {
        configMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FieldMask,
                com.google.protobuf.FieldMask.Builder,
                com.google.protobuf.FieldMaskOrBuilder>(
                getConfigMask(), getParentForChildren(), isClean());
        configMask_ = null;
      }
      return configMaskBuilder_;
    }

    private com.google.cloud.speech.v2.StreamingRecognitionFeatures streamingFeatures_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.StreamingRecognitionFeatures,
            com.google.cloud.speech.v2.StreamingRecognitionFeatures.Builder,
            com.google.cloud.speech.v2.StreamingRecognitionFeaturesOrBuilder>
        streamingFeaturesBuilder_;

    /**
     *
     *
     * <pre>
     * Speech recognition features to enable specific to streaming audio
     * recognition requests.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.StreamingRecognitionFeatures streaming_features = 2;</code>
     *
     * @return Whether the streamingFeatures field is set.
     */
    public boolean hasStreamingFeatures() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Speech recognition features to enable specific to streaming audio
     * recognition requests.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.StreamingRecognitionFeatures streaming_features = 2;</code>
     *
     * @return The streamingFeatures.
     */
    public com.google.cloud.speech.v2.StreamingRecognitionFeatures getStreamingFeatures() {
      if (streamingFeaturesBuilder_ == null) {
        return streamingFeatures_ == null
            ? com.google.cloud.speech.v2.StreamingRecognitionFeatures.getDefaultInstance()
            : streamingFeatures_;
      } else {
        return streamingFeaturesBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Speech recognition features to enable specific to streaming audio
     * recognition requests.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.StreamingRecognitionFeatures streaming_features = 2;</code>
     */
    public Builder setStreamingFeatures(
        com.google.cloud.speech.v2.StreamingRecognitionFeatures value) {
      if (streamingFeaturesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        streamingFeatures_ = value;
      } else {
        streamingFeaturesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Speech recognition features to enable specific to streaming audio
     * recognition requests.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.StreamingRecognitionFeatures streaming_features = 2;</code>
     */
    public Builder setStreamingFeatures(
        com.google.cloud.speech.v2.StreamingRecognitionFeatures.Builder builderForValue) {
      if (streamingFeaturesBuilder_ == null) {
        streamingFeatures_ = builderForValue.build();
      } else {
        streamingFeaturesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Speech recognition features to enable specific to streaming audio
     * recognition requests.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.StreamingRecognitionFeatures streaming_features = 2;</code>
     */
    public Builder mergeStreamingFeatures(
        com.google.cloud.speech.v2.StreamingRecognitionFeatures value) {
      if (streamingFeaturesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && streamingFeatures_ != null
            && streamingFeatures_
                != com.google.cloud.speech.v2.StreamingRecognitionFeatures.getDefaultInstance()) {
          getStreamingFeaturesBuilder().mergeFrom(value);
        } else {
          streamingFeatures_ = value;
        }
      } else {
        streamingFeaturesBuilder_.mergeFrom(value);
      }
      if (streamingFeatures_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Speech recognition features to enable specific to streaming audio
     * recognition requests.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.StreamingRecognitionFeatures streaming_features = 2;</code>
     */
    public Builder clearStreamingFeatures() {
      bitField0_ = (bitField0_ & ~0x00000004);
      streamingFeatures_ = null;
      if (streamingFeaturesBuilder_ != null) {
        streamingFeaturesBuilder_.dispose();
        streamingFeaturesBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Speech recognition features to enable specific to streaming audio
     * recognition requests.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.StreamingRecognitionFeatures streaming_features = 2;</code>
     */
    public com.google.cloud.speech.v2.StreamingRecognitionFeatures.Builder
        getStreamingFeaturesBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getStreamingFeaturesFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Speech recognition features to enable specific to streaming audio
     * recognition requests.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.StreamingRecognitionFeatures streaming_features = 2;</code>
     */
    public com.google.cloud.speech.v2.StreamingRecognitionFeaturesOrBuilder
        getStreamingFeaturesOrBuilder() {
      if (streamingFeaturesBuilder_ != null) {
        return streamingFeaturesBuilder_.getMessageOrBuilder();
      } else {
        return streamingFeatures_ == null
            ? com.google.cloud.speech.v2.StreamingRecognitionFeatures.getDefaultInstance()
            : streamingFeatures_;
      }
    }

    /**
     *
     *
     * <pre>
     * Speech recognition features to enable specific to streaming audio
     * recognition requests.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.StreamingRecognitionFeatures streaming_features = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.StreamingRecognitionFeatures,
            com.google.cloud.speech.v2.StreamingRecognitionFeatures.Builder,
            com.google.cloud.speech.v2.StreamingRecognitionFeaturesOrBuilder>
        getStreamingFeaturesFieldBuilder() {
      if (streamingFeaturesBuilder_ == null) {
        streamingFeaturesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v2.StreamingRecognitionFeatures,
                com.google.cloud.speech.v2.StreamingRecognitionFeatures.Builder,
                com.google.cloud.speech.v2.StreamingRecognitionFeaturesOrBuilder>(
                getStreamingFeatures(), getParentForChildren(), isClean());
        streamingFeatures_ = null;
      }
      return streamingFeaturesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.speech.v2.StreamingRecognitionConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.speech.v2.StreamingRecognitionConfig)
  private static final com.google.cloud.speech.v2.StreamingRecognitionConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.speech.v2.StreamingRecognitionConfig();
  }

  public static com.google.cloud.speech.v2.StreamingRecognitionConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StreamingRecognitionConfig> PARSER =
      new com.google.protobuf.AbstractParser<StreamingRecognitionConfig>() {
        @java.lang.Override
        public StreamingRecognitionConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StreamingRecognitionConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StreamingRecognitionConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.speech.v2.StreamingRecognitionConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
