/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/control/v2/storage_control.proto

// Protobuf Java Version: 3.25.5
package com.google.storage.control.v2;

/**
 *
 *
 * <pre>
 * Request message for ListFolders. This operation is only applicable to a
 * hierarchical namespace enabled bucket.
 * </pre>
 *
 * Protobuf type {@code google.storage.control.v2.ListFoldersRequest}
 */
public final class ListFoldersRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.storage.control.v2.ListFoldersRequest)
    ListFoldersRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListFoldersRequest.newBuilder() to construct.
  private ListFoldersRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListFoldersRequest() {
    parent_ = "";
    pageToken_ = "";
    prefix_ = "";
    delimiter_ = "";
    lexicographicStart_ = "";
    lexicographicEnd_ = "";
    requestId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListFoldersRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.storage.control.v2.StorageControlProto
        .internal_static_google_storage_control_v2_ListFoldersRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.storage.control.v2.StorageControlProto
        .internal_static_google_storage_control_v2_ListFoldersRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.storage.control.v2.ListFoldersRequest.class,
            com.google.storage.control.v2.ListFoldersRequest.Builder.class);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. Name of the bucket in which to look for folders. The bucket must
   * be a hierarchical namespace enabled bucket.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Name of the bucket in which to look for folders. The bucket must
   * be a hierarchical namespace enabled bucket.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 2;
  private int pageSize_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Maximum number of folders to return in a single response. The
   * service will use this parameter or 1,000 items, whichever is smaller.
   * </pre>
   *
   * <code>int32 page_size = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pageSize.
   */
  @java.lang.Override
  public int getPageSize() {
    return pageSize_;
  }

  public static final int PAGE_TOKEN_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pageToken_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A previously-returned page token representing part of the larger
   * set of results to view.
   * </pre>
   *
   * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pageToken.
   */
  @java.lang.Override
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A previously-returned page token representing part of the larger
   * set of results to view.
   * </pre>
   *
   * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for pageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PREFIX_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object prefix_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Filter results to folders whose names begin with this prefix.
   * If set, the value must either be an empty string or end with a '/'.
   * </pre>
   *
   * <code>string prefix = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The prefix.
   */
  @java.lang.Override
  public java.lang.String getPrefix() {
    java.lang.Object ref = prefix_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      prefix_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Filter results to folders whose names begin with this prefix.
   * If set, the value must either be an empty string or end with a '/'.
   * </pre>
   *
   * <code>string prefix = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for prefix.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPrefixBytes() {
    java.lang.Object ref = prefix_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      prefix_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DELIMITER_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object delimiter_ = "";
  /**
   *
   *
   * <pre>
   * Optional. If set, returns results in a directory-like mode. The results
   * will only include folders that either exactly match the above prefix, or
   * are one level below the prefix. The only supported value is '/'.
   * </pre>
   *
   * <code>string delimiter = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The delimiter.
   */
  @java.lang.Override
  public java.lang.String getDelimiter() {
    java.lang.Object ref = delimiter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      delimiter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. If set, returns results in a directory-like mode. The results
   * will only include folders that either exactly match the above prefix, or
   * are one level below the prefix. The only supported value is '/'.
   * </pre>
   *
   * <code>string delimiter = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for delimiter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDelimiterBytes() {
    java.lang.Object ref = delimiter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      delimiter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LEXICOGRAPHIC_START_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object lexicographicStart_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Filter results to folders whose names are lexicographically equal
   * to or after lexicographic_start. If lexicographic_end is also set, the
   * folders listed have names between lexicographic_start (inclusive) and
   * lexicographic_end (exclusive).
   * </pre>
   *
   * <code>string lexicographic_start = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The lexicographicStart.
   */
  @java.lang.Override
  public java.lang.String getLexicographicStart() {
    java.lang.Object ref = lexicographicStart_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      lexicographicStart_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Filter results to folders whose names are lexicographically equal
   * to or after lexicographic_start. If lexicographic_end is also set, the
   * folders listed have names between lexicographic_start (inclusive) and
   * lexicographic_end (exclusive).
   * </pre>
   *
   * <code>string lexicographic_start = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for lexicographicStart.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLexicographicStartBytes() {
    java.lang.Object ref = lexicographicStart_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      lexicographicStart_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LEXICOGRAPHIC_END_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object lexicographicEnd_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Filter results to folders whose names are lexicographically
   * before lexicographic_end. If lexicographic_start is also set, the folders
   * listed have names between lexicographic_start (inclusive) and
   * lexicographic_end (exclusive).
   * </pre>
   *
   * <code>string lexicographic_end = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The lexicographicEnd.
   */
  @java.lang.Override
  public java.lang.String getLexicographicEnd() {
    java.lang.Object ref = lexicographicEnd_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      lexicographicEnd_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Filter results to folders whose names are lexicographically
   * before lexicographic_end. If lexicographic_start is also set, the folders
   * listed have names between lexicographic_start (inclusive) and
   * lexicographic_end (exclusive).
   * </pre>
   *
   * <code>string lexicographic_end = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for lexicographicEnd.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLexicographicEndBytes() {
    java.lang.Object ref = lexicographicEnd_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      lexicographicEnd_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REQUEST_ID_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A unique identifier for this request. UUID is the recommended
   * format, but other formats are still accepted.
   * </pre>
   *
   * <code>
   * string request_id = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
   * </code>
   *
   * @return The requestId.
   */
  @java.lang.Override
  public java.lang.String getRequestId() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A unique identifier for this request. UUID is the recommended
   * format, but other formats are still accepted.
   * </pre>
   *
   * <code>
   * string request_id = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
   * </code>
   *
   * @return The bytes for requestId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestIdBytes() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (pageSize_ != 0) {
      output.writeInt32(2, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, pageToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(prefix_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, prefix_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lexicographicStart_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, lexicographicStart_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lexicographicEnd_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, lexicographicEnd_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(delimiter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, delimiter_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, requestId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, pageToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(prefix_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, prefix_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lexicographicStart_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, lexicographicStart_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lexicographicEnd_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, lexicographicEnd_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(delimiter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, delimiter_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, requestId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.storage.control.v2.ListFoldersRequest)) {
      return super.equals(obj);
    }
    com.google.storage.control.v2.ListFoldersRequest other =
        (com.google.storage.control.v2.ListFoldersRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (getPageSize() != other.getPageSize()) return false;
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (!getPrefix().equals(other.getPrefix())) return false;
    if (!getDelimiter().equals(other.getDelimiter())) return false;
    if (!getLexicographicStart().equals(other.getLexicographicStart())) return false;
    if (!getLexicographicEnd().equals(other.getLexicographicEnd())) return false;
    if (!getRequestId().equals(other.getRequestId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    hash = (37 * hash) + PREFIX_FIELD_NUMBER;
    hash = (53 * hash) + getPrefix().hashCode();
    hash = (37 * hash) + DELIMITER_FIELD_NUMBER;
    hash = (53 * hash) + getDelimiter().hashCode();
    hash = (37 * hash) + LEXICOGRAPHIC_START_FIELD_NUMBER;
    hash = (53 * hash) + getLexicographicStart().hashCode();
    hash = (37 * hash) + LEXICOGRAPHIC_END_FIELD_NUMBER;
    hash = (53 * hash) + getLexicographicEnd().hashCode();
    hash = (37 * hash) + REQUEST_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRequestId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.storage.control.v2.ListFoldersRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.control.v2.ListFoldersRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.control.v2.ListFoldersRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.control.v2.ListFoldersRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.control.v2.ListFoldersRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.control.v2.ListFoldersRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.control.v2.ListFoldersRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.control.v2.ListFoldersRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.control.v2.ListFoldersRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.storage.control.v2.ListFoldersRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.control.v2.ListFoldersRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.control.v2.ListFoldersRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.storage.control.v2.ListFoldersRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for ListFolders. This operation is only applicable to a
   * hierarchical namespace enabled bucket.
   * </pre>
   *
   * Protobuf type {@code google.storage.control.v2.ListFoldersRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.storage.control.v2.ListFoldersRequest)
      com.google.storage.control.v2.ListFoldersRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.control.v2.StorageControlProto
          .internal_static_google_storage_control_v2_ListFoldersRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.control.v2.StorageControlProto
          .internal_static_google_storage_control_v2_ListFoldersRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.control.v2.ListFoldersRequest.class,
              com.google.storage.control.v2.ListFoldersRequest.Builder.class);
    }

    // Construct using com.google.storage.control.v2.ListFoldersRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      pageSize_ = 0;
      pageToken_ = "";
      prefix_ = "";
      delimiter_ = "";
      lexicographicStart_ = "";
      lexicographicEnd_ = "";
      requestId_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.storage.control.v2.StorageControlProto
          .internal_static_google_storage_control_v2_ListFoldersRequest_descriptor;
    }

    @java.lang.Override
    public com.google.storage.control.v2.ListFoldersRequest getDefaultInstanceForType() {
      return com.google.storage.control.v2.ListFoldersRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.storage.control.v2.ListFoldersRequest build() {
      com.google.storage.control.v2.ListFoldersRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.storage.control.v2.ListFoldersRequest buildPartial() {
      com.google.storage.control.v2.ListFoldersRequest result =
          new com.google.storage.control.v2.ListFoldersRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.storage.control.v2.ListFoldersRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.pageSize_ = pageSize_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.pageToken_ = pageToken_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.prefix_ = prefix_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.delimiter_ = delimiter_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.lexicographicStart_ = lexicographicStart_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.lexicographicEnd_ = lexicographicEnd_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.requestId_ = requestId_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.storage.control.v2.ListFoldersRequest) {
        return mergeFrom((com.google.storage.control.v2.ListFoldersRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.storage.control.v2.ListFoldersRequest other) {
      if (other == com.google.storage.control.v2.ListFoldersRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getPrefix().isEmpty()) {
        prefix_ = other.prefix_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getDelimiter().isEmpty()) {
        delimiter_ = other.delimiter_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getLexicographicStart().isEmpty()) {
        lexicographicStart_ = other.lexicographicStart_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getLexicographicEnd().isEmpty()) {
        lexicographicEnd_ = other.lexicographicEnd_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getRequestId().isEmpty()) {
        requestId_ = other.requestId_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                pageSize_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                pageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                prefix_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 50:
              {
                lexicographicStart_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                lexicographicEnd_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                delimiter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 66
            case 74:
              {
                requestId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the bucket in which to look for folders. The bucket must
     * be a hierarchical namespace enabled bucket.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the bucket in which to look for folders. The bucket must
     * be a hierarchical namespace enabled bucket.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the bucket in which to look for folders. The bucket must
     * be a hierarchical namespace enabled bucket.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the bucket in which to look for folders. The bucket must
     * be a hierarchical namespace enabled bucket.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the bucket in which to look for folders. The bucket must
     * be a hierarchical namespace enabled bucket.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int pageSize_;
    /**
     *
     *
     * <pre>
     * Optional. Maximum number of folders to return in a single response. The
     * service will use this parameter or 1,000 items, whichever is smaller.
     * </pre>
     *
     * <code>int32 page_size = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maximum number of folders to return in a single response. The
     * service will use this parameter or 1,000 items, whichever is smaller.
     * </pre>
     *
     * <code>int32 page_size = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The pageSize to set.
     * @return This builder for chaining.
     */
    public Builder setPageSize(int value) {

      pageSize_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maximum number of folders to return in a single response. The
     * service will use this parameter or 1,000 items, whichever is smaller.
     * </pre>
     *
     * <code>int32 page_size = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageSize() {
      bitField0_ = (bitField0_ & ~0x00000002);
      pageSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object pageToken_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A previously-returned page token representing part of the larger
     * set of results to view.
     * </pre>
     *
     * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pageToken.
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A previously-returned page token representing part of the larger
     * set of results to view.
     * </pre>
     *
     * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for pageToken.
     */
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A previously-returned page token representing part of the larger
     * set of results to view.
     * </pre>
     *
     * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pageToken_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A previously-returned page token representing part of the larger
     * set of results to view.
     * </pre>
     *
     * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageToken() {
      pageToken_ = getDefaultInstance().getPageToken();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A previously-returned page token representing part of the larger
     * set of results to view.
     * </pre>
     *
     * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pageToken_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object prefix_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Filter results to folders whose names begin with this prefix.
     * If set, the value must either be an empty string or end with a '/'.
     * </pre>
     *
     * <code>string prefix = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The prefix.
     */
    public java.lang.String getPrefix() {
      java.lang.Object ref = prefix_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        prefix_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter results to folders whose names begin with this prefix.
     * If set, the value must either be an empty string or end with a '/'.
     * </pre>
     *
     * <code>string prefix = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for prefix.
     */
    public com.google.protobuf.ByteString getPrefixBytes() {
      java.lang.Object ref = prefix_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        prefix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter results to folders whose names begin with this prefix.
     * If set, the value must either be an empty string or end with a '/'.
     * </pre>
     *
     * <code>string prefix = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The prefix to set.
     * @return This builder for chaining.
     */
    public Builder setPrefix(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      prefix_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter results to folders whose names begin with this prefix.
     * If set, the value must either be an empty string or end with a '/'.
     * </pre>
     *
     * <code>string prefix = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrefix() {
      prefix_ = getDefaultInstance().getPrefix();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter results to folders whose names begin with this prefix.
     * If set, the value must either be an empty string or end with a '/'.
     * </pre>
     *
     * <code>string prefix = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for prefix to set.
     * @return This builder for chaining.
     */
    public Builder setPrefixBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      prefix_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object delimiter_ = "";
    /**
     *
     *
     * <pre>
     * Optional. If set, returns results in a directory-like mode. The results
     * will only include folders that either exactly match the above prefix, or
     * are one level below the prefix. The only supported value is '/'.
     * </pre>
     *
     * <code>string delimiter = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The delimiter.
     */
    public java.lang.String getDelimiter() {
      java.lang.Object ref = delimiter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        delimiter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, returns results in a directory-like mode. The results
     * will only include folders that either exactly match the above prefix, or
     * are one level below the prefix. The only supported value is '/'.
     * </pre>
     *
     * <code>string delimiter = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for delimiter.
     */
    public com.google.protobuf.ByteString getDelimiterBytes() {
      java.lang.Object ref = delimiter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        delimiter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, returns results in a directory-like mode. The results
     * will only include folders that either exactly match the above prefix, or
     * are one level below the prefix. The only supported value is '/'.
     * </pre>
     *
     * <code>string delimiter = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The delimiter to set.
     * @return This builder for chaining.
     */
    public Builder setDelimiter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      delimiter_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, returns results in a directory-like mode. The results
     * will only include folders that either exactly match the above prefix, or
     * are one level below the prefix. The only supported value is '/'.
     * </pre>
     *
     * <code>string delimiter = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDelimiter() {
      delimiter_ = getDefaultInstance().getDelimiter();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, returns results in a directory-like mode. The results
     * will only include folders that either exactly match the above prefix, or
     * are one level below the prefix. The only supported value is '/'.
     * </pre>
     *
     * <code>string delimiter = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for delimiter to set.
     * @return This builder for chaining.
     */
    public Builder setDelimiterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      delimiter_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object lexicographicStart_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Filter results to folders whose names are lexicographically equal
     * to or after lexicographic_start. If lexicographic_end is also set, the
     * folders listed have names between lexicographic_start (inclusive) and
     * lexicographic_end (exclusive).
     * </pre>
     *
     * <code>string lexicographic_start = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The lexicographicStart.
     */
    public java.lang.String getLexicographicStart() {
      java.lang.Object ref = lexicographicStart_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        lexicographicStart_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter results to folders whose names are lexicographically equal
     * to or after lexicographic_start. If lexicographic_end is also set, the
     * folders listed have names between lexicographic_start (inclusive) and
     * lexicographic_end (exclusive).
     * </pre>
     *
     * <code>string lexicographic_start = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for lexicographicStart.
     */
    public com.google.protobuf.ByteString getLexicographicStartBytes() {
      java.lang.Object ref = lexicographicStart_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        lexicographicStart_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter results to folders whose names are lexicographically equal
     * to or after lexicographic_start. If lexicographic_end is also set, the
     * folders listed have names between lexicographic_start (inclusive) and
     * lexicographic_end (exclusive).
     * </pre>
     *
     * <code>string lexicographic_start = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The lexicographicStart to set.
     * @return This builder for chaining.
     */
    public Builder setLexicographicStart(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      lexicographicStart_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter results to folders whose names are lexicographically equal
     * to or after lexicographic_start. If lexicographic_end is also set, the
     * folders listed have names between lexicographic_start (inclusive) and
     * lexicographic_end (exclusive).
     * </pre>
     *
     * <code>string lexicographic_start = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLexicographicStart() {
      lexicographicStart_ = getDefaultInstance().getLexicographicStart();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter results to folders whose names are lexicographically equal
     * to or after lexicographic_start. If lexicographic_end is also set, the
     * folders listed have names between lexicographic_start (inclusive) and
     * lexicographic_end (exclusive).
     * </pre>
     *
     * <code>string lexicographic_start = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for lexicographicStart to set.
     * @return This builder for chaining.
     */
    public Builder setLexicographicStartBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      lexicographicStart_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object lexicographicEnd_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Filter results to folders whose names are lexicographically
     * before lexicographic_end. If lexicographic_start is also set, the folders
     * listed have names between lexicographic_start (inclusive) and
     * lexicographic_end (exclusive).
     * </pre>
     *
     * <code>string lexicographic_end = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The lexicographicEnd.
     */
    public java.lang.String getLexicographicEnd() {
      java.lang.Object ref = lexicographicEnd_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        lexicographicEnd_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter results to folders whose names are lexicographically
     * before lexicographic_end. If lexicographic_start is also set, the folders
     * listed have names between lexicographic_start (inclusive) and
     * lexicographic_end (exclusive).
     * </pre>
     *
     * <code>string lexicographic_end = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for lexicographicEnd.
     */
    public com.google.protobuf.ByteString getLexicographicEndBytes() {
      java.lang.Object ref = lexicographicEnd_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        lexicographicEnd_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter results to folders whose names are lexicographically
     * before lexicographic_end. If lexicographic_start is also set, the folders
     * listed have names between lexicographic_start (inclusive) and
     * lexicographic_end (exclusive).
     * </pre>
     *
     * <code>string lexicographic_end = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The lexicographicEnd to set.
     * @return This builder for chaining.
     */
    public Builder setLexicographicEnd(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      lexicographicEnd_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter results to folders whose names are lexicographically
     * before lexicographic_end. If lexicographic_start is also set, the folders
     * listed have names between lexicographic_start (inclusive) and
     * lexicographic_end (exclusive).
     * </pre>
     *
     * <code>string lexicographic_end = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLexicographicEnd() {
      lexicographicEnd_ = getDefaultInstance().getLexicographicEnd();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter results to folders whose names are lexicographically
     * before lexicographic_end. If lexicographic_start is also set, the folders
     * listed have names between lexicographic_start (inclusive) and
     * lexicographic_end (exclusive).
     * </pre>
     *
     * <code>string lexicographic_end = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for lexicographicEnd to set.
     * @return This builder for chaining.
     */
    public Builder setLexicographicEndBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      lexicographicEnd_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object requestId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for this request. UUID is the recommended
     * format, but other formats are still accepted.
     * </pre>
     *
     * <code>
     * string request_id = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
     * </code>
     *
     * @return The requestId.
     */
    public java.lang.String getRequestId() {
      java.lang.Object ref = requestId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for this request. UUID is the recommended
     * format, but other formats are still accepted.
     * </pre>
     *
     * <code>
     * string request_id = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
     * </code>
     *
     * @return The bytes for requestId.
     */
    public com.google.protobuf.ByteString getRequestIdBytes() {
      java.lang.Object ref = requestId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for this request. UUID is the recommended
     * format, but other formats are still accepted.
     * </pre>
     *
     * <code>
     * string request_id = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
     * </code>
     *
     * @param value The requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestId_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for this request. UUID is the recommended
     * format, but other formats are still accepted.
     * </pre>
     *
     * <code>
     * string request_id = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestId() {
      requestId_ = getDefaultInstance().getRequestId();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for this request. UUID is the recommended
     * format, but other formats are still accepted.
     * </pre>
     *
     * <code>
     * string request_id = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
     * </code>
     *
     * @param value The bytes for requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestId_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.storage.control.v2.ListFoldersRequest)
  }

  // @@protoc_insertion_point(class_scope:google.storage.control.v2.ListFoldersRequest)
  private static final com.google.storage.control.v2.ListFoldersRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.storage.control.v2.ListFoldersRequest();
  }

  public static com.google.storage.control.v2.ListFoldersRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListFoldersRequest> PARSER =
      new com.google.protobuf.AbstractParser<ListFoldersRequest>() {
        @java.lang.Override
        public ListFoldersRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListFoldersRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListFoldersRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.storage.control.v2.ListFoldersRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
