/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/v2/storage.proto

package com.google.storage.v2;

/**
 *
 *
 * <pre>
 * Predefined or "canned" aliases for sets of specific object ACL entries.
 * </pre>
 *
 * Protobuf enum {@code google.storage.v2.PredefinedObjectAcl}
 */
public enum PredefinedObjectAcl implements com.google.protobuf.ProtocolMessageEnum {
  /**
   *
   *
   * <pre>
   * No predefined ACL.
   * </pre>
   *
   * <code>PREDEFINED_OBJECT_ACL_UNSPECIFIED = 0;</code>
   */
  PREDEFINED_OBJECT_ACL_UNSPECIFIED(0),
  /**
   *
   *
   * <pre>
   * Object owner gets `OWNER` access, and
   * `allAuthenticatedUsers` get `READER` access.
   * </pre>
   *
   * <code>OBJECT_ACL_AUTHENTICATED_READ = 1;</code>
   */
  OBJECT_ACL_AUTHENTICATED_READ(1),
  /**
   *
   *
   * <pre>
   * Object owner gets `OWNER` access, and project team owners get
   * `OWNER` access.
   * </pre>
   *
   * <code>OBJECT_ACL_BUCKET_OWNER_FULL_CONTROL = 2;</code>
   */
  OBJECT_ACL_BUCKET_OWNER_FULL_CONTROL(2),
  /**
   *
   *
   * <pre>
   * Object owner gets `OWNER` access, and project team owners get
   * `READER` access.
   * </pre>
   *
   * <code>OBJECT_ACL_BUCKET_OWNER_READ = 3;</code>
   */
  OBJECT_ACL_BUCKET_OWNER_READ(3),
  /**
   *
   *
   * <pre>
   * Object owner gets `OWNER` access.
   * </pre>
   *
   * <code>OBJECT_ACL_PRIVATE = 4;</code>
   */
  OBJECT_ACL_PRIVATE(4),
  /**
   *
   *
   * <pre>
   * Object owner gets `OWNER` access, and project team members get
   * access according to their roles.
   * </pre>
   *
   * <code>OBJECT_ACL_PROJECT_PRIVATE = 5;</code>
   */
  OBJECT_ACL_PROJECT_PRIVATE(5),
  /**
   *
   *
   * <pre>
   * Object owner gets `OWNER` access, and `allUsers`
   * get `READER` access.
   * </pre>
   *
   * <code>OBJECT_ACL_PUBLIC_READ = 6;</code>
   */
  OBJECT_ACL_PUBLIC_READ(6),
  UNRECOGNIZED(-1),
  ;

  /**
   *
   *
   * <pre>
   * No predefined ACL.
   * </pre>
   *
   * <code>PREDEFINED_OBJECT_ACL_UNSPECIFIED = 0;</code>
   */
  public static final int PREDEFINED_OBJECT_ACL_UNSPECIFIED_VALUE = 0;
  /**
   *
   *
   * <pre>
   * Object owner gets `OWNER` access, and
   * `allAuthenticatedUsers` get `READER` access.
   * </pre>
   *
   * <code>OBJECT_ACL_AUTHENTICATED_READ = 1;</code>
   */
  public static final int OBJECT_ACL_AUTHENTICATED_READ_VALUE = 1;
  /**
   *
   *
   * <pre>
   * Object owner gets `OWNER` access, and project team owners get
   * `OWNER` access.
   * </pre>
   *
   * <code>OBJECT_ACL_BUCKET_OWNER_FULL_CONTROL = 2;</code>
   */
  public static final int OBJECT_ACL_BUCKET_OWNER_FULL_CONTROL_VALUE = 2;
  /**
   *
   *
   * <pre>
   * Object owner gets `OWNER` access, and project team owners get
   * `READER` access.
   * </pre>
   *
   * <code>OBJECT_ACL_BUCKET_OWNER_READ = 3;</code>
   */
  public static final int OBJECT_ACL_BUCKET_OWNER_READ_VALUE = 3;
  /**
   *
   *
   * <pre>
   * Object owner gets `OWNER` access.
   * </pre>
   *
   * <code>OBJECT_ACL_PRIVATE = 4;</code>
   */
  public static final int OBJECT_ACL_PRIVATE_VALUE = 4;
  /**
   *
   *
   * <pre>
   * Object owner gets `OWNER` access, and project team members get
   * access according to their roles.
   * </pre>
   *
   * <code>OBJECT_ACL_PROJECT_PRIVATE = 5;</code>
   */
  public static final int OBJECT_ACL_PROJECT_PRIVATE_VALUE = 5;
  /**
   *
   *
   * <pre>
   * Object owner gets `OWNER` access, and `allUsers`
   * get `READER` access.
   * </pre>
   *
   * <code>OBJECT_ACL_PUBLIC_READ = 6;</code>
   */
  public static final int OBJECT_ACL_PUBLIC_READ_VALUE = 6;

  public final int getNumber() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalArgumentException(
          "Can't get the number of an unknown enum value.");
    }
    return value;
  }

  /**
   * @param value The numeric wire value of the corresponding enum entry.
   * @return The enum associated with the given numeric wire value.
   * @deprecated Use {@link #forNumber(int)} instead.
   */
  @java.lang.Deprecated
  public static PredefinedObjectAcl valueOf(int value) {
    return forNumber(value);
  }

  /**
   * @param value The numeric wire value of the corresponding enum entry.
   * @return The enum associated with the given numeric wire value.
   */
  public static PredefinedObjectAcl forNumber(int value) {
    switch (value) {
      case 0:
        return PREDEFINED_OBJECT_ACL_UNSPECIFIED;
      case 1:
        return OBJECT_ACL_AUTHENTICATED_READ;
      case 2:
        return OBJECT_ACL_BUCKET_OWNER_FULL_CONTROL;
      case 3:
        return OBJECT_ACL_BUCKET_OWNER_READ;
      case 4:
        return OBJECT_ACL_PRIVATE;
      case 5:
        return OBJECT_ACL_PROJECT_PRIVATE;
      case 6:
        return OBJECT_ACL_PUBLIC_READ;
      default:
        return null;
    }
  }

  public static com.google.protobuf.Internal.EnumLiteMap<PredefinedObjectAcl>
      internalGetValueMap() {
    return internalValueMap;
  }

  private static final com.google.protobuf.Internal.EnumLiteMap<PredefinedObjectAcl>
      internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<PredefinedObjectAcl>() {
            public PredefinedObjectAcl findValueByNumber(int number) {
              return PredefinedObjectAcl.forNumber(number);
            }
          };

  public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalStateException(
          "Can't get the descriptor of an unrecognized enum value.");
    }
    return getDescriptor().getValues().get(ordinal());
  }

  public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
    return getDescriptor();
  }

  public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
    return com.google.storage.v2.StorageProto.getDescriptor().getEnumTypes().get(0);
  }

  private static final PredefinedObjectAcl[] VALUES = values();

  public static PredefinedObjectAcl valueOf(
      com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
    if (desc.getType() != getDescriptor()) {
      throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
    }
    if (desc.getIndex() == -1) {
      return UNRECOGNIZED;
    }
    return VALUES[desc.getIndex()];
  }

  private final int value;

  private PredefinedObjectAcl(int value) {
    this.value = value;
  }

  // @@protoc_insertion_point(enum_scope:google.storage.v2.PredefinedObjectAcl)
}
