/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/v2/storage.proto

package com.google.storage.v2;

/**
 *
 *
 * <pre>
 * Response message for GetObject.
 * </pre>
 *
 * Protobuf type {@code google.storage.v2.ReadObjectResponse}
 */
public final class ReadObjectResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.storage.v2.ReadObjectResponse)
    ReadObjectResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ReadObjectResponse.newBuilder() to construct.
  private ReadObjectResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReadObjectResponse() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReadObjectResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ReadObjectResponse(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.storage.v2.ChecksummedData.Builder subBuilder = null;
              if (checksummedData_ != null) {
                subBuilder = checksummedData_.toBuilder();
              }
              checksummedData_ =
                  input.readMessage(
                      com.google.storage.v2.ChecksummedData.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(checksummedData_);
                checksummedData_ = subBuilder.buildPartial();
              }

              break;
            }
          case 18:
            {
              com.google.storage.v2.ObjectChecksums.Builder subBuilder = null;
              if (objectChecksums_ != null) {
                subBuilder = objectChecksums_.toBuilder();
              }
              objectChecksums_ =
                  input.readMessage(
                      com.google.storage.v2.ObjectChecksums.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(objectChecksums_);
                objectChecksums_ = subBuilder.buildPartial();
              }

              break;
            }
          case 26:
            {
              com.google.storage.v2.ContentRange.Builder subBuilder = null;
              if (contentRange_ != null) {
                subBuilder = contentRange_.toBuilder();
              }
              contentRange_ =
                  input.readMessage(com.google.storage.v2.ContentRange.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(contentRange_);
                contentRange_ = subBuilder.buildPartial();
              }

              break;
            }
          case 34:
            {
              com.google.storage.v2.Object.Builder subBuilder = null;
              if (metadata_ != null) {
                subBuilder = metadata_.toBuilder();
              }
              metadata_ =
                  input.readMessage(com.google.storage.v2.Object.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(metadata_);
                metadata_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_ReadObjectResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_ReadObjectResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.storage.v2.ReadObjectResponse.class,
            com.google.storage.v2.ReadObjectResponse.Builder.class);
  }

  public static final int CHECKSUMMED_DATA_FIELD_NUMBER = 1;
  private com.google.storage.v2.ChecksummedData checksummedData_;
  /**
   *
   *
   * <pre>
   * A portion of the data for the object. The service **may** leave `data`
   * empty for any given `ReadResponse`. This enables the service to inform the
   * client that the request is still live while it is running an operation to
   * generate more data.
   * </pre>
   *
   * <code>.google.storage.v2.ChecksummedData checksummed_data = 1;</code>
   *
   * @return Whether the checksummedData field is set.
   */
  @java.lang.Override
  public boolean hasChecksummedData() {
    return checksummedData_ != null;
  }
  /**
   *
   *
   * <pre>
   * A portion of the data for the object. The service **may** leave `data`
   * empty for any given `ReadResponse`. This enables the service to inform the
   * client that the request is still live while it is running an operation to
   * generate more data.
   * </pre>
   *
   * <code>.google.storage.v2.ChecksummedData checksummed_data = 1;</code>
   *
   * @return The checksummedData.
   */
  @java.lang.Override
  public com.google.storage.v2.ChecksummedData getChecksummedData() {
    return checksummedData_ == null
        ? com.google.storage.v2.ChecksummedData.getDefaultInstance()
        : checksummedData_;
  }
  /**
   *
   *
   * <pre>
   * A portion of the data for the object. The service **may** leave `data`
   * empty for any given `ReadResponse`. This enables the service to inform the
   * client that the request is still live while it is running an operation to
   * generate more data.
   * </pre>
   *
   * <code>.google.storage.v2.ChecksummedData checksummed_data = 1;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.ChecksummedDataOrBuilder getChecksummedDataOrBuilder() {
    return getChecksummedData();
  }

  public static final int OBJECT_CHECKSUMS_FIELD_NUMBER = 2;
  private com.google.storage.v2.ObjectChecksums objectChecksums_;
  /**
   *
   *
   * <pre>
   * The checksums of the complete object. The client should compute one of
   * these checksums over the downloaded object and compare it against the value
   * provided here.
   * </pre>
   *
   * <code>.google.storage.v2.ObjectChecksums object_checksums = 2;</code>
   *
   * @return Whether the objectChecksums field is set.
   */
  @java.lang.Override
  public boolean hasObjectChecksums() {
    return objectChecksums_ != null;
  }
  /**
   *
   *
   * <pre>
   * The checksums of the complete object. The client should compute one of
   * these checksums over the downloaded object and compare it against the value
   * provided here.
   * </pre>
   *
   * <code>.google.storage.v2.ObjectChecksums object_checksums = 2;</code>
   *
   * @return The objectChecksums.
   */
  @java.lang.Override
  public com.google.storage.v2.ObjectChecksums getObjectChecksums() {
    return objectChecksums_ == null
        ? com.google.storage.v2.ObjectChecksums.getDefaultInstance()
        : objectChecksums_;
  }
  /**
   *
   *
   * <pre>
   * The checksums of the complete object. The client should compute one of
   * these checksums over the downloaded object and compare it against the value
   * provided here.
   * </pre>
   *
   * <code>.google.storage.v2.ObjectChecksums object_checksums = 2;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.ObjectChecksumsOrBuilder getObjectChecksumsOrBuilder() {
    return getObjectChecksums();
  }

  public static final int CONTENT_RANGE_FIELD_NUMBER = 3;
  private com.google.storage.v2.ContentRange contentRange_;
  /**
   *
   *
   * <pre>
   * If read_offset and or read_limit was specified on the
   * ReadObjectRequest, ContentRange will be populated on the first
   * ReadObjectResponse message of the read stream.
   * </pre>
   *
   * <code>.google.storage.v2.ContentRange content_range = 3;</code>
   *
   * @return Whether the contentRange field is set.
   */
  @java.lang.Override
  public boolean hasContentRange() {
    return contentRange_ != null;
  }
  /**
   *
   *
   * <pre>
   * If read_offset and or read_limit was specified on the
   * ReadObjectRequest, ContentRange will be populated on the first
   * ReadObjectResponse message of the read stream.
   * </pre>
   *
   * <code>.google.storage.v2.ContentRange content_range = 3;</code>
   *
   * @return The contentRange.
   */
  @java.lang.Override
  public com.google.storage.v2.ContentRange getContentRange() {
    return contentRange_ == null
        ? com.google.storage.v2.ContentRange.getDefaultInstance()
        : contentRange_;
  }
  /**
   *
   *
   * <pre>
   * If read_offset and or read_limit was specified on the
   * ReadObjectRequest, ContentRange will be populated on the first
   * ReadObjectResponse message of the read stream.
   * </pre>
   *
   * <code>.google.storage.v2.ContentRange content_range = 3;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.ContentRangeOrBuilder getContentRangeOrBuilder() {
    return getContentRange();
  }

  public static final int METADATA_FIELD_NUMBER = 4;
  private com.google.storage.v2.Object metadata_;
  /**
   *
   *
   * <pre>
   * Metadata of the object whose media is being returned.
   * Only populated in the first response in the stream.
   * </pre>
   *
   * <code>.google.storage.v2.Object metadata = 4;</code>
   *
   * @return Whether the metadata field is set.
   */
  @java.lang.Override
  public boolean hasMetadata() {
    return metadata_ != null;
  }
  /**
   *
   *
   * <pre>
   * Metadata of the object whose media is being returned.
   * Only populated in the first response in the stream.
   * </pre>
   *
   * <code>.google.storage.v2.Object metadata = 4;</code>
   *
   * @return The metadata.
   */
  @java.lang.Override
  public com.google.storage.v2.Object getMetadata() {
    return metadata_ == null ? com.google.storage.v2.Object.getDefaultInstance() : metadata_;
  }
  /**
   *
   *
   * <pre>
   * Metadata of the object whose media is being returned.
   * Only populated in the first response in the stream.
   * </pre>
   *
   * <code>.google.storage.v2.Object metadata = 4;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.ObjectOrBuilder getMetadataOrBuilder() {
    return getMetadata();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (checksummedData_ != null) {
      output.writeMessage(1, getChecksummedData());
    }
    if (objectChecksums_ != null) {
      output.writeMessage(2, getObjectChecksums());
    }
    if (contentRange_ != null) {
      output.writeMessage(3, getContentRange());
    }
    if (metadata_ != null) {
      output.writeMessage(4, getMetadata());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (checksummedData_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getChecksummedData());
    }
    if (objectChecksums_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getObjectChecksums());
    }
    if (contentRange_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getContentRange());
    }
    if (metadata_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getMetadata());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.storage.v2.ReadObjectResponse)) {
      return super.equals(obj);
    }
    com.google.storage.v2.ReadObjectResponse other = (com.google.storage.v2.ReadObjectResponse) obj;

    if (hasChecksummedData() != other.hasChecksummedData()) return false;
    if (hasChecksummedData()) {
      if (!getChecksummedData().equals(other.getChecksummedData())) return false;
    }
    if (hasObjectChecksums() != other.hasObjectChecksums()) return false;
    if (hasObjectChecksums()) {
      if (!getObjectChecksums().equals(other.getObjectChecksums())) return false;
    }
    if (hasContentRange() != other.hasContentRange()) return false;
    if (hasContentRange()) {
      if (!getContentRange().equals(other.getContentRange())) return false;
    }
    if (hasMetadata() != other.hasMetadata()) return false;
    if (hasMetadata()) {
      if (!getMetadata().equals(other.getMetadata())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasChecksummedData()) {
      hash = (37 * hash) + CHECKSUMMED_DATA_FIELD_NUMBER;
      hash = (53 * hash) + getChecksummedData().hashCode();
    }
    if (hasObjectChecksums()) {
      hash = (37 * hash) + OBJECT_CHECKSUMS_FIELD_NUMBER;
      hash = (53 * hash) + getObjectChecksums().hashCode();
    }
    if (hasContentRange()) {
      hash = (37 * hash) + CONTENT_RANGE_FIELD_NUMBER;
      hash = (53 * hash) + getContentRange().hashCode();
    }
    if (hasMetadata()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadata().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.storage.v2.ReadObjectResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.ReadObjectResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.ReadObjectResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.ReadObjectResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.ReadObjectResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.ReadObjectResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.ReadObjectResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.ReadObjectResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.ReadObjectResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.ReadObjectResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.ReadObjectResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.ReadObjectResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.storage.v2.ReadObjectResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for GetObject.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.ReadObjectResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.storage.v2.ReadObjectResponse)
      com.google.storage.v2.ReadObjectResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_ReadObjectResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_ReadObjectResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.ReadObjectResponse.class,
              com.google.storage.v2.ReadObjectResponse.Builder.class);
    }

    // Construct using com.google.storage.v2.ReadObjectResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (checksummedDataBuilder_ == null) {
        checksummedData_ = null;
      } else {
        checksummedData_ = null;
        checksummedDataBuilder_ = null;
      }
      if (objectChecksumsBuilder_ == null) {
        objectChecksums_ = null;
      } else {
        objectChecksums_ = null;
        objectChecksumsBuilder_ = null;
      }
      if (contentRangeBuilder_ == null) {
        contentRange_ = null;
      } else {
        contentRange_ = null;
        contentRangeBuilder_ = null;
      }
      if (metadataBuilder_ == null) {
        metadata_ = null;
      } else {
        metadata_ = null;
        metadataBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_ReadObjectResponse_descriptor;
    }

    @java.lang.Override
    public com.google.storage.v2.ReadObjectResponse getDefaultInstanceForType() {
      return com.google.storage.v2.ReadObjectResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.storage.v2.ReadObjectResponse build() {
      com.google.storage.v2.ReadObjectResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.storage.v2.ReadObjectResponse buildPartial() {
      com.google.storage.v2.ReadObjectResponse result =
          new com.google.storage.v2.ReadObjectResponse(this);
      if (checksummedDataBuilder_ == null) {
        result.checksummedData_ = checksummedData_;
      } else {
        result.checksummedData_ = checksummedDataBuilder_.build();
      }
      if (objectChecksumsBuilder_ == null) {
        result.objectChecksums_ = objectChecksums_;
      } else {
        result.objectChecksums_ = objectChecksumsBuilder_.build();
      }
      if (contentRangeBuilder_ == null) {
        result.contentRange_ = contentRange_;
      } else {
        result.contentRange_ = contentRangeBuilder_.build();
      }
      if (metadataBuilder_ == null) {
        result.metadata_ = metadata_;
      } else {
        result.metadata_ = metadataBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.storage.v2.ReadObjectResponse) {
        return mergeFrom((com.google.storage.v2.ReadObjectResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.storage.v2.ReadObjectResponse other) {
      if (other == com.google.storage.v2.ReadObjectResponse.getDefaultInstance()) return this;
      if (other.hasChecksummedData()) {
        mergeChecksummedData(other.getChecksummedData());
      }
      if (other.hasObjectChecksums()) {
        mergeObjectChecksums(other.getObjectChecksums());
      }
      if (other.hasContentRange()) {
        mergeContentRange(other.getContentRange());
      }
      if (other.hasMetadata()) {
        mergeMetadata(other.getMetadata());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.storage.v2.ReadObjectResponse parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.storage.v2.ReadObjectResponse) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private com.google.storage.v2.ChecksummedData checksummedData_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.ChecksummedData,
            com.google.storage.v2.ChecksummedData.Builder,
            com.google.storage.v2.ChecksummedDataOrBuilder>
        checksummedDataBuilder_;
    /**
     *
     *
     * <pre>
     * A portion of the data for the object. The service **may** leave `data`
     * empty for any given `ReadResponse`. This enables the service to inform the
     * client that the request is still live while it is running an operation to
     * generate more data.
     * </pre>
     *
     * <code>.google.storage.v2.ChecksummedData checksummed_data = 1;</code>
     *
     * @return Whether the checksummedData field is set.
     */
    public boolean hasChecksummedData() {
      return checksummedDataBuilder_ != null || checksummedData_ != null;
    }
    /**
     *
     *
     * <pre>
     * A portion of the data for the object. The service **may** leave `data`
     * empty for any given `ReadResponse`. This enables the service to inform the
     * client that the request is still live while it is running an operation to
     * generate more data.
     * </pre>
     *
     * <code>.google.storage.v2.ChecksummedData checksummed_data = 1;</code>
     *
     * @return The checksummedData.
     */
    public com.google.storage.v2.ChecksummedData getChecksummedData() {
      if (checksummedDataBuilder_ == null) {
        return checksummedData_ == null
            ? com.google.storage.v2.ChecksummedData.getDefaultInstance()
            : checksummedData_;
      } else {
        return checksummedDataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A portion of the data for the object. The service **may** leave `data`
     * empty for any given `ReadResponse`. This enables the service to inform the
     * client that the request is still live while it is running an operation to
     * generate more data.
     * </pre>
     *
     * <code>.google.storage.v2.ChecksummedData checksummed_data = 1;</code>
     */
    public Builder setChecksummedData(com.google.storage.v2.ChecksummedData value) {
      if (checksummedDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        checksummedData_ = value;
        onChanged();
      } else {
        checksummedDataBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A portion of the data for the object. The service **may** leave `data`
     * empty for any given `ReadResponse`. This enables the service to inform the
     * client that the request is still live while it is running an operation to
     * generate more data.
     * </pre>
     *
     * <code>.google.storage.v2.ChecksummedData checksummed_data = 1;</code>
     */
    public Builder setChecksummedData(
        com.google.storage.v2.ChecksummedData.Builder builderForValue) {
      if (checksummedDataBuilder_ == null) {
        checksummedData_ = builderForValue.build();
        onChanged();
      } else {
        checksummedDataBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A portion of the data for the object. The service **may** leave `data`
     * empty for any given `ReadResponse`. This enables the service to inform the
     * client that the request is still live while it is running an operation to
     * generate more data.
     * </pre>
     *
     * <code>.google.storage.v2.ChecksummedData checksummed_data = 1;</code>
     */
    public Builder mergeChecksummedData(com.google.storage.v2.ChecksummedData value) {
      if (checksummedDataBuilder_ == null) {
        if (checksummedData_ != null) {
          checksummedData_ =
              com.google.storage.v2.ChecksummedData.newBuilder(checksummedData_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          checksummedData_ = value;
        }
        onChanged();
      } else {
        checksummedDataBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A portion of the data for the object. The service **may** leave `data`
     * empty for any given `ReadResponse`. This enables the service to inform the
     * client that the request is still live while it is running an operation to
     * generate more data.
     * </pre>
     *
     * <code>.google.storage.v2.ChecksummedData checksummed_data = 1;</code>
     */
    public Builder clearChecksummedData() {
      if (checksummedDataBuilder_ == null) {
        checksummedData_ = null;
        onChanged();
      } else {
        checksummedData_ = null;
        checksummedDataBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A portion of the data for the object. The service **may** leave `data`
     * empty for any given `ReadResponse`. This enables the service to inform the
     * client that the request is still live while it is running an operation to
     * generate more data.
     * </pre>
     *
     * <code>.google.storage.v2.ChecksummedData checksummed_data = 1;</code>
     */
    public com.google.storage.v2.ChecksummedData.Builder getChecksummedDataBuilder() {

      onChanged();
      return getChecksummedDataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A portion of the data for the object. The service **may** leave `data`
     * empty for any given `ReadResponse`. This enables the service to inform the
     * client that the request is still live while it is running an operation to
     * generate more data.
     * </pre>
     *
     * <code>.google.storage.v2.ChecksummedData checksummed_data = 1;</code>
     */
    public com.google.storage.v2.ChecksummedDataOrBuilder getChecksummedDataOrBuilder() {
      if (checksummedDataBuilder_ != null) {
        return checksummedDataBuilder_.getMessageOrBuilder();
      } else {
        return checksummedData_ == null
            ? com.google.storage.v2.ChecksummedData.getDefaultInstance()
            : checksummedData_;
      }
    }
    /**
     *
     *
     * <pre>
     * A portion of the data for the object. The service **may** leave `data`
     * empty for any given `ReadResponse`. This enables the service to inform the
     * client that the request is still live while it is running an operation to
     * generate more data.
     * </pre>
     *
     * <code>.google.storage.v2.ChecksummedData checksummed_data = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.ChecksummedData,
            com.google.storage.v2.ChecksummedData.Builder,
            com.google.storage.v2.ChecksummedDataOrBuilder>
        getChecksummedDataFieldBuilder() {
      if (checksummedDataBuilder_ == null) {
        checksummedDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.ChecksummedData,
                com.google.storage.v2.ChecksummedData.Builder,
                com.google.storage.v2.ChecksummedDataOrBuilder>(
                getChecksummedData(), getParentForChildren(), isClean());
        checksummedData_ = null;
      }
      return checksummedDataBuilder_;
    }

    private com.google.storage.v2.ObjectChecksums objectChecksums_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.ObjectChecksums,
            com.google.storage.v2.ObjectChecksums.Builder,
            com.google.storage.v2.ObjectChecksumsOrBuilder>
        objectChecksumsBuilder_;
    /**
     *
     *
     * <pre>
     * The checksums of the complete object. The client should compute one of
     * these checksums over the downloaded object and compare it against the value
     * provided here.
     * </pre>
     *
     * <code>.google.storage.v2.ObjectChecksums object_checksums = 2;</code>
     *
     * @return Whether the objectChecksums field is set.
     */
    public boolean hasObjectChecksums() {
      return objectChecksumsBuilder_ != null || objectChecksums_ != null;
    }
    /**
     *
     *
     * <pre>
     * The checksums of the complete object. The client should compute one of
     * these checksums over the downloaded object and compare it against the value
     * provided here.
     * </pre>
     *
     * <code>.google.storage.v2.ObjectChecksums object_checksums = 2;</code>
     *
     * @return The objectChecksums.
     */
    public com.google.storage.v2.ObjectChecksums getObjectChecksums() {
      if (objectChecksumsBuilder_ == null) {
        return objectChecksums_ == null
            ? com.google.storage.v2.ObjectChecksums.getDefaultInstance()
            : objectChecksums_;
      } else {
        return objectChecksumsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The checksums of the complete object. The client should compute one of
     * these checksums over the downloaded object and compare it against the value
     * provided here.
     * </pre>
     *
     * <code>.google.storage.v2.ObjectChecksums object_checksums = 2;</code>
     */
    public Builder setObjectChecksums(com.google.storage.v2.ObjectChecksums value) {
      if (objectChecksumsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        objectChecksums_ = value;
        onChanged();
      } else {
        objectChecksumsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The checksums of the complete object. The client should compute one of
     * these checksums over the downloaded object and compare it against the value
     * provided here.
     * </pre>
     *
     * <code>.google.storage.v2.ObjectChecksums object_checksums = 2;</code>
     */
    public Builder setObjectChecksums(
        com.google.storage.v2.ObjectChecksums.Builder builderForValue) {
      if (objectChecksumsBuilder_ == null) {
        objectChecksums_ = builderForValue.build();
        onChanged();
      } else {
        objectChecksumsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The checksums of the complete object. The client should compute one of
     * these checksums over the downloaded object and compare it against the value
     * provided here.
     * </pre>
     *
     * <code>.google.storage.v2.ObjectChecksums object_checksums = 2;</code>
     */
    public Builder mergeObjectChecksums(com.google.storage.v2.ObjectChecksums value) {
      if (objectChecksumsBuilder_ == null) {
        if (objectChecksums_ != null) {
          objectChecksums_ =
              com.google.storage.v2.ObjectChecksums.newBuilder(objectChecksums_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          objectChecksums_ = value;
        }
        onChanged();
      } else {
        objectChecksumsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The checksums of the complete object. The client should compute one of
     * these checksums over the downloaded object and compare it against the value
     * provided here.
     * </pre>
     *
     * <code>.google.storage.v2.ObjectChecksums object_checksums = 2;</code>
     */
    public Builder clearObjectChecksums() {
      if (objectChecksumsBuilder_ == null) {
        objectChecksums_ = null;
        onChanged();
      } else {
        objectChecksums_ = null;
        objectChecksumsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The checksums of the complete object. The client should compute one of
     * these checksums over the downloaded object and compare it against the value
     * provided here.
     * </pre>
     *
     * <code>.google.storage.v2.ObjectChecksums object_checksums = 2;</code>
     */
    public com.google.storage.v2.ObjectChecksums.Builder getObjectChecksumsBuilder() {

      onChanged();
      return getObjectChecksumsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The checksums of the complete object. The client should compute one of
     * these checksums over the downloaded object and compare it against the value
     * provided here.
     * </pre>
     *
     * <code>.google.storage.v2.ObjectChecksums object_checksums = 2;</code>
     */
    public com.google.storage.v2.ObjectChecksumsOrBuilder getObjectChecksumsOrBuilder() {
      if (objectChecksumsBuilder_ != null) {
        return objectChecksumsBuilder_.getMessageOrBuilder();
      } else {
        return objectChecksums_ == null
            ? com.google.storage.v2.ObjectChecksums.getDefaultInstance()
            : objectChecksums_;
      }
    }
    /**
     *
     *
     * <pre>
     * The checksums of the complete object. The client should compute one of
     * these checksums over the downloaded object and compare it against the value
     * provided here.
     * </pre>
     *
     * <code>.google.storage.v2.ObjectChecksums object_checksums = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.ObjectChecksums,
            com.google.storage.v2.ObjectChecksums.Builder,
            com.google.storage.v2.ObjectChecksumsOrBuilder>
        getObjectChecksumsFieldBuilder() {
      if (objectChecksumsBuilder_ == null) {
        objectChecksumsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.ObjectChecksums,
                com.google.storage.v2.ObjectChecksums.Builder,
                com.google.storage.v2.ObjectChecksumsOrBuilder>(
                getObjectChecksums(), getParentForChildren(), isClean());
        objectChecksums_ = null;
      }
      return objectChecksumsBuilder_;
    }

    private com.google.storage.v2.ContentRange contentRange_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.ContentRange,
            com.google.storage.v2.ContentRange.Builder,
            com.google.storage.v2.ContentRangeOrBuilder>
        contentRangeBuilder_;
    /**
     *
     *
     * <pre>
     * If read_offset and or read_limit was specified on the
     * ReadObjectRequest, ContentRange will be populated on the first
     * ReadObjectResponse message of the read stream.
     * </pre>
     *
     * <code>.google.storage.v2.ContentRange content_range = 3;</code>
     *
     * @return Whether the contentRange field is set.
     */
    public boolean hasContentRange() {
      return contentRangeBuilder_ != null || contentRange_ != null;
    }
    /**
     *
     *
     * <pre>
     * If read_offset and or read_limit was specified on the
     * ReadObjectRequest, ContentRange will be populated on the first
     * ReadObjectResponse message of the read stream.
     * </pre>
     *
     * <code>.google.storage.v2.ContentRange content_range = 3;</code>
     *
     * @return The contentRange.
     */
    public com.google.storage.v2.ContentRange getContentRange() {
      if (contentRangeBuilder_ == null) {
        return contentRange_ == null
            ? com.google.storage.v2.ContentRange.getDefaultInstance()
            : contentRange_;
      } else {
        return contentRangeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If read_offset and or read_limit was specified on the
     * ReadObjectRequest, ContentRange will be populated on the first
     * ReadObjectResponse message of the read stream.
     * </pre>
     *
     * <code>.google.storage.v2.ContentRange content_range = 3;</code>
     */
    public Builder setContentRange(com.google.storage.v2.ContentRange value) {
      if (contentRangeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        contentRange_ = value;
        onChanged();
      } else {
        contentRangeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If read_offset and or read_limit was specified on the
     * ReadObjectRequest, ContentRange will be populated on the first
     * ReadObjectResponse message of the read stream.
     * </pre>
     *
     * <code>.google.storage.v2.ContentRange content_range = 3;</code>
     */
    public Builder setContentRange(com.google.storage.v2.ContentRange.Builder builderForValue) {
      if (contentRangeBuilder_ == null) {
        contentRange_ = builderForValue.build();
        onChanged();
      } else {
        contentRangeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If read_offset and or read_limit was specified on the
     * ReadObjectRequest, ContentRange will be populated on the first
     * ReadObjectResponse message of the read stream.
     * </pre>
     *
     * <code>.google.storage.v2.ContentRange content_range = 3;</code>
     */
    public Builder mergeContentRange(com.google.storage.v2.ContentRange value) {
      if (contentRangeBuilder_ == null) {
        if (contentRange_ != null) {
          contentRange_ =
              com.google.storage.v2.ContentRange.newBuilder(contentRange_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          contentRange_ = value;
        }
        onChanged();
      } else {
        contentRangeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If read_offset and or read_limit was specified on the
     * ReadObjectRequest, ContentRange will be populated on the first
     * ReadObjectResponse message of the read stream.
     * </pre>
     *
     * <code>.google.storage.v2.ContentRange content_range = 3;</code>
     */
    public Builder clearContentRange() {
      if (contentRangeBuilder_ == null) {
        contentRange_ = null;
        onChanged();
      } else {
        contentRange_ = null;
        contentRangeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If read_offset and or read_limit was specified on the
     * ReadObjectRequest, ContentRange will be populated on the first
     * ReadObjectResponse message of the read stream.
     * </pre>
     *
     * <code>.google.storage.v2.ContentRange content_range = 3;</code>
     */
    public com.google.storage.v2.ContentRange.Builder getContentRangeBuilder() {

      onChanged();
      return getContentRangeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If read_offset and or read_limit was specified on the
     * ReadObjectRequest, ContentRange will be populated on the first
     * ReadObjectResponse message of the read stream.
     * </pre>
     *
     * <code>.google.storage.v2.ContentRange content_range = 3;</code>
     */
    public com.google.storage.v2.ContentRangeOrBuilder getContentRangeOrBuilder() {
      if (contentRangeBuilder_ != null) {
        return contentRangeBuilder_.getMessageOrBuilder();
      } else {
        return contentRange_ == null
            ? com.google.storage.v2.ContentRange.getDefaultInstance()
            : contentRange_;
      }
    }
    /**
     *
     *
     * <pre>
     * If read_offset and or read_limit was specified on the
     * ReadObjectRequest, ContentRange will be populated on the first
     * ReadObjectResponse message of the read stream.
     * </pre>
     *
     * <code>.google.storage.v2.ContentRange content_range = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.ContentRange,
            com.google.storage.v2.ContentRange.Builder,
            com.google.storage.v2.ContentRangeOrBuilder>
        getContentRangeFieldBuilder() {
      if (contentRangeBuilder_ == null) {
        contentRangeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.ContentRange,
                com.google.storage.v2.ContentRange.Builder,
                com.google.storage.v2.ContentRangeOrBuilder>(
                getContentRange(), getParentForChildren(), isClean());
        contentRange_ = null;
      }
      return contentRangeBuilder_;
    }

    private com.google.storage.v2.Object metadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Object,
            com.google.storage.v2.Object.Builder,
            com.google.storage.v2.ObjectOrBuilder>
        metadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata of the object whose media is being returned.
     * Only populated in the first response in the stream.
     * </pre>
     *
     * <code>.google.storage.v2.Object metadata = 4;</code>
     *
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return metadataBuilder_ != null || metadata_ != null;
    }
    /**
     *
     *
     * <pre>
     * Metadata of the object whose media is being returned.
     * Only populated in the first response in the stream.
     * </pre>
     *
     * <code>.google.storage.v2.Object metadata = 4;</code>
     *
     * @return The metadata.
     */
    public com.google.storage.v2.Object getMetadata() {
      if (metadataBuilder_ == null) {
        return metadata_ == null ? com.google.storage.v2.Object.getDefaultInstance() : metadata_;
      } else {
        return metadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata of the object whose media is being returned.
     * Only populated in the first response in the stream.
     * </pre>
     *
     * <code>.google.storage.v2.Object metadata = 4;</code>
     */
    public Builder setMetadata(com.google.storage.v2.Object value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
        onChanged();
      } else {
        metadataBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata of the object whose media is being returned.
     * Only populated in the first response in the stream.
     * </pre>
     *
     * <code>.google.storage.v2.Object metadata = 4;</code>
     */
    public Builder setMetadata(com.google.storage.v2.Object.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        metadata_ = builderForValue.build();
        onChanged();
      } else {
        metadataBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata of the object whose media is being returned.
     * Only populated in the first response in the stream.
     * </pre>
     *
     * <code>.google.storage.v2.Object metadata = 4;</code>
     */
    public Builder mergeMetadata(com.google.storage.v2.Object value) {
      if (metadataBuilder_ == null) {
        if (metadata_ != null) {
          metadata_ =
              com.google.storage.v2.Object.newBuilder(metadata_).mergeFrom(value).buildPartial();
        } else {
          metadata_ = value;
        }
        onChanged();
      } else {
        metadataBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata of the object whose media is being returned.
     * Only populated in the first response in the stream.
     * </pre>
     *
     * <code>.google.storage.v2.Object metadata = 4;</code>
     */
    public Builder clearMetadata() {
      if (metadataBuilder_ == null) {
        metadata_ = null;
        onChanged();
      } else {
        metadata_ = null;
        metadataBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata of the object whose media is being returned.
     * Only populated in the first response in the stream.
     * </pre>
     *
     * <code>.google.storage.v2.Object metadata = 4;</code>
     */
    public com.google.storage.v2.Object.Builder getMetadataBuilder() {

      onChanged();
      return getMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata of the object whose media is being returned.
     * Only populated in the first response in the stream.
     * </pre>
     *
     * <code>.google.storage.v2.Object metadata = 4;</code>
     */
    public com.google.storage.v2.ObjectOrBuilder getMetadataOrBuilder() {
      if (metadataBuilder_ != null) {
        return metadataBuilder_.getMessageOrBuilder();
      } else {
        return metadata_ == null ? com.google.storage.v2.Object.getDefaultInstance() : metadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata of the object whose media is being returned.
     * Only populated in the first response in the stream.
     * </pre>
     *
     * <code>.google.storage.v2.Object metadata = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Object,
            com.google.storage.v2.Object.Builder,
            com.google.storage.v2.ObjectOrBuilder>
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        metadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Object,
                com.google.storage.v2.Object.Builder,
                com.google.storage.v2.ObjectOrBuilder>(
                getMetadata(), getParentForChildren(), isClean());
        metadata_ = null;
      }
      return metadataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.storage.v2.ReadObjectResponse)
  }

  // @@protoc_insertion_point(class_scope:google.storage.v2.ReadObjectResponse)
  private static final com.google.storage.v2.ReadObjectResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.storage.v2.ReadObjectResponse();
  }

  public static com.google.storage.v2.ReadObjectResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReadObjectResponse> PARSER =
      new com.google.protobuf.AbstractParser<ReadObjectResponse>() {
        @java.lang.Override
        public ReadObjectResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ReadObjectResponse(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ReadObjectResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReadObjectResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.storage.v2.ReadObjectResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
