/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/v2/storage.proto

package com.google.storage.v2;

/**
 *
 *
 * <pre>
 * Message for deleting an object.
 * `bucket` and `object` **must** be set.
 * </pre>
 *
 * Protobuf type {@code google.storage.v2.DeleteObjectRequest}
 */
public final class DeleteObjectRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.storage.v2.DeleteObjectRequest)
    DeleteObjectRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DeleteObjectRequest.newBuilder() to construct.
  private DeleteObjectRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DeleteObjectRequest() {
    bucket_ = "";
    object_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DeleteObjectRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_DeleteObjectRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_DeleteObjectRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.storage.v2.DeleteObjectRequest.class,
            com.google.storage.v2.DeleteObjectRequest.Builder.class);
  }

  private int bitField0_;
  public static final int BUCKET_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object bucket_ = "";
  /**
   *
   *
   * <pre>
   * Required. Name of the bucket in which the object resides.
   * </pre>
   *
   * <code>
   * string bucket = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bucket.
   */
  @java.lang.Override
  public java.lang.String getBucket() {
    java.lang.Object ref = bucket_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      bucket_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Name of the bucket in which the object resides.
   * </pre>
   *
   * <code>
   * string bucket = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for bucket.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBucketBytes() {
    java.lang.Object ref = bucket_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      bucket_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OBJECT_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object object_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the finalized object to delete.
   * Note: If you want to delete an unfinalized resumable upload please use
   * `CancelResumableWrite`.
   * </pre>
   *
   * <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The object.
   */
  @java.lang.Override
  public java.lang.String getObject() {
    java.lang.Object ref = object_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      object_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the finalized object to delete.
   * Note: If you want to delete an unfinalized resumable upload please use
   * `CancelResumableWrite`.
   * </pre>
   *
   * <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for object.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getObjectBytes() {
    java.lang.Object ref = object_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      object_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GENERATION_FIELD_NUMBER = 4;
  private long generation_ = 0L;
  /**
   *
   *
   * <pre>
   * If present, permanently deletes a specific revision of this object (as
   * opposed to the latest version, the default).
   * </pre>
   *
   * <code>int64 generation = 4;</code>
   *
   * @return The generation.
   */
  @java.lang.Override
  public long getGeneration() {
    return generation_;
  }

  public static final int IF_GENERATION_MATCH_FIELD_NUMBER = 5;
  private long ifGenerationMatch_ = 0L;
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current generation
   * matches the given value. Setting to 0 makes the operation succeed only if
   * there are no live versions of the object.
   * </pre>
   *
   * <code>optional int64 if_generation_match = 5;</code>
   *
   * @return Whether the ifGenerationMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfGenerationMatch() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current generation
   * matches the given value. Setting to 0 makes the operation succeed only if
   * there are no live versions of the object.
   * </pre>
   *
   * <code>optional int64 if_generation_match = 5;</code>
   *
   * @return The ifGenerationMatch.
   */
  @java.lang.Override
  public long getIfGenerationMatch() {
    return ifGenerationMatch_;
  }

  public static final int IF_GENERATION_NOT_MATCH_FIELD_NUMBER = 6;
  private long ifGenerationNotMatch_ = 0L;
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's live generation
   * does not match the given value. If no live object exists, the precondition
   * fails. Setting to 0 makes the operation succeed only if there is a live
   * version of the object.
   * </pre>
   *
   * <code>optional int64 if_generation_not_match = 6;</code>
   *
   * @return Whether the ifGenerationNotMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfGenerationNotMatch() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's live generation
   * does not match the given value. If no live object exists, the precondition
   * fails. Setting to 0 makes the operation succeed only if there is a live
   * version of the object.
   * </pre>
   *
   * <code>optional int64 if_generation_not_match = 6;</code>
   *
   * @return The ifGenerationNotMatch.
   */
  @java.lang.Override
  public long getIfGenerationNotMatch() {
    return ifGenerationNotMatch_;
  }

  public static final int IF_METAGENERATION_MATCH_FIELD_NUMBER = 7;
  private long ifMetagenerationMatch_ = 0L;
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * metageneration matches the given value.
   * </pre>
   *
   * <code>optional int64 if_metageneration_match = 7;</code>
   *
   * @return Whether the ifMetagenerationMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfMetagenerationMatch() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * metageneration matches the given value.
   * </pre>
   *
   * <code>optional int64 if_metageneration_match = 7;</code>
   *
   * @return The ifMetagenerationMatch.
   */
  @java.lang.Override
  public long getIfMetagenerationMatch() {
    return ifMetagenerationMatch_;
  }

  public static final int IF_METAGENERATION_NOT_MATCH_FIELD_NUMBER = 8;
  private long ifMetagenerationNotMatch_ = 0L;
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * metageneration does not match the given value.
   * </pre>
   *
   * <code>optional int64 if_metageneration_not_match = 8;</code>
   *
   * @return Whether the ifMetagenerationNotMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfMetagenerationNotMatch() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * metageneration does not match the given value.
   * </pre>
   *
   * <code>optional int64 if_metageneration_not_match = 8;</code>
   *
   * @return The ifMetagenerationNotMatch.
   */
  @java.lang.Override
  public long getIfMetagenerationNotMatch() {
    return ifMetagenerationNotMatch_;
  }

  public static final int COMMON_OBJECT_REQUEST_PARAMS_FIELD_NUMBER = 10;
  private com.google.storage.v2.CommonObjectRequestParams commonObjectRequestParams_;
  /**
   *
   *
   * <pre>
   * A set of parameters common to Storage API requests concerning an object.
   * </pre>
   *
   * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 10;</code>
   *
   * @return Whether the commonObjectRequestParams field is set.
   */
  @java.lang.Override
  public boolean hasCommonObjectRequestParams() {
    return commonObjectRequestParams_ != null;
  }
  /**
   *
   *
   * <pre>
   * A set of parameters common to Storage API requests concerning an object.
   * </pre>
   *
   * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 10;</code>
   *
   * @return The commonObjectRequestParams.
   */
  @java.lang.Override
  public com.google.storage.v2.CommonObjectRequestParams getCommonObjectRequestParams() {
    return commonObjectRequestParams_ == null
        ? com.google.storage.v2.CommonObjectRequestParams.getDefaultInstance()
        : commonObjectRequestParams_;
  }
  /**
   *
   *
   * <pre>
   * A set of parameters common to Storage API requests concerning an object.
   * </pre>
   *
   * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 10;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.CommonObjectRequestParamsOrBuilder
      getCommonObjectRequestParamsOrBuilder() {
    return commonObjectRequestParams_ == null
        ? com.google.storage.v2.CommonObjectRequestParams.getDefaultInstance()
        : commonObjectRequestParams_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucket_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, bucket_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(object_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, object_);
    }
    if (generation_ != 0L) {
      output.writeInt64(4, generation_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt64(5, ifGenerationMatch_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeInt64(6, ifGenerationNotMatch_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeInt64(7, ifMetagenerationMatch_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeInt64(8, ifMetagenerationNotMatch_);
    }
    if (commonObjectRequestParams_ != null) {
      output.writeMessage(10, getCommonObjectRequestParams());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucket_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, bucket_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(object_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, object_);
    }
    if (generation_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, generation_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(5, ifGenerationMatch_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(6, ifGenerationNotMatch_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(7, ifMetagenerationMatch_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(8, ifMetagenerationNotMatch_);
    }
    if (commonObjectRequestParams_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, getCommonObjectRequestParams());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.storage.v2.DeleteObjectRequest)) {
      return super.equals(obj);
    }
    com.google.storage.v2.DeleteObjectRequest other =
        (com.google.storage.v2.DeleteObjectRequest) obj;

    if (!getBucket().equals(other.getBucket())) return false;
    if (!getObject().equals(other.getObject())) return false;
    if (getGeneration() != other.getGeneration()) return false;
    if (hasIfGenerationMatch() != other.hasIfGenerationMatch()) return false;
    if (hasIfGenerationMatch()) {
      if (getIfGenerationMatch() != other.getIfGenerationMatch()) return false;
    }
    if (hasIfGenerationNotMatch() != other.hasIfGenerationNotMatch()) return false;
    if (hasIfGenerationNotMatch()) {
      if (getIfGenerationNotMatch() != other.getIfGenerationNotMatch()) return false;
    }
    if (hasIfMetagenerationMatch() != other.hasIfMetagenerationMatch()) return false;
    if (hasIfMetagenerationMatch()) {
      if (getIfMetagenerationMatch() != other.getIfMetagenerationMatch()) return false;
    }
    if (hasIfMetagenerationNotMatch() != other.hasIfMetagenerationNotMatch()) return false;
    if (hasIfMetagenerationNotMatch()) {
      if (getIfMetagenerationNotMatch() != other.getIfMetagenerationNotMatch()) return false;
    }
    if (hasCommonObjectRequestParams() != other.hasCommonObjectRequestParams()) return false;
    if (hasCommonObjectRequestParams()) {
      if (!getCommonObjectRequestParams().equals(other.getCommonObjectRequestParams()))
        return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + BUCKET_FIELD_NUMBER;
    hash = (53 * hash) + getBucket().hashCode();
    hash = (37 * hash) + OBJECT_FIELD_NUMBER;
    hash = (53 * hash) + getObject().hashCode();
    hash = (37 * hash) + GENERATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getGeneration());
    if (hasIfGenerationMatch()) {
      hash = (37 * hash) + IF_GENERATION_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfGenerationMatch());
    }
    if (hasIfGenerationNotMatch()) {
      hash = (37 * hash) + IF_GENERATION_NOT_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfGenerationNotMatch());
    }
    if (hasIfMetagenerationMatch()) {
      hash = (37 * hash) + IF_METAGENERATION_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfMetagenerationMatch());
    }
    if (hasIfMetagenerationNotMatch()) {
      hash = (37 * hash) + IF_METAGENERATION_NOT_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfMetagenerationNotMatch());
    }
    if (hasCommonObjectRequestParams()) {
      hash = (37 * hash) + COMMON_OBJECT_REQUEST_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getCommonObjectRequestParams().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.storage.v2.DeleteObjectRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.DeleteObjectRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.DeleteObjectRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.DeleteObjectRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.DeleteObjectRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.DeleteObjectRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.DeleteObjectRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.DeleteObjectRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.DeleteObjectRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.DeleteObjectRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.DeleteObjectRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.DeleteObjectRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.storage.v2.DeleteObjectRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Message for deleting an object.
   * `bucket` and `object` **must** be set.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.DeleteObjectRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.storage.v2.DeleteObjectRequest)
      com.google.storage.v2.DeleteObjectRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_DeleteObjectRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_DeleteObjectRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.DeleteObjectRequest.class,
              com.google.storage.v2.DeleteObjectRequest.Builder.class);
    }

    // Construct using com.google.storage.v2.DeleteObjectRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      bucket_ = "";
      object_ = "";
      generation_ = 0L;
      ifGenerationMatch_ = 0L;
      ifGenerationNotMatch_ = 0L;
      ifMetagenerationMatch_ = 0L;
      ifMetagenerationNotMatch_ = 0L;
      commonObjectRequestParams_ = null;
      if (commonObjectRequestParamsBuilder_ != null) {
        commonObjectRequestParamsBuilder_.dispose();
        commonObjectRequestParamsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_DeleteObjectRequest_descriptor;
    }

    @java.lang.Override
    public com.google.storage.v2.DeleteObjectRequest getDefaultInstanceForType() {
      return com.google.storage.v2.DeleteObjectRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.storage.v2.DeleteObjectRequest build() {
      com.google.storage.v2.DeleteObjectRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.storage.v2.DeleteObjectRequest buildPartial() {
      com.google.storage.v2.DeleteObjectRequest result =
          new com.google.storage.v2.DeleteObjectRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.storage.v2.DeleteObjectRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.bucket_ = bucket_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.object_ = object_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.generation_ = generation_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.ifGenerationMatch_ = ifGenerationMatch_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.ifGenerationNotMatch_ = ifGenerationNotMatch_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.ifMetagenerationMatch_ = ifMetagenerationMatch_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.ifMetagenerationNotMatch_ = ifMetagenerationNotMatch_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.commonObjectRequestParams_ =
            commonObjectRequestParamsBuilder_ == null
                ? commonObjectRequestParams_
                : commonObjectRequestParamsBuilder_.build();
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.storage.v2.DeleteObjectRequest) {
        return mergeFrom((com.google.storage.v2.DeleteObjectRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.storage.v2.DeleteObjectRequest other) {
      if (other == com.google.storage.v2.DeleteObjectRequest.getDefaultInstance()) return this;
      if (!other.getBucket().isEmpty()) {
        bucket_ = other.bucket_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getObject().isEmpty()) {
        object_ = other.object_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getGeneration() != 0L) {
        setGeneration(other.getGeneration());
      }
      if (other.hasIfGenerationMatch()) {
        setIfGenerationMatch(other.getIfGenerationMatch());
      }
      if (other.hasIfGenerationNotMatch()) {
        setIfGenerationNotMatch(other.getIfGenerationNotMatch());
      }
      if (other.hasIfMetagenerationMatch()) {
        setIfMetagenerationMatch(other.getIfMetagenerationMatch());
      }
      if (other.hasIfMetagenerationNotMatch()) {
        setIfMetagenerationNotMatch(other.getIfMetagenerationNotMatch());
      }
      if (other.hasCommonObjectRequestParams()) {
        mergeCommonObjectRequestParams(other.getCommonObjectRequestParams());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                bucket_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                object_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 32:
              {
                generation_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 32
            case 40:
              {
                ifGenerationMatch_ = input.readInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case 40
            case 48:
              {
                ifGenerationNotMatch_ = input.readInt64();
                bitField0_ |= 0x00000010;
                break;
              } // case 48
            case 56:
              {
                ifMetagenerationMatch_ = input.readInt64();
                bitField0_ |= 0x00000020;
                break;
              } // case 56
            case 64:
              {
                ifMetagenerationNotMatch_ = input.readInt64();
                bitField0_ |= 0x00000040;
                break;
              } // case 64
            case 82:
              {
                input.readMessage(
                    getCommonObjectRequestParamsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object bucket_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the bucket in which the object resides.
     * </pre>
     *
     * <code>
     * string bucket = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bucket.
     */
    public java.lang.String getBucket() {
      java.lang.Object ref = bucket_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bucket_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the bucket in which the object resides.
     * </pre>
     *
     * <code>
     * string bucket = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for bucket.
     */
    public com.google.protobuf.ByteString getBucketBytes() {
      java.lang.Object ref = bucket_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bucket_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the bucket in which the object resides.
     * </pre>
     *
     * <code>
     * string bucket = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bucket to set.
     * @return This builder for chaining.
     */
    public Builder setBucket(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bucket_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the bucket in which the object resides.
     * </pre>
     *
     * <code>
     * string bucket = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBucket() {
      bucket_ = getDefaultInstance().getBucket();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the bucket in which the object resides.
     * </pre>
     *
     * <code>
     * string bucket = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for bucket to set.
     * @return This builder for chaining.
     */
    public Builder setBucketBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      bucket_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object object_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the finalized object to delete.
     * Note: If you want to delete an unfinalized resumable upload please use
     * `CancelResumableWrite`.
     * </pre>
     *
     * <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The object.
     */
    public java.lang.String getObject() {
      java.lang.Object ref = object_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        object_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the finalized object to delete.
     * Note: If you want to delete an unfinalized resumable upload please use
     * `CancelResumableWrite`.
     * </pre>
     *
     * <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for object.
     */
    public com.google.protobuf.ByteString getObjectBytes() {
      java.lang.Object ref = object_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        object_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the finalized object to delete.
     * Note: If you want to delete an unfinalized resumable upload please use
     * `CancelResumableWrite`.
     * </pre>
     *
     * <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The object to set.
     * @return This builder for chaining.
     */
    public Builder setObject(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      object_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the finalized object to delete.
     * Note: If you want to delete an unfinalized resumable upload please use
     * `CancelResumableWrite`.
     * </pre>
     *
     * <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearObject() {
      object_ = getDefaultInstance().getObject();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the finalized object to delete.
     * Note: If you want to delete an unfinalized resumable upload please use
     * `CancelResumableWrite`.
     * </pre>
     *
     * <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for object to set.
     * @return This builder for chaining.
     */
    public Builder setObjectBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      object_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private long generation_;
    /**
     *
     *
     * <pre>
     * If present, permanently deletes a specific revision of this object (as
     * opposed to the latest version, the default).
     * </pre>
     *
     * <code>int64 generation = 4;</code>
     *
     * @return The generation.
     */
    @java.lang.Override
    public long getGeneration() {
      return generation_;
    }
    /**
     *
     *
     * <pre>
     * If present, permanently deletes a specific revision of this object (as
     * opposed to the latest version, the default).
     * </pre>
     *
     * <code>int64 generation = 4;</code>
     *
     * @param value The generation to set.
     * @return This builder for chaining.
     */
    public Builder setGeneration(long value) {

      generation_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, permanently deletes a specific revision of this object (as
     * opposed to the latest version, the default).
     * </pre>
     *
     * <code>int64 generation = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGeneration() {
      bitField0_ = (bitField0_ & ~0x00000004);
      generation_ = 0L;
      onChanged();
      return this;
    }

    private long ifGenerationMatch_;
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current generation
     * matches the given value. Setting to 0 makes the operation succeed only if
     * there are no live versions of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_match = 5;</code>
     *
     * @return Whether the ifGenerationMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfGenerationMatch() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current generation
     * matches the given value. Setting to 0 makes the operation succeed only if
     * there are no live versions of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_match = 5;</code>
     *
     * @return The ifGenerationMatch.
     */
    @java.lang.Override
    public long getIfGenerationMatch() {
      return ifGenerationMatch_;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current generation
     * matches the given value. Setting to 0 makes the operation succeed only if
     * there are no live versions of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_match = 5;</code>
     *
     * @param value The ifGenerationMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfGenerationMatch(long value) {

      ifGenerationMatch_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current generation
     * matches the given value. Setting to 0 makes the operation succeed only if
     * there are no live versions of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_match = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfGenerationMatch() {
      bitField0_ = (bitField0_ & ~0x00000008);
      ifGenerationMatch_ = 0L;
      onChanged();
      return this;
    }

    private long ifGenerationNotMatch_;
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's live generation
     * does not match the given value. If no live object exists, the precondition
     * fails. Setting to 0 makes the operation succeed only if there is a live
     * version of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_not_match = 6;</code>
     *
     * @return Whether the ifGenerationNotMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfGenerationNotMatch() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's live generation
     * does not match the given value. If no live object exists, the precondition
     * fails. Setting to 0 makes the operation succeed only if there is a live
     * version of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_not_match = 6;</code>
     *
     * @return The ifGenerationNotMatch.
     */
    @java.lang.Override
    public long getIfGenerationNotMatch() {
      return ifGenerationNotMatch_;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's live generation
     * does not match the given value. If no live object exists, the precondition
     * fails. Setting to 0 makes the operation succeed only if there is a live
     * version of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_not_match = 6;</code>
     *
     * @param value The ifGenerationNotMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfGenerationNotMatch(long value) {

      ifGenerationNotMatch_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's live generation
     * does not match the given value. If no live object exists, the precondition
     * fails. Setting to 0 makes the operation succeed only if there is a live
     * version of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_not_match = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfGenerationNotMatch() {
      bitField0_ = (bitField0_ & ~0x00000010);
      ifGenerationNotMatch_ = 0L;
      onChanged();
      return this;
    }

    private long ifMetagenerationMatch_;
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration matches the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_match = 7;</code>
     *
     * @return Whether the ifMetagenerationMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfMetagenerationMatch() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration matches the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_match = 7;</code>
     *
     * @return The ifMetagenerationMatch.
     */
    @java.lang.Override
    public long getIfMetagenerationMatch() {
      return ifMetagenerationMatch_;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration matches the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_match = 7;</code>
     *
     * @param value The ifMetagenerationMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfMetagenerationMatch(long value) {

      ifMetagenerationMatch_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration matches the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_match = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfMetagenerationMatch() {
      bitField0_ = (bitField0_ & ~0x00000020);
      ifMetagenerationMatch_ = 0L;
      onChanged();
      return this;
    }

    private long ifMetagenerationNotMatch_;
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration does not match the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_not_match = 8;</code>
     *
     * @return Whether the ifMetagenerationNotMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfMetagenerationNotMatch() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration does not match the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_not_match = 8;</code>
     *
     * @return The ifMetagenerationNotMatch.
     */
    @java.lang.Override
    public long getIfMetagenerationNotMatch() {
      return ifMetagenerationNotMatch_;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration does not match the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_not_match = 8;</code>
     *
     * @param value The ifMetagenerationNotMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfMetagenerationNotMatch(long value) {

      ifMetagenerationNotMatch_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration does not match the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_not_match = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfMetagenerationNotMatch() {
      bitField0_ = (bitField0_ & ~0x00000040);
      ifMetagenerationNotMatch_ = 0L;
      onChanged();
      return this;
    }

    private com.google.storage.v2.CommonObjectRequestParams commonObjectRequestParams_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.CommonObjectRequestParams,
            com.google.storage.v2.CommonObjectRequestParams.Builder,
            com.google.storage.v2.CommonObjectRequestParamsOrBuilder>
        commonObjectRequestParamsBuilder_;
    /**
     *
     *
     * <pre>
     * A set of parameters common to Storage API requests concerning an object.
     * </pre>
     *
     * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 10;</code>
     *
     * @return Whether the commonObjectRequestParams field is set.
     */
    public boolean hasCommonObjectRequestParams() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * A set of parameters common to Storage API requests concerning an object.
     * </pre>
     *
     * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 10;</code>
     *
     * @return The commonObjectRequestParams.
     */
    public com.google.storage.v2.CommonObjectRequestParams getCommonObjectRequestParams() {
      if (commonObjectRequestParamsBuilder_ == null) {
        return commonObjectRequestParams_ == null
            ? com.google.storage.v2.CommonObjectRequestParams.getDefaultInstance()
            : commonObjectRequestParams_;
      } else {
        return commonObjectRequestParamsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A set of parameters common to Storage API requests concerning an object.
     * </pre>
     *
     * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 10;</code>
     */
    public Builder setCommonObjectRequestParams(
        com.google.storage.v2.CommonObjectRequestParams value) {
      if (commonObjectRequestParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        commonObjectRequestParams_ = value;
      } else {
        commonObjectRequestParamsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of parameters common to Storage API requests concerning an object.
     * </pre>
     *
     * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 10;</code>
     */
    public Builder setCommonObjectRequestParams(
        com.google.storage.v2.CommonObjectRequestParams.Builder builderForValue) {
      if (commonObjectRequestParamsBuilder_ == null) {
        commonObjectRequestParams_ = builderForValue.build();
      } else {
        commonObjectRequestParamsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of parameters common to Storage API requests concerning an object.
     * </pre>
     *
     * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 10;</code>
     */
    public Builder mergeCommonObjectRequestParams(
        com.google.storage.v2.CommonObjectRequestParams value) {
      if (commonObjectRequestParamsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && commonObjectRequestParams_ != null
            && commonObjectRequestParams_
                != com.google.storage.v2.CommonObjectRequestParams.getDefaultInstance()) {
          getCommonObjectRequestParamsBuilder().mergeFrom(value);
        } else {
          commonObjectRequestParams_ = value;
        }
      } else {
        commonObjectRequestParamsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of parameters common to Storage API requests concerning an object.
     * </pre>
     *
     * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 10;</code>
     */
    public Builder clearCommonObjectRequestParams() {
      bitField0_ = (bitField0_ & ~0x00000080);
      commonObjectRequestParams_ = null;
      if (commonObjectRequestParamsBuilder_ != null) {
        commonObjectRequestParamsBuilder_.dispose();
        commonObjectRequestParamsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of parameters common to Storage API requests concerning an object.
     * </pre>
     *
     * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 10;</code>
     */
    public com.google.storage.v2.CommonObjectRequestParams.Builder
        getCommonObjectRequestParamsBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getCommonObjectRequestParamsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A set of parameters common to Storage API requests concerning an object.
     * </pre>
     *
     * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 10;</code>
     */
    public com.google.storage.v2.CommonObjectRequestParamsOrBuilder
        getCommonObjectRequestParamsOrBuilder() {
      if (commonObjectRequestParamsBuilder_ != null) {
        return commonObjectRequestParamsBuilder_.getMessageOrBuilder();
      } else {
        return commonObjectRequestParams_ == null
            ? com.google.storage.v2.CommonObjectRequestParams.getDefaultInstance()
            : commonObjectRequestParams_;
      }
    }
    /**
     *
     *
     * <pre>
     * A set of parameters common to Storage API requests concerning an object.
     * </pre>
     *
     * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.CommonObjectRequestParams,
            com.google.storage.v2.CommonObjectRequestParams.Builder,
            com.google.storage.v2.CommonObjectRequestParamsOrBuilder>
        getCommonObjectRequestParamsFieldBuilder() {
      if (commonObjectRequestParamsBuilder_ == null) {
        commonObjectRequestParamsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.CommonObjectRequestParams,
                com.google.storage.v2.CommonObjectRequestParams.Builder,
                com.google.storage.v2.CommonObjectRequestParamsOrBuilder>(
                getCommonObjectRequestParams(), getParentForChildren(), isClean());
        commonObjectRequestParams_ = null;
      }
      return commonObjectRequestParamsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.storage.v2.DeleteObjectRequest)
  }

  // @@protoc_insertion_point(class_scope:google.storage.v2.DeleteObjectRequest)
  private static final com.google.storage.v2.DeleteObjectRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.storage.v2.DeleteObjectRequest();
  }

  public static com.google.storage.v2.DeleteObjectRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DeleteObjectRequest> PARSER =
      new com.google.protobuf.AbstractParser<DeleteObjectRequest>() {
        @java.lang.Override
        public DeleteObjectRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DeleteObjectRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DeleteObjectRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.storage.v2.DeleteObjectRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
