/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/v2/storage.proto

package com.google.storage.v2;

/**
 *
 *
 * <pre>
 * Request message for RewriteObject.
 * If the source object is encrypted using a Customer-Supplied Encryption Key
 * the key information must be provided in the copy_source_encryption_algorithm,
 * copy_source_encryption_key_bytes, and copy_source_encryption_key_sha256_bytes
 * fields. If the destination object should be encrypted the keying information
 * should be provided in the encryption_algorithm, encryption_key_bytes, and
 * encryption_key_sha256_bytes fields of the
 * common_object_request_params.customer_encryption field.
 * </pre>
 *
 * Protobuf type {@code google.storage.v2.RewriteObjectRequest}
 */
public final class RewriteObjectRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.storage.v2.RewriteObjectRequest)
    RewriteObjectRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RewriteObjectRequest.newBuilder() to construct.
  private RewriteObjectRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RewriteObjectRequest() {
    destinationName_ = "";
    destinationBucket_ = "";
    destinationKmsKey_ = "";
    sourceBucket_ = "";
    sourceObject_ = "";
    rewriteToken_ = "";
    destinationPredefinedAcl_ = "";
    copySourceEncryptionAlgorithm_ = "";
    copySourceEncryptionKeyBytes_ = com.google.protobuf.ByteString.EMPTY;
    copySourceEncryptionKeySha256Bytes_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RewriteObjectRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_RewriteObjectRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_RewriteObjectRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.storage.v2.RewriteObjectRequest.class,
            com.google.storage.v2.RewriteObjectRequest.Builder.class);
  }

  private int bitField0_;
  public static final int DESTINATION_NAME_FIELD_NUMBER = 24;

  @SuppressWarnings("serial")
  private volatile java.lang.Object destinationName_ = "";
  /**
   *
   *
   * <pre>
   * Required. Immutable. The name of the destination object.
   * See the
   * [Naming Guidelines](https://cloud.google.com/storage/docs/objects#naming).
   * Example: `test.txt`
   * The `name` field by itself does not uniquely identify a Cloud Storage
   * object. A Cloud Storage object is uniquely identified by the tuple of
   * (bucket, object, generation).
   * </pre>
   *
   * <code>
   * string destination_name = 24 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The destinationName.
   */
  @java.lang.Override
  public java.lang.String getDestinationName() {
    java.lang.Object ref = destinationName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      destinationName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. The name of the destination object.
   * See the
   * [Naming Guidelines](https://cloud.google.com/storage/docs/objects#naming).
   * Example: `test.txt`
   * The `name` field by itself does not uniquely identify a Cloud Storage
   * object. A Cloud Storage object is uniquely identified by the tuple of
   * (bucket, object, generation).
   * </pre>
   *
   * <code>
   * string destination_name = 24 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The bytes for destinationName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDestinationNameBytes() {
    java.lang.Object ref = destinationName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      destinationName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESTINATION_BUCKET_FIELD_NUMBER = 25;

  @SuppressWarnings("serial")
  private volatile java.lang.Object destinationBucket_ = "";
  /**
   *
   *
   * <pre>
   * Required. Immutable. The name of the bucket containing the destination
   * object.
   * </pre>
   *
   * <code>
   * string destination_bucket = 25 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The destinationBucket.
   */
  @java.lang.Override
  public java.lang.String getDestinationBucket() {
    java.lang.Object ref = destinationBucket_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      destinationBucket_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. The name of the bucket containing the destination
   * object.
   * </pre>
   *
   * <code>
   * string destination_bucket = 25 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for destinationBucket.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDestinationBucketBytes() {
    java.lang.Object ref = destinationBucket_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      destinationBucket_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESTINATION_KMS_KEY_FIELD_NUMBER = 27;

  @SuppressWarnings("serial")
  private volatile java.lang.Object destinationKmsKey_ = "";
  /**
   *
   *
   * <pre>
   * The name of the Cloud KMS key that will be used to encrypt the destination
   * object. The Cloud KMS key must be located in same location as the object.
   * If the parameter is not specified, the request uses the destination
   * bucket's default encryption key, if any, or else the Google-managed
   * encryption key.
   * </pre>
   *
   * <code>string destination_kms_key = 27 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The destinationKmsKey.
   */
  @java.lang.Override
  public java.lang.String getDestinationKmsKey() {
    java.lang.Object ref = destinationKmsKey_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      destinationKmsKey_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the Cloud KMS key that will be used to encrypt the destination
   * object. The Cloud KMS key must be located in same location as the object.
   * If the parameter is not specified, the request uses the destination
   * bucket's default encryption key, if any, or else the Google-managed
   * encryption key.
   * </pre>
   *
   * <code>string destination_kms_key = 27 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for destinationKmsKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDestinationKmsKeyBytes() {
    java.lang.Object ref = destinationKmsKey_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      destinationKmsKey_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESTINATION_FIELD_NUMBER = 1;
  private com.google.storage.v2.Object destination_;
  /**
   *
   *
   * <pre>
   * Properties of the destination, post-rewrite object.
   * The `name`, `bucket` and `kms_key` fields must not be populated (these
   * values are specified in the `destination_name`, `destination_bucket`, and
   * `destination_kms_key` fields).
   * If `destination` is present it will be used to construct the destination
   * object's metadata; otherwise the destination object's metadata will be
   * copied from the source object.
   * </pre>
   *
   * <code>.google.storage.v2.Object destination = 1;</code>
   *
   * @return Whether the destination field is set.
   */
  @java.lang.Override
  public boolean hasDestination() {
    return destination_ != null;
  }
  /**
   *
   *
   * <pre>
   * Properties of the destination, post-rewrite object.
   * The `name`, `bucket` and `kms_key` fields must not be populated (these
   * values are specified in the `destination_name`, `destination_bucket`, and
   * `destination_kms_key` fields).
   * If `destination` is present it will be used to construct the destination
   * object's metadata; otherwise the destination object's metadata will be
   * copied from the source object.
   * </pre>
   *
   * <code>.google.storage.v2.Object destination = 1;</code>
   *
   * @return The destination.
   */
  @java.lang.Override
  public com.google.storage.v2.Object getDestination() {
    return destination_ == null ? com.google.storage.v2.Object.getDefaultInstance() : destination_;
  }
  /**
   *
   *
   * <pre>
   * Properties of the destination, post-rewrite object.
   * The `name`, `bucket` and `kms_key` fields must not be populated (these
   * values are specified in the `destination_name`, `destination_bucket`, and
   * `destination_kms_key` fields).
   * If `destination` is present it will be used to construct the destination
   * object's metadata; otherwise the destination object's metadata will be
   * copied from the source object.
   * </pre>
   *
   * <code>.google.storage.v2.Object destination = 1;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.ObjectOrBuilder getDestinationOrBuilder() {
    return destination_ == null ? com.google.storage.v2.Object.getDefaultInstance() : destination_;
  }

  public static final int SOURCE_BUCKET_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceBucket_ = "";
  /**
   *
   *
   * <pre>
   * Required. Name of the bucket in which to find the source object.
   * </pre>
   *
   * <code>
   * string source_bucket = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The sourceBucket.
   */
  @java.lang.Override
  public java.lang.String getSourceBucket() {
    java.lang.Object ref = sourceBucket_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceBucket_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Name of the bucket in which to find the source object.
   * </pre>
   *
   * <code>
   * string source_bucket = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for sourceBucket.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceBucketBytes() {
    java.lang.Object ref = sourceBucket_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceBucket_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_OBJECT_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceObject_ = "";
  /**
   *
   *
   * <pre>
   * Required. Name of the source object.
   * </pre>
   *
   * <code>string source_object = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The sourceObject.
   */
  @java.lang.Override
  public java.lang.String getSourceObject() {
    java.lang.Object ref = sourceObject_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceObject_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Name of the source object.
   * </pre>
   *
   * <code>string source_object = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for sourceObject.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceObjectBytes() {
    java.lang.Object ref = sourceObject_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceObject_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_GENERATION_FIELD_NUMBER = 4;
  private long sourceGeneration_ = 0L;
  /**
   *
   *
   * <pre>
   * If present, selects a specific revision of the source object (as opposed to
   * the latest version, the default).
   * </pre>
   *
   * <code>int64 source_generation = 4;</code>
   *
   * @return The sourceGeneration.
   */
  @java.lang.Override
  public long getSourceGeneration() {
    return sourceGeneration_;
  }

  public static final int REWRITE_TOKEN_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object rewriteToken_ = "";
  /**
   *
   *
   * <pre>
   * Include this field (from the previous rewrite response) on each rewrite
   * request after the first one, until the rewrite response 'done' flag is
   * true. Calls that provide a rewriteToken can omit all other request fields,
   * but if included those fields must match the values provided in the first
   * rewrite request.
   * </pre>
   *
   * <code>string rewrite_token = 5;</code>
   *
   * @return The rewriteToken.
   */
  @java.lang.Override
  public java.lang.String getRewriteToken() {
    java.lang.Object ref = rewriteToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      rewriteToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Include this field (from the previous rewrite response) on each rewrite
   * request after the first one, until the rewrite response 'done' flag is
   * true. Calls that provide a rewriteToken can omit all other request fields,
   * but if included those fields must match the values provided in the first
   * rewrite request.
   * </pre>
   *
   * <code>string rewrite_token = 5;</code>
   *
   * @return The bytes for rewriteToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRewriteTokenBytes() {
    java.lang.Object ref = rewriteToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      rewriteToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESTINATION_PREDEFINED_ACL_FIELD_NUMBER = 28;

  @SuppressWarnings("serial")
  private volatile java.lang.Object destinationPredefinedAcl_ = "";
  /**
   *
   *
   * <pre>
   * Apply a predefined set of access controls to the destination object.
   * Valid values are "authenticatedRead", "bucketOwnerFullControl",
   * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
   * </pre>
   *
   * <code>string destination_predefined_acl = 28;</code>
   *
   * @return The destinationPredefinedAcl.
   */
  @java.lang.Override
  public java.lang.String getDestinationPredefinedAcl() {
    java.lang.Object ref = destinationPredefinedAcl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      destinationPredefinedAcl_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Apply a predefined set of access controls to the destination object.
   * Valid values are "authenticatedRead", "bucketOwnerFullControl",
   * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
   * </pre>
   *
   * <code>string destination_predefined_acl = 28;</code>
   *
   * @return The bytes for destinationPredefinedAcl.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDestinationPredefinedAclBytes() {
    java.lang.Object ref = destinationPredefinedAcl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      destinationPredefinedAcl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IF_GENERATION_MATCH_FIELD_NUMBER = 7;
  private long ifGenerationMatch_ = 0L;
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current generation
   * matches the given value. Setting to 0 makes the operation succeed only if
   * there are no live versions of the object.
   * </pre>
   *
   * <code>optional int64 if_generation_match = 7;</code>
   *
   * @return Whether the ifGenerationMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfGenerationMatch() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current generation
   * matches the given value. Setting to 0 makes the operation succeed only if
   * there are no live versions of the object.
   * </pre>
   *
   * <code>optional int64 if_generation_match = 7;</code>
   *
   * @return The ifGenerationMatch.
   */
  @java.lang.Override
  public long getIfGenerationMatch() {
    return ifGenerationMatch_;
  }

  public static final int IF_GENERATION_NOT_MATCH_FIELD_NUMBER = 8;
  private long ifGenerationNotMatch_ = 0L;
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's live generation
   * does not match the given value. If no live object exists, the precondition
   * fails. Setting to 0 makes the operation succeed only if there is a live
   * version of the object.
   * </pre>
   *
   * <code>optional int64 if_generation_not_match = 8;</code>
   *
   * @return Whether the ifGenerationNotMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfGenerationNotMatch() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's live generation
   * does not match the given value. If no live object exists, the precondition
   * fails. Setting to 0 makes the operation succeed only if there is a live
   * version of the object.
   * </pre>
   *
   * <code>optional int64 if_generation_not_match = 8;</code>
   *
   * @return The ifGenerationNotMatch.
   */
  @java.lang.Override
  public long getIfGenerationNotMatch() {
    return ifGenerationNotMatch_;
  }

  public static final int IF_METAGENERATION_MATCH_FIELD_NUMBER = 9;
  private long ifMetagenerationMatch_ = 0L;
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the destination object's current
   * metageneration matches the given value.
   * </pre>
   *
   * <code>optional int64 if_metageneration_match = 9;</code>
   *
   * @return Whether the ifMetagenerationMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfMetagenerationMatch() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the destination object's current
   * metageneration matches the given value.
   * </pre>
   *
   * <code>optional int64 if_metageneration_match = 9;</code>
   *
   * @return The ifMetagenerationMatch.
   */
  @java.lang.Override
  public long getIfMetagenerationMatch() {
    return ifMetagenerationMatch_;
  }

  public static final int IF_METAGENERATION_NOT_MATCH_FIELD_NUMBER = 10;
  private long ifMetagenerationNotMatch_ = 0L;
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the destination object's current
   * metageneration does not match the given value.
   * </pre>
   *
   * <code>optional int64 if_metageneration_not_match = 10;</code>
   *
   * @return Whether the ifMetagenerationNotMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfMetagenerationNotMatch() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the destination object's current
   * metageneration does not match the given value.
   * </pre>
   *
   * <code>optional int64 if_metageneration_not_match = 10;</code>
   *
   * @return The ifMetagenerationNotMatch.
   */
  @java.lang.Override
  public long getIfMetagenerationNotMatch() {
    return ifMetagenerationNotMatch_;
  }

  public static final int IF_SOURCE_GENERATION_MATCH_FIELD_NUMBER = 11;
  private long ifSourceGenerationMatch_ = 0L;
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the source object's live
   * generation matches the given value.
   * </pre>
   *
   * <code>optional int64 if_source_generation_match = 11;</code>
   *
   * @return Whether the ifSourceGenerationMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfSourceGenerationMatch() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the source object's live
   * generation matches the given value.
   * </pre>
   *
   * <code>optional int64 if_source_generation_match = 11;</code>
   *
   * @return The ifSourceGenerationMatch.
   */
  @java.lang.Override
  public long getIfSourceGenerationMatch() {
    return ifSourceGenerationMatch_;
  }

  public static final int IF_SOURCE_GENERATION_NOT_MATCH_FIELD_NUMBER = 12;
  private long ifSourceGenerationNotMatch_ = 0L;
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the source object's live
   * generation does not match the given value.
   * </pre>
   *
   * <code>optional int64 if_source_generation_not_match = 12;</code>
   *
   * @return Whether the ifSourceGenerationNotMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfSourceGenerationNotMatch() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the source object's live
   * generation does not match the given value.
   * </pre>
   *
   * <code>optional int64 if_source_generation_not_match = 12;</code>
   *
   * @return The ifSourceGenerationNotMatch.
   */
  @java.lang.Override
  public long getIfSourceGenerationNotMatch() {
    return ifSourceGenerationNotMatch_;
  }

  public static final int IF_SOURCE_METAGENERATION_MATCH_FIELD_NUMBER = 13;
  private long ifSourceMetagenerationMatch_ = 0L;
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the source object's current
   * metageneration matches the given value.
   * </pre>
   *
   * <code>optional int64 if_source_metageneration_match = 13;</code>
   *
   * @return Whether the ifSourceMetagenerationMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfSourceMetagenerationMatch() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the source object's current
   * metageneration matches the given value.
   * </pre>
   *
   * <code>optional int64 if_source_metageneration_match = 13;</code>
   *
   * @return The ifSourceMetagenerationMatch.
   */
  @java.lang.Override
  public long getIfSourceMetagenerationMatch() {
    return ifSourceMetagenerationMatch_;
  }

  public static final int IF_SOURCE_METAGENERATION_NOT_MATCH_FIELD_NUMBER = 14;
  private long ifSourceMetagenerationNotMatch_ = 0L;
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the source object's current
   * metageneration does not match the given value.
   * </pre>
   *
   * <code>optional int64 if_source_metageneration_not_match = 14;</code>
   *
   * @return Whether the ifSourceMetagenerationNotMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfSourceMetagenerationNotMatch() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the source object's current
   * metageneration does not match the given value.
   * </pre>
   *
   * <code>optional int64 if_source_metageneration_not_match = 14;</code>
   *
   * @return The ifSourceMetagenerationNotMatch.
   */
  @java.lang.Override
  public long getIfSourceMetagenerationNotMatch() {
    return ifSourceMetagenerationNotMatch_;
  }

  public static final int MAX_BYTES_REWRITTEN_PER_CALL_FIELD_NUMBER = 15;
  private long maxBytesRewrittenPerCall_ = 0L;
  /**
   *
   *
   * <pre>
   * The maximum number of bytes that will be rewritten per rewrite request.
   * Most callers
   * shouldn't need to specify this parameter - it is primarily in place to
   * support testing. If specified the value must be an integral multiple of
   * 1 MiB (1048576). Also, this only applies to requests where the source and
   * destination span locations and/or storage classes. Finally, this value must
   * not change across rewrite calls else you'll get an error that the
   * `rewriteToken` is invalid.
   * </pre>
   *
   * <code>int64 max_bytes_rewritten_per_call = 15;</code>
   *
   * @return The maxBytesRewrittenPerCall.
   */
  @java.lang.Override
  public long getMaxBytesRewrittenPerCall() {
    return maxBytesRewrittenPerCall_;
  }

  public static final int COPY_SOURCE_ENCRYPTION_ALGORITHM_FIELD_NUMBER = 16;

  @SuppressWarnings("serial")
  private volatile java.lang.Object copySourceEncryptionAlgorithm_ = "";
  /**
   *
   *
   * <pre>
   * The algorithm used to encrypt the source object, if any. Used if the source
   * object was encrypted with a Customer-Supplied Encryption Key.
   * </pre>
   *
   * <code>string copy_source_encryption_algorithm = 16;</code>
   *
   * @return The copySourceEncryptionAlgorithm.
   */
  @java.lang.Override
  public java.lang.String getCopySourceEncryptionAlgorithm() {
    java.lang.Object ref = copySourceEncryptionAlgorithm_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      copySourceEncryptionAlgorithm_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The algorithm used to encrypt the source object, if any. Used if the source
   * object was encrypted with a Customer-Supplied Encryption Key.
   * </pre>
   *
   * <code>string copy_source_encryption_algorithm = 16;</code>
   *
   * @return The bytes for copySourceEncryptionAlgorithm.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCopySourceEncryptionAlgorithmBytes() {
    java.lang.Object ref = copySourceEncryptionAlgorithm_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      copySourceEncryptionAlgorithm_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COPY_SOURCE_ENCRYPTION_KEY_BYTES_FIELD_NUMBER = 21;
  private com.google.protobuf.ByteString copySourceEncryptionKeyBytes_ =
      com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * The raw bytes (not base64-encoded) AES-256 encryption key used to encrypt
   * the source object, if it was encrypted with a Customer-Supplied Encryption
   * Key.
   * </pre>
   *
   * <code>bytes copy_source_encryption_key_bytes = 21;</code>
   *
   * @return The copySourceEncryptionKeyBytes.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCopySourceEncryptionKeyBytes() {
    return copySourceEncryptionKeyBytes_;
  }

  public static final int COPY_SOURCE_ENCRYPTION_KEY_SHA256_BYTES_FIELD_NUMBER = 22;
  private com.google.protobuf.ByteString copySourceEncryptionKeySha256Bytes_ =
      com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * The raw bytes (not base64-encoded) SHA256 hash of the encryption key used
   * to encrypt the source object, if it was encrypted with a Customer-Supplied
   * Encryption Key.
   * </pre>
   *
   * <code>bytes copy_source_encryption_key_sha256_bytes = 22;</code>
   *
   * @return The copySourceEncryptionKeySha256Bytes.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCopySourceEncryptionKeySha256Bytes() {
    return copySourceEncryptionKeySha256Bytes_;
  }

  public static final int COMMON_OBJECT_REQUEST_PARAMS_FIELD_NUMBER = 19;
  private com.google.storage.v2.CommonObjectRequestParams commonObjectRequestParams_;
  /**
   *
   *
   * <pre>
   * A set of parameters common to Storage API requests concerning an object.
   * </pre>
   *
   * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 19;</code>
   *
   * @return Whether the commonObjectRequestParams field is set.
   */
  @java.lang.Override
  public boolean hasCommonObjectRequestParams() {
    return commonObjectRequestParams_ != null;
  }
  /**
   *
   *
   * <pre>
   * A set of parameters common to Storage API requests concerning an object.
   * </pre>
   *
   * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 19;</code>
   *
   * @return The commonObjectRequestParams.
   */
  @java.lang.Override
  public com.google.storage.v2.CommonObjectRequestParams getCommonObjectRequestParams() {
    return commonObjectRequestParams_ == null
        ? com.google.storage.v2.CommonObjectRequestParams.getDefaultInstance()
        : commonObjectRequestParams_;
  }
  /**
   *
   *
   * <pre>
   * A set of parameters common to Storage API requests concerning an object.
   * </pre>
   *
   * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 19;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.CommonObjectRequestParamsOrBuilder
      getCommonObjectRequestParamsOrBuilder() {
    return commonObjectRequestParams_ == null
        ? com.google.storage.v2.CommonObjectRequestParams.getDefaultInstance()
        : commonObjectRequestParams_;
  }

  public static final int OBJECT_CHECKSUMS_FIELD_NUMBER = 29;
  private com.google.storage.v2.ObjectChecksums objectChecksums_;
  /**
   *
   *
   * <pre>
   * The checksums of the complete object. This will be used to validate the
   * destination object after rewriting.
   * </pre>
   *
   * <code>.google.storage.v2.ObjectChecksums object_checksums = 29;</code>
   *
   * @return Whether the objectChecksums field is set.
   */
  @java.lang.Override
  public boolean hasObjectChecksums() {
    return objectChecksums_ != null;
  }
  /**
   *
   *
   * <pre>
   * The checksums of the complete object. This will be used to validate the
   * destination object after rewriting.
   * </pre>
   *
   * <code>.google.storage.v2.ObjectChecksums object_checksums = 29;</code>
   *
   * @return The objectChecksums.
   */
  @java.lang.Override
  public com.google.storage.v2.ObjectChecksums getObjectChecksums() {
    return objectChecksums_ == null
        ? com.google.storage.v2.ObjectChecksums.getDefaultInstance()
        : objectChecksums_;
  }
  /**
   *
   *
   * <pre>
   * The checksums of the complete object. This will be used to validate the
   * destination object after rewriting.
   * </pre>
   *
   * <code>.google.storage.v2.ObjectChecksums object_checksums = 29;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.ObjectChecksumsOrBuilder getObjectChecksumsOrBuilder() {
    return objectChecksums_ == null
        ? com.google.storage.v2.ObjectChecksums.getDefaultInstance()
        : objectChecksums_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (destination_ != null) {
      output.writeMessage(1, getDestination());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceBucket_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, sourceBucket_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceObject_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, sourceObject_);
    }
    if (sourceGeneration_ != 0L) {
      output.writeInt64(4, sourceGeneration_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rewriteToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, rewriteToken_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt64(7, ifGenerationMatch_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeInt64(8, ifGenerationNotMatch_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeInt64(9, ifMetagenerationMatch_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeInt64(10, ifMetagenerationNotMatch_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeInt64(11, ifSourceGenerationMatch_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeInt64(12, ifSourceGenerationNotMatch_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeInt64(13, ifSourceMetagenerationMatch_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeInt64(14, ifSourceMetagenerationNotMatch_);
    }
    if (maxBytesRewrittenPerCall_ != 0L) {
      output.writeInt64(15, maxBytesRewrittenPerCall_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(copySourceEncryptionAlgorithm_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 16, copySourceEncryptionAlgorithm_);
    }
    if (commonObjectRequestParams_ != null) {
      output.writeMessage(19, getCommonObjectRequestParams());
    }
    if (!copySourceEncryptionKeyBytes_.isEmpty()) {
      output.writeBytes(21, copySourceEncryptionKeyBytes_);
    }
    if (!copySourceEncryptionKeySha256Bytes_.isEmpty()) {
      output.writeBytes(22, copySourceEncryptionKeySha256Bytes_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destinationName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 24, destinationName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destinationBucket_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 25, destinationBucket_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destinationKmsKey_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 27, destinationKmsKey_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destinationPredefinedAcl_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 28, destinationPredefinedAcl_);
    }
    if (objectChecksums_ != null) {
      output.writeMessage(29, getObjectChecksums());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (destination_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getDestination());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceBucket_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, sourceBucket_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceObject_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, sourceObject_);
    }
    if (sourceGeneration_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, sourceGeneration_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rewriteToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, rewriteToken_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(7, ifGenerationMatch_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(8, ifGenerationNotMatch_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(9, ifMetagenerationMatch_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(10, ifMetagenerationNotMatch_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(11, ifSourceGenerationMatch_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(12, ifSourceGenerationNotMatch_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(13, ifSourceMetagenerationMatch_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(
              14, ifSourceMetagenerationNotMatch_);
    }
    if (maxBytesRewrittenPerCall_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(15, maxBytesRewrittenPerCall_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(copySourceEncryptionAlgorithm_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              16, copySourceEncryptionAlgorithm_);
    }
    if (commonObjectRequestParams_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              19, getCommonObjectRequestParams());
    }
    if (!copySourceEncryptionKeyBytes_.isEmpty()) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBytesSize(21, copySourceEncryptionKeyBytes_);
    }
    if (!copySourceEncryptionKeySha256Bytes_.isEmpty()) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBytesSize(
              22, copySourceEncryptionKeySha256Bytes_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destinationName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(24, destinationName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destinationBucket_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(25, destinationBucket_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destinationKmsKey_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(27, destinationKmsKey_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destinationPredefinedAcl_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(28, destinationPredefinedAcl_);
    }
    if (objectChecksums_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(29, getObjectChecksums());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.storage.v2.RewriteObjectRequest)) {
      return super.equals(obj);
    }
    com.google.storage.v2.RewriteObjectRequest other =
        (com.google.storage.v2.RewriteObjectRequest) obj;

    if (!getDestinationName().equals(other.getDestinationName())) return false;
    if (!getDestinationBucket().equals(other.getDestinationBucket())) return false;
    if (!getDestinationKmsKey().equals(other.getDestinationKmsKey())) return false;
    if (hasDestination() != other.hasDestination()) return false;
    if (hasDestination()) {
      if (!getDestination().equals(other.getDestination())) return false;
    }
    if (!getSourceBucket().equals(other.getSourceBucket())) return false;
    if (!getSourceObject().equals(other.getSourceObject())) return false;
    if (getSourceGeneration() != other.getSourceGeneration()) return false;
    if (!getRewriteToken().equals(other.getRewriteToken())) return false;
    if (!getDestinationPredefinedAcl().equals(other.getDestinationPredefinedAcl())) return false;
    if (hasIfGenerationMatch() != other.hasIfGenerationMatch()) return false;
    if (hasIfGenerationMatch()) {
      if (getIfGenerationMatch() != other.getIfGenerationMatch()) return false;
    }
    if (hasIfGenerationNotMatch() != other.hasIfGenerationNotMatch()) return false;
    if (hasIfGenerationNotMatch()) {
      if (getIfGenerationNotMatch() != other.getIfGenerationNotMatch()) return false;
    }
    if (hasIfMetagenerationMatch() != other.hasIfMetagenerationMatch()) return false;
    if (hasIfMetagenerationMatch()) {
      if (getIfMetagenerationMatch() != other.getIfMetagenerationMatch()) return false;
    }
    if (hasIfMetagenerationNotMatch() != other.hasIfMetagenerationNotMatch()) return false;
    if (hasIfMetagenerationNotMatch()) {
      if (getIfMetagenerationNotMatch() != other.getIfMetagenerationNotMatch()) return false;
    }
    if (hasIfSourceGenerationMatch() != other.hasIfSourceGenerationMatch()) return false;
    if (hasIfSourceGenerationMatch()) {
      if (getIfSourceGenerationMatch() != other.getIfSourceGenerationMatch()) return false;
    }
    if (hasIfSourceGenerationNotMatch() != other.hasIfSourceGenerationNotMatch()) return false;
    if (hasIfSourceGenerationNotMatch()) {
      if (getIfSourceGenerationNotMatch() != other.getIfSourceGenerationNotMatch()) return false;
    }
    if (hasIfSourceMetagenerationMatch() != other.hasIfSourceMetagenerationMatch()) return false;
    if (hasIfSourceMetagenerationMatch()) {
      if (getIfSourceMetagenerationMatch() != other.getIfSourceMetagenerationMatch()) return false;
    }
    if (hasIfSourceMetagenerationNotMatch() != other.hasIfSourceMetagenerationNotMatch())
      return false;
    if (hasIfSourceMetagenerationNotMatch()) {
      if (getIfSourceMetagenerationNotMatch() != other.getIfSourceMetagenerationNotMatch())
        return false;
    }
    if (getMaxBytesRewrittenPerCall() != other.getMaxBytesRewrittenPerCall()) return false;
    if (!getCopySourceEncryptionAlgorithm().equals(other.getCopySourceEncryptionAlgorithm()))
      return false;
    if (!getCopySourceEncryptionKeyBytes().equals(other.getCopySourceEncryptionKeyBytes()))
      return false;
    if (!getCopySourceEncryptionKeySha256Bytes()
        .equals(other.getCopySourceEncryptionKeySha256Bytes())) return false;
    if (hasCommonObjectRequestParams() != other.hasCommonObjectRequestParams()) return false;
    if (hasCommonObjectRequestParams()) {
      if (!getCommonObjectRequestParams().equals(other.getCommonObjectRequestParams()))
        return false;
    }
    if (hasObjectChecksums() != other.hasObjectChecksums()) return false;
    if (hasObjectChecksums()) {
      if (!getObjectChecksums().equals(other.getObjectChecksums())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DESTINATION_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDestinationName().hashCode();
    hash = (37 * hash) + DESTINATION_BUCKET_FIELD_NUMBER;
    hash = (53 * hash) + getDestinationBucket().hashCode();
    hash = (37 * hash) + DESTINATION_KMS_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getDestinationKmsKey().hashCode();
    if (hasDestination()) {
      hash = (37 * hash) + DESTINATION_FIELD_NUMBER;
      hash = (53 * hash) + getDestination().hashCode();
    }
    hash = (37 * hash) + SOURCE_BUCKET_FIELD_NUMBER;
    hash = (53 * hash) + getSourceBucket().hashCode();
    hash = (37 * hash) + SOURCE_OBJECT_FIELD_NUMBER;
    hash = (53 * hash) + getSourceObject().hashCode();
    hash = (37 * hash) + SOURCE_GENERATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getSourceGeneration());
    hash = (37 * hash) + REWRITE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getRewriteToken().hashCode();
    hash = (37 * hash) + DESTINATION_PREDEFINED_ACL_FIELD_NUMBER;
    hash = (53 * hash) + getDestinationPredefinedAcl().hashCode();
    if (hasIfGenerationMatch()) {
      hash = (37 * hash) + IF_GENERATION_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfGenerationMatch());
    }
    if (hasIfGenerationNotMatch()) {
      hash = (37 * hash) + IF_GENERATION_NOT_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfGenerationNotMatch());
    }
    if (hasIfMetagenerationMatch()) {
      hash = (37 * hash) + IF_METAGENERATION_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfMetagenerationMatch());
    }
    if (hasIfMetagenerationNotMatch()) {
      hash = (37 * hash) + IF_METAGENERATION_NOT_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfMetagenerationNotMatch());
    }
    if (hasIfSourceGenerationMatch()) {
      hash = (37 * hash) + IF_SOURCE_GENERATION_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfSourceGenerationMatch());
    }
    if (hasIfSourceGenerationNotMatch()) {
      hash = (37 * hash) + IF_SOURCE_GENERATION_NOT_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfSourceGenerationNotMatch());
    }
    if (hasIfSourceMetagenerationMatch()) {
      hash = (37 * hash) + IF_SOURCE_METAGENERATION_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfSourceMetagenerationMatch());
    }
    if (hasIfSourceMetagenerationNotMatch()) {
      hash = (37 * hash) + IF_SOURCE_METAGENERATION_NOT_MATCH_FIELD_NUMBER;
      hash =
          (53 * hash) + com.google.protobuf.Internal.hashLong(getIfSourceMetagenerationNotMatch());
    }
    hash = (37 * hash) + MAX_BYTES_REWRITTEN_PER_CALL_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMaxBytesRewrittenPerCall());
    hash = (37 * hash) + COPY_SOURCE_ENCRYPTION_ALGORITHM_FIELD_NUMBER;
    hash = (53 * hash) + getCopySourceEncryptionAlgorithm().hashCode();
    hash = (37 * hash) + COPY_SOURCE_ENCRYPTION_KEY_BYTES_FIELD_NUMBER;
    hash = (53 * hash) + getCopySourceEncryptionKeyBytes().hashCode();
    hash = (37 * hash) + COPY_SOURCE_ENCRYPTION_KEY_SHA256_BYTES_FIELD_NUMBER;
    hash = (53 * hash) + getCopySourceEncryptionKeySha256Bytes().hashCode();
    if (hasCommonObjectRequestParams()) {
      hash = (37 * hash) + COMMON_OBJECT_REQUEST_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getCommonObjectRequestParams().hashCode();
    }
    if (hasObjectChecksums()) {
      hash = (37 * hash) + OBJECT_CHECKSUMS_FIELD_NUMBER;
      hash = (53 * hash) + getObjectChecksums().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.storage.v2.RewriteObjectRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.RewriteObjectRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.RewriteObjectRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.RewriteObjectRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.RewriteObjectRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.RewriteObjectRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.RewriteObjectRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.RewriteObjectRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.RewriteObjectRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.RewriteObjectRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.RewriteObjectRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.RewriteObjectRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.storage.v2.RewriteObjectRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for RewriteObject.
   * If the source object is encrypted using a Customer-Supplied Encryption Key
   * the key information must be provided in the copy_source_encryption_algorithm,
   * copy_source_encryption_key_bytes, and copy_source_encryption_key_sha256_bytes
   * fields. If the destination object should be encrypted the keying information
   * should be provided in the encryption_algorithm, encryption_key_bytes, and
   * encryption_key_sha256_bytes fields of the
   * common_object_request_params.customer_encryption field.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.RewriteObjectRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.storage.v2.RewriteObjectRequest)
      com.google.storage.v2.RewriteObjectRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_RewriteObjectRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_RewriteObjectRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.RewriteObjectRequest.class,
              com.google.storage.v2.RewriteObjectRequest.Builder.class);
    }

    // Construct using com.google.storage.v2.RewriteObjectRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      destinationName_ = "";
      destinationBucket_ = "";
      destinationKmsKey_ = "";
      destination_ = null;
      if (destinationBuilder_ != null) {
        destinationBuilder_.dispose();
        destinationBuilder_ = null;
      }
      sourceBucket_ = "";
      sourceObject_ = "";
      sourceGeneration_ = 0L;
      rewriteToken_ = "";
      destinationPredefinedAcl_ = "";
      ifGenerationMatch_ = 0L;
      ifGenerationNotMatch_ = 0L;
      ifMetagenerationMatch_ = 0L;
      ifMetagenerationNotMatch_ = 0L;
      ifSourceGenerationMatch_ = 0L;
      ifSourceGenerationNotMatch_ = 0L;
      ifSourceMetagenerationMatch_ = 0L;
      ifSourceMetagenerationNotMatch_ = 0L;
      maxBytesRewrittenPerCall_ = 0L;
      copySourceEncryptionAlgorithm_ = "";
      copySourceEncryptionKeyBytes_ = com.google.protobuf.ByteString.EMPTY;
      copySourceEncryptionKeySha256Bytes_ = com.google.protobuf.ByteString.EMPTY;
      commonObjectRequestParams_ = null;
      if (commonObjectRequestParamsBuilder_ != null) {
        commonObjectRequestParamsBuilder_.dispose();
        commonObjectRequestParamsBuilder_ = null;
      }
      objectChecksums_ = null;
      if (objectChecksumsBuilder_ != null) {
        objectChecksumsBuilder_.dispose();
        objectChecksumsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_RewriteObjectRequest_descriptor;
    }

    @java.lang.Override
    public com.google.storage.v2.RewriteObjectRequest getDefaultInstanceForType() {
      return com.google.storage.v2.RewriteObjectRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.storage.v2.RewriteObjectRequest build() {
      com.google.storage.v2.RewriteObjectRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.storage.v2.RewriteObjectRequest buildPartial() {
      com.google.storage.v2.RewriteObjectRequest result =
          new com.google.storage.v2.RewriteObjectRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.storage.v2.RewriteObjectRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.destinationName_ = destinationName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.destinationBucket_ = destinationBucket_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.destinationKmsKey_ = destinationKmsKey_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.destination_ =
            destinationBuilder_ == null ? destination_ : destinationBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.sourceBucket_ = sourceBucket_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.sourceObject_ = sourceObject_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.sourceGeneration_ = sourceGeneration_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.rewriteToken_ = rewriteToken_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.destinationPredefinedAcl_ = destinationPredefinedAcl_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.ifGenerationMatch_ = ifGenerationMatch_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.ifGenerationNotMatch_ = ifGenerationNotMatch_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.ifMetagenerationMatch_ = ifMetagenerationMatch_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.ifMetagenerationNotMatch_ = ifMetagenerationNotMatch_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.ifSourceGenerationMatch_ = ifSourceGenerationMatch_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.ifSourceGenerationNotMatch_ = ifSourceGenerationNotMatch_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.ifSourceMetagenerationMatch_ = ifSourceMetagenerationMatch_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.ifSourceMetagenerationNotMatch_ = ifSourceMetagenerationNotMatch_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.maxBytesRewrittenPerCall_ = maxBytesRewrittenPerCall_;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.copySourceEncryptionAlgorithm_ = copySourceEncryptionAlgorithm_;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.copySourceEncryptionKeyBytes_ = copySourceEncryptionKeyBytes_;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.copySourceEncryptionKeySha256Bytes_ = copySourceEncryptionKeySha256Bytes_;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.commonObjectRequestParams_ =
            commonObjectRequestParamsBuilder_ == null
                ? commonObjectRequestParams_
                : commonObjectRequestParamsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.objectChecksums_ =
            objectChecksumsBuilder_ == null ? objectChecksums_ : objectChecksumsBuilder_.build();
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.storage.v2.RewriteObjectRequest) {
        return mergeFrom((com.google.storage.v2.RewriteObjectRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.storage.v2.RewriteObjectRequest other) {
      if (other == com.google.storage.v2.RewriteObjectRequest.getDefaultInstance()) return this;
      if (!other.getDestinationName().isEmpty()) {
        destinationName_ = other.destinationName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDestinationBucket().isEmpty()) {
        destinationBucket_ = other.destinationBucket_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDestinationKmsKey().isEmpty()) {
        destinationKmsKey_ = other.destinationKmsKey_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasDestination()) {
        mergeDestination(other.getDestination());
      }
      if (!other.getSourceBucket().isEmpty()) {
        sourceBucket_ = other.sourceBucket_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getSourceObject().isEmpty()) {
        sourceObject_ = other.sourceObject_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.getSourceGeneration() != 0L) {
        setSourceGeneration(other.getSourceGeneration());
      }
      if (!other.getRewriteToken().isEmpty()) {
        rewriteToken_ = other.rewriteToken_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.getDestinationPredefinedAcl().isEmpty()) {
        destinationPredefinedAcl_ = other.destinationPredefinedAcl_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasIfGenerationMatch()) {
        setIfGenerationMatch(other.getIfGenerationMatch());
      }
      if (other.hasIfGenerationNotMatch()) {
        setIfGenerationNotMatch(other.getIfGenerationNotMatch());
      }
      if (other.hasIfMetagenerationMatch()) {
        setIfMetagenerationMatch(other.getIfMetagenerationMatch());
      }
      if (other.hasIfMetagenerationNotMatch()) {
        setIfMetagenerationNotMatch(other.getIfMetagenerationNotMatch());
      }
      if (other.hasIfSourceGenerationMatch()) {
        setIfSourceGenerationMatch(other.getIfSourceGenerationMatch());
      }
      if (other.hasIfSourceGenerationNotMatch()) {
        setIfSourceGenerationNotMatch(other.getIfSourceGenerationNotMatch());
      }
      if (other.hasIfSourceMetagenerationMatch()) {
        setIfSourceMetagenerationMatch(other.getIfSourceMetagenerationMatch());
      }
      if (other.hasIfSourceMetagenerationNotMatch()) {
        setIfSourceMetagenerationNotMatch(other.getIfSourceMetagenerationNotMatch());
      }
      if (other.getMaxBytesRewrittenPerCall() != 0L) {
        setMaxBytesRewrittenPerCall(other.getMaxBytesRewrittenPerCall());
      }
      if (!other.getCopySourceEncryptionAlgorithm().isEmpty()) {
        copySourceEncryptionAlgorithm_ = other.copySourceEncryptionAlgorithm_;
        bitField0_ |= 0x00040000;
        onChanged();
      }
      if (other.getCopySourceEncryptionKeyBytes() != com.google.protobuf.ByteString.EMPTY) {
        setCopySourceEncryptionKeyBytes(other.getCopySourceEncryptionKeyBytes());
      }
      if (other.getCopySourceEncryptionKeySha256Bytes() != com.google.protobuf.ByteString.EMPTY) {
        setCopySourceEncryptionKeySha256Bytes(other.getCopySourceEncryptionKeySha256Bytes());
      }
      if (other.hasCommonObjectRequestParams()) {
        mergeCommonObjectRequestParams(other.getCommonObjectRequestParams());
      }
      if (other.hasObjectChecksums()) {
        mergeObjectChecksums(other.getObjectChecksums());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getDestinationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 10
            case 18:
              {
                sourceBucket_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 18
            case 26:
              {
                sourceObject_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 26
            case 32:
              {
                sourceGeneration_ = input.readInt64();
                bitField0_ |= 0x00000040;
                break;
              } // case 32
            case 42:
              {
                rewriteToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 42
            case 56:
              {
                ifGenerationMatch_ = input.readInt64();
                bitField0_ |= 0x00000200;
                break;
              } // case 56
            case 64:
              {
                ifGenerationNotMatch_ = input.readInt64();
                bitField0_ |= 0x00000400;
                break;
              } // case 64
            case 72:
              {
                ifMetagenerationMatch_ = input.readInt64();
                bitField0_ |= 0x00000800;
                break;
              } // case 72
            case 80:
              {
                ifMetagenerationNotMatch_ = input.readInt64();
                bitField0_ |= 0x00001000;
                break;
              } // case 80
            case 88:
              {
                ifSourceGenerationMatch_ = input.readInt64();
                bitField0_ |= 0x00002000;
                break;
              } // case 88
            case 96:
              {
                ifSourceGenerationNotMatch_ = input.readInt64();
                bitField0_ |= 0x00004000;
                break;
              } // case 96
            case 104:
              {
                ifSourceMetagenerationMatch_ = input.readInt64();
                bitField0_ |= 0x00008000;
                break;
              } // case 104
            case 112:
              {
                ifSourceMetagenerationNotMatch_ = input.readInt64();
                bitField0_ |= 0x00010000;
                break;
              } // case 112
            case 120:
              {
                maxBytesRewrittenPerCall_ = input.readInt64();
                bitField0_ |= 0x00020000;
                break;
              } // case 120
            case 130:
              {
                copySourceEncryptionAlgorithm_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00040000;
                break;
              } // case 130
            case 154:
              {
                input.readMessage(
                    getCommonObjectRequestParamsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00200000;
                break;
              } // case 154
            case 170:
              {
                copySourceEncryptionKeyBytes_ = input.readBytes();
                bitField0_ |= 0x00080000;
                break;
              } // case 170
            case 178:
              {
                copySourceEncryptionKeySha256Bytes_ = input.readBytes();
                bitField0_ |= 0x00100000;
                break;
              } // case 178
            case 194:
              {
                destinationName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 194
            case 202:
              {
                destinationBucket_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 202
            case 218:
              {
                destinationKmsKey_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 218
            case 226:
              {
                destinationPredefinedAcl_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 226
            case 234:
              {
                input.readMessage(getObjectChecksumsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00400000;
                break;
              } // case 234
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object destinationName_ = "";
    /**
     *
     *
     * <pre>
     * Required. Immutable. The name of the destination object.
     * See the
     * [Naming Guidelines](https://cloud.google.com/storage/docs/objects#naming).
     * Example: `test.txt`
     * The `name` field by itself does not uniquely identify a Cloud Storage
     * object. A Cloud Storage object is uniquely identified by the tuple of
     * (bucket, object, generation).
     * </pre>
     *
     * <code>
     * string destination_name = 24 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The destinationName.
     */
    public java.lang.String getDestinationName() {
      java.lang.Object ref = destinationName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        destinationName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The name of the destination object.
     * See the
     * [Naming Guidelines](https://cloud.google.com/storage/docs/objects#naming).
     * Example: `test.txt`
     * The `name` field by itself does not uniquely identify a Cloud Storage
     * object. A Cloud Storage object is uniquely identified by the tuple of
     * (bucket, object, generation).
     * </pre>
     *
     * <code>
     * string destination_name = 24 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The bytes for destinationName.
     */
    public com.google.protobuf.ByteString getDestinationNameBytes() {
      java.lang.Object ref = destinationName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        destinationName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The name of the destination object.
     * See the
     * [Naming Guidelines](https://cloud.google.com/storage/docs/objects#naming).
     * Example: `test.txt`
     * The `name` field by itself does not uniquely identify a Cloud Storage
     * object. A Cloud Storage object is uniquely identified by the tuple of
     * (bucket, object, generation).
     * </pre>
     *
     * <code>
     * string destination_name = 24 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The destinationName to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      destinationName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The name of the destination object.
     * See the
     * [Naming Guidelines](https://cloud.google.com/storage/docs/objects#naming).
     * Example: `test.txt`
     * The `name` field by itself does not uniquely identify a Cloud Storage
     * object. A Cloud Storage object is uniquely identified by the tuple of
     * (bucket, object, generation).
     * </pre>
     *
     * <code>
     * string destination_name = 24 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDestinationName() {
      destinationName_ = getDefaultInstance().getDestinationName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The name of the destination object.
     * See the
     * [Naming Guidelines](https://cloud.google.com/storage/docs/objects#naming).
     * Example: `test.txt`
     * The `name` field by itself does not uniquely identify a Cloud Storage
     * object. A Cloud Storage object is uniquely identified by the tuple of
     * (bucket, object, generation).
     * </pre>
     *
     * <code>
     * string destination_name = 24 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The bytes for destinationName to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      destinationName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object destinationBucket_ = "";
    /**
     *
     *
     * <pre>
     * Required. Immutable. The name of the bucket containing the destination
     * object.
     * </pre>
     *
     * <code>
     * string destination_bucket = 25 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The destinationBucket.
     */
    public java.lang.String getDestinationBucket() {
      java.lang.Object ref = destinationBucket_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        destinationBucket_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The name of the bucket containing the destination
     * object.
     * </pre>
     *
     * <code>
     * string destination_bucket = 25 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for destinationBucket.
     */
    public com.google.protobuf.ByteString getDestinationBucketBytes() {
      java.lang.Object ref = destinationBucket_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        destinationBucket_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The name of the bucket containing the destination
     * object.
     * </pre>
     *
     * <code>
     * string destination_bucket = 25 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The destinationBucket to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationBucket(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      destinationBucket_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The name of the bucket containing the destination
     * object.
     * </pre>
     *
     * <code>
     * string destination_bucket = 25 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDestinationBucket() {
      destinationBucket_ = getDefaultInstance().getDestinationBucket();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The name of the bucket containing the destination
     * object.
     * </pre>
     *
     * <code>
     * string destination_bucket = 25 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for destinationBucket to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationBucketBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      destinationBucket_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object destinationKmsKey_ = "";
    /**
     *
     *
     * <pre>
     * The name of the Cloud KMS key that will be used to encrypt the destination
     * object. The Cloud KMS key must be located in same location as the object.
     * If the parameter is not specified, the request uses the destination
     * bucket's default encryption key, if any, or else the Google-managed
     * encryption key.
     * </pre>
     *
     * <code>string destination_kms_key = 27 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The destinationKmsKey.
     */
    public java.lang.String getDestinationKmsKey() {
      java.lang.Object ref = destinationKmsKey_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        destinationKmsKey_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the Cloud KMS key that will be used to encrypt the destination
     * object. The Cloud KMS key must be located in same location as the object.
     * If the parameter is not specified, the request uses the destination
     * bucket's default encryption key, if any, or else the Google-managed
     * encryption key.
     * </pre>
     *
     * <code>string destination_kms_key = 27 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for destinationKmsKey.
     */
    public com.google.protobuf.ByteString getDestinationKmsKeyBytes() {
      java.lang.Object ref = destinationKmsKey_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        destinationKmsKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the Cloud KMS key that will be used to encrypt the destination
     * object. The Cloud KMS key must be located in same location as the object.
     * If the parameter is not specified, the request uses the destination
     * bucket's default encryption key, if any, or else the Google-managed
     * encryption key.
     * </pre>
     *
     * <code>string destination_kms_key = 27 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The destinationKmsKey to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationKmsKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      destinationKmsKey_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the Cloud KMS key that will be used to encrypt the destination
     * object. The Cloud KMS key must be located in same location as the object.
     * If the parameter is not specified, the request uses the destination
     * bucket's default encryption key, if any, or else the Google-managed
     * encryption key.
     * </pre>
     *
     * <code>string destination_kms_key = 27 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDestinationKmsKey() {
      destinationKmsKey_ = getDefaultInstance().getDestinationKmsKey();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the Cloud KMS key that will be used to encrypt the destination
     * object. The Cloud KMS key must be located in same location as the object.
     * If the parameter is not specified, the request uses the destination
     * bucket's default encryption key, if any, or else the Google-managed
     * encryption key.
     * </pre>
     *
     * <code>string destination_kms_key = 27 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for destinationKmsKey to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationKmsKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      destinationKmsKey_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.storage.v2.Object destination_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Object,
            com.google.storage.v2.Object.Builder,
            com.google.storage.v2.ObjectOrBuilder>
        destinationBuilder_;
    /**
     *
     *
     * <pre>
     * Properties of the destination, post-rewrite object.
     * The `name`, `bucket` and `kms_key` fields must not be populated (these
     * values are specified in the `destination_name`, `destination_bucket`, and
     * `destination_kms_key` fields).
     * If `destination` is present it will be used to construct the destination
     * object's metadata; otherwise the destination object's metadata will be
     * copied from the source object.
     * </pre>
     *
     * <code>.google.storage.v2.Object destination = 1;</code>
     *
     * @return Whether the destination field is set.
     */
    public boolean hasDestination() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Properties of the destination, post-rewrite object.
     * The `name`, `bucket` and `kms_key` fields must not be populated (these
     * values are specified in the `destination_name`, `destination_bucket`, and
     * `destination_kms_key` fields).
     * If `destination` is present it will be used to construct the destination
     * object's metadata; otherwise the destination object's metadata will be
     * copied from the source object.
     * </pre>
     *
     * <code>.google.storage.v2.Object destination = 1;</code>
     *
     * @return The destination.
     */
    public com.google.storage.v2.Object getDestination() {
      if (destinationBuilder_ == null) {
        return destination_ == null
            ? com.google.storage.v2.Object.getDefaultInstance()
            : destination_;
      } else {
        return destinationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Properties of the destination, post-rewrite object.
     * The `name`, `bucket` and `kms_key` fields must not be populated (these
     * values are specified in the `destination_name`, `destination_bucket`, and
     * `destination_kms_key` fields).
     * If `destination` is present it will be used to construct the destination
     * object's metadata; otherwise the destination object's metadata will be
     * copied from the source object.
     * </pre>
     *
     * <code>.google.storage.v2.Object destination = 1;</code>
     */
    public Builder setDestination(com.google.storage.v2.Object value) {
      if (destinationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destination_ = value;
      } else {
        destinationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Properties of the destination, post-rewrite object.
     * The `name`, `bucket` and `kms_key` fields must not be populated (these
     * values are specified in the `destination_name`, `destination_bucket`, and
     * `destination_kms_key` fields).
     * If `destination` is present it will be used to construct the destination
     * object's metadata; otherwise the destination object's metadata will be
     * copied from the source object.
     * </pre>
     *
     * <code>.google.storage.v2.Object destination = 1;</code>
     */
    public Builder setDestination(com.google.storage.v2.Object.Builder builderForValue) {
      if (destinationBuilder_ == null) {
        destination_ = builderForValue.build();
      } else {
        destinationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Properties of the destination, post-rewrite object.
     * The `name`, `bucket` and `kms_key` fields must not be populated (these
     * values are specified in the `destination_name`, `destination_bucket`, and
     * `destination_kms_key` fields).
     * If `destination` is present it will be used to construct the destination
     * object's metadata; otherwise the destination object's metadata will be
     * copied from the source object.
     * </pre>
     *
     * <code>.google.storage.v2.Object destination = 1;</code>
     */
    public Builder mergeDestination(com.google.storage.v2.Object value) {
      if (destinationBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && destination_ != null
            && destination_ != com.google.storage.v2.Object.getDefaultInstance()) {
          getDestinationBuilder().mergeFrom(value);
        } else {
          destination_ = value;
        }
      } else {
        destinationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Properties of the destination, post-rewrite object.
     * The `name`, `bucket` and `kms_key` fields must not be populated (these
     * values are specified in the `destination_name`, `destination_bucket`, and
     * `destination_kms_key` fields).
     * If `destination` is present it will be used to construct the destination
     * object's metadata; otherwise the destination object's metadata will be
     * copied from the source object.
     * </pre>
     *
     * <code>.google.storage.v2.Object destination = 1;</code>
     */
    public Builder clearDestination() {
      bitField0_ = (bitField0_ & ~0x00000008);
      destination_ = null;
      if (destinationBuilder_ != null) {
        destinationBuilder_.dispose();
        destinationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Properties of the destination, post-rewrite object.
     * The `name`, `bucket` and `kms_key` fields must not be populated (these
     * values are specified in the `destination_name`, `destination_bucket`, and
     * `destination_kms_key` fields).
     * If `destination` is present it will be used to construct the destination
     * object's metadata; otherwise the destination object's metadata will be
     * copied from the source object.
     * </pre>
     *
     * <code>.google.storage.v2.Object destination = 1;</code>
     */
    public com.google.storage.v2.Object.Builder getDestinationBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getDestinationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Properties of the destination, post-rewrite object.
     * The `name`, `bucket` and `kms_key` fields must not be populated (these
     * values are specified in the `destination_name`, `destination_bucket`, and
     * `destination_kms_key` fields).
     * If `destination` is present it will be used to construct the destination
     * object's metadata; otherwise the destination object's metadata will be
     * copied from the source object.
     * </pre>
     *
     * <code>.google.storage.v2.Object destination = 1;</code>
     */
    public com.google.storage.v2.ObjectOrBuilder getDestinationOrBuilder() {
      if (destinationBuilder_ != null) {
        return destinationBuilder_.getMessageOrBuilder();
      } else {
        return destination_ == null
            ? com.google.storage.v2.Object.getDefaultInstance()
            : destination_;
      }
    }
    /**
     *
     *
     * <pre>
     * Properties of the destination, post-rewrite object.
     * The `name`, `bucket` and `kms_key` fields must not be populated (these
     * values are specified in the `destination_name`, `destination_bucket`, and
     * `destination_kms_key` fields).
     * If `destination` is present it will be used to construct the destination
     * object's metadata; otherwise the destination object's metadata will be
     * copied from the source object.
     * </pre>
     *
     * <code>.google.storage.v2.Object destination = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Object,
            com.google.storage.v2.Object.Builder,
            com.google.storage.v2.ObjectOrBuilder>
        getDestinationFieldBuilder() {
      if (destinationBuilder_ == null) {
        destinationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Object,
                com.google.storage.v2.Object.Builder,
                com.google.storage.v2.ObjectOrBuilder>(
                getDestination(), getParentForChildren(), isClean());
        destination_ = null;
      }
      return destinationBuilder_;
    }

    private java.lang.Object sourceBucket_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the bucket in which to find the source object.
     * </pre>
     *
     * <code>
     * string source_bucket = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The sourceBucket.
     */
    public java.lang.String getSourceBucket() {
      java.lang.Object ref = sourceBucket_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceBucket_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the bucket in which to find the source object.
     * </pre>
     *
     * <code>
     * string source_bucket = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for sourceBucket.
     */
    public com.google.protobuf.ByteString getSourceBucketBytes() {
      java.lang.Object ref = sourceBucket_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceBucket_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the bucket in which to find the source object.
     * </pre>
     *
     * <code>
     * string source_bucket = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The sourceBucket to set.
     * @return This builder for chaining.
     */
    public Builder setSourceBucket(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceBucket_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the bucket in which to find the source object.
     * </pre>
     *
     * <code>
     * string source_bucket = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceBucket() {
      sourceBucket_ = getDefaultInstance().getSourceBucket();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the bucket in which to find the source object.
     * </pre>
     *
     * <code>
     * string source_bucket = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for sourceBucket to set.
     * @return This builder for chaining.
     */
    public Builder setSourceBucketBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceBucket_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object sourceObject_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the source object.
     * </pre>
     *
     * <code>string source_object = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The sourceObject.
     */
    public java.lang.String getSourceObject() {
      java.lang.Object ref = sourceObject_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceObject_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the source object.
     * </pre>
     *
     * <code>string source_object = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for sourceObject.
     */
    public com.google.protobuf.ByteString getSourceObjectBytes() {
      java.lang.Object ref = sourceObject_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceObject_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the source object.
     * </pre>
     *
     * <code>string source_object = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The sourceObject to set.
     * @return This builder for chaining.
     */
    public Builder setSourceObject(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceObject_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the source object.
     * </pre>
     *
     * <code>string source_object = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceObject() {
      sourceObject_ = getDefaultInstance().getSourceObject();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the source object.
     * </pre>
     *
     * <code>string source_object = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for sourceObject to set.
     * @return This builder for chaining.
     */
    public Builder setSourceObjectBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceObject_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private long sourceGeneration_;
    /**
     *
     *
     * <pre>
     * If present, selects a specific revision of the source object (as opposed to
     * the latest version, the default).
     * </pre>
     *
     * <code>int64 source_generation = 4;</code>
     *
     * @return The sourceGeneration.
     */
    @java.lang.Override
    public long getSourceGeneration() {
      return sourceGeneration_;
    }
    /**
     *
     *
     * <pre>
     * If present, selects a specific revision of the source object (as opposed to
     * the latest version, the default).
     * </pre>
     *
     * <code>int64 source_generation = 4;</code>
     *
     * @param value The sourceGeneration to set.
     * @return This builder for chaining.
     */
    public Builder setSourceGeneration(long value) {

      sourceGeneration_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, selects a specific revision of the source object (as opposed to
     * the latest version, the default).
     * </pre>
     *
     * <code>int64 source_generation = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceGeneration() {
      bitField0_ = (bitField0_ & ~0x00000040);
      sourceGeneration_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object rewriteToken_ = "";
    /**
     *
     *
     * <pre>
     * Include this field (from the previous rewrite response) on each rewrite
     * request after the first one, until the rewrite response 'done' flag is
     * true. Calls that provide a rewriteToken can omit all other request fields,
     * but if included those fields must match the values provided in the first
     * rewrite request.
     * </pre>
     *
     * <code>string rewrite_token = 5;</code>
     *
     * @return The rewriteToken.
     */
    public java.lang.String getRewriteToken() {
      java.lang.Object ref = rewriteToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        rewriteToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Include this field (from the previous rewrite response) on each rewrite
     * request after the first one, until the rewrite response 'done' flag is
     * true. Calls that provide a rewriteToken can omit all other request fields,
     * but if included those fields must match the values provided in the first
     * rewrite request.
     * </pre>
     *
     * <code>string rewrite_token = 5;</code>
     *
     * @return The bytes for rewriteToken.
     */
    public com.google.protobuf.ByteString getRewriteTokenBytes() {
      java.lang.Object ref = rewriteToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        rewriteToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Include this field (from the previous rewrite response) on each rewrite
     * request after the first one, until the rewrite response 'done' flag is
     * true. Calls that provide a rewriteToken can omit all other request fields,
     * but if included those fields must match the values provided in the first
     * rewrite request.
     * </pre>
     *
     * <code>string rewrite_token = 5;</code>
     *
     * @param value The rewriteToken to set.
     * @return This builder for chaining.
     */
    public Builder setRewriteToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      rewriteToken_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Include this field (from the previous rewrite response) on each rewrite
     * request after the first one, until the rewrite response 'done' flag is
     * true. Calls that provide a rewriteToken can omit all other request fields,
     * but if included those fields must match the values provided in the first
     * rewrite request.
     * </pre>
     *
     * <code>string rewrite_token = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRewriteToken() {
      rewriteToken_ = getDefaultInstance().getRewriteToken();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Include this field (from the previous rewrite response) on each rewrite
     * request after the first one, until the rewrite response 'done' flag is
     * true. Calls that provide a rewriteToken can omit all other request fields,
     * but if included those fields must match the values provided in the first
     * rewrite request.
     * </pre>
     *
     * <code>string rewrite_token = 5;</code>
     *
     * @param value The bytes for rewriteToken to set.
     * @return This builder for chaining.
     */
    public Builder setRewriteTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      rewriteToken_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object destinationPredefinedAcl_ = "";
    /**
     *
     *
     * <pre>
     * Apply a predefined set of access controls to the destination object.
     * Valid values are "authenticatedRead", "bucketOwnerFullControl",
     * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
     * </pre>
     *
     * <code>string destination_predefined_acl = 28;</code>
     *
     * @return The destinationPredefinedAcl.
     */
    public java.lang.String getDestinationPredefinedAcl() {
      java.lang.Object ref = destinationPredefinedAcl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        destinationPredefinedAcl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Apply a predefined set of access controls to the destination object.
     * Valid values are "authenticatedRead", "bucketOwnerFullControl",
     * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
     * </pre>
     *
     * <code>string destination_predefined_acl = 28;</code>
     *
     * @return The bytes for destinationPredefinedAcl.
     */
    public com.google.protobuf.ByteString getDestinationPredefinedAclBytes() {
      java.lang.Object ref = destinationPredefinedAcl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        destinationPredefinedAcl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Apply a predefined set of access controls to the destination object.
     * Valid values are "authenticatedRead", "bucketOwnerFullControl",
     * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
     * </pre>
     *
     * <code>string destination_predefined_acl = 28;</code>
     *
     * @param value The destinationPredefinedAcl to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationPredefinedAcl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      destinationPredefinedAcl_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Apply a predefined set of access controls to the destination object.
     * Valid values are "authenticatedRead", "bucketOwnerFullControl",
     * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
     * </pre>
     *
     * <code>string destination_predefined_acl = 28;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDestinationPredefinedAcl() {
      destinationPredefinedAcl_ = getDefaultInstance().getDestinationPredefinedAcl();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Apply a predefined set of access controls to the destination object.
     * Valid values are "authenticatedRead", "bucketOwnerFullControl",
     * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
     * </pre>
     *
     * <code>string destination_predefined_acl = 28;</code>
     *
     * @param value The bytes for destinationPredefinedAcl to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationPredefinedAclBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      destinationPredefinedAcl_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private long ifGenerationMatch_;
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current generation
     * matches the given value. Setting to 0 makes the operation succeed only if
     * there are no live versions of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_match = 7;</code>
     *
     * @return Whether the ifGenerationMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfGenerationMatch() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current generation
     * matches the given value. Setting to 0 makes the operation succeed only if
     * there are no live versions of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_match = 7;</code>
     *
     * @return The ifGenerationMatch.
     */
    @java.lang.Override
    public long getIfGenerationMatch() {
      return ifGenerationMatch_;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current generation
     * matches the given value. Setting to 0 makes the operation succeed only if
     * there are no live versions of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_match = 7;</code>
     *
     * @param value The ifGenerationMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfGenerationMatch(long value) {

      ifGenerationMatch_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current generation
     * matches the given value. Setting to 0 makes the operation succeed only if
     * there are no live versions of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_match = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfGenerationMatch() {
      bitField0_ = (bitField0_ & ~0x00000200);
      ifGenerationMatch_ = 0L;
      onChanged();
      return this;
    }

    private long ifGenerationNotMatch_;
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's live generation
     * does not match the given value. If no live object exists, the precondition
     * fails. Setting to 0 makes the operation succeed only if there is a live
     * version of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_not_match = 8;</code>
     *
     * @return Whether the ifGenerationNotMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfGenerationNotMatch() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's live generation
     * does not match the given value. If no live object exists, the precondition
     * fails. Setting to 0 makes the operation succeed only if there is a live
     * version of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_not_match = 8;</code>
     *
     * @return The ifGenerationNotMatch.
     */
    @java.lang.Override
    public long getIfGenerationNotMatch() {
      return ifGenerationNotMatch_;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's live generation
     * does not match the given value. If no live object exists, the precondition
     * fails. Setting to 0 makes the operation succeed only if there is a live
     * version of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_not_match = 8;</code>
     *
     * @param value The ifGenerationNotMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfGenerationNotMatch(long value) {

      ifGenerationNotMatch_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's live generation
     * does not match the given value. If no live object exists, the precondition
     * fails. Setting to 0 makes the operation succeed only if there is a live
     * version of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_not_match = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfGenerationNotMatch() {
      bitField0_ = (bitField0_ & ~0x00000400);
      ifGenerationNotMatch_ = 0L;
      onChanged();
      return this;
    }

    private long ifMetagenerationMatch_;
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the destination object's current
     * metageneration matches the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_match = 9;</code>
     *
     * @return Whether the ifMetagenerationMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfMetagenerationMatch() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the destination object's current
     * metageneration matches the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_match = 9;</code>
     *
     * @return The ifMetagenerationMatch.
     */
    @java.lang.Override
    public long getIfMetagenerationMatch() {
      return ifMetagenerationMatch_;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the destination object's current
     * metageneration matches the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_match = 9;</code>
     *
     * @param value The ifMetagenerationMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfMetagenerationMatch(long value) {

      ifMetagenerationMatch_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the destination object's current
     * metageneration matches the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_match = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfMetagenerationMatch() {
      bitField0_ = (bitField0_ & ~0x00000800);
      ifMetagenerationMatch_ = 0L;
      onChanged();
      return this;
    }

    private long ifMetagenerationNotMatch_;
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the destination object's current
     * metageneration does not match the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_not_match = 10;</code>
     *
     * @return Whether the ifMetagenerationNotMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfMetagenerationNotMatch() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the destination object's current
     * metageneration does not match the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_not_match = 10;</code>
     *
     * @return The ifMetagenerationNotMatch.
     */
    @java.lang.Override
    public long getIfMetagenerationNotMatch() {
      return ifMetagenerationNotMatch_;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the destination object's current
     * metageneration does not match the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_not_match = 10;</code>
     *
     * @param value The ifMetagenerationNotMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfMetagenerationNotMatch(long value) {

      ifMetagenerationNotMatch_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the destination object's current
     * metageneration does not match the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_not_match = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfMetagenerationNotMatch() {
      bitField0_ = (bitField0_ & ~0x00001000);
      ifMetagenerationNotMatch_ = 0L;
      onChanged();
      return this;
    }

    private long ifSourceGenerationMatch_;
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the source object's live
     * generation matches the given value.
     * </pre>
     *
     * <code>optional int64 if_source_generation_match = 11;</code>
     *
     * @return Whether the ifSourceGenerationMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfSourceGenerationMatch() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the source object's live
     * generation matches the given value.
     * </pre>
     *
     * <code>optional int64 if_source_generation_match = 11;</code>
     *
     * @return The ifSourceGenerationMatch.
     */
    @java.lang.Override
    public long getIfSourceGenerationMatch() {
      return ifSourceGenerationMatch_;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the source object's live
     * generation matches the given value.
     * </pre>
     *
     * <code>optional int64 if_source_generation_match = 11;</code>
     *
     * @param value The ifSourceGenerationMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfSourceGenerationMatch(long value) {

      ifSourceGenerationMatch_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the source object's live
     * generation matches the given value.
     * </pre>
     *
     * <code>optional int64 if_source_generation_match = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfSourceGenerationMatch() {
      bitField0_ = (bitField0_ & ~0x00002000);
      ifSourceGenerationMatch_ = 0L;
      onChanged();
      return this;
    }

    private long ifSourceGenerationNotMatch_;
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the source object's live
     * generation does not match the given value.
     * </pre>
     *
     * <code>optional int64 if_source_generation_not_match = 12;</code>
     *
     * @return Whether the ifSourceGenerationNotMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfSourceGenerationNotMatch() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the source object's live
     * generation does not match the given value.
     * </pre>
     *
     * <code>optional int64 if_source_generation_not_match = 12;</code>
     *
     * @return The ifSourceGenerationNotMatch.
     */
    @java.lang.Override
    public long getIfSourceGenerationNotMatch() {
      return ifSourceGenerationNotMatch_;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the source object's live
     * generation does not match the given value.
     * </pre>
     *
     * <code>optional int64 if_source_generation_not_match = 12;</code>
     *
     * @param value The ifSourceGenerationNotMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfSourceGenerationNotMatch(long value) {

      ifSourceGenerationNotMatch_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the source object's live
     * generation does not match the given value.
     * </pre>
     *
     * <code>optional int64 if_source_generation_not_match = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfSourceGenerationNotMatch() {
      bitField0_ = (bitField0_ & ~0x00004000);
      ifSourceGenerationNotMatch_ = 0L;
      onChanged();
      return this;
    }

    private long ifSourceMetagenerationMatch_;
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the source object's current
     * metageneration matches the given value.
     * </pre>
     *
     * <code>optional int64 if_source_metageneration_match = 13;</code>
     *
     * @return Whether the ifSourceMetagenerationMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfSourceMetagenerationMatch() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the source object's current
     * metageneration matches the given value.
     * </pre>
     *
     * <code>optional int64 if_source_metageneration_match = 13;</code>
     *
     * @return The ifSourceMetagenerationMatch.
     */
    @java.lang.Override
    public long getIfSourceMetagenerationMatch() {
      return ifSourceMetagenerationMatch_;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the source object's current
     * metageneration matches the given value.
     * </pre>
     *
     * <code>optional int64 if_source_metageneration_match = 13;</code>
     *
     * @param value The ifSourceMetagenerationMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfSourceMetagenerationMatch(long value) {

      ifSourceMetagenerationMatch_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the source object's current
     * metageneration matches the given value.
     * </pre>
     *
     * <code>optional int64 if_source_metageneration_match = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfSourceMetagenerationMatch() {
      bitField0_ = (bitField0_ & ~0x00008000);
      ifSourceMetagenerationMatch_ = 0L;
      onChanged();
      return this;
    }

    private long ifSourceMetagenerationNotMatch_;
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the source object's current
     * metageneration does not match the given value.
     * </pre>
     *
     * <code>optional int64 if_source_metageneration_not_match = 14;</code>
     *
     * @return Whether the ifSourceMetagenerationNotMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfSourceMetagenerationNotMatch() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the source object's current
     * metageneration does not match the given value.
     * </pre>
     *
     * <code>optional int64 if_source_metageneration_not_match = 14;</code>
     *
     * @return The ifSourceMetagenerationNotMatch.
     */
    @java.lang.Override
    public long getIfSourceMetagenerationNotMatch() {
      return ifSourceMetagenerationNotMatch_;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the source object's current
     * metageneration does not match the given value.
     * </pre>
     *
     * <code>optional int64 if_source_metageneration_not_match = 14;</code>
     *
     * @param value The ifSourceMetagenerationNotMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfSourceMetagenerationNotMatch(long value) {

      ifSourceMetagenerationNotMatch_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the source object's current
     * metageneration does not match the given value.
     * </pre>
     *
     * <code>optional int64 if_source_metageneration_not_match = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfSourceMetagenerationNotMatch() {
      bitField0_ = (bitField0_ & ~0x00010000);
      ifSourceMetagenerationNotMatch_ = 0L;
      onChanged();
      return this;
    }

    private long maxBytesRewrittenPerCall_;
    /**
     *
     *
     * <pre>
     * The maximum number of bytes that will be rewritten per rewrite request.
     * Most callers
     * shouldn't need to specify this parameter - it is primarily in place to
     * support testing. If specified the value must be an integral multiple of
     * 1 MiB (1048576). Also, this only applies to requests where the source and
     * destination span locations and/or storage classes. Finally, this value must
     * not change across rewrite calls else you'll get an error that the
     * `rewriteToken` is invalid.
     * </pre>
     *
     * <code>int64 max_bytes_rewritten_per_call = 15;</code>
     *
     * @return The maxBytesRewrittenPerCall.
     */
    @java.lang.Override
    public long getMaxBytesRewrittenPerCall() {
      return maxBytesRewrittenPerCall_;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of bytes that will be rewritten per rewrite request.
     * Most callers
     * shouldn't need to specify this parameter - it is primarily in place to
     * support testing. If specified the value must be an integral multiple of
     * 1 MiB (1048576). Also, this only applies to requests where the source and
     * destination span locations and/or storage classes. Finally, this value must
     * not change across rewrite calls else you'll get an error that the
     * `rewriteToken` is invalid.
     * </pre>
     *
     * <code>int64 max_bytes_rewritten_per_call = 15;</code>
     *
     * @param value The maxBytesRewrittenPerCall to set.
     * @return This builder for chaining.
     */
    public Builder setMaxBytesRewrittenPerCall(long value) {

      maxBytesRewrittenPerCall_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of bytes that will be rewritten per rewrite request.
     * Most callers
     * shouldn't need to specify this parameter - it is primarily in place to
     * support testing. If specified the value must be an integral multiple of
     * 1 MiB (1048576). Also, this only applies to requests where the source and
     * destination span locations and/or storage classes. Finally, this value must
     * not change across rewrite calls else you'll get an error that the
     * `rewriteToken` is invalid.
     * </pre>
     *
     * <code>int64 max_bytes_rewritten_per_call = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxBytesRewrittenPerCall() {
      bitField0_ = (bitField0_ & ~0x00020000);
      maxBytesRewrittenPerCall_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object copySourceEncryptionAlgorithm_ = "";
    /**
     *
     *
     * <pre>
     * The algorithm used to encrypt the source object, if any. Used if the source
     * object was encrypted with a Customer-Supplied Encryption Key.
     * </pre>
     *
     * <code>string copy_source_encryption_algorithm = 16;</code>
     *
     * @return The copySourceEncryptionAlgorithm.
     */
    public java.lang.String getCopySourceEncryptionAlgorithm() {
      java.lang.Object ref = copySourceEncryptionAlgorithm_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        copySourceEncryptionAlgorithm_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The algorithm used to encrypt the source object, if any. Used if the source
     * object was encrypted with a Customer-Supplied Encryption Key.
     * </pre>
     *
     * <code>string copy_source_encryption_algorithm = 16;</code>
     *
     * @return The bytes for copySourceEncryptionAlgorithm.
     */
    public com.google.protobuf.ByteString getCopySourceEncryptionAlgorithmBytes() {
      java.lang.Object ref = copySourceEncryptionAlgorithm_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        copySourceEncryptionAlgorithm_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The algorithm used to encrypt the source object, if any. Used if the source
     * object was encrypted with a Customer-Supplied Encryption Key.
     * </pre>
     *
     * <code>string copy_source_encryption_algorithm = 16;</code>
     *
     * @param value The copySourceEncryptionAlgorithm to set.
     * @return This builder for chaining.
     */
    public Builder setCopySourceEncryptionAlgorithm(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      copySourceEncryptionAlgorithm_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The algorithm used to encrypt the source object, if any. Used if the source
     * object was encrypted with a Customer-Supplied Encryption Key.
     * </pre>
     *
     * <code>string copy_source_encryption_algorithm = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCopySourceEncryptionAlgorithm() {
      copySourceEncryptionAlgorithm_ = getDefaultInstance().getCopySourceEncryptionAlgorithm();
      bitField0_ = (bitField0_ & ~0x00040000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The algorithm used to encrypt the source object, if any. Used if the source
     * object was encrypted with a Customer-Supplied Encryption Key.
     * </pre>
     *
     * <code>string copy_source_encryption_algorithm = 16;</code>
     *
     * @param value The bytes for copySourceEncryptionAlgorithm to set.
     * @return This builder for chaining.
     */
    public Builder setCopySourceEncryptionAlgorithmBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      copySourceEncryptionAlgorithm_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString copySourceEncryptionKeyBytes_ =
        com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * The raw bytes (not base64-encoded) AES-256 encryption key used to encrypt
     * the source object, if it was encrypted with a Customer-Supplied Encryption
     * Key.
     * </pre>
     *
     * <code>bytes copy_source_encryption_key_bytes = 21;</code>
     *
     * @return The copySourceEncryptionKeyBytes.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCopySourceEncryptionKeyBytes() {
      return copySourceEncryptionKeyBytes_;
    }
    /**
     *
     *
     * <pre>
     * The raw bytes (not base64-encoded) AES-256 encryption key used to encrypt
     * the source object, if it was encrypted with a Customer-Supplied Encryption
     * Key.
     * </pre>
     *
     * <code>bytes copy_source_encryption_key_bytes = 21;</code>
     *
     * @param value The copySourceEncryptionKeyBytes to set.
     * @return This builder for chaining.
     */
    public Builder setCopySourceEncryptionKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      copySourceEncryptionKeyBytes_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The raw bytes (not base64-encoded) AES-256 encryption key used to encrypt
     * the source object, if it was encrypted with a Customer-Supplied Encryption
     * Key.
     * </pre>
     *
     * <code>bytes copy_source_encryption_key_bytes = 21;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCopySourceEncryptionKeyBytes() {
      bitField0_ = (bitField0_ & ~0x00080000);
      copySourceEncryptionKeyBytes_ = getDefaultInstance().getCopySourceEncryptionKeyBytes();
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString copySourceEncryptionKeySha256Bytes_ =
        com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * The raw bytes (not base64-encoded) SHA256 hash of the encryption key used
     * to encrypt the source object, if it was encrypted with a Customer-Supplied
     * Encryption Key.
     * </pre>
     *
     * <code>bytes copy_source_encryption_key_sha256_bytes = 22;</code>
     *
     * @return The copySourceEncryptionKeySha256Bytes.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCopySourceEncryptionKeySha256Bytes() {
      return copySourceEncryptionKeySha256Bytes_;
    }
    /**
     *
     *
     * <pre>
     * The raw bytes (not base64-encoded) SHA256 hash of the encryption key used
     * to encrypt the source object, if it was encrypted with a Customer-Supplied
     * Encryption Key.
     * </pre>
     *
     * <code>bytes copy_source_encryption_key_sha256_bytes = 22;</code>
     *
     * @param value The copySourceEncryptionKeySha256Bytes to set.
     * @return This builder for chaining.
     */
    public Builder setCopySourceEncryptionKeySha256Bytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      copySourceEncryptionKeySha256Bytes_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The raw bytes (not base64-encoded) SHA256 hash of the encryption key used
     * to encrypt the source object, if it was encrypted with a Customer-Supplied
     * Encryption Key.
     * </pre>
     *
     * <code>bytes copy_source_encryption_key_sha256_bytes = 22;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCopySourceEncryptionKeySha256Bytes() {
      bitField0_ = (bitField0_ & ~0x00100000);
      copySourceEncryptionKeySha256Bytes_ =
          getDefaultInstance().getCopySourceEncryptionKeySha256Bytes();
      onChanged();
      return this;
    }

    private com.google.storage.v2.CommonObjectRequestParams commonObjectRequestParams_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.CommonObjectRequestParams,
            com.google.storage.v2.CommonObjectRequestParams.Builder,
            com.google.storage.v2.CommonObjectRequestParamsOrBuilder>
        commonObjectRequestParamsBuilder_;
    /**
     *
     *
     * <pre>
     * A set of parameters common to Storage API requests concerning an object.
     * </pre>
     *
     * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 19;</code>
     *
     * @return Whether the commonObjectRequestParams field is set.
     */
    public boolean hasCommonObjectRequestParams() {
      return ((bitField0_ & 0x00200000) != 0);
    }
    /**
     *
     *
     * <pre>
     * A set of parameters common to Storage API requests concerning an object.
     * </pre>
     *
     * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 19;</code>
     *
     * @return The commonObjectRequestParams.
     */
    public com.google.storage.v2.CommonObjectRequestParams getCommonObjectRequestParams() {
      if (commonObjectRequestParamsBuilder_ == null) {
        return commonObjectRequestParams_ == null
            ? com.google.storage.v2.CommonObjectRequestParams.getDefaultInstance()
            : commonObjectRequestParams_;
      } else {
        return commonObjectRequestParamsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A set of parameters common to Storage API requests concerning an object.
     * </pre>
     *
     * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 19;</code>
     */
    public Builder setCommonObjectRequestParams(
        com.google.storage.v2.CommonObjectRequestParams value) {
      if (commonObjectRequestParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        commonObjectRequestParams_ = value;
      } else {
        commonObjectRequestParamsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of parameters common to Storage API requests concerning an object.
     * </pre>
     *
     * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 19;</code>
     */
    public Builder setCommonObjectRequestParams(
        com.google.storage.v2.CommonObjectRequestParams.Builder builderForValue) {
      if (commonObjectRequestParamsBuilder_ == null) {
        commonObjectRequestParams_ = builderForValue.build();
      } else {
        commonObjectRequestParamsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of parameters common to Storage API requests concerning an object.
     * </pre>
     *
     * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 19;</code>
     */
    public Builder mergeCommonObjectRequestParams(
        com.google.storage.v2.CommonObjectRequestParams value) {
      if (commonObjectRequestParamsBuilder_ == null) {
        if (((bitField0_ & 0x00200000) != 0)
            && commonObjectRequestParams_ != null
            && commonObjectRequestParams_
                != com.google.storage.v2.CommonObjectRequestParams.getDefaultInstance()) {
          getCommonObjectRequestParamsBuilder().mergeFrom(value);
        } else {
          commonObjectRequestParams_ = value;
        }
      } else {
        commonObjectRequestParamsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of parameters common to Storage API requests concerning an object.
     * </pre>
     *
     * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 19;</code>
     */
    public Builder clearCommonObjectRequestParams() {
      bitField0_ = (bitField0_ & ~0x00200000);
      commonObjectRequestParams_ = null;
      if (commonObjectRequestParamsBuilder_ != null) {
        commonObjectRequestParamsBuilder_.dispose();
        commonObjectRequestParamsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of parameters common to Storage API requests concerning an object.
     * </pre>
     *
     * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 19;</code>
     */
    public com.google.storage.v2.CommonObjectRequestParams.Builder
        getCommonObjectRequestParamsBuilder() {
      bitField0_ |= 0x00200000;
      onChanged();
      return getCommonObjectRequestParamsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A set of parameters common to Storage API requests concerning an object.
     * </pre>
     *
     * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 19;</code>
     */
    public com.google.storage.v2.CommonObjectRequestParamsOrBuilder
        getCommonObjectRequestParamsOrBuilder() {
      if (commonObjectRequestParamsBuilder_ != null) {
        return commonObjectRequestParamsBuilder_.getMessageOrBuilder();
      } else {
        return commonObjectRequestParams_ == null
            ? com.google.storage.v2.CommonObjectRequestParams.getDefaultInstance()
            : commonObjectRequestParams_;
      }
    }
    /**
     *
     *
     * <pre>
     * A set of parameters common to Storage API requests concerning an object.
     * </pre>
     *
     * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 19;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.CommonObjectRequestParams,
            com.google.storage.v2.CommonObjectRequestParams.Builder,
            com.google.storage.v2.CommonObjectRequestParamsOrBuilder>
        getCommonObjectRequestParamsFieldBuilder() {
      if (commonObjectRequestParamsBuilder_ == null) {
        commonObjectRequestParamsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.CommonObjectRequestParams,
                com.google.storage.v2.CommonObjectRequestParams.Builder,
                com.google.storage.v2.CommonObjectRequestParamsOrBuilder>(
                getCommonObjectRequestParams(), getParentForChildren(), isClean());
        commonObjectRequestParams_ = null;
      }
      return commonObjectRequestParamsBuilder_;
    }

    private com.google.storage.v2.ObjectChecksums objectChecksums_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.ObjectChecksums,
            com.google.storage.v2.ObjectChecksums.Builder,
            com.google.storage.v2.ObjectChecksumsOrBuilder>
        objectChecksumsBuilder_;
    /**
     *
     *
     * <pre>
     * The checksums of the complete object. This will be used to validate the
     * destination object after rewriting.
     * </pre>
     *
     * <code>.google.storage.v2.ObjectChecksums object_checksums = 29;</code>
     *
     * @return Whether the objectChecksums field is set.
     */
    public boolean hasObjectChecksums() {
      return ((bitField0_ & 0x00400000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The checksums of the complete object. This will be used to validate the
     * destination object after rewriting.
     * </pre>
     *
     * <code>.google.storage.v2.ObjectChecksums object_checksums = 29;</code>
     *
     * @return The objectChecksums.
     */
    public com.google.storage.v2.ObjectChecksums getObjectChecksums() {
      if (objectChecksumsBuilder_ == null) {
        return objectChecksums_ == null
            ? com.google.storage.v2.ObjectChecksums.getDefaultInstance()
            : objectChecksums_;
      } else {
        return objectChecksumsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The checksums of the complete object. This will be used to validate the
     * destination object after rewriting.
     * </pre>
     *
     * <code>.google.storage.v2.ObjectChecksums object_checksums = 29;</code>
     */
    public Builder setObjectChecksums(com.google.storage.v2.ObjectChecksums value) {
      if (objectChecksumsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        objectChecksums_ = value;
      } else {
        objectChecksumsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The checksums of the complete object. This will be used to validate the
     * destination object after rewriting.
     * </pre>
     *
     * <code>.google.storage.v2.ObjectChecksums object_checksums = 29;</code>
     */
    public Builder setObjectChecksums(
        com.google.storage.v2.ObjectChecksums.Builder builderForValue) {
      if (objectChecksumsBuilder_ == null) {
        objectChecksums_ = builderForValue.build();
      } else {
        objectChecksumsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The checksums of the complete object. This will be used to validate the
     * destination object after rewriting.
     * </pre>
     *
     * <code>.google.storage.v2.ObjectChecksums object_checksums = 29;</code>
     */
    public Builder mergeObjectChecksums(com.google.storage.v2.ObjectChecksums value) {
      if (objectChecksumsBuilder_ == null) {
        if (((bitField0_ & 0x00400000) != 0)
            && objectChecksums_ != null
            && objectChecksums_ != com.google.storage.v2.ObjectChecksums.getDefaultInstance()) {
          getObjectChecksumsBuilder().mergeFrom(value);
        } else {
          objectChecksums_ = value;
        }
      } else {
        objectChecksumsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The checksums of the complete object. This will be used to validate the
     * destination object after rewriting.
     * </pre>
     *
     * <code>.google.storage.v2.ObjectChecksums object_checksums = 29;</code>
     */
    public Builder clearObjectChecksums() {
      bitField0_ = (bitField0_ & ~0x00400000);
      objectChecksums_ = null;
      if (objectChecksumsBuilder_ != null) {
        objectChecksumsBuilder_.dispose();
        objectChecksumsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The checksums of the complete object. This will be used to validate the
     * destination object after rewriting.
     * </pre>
     *
     * <code>.google.storage.v2.ObjectChecksums object_checksums = 29;</code>
     */
    public com.google.storage.v2.ObjectChecksums.Builder getObjectChecksumsBuilder() {
      bitField0_ |= 0x00400000;
      onChanged();
      return getObjectChecksumsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The checksums of the complete object. This will be used to validate the
     * destination object after rewriting.
     * </pre>
     *
     * <code>.google.storage.v2.ObjectChecksums object_checksums = 29;</code>
     */
    public com.google.storage.v2.ObjectChecksumsOrBuilder getObjectChecksumsOrBuilder() {
      if (objectChecksumsBuilder_ != null) {
        return objectChecksumsBuilder_.getMessageOrBuilder();
      } else {
        return objectChecksums_ == null
            ? com.google.storage.v2.ObjectChecksums.getDefaultInstance()
            : objectChecksums_;
      }
    }
    /**
     *
     *
     * <pre>
     * The checksums of the complete object. This will be used to validate the
     * destination object after rewriting.
     * </pre>
     *
     * <code>.google.storage.v2.ObjectChecksums object_checksums = 29;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.ObjectChecksums,
            com.google.storage.v2.ObjectChecksums.Builder,
            com.google.storage.v2.ObjectChecksumsOrBuilder>
        getObjectChecksumsFieldBuilder() {
      if (objectChecksumsBuilder_ == null) {
        objectChecksumsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.ObjectChecksums,
                com.google.storage.v2.ObjectChecksums.Builder,
                com.google.storage.v2.ObjectChecksumsOrBuilder>(
                getObjectChecksums(), getParentForChildren(), isClean());
        objectChecksums_ = null;
      }
      return objectChecksumsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.storage.v2.RewriteObjectRequest)
  }

  // @@protoc_insertion_point(class_scope:google.storage.v2.RewriteObjectRequest)
  private static final com.google.storage.v2.RewriteObjectRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.storage.v2.RewriteObjectRequest();
  }

  public static com.google.storage.v2.RewriteObjectRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RewriteObjectRequest> PARSER =
      new com.google.protobuf.AbstractParser<RewriteObjectRequest>() {
        @java.lang.Override
        public RewriteObjectRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RewriteObjectRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RewriteObjectRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.storage.v2.RewriteObjectRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
