/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/v2/storage.proto

// Protobuf Java Version: 3.25.5
package com.google.storage.v2;

/**
 *
 *
 * <pre>
 * Response message for BidiReadObject.
 * </pre>
 *
 * Protobuf type {@code google.storage.v2.BidiReadObjectResponse}
 */
public final class BidiReadObjectResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.storage.v2.BidiReadObjectResponse)
    BidiReadObjectResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BidiReadObjectResponse.newBuilder() to construct.
  private BidiReadObjectResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BidiReadObjectResponse() {
    objectDataRanges_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BidiReadObjectResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_BidiReadObjectResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_BidiReadObjectResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.storage.v2.BidiReadObjectResponse.class,
            com.google.storage.v2.BidiReadObjectResponse.Builder.class);
  }

  private int bitField0_;
  public static final int OBJECT_DATA_RANGES_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.storage.v2.ObjectRangeData> objectDataRanges_;
  /**
   *
   *
   * <pre>
   * A portion of the object's data. The service **may** leave data
   * empty for any given ReadResponse. This enables the service to inform the
   * client that the request is still live while it is running an operation to
   * generate more data.
   * The service **may** pipeline multiple responses belonging to different read
   * requests. Each ObjectRangeData entry will have a read_id
   * set to the same value as the corresponding source read request.
   * </pre>
   *
   * <code>repeated .google.storage.v2.ObjectRangeData object_data_ranges = 6;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.storage.v2.ObjectRangeData> getObjectDataRangesList() {
    return objectDataRanges_;
  }
  /**
   *
   *
   * <pre>
   * A portion of the object's data. The service **may** leave data
   * empty for any given ReadResponse. This enables the service to inform the
   * client that the request is still live while it is running an operation to
   * generate more data.
   * The service **may** pipeline multiple responses belonging to different read
   * requests. Each ObjectRangeData entry will have a read_id
   * set to the same value as the corresponding source read request.
   * </pre>
   *
   * <code>repeated .google.storage.v2.ObjectRangeData object_data_ranges = 6;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.storage.v2.ObjectRangeDataOrBuilder>
      getObjectDataRangesOrBuilderList() {
    return objectDataRanges_;
  }
  /**
   *
   *
   * <pre>
   * A portion of the object's data. The service **may** leave data
   * empty for any given ReadResponse. This enables the service to inform the
   * client that the request is still live while it is running an operation to
   * generate more data.
   * The service **may** pipeline multiple responses belonging to different read
   * requests. Each ObjectRangeData entry will have a read_id
   * set to the same value as the corresponding source read request.
   * </pre>
   *
   * <code>repeated .google.storage.v2.ObjectRangeData object_data_ranges = 6;</code>
   */
  @java.lang.Override
  public int getObjectDataRangesCount() {
    return objectDataRanges_.size();
  }
  /**
   *
   *
   * <pre>
   * A portion of the object's data. The service **may** leave data
   * empty for any given ReadResponse. This enables the service to inform the
   * client that the request is still live while it is running an operation to
   * generate more data.
   * The service **may** pipeline multiple responses belonging to different read
   * requests. Each ObjectRangeData entry will have a read_id
   * set to the same value as the corresponding source read request.
   * </pre>
   *
   * <code>repeated .google.storage.v2.ObjectRangeData object_data_ranges = 6;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.ObjectRangeData getObjectDataRanges(int index) {
    return objectDataRanges_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A portion of the object's data. The service **may** leave data
   * empty for any given ReadResponse. This enables the service to inform the
   * client that the request is still live while it is running an operation to
   * generate more data.
   * The service **may** pipeline multiple responses belonging to different read
   * requests. Each ObjectRangeData entry will have a read_id
   * set to the same value as the corresponding source read request.
   * </pre>
   *
   * <code>repeated .google.storage.v2.ObjectRangeData object_data_ranges = 6;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.ObjectRangeDataOrBuilder getObjectDataRangesOrBuilder(int index) {
    return objectDataRanges_.get(index);
  }

  public static final int METADATA_FIELD_NUMBER = 4;
  private com.google.storage.v2.Object metadata_;
  /**
   *
   *
   * <pre>
   * Metadata of the object whose media is being returned.
   * Only populated in the first response in the stream and not populated when
   * the stream is opened with a read handle.
   * </pre>
   *
   * <code>.google.storage.v2.Object metadata = 4;</code>
   *
   * @return Whether the metadata field is set.
   */
  @java.lang.Override
  public boolean hasMetadata() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Metadata of the object whose media is being returned.
   * Only populated in the first response in the stream and not populated when
   * the stream is opened with a read handle.
   * </pre>
   *
   * <code>.google.storage.v2.Object metadata = 4;</code>
   *
   * @return The metadata.
   */
  @java.lang.Override
  public com.google.storage.v2.Object getMetadata() {
    return metadata_ == null ? com.google.storage.v2.Object.getDefaultInstance() : metadata_;
  }
  /**
   *
   *
   * <pre>
   * Metadata of the object whose media is being returned.
   * Only populated in the first response in the stream and not populated when
   * the stream is opened with a read handle.
   * </pre>
   *
   * <code>.google.storage.v2.Object metadata = 4;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.ObjectOrBuilder getMetadataOrBuilder() {
    return metadata_ == null ? com.google.storage.v2.Object.getDefaultInstance() : metadata_;
  }

  public static final int READ_HANDLE_FIELD_NUMBER = 7;
  private com.google.storage.v2.BidiReadHandle readHandle_;
  /**
   *
   *
   * <pre>
   * This field will be periodically refreshed, however it may not be set in
   * every response. It allows the client to more efficiently open subsequent
   * bidirectional streams to the same object.
   * </pre>
   *
   * <code>.google.storage.v2.BidiReadHandle read_handle = 7;</code>
   *
   * @return Whether the readHandle field is set.
   */
  @java.lang.Override
  public boolean hasReadHandle() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * This field will be periodically refreshed, however it may not be set in
   * every response. It allows the client to more efficiently open subsequent
   * bidirectional streams to the same object.
   * </pre>
   *
   * <code>.google.storage.v2.BidiReadHandle read_handle = 7;</code>
   *
   * @return The readHandle.
   */
  @java.lang.Override
  public com.google.storage.v2.BidiReadHandle getReadHandle() {
    return readHandle_ == null
        ? com.google.storage.v2.BidiReadHandle.getDefaultInstance()
        : readHandle_;
  }
  /**
   *
   *
   * <pre>
   * This field will be periodically refreshed, however it may not be set in
   * every response. It allows the client to more efficiently open subsequent
   * bidirectional streams to the same object.
   * </pre>
   *
   * <code>.google.storage.v2.BidiReadHandle read_handle = 7;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.BidiReadHandleOrBuilder getReadHandleOrBuilder() {
    return readHandle_ == null
        ? com.google.storage.v2.BidiReadHandle.getDefaultInstance()
        : readHandle_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getMetadata());
    }
    for (int i = 0; i < objectDataRanges_.size(); i++) {
      output.writeMessage(6, objectDataRanges_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getReadHandle());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getMetadata());
    }
    for (int i = 0; i < objectDataRanges_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, objectDataRanges_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getReadHandle());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.storage.v2.BidiReadObjectResponse)) {
      return super.equals(obj);
    }
    com.google.storage.v2.BidiReadObjectResponse other =
        (com.google.storage.v2.BidiReadObjectResponse) obj;

    if (!getObjectDataRangesList().equals(other.getObjectDataRangesList())) return false;
    if (hasMetadata() != other.hasMetadata()) return false;
    if (hasMetadata()) {
      if (!getMetadata().equals(other.getMetadata())) return false;
    }
    if (hasReadHandle() != other.hasReadHandle()) return false;
    if (hasReadHandle()) {
      if (!getReadHandle().equals(other.getReadHandle())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getObjectDataRangesCount() > 0) {
      hash = (37 * hash) + OBJECT_DATA_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getObjectDataRangesList().hashCode();
    }
    if (hasMetadata()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadata().hashCode();
    }
    if (hasReadHandle()) {
      hash = (37 * hash) + READ_HANDLE_FIELD_NUMBER;
      hash = (53 * hash) + getReadHandle().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.storage.v2.BidiReadObjectResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.BidiReadObjectResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.BidiReadObjectResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.BidiReadObjectResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.BidiReadObjectResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.BidiReadObjectResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.BidiReadObjectResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.BidiReadObjectResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.BidiReadObjectResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.BidiReadObjectResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.BidiReadObjectResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.BidiReadObjectResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.storage.v2.BidiReadObjectResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for BidiReadObject.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.BidiReadObjectResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.storage.v2.BidiReadObjectResponse)
      com.google.storage.v2.BidiReadObjectResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_BidiReadObjectResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_BidiReadObjectResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.BidiReadObjectResponse.class,
              com.google.storage.v2.BidiReadObjectResponse.Builder.class);
    }

    // Construct using com.google.storage.v2.BidiReadObjectResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getObjectDataRangesFieldBuilder();
        getMetadataFieldBuilder();
        getReadHandleFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (objectDataRangesBuilder_ == null) {
        objectDataRanges_ = java.util.Collections.emptyList();
      } else {
        objectDataRanges_ = null;
        objectDataRangesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      readHandle_ = null;
      if (readHandleBuilder_ != null) {
        readHandleBuilder_.dispose();
        readHandleBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_BidiReadObjectResponse_descriptor;
    }

    @java.lang.Override
    public com.google.storage.v2.BidiReadObjectResponse getDefaultInstanceForType() {
      return com.google.storage.v2.BidiReadObjectResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.storage.v2.BidiReadObjectResponse build() {
      com.google.storage.v2.BidiReadObjectResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.storage.v2.BidiReadObjectResponse buildPartial() {
      com.google.storage.v2.BidiReadObjectResponse result =
          new com.google.storage.v2.BidiReadObjectResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.storage.v2.BidiReadObjectResponse result) {
      if (objectDataRangesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          objectDataRanges_ = java.util.Collections.unmodifiableList(objectDataRanges_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.objectDataRanges_ = objectDataRanges_;
      } else {
        result.objectDataRanges_ = objectDataRangesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.storage.v2.BidiReadObjectResponse result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.metadata_ = metadataBuilder_ == null ? metadata_ : metadataBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.readHandle_ = readHandleBuilder_ == null ? readHandle_ : readHandleBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.storage.v2.BidiReadObjectResponse) {
        return mergeFrom((com.google.storage.v2.BidiReadObjectResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.storage.v2.BidiReadObjectResponse other) {
      if (other == com.google.storage.v2.BidiReadObjectResponse.getDefaultInstance()) return this;
      if (objectDataRangesBuilder_ == null) {
        if (!other.objectDataRanges_.isEmpty()) {
          if (objectDataRanges_.isEmpty()) {
            objectDataRanges_ = other.objectDataRanges_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureObjectDataRangesIsMutable();
            objectDataRanges_.addAll(other.objectDataRanges_);
          }
          onChanged();
        }
      } else {
        if (!other.objectDataRanges_.isEmpty()) {
          if (objectDataRangesBuilder_.isEmpty()) {
            objectDataRangesBuilder_.dispose();
            objectDataRangesBuilder_ = null;
            objectDataRanges_ = other.objectDataRanges_;
            bitField0_ = (bitField0_ & ~0x00000001);
            objectDataRangesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getObjectDataRangesFieldBuilder()
                    : null;
          } else {
            objectDataRangesBuilder_.addAllMessages(other.objectDataRanges_);
          }
        }
      }
      if (other.hasMetadata()) {
        mergeMetadata(other.getMetadata());
      }
      if (other.hasReadHandle()) {
        mergeReadHandle(other.getReadHandle());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 34:
              {
                input.readMessage(getMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 34
            case 50:
              {
                com.google.storage.v2.ObjectRangeData m =
                    input.readMessage(
                        com.google.storage.v2.ObjectRangeData.parser(), extensionRegistry);
                if (objectDataRangesBuilder_ == null) {
                  ensureObjectDataRangesIsMutable();
                  objectDataRanges_.add(m);
                } else {
                  objectDataRangesBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getReadHandleFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.storage.v2.ObjectRangeData> objectDataRanges_ =
        java.util.Collections.emptyList();

    private void ensureObjectDataRangesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        objectDataRanges_ =
            new java.util.ArrayList<com.google.storage.v2.ObjectRangeData>(objectDataRanges_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.storage.v2.ObjectRangeData,
            com.google.storage.v2.ObjectRangeData.Builder,
            com.google.storage.v2.ObjectRangeDataOrBuilder>
        objectDataRangesBuilder_;

    /**
     *
     *
     * <pre>
     * A portion of the object's data. The service **may** leave data
     * empty for any given ReadResponse. This enables the service to inform the
     * client that the request is still live while it is running an operation to
     * generate more data.
     * The service **may** pipeline multiple responses belonging to different read
     * requests. Each ObjectRangeData entry will have a read_id
     * set to the same value as the corresponding source read request.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectRangeData object_data_ranges = 6;</code>
     */
    public java.util.List<com.google.storage.v2.ObjectRangeData> getObjectDataRangesList() {
      if (objectDataRangesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(objectDataRanges_);
      } else {
        return objectDataRangesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A portion of the object's data. The service **may** leave data
     * empty for any given ReadResponse. This enables the service to inform the
     * client that the request is still live while it is running an operation to
     * generate more data.
     * The service **may** pipeline multiple responses belonging to different read
     * requests. Each ObjectRangeData entry will have a read_id
     * set to the same value as the corresponding source read request.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectRangeData object_data_ranges = 6;</code>
     */
    public int getObjectDataRangesCount() {
      if (objectDataRangesBuilder_ == null) {
        return objectDataRanges_.size();
      } else {
        return objectDataRangesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A portion of the object's data. The service **may** leave data
     * empty for any given ReadResponse. This enables the service to inform the
     * client that the request is still live while it is running an operation to
     * generate more data.
     * The service **may** pipeline multiple responses belonging to different read
     * requests. Each ObjectRangeData entry will have a read_id
     * set to the same value as the corresponding source read request.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectRangeData object_data_ranges = 6;</code>
     */
    public com.google.storage.v2.ObjectRangeData getObjectDataRanges(int index) {
      if (objectDataRangesBuilder_ == null) {
        return objectDataRanges_.get(index);
      } else {
        return objectDataRangesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A portion of the object's data. The service **may** leave data
     * empty for any given ReadResponse. This enables the service to inform the
     * client that the request is still live while it is running an operation to
     * generate more data.
     * The service **may** pipeline multiple responses belonging to different read
     * requests. Each ObjectRangeData entry will have a read_id
     * set to the same value as the corresponding source read request.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectRangeData object_data_ranges = 6;</code>
     */
    public Builder setObjectDataRanges(int index, com.google.storage.v2.ObjectRangeData value) {
      if (objectDataRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureObjectDataRangesIsMutable();
        objectDataRanges_.set(index, value);
        onChanged();
      } else {
        objectDataRangesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A portion of the object's data. The service **may** leave data
     * empty for any given ReadResponse. This enables the service to inform the
     * client that the request is still live while it is running an operation to
     * generate more data.
     * The service **may** pipeline multiple responses belonging to different read
     * requests. Each ObjectRangeData entry will have a read_id
     * set to the same value as the corresponding source read request.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectRangeData object_data_ranges = 6;</code>
     */
    public Builder setObjectDataRanges(
        int index, com.google.storage.v2.ObjectRangeData.Builder builderForValue) {
      if (objectDataRangesBuilder_ == null) {
        ensureObjectDataRangesIsMutable();
        objectDataRanges_.set(index, builderForValue.build());
        onChanged();
      } else {
        objectDataRangesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A portion of the object's data. The service **may** leave data
     * empty for any given ReadResponse. This enables the service to inform the
     * client that the request is still live while it is running an operation to
     * generate more data.
     * The service **may** pipeline multiple responses belonging to different read
     * requests. Each ObjectRangeData entry will have a read_id
     * set to the same value as the corresponding source read request.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectRangeData object_data_ranges = 6;</code>
     */
    public Builder addObjectDataRanges(com.google.storage.v2.ObjectRangeData value) {
      if (objectDataRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureObjectDataRangesIsMutable();
        objectDataRanges_.add(value);
        onChanged();
      } else {
        objectDataRangesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A portion of the object's data. The service **may** leave data
     * empty for any given ReadResponse. This enables the service to inform the
     * client that the request is still live while it is running an operation to
     * generate more data.
     * The service **may** pipeline multiple responses belonging to different read
     * requests. Each ObjectRangeData entry will have a read_id
     * set to the same value as the corresponding source read request.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectRangeData object_data_ranges = 6;</code>
     */
    public Builder addObjectDataRanges(int index, com.google.storage.v2.ObjectRangeData value) {
      if (objectDataRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureObjectDataRangesIsMutable();
        objectDataRanges_.add(index, value);
        onChanged();
      } else {
        objectDataRangesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A portion of the object's data. The service **may** leave data
     * empty for any given ReadResponse. This enables the service to inform the
     * client that the request is still live while it is running an operation to
     * generate more data.
     * The service **may** pipeline multiple responses belonging to different read
     * requests. Each ObjectRangeData entry will have a read_id
     * set to the same value as the corresponding source read request.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectRangeData object_data_ranges = 6;</code>
     */
    public Builder addObjectDataRanges(
        com.google.storage.v2.ObjectRangeData.Builder builderForValue) {
      if (objectDataRangesBuilder_ == null) {
        ensureObjectDataRangesIsMutable();
        objectDataRanges_.add(builderForValue.build());
        onChanged();
      } else {
        objectDataRangesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A portion of the object's data. The service **may** leave data
     * empty for any given ReadResponse. This enables the service to inform the
     * client that the request is still live while it is running an operation to
     * generate more data.
     * The service **may** pipeline multiple responses belonging to different read
     * requests. Each ObjectRangeData entry will have a read_id
     * set to the same value as the corresponding source read request.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectRangeData object_data_ranges = 6;</code>
     */
    public Builder addObjectDataRanges(
        int index, com.google.storage.v2.ObjectRangeData.Builder builderForValue) {
      if (objectDataRangesBuilder_ == null) {
        ensureObjectDataRangesIsMutable();
        objectDataRanges_.add(index, builderForValue.build());
        onChanged();
      } else {
        objectDataRangesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A portion of the object's data. The service **may** leave data
     * empty for any given ReadResponse. This enables the service to inform the
     * client that the request is still live while it is running an operation to
     * generate more data.
     * The service **may** pipeline multiple responses belonging to different read
     * requests. Each ObjectRangeData entry will have a read_id
     * set to the same value as the corresponding source read request.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectRangeData object_data_ranges = 6;</code>
     */
    public Builder addAllObjectDataRanges(
        java.lang.Iterable<? extends com.google.storage.v2.ObjectRangeData> values) {
      if (objectDataRangesBuilder_ == null) {
        ensureObjectDataRangesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, objectDataRanges_);
        onChanged();
      } else {
        objectDataRangesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A portion of the object's data. The service **may** leave data
     * empty for any given ReadResponse. This enables the service to inform the
     * client that the request is still live while it is running an operation to
     * generate more data.
     * The service **may** pipeline multiple responses belonging to different read
     * requests. Each ObjectRangeData entry will have a read_id
     * set to the same value as the corresponding source read request.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectRangeData object_data_ranges = 6;</code>
     */
    public Builder clearObjectDataRanges() {
      if (objectDataRangesBuilder_ == null) {
        objectDataRanges_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        objectDataRangesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A portion of the object's data. The service **may** leave data
     * empty for any given ReadResponse. This enables the service to inform the
     * client that the request is still live while it is running an operation to
     * generate more data.
     * The service **may** pipeline multiple responses belonging to different read
     * requests. Each ObjectRangeData entry will have a read_id
     * set to the same value as the corresponding source read request.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectRangeData object_data_ranges = 6;</code>
     */
    public Builder removeObjectDataRanges(int index) {
      if (objectDataRangesBuilder_ == null) {
        ensureObjectDataRangesIsMutable();
        objectDataRanges_.remove(index);
        onChanged();
      } else {
        objectDataRangesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A portion of the object's data. The service **may** leave data
     * empty for any given ReadResponse. This enables the service to inform the
     * client that the request is still live while it is running an operation to
     * generate more data.
     * The service **may** pipeline multiple responses belonging to different read
     * requests. Each ObjectRangeData entry will have a read_id
     * set to the same value as the corresponding source read request.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectRangeData object_data_ranges = 6;</code>
     */
    public com.google.storage.v2.ObjectRangeData.Builder getObjectDataRangesBuilder(int index) {
      return getObjectDataRangesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A portion of the object's data. The service **may** leave data
     * empty for any given ReadResponse. This enables the service to inform the
     * client that the request is still live while it is running an operation to
     * generate more data.
     * The service **may** pipeline multiple responses belonging to different read
     * requests. Each ObjectRangeData entry will have a read_id
     * set to the same value as the corresponding source read request.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectRangeData object_data_ranges = 6;</code>
     */
    public com.google.storage.v2.ObjectRangeDataOrBuilder getObjectDataRangesOrBuilder(int index) {
      if (objectDataRangesBuilder_ == null) {
        return objectDataRanges_.get(index);
      } else {
        return objectDataRangesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A portion of the object's data. The service **may** leave data
     * empty for any given ReadResponse. This enables the service to inform the
     * client that the request is still live while it is running an operation to
     * generate more data.
     * The service **may** pipeline multiple responses belonging to different read
     * requests. Each ObjectRangeData entry will have a read_id
     * set to the same value as the corresponding source read request.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectRangeData object_data_ranges = 6;</code>
     */
    public java.util.List<? extends com.google.storage.v2.ObjectRangeDataOrBuilder>
        getObjectDataRangesOrBuilderList() {
      if (objectDataRangesBuilder_ != null) {
        return objectDataRangesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(objectDataRanges_);
      }
    }
    /**
     *
     *
     * <pre>
     * A portion of the object's data. The service **may** leave data
     * empty for any given ReadResponse. This enables the service to inform the
     * client that the request is still live while it is running an operation to
     * generate more data.
     * The service **may** pipeline multiple responses belonging to different read
     * requests. Each ObjectRangeData entry will have a read_id
     * set to the same value as the corresponding source read request.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectRangeData object_data_ranges = 6;</code>
     */
    public com.google.storage.v2.ObjectRangeData.Builder addObjectDataRangesBuilder() {
      return getObjectDataRangesFieldBuilder()
          .addBuilder(com.google.storage.v2.ObjectRangeData.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A portion of the object's data. The service **may** leave data
     * empty for any given ReadResponse. This enables the service to inform the
     * client that the request is still live while it is running an operation to
     * generate more data.
     * The service **may** pipeline multiple responses belonging to different read
     * requests. Each ObjectRangeData entry will have a read_id
     * set to the same value as the corresponding source read request.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectRangeData object_data_ranges = 6;</code>
     */
    public com.google.storage.v2.ObjectRangeData.Builder addObjectDataRangesBuilder(int index) {
      return getObjectDataRangesFieldBuilder()
          .addBuilder(index, com.google.storage.v2.ObjectRangeData.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A portion of the object's data. The service **may** leave data
     * empty for any given ReadResponse. This enables the service to inform the
     * client that the request is still live while it is running an operation to
     * generate more data.
     * The service **may** pipeline multiple responses belonging to different read
     * requests. Each ObjectRangeData entry will have a read_id
     * set to the same value as the corresponding source read request.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectRangeData object_data_ranges = 6;</code>
     */
    public java.util.List<com.google.storage.v2.ObjectRangeData.Builder>
        getObjectDataRangesBuilderList() {
      return getObjectDataRangesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.storage.v2.ObjectRangeData,
            com.google.storage.v2.ObjectRangeData.Builder,
            com.google.storage.v2.ObjectRangeDataOrBuilder>
        getObjectDataRangesFieldBuilder() {
      if (objectDataRangesBuilder_ == null) {
        objectDataRangesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.storage.v2.ObjectRangeData,
                com.google.storage.v2.ObjectRangeData.Builder,
                com.google.storage.v2.ObjectRangeDataOrBuilder>(
                objectDataRanges_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        objectDataRanges_ = null;
      }
      return objectDataRangesBuilder_;
    }

    private com.google.storage.v2.Object metadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Object,
            com.google.storage.v2.Object.Builder,
            com.google.storage.v2.ObjectOrBuilder>
        metadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata of the object whose media is being returned.
     * Only populated in the first response in the stream and not populated when
     * the stream is opened with a read handle.
     * </pre>
     *
     * <code>.google.storage.v2.Object metadata = 4;</code>
     *
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Metadata of the object whose media is being returned.
     * Only populated in the first response in the stream and not populated when
     * the stream is opened with a read handle.
     * </pre>
     *
     * <code>.google.storage.v2.Object metadata = 4;</code>
     *
     * @return The metadata.
     */
    public com.google.storage.v2.Object getMetadata() {
      if (metadataBuilder_ == null) {
        return metadata_ == null ? com.google.storage.v2.Object.getDefaultInstance() : metadata_;
      } else {
        return metadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata of the object whose media is being returned.
     * Only populated in the first response in the stream and not populated when
     * the stream is opened with a read handle.
     * </pre>
     *
     * <code>.google.storage.v2.Object metadata = 4;</code>
     */
    public Builder setMetadata(com.google.storage.v2.Object value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
      } else {
        metadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata of the object whose media is being returned.
     * Only populated in the first response in the stream and not populated when
     * the stream is opened with a read handle.
     * </pre>
     *
     * <code>.google.storage.v2.Object metadata = 4;</code>
     */
    public Builder setMetadata(com.google.storage.v2.Object.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        metadata_ = builderForValue.build();
      } else {
        metadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata of the object whose media is being returned.
     * Only populated in the first response in the stream and not populated when
     * the stream is opened with a read handle.
     * </pre>
     *
     * <code>.google.storage.v2.Object metadata = 4;</code>
     */
    public Builder mergeMetadata(com.google.storage.v2.Object value) {
      if (metadataBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && metadata_ != null
            && metadata_ != com.google.storage.v2.Object.getDefaultInstance()) {
          getMetadataBuilder().mergeFrom(value);
        } else {
          metadata_ = value;
        }
      } else {
        metadataBuilder_.mergeFrom(value);
      }
      if (metadata_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata of the object whose media is being returned.
     * Only populated in the first response in the stream and not populated when
     * the stream is opened with a read handle.
     * </pre>
     *
     * <code>.google.storage.v2.Object metadata = 4;</code>
     */
    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x00000002);
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata of the object whose media is being returned.
     * Only populated in the first response in the stream and not populated when
     * the stream is opened with a read handle.
     * </pre>
     *
     * <code>.google.storage.v2.Object metadata = 4;</code>
     */
    public com.google.storage.v2.Object.Builder getMetadataBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata of the object whose media is being returned.
     * Only populated in the first response in the stream and not populated when
     * the stream is opened with a read handle.
     * </pre>
     *
     * <code>.google.storage.v2.Object metadata = 4;</code>
     */
    public com.google.storage.v2.ObjectOrBuilder getMetadataOrBuilder() {
      if (metadataBuilder_ != null) {
        return metadataBuilder_.getMessageOrBuilder();
      } else {
        return metadata_ == null ? com.google.storage.v2.Object.getDefaultInstance() : metadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata of the object whose media is being returned.
     * Only populated in the first response in the stream and not populated when
     * the stream is opened with a read handle.
     * </pre>
     *
     * <code>.google.storage.v2.Object metadata = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Object,
            com.google.storage.v2.Object.Builder,
            com.google.storage.v2.ObjectOrBuilder>
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        metadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Object,
                com.google.storage.v2.Object.Builder,
                com.google.storage.v2.ObjectOrBuilder>(
                getMetadata(), getParentForChildren(), isClean());
        metadata_ = null;
      }
      return metadataBuilder_;
    }

    private com.google.storage.v2.BidiReadHandle readHandle_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.BidiReadHandle,
            com.google.storage.v2.BidiReadHandle.Builder,
            com.google.storage.v2.BidiReadHandleOrBuilder>
        readHandleBuilder_;
    /**
     *
     *
     * <pre>
     * This field will be periodically refreshed, however it may not be set in
     * every response. It allows the client to more efficiently open subsequent
     * bidirectional streams to the same object.
     * </pre>
     *
     * <code>.google.storage.v2.BidiReadHandle read_handle = 7;</code>
     *
     * @return Whether the readHandle field is set.
     */
    public boolean hasReadHandle() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * This field will be periodically refreshed, however it may not be set in
     * every response. It allows the client to more efficiently open subsequent
     * bidirectional streams to the same object.
     * </pre>
     *
     * <code>.google.storage.v2.BidiReadHandle read_handle = 7;</code>
     *
     * @return The readHandle.
     */
    public com.google.storage.v2.BidiReadHandle getReadHandle() {
      if (readHandleBuilder_ == null) {
        return readHandle_ == null
            ? com.google.storage.v2.BidiReadHandle.getDefaultInstance()
            : readHandle_;
      } else {
        return readHandleBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * This field will be periodically refreshed, however it may not be set in
     * every response. It allows the client to more efficiently open subsequent
     * bidirectional streams to the same object.
     * </pre>
     *
     * <code>.google.storage.v2.BidiReadHandle read_handle = 7;</code>
     */
    public Builder setReadHandle(com.google.storage.v2.BidiReadHandle value) {
      if (readHandleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        readHandle_ = value;
      } else {
        readHandleBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field will be periodically refreshed, however it may not be set in
     * every response. It allows the client to more efficiently open subsequent
     * bidirectional streams to the same object.
     * </pre>
     *
     * <code>.google.storage.v2.BidiReadHandle read_handle = 7;</code>
     */
    public Builder setReadHandle(com.google.storage.v2.BidiReadHandle.Builder builderForValue) {
      if (readHandleBuilder_ == null) {
        readHandle_ = builderForValue.build();
      } else {
        readHandleBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field will be periodically refreshed, however it may not be set in
     * every response. It allows the client to more efficiently open subsequent
     * bidirectional streams to the same object.
     * </pre>
     *
     * <code>.google.storage.v2.BidiReadHandle read_handle = 7;</code>
     */
    public Builder mergeReadHandle(com.google.storage.v2.BidiReadHandle value) {
      if (readHandleBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && readHandle_ != null
            && readHandle_ != com.google.storage.v2.BidiReadHandle.getDefaultInstance()) {
          getReadHandleBuilder().mergeFrom(value);
        } else {
          readHandle_ = value;
        }
      } else {
        readHandleBuilder_.mergeFrom(value);
      }
      if (readHandle_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field will be periodically refreshed, however it may not be set in
     * every response. It allows the client to more efficiently open subsequent
     * bidirectional streams to the same object.
     * </pre>
     *
     * <code>.google.storage.v2.BidiReadHandle read_handle = 7;</code>
     */
    public Builder clearReadHandle() {
      bitField0_ = (bitField0_ & ~0x00000004);
      readHandle_ = null;
      if (readHandleBuilder_ != null) {
        readHandleBuilder_.dispose();
        readHandleBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field will be periodically refreshed, however it may not be set in
     * every response. It allows the client to more efficiently open subsequent
     * bidirectional streams to the same object.
     * </pre>
     *
     * <code>.google.storage.v2.BidiReadHandle read_handle = 7;</code>
     */
    public com.google.storage.v2.BidiReadHandle.Builder getReadHandleBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getReadHandleFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * This field will be periodically refreshed, however it may not be set in
     * every response. It allows the client to more efficiently open subsequent
     * bidirectional streams to the same object.
     * </pre>
     *
     * <code>.google.storage.v2.BidiReadHandle read_handle = 7;</code>
     */
    public com.google.storage.v2.BidiReadHandleOrBuilder getReadHandleOrBuilder() {
      if (readHandleBuilder_ != null) {
        return readHandleBuilder_.getMessageOrBuilder();
      } else {
        return readHandle_ == null
            ? com.google.storage.v2.BidiReadHandle.getDefaultInstance()
            : readHandle_;
      }
    }
    /**
     *
     *
     * <pre>
     * This field will be periodically refreshed, however it may not be set in
     * every response. It allows the client to more efficiently open subsequent
     * bidirectional streams to the same object.
     * </pre>
     *
     * <code>.google.storage.v2.BidiReadHandle read_handle = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.BidiReadHandle,
            com.google.storage.v2.BidiReadHandle.Builder,
            com.google.storage.v2.BidiReadHandleOrBuilder>
        getReadHandleFieldBuilder() {
      if (readHandleBuilder_ == null) {
        readHandleBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.BidiReadHandle,
                com.google.storage.v2.BidiReadHandle.Builder,
                com.google.storage.v2.BidiReadHandleOrBuilder>(
                getReadHandle(), getParentForChildren(), isClean());
        readHandle_ = null;
      }
      return readHandleBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.storage.v2.BidiReadObjectResponse)
  }

  // @@protoc_insertion_point(class_scope:google.storage.v2.BidiReadObjectResponse)
  private static final com.google.storage.v2.BidiReadObjectResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.storage.v2.BidiReadObjectResponse();
  }

  public static com.google.storage.v2.BidiReadObjectResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BidiReadObjectResponse> PARSER =
      new com.google.protobuf.AbstractParser<BidiReadObjectResponse>() {
        @java.lang.Override
        public BidiReadObjectResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BidiReadObjectResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BidiReadObjectResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.storage.v2.BidiReadObjectResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
