/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/v2/storage.proto

// Protobuf Java Version: 3.25.8
package com.google.storage.v2;

/**
 *
 *
 * <pre>
 * Request message for BidiWriteObject.
 * </pre>
 *
 * Protobuf type {@code google.storage.v2.BidiWriteObjectRequest}
 */
public final class BidiWriteObjectRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.storage.v2.BidiWriteObjectRequest)
    BidiWriteObjectRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use BidiWriteObjectRequest.newBuilder() to construct.
  private BidiWriteObjectRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BidiWriteObjectRequest() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BidiWriteObjectRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_BidiWriteObjectRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_BidiWriteObjectRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.storage.v2.BidiWriteObjectRequest.class,
            com.google.storage.v2.BidiWriteObjectRequest.Builder.class);
  }

  private int bitField0_;
  private int firstMessageCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object firstMessage_;

  public enum FirstMessageCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    UPLOAD_ID(1),
    WRITE_OBJECT_SPEC(2),
    APPEND_OBJECT_SPEC(11),
    FIRSTMESSAGE_NOT_SET(0);
    private final int value;

    private FirstMessageCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FirstMessageCase valueOf(int value) {
      return forNumber(value);
    }

    public static FirstMessageCase forNumber(int value) {
      switch (value) {
        case 1:
          return UPLOAD_ID;
        case 2:
          return WRITE_OBJECT_SPEC;
        case 11:
          return APPEND_OBJECT_SPEC;
        case 0:
          return FIRSTMESSAGE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public FirstMessageCase getFirstMessageCase() {
    return FirstMessageCase.forNumber(firstMessageCase_);
  }

  private int dataCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object data_;

  public enum DataCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CHECKSUMMED_DATA(4),
    DATA_NOT_SET(0);
    private final int value;

    private DataCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DataCase valueOf(int value) {
      return forNumber(value);
    }

    public static DataCase forNumber(int value) {
      switch (value) {
        case 4:
          return CHECKSUMMED_DATA;
        case 0:
          return DATA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DataCase getDataCase() {
    return DataCase.forNumber(dataCase_);
  }

  public static final int UPLOAD_ID_FIELD_NUMBER = 1;

  /**
   *
   *
   * <pre>
   * For resumable uploads. This should be the `upload_id` returned from a
   * call to `StartResumableWriteResponse`.
   * </pre>
   *
   * <code>string upload_id = 1;</code>
   *
   * @return Whether the uploadId field is set.
   */
  public boolean hasUploadId() {
    return firstMessageCase_ == 1;
  }

  /**
   *
   *
   * <pre>
   * For resumable uploads. This should be the `upload_id` returned from a
   * call to `StartResumableWriteResponse`.
   * </pre>
   *
   * <code>string upload_id = 1;</code>
   *
   * @return The uploadId.
   */
  public java.lang.String getUploadId() {
    java.lang.Object ref = "";
    if (firstMessageCase_ == 1) {
      ref = firstMessage_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (firstMessageCase_ == 1) {
        firstMessage_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * For resumable uploads. This should be the `upload_id` returned from a
   * call to `StartResumableWriteResponse`.
   * </pre>
   *
   * <code>string upload_id = 1;</code>
   *
   * @return The bytes for uploadId.
   */
  public com.google.protobuf.ByteString getUploadIdBytes() {
    java.lang.Object ref = "";
    if (firstMessageCase_ == 1) {
      ref = firstMessage_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (firstMessageCase_ == 1) {
        firstMessage_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int WRITE_OBJECT_SPEC_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * For non-resumable uploads. Describes the overall upload, including the
   * destination bucket and object name, preconditions, etc.
   * </pre>
   *
   * <code>.google.storage.v2.WriteObjectSpec write_object_spec = 2;</code>
   *
   * @return Whether the writeObjectSpec field is set.
   */
  @java.lang.Override
  public boolean hasWriteObjectSpec() {
    return firstMessageCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * For non-resumable uploads. Describes the overall upload, including the
   * destination bucket and object name, preconditions, etc.
   * </pre>
   *
   * <code>.google.storage.v2.WriteObjectSpec write_object_spec = 2;</code>
   *
   * @return The writeObjectSpec.
   */
  @java.lang.Override
  public com.google.storage.v2.WriteObjectSpec getWriteObjectSpec() {
    if (firstMessageCase_ == 2) {
      return (com.google.storage.v2.WriteObjectSpec) firstMessage_;
    }
    return com.google.storage.v2.WriteObjectSpec.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * For non-resumable uploads. Describes the overall upload, including the
   * destination bucket and object name, preconditions, etc.
   * </pre>
   *
   * <code>.google.storage.v2.WriteObjectSpec write_object_spec = 2;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.WriteObjectSpecOrBuilder getWriteObjectSpecOrBuilder() {
    if (firstMessageCase_ == 2) {
      return (com.google.storage.v2.WriteObjectSpec) firstMessage_;
    }
    return com.google.storage.v2.WriteObjectSpec.getDefaultInstance();
  }

  public static final int APPEND_OBJECT_SPEC_FIELD_NUMBER = 11;

  /**
   *
   *
   * <pre>
   * For appendable uploads. Describes the object to append to.
   * </pre>
   *
   * <code>.google.storage.v2.AppendObjectSpec append_object_spec = 11;</code>
   *
   * @return Whether the appendObjectSpec field is set.
   */
  @java.lang.Override
  public boolean hasAppendObjectSpec() {
    return firstMessageCase_ == 11;
  }

  /**
   *
   *
   * <pre>
   * For appendable uploads. Describes the object to append to.
   * </pre>
   *
   * <code>.google.storage.v2.AppendObjectSpec append_object_spec = 11;</code>
   *
   * @return The appendObjectSpec.
   */
  @java.lang.Override
  public com.google.storage.v2.AppendObjectSpec getAppendObjectSpec() {
    if (firstMessageCase_ == 11) {
      return (com.google.storage.v2.AppendObjectSpec) firstMessage_;
    }
    return com.google.storage.v2.AppendObjectSpec.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * For appendable uploads. Describes the object to append to.
   * </pre>
   *
   * <code>.google.storage.v2.AppendObjectSpec append_object_spec = 11;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.AppendObjectSpecOrBuilder getAppendObjectSpecOrBuilder() {
    if (firstMessageCase_ == 11) {
      return (com.google.storage.v2.AppendObjectSpec) firstMessage_;
    }
    return com.google.storage.v2.AppendObjectSpec.getDefaultInstance();
  }

  public static final int WRITE_OFFSET_FIELD_NUMBER = 3;
  private long writeOffset_ = 0L;

  /**
   *
   *
   * <pre>
   * Required. The offset from the beginning of the object at which the data
   * should be written.
   *
   * In the first `WriteObjectRequest` of a `WriteObject()` action, it
   * indicates the initial offset for the `Write()` call. The value **must** be
   * equal to the `persisted_size` that a call to `QueryWriteStatus()` would
   * return (0 if this is the first write to the object).
   *
   * On subsequent calls, this value **must** be no larger than the sum of the
   * first `write_offset` and the sizes of all `data` chunks sent previously on
   * this stream.
   *
   * An invalid value will cause an error.
   * </pre>
   *
   * <code>int64 write_offset = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The writeOffset.
   */
  @java.lang.Override
  public long getWriteOffset() {
    return writeOffset_;
  }

  public static final int CHECKSUMMED_DATA_FIELD_NUMBER = 4;

  /**
   *
   *
   * <pre>
   * The data to insert. If a crc32c checksum is provided that doesn't match
   * the checksum computed by the service, the request will fail.
   * </pre>
   *
   * <code>.google.storage.v2.ChecksummedData checksummed_data = 4;</code>
   *
   * @return Whether the checksummedData field is set.
   */
  @java.lang.Override
  public boolean hasChecksummedData() {
    return dataCase_ == 4;
  }

  /**
   *
   *
   * <pre>
   * The data to insert. If a crc32c checksum is provided that doesn't match
   * the checksum computed by the service, the request will fail.
   * </pre>
   *
   * <code>.google.storage.v2.ChecksummedData checksummed_data = 4;</code>
   *
   * @return The checksummedData.
   */
  @java.lang.Override
  public com.google.storage.v2.ChecksummedData getChecksummedData() {
    if (dataCase_ == 4) {
      return (com.google.storage.v2.ChecksummedData) data_;
    }
    return com.google.storage.v2.ChecksummedData.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The data to insert. If a crc32c checksum is provided that doesn't match
   * the checksum computed by the service, the request will fail.
   * </pre>
   *
   * <code>.google.storage.v2.ChecksummedData checksummed_data = 4;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.ChecksummedDataOrBuilder getChecksummedDataOrBuilder() {
    if (dataCase_ == 4) {
      return (com.google.storage.v2.ChecksummedData) data_;
    }
    return com.google.storage.v2.ChecksummedData.getDefaultInstance();
  }

  public static final int OBJECT_CHECKSUMS_FIELD_NUMBER = 6;
  private com.google.storage.v2.ObjectChecksums objectChecksums_;

  /**
   *
   *
   * <pre>
   * Optional. Checksums for the complete object. If the checksums computed by
   * the service don't match the specified checksums the call will fail. May
   * only be provided in the first request or the last request (with
   * finish_write set).
   * </pre>
   *
   * <code>
   * .google.storage.v2.ObjectChecksums object_checksums = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the objectChecksums field is set.
   */
  @java.lang.Override
  public boolean hasObjectChecksums() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Checksums for the complete object. If the checksums computed by
   * the service don't match the specified checksums the call will fail. May
   * only be provided in the first request or the last request (with
   * finish_write set).
   * </pre>
   *
   * <code>
   * .google.storage.v2.ObjectChecksums object_checksums = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The objectChecksums.
   */
  @java.lang.Override
  public com.google.storage.v2.ObjectChecksums getObjectChecksums() {
    return objectChecksums_ == null
        ? com.google.storage.v2.ObjectChecksums.getDefaultInstance()
        : objectChecksums_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Checksums for the complete object. If the checksums computed by
   * the service don't match the specified checksums the call will fail. May
   * only be provided in the first request or the last request (with
   * finish_write set).
   * </pre>
   *
   * <code>
   * .google.storage.v2.ObjectChecksums object_checksums = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.storage.v2.ObjectChecksumsOrBuilder getObjectChecksumsOrBuilder() {
    return objectChecksums_ == null
        ? com.google.storage.v2.ObjectChecksums.getDefaultInstance()
        : objectChecksums_;
  }

  public static final int STATE_LOOKUP_FIELD_NUMBER = 7;
  private boolean stateLookup_ = false;

  /**
   *
   *
   * <pre>
   * Optional. For each BidiWriteObjectRequest where state_lookup is `true` or
   * the client closes the stream, the service will send a
   * BidiWriteObjectResponse containing the current persisted size. The
   * persisted size sent in responses covers all the bytes the server has
   * persisted thus far and can be used to decide what data is safe for the
   * client to drop. Note that the object's current size reported by the
   * BidiWriteObjectResponse may lag behind the number of bytes written by the
   * client. This field is ignored if `finish_write` is set to true.
   * </pre>
   *
   * <code>bool state_lookup = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The stateLookup.
   */
  @java.lang.Override
  public boolean getStateLookup() {
    return stateLookup_;
  }

  public static final int FLUSH_FIELD_NUMBER = 8;
  private boolean flush_ = false;

  /**
   *
   *
   * <pre>
   * Optional. Persists data written on the stream, up to and including the
   * current message, to permanent storage. This option should be used sparingly
   * as it may reduce performance. Ongoing writes will periodically be persisted
   * on the server even when `flush` is not set. This field is ignored if
   * `finish_write` is set to true since there's no need to checkpoint or flush
   * if this message completes the write.
   * </pre>
   *
   * <code>bool flush = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The flush.
   */
  @java.lang.Override
  public boolean getFlush() {
    return flush_;
  }

  public static final int FINISH_WRITE_FIELD_NUMBER = 9;
  private boolean finishWrite_ = false;

  /**
   *
   *
   * <pre>
   * Optional. If `true`, this indicates that the write is complete. Sending any
   * `WriteObjectRequest`s subsequent to one in which `finish_write` is `true`
   * will cause an error.
   * For a non-resumable write (where the upload_id was not set in the first
   * message), it is an error not to set this field in the final message of the
   * stream.
   * </pre>
   *
   * <code>bool finish_write = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The finishWrite.
   */
  @java.lang.Override
  public boolean getFinishWrite() {
    return finishWrite_;
  }

  public static final int COMMON_OBJECT_REQUEST_PARAMS_FIELD_NUMBER = 10;
  private com.google.storage.v2.CommonObjectRequestParams commonObjectRequestParams_;

  /**
   *
   *
   * <pre>
   * Optional. A set of parameters common to Storage API requests concerning an
   * object.
   * </pre>
   *
   * <code>
   * .google.storage.v2.CommonObjectRequestParams common_object_request_params = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the commonObjectRequestParams field is set.
   */
  @java.lang.Override
  public boolean hasCommonObjectRequestParams() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. A set of parameters common to Storage API requests concerning an
   * object.
   * </pre>
   *
   * <code>
   * .google.storage.v2.CommonObjectRequestParams common_object_request_params = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The commonObjectRequestParams.
   */
  @java.lang.Override
  public com.google.storage.v2.CommonObjectRequestParams getCommonObjectRequestParams() {
    return commonObjectRequestParams_ == null
        ? com.google.storage.v2.CommonObjectRequestParams.getDefaultInstance()
        : commonObjectRequestParams_;
  }

  /**
   *
   *
   * <pre>
   * Optional. A set of parameters common to Storage API requests concerning an
   * object.
   * </pre>
   *
   * <code>
   * .google.storage.v2.CommonObjectRequestParams common_object_request_params = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.storage.v2.CommonObjectRequestParamsOrBuilder
      getCommonObjectRequestParamsOrBuilder() {
    return commonObjectRequestParams_ == null
        ? com.google.storage.v2.CommonObjectRequestParams.getDefaultInstance()
        : commonObjectRequestParams_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (firstMessageCase_ == 1) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, firstMessage_);
    }
    if (firstMessageCase_ == 2) {
      output.writeMessage(2, (com.google.storage.v2.WriteObjectSpec) firstMessage_);
    }
    if (writeOffset_ != 0L) {
      output.writeInt64(3, writeOffset_);
    }
    if (dataCase_ == 4) {
      output.writeMessage(4, (com.google.storage.v2.ChecksummedData) data_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getObjectChecksums());
    }
    if (stateLookup_ != false) {
      output.writeBool(7, stateLookup_);
    }
    if (flush_ != false) {
      output.writeBool(8, flush_);
    }
    if (finishWrite_ != false) {
      output.writeBool(9, finishWrite_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(10, getCommonObjectRequestParams());
    }
    if (firstMessageCase_ == 11) {
      output.writeMessage(11, (com.google.storage.v2.AppendObjectSpec) firstMessage_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (firstMessageCase_ == 1) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, firstMessage_);
    }
    if (firstMessageCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.storage.v2.WriteObjectSpec) firstMessage_);
    }
    if (writeOffset_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, writeOffset_);
    }
    if (dataCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.storage.v2.ChecksummedData) data_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getObjectChecksums());
    }
    if (stateLookup_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, stateLookup_);
    }
    if (flush_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, flush_);
    }
    if (finishWrite_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(9, finishWrite_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, getCommonObjectRequestParams());
    }
    if (firstMessageCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, (com.google.storage.v2.AppendObjectSpec) firstMessage_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.storage.v2.BidiWriteObjectRequest)) {
      return super.equals(obj);
    }
    com.google.storage.v2.BidiWriteObjectRequest other =
        (com.google.storage.v2.BidiWriteObjectRequest) obj;

    if (getWriteOffset() != other.getWriteOffset()) return false;
    if (hasObjectChecksums() != other.hasObjectChecksums()) return false;
    if (hasObjectChecksums()) {
      if (!getObjectChecksums().equals(other.getObjectChecksums())) return false;
    }
    if (getStateLookup() != other.getStateLookup()) return false;
    if (getFlush() != other.getFlush()) return false;
    if (getFinishWrite() != other.getFinishWrite()) return false;
    if (hasCommonObjectRequestParams() != other.hasCommonObjectRequestParams()) return false;
    if (hasCommonObjectRequestParams()) {
      if (!getCommonObjectRequestParams().equals(other.getCommonObjectRequestParams()))
        return false;
    }
    if (!getFirstMessageCase().equals(other.getFirstMessageCase())) return false;
    switch (firstMessageCase_) {
      case 1:
        if (!getUploadId().equals(other.getUploadId())) return false;
        break;
      case 2:
        if (!getWriteObjectSpec().equals(other.getWriteObjectSpec())) return false;
        break;
      case 11:
        if (!getAppendObjectSpec().equals(other.getAppendObjectSpec())) return false;
        break;
      case 0:
      default:
    }
    if (!getDataCase().equals(other.getDataCase())) return false;
    switch (dataCase_) {
      case 4:
        if (!getChecksummedData().equals(other.getChecksummedData())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + WRITE_OFFSET_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getWriteOffset());
    if (hasObjectChecksums()) {
      hash = (37 * hash) + OBJECT_CHECKSUMS_FIELD_NUMBER;
      hash = (53 * hash) + getObjectChecksums().hashCode();
    }
    hash = (37 * hash) + STATE_LOOKUP_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getStateLookup());
    hash = (37 * hash) + FLUSH_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getFlush());
    hash = (37 * hash) + FINISH_WRITE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getFinishWrite());
    if (hasCommonObjectRequestParams()) {
      hash = (37 * hash) + COMMON_OBJECT_REQUEST_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getCommonObjectRequestParams().hashCode();
    }
    switch (firstMessageCase_) {
      case 1:
        hash = (37 * hash) + UPLOAD_ID_FIELD_NUMBER;
        hash = (53 * hash) + getUploadId().hashCode();
        break;
      case 2:
        hash = (37 * hash) + WRITE_OBJECT_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getWriteObjectSpec().hashCode();
        break;
      case 11:
        hash = (37 * hash) + APPEND_OBJECT_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getAppendObjectSpec().hashCode();
        break;
      case 0:
      default:
    }
    switch (dataCase_) {
      case 4:
        hash = (37 * hash) + CHECKSUMMED_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getChecksummedData().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.storage.v2.BidiWriteObjectRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.BidiWriteObjectRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.BidiWriteObjectRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.BidiWriteObjectRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.BidiWriteObjectRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.BidiWriteObjectRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.BidiWriteObjectRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.BidiWriteObjectRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.BidiWriteObjectRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.BidiWriteObjectRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.BidiWriteObjectRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.BidiWriteObjectRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.storage.v2.BidiWriteObjectRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for BidiWriteObject.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.BidiWriteObjectRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.storage.v2.BidiWriteObjectRequest)
      com.google.storage.v2.BidiWriteObjectRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_BidiWriteObjectRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_BidiWriteObjectRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.BidiWriteObjectRequest.class,
              com.google.storage.v2.BidiWriteObjectRequest.Builder.class);
    }

    // Construct using com.google.storage.v2.BidiWriteObjectRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getObjectChecksumsFieldBuilder();
        getCommonObjectRequestParamsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (writeObjectSpecBuilder_ != null) {
        writeObjectSpecBuilder_.clear();
      }
      if (appendObjectSpecBuilder_ != null) {
        appendObjectSpecBuilder_.clear();
      }
      writeOffset_ = 0L;
      if (checksummedDataBuilder_ != null) {
        checksummedDataBuilder_.clear();
      }
      objectChecksums_ = null;
      if (objectChecksumsBuilder_ != null) {
        objectChecksumsBuilder_.dispose();
        objectChecksumsBuilder_ = null;
      }
      stateLookup_ = false;
      flush_ = false;
      finishWrite_ = false;
      commonObjectRequestParams_ = null;
      if (commonObjectRequestParamsBuilder_ != null) {
        commonObjectRequestParamsBuilder_.dispose();
        commonObjectRequestParamsBuilder_ = null;
      }
      firstMessageCase_ = 0;
      firstMessage_ = null;
      dataCase_ = 0;
      data_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_BidiWriteObjectRequest_descriptor;
    }

    @java.lang.Override
    public com.google.storage.v2.BidiWriteObjectRequest getDefaultInstanceForType() {
      return com.google.storage.v2.BidiWriteObjectRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.storage.v2.BidiWriteObjectRequest build() {
      com.google.storage.v2.BidiWriteObjectRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.storage.v2.BidiWriteObjectRequest buildPartial() {
      com.google.storage.v2.BidiWriteObjectRequest result =
          new com.google.storage.v2.BidiWriteObjectRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.storage.v2.BidiWriteObjectRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.writeOffset_ = writeOffset_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.objectChecksums_ =
            objectChecksumsBuilder_ == null ? objectChecksums_ : objectChecksumsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.stateLookup_ = stateLookup_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.flush_ = flush_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.finishWrite_ = finishWrite_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.commonObjectRequestParams_ =
            commonObjectRequestParamsBuilder_ == null
                ? commonObjectRequestParams_
                : commonObjectRequestParamsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.storage.v2.BidiWriteObjectRequest result) {
      result.firstMessageCase_ = firstMessageCase_;
      result.firstMessage_ = this.firstMessage_;
      if (firstMessageCase_ == 2 && writeObjectSpecBuilder_ != null) {
        result.firstMessage_ = writeObjectSpecBuilder_.build();
      }
      if (firstMessageCase_ == 11 && appendObjectSpecBuilder_ != null) {
        result.firstMessage_ = appendObjectSpecBuilder_.build();
      }
      result.dataCase_ = dataCase_;
      result.data_ = this.data_;
      if (dataCase_ == 4 && checksummedDataBuilder_ != null) {
        result.data_ = checksummedDataBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.storage.v2.BidiWriteObjectRequest) {
        return mergeFrom((com.google.storage.v2.BidiWriteObjectRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.storage.v2.BidiWriteObjectRequest other) {
      if (other == com.google.storage.v2.BidiWriteObjectRequest.getDefaultInstance()) return this;
      if (other.getWriteOffset() != 0L) {
        setWriteOffset(other.getWriteOffset());
      }
      if (other.hasObjectChecksums()) {
        mergeObjectChecksums(other.getObjectChecksums());
      }
      if (other.getStateLookup() != false) {
        setStateLookup(other.getStateLookup());
      }
      if (other.getFlush() != false) {
        setFlush(other.getFlush());
      }
      if (other.getFinishWrite() != false) {
        setFinishWrite(other.getFinishWrite());
      }
      if (other.hasCommonObjectRequestParams()) {
        mergeCommonObjectRequestParams(other.getCommonObjectRequestParams());
      }
      switch (other.getFirstMessageCase()) {
        case UPLOAD_ID:
          {
            firstMessageCase_ = 1;
            firstMessage_ = other.firstMessage_;
            onChanged();
            break;
          }
        case WRITE_OBJECT_SPEC:
          {
            mergeWriteObjectSpec(other.getWriteObjectSpec());
            break;
          }
        case APPEND_OBJECT_SPEC:
          {
            mergeAppendObjectSpec(other.getAppendObjectSpec());
            break;
          }
        case FIRSTMESSAGE_NOT_SET:
          {
            break;
          }
      }
      switch (other.getDataCase()) {
        case CHECKSUMMED_DATA:
          {
            mergeChecksummedData(other.getChecksummedData());
            break;
          }
        case DATA_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                firstMessageCase_ = 1;
                firstMessage_ = s;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getWriteObjectSpecFieldBuilder().getBuilder(), extensionRegistry);
                firstMessageCase_ = 2;
                break;
              } // case 18
            case 24:
              {
                writeOffset_ = input.readInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(getChecksummedDataFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 4;
                break;
              } // case 34
            case 50:
              {
                input.readMessage(getObjectChecksumsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 56:
              {
                stateLookup_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 64:
              {
                flush_ = input.readBool();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 72:
              {
                finishWrite_ = input.readBool();
                bitField0_ |= 0x00000100;
                break;
              } // case 72
            case 82:
              {
                input.readMessage(
                    getCommonObjectRequestParamsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(
                    getAppendObjectSpecFieldBuilder().getBuilder(), extensionRegistry);
                firstMessageCase_ = 11;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int firstMessageCase_ = 0;
    private java.lang.Object firstMessage_;

    public FirstMessageCase getFirstMessageCase() {
      return FirstMessageCase.forNumber(firstMessageCase_);
    }

    public Builder clearFirstMessage() {
      firstMessageCase_ = 0;
      firstMessage_ = null;
      onChanged();
      return this;
    }

    private int dataCase_ = 0;
    private java.lang.Object data_;

    public DataCase getDataCase() {
      return DataCase.forNumber(dataCase_);
    }

    public Builder clearData() {
      dataCase_ = 0;
      data_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * For resumable uploads. This should be the `upload_id` returned from a
     * call to `StartResumableWriteResponse`.
     * </pre>
     *
     * <code>string upload_id = 1;</code>
     *
     * @return Whether the uploadId field is set.
     */
    @java.lang.Override
    public boolean hasUploadId() {
      return firstMessageCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * For resumable uploads. This should be the `upload_id` returned from a
     * call to `StartResumableWriteResponse`.
     * </pre>
     *
     * <code>string upload_id = 1;</code>
     *
     * @return The uploadId.
     */
    @java.lang.Override
    public java.lang.String getUploadId() {
      java.lang.Object ref = "";
      if (firstMessageCase_ == 1) {
        ref = firstMessage_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (firstMessageCase_ == 1) {
          firstMessage_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * For resumable uploads. This should be the `upload_id` returned from a
     * call to `StartResumableWriteResponse`.
     * </pre>
     *
     * <code>string upload_id = 1;</code>
     *
     * @return The bytes for uploadId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUploadIdBytes() {
      java.lang.Object ref = "";
      if (firstMessageCase_ == 1) {
        ref = firstMessage_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (firstMessageCase_ == 1) {
          firstMessage_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * For resumable uploads. This should be the `upload_id` returned from a
     * call to `StartResumableWriteResponse`.
     * </pre>
     *
     * <code>string upload_id = 1;</code>
     *
     * @param value The uploadId to set.
     * @return This builder for chaining.
     */
    public Builder setUploadId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      firstMessageCase_ = 1;
      firstMessage_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * For resumable uploads. This should be the `upload_id` returned from a
     * call to `StartResumableWriteResponse`.
     * </pre>
     *
     * <code>string upload_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUploadId() {
      if (firstMessageCase_ == 1) {
        firstMessageCase_ = 0;
        firstMessage_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * For resumable uploads. This should be the `upload_id` returned from a
     * call to `StartResumableWriteResponse`.
     * </pre>
     *
     * <code>string upload_id = 1;</code>
     *
     * @param value The bytes for uploadId to set.
     * @return This builder for chaining.
     */
    public Builder setUploadIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      firstMessageCase_ = 1;
      firstMessage_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.WriteObjectSpec,
            com.google.storage.v2.WriteObjectSpec.Builder,
            com.google.storage.v2.WriteObjectSpecOrBuilder>
        writeObjectSpecBuilder_;

    /**
     *
     *
     * <pre>
     * For non-resumable uploads. Describes the overall upload, including the
     * destination bucket and object name, preconditions, etc.
     * </pre>
     *
     * <code>.google.storage.v2.WriteObjectSpec write_object_spec = 2;</code>
     *
     * @return Whether the writeObjectSpec field is set.
     */
    @java.lang.Override
    public boolean hasWriteObjectSpec() {
      return firstMessageCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * For non-resumable uploads. Describes the overall upload, including the
     * destination bucket and object name, preconditions, etc.
     * </pre>
     *
     * <code>.google.storage.v2.WriteObjectSpec write_object_spec = 2;</code>
     *
     * @return The writeObjectSpec.
     */
    @java.lang.Override
    public com.google.storage.v2.WriteObjectSpec getWriteObjectSpec() {
      if (writeObjectSpecBuilder_ == null) {
        if (firstMessageCase_ == 2) {
          return (com.google.storage.v2.WriteObjectSpec) firstMessage_;
        }
        return com.google.storage.v2.WriteObjectSpec.getDefaultInstance();
      } else {
        if (firstMessageCase_ == 2) {
          return writeObjectSpecBuilder_.getMessage();
        }
        return com.google.storage.v2.WriteObjectSpec.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * For non-resumable uploads. Describes the overall upload, including the
     * destination bucket and object name, preconditions, etc.
     * </pre>
     *
     * <code>.google.storage.v2.WriteObjectSpec write_object_spec = 2;</code>
     */
    public Builder setWriteObjectSpec(com.google.storage.v2.WriteObjectSpec value) {
      if (writeObjectSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        firstMessage_ = value;
        onChanged();
      } else {
        writeObjectSpecBuilder_.setMessage(value);
      }
      firstMessageCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * For non-resumable uploads. Describes the overall upload, including the
     * destination bucket and object name, preconditions, etc.
     * </pre>
     *
     * <code>.google.storage.v2.WriteObjectSpec write_object_spec = 2;</code>
     */
    public Builder setWriteObjectSpec(
        com.google.storage.v2.WriteObjectSpec.Builder builderForValue) {
      if (writeObjectSpecBuilder_ == null) {
        firstMessage_ = builderForValue.build();
        onChanged();
      } else {
        writeObjectSpecBuilder_.setMessage(builderForValue.build());
      }
      firstMessageCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * For non-resumable uploads. Describes the overall upload, including the
     * destination bucket and object name, preconditions, etc.
     * </pre>
     *
     * <code>.google.storage.v2.WriteObjectSpec write_object_spec = 2;</code>
     */
    public Builder mergeWriteObjectSpec(com.google.storage.v2.WriteObjectSpec value) {
      if (writeObjectSpecBuilder_ == null) {
        if (firstMessageCase_ == 2
            && firstMessage_ != com.google.storage.v2.WriteObjectSpec.getDefaultInstance()) {
          firstMessage_ =
              com.google.storage.v2.WriteObjectSpec.newBuilder(
                      (com.google.storage.v2.WriteObjectSpec) firstMessage_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          firstMessage_ = value;
        }
        onChanged();
      } else {
        if (firstMessageCase_ == 2) {
          writeObjectSpecBuilder_.mergeFrom(value);
        } else {
          writeObjectSpecBuilder_.setMessage(value);
        }
      }
      firstMessageCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * For non-resumable uploads. Describes the overall upload, including the
     * destination bucket and object name, preconditions, etc.
     * </pre>
     *
     * <code>.google.storage.v2.WriteObjectSpec write_object_spec = 2;</code>
     */
    public Builder clearWriteObjectSpec() {
      if (writeObjectSpecBuilder_ == null) {
        if (firstMessageCase_ == 2) {
          firstMessageCase_ = 0;
          firstMessage_ = null;
          onChanged();
        }
      } else {
        if (firstMessageCase_ == 2) {
          firstMessageCase_ = 0;
          firstMessage_ = null;
        }
        writeObjectSpecBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * For non-resumable uploads. Describes the overall upload, including the
     * destination bucket and object name, preconditions, etc.
     * </pre>
     *
     * <code>.google.storage.v2.WriteObjectSpec write_object_spec = 2;</code>
     */
    public com.google.storage.v2.WriteObjectSpec.Builder getWriteObjectSpecBuilder() {
      return getWriteObjectSpecFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * For non-resumable uploads. Describes the overall upload, including the
     * destination bucket and object name, preconditions, etc.
     * </pre>
     *
     * <code>.google.storage.v2.WriteObjectSpec write_object_spec = 2;</code>
     */
    @java.lang.Override
    public com.google.storage.v2.WriteObjectSpecOrBuilder getWriteObjectSpecOrBuilder() {
      if ((firstMessageCase_ == 2) && (writeObjectSpecBuilder_ != null)) {
        return writeObjectSpecBuilder_.getMessageOrBuilder();
      } else {
        if (firstMessageCase_ == 2) {
          return (com.google.storage.v2.WriteObjectSpec) firstMessage_;
        }
        return com.google.storage.v2.WriteObjectSpec.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * For non-resumable uploads. Describes the overall upload, including the
     * destination bucket and object name, preconditions, etc.
     * </pre>
     *
     * <code>.google.storage.v2.WriteObjectSpec write_object_spec = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.WriteObjectSpec,
            com.google.storage.v2.WriteObjectSpec.Builder,
            com.google.storage.v2.WriteObjectSpecOrBuilder>
        getWriteObjectSpecFieldBuilder() {
      if (writeObjectSpecBuilder_ == null) {
        if (!(firstMessageCase_ == 2)) {
          firstMessage_ = com.google.storage.v2.WriteObjectSpec.getDefaultInstance();
        }
        writeObjectSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.WriteObjectSpec,
                com.google.storage.v2.WriteObjectSpec.Builder,
                com.google.storage.v2.WriteObjectSpecOrBuilder>(
                (com.google.storage.v2.WriteObjectSpec) firstMessage_,
                getParentForChildren(),
                isClean());
        firstMessage_ = null;
      }
      firstMessageCase_ = 2;
      onChanged();
      return writeObjectSpecBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.AppendObjectSpec,
            com.google.storage.v2.AppendObjectSpec.Builder,
            com.google.storage.v2.AppendObjectSpecOrBuilder>
        appendObjectSpecBuilder_;

    /**
     *
     *
     * <pre>
     * For appendable uploads. Describes the object to append to.
     * </pre>
     *
     * <code>.google.storage.v2.AppendObjectSpec append_object_spec = 11;</code>
     *
     * @return Whether the appendObjectSpec field is set.
     */
    @java.lang.Override
    public boolean hasAppendObjectSpec() {
      return firstMessageCase_ == 11;
    }

    /**
     *
     *
     * <pre>
     * For appendable uploads. Describes the object to append to.
     * </pre>
     *
     * <code>.google.storage.v2.AppendObjectSpec append_object_spec = 11;</code>
     *
     * @return The appendObjectSpec.
     */
    @java.lang.Override
    public com.google.storage.v2.AppendObjectSpec getAppendObjectSpec() {
      if (appendObjectSpecBuilder_ == null) {
        if (firstMessageCase_ == 11) {
          return (com.google.storage.v2.AppendObjectSpec) firstMessage_;
        }
        return com.google.storage.v2.AppendObjectSpec.getDefaultInstance();
      } else {
        if (firstMessageCase_ == 11) {
          return appendObjectSpecBuilder_.getMessage();
        }
        return com.google.storage.v2.AppendObjectSpec.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * For appendable uploads. Describes the object to append to.
     * </pre>
     *
     * <code>.google.storage.v2.AppendObjectSpec append_object_spec = 11;</code>
     */
    public Builder setAppendObjectSpec(com.google.storage.v2.AppendObjectSpec value) {
      if (appendObjectSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        firstMessage_ = value;
        onChanged();
      } else {
        appendObjectSpecBuilder_.setMessage(value);
      }
      firstMessageCase_ = 11;
      return this;
    }

    /**
     *
     *
     * <pre>
     * For appendable uploads. Describes the object to append to.
     * </pre>
     *
     * <code>.google.storage.v2.AppendObjectSpec append_object_spec = 11;</code>
     */
    public Builder setAppendObjectSpec(
        com.google.storage.v2.AppendObjectSpec.Builder builderForValue) {
      if (appendObjectSpecBuilder_ == null) {
        firstMessage_ = builderForValue.build();
        onChanged();
      } else {
        appendObjectSpecBuilder_.setMessage(builderForValue.build());
      }
      firstMessageCase_ = 11;
      return this;
    }

    /**
     *
     *
     * <pre>
     * For appendable uploads. Describes the object to append to.
     * </pre>
     *
     * <code>.google.storage.v2.AppendObjectSpec append_object_spec = 11;</code>
     */
    public Builder mergeAppendObjectSpec(com.google.storage.v2.AppendObjectSpec value) {
      if (appendObjectSpecBuilder_ == null) {
        if (firstMessageCase_ == 11
            && firstMessage_ != com.google.storage.v2.AppendObjectSpec.getDefaultInstance()) {
          firstMessage_ =
              com.google.storage.v2.AppendObjectSpec.newBuilder(
                      (com.google.storage.v2.AppendObjectSpec) firstMessage_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          firstMessage_ = value;
        }
        onChanged();
      } else {
        if (firstMessageCase_ == 11) {
          appendObjectSpecBuilder_.mergeFrom(value);
        } else {
          appendObjectSpecBuilder_.setMessage(value);
        }
      }
      firstMessageCase_ = 11;
      return this;
    }

    /**
     *
     *
     * <pre>
     * For appendable uploads. Describes the object to append to.
     * </pre>
     *
     * <code>.google.storage.v2.AppendObjectSpec append_object_spec = 11;</code>
     */
    public Builder clearAppendObjectSpec() {
      if (appendObjectSpecBuilder_ == null) {
        if (firstMessageCase_ == 11) {
          firstMessageCase_ = 0;
          firstMessage_ = null;
          onChanged();
        }
      } else {
        if (firstMessageCase_ == 11) {
          firstMessageCase_ = 0;
          firstMessage_ = null;
        }
        appendObjectSpecBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * For appendable uploads. Describes the object to append to.
     * </pre>
     *
     * <code>.google.storage.v2.AppendObjectSpec append_object_spec = 11;</code>
     */
    public com.google.storage.v2.AppendObjectSpec.Builder getAppendObjectSpecBuilder() {
      return getAppendObjectSpecFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * For appendable uploads. Describes the object to append to.
     * </pre>
     *
     * <code>.google.storage.v2.AppendObjectSpec append_object_spec = 11;</code>
     */
    @java.lang.Override
    public com.google.storage.v2.AppendObjectSpecOrBuilder getAppendObjectSpecOrBuilder() {
      if ((firstMessageCase_ == 11) && (appendObjectSpecBuilder_ != null)) {
        return appendObjectSpecBuilder_.getMessageOrBuilder();
      } else {
        if (firstMessageCase_ == 11) {
          return (com.google.storage.v2.AppendObjectSpec) firstMessage_;
        }
        return com.google.storage.v2.AppendObjectSpec.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * For appendable uploads. Describes the object to append to.
     * </pre>
     *
     * <code>.google.storage.v2.AppendObjectSpec append_object_spec = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.AppendObjectSpec,
            com.google.storage.v2.AppendObjectSpec.Builder,
            com.google.storage.v2.AppendObjectSpecOrBuilder>
        getAppendObjectSpecFieldBuilder() {
      if (appendObjectSpecBuilder_ == null) {
        if (!(firstMessageCase_ == 11)) {
          firstMessage_ = com.google.storage.v2.AppendObjectSpec.getDefaultInstance();
        }
        appendObjectSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.AppendObjectSpec,
                com.google.storage.v2.AppendObjectSpec.Builder,
                com.google.storage.v2.AppendObjectSpecOrBuilder>(
                (com.google.storage.v2.AppendObjectSpec) firstMessage_,
                getParentForChildren(),
                isClean());
        firstMessage_ = null;
      }
      firstMessageCase_ = 11;
      onChanged();
      return appendObjectSpecBuilder_;
    }

    private long writeOffset_;

    /**
     *
     *
     * <pre>
     * Required. The offset from the beginning of the object at which the data
     * should be written.
     *
     * In the first `WriteObjectRequest` of a `WriteObject()` action, it
     * indicates the initial offset for the `Write()` call. The value **must** be
     * equal to the `persisted_size` that a call to `QueryWriteStatus()` would
     * return (0 if this is the first write to the object).
     *
     * On subsequent calls, this value **must** be no larger than the sum of the
     * first `write_offset` and the sizes of all `data` chunks sent previously on
     * this stream.
     *
     * An invalid value will cause an error.
     * </pre>
     *
     * <code>int64 write_offset = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The writeOffset.
     */
    @java.lang.Override
    public long getWriteOffset() {
      return writeOffset_;
    }

    /**
     *
     *
     * <pre>
     * Required. The offset from the beginning of the object at which the data
     * should be written.
     *
     * In the first `WriteObjectRequest` of a `WriteObject()` action, it
     * indicates the initial offset for the `Write()` call. The value **must** be
     * equal to the `persisted_size` that a call to `QueryWriteStatus()` would
     * return (0 if this is the first write to the object).
     *
     * On subsequent calls, this value **must** be no larger than the sum of the
     * first `write_offset` and the sizes of all `data` chunks sent previously on
     * this stream.
     *
     * An invalid value will cause an error.
     * </pre>
     *
     * <code>int64 write_offset = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The writeOffset to set.
     * @return This builder for chaining.
     */
    public Builder setWriteOffset(long value) {

      writeOffset_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The offset from the beginning of the object at which the data
     * should be written.
     *
     * In the first `WriteObjectRequest` of a `WriteObject()` action, it
     * indicates the initial offset for the `Write()` call. The value **must** be
     * equal to the `persisted_size` that a call to `QueryWriteStatus()` would
     * return (0 if this is the first write to the object).
     *
     * On subsequent calls, this value **must** be no larger than the sum of the
     * first `write_offset` and the sizes of all `data` chunks sent previously on
     * this stream.
     *
     * An invalid value will cause an error.
     * </pre>
     *
     * <code>int64 write_offset = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWriteOffset() {
      bitField0_ = (bitField0_ & ~0x00000008);
      writeOffset_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.ChecksummedData,
            com.google.storage.v2.ChecksummedData.Builder,
            com.google.storage.v2.ChecksummedDataOrBuilder>
        checksummedDataBuilder_;

    /**
     *
     *
     * <pre>
     * The data to insert. If a crc32c checksum is provided that doesn't match
     * the checksum computed by the service, the request will fail.
     * </pre>
     *
     * <code>.google.storage.v2.ChecksummedData checksummed_data = 4;</code>
     *
     * @return Whether the checksummedData field is set.
     */
    @java.lang.Override
    public boolean hasChecksummedData() {
      return dataCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * The data to insert. If a crc32c checksum is provided that doesn't match
     * the checksum computed by the service, the request will fail.
     * </pre>
     *
     * <code>.google.storage.v2.ChecksummedData checksummed_data = 4;</code>
     *
     * @return The checksummedData.
     */
    @java.lang.Override
    public com.google.storage.v2.ChecksummedData getChecksummedData() {
      if (checksummedDataBuilder_ == null) {
        if (dataCase_ == 4) {
          return (com.google.storage.v2.ChecksummedData) data_;
        }
        return com.google.storage.v2.ChecksummedData.getDefaultInstance();
      } else {
        if (dataCase_ == 4) {
          return checksummedDataBuilder_.getMessage();
        }
        return com.google.storage.v2.ChecksummedData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The data to insert. If a crc32c checksum is provided that doesn't match
     * the checksum computed by the service, the request will fail.
     * </pre>
     *
     * <code>.google.storage.v2.ChecksummedData checksummed_data = 4;</code>
     */
    public Builder setChecksummedData(com.google.storage.v2.ChecksummedData value) {
      if (checksummedDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        checksummedDataBuilder_.setMessage(value);
      }
      dataCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The data to insert. If a crc32c checksum is provided that doesn't match
     * the checksum computed by the service, the request will fail.
     * </pre>
     *
     * <code>.google.storage.v2.ChecksummedData checksummed_data = 4;</code>
     */
    public Builder setChecksummedData(
        com.google.storage.v2.ChecksummedData.Builder builderForValue) {
      if (checksummedDataBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        checksummedDataBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The data to insert. If a crc32c checksum is provided that doesn't match
     * the checksum computed by the service, the request will fail.
     * </pre>
     *
     * <code>.google.storage.v2.ChecksummedData checksummed_data = 4;</code>
     */
    public Builder mergeChecksummedData(com.google.storage.v2.ChecksummedData value) {
      if (checksummedDataBuilder_ == null) {
        if (dataCase_ == 4 && data_ != com.google.storage.v2.ChecksummedData.getDefaultInstance()) {
          data_ =
              com.google.storage.v2.ChecksummedData.newBuilder(
                      (com.google.storage.v2.ChecksummedData) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 4) {
          checksummedDataBuilder_.mergeFrom(value);
        } else {
          checksummedDataBuilder_.setMessage(value);
        }
      }
      dataCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The data to insert. If a crc32c checksum is provided that doesn't match
     * the checksum computed by the service, the request will fail.
     * </pre>
     *
     * <code>.google.storage.v2.ChecksummedData checksummed_data = 4;</code>
     */
    public Builder clearChecksummedData() {
      if (checksummedDataBuilder_ == null) {
        if (dataCase_ == 4) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 4) {
          dataCase_ = 0;
          data_ = null;
        }
        checksummedDataBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The data to insert. If a crc32c checksum is provided that doesn't match
     * the checksum computed by the service, the request will fail.
     * </pre>
     *
     * <code>.google.storage.v2.ChecksummedData checksummed_data = 4;</code>
     */
    public com.google.storage.v2.ChecksummedData.Builder getChecksummedDataBuilder() {
      return getChecksummedDataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The data to insert. If a crc32c checksum is provided that doesn't match
     * the checksum computed by the service, the request will fail.
     * </pre>
     *
     * <code>.google.storage.v2.ChecksummedData checksummed_data = 4;</code>
     */
    @java.lang.Override
    public com.google.storage.v2.ChecksummedDataOrBuilder getChecksummedDataOrBuilder() {
      if ((dataCase_ == 4) && (checksummedDataBuilder_ != null)) {
        return checksummedDataBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 4) {
          return (com.google.storage.v2.ChecksummedData) data_;
        }
        return com.google.storage.v2.ChecksummedData.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The data to insert. If a crc32c checksum is provided that doesn't match
     * the checksum computed by the service, the request will fail.
     * </pre>
     *
     * <code>.google.storage.v2.ChecksummedData checksummed_data = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.ChecksummedData,
            com.google.storage.v2.ChecksummedData.Builder,
            com.google.storage.v2.ChecksummedDataOrBuilder>
        getChecksummedDataFieldBuilder() {
      if (checksummedDataBuilder_ == null) {
        if (!(dataCase_ == 4)) {
          data_ = com.google.storage.v2.ChecksummedData.getDefaultInstance();
        }
        checksummedDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.ChecksummedData,
                com.google.storage.v2.ChecksummedData.Builder,
                com.google.storage.v2.ChecksummedDataOrBuilder>(
                (com.google.storage.v2.ChecksummedData) data_, getParentForChildren(), isClean());
        data_ = null;
      }
      dataCase_ = 4;
      onChanged();
      return checksummedDataBuilder_;
    }

    private com.google.storage.v2.ObjectChecksums objectChecksums_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.ObjectChecksums,
            com.google.storage.v2.ObjectChecksums.Builder,
            com.google.storage.v2.ObjectChecksumsOrBuilder>
        objectChecksumsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Checksums for the complete object. If the checksums computed by
     * the service don't match the specified checksums the call will fail. May
     * only be provided in the first request or the last request (with
     * finish_write set).
     * </pre>
     *
     * <code>
     * .google.storage.v2.ObjectChecksums object_checksums = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the objectChecksums field is set.
     */
    public boolean hasObjectChecksums() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Checksums for the complete object. If the checksums computed by
     * the service don't match the specified checksums the call will fail. May
     * only be provided in the first request or the last request (with
     * finish_write set).
     * </pre>
     *
     * <code>
     * .google.storage.v2.ObjectChecksums object_checksums = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The objectChecksums.
     */
    public com.google.storage.v2.ObjectChecksums getObjectChecksums() {
      if (objectChecksumsBuilder_ == null) {
        return objectChecksums_ == null
            ? com.google.storage.v2.ObjectChecksums.getDefaultInstance()
            : objectChecksums_;
      } else {
        return objectChecksumsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Checksums for the complete object. If the checksums computed by
     * the service don't match the specified checksums the call will fail. May
     * only be provided in the first request or the last request (with
     * finish_write set).
     * </pre>
     *
     * <code>
     * .google.storage.v2.ObjectChecksums object_checksums = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setObjectChecksums(com.google.storage.v2.ObjectChecksums value) {
      if (objectChecksumsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        objectChecksums_ = value;
      } else {
        objectChecksumsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Checksums for the complete object. If the checksums computed by
     * the service don't match the specified checksums the call will fail. May
     * only be provided in the first request or the last request (with
     * finish_write set).
     * </pre>
     *
     * <code>
     * .google.storage.v2.ObjectChecksums object_checksums = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setObjectChecksums(
        com.google.storage.v2.ObjectChecksums.Builder builderForValue) {
      if (objectChecksumsBuilder_ == null) {
        objectChecksums_ = builderForValue.build();
      } else {
        objectChecksumsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Checksums for the complete object. If the checksums computed by
     * the service don't match the specified checksums the call will fail. May
     * only be provided in the first request or the last request (with
     * finish_write set).
     * </pre>
     *
     * <code>
     * .google.storage.v2.ObjectChecksums object_checksums = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeObjectChecksums(com.google.storage.v2.ObjectChecksums value) {
      if (objectChecksumsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && objectChecksums_ != null
            && objectChecksums_ != com.google.storage.v2.ObjectChecksums.getDefaultInstance()) {
          getObjectChecksumsBuilder().mergeFrom(value);
        } else {
          objectChecksums_ = value;
        }
      } else {
        objectChecksumsBuilder_.mergeFrom(value);
      }
      if (objectChecksums_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Checksums for the complete object. If the checksums computed by
     * the service don't match the specified checksums the call will fail. May
     * only be provided in the first request or the last request (with
     * finish_write set).
     * </pre>
     *
     * <code>
     * .google.storage.v2.ObjectChecksums object_checksums = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearObjectChecksums() {
      bitField0_ = (bitField0_ & ~0x00000020);
      objectChecksums_ = null;
      if (objectChecksumsBuilder_ != null) {
        objectChecksumsBuilder_.dispose();
        objectChecksumsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Checksums for the complete object. If the checksums computed by
     * the service don't match the specified checksums the call will fail. May
     * only be provided in the first request or the last request (with
     * finish_write set).
     * </pre>
     *
     * <code>
     * .google.storage.v2.ObjectChecksums object_checksums = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.storage.v2.ObjectChecksums.Builder getObjectChecksumsBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getObjectChecksumsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Checksums for the complete object. If the checksums computed by
     * the service don't match the specified checksums the call will fail. May
     * only be provided in the first request or the last request (with
     * finish_write set).
     * </pre>
     *
     * <code>
     * .google.storage.v2.ObjectChecksums object_checksums = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.storage.v2.ObjectChecksumsOrBuilder getObjectChecksumsOrBuilder() {
      if (objectChecksumsBuilder_ != null) {
        return objectChecksumsBuilder_.getMessageOrBuilder();
      } else {
        return objectChecksums_ == null
            ? com.google.storage.v2.ObjectChecksums.getDefaultInstance()
            : objectChecksums_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Checksums for the complete object. If the checksums computed by
     * the service don't match the specified checksums the call will fail. May
     * only be provided in the first request or the last request (with
     * finish_write set).
     * </pre>
     *
     * <code>
     * .google.storage.v2.ObjectChecksums object_checksums = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.ObjectChecksums,
            com.google.storage.v2.ObjectChecksums.Builder,
            com.google.storage.v2.ObjectChecksumsOrBuilder>
        getObjectChecksumsFieldBuilder() {
      if (objectChecksumsBuilder_ == null) {
        objectChecksumsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.ObjectChecksums,
                com.google.storage.v2.ObjectChecksums.Builder,
                com.google.storage.v2.ObjectChecksumsOrBuilder>(
                getObjectChecksums(), getParentForChildren(), isClean());
        objectChecksums_ = null;
      }
      return objectChecksumsBuilder_;
    }

    private boolean stateLookup_;

    /**
     *
     *
     * <pre>
     * Optional. For each BidiWriteObjectRequest where state_lookup is `true` or
     * the client closes the stream, the service will send a
     * BidiWriteObjectResponse containing the current persisted size. The
     * persisted size sent in responses covers all the bytes the server has
     * persisted thus far and can be used to decide what data is safe for the
     * client to drop. Note that the object's current size reported by the
     * BidiWriteObjectResponse may lag behind the number of bytes written by the
     * client. This field is ignored if `finish_write` is set to true.
     * </pre>
     *
     * <code>bool state_lookup = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The stateLookup.
     */
    @java.lang.Override
    public boolean getStateLookup() {
      return stateLookup_;
    }

    /**
     *
     *
     * <pre>
     * Optional. For each BidiWriteObjectRequest where state_lookup is `true` or
     * the client closes the stream, the service will send a
     * BidiWriteObjectResponse containing the current persisted size. The
     * persisted size sent in responses covers all the bytes the server has
     * persisted thus far and can be used to decide what data is safe for the
     * client to drop. Note that the object's current size reported by the
     * BidiWriteObjectResponse may lag behind the number of bytes written by the
     * client. This field is ignored if `finish_write` is set to true.
     * </pre>
     *
     * <code>bool state_lookup = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The stateLookup to set.
     * @return This builder for chaining.
     */
    public Builder setStateLookup(boolean value) {

      stateLookup_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. For each BidiWriteObjectRequest where state_lookup is `true` or
     * the client closes the stream, the service will send a
     * BidiWriteObjectResponse containing the current persisted size. The
     * persisted size sent in responses covers all the bytes the server has
     * persisted thus far and can be used to decide what data is safe for the
     * client to drop. Note that the object's current size reported by the
     * BidiWriteObjectResponse may lag behind the number of bytes written by the
     * client. This field is ignored if `finish_write` is set to true.
     * </pre>
     *
     * <code>bool state_lookup = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStateLookup() {
      bitField0_ = (bitField0_ & ~0x00000040);
      stateLookup_ = false;
      onChanged();
      return this;
    }

    private boolean flush_;

    /**
     *
     *
     * <pre>
     * Optional. Persists data written on the stream, up to and including the
     * current message, to permanent storage. This option should be used sparingly
     * as it may reduce performance. Ongoing writes will periodically be persisted
     * on the server even when `flush` is not set. This field is ignored if
     * `finish_write` is set to true since there's no need to checkpoint or flush
     * if this message completes the write.
     * </pre>
     *
     * <code>bool flush = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The flush.
     */
    @java.lang.Override
    public boolean getFlush() {
      return flush_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Persists data written on the stream, up to and including the
     * current message, to permanent storage. This option should be used sparingly
     * as it may reduce performance. Ongoing writes will periodically be persisted
     * on the server even when `flush` is not set. This field is ignored if
     * `finish_write` is set to true since there's no need to checkpoint or flush
     * if this message completes the write.
     * </pre>
     *
     * <code>bool flush = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The flush to set.
     * @return This builder for chaining.
     */
    public Builder setFlush(boolean value) {

      flush_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Persists data written on the stream, up to and including the
     * current message, to permanent storage. This option should be used sparingly
     * as it may reduce performance. Ongoing writes will periodically be persisted
     * on the server even when `flush` is not set. This field is ignored if
     * `finish_write` is set to true since there's no need to checkpoint or flush
     * if this message completes the write.
     * </pre>
     *
     * <code>bool flush = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFlush() {
      bitField0_ = (bitField0_ & ~0x00000080);
      flush_ = false;
      onChanged();
      return this;
    }

    private boolean finishWrite_;

    /**
     *
     *
     * <pre>
     * Optional. If `true`, this indicates that the write is complete. Sending any
     * `WriteObjectRequest`s subsequent to one in which `finish_write` is `true`
     * will cause an error.
     * For a non-resumable write (where the upload_id was not set in the first
     * message), it is an error not to set this field in the final message of the
     * stream.
     * </pre>
     *
     * <code>bool finish_write = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The finishWrite.
     */
    @java.lang.Override
    public boolean getFinishWrite() {
      return finishWrite_;
    }

    /**
     *
     *
     * <pre>
     * Optional. If `true`, this indicates that the write is complete. Sending any
     * `WriteObjectRequest`s subsequent to one in which `finish_write` is `true`
     * will cause an error.
     * For a non-resumable write (where the upload_id was not set in the first
     * message), it is an error not to set this field in the final message of the
     * stream.
     * </pre>
     *
     * <code>bool finish_write = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The finishWrite to set.
     * @return This builder for chaining.
     */
    public Builder setFinishWrite(boolean value) {

      finishWrite_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If `true`, this indicates that the write is complete. Sending any
     * `WriteObjectRequest`s subsequent to one in which `finish_write` is `true`
     * will cause an error.
     * For a non-resumable write (where the upload_id was not set in the first
     * message), it is an error not to set this field in the final message of the
     * stream.
     * </pre>
     *
     * <code>bool finish_write = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFinishWrite() {
      bitField0_ = (bitField0_ & ~0x00000100);
      finishWrite_ = false;
      onChanged();
      return this;
    }

    private com.google.storage.v2.CommonObjectRequestParams commonObjectRequestParams_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.CommonObjectRequestParams,
            com.google.storage.v2.CommonObjectRequestParams.Builder,
            com.google.storage.v2.CommonObjectRequestParamsOrBuilder>
        commonObjectRequestParamsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. A set of parameters common to Storage API requests concerning an
     * object.
     * </pre>
     *
     * <code>
     * .google.storage.v2.CommonObjectRequestParams common_object_request_params = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the commonObjectRequestParams field is set.
     */
    public boolean hasCommonObjectRequestParams() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of parameters common to Storage API requests concerning an
     * object.
     * </pre>
     *
     * <code>
     * .google.storage.v2.CommonObjectRequestParams common_object_request_params = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The commonObjectRequestParams.
     */
    public com.google.storage.v2.CommonObjectRequestParams getCommonObjectRequestParams() {
      if (commonObjectRequestParamsBuilder_ == null) {
        return commonObjectRequestParams_ == null
            ? com.google.storage.v2.CommonObjectRequestParams.getDefaultInstance()
            : commonObjectRequestParams_;
      } else {
        return commonObjectRequestParamsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of parameters common to Storage API requests concerning an
     * object.
     * </pre>
     *
     * <code>
     * .google.storage.v2.CommonObjectRequestParams common_object_request_params = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCommonObjectRequestParams(
        com.google.storage.v2.CommonObjectRequestParams value) {
      if (commonObjectRequestParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        commonObjectRequestParams_ = value;
      } else {
        commonObjectRequestParamsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of parameters common to Storage API requests concerning an
     * object.
     * </pre>
     *
     * <code>
     * .google.storage.v2.CommonObjectRequestParams common_object_request_params = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCommonObjectRequestParams(
        com.google.storage.v2.CommonObjectRequestParams.Builder builderForValue) {
      if (commonObjectRequestParamsBuilder_ == null) {
        commonObjectRequestParams_ = builderForValue.build();
      } else {
        commonObjectRequestParamsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of parameters common to Storage API requests concerning an
     * object.
     * </pre>
     *
     * <code>
     * .google.storage.v2.CommonObjectRequestParams common_object_request_params = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeCommonObjectRequestParams(
        com.google.storage.v2.CommonObjectRequestParams value) {
      if (commonObjectRequestParamsBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && commonObjectRequestParams_ != null
            && commonObjectRequestParams_
                != com.google.storage.v2.CommonObjectRequestParams.getDefaultInstance()) {
          getCommonObjectRequestParamsBuilder().mergeFrom(value);
        } else {
          commonObjectRequestParams_ = value;
        }
      } else {
        commonObjectRequestParamsBuilder_.mergeFrom(value);
      }
      if (commonObjectRequestParams_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of parameters common to Storage API requests concerning an
     * object.
     * </pre>
     *
     * <code>
     * .google.storage.v2.CommonObjectRequestParams common_object_request_params = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearCommonObjectRequestParams() {
      bitField0_ = (bitField0_ & ~0x00000200);
      commonObjectRequestParams_ = null;
      if (commonObjectRequestParamsBuilder_ != null) {
        commonObjectRequestParamsBuilder_.dispose();
        commonObjectRequestParamsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of parameters common to Storage API requests concerning an
     * object.
     * </pre>
     *
     * <code>
     * .google.storage.v2.CommonObjectRequestParams common_object_request_params = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.storage.v2.CommonObjectRequestParams.Builder
        getCommonObjectRequestParamsBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getCommonObjectRequestParamsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of parameters common to Storage API requests concerning an
     * object.
     * </pre>
     *
     * <code>
     * .google.storage.v2.CommonObjectRequestParams common_object_request_params = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.storage.v2.CommonObjectRequestParamsOrBuilder
        getCommonObjectRequestParamsOrBuilder() {
      if (commonObjectRequestParamsBuilder_ != null) {
        return commonObjectRequestParamsBuilder_.getMessageOrBuilder();
      } else {
        return commonObjectRequestParams_ == null
            ? com.google.storage.v2.CommonObjectRequestParams.getDefaultInstance()
            : commonObjectRequestParams_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of parameters common to Storage API requests concerning an
     * object.
     * </pre>
     *
     * <code>
     * .google.storage.v2.CommonObjectRequestParams common_object_request_params = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.CommonObjectRequestParams,
            com.google.storage.v2.CommonObjectRequestParams.Builder,
            com.google.storage.v2.CommonObjectRequestParamsOrBuilder>
        getCommonObjectRequestParamsFieldBuilder() {
      if (commonObjectRequestParamsBuilder_ == null) {
        commonObjectRequestParamsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.CommonObjectRequestParams,
                com.google.storage.v2.CommonObjectRequestParams.Builder,
                com.google.storage.v2.CommonObjectRequestParamsOrBuilder>(
                getCommonObjectRequestParams(), getParentForChildren(), isClean());
        commonObjectRequestParams_ = null;
      }
      return commonObjectRequestParamsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.storage.v2.BidiWriteObjectRequest)
  }

  // @@protoc_insertion_point(class_scope:google.storage.v2.BidiWriteObjectRequest)
  private static final com.google.storage.v2.BidiWriteObjectRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.storage.v2.BidiWriteObjectRequest();
  }

  public static com.google.storage.v2.BidiWriteObjectRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BidiWriteObjectRequest> PARSER =
      new com.google.protobuf.AbstractParser<BidiWriteObjectRequest>() {
        @java.lang.Override
        public BidiWriteObjectRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BidiWriteObjectRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BidiWriteObjectRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.storage.v2.BidiWriteObjectRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
