/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/storageinsights/v1/storageinsights.proto

package com.google.cloud.storageinsights.v1;

/**
 *
 *
 * <pre>
 * Report specification for exporting object metadata.
 * Next ID: 4
 * </pre>
 *
 * Protobuf type {@code google.cloud.storageinsights.v1.ObjectMetadataReportOptions}
 */
public final class ObjectMetadataReportOptions extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.storageinsights.v1.ObjectMetadataReportOptions)
    ObjectMetadataReportOptionsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ObjectMetadataReportOptions.newBuilder() to construct.
  private ObjectMetadataReportOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ObjectMetadataReportOptions() {
    metadataFields_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ObjectMetadataReportOptions();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.storageinsights.v1.V1Proto
        .internal_static_google_cloud_storageinsights_v1_ObjectMetadataReportOptions_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.storageinsights.v1.V1Proto
        .internal_static_google_cloud_storageinsights_v1_ObjectMetadataReportOptions_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions.class,
            com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions.Builder.class);
  }

  private int filterCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object filter_;

  public enum FilterCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    STORAGE_FILTERS(2),
    FILTER_NOT_SET(0);
    private final int value;

    private FilterCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FilterCase valueOf(int value) {
      return forNumber(value);
    }

    public static FilterCase forNumber(int value) {
      switch (value) {
        case 2:
          return STORAGE_FILTERS;
        case 0:
          return FILTER_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public FilterCase getFilterCase() {
    return FilterCase.forNumber(filterCase_);
  }

  private int destinationOptionsCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object destinationOptions_;

  public enum DestinationOptionsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    STORAGE_DESTINATION_OPTIONS(3),
    DESTINATIONOPTIONS_NOT_SET(0);
    private final int value;

    private DestinationOptionsCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DestinationOptionsCase valueOf(int value) {
      return forNumber(value);
    }

    public static DestinationOptionsCase forNumber(int value) {
      switch (value) {
        case 3:
          return STORAGE_DESTINATION_OPTIONS;
        case 0:
          return DESTINATIONOPTIONS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DestinationOptionsCase getDestinationOptionsCase() {
    return DestinationOptionsCase.forNumber(destinationOptionsCase_);
  }

  public static final int METADATA_FIELDS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList metadataFields_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Metadata fields to be included in the report.
   * </pre>
   *
   * <code>repeated string metadata_fields = 1;</code>
   *
   * @return A list containing the metadataFields.
   */
  public com.google.protobuf.ProtocolStringList getMetadataFieldsList() {
    return metadataFields_;
  }
  /**
   *
   *
   * <pre>
   * Metadata fields to be included in the report.
   * </pre>
   *
   * <code>repeated string metadata_fields = 1;</code>
   *
   * @return The count of metadataFields.
   */
  public int getMetadataFieldsCount() {
    return metadataFields_.size();
  }
  /**
   *
   *
   * <pre>
   * Metadata fields to be included in the report.
   * </pre>
   *
   * <code>repeated string metadata_fields = 1;</code>
   *
   * @param index The index of the element to return.
   * @return The metadataFields at the given index.
   */
  public java.lang.String getMetadataFields(int index) {
    return metadataFields_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Metadata fields to be included in the report.
   * </pre>
   *
   * <code>repeated string metadata_fields = 1;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the metadataFields at the given index.
   */
  public com.google.protobuf.ByteString getMetadataFieldsBytes(int index) {
    return metadataFields_.getByteString(index);
  }

  public static final int STORAGE_FILTERS_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Cloud Storage as the storage system.
   * </pre>
   *
   * <code>.google.cloud.storageinsights.v1.CloudStorageFilters storage_filters = 2;</code>
   *
   * @return Whether the storageFilters field is set.
   */
  @java.lang.Override
  public boolean hasStorageFilters() {
    return filterCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Cloud Storage as the storage system.
   * </pre>
   *
   * <code>.google.cloud.storageinsights.v1.CloudStorageFilters storage_filters = 2;</code>
   *
   * @return The storageFilters.
   */
  @java.lang.Override
  public com.google.cloud.storageinsights.v1.CloudStorageFilters getStorageFilters() {
    if (filterCase_ == 2) {
      return (com.google.cloud.storageinsights.v1.CloudStorageFilters) filter_;
    }
    return com.google.cloud.storageinsights.v1.CloudStorageFilters.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Cloud Storage as the storage system.
   * </pre>
   *
   * <code>.google.cloud.storageinsights.v1.CloudStorageFilters storage_filters = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.storageinsights.v1.CloudStorageFiltersOrBuilder
      getStorageFiltersOrBuilder() {
    if (filterCase_ == 2) {
      return (com.google.cloud.storageinsights.v1.CloudStorageFilters) filter_;
    }
    return com.google.cloud.storageinsights.v1.CloudStorageFilters.getDefaultInstance();
  }

  public static final int STORAGE_DESTINATION_OPTIONS_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Cloud Storage as the storage system.
   * </pre>
   *
   * <code>
   * .google.cloud.storageinsights.v1.CloudStorageDestinationOptions storage_destination_options = 3;
   * </code>
   *
   * @return Whether the storageDestinationOptions field is set.
   */
  @java.lang.Override
  public boolean hasStorageDestinationOptions() {
    return destinationOptionsCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Cloud Storage as the storage system.
   * </pre>
   *
   * <code>
   * .google.cloud.storageinsights.v1.CloudStorageDestinationOptions storage_destination_options = 3;
   * </code>
   *
   * @return The storageDestinationOptions.
   */
  @java.lang.Override
  public com.google.cloud.storageinsights.v1.CloudStorageDestinationOptions
      getStorageDestinationOptions() {
    if (destinationOptionsCase_ == 3) {
      return (com.google.cloud.storageinsights.v1.CloudStorageDestinationOptions)
          destinationOptions_;
    }
    return com.google.cloud.storageinsights.v1.CloudStorageDestinationOptions.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Cloud Storage as the storage system.
   * </pre>
   *
   * <code>
   * .google.cloud.storageinsights.v1.CloudStorageDestinationOptions storage_destination_options = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.storageinsights.v1.CloudStorageDestinationOptionsOrBuilder
      getStorageDestinationOptionsOrBuilder() {
    if (destinationOptionsCase_ == 3) {
      return (com.google.cloud.storageinsights.v1.CloudStorageDestinationOptions)
          destinationOptions_;
    }
    return com.google.cloud.storageinsights.v1.CloudStorageDestinationOptions.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < metadataFields_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, metadataFields_.getRaw(i));
    }
    if (filterCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.storageinsights.v1.CloudStorageFilters) filter_);
    }
    if (destinationOptionsCase_ == 3) {
      output.writeMessage(
          3,
          (com.google.cloud.storageinsights.v1.CloudStorageDestinationOptions) destinationOptions_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < metadataFields_.size(); i++) {
        dataSize += computeStringSizeNoTag(metadataFields_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getMetadataFieldsList().size();
    }
    if (filterCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.storageinsights.v1.CloudStorageFilters) filter_);
    }
    if (destinationOptionsCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3,
              (com.google.cloud.storageinsights.v1.CloudStorageDestinationOptions)
                  destinationOptions_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions)) {
      return super.equals(obj);
    }
    com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions other =
        (com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions) obj;

    if (!getMetadataFieldsList().equals(other.getMetadataFieldsList())) return false;
    if (!getFilterCase().equals(other.getFilterCase())) return false;
    switch (filterCase_) {
      case 2:
        if (!getStorageFilters().equals(other.getStorageFilters())) return false;
        break;
      case 0:
      default:
    }
    if (!getDestinationOptionsCase().equals(other.getDestinationOptionsCase())) return false;
    switch (destinationOptionsCase_) {
      case 3:
        if (!getStorageDestinationOptions().equals(other.getStorageDestinationOptions()))
          return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getMetadataFieldsCount() > 0) {
      hash = (37 * hash) + METADATA_FIELDS_FIELD_NUMBER;
      hash = (53 * hash) + getMetadataFieldsList().hashCode();
    }
    switch (filterCase_) {
      case 2:
        hash = (37 * hash) + STORAGE_FILTERS_FIELD_NUMBER;
        hash = (53 * hash) + getStorageFilters().hashCode();
        break;
      case 0:
      default:
    }
    switch (destinationOptionsCase_) {
      case 3:
        hash = (37 * hash) + STORAGE_DESTINATION_OPTIONS_FIELD_NUMBER;
        hash = (53 * hash) + getStorageDestinationOptions().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Report specification for exporting object metadata.
   * Next ID: 4
   * </pre>
   *
   * Protobuf type {@code google.cloud.storageinsights.v1.ObjectMetadataReportOptions}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.storageinsights.v1.ObjectMetadataReportOptions)
      com.google.cloud.storageinsights.v1.ObjectMetadataReportOptionsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.storageinsights.v1.V1Proto
          .internal_static_google_cloud_storageinsights_v1_ObjectMetadataReportOptions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.storageinsights.v1.V1Proto
          .internal_static_google_cloud_storageinsights_v1_ObjectMetadataReportOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions.class,
              com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions.Builder.class);
    }

    // Construct using com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      metadataFields_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (storageFiltersBuilder_ != null) {
        storageFiltersBuilder_.clear();
      }
      if (storageDestinationOptionsBuilder_ != null) {
        storageDestinationOptionsBuilder_.clear();
      }
      filterCase_ = 0;
      filter_ = null;
      destinationOptionsCase_ = 0;
      destinationOptions_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.storageinsights.v1.V1Proto
          .internal_static_google_cloud_storageinsights_v1_ObjectMetadataReportOptions_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions
        getDefaultInstanceForType() {
      return com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions build() {
      com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions buildPartial() {
      com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions result =
          new com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        metadataFields_.makeImmutable();
        result.metadataFields_ = metadataFields_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions result) {
      result.filterCase_ = filterCase_;
      result.filter_ = this.filter_;
      if (filterCase_ == 2 && storageFiltersBuilder_ != null) {
        result.filter_ = storageFiltersBuilder_.build();
      }
      result.destinationOptionsCase_ = destinationOptionsCase_;
      result.destinationOptions_ = this.destinationOptions_;
      if (destinationOptionsCase_ == 3 && storageDestinationOptionsBuilder_ != null) {
        result.destinationOptions_ = storageDestinationOptionsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions) {
        return mergeFrom((com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions other) {
      if (other
          == com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions.getDefaultInstance())
        return this;
      if (!other.metadataFields_.isEmpty()) {
        if (metadataFields_.isEmpty()) {
          metadataFields_ = other.metadataFields_;
          bitField0_ |= 0x00000001;
        } else {
          ensureMetadataFieldsIsMutable();
          metadataFields_.addAll(other.metadataFields_);
        }
        onChanged();
      }
      switch (other.getFilterCase()) {
        case STORAGE_FILTERS:
          {
            mergeStorageFilters(other.getStorageFilters());
            break;
          }
        case FILTER_NOT_SET:
          {
            break;
          }
      }
      switch (other.getDestinationOptionsCase()) {
        case STORAGE_DESTINATION_OPTIONS:
          {
            mergeStorageDestinationOptions(other.getStorageDestinationOptions());
            break;
          }
        case DESTINATIONOPTIONS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureMetadataFieldsIsMutable();
                metadataFields_.add(s);
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getStorageFiltersFieldBuilder().getBuilder(), extensionRegistry);
                filterCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getStorageDestinationOptionsFieldBuilder().getBuilder(), extensionRegistry);
                destinationOptionsCase_ = 3;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int filterCase_ = 0;
    private java.lang.Object filter_;

    public FilterCase getFilterCase() {
      return FilterCase.forNumber(filterCase_);
    }

    public Builder clearFilter() {
      filterCase_ = 0;
      filter_ = null;
      onChanged();
      return this;
    }

    private int destinationOptionsCase_ = 0;
    private java.lang.Object destinationOptions_;

    public DestinationOptionsCase getDestinationOptionsCase() {
      return DestinationOptionsCase.forNumber(destinationOptionsCase_);
    }

    public Builder clearDestinationOptions() {
      destinationOptionsCase_ = 0;
      destinationOptions_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringArrayList metadataFields_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureMetadataFieldsIsMutable() {
      if (!metadataFields_.isModifiable()) {
        metadataFields_ = new com.google.protobuf.LazyStringArrayList(metadataFields_);
      }
      bitField0_ |= 0x00000001;
    }
    /**
     *
     *
     * <pre>
     * Metadata fields to be included in the report.
     * </pre>
     *
     * <code>repeated string metadata_fields = 1;</code>
     *
     * @return A list containing the metadataFields.
     */
    public com.google.protobuf.ProtocolStringList getMetadataFieldsList() {
      metadataFields_.makeImmutable();
      return metadataFields_;
    }
    /**
     *
     *
     * <pre>
     * Metadata fields to be included in the report.
     * </pre>
     *
     * <code>repeated string metadata_fields = 1;</code>
     *
     * @return The count of metadataFields.
     */
    public int getMetadataFieldsCount() {
      return metadataFields_.size();
    }
    /**
     *
     *
     * <pre>
     * Metadata fields to be included in the report.
     * </pre>
     *
     * <code>repeated string metadata_fields = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The metadataFields at the given index.
     */
    public java.lang.String getMetadataFields(int index) {
      return metadataFields_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Metadata fields to be included in the report.
     * </pre>
     *
     * <code>repeated string metadata_fields = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the metadataFields at the given index.
     */
    public com.google.protobuf.ByteString getMetadataFieldsBytes(int index) {
      return metadataFields_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Metadata fields to be included in the report.
     * </pre>
     *
     * <code>repeated string metadata_fields = 1;</code>
     *
     * @param index The index to set the value at.
     * @param value The metadataFields to set.
     * @return This builder for chaining.
     */
    public Builder setMetadataFields(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMetadataFieldsIsMutable();
      metadataFields_.set(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata fields to be included in the report.
     * </pre>
     *
     * <code>repeated string metadata_fields = 1;</code>
     *
     * @param value The metadataFields to add.
     * @return This builder for chaining.
     */
    public Builder addMetadataFields(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMetadataFieldsIsMutable();
      metadataFields_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata fields to be included in the report.
     * </pre>
     *
     * <code>repeated string metadata_fields = 1;</code>
     *
     * @param values The metadataFields to add.
     * @return This builder for chaining.
     */
    public Builder addAllMetadataFields(java.lang.Iterable<java.lang.String> values) {
      ensureMetadataFieldsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, metadataFields_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata fields to be included in the report.
     * </pre>
     *
     * <code>repeated string metadata_fields = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetadataFields() {
      metadataFields_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata fields to be included in the report.
     * </pre>
     *
     * <code>repeated string metadata_fields = 1;</code>
     *
     * @param value The bytes of the metadataFields to add.
     * @return This builder for chaining.
     */
    public Builder addMetadataFieldsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureMetadataFieldsIsMutable();
      metadataFields_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.storageinsights.v1.CloudStorageFilters,
            com.google.cloud.storageinsights.v1.CloudStorageFilters.Builder,
            com.google.cloud.storageinsights.v1.CloudStorageFiltersOrBuilder>
        storageFiltersBuilder_;
    /**
     *
     *
     * <pre>
     * Cloud Storage as the storage system.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.CloudStorageFilters storage_filters = 2;</code>
     *
     * @return Whether the storageFilters field is set.
     */
    @java.lang.Override
    public boolean hasStorageFilters() {
      return filterCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage as the storage system.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.CloudStorageFilters storage_filters = 2;</code>
     *
     * @return The storageFilters.
     */
    @java.lang.Override
    public com.google.cloud.storageinsights.v1.CloudStorageFilters getStorageFilters() {
      if (storageFiltersBuilder_ == null) {
        if (filterCase_ == 2) {
          return (com.google.cloud.storageinsights.v1.CloudStorageFilters) filter_;
        }
        return com.google.cloud.storageinsights.v1.CloudStorageFilters.getDefaultInstance();
      } else {
        if (filterCase_ == 2) {
          return storageFiltersBuilder_.getMessage();
        }
        return com.google.cloud.storageinsights.v1.CloudStorageFilters.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage as the storage system.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.CloudStorageFilters storage_filters = 2;</code>
     */
    public Builder setStorageFilters(
        com.google.cloud.storageinsights.v1.CloudStorageFilters value) {
      if (storageFiltersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
        onChanged();
      } else {
        storageFiltersBuilder_.setMessage(value);
      }
      filterCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage as the storage system.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.CloudStorageFilters storage_filters = 2;</code>
     */
    public Builder setStorageFilters(
        com.google.cloud.storageinsights.v1.CloudStorageFilters.Builder builderForValue) {
      if (storageFiltersBuilder_ == null) {
        filter_ = builderForValue.build();
        onChanged();
      } else {
        storageFiltersBuilder_.setMessage(builderForValue.build());
      }
      filterCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage as the storage system.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.CloudStorageFilters storage_filters = 2;</code>
     */
    public Builder mergeStorageFilters(
        com.google.cloud.storageinsights.v1.CloudStorageFilters value) {
      if (storageFiltersBuilder_ == null) {
        if (filterCase_ == 2
            && filter_
                != com.google.cloud.storageinsights.v1.CloudStorageFilters.getDefaultInstance()) {
          filter_ =
              com.google.cloud.storageinsights.v1.CloudStorageFilters.newBuilder(
                      (com.google.cloud.storageinsights.v1.CloudStorageFilters) filter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          filter_ = value;
        }
        onChanged();
      } else {
        if (filterCase_ == 2) {
          storageFiltersBuilder_.mergeFrom(value);
        } else {
          storageFiltersBuilder_.setMessage(value);
        }
      }
      filterCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage as the storage system.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.CloudStorageFilters storage_filters = 2;</code>
     */
    public Builder clearStorageFilters() {
      if (storageFiltersBuilder_ == null) {
        if (filterCase_ == 2) {
          filterCase_ = 0;
          filter_ = null;
          onChanged();
        }
      } else {
        if (filterCase_ == 2) {
          filterCase_ = 0;
          filter_ = null;
        }
        storageFiltersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage as the storage system.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.CloudStorageFilters storage_filters = 2;</code>
     */
    public com.google.cloud.storageinsights.v1.CloudStorageFilters.Builder
        getStorageFiltersBuilder() {
      return getStorageFiltersFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage as the storage system.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.CloudStorageFilters storage_filters = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.storageinsights.v1.CloudStorageFiltersOrBuilder
        getStorageFiltersOrBuilder() {
      if ((filterCase_ == 2) && (storageFiltersBuilder_ != null)) {
        return storageFiltersBuilder_.getMessageOrBuilder();
      } else {
        if (filterCase_ == 2) {
          return (com.google.cloud.storageinsights.v1.CloudStorageFilters) filter_;
        }
        return com.google.cloud.storageinsights.v1.CloudStorageFilters.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage as the storage system.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.CloudStorageFilters storage_filters = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.storageinsights.v1.CloudStorageFilters,
            com.google.cloud.storageinsights.v1.CloudStorageFilters.Builder,
            com.google.cloud.storageinsights.v1.CloudStorageFiltersOrBuilder>
        getStorageFiltersFieldBuilder() {
      if (storageFiltersBuilder_ == null) {
        if (!(filterCase_ == 2)) {
          filter_ = com.google.cloud.storageinsights.v1.CloudStorageFilters.getDefaultInstance();
        }
        storageFiltersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.storageinsights.v1.CloudStorageFilters,
                com.google.cloud.storageinsights.v1.CloudStorageFilters.Builder,
                com.google.cloud.storageinsights.v1.CloudStorageFiltersOrBuilder>(
                (com.google.cloud.storageinsights.v1.CloudStorageFilters) filter_,
                getParentForChildren(),
                isClean());
        filter_ = null;
      }
      filterCase_ = 2;
      onChanged();
      return storageFiltersBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.storageinsights.v1.CloudStorageDestinationOptions,
            com.google.cloud.storageinsights.v1.CloudStorageDestinationOptions.Builder,
            com.google.cloud.storageinsights.v1.CloudStorageDestinationOptionsOrBuilder>
        storageDestinationOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * Cloud Storage as the storage system.
     * </pre>
     *
     * <code>
     * .google.cloud.storageinsights.v1.CloudStorageDestinationOptions storage_destination_options = 3;
     * </code>
     *
     * @return Whether the storageDestinationOptions field is set.
     */
    @java.lang.Override
    public boolean hasStorageDestinationOptions() {
      return destinationOptionsCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage as the storage system.
     * </pre>
     *
     * <code>
     * .google.cloud.storageinsights.v1.CloudStorageDestinationOptions storage_destination_options = 3;
     * </code>
     *
     * @return The storageDestinationOptions.
     */
    @java.lang.Override
    public com.google.cloud.storageinsights.v1.CloudStorageDestinationOptions
        getStorageDestinationOptions() {
      if (storageDestinationOptionsBuilder_ == null) {
        if (destinationOptionsCase_ == 3) {
          return (com.google.cloud.storageinsights.v1.CloudStorageDestinationOptions)
              destinationOptions_;
        }
        return com.google.cloud.storageinsights.v1.CloudStorageDestinationOptions
            .getDefaultInstance();
      } else {
        if (destinationOptionsCase_ == 3) {
          return storageDestinationOptionsBuilder_.getMessage();
        }
        return com.google.cloud.storageinsights.v1.CloudStorageDestinationOptions
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage as the storage system.
     * </pre>
     *
     * <code>
     * .google.cloud.storageinsights.v1.CloudStorageDestinationOptions storage_destination_options = 3;
     * </code>
     */
    public Builder setStorageDestinationOptions(
        com.google.cloud.storageinsights.v1.CloudStorageDestinationOptions value) {
      if (storageDestinationOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destinationOptions_ = value;
        onChanged();
      } else {
        storageDestinationOptionsBuilder_.setMessage(value);
      }
      destinationOptionsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage as the storage system.
     * </pre>
     *
     * <code>
     * .google.cloud.storageinsights.v1.CloudStorageDestinationOptions storage_destination_options = 3;
     * </code>
     */
    public Builder setStorageDestinationOptions(
        com.google.cloud.storageinsights.v1.CloudStorageDestinationOptions.Builder
            builderForValue) {
      if (storageDestinationOptionsBuilder_ == null) {
        destinationOptions_ = builderForValue.build();
        onChanged();
      } else {
        storageDestinationOptionsBuilder_.setMessage(builderForValue.build());
      }
      destinationOptionsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage as the storage system.
     * </pre>
     *
     * <code>
     * .google.cloud.storageinsights.v1.CloudStorageDestinationOptions storage_destination_options = 3;
     * </code>
     */
    public Builder mergeStorageDestinationOptions(
        com.google.cloud.storageinsights.v1.CloudStorageDestinationOptions value) {
      if (storageDestinationOptionsBuilder_ == null) {
        if (destinationOptionsCase_ == 3
            && destinationOptions_
                != com.google.cloud.storageinsights.v1.CloudStorageDestinationOptions
                    .getDefaultInstance()) {
          destinationOptions_ =
              com.google.cloud.storageinsights.v1.CloudStorageDestinationOptions.newBuilder(
                      (com.google.cloud.storageinsights.v1.CloudStorageDestinationOptions)
                          destinationOptions_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          destinationOptions_ = value;
        }
        onChanged();
      } else {
        if (destinationOptionsCase_ == 3) {
          storageDestinationOptionsBuilder_.mergeFrom(value);
        } else {
          storageDestinationOptionsBuilder_.setMessage(value);
        }
      }
      destinationOptionsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage as the storage system.
     * </pre>
     *
     * <code>
     * .google.cloud.storageinsights.v1.CloudStorageDestinationOptions storage_destination_options = 3;
     * </code>
     */
    public Builder clearStorageDestinationOptions() {
      if (storageDestinationOptionsBuilder_ == null) {
        if (destinationOptionsCase_ == 3) {
          destinationOptionsCase_ = 0;
          destinationOptions_ = null;
          onChanged();
        }
      } else {
        if (destinationOptionsCase_ == 3) {
          destinationOptionsCase_ = 0;
          destinationOptions_ = null;
        }
        storageDestinationOptionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage as the storage system.
     * </pre>
     *
     * <code>
     * .google.cloud.storageinsights.v1.CloudStorageDestinationOptions storage_destination_options = 3;
     * </code>
     */
    public com.google.cloud.storageinsights.v1.CloudStorageDestinationOptions.Builder
        getStorageDestinationOptionsBuilder() {
      return getStorageDestinationOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage as the storage system.
     * </pre>
     *
     * <code>
     * .google.cloud.storageinsights.v1.CloudStorageDestinationOptions storage_destination_options = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.storageinsights.v1.CloudStorageDestinationOptionsOrBuilder
        getStorageDestinationOptionsOrBuilder() {
      if ((destinationOptionsCase_ == 3) && (storageDestinationOptionsBuilder_ != null)) {
        return storageDestinationOptionsBuilder_.getMessageOrBuilder();
      } else {
        if (destinationOptionsCase_ == 3) {
          return (com.google.cloud.storageinsights.v1.CloudStorageDestinationOptions)
              destinationOptions_;
        }
        return com.google.cloud.storageinsights.v1.CloudStorageDestinationOptions
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage as the storage system.
     * </pre>
     *
     * <code>
     * .google.cloud.storageinsights.v1.CloudStorageDestinationOptions storage_destination_options = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.storageinsights.v1.CloudStorageDestinationOptions,
            com.google.cloud.storageinsights.v1.CloudStorageDestinationOptions.Builder,
            com.google.cloud.storageinsights.v1.CloudStorageDestinationOptionsOrBuilder>
        getStorageDestinationOptionsFieldBuilder() {
      if (storageDestinationOptionsBuilder_ == null) {
        if (!(destinationOptionsCase_ == 3)) {
          destinationOptions_ =
              com.google.cloud.storageinsights.v1.CloudStorageDestinationOptions
                  .getDefaultInstance();
        }
        storageDestinationOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.storageinsights.v1.CloudStorageDestinationOptions,
                com.google.cloud.storageinsights.v1.CloudStorageDestinationOptions.Builder,
                com.google.cloud.storageinsights.v1.CloudStorageDestinationOptionsOrBuilder>(
                (com.google.cloud.storageinsights.v1.CloudStorageDestinationOptions)
                    destinationOptions_,
                getParentForChildren(),
                isClean());
        destinationOptions_ = null;
      }
      destinationOptionsCase_ = 3;
      onChanged();
      return storageDestinationOptionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.storageinsights.v1.ObjectMetadataReportOptions)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.storageinsights.v1.ObjectMetadataReportOptions)
  private static final com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions();
  }

  public static com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ObjectMetadataReportOptions> PARSER =
      new com.google.protobuf.AbstractParser<ObjectMetadataReportOptions>() {
        @java.lang.Override
        public ObjectMetadataReportOptions parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ObjectMetadataReportOptions> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ObjectMetadataReportOptions> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
