/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/storageinsights/v1/storageinsights.proto

package com.google.cloud.storageinsights.v1;

/**
 *
 *
 * <pre>
 * Message describing ReportConfig object. ReportConfig is the configuration to
 * generate reports.
 * See
 * https://cloud.google.com/storage/docs/insights/using-inventory-reports#create-config-rest
 * for more details on how to set various fields.
 * Next ID: 12
 * </pre>
 *
 * Protobuf type {@code google.cloud.storageinsights.v1.ReportConfig}
 */
public final class ReportConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.storageinsights.v1.ReportConfig)
    ReportConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ReportConfig.newBuilder() to construct.
  private ReportConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReportConfig() {
    name_ = "";
    displayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReportConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.storageinsights.v1.V1Proto
        .internal_static_google_cloud_storageinsights_v1_ReportConfig_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 10:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.storageinsights.v1.V1Proto
        .internal_static_google_cloud_storageinsights_v1_ReportConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.storageinsights.v1.ReportConfig.class,
            com.google.cloud.storageinsights.v1.ReportConfig.Builder.class);
  }

  private int reportFormatCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object reportFormat_;

  public enum ReportFormatCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CSV_OPTIONS(6),
    PARQUET_OPTIONS(7),
    REPORTFORMAT_NOT_SET(0);
    private final int value;

    private ReportFormatCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ReportFormatCase valueOf(int value) {
      return forNumber(value);
    }

    public static ReportFormatCase forNumber(int value) {
      switch (value) {
        case 6:
          return CSV_OPTIONS;
        case 7:
          return PARQUET_OPTIONS;
        case 0:
          return REPORTFORMAT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ReportFormatCase getReportFormatCase() {
    return ReportFormatCase.forNumber(reportFormatCase_);
  }

  private int reportKindCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object reportKind_;

  public enum ReportKindCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    OBJECT_METADATA_REPORT_OPTIONS(8),
    REPORTKIND_NOT_SET(0);
    private final int value;

    private ReportKindCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ReportKindCase valueOf(int value) {
      return forNumber(value);
    }

    public static ReportKindCase forNumber(int value) {
      switch (value) {
        case 8:
          return OBJECT_METADATA_REPORT_OPTIONS;
        case 0:
          return REPORTKIND_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ReportKindCase getReportKindCase() {
    return ReportKindCase.forNumber(reportKindCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * name of resource. It will be of form
   * projects/&lt;project&gt;/locations/&lt;location&gt;/reportConfigs/&lt;report-config-id&gt;.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * name of resource. It will be of form
   * projects/&lt;project&gt;/locations/&lt;location&gt;/reportConfigs/&lt;report-config-id&gt;.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. [Output only] Create time stamp
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. [Output only] Create time stamp
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. [Output only] Create time stamp
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. [Output only] Update time stamp
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. [Output only] Update time stamp
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. [Output only] Update time stamp
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int FREQUENCY_OPTIONS_FIELD_NUMBER = 5;
  private com.google.cloud.storageinsights.v1.FrequencyOptions frequencyOptions_;
  /**
   *
   *
   * <pre>
   * The frequency of report generation.
   * </pre>
   *
   * <code>.google.cloud.storageinsights.v1.FrequencyOptions frequency_options = 5;</code>
   *
   * @return Whether the frequencyOptions field is set.
   */
  @java.lang.Override
  public boolean hasFrequencyOptions() {
    return frequencyOptions_ != null;
  }
  /**
   *
   *
   * <pre>
   * The frequency of report generation.
   * </pre>
   *
   * <code>.google.cloud.storageinsights.v1.FrequencyOptions frequency_options = 5;</code>
   *
   * @return The frequencyOptions.
   */
  @java.lang.Override
  public com.google.cloud.storageinsights.v1.FrequencyOptions getFrequencyOptions() {
    return frequencyOptions_ == null
        ? com.google.cloud.storageinsights.v1.FrequencyOptions.getDefaultInstance()
        : frequencyOptions_;
  }
  /**
   *
   *
   * <pre>
   * The frequency of report generation.
   * </pre>
   *
   * <code>.google.cloud.storageinsights.v1.FrequencyOptions frequency_options = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.storageinsights.v1.FrequencyOptionsOrBuilder
      getFrequencyOptionsOrBuilder() {
    return frequencyOptions_ == null
        ? com.google.cloud.storageinsights.v1.FrequencyOptions.getDefaultInstance()
        : frequencyOptions_;
  }

  public static final int CSV_OPTIONS_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Options for CSV formatted reports.
   * </pre>
   *
   * <code>.google.cloud.storageinsights.v1.CSVOptions csv_options = 6;</code>
   *
   * @return Whether the csvOptions field is set.
   */
  @java.lang.Override
  public boolean hasCsvOptions() {
    return reportFormatCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Options for CSV formatted reports.
   * </pre>
   *
   * <code>.google.cloud.storageinsights.v1.CSVOptions csv_options = 6;</code>
   *
   * @return The csvOptions.
   */
  @java.lang.Override
  public com.google.cloud.storageinsights.v1.CSVOptions getCsvOptions() {
    if (reportFormatCase_ == 6) {
      return (com.google.cloud.storageinsights.v1.CSVOptions) reportFormat_;
    }
    return com.google.cloud.storageinsights.v1.CSVOptions.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Options for CSV formatted reports.
   * </pre>
   *
   * <code>.google.cloud.storageinsights.v1.CSVOptions csv_options = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.storageinsights.v1.CSVOptionsOrBuilder getCsvOptionsOrBuilder() {
    if (reportFormatCase_ == 6) {
      return (com.google.cloud.storageinsights.v1.CSVOptions) reportFormat_;
    }
    return com.google.cloud.storageinsights.v1.CSVOptions.getDefaultInstance();
  }

  public static final int PARQUET_OPTIONS_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Options for Parquet formatted reports.
   * </pre>
   *
   * <code>.google.cloud.storageinsights.v1.ParquetOptions parquet_options = 7;</code>
   *
   * @return Whether the parquetOptions field is set.
   */
  @java.lang.Override
  public boolean hasParquetOptions() {
    return reportFormatCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Options for Parquet formatted reports.
   * </pre>
   *
   * <code>.google.cloud.storageinsights.v1.ParquetOptions parquet_options = 7;</code>
   *
   * @return The parquetOptions.
   */
  @java.lang.Override
  public com.google.cloud.storageinsights.v1.ParquetOptions getParquetOptions() {
    if (reportFormatCase_ == 7) {
      return (com.google.cloud.storageinsights.v1.ParquetOptions) reportFormat_;
    }
    return com.google.cloud.storageinsights.v1.ParquetOptions.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Options for Parquet formatted reports.
   * </pre>
   *
   * <code>.google.cloud.storageinsights.v1.ParquetOptions parquet_options = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.storageinsights.v1.ParquetOptionsOrBuilder getParquetOptionsOrBuilder() {
    if (reportFormatCase_ == 7) {
      return (com.google.cloud.storageinsights.v1.ParquetOptions) reportFormat_;
    }
    return com.google.cloud.storageinsights.v1.ParquetOptions.getDefaultInstance();
  }

  public static final int OBJECT_METADATA_REPORT_OPTIONS_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Report for exporting object metadata.
   * </pre>
   *
   * <code>
   * .google.cloud.storageinsights.v1.ObjectMetadataReportOptions object_metadata_report_options = 8;
   * </code>
   *
   * @return Whether the objectMetadataReportOptions field is set.
   */
  @java.lang.Override
  public boolean hasObjectMetadataReportOptions() {
    return reportKindCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * Report for exporting object metadata.
   * </pre>
   *
   * <code>
   * .google.cloud.storageinsights.v1.ObjectMetadataReportOptions object_metadata_report_options = 8;
   * </code>
   *
   * @return The objectMetadataReportOptions.
   */
  @java.lang.Override
  public com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions
      getObjectMetadataReportOptions() {
    if (reportKindCase_ == 8) {
      return (com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions) reportKind_;
    }
    return com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Report for exporting object metadata.
   * </pre>
   *
   * <code>
   * .google.cloud.storageinsights.v1.ObjectMetadataReportOptions object_metadata_report_options = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.storageinsights.v1.ObjectMetadataReportOptionsOrBuilder
      getObjectMetadataReportOptionsOrBuilder() {
    if (reportKindCase_ == 8) {
      return (com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions) reportKind_;
    }
    return com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions.getDefaultInstance();
  }

  public static final int LABELS_FIELD_NUMBER = 10;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.storageinsights.v1.V1Proto
                .internal_static_google_cloud_storageinsights_v1_ReportConfig_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels as key value pairs
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 10;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels as key value pairs
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 10;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels as key value pairs
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 10;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels as key value pairs
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 10;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * User provided display name which can be empty and limited to 256 characters
   * that is editable.
   * </pre>
   *
   * <code>string display_name = 11;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * User provided display name which can be empty and limited to 256 characters
   * that is editable.
   * </pre>
   *
   * <code>string display_name = 11;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (createTime_ != null) {
      output.writeMessage(2, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(3, getUpdateTime());
    }
    if (frequencyOptions_ != null) {
      output.writeMessage(5, getFrequencyOptions());
    }
    if (reportFormatCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.storageinsights.v1.CSVOptions) reportFormat_);
    }
    if (reportFormatCase_ == 7) {
      output.writeMessage(7, (com.google.cloud.storageinsights.v1.ParquetOptions) reportFormat_);
    }
    if (reportKindCase_ == 8) {
      output.writeMessage(
          8, (com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions) reportKind_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 10);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, displayName_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    if (frequencyOptions_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getFrequencyOptions());
    }
    if (reportFormatCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.storageinsights.v1.CSVOptions) reportFormat_);
    }
    if (reportFormatCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.storageinsights.v1.ParquetOptions) reportFormat_);
    }
    if (reportKindCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions) reportKind_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, labels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, displayName_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.storageinsights.v1.ReportConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.storageinsights.v1.ReportConfig other =
        (com.google.cloud.storageinsights.v1.ReportConfig) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasFrequencyOptions() != other.hasFrequencyOptions()) return false;
    if (hasFrequencyOptions()) {
      if (!getFrequencyOptions().equals(other.getFrequencyOptions())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getReportFormatCase().equals(other.getReportFormatCase())) return false;
    switch (reportFormatCase_) {
      case 6:
        if (!getCsvOptions().equals(other.getCsvOptions())) return false;
        break;
      case 7:
        if (!getParquetOptions().equals(other.getParquetOptions())) return false;
        break;
      case 0:
      default:
    }
    if (!getReportKindCase().equals(other.getReportKindCase())) return false;
    switch (reportKindCase_) {
      case 8:
        if (!getObjectMetadataReportOptions().equals(other.getObjectMetadataReportOptions()))
          return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasFrequencyOptions()) {
      hash = (37 * hash) + FREQUENCY_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getFrequencyOptions().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    switch (reportFormatCase_) {
      case 6:
        hash = (37 * hash) + CSV_OPTIONS_FIELD_NUMBER;
        hash = (53 * hash) + getCsvOptions().hashCode();
        break;
      case 7:
        hash = (37 * hash) + PARQUET_OPTIONS_FIELD_NUMBER;
        hash = (53 * hash) + getParquetOptions().hashCode();
        break;
      case 0:
      default:
    }
    switch (reportKindCase_) {
      case 8:
        hash = (37 * hash) + OBJECT_METADATA_REPORT_OPTIONS_FIELD_NUMBER;
        hash = (53 * hash) + getObjectMetadataReportOptions().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.storageinsights.v1.ReportConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.storageinsights.v1.ReportConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.storageinsights.v1.ReportConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.storageinsights.v1.ReportConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.storageinsights.v1.ReportConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.storageinsights.v1.ReportConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.storageinsights.v1.ReportConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.storageinsights.v1.ReportConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.storageinsights.v1.ReportConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.storageinsights.v1.ReportConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.storageinsights.v1.ReportConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.storageinsights.v1.ReportConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.storageinsights.v1.ReportConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Message describing ReportConfig object. ReportConfig is the configuration to
   * generate reports.
   * See
   * https://cloud.google.com/storage/docs/insights/using-inventory-reports#create-config-rest
   * for more details on how to set various fields.
   * Next ID: 12
   * </pre>
   *
   * Protobuf type {@code google.cloud.storageinsights.v1.ReportConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.storageinsights.v1.ReportConfig)
      com.google.cloud.storageinsights.v1.ReportConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.storageinsights.v1.V1Proto
          .internal_static_google_cloud_storageinsights_v1_ReportConfig_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 10:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 10:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.storageinsights.v1.V1Proto
          .internal_static_google_cloud_storageinsights_v1_ReportConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.storageinsights.v1.ReportConfig.class,
              com.google.cloud.storageinsights.v1.ReportConfig.Builder.class);
    }

    // Construct using com.google.cloud.storageinsights.v1.ReportConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      frequencyOptions_ = null;
      if (frequencyOptionsBuilder_ != null) {
        frequencyOptionsBuilder_.dispose();
        frequencyOptionsBuilder_ = null;
      }
      if (csvOptionsBuilder_ != null) {
        csvOptionsBuilder_.clear();
      }
      if (parquetOptionsBuilder_ != null) {
        parquetOptionsBuilder_.clear();
      }
      if (objectMetadataReportOptionsBuilder_ != null) {
        objectMetadataReportOptionsBuilder_.clear();
      }
      internalGetMutableLabels().clear();
      displayName_ = "";
      reportFormatCase_ = 0;
      reportFormat_ = null;
      reportKindCase_ = 0;
      reportKind_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.storageinsights.v1.V1Proto
          .internal_static_google_cloud_storageinsights_v1_ReportConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.storageinsights.v1.ReportConfig getDefaultInstanceForType() {
      return com.google.cloud.storageinsights.v1.ReportConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.storageinsights.v1.ReportConfig build() {
      com.google.cloud.storageinsights.v1.ReportConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.storageinsights.v1.ReportConfig buildPartial() {
      com.google.cloud.storageinsights.v1.ReportConfig result =
          new com.google.cloud.storageinsights.v1.ReportConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.storageinsights.v1.ReportConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.frequencyOptions_ =
            frequencyOptionsBuilder_ == null ? frequencyOptions_ : frequencyOptionsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.displayName_ = displayName_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.storageinsights.v1.ReportConfig result) {
      result.reportFormatCase_ = reportFormatCase_;
      result.reportFormat_ = this.reportFormat_;
      if (reportFormatCase_ == 6 && csvOptionsBuilder_ != null) {
        result.reportFormat_ = csvOptionsBuilder_.build();
      }
      if (reportFormatCase_ == 7 && parquetOptionsBuilder_ != null) {
        result.reportFormat_ = parquetOptionsBuilder_.build();
      }
      result.reportKindCase_ = reportKindCase_;
      result.reportKind_ = this.reportKind_;
      if (reportKindCase_ == 8 && objectMetadataReportOptionsBuilder_ != null) {
        result.reportKind_ = objectMetadataReportOptionsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.storageinsights.v1.ReportConfig) {
        return mergeFrom((com.google.cloud.storageinsights.v1.ReportConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.storageinsights.v1.ReportConfig other) {
      if (other == com.google.cloud.storageinsights.v1.ReportConfig.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasFrequencyOptions()) {
        mergeFrequencyOptions(other.getFrequencyOptions());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000080;
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      switch (other.getReportFormatCase()) {
        case CSV_OPTIONS:
          {
            mergeCsvOptions(other.getCsvOptions());
            break;
          }
        case PARQUET_OPTIONS:
          {
            mergeParquetOptions(other.getParquetOptions());
            break;
          }
        case REPORTFORMAT_NOT_SET:
          {
            break;
          }
      }
      switch (other.getReportKindCase()) {
        case OBJECT_METADATA_REPORT_OPTIONS:
          {
            mergeObjectMetadataReportOptions(other.getObjectMetadataReportOptions());
            break;
          }
        case REPORTKIND_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 42:
              {
                input.readMessage(
                    getFrequencyOptionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getCsvOptionsFieldBuilder().getBuilder(), extensionRegistry);
                reportFormatCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getParquetOptionsFieldBuilder().getBuilder(), extensionRegistry);
                reportFormatCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getObjectMetadataReportOptionsFieldBuilder().getBuilder(), extensionRegistry);
                reportKindCase_ = 8;
                break;
              } // case 66
            case 82:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000080;
                break;
              } // case 82
            case 90:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int reportFormatCase_ = 0;
    private java.lang.Object reportFormat_;

    public ReportFormatCase getReportFormatCase() {
      return ReportFormatCase.forNumber(reportFormatCase_);
    }

    public Builder clearReportFormat() {
      reportFormatCase_ = 0;
      reportFormat_ = null;
      onChanged();
      return this;
    }

    private int reportKindCase_ = 0;
    private java.lang.Object reportKind_;

    public ReportKindCase getReportKindCase() {
      return ReportKindCase.forNumber(reportKindCase_);
    }

    public Builder clearReportKind() {
      reportKindCase_ = 0;
      reportKind_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * name of resource. It will be of form
     * projects/&lt;project&gt;/locations/&lt;location&gt;/reportConfigs/&lt;report-config-id&gt;.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * name of resource. It will be of form
     * projects/&lt;project&gt;/locations/&lt;location&gt;/reportConfigs/&lt;report-config-id&gt;.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * name of resource. It will be of form
     * projects/&lt;project&gt;/locations/&lt;location&gt;/reportConfigs/&lt;report-config-id&gt;.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * name of resource. It will be of form
     * projects/&lt;project&gt;/locations/&lt;location&gt;/reportConfigs/&lt;report-config-id&gt;.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * name of resource. It will be of form
     * projects/&lt;project&gt;/locations/&lt;location&gt;/reportConfigs/&lt;report-config-id&gt;.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. [Output only] Create time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. [Output only] Create time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. [Output only] Create time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. [Output only] Create time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. [Output only] Create time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. [Output only] Create time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. [Output only] Create time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. [Output only] Create time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. [Output only] Create time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. [Output only] Update time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. [Output only] Update time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. [Output only] Update time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. [Output only] Update time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. [Output only] Update time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. [Output only] Update time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. [Output only] Update time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. [Output only] Update time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. [Output only] Update time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.cloud.storageinsights.v1.FrequencyOptions frequencyOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.storageinsights.v1.FrequencyOptions,
            com.google.cloud.storageinsights.v1.FrequencyOptions.Builder,
            com.google.cloud.storageinsights.v1.FrequencyOptionsOrBuilder>
        frequencyOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * The frequency of report generation.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.FrequencyOptions frequency_options = 5;</code>
     *
     * @return Whether the frequencyOptions field is set.
     */
    public boolean hasFrequencyOptions() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The frequency of report generation.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.FrequencyOptions frequency_options = 5;</code>
     *
     * @return The frequencyOptions.
     */
    public com.google.cloud.storageinsights.v1.FrequencyOptions getFrequencyOptions() {
      if (frequencyOptionsBuilder_ == null) {
        return frequencyOptions_ == null
            ? com.google.cloud.storageinsights.v1.FrequencyOptions.getDefaultInstance()
            : frequencyOptions_;
      } else {
        return frequencyOptionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The frequency of report generation.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.FrequencyOptions frequency_options = 5;</code>
     */
    public Builder setFrequencyOptions(com.google.cloud.storageinsights.v1.FrequencyOptions value) {
      if (frequencyOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        frequencyOptions_ = value;
      } else {
        frequencyOptionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The frequency of report generation.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.FrequencyOptions frequency_options = 5;</code>
     */
    public Builder setFrequencyOptions(
        com.google.cloud.storageinsights.v1.FrequencyOptions.Builder builderForValue) {
      if (frequencyOptionsBuilder_ == null) {
        frequencyOptions_ = builderForValue.build();
      } else {
        frequencyOptionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The frequency of report generation.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.FrequencyOptions frequency_options = 5;</code>
     */
    public Builder mergeFrequencyOptions(
        com.google.cloud.storageinsights.v1.FrequencyOptions value) {
      if (frequencyOptionsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && frequencyOptions_ != null
            && frequencyOptions_
                != com.google.cloud.storageinsights.v1.FrequencyOptions.getDefaultInstance()) {
          getFrequencyOptionsBuilder().mergeFrom(value);
        } else {
          frequencyOptions_ = value;
        }
      } else {
        frequencyOptionsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The frequency of report generation.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.FrequencyOptions frequency_options = 5;</code>
     */
    public Builder clearFrequencyOptions() {
      bitField0_ = (bitField0_ & ~0x00000008);
      frequencyOptions_ = null;
      if (frequencyOptionsBuilder_ != null) {
        frequencyOptionsBuilder_.dispose();
        frequencyOptionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The frequency of report generation.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.FrequencyOptions frequency_options = 5;</code>
     */
    public com.google.cloud.storageinsights.v1.FrequencyOptions.Builder
        getFrequencyOptionsBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getFrequencyOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The frequency of report generation.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.FrequencyOptions frequency_options = 5;</code>
     */
    public com.google.cloud.storageinsights.v1.FrequencyOptionsOrBuilder
        getFrequencyOptionsOrBuilder() {
      if (frequencyOptionsBuilder_ != null) {
        return frequencyOptionsBuilder_.getMessageOrBuilder();
      } else {
        return frequencyOptions_ == null
            ? com.google.cloud.storageinsights.v1.FrequencyOptions.getDefaultInstance()
            : frequencyOptions_;
      }
    }
    /**
     *
     *
     * <pre>
     * The frequency of report generation.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.FrequencyOptions frequency_options = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.storageinsights.v1.FrequencyOptions,
            com.google.cloud.storageinsights.v1.FrequencyOptions.Builder,
            com.google.cloud.storageinsights.v1.FrequencyOptionsOrBuilder>
        getFrequencyOptionsFieldBuilder() {
      if (frequencyOptionsBuilder_ == null) {
        frequencyOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.storageinsights.v1.FrequencyOptions,
                com.google.cloud.storageinsights.v1.FrequencyOptions.Builder,
                com.google.cloud.storageinsights.v1.FrequencyOptionsOrBuilder>(
                getFrequencyOptions(), getParentForChildren(), isClean());
        frequencyOptions_ = null;
      }
      return frequencyOptionsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.storageinsights.v1.CSVOptions,
            com.google.cloud.storageinsights.v1.CSVOptions.Builder,
            com.google.cloud.storageinsights.v1.CSVOptionsOrBuilder>
        csvOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * Options for CSV formatted reports.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.CSVOptions csv_options = 6;</code>
     *
     * @return Whether the csvOptions field is set.
     */
    @java.lang.Override
    public boolean hasCsvOptions() {
      return reportFormatCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Options for CSV formatted reports.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.CSVOptions csv_options = 6;</code>
     *
     * @return The csvOptions.
     */
    @java.lang.Override
    public com.google.cloud.storageinsights.v1.CSVOptions getCsvOptions() {
      if (csvOptionsBuilder_ == null) {
        if (reportFormatCase_ == 6) {
          return (com.google.cloud.storageinsights.v1.CSVOptions) reportFormat_;
        }
        return com.google.cloud.storageinsights.v1.CSVOptions.getDefaultInstance();
      } else {
        if (reportFormatCase_ == 6) {
          return csvOptionsBuilder_.getMessage();
        }
        return com.google.cloud.storageinsights.v1.CSVOptions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Options for CSV formatted reports.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.CSVOptions csv_options = 6;</code>
     */
    public Builder setCsvOptions(com.google.cloud.storageinsights.v1.CSVOptions value) {
      if (csvOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        reportFormat_ = value;
        onChanged();
      } else {
        csvOptionsBuilder_.setMessage(value);
      }
      reportFormatCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Options for CSV formatted reports.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.CSVOptions csv_options = 6;</code>
     */
    public Builder setCsvOptions(
        com.google.cloud.storageinsights.v1.CSVOptions.Builder builderForValue) {
      if (csvOptionsBuilder_ == null) {
        reportFormat_ = builderForValue.build();
        onChanged();
      } else {
        csvOptionsBuilder_.setMessage(builderForValue.build());
      }
      reportFormatCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Options for CSV formatted reports.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.CSVOptions csv_options = 6;</code>
     */
    public Builder mergeCsvOptions(com.google.cloud.storageinsights.v1.CSVOptions value) {
      if (csvOptionsBuilder_ == null) {
        if (reportFormatCase_ == 6
            && reportFormat_
                != com.google.cloud.storageinsights.v1.CSVOptions.getDefaultInstance()) {
          reportFormat_ =
              com.google.cloud.storageinsights.v1.CSVOptions.newBuilder(
                      (com.google.cloud.storageinsights.v1.CSVOptions) reportFormat_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          reportFormat_ = value;
        }
        onChanged();
      } else {
        if (reportFormatCase_ == 6) {
          csvOptionsBuilder_.mergeFrom(value);
        } else {
          csvOptionsBuilder_.setMessage(value);
        }
      }
      reportFormatCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Options for CSV formatted reports.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.CSVOptions csv_options = 6;</code>
     */
    public Builder clearCsvOptions() {
      if (csvOptionsBuilder_ == null) {
        if (reportFormatCase_ == 6) {
          reportFormatCase_ = 0;
          reportFormat_ = null;
          onChanged();
        }
      } else {
        if (reportFormatCase_ == 6) {
          reportFormatCase_ = 0;
          reportFormat_ = null;
        }
        csvOptionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Options for CSV formatted reports.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.CSVOptions csv_options = 6;</code>
     */
    public com.google.cloud.storageinsights.v1.CSVOptions.Builder getCsvOptionsBuilder() {
      return getCsvOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Options for CSV formatted reports.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.CSVOptions csv_options = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.storageinsights.v1.CSVOptionsOrBuilder getCsvOptionsOrBuilder() {
      if ((reportFormatCase_ == 6) && (csvOptionsBuilder_ != null)) {
        return csvOptionsBuilder_.getMessageOrBuilder();
      } else {
        if (reportFormatCase_ == 6) {
          return (com.google.cloud.storageinsights.v1.CSVOptions) reportFormat_;
        }
        return com.google.cloud.storageinsights.v1.CSVOptions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Options for CSV formatted reports.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.CSVOptions csv_options = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.storageinsights.v1.CSVOptions,
            com.google.cloud.storageinsights.v1.CSVOptions.Builder,
            com.google.cloud.storageinsights.v1.CSVOptionsOrBuilder>
        getCsvOptionsFieldBuilder() {
      if (csvOptionsBuilder_ == null) {
        if (!(reportFormatCase_ == 6)) {
          reportFormat_ = com.google.cloud.storageinsights.v1.CSVOptions.getDefaultInstance();
        }
        csvOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.storageinsights.v1.CSVOptions,
                com.google.cloud.storageinsights.v1.CSVOptions.Builder,
                com.google.cloud.storageinsights.v1.CSVOptionsOrBuilder>(
                (com.google.cloud.storageinsights.v1.CSVOptions) reportFormat_,
                getParentForChildren(),
                isClean());
        reportFormat_ = null;
      }
      reportFormatCase_ = 6;
      onChanged();
      return csvOptionsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.storageinsights.v1.ParquetOptions,
            com.google.cloud.storageinsights.v1.ParquetOptions.Builder,
            com.google.cloud.storageinsights.v1.ParquetOptionsOrBuilder>
        parquetOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * Options for Parquet formatted reports.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.ParquetOptions parquet_options = 7;</code>
     *
     * @return Whether the parquetOptions field is set.
     */
    @java.lang.Override
    public boolean hasParquetOptions() {
      return reportFormatCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Options for Parquet formatted reports.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.ParquetOptions parquet_options = 7;</code>
     *
     * @return The parquetOptions.
     */
    @java.lang.Override
    public com.google.cloud.storageinsights.v1.ParquetOptions getParquetOptions() {
      if (parquetOptionsBuilder_ == null) {
        if (reportFormatCase_ == 7) {
          return (com.google.cloud.storageinsights.v1.ParquetOptions) reportFormat_;
        }
        return com.google.cloud.storageinsights.v1.ParquetOptions.getDefaultInstance();
      } else {
        if (reportFormatCase_ == 7) {
          return parquetOptionsBuilder_.getMessage();
        }
        return com.google.cloud.storageinsights.v1.ParquetOptions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Options for Parquet formatted reports.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.ParquetOptions parquet_options = 7;</code>
     */
    public Builder setParquetOptions(com.google.cloud.storageinsights.v1.ParquetOptions value) {
      if (parquetOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        reportFormat_ = value;
        onChanged();
      } else {
        parquetOptionsBuilder_.setMessage(value);
      }
      reportFormatCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Options for Parquet formatted reports.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.ParquetOptions parquet_options = 7;</code>
     */
    public Builder setParquetOptions(
        com.google.cloud.storageinsights.v1.ParquetOptions.Builder builderForValue) {
      if (parquetOptionsBuilder_ == null) {
        reportFormat_ = builderForValue.build();
        onChanged();
      } else {
        parquetOptionsBuilder_.setMessage(builderForValue.build());
      }
      reportFormatCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Options for Parquet formatted reports.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.ParquetOptions parquet_options = 7;</code>
     */
    public Builder mergeParquetOptions(com.google.cloud.storageinsights.v1.ParquetOptions value) {
      if (parquetOptionsBuilder_ == null) {
        if (reportFormatCase_ == 7
            && reportFormat_
                != com.google.cloud.storageinsights.v1.ParquetOptions.getDefaultInstance()) {
          reportFormat_ =
              com.google.cloud.storageinsights.v1.ParquetOptions.newBuilder(
                      (com.google.cloud.storageinsights.v1.ParquetOptions) reportFormat_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          reportFormat_ = value;
        }
        onChanged();
      } else {
        if (reportFormatCase_ == 7) {
          parquetOptionsBuilder_.mergeFrom(value);
        } else {
          parquetOptionsBuilder_.setMessage(value);
        }
      }
      reportFormatCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Options for Parquet formatted reports.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.ParquetOptions parquet_options = 7;</code>
     */
    public Builder clearParquetOptions() {
      if (parquetOptionsBuilder_ == null) {
        if (reportFormatCase_ == 7) {
          reportFormatCase_ = 0;
          reportFormat_ = null;
          onChanged();
        }
      } else {
        if (reportFormatCase_ == 7) {
          reportFormatCase_ = 0;
          reportFormat_ = null;
        }
        parquetOptionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Options for Parquet formatted reports.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.ParquetOptions parquet_options = 7;</code>
     */
    public com.google.cloud.storageinsights.v1.ParquetOptions.Builder getParquetOptionsBuilder() {
      return getParquetOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Options for Parquet formatted reports.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.ParquetOptions parquet_options = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.storageinsights.v1.ParquetOptionsOrBuilder
        getParquetOptionsOrBuilder() {
      if ((reportFormatCase_ == 7) && (parquetOptionsBuilder_ != null)) {
        return parquetOptionsBuilder_.getMessageOrBuilder();
      } else {
        if (reportFormatCase_ == 7) {
          return (com.google.cloud.storageinsights.v1.ParquetOptions) reportFormat_;
        }
        return com.google.cloud.storageinsights.v1.ParquetOptions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Options for Parquet formatted reports.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.ParquetOptions parquet_options = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.storageinsights.v1.ParquetOptions,
            com.google.cloud.storageinsights.v1.ParquetOptions.Builder,
            com.google.cloud.storageinsights.v1.ParquetOptionsOrBuilder>
        getParquetOptionsFieldBuilder() {
      if (parquetOptionsBuilder_ == null) {
        if (!(reportFormatCase_ == 7)) {
          reportFormat_ = com.google.cloud.storageinsights.v1.ParquetOptions.getDefaultInstance();
        }
        parquetOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.storageinsights.v1.ParquetOptions,
                com.google.cloud.storageinsights.v1.ParquetOptions.Builder,
                com.google.cloud.storageinsights.v1.ParquetOptionsOrBuilder>(
                (com.google.cloud.storageinsights.v1.ParquetOptions) reportFormat_,
                getParentForChildren(),
                isClean());
        reportFormat_ = null;
      }
      reportFormatCase_ = 7;
      onChanged();
      return parquetOptionsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions,
            com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions.Builder,
            com.google.cloud.storageinsights.v1.ObjectMetadataReportOptionsOrBuilder>
        objectMetadataReportOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * Report for exporting object metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.storageinsights.v1.ObjectMetadataReportOptions object_metadata_report_options = 8;
     * </code>
     *
     * @return Whether the objectMetadataReportOptions field is set.
     */
    @java.lang.Override
    public boolean hasObjectMetadataReportOptions() {
      return reportKindCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Report for exporting object metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.storageinsights.v1.ObjectMetadataReportOptions object_metadata_report_options = 8;
     * </code>
     *
     * @return The objectMetadataReportOptions.
     */
    @java.lang.Override
    public com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions
        getObjectMetadataReportOptions() {
      if (objectMetadataReportOptionsBuilder_ == null) {
        if (reportKindCase_ == 8) {
          return (com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions) reportKind_;
        }
        return com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions.getDefaultInstance();
      } else {
        if (reportKindCase_ == 8) {
          return objectMetadataReportOptionsBuilder_.getMessage();
        }
        return com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Report for exporting object metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.storageinsights.v1.ObjectMetadataReportOptions object_metadata_report_options = 8;
     * </code>
     */
    public Builder setObjectMetadataReportOptions(
        com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions value) {
      if (objectMetadataReportOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        reportKind_ = value;
        onChanged();
      } else {
        objectMetadataReportOptionsBuilder_.setMessage(value);
      }
      reportKindCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Report for exporting object metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.storageinsights.v1.ObjectMetadataReportOptions object_metadata_report_options = 8;
     * </code>
     */
    public Builder setObjectMetadataReportOptions(
        com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions.Builder builderForValue) {
      if (objectMetadataReportOptionsBuilder_ == null) {
        reportKind_ = builderForValue.build();
        onChanged();
      } else {
        objectMetadataReportOptionsBuilder_.setMessage(builderForValue.build());
      }
      reportKindCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Report for exporting object metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.storageinsights.v1.ObjectMetadataReportOptions object_metadata_report_options = 8;
     * </code>
     */
    public Builder mergeObjectMetadataReportOptions(
        com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions value) {
      if (objectMetadataReportOptionsBuilder_ == null) {
        if (reportKindCase_ == 8
            && reportKind_
                != com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions
                    .getDefaultInstance()) {
          reportKind_ =
              com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions.newBuilder(
                      (com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions) reportKind_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          reportKind_ = value;
        }
        onChanged();
      } else {
        if (reportKindCase_ == 8) {
          objectMetadataReportOptionsBuilder_.mergeFrom(value);
        } else {
          objectMetadataReportOptionsBuilder_.setMessage(value);
        }
      }
      reportKindCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Report for exporting object metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.storageinsights.v1.ObjectMetadataReportOptions object_metadata_report_options = 8;
     * </code>
     */
    public Builder clearObjectMetadataReportOptions() {
      if (objectMetadataReportOptionsBuilder_ == null) {
        if (reportKindCase_ == 8) {
          reportKindCase_ = 0;
          reportKind_ = null;
          onChanged();
        }
      } else {
        if (reportKindCase_ == 8) {
          reportKindCase_ = 0;
          reportKind_ = null;
        }
        objectMetadataReportOptionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Report for exporting object metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.storageinsights.v1.ObjectMetadataReportOptions object_metadata_report_options = 8;
     * </code>
     */
    public com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions.Builder
        getObjectMetadataReportOptionsBuilder() {
      return getObjectMetadataReportOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Report for exporting object metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.storageinsights.v1.ObjectMetadataReportOptions object_metadata_report_options = 8;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.storageinsights.v1.ObjectMetadataReportOptionsOrBuilder
        getObjectMetadataReportOptionsOrBuilder() {
      if ((reportKindCase_ == 8) && (objectMetadataReportOptionsBuilder_ != null)) {
        return objectMetadataReportOptionsBuilder_.getMessageOrBuilder();
      } else {
        if (reportKindCase_ == 8) {
          return (com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions) reportKind_;
        }
        return com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Report for exporting object metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.storageinsights.v1.ObjectMetadataReportOptions object_metadata_report_options = 8;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions,
            com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions.Builder,
            com.google.cloud.storageinsights.v1.ObjectMetadataReportOptionsOrBuilder>
        getObjectMetadataReportOptionsFieldBuilder() {
      if (objectMetadataReportOptionsBuilder_ == null) {
        if (!(reportKindCase_ == 8)) {
          reportKind_ =
              com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions.getDefaultInstance();
        }
        objectMetadataReportOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions,
                com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions.Builder,
                com.google.cloud.storageinsights.v1.ObjectMetadataReportOptionsOrBuilder>(
                (com.google.cloud.storageinsights.v1.ObjectMetadataReportOptions) reportKind_,
                getParentForChildren(),
                isClean());
        reportKind_ = null;
      }
      reportKindCase_ = 8;
      onChanged();
      return objectMetadataReportOptionsBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000080);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000080;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000080;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000080;
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * User provided display name which can be empty and limited to 256 characters
     * that is editable.
     * </pre>
     *
     * <code>string display_name = 11;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User provided display name which can be empty and limited to 256 characters
     * that is editable.
     * </pre>
     *
     * <code>string display_name = 11;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User provided display name which can be empty and limited to 256 characters
     * that is editable.
     * </pre>
     *
     * <code>string display_name = 11;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User provided display name which can be empty and limited to 256 characters
     * that is editable.
     * </pre>
     *
     * <code>string display_name = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User provided display name which can be empty and limited to 256 characters
     * that is editable.
     * </pre>
     *
     * <code>string display_name = 11;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.storageinsights.v1.ReportConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.storageinsights.v1.ReportConfig)
  private static final com.google.cloud.storageinsights.v1.ReportConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.storageinsights.v1.ReportConfig();
  }

  public static com.google.cloud.storageinsights.v1.ReportConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReportConfig> PARSER =
      new com.google.protobuf.AbstractParser<ReportConfig>() {
        @java.lang.Override
        public ReportConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ReportConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReportConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.storageinsights.v1.ReportConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
