/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/storageinsights/v1/storageinsights.proto

package com.google.cloud.storageinsights.v1;

/**
 *
 *
 * <pre>
 * Message describing ReportDetail object. ReportDetail represents metadata of
 * generated reports for a ReportConfig.
 * Next ID: 10
 * </pre>
 *
 * Protobuf type {@code google.cloud.storageinsights.v1.ReportDetail}
 */
public final class ReportDetail extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.storageinsights.v1.ReportDetail)
    ReportDetailOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ReportDetail.newBuilder() to construct.
  private ReportDetail(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReportDetail() {
    name_ = "";
    reportPathPrefix_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReportDetail();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.storageinsights.v1.V1Proto
        .internal_static_google_cloud_storageinsights_v1_ReportDetail_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 5:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.storageinsights.v1.V1Proto
        .internal_static_google_cloud_storageinsights_v1_ReportDetail_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.storageinsights.v1.ReportDetail.class,
            com.google.cloud.storageinsights.v1.ReportDetail.Builder.class);
  }

  public interface MetricsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.storageinsights.v1.ReportDetail.Metrics)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Count of Cloud Storage objects which are part of the report.
     * </pre>
     *
     * <code>int64 processed_records_count = 1;</code>
     *
     * @return The processedRecordsCount.
     */
    long getProcessedRecordsCount();
  }
  /**
   *
   *
   * <pre>
   * Different metrics associated with the generated report.
   * </pre>
   *
   * Protobuf type {@code google.cloud.storageinsights.v1.ReportDetail.Metrics}
   */
  public static final class Metrics extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.storageinsights.v1.ReportDetail.Metrics)
      MetricsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Metrics.newBuilder() to construct.
    private Metrics(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Metrics() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Metrics();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.storageinsights.v1.V1Proto
          .internal_static_google_cloud_storageinsights_v1_ReportDetail_Metrics_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.storageinsights.v1.V1Proto
          .internal_static_google_cloud_storageinsights_v1_ReportDetail_Metrics_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.storageinsights.v1.ReportDetail.Metrics.class,
              com.google.cloud.storageinsights.v1.ReportDetail.Metrics.Builder.class);
    }

    public static final int PROCESSED_RECORDS_COUNT_FIELD_NUMBER = 1;
    private long processedRecordsCount_ = 0L;
    /**
     *
     *
     * <pre>
     * Count of Cloud Storage objects which are part of the report.
     * </pre>
     *
     * <code>int64 processed_records_count = 1;</code>
     *
     * @return The processedRecordsCount.
     */
    @java.lang.Override
    public long getProcessedRecordsCount() {
      return processedRecordsCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (processedRecordsCount_ != 0L) {
        output.writeInt64(1, processedRecordsCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (processedRecordsCount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, processedRecordsCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.storageinsights.v1.ReportDetail.Metrics)) {
        return super.equals(obj);
      }
      com.google.cloud.storageinsights.v1.ReportDetail.Metrics other =
          (com.google.cloud.storageinsights.v1.ReportDetail.Metrics) obj;

      if (getProcessedRecordsCount() != other.getProcessedRecordsCount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PROCESSED_RECORDS_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getProcessedRecordsCount());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.storageinsights.v1.ReportDetail.Metrics parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.storageinsights.v1.ReportDetail.Metrics parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.storageinsights.v1.ReportDetail.Metrics parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.storageinsights.v1.ReportDetail.Metrics parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.storageinsights.v1.ReportDetail.Metrics parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.storageinsights.v1.ReportDetail.Metrics parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.storageinsights.v1.ReportDetail.Metrics parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.storageinsights.v1.ReportDetail.Metrics parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.storageinsights.v1.ReportDetail.Metrics parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.storageinsights.v1.ReportDetail.Metrics parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.storageinsights.v1.ReportDetail.Metrics parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.storageinsights.v1.ReportDetail.Metrics parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.storageinsights.v1.ReportDetail.Metrics prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Different metrics associated with the generated report.
     * </pre>
     *
     * Protobuf type {@code google.cloud.storageinsights.v1.ReportDetail.Metrics}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.storageinsights.v1.ReportDetail.Metrics)
        com.google.cloud.storageinsights.v1.ReportDetail.MetricsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.storageinsights.v1.V1Proto
            .internal_static_google_cloud_storageinsights_v1_ReportDetail_Metrics_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.storageinsights.v1.V1Proto
            .internal_static_google_cloud_storageinsights_v1_ReportDetail_Metrics_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.storageinsights.v1.ReportDetail.Metrics.class,
                com.google.cloud.storageinsights.v1.ReportDetail.Metrics.Builder.class);
      }

      // Construct using com.google.cloud.storageinsights.v1.ReportDetail.Metrics.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        processedRecordsCount_ = 0L;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.storageinsights.v1.V1Proto
            .internal_static_google_cloud_storageinsights_v1_ReportDetail_Metrics_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.storageinsights.v1.ReportDetail.Metrics getDefaultInstanceForType() {
        return com.google.cloud.storageinsights.v1.ReportDetail.Metrics.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.storageinsights.v1.ReportDetail.Metrics build() {
        com.google.cloud.storageinsights.v1.ReportDetail.Metrics result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.storageinsights.v1.ReportDetail.Metrics buildPartial() {
        com.google.cloud.storageinsights.v1.ReportDetail.Metrics result =
            new com.google.cloud.storageinsights.v1.ReportDetail.Metrics(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.storageinsights.v1.ReportDetail.Metrics result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.processedRecordsCount_ = processedRecordsCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.storageinsights.v1.ReportDetail.Metrics) {
          return mergeFrom((com.google.cloud.storageinsights.v1.ReportDetail.Metrics) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.storageinsights.v1.ReportDetail.Metrics other) {
        if (other == com.google.cloud.storageinsights.v1.ReportDetail.Metrics.getDefaultInstance())
          return this;
        if (other.getProcessedRecordsCount() != 0L) {
          setProcessedRecordsCount(other.getProcessedRecordsCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  processedRecordsCount_ = input.readInt64();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private long processedRecordsCount_;
      /**
       *
       *
       * <pre>
       * Count of Cloud Storage objects which are part of the report.
       * </pre>
       *
       * <code>int64 processed_records_count = 1;</code>
       *
       * @return The processedRecordsCount.
       */
      @java.lang.Override
      public long getProcessedRecordsCount() {
        return processedRecordsCount_;
      }
      /**
       *
       *
       * <pre>
       * Count of Cloud Storage objects which are part of the report.
       * </pre>
       *
       * <code>int64 processed_records_count = 1;</code>
       *
       * @param value The processedRecordsCount to set.
       * @return This builder for chaining.
       */
      public Builder setProcessedRecordsCount(long value) {

        processedRecordsCount_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Count of Cloud Storage objects which are part of the report.
       * </pre>
       *
       * <code>int64 processed_records_count = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearProcessedRecordsCount() {
        bitField0_ = (bitField0_ & ~0x00000001);
        processedRecordsCount_ = 0L;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.storageinsights.v1.ReportDetail.Metrics)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.storageinsights.v1.ReportDetail.Metrics)
    private static final com.google.cloud.storageinsights.v1.ReportDetail.Metrics DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.storageinsights.v1.ReportDetail.Metrics();
    }

    public static com.google.cloud.storageinsights.v1.ReportDetail.Metrics getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Metrics> PARSER =
        new com.google.protobuf.AbstractParser<Metrics>() {
          @java.lang.Override
          public Metrics parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Metrics> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Metrics> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.storageinsights.v1.ReportDetail.Metrics getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Name of resource. It will be of form
   * projects/&lt;project&gt;/locations/&lt;location&gt;/reportConfigs/&lt;report-config-id&gt;/reportDetails/&lt;report-detail-id&gt;.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of resource. It will be of form
   * projects/&lt;project&gt;/locations/&lt;location&gt;/reportConfigs/&lt;report-config-id&gt;/reportDetails/&lt;report-detail-id&gt;.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SNAPSHOT_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp snapshotTime_;
  /**
   *
   *
   * <pre>
   * The snapshot time.
   * All the report data is referenced at this point of time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp snapshot_time = 2;</code>
   *
   * @return Whether the snapshotTime field is set.
   */
  @java.lang.Override
  public boolean hasSnapshotTime() {
    return snapshotTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The snapshot time.
   * All the report data is referenced at this point of time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp snapshot_time = 2;</code>
   *
   * @return The snapshotTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getSnapshotTime() {
    return snapshotTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : snapshotTime_;
  }
  /**
   *
   *
   * <pre>
   * The snapshot time.
   * All the report data is referenced at this point of time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp snapshot_time = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getSnapshotTimeOrBuilder() {
    return snapshotTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : snapshotTime_;
  }

  public static final int REPORT_PATH_PREFIX_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object reportPathPrefix_ = "";
  /**
   *
   *
   * <pre>
   * Prefix of the object name of each report's shard. This will have full
   * prefix except the "extension" and "shard_id".
   * For example, if the `destination_path` is
   * `{{report-config-id}}/dt={{datetime}}`, the shard object name would be
   * `gs://my-insights/1A34-F2E456-12B456-1C3D/dt=2022-05-20T06:35/1A34-F2E456-12B456-1C3D_2022-05-20T06:35_5.csv`
   * and the value of `report_path_prefix` field would be
   * `gs://my-insights/1A34-F2E456-12B456-1C3D/dt=2022-05-20T06:35/1A34-F2E456-12B456-1C3D_2022-05-20T06:35_`.
   * </pre>
   *
   * <code>string report_path_prefix = 8;</code>
   *
   * @return The reportPathPrefix.
   */
  @java.lang.Override
  public java.lang.String getReportPathPrefix() {
    java.lang.Object ref = reportPathPrefix_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      reportPathPrefix_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Prefix of the object name of each report's shard. This will have full
   * prefix except the "extension" and "shard_id".
   * For example, if the `destination_path` is
   * `{{report-config-id}}/dt={{datetime}}`, the shard object name would be
   * `gs://my-insights/1A34-F2E456-12B456-1C3D/dt=2022-05-20T06:35/1A34-F2E456-12B456-1C3D_2022-05-20T06:35_5.csv`
   * and the value of `report_path_prefix` field would be
   * `gs://my-insights/1A34-F2E456-12B456-1C3D/dt=2022-05-20T06:35/1A34-F2E456-12B456-1C3D_2022-05-20T06:35_`.
   * </pre>
   *
   * <code>string report_path_prefix = 8;</code>
   *
   * @return The bytes for reportPathPrefix.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getReportPathPrefixBytes() {
    java.lang.Object ref = reportPathPrefix_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      reportPathPrefix_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SHARDS_COUNT_FIELD_NUMBER = 9;
  private long shardsCount_ = 0L;
  /**
   *
   *
   * <pre>
   * Total shards generated for the report.
   * </pre>
   *
   * <code>int64 shards_count = 9;</code>
   *
   * @return The shardsCount.
   */
  @java.lang.Override
  public long getShardsCount() {
    return shardsCount_;
  }

  public static final int STATUS_FIELD_NUMBER = 4;
  private com.google.rpc.Status status_;
  /**
   *
   *
   * <pre>
   * Status of the ReportDetail.
   * </pre>
   *
   * <code>.google.rpc.Status status = 4;</code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return status_ != null;
  }
  /**
   *
   *
   * <pre>
   * Status of the ReportDetail.
   * </pre>
   *
   * <code>.google.rpc.Status status = 4;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public com.google.rpc.Status getStatus() {
    return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
  }
  /**
   *
   *
   * <pre>
   * Status of the ReportDetail.
   * </pre>
   *
   * <code>.google.rpc.Status status = 4;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getStatusOrBuilder() {
    return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
  }

  public static final int LABELS_FIELD_NUMBER = 5;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.storageinsights.v1.V1Proto
                .internal_static_google_cloud_storageinsights_v1_ReportDetail_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels as key value pairs
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels as key value pairs
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels as key value pairs
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels as key value pairs
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int TARGET_DATETIME_FIELD_NUMBER = 6;
  private com.google.type.DateTime targetDatetime_;
  /**
   *
   *
   * <pre>
   * The date for which report is generated. The time part of target_datetime
   * will be zero till we support multiple reports per day.
   * </pre>
   *
   * <code>.google.type.DateTime target_datetime = 6;</code>
   *
   * @return Whether the targetDatetime field is set.
   */
  @java.lang.Override
  public boolean hasTargetDatetime() {
    return targetDatetime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The date for which report is generated. The time part of target_datetime
   * will be zero till we support multiple reports per day.
   * </pre>
   *
   * <code>.google.type.DateTime target_datetime = 6;</code>
   *
   * @return The targetDatetime.
   */
  @java.lang.Override
  public com.google.type.DateTime getTargetDatetime() {
    return targetDatetime_ == null
        ? com.google.type.DateTime.getDefaultInstance()
        : targetDatetime_;
  }
  /**
   *
   *
   * <pre>
   * The date for which report is generated. The time part of target_datetime
   * will be zero till we support multiple reports per day.
   * </pre>
   *
   * <code>.google.type.DateTime target_datetime = 6;</code>
   */
  @java.lang.Override
  public com.google.type.DateTimeOrBuilder getTargetDatetimeOrBuilder() {
    return targetDatetime_ == null
        ? com.google.type.DateTime.getDefaultInstance()
        : targetDatetime_;
  }

  public static final int REPORT_METRICS_FIELD_NUMBER = 7;
  private com.google.cloud.storageinsights.v1.ReportDetail.Metrics reportMetrics_;
  /**
   *
   *
   * <pre>
   * Metrics of the report.
   * </pre>
   *
   * <code>.google.cloud.storageinsights.v1.ReportDetail.Metrics report_metrics = 7;</code>
   *
   * @return Whether the reportMetrics field is set.
   */
  @java.lang.Override
  public boolean hasReportMetrics() {
    return reportMetrics_ != null;
  }
  /**
   *
   *
   * <pre>
   * Metrics of the report.
   * </pre>
   *
   * <code>.google.cloud.storageinsights.v1.ReportDetail.Metrics report_metrics = 7;</code>
   *
   * @return The reportMetrics.
   */
  @java.lang.Override
  public com.google.cloud.storageinsights.v1.ReportDetail.Metrics getReportMetrics() {
    return reportMetrics_ == null
        ? com.google.cloud.storageinsights.v1.ReportDetail.Metrics.getDefaultInstance()
        : reportMetrics_;
  }
  /**
   *
   *
   * <pre>
   * Metrics of the report.
   * </pre>
   *
   * <code>.google.cloud.storageinsights.v1.ReportDetail.Metrics report_metrics = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.storageinsights.v1.ReportDetail.MetricsOrBuilder
      getReportMetricsOrBuilder() {
    return reportMetrics_ == null
        ? com.google.cloud.storageinsights.v1.ReportDetail.Metrics.getDefaultInstance()
        : reportMetrics_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (snapshotTime_ != null) {
      output.writeMessage(2, getSnapshotTime());
    }
    if (status_ != null) {
      output.writeMessage(4, getStatus());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 5);
    if (targetDatetime_ != null) {
      output.writeMessage(6, getTargetDatetime());
    }
    if (reportMetrics_ != null) {
      output.writeMessage(7, getReportMetrics());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(reportPathPrefix_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, reportPathPrefix_);
    }
    if (shardsCount_ != 0L) {
      output.writeInt64(9, shardsCount_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (snapshotTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSnapshotTime());
    }
    if (status_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getStatus());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, labels__);
    }
    if (targetDatetime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getTargetDatetime());
    }
    if (reportMetrics_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getReportMetrics());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(reportPathPrefix_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, reportPathPrefix_);
    }
    if (shardsCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(9, shardsCount_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.storageinsights.v1.ReportDetail)) {
      return super.equals(obj);
    }
    com.google.cloud.storageinsights.v1.ReportDetail other =
        (com.google.cloud.storageinsights.v1.ReportDetail) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasSnapshotTime() != other.hasSnapshotTime()) return false;
    if (hasSnapshotTime()) {
      if (!getSnapshotTime().equals(other.getSnapshotTime())) return false;
    }
    if (!getReportPathPrefix().equals(other.getReportPathPrefix())) return false;
    if (getShardsCount() != other.getShardsCount()) return false;
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasTargetDatetime() != other.hasTargetDatetime()) return false;
    if (hasTargetDatetime()) {
      if (!getTargetDatetime().equals(other.getTargetDatetime())) return false;
    }
    if (hasReportMetrics() != other.hasReportMetrics()) return false;
    if (hasReportMetrics()) {
      if (!getReportMetrics().equals(other.getReportMetrics())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasSnapshotTime()) {
      hash = (37 * hash) + SNAPSHOT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getSnapshotTime().hashCode();
    }
    hash = (37 * hash) + REPORT_PATH_PREFIX_FIELD_NUMBER;
    hash = (53 * hash) + getReportPathPrefix().hashCode();
    hash = (37 * hash) + SHARDS_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getShardsCount());
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasTargetDatetime()) {
      hash = (37 * hash) + TARGET_DATETIME_FIELD_NUMBER;
      hash = (53 * hash) + getTargetDatetime().hashCode();
    }
    if (hasReportMetrics()) {
      hash = (37 * hash) + REPORT_METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getReportMetrics().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.storageinsights.v1.ReportDetail parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.storageinsights.v1.ReportDetail parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.storageinsights.v1.ReportDetail parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.storageinsights.v1.ReportDetail parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.storageinsights.v1.ReportDetail parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.storageinsights.v1.ReportDetail parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.storageinsights.v1.ReportDetail parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.storageinsights.v1.ReportDetail parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.storageinsights.v1.ReportDetail parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.storageinsights.v1.ReportDetail parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.storageinsights.v1.ReportDetail parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.storageinsights.v1.ReportDetail parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.storageinsights.v1.ReportDetail prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Message describing ReportDetail object. ReportDetail represents metadata of
   * generated reports for a ReportConfig.
   * Next ID: 10
   * </pre>
   *
   * Protobuf type {@code google.cloud.storageinsights.v1.ReportDetail}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.storageinsights.v1.ReportDetail)
      com.google.cloud.storageinsights.v1.ReportDetailOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.storageinsights.v1.V1Proto
          .internal_static_google_cloud_storageinsights_v1_ReportDetail_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 5:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 5:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.storageinsights.v1.V1Proto
          .internal_static_google_cloud_storageinsights_v1_ReportDetail_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.storageinsights.v1.ReportDetail.class,
              com.google.cloud.storageinsights.v1.ReportDetail.Builder.class);
    }

    // Construct using com.google.cloud.storageinsights.v1.ReportDetail.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      snapshotTime_ = null;
      if (snapshotTimeBuilder_ != null) {
        snapshotTimeBuilder_.dispose();
        snapshotTimeBuilder_ = null;
      }
      reportPathPrefix_ = "";
      shardsCount_ = 0L;
      status_ = null;
      if (statusBuilder_ != null) {
        statusBuilder_.dispose();
        statusBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      targetDatetime_ = null;
      if (targetDatetimeBuilder_ != null) {
        targetDatetimeBuilder_.dispose();
        targetDatetimeBuilder_ = null;
      }
      reportMetrics_ = null;
      if (reportMetricsBuilder_ != null) {
        reportMetricsBuilder_.dispose();
        reportMetricsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.storageinsights.v1.V1Proto
          .internal_static_google_cloud_storageinsights_v1_ReportDetail_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.storageinsights.v1.ReportDetail getDefaultInstanceForType() {
      return com.google.cloud.storageinsights.v1.ReportDetail.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.storageinsights.v1.ReportDetail build() {
      com.google.cloud.storageinsights.v1.ReportDetail result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.storageinsights.v1.ReportDetail buildPartial() {
      com.google.cloud.storageinsights.v1.ReportDetail result =
          new com.google.cloud.storageinsights.v1.ReportDetail(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.storageinsights.v1.ReportDetail result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.snapshotTime_ =
            snapshotTimeBuilder_ == null ? snapshotTime_ : snapshotTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.reportPathPrefix_ = reportPathPrefix_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.shardsCount_ = shardsCount_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.status_ = statusBuilder_ == null ? status_ : statusBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.targetDatetime_ =
            targetDatetimeBuilder_ == null ? targetDatetime_ : targetDatetimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.reportMetrics_ =
            reportMetricsBuilder_ == null ? reportMetrics_ : reportMetricsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.storageinsights.v1.ReportDetail) {
        return mergeFrom((com.google.cloud.storageinsights.v1.ReportDetail) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.storageinsights.v1.ReportDetail other) {
      if (other == com.google.cloud.storageinsights.v1.ReportDetail.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasSnapshotTime()) {
        mergeSnapshotTime(other.getSnapshotTime());
      }
      if (!other.getReportPathPrefix().isEmpty()) {
        reportPathPrefix_ = other.reportPathPrefix_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.getShardsCount() != 0L) {
        setShardsCount(other.getShardsCount());
      }
      if (other.hasStatus()) {
        mergeStatus(other.getStatus());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000020;
      if (other.hasTargetDatetime()) {
        mergeTargetDatetime(other.getTargetDatetime());
      }
      if (other.hasReportMetrics()) {
        mergeReportMetrics(other.getReportMetrics());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getSnapshotTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 34:
              {
                input.readMessage(getStatusFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getTargetDatetimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getReportMetricsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 66:
              {
                reportPathPrefix_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 66
            case 72:
              {
                shardsCount_ = input.readInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case 72
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Name of resource. It will be of form
     * projects/&lt;project&gt;/locations/&lt;location&gt;/reportConfigs/&lt;report-config-id&gt;/reportDetails/&lt;report-detail-id&gt;.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of resource. It will be of form
     * projects/&lt;project&gt;/locations/&lt;location&gt;/reportConfigs/&lt;report-config-id&gt;/reportDetails/&lt;report-detail-id&gt;.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of resource. It will be of form
     * projects/&lt;project&gt;/locations/&lt;location&gt;/reportConfigs/&lt;report-config-id&gt;/reportDetails/&lt;report-detail-id&gt;.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of resource. It will be of form
     * projects/&lt;project&gt;/locations/&lt;location&gt;/reportConfigs/&lt;report-config-id&gt;/reportDetails/&lt;report-detail-id&gt;.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of resource. It will be of form
     * projects/&lt;project&gt;/locations/&lt;location&gt;/reportConfigs/&lt;report-config-id&gt;/reportDetails/&lt;report-detail-id&gt;.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp snapshotTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        snapshotTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The snapshot time.
     * All the report data is referenced at this point of time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 2;</code>
     *
     * @return Whether the snapshotTime field is set.
     */
    public boolean hasSnapshotTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The snapshot time.
     * All the report data is referenced at this point of time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 2;</code>
     *
     * @return The snapshotTime.
     */
    public com.google.protobuf.Timestamp getSnapshotTime() {
      if (snapshotTimeBuilder_ == null) {
        return snapshotTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : snapshotTime_;
      } else {
        return snapshotTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The snapshot time.
     * All the report data is referenced at this point of time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 2;</code>
     */
    public Builder setSnapshotTime(com.google.protobuf.Timestamp value) {
      if (snapshotTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        snapshotTime_ = value;
      } else {
        snapshotTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The snapshot time.
     * All the report data is referenced at this point of time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 2;</code>
     */
    public Builder setSnapshotTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (snapshotTimeBuilder_ == null) {
        snapshotTime_ = builderForValue.build();
      } else {
        snapshotTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The snapshot time.
     * All the report data is referenced at this point of time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 2;</code>
     */
    public Builder mergeSnapshotTime(com.google.protobuf.Timestamp value) {
      if (snapshotTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && snapshotTime_ != null
            && snapshotTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getSnapshotTimeBuilder().mergeFrom(value);
        } else {
          snapshotTime_ = value;
        }
      } else {
        snapshotTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The snapshot time.
     * All the report data is referenced at this point of time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 2;</code>
     */
    public Builder clearSnapshotTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      snapshotTime_ = null;
      if (snapshotTimeBuilder_ != null) {
        snapshotTimeBuilder_.dispose();
        snapshotTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The snapshot time.
     * All the report data is referenced at this point of time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getSnapshotTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getSnapshotTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The snapshot time.
     * All the report data is referenced at this point of time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 2;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getSnapshotTimeOrBuilder() {
      if (snapshotTimeBuilder_ != null) {
        return snapshotTimeBuilder_.getMessageOrBuilder();
      } else {
        return snapshotTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : snapshotTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The snapshot time.
     * All the report data is referenced at this point of time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getSnapshotTimeFieldBuilder() {
      if (snapshotTimeBuilder_ == null) {
        snapshotTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getSnapshotTime(), getParentForChildren(), isClean());
        snapshotTime_ = null;
      }
      return snapshotTimeBuilder_;
    }

    private java.lang.Object reportPathPrefix_ = "";
    /**
     *
     *
     * <pre>
     * Prefix of the object name of each report's shard. This will have full
     * prefix except the "extension" and "shard_id".
     * For example, if the `destination_path` is
     * `{{report-config-id}}/dt={{datetime}}`, the shard object name would be
     * `gs://my-insights/1A34-F2E456-12B456-1C3D/dt=2022-05-20T06:35/1A34-F2E456-12B456-1C3D_2022-05-20T06:35_5.csv`
     * and the value of `report_path_prefix` field would be
     * `gs://my-insights/1A34-F2E456-12B456-1C3D/dt=2022-05-20T06:35/1A34-F2E456-12B456-1C3D_2022-05-20T06:35_`.
     * </pre>
     *
     * <code>string report_path_prefix = 8;</code>
     *
     * @return The reportPathPrefix.
     */
    public java.lang.String getReportPathPrefix() {
      java.lang.Object ref = reportPathPrefix_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        reportPathPrefix_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Prefix of the object name of each report's shard. This will have full
     * prefix except the "extension" and "shard_id".
     * For example, if the `destination_path` is
     * `{{report-config-id}}/dt={{datetime}}`, the shard object name would be
     * `gs://my-insights/1A34-F2E456-12B456-1C3D/dt=2022-05-20T06:35/1A34-F2E456-12B456-1C3D_2022-05-20T06:35_5.csv`
     * and the value of `report_path_prefix` field would be
     * `gs://my-insights/1A34-F2E456-12B456-1C3D/dt=2022-05-20T06:35/1A34-F2E456-12B456-1C3D_2022-05-20T06:35_`.
     * </pre>
     *
     * <code>string report_path_prefix = 8;</code>
     *
     * @return The bytes for reportPathPrefix.
     */
    public com.google.protobuf.ByteString getReportPathPrefixBytes() {
      java.lang.Object ref = reportPathPrefix_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        reportPathPrefix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Prefix of the object name of each report's shard. This will have full
     * prefix except the "extension" and "shard_id".
     * For example, if the `destination_path` is
     * `{{report-config-id}}/dt={{datetime}}`, the shard object name would be
     * `gs://my-insights/1A34-F2E456-12B456-1C3D/dt=2022-05-20T06:35/1A34-F2E456-12B456-1C3D_2022-05-20T06:35_5.csv`
     * and the value of `report_path_prefix` field would be
     * `gs://my-insights/1A34-F2E456-12B456-1C3D/dt=2022-05-20T06:35/1A34-F2E456-12B456-1C3D_2022-05-20T06:35_`.
     * </pre>
     *
     * <code>string report_path_prefix = 8;</code>
     *
     * @param value The reportPathPrefix to set.
     * @return This builder for chaining.
     */
    public Builder setReportPathPrefix(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      reportPathPrefix_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Prefix of the object name of each report's shard. This will have full
     * prefix except the "extension" and "shard_id".
     * For example, if the `destination_path` is
     * `{{report-config-id}}/dt={{datetime}}`, the shard object name would be
     * `gs://my-insights/1A34-F2E456-12B456-1C3D/dt=2022-05-20T06:35/1A34-F2E456-12B456-1C3D_2022-05-20T06:35_5.csv`
     * and the value of `report_path_prefix` field would be
     * `gs://my-insights/1A34-F2E456-12B456-1C3D/dt=2022-05-20T06:35/1A34-F2E456-12B456-1C3D_2022-05-20T06:35_`.
     * </pre>
     *
     * <code>string report_path_prefix = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReportPathPrefix() {
      reportPathPrefix_ = getDefaultInstance().getReportPathPrefix();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Prefix of the object name of each report's shard. This will have full
     * prefix except the "extension" and "shard_id".
     * For example, if the `destination_path` is
     * `{{report-config-id}}/dt={{datetime}}`, the shard object name would be
     * `gs://my-insights/1A34-F2E456-12B456-1C3D/dt=2022-05-20T06:35/1A34-F2E456-12B456-1C3D_2022-05-20T06:35_5.csv`
     * and the value of `report_path_prefix` field would be
     * `gs://my-insights/1A34-F2E456-12B456-1C3D/dt=2022-05-20T06:35/1A34-F2E456-12B456-1C3D_2022-05-20T06:35_`.
     * </pre>
     *
     * <code>string report_path_prefix = 8;</code>
     *
     * @param value The bytes for reportPathPrefix to set.
     * @return This builder for chaining.
     */
    public Builder setReportPathPrefixBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      reportPathPrefix_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private long shardsCount_;
    /**
     *
     *
     * <pre>
     * Total shards generated for the report.
     * </pre>
     *
     * <code>int64 shards_count = 9;</code>
     *
     * @return The shardsCount.
     */
    @java.lang.Override
    public long getShardsCount() {
      return shardsCount_;
    }
    /**
     *
     *
     * <pre>
     * Total shards generated for the report.
     * </pre>
     *
     * <code>int64 shards_count = 9;</code>
     *
     * @param value The shardsCount to set.
     * @return This builder for chaining.
     */
    public Builder setShardsCount(long value) {

      shardsCount_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Total shards generated for the report.
     * </pre>
     *
     * <code>int64 shards_count = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearShardsCount() {
      bitField0_ = (bitField0_ & ~0x00000008);
      shardsCount_ = 0L;
      onChanged();
      return this;
    }

    private com.google.rpc.Status status_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        statusBuilder_;
    /**
     *
     *
     * <pre>
     * Status of the ReportDetail.
     * </pre>
     *
     * <code>.google.rpc.Status status = 4;</code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Status of the ReportDetail.
     * </pre>
     *
     * <code>.google.rpc.Status status = 4;</code>
     *
     * @return The status.
     */
    public com.google.rpc.Status getStatus() {
      if (statusBuilder_ == null) {
        return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
      } else {
        return statusBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Status of the ReportDetail.
     * </pre>
     *
     * <code>.google.rpc.Status status = 4;</code>
     */
    public Builder setStatus(com.google.rpc.Status value) {
      if (statusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        status_ = value;
      } else {
        statusBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Status of the ReportDetail.
     * </pre>
     *
     * <code>.google.rpc.Status status = 4;</code>
     */
    public Builder setStatus(com.google.rpc.Status.Builder builderForValue) {
      if (statusBuilder_ == null) {
        status_ = builderForValue.build();
      } else {
        statusBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Status of the ReportDetail.
     * </pre>
     *
     * <code>.google.rpc.Status status = 4;</code>
     */
    public Builder mergeStatus(com.google.rpc.Status value) {
      if (statusBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && status_ != null
            && status_ != com.google.rpc.Status.getDefaultInstance()) {
          getStatusBuilder().mergeFrom(value);
        } else {
          status_ = value;
        }
      } else {
        statusBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Status of the ReportDetail.
     * </pre>
     *
     * <code>.google.rpc.Status status = 4;</code>
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00000010);
      status_ = null;
      if (statusBuilder_ != null) {
        statusBuilder_.dispose();
        statusBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Status of the ReportDetail.
     * </pre>
     *
     * <code>.google.rpc.Status status = 4;</code>
     */
    public com.google.rpc.Status.Builder getStatusBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getStatusFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Status of the ReportDetail.
     * </pre>
     *
     * <code>.google.rpc.Status status = 4;</code>
     */
    public com.google.rpc.StatusOrBuilder getStatusOrBuilder() {
      if (statusBuilder_ != null) {
        return statusBuilder_.getMessageOrBuilder();
      } else {
        return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
      }
    }
    /**
     *
     *
     * <pre>
     * Status of the ReportDetail.
     * </pre>
     *
     * <code>.google.rpc.Status status = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getStatusFieldBuilder() {
      if (statusBuilder_ == null) {
        statusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getStatus(), getParentForChildren(), isClean());
        status_ = null;
      }
      return statusBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000020);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000020;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000020;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000020;
      return this;
    }

    private com.google.type.DateTime targetDatetime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.DateTime,
            com.google.type.DateTime.Builder,
            com.google.type.DateTimeOrBuilder>
        targetDatetimeBuilder_;
    /**
     *
     *
     * <pre>
     * The date for which report is generated. The time part of target_datetime
     * will be zero till we support multiple reports per day.
     * </pre>
     *
     * <code>.google.type.DateTime target_datetime = 6;</code>
     *
     * @return Whether the targetDatetime field is set.
     */
    public boolean hasTargetDatetime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * The date for which report is generated. The time part of target_datetime
     * will be zero till we support multiple reports per day.
     * </pre>
     *
     * <code>.google.type.DateTime target_datetime = 6;</code>
     *
     * @return The targetDatetime.
     */
    public com.google.type.DateTime getTargetDatetime() {
      if (targetDatetimeBuilder_ == null) {
        return targetDatetime_ == null
            ? com.google.type.DateTime.getDefaultInstance()
            : targetDatetime_;
      } else {
        return targetDatetimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The date for which report is generated. The time part of target_datetime
     * will be zero till we support multiple reports per day.
     * </pre>
     *
     * <code>.google.type.DateTime target_datetime = 6;</code>
     */
    public Builder setTargetDatetime(com.google.type.DateTime value) {
      if (targetDatetimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        targetDatetime_ = value;
      } else {
        targetDatetimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The date for which report is generated. The time part of target_datetime
     * will be zero till we support multiple reports per day.
     * </pre>
     *
     * <code>.google.type.DateTime target_datetime = 6;</code>
     */
    public Builder setTargetDatetime(com.google.type.DateTime.Builder builderForValue) {
      if (targetDatetimeBuilder_ == null) {
        targetDatetime_ = builderForValue.build();
      } else {
        targetDatetimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The date for which report is generated. The time part of target_datetime
     * will be zero till we support multiple reports per day.
     * </pre>
     *
     * <code>.google.type.DateTime target_datetime = 6;</code>
     */
    public Builder mergeTargetDatetime(com.google.type.DateTime value) {
      if (targetDatetimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && targetDatetime_ != null
            && targetDatetime_ != com.google.type.DateTime.getDefaultInstance()) {
          getTargetDatetimeBuilder().mergeFrom(value);
        } else {
          targetDatetime_ = value;
        }
      } else {
        targetDatetimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The date for which report is generated. The time part of target_datetime
     * will be zero till we support multiple reports per day.
     * </pre>
     *
     * <code>.google.type.DateTime target_datetime = 6;</code>
     */
    public Builder clearTargetDatetime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      targetDatetime_ = null;
      if (targetDatetimeBuilder_ != null) {
        targetDatetimeBuilder_.dispose();
        targetDatetimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The date for which report is generated. The time part of target_datetime
     * will be zero till we support multiple reports per day.
     * </pre>
     *
     * <code>.google.type.DateTime target_datetime = 6;</code>
     */
    public com.google.type.DateTime.Builder getTargetDatetimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getTargetDatetimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The date for which report is generated. The time part of target_datetime
     * will be zero till we support multiple reports per day.
     * </pre>
     *
     * <code>.google.type.DateTime target_datetime = 6;</code>
     */
    public com.google.type.DateTimeOrBuilder getTargetDatetimeOrBuilder() {
      if (targetDatetimeBuilder_ != null) {
        return targetDatetimeBuilder_.getMessageOrBuilder();
      } else {
        return targetDatetime_ == null
            ? com.google.type.DateTime.getDefaultInstance()
            : targetDatetime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The date for which report is generated. The time part of target_datetime
     * will be zero till we support multiple reports per day.
     * </pre>
     *
     * <code>.google.type.DateTime target_datetime = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.DateTime,
            com.google.type.DateTime.Builder,
            com.google.type.DateTimeOrBuilder>
        getTargetDatetimeFieldBuilder() {
      if (targetDatetimeBuilder_ == null) {
        targetDatetimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.DateTime,
                com.google.type.DateTime.Builder,
                com.google.type.DateTimeOrBuilder>(
                getTargetDatetime(), getParentForChildren(), isClean());
        targetDatetime_ = null;
      }
      return targetDatetimeBuilder_;
    }

    private com.google.cloud.storageinsights.v1.ReportDetail.Metrics reportMetrics_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.storageinsights.v1.ReportDetail.Metrics,
            com.google.cloud.storageinsights.v1.ReportDetail.Metrics.Builder,
            com.google.cloud.storageinsights.v1.ReportDetail.MetricsOrBuilder>
        reportMetricsBuilder_;
    /**
     *
     *
     * <pre>
     * Metrics of the report.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.ReportDetail.Metrics report_metrics = 7;</code>
     *
     * @return Whether the reportMetrics field is set.
     */
    public boolean hasReportMetrics() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Metrics of the report.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.ReportDetail.Metrics report_metrics = 7;</code>
     *
     * @return The reportMetrics.
     */
    public com.google.cloud.storageinsights.v1.ReportDetail.Metrics getReportMetrics() {
      if (reportMetricsBuilder_ == null) {
        return reportMetrics_ == null
            ? com.google.cloud.storageinsights.v1.ReportDetail.Metrics.getDefaultInstance()
            : reportMetrics_;
      } else {
        return reportMetricsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Metrics of the report.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.ReportDetail.Metrics report_metrics = 7;</code>
     */
    public Builder setReportMetrics(
        com.google.cloud.storageinsights.v1.ReportDetail.Metrics value) {
      if (reportMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        reportMetrics_ = value;
      } else {
        reportMetricsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics of the report.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.ReportDetail.Metrics report_metrics = 7;</code>
     */
    public Builder setReportMetrics(
        com.google.cloud.storageinsights.v1.ReportDetail.Metrics.Builder builderForValue) {
      if (reportMetricsBuilder_ == null) {
        reportMetrics_ = builderForValue.build();
      } else {
        reportMetricsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics of the report.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.ReportDetail.Metrics report_metrics = 7;</code>
     */
    public Builder mergeReportMetrics(
        com.google.cloud.storageinsights.v1.ReportDetail.Metrics value) {
      if (reportMetricsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && reportMetrics_ != null
            && reportMetrics_
                != com.google.cloud.storageinsights.v1.ReportDetail.Metrics.getDefaultInstance()) {
          getReportMetricsBuilder().mergeFrom(value);
        } else {
          reportMetrics_ = value;
        }
      } else {
        reportMetricsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics of the report.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.ReportDetail.Metrics report_metrics = 7;</code>
     */
    public Builder clearReportMetrics() {
      bitField0_ = (bitField0_ & ~0x00000080);
      reportMetrics_ = null;
      if (reportMetricsBuilder_ != null) {
        reportMetricsBuilder_.dispose();
        reportMetricsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics of the report.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.ReportDetail.Metrics report_metrics = 7;</code>
     */
    public com.google.cloud.storageinsights.v1.ReportDetail.Metrics.Builder
        getReportMetricsBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getReportMetricsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metrics of the report.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.ReportDetail.Metrics report_metrics = 7;</code>
     */
    public com.google.cloud.storageinsights.v1.ReportDetail.MetricsOrBuilder
        getReportMetricsOrBuilder() {
      if (reportMetricsBuilder_ != null) {
        return reportMetricsBuilder_.getMessageOrBuilder();
      } else {
        return reportMetrics_ == null
            ? com.google.cloud.storageinsights.v1.ReportDetail.Metrics.getDefaultInstance()
            : reportMetrics_;
      }
    }
    /**
     *
     *
     * <pre>
     * Metrics of the report.
     * </pre>
     *
     * <code>.google.cloud.storageinsights.v1.ReportDetail.Metrics report_metrics = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.storageinsights.v1.ReportDetail.Metrics,
            com.google.cloud.storageinsights.v1.ReportDetail.Metrics.Builder,
            com.google.cloud.storageinsights.v1.ReportDetail.MetricsOrBuilder>
        getReportMetricsFieldBuilder() {
      if (reportMetricsBuilder_ == null) {
        reportMetricsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.storageinsights.v1.ReportDetail.Metrics,
                com.google.cloud.storageinsights.v1.ReportDetail.Metrics.Builder,
                com.google.cloud.storageinsights.v1.ReportDetail.MetricsOrBuilder>(
                getReportMetrics(), getParentForChildren(), isClean());
        reportMetrics_ = null;
      }
      return reportMetricsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.storageinsights.v1.ReportDetail)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.storageinsights.v1.ReportDetail)
  private static final com.google.cloud.storageinsights.v1.ReportDetail DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.storageinsights.v1.ReportDetail();
  }

  public static com.google.cloud.storageinsights.v1.ReportDetail getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReportDetail> PARSER =
      new com.google.protobuf.AbstractParser<ReportDetail>() {
        @java.lang.Override
        public ReportDetail parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ReportDetail> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReportDetail> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.storageinsights.v1.ReportDetail getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
