/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storageinsights.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ReportDetailName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_REPORT_CONFIG_REPORT_DETAIL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/reportConfigs/{report_config}/reportDetails/{report_detail}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String reportConfig;
    private final String reportDetail;

    @Deprecated
    protected ReportDetailName() {
        this.project = null;
        this.location = null;
        this.reportConfig = null;
        this.reportDetail = null;
    }

    private ReportDetailName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.reportConfig = (String)Preconditions.checkNotNull((Object)builder.getReportConfig());
        this.reportDetail = (String)Preconditions.checkNotNull((Object)builder.getReportDetail());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getReportConfig() {
        return this.reportConfig;
    }

    public String getReportDetail() {
        return this.reportDetail;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ReportDetailName of(String project, String location, String reportConfig, String reportDetail) {
        return ReportDetailName.newBuilder().setProject(project).setLocation(location).setReportConfig(reportConfig).setReportDetail(reportDetail).build();
    }

    public static String format(String project, String location, String reportConfig, String reportDetail) {
        return ReportDetailName.newBuilder().setProject(project).setLocation(location).setReportConfig(reportConfig).setReportDetail(reportDetail).build().toString();
    }

    public static ReportDetailName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_REPORT_CONFIG_REPORT_DETAIL.validatedMatch(formattedString, "ReportDetailName.parse: formattedString not in valid format");
        return ReportDetailName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("report_config"), (String)matchMap.get("report_detail"));
    }

    public static List<ReportDetailName> parseList(List<String> formattedStrings) {
        ArrayList<ReportDetailName> list = new ArrayList<ReportDetailName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ReportDetailName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ReportDetailName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ReportDetailName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_REPORT_CONFIG_REPORT_DETAIL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ReportDetailName reportDetailName = this;
            synchronized (reportDetailName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.reportConfig != null) {
                        fieldMapBuilder.put((Object)"report_config", (Object)this.reportConfig);
                    }
                    if (this.reportDetail != null) {
                        fieldMapBuilder.put((Object)"report_detail", (Object)this.reportDetail);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_REPORT_CONFIG_REPORT_DETAIL.instantiate(new String[]{"project", this.project, "location", this.location, "report_config", this.reportConfig, "report_detail", this.reportDetail});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ReportDetailName that = (ReportDetailName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.reportConfig, that.reportConfig) && Objects.equals(this.reportDetail, that.reportDetail);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.reportConfig);
        h *= 1000003;
        return h ^= Objects.hashCode(this.reportDetail);
    }

    public static class Builder {
        private String project;
        private String location;
        private String reportConfig;
        private String reportDetail;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getReportConfig() {
            return this.reportConfig;
        }

        public String getReportDetail() {
            return this.reportDetail;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setReportConfig(String reportConfig) {
            this.reportConfig = reportConfig;
            return this;
        }

        public Builder setReportDetail(String reportDetail) {
            this.reportDetail = reportDetail;
            return this;
        }

        private Builder(ReportDetailName reportDetailName) {
            this.project = reportDetailName.project;
            this.location = reportDetailName.location;
            this.reportConfig = reportDetailName.reportConfig;
            this.reportDetail = reportDetailName.reportDetail;
        }

        public ReportDetailName build() {
            return new ReportDetailName(this);
        }
    }
}

